rscpTags = {
    # imported from https://s10.e3dc.com/s10/js/rscpLibV0.9.2.min.js
    0xF800A001: "SERVER_REGISTER_CONNECTION",
    0xF800B001: "SERVER_CONNECTION_ID",
    0xF800B002: "SERVER_AUTH_LEVEL",
    0xF800B003: "SERVER_STATUS",
    0xF800B006: "SERVER_TYPE",
    0xF800B007: "SERVER_HASH_CODE",
    0xF808A001: "SERVER_CONNECTION_REGISTERED",
    0xF800A002: "SERVER_UNREGISTER_CONNECTION",
    0xF808A002: "SERVER_CONNECTION_UNREGISTERED",
    0xF808A004: "SERVER_PING",
    0xF800A004: "SERVER_REQ_PING",
    0xF800B004: "SERVER_RSCP_DATA_LEN",
    0xF800B005: "SERVER_RSCP_DATA",
    0xF800A003: "SERVER_REQ_RSCP_CMD",
    0xF808A003: "SERVER_RSCP_CMD_RESP",
    0xF800A005: "SERVER_REQ_NEW_VIRTUAL_CONNECTION",
    0xF800B008: "SERVER_USER",
    0xF800B009: "SERVER_PASSWD",
    0xF800B010: "SERVER_IDENTIFIER",
    0xFC000001: "GROUP_CTRL_REQ_STATUS",
    0xFC800001: "GROUP_CTRL_STATUS",
    0xFC000002: "GROUP_CTRL_GROUP_ID",
    0xFC000003: "GROUP_CTRL_READY",
    0xFC000004: "GROUP_CTRL_P_OPERATION_POINT",
    0xFC000005: "GROUP_CTRL_P_ACTUAL",
    0xFC000006: "GROUP_CTRL_FORECAST_60MINUTES",
    0xFC000007: "GROUP_CTRL_REQ_CONTROL",
    0xFC800007: "GROUP_CTRL_CONTROL",
    0xFC000008: "GROUP_CTRL_P_TARGET",
    0xFC000009: "GROUP_CTRL_ACTIVE",
    0xFC00000A: "GROUP_CTRL_AWARD",
    0x00000001: "RSCP_REQ_AUTHENTICATION",
    0x00000002: "RSCP_AUTHENTICATION_USER",
    0x00000003: "RSCP_AUTHENTICATION_PASSWORD",
    0x00800001: "RSCP_AUTHENTICATION",
    0x00000004: "RSCP_REQ_USER_LEVEL",
    0x00800004: "RSCP_USER_LEVEL",
    0x00000005: "RSCP_REQ_SET_ENCRYPTION_PASSPHRASE",
    0x00800005: "RSCP_SET_ENCRYPTION_PASSPHRASE",
    0x00000006: "RSCP_REQ_AUTH_CHALLENGE",
    0x00800006: "RSCP_AUTH_CHALLENGE",
    0x00000007: "RSCP_AUTH_CHALLENGE_INDEX",
    0x00000008: "RSCP_AUTH_CHALLENGE_DATA",
    0x00000009: "RSCP_REQ_SET_PROTOCOL_VERSION",
    0x00800009: "RSCP_SET_PROTOCOL_VERSION",
    0x0000000A: "RSCP_REQ_SUPPORTED_PROTOCOL_VERSIONS",
    0x0080000A: "RSCP_SUPPORTED_PROTOCOL_VERSIONS",
    0x00FFFFFF: "RSCP_GENERAL_ERROR",
    0x01000001: "EMS_REQ_POWER_PV",
    0x01000002: "EMS_REQ_POWER_BAT",
    0x01000003: "EMS_REQ_POWER_HOME",
    0x01000004: "EMS_REQ_POWER_GRID",
    0x01000005: "EMS_REQ_POWER_ADD",
    0x01000006: "EMS_REQ_AUTARKY",
    0x01000007: "EMS_REQ_SELF_CONSUMPTION",
    0x01000008: "EMS_REQ_BAT_SOC",
    0x01000009: "EMS_REQ_COUPLING_MODE",
    0x0100000A: "EMS_REQ_STORED_ERRORS",
    0x01000011: "EMS_REQ_MODE",
    0x01000012: "EMS_REQ_BALANCED_PHASES",
    0x01000013: "EMS_REQ_INSTALLED_PEAK_POWER",
    0x01000014: "EMS_REQ_DERATE_AT_PERCENT_VALUE",
    0x01000015: "EMS_REQ_DERATE_AT_POWER_VALUE",
    0x01000016: "EMS_REQ_ERROR_BUZZER_ENABLED",
    0x01000017: "EMS_REQ_SET_BALANCED_PHASES",
    0x01000018: "EMS_REQ_SET_INSTALLED_PEAK_POWER",
    0x01000019: "EMS_REQ_SET_DERATE_PERCENT",
    0x0100001A: "EMS_REQ_SET_ERROR_BUZZER_ENABLED",
    0x0100001B: "EMS_REQ_START_ADJUST_BATTERY_VOLTAGE",
    0x0100001C: "EMS_REQ_CANCEL_ADJUST_BATTERY_VOLTAGE",
    0x0100001D: "EMS_REQ_ADJUST_BATTERY_VOLTAGE_STATUS",
    0x0100001E: "EMS_REQ_CONFIRM_ERRORS",
    0x0100001F: "EMS_REQ_POWER_WB_ALL",
    0x01000020: "EMS_REQ_POWER_WB_SOLAR",
    0x01000021: "EMS_REQ_EXT_SRC_AVAILABLE",
    0x01000022: "EMS_REQ_RESCUE_BAT_MODE",
    0x01000023: "EMS_REQ_SET_RESCUE_BAT_MODE",
    0x01800001: "EMS_POWER_PV",
    0x01800002: "EMS_POWER_BAT",
    0x01800003: "EMS_POWER_HOME",
    0x01800004: "EMS_POWER_GRID",
    0x01800005: "EMS_POWER_ADD",
    0x01800006: "EMS_AUTARKY",
    0x01800007: "EMS_SELF_CONSUMPTION",
    0x01800008: "EMS_BAT_SOC",
    0x01800009: "EMS_COUPLING_MODE",
    0x0180000A: "EMS_STORED_ERRORS",
    0x0180000B: "EMS_ERROR_CONTAINER",
    0x0180000C: "EMS_ERROR_TYPE",
    0x0180000D: "EMS_ERROR_SOURCE",
    0x0180000E: "EMS_ERROR_MESSAGE",
    0x0180000F: "EMS_ERROR_CODE",
    0x01800010: "EMS_ERROR_TIMESTAMP",
    0x01800011: "EMS_MODE",
    0x01800012: "EMS_BALANCED_PHASES",
    0x01800013: "EMS_INSTALLED_PEAK_POWER",
    0x01800014: "EMS_DERATE_AT_PERCENT_VALUE",
    0x01800015: "EMS_DERATE_AT_POWER_VALUE",
    0x01800016: "EMS_ERROR_BUZZER_ENABLED",
    0x01800017: "EMS_SET_BALANCED_PHASES",
    0x01800018: "EMS_SET_INSTALLED_PEAK_POWER",
    0x01800019: "EMS_SET_DERATE_PERCENT",
    0x0180001A: "EMS_SET_ERROR_BUZZER_ENABLED",
    0x0180001B: "EMS_START_ADJUST_BATTERY_VOLTAGE",
    0x0180001C: "EMS_CANCEL_ADJUST_BATTERY_VOLTAGE",
    0x0180001D: "EMS_ADJUST_BATTERY_VOLTAGE_STATUS",
    0x0180001E: "EMS_CONFIRM_ERRORS",
    0x0180001F: "EMS_POWER_WB_ALL",
    0x01800020: "EMS_POWER_WB_SOLAR",
    0x01800021: "EMS_EXT_SRC_AVAILABLE",
    0x01800022: "EMS_RESCUE_BAT_MODE",
    0x01000030: "EMS_REQ_SET_POWER",
    0x01000031: "EMS_REQ_SET_POWER_MODE",
    0x01000032: "EMS_REQ_SET_POWER_VALUE",
    0x01800030: "EMS_SET_POWER",
    0x01000040: "EMS_REQ_STATUS",
    0x01800040: "EMS_STATUS",
    0x01000041: "EMS_REQ_USED_CHARGE_LIMIT",
    0x01000042: "EMS_REQ_BAT_CHARGE_LIMIT",
    0x01000043: "EMS_REQ_DCDC_CHARGE_LIMIT",
    0x01000044: "EMS_REQ_USER_CHARGE_LIMIT",
    0x01000045: "EMS_REQ_USED_DISCHARGE_LIMIT",
    0x01000046: "EMS_REQ_BAT_DISCHARGE_LIMIT",
    0x01000047: "EMS_REQ_DCDC_DISCHARGE_LIMIT",
    0x01000048: "EMS_REQ_USER_DISCHARGE_LIMIT",
    0x01800041: "EMS_USED_CHARGE_LIMIT",
    0x01800042: "EMS_BAT_CHARGE_LIMIT",
    0x01800043: "EMS_DCDC_CHARGE_LIMIT",
    0x01800044: "EMS_USER_CHARGE_LIMIT",
    0x01800045: "EMS_USED_DISCHARGE_LIMIT",
    0x01800046: "EMS_BAT_DISCHARGE_LIMIT",
    0x01800047: "EMS_DCDC_DISCHARGE_LIMIT",
    0x01800048: "EMS_USER_DISCHARGE_LIMIT",
    0x01000060: "EMS_REQ_SET_POWER_CONTROL_OFFSET",
    0x01800060: "EMS_SET_POWER_CONTROL_OFFSET",
    0x01000071: "EMS_REQ_REMAINING_BAT_CHARGE_POWER",
    0x01800071: "EMS_REMAINING_BAT_CHARGE_POWER",
    0x01000072: "EMS_REQ_REMAINING_BAT_DISCHARGE_POWER",
    0x01800072: "EMS_REMAINING_BAT_DISCHARGE_POWER",
    0x01000073: "EMS_REQ_EMERGENCY_POWER_STATUS",
    0x01800073: "EMS_EMERGENCY_POWER_STATUS",
    0x01000074: "EMS_REQ_SET_EMERGENCY_POWER",
    0x01800074: "EMS_SET_EMERGENCY_POWER",
    0x01000075: "EMS_REQ_SET_OVERRIDE_AVAILABLE_POWER",
    0x01800075: "EMS_SET_OVERRIDE_AVAILABLE_POWER",
    0x01800076: "EMS_SET_BATTERY_TO_CAR_MODE",
    0x01000076: "EMS_REQ_SET_BATTERY_TO_CAR_MODE",
    0x01800077: "EMS_BATTERY_TO_CAR_MODE",
    0x01000077: "EMS_REQ_BATTERY_TO_CAR_MODE",
    0x01800078: "EMS_SET_BATTERY_BEFORE_CAR_MODE",
    0x01000078: "EMS_REQ_SET_BATTERY_BEFORE_CAR_MODE",
    0x01800079: "EMS_BATTERY_BEFORE_CAR_MODE",
    0x01000079: "EMS_REQ_BATTERY_BEFORE_CAR_MODE",
    0x01000080: "EMS_REQ_GET_IDLE_PERIODS",
    0x01800080: "EMS_GET_IDLE_PERIODS",
    0x01000081: "EMS_REQ_SET_IDLE_PERIODS",
    0x01800081: "EMS_SET_IDLE_PERIODS",
    0x01000082: "EMS_IDLE_PERIOD",
    0x01000083: "EMS_IDLE_PERIOD_TYPE",
    0x01000084: "EMS_IDLE_PERIOD_DAY",
    0x01000085: "EMS_IDLE_PERIOD_START",
    0x01000086: "EMS_IDLE_PERIOD_END",
    0x01000087: "EMS_IDLE_PERIOD_HOUR",
    0x01000088: "EMS_IDLE_PERIOD_MINUTE",
    0x01000089: "EMS_IDLE_PERIOD_ACTIVE",
    0x0100008A: "EMS_REQ_IDLE_PERIOD_CHANGE_MARKER",
    0x0180008A: "EMS_IDLE_PERIOD_CHANGE_MARKER",
    0x0100008B: "EMS_REQ_GET_POWER_SETTINGS",
    0x0180008B: "EMS_GET_POWER_SETTINGS",
    0x0100008C: "EMS_REQ_SET_POWER_SETTINGS",
    0x0180008C: "EMS_SET_POWER_SETTINGS",
    0x01000100: "EMS_POWER_LIMITS_USED",
    0x01800100: "EMS_RES_POWER_LIMITS_USED",
    0x01000101: "EMS_MAX_CHARGE_POWER",
    0x01800101: "EMS_RES_MAX_CHARGE_POWER",
    0x01000102: "EMS_MAX_DISCHARGE_POWER",
    0x01800102: "EMS_RES_MAX_DISCHARGE_POWER",
    0x01000103: "EMS_DISCHARGE_START_POWER",
    0x01800103: "EMS_RES_DISCHARGE_START_POWER",
    0x01000104: "EMS_POWERSAVE_ENABLED",
    0x01800104: "EMS_RES_POWERSAVE_ENABLED",
    0x01000105: "EMS_WEATHER_REGULATED_CHARGE_ENABLED",
    0x01800105: "EMS_RES_WEATHER_REGULATED_CHARGE_ENABLED",
    0x01000106: "EMS_WEATHER_FORECAST_MODE",
    0x01800106: "EMS_RES_WEATHER_FORECAST_MODE",
    0x0100008D: "EMS_REQ_SETTINGS_CHANGE_MARKER",
    0x0180008D: "EMS_SETTINGS_CHANGE_MARKER",
    0x0100008E: "EMS_REQ_GET_MANUAL_CHARGE",
    0x0180008E: "EMS_GET_MANUAL_CHARGE",
    0x01000150: "EMS_MANUAL_CHARGE_START_COUNTER",
    0x01000151: "EMS_MANUAL_CHARGE_ACTIVE",
    0x01000152: "EMS_MANUAL_CHARGE_ENERGY_COUNTER",
    0x01000153: "EMS_MANUAL_CHARGE_LASTSTART",
    0x0100008F: "EMS_REQ_START_MANUAL_CHARGE",
    0x0180008F: "EMS_START_MANUAL_CHARGE",
    0x01000090: "EMS_REQ_START_EMERGENCYPOWER_TEST",
    0x01800090: "EMS_START_EMERGENCYPOWER_TEST",
    0x01000091: "EMS_REQ_GET_GENERATOR_STATE",
    0x01800091: "EMS_GET_GENERATOR_STATE",
    0x01000092: "EMS_REQ_SET_GENERATOR_MODE",
    0x01800092: "EMS_SET_GENERATOR_MODE",
    0x01000093: "EMS_REQ_EMERGENCYPOWER_TEST_STATUS",
    0x01800093: "EMS_EMERGENCYPOWER_TEST_STATUS",
    0x01000094: "EMS_EPTEST_NEXT_TESTSTART",
    0x01000095: "EMS_EPTEST_START_COUNTER",
    0x01000096: "EMS_EPTEST_RUNNING",
    0x01000097: "EMS_REQ_GET_SYS_SPECS",
    0x01800098: "EMS_GET_SYS_SPECS",
    0x01000099: "EMS_SYS_SPEC",
    0x0100009A: "EMS_SYS_SPEC_INDEX",
    0x0100009B: "EMS_SYS_SPEC_NAME",
    0x0100009C: "EMS_SYS_SPEC_VALUE_INT",
    0x0100009D: "EMS_SYS_SPEC_VALUE_STRING",
    0x01000098: "EMS_REQ_SYS_STATUS",
    0x0100009E: "EMS_SYS_STATUS",
    0x01050000: "EMS_REQ_ALIVE",
    0x01850000: "EMS_ALIVE",
    0x01FFFFFF: "EMS_GENERAL_ERROR",
    0x01000200: "EMS_REQ_REMOTE_CONTROL ",
    0x01040001: "EMS_PARAM_DERATE_POWER_VALUE",
    0x01040002: "EMS_PARAM_AVAILABLE_POWER",
    0x01040004: "EMS_PARAM_IP_REMOTE_CONTROL",
    0x01040005: "EMS_PARAM_POWEROFFSET_VALUE",
    0x01040006: "EMS_PARAM_POWER_VALUE_L1",
    0x01040007: "EMS_PARAM_POWER_VALUE_L2",
    0x01040008: "EMS_PARAM_POWER_VALUE_L3",
    0x01040009: "EMS_PARAM_SET_POINT",
    0x01040010: "EMS_PARAM_DERATE_POWER_VALUE_L1",
    0x01040011: "EMS_PARAM_DERATE_POWER_VALUE_L2",
    0x01040012: "EMS_PARAM_DERATE_POWER_VALUE_L3",
    # 0x01040013: "EMS_PARAM_REGULATOR_MODE",
    0x01040013: "EMS_PARAM_REMOTE_CONTROL_ACTIVE",
    0x01040115: "EMS_PARAM_DEACTIVATE_SURPLUS_ACTOR",
    # 0x01040014: "EMS_PARAM_REGULATOR_STRATEGY",
    0x01040014: "EMS_PARAM_TIME_TO_RETRY",
    0x01040016: "EMS_PARAM_INDEX",
    0x01040017: "EMS_PARAM_WALLBOX_SETPOINT_L1",
    0x01040018: "EMS_PARAM_WALLBOX_SETPOINT_L2",
    0x01040019: "EMS_PARAM_WALLBOX_SETPOINT_L3",
    0x01800200: "EMS_REMOTE_CONTROL ",
    0x01000201: "EMS_REQ_DEACTIVATE_REMOTE_CONTROL",
    0x01800201: "EMS_DEACTIVATE_REMOTE_CONTROL",
    0x01000202: "EMS_REQ_IP_REMOTE_CONTROL",
    0x01800202: "EMS_IP_REMOTE_CONTROL",
    0x01000203: "EMS_REQ_EP_DELAY",
    0x01800203: "EMS_EP_DELAY",
    0x01000204: "EMS_REQ_SET_EP_DELAY",
    0x01800204: "EMS_SET_EP_DELAY",
    0x01000205: "EMS_REQ_REMOTE_CONTROL_STATUS",
    0x01800205: "EMS_REMOTE_CONTROL_STATUS",
    0x01000206: "EMS_REQ_IDLE_PERIOD_MIN_SOC_UCB",
    0x01000207: "EMS_REQ_IDLE_PERIOD_MAX_SOC_UCB",
    0x01800206: "EMS_IDLE_PERIOD_MIN_SOC_UCB",
    0x01800207: "EMS_IDLE_PERIOD_MAX_SOC_UCB",
    0x01000208: "EMS_REQ_SET_IDLE_PERIOD_MIN_SOC_UCB",
    0x01000209: "EMS_REQ_SET_IDLE_PERIOD_MAX_SOC_UCB",
    0x01800208: "EMS_SET_IDLE_PERIOD_MIN_SOC_UCB",
    0x01800209: "EMS_SET_IDLE_PERIOD_MAX_SOC_UCB",
    0x01000210: "EMS_REQ_REGULATOR_MODE",
    0x01800210: "EMS_REGULATOR_MODE",
    0x01000211: "EMS_REQ_SET_REGULATOR_MODE",
    0x01800211: "EMS_SET_REGULATOR_MODE",
    0x01000212: "EMS_REQ_SUPPORTED_REGULATOR_MODES",
    0x01800212: "EMS_SUPPORTED_REGULATOR_MODES",
    0x01000213: "EMS_REQ_EMERGENCY_POWER_OVERLOAD_STATUS",
    0x01800213: "EMS_EMERGENCY_POWER_OVERLOAD_STATUS",
    0x01000214: "EMS_REQ_EMERGENCY_POWER_RETRY",
    0x01800214: "EMS_EMERGENCY_POWER_RETRY",
    0x01040015: "EMS_PARAM_NO_REMAINING_RETRY",
    0x01000217: "EMS_REQ_DETECT_PHASE_OFFSET",
    0x01800217: "EMS_DETECT_PHASE_OFFSET",
    0x01000218: "EMS_REQ_PHASE_DETECTION_STATUS",
    0x01800218: "EMS_PHASE_DETECTION_STATUS",
    0x01000219: "EMS_REQ_PHASE_OFFSET",
    0x01800219: "EMS_PHASE_OFFSET",
    0x01000220: "EMS_REQ_ABORT_PHASE_DETECTION",
    0x01800220: "EMS_ABORT_PHASE_DETECTION",
    0x01000221: "EMS_REQ_REGULATOR_STRATEGY",
    0x01800221: "EMS_REGULATOR_STRATEGY",
    0x01000222: "EMS_REQ_SET_REGULATOR_STRATEGY",
    0x01800222: "EMS_SET_REGULATOR_STRATEGY",
    0x01000223: "EMS_REQ_POWER_PV_AC_OUT",
    0x01800223: "EMS_POWER_PV_AC_OUT",
    0x01000224: "EMS_REQ_PV_ENERGY",
    0x01800224: "EMS_PV_ENERGY",
    0x01800225: "EMS_PARAM_AC_ENERGY_OUT",
    0x01800226: "EMS_PARAM_AC_ENERGY_IN",
    0x01800227: "EMS_PARAM_DC_IN",
    0x01000228: "EMS_REQ_ENERGY_STORAGE_MODEL",
    0x01800228: "EMS_ENERGY_STORAGE_MODEL",
    0x01800229: "EMS_PARAM_CURR_CHARGED_ENERGY",
    0x01800230: "EMS_PARAM_FULL_CHARGED_ENERGY_EP_RESERVE",
    0x01800231: "EMS_PARAM_DESIGN_ENERGY",
    0x01800232: "EMS_PARAM_FULL_CHARGED_ENERGY",
    0x01800233: "EMS_PARAM_USED_CAPACITY",
    0x01000234: "EMS_REQ_SPECIFICATION_VALUES",
    0x01800234: "EMS_SPECIFICATION_VALUES",
    0x01800235: "EMS_PARAM_MAX_CHARGE_POWER",
    0x01800236: "EMS_PARAM_MAX_DISCHARGE_POWER",
    0x01800237: "EMS_PARAM_MAX_PV_POWER",
    0x01800238: "EMS_PARAM_MAX_AC_POWER",
    0x01800239: "EMS_PARAM_INSTALLED_BAT_CAP",
    0x01800240: "EMS_PARAM_HYBRIT_SUPPORTED",
    0x01800241: "EMS_PARAM_INIT_STATUS",
    0x01000242: "EMS_REQ_EP_RESERVE",
    0x01800242: "EMS_EP_RESERVE",
    0x01000243: "EMS_REQ_SEC_LIMITS",
    0x01800243: "EMS_SEC_LIMITS",
    0x01800244: "EMS_PARAM_SEL_TOTAL_MAX",
    0x01800245: "EMS_PARAM_SEL_TOTAL_MIN",
    0x01800246: "EMS_PARAM_SEL_PHASE_MAX_L1",
    0x01800247: "EMS_PARAM_SEL_PHASE_MAX_L2",
    0x01800248: "EMS_PARAM_SEL_PHASE_MAX_L3",
    0x01800249: "EMS_PARAM_SEL_PHASE_MIN_L1",
    0x01800250: "EMS_PARAM_SEL_PHASE_MIN_L2",
    0x01800251: "EMS_PARAM_SEL_PHASE_MIN_L3",
    0x01000252: "EMS_REQ_SEC_DEVICE_STATUS",
    0x01800252: "EMS_SEC_DEVICE_STATUS",
    0x01800253: "EMS_PARAM_PVI_1",
    0x01800254: "EMS_PARAM_PVI_2",
    0x01800255: "EMS_PARAM_PVI_3",
    0x01800256: "EMS_PARAM_DCDC",
    0x01800257: "EMS_PARAM_BAT",
    0x01000258: "EMS_REQ_BAT_CURRENT_IN",
    0x01000259: "EMS_REQ_BAT_CURRENT_OUT",
    0x01800258: "EMS_BAT_CURRENT_IN",
    0x01800259: "EMS_BAT_CURRENT_OUT",
    0x01000260: "EMS_REQ_MAX_DC_POWER",
    0x01800260: "EMS_MAX_DC_POWER",
    0x01000261: "EMS_REQ_AC_REACTIVE_POWER",
    0x01800261: "EMS_AC_REACTIVE_POWER",
    0x01000262: "EMS_REQ_SET_EP_PARTIAL_GRID",
    0x01000263: "EMS_REQ_GET_PARTIAL_GRID",
    0x01800263: "EMS_GET_PARTIAL_GRID",
    0x01000264: "EMS_REQ_ESTIMATED_POWER_LIMITS",
    0x01800264: "EMS_ESTIMATED_POWER_LIMITS",
    0x01000265: "EMS_REQ_DESIGN_POWER_LIMITS",
    0x01800265: "EMS_DESIGN_POWER_LIMITS",
    0x01400265: "EMS_PARAM_LIMITS_TOTAL_MAX",
    0x01400266: "EMS_PARAM_LIMITS_TOTAL_MIN",
    0x01400267: "EMS_PARAM_LIMITS_PHASE_MAX_L1",
    0x01400268: "EMS_PARAM_LIMITS_PHASE_MAX_L2",
    0x01400269: "EMS_PARAM_LIMITS_PHASE_MAX_L3",
    0x01400270: "EMS_PARAM_LIMITS_PHASE_MIN_L1",
    0x01400271: "EMS_PARAM_LIMITS_PHASE_MIN_L2",
    0x01400272: "EMS_PARAM_LIMITS_PHASE_MIN_L3",
    0x01000266: "EMS_REQ_SET_CAN_ID_FEED_IN_REDUCTION",
    0x01800266: "EMS_SET_CAN_ID_FEED_IN_REDUCTION",
    0x01000267: "EMS_REQ_CAN_ID_FEED_IN_REDUCTION",
    0x01800267: "EMS_CAN_ID_FEED_IN_REDUCTION",
    0x01000268: "EMS_REQ_SET_CAN_ID_UNBALANCED_LOAD",
    0x01800268: "EMS_SET_CAN_ID_UNBALANCED_LOAD",
    0x01000269: "EMS_REQ_CAN_ID_UNBALANCED_LOAD",
    0x01800269: "EMS_CAN_ID_UNBALANCED_LOAD",
    0x01000270: "EMS_REQ_SET_WALLBOX_MODE",
    0x01800270: "EMS_SET_WALLBOX_MODE",
    0x01000271: "EMS_REQ_GET_WALLBOX_MODE",
    0x01800271: "EMS_GET_WALLBOX_MODE",
    0x01000272: "EMS_REQ_SET_MAX_FUSE_POWER",
    0x01800272: "EMS_SET_MAX_FUSE_POWER",
    0x01000273: "EMS_REQ_GET_MAX_FUSE_POWER",
    0x01800273: "EMS_GET_MAX_FUSE_POWER",
    0x01000274: "EMS_REQ_SET_CONNECTED_POWER",
    0x01800274: "EMS_SET_CONNECTED_POWER",
    0x01000275: "EMS_REQ_GET_CONNECTED_POWER ",
    0x01800275: "EMS_GET_CONNECTED_POWER",
    0x01000276: "EMS_REQ_DERATE_AT_CONNECTED_POWER",
    0x01800276: "EMS_DERATE_AT_CONNECTED_POWER",
    0x01000277: "EMS_REQ_SET_DERATE_AT_CONNECTED_POWER",
    0x01800277: "EMS_SET_DERATE_AT_CONNECTED_POWER",
    0x01400278: "EMS_PARAM_CURR_CHARGED_ENERGY_EP_RESERVE",
    0x01000280: "EMS_REQ_WB_AVAILABLE",
    0x01800280: "EMS_WB_AVAILABLE",
    0x01000281: "EMS_REQ_WB_PREFERRED_CHARGE_POWER",
    0x01800281: "EMS_WB_PREFERRED_CHARGE_POWER",
    0x01000282: "EMS_REQ_SET_PEAK_SHAVING_POWER",
    0x01800282: "EMS_SET_PEAK_SHAVING_POWER",
    0x01800283: "EMS_GET_PEAK_SHAVING_POWER",
    0x01000283: "EMS_REQ_GET_PEAK_SHAVING_POWER",
    0x01000284: "EMS_REQ_GET_RUNSCREENVALUES",
    0x01800284: "EMS_GET_RUNSCREENVALUES",
    0x01000286: "EMS_REQ_SET_PEAK_SHAVING_TIMES",
    0x01800286: "EMS_SET_PEAK_SHAVING_TIMES",
    0x01000287: "EMS_REQ_GET_PEAK_SHAVING_TIMES",
    0x01800287: "EMS_GET_PEAK_SHAVING_TIMES",
    0x01000288: "EMS_REQ_SET_LIST_ACTOR",
    0x01800288: "EMS_SET_LIST_ACTOR",
    0x01000289: "EMS_REQ_GET_LIST_ACTOR",
    0x01800289: "EMS_GET_LIST_ACTOR",
    0x01800290: "EMS_ACTOR_ITEM",
    0x01800291: "EMS_ACTOR_ID",
    0x01800292: "EMS_ACTOR_NAME",
    0x01800293: "EMS_ACTOR_PRIORITY",
    0x01800300: "EMS_PERIOD_ITEM",
    0x01800301: "EMS_PERIOD_ACTIVE",
    0x01800302: "EMS_PERIOD_NAME",
    0x01800303: "EMS_PERIOD_WEEKDAYS",
    0x01800304: "EMS_PERIOD_START",
    0x01800305: "EMS_PERIOD_STOP",
    0x01800306: "EMS_PERIOD_POWER",
    0x03040000: "BAT_REQ_DATA",
    0x03040001: "BAT_INDEX",
    0x03840000: "BAT_DATA",
    0x03800001: "BAT_RSOC",
    0x03800002: "BAT_MODULE_VOLTAGE",
    0x03800003: "BAT_CURRENT",
    0x03800004: "BAT_MAX_BAT_VOLTAGE",
    0x03800005: "BAT_MAX_CHARGE_CURRENT",
    0x03800006: "BAT_EOD_VOLTAGE",
    0x03800007: "BAT_MAX_DISCHARGE_CURRENT",
    0x03800008: "BAT_CHARGE_CYCLES",
    0x03800009: "BAT_TERMINAL_VOLTAGE",
    0x0380000A: "BAT_STATUS_CODE",
    0x0380000B: "BAT_ERROR_CODE",
    0x0380000C: "BAT_DEVICE_NAME",
    0x0380000D: "BAT_DCB_COUNT",
    0x0380000E: "BAT_RSOC_REAL",
    0x0380000F: "BAT_ASOC",
    0x03800010: "BAT_FCC",
    0x03800011: "BAT_RC",
    0x03800012: "BAT_MAX_DCB_CELL_CURRENT",
    0x03800013: "BAT_MIN_DCB_CELL_CURRENT",
    0x03800014: "BAT_MAX_DCB_CELL_VOLTAGE",
    0x03800015: "BAT_MIN_DCB_CELL_VOLTAGE",
    0x03800016: "BAT_MAX_DCB_CELL_TEMPERATURE",
    0x03800017: "BAT_MIN_DCB_CELL_TEMPERATURE",
    0x03800018: "BAT_DCB_ALL_CELL_TEMPERATURES",
    0x03800019: "BAT_DCB_CELL_TEMPERATURE",
    0x0380001A: "BAT_DCB_ALL_CELL_VOLTAGES",
    0x0380001B: "BAT_DCB_CELL_VOLTAGE",
    0x0380001C: "BAT_OPEN_BREAKER",
    0x0380001D: "BAT_OPEN_BREAKER_CONFIRM",
    0x0380001E: "BAT_READY_FOR_SHUTDOWN",
    0x0380001F: "BAT_FIRMWARE_VERSION",
    0x03800024: "BAT_TIME_LAST_RESPONSE",
    0x03800025: "BAT_MANUFACTURER_NAME",
    0x03800026: "BAT_USABLE_CAPACITY",
    0x03800027: "BAT_USABLE_REMAINING_CAPACITY",
    0x03800020: "BAT_INFO",
    0x03800021: "BAT_TRAINING_MODE",
    0x03800022: "BAT_UPDATE_STATUS",
    0x03800028: "BAT_SET_A1_DATA",
    0x03800032: "BAT_CONTROL_CODE",
    0x03800033: "BAT_BPM_STATUS",
    0x03800034: "BAT_DCB_ERROR_LIST",
    0x03000001: "BAT_REQ_RSOC",
    0x03000002: "BAT_REQ_MODULE_VOLTAGE",
    0x03000003: "BAT_REQ_CURRENT",
    0x03000004: "BAT_REQ_MAX_BAT_VOLTAGE",
    0x03000005: "BAT_REQ_MAX_CHARGE_CURRENT",
    0x03000006: "BAT_REQ_EOD_VOLTAGE",
    0x03000007: "BAT_REQ_MAX_DISCHARGE_CURRENT",
    0x03000008: "BAT_REQ_CHARGE_CYCLES",
    0x03000009: "BAT_REQ_TERMINAL_VOLTAGE",
    0x0300000A: "BAT_REQ_STATUS_CODE",
    0x0300000B: "BAT_REQ_ERROR_CODE",
    0x0300000C: "BAT_REQ_DEVICE_NAME",
    0x0300000D: "BAT_REQ_DCB_COUNT",
    0x0300000E: "BAT_REQ_RSOC_REAL",
    0x0300000F: "BAT_REQ_ASOC",
    0x03000010: "BAT_REQ_FCC",
    0x03000011: "BAT_REQ_RC",
    0x03000012: "BAT_REQ_MAX_DCB_CELL_CURRENT",
    0x03000013: "BAT_REQ_MIN_DCB_CELL_CURRENT",
    0x03000014: "BAT_REQ_MAX_DCB_CELL_VOLTAGE",
    0x03000015: "BAT_REQ_MIN_DCB_CELL_VOLTAGE",
    0x03000016: "BAT_REQ_MAX_DCB_CELL_TEMPERATURE",
    0x03000017: "BAT_REQ_MIN_DCB_CELL_TEMPERATURE",
    0x03000018: "BAT_REQ_DCB_ALL_CELL_TEMPERATURES",
    0x0300001A: "BAT_REQ_DCB_ALL_CELL_VOLTAGES",
    0x0300001C: "BAT_REQ_OPEN_BREAKER",
    0x0300001D: "BAT_REQ_OPEN_BREAKER_CONFIRM",
    0x0300001E: "BAT_REQ_READY_FOR_SHUTDOWN",
    0x0300001F: "BAT_REQ_FIRMWARE_VERSION",
    0x03000020: "BAT_REQ_INFO",
    0x03000021: "BAT_REQ_TRAINING_MODE",
    0x03000022: "BAT_REQ_UPDATE_STATUS",
    0x03000023: "BAT_REQ_SET_TRAINING_MODE",
    0x03000024: "BAT_REQ_TIME_LAST_RESPONSE",
    0x03000025: "BAT_REQ_MANUFACTURER_NAME",
    0x03000026: "BAT_REQ_USABLE_CAPACITY",
    0x03000027: "BAT_REQ_USABLE_REMAINING_CAPACITY",
    0x03000028: "BAT_REQ_SET_A1_DATA",
    0x03000029: "BAT_REQ_SET_A1_MODE",
    0x03000030: "BAT_REQ_SET_A1_VOLTAGE",
    0x03000031: "BAT_REQ_SET_A1_CURRENT",
    0x03000032: "BAT_REQ_CONTROL_CODE",
    0x03000033: "BAT_REQ_BPM_STATUS",
    0x03000034: "BAT_REQ_DCB_ERROR_LIST",
    0x03000042: "BAT_REQ_DCB_INFO",
    0x03000092: "BAT_REQ_DISCHARGE_UNTIL_EMPTY_STATE",
    0x03800092: "BAT_DISCHARGE_UNTIL_EMPTY_STATE",
    0x03000094: "BAT_REQ_SET_DISCHARGE_UNTIL_EMPTY",
    0x03800094: "BAT_SET_DISCHARGE_UNTIL_EMPTY",
    0x03000095: "BAT_REQ_CONTROL_STATE",
    0x03000096: "BAT_REQ_INTERNAL_STATE",
    0x03800095: "BAT_CONTROL_STATE",
    0x03800096: "BAT_INTERNAL_STATE",
    0x03000097: "BAT_REQ_IS_BREAKER_OPEN",
    0x03800097: "BAT_IS_BREAKER_OPEN",
    0x03000098: "BAT_REQ_CLOSE_BREAKER",
    0x03800098: "BAT_CLOSE_BREAKER",
    0x03000130: "BAT_REQ_MEASURED_RESISTANCE",
    0x03800130: "BAT_MEASURED_RESISTANCE",
    0x03000131: "BAT_REQ_RUN_MEASURED_RESISTANCE",
    0x03800131: "BAT_RUN_MEASURED_RESISTANCE",
    0x03800042: "BAT_DCB_INFO",
    0x03800100: "BAT_DCB_INDEX",
    0x03800101: "BAT_DCB_LAST_MESSAGE_TIMESTAMP",
    0x03800102: "BAT_DCB_MAX_CHARGE_VOLTAGE",
    0x03800103: "BAT_DCB_MAX_CHARGE_CURRENT",
    0x03800104: "BAT_DCB_END_OF_DISCHARGE",
    0x03800105: "BAT_DCB_MAX_DISCHARGE_CURRENT",
    0x03800106: "BAT_DCB_FULL_CHARGE_CAPACITY",
    0x03800107: "BAT_DCB_REMAINING_CAPACITY",
    0x03800108: "BAT_DCB_SOC",
    0x03800109: "BAT_DCB_SOH",
    0x03800110: "BAT_DCB_CYCLE_COUNT",
    0x03800111: "BAT_DCB_CURRENT",
    0x03800112: "BAT_DCB_VOLTAGE",
    0x03800113: "BAT_DCB_CURRENT_AVG_30S",
    0x03800114: "BAT_DCB_VOLTAGE_AVG_30S",
    0x03800115: "BAT_DCB_DESIGN_CAPACITY",
    0x03800116: "BAT_DCB_DESIGN_VOLTAGE",
    0x03800117: "BAT_DCB_CHARGE_LOW_TEMPERATURE",
    0x03800118: "BAT_DCB_CHARGE_HIGH_TEMPERATURE",
    0x03800119: "BAT_DCB_MANUFACTURE_DATE",
    0x03800120: "BAT_DCB_SERIALNO",
    0x03800121: "BAT_DCB_PROTOCOL_VERSION",
    0x03800122: "BAT_DCB_FW_VERSION",
    0x03800123: "BAT_DCB_DATA_TABLE_VERSION",
    0x03800124: "BAT_DCB_PCB_VERSION",
    0x03800300: "BAT_DCB_NR_SERIES_CELL",
    0x03800301: "BAT_DCB_NR_PARALLEL_CELL",
    0x03800302: "BAT_DCB_MANUFACTURE_NAME",
    0x03800303: "BAT_DCB_DEVICE_NAME",
    0x03800304: "BAT_DCB_SERIALCODE",
    0x03800305: "BAT_DCB_NR_SENSOR",
    0x03800306: "BAT_DCB_STATUS",
    0x03800307: "BAT_DCB_WARNING",
    0x03800308: "BAT_DCB_ALARM",
    0x03800309: "BAT_DCB_ERROR",
    0x03060000: "BAT_REQ_DEVICE_STATE",
    0x03860000: "BAT_DEVICE_STATE",
    0x03860001: "BAT_DEVICE_CONNECTED",
    0x03860002: "BAT_DEVICE_WORKING",
    0x03860003: "BAT_DEVICE_IN_SERVICE",
    0x03FFFFFF: "BAT_GENERAL_ERROR",
    0x03000043: "BAT_REQ_SPECIFICATION",
    0x03800043: "BAT_SPECIFICATION",
    0x03800125: "BAT_SPECIFIED_CAPACITY",
    0x03800126: "BAT_SPECIFIED_DSCHARGE_POWER",
    0x03800127: "BAT_SPECIFIED_CHARGE_POWER",
    0x03800128: "BAT_SPECIFIED_MAX_DCB_COUNT",
    0x03800129: "BAT_ROLE",
    0x03000044: "BAT_REQ_INTERNALS",
    0x03800044: "BAT_INTERNALS",
    0x03800132: "BAT_INTERNAL_MAX_CHARGE_CURRENT",
    0x03800133: "BAT_INTERNAL_MAX_DISCHARGE_CURRENT",
    0x03800134: "BAT_INTERNAL_MAX_CHARGE_CURR_PER_DCB",
    0x03800135: "BAT_INTERNAL_MAX_DISCHARGE_CURR_PER_DCB",
    0x03800136: "BAT_INTERNAL_MAX_CHARGE_CURR_DATA_LOG",
    0x03800137: "BAT_INTERNAL_MAX_DISCHARGE_CURR_DATA_LOG",
    0x03000045: "BAT_REQ_DESIGN_CAPACITY",
    0x03000046: "BAT_REQ_DESIGN_VOLTAGE",
    0x03000047: "BAT_REQ_CHARGE_HIGH_TEMP",
    0x03000048: "BAT_REQ_CHARGE_LOW_TEMP",
    0x03000049: "BAT_REQ_MANUFACTURE_DATE",
    0x03000050: "BAT_REQ_SERIALNO",
    0x03000051: "BAT_REQ_DATA_TABLE_VERSION",
    0x03000052: "BAT_REQ_PROTOCOL_VERSION",
    0x03000053: "BAT_REQ_PCB_VERSION",
    0x03000054: "BAT_REQ_TOTAL_USE_TIME",
    0x03000055: "BAT_REQ_TOTAL_DISCHARGE_TIME",
    0x03000060: "BAT_REQ_OPEN_FET",
    0x03000061: "BAT_REQ_FET_STATE",
    0x03800045: "BAT_DESIGN_CAPACITY",
    0x03800046: "BAT_DESIGN_VOLTAGE",
    0x03800047: "BAT_CHARGE_HIGH_TEMP",
    0x03800048: "BAT_CHARGE_LOW_TEMP",
    0x03800049: "BAT_MANUFACTURE_DATE",
    0x03800050: "BAT_SERIALNO",
    0x03800051: "BAT_DATA_TABLE_VERSION",
    0x03800052: "BAT_PROTOCOL_VERSION",
    0x03800053: "BAT_PCB_VERSION",
    0x03800054: "BAT_TOTAL_USE_TIME",
    0x03800055: "BAT_TOTAL_DISCHARGE_TIME",
    0x03800061: "BAT_FET_STATE",
    0x03000056: "BAT_REQ_AVAILABLE_BATTERIES",
    0x03800057: "BAT_AVAILABLE_BATTERIES",
    0x03800058: "BAT_BATTERY_SPEC",
    0x03800059: "BAT_INSTANCE_DESCRIPTOR",
    0x03000062: "BAT_REQ_BATTERY_SOFT_ON",
    0x03800062: "BAT_BATTERY_SOFT_ON",
    0x03000063: "BAT_REQ_SET_BAT_VOLT_ADJUSTMENT",
    0x03800063: "BAT_SET_BAT_VOLT_ADJUSTMENT",
    0x03000064: "BAT_REQ_BAT_VOLT_ADJUSTMENT",
    0x03800064: "BAT_BAT_VOLT_ADJUSTMENT",
    0x03000065: "BAT_REQ_BAT_VOLT_ADJ_READY_INDEX",
    0x03800065: "BAT_BAT_VOLT_ADJ_READY_INDEX",
    0x03400001: "BAT_PARAM_BAT_VOLT_STATUS",
    0x03400002: "BAT_PARAM_BAT_VOLT_TARGET_VALUE",
    0x03400003: "BAT_PARAM_BAT_VOLT_MIN_VOLTAGE",
    0x03400004: "BAT_PARAM_BAT_VOLT_MAX_VOLTAGE",
    0x03400005: "BAT_PARAM_BAT_VOLT_ENABLED",
    0x03400006: "BAT_PARAM_BAT_NUMBER",
    0x05040000: "PM_REQ_DATA",
    0x05040001: "PM_INDEX",
    0x05840000: "PM_DATA",
    0x05000001: "PM_REQ_POWER_L1",
    0x05000002: "PM_REQ_POWER_L2",
    0x05000003: "PM_REQ_POWER_L3",
    0x05000004: "PM_REQ_ACTIVE_PHASES",
    0x05000005: "PM_REQ_MODE",
    0x05000006: "PM_REQ_ENERGY_L1",
    0x05000007: "PM_REQ_ENERGY_L2",
    0x05000008: "PM_REQ_ENERGY_L3",
    0x05000009: "PM_REQ_DEVICE_ID",
    0x0500000A: "PM_REQ_ERROR_CODE",
    0x0500000B: "PM_REQ_SET_PHASE_ELIMINATION",
    0x05000018: "PM_REQ_GET_PHASE_ELIMINATION",
    0x0500000C: "PM_REQ_FIRMWARE_VERSION",
    0x0500000D: "PM_REQ_SET_FOR_EMERGENCY_TEST",
    0x0500000E: "PM_REQ_IS_CAN_SILENCE",
    0x0500000F: "PM_REQ_MAX_PHASE_POWER",
    0x05000011: "PM_REQ_VOLTAGE_L1",
    0x05000012: "PM_REQ_VOLTAGE_L2",
    0x05000013: "PM_REQ_VOLTAGE_L3",
    0x05000014: "PM_REQ_TYPE",
    0x05000015: "PM_REQ_SET_TYPE",
    0x05800001: "PM_POWER_L1",
    0x05800002: "PM_POWER_L2",
    0x05800003: "PM_POWER_L3",
    0x05800004: "PM_ACTIVE_PHASES",
    0x05800005: "PM_MODE",
    0x05800006: "PM_ENERGY_L1",
    0x05800007: "PM_ENERGY_L2",
    0x05800008: "PM_ENERGY_L3",
    0x05800009: "PM_DEVICE_ID",
    0x0580000A: "PM_ERROR_CODE",
    0x0580000B: "PM_SET_PHASE_ELIMINATION",
    0x05800018: "PM_GET_PHASE_ELIMINATION",
    0x0580000C: "PM_FIRMWARE_VERSION",
    0x0580000D: "PM_SET_FOR_EMERGENCY_TEST",
    0x0580000E: "PM_IS_CAN_SILENCE",
    0x0580000F: "PM_MAX_PHASE_POWER",
    0x05800011: "PM_VOLTAGE_L1",
    0x05800012: "PM_VOLTAGE_L2",
    0x05800013: "PM_VOLTAGE_L3",
    0x05800014: "PM_TYPE",
    0x05000050: "PM_REQ_COMM_STATE",
    0x05800050: "PM_COMM_STATE",
    0x05800051: "PM_CS_START_TIME",
    0x05800052: "PM_CS_LAST_TIME",
    0x05800053: "PM_CS_SUCC_FRAMES_ALL",
    0x05800054: "PM_CS_SUCC_FRAMES_100",
    0x05800055: "PM_CS_EXP_FRAMES_ALL",
    0x05800056: "PM_CS_EXP_FRAMES_100",
    0x05800057: "PM_CS_ERR_FRAMES_ALL",
    0x05800058: "PM_CS_ERR_FRAMES_100",
    0x05800059: "PM_CS_UNK_FRAMES",
    0x0580005A: "PM_CS_ERR_FRAME",
    0x05060000: "PM_REQ_DEVICE_STATE",
    0x05860000: "PM_DEVICE_STATE",
    0x05860001: "PM_DEVICE_CONNECTED",
    0x05860002: "PM_DEVICE_WORKING",
    0x05860003: "PM_DEVICE_IN_SERVICE",
    0x05FFFFFF: "PM_GENERAL_ERROR",
    0x050000A0: "PM_REQ_CONNECTED_DEVICES",
    0x058000A0: "PM_CONNECTED_DEVICES",
    0x058000A1: "PM_CONNECTED_DEVICE",
    0x050000B0: "PM_REQ_SET_DEVICE_NAME",
    0x050000B1: "PM_REQ_DEVICE_NAME",
    0x058000B1: "PM_DEVICE_NAME",
    0x050000B3: "PM_REQ_SET_EXTERN_LOAD",
    0x058000B3: "PM_SET_EXTERN_LOAD",
    0x050000B4: "PM_REQ_INJECT_DATA",
    0x058000B4: "PM_INJECT_DATA",
    0x04040000: "DCDC_REQ_DATA",
    0x04040001: "DCDC_INDEX",
    0x04840000: "DCDC_DATA",
    0x04000001: "DCDC_REQ_I_BAT",
    0x04000002: "DCDC_REQ_U_BAT",
    0x04000003: "DCDC_REQ_P_BAT",
    0x04000004: "DCDC_REQ_I_DCL",
    0x04000005: "DCDC_REQ_U_DCL",
    0x04000006: "DCDC_REQ_P_DCL",
    0x04000007: "DCDC_REQ_SELF_TEST",
    0x04000008: "DCDC_REQ_FIRMWARE_VERSION",
    0x04000009: "DCDC_REQ_FPGA_FIRMWARE",
    0x0400000A: "DCDC_REQ_SERIAL_NUMBER",
    0x0400000B: "DCDC_REQ_BOARD_VERSION",
    0x0400000C: "DCDC_REQ_FLASH_FILE_LIST",
    0x0400000E: "DCDC_REQ_IS_FLASHING",
    0x0400000F: "DCDC_REQ_FLASH",
    0x04000010: "DCDC_REQ_STATUS",
    0x04000013: "DCDC_REQ_STATUS_AS_STRING",
    0x04000021: "DCDC_REQ_VERIFY_CORTEX",
    0x04000022: "DCDC_REQ_FLASH_FPGA",
    0x04000023: "DCDC_REQ_FLASH_FPGA_FILE_LIST",
    0x04000024: "DCDC_REQ_SELF_TEST_RESULT",
    0x04000025: "DCDC_REQ_FLASH_STATUS",
    0x04000026: "DCDC_REQ_GET_PARAMETER",
    0x04000027: "DCDC_REQ_SET_PARAMETER",
    0x04000028: "DCDC_REQ_SET_PID_DEBUG",
    0x04000029: "DCDC_REQ_GET_PID_DEBUG",
    # 0x04000029: "DCDC_REQ_COPY_RING_BUFFER",
    0x04000030: "DCDC_REQ_PID_DEBUG_DATA",
    # 0x04000030: "DCDC_REQ_RING_BUFFER",
    0x04000071: "DCDC_REQ_SET_POWER",
    0x04000072: "DCDC_REQ_SET_IDLE",
    0x04000073: "DCDC_REQ_HANDLE_ERRORS",
    0x04000074: "DCDC_REQ_CLEAR_ERRORS",
    0x04000075: "DCDC_REQ_SEND_COMMAND",
    0x04000076: "DCDC_REQ_BROADCAST_COMMAND",
    0x04000077: "DCDC_REQ_ERROR_PENDING",
    0x04000078: "DCDC_REQ_SET_PVI_TYPE",
    0x04000079: "DCDC_REQ_PVI_TYPE",
    0x04000080: "DCDC_REQ_ON_GRID",
    0x04000081: "DCDC_REQ_SET_ON_GRID",
    0x04000082: "DCDC_REQ_NEXT_SLAVE_STATE",
    0x04000083: "DCDC_REQ_ENABLE_NEXT_SLAVE",
    0x04000084: "DCDC_REQ_DCDC_TYPE",
    0x04000085: "DCDC_REQ_SEND_KICKSTART",
    0x04800001: "DCDC_I_BAT",
    0x04800002: "DCDC_U_BAT",
    0x04800003: "DCDC_P_BAT",
    0x04800004: "DCDC_I_DCL",
    0x04800005: "DCDC_U_DCL",
    0x04800006: "DCDC_P_DCL",
    0x04800007: "DCDC_SELF_TEST",
    0x04800008: "DCDC_FIRMWARE_VERSION",
    0x04800009: "DCDC_FPGA_FIRMWARE",
    0x0480000A: "DCDC_SERIAL_NUMBER",
    0x0480000B: "DCDC_BOARD_VERSION",
    0x0480000C: "DCDC_FLASH_FILE_LIST",
    0x0480000D: "DCDC_FLASH_FILE",
    0x0480000E: "DCDC_IS_FLASHING",
    0x0480000F: "DCDC_FLASH",
    0x04800010: "DCDC_STATUS",
    0x04800011: "DCDC_STATE",
    0x04800012: "DCDC_SUBSTATE",
    0x04800013: "DCDC_STATUS_AS_STRING",
    0x04800014: "DCDC_STATE_AS_STRING",
    0x04800015: "DCDC_SUBSTATE_AS_STRING",
    0x04060000: "DCDC_REQ_DEVICE_STATE",
    0x04860000: "DCDC_DEVICE_STATE",
    0x04860001: "DCDC_DEVICE_CONNECTED",
    0x04860002: "DCDC_DEVICE_WORKING",
    0x04860003: "DCDC_DEVICE_IN_SERVICE",
    0x04FFFFFF: "DCDC_GENERAL_ERROR",
    0x04800021: "DCDC_VERIFY_CORTEX",
    0x04800022: "DCDC_FLASH_FPGA",
    0x04800023: "DCDC_FLASH_FPGA_FILE_LIST",
    0x04800024: "DCDC_SELF_TEST_RESULT",
    0x04800025: "DCDC_FLASH_STATUS",
    0x04800026: "DCDC_GET_PARAMETER",
    0x04800027: "DCDC_SET_PARAMETER",
    0x04800029: "DCDC_GET_PID_DEBUG",
    # 0x04800029: "DCDC_COPY_RING_BUFFER",
    0x04800030: "DCDC_PID_DEBUG_DATA",
    # 0x04800030: "DCDC_RING_BUFFER",
    0x04800071: "DCDC_SET_POWER",
    0x04800072: "DCDC_SET_IDLE",
    0x04800073: "DCDC_HANDLE_ERRORS",
    0x04800074: "DCDC_CLEAR_ERRORS",
    0x04800075: "DCDC_SEND_COMMAND",
    0x04800076: "DCDC_BROADCAST_COMMAND",
    0x04800077: "DCDC_ERROR_PENDING",
    0x04800079: "DCDC_PVI_TYPE",
    0x04800080: "DCDC_ON_GRID",
    0x04800082: "DCDC_NEXT_SLAVE_STATE",
    0x04800084: "DCDC_DCDC_TYPE",
    0x04800085: "DCDC_SEND_KICKSTART",
    0x04040010: "DCDC_PARAM_FLASH_PROGRESS",
    0x04040011: "DCDC_PARAM_FLASH_TYPE",
    0x04040012: "DCDC_PARAM_FLASHING_ACTIVE",
    0x04040013: "DCDC_PARAM_FLASH_MODE",
    0x04040014: "DCDC_PARAM_FLASH_FILE",
    0x04040015: "DCDC_PARAM_CRC",
    0x04040016: "DCDC_PARAM_PARAMETER_BLOCK",
    0x04040017: "DCDC_PARAM_PARAMETER_INDEX_FROM",
    0x04040018: "DCDC_PARAM_PARAMETER_INDEX_UNTIL",
    0x04040019: "DCDC_PARAM_PARAMETER_VALUE",
    0x04000031: "DCDC_REQ_FREE_RING_BUFFER",
    0x04800031: "DCDC_FREED_RING_BUFFER",
    0x04040030: "DCDC_PARAM_RING_BUFFER_ELEMENT",
    0x04040031: "DCDC_PARAM_RB_ID",
    0x04040032: "DCDC_PARAM_RB_TIME",
    0x04040033: "DCDC_PARAM_RB_I_BAT",
    0x04040034: "DCDC_PARAM_RB_U_BAT",
    0x04040035: "DCDC_PARAM_RB_I_DCL",
    0x04040036: "DCDC_PARAM_RB_U_DCL",
    0x04040037: "DCDC_PARAM_RB_MODE",
    0x04040038: "DCDC_PARAM_RB_SUBSTATE",
    0x04040039: "DCDC_PARAM_RB_SETPOINT",
    0x04040040: "DCDC_PARAM_RB_INDEX_DCDC",
    0x04040041: "DCDC_PARAM_RB_INDEX_FROM",
    0x04040042: "DCDC_PARAM_RB_INDEX_UNTIL",
    0x04000050: "DCDC_REQ_DCL_OPERATION_VOLTAGE",
    0x04000051: "DCDC_REQ_SET_DCL_OPERATION_VOLTAGE",
    0x04800051: "DCDC_DCL_OPERATION_VOLTAGE",
    0x04040050: "DCDC_PARAM_DCL_OV_UPPER_VOLTAGE",
    0x04040051: "DCDC_PARAM_DCL_OV_LOWER_VOLTAGE",
    0x04040052: "DCDC_PARAM_DCL_OV_INDEX",
    0x04040060: "DCDC_REQ_COUNT_HW_CONTROLLER",
    0x04840060: "DCDC_COUNT_HW_CONTROLLER",
    0x04040061: "DCDC_REQ_ENABLE_FAN_TEST",
    0x04040062: "DCDC_REQ_DISABLE_FAN_TEST",
    0x02840000: "PVI_DATA",
    0x02040000: "PVI_REQ_DATA",
    0x02040001: "PVI_INDEX",
    #    0x02000009: "PVI_REQ_INVERTER_COUNT",
    0x02000009: "PVI_REQ_TYPE",
    #    0x02800009: "PVI_INVERTER_COUNT",
    0x02800009: "PVI_TYPE",
    0x02040005: "PVI_VALUE",
    0x02FFFFFF: "PVI_GENERAL_ERROR",
    0x02800001: "PVI_ON_GRID",
    0x02000001: "PVI_REQ_ON_GRID",
    0x02800002: "PVI_STATE",
    0x02000002: "PVI_REQ_STATE",
    0x02800003: "PVI_LAST_ERROR",
    0x02000003: "PVI_REQ_LAST_ERROR",
    0x02800004: "PVI_IS_FLASHING",
    0x02000004: "PVI_REQ_IS_FLASHING",
    0x02000005: "PVI_REQ_START_FLASHING",
    0x02800006: "PVI_FLASH_FILE_LIST",
    0x02800007: "PVI_FLASH_FILE",
    0x02000006: "PVI_REQ_FLASH_FILE_LIST",
    0x02800008: "PVI_SERVICE_PROGRESS_STATE",
    0x02000008: "PVI_REQ_SERVICE_PROGRESS_STATE",
    0x02060000: "PVI_REQ_DEVICE_STATE",
    0x02860000: "PVI_DEVICE_STATE",
    0x02860001: "PVI_DEVICE_CONNECTED",
    0x02860002: "PVI_DEVICE_WORKING",
    0x02860003: "PVI_DEVICE_IN_SERVICE",
    0x02000010: "PVI_REQ_LAND_CODE",
    0x02800010: "PVI_LAND_CODE",
    0x02000011: "PVI_REQ_LAND_CODE_LIST",
    0x02000012: "PVI_REQ_SET_LAND_CODE",
    0x02800011: "PVI_LAND_CODE_LIST",
    0x02000013: "PVI_REQ_ERROR_LIST",
    0x02000015: "PVI_REQ_STATUS_LIST",
    0x02000014: "PVI_ERROR_LIST",
    0x02000016: "PVI_STATUS_LIST",
    0x02800013: "PVI_ERROR_STRING",
    0x02800015: "PVI_STATUS_STRING",
    0x02000017: "PVI_REQ_SET_DEVICE_SILENCE",
    0x02000018: "PVI_REQ_DEVICE_SILENCE",
    0x02800018: "PVI_DEVICE_SILENCE",
    0x02000019: "PVI_REQ_SELF_TEST",
    0x02800019: "PVI_SELF_TEST",
    0x02800050: "PVI_UZK_VOLTAGE",
    0x02000050: "PVI_REQ_UZK_VOLTAGE",
    0x02800060: "PVI_COS_PHI",
    0x02000060: "PVI_REQ_COS_PHI",
    0x02000061: "PVI_REQ_SET_COS_PHI",
    0x02000062: "PVI_COS_PHI_VALUE",
    0x02000063: "PVI_COS_PHI_IS_AKTIV",
    0x02000064: "PVI_COS_PHI_EXCITED",
    0x02800070: "PVI_VOLTAGE_MONITORING",
    0x02000070: "PVI_REQ_VOLTAGE_MONITORING",
    0x02000071: "PVI_REQ_SET_VOLTAGE_MONITORING",
    0x02000072: "PVI_VOLTAGE_MONITORING_THRESHOLD_TOP",
    0x02000073: "PVI_VOLTAGE_MONITORING_THRESHOLD_BOTTOM",
    0x02000074: "PVI_VOLTAGE_MONITORING_SLOPE_UP",
    0x02000075: "PVI_VOLTAGE_MONITORING_SLOPE_DOWN",
    0x02800080: "PVI_FREQUENCY_UNDER_OVER",
    0x02000080: "PVI_REQ_FREQUENCY_UNDER_OVER",
    0x02800081: "PVI_SET_FREQUENCY_UNDER_OVER",
    0x02000081: "PVI_REQ_SET_FREQUENCY_UNDER_OVER",
    0x02000082: "PVI_FREQUENCY_UNDER",
    0x02000083: "PVI_FREQUENCY_OVER",
    0x02800084: "PVI_SET_SYSTEM_MODE",
    0x02000084: "PVI_REQ_SET_SYSTEM_MODE",
    0x02800085: "PVI_SYSTEM_MODE",
    0x02000085: "PVI_REQ_SYSTEM_MODE",
    0x02800086: "PVI_SET_POWER_MODE",
    0x02000086: "PVI_REQ_SET_POWER_MODE",
    0x02800087: "PVI_POWER_MODE",
    0x02000087: "PVI_REQ_POWER_MODE",
    0x02000090: "PVI_REQ_USED_STRING_COUNT",
    0x02000091: "PVI_REQ_SET_USED_STRING_COUNT",
    0x02800090: "PVI_USED_STRING_COUNT",
    0x02000092: "PVI_REQ_DERATE_TO_POWER",
    0x02800092: "PVI_DERATE_TO_POWER",
    0x02800100: "PVI_TEMPERATURE",
    0x02000100: "PVI_REQ_TEMPERATURE",
    0x02800101: "PVI_TEMPERATURE_COUNT",
    0x02000101: "PVI_REQ_TEMPERATURE_COUNT",
    0x02800102: "PVI_MAX_TEMPERATURE",
    0x02000102: "PVI_REQ_MAX_TEMPERATURE",
    0x02800103: "PVI_MIN_TEMPERATURE",
    0x02000103: "PVI_REQ_MIN_TEMPERATURE",
    0x02000104: "PVI_REQ_CT_TAR_USV_BOX",
    0x02800104: "PVI_CT_TAR_USV_BOX",
    0x028ABC01: "PVI_SERIAL_NUMBER",
    0x020ABC01: "PVI_REQ_SERIAL_NUMBER",
    0x028ABC02: "PVI_VERSION",
    0x020ABC02: "PVI_REQ_VERSION",
    0x020ABC03: "PVI_VERSION_MAIN",
    0x020ABC04: "PVI_VERSION_PIC",
    0x020ABC05: "PVI_VERSION_ALL",
    0x020ABC51: "PVI_REQ_SET_POWEROFF_GPIO",
    0x020ABC52: "PVI_REQ_SET_NIGHTSWITCH_GPIO",
    0x020ABC60: "PVI_REQ_SET_PRE_GRID_CHARGE",
    0x028AC000: "PVI_AC_MAX_PHASE_COUNT",
    0x028AC001: "PVI_AC_POWER",
    0x028AC002: "PVI_AC_VOLTAGE",
    0x028AC003: "PVI_AC_CURRENT",
    0x028AC004: "PVI_AC_APPARENTPOWER",
    0x028AC005: "PVI_AC_REACTIVEPOWER",
    0x028AC006: "PVI_AC_ENERGY_ALL",
    0x028AC007: "PVI_AC_MAX_APPARENTPOWER",
    0x028AC008: "PVI_AC_ENERGY_DAY",
    0x028AC009: "PVI_AC_ENERGY_GRID_CONSUMPTION",
    0x020AC000: "PVI_REQ_AC_MAX_PHASE_COUNT",
    0x020AC001: "PVI_REQ_AC_POWER",
    0x020AC002: "PVI_REQ_AC_VOLTAGE",
    0x020AC003: "PVI_REQ_AC_CURRENT",
    0x020AC004: "PVI_REQ_AC_APPARENTPOWER",
    0x020AC005: "PVI_REQ_AC_REACTIVEPOWER",
    0x020AC006: "PVI_REQ_AC_ENERGY_ALL",
    0x020AC007: "PVI_REQ_AC_MAX_APPARENTPOWER",
    0x020AC008: "PVI_REQ_AC_ENERGY_DAY",
    0x020AC009: "PVI_REQ_AC_ENERGY_GRID_CONSUMPTION",
    0x028DC000: "PVI_DC_MAX_STRING_COUNT",
    0x028DC001: "PVI_DC_POWER",
    0x028DC002: "PVI_DC_VOLTAGE",
    0x028DC003: "PVI_DC_CURRENT",
    0x028DC004: "PVI_DC_MAX_POWER",
    0x028DC005: "PVI_DC_MAX_VOLTAGE",
    0x028DC006: "PVI_DC_MIN_VOLTAGE",
    0x028DC007: "PVI_DC_MAX_CURRENT",
    0x028DC008: "PVI_DC_MIN_CURRENT",
    0x028DC009: "PVI_DC_STRING_ENERGY_ALL",
    0x020DC000: "PVI_REQ_DC_MAX_STRING_COUNT",
    0x020DC001: "PVI_REQ_DC_POWER",
    0x020DC002: "PVI_REQ_DC_VOLTAGE",
    0x020DC003: "PVI_REQ_DC_CURRENT",
    0x020DC004: "PVI_REQ_DC_MAX_POWER",
    0x020DC005: "PVI_REQ_DC_MAX_VOLTAGE",
    0x020DC006: "PVI_REQ_DC_MIN_VOLTAGE",
    0x020DC007: "PVI_REQ_DC_MAX_CURRENT",
    0x020DC008: "PVI_REQ_DC_MIN_CURRENT",
    0x020DC009: "PVI_REQ_DC_STRING_ENERGY_ALL",
    0x020DC00A: "PVI_REQ_AC_ENERGY_PRODUCED_L1",
    0x020DC00B: "PVI_REQ_AC_ENERGY_PRODUCED_L2",
    0x020DC00C: "PVI_REQ_AC_ENERGY_PRODUCED_L3",
    0x020DC00D: "PVI_REQ_AC_ENERGY_CONSUMED_L1",
    0x020DC00E: "PVI_REQ_AC_ENERGY_CONSUMED_L2",
    0x020DC00F: "PVI_REQ_AC_ENERGY_CONSUMED_L3",
    0x028DC00A: "PVI_AC_ENERGY_PRODUCED_L1",
    0x028DC00B: "PVI_AC_ENERGY_PRODUCED_L2",
    0x028DC00C: "PVI_AC_ENERGY_PRODUCED_L3",
    0x028DC00D: "PVI_AC_ENERGY_CONSUMED_L1",
    0x028DC00E: "PVI_AC_ENERGY_CONSUMED_L2",
    0x028DC00F: "PVI_AC_ENERGY_CONSUMED_L3",
    0x020DC010: "PVI_REQ_ENABLE_FAN_TEST",
    0x020DC011: "PVI_REQ_DISABLE_FAN_TEST",
    0x020DC012: "PVI_REQ_RESET_LAND_NORM",
    0x028DC012: "PVI_RESET_LAND_NORM",
    0x09000001: "HA_REQ_DATAPOINT_LIST",
    0x09000010: "HA_REQ_ACTUATOR_STATES",
    0x09000020: "HA_REQ_ADD_ACTUATOR",
    0x09000030: "HA_REQ_REMOVE_ACTUATOR",
    0x09000040: "HA_REQ_COMMAND_ACTUATOR",
    0x09000041: "HA_REQ_COMMAND",
    0x09000050: "HA_REQ_DESCRIPTIONS_CHANGE",
    0x09000060: "HA_REQ_CONFIGURATION_CHANGE_COUNTER",
    0x09800060: "HA_CONFIGURATION_CHANGE_COUNTER",
    0x09800001: "HA_DATAPOINT_LIST",
    0x09800002: "HA_DATAPOINT",
    0x09800003: "HA_DATAPOINT_INDEX",
    0x09800004: "HA_DATAPOINT_TYPE",
    0x09800005: "HA_DATAPOINT_NAME",
    0x09800011: "HA_DATAPOINT_STATE",
    0x09800013: "HA_DATAPOINT_STATE_TIMESTAMP",
    0x09800014: "HA_DATAPOINT_STATE_VALUE",
    0x09800015: "HA_DATAPOINT_SUPPLY_QUALITY",
    0x09800016: "HA_DATAPOINT_SIGNAL_QUALITY",
    0x09800012: "HA_DATAPOINT_MODE",
    0x09800006: "HA_DATAPOINT_DESCRIPTIONS",
    0x09800007: "HA_DATAPOINT_DESCRIPTION",
    0x09800008: "HA_DATAPOINT_DESCRIPTION_NAME",
    0x09800009: "HA_DATAPOINT_DESCRIPTION_VALUE",
    0x09800010: "HA_ACTUATOR_STATES",
    0x09800020: "HA_ADD_ACTUATOR",
    0x09800030: "HA_REMOVE_ACTUATOR",
    0x09000070: "HA_REQ_POSSIBLE_POWER_METERS",
    0x09800070: "HA_POSSIBLE_POWER_METERS",
    0x09800071: "HA_POSSIBLE_POWER_METER",
    0x09000080: "HA_REQ_POSSIBLE_ANALOG_MODES",
    0x09800080: "HA_POSSIBLE_ANALOG_MODES",
    0x09800081: "HA_POSSIBLE_ANALOG_MODE",
    0x09800040: "HA_COMMAND_ACTUATOR",
    0x09800050: "HA_DESCRIPTIONS_CHANGE",
    0x09060000: "HA_REQ_DEVICE_STATE",
    0x09860000: "HA_DEVICE_STATE",
    0x09860001: "HA_DEVICE_CONNECTED",
    0x09860002: "HA_DEVICE_WORKING",
    0x09860003: "HA_DEVICE_IN_SERVICE",
    0x09FFFFFF: "HA_GENERAL_ERROR",
    0x08000001: "SRV_REQ_IS_ONLINE",
    0x08800001: "SRV_IS_ONLINE",
    0x08000002: "SRV_REQ_ADD_USER",
    0x08800002: "SRV_ADD_USER",
    0x08000003: "SRV_REQ_SET_LOCAL_USER",
    0x08800003: "SRV_SET_LOCAL_USER",
    0x08FFFFFF: "SRV_GENERAL_ERROR",
    0x0A000001: "INFO_REQ_SERIAL_NUMBER",
    0x0A000002: "INFO_REQ_PRODUCTION_DATE",
    0x0A000003: "INFO_REQ_MODULES_SW_VERSIONS",
    0x0A000007: "INFO_REQ_A35_SERIAL_NUMBER",
    0x0A000008: "INFO_REQ_IP_ADDRESS",
    0x0A000009: "INFO_REQ_SUBNET_MASK",
    0x0A00000A: "INFO_REQ_MAC_ADDRESS",
    0x0A00000B: "INFO_REQ_GATEWAY",
    0x0A00000C: "INFO_REQ_DNS",
    0x0A00000D: "INFO_REQ_DHCP_STATUS",
    0x0A00000E: "INFO_REQ_TIME",
    0x0A00000F: "INFO_REQ_UTC_TIME",
    0x0A000010: "INFO_REQ_TIME_ZONE",
    0x0A000011: "INFO_REQ_INFO",
    0x0A000012: "INFO_REQ_SET_IP_ADDRESS",
    0x0A000013: "INFO_REQ_SET_SUBNET_MASK",
    0x0A000014: "INFO_REQ_SET_DHCP_STATUS",
    0x0A000015: "INFO_REQ_SET_GATEWAY",
    0x0A000016: "INFO_REQ_SET_DNS",
    0x0A000018: "INFO_REQ_SET_TIME_ZONE",
    0x0A000019: "INFO_REQ_SW_RELEASE",
    0x0A00001A: "INFO_REQ_SET_GUI_TARGET",
    0x0A00001B: "INFO_REQ_GUI_TARGET",
    0x0A00001C: "INFO_REQ_PLATFORM_TYPE",
    0x0A000037: "INFO_REQ_UPNP_STATUS",
    0x0A000038: "INFO_REQ_SET_UPNP_STATUS",
    0x0A000039: "INFO_REQ_IS_OVP_POSSIBLE",
    0x0A800001: "INFO_SERIAL_NUMBER",
    0x0A800002: "INFO_PRODUCTION_DATE",
    0x0A800003: "INFO_MODULES_SW_VERSIONS",
    0x0A800004: "INFO_MODULE_SW_VERSION",
    0x0A800005: "INFO_MODULE",
    0x0A800006: "INFO_VERSION",
    0x0A800007: "INFO_A35_SERIAL_NUMBER",
    0x0A800008: "INFO_IP_ADDRESS",
    0x0A800009: "INFO_SUBNET_MASK",
    0x0A80000A: "INFO_MAC_ADDRESS",
    0x0A80000B: "INFO_GATEWAY",
    0x0A80000C: "INFO_DNS",
    0x0A80000D: "INFO_DHCP_STATUS",
    0x0A80000E: "INFO_TIME",
    0x0A80000F: "INFO_UTC_TIME",
    0x0A800010: "INFO_TIME_ZONE",
    0x0A800011: "INFO_INFO",
    0x0A800012: "INFO_SET_IP_ADDRESS",
    0x0A800013: "INFO_SET_SUBNET_MASK",
    0x0A800014: "INFO_SET_DHCP_STATUS",
    0x0A800015: "INFO_SET_GATEWAY",
    0x0A800016: "INFO_SET_DNS",
    0x0A800017: "INFO_SET_TIME",
    0x0A800018: "INFO_SET_TIME_ZONE",
    0x0A800019: "INFO_SW_RELEASE",
    0x0A80001A: "INFO_SET_GUI_TARGET",
    0x0A80001B: "INFO_GUI_TARGET",
    0x0A80001C: "INFO_PLATFORM_TYPE",
    0x0A800037: "INFO_UPNP_STATUS",
    0x0A800038: "INFO_SET_UPNP_STATUS",
    0x0A800039: "INFO_IS_OVP_POSSIBLE",
    0x0AFFFFFF: "INFO_GENERAL_ERROR",
    0x0A00001D: "INFO_REQ_IS_CALIBRATED",
    0x0A80001D: "INFO_IS_CALIBRATED",
    0x0A00001E: "INFO_REQ_CALIBRATION_CHECK",
    0x0A80001E: "INFO_CALIBRATION_CHECK",
    0x0A00001F: "INFO_REQ_RESET_CALIBRATION",
    0x0A80001F: "INFO_RESET_CALIBRATION",
    0x0A000020: "INFO_REQ_HW_TIME",
    0x0A800020: "INFO_HW_TIME",
    0x0A000021: "INFO_REQ_SET_TIME_UTC",
    0x0A800021: "INFO_SET_TIME_UTC",
    0x0A000022: "INFO_REQ_SET_HW_TIME",
    0x0A800022: "INFO_SET_HW_TIME",
    0x0A000023: "INFO_REQ_SET_FACILITY",
    0x0A800023: "INFO_SET_FACILITY",
    0x0A000024: "INFO_REQ_GET_FACILITY",
    0x0A800024: "INFO_GET_FACILITY",
    0x0A800025: "INFO_NAME",
    0x0A800026: "INFO_STREET",
    0x0A800027: "INFO_STREET_NO",
    0x0A800028: "INFO_POSTCODE",
    0x0A800029: "INFO_CITY",
    0x0A80002A: "INFO_FON",
    0x0A80002B: "INFO_E_MAIL",
    0x0A80002C: "INFO_COUNTRY",
    0x0A800036: "INFO_SURNAME",
    0x0A000025: "INFO_REQ_GET_FS_USAGE",
    0x0A80002D: "INFO_GET_FS_USAGE",
    0x0A80002E: "INFO_FS_SIZE",
    0x0A80002F: "INFO_FS_USED",
    0x0A800030: "INFO_FS_AVAILABLE",
    0x0A800031: "INFO_FS_USE_PERCENT",
    0x0A800032: "INFO_INODES",
    0x0A800033: "INFO_INODES_USED",
    0x0A800034: "INFO_INODES_AVAILABLE",
    0x0A800035: "INFO_INODES_USE_PERCENT",
    0x0B000001: "EP_REQ_SWITCH_TO_GRID",
    0x0B000002: "EP_REQ_SWITCH_TO_ISLAND",
    0x0B000003: "EP_REQ_IS_READY_FOR_SWITCH",
    0x0B000004: "EP_REQ_IS_GRID_CONNECTED",
    0x0B000005: "EP_REQ_IS_ISLAND_GRID",
    0x0B000006: "EP_REQ_IS_INVALID_STATE",
    0x0B000007: "EP_REQ_IS_POSSIBLE",
    0x0B000008: "EP_REQ_LEAVE_INVALID_STATE_TO_ISLAND",
    0x0B000009: "EP_REQ_LEAVE_INVALID_STATE_TO_GRID",
    0x0B800001: "EP_SWITCH_TO_GRID",
    0x0B800002: "EP_SWITCH_TO_ISLAND",
    0x0B800003: "EP_IS_READY_FOR_SWITCH",
    0x0B800004: "EP_IS_GRID_CONNECTED",
    0x0B800005: "EP_IS_ISLAND_GRID",
    0x0B800006: "EP_IS_INVALID_STATE",
    0x0B800007: "EP_IS_POSSIBLE",
    0x0B800008: "EP_LEAVE_INVALID_STATE_TO_ISLAND",
    0x0B800009: "EP_LEAVE_INVALID_STATE_TO_GRID",
    0x0BFFFFFF: "EP_GENERAL_ERROR",
    0x06000100: "DB_REQ_HISTORY_DATA_DAY",
    0x06000101: "DB_REQ_HISTORY_TIME_START",
    0x06000104: "DB_REQ_HISTORY_UTC_TIME_START",
    0x06000102: "DB_REQ_HISTORY_TIME_INTERVAL",
    0x06000103: "DB_REQ_HISTORY_TIME_SPAN",
    0x06000200: "DB_REQ_HISTORY_DATA_WEEK",
    0x06000300: "DB_REQ_HISTORY_DATA_MONTH",
    0x06000400: "DB_REQ_HISTORY_DATA_YEAR",
    0x06800010: "DB_SUM_CONTAINER",
    0x06800020: "DB_VALUE_CONTAINER",
    0x06800001: "DB_GRAPH_INDEX",
    0x06800002: "DB_BAT_POWER_IN",
    0x06800003: "DB_BAT_POWER_OUT",
    0x06800004: "DB_DC_POWER",
    0x06800005: "DB_GRID_POWER_IN",
    0x06800006: "DB_GRID_POWER_OUT",
    0x06800007: "DB_CONSUMPTION",
    0x06800008: "DB_PM_0_POWER",
    0x06800009: "DB_PM_1_POWER",
    0x0680000A: "DB_BAT_CHARGE_LEVEL",
    0x0680000B: "DB_BAT_CYCLE_COUNT",
    0x0680000C: "DB_CONSUMED_PRODUCTION",
    0x0680000D: "DB_AUTARKY",
    0x0680000E: "DB_PRODUCTION_POWER",
    0x06800100: "DB_HISTORY_DATA_DAY",
    0x06800200: "DB_HISTORY_DATA_WEEK",
    0x06800300: "DB_HISTORY_DATA_MONTH",
    0x06800400: "DB_HISTORY_DATA_YEAR",
    0x06000500: "DB_REQ_SYNC_HIST",
    0x06800500: "DB_SYNC_HIST",
    0x06000501: "DB_REQ_VACUUM_HIST",
    0x06800501: "DB_VACUUM_HIST",
    0x06000502: "DB_REQ_SYNC_BPU",
    0x06800502: "DB_SYNC_BPU",
    0x06000503: "DB_REQ_VACUUM_BPU",
    0x06800503: "DB_VACUUM_BPU",
    0x06000504: "DB_REQ_SYNC_DCB",
    0x06800504: "DB_SYNC_DCB",
    0x06000505: "DB_REQ_VACUUM_DBC",
    0x06800505: "DB_VACUUM_DCB",
    0x06000506: "DB_REQ_SYNC_BPU_CONF",
    0x06800506: "DB_SYNC_BPU_CONF",
    0x06000507: "DB_REQ_VACUUM_BPU_CONF",
    0x06800507: "DB_VACUUM_BPU_CONF",
    0x06000508: "DB_REQ_SYNC_DCB_CONF",
    0x06800508: "DB_SYNC_DCB_CONF",
    0x06000509: "DB_REQ_VACUUM_DBC_CONF",
    0x06800509: "DB_VACUUM_DCB_CONF",
    0x0600050A: "DB_REQ_SYNC_WALLBOX",
    0x0680050A: "DB_SYNC_WALLBOX",
    0x0600050B: "DB_REQ_VACUUM_WALLBOX",
    0x0680050B: "DB_VACUUM_WALLBOX",
    0x0600050C: "DB_REQ_SYNC_PV_DEBUG",
    0x0680050C: "DB_SYNC_PV_DEBUG",
    0x0600050D: "DB_REQ_VACUUM_PV_DEBUG",
    0x0680050D: "DB_VACUUM_PV_DEBUG",
    0x0600050E: "DB_REQ_SYNC_CONFIG",
    0x0680050E: "DB_SYNC_CONFIG",
    0x0600050F: "DB_REQ_VACUUM_CONFIG",
    0x0680050F: "DB_VACUUM_CONFIG",
    0x06000510: "DB_REQ_SET_SYNC_TIME",
    0x06800510: "DB_SET_SYNC_TIME",
    0x06000511: "DB_REQ_PVI_DIAL_RECORDINGS",
    0x06800511: "DB_PVI_DIAL_RECORDINGS",
    0x06000512: "DB_REQ_SYNC_BAT_DIAGNOSE",
    0x06800512: "DB_SYNC_BAT_DIAGNOSE",
    0x06000513: "DB_REQ_VACUUM_BAT_DIAGNOSE",
    0x06800513: "DB_VACUUM_BAT_DIAGNOSE",
    0x06000514: "DB_REQ_SYNC_EXT_LG",
    0x06800514: "DB_SYNC_EXT_LG",
    0x06000515: "DB_REQ_VACUUM_EXT_LG",
    0x06800515: "DB_VACUUM_EXT_LG",
    0x06000517: "DB_REQ_SYNC_ALL",
    0x06800517: "DB_SYNC_ALL",
    0x06B00000: "DB_PAR_TIME_MIN",
    0x06B00001: "DB_PAR_TIME_MAX",
    0x06B00002: "DB_PARAM_ROW",
    0x06B00003: "DB_PARAM_COLUMN",
    0x06B00004: "DB_PARAM_INDEX",
    0x06B00005: "DB_PARAM_VALUE",
    0x06B00006: "DB_PARAM_MAX_ROWS",
    0x06B00007: "DB_PARAM_TIME",
    0x06B00008: "DB_PARAM_VERSION",
    0x06B00009: "DB_PARAM_HEADER",
    0x06B00010: "DB_PARAM_PRODUCTION_L1",
    0x06B00011: "DB_PARAM_PRODUCTION_L2",
    0x06B00012: "DB_PARAM_PRODUCTION_L3",
    0x06B00013: "DB_PARAM_DC_POWER_S1",
    0x06B00014: "DB_PARAM_DC_POWER_S2",
    0x06B00015: "DB_PARAM_DC_POWER_S3",
    0x06000516: "DB_REQ_CLEAN_DATABASE",
    0x06800101: "DB_SET_IDLE",
    0x06800102: "DB_IS_IDLE",
    0x06800103: "DB_ENERGY_COUNTERS",
    0x0C000001: "SYS_REQ_SYSTEM_REBOOT",
    0x0C800001: "SYS_SYSTEM_REBOOT",
    0x0C000002: "SYS_REQ_IS_SYSTEM_REBOOTING",
    0x0C800002: "SYS_IS_SYSTEM_REBOOTING",
    0x0C000003: "SYS_REQ_RESTART_APPLICATION",
    0x0C800003: "SYS_RESTART_APPLICATION",
    0x0C000010: "SYS_REQ_SCRIPT_FILE_LIST",
    0x0C800010: "SYS_SCRIPT_FILE_LIST",
    0x0C800011: "SYS_SCRIPT_FILE",
    0x0C000015: "SYS_REQ_EXECUTE_SCRIPT",
    0x0C800015: "SYS_EXECUTE_SCRIPT",
    0x0CFFFFFF: "SYS_GENERAL_ERROR",
    0x0C000016: "SYS_REQ_SYSTEM_SHUTDOWN",
    0x0C000017: "SYS_REQ_IS_SYSTEM_SHUTTING_DOWN",
    0x0C800017: "SYS_IS_SYSTEM_SHUTING_DOWN",
    0x0D000001: "UM_REQ_UPDATE_STATUS",
    0x0D800001: "UM_UPDATE_STATUS",
    0x0D000002: "UM_REQ_UPDATE_DCDC",
    0x0D800002: "UM_UPDATE_DCDC",
    0x0D000003: "UM_REQ_CHECK_FOR_UPDATES",
    0x0D800003: "UM_CHECK_FOR_UPDATES",
    0x0DFFFFFF: "UM_GENERAL_ERROR",
    0x0E040000: "WB_REQ_DATA",
    0x0E040001: "WB_INDEX",
    0x0E840000: "WB_DATA",
    0x0E000001: "WB_REQ_ENERGY_ALL",
    0x0E000002: "WB_REQ_ENERGY_SOLAR",
    0x0E000003: "WB_REQ_SOC",
    0x0E000004: "WB_REQ_STATUS",
    0x0E000005: "WB_REQ_ERROR_CODE",
    0x0E000006: "WB_REQ_MODE",
    0x0E000007: "WB_REQ_APP_SOFTWARE",
    0x0E000008: "WB_REQ_BOOTLOADER_SOFTWARE",
    0x0E000009: "WB_REQ_HW_VERSION",
    0x0E00000A: "WB_REQ_FLASH_VERSION",
    0x0E00000B: "WB_REQ_DEVICE_ID",
    0x0E060000: "WB_REQ_DEVICE_STATE",
    0x0E00000C: "WB_REQ_PM_POWER_L1",
    0x0E00000D: "WB_REQ_PM_POWER_L2",
    0x0E00000E: "WB_REQ_PM_POWER_L3",
    0x0E00000F: "WB_REQ_PM_ACTIVE_PHASES",
    0x0E000011: "WB_REQ_PM_MODE",
    0x0E000012: "WB_REQ_PM_ENERGY_L1",
    0x0E000013: "WB_REQ_PM_ENERGY_L2",
    0x0E000014: "WB_REQ_PM_ENERGY_L3",
    0x0E000015: "WB_REQ_PM_DEVICE_ID",
    0x0E000016: "WB_REQ_PM_ERROR_CODE",
    0x0E000029: "WB_REQ_PM_DEVICE_STATE",
    0x0E000017: "WB_REQ_PM_FIRMWARE_VERSION",
    0x0E000018: "WB_REQ_DIAG_DEVICE_ID",
    0x0E000019: "WB_REQ_DIAG_BAT_CAPACITY",
    0x0E00001A: "WB_REQ_DIAG_USER_PARAM",
    0x0E00001B: "WB_REQ_DIAG_MAX_CURRENT",
    0x0E00001C: "WB_REQ_DIAG_PHASE_VOLTAGE",
    0x0E00001D: "WB_REQ_DIAG_DISPLAY_SPEECH",
    0x0E00001E: "WB_REQ_DIAG_DESIGN",
    0x0E00001F: "WB_REQ_DIAG_INFOS",
    0x0E000020: "WB_REQ_DIAG_WARNINGS",
    0x0E000021: "WB_REQ_DIAG_ERRORS",
    0x0E000022: "WB_REQ_DIAG_TEMP_1",
    0x0E000023: "WB_REQ_DIAG_TEMP_2",
    0x0E000024: "WB_REQ_DIAG_CP_PEGEL",
    0x0E000025: "WB_REQ_DIAG_PP_IN_A",
    0x0E000026: "WB_REQ_DIAG_STATUS_DIODE",
    0x0E000027: "WB_REQ_DIAG_DIG_IN_1",
    0x0E000028: "WB_REQ_DIAG_DIG_IN_2",
    0x0E000040: "WB_REQ_PM_MAX_PHASE_POWER",
    0x0E000041: "WB_REQ_SET_DEVICE_NAME",
    0x0E000042: "WB_REQ_DEVICE_NAME",
    0x0E800001: "WB_ENERGY_ALL",
    0x0E800002: "WB_ENERGY_SOLAR",
    0x0E800003: "WB_SOC",
    0x0E800004: "WB_STATUS",
    0x0E800005: "WB_ERROR_CODE",
    0x0E800006: "WB_MODE",
    0x0E800007: "WB_APP_SOFTWARE",
    0x0E800008: "WB_BOOTLOADER_SOFTWARE",
    0x0E800009: "WB_HW_VERSION",
    0x0E80000A: "WB_FLASH_VERSION",
    0x0E80000B: "WB_DEVICE_ID",
    0x0E860000: "WB_DEVICE_STATE",
    0x0E860001: "WB_DEVICE_CONNECTED",
    0x0E860002: "WB_DEVICE_WORKING",
    0x0E860003: "WB_DEVICE_IN_SERVICE",
    0x0EFFFFFF: "WB_GENERAL_ERROR",
    0x0E80000C: "WB_PM_POWER_L1",
    0x0E80000D: "WB_PM_POWER_L2",
    0x0E80000E: "WB_PM_POWER_L3",
    0x0E80000F: "WB_PM_ACTIVE_PHASES",
    0x0E800011: "WB_PM_MODE",
    0x0E800012: "WB_PM_ENERGY_L1",
    0x0E800013: "WB_PM_ENERGY_L2",
    0x0E800014: "WB_PM_ENERGY_L3",
    0x0E800015: "WB_PM_DEVICE_ID",
    0x0E800016: "WB_PM_ERROR_CODE",
    0x0E800029: "WB_PM_DEVICE_STATE",
    0x0E800030: "WB_PM_DEVICE_STATE_CONNECTED",
    0x0E800031: "WB_PM_DEVICE_STATE_WORKING",
    0x0E800032: "WB_PM_DEVICE_STATE_IN_SERVICE",
    0x0E800017: "WB_PM_FIRMWARE_VERSION",
    0x0E800018: "WB_DIAG_DEVICE_ID",
    0x0E800019: "WB_DIAG_BAT_CAPACITY",
    0x0E80001A: "WB_DIAG_USER_PARAM",
    0x0E80001B: "WB_DIAG_MAX_CURRENT",
    0x0E80001C: "WB_DIAG_PHASE_VOLTAGE",
    0x0E80001D: "WB_DIAG_DISPLAY_SPEECH",
    0x0E80001E: "WB_DIAG_DESIGN",
    0x0E80001F: "WB_DIAG_INFOS",
    0x0E800020: "WB_DIAG_WARNINGS",
    0x0E800021: "WB_DIAG_ERRORS",
    0x0E800022: "WB_DIAG_TEMP_1",
    0x0E800023: "WB_DIAG_TEMP_2",
    0x0E800024: "WB_DIAG_CP_PEGEL",
    0x0E800025: "WB_DIAG_PP_IN_A",
    0x0E800026: "WB_DIAG_STATUS_DIODE",
    0x0E800027: "WB_DIAG_DIG_IN_1",
    0x0E800028: "WB_DIAG_DIG_IN_2",
    0x0E800040: "WB_PM_MAX_PHASE_POWER",
    0x0E800042: "WB_DEVICE_NAME",
    0x0E041000: "WB_REQ_AVAILABLE_SOLAR_POWER",
    0x0E041001: "WB_POWER",
    0x0E041002: "WB_STATUS_BIT",
    0x0E841000: "WB_AVAILABLE_SOLAR_POWER",
    0x0E000030: "WB_REQ_SET_MODE",
    0x0E040031: "WB_MODE_PARAM_MODE",
    0x0E040032: "WB_MODE_PARAM_MAX_CURRENT",
    0x0E000031: "WB_SET_MODE",
    0x0E041010: "WB_REQ_SET_EXTERN",
    0x0E841010: "WB_SET_EXTERN",
    0x0E042010: "WB_EXTERN_DATA",
    0x0E042011: "WB_EXTERN_DATA_LEN",
    0x0E041011: "WB_REQ_EXTERN_DATA_SUN",
    0x0E041012: "WB_REQ_EXTERN_DATA_NET",
    0x0E041013: "WB_REQ_EXTERN_DATA_ALL",
    0x0E041014: "WB_REQ_EXTERN_DATA_ALG",
    0x0E841011: "WB_EXTERN_DATA_SUN",
    0x0E841012: "WB_EXTERN_DATA_NET",
    0x0E841013: "WB_EXTERN_DATA_ALL",
    0x0E841014: "WB_EXTERN_DATA_ALG",
    0x0E041015: "WB_REQ_SET_BAT_CAPACITY",
    0x0E041016: "WB_REQ_SET_ENERGY_ALL",
    0x0E041017: "WB_REQ_SET_ENERGY_SOLAR",
    0x0E041018: "WB_REQ_SET_PARAM_1",
    0x0E041019: "WB_REQ_SET_PARAM_2",
    0x0E041020: "WB_REQ_SET_PW",
    0x0E042012: "WB_PARAM_USR",
    0x0E042013: "WB_PARAM_PW",
    0x0E841015: "WB_SET_BAT_CAPACITY",
    0x0E841016: "WB_SET_ENERGY_ALL",
    0x0E841017: "WB_SET_ENERGY_SOLAR",
    0x0E841018: "WB_SET_PARAM_1",
    0x0E841019: "WB_SET_PARAM_2",
    0x0E841020: "WB_SET_PW",
    0x0E04101A: "WB_REQ_PARAM_2",
    0x0E84101A: "WB_RSP_PARAM_2",
    0x0E04101B: "WB_REQ_PARAM_1",
    0x0E84101B: "WB_RSP_PARAM_1",
    0x0E04101C: "WB_REQ_CONNECTED_DEVICES",
    0x0E84101C: "WB_CONNECTED_DEVICES",
    0x0E04101D: "WB_REQ_SET_SOC",
    0x0E84101D: "WB_SET_SOC",
    0x0E04101E: "WB_REQ_STATION_AVAILABLE",
    0x0E84101E: "WB_STATION_AVAILABLE",
    0x0E04101F: "WB_REQ_SET_STATION_AVAILABLE",
    0x0E84101F: "WB_SET_STATION_AVAILABLE",
    0x0E04102A: "WB_REQ_STATION_ENABLED",
    0x0E84102A: "WB_STATION_ENABLED",
    0x0E041021: "WB_REQ_SET_STATION_ENABLED",
    0x0E841021: "WB_SET_STATION_ENABLED",
    0x0E041022: "WB_REQ_MAC_ADDRESS",
    0x0E841022: "WB_MAC_ADDRESS",
    0x0E041023: "WB_REQ_PROXIMITY_PLUG",
    0x0E841023: "WB_PROXIMITY_PLUG",
    0x0E041024: "WB_REQ_PREFERRED_CHARGE_POWER",
    0x0E741024: "WB_PREFERRED_CHARGE_POWER",
    0x0E041025: "WB_REQ_CHARGE_FULL",
    0x0E841025: "WB_CHARGE_FULL",
    0x0E041026: "WB_REQ_SET_CHARGE_FULL",
    0x0E841026: "WB_SET_CHARGE_FULL",
    0x0E041027: "WB_REQ_ACTIVE_CHARGE_STRATEGY",
    0x0E841027: "WB_ACTIVE_CHARGE_STRATEGY",
    0x0E041028: "WB_REQ_SET_ACTIVE_CHARGE_STRATEGY",
    0x0E841028: "WB_SET_ACTIVE_CHARGE_STRAGETY",
    0x0E041029: "WB_REQ_PARAMETER_LIST",
    0x0E841029: "WB_PARAMETER_LIST",
    0x0E041030: "WB_REQ_SET_PARAMETER_LIST",
    0x0E841030: "WB_SET_PARAMETER_LIST",
    0x0E440010: "WB_STRING_PARAMETER",
    0x0E041031: "WB_REQ_GATEWAY",
    0x0E841031: "WB_GATEWAY",
    0x0E041032: "WB_REQ_SUBNET_MASK",
    0x0E841032: "WB_SUBNET_MASK",
    0x0E041033: "WB_REQ_IP_ADDR",
    0x0E841033: "WB_IP_ADDR",
    0x0E041034: "WB_REQ_DHCP_ENABLED",
    0x0E841034: "WB_DHCP_ENABLED",
    0x0E041035: "WB_REQ_SET_DHCP_ENABLED",
    0x0E841035: "WB_SET_DHCP_ENABLED",
    0x0E041036: "WB_REQ_WALLBOX_TYPE",
    0x0E841036: "WB_WALLBOX_TYPE",
    0x0E041037: "WB_REQ_UPDATE_NETWORK_CONFIG",
    0x0E841037: "WB_UPDATE_NETWORK_CONFIG",
    0x0E041038: "WB_REQ_SUN_MODE_ACTIVE",
    0x0E841038: "WB_SUN_MODE_ACTIVE",
    0x0E041039: "WB_REQ_SET_SUN_MODE_ACTIVE",
    0x0E841039: "WB_SET_SUN_MODE_ACTIVE",
    0x0E04103A: "WB_REQ_NUMBER",
    0x0E84103A: "WB_NUMBER",
    0x0E04103B: "WB_REQ_NUMBER_PHASES",
    0x0E84103B: "WB_NUMBER_PHASES",
    0x0E04103C: "WB_REQ_SET_NUMBER_PHASES",
    0x0E84103C: "WB_SET_NUMBER_PHASES",
    0x0E04103D: "WB_REQ_ABORT_CHARGING",
    0x0E84103D: "WB_ABORT_CHARGING",
    0x0E04103E: "WB_REQ_SET_ABORT_CHARGING",
    0x0E84103F: "WB_SET_ABORT_CHARGING",
    0x0E041040: "WB_REQ_SHUKO_AVAILABLE",
    0x0E841040: "WB_SHUKO_AVAILABLE",
    0x0E041041: "WB_REQ_IS_SHUKO_LOCKED",
    0x0E841041: "WB_IS_SHUKO_LOCKED",
    0x0E041042: "WB_REQ_SET_SHUKO_LOCKED",
    0x0E841042: "WB_SET_SHUKO_LOCKED",
    0x0E041043: "WB_REQ_MAX_POWER_PER_PHASE",
    0x0E841043: "WB_MAX_POWER_PER_PHASE",
    0x0E041044: "WB_REQ_MIN_POWER_PER_PHASE",
    0x0E841044: "WB_MIN_POWER_PER_PHASE",
    0x0E041045: "WB_REQ_UPPER_CURRENT_LITMIT",
    0x0E841045: "WB_UPPER_CURRENT_LITMIT",
    0x0E041046: "WB_REQ_LOWER_CURRENT_LITMIT",
    0x0E841046: "WB_LOWER_CURRENT_LITMIT",
    0x0E041047: "WB_REQ_MAX_CHARGE_CURRENT",
    0x0E841047: "WB_MAX_CHARGE_CURRENT",
    0x0E041048: "WB_REQ_MIN_CHARGE_CURRENT",
    0x0E841048: "WB_MIN_CHARGE_CURRENT",
    0x0E041049: "WB_REQ_SET_MAX_CHARGE_CURRENT",
    0x0E841049: "WB_SET_MAX_CHARGE_CURRENT",
    0x0E04104A: "WB_REQ_SET_MIN_CHARGE_CURRENT",
    0x0E84104A: "WB_SET_MIN_CHARGE_CURRENT",
    0x0E04104B: "WB_PARAM_INDEX",
    0x0E04104C: "WB_REQ_CHARGE_STOP_HYSTERESIS",
    0x0E84104C: "WB_CHARGE_STOP_HYSTERESIS",
    0x0E04104D: "WB_REQ_SET_CHARGE_STOP_HYSTERESIS",
    0x0E84104D: "WB_SET_CHARGE_STOP_HYSTERESIS",
    0x0E04104E: "WB_REQ_GET_KEY_LOCK_MODE",
    0x0E84104E: "WB_GET_KEY_LOCK_MODE",
    0x0E04104F: "WB_REQ_SET_KEY_LOCK_MODE",
    0x0E84104F: "WB_SET_KEY_LOCK_MODE",
    0x0E041050: "WB_REQ_KEY_STATE",
    0x0E841050: "WB_KEY_STATE",
    0x0E841051: "WB_REQ_SERIAL",
    0x0E041051: "WB_SERIAL",
    0x0E041052: "WB_REQ_MAX_CHARGE_POWER",
    0x0E041053: "WB_REQ_MIN_CHARGE_POWER",
    0x0E841052: "WB_MAX_CHARGE_POWER",
    0x0E841053: "WB_MIN_CHARGE_POWER",
    0x0E0F0001: "WB_REQ_SET_BIC_MODE",
    0x0E8F0001: "WB_SET_BIC_MODE",
    0x0E0F0002: "WB_REQ_GET_BIC_MODE",
    0x0E8F0002: "WB_GET_BIC_MODE",
    0x0E0F0003: "WB_REQ_GET_CHARGE_PLAN_TEXT",
    0x0E8F0003: "WB_GET_CHARGE_PLAN_TEXT",
    0x0F000001: "PTDB_REQ_SET_STD_PROPS",
    0x0F800001: "PTDB_SET_STD_PROPS",
    0x10000001: "LED_REQ_SET_BAR_SWITCHED_ON_STATE",
    0x10800001: "LED_SET_BAR_SWITCHED_ON_STATE",
    0x10000002: "LED_REQ_BAR_SWITCHED_ON_STATE",
    0x10800002: "LED_BAR_SWITCHED_ON_STATE",
    0x10000003: "LED_REQ_INTENSITY",
    0x10800003: "LED_INTENSITY",
    0x10000004: "LED_REQ_SET_INTENSITY",
    0x10800004: "LED_SET_INTENSITY",
    0x10000005: "LED_REQ_COLOR",
    0x10800005: "LED_COLOR",
    0x10000006: "LED_REQ_SET_COLOR",
    0x10800006: "LED_SET_COLOR",
    0x10000007: "LED_REQ_HW_INFO",
    0x10800007: "LED_HW_INFO",
    0x10000008: "LED_REQ_STORE_CONFIG",
    0x10800009: "LED_CONFIG_STORED",
    0x10860001: "LED_INDEX",
    0x10860002: "LED_RED",
    0x10860003: "LED_GREEN",
    0x10860004: "LED_BLUE",
    0x10860005: "LED_FW_VERSION",
    0x10860006: "LED_BL_VERSION",
    0x10060000: "LED_REQ_DEVICE_STATE",
    0x10860000: "LED_DEVICE_STATE",
    0x10860007: "LED_DEVICE_CONNECTED",
    0x10860008: "LED_DEVICE_WORKING",
    0x10860009: "LED_DEVICE_IN_SERVICE",
    0x11000000: "DIAG_REQ_CURRENT_ISSUES",
    0x11000001: "DIAG_REQ_REPORTED_ISSUES",
    0x11800000: "DIAG_CURRENT_ISSUES",
    0x11800001: "DIAG_REPORTED_ISSUES",
    0x11860000: "DIAG_ISSUE",
    0x11860001: "DIAG_ERR_CODE",
    0x11860002: "DIAG_ENDURE_TIME",
    0x11860003: "DIAG_TIME_ARISED",
    0x11860004: "DIAG_ERR_MSG",
    0x12840000: "SGR_DATA",
    0x12040000: "SGR_REQ_DATA",
    0x12040001: "SGR_INDEX",
    0x12000011: "SGR_REQ_SET_STATE",
    0x12000001: "SGR_REQ_STATE",
    0x12800001: "SGR_STATE",
    0x12000007: "SGR_REQ_SET_COOLDOWN_START",
    0x12000008: "SGR_REQ_COOLDOWN_END",
    0x12800008: "SGR_COOLDOWN_END",
    0x12000002: "SGR_REQ_READY_TO_USE",
    0x12800002: "SGR_READY_TO_USE",
    0x12000003: "SGR_REQ_HW_PROVIDER_LIST",
    0x12800003: "SGR_HW_PROVIDER_LIST",
    0x12800004: "SGR_HW_PROVIDER",
    0x12000006: "SGR_REQ_SET_AKTIV",
    0x12800006: "SGR_AKTIV",
    0x12800005: "SGR_NAME",
    0x12000009: "SGR_REQ_SET_USED_POWER",
    0x12000010: "SGR_REQ_USED_POWER",
    0x12800009: "SGR_USED_POWER",
    0x13000001: "MBS_REQ_MODBUS_ENABLED",
    0x13800001: "MBS_MODBUS_ENABLED",
    0x13700001: "MBS_REQ_SET_MODBUS_ENABLED",
    0x13000002: "MBS_REQ_MODBUS_CONNECTORS",
    0x13800002: "MBS_MODBUS_CONNECTORS",
    0x13810002: "MBS_MODBUS_CONNECTOR_CONTAINER",
    0x13810003: "MBS_MODBUS_CONNECTOR_NAME",
    0x13810004: "MBS_MODBUS_CONNECTOR_ID",
    0x13810005: "MBS_MODBUS_CONNECTOR_ENABLED",
    0x13810006: "MBS_MODBUS_CONNECTOR_SETUP",
    0x13810007: "MBS_MODBUS_SETUP_NAME",
    0x13810008: "MBS_MODBUS_SETUP_TYPE",
    0x13810009: "MBS_MODBUS_SETUP_VALUE",
    0x1381000A: "MBS_MODBUS_SETUP_VALUES",
    0x1381000B: "MBS_MODBUS_SETUP_VALUE_STRING",
    0x13000003: "MBS_REQ_ENABLE_CONNECTOR",
    0x13000004: "MBS_REQ_DISABLE_CONNECTOR",
    0x13000005: "MBS_REQ_CHANGE_SETTING",
    0x13800005: "MBS_CHANGE_SETTING",
    0x13800006: "MBS_REQ_CHANGE_SETTING_ERR",
    0x14000001: "EH_REQ_UNREPORTED_ERRORS",
    0x14800001: "EH_UNREPORTED_ERRORS",
    0x14000002: "EH_REQ_MARK_REPORTED",
    0x14800002: "EH_MARKED_REPORTED",
    0x14040000: "EH_PARAM_ROW",
    0x14040001: "EH_PARAM_ROW_ID",
    0x14040002: "EH_PARAM_ROW_TIME",
    0x14040003: "EH_PARAM_ROW_CODE",
    0x14040004: "EH_PARAM_ROW_TYPE",
    0x14040005: "EH_PARAM_ROW_CLEARED",
    0x14040006: "EH_PARAM_ROW_ERR_SRC",
    0x14040007: "EH_PARAM_ROW_MSG",
    0x15000001: "UPNPC_REQ_DEFAULT_LIST",
    0x15800001: "UPNPC_DEFAULT_LIST",
    0x15000002: "UPNPC_REQ_SET_DEFAULT_LIST",
    0x15800002: "UPNPC_SET_DEFAULT_LIST",
    0x15040000: "UPNPC_PARAM_DEVICE_ENTRY",
    0x15040001: "UPNPC_PARAM_SERIALNO",
    0x15040002: "UPNPC_PARAM_IP_ADR",
    0x15040003: "UPNPC_PARAM_PORT",
    0x15000003: "UPNPC_REQ_SERVICE_LIST",
    0x15800003: "UPNPC_SERVICE_LIST",
    0x15040004: "UPNPC_PARAM_NAME",
    0x15040005: "UPNPC_PARAM_LOCATION",
    0x15000006: "UPNPC_REQ_DEFAULT_LIST_REV",
    0x15800006: "UPNPC_DEFAULT_LIST_REV",
    0x15000007: "UPNPC_REQ_SERVICE_LIST_REV",
    0x15800007: "UPNPC_SERVICE_LIST_REV",
    0x16000001: "KNX_REQ_SET",
    0x16800001: "KNX_RSP_SET",
    0x16000002: "KNX_MAC",
    0x16000003: "KNX_IP",
    0x17000001: "EMSHB_REQ_HB_DATA",
    0x17800001: "EMSHB_HB_DATA",
    0x17040000: "EMSHB_PARAM_VERSION",
    0x17040001: "EMSHB_PARAM_BAT_S1",
    0x17040002: "EMSHB_PARAM_BAT_S2",
    0x17040003: "EMSHB_PARAM_BAT_S3",
    0x17040004: "EMSHB_PARAM_LM1",
    0x17040005: "EMSHB_PARAM_LM2",
    0x17040006: "EMSHB_PARAM_LM3",
    0x17040007: "EMSHB_PARAM_AC_L1",
    0x17040008: "EMSHB_PARAM_AC_L2",
    0x17040009: "EMSHB_PARAM_AC_L3",
    0x17040010: "EMSHB_PARAM_C_L1",
    0x17040011: "EMSHB_PARAM_C_L2",
    0x17040012: "EMSHB_PARAM_C_L3",
    0x17040013: "EMSHB_PARAM_SOC",
    0x17040014: "EMSHB_PARAM_SYS_STATUS",
    0x17040015: "EMSHB_PARAM_WB",
    0x17040016: "EMSHB_PARAM_WB_INDEX",
    0x17040017: "EMSHB_PARAM_WB_L1",
    0x17040018: "EMSHB_PARAM_WB_L2",
    0x17040019: "EMSHB_PARAM_WB_L3",
    0x17040020: "EMSHB_PARAM_WB_L1_Active",
    0x17040021: "EMSHB_PARAM_WB_L2_Active",
    0x17040022: "EMSHB_PARAM_WB_L3_Active",
    0x17040023: "EMSHB_PARAM_PV_S1",
    0x17040024: "EMSHB_PARAM_PV_S2",
    0x17040025: "EMSHB_PARAM_PV_S3",
    0x17040026: "EMSHB_PARAM_LM",
    0x17040027: "EMSHB_PARAM_ID",
    0x17040028: "EMSHB_PARAM_L1",
    0x17040029: "EMSHB_PARAM_L2",
    0x17040030: "EMSHB_PARAM_L3",
    0x17040031: "EMSHB_PARAM_LM_ALIVE_FLAG",
    0x17040032: "EMSHB_PARAM_WB_ALIVE_FLAG",
    0x17040033: "EMSHB_PARAM_WB_SOLAR_L1",
    0x17040034: "EMSHB_PARAM_WB_SOLAR_L2",
    0x17040035: "EMSHB_PARAM_WB_SOLAR_L3",
    0x18000003: "MYPV_REQ_FIND_DEVICES",
    0x18800003: "MYPV_RSP_FIND_DEVICES",
    0x18200004: "MYPV_REQ_LIST_DEVICES",
    0x18A00004: "MYPV_RSP_LIST_DEVICES",
    0x18300004: "MYPV_REQ_WRITE_DEVICES",
    0x18B00004: "MYPV_RSP_WRITE_DEVICES",
    0x18000006: "MYPV_REQ_REMOVE_DEVICES",
    0x18800006: "MYPV_RSP_REMOVE_DEVICES",
    0x18000007: "MYPV_REQ_INSTANT_BOOST",
    0x18800007: "MYPV_RSP_INSTANT_BOOST",
    0x18000100: "MYPV_DEVICE",
    0x18000101: "MYPV_DEVICE_SERIAL",
    0x18000102: "MYPV_DEVICE_ENABLED",
    0x18000103: "MYPV_DEVICE_IP",
    0x18000104: "MYPV_DEVICE_TEMPERATURE_CURRENT",
    0x18000105: "MYPV_DEVICE_TEMPERATURE_MAXIMUM",
    0x18000106: "MYPV_DEVICE_POWER",
    0x18000107: "MYPV_DEVICE_STATUS",
    0x18000108: "MYPV_DEVICE_CONTROL_MODE",
    0x18000109: "MYPV_DEVICE_TYPE",
    0x18000110: "MYPV_DEVICE_TIMESPAN_IBOOST",
    0x18000200: "MYPV_DEVICE_BOOST_LIST",
    0x18000300: "MYPV_DEVICE_BOOST_ITEM",
    0x18000301: "MYPV_DEVICE_BOOST_START",
    0x18000302: "MYPV_DEVICE_BOOST_STOP",
    0x18000303: "MYPV_DEVICE_BOOST_TEMPERATURE",
    0x18000304: "MYPV_DEVICE_BOOST_ACTIVE",
    0x18000305: "MYPV_DEVICE_BOOST_WEEKDAYS",
    0x18000306: "MYPV_DEVICE_BOOST_NAME",
    0x19000001: "GPIO_REQ_SET",
    0x19800001: "GPIO_RSP_SET",
    0x19000002: "GPIO_REQ_GET",
    0x19800002: "GPIO_RSP_GET",
    0x19000003: "GPIO_REQ_LIST",
    0x19800003: "GPIO_RSP_LIST",
    0x19860001: "GPIO_TUPEL",
    0x19860002: "GPIO_NUMBER",
    0x19860003: "GPIO_NAME",
    0x19860004: "GPIO_VALUE",
    0x1A000001: "FARM_REQ_CONNECTED_DEVICES",
    0x1A800001: "FARM_CONNECTED_DEVICES",
    0x1A040000: "FARM_PARAM_DEVICE",
    0x1A040001: "FARM_PARAM_SERIALNO",
    0x1A040002: "FARM_PARAM_CNAME",
    0x1A000003: "FARM_REQ_CONNECTED_DEVICES_REV",
    0x1A040003: "FARM_CONNECTED_DEVICES_REV",
    0x1B000001: "SE_REQ_SE_COUNT",
    0x1B800001: "SE_SE_COUNT",
    0x1B000002: "SE_REQ_SE_DATA",
    0x1B800002: "SE_SE_DATA",
    0x1B000003: "SE_REQ_SET_POWER",
    0x1B000004: "SE_REQ_SET_DERATING",
    0x1B800003: "SE_SET_POWER",
    0x1B800004: "SE_SET_DERATE",
    0x1B000005: "SE_REQ_SET_COUPLE_MODE",
    0x1B800005: "SE_SET_COUPLE_MODE",
    0x1B000006: "SE_REQ_COUPLE_MODE",
    0x1B800006: "SE_COUPLE_MODE",
    0x1B000009: "SE_REQ_EP_RESERVE",
    0x1B800009: "SE_EP_RESERVE",
    0x1B000010: "SE_REQ_SET_EP_RESERVE",
    0x1B000011: "SE_REQ_GET_ESTIMATED_POWER_LIMIT",
    0x1B800011: "SE_GET_ESTIMATED_POWER_LIMIT",
    0x1B000012: "SE_REQ_DESIGN_LIMIT",
    0x1B800012: "SE_DESIGN_LIMIT",
    0x1B040000: "SE_PARAM_INDEX",
    0x1B040001: "SE_PARAM_DCDC_STATUS",
    0x1B040002: "SE_PARAM_BAT_STATUS",
    0x1B040003: "SE_PARAM_CTRL_STATE",
    0x1B040004: "SE_PARAM_PvPower",
    0x1B040005: "SE_PARAM_PvEnergy",
    0x1B040006: "SE_PARAM_BatteryPower",
    0x1B040007: "SE_PARAM_BatCapacity",
    0x1B040008: "SE_PARAM_Limits",
    0x1B040009: "SE_PARAM_DesiredPower",
    0x1B040010: "SE_PARAM_DesiredDerating",
    0x1B040011: "SE_PARAM_INT",
    0x1B040012: "SE_PARAM_UINT",
    0x1B040013: "SE_PARAM_FLOAT",
    0x1B040014: "SE_PARAM_EmergencyMode",
    0x1B040020: "SE_PARAM_PVI1_STATUS",
    0x1B040021: "SE_PARAM_PVI2_STATUS",
    0x1B040022: "SE_PARAM_PVI3_STATUS",
    0x1B040023: "SE_PARAM_EP_RESERVE",
    0x1B040024: "SE_PARAM_TIME_LAST_FULL",
    0x1B040025: "SE_PARAM_TIME_LAST_EMPTY",
    0x1B040026: "SE_PARAM_LAST_SOC",
    0x1B000027: "SE_REQ_RESET_POWERSAVE_TIMEOUT",
    0x1B000028: "SE_REQ_EMERGENCY_POWER_OVERLOAD_STATUS",
    0x1B800028: "SE_EMERGENCY_POWER_OVERLOAD_STATUS",
    0x1B000029: "SE_REQ_EMERGENCY_POWER_RETRY",
    0x1B800029: "SE_EMERGENCY_POWER_RETRY",
    0x1B040030: "SE_PARAM_TIME_TO_RETRY",
    0x1B040031: "SE_PARAM_NO_REMAINING_RETRY",
    0x1B040033: "SE_PARAM_EP_RESERVE_W",
    0x1B040034: "SE_PARAM_EP_RESERVE_MAX_W",
    0x1B000030: "SE_REQ_IS_EMERGENCYPOWER_POSSIBLE",
    0x1B800030: "SE_IS_EMERGENCYPOWER_POSSIBLE",
    0x1C000001: "QPI_REQ_INVERTER_COUNT",
    0x1C800001: "QPI_INVERTER_COUNT",
    0x1C000002: "QPI_REQ_INVERTER_DATA",
    0x1C800002: "QPI_INVERTER_DATA",
    0x1C000003: "QPI_REQ_UPDATE_FIRMWARE",
    0x1C800003: "QPI_UPDATE_FIRMWARE",
    0x1C000004: "QPI_REQ_UPDATE_STATUS",
    0x1C800004: "QPI_UPDATE_STATUS",
    0x1C000005: "QPI_REQ_INVERTER_SET_VALUES",
    0x1C800005: "QPI_INVERTER_SET_VALUES",
    0x1C000006: "QPI_REQ_RESET_STATE_1_COUNTER",
    0x1C800006: "QPI_RESET_STATE_1_COUNTER",
    0x1C000007: "QPI_REQ_STATE_1_COUNTER",
    0x1C800007: "QPI_STATE_1_COUNTER",
    0x1C000008: "QPI_REQ_INVERTER_SET_POWER",
    0x1C800008: "QPI_INVERTER_SET_POWER",
    0x1C000009: "QPI_REQ_SET_BAT_INFO",
    0x1C800009: "QPI_SET_BAT_INFO",
    0x1C00000A: "QPI_REQ_GET_PARAM",
    0x1C80000A: "QPI_GET_PARAM",
    0x1C00000B: "QPI_REQ_SET_PARAM",
    0x1C80000B: "QPI_SET_PARAM",
    0x1C00000C: "QPI_REQ_ERR_LIST",
    0x1C80000C: "QPI_ERR_LIST",
    0x1C00000D: "QPI_REQ_ERR_LIST_4105",
    0x1C80000D: "QPI_ERR_LIST_4105",
    0x1C00000E: "QPI_REQ_CLEAR_ERR_HIST",
    0x1C80000E: "QPI_CLEAR_ERR_HIST",
    0x1C00000F: "QPI_REQ_STATE_0",
    0x1C80000F: "QPI_STATE_0",
    0x1C000010: "QPI_REQ_DEBUG_DATA",
    0x1C800010: "QPI_DEBUG_DATA",
    0x1C000011: "QPI_REQ_INVERTER_COUNT_DETAIL",
    0x1C800011: "QPI_INVERTER_COUNT_DETAIL",
    0x1C000012: "QPI_REQ_SELECTED_INVERTER_DATA",
    0x1C800012: "QPI_SELECTED_INVERTER_DATA",
    0x1C000013: "QPI_REQ_ERR_HIST",
    0x1C800013: "QPI_ERR_HIST",
    0x1C000014: "QPI_REQ_HW_INFO",
    0x1C800014: "QPI_HW_INFO",
    0x1C000015: "QPI_REQ_VERSION_RESET",
    0x1C800015: "QPI_VERSION_RESET",
    0x1C000016: "QPI_REQ_SET_DESIRED_CURRENT_FOR_EP",
    0x1C800016: "QPI_SET_DESIRED_CURRENT_FOR_EP",
    0x1C000017: "QPI_REQ_GET_DESIRED_CURRENT_FOR_EP",
    0x1C800017: "QPI_GET_DESIRED_CURRENT_FOR_EP",
    0x1C040000: "QPI_PARAM_INDEX",
    0x1C040001: "QPI_PARAM_U_Bat",
    0x1C040002: "QPI_PARAM_I_Bat",
    0x1C040003: "QPI_PARAM_U_AC",
    0x1C040004: "QPI_PARAM_I_AC",
    0x1C040005: "QPI_PARAM_PHI",
    0x1C040006: "QPI_PARAM_POWER",
    0x1C040007: "QPI_PARAM_APP_POWER",
    0x1C040008: "QPI_PARAM_REA_POWER",
    0x1C040009: "QPI_PARAM_FILE_NAME",
    0x1C040010: "QPI_PARAM_PROGRESS",
    0x1C040011: "QPI_PARAM_CHILD",
    0x1C040012: "QPI_PARAM_POWER_L1",
    0x1C040013: "QPI_PARAM_POWER_L2",
    0x1C040014: "QPI_PARAM_POWER_L3",
    0x1C040015: "QPI_PARAM_TIME",
    0x1C040016: "QPI_PARAM_STATE_1_COUNT",
    0x1C040017: "QPI_PARAM_CMD",
    0x1C400018: "QPI_PARAM_STATE_1_PS",
    0x1C400019: "QPI_PARAM_U_MAX",
    0x1C400020: "QPI_PARAM_U_MIN",
    0x1C400021: "QPI_PARAM_I_MAX",
    0x1C400022: "QPI_PARAM_I_MIN",
    0x1C400023: "QPI_PARAM_BLOCK",
    0x1C400024: "QPI_PARAM_ITEM",
    0x1C400025: "QPI_PARAM_VALUE",
    0x1C400030: "QPI_PARAM_ERR",
    0x1C400031: "QPI_PARAM_ERR_STR",
    0x1C400032: "QPI_PARAM_ERR_DATE",
    0x1C400033: "QPI_PARAM_ERR_CODE",
    0x1C400034: "QPI_PARAM_ERR_F_MIN",
    0x1C400035: "QPI_PARAM_ERR_F_MAX",
    0x1C400036: "QPI_PARAM_ERR_U_MIN",
    0x1C400037: "QPI_PARAM_ERR_U_MAX",
    0x1C400038: "QPI_PARAM_ERR_U_L1_PHI",
    0x1C400039: "QPI_PARAM_ERR_U_L1_RMS",
    0x1C400040: "QPI_PARAM_ERR_U_L2_PHI",
    0x1C400041: "QPI_PARAM_ERR_U_L2_RMS",
    0x1C400042: "QPI_PARAM_ERR_U_L3_PHI",
    0x1C400043: "QPI_PARAM_ERR_U_L3_RMS",
    0x1C400044: "QPI_PARAM_ERR_U_INV_PHI",
    0x1C400045: "QPI_PARAM_ERR_U_INV_RMS",
    0x1C400046: "QPI_PARAM_ERR_I_DCL_RMS",
    0x1C400047: "QPI_PARAM_ERR_U_DCL",
    0x1C400048: "QPI_PARAM_ERR_I_LOAD_PHI",
    0x1C400049: "QPI_PARAM_ERR_I_LOAD_RMS",
    0x1C400050: "QPI_PARAM_ERR_REGULATOR_OUT",
    0x1C400051: "QPI_PARAM_ERR_STATE_MASHINE_E_STATE",
    0x1C400052: "QPI_PARAM_ERR_STATE_ACT_REG",
    0x1C400053: "QPI_PARAM_ERR_TMP_0",
    0x1C400054: "QPI_PARAM_ERR_TMP_1",
    0x1C400055: "QPI_PARAM_ERR_TMP_2",
    0x1C400056: "QPI_PARAM_ERR_TMP_3",
    0x1C400057: "QPI_PARAM_ERR_CO_PRO",
    0x1C400058: "QPI_PARAM_ERR_TREATMENT",
    0x1C400059: "QPI_PARAM_ERR_I_LOAD_T0",
    0x1C400060: "QPI_PARAM_ERR_U_INV_TO",
    0x1C400061: "QPI_PARAM_U_AC_L1",
    0x1C400062: "QPI_PARAM_U_AC_L2",
    0x1C400063: "QPI_PARAM_U_AC_L3",
    0x1C400064: "QPI_PARAM_I_AC_L1",
    0x1C400065: "QPI_PARAM_I_AC_L2",
    0x1C400066: "QPI_PARAM_I_AC_L3",
    0x1C400067: "QPI_PARAM_APP_POWER_L1",
    0x1C400068: "QPI_PARAM_APP_POWER_L2",
    0x1C400069: "QPI_PARAM_APP_POWER_L3",
    0x1C400070: "QPI_PARAM_REA_POWER_L1",
    0x1C400071: "QPI_PARAM_REA_POWER_L2",
    0x1C400072: "QPI_PARAM_REA_POWER_L3",
    0x1C400073: "QPI_PARAM_STATE_0_STATE",
    0x1C400074: "QPI_PARAM_STATE_0_ERR_COUNT_ALL",
    0x1C400075: "QPI_PARAM_STATE_0_ERR_COUNT_ACTIVE",
    0x1C400076: "QPI_PARAM_STATE_0_OP_STATE",
    0x1C400079: "QPI_PARAM_CONF_STATE",
    0x1C400080: "QPI_PARAM_ACTIVATED",
    0x1C400081: "QPI_PARAM_INVERTER_GROUP",
    # 0x1C400109: "QPI_PARAM_COUNT_DETAIL",
    0x1C400109: "QPI_PARAM_INVERTER_STORED_SI_GROUP",
    # 0x1C400110: "QPI_PARAM_SW_SVN",
    0x1C400110: "QPI_PARAM_INVERTER_EP_LINE",
    0x1C400083: "QPI_PARAM_DEBUG_SM",
    0x1C400084: "QPI_PARAM_DEBUG_ACTUAL_REG",
    0x1C400085: "QPI_PARAM_DEBUG_U_DCL",
    0x1C400086: "QPI_PARAM_DEBUG_I_DCL_RMS",
    0x1C400087: "QPI_PARAM_DEBUG_I_LOAD_RMS",
    0x1C400088: "QPI_PARAM_DEBUG_I_LOAD_T0",
    0x1C400089: "QPI_PARAM_DEBUG_U_INV_RMS",
    0x1C400090: "QPI_PARAM_DEBUG_U_INV_T0",
    0x1C400091: "QPI_PARAM_DEBUG_U_L1_RMS",
    0x1C400092: "QPI_PARAM_DEBUG_U_L2_RMS",
    0x1C400093: "QPI_PARAM_DEBUG_U_L3_RMS",
    0x1C400094: "QPI_PARAM_DEBUG_U_L1_T0",
    0x1C400095: "QPI_PARAM_DEBUG_U_L2_T0",
    0x1C400096: "QPI_PARAM_DEBUG_U_L3_T0",
    0x1C400097: "QPI_PARAM_DEBUG_TMP_0",
    0x1C400098: "QPI_PARAM_DEBUG_TMP_1",
    0x1C400099: "QPI_PARAM_DEBUG_TMP_2",
    0x1C400100: "QPI_PARAM_DEBUG_TMP_3",
    0x1C400101: "QPI_PARAM_DEBUG_F_LINE",
    0x1C400102: "QPI_PARAM_DEBUG_I_DCL_AVG",
    0x1C400103: "QPI_PARAM_DEBUG_U_L1_PHI",
    0x1C400104: "QPI_PARAM_DEBUG_U_L2_PHI",
    0x1C400105: "QPI_PARAM_DEBUG_U_L3_PHI",
    0x1C400106: "QPI_PARAM_DEBUG_INV_PHI",
    0x1C400107: "QPI_PARAM_DEBUG_I_LOAD_PHI",
    0x1C400108: "QPI_PARAM_NUMBER_CHILDS",
    0x1C40010A: "QPI_PARAM_DEBUG_U_L1_RMS_COPRO",
    0x1C40010B: "QPI_PARAM_DEBUG_U_L2_RMS_COPRO",
    0x1C40010C: "QPI_PARAM_DEBUG_U_L3_RMS_COPRO",
    0x1C40010D: "QPI_PARAM_DEBUG_F_LINE_COPRO",
    0x1C40010E: "QPI_PARAM_SW_VERSION_DATE",
    0x1C40010F: "QPI_PARAM_SW_VERSION",
    0x1C400111: "QPI_PARAM_COPRO_SW_VERSION_DATE",
    0x1C400112: "QPI_PARAM_COPRO_SW_VERSION",
    0x1C400113: "QPI_PARAM_COPRO_SW_SVN",
    0x1C400114: "QPI_PARAM_HW_VERSION_MAIN",
    0x1C400115: "QPI_PARAM_HW_VERSION_COPRO",
    0x1C400116: "QPI_PARAM_HW_VERSION_PCB_CODE",
    0x1C400117: "QPI_PARAM_BOARD_SERIAL",
    0x1C400118: "QPI_PARAM_MODULE_SERIAL",
    0x1C400119: "QPI_PARAM_ERR_F_LINE",
    0x1C40011A: "QPI_PARAM_ERR_OPT_STATE",
    0x1C40011B: "QPI_PARAM_RT_RESULT",
    0x1C40011C: "QPI_PARAM_DOOR_SW_OPEN",
    0x1C40011D: "QPI_PARAM_FAN_REQESTED",
    0x1C40011E: "QPI_PARAM_DEBUG_COPRO_STATE",
    0x1C40011F: "QPI_PARAM_ERR_I_DCL_T0",
    0x1C400120: "QPI_PARAM_ERR_COPRO_U_L1_RMS",
    0x1C400121: "QPI_PARAM_ERR_COPRO_U_L2_RMS",
    0x1C400122: "QPI_PARAM_ERR_COPRO_U_L3_RMS",
    0x1C400123: "QPI_PARAM_ERR_COPRO_U_INV_RMS",
    0x1C400124: "QPI_PARAM_ERR_COPRO_REL_STATE",
    0x1C400125: "QPI_PARAM_ERR_COPRO_MODE",
    0x1C400126: "QPI_PARAM_ERR_COPRO_F_LINE",
    0x1C400127: "QPI_PARAM_ERR_COPRO_PEN_TV_STATE",
    0x1C400128: "QPI_PARAM_ERR_COPRO_ERR_DATA",
    0x1C400129: "QPI_PARAM_ERR_COPRO_TRIPP_LN_OUT",
    0x1C40012A: "QPI_PARAM_ERR_COPRO_TRIPP_LN_IN",
    0x1C40012B: "QPI_PARAM_ERR_COPRO_U_PEN_AVG",
    0x1C40012C: "QPI_PARAM_ERR_I_PRIM",
    0x1C40012D: "QPI_PARAM_SW_COUNTRY",
    0x1C40012E: "QPI_PARAM_SELECTEC_COUNTRY",
    0x1C40012F: "QPI_PARAM_COPRO_SW_COUNTRY",
    0x1C400130: "QPI_PARAM_COPRO_SELECTEC_COUNTRY",
    0x1C400131: "QPI_PARAM_MAX_AC_APPARENT_POWER",
    0x1C400132: "QPI_PARAM_DEBUG_U_INV_RMS_COPRO",
    0x1C400133: "QPI_PARAM_DEBUG_I_PRIM_RMS",
    0x1C000030: "QPI_REQ_SETTINGS_EP_ENABLED",
    0x1C800030: "QPI_SETTINGS_EP_ENABLED",
    0x1C00003A: "QPI_REQ_SET_SETTINGS_EP_ENABLED",
    0x1C80003A: "QPI_SET_SETTINGS_EP_ENABLED",
    0x1C00003B: "QPI_REQ_SETTINGS_VDE_2510_ENABLED",
    0x1C80003B: "QPI_SETTINGS_VDE_2510_ENABLED",
    0x1C00003C: "QPI_REQ_SET_SETTINGS_VDE_2510_ENABLED",
    0x1C80003C: "QPI_SET_SETTINGS_VDE_2510_ENABLED",
    0x1D000001: "GAPP_REQ_DEV_COUNT",
    0x1D800001: "GAPP_DEV_COUNT",
    0x1D000002: "GAPP_REQ_SERIALNO",
    0x1D800002: "GAPP_SERIALNO",
    0x1D000003: "GAPP_REQ_SUPPORTED_REACTIVE_POWER_FUNCTIONS",
    0x1D800003: "GAPP_SUPPORTED_REACTIVE_POWER_FUNCTIONS",
    0x1D000004: "GAPP_REQ_ENABLED_REACTIVE_POWER_FUNCTIONS",
    0x1D800004: "GAPP_ENABLED_REACTIVE_POWER_FUNCTIONS",
    0x1D000005: "GAPP_REQ_SET_REACTIVE_POWER_FUNCTIONS",
    0x1D800005: "GAPP_SET_REACTIVE_POWER_FUNCTIONS",
    0x1D000006: "GAPP_REQ_SET_REACTIVE_POWER_FUNCTIONS_PARAMETER",
    0x1D800006: "GAPP_SET_REACTIVE_POWER_FUNCTIONS_PARAMETER",
    0x1D000007: "GAPP_REQ_REACTIVE_POWER_FUNCTIONS_PARAMETER",
    0x1D800007: "GAPP_REACTIVE_POWER_FUNCTIONS_PARAMETER",
    0x1D000008: "GAPP_REQ_SUPPORTED_ACTIVE_POWER_FUNCTIONS",
    0x1D800008: "GAPP_SUPPORTED_ACTIVE_POWER_FUNCTIONS",
    0x1D000009: "GAPP_REQ_ENABLED_ACTIVE_POWER_FUNCTIONS_PU",
    0x1D800009: "GAPP_ENABLED_ACTIVE_POWER_FUNCTIONS_PU",
    0x1D00000A: "GAPP_REQ_SET_ACTIVE_POWER_FUNCTIONS_PU",
    0x1D80000A: "GAPP_SET_ACTIVE_POWER_FUNCTIONS_PU",
    0x1D00000B: "GAPP_REQ_SET_ACTIVE_POWER_FUNCTIONS_PU_PARAMETER",
    0x1D80000B: "GAPP_SET_ACTIVE_POWER_FUNCTIONS_PU_PARAMETER",
    0x1D00000C: "GAPP_REQ_ACTIVE_POWER_FUNCTION_PU_PARAMETER",
    0x1D80000C: "GAPP_ACTIVE_POWER_FUNCTION_PU_PARAMETER",
    0x1D00000D: "GAPP_REQ_REACTIVE_POWER_SETTINGS_EQUAL",
    0x1D80000D: "GAPP_REACTIVE_POWER_SETTINGS_EQUAL",
    0x1D00000E: "GAPP_REQ_ACTIVE_POWER_SETTINGS_EQUAL",
    0x1D80000E: "GAPP_ACTIVE_POWER_SETTINGS_EQUAL",
    0x1D040000: "GAPP_PARAM_INDEX",
    0x1D040001: "GAPP_PARAM_SERIALNO",
    0x1D040002: "GAPP_PARAM_REACTIVE_POWER_FUNCTION",
    0x1D040003: "GAPP_PARAM_ACTIVE_POWER_FUNCTION_PU",
    0x1D040004: "GAPP_PARAM_GAPP_PARAMETER",
    0x1D040005: "GAPP_PARAM_GAPP_PARAMETER_FUNCTION",
    0x1D040006: "GAPP_PARAM_GAPP_PARAMETER_VALUE_LIST",
    0x1D040007: "GAPP_PARAM_GAPP_PARAMETER_VALUE_LIST_ENTRY",
    0x1D040008: "GAPP_PARAM_GAPP_PARAMETER_SCALE_FACTOR_X",
    0x1D040009: "GAPP_PARAM_GAPP_PARAMETER_SCALE_FACTOR_Y",
    0x1D040010: "GAPP_PARAM_GAPP_PARAMETER_VALUE_MAX",
    0x1D040011: "GAPP_PARAM_GAPP_PARAMETER_VALUE_MIN",
    0x1D040012: "GAPP_PARAM_GAPP_PARAMETER_VALUE",
    0x1D040014: "GAPP_PARAM_SUPPORTED_REACTIVE_POWER_FUNCTIONS",
    0x1D040015: "GAPP_PARAM_SUPPORTED_ACTIVE_POWER_FUNCTIONS",
    0x1D040016: "GAPP_PARAM_SUCCESS",
    0x1D040017: "GAPP_PARAM_GAPP_PARAMETER_HAS_Y",
    0x1D040018: "GAPP_PARAM_GAPP_PARAMETER_COUNT_MIN",
    0x1D040019: "GAPP_PARAM_GAPP_PARAMETER_COUNT_MAX",
    0x1D040020: "GAPP_PARAM_GAPP_PARAMETER_COUNT_USED",
    0x1E000006: "EMSPR_REQ_CHANGECOUNTER",
    0x1E800006: "EMSPR_RSP_CHANGECOUNTER",
    0x1E000001: "EMSPR_REQ_GET_EQUATIONS",
    0x1E800001: "EMSPR_RSP_GET_EQUATIONS",
    0x1E000002: "EMSPR_REQ_SET_EQUATIONS",
    0x1E800002: "EMSPR_RSP_SET_EQUATIONS",
    0x1E000003: "EMSPR_REQ_GET_ACTIVE",
    0x1E800003: "EMSPR_RSP_GET_ACTIVE",
    0x1E000004: "EMSPR_REQ_GET_PINCOUNT",
    0x1E800004: "EMSPR_RSP_GET_PINCOUNT",
    0x1E000005: "EMSPR_REQ_SET_PINCOUNT",
    0x1E800005: "EMSPR_RSP_SET_PINCOUNT",
    0x1E000007: "EMSPR_REQ_GET_INVERTERENABLING",
    0x1E800007: "EMSPR_RSP_GET_INVERTERENABLING",
    0x1E000008: "EMSPR_REQ_SET_INVERTERENABLING",
    0x1E800008: "EMSPR_RSP_SET_INVERTERENABLING",
    0x1E00000B: "EMSPR_REQ_GET_INVERTERENABLEWAIT",
    0x1E80000B: "EMSPR_RSP_GET_INVERTERENABLEWAIT",
    0x1E00000C: "EMSPR_REQ_SET_INVERTERENABLEWAIT",
    0x1E80000C: "EMSPR_RSP_SET_INVERTERENABLEWAIT",
    0x1E860001: "EMSPR_EQUATION",
    0x1E860002: "EMSPR_INPUT",
    0x1E860003: "EMSPR_MASK",
    0x1E860004: "EMSPR_INVALID",
    0x1E860005: "EMSPR_OUTPUT",
    0x1E860006: "EMSPR_ISACTIVE",
    0x1E860007: "EMSPR_FAILURESTATE",
    0x20000001: "WBD_REQ_START_SCAN",
    0x20800001: "WBD_START_SCAN",
    0x20000002: "WBD_REQ_IS_SCANNING",
    0x20800002: "WBD_IS_SCANNING",
    0x20000003: "WBD_REQ_CREATE_WB",
    0x20800003: "WBD_CREATE_WB",
    0x20000004: "WBD_REQ_CANCEL_SCAN",
    0x20800004: "WBD_CANCEL_CAN",
    0x20000005: "WBD_REQ_DELETE_WALLBOX",
    0x20800005: "WBD_DELETE_WALL_BOX",
    0x21000001: "REFU_REQ_START_SCAN",
    0x21800001: "REFU_START_SCAN",
    0x21000002: "REFU_REQ_IS_SCANNING",
    0x21800002: "REFU_IS_SCANNING",
    0x21000003: "REFU_REQ_CREATE_INV",
    0x21800003: "REFU_CREATE_INV",
    0x21000004: "REFU_REQ_CANCEL_SCAN",
    0x21800004: "REFU_CANCEL_CAN",
    0x21000005: "REFU_REQ_DELETE_INVERTER",
    0x21800005: "REFU_DELETE_INVERTER",
    0x21000006: "REFU_REQ_NO_INVERTERS",
    0x21800006: "REFU_NO_INVERTERS",
    0x21000008: "REFU_REQ_CONNECTED_DEVICES",
    0x21800008: "REFU_CONNECTED_DEVICES",
    0x21400001: "REFU_PARAM_MAC",
    0x21400002: "REFU_PARAM_IP",
    0x21400003: "REFU_PARAM_ALIVE",
    0x21400004: "REFU_PARAM_INDEX",
    0x21400005: "REFU_PARAM_DHCP",
    0x22000001: "OVP_REQ_STATUS",
    0x22000002: "OVP_REQ_RESET",
    0x22800001: "OVP_STATUS",
    0x22800002: "OVP_RESET",
}


def getHexTag(tag_str):
    """Get tag as hex.

    Attributes:
        tag_str (str): tag as string

    Returns:
        int: hex representation of the given tag_str
    """
    for k, v in rscpTags.items():
        if v == tag_str:
            return k
    # key not found
    return int(tag_str, 0)


def getTag(tag_hex):
    """Get tag as hex.

    Attributes:
        tag_hex (int): tag as hex

    Returns:
        str: String representation of the given tag_hex
    """
    try:
        return rscpTags[tag_hex]
    except (KeyError):
        return hex(tag_hex)


rscpDataTypes = {
    0x00: "None",
    0x01: "Bool",
    0x02: "Char8",
    0x03: "UChar8",
    0x04: "Int16",
    0x05: "Uint16",
    0x06: "Int32",
    0x07: "Uint32",
    0x08: "Int64",
    0x09: "Uint64",
    0x0A: "Float32",
    0x0B: "Double64",
    0x0C: "Bitfield",
    0x0D: "CString",
    0x0E: "Container",
    0x0F: "Timestamp",
    0x10: "ByteArray",
    0xFF: "Error",
}

rscpErrorCodes = {
    0x01: "RSCP_ERR_NOT_HANDLED",
    0x02: "RSCP_ERR_ACCESS_DENIED",
    0x03: "RSCP_ERR_FORMAT",
    0x04: "RSCP_ERR_AGAIN",
    0x05: "RSCP_ERR_OUT_OF_BOUNDS",
    0x06: "RSCP_ERR_NOT_AVAILABLE",
    0x07: "RSCP_ERR_UNKNOWN_TAG",
    0x08: "RSCP_ERR_ALREADY_IN_USE",
    0xFFFFFFFF: "UNEXPECTED ERROR",  # happens for example in get_db_data if time and span is invalid (not available)
}


def getHexDatatype(type_str):
    """Get data type as hex.

    Attributes:
        type_str (str): type as string

    Returns:
        int: hex representation of the given type_str
    """
    for k, v in rscpDataTypes.items():
        if v == type_str:
            return k
    raise KeyError(type_str)


def getDatatype(type_hex):
    """Get data type as string.

    Attributes:
        type_hex (int): type as hex

    Returns:
        str: String representation of the given type_hex
    """
    return rscpDataTypes[type_hex]


def getErrorcode(error_hex):
    """Get error code as string.

    Attributes:
        error_hex (int): error as hex

    Returns:
        str: String representation of the given error_hex
    """
    return rscpErrorCodes[error_hex]
