# coding: utf-8
# Copyright (c) Tingzheng Hou.
# Distributed under the terms of the MIT License.

import os

from setuptools import setup, find_packages

module_dir = os.path.dirname(os.path.abspath(__file__))

with open(os.path.join(module_dir, "README.md"), "r") as f:
    readme = f.read()

INSTALL_REQUIRES = [
    "numpy>=1.16.0",
    "pandas",
    "matplotlib",
    "scipy",
    "tqdm",
    "pymatgen>=2022.0.9",
    "statsmodels",
    "pubchempy",
    "MDAnalysis",
    "selenium",
    "typing-extensions",
]

on_rtd = os.environ.get("READTHEDOCS") == "True"
if on_rtd:
    INSTALL_REQUIRES = []

if __name__ == "__main__":
    setup(
        name="mdgo",
        version="0.2.1",
        description="A codebase for MD simulation setup and results analysis.",
        long_description=readme,
        long_description_content_type="text/markdown",
        license="MIT",
        author="mdgo development team",
        author_email="tingzheng_hou@berkeley.edu",
        maintainer="Tingzheng Hou",
        maintainer_email="tingzheng_hou@berkeley.edu",
        url="https://github.com/HT-MD/mdgo",
        packages=find_packages(),
        install_requires=INSTALL_REQUIRES,
        extras_require={
            "web": [
                "sphinx",
                "sphinx_rtd_theme",
                "sphinx-autodoc-typehints",
            ],
        },
        python_requires=">=3.7",
    )
