"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PloneService = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
class PloneService extends constructs_1.Construct {
    constructor(scope, id, options) {
        super(scope, id);
        const targetPort = k8s.IntOrString.fromNumber(options.targetPort);
        const selectorLabel = options.selectorLabel;
        const service_labels = {
            ...options.labels ?? {},
            'app.kubernetes.io/part-of': 'plone',
            'app.kubernetes.io/managed-by': 'cdk8s-plone',
        };
        const serviceOpts = {
            metadata: {
                labels: service_labels,
            },
            spec: {
                ports: [{ port: options.targetPort, targetPort: targetPort, name: 'backend-http' }],
                selector: selectorLabel,
            },
        };
        const service = new k8s.KubeService(this, 'service', serviceOpts);
        this.name = service.name;
    }
}
exports.PloneService = PloneService;
//# sourceMappingURL=data:application/json;base64,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