"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Plone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const kplus = require("cdk8s-plus-24");
const constructs_1 = require("constructs");
const deployment_1 = require("./deployment");
const k8s_1 = require("./imports/k8s");
const service_1 = require("./service");
class Plone extends constructs_1.Construct {
    constructor(scope, id, options = {}) {
        super(scope, id);
        // ------------------------------------------------------------------------
        // Backend
        const backend = options.backend ?? {};
        const backendPort = 8080;
        const backendLabels = {
            'app.kubernetes.io/name': 'plone-backend',
            'app.kubernetes.io/component': 'backend',
            'app.kubernetes.io/version': options.version ?? 'undefined',
        };
        // Probing
        const backendLivenessProbe = {
            httpGet: {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(backendPort),
            },
            initialDelaySeconds: 30,
            timeoutSeconds: 1,
            periodSeconds: 10,
            successThreshold: 1,
            failureThreshold: 3,
        };
        const backendReadinessProbe = {
            httpGet: {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(backendPort),
            },
            initialDelaySeconds: 10,
            timeoutSeconds: 15,
            periodSeconds: 10,
            successThreshold: 1,
            failureThreshold: 3,
        };
        // Deployment
        const backendDeployment = new deployment_1.PloneDeployment(this, 'backend', {
            labels: backendLabels,
            image: {
                image: backend.image ?? 'plone/plone-backend:latest',
                imagePullSecrets: options.imagePullSecrets ?? [],
                imagePullPolicy: backend.imagePullPolicy ?? 'IfNotPresent',
            },
            replicas: backend.replicas,
            limitCpu: backend.limitCpu ?? 1,
            limitMemory: backend.limitMemory ?? '512Mi',
            pdb: {
                maxUnavailable: backend.maxUnavailable ?? undefined,
                minAvailable: backend.minAvailable ?? undefined,
            },
            port: backendPort,
            environment: backend.environment,
            livenessProbe: backendLivenessProbe,
            readinessProbe: backendReadinessProbe,
        });
        // Service
        const backendService = new service_1.PloneService(backendDeployment, 'service', {
            labels: {
                'app.kubernetes.io/name': 'plone-backend-service',
                'app.kubernetes.io/component': 'service',
            },
            targetPort: backendPort,
            selectorLabel: { app: cdk8s_1.Names.toLabelValue(backendDeployment) },
        });
        this.backendServiceName = backendService.name;
        // ------------------------------------------------------------------------
        // Frontend
        const frontend = options.frontend ?? {};
        const frontendPort = 3000;
        const frontendLabels = {
            'app.kubernetes.io/name': 'plone-frontend',
            'app.kubernetes.io/component': 'frontend',
            'app.kubernetes.io/version': options.version ?? 'undefined',
        };
        // Probing
        const frontendLivenessProbe = {
            httpGet: {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(frontendPort),
            },
            initialDelaySeconds: 30,
            timeoutSeconds: 1,
            periodSeconds: 10,
            successThreshold: 1,
            failureThreshold: 3,
        };
        const frontendReadinessProbe = {
            httpGet: {
                path: '/',
                port: k8s_1.IntOrString.fromNumber(frontendPort),
            },
            initialDelaySeconds: 10,
            timeoutSeconds: 15,
            periodSeconds: 10,
            successThreshold: 1,
            failureThreshold: 3,
        };
        // Environment for RAZZLE
        var frontendEnvironment = frontend.environment ?? new kplus.Env([], {});
        if (frontendEnvironment.variables.RAZZLE_INTERNAL_API_PATH === undefined) {
            // connect with backend service
            frontendEnvironment?.addVariable('RAZZLE_INTERNAL_API_PATH', kplus.EnvValue.fromValue(`http://${backendService.name}:${backendPort}`));
        }
        // Deployment
        const frontendDeployment = new deployment_1.PloneDeployment(this, 'frontend', {
            labels: frontendLabels,
            image: {
                image: frontend.image ?? 'plone/plone-frontend:latest',
                imagePullSecrets: options.imagePullSecrets ?? [],
                imagePullPolicy: frontend.imagePullPolicy ?? 'IfNotPresent',
            },
            replicas: frontend.replicas,
            limitCpu: frontend.limitCpu ?? 1,
            limitMemory: frontend.limitMemory ?? '1Gi',
            pdb: {
                maxUnavailable: frontend.maxUnavailable ?? undefined,
                minAvailable: frontend.minAvailable ?? undefined,
            },
            port: frontendPort,
            environment: frontendEnvironment,
            livenessProbe: frontendLivenessProbe,
            readinessProbe: frontendReadinessProbe,
        });
        // Service
        const frontendService = new service_1.PloneService(frontendDeployment, 'service', {
            labels: {
                'app.kubernetes.io/name': 'plone-frontend-service',
                'app.kubernetes.io/component': 'service',
            },
            targetPort: frontendPort,
            selectorLabel: { app: cdk8s_1.Names.toLabelValue(frontendDeployment) },
        });
        this.frontendServiceName = frontendService.name;
    }
}
exports.Plone = Plone;
_a = JSII_RTTI_SYMBOL_1;
Plone[_a] = { fqn: "@bluedynamics/cdk8s-plone.Plone", version: "0.0.4" };
//# sourceMappingURL=data:application/json;base64,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