"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PloneDeployment = void 0;
const cdk8s_1 = require("cdk8s");
const kplus = require("cdk8s-plus-24");
const constructs_1 = require("constructs");
const k8s = require("./imports/k8s");
const pdb_1 = require("./pdb");
class PloneDeployment extends constructs_1.Construct {
    constructor(scope, id, options) {
        super(scope, id);
        const image = options.image ?? {};
        const replicas = options.replicas ?? 2;
        const label = { app: cdk8s_1.Names.toLabelValue(this) };
        const optionLabels = options.labels ?? {};
        const deploymentLabels = {
            'app.kubernetes.io/name': optionLabels['app.kubernetes.io/name'] + '-deployment',
            'app.kubernetes.io/component': optionLabels['app.kubernetes.io/component'] ?? '' + '-deployment',
        };
        const template_labels = {
            ...optionLabels,
            ...label,
            'app.kubernetes.io/part-of': 'plone',
            'app.kubernetes.io/managed-by': 'cdk8s-plone',
        };
        const kpEnv = options.environment ?? new kplus.Env([], {});
        var env = [];
        var envFrom = [];
        for (const name in kpEnv.variables) {
            env.push({ name: name, value: kpEnv.variables[name].value });
        }
        // for (const source in kpEnv.sources) {
        //   envFrom.push({ configMapRef: source.configMap, prefix: source.prefix, secretRef: source.sec });
        // }
        var ploneContainerSpec = {
            name: id + '-container', // here the namespaced name shold be used, but how?
            image: image.image,
            imagePullPolicy: image.imagePullPolicy,
            env: env,
            envFrom: envFrom,
            resources: {
                limits: {
                    cpu: k8s.Quantity.fromNumber(options.limitCpu ?? 1),
                    memory: k8s.Quantity.fromString(options.limitMemory ?? '1Gi'),
                },
            },
            livenessProbe: options.livenessProbe ?? {},
            readinessProbe: options.readinessProbe ?? {},
        };
        const deploymentOptions = {
            metadata: {
                labels: deploymentLabels,
            },
            spec: {
                replicas,
                selector: {
                    matchLabels: label,
                },
                template: {
                    metadata: { labels: template_labels },
                    spec: {
                        imagePullSecrets: (image.imagePullSecrets ?? []).map((name) => ({ name: name })),
                        containers: [
                            ploneContainerSpec,
                            ...options.sidecars ?? [],
                        ],
                    },
                },
            },
        };
        new k8s.KubeDeployment(this, 'deployment', deploymentOptions);
        if (options.pdb ?? false) {
            const pdbOptions = options.pdb ?? {};
            new pdb_1.PlonePDB(this, 'pdb', label, pdbOptions);
        }
    }
}
exports.PloneDeployment = PloneDeployment;
//# sourceMappingURL=data:application/json;base64,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