"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
// we associate this stack with an explicit environment since this is required by the
// environmental context provider used in `fromLookup`. CDK_INTEG_XXX are set
// when producing the .expected file and CDK_DEFAULT_XXX is passed in through from
// the CLI in actual deployment.
const env = {
    account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
    region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION,
};
const stack = new cdk.Stack(app, 'aws-cdk-ec2-import', { env });
/// !show
const vpc = ec2.Vpc.fromLookup(stack, 'VPC', {
    // This imports the default VPC but you can also
    // specify a 'vpcName' or 'tags'.
    isDefault: true,
});
/// !hide
// The only thing in this library that takes a VPC as an argument :)
new ec2.SecurityGroup(stack, 'SecurityGroup', {
    vpc,
});
// Try subnet selection
new cdk.CfnOutput(stack, 'PublicSubnets', { value: 'ids:' + vpc.publicSubnets.map(s => s.subnetId).join(',') });
new cdk.CfnOutput(stack, 'PrivateSubnets', { value: 'ids:' + vpc.privateSubnets.map(s => s.subnetId).join(',') });
// Route table IDs
new cdk.CfnOutput(stack, 'PublicRouteTables', { value: 'ids: ' + vpc.publicSubnets.map(s => s.routeTable.routeTableId).join(', ') });
app.synth();
//# sourceMappingURL=data:application/json;base64,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