#!/usr/bin/env python

from setuptools import setup, find_packages

VERSION_TMPL = """
# coding: utf-8
# file generated by setuptools_scm
# don't change, don't track in version control
# pylint: skip-file
version = {version!r}
"""

dev_requires = [
    "twine",
    "wheel",
    "setuptools-scm",
    "setuptools-lint",
    "requirements-builder",
]


tests_require = [
      "flask",
      "pylint",
      "flake8"
]

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(name='healthcheck-extended',
      use_scm_version={
            "write_to": "_version.py",
            "write_to_template": VERSION_TMPL,
      },
      description='Adds healthcheck endpoints to Flask apps',
      long_description=long_description,
      long_description_content_type="text/markdown",
      author='Felix Schabernack',
      author_email='felix.schabernack@gmail.com',
      url='https://github.com/schabi88/healthcheck-extended',
      packages=find_packages(),
      zip_safe=False,
      include_package_data=True,
      license='MIT',
      platforms='any',
      tests_require=tests_require,
      extras_require={
          "dev": dev_requires,
          "tests": tests_require,
      },
      test_suite='test_healthcheck',
      classifiers=['Development Status :: 5 - Production/Stable',
                   'Environment :: Web Environment',
                   'Framework :: Flask',
                   'Programming Language :: Python'])
