import sys
import argparse

import vstruct.defs.ihex as v_d_ihex


example = '''
:020000021000EC
:10C20000E0A5E6F6FDFFE0AEE00FE6FCFDFFE6FD93
:10C21000FFFFF6F50EFE4B66F2FA0CFEF2F40EFE90
:10C22000F04EF05FF06CF07DCA0050C2F086F097DF
:10C23000F04AF054BCF5204830592D02E018BB03F9
:020000020000FC
:04000000FA00000200
:00000001FF
'''
example1 = '''
:10001300AC12AD13AE10AF1112002F8E0E8F0F2244
:10000300E50B250DF509E50A350CF5081200132259
:03000000020023D8
:0C002300787FE4F6D8FD7581130200031D
:10002F00EFF88DF0A4FFEDC5F0CEA42EFEEC88F016
:04003F00A42EFE22CB
:00000001FF
'''
example2 = '''
:10010000214601360121470136007EFE09D2190140
:100110002146017EB7C20001FF5F16002148011988
:10012000194E79234623965778239EDA3F01B2CAA7
:100130003F0156702B5E712B722B732146013421C7
:00000001FF
asdf
'''

example3 = '''
:100000003C932014BBE0AD7A3EAC4D261FB267A4F2
:100010008121F4C2D641A503B6038C9932A36EBCEC
:10002000D204306AE84404FCE8C7452DE0BE3160E4
:100030005CC6E94D3F4E62765AC237EAD3C2895157
:0200000400F00A
:10000000FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00
:020000040030CA
:1000000000270F0F0083F500FFC0FFE0FF400000C5
:020000040020DA
:080000000102030405060708D4
:00000001FF
'''


def setup():
    ap = argparse.ArgumentParser(description='IHEX Memory Map Printer')
    ap.add_argument('file', help='Path to IHex file to parse')
    return ap


def main(argv):
    opts = setup().parse_args(argv)

    ihex = v_d_ihex.IhexFile()
    with open(opts.ihex, 'rb') as f:
        ihex.vsParse(f.read())

    for addr, perms, fname, bytez in ihex.getMemoryMaps():
        print('0x%.8x: %r' % (addr, bytez))

    print(ihex.getEntryPoint())


if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
