# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.auth_config import AuthConfig  # noqa: F401,E501
from odahuflow.sdk.models import util


class OperatorConfig(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, auth: AuthConfig=None, monitoring_port: int=None):  # noqa: E501
        """OperatorConfig - a model defined in Swagger

        :param auth: The auth of this OperatorConfig.  # noqa: E501
        :type auth: AuthConfig
        :param monitoring_port: The monitoring_port of this OperatorConfig.  # noqa: E501
        :type monitoring_port: int
        """
        self.swagger_types = {
            'auth': AuthConfig,
            'monitoring_port': int
        }

        self.attribute_map = {
            'auth': 'auth',
            'monitoring_port': 'monitoringPort'
        }

        self._auth = auth
        self._monitoring_port = monitoring_port

    @classmethod
    def from_dict(cls, dikt) -> 'OperatorConfig':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The OperatorConfig of this OperatorConfig.  # noqa: E501
        :rtype: OperatorConfig
        """
        return util.deserialize_model(dikt, cls)

    @property
    def auth(self) -> AuthConfig:
        """Gets the auth of this OperatorConfig.


        :return: The auth of this OperatorConfig.
        :rtype: AuthConfig
        """
        return self._auth

    @auth.setter
    def auth(self, auth: AuthConfig):
        """Sets the auth of this OperatorConfig.


        :param auth: The auth of this OperatorConfig.
        :type auth: AuthConfig
        """

        self._auth = auth

    @property
    def monitoring_port(self) -> int:
        """Gets the monitoring_port of this OperatorConfig.

        Operator HTTP monitoring port  # noqa: E501

        :return: The monitoring_port of this OperatorConfig.
        :rtype: int
        """
        return self._monitoring_port

    @monitoring_port.setter
    def monitoring_port(self, monitoring_port: int):
        """Sets the monitoring_port of this OperatorConfig.

        Operator HTTP monitoring port  # noqa: E501

        :param monitoring_port: The monitoring_port of this OperatorConfig.
        :type monitoring_port: int
        """

        self._monitoring_port = monitoring_port
