"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalableTableAttribute = void 0;
const appscaling = require("@aws-cdk/aws-applicationautoscaling");
/**
 * A scalable table attribute
 */
class ScalableTableAttribute extends appscaling.BaseScalableAttribute {
    /**
     * Scale out or in based on time
     */
    scaleOnSchedule(id, action) {
        super.doScaleOnSchedule(id, action);
    }
    /**
     * Scale out or in to keep utilization at a given level
     */
    scaleOnUtilization(props) {
        if (props.targetUtilizationPercent < 10 || props.targetUtilizationPercent > 90) {
            // tslint:disable-next-line:max-line-length
            throw new RangeError(`targetUtilizationPercent for DynamoDB scaling must be between 10 and 90 percent, got: ${props.targetUtilizationPercent}`);
        }
        const predefinedMetric = this.props.dimension.indexOf('ReadCapacity') === -1
            ? appscaling.PredefinedMetric.DYANMODB_WRITE_CAPACITY_UTILIZATION
            : appscaling.PredefinedMetric.DYNAMODB_READ_CAPACITY_UTILIZATION;
        super.doScaleToTrackMetric('Tracking', {
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
            targetValue: props.targetUtilizationPercent,
            predefinedMetric,
        });
    }
}
exports.ScalableTableAttribute = ScalableTableAttribute;
//# sourceMappingURL=data:application/json;base64,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