"use strict";
const core_1 = require("@aws-cdk/core");
const ec2 = require("../lib");
module.exports = {
    'can make and use a Windows image'(test) {
        // GIVEN
        const stack = new core_1.Stack(undefined, undefined, {
            env: { region: 'testregion' }
        });
        // WHEN
        const image = new ec2.GenericWindowsImage({
            testregion: 'ami-1234'
        });
        // THEN
        const details = image.getImage(stack);
        test.equals(details.imageId, 'ami-1234');
        test.equals(details.osType, ec2.OperatingSystemType.WINDOWS);
        test.done();
    },
    'WindowsImage retains userdata'(test) {
        // GIVEN
        const stack = new core_1.Stack(undefined, undefined, {
            env: { region: 'testregion' }
        });
        // WHEN
        const ud = ec2.UserData.forWindows();
        const image = new ec2.GenericWindowsImage({
            testregion: 'ami-1234',
        }, {
            userData: ud
        });
        // THEN
        const details = image.getImage(stack);
        test.equals(details.userData, ud);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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