"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
class VpcEndpointStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        /// !show
        // Add gateway endpoints when creating the VPC
        const vpc = new ec2.Vpc(this, 'MyVpc', {
            gatewayEndpoints: {
                S3: {
                    service: ec2.GatewayVpcEndpointAwsService.S3
                }
            }
        });
        // Alternatively gateway endpoints can be added on the VPC
        const dynamoDbEndpoint = vpc.addGatewayEndpoint('DynamoDbEndpoint', {
            service: ec2.GatewayVpcEndpointAwsService.DYNAMODB
        });
        // This allows to customize the endpoint policy
        dynamoDbEndpoint.addToPolicy(new iam.PolicyStatement({
            principals: [new iam.AnyPrincipal()],
            actions: ['dynamodb:DescribeTable', 'dynamodb:ListTables'],
            resources: ['*'],
        }));
        // Add an interface endpoint
        const ecrDockerEndpoint = vpc.addInterfaceEndpoint('EcrDockerEndpoint', {
            service: ec2.InterfaceVpcEndpointAwsService.ECR_DOCKER
        });
        // When working with an interface endpoint, use the connections object to
        // allow traffic to flow to the endpoint.
        ecrDockerEndpoint.connections.allowDefaultPortFromAnyIpv4();
        /// !hide
    }
}
new VpcEndpointStack(app, 'aws-cdk-ec2-vpc-endpoint');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcudnBjLWVuZHBvaW50LmxpdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLnZwYy1lbmRwb2ludC5saXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx3Q0FBeUM7QUFDekMscUNBQXNDO0FBQ3RDLDhCQUErQjtBQUUvQixNQUFNLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUUxQixNQUFNLGdCQUFpQixTQUFRLEdBQUcsQ0FBQyxLQUFLO0lBQ3RDLFlBQVksS0FBYyxFQUFFLEVBQVUsRUFBRSxLQUFzQjtRQUM1RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUV4QixTQUFTO1FBQ1QsOENBQThDO1FBQzlDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsQ0FBQyxJQUFJLEVBQUUsT0FBTyxFQUFFO1lBQ3JDLGdCQUFnQixFQUFFO2dCQUNoQixFQUFFLEVBQUU7b0JBQ0YsT0FBTyxFQUFFLEdBQUcsQ0FBQyw0QkFBNEIsQ0FBQyxFQUFFO2lCQUM3QzthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsMERBQTBEO1FBQzFELE1BQU0sZ0JBQWdCLEdBQUcsR0FBRyxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixFQUFFO1lBQ2xFLE9BQU8sRUFBRSxHQUFHLENBQUMsNEJBQTRCLENBQUMsUUFBUTtTQUNuRCxDQUFDLENBQUM7UUFFSCwrQ0FBK0M7UUFDL0MsZ0JBQWdCLENBQUMsV0FBVyxDQUMxQixJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7WUFDdEIsVUFBVSxFQUFFLENBQUMsSUFBSSxHQUFHLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDcEMsT0FBTyxFQUFFLENBQUMsd0JBQXdCLEVBQUUscUJBQXFCLENBQUM7WUFDMUQsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDO1NBQ25CLENBQUMsQ0FBQyxDQUFDO1FBRUosNEJBQTRCO1FBQzVCLE1BQU0saUJBQWlCLEdBQUcsR0FBRyxDQUFDLG9CQUFvQixDQUFDLG1CQUFtQixFQUFFO1lBQ3RFLE9BQU8sRUFBRSxHQUFHLENBQUMsOEJBQThCLENBQUMsVUFBVTtTQUN2RCxDQUFDLENBQUM7UUFFSCx5RUFBeUU7UUFDekUseUNBQXlDO1FBQ3pDLGlCQUFpQixDQUFDLFdBQVcsQ0FBQywyQkFBMkIsRUFBRSxDQUFDO1FBQzVELFNBQVM7SUFDWCxDQUFDO0NBQ0Y7QUFFRCxJQUFJLGdCQUFnQixDQUFDLEdBQUcsRUFBRSwwQkFBMEIsQ0FBQyxDQUFDO0FBQ3RELEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpYW0gPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtaWFtJyk7XG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY29yZScpO1xuaW1wb3J0IGVjMiA9IHJlcXVpcmUoJy4uL2xpYicpO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG5jbGFzcyBWcGNFbmRwb2ludFN0YWNrIGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5BcHAsIGlkOiBzdHJpbmcsIHByb3BzPzogY2RrLlN0YWNrUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHByb3BzKTtcblxuICAgIC8vLyAhc2hvd1xuICAgIC8vIEFkZCBnYXRld2F5IGVuZHBvaW50cyB3aGVuIGNyZWF0aW5nIHRoZSBWUENcbiAgICBjb25zdCB2cGMgPSBuZXcgZWMyLlZwYyh0aGlzLCAnTXlWcGMnLCB7XG4gICAgICBnYXRld2F5RW5kcG9pbnRzOiB7XG4gICAgICAgIFMzOiB7XG4gICAgICAgICAgc2VydmljZTogZWMyLkdhdGV3YXlWcGNFbmRwb2ludEF3c1NlcnZpY2UuUzNcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0pO1xuXG4gICAgLy8gQWx0ZXJuYXRpdmVseSBnYXRld2F5IGVuZHBvaW50cyBjYW4gYmUgYWRkZWQgb24gdGhlIFZQQ1xuICAgIGNvbnN0IGR5bmFtb0RiRW5kcG9pbnQgPSB2cGMuYWRkR2F0ZXdheUVuZHBvaW50KCdEeW5hbW9EYkVuZHBvaW50Jywge1xuICAgICAgc2VydmljZTogZWMyLkdhdGV3YXlWcGNFbmRwb2ludEF3c1NlcnZpY2UuRFlOQU1PREJcbiAgICB9KTtcblxuICAgIC8vIFRoaXMgYWxsb3dzIHRvIGN1c3RvbWl6ZSB0aGUgZW5kcG9pbnQgcG9saWN5XG4gICAgZHluYW1vRGJFbmRwb2ludC5hZGRUb1BvbGljeShcbiAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHsgLy8gUmVzdHJpY3QgdG8gbGlzdGluZyBhbmQgZGVzY3JpYmluZyB0YWJsZXNcbiAgICAgICAgcHJpbmNpcGFsczogW25ldyBpYW0uQW55UHJpbmNpcGFsKCldLFxuICAgICAgICBhY3Rpb25zOiBbJ2R5bmFtb2RiOkRlc2NyaWJlVGFibGUnLCAnZHluYW1vZGI6TGlzdFRhYmxlcyddLFxuICAgICAgICByZXNvdXJjZXM6IFsnKiddLFxuICAgIH0pKTtcblxuICAgIC8vIEFkZCBhbiBpbnRlcmZhY2UgZW5kcG9pbnRcbiAgICBjb25zdCBlY3JEb2NrZXJFbmRwb2ludCA9IHZwYy5hZGRJbnRlcmZhY2VFbmRwb2ludCgnRWNyRG9ja2VyRW5kcG9pbnQnLCB7XG4gICAgICBzZXJ2aWNlOiBlYzIuSW50ZXJmYWNlVnBjRW5kcG9pbnRBd3NTZXJ2aWNlLkVDUl9ET0NLRVJcbiAgICB9KTtcblxuICAgIC8vIFdoZW4gd29ya2luZyB3aXRoIGFuIGludGVyZmFjZSBlbmRwb2ludCwgdXNlIHRoZSBjb25uZWN0aW9ucyBvYmplY3QgdG9cbiAgICAvLyBhbGxvdyB0cmFmZmljIHRvIGZsb3cgdG8gdGhlIGVuZHBvaW50LlxuICAgIGVjckRvY2tlckVuZHBvaW50LmNvbm5lY3Rpb25zLmFsbG93RGVmYXVsdFBvcnRGcm9tQW55SXB2NCgpO1xuICAgIC8vLyAhaGlkZVxuICB9XG59XG5cbm5ldyBWcGNFbmRwb2ludFN0YWNrKGFwcCwgJ2F3cy1jZGstZWMyLXZwYy1lbmRwb2ludCcpO1xuYXBwLnN5bnRoKCk7XG4iXX0=