"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
class ConstructThatTakesAVpc extends cdk.Construct {
    constructor(scope, id, _props) {
        super(scope, id);
        // new ec2.CfnInstance(this, 'Instance', {
        //   subnetId: props.vpc.privateSubnets[0].subnetId,
        //   imageId: new ec2.AmazonLinuxImage().getImage(this).imageId,
        // });
    }
}
/// !show
/**
 * Stack1 creates the VPC
 */
class Stack1 extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.vpc = new ec2.Vpc(this, 'VPC');
    }
}
/**
 * Stack2 consumes the VPC
 */
class Stack2 extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        // Pass the VPC to a construct that needs it
        new ConstructThatTakesAVpc(this, 'Construct', {
            vpc: props.vpc
        });
    }
}
const stack1 = new Stack1(app, 'Stack1');
const stack2 = new Stack2(app, 'Stack2', {
    vpc: stack1.vpc,
});
/// !hide
Array.isArray(stack2);
app.synth();
//# sourceMappingURL=data:application/json;base64,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