"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const cdk = require("@aws-cdk/core");
const ec2 = require("../lib");
const app = new cdk.App();
// we associate this stack with an explicit environment since this is required by the
// environmental context provider used in `fromLookup`. CDK_INTEG_XXX are set
// when producing the .expected file and CDK_DEFAULT_XXX is passed in through from
// the CLI in actual deployment.
const env = {
    account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
    region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION
};
const stack = new cdk.Stack(app, 'aws-cdk-ec2-import', { env });
/// !show
const vpc = ec2.Vpc.fromLookup(stack, 'VPC', {
    // This imports the default VPC but you can also
    // specify a 'vpcName' or 'tags'.
    isDefault: true
});
/// !hide
// The only thing in this library that takes a VPC as an argument :)
new ec2.SecurityGroup(stack, 'SecurityGroup', {
    vpc
});
// Try subnet selection
new cdk.CfnOutput(stack, 'PublicSubnets', { value: 'ids:' + vpc.publicSubnets.map(s => s.subnetId).join(',') });
new cdk.CfnOutput(stack, 'PrivateSubnets', { value: 'ids:' + vpc.privateSubnets.map(s => s.subnetId).join(',') });
// Route table IDs
new cdk.CfnOutput(stack, 'PublicRouteTables', { value: 'ids: ' + vpc.publicSubnets.map(s => s.routeTable.routeTableId).join(', ') });
app.synth();
//# sourceMappingURL=data:application/json;base64,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