"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ec2 = require("../lib");
/// !show
// Pick a Windows edition to use
const windows = new ec2.WindowsImage(ec2.WindowsVersion.WINDOWS_SERVER_2019_ENGLISH_FULL_BASE);
// Pick the right Amazon Linux edition. All arguments shown are optional
// and will default to these values when omitted.
const amznLinux = new ec2.AmazonLinuxImage({
    generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX,
    edition: ec2.AmazonLinuxEdition.STANDARD,
    virtualization: ec2.AmazonLinuxVirt.HVM,
    storage: ec2.AmazonLinuxStorage.GENERAL_PURPOSE,
});
// For other custom (Linux) images, instantiate a `GenericLinuxImage` with
// a map giving the AMI to in for each region:
const linux = new ec2.GenericLinuxImage({
    'us-east-1': 'ami-97785bed',
    'eu-west-1': 'ami-12345678',
});
// For other custom (Windows) images, instantiate a `GenericWindowsImage` with
// a map giving the AMI to in for each region:
const genericWindows = new ec2.GenericWindowsImage({
    'us-east-1': 'ami-97785bed',
    'eu-west-1': 'ami-12345678',
});
/// !hide
Array.isArray(windows);
Array.isArray(amznLinux);
Array.isArray(linux);
Array.isArray(genericWindows);
//# sourceMappingURL=data:application/json;base64,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