import { OperatingSystemType } from "./machine-image";
/**
 * Options when constructing UserData for Linux
 */
export interface LinuxUserDataOptions {
    /**
     * Shebang for the UserData script
     *
     * @default "#!/bin/bash"
     */
    readonly shebang?: string;
}
/**
 * Instance User Data
 */
export declare abstract class UserData {
    /**
     * Create a userdata object for Linux hosts
     */
    static forLinux(options?: LinuxUserDataOptions): UserData;
    /**
     * Create a userdata object for Windows hosts
     */
    static forWindows(): UserData;
    /**
     * Create a userdata object with custom content
     */
    static custom(content: string): UserData;
    static forOperatingSystem(os: OperatingSystemType): UserData;
    /**
     * Add one or more commands to the user data
     */
    abstract addCommands(...commands: string[]): void;
    /**
     * Render the UserData for use in a construct
     */
    abstract render(): string;
}
