"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * What class and generation of instance to use
 *
 * We have both symbolic and concrete enums for every type.
 *
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 */
var InstanceClass;
(function (InstanceClass) {
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["STANDARD3"] = "m3";
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["M3"] = "m3";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["STANDARD4"] = "m4";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["M4"] = "m4";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["STANDARD5"] = "m5";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["M5"] = "m5";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["STANDARD5_NVME_DRIVE"] = "m5d";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["M5D"] = "m5d";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["STANDARD5_AMD_NVME_DRIVE"] = "m5ad";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["M5AD"] = "m5ad";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["MEMORY3"] = "r3";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["R3"] = "r3";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["MEMORY4"] = "r4";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["R4"] = "r4";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["MEMORY5"] = "r5";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["R5"] = "r5";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["MEMORY5_AMD"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["R5A"] = "r5a";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["COMPUTE3"] = "c3";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["C3"] = "c3";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["COMPUTE4"] = "c4";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["C4"] = "c4";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["COMPUTE5"] = "c5";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["C5"] = "c5";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["COMPUTE5_NVME_DRIVE"] = "c5d";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["C5D"] = "c5d";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["COMPUTE5_HIGH_PERFORMANCE"] = "c5n";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["C5N"] = "c5n";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["STORAGE2"] = "d2";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["D2"] = "d2";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["STORAGE_COMPUTE_1"] = "h1";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["H1"] = "h1";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["IO3"] = "i3";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["I3"] = "i3";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["IO3_DENSE_NVME_DRIVE"] = "i3en";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["I3EN"] = "i3en";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["BURSTABLE2"] = "t2";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["T2"] = "t2";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["BURSTABLE3"] = "t3";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["T3"] = "t3";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["BURSTABLE3_AMD"] = "t3a";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["T3A"] = "t3a";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["MEMORY_INTENSIVE_1"] = "x1";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1"] = "x1";
    /**
     * Memory-intensive instances, extended, 1st generation
     */
    InstanceClass["MEMORY_INTENSIVE_1_EXTENDED"] = "x1e";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1E"] = "x1e";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["FPGA1"] = "f1";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["F1"] = "f1";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["GRAPHICS3"] = "g3";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["G3"] = "g3";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["PARALLEL2"] = "p2";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["P2"] = "p2";
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    InstanceClass["PARALLEL3"] = "p3";
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    InstanceClass["P3"] = "p3";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["ARM1"] = "a1";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["A1"] = "a1";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["HIGH_COMPUTE_MEMORY1"] = "z1d";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["Z1D"] = "z1d";
})(InstanceClass = exports.InstanceClass || (exports.InstanceClass = {}));
/**
 * What size of instance to use
 */
var InstanceSize;
(function (InstanceSize) {
    InstanceSize["NANO"] = "nano";
    InstanceSize["MICRO"] = "micro";
    InstanceSize["SMALL"] = "small";
    InstanceSize["MEDIUM"] = "medium";
    InstanceSize["LARGE"] = "large";
    InstanceSize["XLARGE"] = "xlarge";
    InstanceSize["XLARGE2"] = "2xlarge";
    InstanceSize["XLARGE4"] = "4xlarge";
    InstanceSize["XLARGE8"] = "8xlarge";
    InstanceSize["XLARGE9"] = "9xlarge";
    InstanceSize["XLARGE10"] = "10xlarge";
    InstanceSize["XLARGE12"] = "12xlarge";
    InstanceSize["XLARGE16"] = "16xlarge";
    InstanceSize["XLARGE18"] = "18xlarge";
    InstanceSize["XLARGE24"] = "24xlarge";
    InstanceSize["XLARGE32"] = "32xlarge";
    InstanceSize["METAL"] = "metal";
})(InstanceSize = exports.InstanceSize || (exports.InstanceSize = {}));
/**
 * Instance type for EC2 instances
 *
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 */
class InstanceType {
    constructor(instanceTypeIdentifier) {
        this.instanceTypeIdentifier = instanceTypeIdentifier;
    }
    /**
     * Instance type for EC2 instances
     *
     * This class takes a combination of a class and size.
     *
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     */
    static of(instanceClass, instanceSize) {
        return new InstanceType(`${instanceClass}.${instanceSize}`);
    }
    /**
     * Return the instance type as a dotted string
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
}
exports.InstanceType = InstanceType;
//# sourceMappingURL=data:application/json;base64,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