import cdk = require('@aws-cdk/core');
/**
 * Properties for defining a `AWS::EC2::CapacityReservation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
 */
export interface CfnCapacityReservationProps {
    /**
     * `AWS::EC2::CapacityReservation.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-availabilityzone
     */
    readonly availabilityZone: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceCount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancecount
     */
    readonly instanceCount: number;
    /**
     * `AWS::EC2::CapacityReservation.InstancePlatform`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instanceplatform
     */
    readonly instancePlatform: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::EC2::CapacityReservation.EbsOptimized`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ebsoptimized
     */
    readonly ebsOptimized?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservation.EndDate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddate
     */
    readonly endDate?: string;
    /**
     * `AWS::EC2::CapacityReservation.EndDateType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddatetype
     */
    readonly endDateType?: string;
    /**
     * `AWS::EC2::CapacityReservation.EphemeralStorage`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ephemeralstorage
     */
    readonly ephemeralStorage?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservation.InstanceMatchCriteria`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancematchcriteria
     */
    readonly instanceMatchCriteria?: string;
    /**
     * `AWS::EC2::CapacityReservation.TagSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tagspecifications
     */
    readonly tagSpecifications?: Array<CfnCapacityReservation.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::CapacityReservation.Tenancy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tenancy
     */
    readonly tenancy?: string;
}
/**
 * A CloudFormation `AWS::EC2::CapacityReservation`
 *
 * @cloudformationResource AWS::EC2::CapacityReservation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html
 */
export declare class CfnCapacityReservation extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::CapacityReservation";
    /**
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @cloudformationAttribute AvailableInstanceCount
     */
    readonly attrAvailableInstanceCount: number;
    /**
     * @cloudformationAttribute InstanceType
     */
    readonly attrInstanceType: string;
    /**
     * @cloudformationAttribute Tenancy
     */
    readonly attrTenancy: string;
    /**
     * @cloudformationAttribute TotalInstanceCount
     */
    readonly attrTotalInstanceCount: number;
    /**
     * `AWS::EC2::CapacityReservation.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-availabilityzone
     */
    availabilityZone: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceCount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancecount
     */
    instanceCount: number;
    /**
     * `AWS::EC2::CapacityReservation.InstancePlatform`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instanceplatform
     */
    instancePlatform: string;
    /**
     * `AWS::EC2::CapacityReservation.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancetype
     */
    instanceType: string;
    /**
     * `AWS::EC2::CapacityReservation.EbsOptimized`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ebsoptimized
     */
    ebsOptimized: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservation.EndDate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddate
     */
    endDate: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.EndDateType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-enddatetype
     */
    endDateType: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.EphemeralStorage`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-ephemeralstorage
     */
    ephemeralStorage: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservation.InstanceMatchCriteria`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-instancematchcriteria
     */
    instanceMatchCriteria: string | undefined;
    /**
     * `AWS::EC2::CapacityReservation.TagSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tagspecifications
     */
    tagSpecifications: Array<CfnCapacityReservation.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::CapacityReservation.Tenancy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-capacityreservation.html#cfn-ec2-capacityreservation-tenancy
     */
    tenancy: string | undefined;
    /**
     * Create a new `AWS::EC2::CapacityReservation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCapacityReservationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCapacityReservation {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html
     */
    interface TagSpecificationProperty {
        /**
         * `CfnCapacityReservation.TagSpecificationProperty.ResourceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html#cfn-ec2-capacityreservation-tagspecification-resourcetype
         */
        readonly resourceType?: string;
        /**
         * `CfnCapacityReservation.TagSpecificationProperty.Tags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-capacityreservation-tagspecification.html#cfn-ec2-capacityreservation-tagspecification-tags
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnAuthorizationRule`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html
 */
export interface CfnClientVpnAuthorizationRuleProps {
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.ClientVpnEndpointId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-clientvpnendpointid
     */
    readonly clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.TargetNetworkCidr`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-targetnetworkcidr
     */
    readonly targetNetworkCidr: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AccessGroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-accessgroupid
     */
    readonly accessGroupId?: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AuthorizeAllGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-authorizeallgroups
     */
    readonly authorizeAllGroups?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnAuthorizationRule`
 *
 * @cloudformationResource AWS::EC2::ClientVpnAuthorizationRule
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html
 */
export declare class CfnClientVpnAuthorizationRule extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnAuthorizationRule";
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.ClientVpnEndpointId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-clientvpnendpointid
     */
    clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.TargetNetworkCidr`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-targetnetworkcidr
     */
    targetNetworkCidr: string;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AccessGroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-accessgroupid
     */
    accessGroupId: string | undefined;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.AuthorizeAllGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-authorizeallgroups
     */
    authorizeAllGroups: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnAuthorizationRule.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnauthorizationrule.html#cfn-ec2-clientvpnauthorizationrule-description
     */
    description: string | undefined;
    /**
     * Create a new `AWS::EC2::ClientVpnAuthorizationRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnAuthorizationRuleProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnEndpoint`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export interface CfnClientVpnEndpointProps {
    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    readonly authenticationOptions: Array<CfnClientVpnEndpoint.ClientAuthenticationRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     */
    readonly clientCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    readonly connectionLogOptions: CfnClientVpnEndpoint.ConnectionLogOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     */
    readonly serverCertificateArn: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     */
    readonly dnsServers?: string[];
    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    readonly splitTunnel?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    readonly tagSpecifications?: Array<CfnClientVpnEndpoint.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     */
    readonly transportProtocol?: string;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnEndpoint`
 *
 * @cloudformationResource AWS::EC2::ClientVpnEndpoint
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html
 */
export declare class CfnClientVpnEndpoint extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnEndpoint";
    /**
     * `AWS::EC2::ClientVpnEndpoint.AuthenticationOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-authenticationoptions
     */
    authenticationOptions: Array<CfnClientVpnEndpoint.ClientAuthenticationRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ClientCidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-clientcidrblock
     */
    clientCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ConnectionLogOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-connectionlogoptions
     */
    connectionLogOptions: CfnClientVpnEndpoint.ConnectionLogOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::ClientVpnEndpoint.ServerCertificateArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-servercertificatearn
     */
    serverCertificateArn: string;
    /**
     * `AWS::EC2::ClientVpnEndpoint.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.DnsServers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-dnsservers
     */
    dnsServers: string[] | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.SplitTunnel`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-splittunnel
     */
    splitTunnel: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TagSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-tagspecifications
     */
    tagSpecifications: Array<CfnClientVpnEndpoint.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::ClientVpnEndpoint.TransportProtocol`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnendpoint.html#cfn-ec2-clientvpnendpoint-transportprotocol
     */
    transportProtocol: string | undefined;
    /**
     * Create a new `AWS::EC2::ClientVpnEndpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnEndpointProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnClientVpnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html
     */
    interface CertificateAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty.ClientRootCertificateChainArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-certificateauthenticationrequest.html#cfn-ec2-clientvpnendpoint-certificateauthenticationrequest-clientrootcertificatechainarn
         */
        readonly clientRootCertificateChainArn: string;
    }
}
export declare namespace CfnClientVpnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html
     */
    interface ClientAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.ActiveDirectory`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-activedirectory
         */
        readonly activeDirectory?: CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty | cdk.IResolvable;
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.MutualAuthentication`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-mutualauthentication
         */
        readonly mutualAuthentication?: CfnClientVpnEndpoint.CertificateAuthenticationRequestProperty | cdk.IResolvable;
        /**
         * `CfnClientVpnEndpoint.ClientAuthenticationRequestProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-clientauthenticationrequest.html#cfn-ec2-clientvpnendpoint-clientauthenticationrequest-type
         */
        readonly type: string;
    }
}
export declare namespace CfnClientVpnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html
     */
    interface ConnectionLogOptionsProperty {
        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogGroup`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchloggroup
         */
        readonly cloudwatchLogGroup?: string;
        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.CloudwatchLogStream`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-cloudwatchlogstream
         */
        readonly cloudwatchLogStream?: string;
        /**
         * `CfnClientVpnEndpoint.ConnectionLogOptionsProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-connectionlogoptions.html#cfn-ec2-clientvpnendpoint-connectionlogoptions-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnClientVpnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html
     */
    interface DirectoryServiceAuthenticationRequestProperty {
        /**
         * `CfnClientVpnEndpoint.DirectoryServiceAuthenticationRequestProperty.DirectoryId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-directoryserviceauthenticationrequest.html#cfn-ec2-clientvpnendpoint-directoryserviceauthenticationrequest-directoryid
         */
        readonly directoryId: string;
    }
}
export declare namespace CfnClientVpnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html
     */
    interface TagSpecificationProperty {
        /**
         * `CfnClientVpnEndpoint.TagSpecificationProperty.ResourceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-resourcetype
         */
        readonly resourceType: string;
        /**
         * `CfnClientVpnEndpoint.TagSpecificationProperty.Tags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-clientvpnendpoint-tagspecification.html#cfn-ec2-clientvpnendpoint-tagspecification-tags
         */
        readonly tags: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnRoute`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
 */
export interface CfnClientVpnRouteProps {
    /**
     * `AWS::EC2::ClientVpnRoute.ClientVpnEndpointId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-clientvpnendpointid
     */
    readonly clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.DestinationCidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-destinationcidrblock
     */
    readonly destinationCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnRoute.TargetVpcSubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-targetvpcsubnetid
     */
    readonly targetVpcSubnetId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-description
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnRoute`
 *
 * @cloudformationResource AWS::EC2::ClientVpnRoute
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
 */
export declare class CfnClientVpnRoute extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnRoute";
    /**
     * `AWS::EC2::ClientVpnRoute.ClientVpnEndpointId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-clientvpnendpointid
     */
    clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.DestinationCidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-destinationcidrblock
     */
    destinationCidrBlock: string;
    /**
     * `AWS::EC2::ClientVpnRoute.TargetVpcSubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-targetvpcsubnetid
     */
    targetVpcSubnetId: string;
    /**
     * `AWS::EC2::ClientVpnRoute.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html#cfn-ec2-clientvpnroute-description
     */
    description: string | undefined;
    /**
     * Create a new `AWS::EC2::ClientVpnRoute`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnRouteProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::ClientVpnTargetNetworkAssociation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html
 */
export interface CfnClientVpnTargetNetworkAssociationProps {
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.ClientVpnEndpointId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-clientvpnendpointid
     */
    readonly clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-subnetid
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::ClientVpnTargetNetworkAssociation`
 *
 * @cloudformationResource AWS::EC2::ClientVpnTargetNetworkAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html
 */
export declare class CfnClientVpnTargetNetworkAssociation extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::ClientVpnTargetNetworkAssociation";
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.ClientVpnEndpointId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-clientvpnendpointid
     */
    clientVpnEndpointId: string;
    /**
     * `AWS::EC2::ClientVpnTargetNetworkAssociation.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpntargetnetworkassociation.html#cfn-ec2-clientvpntargetnetworkassociation-subnetid
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::ClientVpnTargetNetworkAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClientVpnTargetNetworkAssociationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::CustomerGateway`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html
 */
export interface CfnCustomerGatewayProps {
    /**
     * `AWS::EC2::CustomerGateway.BgpAsn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
     */
    readonly bgpAsn: number;
    /**
     * `AWS::EC2::CustomerGateway.IpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
     */
    readonly ipAddress: string;
    /**
     * `AWS::EC2::CustomerGateway.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
     */
    readonly type: string;
    /**
     * `AWS::EC2::CustomerGateway.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::CustomerGateway`
 *
 * @cloudformationResource AWS::EC2::CustomerGateway
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html
 */
export declare class CfnCustomerGateway extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::CustomerGateway";
    /**
     * `AWS::EC2::CustomerGateway.BgpAsn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-bgpasn
     */
    bgpAsn: number;
    /**
     * `AWS::EC2::CustomerGateway.IpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-ipaddress
     */
    ipAddress: string;
    /**
     * `AWS::EC2::CustomerGateway.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-type
     */
    type: string;
    /**
     * `AWS::EC2::CustomerGateway.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-customer-gateway.html#cfn-ec2-customergateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::CustomerGateway`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCustomerGatewayProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::DHCPOptions`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html
 */
export interface CfnDHCPOptionsProps {
    /**
     * `AWS::EC2::DHCPOptions.DomainName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainname
     */
    readonly domainName?: string;
    /**
     * `AWS::EC2::DHCPOptions.DomainNameServers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainnameservers
     */
    readonly domainNameServers?: string[];
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNameServers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnameservers
     */
    readonly netbiosNameServers?: string[];
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNodeType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnodetype
     */
    readonly netbiosNodeType?: number;
    /**
     * `AWS::EC2::DHCPOptions.NtpServers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-ntpservers
     */
    readonly ntpServers?: string[];
    /**
     * `AWS::EC2::DHCPOptions.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::DHCPOptions`
 *
 * @cloudformationResource AWS::EC2::DHCPOptions
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html
 */
export declare class CfnDHCPOptions extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::DHCPOptions";
    /**
     * `AWS::EC2::DHCPOptions.DomainName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainname
     */
    domainName: string | undefined;
    /**
     * `AWS::EC2::DHCPOptions.DomainNameServers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-domainnameservers
     */
    domainNameServers: string[] | undefined;
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNameServers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnameservers
     */
    netbiosNameServers: string[] | undefined;
    /**
     * `AWS::EC2::DHCPOptions.NetbiosNodeType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-netbiosnodetype
     */
    netbiosNodeType: number | undefined;
    /**
     * `AWS::EC2::DHCPOptions.NtpServers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-ntpservers
     */
    ntpServers: string[] | undefined;
    /**
     * `AWS::EC2::DHCPOptions.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-dhcp-options.html#cfn-ec2-dhcpoptions-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::DHCPOptions`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDHCPOptionsProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::EC2Fleet`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export interface CfnEC2FleetProps {
    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
     */
    readonly launchTemplateConfigs: Array<CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
     */
    readonly targetCapacitySpecification: CfnEC2Fleet.TargetCapacitySpecificationRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
     */
    readonly excessCapacityTerminationPolicy?: string;
    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
     */
    readonly onDemandOptions?: CfnEC2Fleet.OnDemandOptionsRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
     */
    readonly replaceUnhealthyInstances?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
     */
    readonly spotOptions?: CfnEC2Fleet.SpotOptionsRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
     */
    readonly tagSpecifications?: Array<CfnEC2Fleet.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
     */
    readonly terminateInstancesWithExpiration?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
     */
    readonly type?: string;
    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
     */
    readonly validFrom?: string;
    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
     */
    readonly validUntil?: string;
}
/**
 * A CloudFormation `AWS::EC2::EC2Fleet`
 *
 * @cloudformationResource AWS::EC2::EC2Fleet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html
 */
export declare class CfnEC2Fleet extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EC2Fleet";
    /**
     * `AWS::EC2::EC2Fleet.LaunchTemplateConfigs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-launchtemplateconfigs
     */
    launchTemplateConfigs: Array<CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.TargetCapacitySpecification`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-targetcapacityspecification
     */
    targetCapacitySpecification: CfnEC2Fleet.TargetCapacitySpecificationRequestProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::EC2Fleet.ExcessCapacityTerminationPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-excesscapacityterminationpolicy
     */
    excessCapacityTerminationPolicy: string | undefined;
    /**
     * `AWS::EC2::EC2Fleet.OnDemandOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-ondemandoptions
     */
    onDemandOptions: CfnEC2Fleet.OnDemandOptionsRequestProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.ReplaceUnhealthyInstances`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-replaceunhealthyinstances
     */
    replaceUnhealthyInstances: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.SpotOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-spotoptions
     */
    spotOptions: CfnEC2Fleet.SpotOptionsRequestProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.TagSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-tagspecifications
     */
    tagSpecifications: Array<CfnEC2Fleet.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.TerminateInstancesWithExpiration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-terminateinstanceswithexpiration
     */
    terminateInstancesWithExpiration: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::EC2Fleet.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-type
     */
    type: string | undefined;
    /**
     * `AWS::EC2::EC2Fleet.ValidFrom`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validfrom
     */
    validFrom: string | undefined;
    /**
     * `AWS::EC2::EC2Fleet.ValidUntil`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-ec2fleet.html#cfn-ec2-ec2fleet-validuntil
     */
    validUntil: string | undefined;
    /**
     * Create a new `AWS::EC2::EC2Fleet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEC2FleetProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEC2Fleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html
     */
    interface FleetLaunchTemplateConfigRequestProperty {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.LaunchTemplateSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-launchtemplatespecification
         */
        readonly launchTemplateSpecification?: CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty | cdk.IResolvable;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateConfigRequestProperty.Overrides`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateconfigrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateconfigrequest-overrides
         */
        readonly overrides?: Array<CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnEC2Fleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html
     */
    interface FleetLaunchTemplateOverridesRequestProperty {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.AvailabilityZone`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.MaxPrice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-maxprice
         */
        readonly maxPrice?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.Priority`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-priority
         */
        readonly priority?: number;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.SubnetId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-subnetid
         */
        readonly subnetId?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateOverridesRequestProperty.WeightedCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplateoverridesrequest-weightedcapacity
         */
        readonly weightedCapacity?: number;
    }
}
export declare namespace CfnEC2Fleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html
     */
    interface FleetLaunchTemplateSpecificationRequestProperty {
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplateid
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.LaunchTemplateName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-launchtemplatename
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnEC2Fleet.FleetLaunchTemplateSpecificationRequestProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest.html#cfn-ec2-ec2fleet-fleetlaunchtemplatespecificationrequest-version
         */
        readonly version?: string;
    }
}
export declare namespace CfnEC2Fleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html
     */
    interface OnDemandOptionsRequestProperty {
        /**
         * `CfnEC2Fleet.OnDemandOptionsRequestProperty.AllocationStrategy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-ondemandoptionsrequest.html#cfn-ec2-ec2fleet-ondemandoptionsrequest-allocationstrategy
         */
        readonly allocationStrategy?: string;
    }
}
export declare namespace CfnEC2Fleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html
     */
    interface SpotOptionsRequestProperty {
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.AllocationStrategy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-allocationstrategy
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstanceInterruptionBehavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instanceinterruptionbehavior
         */
        readonly instanceInterruptionBehavior?: string;
        /**
         * `CfnEC2Fleet.SpotOptionsRequestProperty.InstancePoolsToUseCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-spotoptionsrequest.html#cfn-ec2-ec2fleet-spotoptionsrequest-instancepoolstousecount
         */
        readonly instancePoolsToUseCount?: number;
    }
}
export declare namespace CfnEC2Fleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html
     */
    interface TagRequestProperty {
        /**
         * `CfnEC2Fleet.TagRequestProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html#cfn-ec2-ec2fleet-tagrequest-key
         */
        readonly key?: string;
        /**
         * `CfnEC2Fleet.TagRequestProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagrequest.html#cfn-ec2-ec2fleet-tagrequest-value
         */
        readonly value?: string;
    }
}
export declare namespace CfnEC2Fleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html
     */
    interface TagSpecificationProperty {
        /**
         * `CfnEC2Fleet.TagSpecificationProperty.ResourceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-resourcetype
         */
        readonly resourceType?: string;
        /**
         * `CfnEC2Fleet.TagSpecificationProperty.Tags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-tagspecification.html#cfn-ec2-ec2fleet-tagspecification-tags
         */
        readonly tags?: CfnEC2Fleet.TagRequestProperty[];
    }
}
export declare namespace CfnEC2Fleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html
     */
    interface TargetCapacitySpecificationRequestProperty {
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.DefaultTargetCapacityType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-defaulttargetcapacitytype
         */
        readonly defaultTargetCapacityType?: string;
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.OnDemandTargetCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-ondemandtargetcapacity
         */
        readonly onDemandTargetCapacity?: number;
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.SpotTargetCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-spottargetcapacity
         */
        readonly spotTargetCapacity?: number;
        /**
         * `CfnEC2Fleet.TargetCapacitySpecificationRequestProperty.TotalTargetCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ec2fleet-targetcapacityspecificationrequest.html#cfn-ec2-ec2fleet-targetcapacityspecificationrequest-totaltargetcapacity
         */
        readonly totalTargetCapacity: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::EIP`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html
 */
export interface CfnEIPProps {
    /**
     * `AWS::EC2::EIP.Domain`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-domain
     */
    readonly domain?: string;
    /**
     * `AWS::EC2::EIP.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-instanceid
     */
    readonly instanceId?: string;
    /**
     * `AWS::EC2::EIP.PublicIpv4Pool`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-publicipv4pool
     */
    readonly publicIpv4Pool?: string;
}
/**
 * A CloudFormation `AWS::EC2::EIP`
 *
 * @cloudformationResource AWS::EC2::EIP
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html
 */
export declare class CfnEIP extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EIP";
    /**
     * @cloudformationAttribute AllocationId
     */
    readonly attrAllocationId: string;
    /**
     * `AWS::EC2::EIP.Domain`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-domain
     */
    domain: string | undefined;
    /**
     * `AWS::EC2::EIP.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-instanceid
     */
    instanceId: string | undefined;
    /**
     * `AWS::EC2::EIP.PublicIpv4Pool`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip.html#cfn-ec2-eip-publicipv4pool
     */
    publicIpv4Pool: string | undefined;
    /**
     * Create a new `AWS::EC2::EIP`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnEIPProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::EIPAssociation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html
 */
export interface CfnEIPAssociationProps {
    /**
     * `AWS::EC2::EIPAssociation.AllocationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-allocationid
     */
    readonly allocationId?: string;
    /**
     * `AWS::EC2::EIPAssociation.EIP`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-eip
     */
    readonly eip?: string;
    /**
     * `AWS::EC2::EIPAssociation.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-instanceid
     */
    readonly instanceId?: string;
    /**
     * `AWS::EC2::EIPAssociation.NetworkInterfaceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-networkinterfaceid
     */
    readonly networkInterfaceId?: string;
    /**
     * `AWS::EC2::EIPAssociation.PrivateIpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-PrivateIpAddress
     */
    readonly privateIpAddress?: string;
}
/**
 * A CloudFormation `AWS::EC2::EIPAssociation`
 *
 * @cloudformationResource AWS::EC2::EIPAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html
 */
export declare class CfnEIPAssociation extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EIPAssociation";
    /**
     * `AWS::EC2::EIPAssociation.AllocationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-allocationid
     */
    allocationId: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.EIP`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-eip
     */
    eip: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-instanceid
     */
    instanceId: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.NetworkInterfaceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-networkinterfaceid
     */
    networkInterfaceId: string | undefined;
    /**
     * `AWS::EC2::EIPAssociation.PrivateIpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-eip-association.html#cfn-ec2-eipassociation-PrivateIpAddress
     */
    privateIpAddress: string | undefined;
    /**
     * Create a new `AWS::EC2::EIPAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnEIPAssociationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::EgressOnlyInternetGateway`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html
 */
export interface CfnEgressOnlyInternetGatewayProps {
    /**
     * `AWS::EC2::EgressOnlyInternetGateway.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
     */
    readonly vpcId: string;
}
/**
 * A CloudFormation `AWS::EC2::EgressOnlyInternetGateway`
 *
 * @cloudformationResource AWS::EC2::EgressOnlyInternetGateway
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html
 */
export declare class CfnEgressOnlyInternetGateway extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::EgressOnlyInternetGateway";
    /**
     * `AWS::EC2::EgressOnlyInternetGateway.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-egressonlyinternetgateway.html#cfn-ec2-egressonlyinternetgateway-vpcid
     */
    vpcId: string;
    /**
     * Create a new `AWS::EC2::EgressOnlyInternetGateway`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEgressOnlyInternetGatewayProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::FlowLog`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html
 */
export interface CfnFlowLogProps {
    /**
     * `AWS::EC2::FlowLog.ResourceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourceid
     */
    readonly resourceId: string;
    /**
     * `AWS::EC2::FlowLog.ResourceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype
     */
    readonly resourceType: string;
    /**
     * `AWS::EC2::FlowLog.TrafficType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype
     */
    readonly trafficType: string;
    /**
     * `AWS::EC2::FlowLog.DeliverLogsPermissionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn
     */
    readonly deliverLogsPermissionArn?: string;
    /**
     * `AWS::EC2::FlowLog.LogDestination`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination
     */
    readonly logDestination?: string;
    /**
     * `AWS::EC2::FlowLog.LogDestinationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype
     */
    readonly logDestinationType?: string;
    /**
     * `AWS::EC2::FlowLog.LogGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-loggroupname
     */
    readonly logGroupName?: string;
}
/**
 * A CloudFormation `AWS::EC2::FlowLog`
 *
 * @cloudformationResource AWS::EC2::FlowLog
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html
 */
export declare class CfnFlowLog extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::FlowLog";
    /**
     * `AWS::EC2::FlowLog.ResourceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourceid
     */
    resourceId: string;
    /**
     * `AWS::EC2::FlowLog.ResourceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-resourcetype
     */
    resourceType: string;
    /**
     * `AWS::EC2::FlowLog.TrafficType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-traffictype
     */
    trafficType: string;
    /**
     * `AWS::EC2::FlowLog.DeliverLogsPermissionArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-deliverlogspermissionarn
     */
    deliverLogsPermissionArn: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogDestination`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestination
     */
    logDestination: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogDestinationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-logdestinationtype
     */
    logDestinationType: string | undefined;
    /**
     * `AWS::EC2::FlowLog.LogGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-flowlog.html#cfn-ec2-flowlog-loggroupname
     */
    logGroupName: string | undefined;
    /**
     * Create a new `AWS::EC2::FlowLog`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFlowLogProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::Host`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
 */
export interface CfnHostProps {
    /**
     * `AWS::EC2::Host.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
     */
    readonly availabilityZone: string;
    /**
     * `AWS::EC2::Host.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::EC2::Host.AutoPlacement`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
     */
    readonly autoPlacement?: string;
    /**
     * `AWS::EC2::Host.HostRecovery`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
     */
    readonly hostRecovery?: string;
}
/**
 * A CloudFormation `AWS::EC2::Host`
 *
 * @cloudformationResource AWS::EC2::Host
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html
 */
export declare class CfnHost extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Host";
    /**
     * `AWS::EC2::Host.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-availabilityzone
     */
    availabilityZone: string;
    /**
     * `AWS::EC2::Host.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-instancetype
     */
    instanceType: string;
    /**
     * `AWS::EC2::Host.AutoPlacement`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-autoplacement
     */
    autoPlacement: string | undefined;
    /**
     * `AWS::EC2::Host.HostRecovery`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-host.html#cfn-ec2-host-hostrecovery
     */
    hostRecovery: string | undefined;
    /**
     * Create a new `AWS::EC2::Host`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnHostProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::Instance`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export interface CfnInstanceProps {
    /**
     * `AWS::EC2::Instance.AdditionalInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     */
    readonly additionalInfo?: string;
    /**
     * `AWS::EC2::Instance.Affinity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     */
    readonly affinity?: string;
    /**
     * `AWS::EC2::Instance.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    readonly blockDeviceMappings?: Array<CfnInstance.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.CpuOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
     */
    readonly cpuOptions?: CfnInstance.CpuOptionsProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.CreditSpecification`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    readonly creditSpecification?: CfnInstance.CreditSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.DisableApiTermination`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    readonly disableApiTermination?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.EbsOptimized`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    readonly ebsOptimized?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    readonly elasticGpuSpecifications?: Array<CfnInstance.ElasticGpuSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    readonly elasticInferenceAccelerators?: Array<CfnInstance.ElasticInferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.HostId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     */
    readonly hostId?: string;
    /**
     * `AWS::EC2::Instance.IamInstanceProfile`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     */
    readonly iamInstanceProfile?: string;
    /**
     * `AWS::EC2::Instance.ImageId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     */
    readonly imageId?: string;
    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     */
    readonly instanceInitiatedShutdownBehavior?: string;
    /**
     * `AWS::EC2::Instance.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     */
    readonly instanceType?: string;
    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     */
    readonly ipv6AddressCount?: number;
    /**
     * `AWS::EC2::Instance.Ipv6Addresses`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    readonly ipv6Addresses?: Array<CfnInstance.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.KernelId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     */
    readonly kernelId?: string;
    /**
     * `AWS::EC2::Instance.KeyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     */
    readonly keyName?: string;
    /**
     * `AWS::EC2::Instance.LaunchTemplate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    readonly launchTemplate?: CfnInstance.LaunchTemplateSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.LicenseSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    readonly licenseSpecifications?: Array<CfnInstance.LicenseSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.Monitoring`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    readonly monitoring?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.NetworkInterfaces`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    readonly networkInterfaces?: Array<CfnInstance.NetworkInterfaceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.PlacementGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     */
    readonly placementGroupName?: string;
    /**
     * `AWS::EC2::Instance.PrivateIpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     */
    readonly privateIpAddress?: string;
    /**
     * `AWS::EC2::Instance.RamdiskId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     */
    readonly ramdiskId?: string;
    /**
     * `AWS::EC2::Instance.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::EC2::Instance.SecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::EC2::Instance.SourceDestCheck`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    readonly sourceDestCheck?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.SsmAssociations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    readonly ssmAssociations?: Array<CfnInstance.SsmAssociationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::Instance.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     */
    readonly subnetId?: string;
    /**
     * `AWS::EC2::Instance.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::Instance.Tenancy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     */
    readonly tenancy?: string;
    /**
     * `AWS::EC2::Instance.UserData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     */
    readonly userData?: string;
    /**
     * `AWS::EC2::Instance.Volumes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    readonly volumes?: Array<CfnInstance.VolumeProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::Instance`
 *
 * @cloudformationResource AWS::EC2::Instance
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html
 */
export declare class CfnInstance extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Instance";
    /**
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @cloudformationAttribute PrivateDnsName
     */
    readonly attrPrivateDnsName: string;
    /**
     * @cloudformationAttribute PrivateIp
     */
    readonly attrPrivateIp: string;
    /**
     * @cloudformationAttribute PublicDnsName
     */
    readonly attrPublicDnsName: string;
    /**
     * @cloudformationAttribute PublicIp
     */
    readonly attrPublicIp: string;
    /**
     * `AWS::EC2::Instance.AdditionalInfo`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-additionalinfo
     */
    additionalInfo: string | undefined;
    /**
     * `AWS::EC2::Instance.Affinity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-affinity
     */
    affinity: string | undefined;
    /**
     * `AWS::EC2::Instance.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::EC2::Instance.BlockDeviceMappings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-blockdevicemappings
     */
    blockDeviceMappings: Array<CfnInstance.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.CpuOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-cpuoptions
     */
    cpuOptions: CfnInstance.CpuOptionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.CreditSpecification`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-creditspecification
     */
    creditSpecification: CfnInstance.CreditSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.DisableApiTermination`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-disableapitermination
     */
    disableApiTermination: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.EbsOptimized`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ebsoptimized
     */
    ebsOptimized: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.ElasticGpuSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticgpuspecifications
     */
    elasticGpuSpecifications: Array<CfnInstance.ElasticGpuSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.ElasticInferenceAccelerators`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-elasticinferenceaccelerators
     */
    elasticInferenceAccelerators: Array<CfnInstance.ElasticInferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.HostId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-hostid
     */
    hostId: string | undefined;
    /**
     * `AWS::EC2::Instance.IamInstanceProfile`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-iaminstanceprofile
     */
    iamInstanceProfile: string | undefined;
    /**
     * `AWS::EC2::Instance.ImageId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-imageid
     */
    imageId: string | undefined;
    /**
     * `AWS::EC2::Instance.InstanceInitiatedShutdownBehavior`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instanceinitiatedshutdownbehavior
     */
    instanceInitiatedShutdownBehavior: string | undefined;
    /**
     * `AWS::EC2::Instance.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-instancetype
     */
    instanceType: string | undefined;
    /**
     * `AWS::EC2::Instance.Ipv6AddressCount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresscount
     */
    ipv6AddressCount: number | undefined;
    /**
     * `AWS::EC2::Instance.Ipv6Addresses`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ipv6addresses
     */
    ipv6Addresses: Array<CfnInstance.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.KernelId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-kernelid
     */
    kernelId: string | undefined;
    /**
     * `AWS::EC2::Instance.KeyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-keyname
     */
    keyName: string | undefined;
    /**
     * `AWS::EC2::Instance.LaunchTemplate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-launchtemplate
     */
    launchTemplate: CfnInstance.LaunchTemplateSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.LicenseSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-licensespecifications
     */
    licenseSpecifications: Array<CfnInstance.LicenseSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.Monitoring`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-monitoring
     */
    monitoring: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.NetworkInterfaces`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-networkinterfaces
     */
    networkInterfaces: Array<CfnInstance.NetworkInterfaceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.PlacementGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-placementgroupname
     */
    placementGroupName: string | undefined;
    /**
     * `AWS::EC2::Instance.PrivateIpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-privateipaddress
     */
    privateIpAddress: string | undefined;
    /**
     * `AWS::EC2::Instance.RamdiskId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ramdiskid
     */
    ramdiskId: string | undefined;
    /**
     * `AWS::EC2::Instance.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::EC2::Instance.SecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-securitygroups
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::EC2::Instance.SourceDestCheck`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-sourcedestcheck
     */
    sourceDestCheck: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.SsmAssociations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-ssmassociations
     */
    ssmAssociations: Array<CfnInstance.SsmAssociationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Instance.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-subnetid
     */
    subnetId: string | undefined;
    /**
     * `AWS::EC2::Instance.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::Instance.Tenancy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-tenancy
     */
    tenancy: string | undefined;
    /**
     * `AWS::EC2::Instance.UserData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-userdata
     */
    userData: string | undefined;
    /**
     * `AWS::EC2::Instance.Volumes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance.html#cfn-ec2-instance-volumes
     */
    volumes: Array<CfnInstance.VolumeProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInstanceProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html
     */
    interface AssociationParameterProperty {
        /**
         * `CfnInstance.AssociationParameterProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-key
         */
        readonly key: string;
        /**
         * `CfnInstance.AssociationParameterProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations-associationparameters.html#cfn-ec2-instance-ssmassociations-associationparameters-value
         */
        readonly value: string[];
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnInstance.BlockDeviceMappingProperty.DeviceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-devicename
         */
        readonly deviceName: string;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.Ebs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-ebs
         */
        readonly ebs?: CfnInstance.EbsProperty | cdk.IResolvable;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.NoDevice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-nodevice
         */
        readonly noDevice?: CfnInstance.NoDeviceProperty | cdk.IResolvable;
        /**
         * `CfnInstance.BlockDeviceMappingProperty.VirtualName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-mapping.html#cfn-ec2-blockdev-mapping-virtualname
         */
        readonly virtualName?: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html
     */
    interface CpuOptionsProperty {
        /**
         * `CfnInstance.CpuOptionsProperty.CoreCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html#cfn-ec2-instance-cpuoptions-corecount
         */
        readonly coreCount?: number;
        /**
         * `CfnInstance.CpuOptionsProperty.ThreadsPerCore`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-cpuoptions.html#cfn-ec2-instance-cpuoptions-threadspercore
         */
        readonly threadsPerCore?: number;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html
     */
    interface CreditSpecificationProperty {
        /**
         * `CfnInstance.CreditSpecificationProperty.CPUCredits`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-creditspecification.html#cfn-ec2-instance-creditspecification-cpucredits
         */
        readonly cpuCredits?: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html
     */
    interface EbsProperty {
        /**
         * `CfnInstance.EbsProperty.DeleteOnTermination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.EbsProperty.Encrypted`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.EbsProperty.Iops`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-iops
         */
        readonly iops?: number;
        /**
         * `CfnInstance.EbsProperty.KmsKeyId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-instance-ebs-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnInstance.EbsProperty.SnapshotId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-snapshotid
         */
        readonly snapshotId?: string;
        /**
         * `CfnInstance.EbsProperty.VolumeSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnInstance.EbsProperty.VolumeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-blockdev-template.html#cfn-ec2-blockdev-template-volumetype
         */
        readonly volumeType?: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html
     */
    interface ElasticGpuSpecificationProperty {
        /**
         * `CfnInstance.ElasticGpuSpecificationProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticgpuspecification.html#cfn-ec2-instance-elasticgpuspecification-type
         */
        readonly type: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html
     */
    interface ElasticInferenceAcceleratorProperty {
        /**
         * `CfnInstance.ElasticInferenceAcceleratorProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-elasticinferenceaccelerator.html#cfn-ec2-instance-elasticinferenceaccelerator-type
         */
        readonly type: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html
     */
    interface InstanceIpv6AddressProperty {
        /**
         * `CfnInstance.InstanceIpv6AddressProperty.Ipv6Address`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-instanceipv6address.html#cfn-ec2-instance-instanceipv6address-ipv6address
         */
        readonly ipv6Address: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html
     */
    interface LaunchTemplateSpecificationProperty {
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplateid
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.LaunchTemplateName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-launchtemplatename
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnInstance.LaunchTemplateSpecificationProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-launchtemplatespecification.html#cfn-ec2-instance-launchtemplatespecification-version
         */
        readonly version: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html
     */
    interface LicenseSpecificationProperty {
        /**
         * `CfnInstance.LicenseSpecificationProperty.LicenseConfigurationArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-licensespecification.html#cfn-ec2-instance-licensespecification-licenseconfigurationarn
         */
        readonly licenseConfigurationArn: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html
     */
    interface NetworkInterfaceProperty {
        /**
         * `CfnInstance.NetworkInterfaceProperty.AssociatePublicIpAddress`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-associatepubip
         */
        readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.DeleteOnTermination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-delete
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-description
         */
        readonly description?: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.DeviceIndex`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-deviceindex
         */
        readonly deviceIndex: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.GroupSet`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-groupset
         */
        readonly groupSet?: string[];
        /**
         * `CfnInstance.NetworkInterfaceProperty.Ipv6AddressCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresscount
         */
        readonly ipv6AddressCount?: number;
        /**
         * `CfnInstance.NetworkInterfaceProperty.Ipv6Addresses`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#cfn-ec2-instance-networkinterface-ipv6addresses
         */
        readonly ipv6Addresses?: Array<CfnInstance.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.NetworkInterfaceId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-network-iface
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddress`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddress
         */
        readonly privateIpAddress?: string;
        /**
         * `CfnInstance.NetworkInterfaceProperty.PrivateIpAddresses`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-privateipaddresses
         */
        readonly privateIpAddresses?: Array<CfnInstance.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnInstance.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-secondprivateip
         */
        readonly secondaryPrivateIpAddressCount?: number;
        /**
         * `CfnInstance.NetworkInterfaceProperty.SubnetId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-iface-embedded.html#aws-properties-ec2-network-iface-embedded-subnetid
         */
        readonly subnetId?: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-nodevice.html
     */
    interface NoDeviceProperty {
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     */
    interface PrivateIpAddressSpecificationProperty {
        /**
         * `CfnInstance.PrivateIpAddressSpecificationProperty.Primary`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        readonly primary: boolean | cdk.IResolvable;
        /**
         * `CfnInstance.PrivateIpAddressSpecificationProperty.PrivateIpAddress`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        readonly privateIpAddress: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html
     */
    interface SsmAssociationProperty {
        /**
         * `CfnInstance.SsmAssociationProperty.AssociationParameters`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-associationparameters
         */
        readonly associationParameters?: Array<CfnInstance.AssociationParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnInstance.SsmAssociationProperty.DocumentName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-ssmassociations.html#cfn-ec2-instance-ssmassociations-documentname
         */
        readonly documentName: string;
    }
}
export declare namespace CfnInstance {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html
     */
    interface VolumeProperty {
        /**
         * `CfnInstance.VolumeProperty.Device`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-device
         */
        readonly device: string;
        /**
         * `CfnInstance.VolumeProperty.VolumeId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-mount-point.html#cfn-ec2-mountpoint-volumeid
         */
        readonly volumeId: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::InternetGateway`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html
 */
export interface CfnInternetGatewayProps {
    /**
     * `AWS::EC2::InternetGateway.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html#cfn-ec2-internetgateway-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::InternetGateway`
 *
 * @cloudformationResource AWS::EC2::InternetGateway
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html
 */
export declare class CfnInternetGateway extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::InternetGateway";
    /**
     * `AWS::EC2::InternetGateway.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-internetgateway.html#cfn-ec2-internetgateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::InternetGateway`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInternetGatewayProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::LaunchTemplate`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export interface CfnLaunchTemplateProps {
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    readonly launchTemplateData?: CfnLaunchTemplate.LaunchTemplateDataProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     */
    readonly launchTemplateName?: string;
}
/**
 * A CloudFormation `AWS::EC2::LaunchTemplate`
 *
 * @cloudformationResource AWS::EC2::LaunchTemplate
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html
 */
export declare class CfnLaunchTemplate extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::LaunchTemplate";
    /**
     * @cloudformationAttribute DefaultVersionNumber
     */
    readonly attrDefaultVersionNumber: string;
    /**
     * @cloudformationAttribute LatestVersionNumber
     */
    readonly attrLatestVersionNumber: string;
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatedata
     */
    launchTemplateData: CfnLaunchTemplate.LaunchTemplateDataProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::LaunchTemplate.LaunchTemplateName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html#cfn-ec2-launchtemplate-launchtemplatename
     */
    launchTemplateName: string | undefined;
    /**
     * Create a new `AWS::EC2::LaunchTemplate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnLaunchTemplateProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.DeviceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-devicename
         */
        readonly deviceName?: string;
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.Ebs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs
         */
        readonly ebs?: CfnLaunchTemplate.EbsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.NoDevice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-nodevice
         */
        readonly noDevice?: string;
        /**
         * `CfnLaunchTemplate.BlockDeviceMappingProperty.VirtualName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping.html#cfn-ec2-launchtemplate-blockdevicemapping-virtualname
         */
        readonly virtualName?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html
     */
    interface CapacityReservationSpecificationProperty {
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationPreference`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationpreference
         */
        readonly capacityReservationPreference?: string;
        /**
         * `CfnLaunchTemplate.CapacityReservationSpecificationProperty.CapacityReservationTarget`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification-capacityreservationtarget
         */
        readonly capacityReservationTarget?: CfnLaunchTemplate.CapacityReservationTargetProperty | cdk.IResolvable;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html
     */
    interface CapacityReservationTargetProperty {
        /**
         * `CfnLaunchTemplate.CapacityReservationTargetProperty.CapacityReservationId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-capacityreservationtarget.html#cfn-ec2-launchtemplate-capacityreservationtarget-capacityreservationid
         */
        readonly capacityReservationId?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html
     */
    interface CpuOptionsProperty {
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.CoreCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-corecount
         */
        readonly coreCount?: number;
        /**
         * `CfnLaunchTemplate.CpuOptionsProperty.ThreadsPerCore`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-cpuoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions-threadspercore
         */
        readonly threadsPerCore?: number;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html
     */
    interface CreditSpecificationProperty {
        /**
         * `CfnLaunchTemplate.CreditSpecificationProperty.CpuCredits`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-creditspecification.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification-cpucredits
         */
        readonly cpuCredits?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html
     */
    interface EbsProperty {
        /**
         * `CfnLaunchTemplate.EbsProperty.DeleteOnTermination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.EbsProperty.Encrypted`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.EbsProperty.Iops`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-iops
         */
        readonly iops?: number;
        /**
         * `CfnLaunchTemplate.EbsProperty.KmsKeyId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-kmskeyid
         */
        readonly kmsKeyId?: string;
        /**
         * `CfnLaunchTemplate.EbsProperty.SnapshotId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-snapshotid
         */
        readonly snapshotId?: string;
        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnLaunchTemplate.EbsProperty.VolumeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-blockdevicemapping-ebs.html#cfn-ec2-launchtemplate-blockdevicemapping-ebs-volumetype
         */
        readonly volumeType?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html
     */
    interface ElasticGpuSpecificationProperty {
        /**
         * `CfnLaunchTemplate.ElasticGpuSpecificationProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-elasticgpuspecification.html#cfn-ec2-launchtemplate-elasticgpuspecification-type
         */
        readonly type?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html
     */
    interface HibernationOptionsProperty {
        /**
         * `CfnLaunchTemplate.HibernationOptionsProperty.Configured`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-hibernationoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions-configured
         */
        readonly configured?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html
     */
    interface IamInstanceProfileProperty {
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-arn
         */
        readonly arn?: string;
        /**
         * `CfnLaunchTemplate.IamInstanceProfileProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile-name
         */
        readonly name?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html
     */
    interface InstanceMarketOptionsProperty {
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.MarketType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-markettype
         */
        readonly marketType?: string;
        /**
         * `CfnLaunchTemplate.InstanceMarketOptionsProperty.SpotOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions
         */
        readonly spotOptions?: CfnLaunchTemplate.SpotOptionsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html
     */
    interface Ipv6AddProperty {
        /**
         * `CfnLaunchTemplate.Ipv6AddProperty.Ipv6Address`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-ipv6add.html#cfn-ec2-launchtemplate-ipv6add-ipv6address
         */
        readonly ipv6Address?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html
     */
    interface LaunchTemplateDataProperty {
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.BlockDeviceMappings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-blockdevicemappings
         */
        readonly blockDeviceMappings?: Array<CfnLaunchTemplate.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CapacityReservationSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-capacityreservationspecification
         */
        readonly capacityReservationSpecification?: CfnLaunchTemplate.CapacityReservationSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CpuOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-cpuoptions
         */
        readonly cpuOptions?: CfnLaunchTemplate.CpuOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.CreditSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-creditspecification
         */
        readonly creditSpecification?: CfnLaunchTemplate.CreditSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.DisableApiTermination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-disableapitermination
         */
        readonly disableApiTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.EbsOptimized`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ebsoptimized
         */
        readonly ebsOptimized?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticGpuSpecifications`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticgpuspecifications
         */
        readonly elasticGpuSpecifications?: Array<CfnLaunchTemplate.ElasticGpuSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ElasticInferenceAccelerators`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-elasticinferenceaccelerators
         */
        readonly elasticInferenceAccelerators?: Array<CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.HibernationOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-hibernationoptions
         */
        readonly hibernationOptions?: CfnLaunchTemplate.HibernationOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.IamInstanceProfile`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-iaminstanceprofile
         */
        readonly iamInstanceProfile?: CfnLaunchTemplate.IamInstanceProfileProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.ImageId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-imageid
         */
        readonly imageId?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceInitiatedShutdownBehavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instanceinitiatedshutdownbehavior
         */
        readonly instanceInitiatedShutdownBehavior?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceMarketOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions
         */
        readonly instanceMarketOptions?: CfnLaunchTemplate.InstanceMarketOptionsProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KernelId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-kernelid
         */
        readonly kernelId?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.KeyName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-keyname
         */
        readonly keyName?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.LicenseSpecifications`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-licensespecifications
         */
        readonly licenseSpecifications?: Array<CfnLaunchTemplate.LicenseSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Monitoring`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring
         */
        readonly monitoring?: CfnLaunchTemplate.MonitoringProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.NetworkInterfaces`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-networkinterfaces
         */
        readonly networkInterfaces?: Array<CfnLaunchTemplate.NetworkInterfaceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.Placement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-placement
         */
        readonly placement?: CfnLaunchTemplate.PlacementProperty | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.RamDiskId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-ramdiskid
         */
        readonly ramDiskId?: string;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.SecurityGroups`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-securitygroups
         */
        readonly securityGroups?: string[];
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.TagSpecifications`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-tagspecifications
         */
        readonly tagSpecifications?: Array<CfnLaunchTemplate.TagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.LaunchTemplateDataProperty.UserData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata.html#cfn-ec2-launchtemplate-launchtemplatedata-userdata
         */
        readonly userData?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html
     */
    interface LaunchTemplateElasticInferenceAcceleratorProperty {
        /**
         * `CfnLaunchTemplate.LaunchTemplateElasticInferenceAcceleratorProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator.html#cfn-ec2-launchtemplate-launchtemplateelasticinferenceaccelerator-type
         */
        readonly type?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html
     */
    interface LicenseSpecificationProperty {
        /**
         * `CfnLaunchTemplate.LicenseSpecificationProperty.LicenseConfigurationArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-licensespecification.html#cfn-ec2-launchtemplate-licensespecification-licenseconfigurationarn
         */
        readonly licenseConfigurationArn?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html
     */
    interface MonitoringProperty {
        /**
         * `CfnLaunchTemplate.MonitoringProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-monitoring.html#cfn-ec2-launchtemplate-launchtemplatedata-monitoring-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html
     */
    interface NetworkInterfaceProperty {
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.AssociatePublicIpAddress`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-associatepublicipaddress
         */
        readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeleteOnTermination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-description
         */
        readonly description?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.DeviceIndex`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-deviceindex
         */
        readonly deviceIndex?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Groups`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-groups
         */
        readonly groups?: string[];
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.InterfaceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-interfacetype
         */
        readonly interfaceType?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6AddressCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresscount
         */
        readonly ipv6AddressCount?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.Ipv6Addresses`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-ipv6addresses
         */
        readonly ipv6Addresses?: Array<CfnLaunchTemplate.Ipv6AddProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.NetworkInterfaceId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-networkinterfaceid
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddress`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddress
         */
        readonly privateIpAddress?: string;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.PrivateIpAddresses`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-privateipaddresses
         */
        readonly privateIpAddresses?: Array<CfnLaunchTemplate.PrivateIpAddProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SecondaryPrivateIpAddressCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-secondaryprivateipaddresscount
         */
        readonly secondaryPrivateIpAddressCount?: number;
        /**
         * `CfnLaunchTemplate.NetworkInterfaceProperty.SubnetId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-networkinterface.html#cfn-ec2-launchtemplate-networkinterface-subnetid
         */
        readonly subnetId?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html
     */
    interface PlacementProperty {
        /**
         * `CfnLaunchTemplate.PlacementProperty.Affinity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-affinity
         */
        readonly affinity?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.AvailabilityZone`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.GroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-groupname
         */
        readonly groupName?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.HostId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-hostid
         */
        readonly hostId?: string;
        /**
         * `CfnLaunchTemplate.PlacementProperty.Tenancy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-placement.html#cfn-ec2-launchtemplate-launchtemplatedata-placement-tenancy
         */
        readonly tenancy?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html
     */
    interface PrivateIpAddProperty {
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.Primary`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-primary
         */
        readonly primary?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchTemplate.PrivateIpAddProperty.PrivateIpAddress`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-privateipadd.html#cfn-ec2-launchtemplate-privateipadd-privateipaddress
         */
        readonly privateIpAddress?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html
     */
    interface SpotOptionsProperty {
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.BlockDurationMinutes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-blockdurationminutes
         */
        readonly blockDurationMinutes?: number;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.InstanceInterruptionBehavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-instanceinterruptionbehavior
         */
        readonly instanceInterruptionBehavior?: string;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.MaxPrice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-maxprice
         */
        readonly maxPrice?: string;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.SpotInstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-spotinstancetype
         */
        readonly spotInstanceType?: string;
        /**
         * `CfnLaunchTemplate.SpotOptionsProperty.ValidUntil`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-instancemarketoptions-spotoptions-validuntil
         */
        readonly validUntil?: string;
    }
}
export declare namespace CfnLaunchTemplate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html
     */
    interface TagSpecificationProperty {
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.ResourceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-resourcetype
         */
        readonly resourceType?: string;
        /**
         * `CfnLaunchTemplate.TagSpecificationProperty.Tags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-tagspecification.html#cfn-ec2-launchtemplate-tagspecification-tags
         */
        readonly tags?: cdk.CfnTag[];
    }
}
/**
 * Properties for defining a `AWS::EC2::NatGateway`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html
 */
export interface CfnNatGatewayProps {
    /**
     * `AWS::EC2::NatGateway.AllocationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid
     */
    readonly allocationId: string;
    /**
     * `AWS::EC2::NatGateway.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid
     */
    readonly subnetId: string;
    /**
     * `AWS::EC2::NatGateway.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NatGateway`
 *
 * @cloudformationResource AWS::EC2::NatGateway
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html
 */
export declare class CfnNatGateway extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NatGateway";
    /**
     * `AWS::EC2::NatGateway.AllocationId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-allocationid
     */
    allocationId: string;
    /**
     * `AWS::EC2::NatGateway.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-subnetid
     */
    subnetId: string;
    /**
     * `AWS::EC2::NatGateway.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-natgateway.html#cfn-ec2-natgateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NatGateway`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNatGatewayProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkAcl`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html
 */
export interface CfnNetworkAclProps {
    /**
     * `AWS::EC2::NetworkAcl.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::NetworkAcl.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NetworkAcl`
 *
 * @cloudformationResource AWS::EC2::NetworkAcl
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html
 */
export declare class CfnNetworkAcl extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkAcl";
    /**
     * `AWS::EC2::NetworkAcl.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::NetworkAcl.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl.html#cfn-ec2-networkacl-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NetworkAcl`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkAclProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkAclEntry`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
 */
export interface CfnNetworkAclEntryProps {
    /**
     * `AWS::EC2::NetworkAclEntry.NetworkAclId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-networkaclid
     */
    readonly networkAclId: string;
    /**
     * `AWS::EC2::NetworkAclEntry.Protocol`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-protocol
     */
    readonly protocol: number;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleAction`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ruleaction
     */
    readonly ruleAction: string;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleNumber`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-rulenumber
     */
    readonly ruleNumber: number;
    /**
     * `AWS::EC2::NetworkAclEntry.CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-cidrblock
     */
    readonly cidrBlock?: string;
    /**
     * `AWS::EC2::NetworkAclEntry.Egress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-egress
     */
    readonly egress?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkAclEntry.Icmp`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-icmp
     */
    readonly icmp?: CfnNetworkAclEntry.IcmpProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkAclEntry.Ipv6CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ipv6cidrblock
     */
    readonly ipv6CidrBlock?: string;
    /**
     * `AWS::EC2::NetworkAclEntry.PortRange`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-portrange
     */
    readonly portRange?: CfnNetworkAclEntry.PortRangeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::NetworkAclEntry`
 *
 * @cloudformationResource AWS::EC2::NetworkAclEntry
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html
 */
export declare class CfnNetworkAclEntry extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkAclEntry";
    /**
     * `AWS::EC2::NetworkAclEntry.NetworkAclId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-networkaclid
     */
    networkAclId: string;
    /**
     * `AWS::EC2::NetworkAclEntry.Protocol`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-protocol
     */
    protocol: number;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleAction`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ruleaction
     */
    ruleAction: string;
    /**
     * `AWS::EC2::NetworkAclEntry.RuleNumber`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-rulenumber
     */
    ruleNumber: number;
    /**
     * `AWS::EC2::NetworkAclEntry.CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-cidrblock
     */
    cidrBlock: string | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.Egress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-egress
     */
    egress: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.Icmp`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-icmp
     */
    icmp: CfnNetworkAclEntry.IcmpProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.Ipv6CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-ipv6cidrblock
     */
    ipv6CidrBlock: string | undefined;
    /**
     * `AWS::EC2::NetworkAclEntry.PortRange`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-acl-entry.html#cfn-ec2-networkaclentry-portrange
     */
    portRange: CfnNetworkAclEntry.PortRangeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::NetworkAclEntry`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkAclEntryProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnNetworkAclEntry {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html
     */
    interface IcmpProperty {
        /**
         * `CfnNetworkAclEntry.IcmpProperty.Code`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-code
         */
        readonly code?: number;
        /**
         * `CfnNetworkAclEntry.IcmpProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-icmp.html#cfn-ec2-networkaclentry-icmp-type
         */
        readonly type?: number;
    }
}
export declare namespace CfnNetworkAclEntry {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html
     */
    interface PortRangeProperty {
        /**
         * `CfnNetworkAclEntry.PortRangeProperty.From`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-from
         */
        readonly from?: number;
        /**
         * `CfnNetworkAclEntry.PortRangeProperty.To`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkaclentry-portrange.html#cfn-ec2-networkaclentry-portrange-to
         */
        readonly to?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::NetworkInterface`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 */
export interface CfnNetworkInterfaceProps {
    /**
     * `AWS::EC2::NetworkInterface.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
     */
    readonly subnetId: string;
    /**
     * `AWS::EC2::NetworkInterface.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::NetworkInterface.GroupSet`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
     */
    readonly groupSet?: string[];
    /**
     * `AWS::EC2::NetworkInterface.InterfaceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
     */
    readonly interfaceType?: string;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6AddressCount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
     */
    readonly ipv6AddressCount?: number;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6Addresses`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
     */
    readonly ipv6Addresses?: CfnNetworkInterface.InstanceIpv6AddressProperty | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
     */
    readonly privateIpAddress?: string;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddresses`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
     */
    readonly privateIpAddresses?: Array<CfnNetworkInterface.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
     */
    readonly secondaryPrivateIpAddressCount?: number;
    /**
     * `AWS::EC2::NetworkInterface.SourceDestCheck`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
     */
    readonly sourceDestCheck?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::NetworkInterface.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterface`
 *
 * @cloudformationResource AWS::EC2::NetworkInterface
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html
 */
export declare class CfnNetworkInterface extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInterface";
    /**
     * @cloudformationAttribute PrimaryPrivateIpAddress
     */
    readonly attrPrimaryPrivateIpAddress: string;
    /**
     * @cloudformationAttribute SecondaryPrivateIpAddresses
     */
    readonly attrSecondaryPrivateIpAddresses: string[];
    /**
     * `AWS::EC2::NetworkInterface.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-subnetid
     */
    subnetId: string;
    /**
     * `AWS::EC2::NetworkInterface.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::NetworkInterface.GroupSet`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-groupset
     */
    groupSet: string[] | undefined;
    /**
     * `AWS::EC2::NetworkInterface.InterfaceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-interfacetype
     */
    interfaceType: string | undefined;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6AddressCount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresscount
     */
    ipv6AddressCount: number | undefined;
    /**
     * `AWS::EC2::NetworkInterface.Ipv6Addresses`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-ec2-networkinterface-ipv6addresses
     */
    ipv6Addresses: CfnNetworkInterface.InstanceIpv6AddressProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddress
     */
    privateIpAddress: string | undefined;
    /**
     * `AWS::EC2::NetworkInterface.PrivateIpAddresses`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-privateipaddresses
     */
    privateIpAddresses: Array<CfnNetworkInterface.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkInterface.SecondaryPrivateIpAddressCount`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-secondaryprivateipcount
     */
    secondaryPrivateIpAddressCount: number | undefined;
    /**
     * `AWS::EC2::NetworkInterface.SourceDestCheck`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-sourcedestcheck
     */
    sourceDestCheck: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::NetworkInterface.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface.html#cfn-awsec2networkinterface-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::NetworkInterface`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInterfaceProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnNetworkInterface {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html
     */
    interface InstanceIpv6AddressProperty {
        /**
         * `CfnNetworkInterface.InstanceIpv6AddressProperty.Ipv6Address`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-networkinterface-instanceipv6address.html#cfn-ec2-networkinterface-instanceipv6address-ipv6address
         */
        readonly ipv6Address: string;
    }
}
export declare namespace CfnNetworkInterface {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html
     */
    interface PrivateIpAddressSpecificationProperty {
        /**
         * `CfnNetworkInterface.PrivateIpAddressSpecificationProperty.Primary`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-primary
         */
        readonly primary: boolean | cdk.IResolvable;
        /**
         * `CfnNetworkInterface.PrivateIpAddressSpecificationProperty.PrivateIpAddress`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-network-interface-privateipspec.html#cfn-ec2-networkinterface-privateipspecification-privateipaddress
         */
        readonly privateIpAddress: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::NetworkInterfaceAttachment`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html
 */
export interface CfnNetworkInterfaceAttachmentProps {
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
     */
    readonly deviceIndex: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
     */
    readonly instanceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
     */
    readonly networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
     */
    readonly deleteOnTermination?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterfaceAttachment`
 *
 * @cloudformationResource AWS::EC2::NetworkInterfaceAttachment
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html
 */
export declare class CfnNetworkInterfaceAttachment extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInterfaceAttachment";
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeviceIndex`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deviceindex
     */
    deviceIndex: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-instanceid
     */
    instanceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.NetworkInterfaceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-networkinterfaceid
     */
    networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfaceAttachment.DeleteOnTermination`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-network-interface-attachment.html#cfn-ec2-network-interface-attachment-deleteonterm
     */
    deleteOnTermination: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::NetworkInterfaceAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInterfaceAttachmentProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::NetworkInterfacePermission`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
 */
export interface CfnNetworkInterfacePermissionProps {
    /**
     * `AWS::EC2::NetworkInterfacePermission.AwsAccountId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     */
    readonly awsAccountId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     */
    readonly networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.Permission`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     */
    readonly permission: string;
}
/**
 * A CloudFormation `AWS::EC2::NetworkInterfacePermission`
 *
 * @cloudformationResource AWS::EC2::NetworkInterfacePermission
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html
 */
export declare class CfnNetworkInterfacePermission extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::NetworkInterfacePermission";
    /**
     * `AWS::EC2::NetworkInterfacePermission.AwsAccountId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-awsaccountid
     */
    awsAccountId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.NetworkInterfaceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-networkinterfaceid
     */
    networkInterfaceId: string;
    /**
     * `AWS::EC2::NetworkInterfacePermission.Permission`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-networkinterfacepermission.html#cfn-ec2-networkinterfacepermission-permission
     */
    permission: string;
    /**
     * Create a new `AWS::EC2::NetworkInterfacePermission`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNetworkInterfacePermissionProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::PlacementGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html
 */
export interface CfnPlacementGroupProps {
    /**
     * `AWS::EC2::PlacementGroup.Strategy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html#cfn-ec2-placementgroup-strategy
     */
    readonly strategy?: string;
}
/**
 * A CloudFormation `AWS::EC2::PlacementGroup`
 *
 * @cloudformationResource AWS::EC2::PlacementGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html
 */
export declare class CfnPlacementGroup extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::PlacementGroup";
    /**
     * `AWS::EC2::PlacementGroup.Strategy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-placementgroup.html#cfn-ec2-placementgroup-strategy
     */
    strategy: string | undefined;
    /**
     * Create a new `AWS::EC2::PlacementGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnPlacementGroupProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::Route`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
 */
export interface CfnRouteProps {
    /**
     * `AWS::EC2::Route.RouteTableId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     */
    readonly routeTableId: string;
    /**
     * `AWS::EC2::Route.DestinationCidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     */
    readonly destinationCidrBlock?: string;
    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     */
    readonly destinationIpv6CidrBlock?: string;
    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     */
    readonly egressOnlyInternetGatewayId?: string;
    /**
     * `AWS::EC2::Route.GatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     */
    readonly gatewayId?: string;
    /**
     * `AWS::EC2::Route.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     */
    readonly instanceId?: string;
    /**
     * `AWS::EC2::Route.NatGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     */
    readonly natGatewayId?: string;
    /**
     * `AWS::EC2::Route.NetworkInterfaceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     */
    readonly networkInterfaceId?: string;
    /**
     * `AWS::EC2::Route.TransitGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
     */
    readonly transitGatewayId?: string;
    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     */
    readonly vpcPeeringConnectionId?: string;
}
/**
 * A CloudFormation `AWS::EC2::Route`
 *
 * @cloudformationResource AWS::EC2::Route
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html
 */
export declare class CfnRoute extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Route";
    /**
     * `AWS::EC2::Route.RouteTableId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-routetableid
     */
    routeTableId: string;
    /**
     * `AWS::EC2::Route.DestinationCidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationcidrblock
     */
    destinationCidrBlock: string | undefined;
    /**
     * `AWS::EC2::Route.DestinationIpv6CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-destinationipv6cidrblock
     */
    destinationIpv6CidrBlock: string | undefined;
    /**
     * `AWS::EC2::Route.EgressOnlyInternetGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-egressonlyinternetgatewayid
     */
    egressOnlyInternetGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.GatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-gatewayid
     */
    gatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-instanceid
     */
    instanceId: string | undefined;
    /**
     * `AWS::EC2::Route.NatGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-natgatewayid
     */
    natGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.NetworkInterfaceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-networkinterfaceid
     */
    networkInterfaceId: string | undefined;
    /**
     * `AWS::EC2::Route.TransitGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-transitgatewayid
     */
    transitGatewayId: string | undefined;
    /**
     * `AWS::EC2::Route.VpcPeeringConnectionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route.html#cfn-ec2-route-vpcpeeringconnectionid
     */
    vpcPeeringConnectionId: string | undefined;
    /**
     * Create a new `AWS::EC2::Route`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::RouteTable`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html
 */
export interface CfnRouteTableProps {
    /**
     * `AWS::EC2::RouteTable.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::RouteTable.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::RouteTable`
 *
 * @cloudformationResource AWS::EC2::RouteTable
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html
 */
export declare class CfnRouteTable extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::RouteTable";
    /**
     * `AWS::EC2::RouteTable.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::RouteTable.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-route-table.html#cfn-ec2-routetable-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::RouteTable`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRouteTableProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SecurityGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
export interface CfnSecurityGroupProps {
    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    readonly groupDescription: string;
    /**
     * `AWS::EC2::SecurityGroup.GroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    readonly groupName?: string;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    readonly securityGroupEgress?: Array<CfnSecurityGroup.EgressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    readonly securityGroupIngress?: Array<CfnSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EC2::SecurityGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::SecurityGroup.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    readonly vpcId?: string;
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroup`
 *
 * @cloudformationResource AWS::EC2::SecurityGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html
 */
export declare class CfnSecurityGroup extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SecurityGroup";
    /**
     * @cloudformationAttribute GroupId
     */
    readonly attrGroupId: string;
    /**
     * @cloudformationAttribute VpcId
     */
    readonly attrVpcId: string;
    /**
     * `AWS::EC2::SecurityGroup.GroupDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupdescription
     */
    groupDescription: string;
    /**
     * `AWS::EC2::SecurityGroup.GroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-groupname
     */
    groupName: string | undefined;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupEgress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupegress
     */
    securityGroupEgress: Array<CfnSecurityGroup.EgressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::SecurityGroup.SecurityGroupIngress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-securitygroupingress
     */
    securityGroupIngress: Array<CfnSecurityGroup.IngressProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::SecurityGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::SecurityGroup.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html#cfn-ec2-securitygroup-vpcid
     */
    vpcId: string | undefined;
    /**
     * Create a new `AWS::EC2::SecurityGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSecurityGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    interface EgressProperty {
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIp`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        readonly cidrIp?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.CidrIpv6`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        readonly cidrIpv6?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        readonly description?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationPrefixListId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destinationprefixlistid
         */
        readonly destinationPrefixListId?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.DestinationSecurityGroupId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-destsecgroupid
         */
        readonly destinationSecurityGroupId?: string;
        /**
         * `CfnSecurityGroup.EgressProperty.FromPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        readonly fromPort?: number;
        /**
         * `CfnSecurityGroup.EgressProperty.IpProtocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        readonly ipProtocol: string;
        /**
         * `CfnSecurityGroup.EgressProperty.ToPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        readonly toPort?: number;
    }
}
export declare namespace CfnSecurityGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html
     */
    interface IngressProperty {
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIp`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidrip
         */
        readonly cidrIp?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.CidrIpv6`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-cidripv6
         */
        readonly cidrIpv6?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-description
         */
        readonly description?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.FromPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-fromport
         */
        readonly fromPort?: number;
        /**
         * `CfnSecurityGroup.IngressProperty.IpProtocol`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-ipprotocol
         */
        readonly ipProtocol: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourcePrefixListId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-securitygroup-ingress-sourceprefixlistid
         */
        readonly sourcePrefixListId?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupid
         */
        readonly sourceSecurityGroupId?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupname
         */
        readonly sourceSecurityGroupName?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.SourceSecurityGroupOwnerId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-sourcesecuritygroupownerid
         */
        readonly sourceSecurityGroupOwnerId?: string;
        /**
         * `CfnSecurityGroup.IngressProperty.ToPort`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-rule.html#cfn-ec2-security-group-rule-toport
         */
        readonly toPort?: number;
    }
}
/**
 * Properties for defining a `AWS::EC2::SecurityGroupEgress`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html
 */
export interface CfnSecurityGroupEgressProps {
    /**
     * `AWS::EC2::SecurityGroupEgress.GroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
     */
    readonly groupId: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.IpProtocol`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
     */
    readonly ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIp`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
     */
    readonly cidrIp?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIpv6`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
     */
    readonly cidrIpv6?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
     */
    readonly destinationPrefixListId?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
     */
    readonly destinationSecurityGroupId?: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.FromPort`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
     */
    readonly fromPort?: number;
    /**
     * `AWS::EC2::SecurityGroupEgress.ToPort`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
     */
    readonly toPort?: number;
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroupEgress`
 *
 * @cloudformationResource AWS::EC2::SecurityGroupEgress
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html
 */
export declare class CfnSecurityGroupEgress extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SecurityGroupEgress";
    /**
     * `AWS::EC2::SecurityGroupEgress.GroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-groupid
     */
    groupId: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.IpProtocol`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-ipprotocol
     */
    ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIp`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidrip
     */
    cidrIp: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.CidrIpv6`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-cidripv6
     */
    cidrIpv6: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationPrefixListId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationprefixlistid
     */
    destinationPrefixListId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.DestinationSecurityGroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-destinationsecuritygroupid
     */
    destinationSecurityGroupId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.FromPort`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-fromport
     */
    fromPort: number | undefined;
    /**
     * `AWS::EC2::SecurityGroupEgress.ToPort`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-security-group-egress.html#cfn-ec2-securitygroupegress-toport
     */
    toPort: number | undefined;
    /**
     * Create a new `AWS::EC2::SecurityGroupEgress`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupEgressProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SecurityGroupIngress`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html
 */
export interface CfnSecurityGroupIngressProps {
    /**
     * `AWS::EC2::SecurityGroupIngress.IpProtocol`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     */
    readonly ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIp`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     */
    readonly cidrIp?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIpv6`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     */
    readonly cidrIpv6?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.FromPort`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     */
    readonly fromPort?: number;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     */
    readonly groupId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     */
    readonly groupName?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourcePrefixListId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
     */
    readonly sourcePrefixListId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     */
    readonly sourceSecurityGroupId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     */
    readonly sourceSecurityGroupName?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     */
    readonly sourceSecurityGroupOwnerId?: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.ToPort`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     */
    readonly toPort?: number;
}
/**
 * A CloudFormation `AWS::EC2::SecurityGroupIngress`
 *
 * @cloudformationResource AWS::EC2::SecurityGroupIngress
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html
 */
export declare class CfnSecurityGroupIngress extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SecurityGroupIngress";
    /**
     * `AWS::EC2::SecurityGroupIngress.IpProtocol`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-ipprotocol
     */
    ipProtocol: string;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIp`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidrip
     */
    cidrIp: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.CidrIpv6`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-cidripv6
     */
    cidrIpv6: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.FromPort`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-fromport
     */
    fromPort: number | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupid
     */
    groupId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.GroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-groupname
     */
    groupName: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourcePrefixListId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-securitygroupingress-sourceprefixlistid
     */
    sourcePrefixListId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupid
     */
    sourceSecurityGroupId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupname
     */
    sourceSecurityGroupName: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.SourceSecurityGroupOwnerId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-sourcesecuritygroupownerid
     */
    sourceSecurityGroupOwnerId: string | undefined;
    /**
     * `AWS::EC2::SecurityGroupIngress.ToPort`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group-ingress.html#cfn-ec2-security-group-ingress-toport
     */
    toPort: number | undefined;
    /**
     * Create a new `AWS::EC2::SecurityGroupIngress`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSecurityGroupIngressProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SpotFleet`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export interface CfnSpotFleetProps {
    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    readonly spotFleetRequestConfigData: CfnSpotFleet.SpotFleetRequestConfigDataProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::SpotFleet`
 *
 * @cloudformationResource AWS::EC2::SpotFleet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html
 */
export declare class CfnSpotFleet extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SpotFleet";
    /**
     * `AWS::EC2::SpotFleet.SpotFleetRequestConfigData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-spotfleet.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata
     */
    spotFleetRequestConfigData: CfnSpotFleet.SpotFleetRequestConfigDataProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::EC2::SpotFleet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSpotFleetProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.DeviceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-devicename
         */
        readonly deviceName: string;
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.Ebs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-ebs
         */
        readonly ebs?: CfnSpotFleet.EbsBlockDeviceProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.NoDevice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-nodevice
         */
        readonly noDevice?: string;
        /**
         * `CfnSpotFleet.BlockDeviceMappingProperty.VirtualName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings.html#cfn-ec2-spotfleet-blockdevicemapping-virtualname
         */
        readonly virtualName?: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html
     */
    interface ClassicLoadBalancerProperty {
        /**
         * `CfnSpotFleet.ClassicLoadBalancerProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancer.html#cfn-ec2-spotfleet-classicloadbalancer-name
         */
        readonly name: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html
     */
    interface ClassicLoadBalancersConfigProperty {
        /**
         * `CfnSpotFleet.ClassicLoadBalancersConfigProperty.ClassicLoadBalancers`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-classicloadbalancersconfig.html#cfn-ec2-spotfleet-classicloadbalancersconfig-classicloadbalancers
         */
        readonly classicLoadBalancers: Array<CfnSpotFleet.ClassicLoadBalancerProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html
     */
    interface EbsBlockDeviceProperty {
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.DeleteOnTermination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Encrypted`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.Iops`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-iops
         */
        readonly iops?: number;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.SnapshotId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-snapshotid
         */
        readonly snapshotId?: string;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnSpotFleet.EbsBlockDeviceProperty.VolumeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-blockdevicemappings-ebs.html#cfn-ec2-spotfleet-ebsblockdevice-volumetype
         */
        readonly volumeType?: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html
     */
    interface FleetLaunchTemplateSpecificationProperty {
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplateid
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.LaunchTemplateName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-launchtemplatename
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnSpotFleet.FleetLaunchTemplateSpecificationProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-fleetlaunchtemplatespecification.html#cfn-ec2-spotfleet-fleetlaunchtemplatespecification-version
         */
        readonly version: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html
     */
    interface GroupIdentifierProperty {
        /**
         * `CfnSpotFleet.GroupIdentifierProperty.GroupId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-securitygroups.html#cfn-ec2-spotfleet-groupidentifier-groupid
         */
        readonly groupId: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html
     */
    interface IamInstanceProfileSpecificationProperty {
        /**
         * `CfnSpotFleet.IamInstanceProfileSpecificationProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-iaminstanceprofile.html#cfn-ec2-spotfleet-iaminstanceprofilespecification-arn
         */
        readonly arn?: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html
     */
    interface InstanceIpv6AddressProperty {
        /**
         * `CfnSpotFleet.InstanceIpv6AddressProperty.Ipv6Address`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-instanceipv6address.html#cfn-ec2-spotfleet-instanceipv6address-ipv6address
         */
        readonly ipv6Address: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html
     */
    interface InstanceNetworkInterfaceSpecificationProperty {
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.AssociatePublicIpAddress`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-associatepublicipaddress
         */
        readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeleteOnTermination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deleteontermination
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Description`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-description
         */
        readonly description?: string;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.DeviceIndex`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-deviceindex
         */
        readonly deviceIndex?: number;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Groups`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-groups
         */
        readonly groups?: string[];
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6AddressCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresscount
         */
        readonly ipv6AddressCount?: number;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.Ipv6Addresses`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-ipv6addresses
         */
        readonly ipv6Addresses?: Array<CfnSpotFleet.InstanceIpv6AddressProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.NetworkInterfaceId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-networkinterfaceid
         */
        readonly networkInterfaceId?: string;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.PrivateIpAddresses`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-privateipaddresses
         */
        readonly privateIpAddresses?: Array<CfnSpotFleet.PrivateIpAddressSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SecondaryPrivateIpAddressCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-secondaryprivateipaddresscount
         */
        readonly secondaryPrivateIpAddressCount?: number;
        /**
         * `CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty.SubnetId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces.html#cfn-ec2-spotfleet-instancenetworkinterfacespecification-subnetid
         */
        readonly subnetId?: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html
     */
    interface LaunchTemplateConfigProperty {
        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.LaunchTemplateSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-launchtemplatespecification
         */
        readonly launchTemplateSpecification?: CfnSpotFleet.FleetLaunchTemplateSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.LaunchTemplateConfigProperty.Overrides`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateconfig.html#cfn-ec2-spotfleet-launchtemplateconfig-overrides
         */
        readonly overrides?: Array<CfnSpotFleet.LaunchTemplateOverridesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html
     */
    interface LaunchTemplateOverridesProperty {
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.AvailabilityZone`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SpotPrice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-spotprice
         */
        readonly spotPrice?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.SubnetId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-subnetid
         */
        readonly subnetId?: string;
        /**
         * `CfnSpotFleet.LaunchTemplateOverridesProperty.WeightedCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-launchtemplateoverrides.html#cfn-ec2-spotfleet-launchtemplateoverrides-weightedcapacity
         */
        readonly weightedCapacity?: number;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html
     */
    interface LoadBalancersConfigProperty {
        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.ClassicLoadBalancersConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-classicloadbalancersconfig
         */
        readonly classicLoadBalancersConfig?: CfnSpotFleet.ClassicLoadBalancersConfigProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.LoadBalancersConfigProperty.TargetGroupsConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-loadbalancersconfig.html#cfn-ec2-spotfleet-loadbalancersconfig-targetgroupsconfig
         */
        readonly targetGroupsConfig?: CfnSpotFleet.TargetGroupsConfigProperty | cdk.IResolvable;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html
     */
    interface PrivateIpAddressSpecificationProperty {
        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.Primary`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-primary
         */
        readonly primary?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.PrivateIpAddressSpecificationProperty.PrivateIpAddress`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-networkinterfaces-privateipaddresses.html#cfn-ec2-spotfleet-privateipaddressspecification-privateipaddress
         */
        readonly privateIpAddress: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html
     */
    interface SpotFleetLaunchSpecificationProperty {
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.BlockDeviceMappings`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-blockdevicemappings
         */
        readonly blockDeviceMappings?: Array<CfnSpotFleet.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.EbsOptimized`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ebsoptimized
         */
        readonly ebsOptimized?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.IamInstanceProfile`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-iaminstanceprofile
         */
        readonly iamInstanceProfile?: CfnSpotFleet.IamInstanceProfileSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.ImageId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-imageid
         */
        readonly imageId: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KernelId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-kernelid
         */
        readonly kernelId?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.KeyName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-keyname
         */
        readonly keyName?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Monitoring`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-monitoring
         */
        readonly monitoring?: CfnSpotFleet.SpotFleetMonitoringProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.NetworkInterfaces`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-networkinterfaces
         */
        readonly networkInterfaces?: Array<CfnSpotFleet.InstanceNetworkInterfaceSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.Placement`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-placement
         */
        readonly placement?: CfnSpotFleet.SpotPlacementProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.RamdiskId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-ramdiskid
         */
        readonly ramdiskId?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SecurityGroups`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-securitygroups
         */
        readonly securityGroups?: Array<CfnSpotFleet.GroupIdentifierProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SpotPrice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-spotprice
         */
        readonly spotPrice?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.SubnetId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-subnetid
         */
        readonly subnetId?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.TagSpecifications`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-tagspecifications
         */
        readonly tagSpecifications?: Array<CfnSpotFleet.SpotFleetTagSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.UserData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-userdata
         */
        readonly userData?: string;
        /**
         * `CfnSpotFleet.SpotFleetLaunchSpecificationProperty.WeightedCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications.html#cfn-ec2-spotfleet-spotfleetlaunchspecification-weightedcapacity
         */
        readonly weightedCapacity?: number;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html
     */
    interface SpotFleetMonitoringProperty {
        /**
         * `CfnSpotFleet.SpotFleetMonitoringProperty.Enabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-monitoring.html#cfn-ec2-spotfleet-spotfleetmonitoring-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html
     */
    interface SpotFleetRequestConfigDataProperty {
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.AllocationStrategy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-allocationstrategy
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ExcessCapacityTerminationPolicy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-excesscapacityterminationpolicy
         */
        readonly excessCapacityTerminationPolicy?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.IamFleetRole`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-iamfleetrole
         */
        readonly iamFleetRole: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.InstanceInterruptionBehavior`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-instanceinterruptionbehavior
         */
        readonly instanceInterruptionBehavior?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchSpecifications`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications
         */
        readonly launchSpecifications?: Array<CfnSpotFleet.SpotFleetLaunchSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LaunchTemplateConfigs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-launchtemplateconfigs
         */
        readonly launchTemplateConfigs?: Array<CfnSpotFleet.LaunchTemplateConfigProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.LoadBalancersConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-loadbalancersconfig
         */
        readonly loadBalancersConfig?: CfnSpotFleet.LoadBalancersConfigProperty | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ReplaceUnhealthyInstances`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-replaceunhealthyinstances
         */
        readonly replaceUnhealthyInstances?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.SpotPrice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-spotprice
         */
        readonly spotPrice?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TargetCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-targetcapacity
         */
        readonly targetCapacity: number;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.TerminateInstancesWithExpiration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-terminateinstanceswithexpiration
         */
        readonly terminateInstancesWithExpiration?: boolean | cdk.IResolvable;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-type
         */
        readonly type?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidFrom`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validfrom
         */
        readonly validFrom?: string;
        /**
         * `CfnSpotFleet.SpotFleetRequestConfigDataProperty.ValidUntil`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata.html#cfn-ec2-spotfleet-spotfleetrequestconfigdata-validuntil
         */
        readonly validUntil?: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html
     */
    interface SpotFleetTagSpecificationProperty {
        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.ResourceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-spotfleettagspecification-resourcetype
         */
        readonly resourceType?: string;
        /**
         * `CfnSpotFleet.SpotFleetTagSpecificationProperty.Tags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-tagspecifications.html#cfn-ec2-spotfleet-tags
         */
        readonly tags?: cdk.CfnTag[];
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html
     */
    interface SpotPlacementProperty {
        /**
         * `CfnSpotFleet.SpotPlacementProperty.AvailabilityZone`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-availabilityzone
         */
        readonly availabilityZone?: string;
        /**
         * `CfnSpotFleet.SpotPlacementProperty.GroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-groupname
         */
        readonly groupName?: string;
        /**
         * `CfnSpotFleet.SpotPlacementProperty.Tenancy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-spotfleetrequestconfigdata-launchspecifications-placement.html#cfn-ec2-spotfleet-spotplacement-tenancy
         */
        readonly tenancy?: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html
     */
    interface TargetGroupProperty {
        /**
         * `CfnSpotFleet.TargetGroupProperty.Arn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroup.html#cfn-ec2-spotfleet-targetgroup-arn
         */
        readonly arn: string;
    }
}
export declare namespace CfnSpotFleet {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html
     */
    interface TargetGroupsConfigProperty {
        /**
         * `CfnSpotFleet.TargetGroupsConfigProperty.TargetGroups`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-spotfleet-targetgroupsconfig.html#cfn-ec2-spotfleet-targetgroupsconfig-targetgroups
         */
        readonly targetGroups: Array<CfnSpotFleet.TargetGroupProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::EC2::Subnet`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html
 */
export interface CfnSubnetProps {
    /**
     * `AWS::EC2::Subnet.CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock
     */
    readonly cidrBlock: string;
    /**
     * `AWS::EC2::Subnet.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-awsec2subnet-prop-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::Subnet.AssignIpv6AddressOnCreation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation
     */
    readonly assignIpv6AddressOnCreation?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Subnet.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::EC2::Subnet.Ipv6CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock
     */
    readonly ipv6CidrBlock?: string;
    /**
     * `AWS::EC2::Subnet.MapPublicIpOnLaunch`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch
     */
    readonly mapPublicIpOnLaunch?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Subnet.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::Subnet`
 *
 * @cloudformationResource AWS::EC2::Subnet
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html
 */
export declare class CfnSubnet extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Subnet";
    /**
     * @cloudformationAttribute AvailabilityZone
     */
    readonly attrAvailabilityZone: string;
    /**
     * @cloudformationAttribute Ipv6CidrBlocks
     */
    readonly attrIpv6CidrBlocks: string[];
    /**
     * @cloudformationAttribute NetworkAclAssociationId
     */
    readonly attrNetworkAclAssociationId: string;
    /**
     * @cloudformationAttribute VpcId
     */
    readonly attrVpcId: string;
    /**
     * `AWS::EC2::Subnet.CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-cidrblock
     */
    cidrBlock: string;
    /**
     * `AWS::EC2::Subnet.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-awsec2subnet-prop-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::Subnet.AssignIpv6AddressOnCreation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-assignipv6addressoncreation
     */
    assignIpv6AddressOnCreation: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Subnet.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::EC2::Subnet.Ipv6CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-ipv6cidrblock
     */
    ipv6CidrBlock: string | undefined;
    /**
     * `AWS::EC2::Subnet.MapPublicIpOnLaunch`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-mappubliciponlaunch
     */
    mapPublicIpOnLaunch: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Subnet.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet.html#cfn-ec2-subnet-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::Subnet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SubnetCidrBlock`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html
 */
export interface CfnSubnetCidrBlockProps {
    /**
     * `AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
     */
    readonly ipv6CidrBlock: string;
    /**
     * `AWS::EC2::SubnetCidrBlock.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::SubnetCidrBlock`
 *
 * @cloudformationResource AWS::EC2::SubnetCidrBlock
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html
 */
export declare class CfnSubnetCidrBlock extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SubnetCidrBlock";
    /**
     * `AWS::EC2::SubnetCidrBlock.Ipv6CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-ipv6cidrblock
     */
    ipv6CidrBlock: string;
    /**
     * `AWS::EC2::SubnetCidrBlock.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnetcidrblock.html#cfn-ec2-subnetcidrblock-subnetid
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::SubnetCidrBlock`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetCidrBlockProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SubnetNetworkAclAssociation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html
 */
export interface CfnSubnetNetworkAclAssociationProps {
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-networkaclid
     */
    readonly networkAclId: string;
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-associationid
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::SubnetNetworkAclAssociation`
 *
 * @cloudformationResource AWS::EC2::SubnetNetworkAclAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html
 */
export declare class CfnSubnetNetworkAclAssociation extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SubnetNetworkAclAssociation";
    /**
     * @cloudformationAttribute AssociationId
     */
    readonly attrAssociationId: string;
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.NetworkAclId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-networkaclid
     */
    networkAclId: string;
    /**
     * `AWS::EC2::SubnetNetworkAclAssociation.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-network-acl-assoc.html#cfn-ec2-subnetnetworkaclassociation-associationid
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::SubnetNetworkAclAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetNetworkAclAssociationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::SubnetRouteTableAssociation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html
 */
export interface CfnSubnetRouteTableAssociationProps {
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.RouteTableId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
     */
    readonly routeTableId: string;
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
     */
    readonly subnetId: string;
}
/**
 * A CloudFormation `AWS::EC2::SubnetRouteTableAssociation`
 *
 * @cloudformationResource AWS::EC2::SubnetRouteTableAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html
 */
export declare class CfnSubnetRouteTableAssociation extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::SubnetRouteTableAssociation";
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.RouteTableId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-routetableid
     */
    routeTableId: string;
    /**
     * `AWS::EC2::SubnetRouteTableAssociation.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-subnet-route-table-assoc.html#cfn-ec2-subnetroutetableassociation-subnetid
     */
    subnetId: string;
    /**
     * Create a new `AWS::EC2::SubnetRouteTableAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSubnetRouteTableAssociationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGateway`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html
 */
export interface CfnTransitGatewayProps {
    /**
     * `AWS::EC2::TransitGateway.AmazonSideAsn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-amazonsideasn
     */
    readonly amazonSideAsn?: number;
    /**
     * `AWS::EC2::TransitGateway.AutoAcceptSharedAttachments`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-autoacceptsharedattachments
     */
    readonly autoAcceptSharedAttachments?: string;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTableAssociation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetableassociation
     */
    readonly defaultRouteTableAssociation?: string;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTablePropagation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetablepropagation
     */
    readonly defaultRouteTablePropagation?: string;
    /**
     * `AWS::EC2::TransitGateway.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-description
     */
    readonly description?: string;
    /**
     * `AWS::EC2::TransitGateway.DnsSupport`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-dnssupport
     */
    readonly dnsSupport?: string;
    /**
     * `AWS::EC2::TransitGateway.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::TransitGateway.VpnEcmpSupport`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-vpnecmpsupport
     */
    readonly vpnEcmpSupport?: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGateway`
 *
 * @cloudformationResource AWS::EC2::TransitGateway
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html
 */
export declare class CfnTransitGateway extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGateway";
    /**
     * `AWS::EC2::TransitGateway.AmazonSideAsn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-amazonsideasn
     */
    amazonSideAsn: number | undefined;
    /**
     * `AWS::EC2::TransitGateway.AutoAcceptSharedAttachments`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-autoacceptsharedattachments
     */
    autoAcceptSharedAttachments: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTableAssociation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetableassociation
     */
    defaultRouteTableAssociation: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.DefaultRouteTablePropagation`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-defaultroutetablepropagation
     */
    defaultRouteTablePropagation: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-description
     */
    description: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.DnsSupport`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-dnssupport
     */
    dnsSupport: string | undefined;
    /**
     * `AWS::EC2::TransitGateway.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::TransitGateway.VpnEcmpSupport`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgateway.html#cfn-ec2-transitgateway-vpnecmpsupport
     */
    vpnEcmpSupport: string | undefined;
    /**
     * Create a new `AWS::EC2::TransitGateway`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTransitGatewayProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayAttachment`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html
 */
export interface CfnTransitGatewayAttachmentProps {
    /**
     * `AWS::EC2::TransitGatewayAttachment.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-subnetids
     */
    readonly subnetIds: string[];
    /**
     * `AWS::EC2::TransitGatewayAttachment.TransitGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-transitgatewayid
     */
    readonly transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayAttachment`
 *
 * @cloudformationResource AWS::EC2::TransitGatewayAttachment
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html
 */
export declare class CfnTransitGatewayAttachment extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayAttachment";
    /**
     * `AWS::EC2::TransitGatewayAttachment.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-subnetids
     */
    subnetIds: string[];
    /**
     * `AWS::EC2::TransitGatewayAttachment.TransitGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-transitgatewayid
     */
    transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::TransitGatewayAttachment.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayattachment.html#cfn-ec2-transitgatewayattachment-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TransitGatewayAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayAttachmentProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRoute`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html
 */
export interface CfnTransitGatewayRouteProps {
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayRouteTableId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayroutetableid
     */
    readonly transitGatewayRouteTableId: string;
    /**
     * `AWS::EC2::TransitGatewayRoute.Blackhole`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-blackhole
     */
    readonly blackhole?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::TransitGatewayRoute.DestinationCidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-destinationcidrblock
     */
    readonly destinationCidrBlock?: string;
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayAttachmentId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayattachmentid
     */
    readonly transitGatewayAttachmentId?: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRoute`
 *
 * @cloudformationResource AWS::EC2::TransitGatewayRoute
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html
 */
export declare class CfnTransitGatewayRoute extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRoute";
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayRouteTableId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayroutetableid
     */
    transitGatewayRouteTableId: string;
    /**
     * `AWS::EC2::TransitGatewayRoute.Blackhole`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-blackhole
     */
    blackhole: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::TransitGatewayRoute.DestinationCidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-destinationcidrblock
     */
    destinationCidrBlock: string | undefined;
    /**
     * `AWS::EC2::TransitGatewayRoute.TransitGatewayAttachmentId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroute.html#cfn-ec2-transitgatewayroute-transitgatewayattachmentid
     */
    transitGatewayAttachmentId: string | undefined;
    /**
     * Create a new `AWS::EC2::TransitGatewayRoute`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRouteTable`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html
 */
export interface CfnTransitGatewayRouteTableProps {
    /**
     * `AWS::EC2::TransitGatewayRouteTable.TransitGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-transitgatewayid
     */
    readonly transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTable.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRouteTable`
 *
 * @cloudformationResource AWS::EC2::TransitGatewayRouteTable
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html
 */
export declare class CfnTransitGatewayRouteTable extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRouteTable";
    /**
     * `AWS::EC2::TransitGatewayRouteTable.TransitGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-transitgatewayid
     */
    transitGatewayId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTable.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetable.html#cfn-ec2-transitgatewayroutetable-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::TransitGatewayRouteTable`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteTableProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRouteTableAssociation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html
 */
export interface CfnTransitGatewayRouteTableAssociationProps {
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayAttachmentId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayattachmentid
     */
    readonly transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayRouteTableId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayroutetableid
     */
    readonly transitGatewayRouteTableId: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRouteTableAssociation`
 *
 * @cloudformationResource AWS::EC2::TransitGatewayRouteTableAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html
 */
export declare class CfnTransitGatewayRouteTableAssociation extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRouteTableAssociation";
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayAttachmentId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayattachmentid
     */
    transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTableAssociation.TransitGatewayRouteTableId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetableassociation.html#cfn-ec2-transitgatewayroutetableassociation-transitgatewayroutetableid
     */
    transitGatewayRouteTableId: string;
    /**
     * Create a new `AWS::EC2::TransitGatewayRouteTableAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteTableAssociationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::TransitGatewayRouteTablePropagation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html
 */
export interface CfnTransitGatewayRouteTablePropagationProps {
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayAttachmentId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayattachmentid
     */
    readonly transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayRouteTableId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayroutetableid
     */
    readonly transitGatewayRouteTableId: string;
}
/**
 * A CloudFormation `AWS::EC2::TransitGatewayRouteTablePropagation`
 *
 * @cloudformationResource AWS::EC2::TransitGatewayRouteTablePropagation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html
 */
export declare class CfnTransitGatewayRouteTablePropagation extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::TransitGatewayRouteTablePropagation";
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayAttachmentId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayattachmentid
     */
    transitGatewayAttachmentId: string;
    /**
     * `AWS::EC2::TransitGatewayRouteTablePropagation.TransitGatewayRouteTableId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-transitgatewayroutetablepropagation.html#cfn-ec2-transitgatewayroutetablepropagation-transitgatewayroutetableid
     */
    transitGatewayRouteTableId: string;
    /**
     * Create a new `AWS::EC2::TransitGatewayRouteTablePropagation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTransitGatewayRouteTablePropagationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPC`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html
 */
export interface CfnVPCProps {
    /**
     * `AWS::EC2::VPC.CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-cidrblock
     */
    readonly cidrBlock: string;
    /**
     * `AWS::EC2::VPC.EnableDnsHostnames`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
     */
    readonly enableDnsHostnames?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPC.EnableDnsSupport`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
     */
    readonly enableDnsSupport?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPC.InstanceTenancy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-instancetenancy
     */
    readonly instanceTenancy?: string;
    /**
     * `AWS::EC2::VPC.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::VPC`
 *
 * @cloudformationResource AWS::EC2::VPC
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html
 */
export declare class CfnVPC extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPC";
    /**
     * @cloudformationAttribute CidrBlock
     */
    readonly attrCidrBlock: string;
    /**
     * @cloudformationAttribute CidrBlockAssociations
     */
    readonly attrCidrBlockAssociations: string[];
    /**
     * @cloudformationAttribute DefaultNetworkAcl
     */
    readonly attrDefaultNetworkAcl: string;
    /**
     * @cloudformationAttribute DefaultSecurityGroup
     */
    readonly attrDefaultSecurityGroup: string;
    /**
     * @cloudformationAttribute Ipv6CidrBlocks
     */
    readonly attrIpv6CidrBlocks: string[];
    /**
     * `AWS::EC2::VPC.CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-cidrblock
     */
    cidrBlock: string;
    /**
     * `AWS::EC2::VPC.EnableDnsHostnames`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsHostnames
     */
    enableDnsHostnames: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPC.EnableDnsSupport`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-EnableDnsSupport
     */
    enableDnsSupport: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPC.InstanceTenancy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-instancetenancy
     */
    instanceTenancy: string | undefined;
    /**
     * `AWS::EC2::VPC.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc.html#cfn-aws-ec2-vpc-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::VPC`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCCidrBlock`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html
 */
export interface CfnVPCCidrBlockProps {
    /**
     * `AWS::EC2::VPCCidrBlock.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCCidrBlock.AmazonProvidedIpv6CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-amazonprovidedipv6cidrblock
     */
    readonly amazonProvidedIpv6CidrBlock?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCCidrBlock.CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-cidrblock
     */
    readonly cidrBlock?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCCidrBlock`
 *
 * @cloudformationResource AWS::EC2::VPCCidrBlock
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html
 */
export declare class CfnVPCCidrBlock extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCCidrBlock";
    /**
     * `AWS::EC2::VPCCidrBlock.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCCidrBlock.AmazonProvidedIpv6CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-amazonprovidedipv6cidrblock
     */
    amazonProvidedIpv6CidrBlock: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCCidrBlock.CidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpccidrblock.html#cfn-ec2-vpccidrblock-cidrblock
     */
    cidrBlock: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCCidrBlock`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCCidrBlockProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCDHCPOptionsAssociation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html
 */
export interface CfnVPCDHCPOptionsAssociationProps {
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.DhcpOptionsId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-dhcpoptionsid
     */
    readonly dhcpOptionsId: string;
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-vpcid
     */
    readonly vpcId: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCDHCPOptionsAssociation`
 *
 * @cloudformationResource AWS::EC2::VPCDHCPOptionsAssociation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html
 */
export declare class CfnVPCDHCPOptionsAssociation extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCDHCPOptionsAssociation";
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.DhcpOptionsId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-dhcpoptionsid
     */
    dhcpOptionsId: string;
    /**
     * `AWS::EC2::VPCDHCPOptionsAssociation.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-dhcp-options-assoc.html#cfn-ec2-vpcdhcpoptionsassociation-vpcid
     */
    vpcId: string;
    /**
     * Create a new `AWS::EC2::VPCDHCPOptionsAssociation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCDHCPOptionsAssociationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpoint`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
 */
export interface CfnVPCEndpointProps {
    /**
     * `AWS::EC2::VPCEndpoint.ServiceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
     */
    readonly serviceName: string;
    /**
     * `AWS::EC2::VPCEndpoint.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCEndpoint.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
     */
    readonly policyDocument?: any | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
     */
    readonly privateDnsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPCEndpoint.RouteTableIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
     */
    readonly routeTableIds?: string[];
    /**
     * `AWS::EC2::VPCEndpoint.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::EC2::VPCEndpoint.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
     */
    readonly subnetIds?: string[];
    /**
     * `AWS::EC2::VPCEndpoint.VpcEndpointType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
     */
    readonly vpcEndpointType?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpoint`
 *
 * @cloudformationResource AWS::EC2::VPCEndpoint
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html
 */
export declare class CfnVPCEndpoint extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpoint";
    /**
     * @cloudformationAttribute CreationTimestamp
     */
    readonly attrCreationTimestamp: string;
    /**
     * @cloudformationAttribute DnsEntries
     */
    readonly attrDnsEntries: string[];
    /**
     * @cloudformationAttribute NetworkInterfaceIds
     */
    readonly attrNetworkInterfaceIds: string[];
    /**
     * `AWS::EC2::VPCEndpoint.ServiceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-servicename
     */
    serviceName: string;
    /**
     * `AWS::EC2::VPCEndpoint.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCEndpoint.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-policydocument
     */
    policyDocument: any | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.PrivateDnsEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-privatednsenabled
     */
    privateDnsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.RouteTableIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-routetableids
     */
    routeTableIds: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-subnetids
     */
    subnetIds: string[] | undefined;
    /**
     * `AWS::EC2::VPCEndpoint.VpcEndpointType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpoint.html#cfn-ec2-vpcendpoint-vpcendpointtype
     */
    vpcEndpointType: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCEndpointProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpointConnectionNotification`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html
 */
export interface CfnVPCEndpointConnectionNotificationProps {
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
     */
    readonly connectionEvents: string[];
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
     */
    readonly connectionNotificationArn: string;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
     */
    readonly serviceId?: string;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
     */
    readonly vpcEndpointId?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpointConnectionNotification`
 *
 * @cloudformationResource AWS::EC2::VPCEndpointConnectionNotification
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html
 */
export declare class CfnVPCEndpointConnectionNotification extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpointConnectionNotification";
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionEvents`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionevents
     */
    connectionEvents: string[];
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ConnectionNotificationArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-connectionnotificationarn
     */
    connectionNotificationArn: string;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.ServiceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-serviceid
     */
    serviceId: string | undefined;
    /**
     * `AWS::EC2::VPCEndpointConnectionNotification.VPCEndpointId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointconnectionnotification.html#cfn-ec2-vpcendpointconnectionnotification-vpcendpointid
     */
    vpcEndpointId: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpointConnectionNotification`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCEndpointConnectionNotificationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpointService`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html
 */
export interface CfnVPCEndpointServiceProps {
    /**
     * `AWS::EC2::VPCEndpointService.NetworkLoadBalancerArns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-networkloadbalancerarns
     */
    readonly networkLoadBalancerArns: string[];
    /**
     * `AWS::EC2::VPCEndpointService.AcceptanceRequired`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-acceptancerequired
     */
    readonly acceptanceRequired?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpointService`
 *
 * @cloudformationResource AWS::EC2::VPCEndpointService
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html
 */
export declare class CfnVPCEndpointService extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpointService";
    /**
     * `AWS::EC2::VPCEndpointService.NetworkLoadBalancerArns`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-networkloadbalancerarns
     */
    networkLoadBalancerArns: string[];
    /**
     * `AWS::EC2::VPCEndpointService.AcceptanceRequired`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservice.html#cfn-ec2-vpcendpointservice-acceptancerequired
     */
    acceptanceRequired: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpointService`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCEndpointServiceProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCEndpointServicePermissions`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html
 */
export interface CfnVPCEndpointServicePermissionsProps {
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.ServiceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-serviceid
     */
    readonly serviceId: string;
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-allowedprincipals
     */
    readonly allowedPrincipals?: string[];
}
/**
 * A CloudFormation `AWS::EC2::VPCEndpointServicePermissions`
 *
 * @cloudformationResource AWS::EC2::VPCEndpointServicePermissions
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html
 */
export declare class CfnVPCEndpointServicePermissions extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCEndpointServicePermissions";
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.ServiceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-serviceid
     */
    serviceId: string;
    /**
     * `AWS::EC2::VPCEndpointServicePermissions.AllowedPrincipals`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcendpointservicepermissions.html#cfn-ec2-vpcendpointservicepermissions-allowedprincipals
     */
    allowedPrincipals: string[] | undefined;
    /**
     * Create a new `AWS::EC2::VPCEndpointServicePermissions`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCEndpointServicePermissionsProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCGatewayAttachment`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html
 */
export interface CfnVPCGatewayAttachmentProps {
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCGatewayAttachment.InternetGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-internetgatewayid
     */
    readonly internetGatewayId?: string;
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpnGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpngatewayid
     */
    readonly vpnGatewayId?: string;
}
/**
 * A CloudFormation `AWS::EC2::VPCGatewayAttachment`
 *
 * @cloudformationResource AWS::EC2::VPCGatewayAttachment
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html
 */
export declare class CfnVPCGatewayAttachment extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCGatewayAttachment";
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCGatewayAttachment.InternetGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-internetgatewayid
     */
    internetGatewayId: string | undefined;
    /**
     * `AWS::EC2::VPCGatewayAttachment.VpnGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html#cfn-ec2-vpcgatewayattachment-vpngatewayid
     */
    vpnGatewayId: string | undefined;
    /**
     * Create a new `AWS::EC2::VPCGatewayAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCGatewayAttachmentProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPCPeeringConnection`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html
 */
export interface CfnVPCPeeringConnectionProps {
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerVpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peervpcid
     */
    readonly peerVpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-vpcid
     */
    readonly vpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerOwnerId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerownerid
     */
    readonly peerOwnerId?: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRegion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerregion
     */
    readonly peerRegion?: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerrolearn
     */
    readonly peerRoleArn?: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::VPCPeeringConnection`
 *
 * @cloudformationResource AWS::EC2::VPCPeeringConnection
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html
 */
export declare class CfnVPCPeeringConnection extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPCPeeringConnection";
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerVpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peervpcid
     */
    peerVpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.VpcId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-vpcid
     */
    vpcId: string;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerOwnerId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerownerid
     */
    peerOwnerId: string | undefined;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRegion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerregion
     */
    peerRegion: string | undefined;
    /**
     * `AWS::EC2::VPCPeeringConnection.PeerRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-peerrolearn
     */
    peerRoleArn: string | undefined;
    /**
     * `AWS::EC2::VPCPeeringConnection.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpcpeeringconnection.html#cfn-ec2-vpcpeeringconnection-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::VPCPeeringConnection`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPCPeeringConnectionProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPNConnection`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 */
export interface CfnVPNConnectionProps {
    /**
     * `AWS::EC2::VPNConnection.CustomerGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
     */
    readonly customerGatewayId: string;
    /**
     * `AWS::EC2::VPNConnection.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
     */
    readonly type: string;
    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     */
    readonly staticRoutesOnly?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::VPNConnection.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::VPNConnection.TransitGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-transitgatewayid
     */
    readonly transitGatewayId?: string;
    /**
     * `AWS::EC2::VPNConnection.VpnGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
     */
    readonly vpnGatewayId?: string;
    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     */
    readonly vpnTunnelOptionsSpecifications?: Array<CfnVPNConnection.VpnTunnelOptionsSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EC2::VPNConnection`
 *
 * @cloudformationResource AWS::EC2::VPNConnection
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html
 */
export declare class CfnVPNConnection extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNConnection";
    /**
     * `AWS::EC2::VPNConnection.CustomerGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-customergatewayid
     */
    customerGatewayId: string;
    /**
     * `AWS::EC2::VPNConnection.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-type
     */
    type: string;
    /**
     * `AWS::EC2::VPNConnection.StaticRoutesOnly`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-StaticRoutesOnly
     */
    staticRoutesOnly: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::VPNConnection.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::VPNConnection.TransitGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-transitgatewayid
     */
    transitGatewayId: string | undefined;
    /**
     * `AWS::EC2::VPNConnection.VpnGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpngatewayid
     */
    vpnGatewayId: string | undefined;
    /**
     * `AWS::EC2::VPNConnection.VpnTunnelOptionsSpecifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications
     */
    vpnTunnelOptionsSpecifications: Array<CfnVPNConnection.VpnTunnelOptionsSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EC2::VPNConnection`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNConnectionProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnVPNConnection {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html
     */
    interface VpnTunnelOptionsSpecificationProperty {
        /**
         * `CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.PreSharedKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey
         */
        readonly preSharedKey?: string;
        /**
         * `CfnVPNConnection.VpnTunnelOptionsSpecificationProperty.TunnelInsideCidr`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr
         */
        readonly tunnelInsideCidr?: string;
    }
}
/**
 * Properties for defining a `AWS::EC2::VPNConnectionRoute`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html
 */
export interface CfnVPNConnectionRouteProps {
    /**
     * `AWS::EC2::VPNConnectionRoute.DestinationCidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
     */
    readonly destinationCidrBlock: string;
    /**
     * `AWS::EC2::VPNConnectionRoute.VpnConnectionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
     */
    readonly vpnConnectionId: string;
}
/**
 * A CloudFormation `AWS::EC2::VPNConnectionRoute`
 *
 * @cloudformationResource AWS::EC2::VPNConnectionRoute
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html
 */
export declare class CfnVPNConnectionRoute extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNConnectionRoute";
    /**
     * `AWS::EC2::VPNConnectionRoute.DestinationCidrBlock`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-cidrblock
     */
    destinationCidrBlock: string;
    /**
     * `AWS::EC2::VPNConnectionRoute.VpnConnectionId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-connection-route.html#cfn-ec2-vpnconnectionroute-connectionid
     */
    vpnConnectionId: string;
    /**
     * Create a new `AWS::EC2::VPNConnectionRoute`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNConnectionRouteProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPNGateway`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html
 */
export interface CfnVPNGatewayProps {
    /**
     * `AWS::EC2::VPNGateway.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-type
     */
    readonly type: string;
    /**
     * `AWS::EC2::VPNGateway.AmazonSideAsn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-amazonsideasn
     */
    readonly amazonSideAsn?: number;
    /**
     * `AWS::EC2::VPNGateway.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EC2::VPNGateway`
 *
 * @cloudformationResource AWS::EC2::VPNGateway
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html
 */
export declare class CfnVPNGateway extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNGateway";
    /**
     * `AWS::EC2::VPNGateway.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-type
     */
    type: string;
    /**
     * `AWS::EC2::VPNGateway.AmazonSideAsn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-amazonsideasn
     */
    amazonSideAsn: number | undefined;
    /**
     * `AWS::EC2::VPNGateway.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gateway.html#cfn-ec2-vpngateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EC2::VPNGateway`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNGatewayProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VPNGatewayRoutePropagation`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html
 */
export interface CfnVPNGatewayRoutePropagationProps {
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.RouteTableIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-routetableids
     */
    readonly routeTableIds: string[];
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.VpnGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-vpngatewayid
     */
    readonly vpnGatewayId: string;
}
/**
 * A CloudFormation `AWS::EC2::VPNGatewayRoutePropagation`
 *
 * @cloudformationResource AWS::EC2::VPNGatewayRoutePropagation
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html
 */
export declare class CfnVPNGatewayRoutePropagation extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VPNGatewayRoutePropagation";
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.RouteTableIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-routetableids
     */
    routeTableIds: string[];
    /**
     * `AWS::EC2::VPNGatewayRoutePropagation.VpnGatewayId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpn-gatewayrouteprop.html#cfn-ec2-vpngatewayrouteprop-vpngatewayid
     */
    vpnGatewayId: string;
    /**
     * Create a new `AWS::EC2::VPNGatewayRoutePropagation`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVPNGatewayRoutePropagationProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::Volume`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html
 */
export interface CfnVolumeProps {
    /**
     * `AWS::EC2::Volume.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-availabilityzone
     */
    readonly availabilityZone: string;
    /**
     * `AWS::EC2::Volume.AutoEnableIO`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-autoenableio
     */
    readonly autoEnableIo?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Volume.Encrypted`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-encrypted
     */
    readonly encrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::EC2::Volume.Iops`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-iops
     */
    readonly iops?: number;
    /**
     * `AWS::EC2::Volume.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::EC2::Volume.Size`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-size
     */
    readonly size?: number;
    /**
     * `AWS::EC2::Volume.SnapshotId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-snapshotid
     */
    readonly snapshotId?: string;
    /**
     * `AWS::EC2::Volume.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::EC2::Volume.VolumeType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-volumetype
     */
    readonly volumeType?: string;
}
/**
 * A CloudFormation `AWS::EC2::Volume`
 *
 * @cloudformationResource AWS::EC2::Volume
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html
 */
export declare class CfnVolume extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::Volume";
    /**
     * `AWS::EC2::Volume.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-availabilityzone
     */
    availabilityZone: string;
    /**
     * `AWS::EC2::Volume.AutoEnableIO`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-autoenableio
     */
    autoEnableIo: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Volume.Encrypted`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-encrypted
     */
    encrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EC2::Volume.Iops`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-iops
     */
    iops: number | undefined;
    /**
     * `AWS::EC2::Volume.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::EC2::Volume.Size`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-size
     */
    size: number | undefined;
    /**
     * `AWS::EC2::Volume.SnapshotId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-snapshotid
     */
    snapshotId: string | undefined;
    /**
     * `AWS::EC2::Volume.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EC2::Volume.VolumeType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volume.html#cfn-ec2-ebs-volume-volumetype
     */
    volumeType: string | undefined;
    /**
     * Create a new `AWS::EC2::Volume`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVolumeProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::EC2::VolumeAttachment`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html
 */
export interface CfnVolumeAttachmentProps {
    /**
     * `AWS::EC2::VolumeAttachment.Device`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-device
     */
    readonly device: string;
    /**
     * `AWS::EC2::VolumeAttachment.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-instanceid
     */
    readonly instanceId: string;
    /**
     * `AWS::EC2::VolumeAttachment.VolumeId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-volumeid
     */
    readonly volumeId: string;
}
/**
 * A CloudFormation `AWS::EC2::VolumeAttachment`
 *
 * @cloudformationResource AWS::EC2::VolumeAttachment
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html
 */
export declare class CfnVolumeAttachment extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EC2::VolumeAttachment";
    /**
     * `AWS::EC2::VolumeAttachment.Device`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-device
     */
    device: string;
    /**
     * `AWS::EC2::VolumeAttachment.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-instanceid
     */
    instanceId: string;
    /**
     * `AWS::EC2::VolumeAttachment.VolumeId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-ebs-volumeattachment.html#cfn-ec2-ebs-volumeattachment-volumeid
     */
    volumeId: string;
    /**
     * Create a new `AWS::EC2::VolumeAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVolumeAttachmentProps);
    protected readonly cfnProperties: {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
