import { ICertificate } from '@aws-cdk/aws-certificatemanager';
import { IOrigin, ErrorResponse, PriceClass } from '@aws-cdk/aws-cloudfront';
import { Construct, Duration, RemovalPolicy } from '@aws-cdk/core';
import { IAuthorization, IStaticSiteAuthorization, ISpaAuthorization } from './authorizations';
export interface CommonDistributionProps {
    readonly origin?: IOrigin;
    readonly priceClass?: PriceClass;
    readonly certificate?: ICertificate;
    readonly removalPolicy?: RemovalPolicy;
}
export interface BaseDistributionProps extends CommonDistributionProps {
    readonly authorization: IAuthorization;
    readonly errorResponses?: ErrorResponse[];
}
export declare class BaseDistribution extends Construct {
    constructor(scope: Construct, id: string, props: BaseDistributionProps);
    private defaultOrigin;
}
export interface StaticSiteDistributionProps extends CommonDistributionProps {
    readonly authorization: IStaticSiteAuthorization;
    readonly errorResponses?: ErrorResponse[];
}
export declare class StaticSiteDistribution extends BaseDistribution {
    constructor(scope: Construct, id: string, props: StaticSiteDistributionProps);
}
export interface SpaDistributionProps extends CommonDistributionProps {
    readonly authorization: ISpaAuthorization;
    /**
     * The minimum amount of time, in seconds, that you want CloudFront
     * to cache the HTTP status code specified in ErrorCode.
     *
     * @default 300 seconds
     */
    readonly ttl?: Duration;
}
export declare class SpaDistribution extends BaseDistribution {
    constructor(scope: Construct, id: string, props: SpaDistributionProps);
}
