"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsInterfaceEndpoints = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ec2 = require("aws-cdk-lib/aws-ec2");
const change_case_1 = require("change-case");
const constructs_1 = require("constructs");
class AwsInterfaceEndpoints extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { exportPrefix = 'SessionManagerEndpoints', services } = props;
        const endpointProps = {
            vpc: props.vpc,
            subnets: props.subnets || { subnetType: ec2.SubnetType.PRIVATE_ISOLATED },
            open: typeof props.open !== 'undefined' ? props.open : true,
            securityGroups: props.securityGroups,
        };
        this.endpointServices = services.map(service => ({
            service: service.service,
            endpoint: this.defineEndpoint(this, service.id, {
                service: service.service,
                ...endpointProps,
                exportPrefix,
            }),
        }));
    }
    static fromAttributes(scope, id, props) {
        const { exportPrefix = 'SessionManagerEndpoints', services } = props;
        class Import extends aws_cdk_lib_1.Resource {
            constructor(_scope, _id) {
                super(_scope, _id);
                this.endpointServices = services.map(service => ({
                    service: service.service,
                    endpoint: ec2.InterfaceVpcEndpoint.fromInterfaceVpcEndpointAttributes(_scope, service.id, {
                        port: service.service.port,
                        vpcEndpointId: cdk.Fn.importValue(`${exportPrefix}/${change_case_1.pascalCase(service.service.name)}`),
                    }),
                }));
            }
            allowDefaultPromFrom(connectable) {
                this.endpointServices.forEach(endpointService => endpointService.endpoint.connections.allowDefaultPortFrom(connectable));
            }
        }
        return new Import(scope, id);
    }
    defineEndpoint(scope, id, props) {
        const endpoint = new ec2.InterfaceVpcEndpoint(scope, id, props);
        const tags = cdk.Tags.of(endpoint);
        tags.add('Name', endpoint.node.path);
        const { exportPrefix, service } = props;
        new cdk.CfnOutput(this, `vpcEndpointId${id}`, {
            value: endpoint.vpcEndpointId,
            exportName: `${exportPrefix}/${change_case_1.pascalCase(service.name)}`,
        });
        return endpoint;
    }
    allowDefaultPromFrom(connectable) {
        this.endpointServices.forEach(endpointService => endpointService.endpoint.connections.allowDefaultPortFrom(connectable));
    }
}
exports.AwsInterfaceEndpoints = AwsInterfaceEndpoints;
_a = JSII_RTTI_SYMBOL_1;
AwsInterfaceEndpoints[_a] = { fqn: "@alma-cdk/aws-interface-endpoints.AwsInterfaceEndpoints", version: "0.0.5" };
AwsInterfaceEndpoints.SessionManagerConnect = [
    { id: 'Ssm', service: ec2.InterfaceVpcEndpointAwsService.SSM },
    { id: 'Ec2Messages', service: ec2.InterfaceVpcEndpointAwsService.EC2_MESSAGES },
    { id: 'SsmMessages', service: ec2.InterfaceVpcEndpointAwsService.SSM_MESSAGES },
];
//# sourceMappingURL=data:application/json;base64,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