from infiniguard_api.lib.logging import iguard_logging

from infiniguard_api.lib.rest.common import http_code

from infiniguard_api.common import messages

from infiniguard_api.lib.rest.pagination import Pagination

from infiniguard_api.lib.hw.output_parser import parse_config_style, check_command_successful

from infiniguard_api.lib.rest.common import (build_error_message,
                                             build_paginated_response,
                                             build_entity_response,
                                             build_error_model)

from infiniguard_api.lib.hw.cli_handler import run_syscli1

from infiniguard_api.controller.ost.lsu import list_lsus

log = iguard_logging.get_logger(__name__)

def create_ostair(cli_dict):
    try:
        if cli_dict.get('errors', None):
            error = build_error_model(
                error_message=build_error_message(cli_dict['errors']),
                error_code='WRONG_FIELD_VALUES',)
            return (build_entity_response(error=error), 400)
    
        result, errmsg = run_syscli1('add', 'ostair', check_command_successful, **cli_dict)
        if not result:
            error = build_error_model(
            error_message=[errmsg],
            error_code='COMMAND FAILED')
            return (build_entity_response(error=error), 400)

        #read back object just created
        new_cli_dict = dict(storageserver=cli_dict['sourcess'], name=cli_dict['sourcelsu'])
        return list_lsus(new_cli_dict, None, http_code.CREATED, True)

    except Exception as e:
        error = build_error_model(
            error_message=[e.message],
            error_code='UNEXPECTED_EXCEPTION')
        return (build_entity_response(error=error), 400)

def update_ostair(cli_dict):
    try:
        if cli_dict.get('errors', None):
            error = build_error_model(
                error_message=build_error_message(cli_dict['errors']),
                error_code='WRONG_FIELD_VALUES',)
            return (build_entity_response(error=error), 400)
    
        sourcess = cli_dict.get('sourcess', None)
        sourcelsu = cli_dict.get('sourcelsu', '_PhysicalLSU')
        cli_dict['sourcess'] = sourcess
        cli_dict['sourcelsu'] = sourcelsu
        cli_args = []
        operation = cli_dict.pop('operation', None)
        if operation:
            cli_args.append(operation)
        result, errmsg = run_syscli1('edit', 'ostair', check_command_successful, *cli_args, **cli_dict)

        if not result:
            error = build_error_model(
            error_message=[errmsg],
            error_code='COMMAND FAILED')
            return (build_entity_response(error=error), 400)

        #read back object just created
        cli_dict = dict(storageserver=cli_dict['sourcess'], name=cli_dict['sourcelsu'])
        return list_lsus(cli_dict, None, http_code.OK, True)

    except Exception as e:
        error = build_error_model(
            error_message=[e.message],
            error_code='UNEXPECTED_EXCEPTION')
        return (build_entity_response(error=error), 400)

def delete_ostair(cli_dict):
    try:
        if cli_dict.get('errors', None):
            error = build_error_model(
                error_message=build_error_message(cli_dict['errors']),
                error_code='WRONG_FIELD_VALUES',)
            return (build_entity_response(error=error), 400)

        result, errmsg = run_syscli1('del', 'ostair', check_command_successful, **cli_dict)
        if not result:
            error = build_error_model(
            error_message=[errmsg],
            error_code='COMMAND FAILED')
            return (build_entity_response(error=error), 400)
        name = 'ostair for {}/{}'.format(cli_dict['sourcess'], cli_dict['sourcelsu'])
        data = dict(message=messages.DELETE_SUCCESS_MSG.format(name))
        return (data, http_code.OK)
    except Exception as e:
        error = build_error_model(
            error_message=[e.message],
            error_code='UNEXPECTED_EXCEPTION')
        return (build_entity_response(error=error), 400)
