#!/usr/bin/env python
# -*- coding: UTF-8 -*-
#
# generated by wxGlade 0.9.5 on Thu Apr  2 08:19:01 2020
#
#----------------------------------------------------------------------------
# Name:         ldmStorageFolderFrm.py
# Purpose:      ldmStorageFolderFrm.py
#               GUI for ldmStorageFolder
# Author:       Walter Obweger
#
# Created:      20200402
# CVS-ID:       $Id$
# Copyright:    (c) 2020 by Walter Obweger
# Licence:      MIT
#----------------------------------------------------------------------------


import wx
import os
import logging
import traceback

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode
# end wxGlade

from lindworm import __version__
import lindworm.ldmGui as ldmGui
from lindworm.ldmArg import ldmArg
from lindworm.ldmWidApp import ldmWidApp
from lindworm.ldmWidFrmAui import ldmWidFrmAui
from lindworm.ldmGuiThd import ldmGuiThd
from lindworm.ldmWidTree import ldmWidTree
from lindworm.ldmWidThd import ldmWidThd
from lindworm.ldmStorageFolder import ldmStorageFolder

class ldmStorageFolderThd(ldmWidThd):
    def prcCmd(self,sCmd):
        try:
            # +++++ beg:
            self.logDbg('ldmStorageFolderFrm::prcCmd sCmd:%r',sCmd)
            if sCmd=='start':
                oNty=self.oThd.GetNty()
                self.oThd.Do('%s'%(self.sSrcDN),
                            self.prcFld,*(),
                            sCfgFN=self.sCfgFN,
                            sSrcDN=self.sSrcDN,
                            sBldFN=self.sBldFN,
                            sBldDN=self.sBldDN,
                            iShaMB=self.iShaMB,
                            oNty=oNty)
            # ----- end:
            return 0
        except:
            self.logTB()
            return -1

class ldmStorageFolderFrm(ldmWidFrmAui):
    WILDCARD_JSON=["json file (*.json)|*.json",
            "All files (*.*)|*.*"]
    def __initCfg__(self,**kwargs):
        try:
            # +++++ beg:initialize
            sOrg='ldmStorageFolderFrm::__initCfg__'
            self.logDbg('beg:%s'%(sOrg))
            ldmWidFrmAui.__initCfg__(self,**kwargs)
            # ----- end:initialize
            # +++++ beg:
            self.setCfgWid('toolbar','command','1')
            #self.dCfgWidDft['frmMain']['sToolBarCommand']='1'
            # ----- end:
            # +++++ beg:finalize
            self.logDbg('end:%s'%(sOrg))
            # ----- end:finalize
        except:
            self.logTB()
    def __initPanLf__(self,**kwargs):
        try:
            # +++++ beg:initialize
            sOrg='ldmStorageFolderFrm::__initPanLf__'
            self.logDbg('beg:%s',sOrg)
            # ----- end:initialize
            # +++++ beg:
            # ----- end:
            # +++++ beg:finalize
            self.logDbg('end:%s',sOrg)
            # ----- end:finalize
        except:
            self.logTB()
    def __initPanCt__(self,**kwargs):
        try:
            # +++++ beg:initialize
            sOrg='ldmStorageFolderFrm::__initPanLf__'
            self.logDbg('beg:%s',sOrg)
            # ----- end:initialize
            # +++++ beg:
            wNb=ldmWidFrmAui.__initPanCt__(self,**kwargs)
            self.widMainNB=wNb
            # ----- end:
            # +++++ beg:
            oWid=ldmWidThd(parent=wNb,iLv=0,
                        size=(200,120),sLogger='thdFdr',
                        )
            wNb.AddPage(oWid.GetWid(),'thd')
            self.wThd=oWid
            # ----- end:
            self.wThd.SetFunc('start','launch',self.DoStart)
            # +++++ beg:finalize
            self.logDbg('end:%s',sOrg)
            # ----- end:finalize
            return wNb
        except:
            self.logTB()
            return None
    def OnCmd00(self,evt):
        try:
            # +++++ beg:initialize
            sOrg='ldmStorageFolderFrm::OnCmd00'
            self.logDbg('beg:%s',sOrg)
            # ----- end:initialize
            # +++++ beg:
            # ----- end:
            # +++++ beg:finalize
            self.logDbg('end:%s'%(sOrg))
            # ----- end:finalize
        except:
            self.logTB()
    def OnCmd01(self,evt):
        try:
            # +++++ beg:initialize
            sOrg='ldmStorageFolderFrm::OnCmd00'
            self.logDbg('beg:%s',sOrg)
            # ----- end:initialize
            # +++++ beg:
            oThd=self.wThd.GetThd()
            self.DoStart(oThd)
            # ----- end:
            # +++++ beg:finalize
            self.logDbg('end:%s'%(sOrg))
            # ----- end:finalize
        except:
            self.logTB()
    def __initDat__(self,**kwargs):
        try:
            # +++++ beg:initialize
            sOrg='ldmStorageFolderFrm::__initDat__'
            self.logDbg('beg:%s',sOrg)
            # ----- end:initialize
            # +++++ beg:
            self.iShaMB=1
            # ----- end:
            # +++++ beg:
            self.oFld=ldmStorageFolder(iVerbose=self.iVerbose)
            #iRet=oFld.loadCfg(sCfgFN)
            # ----- end:
            # +++++ beg:finalize
            self.logDbg('end:%s',sOrg)
            # ----- end:finalize
        except:
            self.logTB()
    def __initPrp__(self,**kwargs):
        try:
            # +++++ beg:initialize
            sOrg='ldmStorageFolderFrm::__initPrp__'
            self.logDbg('beg:%s',sOrg)
            iRet=0
            # ----- end:initialize
            # +++++ beg:
            sBldFN=self.pnCLI.txtBldFN.GetValue()
            self.logDbg('sBldFN:%s',sBldFN)
            #iRet=self.shwFdr(sBldFN,sKey='0')
            if iRet>0:
                self.widMainNB.SetSelection(0)
            # ----- end:
            # +++++ beg:finalize
            self.logDbg('end:%s',sOrg)
            # ----- end:finalize
        except:
            self.logTB()
    def DoStart(self,oThd=None):
        try:
            # +++++ beg:initialize
            logging.debug('beg:OnStart')
            iRet=0
            # ----- end:initialize
            # +++++ beg:
            #sSrcDN=self.txtSrcDN.GetValue()
            sSrcDN=self.pnCLI.txtSrcDN.GetValue()
            sCfgFN=self.pnCLI.txtCfgFN.GetValue()
            sBldFN=self.pnCLI.txtBldFN.GetValue()
            sBldDN=self.pnCLI.txtBldDN.GetValue()
            #sSrcDN=self.pnCLI.txtSrcDN.GetValue()
            iShaMB=self.pnCLI.spnShaMbInt.GetValue()
            #iShaMB=self.GetShaMbChoice()
            # ----- end:
            # +++++ beg:schedule action
            oNty=oThd.GetNty()
            oThd.Do('%s'%(sSrcDN),
                        self.prcFld,*(),
                        sCfgFN=sCfgFN,
                        sSrcDN=sSrcDN,
                        sBldFN=sBldFN,
                        sBldDN=sBldDN,
                        iShaMB=iShaMB,
                        oNty=oNty)
            self.widMainNB.SetSelection(0)
            # ----- end:schedule action
            # +++++ beg:finalize
            logging.debug('end:OnStart iRet:%d'%(iRet))
            # ----- end:finalize
            return 1
        except:
            self.oFld.logTB()
    def prcFld(self,sCfgFN=None,sSrcDN=None,
                sBldFN=None,sBldDN=None,
                iShaMB=0,oNty=None):
        try:
            # +++++ beg:initialize
            sOrg='ldmStorageFolderFrm::prcFld'
            self.oFld.logDbg('beg:%s sSrcDN:%s',sOrg,sSrcDN)
            self.oFld.clrAll()
            iRet=self.oFld.loadCfg(sCfgFN)
            # ----- end:initialize
            # +++++ beg:register action
            #self.oFld.logDbg('    sSrcDN:%r',sSrcDN)
            iRet=self.oFld.prcBeg(sSrcDN,oRef=None)
            if iRet>0:
                if oNty is not None:
                    oNty.SetPhase('%r ...'%(sSrcDN))
                    oNty.SetStatus('')
                iRet+=1
            else:
                if oNty is not None:
                    oNty.SetPhase('%r skipped. iRet:%d'%(sSrcDN,iRet))
                    oNty.SetStatus('failed start')
                return -1
            # ----- end:register action
            # +++++ beg:perform action
            iRet=self.oFld.prcExc()#(oGtrMD=self)
            if iRet>0:
                if oNty is not None:
                    oNty.SetPhase('%r finalize ...'%(sSrcDN))
            else:
                if oNty is not None:
                    oNty.SetPhase('%r aborted. iRet:%d'%(sSrcDN,iRet))
                    oNty.SetStatus('failed to process')
                return -2
            # ----- end:perform action
            # +++++ beg:finalize action
            self.oFld.logDbg('    %s iShaMB:%r',sOrg,iShaMB)
            iRetFdr=self.oFld.prcEnd(iShaMB=iShaMB,oNty=oNty)
            if iRetFdr>0:
                if oNty is not None:
                    oNty.SetPhase('%r finished.'%(sSrcDN))
                iRet+=1
            else:
                if oNty is not None:
                    oNty.SetPhase('%r aborted. iRet:%d'%(sSrcDN,iRetFdr))
                    oNty.SetStatus('failed to finalize')
            # ----- end:finalize action
            # +++++ beg:save result to json
            if iRetFdr>0:
                self.oFld.logDbg('    %s sBldFN:%r sBldDN:%r sDefEnd:%r',
                            sOrg,sBldFN,sBldDN,self.oFld.sDefEnd)
                if sBldFN is None:
                    sBldFN=None
                else:
                    if len(sBldFN)>0:
                        if sBldFN=='0':
                            sBldFN=0
                        elif sBldFN=='1':
                            sBldFN=1
                    else:
                        sBldFN=None
                iRetSave=self.oFld.saveDat(sBldFN,sDN=sBldDN,
                                    lKey=[self.oFld.sDefEnd],
                                    sAtr='dDat')
                if iRetSave>0:
                    if oNty is not None:
                        oNty.SetStatus('saved FN:%r DN:%r'%(sBldFN,sBldDN))
                    iRet+=1
                else:
                    oNty.SetStatus('save failed iRetSave:%d'%(iRetSave))
            # ----- end:save result to json
            # +++++ beg:
            if oNty is not None:
                oNty.finStatus()
                #self.oThd.delay(iCnt=5)
            self.oFld.logDbg('end:%s iRet:%d',sOrg,iRet)
            # ----- end:
            return iRet
        except:
            self.oFld.logTB()
            return -1


# end of class ldmStorageFolderFrm


def main(args=None):
    # +++++ beg:
    # ----- end:
    
    # +++++ beg:init
    iRet=0
    iVerbose=5                                          # 20190624 wro:set default verbose level
    # ----- end:init
    # +++++ beg:define CLI arguments
    usage = "usage: %prog [options]"
    oArg=ldmArg(sUsage=usage,sVer=__version__,iVerbose=0)
    oArg.addOpt('sCfgFN',
            sDft='ldmStorageFolderCfg.json',
            sHlp='configuration file',
            sVerbose='config FN',
            sMeta='pyGatherMDCfg.json')
    oArg.addOpt('sSrcDN',
            sDft='./',
            sHlp='source folder',
            sVerbose='source DN',
            sMeta='path/to/folder/to/read')
    oArg.addOpt('sBldDN',
            sDft='./',
            sHlp='build directory',
            sVerbose='build DN',
            sMeta='path/to/output/folder')
    oArg.addOpt('sBldFN',
            sDft='./',
            sHlp='build directory',
            sVerbose='build FN',
            sMeta='path/to/output/folder')
    oArg.addOpt('sShaMbInt',
            sDft='1',
            sHlp='size boundary;-1 <= x <= 128',
            sVerbose='limit',
            sMeta='full')
    oArg.addOpt('sLogFN',
            sDft='./log/ldmStorageFolder.log',
            sHlp='log filename',
            sVerbose='log FN',
            sMeta='./log/ldmStorageFolder.log')
    # ----- end:define CLI arguments
    # +++++ beg:parse command line
    iRet=oArg.prcParse(args)
    if oArg.GetVerbose(10):
        print('ldmArg.prcParse:%d'%(iRet))
        print(" log FN:     %r"%(oArg.sLogFN))
    # ----- end:parse command line
    # +++++ beg:prepare logging
    if oArg.sLogFN is not None:
        import lindworm.logUtil as logUtil
        logUtil.logInit(oArg.sLogFN,iLevel=logging.DEBUG)
    # ----- end:prepare logging
    # +++++ beg:
    app = ldmWidApp(0,
                title="lindworm storage folder",
                oArg=oArg,
                clsFrm=ldmStorageFolderFrm)
    app.MainLoop()
    iRet+=1
    # ----- end:
    return iRet

if __name__ == "__main__":
    # +++++ beg:call entry point
    main(args=None)
    # ----- end:call entry point
