# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['omnidep', 'omnidep.tst']

package_data = \
{'': ['*'],
 'omnidep.tst': ['test_cases/*',
                 'test_cases/case_insensitive_sorted/*',
                 'test_cases/case_sensitive_sorted/*',
                 'test_cases/dev_dependencies_new/*',
                 'test_cases/dev_dependencies_old/*',
                 'test_cases/unsorted/*']}

install_requires = \
['importlib-metadata>=1.1.0', 'tomli>=1.1.0']

extras_require = \
{':python_version < "3.10"': ['isort>=5.0.1']}

entry_points = \
{'console_scripts': ['omnidep = omnidep.main:script_entry_point']}

setup_kwargs = {
    'name': 'omnidep',
    'version': '0.3.2',
    'description': 'Linter to compare project dependencies against imports in source code',
    'long_description': '=======\nOmnidep\n=======\n\nA Python linter to compare a project\'s declared dependencies against the import\nstatements in its source code.\n\n.. image:: https://github.com/sjjessop/omnidep/workflows/tests/badge.svg?branch=develop\n   :alt: Test status\n   :target: https://github.com/sjjessop/omnidep/actions?query=workflow%3Atests+branch%3Adevelop\n\n.. image:: https://img.shields.io/badge/CI%20python-3.7%20%7C%203.8%20%7C%203.9%20%7C%203.10%20%7C%203.11-blue.svg\n   :alt: Tested with Python versions 3.7 3.8 3.9 3.10 3.11\n   :target: https://www.python.org/downloads/\n\n.. image:: https://img.shields.io/pypi/pyversions/omnidep\n   :alt: PyPI project\n   :target: https://pypi.org/project/omnidep/\n\n.. image:: https://img.shields.io/badge/badges-4-green.svg\n   :alt: 4 badges\n   :target: https://shields.io/\n\nPurpose\n=======\n\nProvides warnings when a project imports packages that it doesn\'t declare a\ndependency on, plus some related linting of the project dependency data.\n\nCurrently only poetry projects are supported (configured in pyproject.toml).\nThe projects that your project depends on can be packaged using any tools, but\nyour project (that omnidep analyses) currently must use poetry.\n\nInstallation\n------------\n\n.. code-block:: bash\n\n    pip install omnidep\n\nOptionally, you can also run the test suite. This would be a good idea if\nyou\'re using a new (or pre-release) version of Python not included in this\nrepo\'s CI testing.\n\n.. code-block:: bash\n\n    pip install pyOpenSSL pytest\n    pytest --pyargs omnidep.tst\n\nUsage\n-----\n\n.. code-block:: bash\n\n    omnidep pyproject.toml\n\n\nConfiguration\n-------------\n\nomnidep uses your project\'s poetry configuration to work out:\n\n* What source files to search for imports, from ``tool.poetry.packages``.\n* What dependencies your project declares, from ``tool.poetry.dependencies``.\n* What dev-dependencies your project declares, from\n  ``tool.poetry.dev-dependencies`` and ``tool.poetry.group.dev.dependences``.\n\nIf you have test code that you want omnidep to search for imports, then:\n\n* If you keep your test code "inside" your project, then list it in\n  ``local-test-paths`` in the ``[omnidep.config]`` section described below.\n* If you keep your test code "outside" your project, then use the ``--tests``\n  command-line option to locate it, otherwise omnidep ignores it. You also need\n  to configure ``local-test-packages`` if some of your test files import other\n  test files, for example if you have shared helper functions.\n\nomnidep is configured using the ``pyproject.toml`` file, and specifically the\n``[tool.omnidep]`` section. The following config keys are recognised.\nUnrecognised keys are rejected and omnidep will not run (so, if you want to\nuse a particular key then you should require at least the minimum version of\nomnidep that recognises it).\n\nignore-imports\n^^^^^^^^^^^^^^\n\nExample: ``ignore-imports = ["X"]``\n\nSince: 0.2.0\n\nCauses omnidep to ignore all import statements from X, for example\n``import X``, ``from X.Y import Z``. omnidep will behave as if your code does\nnot use package X, even if it does. X must be a top-level package. It is not\ncurrently possible to selectively ignore a sub-package (like X.Y), nor is it\ncurrently possible to ignore imports from some files but not others.\n\nchild-packages\n^^^^^^^^^^^^^^\n\nExample: ``child-packages = {boto3 = ["botocore"]}``\n\nSince: 0.2.0\n\nCauses omnidep to consider a dependency on boto3 to also supply botocore. This\nsaves you having to explictly list the child as a dependency of your project.\nYou chould only do this when the child is inherant to the parent, not just\nbecause by chance you pull in a package you need via an indirect dependency.\nThe reason is that indirect dependencies can change, and the project that you\ndo depend on might not require the same version of the child that your usage\nrequires. Only if the projects are closely related can you assume that the\nversion you require of one will provide the features you need from the other.\n\nignore-dependencies\n^^^^^^^^^^^^^^^^^^^\n\nExample: ``ignore-dependencies = ["X"]``\n\nSince: 0.2.0\n\nCauses omnidep to ignore the project X listed in your project\'s dependencies.\nomnidep will behave as if your project does not depend on X, even if it does.\n\nignore-dependencies-order\n^^^^^^^^^^^^^^^^^^^^^^^^^\n\nExample: ``ignore-dependencies-order = true``\n\nSince: 0.2.0\n\nCauses omnidep to skip the check that your dependencies are alphabetically\nordered.\n\nignore-dev-dependencies-order\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nExample: ``ignore-dev-dependencies-order = true``\n\nSince: 0.2.0\n\nCauses omnidep to skip the check that your dev-dependencies are alphabetically\nordered.\n\nlocal-test-paths\n^^^^^^^^^^^^^^^^\n\nExample: ``local-test-paths = ["myproject/tests/"]``\n\nSince: 0.2.0\n\nCauses omnidep to treat all code in ``myproject.tests`` as test code, meaning\nthat anything it imports can be provided either by your projects dependencies\nor by its dev-dependencies. Imports from code that is not test code must be\nprovided by non-dev dependencies.\n\nlocal-test-packages\n^^^^^^^^^^^^^^^^^^^\n\nExample: ``local-test-packages = ["tests"]``\n\nSince: 0.2.0\n\nCauses omnidep to treat ``tests`` as part of the current project, but only when\nconsidering imports that appear in test code. Use this when your test code is\nnot shipped as part of your project.\n\nError codes explained\n---------------------\n\nX, Y, P, Q, R, represent the names of imports or dependencies, depending on the\nmessage.\n\nODEP001\n^^^^^^^\n\n| ``package \'X\' is imported but not listed in dependencies``\n| ``package \'X\' is imported but not listed in dev-dependencies``\n|\n\nX is the name you imported, which is not necessarily the same as the name of\nthe project you have to install (for example the project ``beautifulsoup4``\ninstalls the package ``bs4``). omnidep does its best to find what project your\ndesired package comes from, but if it fails, or if you don\'t have a suitable\ndependency, then this is the result.\n\nTo fix, choose one of the following:\n\n* List the project name in your dependencies. If the package is used from test\n  code, then the dependency can be either dev or non-dev. If the package is\n  used from non-test code, then the dependency needs to be non-dev.\n* To ignore the import, add it to the list of ignored imports in your\n  ``[tool.omnidep]`` config, like ``ignore-imports = ["X"]``.\n* The package might come from a dependency of a dependency, and you might\n  prefer not to explicitly list it as a direct dependency too, so you can list\n  X as a child of some other dependency that you do list. You should only do\n  this when the indirect dependency is inherent to the direct dependency, for\n  example ``boto3`` provides ``botocore``. Add\n  ``child-packages = {something = ["X"]}`` to your ``[tool.omnidep]`` config,\n  meaning that the project named "something" provides "X", and so a dependency\n  on "something" is acceptable in place of a dependency on "X".\n\nODEP002\n^^^^^^^\n\n``module \'X\' is imported but not installed``\n\nNot only is there no dependency found that provides X, but X isn\'t even\ncurrently installed. omnidep relies on locally installed metadata to help it\nfind what dependencies correspond to what imports.\n\nTo fix, choose one of the following:\n\n* If your project has X as a dependency, but you haven\'t installed your\n  project then install your project, bringing in its dependencies.\n* Add a dependency that provides X.\n* Ignore the import by listing it in your in your ``[tool.omnidep]`` config,\n  like ``ignore-imports = ["X"]``.\n\nODEP003\n^^^^^^^\n\n``Namespace package found: any of [\'P\', \'Q\', \'R\'] might provide \'X\'``\n\nIf projects P, Q, and R all provide code in the Python package X, then omnidep\ndoesn\'t know which one you need in order to satisfy a given import. If you\ndeclare dependencies on all of them (that is, all the ones you currently have\ninstalled), then omnidep is satisfied. If you depend on some but not others,\nthen you get this message.\n\nTo fix, choose one of the following:\n\n* If you don\'t need the ones you don\'t declare dependencies on, and they are\n  installed accidentally, then uninstall them.\n* If appropriate, declare dependencies on all of P, Q, and R. However, this\n  might not be appropriate because P and Q might be genuine direct dependencies\n  of your code, whereas R was pulled in indirectly via something else. You\n  don\'t want to have to list indirect dependencies as direct dependencies.\n* Otherwise you have to resolve for yourself whether your dependencies are\n  adequate, then ignore the import with ``ignore-imports = ["X"]`` in your\n  ``[tool.omnidep]`` config.\n\n\nODEP004\n^^^^^^^\n\n``Namespace package found: any of [\'P\', \'Q\', \'R\'] might provide \'X\', and there are no dependencies on any of them``\n\nIf projects P, Q, and R all provide code in the Python package X, then omnidep\ndoesn\'t know which one you need in order to satisfy a given import. If you\ndeclare dependencies on all of them (that is, all the ones you currently have\ninstalled), then omnidep is satisfied. If you depend on none of them,\nthen you get this message.\n\nTo fix, choose one of the following:\n\n* If appropriate, declare dependencies on all of P, Q, and R. However, this\n  might not be appropriate because P and Q might be genuine direct dependencies\n  of your code, whereas R was pulled in indirectly via something else. You\n  don\'t want to have to list indirect dependencies as direct dependencies.\n* Otherwise you have to resolve for yourself whether your dependencies are\n  adequate, then ignore the import with ``ignore-imports = ["X"]`` in your\n  ``[tool.omnidep]`` config.\n\n\nODEP005\n^^^^^^^\n\n``unused dependencies in project file: {\'X\', \'Y\'}``\n\nomnidep expects you not to list any dependencies that you don\'t import. This\nmight be completely legitimate, for example:\n\n* the dependency is a plugin to some framework and will be used via some means\n  other than an explicit ``import`` in your code;\n* you are controlling the version of an indirect dependency, to deal with\n  some problem caused by unexpected breaking changes.\n\nUnused dev-dependencies are always ignored, since they tend to include linters\nand suchlike.\n\nTo fix, choose one of the following:\n\n* Remove the dependency.\n* List the dependency in your ``[tool.omnidep]`` config like\n  ``ignore-dependencies = ["X"]``.\n\nODEP006\n^^^^^^^\n\n| ``dependencies are not sorted: \'Y\' before \'X\'``\n| ``dev-dependencies are not sorted: \'Y\' before \'X\'``\n|\n\nIgnoring ``python``, which is allowed to come first, omnidep expects you to\nlist dependencies in case-insensitive alphabetical order within each section\n(dev and non-dev).\n\nTo fix, choose one of the following:\n\n* List your dependencies alphabetically.\n* Set ``ignore-dependencies-order = true`` or\n  ``ignore-dev-dependencies-order = true`` in your ``[tool.omnidep]`` config.\n\nODEP007\n^^^^^^^\n\n``dependency \'X\' is not the preferred name: consider \'Y\'``\n\nomnidep expects you to use either of two formats to name dependencies in your\nproject file: the "Normalized Name" as defined in\n`PEP 503 <https://peps.python.org/pep-0503/>`_ or the name the dependency uses\nfor itself in its metadata. Any name that normalizes to the same value will\nwork, but inconsistent naming tends to lead to confusion, or to failing to find\nmentions when you search for them.\n\nTo fix:\n\n* Use the name omnidep suggests, or the normalized name.\n\nODEP008\n^^^^^^^\n\n``Module \'X\' not under package management but found on python path``\n\nomnidep cannot find any project that provides X, but it is available to import.\nThis can happen for example if you have set up the ``PYTHONPATH`` to find the\ncode, instead of installing it as a dependency.\n\nTo fix, choose one of the following:\n\n* If this is an error, list a suitable dependency.\n* If you know what you\'re doing, and users of your project will know how to\n  supply the code that you\'re importing, then ignore the import with\n  ``ignore-imports = ["X"]`` in your ``[tool.omnidep]`` config.\n\nChangelog\n=========\n\n0.3.2\n-----\n\n* Read dev dependencies from the new location used by Poetry 1.2.0+\n* Add Python 3.11 to PyPI classifiers.\n\n0.3.1\n-----\n\n* Add Python 3.11 to the test matrix, and use separate badges in the README\n  for what is tagged on PyPI vs. what is tested.\n* Documentation improvements.\n* Uncap Python dependency. If Python ever reaches version 4, you are free to\n  install omnidep on it and see what happens!\n\n0.3.0\n-----\n\n* Breaking: When testing that dependencies are sorted, do it case-insensitive.\n* Deal with some build issues.\n\n0.2.1\n-----\n\n* Refer to online docs insted of long message in terminal.\n* Publish to PyPI.\n\n0.2.0\n-----\n\n* Minor documentation improvements.\n* Lower bounds for dependencies importlib-metadata, isort, and tomli.\n* CI test of the lower-bound versions.\n',
    'author': 'Steve Jessop',
    'author_email': '68118527+sjjessop@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sjjessop/omnidep',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7.0',
}


setup(**setup_kwargs)
