# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import requests,json
from django.conf import settings
from django.http import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from django.contrib.auth import authenticate
from dss.Serializer import serializer

from .models import UserProfile
from .utils import encode, decode

JSCODE2SESSION_URL = 'https://api.weixin.qq.com/sns/jscode2session?grant_type=authorization_code'
APPID = settings.WEIXIN_APPID
APPSECRET = settings.WEIXIN_APPSECRET


# 接受小程序发送的code，然后从微信服务器换取用户的微信身份ID
def login(request):
    code = request.GET.get('code')
    url = JSCODE2SESSION_URL + '&appid=' + APPID + '&secret=' + APPSECRET + '&js_code=' + code

    r = requests.get(url).json()
    openid = r['openid']
    session_key = r['session_key']

    try:
        userprofile = UserProfile.objects.get(wxapp_openid=openid)
        result = serializer(data=userprofile, output_type='json', datetime_format='string',include_attr=('user_id',"student_id","sn","room_id","user_class","start_date","expire_date","preuser","avatar","is_pause"))
        result_dict = json.loads(result)
        result_dict["username"]=userprofile.user.username
        result_dict["name"]=userprofile.user.first_name

        return JsonResponse(data={
            'errCode': 0,
            'token': encode(openid),
            'errMsg': "成功",
            "userInfo":json.dumps(result_dict)
        })
    except UserProfile.DoesNotExist:
        # 用户还未绑定微信账号
        return JsonResponse(data={
            'errCode': 1,
            'token': encode(openid),
            'errMsg': "未绑定账户"
        })
    except Exception as e:
        print(e)
        return JsonResponse(data={
            'errCode': 2,
            'errMsg': "发生错误"
        })


# 绑定网站的用户和微信的用户
@csrf_exempt
def user_bind(request):
    username = request.POST.get('username')
    password = request.POST.get('password')
    token = request.POST.get('token')
    print(username,password,token)
    user = authenticate(username=username, password=password)
    if user is not None and user.is_active==True:
        openid = decode(token)

        if openid:
            # existing_weixininfo = user.weixininfo_set.all()
            existing_users = UserProfile.objects.filter(wxapp_openid=openid)
            if existing_users.exists():
                # 不能重复绑定
                return JsonResponse(data={
                    'errCode': 3,
                    'errMsg': "当前微信已绑定过用户，不能重复绑定"
                })
            else:
                # 绑定成功
                user.userprofile.wxapp_openid = openid
                user.userprofile.save()
                result = serializer(data=user.userprofile, output_type='json', datetime_format='string',include_attr=('user_id',"student_id","sn","room_id","user_class","start_date","expire_date","preuser","avatar","is_pause"))
                result_dict = json.loads(result)
                result_dict["username"]=user.username
                result_dict["name"]=user.first_name
                return JsonResponse(data={
                    'errCode': 0,
                    'errMsg': "绑定成功",
                    'userInfo':json.dumps(result_dict)

                })
        else:
            # token已过期
            return JsonResponse(data={
                'errCode': 2,
                'errMsg': "token已过期"
            })
    else:
        # 用户不存在
        return JsonResponse(data={
            'errCode': 1,
            'errMsg': "用户名或密码错误"
        })


def add_user_json(userprofile):
    user = userprofile.user
    setattr(userprofile,'user11',user)