# -*- coding: utf-8 -*-

"""
Copyright (c) 2014, Cooper Hewitt Smithsonian Design Museum
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the {organization} nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""

from __future__ import print_function

UCD_MAP = {
    # "0000":  "<control>", */
    # "0001":  "<control>", */
    # "0002":  "<control>", */
    # "0003":  "<control>", */
    # "0004":  "<control>", */
    # "0005":  "<control>", */
    # "0006":  "<control>", */
    # "0007":  "<control>", */
    # "0008":  "<control>", */
    # "0009":  "<control>", */
    # "000A":  "<control>", */
    # "000B":  "<control>", */
    # "000C":  "<control>", */
    # "000D":  "<control>", */
    # "000E":  "<control>", */
    # "000F":  "<control>", */
    # "0010":  "<control>", */
    # "0011":  "<control>", */
    # "0012":  "<control>", */
    # "0013":  "<control>", */
    # "0014":  "<control>", */
    # "0015":  "<control>", */
    # "0016":  "<control>", */
    # "0017":  "<control>", */
    # "0018":  "<control>", */
    # "0019":  "<control>", */
    # "001A":  "<control>", */
    # "001B":  "<control>", */
    # "001C":  "<control>", */
    # "001D":  "<control>", */
    # "001E":  "<control>", */
    # "001F":  "<control>", */
    "0020": "SPACE",
    "0021": "EXCLAMATION MARK",
    "0022": "QUOTATION MARK",
    "0023": "NUMBER SIGN",
    "0024": "DOLLAR SIGN",
    "0025": "PERCENT SIGN",
    "0026": "AMPERSAND",
    "0027": "APOSTROPHE",
    "0028": "LEFT PARENTHESIS",
    "0029": "RIGHT PARENTHESIS",
    "002A": "ASTERISK",
    "002B": "PLUS SIGN",
    "002C": "COMMA",
    "002D": "HYPHEN-MINUS",
    "002E": "FULL STOP",
    "002F": "SOLIDUS",
    "0030": "DIGIT ZERO",
    "0031": "DIGIT ONE",
    "0032": "DIGIT TWO",
    "0033": "DIGIT THREE",
    "0034": "DIGIT FOUR",
    "0035": "DIGIT FIVE",
    "0036": "DIGIT SIX",
    "0037": "DIGIT SEVEN",
    "0038": "DIGIT EIGHT",
    "0039": "DIGIT NINE",
    "003A": "COLON",
    "003B": "SEMICOLON",
    "003C": "LESS-THAN SIGN",
    "003D": "EQUALS SIGN",
    "003E": "GREATER-THAN SIGN",
    "003F": "QUESTION MARK",
    "0040": "COMMERCIAL AT",
    "0041": "LATIN CAPITAL LETTER A",
    "0042": "LATIN CAPITAL LETTER B",
    "0043": "LATIN CAPITAL LETTER C",
    "0044": "LATIN CAPITAL LETTER D",
    "0045": "LATIN CAPITAL LETTER E",
    "0046": "LATIN CAPITAL LETTER F",
    "0047": "LATIN CAPITAL LETTER G",
    "0048": "LATIN CAPITAL LETTER H",
    "0049": "LATIN CAPITAL LETTER I",
    "004A": "LATIN CAPITAL LETTER J",
    "004B": "LATIN CAPITAL LETTER K",
    "004C": "LATIN CAPITAL LETTER L",
    "004D": "LATIN CAPITAL LETTER M",
    "004E": "LATIN CAPITAL LETTER N",
    "004F": "LATIN CAPITAL LETTER O",
    "0050": "LATIN CAPITAL LETTER P",
    "0051": "LATIN CAPITAL LETTER Q",
    "0052": "LATIN CAPITAL LETTER R",
    "0053": "LATIN CAPITAL LETTER S",
    "0054": "LATIN CAPITAL LETTER T",
    "0055": "LATIN CAPITAL LETTER U",
    "0056": "LATIN CAPITAL LETTER V",
    "0057": "LATIN CAPITAL LETTER W",
    "0058": "LATIN CAPITAL LETTER X",
    "0059": "LATIN CAPITAL LETTER Y",
    "005A": "LATIN CAPITAL LETTER Z",
    "005B": "LEFT SQUARE BRACKET",
    "005C": "REVERSE SOLIDUS",
    "005D": "RIGHT SQUARE BRACKET",
    "005E": "CIRCUMFLEX ACCENT",
    "005F": "LOW LINE",
    "0060": "GRAVE ACCENT",
    "0061": "LATIN SMALL LETTER A",
    "0062": "LATIN SMALL LETTER B",
    "0063": "LATIN SMALL LETTER C",
    "0064": "LATIN SMALL LETTER D",
    "0065": "LATIN SMALL LETTER E",
    "0066": "LATIN SMALL LETTER F",
    "0067": "LATIN SMALL LETTER G",
    "0068": "LATIN SMALL LETTER H",
    "0069": "LATIN SMALL LETTER I",
    "006A": "LATIN SMALL LETTER J",
    "006B": "LATIN SMALL LETTER K",
    "006C": "LATIN SMALL LETTER L",
    "006D": "LATIN SMALL LETTER M",
    "006E": "LATIN SMALL LETTER N",
    "006F": "LATIN SMALL LETTER O",
    "0070": "LATIN SMALL LETTER P",
    "0071": "LATIN SMALL LETTER Q",
    "0072": "LATIN SMALL LETTER R",
    "0073": "LATIN SMALL LETTER S",
    "0074": "LATIN SMALL LETTER T",
    "0075": "LATIN SMALL LETTER U",
    "0076": "LATIN SMALL LETTER V",
    "0077": "LATIN SMALL LETTER W",
    "0078": "LATIN SMALL LETTER X",
    "0079": "LATIN SMALL LETTER Y",
    "007A": "LATIN SMALL LETTER Z",
    "007B": "LEFT CURLY BRACKET",
    "007C": "VERTICAL LINE",
    "007D": "RIGHT CURLY BRACKET",
    "007E": "TILDE",
    # "007F":  "<control>", */
    # "0080":  "<control>", */
    # "0081":  "<control>", */
    # "0082":  "<control>", */
    # "0083":  "<control>", */
    # "0084":  "<control>", */
    # "0085":  "<control>", */
    # "0086":  "<control>", */
    # "0087":  "<control>", */
    # "0088":  "<control>", */
    # "0089":  "<control>", */
    # "008A":  "<control>", */
    # "008B":  "<control>", */
    # "008C":  "<control>", */
    # "008D":  "<control>", */
    # "008E":  "<control>", */
    # "008F":  "<control>", */
    # "0090":  "<control>", */
    # "0091":  "<control>", */
    # "0092":  "<control>", */
    # "0093":  "<control>", */
    # "0094":  "<control>", */
    # "0095":  "<control>", */
    # "0096":  "<control>", */
    # "0097":  "<control>", */
    # "0098":  "<control>", */
    # "0099":  "<control>", */
    # "009A":  "<control>", */
    # "009B":  "<control>", */
    # "009C":  "<control>", */
    # "009D":  "<control>", */
    # "009E":  "<control>", */
    # "009F":  "<control>", */
    "00A0": "NO-BREAK SPACE",
    "00A1": "INVERTED EXCLAMATION MARK",
    "00A2": "CENT SIGN",
    "00A3": "POUND SIGN",
    "00A4": "CURRENCY SIGN",
    "00A5": "YEN SIGN",
    "00A6": "BROKEN BAR",
    "00A7": "SECTION SIGN",
    "00A8": "DIAERESIS",
    "00A9": "COPYRIGHT SIGN",
    "00AA": "FEMININE ORDINAL INDICATOR",
    "00AB": "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK",
    "00AC": "NOT SIGN",
    "00AD": "SOFT HYPHEN",
    "00AE": "REGISTERED SIGN",
    "00AF": "MACRON",
    "00B0": "DEGREE SIGN",
    "00B1": "PLUS-MINUS SIGN",
    "00B2": "SUPERSCRIPT TWO",
    "00B3": "SUPERSCRIPT THREE",
    "00B4": "ACUTE ACCENT",
    "00B5": "MICRO SIGN",
    "00B6": "PILCROW SIGN",
    "00B7": "MIDDLE DOT",
    "00B8": "CEDILLA",
    "00B9": "SUPERSCRIPT ONE",
    "00BA": "MASCULINE ORDINAL INDICATOR",
    "00BB": "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK",
    "00BC": "VULGAR FRACTION ONE QUARTER",
    "00BD": "VULGAR FRACTION ONE HALF",
    "00BE": "VULGAR FRACTION THREE QUARTERS",
    "00BF": "INVERTED QUESTION MARK",
    "00C0": "LATIN CAPITAL LETTER A WITH GRAVE",
    "00C1": "LATIN CAPITAL LETTER A WITH ACUTE",
    "00C2": "LATIN CAPITAL LETTER A WITH CIRCUMFLEX",
    "00C3": "LATIN CAPITAL LETTER A WITH TILDE",
    "00C4": "LATIN CAPITAL LETTER A WITH DIAERESIS",
    "00C5": "LATIN CAPITAL LETTER A WITH RING ABOVE",
    "00C6": "LATIN CAPITAL LETTER AE",
    "00C7": "LATIN CAPITAL LETTER C WITH CEDILLA",
    "00C8": "LATIN CAPITAL LETTER E WITH GRAVE",
    "00C9": "LATIN CAPITAL LETTER E WITH ACUTE",
    "00CA": "LATIN CAPITAL LETTER E WITH CIRCUMFLEX",
    "00CB": "LATIN CAPITAL LETTER E WITH DIAERESIS",
    "00CC": "LATIN CAPITAL LETTER I WITH GRAVE",
    "00CD": "LATIN CAPITAL LETTER I WITH ACUTE",
    "00CE": "LATIN CAPITAL LETTER I WITH CIRCUMFLEX",
    "00CF": "LATIN CAPITAL LETTER I WITH DIAERESIS",
    "00D0": "LATIN CAPITAL LETTER ETH",
    "00D1": "LATIN CAPITAL LETTER N WITH TILDE",
    "00D2": "LATIN CAPITAL LETTER O WITH GRAVE",
    "00D3": "LATIN CAPITAL LETTER O WITH ACUTE",
    "00D4": "LATIN CAPITAL LETTER O WITH CIRCUMFLEX",
    "00D5": "LATIN CAPITAL LETTER O WITH TILDE",
    "00D6": "LATIN CAPITAL LETTER O WITH DIAERESIS",
    "00D7": "MULTIPLICATION SIGN",
    "00D8": "LATIN CAPITAL LETTER O WITH STROKE",
    "00D9": "LATIN CAPITAL LETTER U WITH GRAVE",
    "00DA": "LATIN CAPITAL LETTER U WITH ACUTE",
    "00DB": "LATIN CAPITAL LETTER U WITH CIRCUMFLEX",
    "00DC": "LATIN CAPITAL LETTER U WITH DIAERESIS",
    "00DD": "LATIN CAPITAL LETTER Y WITH ACUTE",
    "00DE": "LATIN CAPITAL LETTER THORN",
    "00DF": "LATIN SMALL LETTER SHARP S",
    "00E0": "LATIN SMALL LETTER A WITH GRAVE",
    "00E1": "LATIN SMALL LETTER A WITH ACUTE",
    "00E2": "LATIN SMALL LETTER A WITH CIRCUMFLEX",
    "00E3": "LATIN SMALL LETTER A WITH TILDE",
    "00E4": "LATIN SMALL LETTER A WITH DIAERESIS",
    "00E5": "LATIN SMALL LETTER A WITH RING ABOVE",
    "00E6": "LATIN SMALL LETTER AE",
    "00E7": "LATIN SMALL LETTER C WITH CEDILLA",
    "00E8": "LATIN SMALL LETTER E WITH GRAVE",
    "00E9": "LATIN SMALL LETTER E WITH ACUTE",
    "00EA": "LATIN SMALL LETTER E WITH CIRCUMFLEX",
    "00EB": "LATIN SMALL LETTER E WITH DIAERESIS",
    "00EC": "LATIN SMALL LETTER I WITH GRAVE",
    "00ED": "LATIN SMALL LETTER I WITH ACUTE",
    "00EE": "LATIN SMALL LETTER I WITH CIRCUMFLEX",
    "00EF": "LATIN SMALL LETTER I WITH DIAERESIS",
    "00F0": "LATIN SMALL LETTER ETH",
    "00F1": "LATIN SMALL LETTER N WITH TILDE",
    "00F2": "LATIN SMALL LETTER O WITH GRAVE",
    "00F3": "LATIN SMALL LETTER O WITH ACUTE",
    "00F4": "LATIN SMALL LETTER O WITH CIRCUMFLEX",
    "00F5": "LATIN SMALL LETTER O WITH TILDE",
    "00F6": "LATIN SMALL LETTER O WITH DIAERESIS",
    "00F7": "DIVISION SIGN",
    "00F8": "LATIN SMALL LETTER O WITH STROKE",
    "00F9": "LATIN SMALL LETTER U WITH GRAVE",
    "00FA": "LATIN SMALL LETTER U WITH ACUTE",
    "00FB": "LATIN SMALL LETTER U WITH CIRCUMFLEX",
    "00FC": "LATIN SMALL LETTER U WITH DIAERESIS",
    "00FD": "LATIN SMALL LETTER Y WITH ACUTE",
    "00FE": "LATIN SMALL LETTER THORN",
    "00FF": "LATIN SMALL LETTER Y WITH DIAERESIS",
    "0100": "LATIN CAPITAL LETTER A WITH MACRON",
    "0101": "LATIN SMALL LETTER A WITH MACRON",
    "0102": "LATIN CAPITAL LETTER A WITH BREVE",
    "0103": "LATIN SMALL LETTER A WITH BREVE",
    "0104": "LATIN CAPITAL LETTER A WITH OGONEK",
    "0105": "LATIN SMALL LETTER A WITH OGONEK",
    "0106": "LATIN CAPITAL LETTER C WITH ACUTE",
    "0107": "LATIN SMALL LETTER C WITH ACUTE",
    "0108": "LATIN CAPITAL LETTER C WITH CIRCUMFLEX",
    "0109": "LATIN SMALL LETTER C WITH CIRCUMFLEX",
    "010A": "LATIN CAPITAL LETTER C WITH DOT ABOVE",
    "010B": "LATIN SMALL LETTER C WITH DOT ABOVE",
    "010C": "LATIN CAPITAL LETTER C WITH CARON",
    "010D": "LATIN SMALL LETTER C WITH CARON",
    "010E": "LATIN CAPITAL LETTER D WITH CARON",
    "010F": "LATIN SMALL LETTER D WITH CARON",
    "0110": "LATIN CAPITAL LETTER D WITH STROKE",
    "0111": "LATIN SMALL LETTER D WITH STROKE",
    "0112": "LATIN CAPITAL LETTER E WITH MACRON",
    "0113": "LATIN SMALL LETTER E WITH MACRON",
    "0114": "LATIN CAPITAL LETTER E WITH BREVE",
    "0115": "LATIN SMALL LETTER E WITH BREVE",
    "0116": "LATIN CAPITAL LETTER E WITH DOT ABOVE",
    "0117": "LATIN SMALL LETTER E WITH DOT ABOVE",
    "0118": "LATIN CAPITAL LETTER E WITH OGONEK",
    "0119": "LATIN SMALL LETTER E WITH OGONEK",
    "011A": "LATIN CAPITAL LETTER E WITH CARON",
    "011B": "LATIN SMALL LETTER E WITH CARON",
    "011C": "LATIN CAPITAL LETTER G WITH CIRCUMFLEX",
    "011D": "LATIN SMALL LETTER G WITH CIRCUMFLEX",
    "011E": "LATIN CAPITAL LETTER G WITH BREVE",
    "011F": "LATIN SMALL LETTER G WITH BREVE",
    "0120": "LATIN CAPITAL LETTER G WITH DOT ABOVE",
    "0121": "LATIN SMALL LETTER G WITH DOT ABOVE",
    "0122": "LATIN CAPITAL LETTER G WITH CEDILLA",
    "0123": "LATIN SMALL LETTER G WITH CEDILLA",
    "0124": "LATIN CAPITAL LETTER H WITH CIRCUMFLEX",
    "0125": "LATIN SMALL LETTER H WITH CIRCUMFLEX",
    "0126": "LATIN CAPITAL LETTER H WITH STROKE",
    "0127": "LATIN SMALL LETTER H WITH STROKE",
    "0128": "LATIN CAPITAL LETTER I WITH TILDE",
    "0129": "LATIN SMALL LETTER I WITH TILDE",
    "012A": "LATIN CAPITAL LETTER I WITH MACRON",
    "012B": "LATIN SMALL LETTER I WITH MACRON",
    "012C": "LATIN CAPITAL LETTER I WITH BREVE",
    "012D": "LATIN SMALL LETTER I WITH BREVE",
    "012E": "LATIN CAPITAL LETTER I WITH OGONEK",
    "012F": "LATIN SMALL LETTER I WITH OGONEK",
    "0130": "LATIN CAPITAL LETTER I WITH DOT ABOVE",
    "0131": "LATIN SMALL LETTER DOTLESS I",
    "0132": "LATIN CAPITAL LIGATURE IJ",
    "0133": "LATIN SMALL LIGATURE IJ",
    "0134": "LATIN CAPITAL LETTER J WITH CIRCUMFLEX",
    "0135": "LATIN SMALL LETTER J WITH CIRCUMFLEX",
    "0136": "LATIN CAPITAL LETTER K WITH CEDILLA",
    "0137": "LATIN SMALL LETTER K WITH CEDILLA",
    "0138": "LATIN SMALL LETTER KRA",
    "0139": "LATIN CAPITAL LETTER L WITH ACUTE",
    "013A": "LATIN SMALL LETTER L WITH ACUTE",
    "013B": "LATIN CAPITAL LETTER L WITH CEDILLA",
    "013C": "LATIN SMALL LETTER L WITH CEDILLA",
    "013D": "LATIN CAPITAL LETTER L WITH CARON",
    "013E": "LATIN SMALL LETTER L WITH CARON",
    "013F": "LATIN CAPITAL LETTER L WITH MIDDLE DOT",
    "0140": "LATIN SMALL LETTER L WITH MIDDLE DOT",
    "0141": "LATIN CAPITAL LETTER L WITH STROKE",
    "0142": "LATIN SMALL LETTER L WITH STROKE",
    "0143": "LATIN CAPITAL LETTER N WITH ACUTE",
    "0144": "LATIN SMALL LETTER N WITH ACUTE",
    "0145": "LATIN CAPITAL LETTER N WITH CEDILLA",
    "0146": "LATIN SMALL LETTER N WITH CEDILLA",
    "0147": "LATIN CAPITAL LETTER N WITH CARON",
    "0148": "LATIN SMALL LETTER N WITH CARON",
    "0149": "LATIN SMALL LETTER N PRECEDED BY APOSTROPHE",
    "014A": "LATIN CAPITAL LETTER ENG",
    "014B": "LATIN SMALL LETTER ENG",
    "014C": "LATIN CAPITAL LETTER O WITH MACRON",
    "014D": "LATIN SMALL LETTER O WITH MACRON",
    "014E": "LATIN CAPITAL LETTER O WITH BREVE",
    "014F": "LATIN SMALL LETTER O WITH BREVE",
    "0150": "LATIN CAPITAL LETTER O WITH DOUBLE ACUTE",
    "0151": "LATIN SMALL LETTER O WITH DOUBLE ACUTE",
    "0152": "LATIN CAPITAL LIGATURE OE",
    "0153": "LATIN SMALL LIGATURE OE",
    "0154": "LATIN CAPITAL LETTER R WITH ACUTE",
    "0155": "LATIN SMALL LETTER R WITH ACUTE",
    "0156": "LATIN CAPITAL LETTER R WITH CEDILLA",
    "0157": "LATIN SMALL LETTER R WITH CEDILLA",
    "0158": "LATIN CAPITAL LETTER R WITH CARON",
    "0159": "LATIN SMALL LETTER R WITH CARON",
    "015A": "LATIN CAPITAL LETTER S WITH ACUTE",
    "015B": "LATIN SMALL LETTER S WITH ACUTE",
    "015C": "LATIN CAPITAL LETTER S WITH CIRCUMFLEX",
    "015D": "LATIN SMALL LETTER S WITH CIRCUMFLEX",
    "015E": "LATIN CAPITAL LETTER S WITH CEDILLA",
    "015F": "LATIN SMALL LETTER S WITH CEDILLA",
    "0160": "LATIN CAPITAL LETTER S WITH CARON",
    "0161": "LATIN SMALL LETTER S WITH CARON",
    "0162": "LATIN CAPITAL LETTER T WITH CEDILLA",
    "0163": "LATIN SMALL LETTER T WITH CEDILLA",
    "0164": "LATIN CAPITAL LETTER T WITH CARON",
    "0165": "LATIN SMALL LETTER T WITH CARON",
    "0166": "LATIN CAPITAL LETTER T WITH STROKE",
    "0167": "LATIN SMALL LETTER T WITH STROKE",
    "0168": "LATIN CAPITAL LETTER U WITH TILDE",
    "0169": "LATIN SMALL LETTER U WITH TILDE",
    "016A": "LATIN CAPITAL LETTER U WITH MACRON",
    "016B": "LATIN SMALL LETTER U WITH MACRON",
    "016C": "LATIN CAPITAL LETTER U WITH BREVE",
    "016D": "LATIN SMALL LETTER U WITH BREVE",
    "016E": "LATIN CAPITAL LETTER U WITH RING ABOVE",
    "016F": "LATIN SMALL LETTER U WITH RING ABOVE",
    "0170": "LATIN CAPITAL LETTER U WITH DOUBLE ACUTE",
    "0171": "LATIN SMALL LETTER U WITH DOUBLE ACUTE",
    "0172": "LATIN CAPITAL LETTER U WITH OGONEK",
    "0173": "LATIN SMALL LETTER U WITH OGONEK",
    "0174": "LATIN CAPITAL LETTER W WITH CIRCUMFLEX",
    "0175": "LATIN SMALL LETTER W WITH CIRCUMFLEX",
    "0176": "LATIN CAPITAL LETTER Y WITH CIRCUMFLEX",
    "0177": "LATIN SMALL LETTER Y WITH CIRCUMFLEX",
    "0178": "LATIN CAPITAL LETTER Y WITH DIAERESIS",
    "0179": "LATIN CAPITAL LETTER Z WITH ACUTE",
    "017A": "LATIN SMALL LETTER Z WITH ACUTE",
    "017B": "LATIN CAPITAL LETTER Z WITH DOT ABOVE",
    "017C": "LATIN SMALL LETTER Z WITH DOT ABOVE",
    "017D": "LATIN CAPITAL LETTER Z WITH CARON",
    "017E": "LATIN SMALL LETTER Z WITH CARON",
    "017F": "LATIN SMALL LETTER LONG S",
    "0180": "LATIN SMALL LETTER B WITH STROKE",
    "0181": "LATIN CAPITAL LETTER B WITH HOOK",
    "0182": "LATIN CAPITAL LETTER B WITH TOPBAR",
    "0183": "LATIN SMALL LETTER B WITH TOPBAR",
    "0184": "LATIN CAPITAL LETTER TONE SIX",
    "0185": "LATIN SMALL LETTER TONE SIX",
    "0186": "LATIN CAPITAL LETTER OPEN O",
    "0187": "LATIN CAPITAL LETTER C WITH HOOK",
    "0188": "LATIN SMALL LETTER C WITH HOOK",
    "0189": "LATIN CAPITAL LETTER AFRICAN D",
    "018A": "LATIN CAPITAL LETTER D WITH HOOK",
    "018B": "LATIN CAPITAL LETTER D WITH TOPBAR",
    "018C": "LATIN SMALL LETTER D WITH TOPBAR",
    "018D": "LATIN SMALL LETTER TURNED DELTA",
    "018E": "LATIN CAPITAL LETTER REVERSED E",
    "018F": "LATIN CAPITAL LETTER SCHWA",
    "0190": "LATIN CAPITAL LETTER OPEN E",
    "0191": "LATIN CAPITAL LETTER F WITH HOOK",
    "0192": "LATIN SMALL LETTER F WITH HOOK",
    "0193": "LATIN CAPITAL LETTER G WITH HOOK",
    "0194": "LATIN CAPITAL LETTER GAMMA",
    "0195": "LATIN SMALL LETTER HV",
    "0196": "LATIN CAPITAL LETTER IOTA",
    "0197": "LATIN CAPITAL LETTER I WITH STROKE",
    "0198": "LATIN CAPITAL LETTER K WITH HOOK",
    "0199": "LATIN SMALL LETTER K WITH HOOK",
    "019A": "LATIN SMALL LETTER L WITH BAR",
    "019B": "LATIN SMALL LETTER LAMBDA WITH STROKE",
    "019C": "LATIN CAPITAL LETTER TURNED M",
    "019D": "LATIN CAPITAL LETTER N WITH LEFT HOOK",
    "019E": "LATIN SMALL LETTER N WITH LONG RIGHT LEG",
    "019F": "LATIN CAPITAL LETTER O WITH MIDDLE TILDE",
    "01A0": "LATIN CAPITAL LETTER O WITH HORN",
    "01A1": "LATIN SMALL LETTER O WITH HORN",
    "01A2": "LATIN CAPITAL LETTER OI",
    "01A3": "LATIN SMALL LETTER OI",
    "01A4": "LATIN CAPITAL LETTER P WITH HOOK",
    "01A5": "LATIN SMALL LETTER P WITH HOOK",
    "01A6": "LATIN LETTER YR",
    "01A7": "LATIN CAPITAL LETTER TONE TWO",
    "01A8": "LATIN SMALL LETTER TONE TWO",
    "01A9": "LATIN CAPITAL LETTER ESH",
    "01AA": "LATIN LETTER REVERSED ESH LOOP",
    "01AB": "LATIN SMALL LETTER T WITH PALATAL HOOK",
    "01AC": "LATIN CAPITAL LETTER T WITH HOOK",
    "01AD": "LATIN SMALL LETTER T WITH HOOK",
    "01AE": "LATIN CAPITAL LETTER T WITH RETROFLEX HOOK",
    "01AF": "LATIN CAPITAL LETTER U WITH HORN",
    "01B0": "LATIN SMALL LETTER U WITH HORN",
    "01B1": "LATIN CAPITAL LETTER UPSILON",
    "01B2": "LATIN CAPITAL LETTER V WITH HOOK",
    "01B3": "LATIN CAPITAL LETTER Y WITH HOOK",
    "01B4": "LATIN SMALL LETTER Y WITH HOOK",
    "01B5": "LATIN CAPITAL LETTER Z WITH STROKE",
    "01B6": "LATIN SMALL LETTER Z WITH STROKE",
    "01B7": "LATIN CAPITAL LETTER EZH",
    "01B8": "LATIN CAPITAL LETTER EZH REVERSED",
    "01B9": "LATIN SMALL LETTER EZH REVERSED",
    "01BA": "LATIN SMALL LETTER EZH WITH TAIL",
    "01BB": "LATIN LETTER TWO WITH STROKE",
    "01BC": "LATIN CAPITAL LETTER TONE FIVE",
    "01BD": "LATIN SMALL LETTER TONE FIVE",
    "01BE": "LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE",
    "01BF": "LATIN LETTER WYNN",
    "01C0": "LATIN LETTER DENTAL CLICK",
    "01C1": "LATIN LETTER LATERAL CLICK",
    "01C2": "LATIN LETTER ALVEOLAR CLICK",
    "01C3": "LATIN LETTER RETROFLEX CLICK",
    "01C4": "LATIN CAPITAL LETTER DZ WITH CARON",
    "01C5": "LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON",
    "01C6": "LATIN SMALL LETTER DZ WITH CARON",
    "01C7": "LATIN CAPITAL LETTER LJ",
    "01C8": "LATIN CAPITAL LETTER L WITH SMALL LETTER J",
    "01C9": "LATIN SMALL LETTER LJ",
    "01CA": "LATIN CAPITAL LETTER NJ",
    "01CB": "LATIN CAPITAL LETTER N WITH SMALL LETTER J",
    "01CC": "LATIN SMALL LETTER NJ",
    "01CD": "LATIN CAPITAL LETTER A WITH CARON",
    "01CE": "LATIN SMALL LETTER A WITH CARON",
    "01CF": "LATIN CAPITAL LETTER I WITH CARON",
    "01D0": "LATIN SMALL LETTER I WITH CARON",
    "01D1": "LATIN CAPITAL LETTER O WITH CARON",
    "01D2": "LATIN SMALL LETTER O WITH CARON",
    "01D3": "LATIN CAPITAL LETTER U WITH CARON",
    "01D4": "LATIN SMALL LETTER U WITH CARON",
    "01D5": "LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON",
    "01D6": "LATIN SMALL LETTER U WITH DIAERESIS AND MACRON",
    "01D7": "LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE",
    "01D8": "LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE",
    "01D9": "LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON",
    "01DA": "LATIN SMALL LETTER U WITH DIAERESIS AND CARON",
    "01DB": "LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE",
    "01DC": "LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE",
    "01DD": "LATIN SMALL LETTER TURNED E",
    "01DE": "LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON",
    "01DF": "LATIN SMALL LETTER A WITH DIAERESIS AND MACRON",
    "01E0": "LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON",
    "01E1": "LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON",
    "01E2": "LATIN CAPITAL LETTER AE WITH MACRON",
    "01E3": "LATIN SMALL LETTER AE WITH MACRON",
    "01E4": "LATIN CAPITAL LETTER G WITH STROKE",
    "01E5": "LATIN SMALL LETTER G WITH STROKE",
    "01E6": "LATIN CAPITAL LETTER G WITH CARON",
    "01E7": "LATIN SMALL LETTER G WITH CARON",
    "01E8": "LATIN CAPITAL LETTER K WITH CARON",
    "01E9": "LATIN SMALL LETTER K WITH CARON",
    "01EA": "LATIN CAPITAL LETTER O WITH OGONEK",
    "01EB": "LATIN SMALL LETTER O WITH OGONEK",
    "01EC": "LATIN CAPITAL LETTER O WITH OGONEK AND MACRON",
    "01ED": "LATIN SMALL LETTER O WITH OGONEK AND MACRON",
    "01EE": "LATIN CAPITAL LETTER EZH WITH CARON",
    "01EF": "LATIN SMALL LETTER EZH WITH CARON",
    "01F0": "LATIN SMALL LETTER J WITH CARON",
    "01F1": "LATIN CAPITAL LETTER DZ",
    "01F2": "LATIN CAPITAL LETTER D WITH SMALL LETTER Z",
    "01F3": "LATIN SMALL LETTER DZ",
    "01F4": "LATIN CAPITAL LETTER G WITH ACUTE",
    "01F5": "LATIN SMALL LETTER G WITH ACUTE",
    "01F6": "LATIN CAPITAL LETTER HWAIR",
    "01F7": "LATIN CAPITAL LETTER WYNN",
    "01F8": "LATIN CAPITAL LETTER N WITH GRAVE",
    "01F9": "LATIN SMALL LETTER N WITH GRAVE",
    "01FA": "LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE",
    "01FB": "LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE",
    "01FC": "LATIN CAPITAL LETTER AE WITH ACUTE",
    "01FD": "LATIN SMALL LETTER AE WITH ACUTE",
    "01FE": "LATIN CAPITAL LETTER O WITH STROKE AND ACUTE",
    "01FF": "LATIN SMALL LETTER O WITH STROKE AND ACUTE",
    "0200": "LATIN CAPITAL LETTER A WITH DOUBLE GRAVE",
    "0201": "LATIN SMALL LETTER A WITH DOUBLE GRAVE",
    "0202": "LATIN CAPITAL LETTER A WITH INVERTED BREVE",
    "0203": "LATIN SMALL LETTER A WITH INVERTED BREVE",
    "0204": "LATIN CAPITAL LETTER E WITH DOUBLE GRAVE",
    "0205": "LATIN SMALL LETTER E WITH DOUBLE GRAVE",
    "0206": "LATIN CAPITAL LETTER E WITH INVERTED BREVE",
    "0207": "LATIN SMALL LETTER E WITH INVERTED BREVE",
    "0208": "LATIN CAPITAL LETTER I WITH DOUBLE GRAVE",
    "0209": "LATIN SMALL LETTER I WITH DOUBLE GRAVE",
    "020A": "LATIN CAPITAL LETTER I WITH INVERTED BREVE",
    "020B": "LATIN SMALL LETTER I WITH INVERTED BREVE",
    "020C": "LATIN CAPITAL LETTER O WITH DOUBLE GRAVE",
    "020D": "LATIN SMALL LETTER O WITH DOUBLE GRAVE",
    "020E": "LATIN CAPITAL LETTER O WITH INVERTED BREVE",
    "020F": "LATIN SMALL LETTER O WITH INVERTED BREVE",
    "0210": "LATIN CAPITAL LETTER R WITH DOUBLE GRAVE",
    "0211": "LATIN SMALL LETTER R WITH DOUBLE GRAVE",
    "0212": "LATIN CAPITAL LETTER R WITH INVERTED BREVE",
    "0213": "LATIN SMALL LETTER R WITH INVERTED BREVE",
    "0214": "LATIN CAPITAL LETTER U WITH DOUBLE GRAVE",
    "0215": "LATIN SMALL LETTER U WITH DOUBLE GRAVE",
    "0216": "LATIN CAPITAL LETTER U WITH INVERTED BREVE",
    "0217": "LATIN SMALL LETTER U WITH INVERTED BREVE",
    "0218": "LATIN CAPITAL LETTER S WITH COMMA BELOW",
    "0219": "LATIN SMALL LETTER S WITH COMMA BELOW",
    "021A": "LATIN CAPITAL LETTER T WITH COMMA BELOW",
    "021B": "LATIN SMALL LETTER T WITH COMMA BELOW",
    "021C": "LATIN CAPITAL LETTER YOGH",
    "021D": "LATIN SMALL LETTER YOGH",
    "021E": "LATIN CAPITAL LETTER H WITH CARON",
    "021F": "LATIN SMALL LETTER H WITH CARON",
    "0220": "LATIN CAPITAL LETTER N WITH LONG RIGHT LEG",
    "0221": "LATIN SMALL LETTER D WITH CURL",
    "0222": "LATIN CAPITAL LETTER OU",
    "0223": "LATIN SMALL LETTER OU",
    "0224": "LATIN CAPITAL LETTER Z WITH HOOK",
    "0225": "LATIN SMALL LETTER Z WITH HOOK",
    "0226": "LATIN CAPITAL LETTER A WITH DOT ABOVE",
    "0227": "LATIN SMALL LETTER A WITH DOT ABOVE",
    "0228": "LATIN CAPITAL LETTER E WITH CEDILLA",
    "0229": "LATIN SMALL LETTER E WITH CEDILLA",
    "022A": "LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON",
    "022B": "LATIN SMALL LETTER O WITH DIAERESIS AND MACRON",
    "022C": "LATIN CAPITAL LETTER O WITH TILDE AND MACRON",
    "022D": "LATIN SMALL LETTER O WITH TILDE AND MACRON",
    "022E": "LATIN CAPITAL LETTER O WITH DOT ABOVE",
    "022F": "LATIN SMALL LETTER O WITH DOT ABOVE",
    "0230": "LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON",
    "0231": "LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON",
    "0232": "LATIN CAPITAL LETTER Y WITH MACRON",
    "0233": "LATIN SMALL LETTER Y WITH MACRON",
    "0234": "LATIN SMALL LETTER L WITH CURL",
    "0235": "LATIN SMALL LETTER N WITH CURL",
    "0236": "LATIN SMALL LETTER T WITH CURL",
    "0237": "LATIN SMALL LETTER DOTLESS J",
    "0238": "LATIN SMALL LETTER DB DIGRAPH",
    "0239": "LATIN SMALL LETTER QP DIGRAPH",
    "023A": "LATIN CAPITAL LETTER A WITH STROKE",
    "023B": "LATIN CAPITAL LETTER C WITH STROKE",
    "023C": "LATIN SMALL LETTER C WITH STROKE",
    "023D": "LATIN CAPITAL LETTER L WITH BAR",
    "023E": "LATIN CAPITAL LETTER T WITH DIAGONAL STROKE",
    "023F": "LATIN SMALL LETTER S WITH SWASH TAIL",
    "0240": "LATIN SMALL LETTER Z WITH SWASH TAIL",
    "0241": "LATIN CAPITAL LETTER GLOTTAL STOP",
    "0242": "LATIN SMALL LETTER GLOTTAL STOP",
    "0243": "LATIN CAPITAL LETTER B WITH STROKE",
    "0244": "LATIN CAPITAL LETTER U BAR",
    "0245": "LATIN CAPITAL LETTER TURNED V",
    "0246": "LATIN CAPITAL LETTER E WITH STROKE",
    "0247": "LATIN SMALL LETTER E WITH STROKE",
    "0248": "LATIN CAPITAL LETTER J WITH STROKE",
    "0249": "LATIN SMALL LETTER J WITH STROKE",
    "024A": "LATIN CAPITAL LETTER SMALL Q WITH HOOK TAIL",
    "024B": "LATIN SMALL LETTER Q WITH HOOK TAIL",
    "024C": "LATIN CAPITAL LETTER R WITH STROKE",
    "024D": "LATIN SMALL LETTER R WITH STROKE",
    "024E": "LATIN CAPITAL LETTER Y WITH STROKE",
    "024F": "LATIN SMALL LETTER Y WITH STROKE",
    "0250": "LATIN SMALL LETTER TURNED A",
    "0251": "LATIN SMALL LETTER ALPHA",
    "0252": "LATIN SMALL LETTER TURNED ALPHA",
    "0253": "LATIN SMALL LETTER B WITH HOOK",
    "0254": "LATIN SMALL LETTER OPEN O",
    "0255": "LATIN SMALL LETTER C WITH CURL",
    "0256": "LATIN SMALL LETTER D WITH TAIL",
    "0257": "LATIN SMALL LETTER D WITH HOOK",
    "0258": "LATIN SMALL LETTER REVERSED E",
    "0259": "LATIN SMALL LETTER SCHWA",
    "025A": "LATIN SMALL LETTER SCHWA WITH HOOK",
    "025B": "LATIN SMALL LETTER OPEN E",
    "025C": "LATIN SMALL LETTER REVERSED OPEN E",
    "025D": "LATIN SMALL LETTER REVERSED OPEN E WITH HOOK",
    "025E": "LATIN SMALL LETTER CLOSED REVERSED OPEN E",
    "025F": "LATIN SMALL LETTER DOTLESS J WITH STROKE",
    "0260": "LATIN SMALL LETTER G WITH HOOK",
    "0261": "LATIN SMALL LETTER SCRIPT G",
    "0262": "LATIN LETTER SMALL CAPITAL G",
    "0263": "LATIN SMALL LETTER GAMMA",
    "0264": "LATIN SMALL LETTER RAMS HORN",
    "0265": "LATIN SMALL LETTER TURNED H",
    "0266": "LATIN SMALL LETTER H WITH HOOK",
    "0267": "LATIN SMALL LETTER HENG WITH HOOK",
    "0268": "LATIN SMALL LETTER I WITH STROKE",
    "0269": "LATIN SMALL LETTER IOTA",
    "026A": "LATIN LETTER SMALL CAPITAL I",
    "026B": "LATIN SMALL LETTER L WITH MIDDLE TILDE",
    "026C": "LATIN SMALL LETTER L WITH BELT",
    "026D": "LATIN SMALL LETTER L WITH RETROFLEX HOOK",
    "026E": "LATIN SMALL LETTER LEZH",
    "026F": "LATIN SMALL LETTER TURNED M",
    "0270": "LATIN SMALL LETTER TURNED M WITH LONG LEG",
    "0271": "LATIN SMALL LETTER M WITH HOOK",
    "0272": "LATIN SMALL LETTER N WITH LEFT HOOK",
    "0273": "LATIN SMALL LETTER N WITH RETROFLEX HOOK",
    "0274": "LATIN LETTER SMALL CAPITAL N",
    "0275": "LATIN SMALL LETTER BARRED O",
    "0276": "LATIN LETTER SMALL CAPITAL OE",
    "0277": "LATIN SMALL LETTER CLOSED OMEGA",
    "0278": "LATIN SMALL LETTER PHI",
    "0279": "LATIN SMALL LETTER TURNED R",
    "027A": "LATIN SMALL LETTER TURNED R WITH LONG LEG",
    "027B": "LATIN SMALL LETTER TURNED R WITH HOOK",
    "027C": "LATIN SMALL LETTER R WITH LONG LEG",
    "027D": "LATIN SMALL LETTER R WITH TAIL",
    "027E": "LATIN SMALL LETTER R WITH FISHHOOK",
    "027F": "LATIN SMALL LETTER REVERSED R WITH FISHHOOK",
    "0280": "LATIN LETTER SMALL CAPITAL R",
    "0281": "LATIN LETTER SMALL CAPITAL INVERTED R",
    "0282": "LATIN SMALL LETTER S WITH HOOK",
    "0283": "LATIN SMALL LETTER ESH",
    "0284": "LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK",
    "0285": "LATIN SMALL LETTER SQUAT REVERSED ESH",
    "0286": "LATIN SMALL LETTER ESH WITH CURL",
    "0287": "LATIN SMALL LETTER TURNED T",
    "0288": "LATIN SMALL LETTER T WITH RETROFLEX HOOK",
    "0289": "LATIN SMALL LETTER U BAR",
    "028A": "LATIN SMALL LETTER UPSILON",
    "028B": "LATIN SMALL LETTER V WITH HOOK",
    "028C": "LATIN SMALL LETTER TURNED V",
    "028D": "LATIN SMALL LETTER TURNED W",
    "028E": "LATIN SMALL LETTER TURNED Y",
    "028F": "LATIN LETTER SMALL CAPITAL Y",
    "0290": "LATIN SMALL LETTER Z WITH RETROFLEX HOOK",
    "0291": "LATIN SMALL LETTER Z WITH CURL",
    "0292": "LATIN SMALL LETTER EZH",
    "0293": "LATIN SMALL LETTER EZH WITH CURL",
    "0294": "LATIN LETTER GLOTTAL STOP",
    "0295": "LATIN LETTER PHARYNGEAL VOICED FRICATIVE",
    "0296": "LATIN LETTER INVERTED GLOTTAL STOP",
    "0297": "LATIN LETTER STRETCHED C",
    "0298": "LATIN LETTER BILABIAL CLICK",
    "0299": "LATIN LETTER SMALL CAPITAL B",
    "029A": "LATIN SMALL LETTER CLOSED OPEN E",
    "029B": "LATIN LETTER SMALL CAPITAL G WITH HOOK",
    "029C": "LATIN LETTER SMALL CAPITAL H",
    "029D": "LATIN SMALL LETTER J WITH CROSSED-TAIL",
    "029E": "LATIN SMALL LETTER TURNED K",
    "029F": "LATIN LETTER SMALL CAPITAL L",
    "02A0": "LATIN SMALL LETTER Q WITH HOOK",
    "02A1": "LATIN LETTER GLOTTAL STOP WITH STROKE",
    "02A2": "LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE",
    "02A3": "LATIN SMALL LETTER DZ DIGRAPH",
    "02A4": "LATIN SMALL LETTER DEZH DIGRAPH",
    "02A5": "LATIN SMALL LETTER DZ DIGRAPH WITH CURL",
    "02A6": "LATIN SMALL LETTER TS DIGRAPH",
    "02A7": "LATIN SMALL LETTER TESH DIGRAPH",
    "02A8": "LATIN SMALL LETTER TC DIGRAPH WITH CURL",
    "02A9": "LATIN SMALL LETTER FENG DIGRAPH",
    "02AA": "LATIN SMALL LETTER LS DIGRAPH",
    "02AB": "LATIN SMALL LETTER LZ DIGRAPH",
    "02AC": "LATIN LETTER BILABIAL PERCUSSIVE",
    "02AD": "LATIN LETTER BIDENTAL PERCUSSIVE",
    "02AE": "LATIN SMALL LETTER TURNED H WITH FISHHOOK",
    "02AF": "LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL",
    "02B0": "MODIFIER LETTER SMALL H",
    "02B1": "MODIFIER LETTER SMALL H WITH HOOK",
    "02B2": "MODIFIER LETTER SMALL J",
    "02B3": "MODIFIER LETTER SMALL R",
    "02B4": "MODIFIER LETTER SMALL TURNED R",
    "02B5": "MODIFIER LETTER SMALL TURNED R WITH HOOK",
    "02B6": "MODIFIER LETTER SMALL CAPITAL INVERTED R",
    "02B7": "MODIFIER LETTER SMALL W",
    "02B8": "MODIFIER LETTER SMALL Y",
    "02B9": "MODIFIER LETTER PRIME",
    "02BA": "MODIFIER LETTER DOUBLE PRIME",
    "02BB": "MODIFIER LETTER TURNED COMMA",
    "02BC": "MODIFIER LETTER APOSTROPHE",
    "02BD": "MODIFIER LETTER REVERSED COMMA",
    "02BE": "MODIFIER LETTER RIGHT HALF RING",
    "02BF": "MODIFIER LETTER LEFT HALF RING",
    "02C0": "MODIFIER LETTER GLOTTAL STOP",
    "02C1": "MODIFIER LETTER REVERSED GLOTTAL STOP",
    "02C2": "MODIFIER LETTER LEFT ARROWHEAD",
    "02C3": "MODIFIER LETTER RIGHT ARROWHEAD",
    "02C4": "MODIFIER LETTER UP ARROWHEAD",
    "02C5": "MODIFIER LETTER DOWN ARROWHEAD",
    "02C6": "MODIFIER LETTER CIRCUMFLEX ACCENT",
    "02C7": "CARON",
    "02C8": "MODIFIER LETTER VERTICAL LINE",
    "02C9": "MODIFIER LETTER MACRON",
    "02CA": "MODIFIER LETTER ACUTE ACCENT",
    "02CB": "MODIFIER LETTER GRAVE ACCENT",
    "02CC": "MODIFIER LETTER LOW VERTICAL LINE",
    "02CD": "MODIFIER LETTER LOW MACRON",
    "02CE": "MODIFIER LETTER LOW GRAVE ACCENT",
    "02CF": "MODIFIER LETTER LOW ACUTE ACCENT",
    "02D0": "MODIFIER LETTER TRIANGULAR COLON",
    "02D1": "MODIFIER LETTER HALF TRIANGULAR COLON",
    "02D2": "MODIFIER LETTER CENTRED RIGHT HALF RING",
    "02D3": "MODIFIER LETTER CENTRED LEFT HALF RING",
    "02D4": "MODIFIER LETTER UP TACK",
    "02D5": "MODIFIER LETTER DOWN TACK",
    "02D6": "MODIFIER LETTER PLUS SIGN",
    "02D7": "MODIFIER LETTER MINUS SIGN",
    "02D8": "BREVE",
    "02D9": "DOT ABOVE",
    "02DA": "RING ABOVE",
    "02DB": "OGONEK",
    "02DC": "SMALL TILDE",
    "02DD": "DOUBLE ACUTE ACCENT",
    "02DE": "MODIFIER LETTER RHOTIC HOOK",
    "02DF": "MODIFIER LETTER CROSS ACCENT",
    "02E0": "MODIFIER LETTER SMALL GAMMA",
    "02E1": "MODIFIER LETTER SMALL L",
    "02E2": "MODIFIER LETTER SMALL S",
    "02E3": "MODIFIER LETTER SMALL X",
    "02E4": "MODIFIER LETTER SMALL REVERSED GLOTTAL STOP",
    "02E5": "MODIFIER LETTER EXTRA-HIGH TONE BAR",
    "02E6": "MODIFIER LETTER HIGH TONE BAR",
    "02E7": "MODIFIER LETTER MID TONE BAR",
    "02E8": "MODIFIER LETTER LOW TONE BAR",
    "02E9": "MODIFIER LETTER EXTRA-LOW TONE BAR",
    "02EA": "MODIFIER LETTER YIN DEPARTING TONE MARK",
    "02EB": "MODIFIER LETTER YANG DEPARTING TONE MARK",
    "02EC": "MODIFIER LETTER VOICING",
    "02ED": "MODIFIER LETTER UNASPIRATED",
    "02EE": "MODIFIER LETTER DOUBLE APOSTROPHE",
    "02EF": "MODIFIER LETTER LOW DOWN ARROWHEAD",
    "02F0": "MODIFIER LETTER LOW UP ARROWHEAD",
    "02F1": "MODIFIER LETTER LOW LEFT ARROWHEAD",
    "02F2": "MODIFIER LETTER LOW RIGHT ARROWHEAD",
    "02F3": "MODIFIER LETTER LOW RING",
    "02F4": "MODIFIER LETTER MIDDLE GRAVE ACCENT",
    "02F5": "MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT",
    "02F6": "MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT",
    "02F7": "MODIFIER LETTER LOW TILDE",
    "02F8": "MODIFIER LETTER RAISED COLON",
    "02F9": "MODIFIER LETTER BEGIN HIGH TONE",
    "02FA": "MODIFIER LETTER END HIGH TONE",
    "02FB": "MODIFIER LETTER BEGIN LOW TONE",
    "02FC": "MODIFIER LETTER END LOW TONE",
    "02FD": "MODIFIER LETTER SHELF",
    "02FE": "MODIFIER LETTER OPEN SHELF",
    "02FF": "MODIFIER LETTER LOW LEFT ARROW",
    "0300": "COMBINING GRAVE ACCENT",
    "0301": "COMBINING ACUTE ACCENT",
    "0302": "COMBINING CIRCUMFLEX ACCENT",
    "0303": "COMBINING TILDE",
    "0304": "COMBINING MACRON",
    "0305": "COMBINING OVERLINE",
    "0306": "COMBINING BREVE",
    "0307": "COMBINING DOT ABOVE",
    "0308": "COMBINING DIAERESIS",
    "0309": "COMBINING HOOK ABOVE",
    "030A": "COMBINING RING ABOVE",
    "030B": "COMBINING DOUBLE ACUTE ACCENT",
    "030C": "COMBINING CARON",
    "030D": "COMBINING VERTICAL LINE ABOVE",
    "030E": "COMBINING DOUBLE VERTICAL LINE ABOVE",
    "030F": "COMBINING DOUBLE GRAVE ACCENT",
    "0310": "COMBINING CANDRABINDU",
    "0311": "COMBINING INVERTED BREVE",
    "0312": "COMBINING TURNED COMMA ABOVE",
    "0313": "COMBINING COMMA ABOVE",
    "0314": "COMBINING REVERSED COMMA ABOVE",
    "0315": "COMBINING COMMA ABOVE RIGHT",
    "0316": "COMBINING GRAVE ACCENT BELOW",
    "0317": "COMBINING ACUTE ACCENT BELOW",
    "0318": "COMBINING LEFT TACK BELOW",
    "0319": "COMBINING RIGHT TACK BELOW",
    "031A": "COMBINING LEFT ANGLE ABOVE",
    "031B": "COMBINING HORN",
    "031C": "COMBINING LEFT HALF RING BELOW",
    "031D": "COMBINING UP TACK BELOW",
    "031E": "COMBINING DOWN TACK BELOW",
    "031F": "COMBINING PLUS SIGN BELOW",
    "0320": "COMBINING MINUS SIGN BELOW",
    "0321": "COMBINING PALATALIZED HOOK BELOW",
    "0322": "COMBINING RETROFLEX HOOK BELOW",
    "0323": "COMBINING DOT BELOW",
    "0324": "COMBINING DIAERESIS BELOW",
    "0325": "COMBINING RING BELOW",
    "0326": "COMBINING COMMA BELOW",
    "0327": "COMBINING CEDILLA",
    "0328": "COMBINING OGONEK",
    "0329": "COMBINING VERTICAL LINE BELOW",
    "032A": "COMBINING BRIDGE BELOW",
    "032B": "COMBINING INVERTED DOUBLE ARCH BELOW",
    "032C": "COMBINING CARON BELOW",
    "032D": "COMBINING CIRCUMFLEX ACCENT BELOW",
    "032E": "COMBINING BREVE BELOW",
    "032F": "COMBINING INVERTED BREVE BELOW",
    "0330": "COMBINING TILDE BELOW",
    "0331": "COMBINING MACRON BELOW",
    "0332": "COMBINING LOW LINE",
    "0333": "COMBINING DOUBLE LOW LINE",
    "0334": "COMBINING TILDE OVERLAY",
    "0335": "COMBINING SHORT STROKE OVERLAY",
    "0336": "COMBINING LONG STROKE OVERLAY",
    "0337": "COMBINING SHORT SOLIDUS OVERLAY",
    "0338": "COMBINING LONG SOLIDUS OVERLAY",
    "0339": "COMBINING RIGHT HALF RING BELOW",
    "033A": "COMBINING INVERTED BRIDGE BELOW",
    "033B": "COMBINING SQUARE BELOW",
    "033C": "COMBINING SEAGULL BELOW",
    "033D": "COMBINING X ABOVE",
    "033E": "COMBINING VERTICAL TILDE",
    "033F": "COMBINING DOUBLE OVERLINE",
    "0340": "COMBINING GRAVE TONE MARK",
    "0341": "COMBINING ACUTE TONE MARK",
    "0342": "COMBINING GREEK PERISPOMENI",
    "0343": "COMBINING GREEK KORONIS",
    "0344": "COMBINING GREEK DIALYTIKA TONOS",
    "0345": "COMBINING GREEK YPOGEGRAMMENI",
    "0346": "COMBINING BRIDGE ABOVE",
    "0347": "COMBINING EQUALS SIGN BELOW",
    "0348": "COMBINING DOUBLE VERTICAL LINE BELOW",
    "0349": "COMBINING LEFT ANGLE BELOW",
    "034A": "COMBINING NOT TILDE ABOVE",
    "034B": "COMBINING HOMOTHETIC ABOVE",
    "034C": "COMBINING ALMOST EQUAL TO ABOVE",
    "034D": "COMBINING LEFT RIGHT ARROW BELOW",
    "034E": "COMBINING UPWARDS ARROW BELOW",
    "034F": "COMBINING GRAPHEME JOINER",
    "0350": "COMBINING RIGHT ARROWHEAD ABOVE",
    "0351": "COMBINING LEFT HALF RING ABOVE",
    "0352": "COMBINING FERMATA",
    "0353": "COMBINING X BELOW",
    "0354": "COMBINING LEFT ARROWHEAD BELOW",
    "0355": "COMBINING RIGHT ARROWHEAD BELOW",
    "0356": "COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW",
    "0357": "COMBINING RIGHT HALF RING ABOVE",
    "0358": "COMBINING DOT ABOVE RIGHT",
    "0359": "COMBINING ASTERISK BELOW",
    "035A": "COMBINING DOUBLE RING BELOW",
    "035B": "COMBINING ZIGZAG ABOVE",
    "035C": "COMBINING DOUBLE BREVE BELOW",
    "035D": "COMBINING DOUBLE BREVE",
    "035E": "COMBINING DOUBLE MACRON",
    "035F": "COMBINING DOUBLE MACRON BELOW",
    "0360": "COMBINING DOUBLE TILDE",
    "0361": "COMBINING DOUBLE INVERTED BREVE",
    "0362": "COMBINING DOUBLE RIGHTWARDS ARROW BELOW",
    "0363": "COMBINING LATIN SMALL LETTER A",
    "0364": "COMBINING LATIN SMALL LETTER E",
    "0365": "COMBINING LATIN SMALL LETTER I",
    "0366": "COMBINING LATIN SMALL LETTER O",
    "0367": "COMBINING LATIN SMALL LETTER U",
    "0368": "COMBINING LATIN SMALL LETTER C",
    "0369": "COMBINING LATIN SMALL LETTER D",
    "036A": "COMBINING LATIN SMALL LETTER H",
    "036B": "COMBINING LATIN SMALL LETTER M",
    "036C": "COMBINING LATIN SMALL LETTER R",
    "036D": "COMBINING LATIN SMALL LETTER T",
    "036E": "COMBINING LATIN SMALL LETTER V",
    "036F": "COMBINING LATIN SMALL LETTER X",
    "0370": "GREEK CAPITAL LETTER HETA",
    "0371": "GREEK SMALL LETTER HETA",
    "0372": "GREEK CAPITAL LETTER ARCHAIC SAMPI",
    "0373": "GREEK SMALL LETTER ARCHAIC SAMPI",
    "0374": "GREEK NUMERAL SIGN",
    "0375": "GREEK LOWER NUMERAL SIGN",
    "0376": "GREEK CAPITAL LETTER PAMPHYLIAN DIGAMMA",
    "0377": "GREEK SMALL LETTER PAMPHYLIAN DIGAMMA",
    "037A": "GREEK YPOGEGRAMMENI",
    "037B": "GREEK SMALL REVERSED LUNATE SIGMA SYMBOL",
    "037C": "GREEK SMALL DOTTED LUNATE SIGMA SYMBOL",
    "037D": "GREEK SMALL REVERSED DOTTED LUNATE SIGMA SYMBOL",
    "037E": "GREEK QUESTION MARK",
    "037F": "GREEK CAPITAL LETTER YOT",
    "0384": "GREEK TONOS",
    "0385": "GREEK DIALYTIKA TONOS",
    "0386": "GREEK CAPITAL LETTER ALPHA WITH TONOS",
    "0387": "GREEK ANO TELEIA",
    "0388": "GREEK CAPITAL LETTER EPSILON WITH TONOS",
    "0389": "GREEK CAPITAL LETTER ETA WITH TONOS",
    "038A": "GREEK CAPITAL LETTER IOTA WITH TONOS",
    "038C": "GREEK CAPITAL LETTER OMICRON WITH TONOS",
    "038E": "GREEK CAPITAL LETTER UPSILON WITH TONOS",
    "038F": "GREEK CAPITAL LETTER OMEGA WITH TONOS",
    "0390": "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS",
    "0391": "GREEK CAPITAL LETTER ALPHA",
    "0392": "GREEK CAPITAL LETTER BETA",
    "0393": "GREEK CAPITAL LETTER GAMMA",
    "0394": "GREEK CAPITAL LETTER DELTA",
    "0395": "GREEK CAPITAL LETTER EPSILON",
    "0396": "GREEK CAPITAL LETTER ZETA",
    "0397": "GREEK CAPITAL LETTER ETA",
    "0398": "GREEK CAPITAL LETTER THETA",
    "0399": "GREEK CAPITAL LETTER IOTA",
    "039A": "GREEK CAPITAL LETTER KAPPA",
    "039B": "GREEK CAPITAL LETTER LAMDA",
    "039C": "GREEK CAPITAL LETTER MU",
    "039D": "GREEK CAPITAL LETTER NU",
    "039E": "GREEK CAPITAL LETTER XI",
    "039F": "GREEK CAPITAL LETTER OMICRON",
    "03A0": "GREEK CAPITAL LETTER PI",
    "03A1": "GREEK CAPITAL LETTER RHO",
    "03A3": "GREEK CAPITAL LETTER SIGMA",
    "03A4": "GREEK CAPITAL LETTER TAU",
    "03A5": "GREEK CAPITAL LETTER UPSILON",
    "03A6": "GREEK CAPITAL LETTER PHI",
    "03A7": "GREEK CAPITAL LETTER CHI",
    "03A8": "GREEK CAPITAL LETTER PSI",
    "03A9": "GREEK CAPITAL LETTER OMEGA",
    "03AA": "GREEK CAPITAL LETTER IOTA WITH DIALYTIKA",
    "03AB": "GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA",
    "03AC": "GREEK SMALL LETTER ALPHA WITH TONOS",
    "03AD": "GREEK SMALL LETTER EPSILON WITH TONOS",
    "03AE": "GREEK SMALL LETTER ETA WITH TONOS",
    "03AF": "GREEK SMALL LETTER IOTA WITH TONOS",
    "03B0": "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS",
    "03B1": "GREEK SMALL LETTER ALPHA",
    "03B2": "GREEK SMALL LETTER BETA",
    "03B3": "GREEK SMALL LETTER GAMMA",
    "03B4": "GREEK SMALL LETTER DELTA",
    "03B5": "GREEK SMALL LETTER EPSILON",
    "03B6": "GREEK SMALL LETTER ZETA",
    "03B7": "GREEK SMALL LETTER ETA",
    "03B8": "GREEK SMALL LETTER THETA",
    "03B9": "GREEK SMALL LETTER IOTA",
    "03BA": "GREEK SMALL LETTER KAPPA",
    "03BB": "GREEK SMALL LETTER LAMDA",
    "03BC": "GREEK SMALL LETTER MU",
    "03BD": "GREEK SMALL LETTER NU",
    "03BE": "GREEK SMALL LETTER XI",
    "03BF": "GREEK SMALL LETTER OMICRON",
    "03C0": "GREEK SMALL LETTER PI",
    "03C1": "GREEK SMALL LETTER RHO",
    "03C2": "GREEK SMALL LETTER FINAL SIGMA",
    "03C3": "GREEK SMALL LETTER SIGMA",
    "03C4": "GREEK SMALL LETTER TAU",
    "03C5": "GREEK SMALL LETTER UPSILON",
    "03C6": "GREEK SMALL LETTER PHI",
    "03C7": "GREEK SMALL LETTER CHI",
    "03C8": "GREEK SMALL LETTER PSI",
    "03C9": "GREEK SMALL LETTER OMEGA",
    "03CA": "GREEK SMALL LETTER IOTA WITH DIALYTIKA",
    "03CB": "GREEK SMALL LETTER UPSILON WITH DIALYTIKA",
    "03CC": "GREEK SMALL LETTER OMICRON WITH TONOS",
    "03CD": "GREEK SMALL LETTER UPSILON WITH TONOS",
    "03CE": "GREEK SMALL LETTER OMEGA WITH TONOS",
    "03CF": "GREEK CAPITAL KAI SYMBOL",
    "03D0": "GREEK BETA SYMBOL",
    "03D1": "GREEK THETA SYMBOL",
    "03D2": "GREEK UPSILON WITH HOOK SYMBOL",
    "03D3": "GREEK UPSILON WITH ACUTE AND HOOK SYMBOL",
    "03D4": "GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL",
    "03D5": "GREEK PHI SYMBOL",
    "03D6": "GREEK PI SYMBOL",
    "03D7": "GREEK KAI SYMBOL",
    "03D8": "GREEK LETTER ARCHAIC KOPPA",
    "03D9": "GREEK SMALL LETTER ARCHAIC KOPPA",
    "03DA": "GREEK LETTER STIGMA",
    "03DB": "GREEK SMALL LETTER STIGMA",
    "03DC": "GREEK LETTER DIGAMMA",
    "03DD": "GREEK SMALL LETTER DIGAMMA",
    "03DE": "GREEK LETTER KOPPA",
    "03DF": "GREEK SMALL LETTER KOPPA",
    "03E0": "GREEK LETTER SAMPI",
    "03E1": "GREEK SMALL LETTER SAMPI",
    "03E2": "COPTIC CAPITAL LETTER SHEI",
    "03E3": "COPTIC SMALL LETTER SHEI",
    "03E4": "COPTIC CAPITAL LETTER FEI",
    "03E5": "COPTIC SMALL LETTER FEI",
    "03E6": "COPTIC CAPITAL LETTER KHEI",
    "03E7": "COPTIC SMALL LETTER KHEI",
    "03E8": "COPTIC CAPITAL LETTER HORI",
    "03E9": "COPTIC SMALL LETTER HORI",
    "03EA": "COPTIC CAPITAL LETTER GANGIA",
    "03EB": "COPTIC SMALL LETTER GANGIA",
    "03EC": "COPTIC CAPITAL LETTER SHIMA",
    "03ED": "COPTIC SMALL LETTER SHIMA",
    "03EE": "COPTIC CAPITAL LETTER DEI",
    "03EF": "COPTIC SMALL LETTER DEI",
    "03F0": "GREEK KAPPA SYMBOL",
    "03F1": "GREEK RHO SYMBOL",
    "03F2": "GREEK LUNATE SIGMA SYMBOL",
    "03F3": "GREEK LETTER YOT",
    "03F4": "GREEK CAPITAL THETA SYMBOL",
    "03F5": "GREEK LUNATE EPSILON SYMBOL",
    "03F6": "GREEK REVERSED LUNATE EPSILON SYMBOL",
    "03F7": "GREEK CAPITAL LETTER SHO",
    "03F8": "GREEK SMALL LETTER SHO",
    "03F9": "GREEK CAPITAL LUNATE SIGMA SYMBOL",
    "03FA": "GREEK CAPITAL LETTER SAN",
    "03FB": "GREEK SMALL LETTER SAN",
    "03FC": "GREEK RHO WITH STROKE SYMBOL",
    "03FD": "GREEK CAPITAL REVERSED LUNATE SIGMA SYMBOL",
    "03FE": "GREEK CAPITAL DOTTED LUNATE SIGMA SYMBOL",
    "03FF": "GREEK CAPITAL REVERSED DOTTED LUNATE SIGMA SYMBOL",
    "0400": "CYRILLIC CAPITAL LETTER IE WITH GRAVE",
    "0401": "CYRILLIC CAPITAL LETTER IO",
    "0402": "CYRILLIC CAPITAL LETTER DJE",
    "0403": "CYRILLIC CAPITAL LETTER GJE",
    "0404": "CYRILLIC CAPITAL LETTER UKRAINIAN IE",
    "0405": "CYRILLIC CAPITAL LETTER DZE",
    "0406": "CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I",
    "0407": "CYRILLIC CAPITAL LETTER YI",
    "0408": "CYRILLIC CAPITAL LETTER JE",
    "0409": "CYRILLIC CAPITAL LETTER LJE",
    "040A": "CYRILLIC CAPITAL LETTER NJE",
    "040B": "CYRILLIC CAPITAL LETTER TSHE",
    "040C": "CYRILLIC CAPITAL LETTER KJE",
    "040D": "CYRILLIC CAPITAL LETTER I WITH GRAVE",
    "040E": "CYRILLIC CAPITAL LETTER SHORT U",
    "040F": "CYRILLIC CAPITAL LETTER DZHE",
    "0410": "CYRILLIC CAPITAL LETTER A",
    "0411": "CYRILLIC CAPITAL LETTER BE",
    "0412": "CYRILLIC CAPITAL LETTER VE",
    "0413": "CYRILLIC CAPITAL LETTER GHE",
    "0414": "CYRILLIC CAPITAL LETTER DE",
    "0415": "CYRILLIC CAPITAL LETTER IE",
    "0416": "CYRILLIC CAPITAL LETTER ZHE",
    "0417": "CYRILLIC CAPITAL LETTER ZE",
    "0418": "CYRILLIC CAPITAL LETTER I",
    "0419": "CYRILLIC CAPITAL LETTER SHORT I",
    "041A": "CYRILLIC CAPITAL LETTER KA",
    "041B": "CYRILLIC CAPITAL LETTER EL",
    "041C": "CYRILLIC CAPITAL LETTER EM",
    "041D": "CYRILLIC CAPITAL LETTER EN",
    "041E": "CYRILLIC CAPITAL LETTER O",
    "041F": "CYRILLIC CAPITAL LETTER PE",
    "0420": "CYRILLIC CAPITAL LETTER ER",
    "0421": "CYRILLIC CAPITAL LETTER ES",
    "0422": "CYRILLIC CAPITAL LETTER TE",
    "0423": "CYRILLIC CAPITAL LETTER U",
    "0424": "CYRILLIC CAPITAL LETTER EF",
    "0425": "CYRILLIC CAPITAL LETTER HA",
    "0426": "CYRILLIC CAPITAL LETTER TSE",
    "0427": "CYRILLIC CAPITAL LETTER CHE",
    "0428": "CYRILLIC CAPITAL LETTER SHA",
    "0429": "CYRILLIC CAPITAL LETTER SHCHA",
    "042A": "CYRILLIC CAPITAL LETTER HARD SIGN",
    "042B": "CYRILLIC CAPITAL LETTER YERU",
    "042C": "CYRILLIC CAPITAL LETTER SOFT SIGN",
    "042D": "CYRILLIC CAPITAL LETTER E",
    "042E": "CYRILLIC CAPITAL LETTER YU",
    "042F": "CYRILLIC CAPITAL LETTER YA",
    "0430": "CYRILLIC SMALL LETTER A",
    "0431": "CYRILLIC SMALL LETTER BE",
    "0432": "CYRILLIC SMALL LETTER VE",
    "0433": "CYRILLIC SMALL LETTER GHE",
    "0434": "CYRILLIC SMALL LETTER DE",
    "0435": "CYRILLIC SMALL LETTER IE",
    "0436": "CYRILLIC SMALL LETTER ZHE",
    "0437": "CYRILLIC SMALL LETTER ZE",
    "0438": "CYRILLIC SMALL LETTER I",
    "0439": "CYRILLIC SMALL LETTER SHORT I",
    "043A": "CYRILLIC SMALL LETTER KA",
    "043B": "CYRILLIC SMALL LETTER EL",
    "043C": "CYRILLIC SMALL LETTER EM",
    "043D": "CYRILLIC SMALL LETTER EN",
    "043E": "CYRILLIC SMALL LETTER O",
    "043F": "CYRILLIC SMALL LETTER PE",
    "0440": "CYRILLIC SMALL LETTER ER",
    "0441": "CYRILLIC SMALL LETTER ES",
    "0442": "CYRILLIC SMALL LETTER TE",
    "0443": "CYRILLIC SMALL LETTER U",
    "0444": "CYRILLIC SMALL LETTER EF",
    "0445": "CYRILLIC SMALL LETTER HA",
    "0446": "CYRILLIC SMALL LETTER TSE",
    "0447": "CYRILLIC SMALL LETTER CHE",
    "0448": "CYRILLIC SMALL LETTER SHA",
    "0449": "CYRILLIC SMALL LETTER SHCHA",
    "044A": "CYRILLIC SMALL LETTER HARD SIGN",
    "044B": "CYRILLIC SMALL LETTER YERU",
    "044C": "CYRILLIC SMALL LETTER SOFT SIGN",
    "044D": "CYRILLIC SMALL LETTER E",
    "044E": "CYRILLIC SMALL LETTER YU",
    "044F": "CYRILLIC SMALL LETTER YA",
    "0450": "CYRILLIC SMALL LETTER IE WITH GRAVE",
    "0451": "CYRILLIC SMALL LETTER IO",
    "0452": "CYRILLIC SMALL LETTER DJE",
    "0453": "CYRILLIC SMALL LETTER GJE",
    "0454": "CYRILLIC SMALL LETTER UKRAINIAN IE",
    "0455": "CYRILLIC SMALL LETTER DZE",
    "0456": "CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I",
    "0457": "CYRILLIC SMALL LETTER YI",
    "0458": "CYRILLIC SMALL LETTER JE",
    "0459": "CYRILLIC SMALL LETTER LJE",
    "045A": "CYRILLIC SMALL LETTER NJE",
    "045B": "CYRILLIC SMALL LETTER TSHE",
    "045C": "CYRILLIC SMALL LETTER KJE",
    "045D": "CYRILLIC SMALL LETTER I WITH GRAVE",
    "045E": "CYRILLIC SMALL LETTER SHORT U",
    "045F": "CYRILLIC SMALL LETTER DZHE",
    "0460": "CYRILLIC CAPITAL LETTER OMEGA",
    "0461": "CYRILLIC SMALL LETTER OMEGA",
    "0462": "CYRILLIC CAPITAL LETTER YAT",
    "0463": "CYRILLIC SMALL LETTER YAT",
    "0464": "CYRILLIC CAPITAL LETTER IOTIFIED E",
    "0465": "CYRILLIC SMALL LETTER IOTIFIED E",
    "0466": "CYRILLIC CAPITAL LETTER LITTLE YUS",
    "0467": "CYRILLIC SMALL LETTER LITTLE YUS",
    "0468": "CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS",
    "0469": "CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS",
    "046A": "CYRILLIC CAPITAL LETTER BIG YUS",
    "046B": "CYRILLIC SMALL LETTER BIG YUS",
    "046C": "CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS",
    "046D": "CYRILLIC SMALL LETTER IOTIFIED BIG YUS",
    "046E": "CYRILLIC CAPITAL LETTER KSI",
    "046F": "CYRILLIC SMALL LETTER KSI",
    "0470": "CYRILLIC CAPITAL LETTER PSI",
    "0471": "CYRILLIC SMALL LETTER PSI",
    "0472": "CYRILLIC CAPITAL LETTER FITA",
    "0473": "CYRILLIC SMALL LETTER FITA",
    "0474": "CYRILLIC CAPITAL LETTER IZHITSA",
    "0475": "CYRILLIC SMALL LETTER IZHITSA",
    "0476": "CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
    "0477": "CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT",
    "0478": "CYRILLIC CAPITAL LETTER UK",
    "0479": "CYRILLIC SMALL LETTER UK",
    "047A": "CYRILLIC CAPITAL LETTER ROUND OMEGA",
    "047B": "CYRILLIC SMALL LETTER ROUND OMEGA",
    "047C": "CYRILLIC CAPITAL LETTER OMEGA WITH TITLO",
    "047D": "CYRILLIC SMALL LETTER OMEGA WITH TITLO",
    "047E": "CYRILLIC CAPITAL LETTER OT",
    "047F": "CYRILLIC SMALL LETTER OT",
    "0480": "CYRILLIC CAPITAL LETTER KOPPA",
    "0481": "CYRILLIC SMALL LETTER KOPPA",
    "0482": "CYRILLIC THOUSANDS SIGN",
    "0483": "COMBINING CYRILLIC TITLO",
    "0484": "COMBINING CYRILLIC PALATALIZATION",
    "0485": "COMBINING CYRILLIC DASIA PNEUMATA",
    "0486": "COMBINING CYRILLIC PSILI PNEUMATA",
    "0487": "COMBINING CYRILLIC POKRYTIE",
    "0488": "COMBINING CYRILLIC HUNDRED THOUSANDS SIGN",
    "0489": "COMBINING CYRILLIC MILLIONS SIGN",
    "048A": "CYRILLIC CAPITAL LETTER SHORT I WITH TAIL",
    "048B": "CYRILLIC SMALL LETTER SHORT I WITH TAIL",
    "048C": "CYRILLIC CAPITAL LETTER SEMISOFT SIGN",
    "048D": "CYRILLIC SMALL LETTER SEMISOFT SIGN",
    "048E": "CYRILLIC CAPITAL LETTER ER WITH TICK",
    "048F": "CYRILLIC SMALL LETTER ER WITH TICK",
    "0490": "CYRILLIC CAPITAL LETTER GHE WITH UPTURN",
    "0491": "CYRILLIC SMALL LETTER GHE WITH UPTURN",
    "0492": "CYRILLIC CAPITAL LETTER GHE WITH STROKE",
    "0493": "CYRILLIC SMALL LETTER GHE WITH STROKE",
    "0494": "CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK",
    "0495": "CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK",
    "0496": "CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER",
    "0497": "CYRILLIC SMALL LETTER ZHE WITH DESCENDER",
    "0498": "CYRILLIC CAPITAL LETTER ZE WITH DESCENDER",
    "0499": "CYRILLIC SMALL LETTER ZE WITH DESCENDER",
    "049A": "CYRILLIC CAPITAL LETTER KA WITH DESCENDER",
    "049B": "CYRILLIC SMALL LETTER KA WITH DESCENDER",
    "049C": "CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE",
    "049D": "CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE",
    "049E": "CYRILLIC CAPITAL LETTER KA WITH STROKE",
    "049F": "CYRILLIC SMALL LETTER KA WITH STROKE",
    "04A0": "CYRILLIC CAPITAL LETTER BASHKIR KA",
    "04A1": "CYRILLIC SMALL LETTER BASHKIR KA",
    "04A2": "CYRILLIC CAPITAL LETTER EN WITH DESCENDER",
    "04A3": "CYRILLIC SMALL LETTER EN WITH DESCENDER",
    "04A4": "CYRILLIC CAPITAL LIGATURE EN GHE",
    "04A5": "CYRILLIC SMALL LIGATURE EN GHE",
    "04A6": "CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK",
    "04A7": "CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK",
    "04A8": "CYRILLIC CAPITAL LETTER ABKHASIAN HA",
    "04A9": "CYRILLIC SMALL LETTER ABKHASIAN HA",
    "04AA": "CYRILLIC CAPITAL LETTER ES WITH DESCENDER",
    "04AB": "CYRILLIC SMALL LETTER ES WITH DESCENDER",
    "04AC": "CYRILLIC CAPITAL LETTER TE WITH DESCENDER",
    "04AD": "CYRILLIC SMALL LETTER TE WITH DESCENDER",
    "04AE": "CYRILLIC CAPITAL LETTER STRAIGHT U",
    "04AF": "CYRILLIC SMALL LETTER STRAIGHT U",
    "04B0": "CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE",
    "04B1": "CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE",
    "04B2": "CYRILLIC CAPITAL LETTER HA WITH DESCENDER",
    "04B3": "CYRILLIC SMALL LETTER HA WITH DESCENDER",
    "04B4": "CYRILLIC CAPITAL LIGATURE TE TSE",
    "04B5": "CYRILLIC SMALL LIGATURE TE TSE",
    "04B6": "CYRILLIC CAPITAL LETTER CHE WITH DESCENDER",
    "04B7": "CYRILLIC SMALL LETTER CHE WITH DESCENDER",
    "04B8": "CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE",
    "04B9": "CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE",
    "04BA": "CYRILLIC CAPITAL LETTER SHHA",
    "04BB": "CYRILLIC SMALL LETTER SHHA",
    "04BC": "CYRILLIC CAPITAL LETTER ABKHASIAN CHE",
    "04BD": "CYRILLIC SMALL LETTER ABKHASIAN CHE",
    "04BE": "CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER",
    "04BF": "CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER",
    "04C0": "CYRILLIC LETTER PALOCHKA",
    "04C1": "CYRILLIC CAPITAL LETTER ZHE WITH BREVE",
    "04C2": "CYRILLIC SMALL LETTER ZHE WITH BREVE",
    "04C3": "CYRILLIC CAPITAL LETTER KA WITH HOOK",
    "04C4": "CYRILLIC SMALL LETTER KA WITH HOOK",
    "04C5": "CYRILLIC CAPITAL LETTER EL WITH TAIL",
    "04C6": "CYRILLIC SMALL LETTER EL WITH TAIL",
    "04C7": "CYRILLIC CAPITAL LETTER EN WITH HOOK",
    "04C8": "CYRILLIC SMALL LETTER EN WITH HOOK",
    "04C9": "CYRILLIC CAPITAL LETTER EN WITH TAIL",
    "04CA": "CYRILLIC SMALL LETTER EN WITH TAIL",
    "04CB": "CYRILLIC CAPITAL LETTER KHAKASSIAN CHE",
    "04CC": "CYRILLIC SMALL LETTER KHAKASSIAN CHE",
    "04CD": "CYRILLIC CAPITAL LETTER EM WITH TAIL",
    "04CE": "CYRILLIC SMALL LETTER EM WITH TAIL",
    "04CF": "CYRILLIC SMALL LETTER PALOCHKA",
    "04D0": "CYRILLIC CAPITAL LETTER A WITH BREVE",
    "04D1": "CYRILLIC SMALL LETTER A WITH BREVE",
    "04D2": "CYRILLIC CAPITAL LETTER A WITH DIAERESIS",
    "04D3": "CYRILLIC SMALL LETTER A WITH DIAERESIS",
    "04D4": "CYRILLIC CAPITAL LIGATURE A IE",
    "04D5": "CYRILLIC SMALL LIGATURE A IE",
    "04D6": "CYRILLIC CAPITAL LETTER IE WITH BREVE",
    "04D7": "CYRILLIC SMALL LETTER IE WITH BREVE",
    "04D8": "CYRILLIC CAPITAL LETTER SCHWA",
    "04D9": "CYRILLIC SMALL LETTER SCHWA",
    "04DA": "CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS",
    "04DB": "CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS",
    "04DC": "CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS",
    "04DD": "CYRILLIC SMALL LETTER ZHE WITH DIAERESIS",
    "04DE": "CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS",
    "04DF": "CYRILLIC SMALL LETTER ZE WITH DIAERESIS",
    "04E0": "CYRILLIC CAPITAL LETTER ABKHASIAN DZE",
    "04E1": "CYRILLIC SMALL LETTER ABKHASIAN DZE",
    "04E2": "CYRILLIC CAPITAL LETTER I WITH MACRON",
    "04E3": "CYRILLIC SMALL LETTER I WITH MACRON",
    "04E4": "CYRILLIC CAPITAL LETTER I WITH DIAERESIS",
    "04E5": "CYRILLIC SMALL LETTER I WITH DIAERESIS",
    "04E6": "CYRILLIC CAPITAL LETTER O WITH DIAERESIS",
    "04E7": "CYRILLIC SMALL LETTER O WITH DIAERESIS",
    "04E8": "CYRILLIC CAPITAL LETTER BARRED O",
    "04E9": "CYRILLIC SMALL LETTER BARRED O",
    "04EA": "CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS",
    "04EB": "CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS",
    "04EC": "CYRILLIC CAPITAL LETTER E WITH DIAERESIS",
    "04ED": "CYRILLIC SMALL LETTER E WITH DIAERESIS",
    "04EE": "CYRILLIC CAPITAL LETTER U WITH MACRON",
    "04EF": "CYRILLIC SMALL LETTER U WITH MACRON",
    "04F0": "CYRILLIC CAPITAL LETTER U WITH DIAERESIS",
    "04F1": "CYRILLIC SMALL LETTER U WITH DIAERESIS",
    "04F2": "CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE",
    "04F3": "CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE",
    "04F4": "CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS",
    "04F5": "CYRILLIC SMALL LETTER CHE WITH DIAERESIS",
    "04F6": "CYRILLIC CAPITAL LETTER GHE WITH DESCENDER",
    "04F7": "CYRILLIC SMALL LETTER GHE WITH DESCENDER",
    "04F8": "CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS",
    "04F9": "CYRILLIC SMALL LETTER YERU WITH DIAERESIS",
    "04FA": "CYRILLIC CAPITAL LETTER GHE WITH STROKE AND HOOK",
    "04FB": "CYRILLIC SMALL LETTER GHE WITH STROKE AND HOOK",
    "04FC": "CYRILLIC CAPITAL LETTER HA WITH HOOK",
    "04FD": "CYRILLIC SMALL LETTER HA WITH HOOK",
    "04FE": "CYRILLIC CAPITAL LETTER HA WITH STROKE",
    "04FF": "CYRILLIC SMALL LETTER HA WITH STROKE",
    "0500": "CYRILLIC CAPITAL LETTER KOMI DE",
    "0501": "CYRILLIC SMALL LETTER KOMI DE",
    "0502": "CYRILLIC CAPITAL LETTER KOMI DJE",
    "0503": "CYRILLIC SMALL LETTER KOMI DJE",
    "0504": "CYRILLIC CAPITAL LETTER KOMI ZJE",
    "0505": "CYRILLIC SMALL LETTER KOMI ZJE",
    "0506": "CYRILLIC CAPITAL LETTER KOMI DZJE",
    "0507": "CYRILLIC SMALL LETTER KOMI DZJE",
    "0508": "CYRILLIC CAPITAL LETTER KOMI LJE",
    "0509": "CYRILLIC SMALL LETTER KOMI LJE",
    "050A": "CYRILLIC CAPITAL LETTER KOMI NJE",
    "050B": "CYRILLIC SMALL LETTER KOMI NJE",
    "050C": "CYRILLIC CAPITAL LETTER KOMI SJE",
    "050D": "CYRILLIC SMALL LETTER KOMI SJE",
    "050E": "CYRILLIC CAPITAL LETTER KOMI TJE",
    "050F": "CYRILLIC SMALL LETTER KOMI TJE",
    "0510": "CYRILLIC CAPITAL LETTER REVERSED ZE",
    "0511": "CYRILLIC SMALL LETTER REVERSED ZE",
    "0512": "CYRILLIC CAPITAL LETTER EL WITH HOOK",
    "0513": "CYRILLIC SMALL LETTER EL WITH HOOK",
    "0514": "CYRILLIC CAPITAL LETTER LHA",
    "0515": "CYRILLIC SMALL LETTER LHA",
    "0516": "CYRILLIC CAPITAL LETTER RHA",
    "0517": "CYRILLIC SMALL LETTER RHA",
    "0518": "CYRILLIC CAPITAL LETTER YAE",
    "0519": "CYRILLIC SMALL LETTER YAE",
    "051A": "CYRILLIC CAPITAL LETTER QA",
    "051B": "CYRILLIC SMALL LETTER QA",
    "051C": "CYRILLIC CAPITAL LETTER WE",
    "051D": "CYRILLIC SMALL LETTER WE",
    "051E": "CYRILLIC CAPITAL LETTER ALEUT KA",
    "051F": "CYRILLIC SMALL LETTER ALEUT KA",
    "0520": "CYRILLIC CAPITAL LETTER EL WITH MIDDLE HOOK",
    "0521": "CYRILLIC SMALL LETTER EL WITH MIDDLE HOOK",
    "0522": "CYRILLIC CAPITAL LETTER EN WITH MIDDLE HOOK",
    "0523": "CYRILLIC SMALL LETTER EN WITH MIDDLE HOOK",
    "0524": "CYRILLIC CAPITAL LETTER PE WITH DESCENDER",
    "0525": "CYRILLIC SMALL LETTER PE WITH DESCENDER",
    "0526": "CYRILLIC CAPITAL LETTER SHHA WITH DESCENDER",
    "0527": "CYRILLIC SMALL LETTER SHHA WITH DESCENDER",
    "0528": "CYRILLIC CAPITAL LETTER EN WITH LEFT HOOK",
    "0529": "CYRILLIC SMALL LETTER EN WITH LEFT HOOK",
    "052A": "CYRILLIC CAPITAL LETTER DZZHE",
    "052B": "CYRILLIC SMALL LETTER DZZHE",
    "052C": "CYRILLIC CAPITAL LETTER DCHE",
    "052D": "CYRILLIC SMALL LETTER DCHE",
    "052E": "CYRILLIC CAPITAL LETTER EL WITH DESCENDER",
    "052F": "CYRILLIC SMALL LETTER EL WITH DESCENDER",
    "0531": "ARMENIAN CAPITAL LETTER AYB",
    "0532": "ARMENIAN CAPITAL LETTER BEN",
    "0533": "ARMENIAN CAPITAL LETTER GIM",
    "0534": "ARMENIAN CAPITAL LETTER DA",
    "0535": "ARMENIAN CAPITAL LETTER ECH",
    "0536": "ARMENIAN CAPITAL LETTER ZA",
    "0537": "ARMENIAN CAPITAL LETTER EH",
    "0538": "ARMENIAN CAPITAL LETTER ET",
    "0539": "ARMENIAN CAPITAL LETTER TO",
    "053A": "ARMENIAN CAPITAL LETTER ZHE",
    "053B": "ARMENIAN CAPITAL LETTER INI",
    "053C": "ARMENIAN CAPITAL LETTER LIWN",
    "053D": "ARMENIAN CAPITAL LETTER XEH",
    "053E": "ARMENIAN CAPITAL LETTER CA",
    "053F": "ARMENIAN CAPITAL LETTER KEN",
    "0540": "ARMENIAN CAPITAL LETTER HO",
    "0541": "ARMENIAN CAPITAL LETTER JA",
    "0542": "ARMENIAN CAPITAL LETTER GHAD",
    "0543": "ARMENIAN CAPITAL LETTER CHEH",
    "0544": "ARMENIAN CAPITAL LETTER MEN",
    "0545": "ARMENIAN CAPITAL LETTER YI",
    "0546": "ARMENIAN CAPITAL LETTER NOW",
    "0547": "ARMENIAN CAPITAL LETTER SHA",
    "0548": "ARMENIAN CAPITAL LETTER VO",
    "0549": "ARMENIAN CAPITAL LETTER CHA",
    "054A": "ARMENIAN CAPITAL LETTER PEH",
    "054B": "ARMENIAN CAPITAL LETTER JHEH",
    "054C": "ARMENIAN CAPITAL LETTER RA",
    "054D": "ARMENIAN CAPITAL LETTER SEH",
    "054E": "ARMENIAN CAPITAL LETTER VEW",
    "054F": "ARMENIAN CAPITAL LETTER TIWN",
    "0550": "ARMENIAN CAPITAL LETTER REH",
    "0551": "ARMENIAN CAPITAL LETTER CO",
    "0552": "ARMENIAN CAPITAL LETTER YIWN",
    "0553": "ARMENIAN CAPITAL LETTER PIWR",
    "0554": "ARMENIAN CAPITAL LETTER KEH",
    "0555": "ARMENIAN CAPITAL LETTER OH",
    "0556": "ARMENIAN CAPITAL LETTER FEH",
    "0559": "ARMENIAN MODIFIER LETTER LEFT HALF RING",
    "055A": "ARMENIAN APOSTROPHE",
    "055B": "ARMENIAN EMPHASIS MARK",
    "055C": "ARMENIAN EXCLAMATION MARK",
    "055D": "ARMENIAN COMMA",
    "055E": "ARMENIAN QUESTION MARK",
    "055F": "ARMENIAN ABBREVIATION MARK",
    "0561": "ARMENIAN SMALL LETTER AYB",
    "0562": "ARMENIAN SMALL LETTER BEN",
    "0563": "ARMENIAN SMALL LETTER GIM",
    "0564": "ARMENIAN SMALL LETTER DA",
    "0565": "ARMENIAN SMALL LETTER ECH",
    "0566": "ARMENIAN SMALL LETTER ZA",
    "0567": "ARMENIAN SMALL LETTER EH",
    "0568": "ARMENIAN SMALL LETTER ET",
    "0569": "ARMENIAN SMALL LETTER TO",
    "056A": "ARMENIAN SMALL LETTER ZHE",
    "056B": "ARMENIAN SMALL LETTER INI",
    "056C": "ARMENIAN SMALL LETTER LIWN",
    "056D": "ARMENIAN SMALL LETTER XEH",
    "056E": "ARMENIAN SMALL LETTER CA",
    "056F": "ARMENIAN SMALL LETTER KEN",
    "0570": "ARMENIAN SMALL LETTER HO",
    "0571": "ARMENIAN SMALL LETTER JA",
    "0572": "ARMENIAN SMALL LETTER GHAD",
    "0573": "ARMENIAN SMALL LETTER CHEH",
    "0574": "ARMENIAN SMALL LETTER MEN",
    "0575": "ARMENIAN SMALL LETTER YI",
    "0576": "ARMENIAN SMALL LETTER NOW",
    "0577": "ARMENIAN SMALL LETTER SHA",
    "0578": "ARMENIAN SMALL LETTER VO",
    "0579": "ARMENIAN SMALL LETTER CHA",
    "057A": "ARMENIAN SMALL LETTER PEH",
    "057B": "ARMENIAN SMALL LETTER JHEH",
    "057C": "ARMENIAN SMALL LETTER RA",
    "057D": "ARMENIAN SMALL LETTER SEH",
    "057E": "ARMENIAN SMALL LETTER VEW",
    "057F": "ARMENIAN SMALL LETTER TIWN",
    "0580": "ARMENIAN SMALL LETTER REH",
    "0581": "ARMENIAN SMALL LETTER CO",
    "0582": "ARMENIAN SMALL LETTER YIWN",
    "0583": "ARMENIAN SMALL LETTER PIWR",
    "0584": "ARMENIAN SMALL LETTER KEH",
    "0585": "ARMENIAN SMALL LETTER OH",
    "0586": "ARMENIAN SMALL LETTER FEH",
    "0587": "ARMENIAN SMALL LIGATURE ECH YIWN",
    "0589": "ARMENIAN FULL STOP",
    "058A": "ARMENIAN HYPHEN",
    "058D": "RIGHT-FACING ARMENIAN ETERNITY SIGN",
    "058E": "LEFT-FACING ARMENIAN ETERNITY SIGN",
    "058F": "ARMENIAN DRAM SIGN",
    "0591": "HEBREW ACCENT ETNAHTA",
    "0592": "HEBREW ACCENT SEGOL",
    "0593": "HEBREW ACCENT SHALSHELET",
    "0594": "HEBREW ACCENT ZAQEF QATAN",
    "0595": "HEBREW ACCENT ZAQEF GADOL",
    "0596": "HEBREW ACCENT TIPEHA",
    "0597": "HEBREW ACCENT REVIA",
    "0598": "HEBREW ACCENT ZARQA",
    "0599": "HEBREW ACCENT PASHTA",
    "059A": "HEBREW ACCENT YETIV",
    "059B": "HEBREW ACCENT TEVIR",
    "059C": "HEBREW ACCENT GERESH",
    "059D": "HEBREW ACCENT GERESH MUQDAM",
    "059E": "HEBREW ACCENT GERSHAYIM",
    "059F": "HEBREW ACCENT QARNEY PARA",
    "05A0": "HEBREW ACCENT TELISHA GEDOLA",
    "05A1": "HEBREW ACCENT PAZER",
    "05A2": "HEBREW ACCENT ATNAH HAFUKH",
    "05A3": "HEBREW ACCENT MUNAH",
    "05A4": "HEBREW ACCENT MAHAPAKH",
    "05A5": "HEBREW ACCENT MERKHA",
    "05A6": "HEBREW ACCENT MERKHA KEFULA",
    "05A7": "HEBREW ACCENT DARGA",
    "05A8": "HEBREW ACCENT QADMA",
    "05A9": "HEBREW ACCENT TELISHA QETANA",
    "05AA": "HEBREW ACCENT YERAH BEN YOMO",
    "05AB": "HEBREW ACCENT OLE",
    "05AC": "HEBREW ACCENT ILUY",
    "05AD": "HEBREW ACCENT DEHI",
    "05AE": "HEBREW ACCENT ZINOR",
    "05AF": "HEBREW MARK MASORA CIRCLE",
    "05B0": "HEBREW POINT SHEVA",
    "05B1": "HEBREW POINT HATAF SEGOL",
    "05B2": "HEBREW POINT HATAF PATAH",
    "05B3": "HEBREW POINT HATAF QAMATS",
    "05B4": "HEBREW POINT HIRIQ",
    "05B5": "HEBREW POINT TSERE",
    "05B6": "HEBREW POINT SEGOL",
    "05B7": "HEBREW POINT PATAH",
    "05B8": "HEBREW POINT QAMATS",
    "05B9": "HEBREW POINT HOLAM",
    "05BA": "HEBREW POINT HOLAM HASER FOR VAV",
    "05BB": "HEBREW POINT QUBUTS",
    "05BC": "HEBREW POINT DAGESH OR MAPIQ",
    "05BD": "HEBREW POINT METEG",
    "05BE": "HEBREW PUNCTUATION MAQAF",
    "05BF": "HEBREW POINT RAFE",
    "05C0": "HEBREW PUNCTUATION PASEQ",
    "05C1": "HEBREW POINT SHIN DOT",
    "05C2": "HEBREW POINT SIN DOT",
    "05C3": "HEBREW PUNCTUATION SOF PASUQ",
    "05C4": "HEBREW MARK UPPER DOT",
    "05C5": "HEBREW MARK LOWER DOT",
    "05C6": "HEBREW PUNCTUATION NUN HAFUKHA",
    "05C7": "HEBREW POINT QAMATS QATAN",
    "05D0": "HEBREW LETTER ALEF",
    "05D1": "HEBREW LETTER BET",
    "05D2": "HEBREW LETTER GIMEL",
    "05D3": "HEBREW LETTER DALET",
    "05D4": "HEBREW LETTER HE",
    "05D5": "HEBREW LETTER VAV",
    "05D6": "HEBREW LETTER ZAYIN",
    "05D7": "HEBREW LETTER HET",
    "05D8": "HEBREW LETTER TET",
    "05D9": "HEBREW LETTER YOD",
    "05DA": "HEBREW LETTER FINAL KAF",
    "05DB": "HEBREW LETTER KAF",
    "05DC": "HEBREW LETTER LAMED",
    "05DD": "HEBREW LETTER FINAL MEM",
    "05DE": "HEBREW LETTER MEM",
    "05DF": "HEBREW LETTER FINAL NUN",
    "05E0": "HEBREW LETTER NUN",
    "05E1": "HEBREW LETTER SAMEKH",
    "05E2": "HEBREW LETTER AYIN",
    "05E3": "HEBREW LETTER FINAL PE",
    "05E4": "HEBREW LETTER PE",
    "05E5": "HEBREW LETTER FINAL TSADI",
    "05E6": "HEBREW LETTER TSADI",
    "05E7": "HEBREW LETTER QOF",
    "05E8": "HEBREW LETTER RESH",
    "05E9": "HEBREW LETTER SHIN",
    "05EA": "HEBREW LETTER TAV",
    "05F0": "HEBREW LIGATURE YIDDISH DOUBLE VAV",
    "05F1": "HEBREW LIGATURE YIDDISH VAV YOD",
    "05F2": "HEBREW LIGATURE YIDDISH DOUBLE YOD",
    "05F3": "HEBREW PUNCTUATION GERESH",
    "05F4": "HEBREW PUNCTUATION GERSHAYIM",
    "0600": "ARABIC NUMBER SIGN",
    "0601": "ARABIC SIGN SANAH",
    "0602": "ARABIC FOOTNOTE MARKER",
    "0603": "ARABIC SIGN SAFHA",
    "0604": "ARABIC SIGN SAMVAT",
    "0605": "ARABIC NUMBER MARK ABOVE",
    "0606": "ARABIC-INDIC CUBE ROOT",
    "0607": "ARABIC-INDIC FOURTH ROOT",
    "0608": "ARABIC RAY",
    "0609": "ARABIC-INDIC PER MILLE SIGN",
    "060A": "ARABIC-INDIC PER TEN THOUSAND SIGN",
    "060B": "AFGHANI SIGN",
    "060C": "ARABIC COMMA",
    "060D": "ARABIC DATE SEPARATOR",
    "060E": "ARABIC POETIC VERSE SIGN",
    "060F": "ARABIC SIGN MISRA",
    "0610": "ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM",
    "0611": "ARABIC SIGN ALAYHE ASSALLAM",
    "0612": "ARABIC SIGN RAHMATULLAH ALAYHE",
    "0613": "ARABIC SIGN RADI ALLAHOU ANHU",
    "0614": "ARABIC SIGN TAKHALLUS",
    "0615": "ARABIC SMALL HIGH TAH",
    "0616": "ARABIC SMALL HIGH LIGATURE ALEF WITH LAM WITH YEH",
    "0617": "ARABIC SMALL HIGH ZAIN",
    "0618": "ARABIC SMALL FATHA",
    "0619": "ARABIC SMALL DAMMA",
    "061A": "ARABIC SMALL KASRA",
    "061B": "ARABIC SEMICOLON",
    "061C": "ARABIC LETTER MARK",
    "061E": "ARABIC TRIPLE DOT PUNCTUATION MARK",
    "061F": "ARABIC QUESTION MARK",
    "0620": "ARABIC LETTER KASHMIRI YEH",
    "0621": "ARABIC LETTER HAMZA",
    "0622": "ARABIC LETTER ALEF WITH MADDA ABOVE",
    "0623": "ARABIC LETTER ALEF WITH HAMZA ABOVE",
    "0624": "ARABIC LETTER WAW WITH HAMZA ABOVE",
    "0625": "ARABIC LETTER ALEF WITH HAMZA BELOW",
    "0626": "ARABIC LETTER YEH WITH HAMZA ABOVE",
    "0627": "ARABIC LETTER ALEF",
    "0628": "ARABIC LETTER BEH",
    "0629": "ARABIC LETTER TEH MARBUTA",
    "062A": "ARABIC LETTER TEH",
    "062B": "ARABIC LETTER THEH",
    "062C": "ARABIC LETTER JEEM",
    "062D": "ARABIC LETTER HAH",
    "062E": "ARABIC LETTER KHAH",
    "062F": "ARABIC LETTER DAL",
    "0630": "ARABIC LETTER THAL",
    "0631": "ARABIC LETTER REH",
    "0632": "ARABIC LETTER ZAIN",
    "0633": "ARABIC LETTER SEEN",
    "0634": "ARABIC LETTER SHEEN",
    "0635": "ARABIC LETTER SAD",
    "0636": "ARABIC LETTER DAD",
    "0637": "ARABIC LETTER TAH",
    "0638": "ARABIC LETTER ZAH",
    "0639": "ARABIC LETTER AIN",
    "063A": "ARABIC LETTER GHAIN",
    "063B": "ARABIC LETTER KEHEH WITH TWO DOTS ABOVE",
    "063C": "ARABIC LETTER KEHEH WITH THREE DOTS BELOW",
    "063D": "ARABIC LETTER FARSI YEH WITH INVERTED V",
    "063E": "ARABIC LETTER FARSI YEH WITH TWO DOTS ABOVE",
    "063F": "ARABIC LETTER FARSI YEH WITH THREE DOTS ABOVE",
    "0640": "ARABIC TATWEEL",
    "0641": "ARABIC LETTER FEH",
    "0642": "ARABIC LETTER QAF",
    "0643": "ARABIC LETTER KAF",
    "0644": "ARABIC LETTER LAM",
    "0645": "ARABIC LETTER MEEM",
    "0646": "ARABIC LETTER NOON",
    "0647": "ARABIC LETTER HEH",
    "0648": "ARABIC LETTER WAW",
    "0649": "ARABIC LETTER ALEF MAKSURA",
    "064A": "ARABIC LETTER YEH",
    "064B": "ARABIC FATHATAN",
    "064C": "ARABIC DAMMATAN",
    "064D": "ARABIC KASRATAN",
    "064E": "ARABIC FATHA",
    "064F": "ARABIC DAMMA",
    "0650": "ARABIC KASRA",
    "0651": "ARABIC SHADDA",
    "0652": "ARABIC SUKUN",
    "0653": "ARABIC MADDAH ABOVE",
    "0654": "ARABIC HAMZA ABOVE",
    "0655": "ARABIC HAMZA BELOW",
    "0656": "ARABIC SUBSCRIPT ALEF",
    "0657": "ARABIC INVERTED DAMMA",
    "0658": "ARABIC MARK NOON GHUNNA",
    "0659": "ARABIC ZWARAKAY",
    "065A": "ARABIC VOWEL SIGN SMALL V ABOVE",
    "065B": "ARABIC VOWEL SIGN INVERTED SMALL V ABOVE",
    "065C": "ARABIC VOWEL SIGN DOT BELOW",
    "065D": "ARABIC REVERSED DAMMA",
    "065E": "ARABIC FATHA WITH TWO DOTS",
    "065F": "ARABIC WAVY HAMZA BELOW",
    "0660": "ARABIC-INDIC DIGIT ZERO",
    "0661": "ARABIC-INDIC DIGIT ONE",
    "0662": "ARABIC-INDIC DIGIT TWO",
    "0663": "ARABIC-INDIC DIGIT THREE",
    "0664": "ARABIC-INDIC DIGIT FOUR",
    "0665": "ARABIC-INDIC DIGIT FIVE",
    "0666": "ARABIC-INDIC DIGIT SIX",
    "0667": "ARABIC-INDIC DIGIT SEVEN",
    "0668": "ARABIC-INDIC DIGIT EIGHT",
    "0669": "ARABIC-INDIC DIGIT NINE",
    "066A": "ARABIC PERCENT SIGN",
    "066B": "ARABIC DECIMAL SEPARATOR",
    "066C": "ARABIC THOUSANDS SEPARATOR",
    "066D": "ARABIC FIVE POINTED STAR",
    "066E": "ARABIC LETTER DOTLESS BEH",
    "066F": "ARABIC LETTER DOTLESS QAF",
    "0670": "ARABIC LETTER SUPERSCRIPT ALEF",
    "0671": "ARABIC LETTER ALEF WASLA",
    "0672": "ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE",
    "0673": "ARABIC LETTER ALEF WITH WAVY HAMZA BELOW",
    "0674": "ARABIC LETTER HIGH HAMZA",
    "0675": "ARABIC LETTER HIGH HAMZA ALEF",
    "0676": "ARABIC LETTER HIGH HAMZA WAW",
    "0677": "ARABIC LETTER U WITH HAMZA ABOVE",
    "0678": "ARABIC LETTER HIGH HAMZA YEH",
    "0679": "ARABIC LETTER TTEH",
    "067A": "ARABIC LETTER TTEHEH",
    "067B": "ARABIC LETTER BEEH",
    "067C": "ARABIC LETTER TEH WITH RING",
    "067D": "ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS",
    "067E": "ARABIC LETTER PEH",
    "067F": "ARABIC LETTER TEHEH",
    "0680": "ARABIC LETTER BEHEH",
    "0681": "ARABIC LETTER HAH WITH HAMZA ABOVE",
    "0682": "ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE",
    "0683": "ARABIC LETTER NYEH",
    "0684": "ARABIC LETTER DYEH",
    "0685": "ARABIC LETTER HAH WITH THREE DOTS ABOVE",
    "0686": "ARABIC LETTER TCHEH",
    "0687": "ARABIC LETTER TCHEHEH",
    "0688": "ARABIC LETTER DDAL",
    "0689": "ARABIC LETTER DAL WITH RING",
    "068A": "ARABIC LETTER DAL WITH DOT BELOW",
    "068B": "ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH",
    "068C": "ARABIC LETTER DAHAL",
    "068D": "ARABIC LETTER DDAHAL",
    "068E": "ARABIC LETTER DUL",
    "068F": "ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS",
    "0690": "ARABIC LETTER DAL WITH FOUR DOTS ABOVE",
    "0691": "ARABIC LETTER RREH",
    "0692": "ARABIC LETTER REH WITH SMALL V",
    "0693": "ARABIC LETTER REH WITH RING",
    "0694": "ARABIC LETTER REH WITH DOT BELOW",
    "0695": "ARABIC LETTER REH WITH SMALL V BELOW",
    "0696": "ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE",
    "0697": "ARABIC LETTER REH WITH TWO DOTS ABOVE",
    "0698": "ARABIC LETTER JEH",
    "0699": "ARABIC LETTER REH WITH FOUR DOTS ABOVE",
    "069A": "ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE",
    "069B": "ARABIC LETTER SEEN WITH THREE DOTS BELOW",
    "069C": "ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE",
    "069D": "ARABIC LETTER SAD WITH TWO DOTS BELOW",
    "069E": "ARABIC LETTER SAD WITH THREE DOTS ABOVE",
    "069F": "ARABIC LETTER TAH WITH THREE DOTS ABOVE",
    "06A0": "ARABIC LETTER AIN WITH THREE DOTS ABOVE",
    "06A1": "ARABIC LETTER DOTLESS FEH",
    "06A2": "ARABIC LETTER FEH WITH DOT MOVED BELOW",
    "06A3": "ARABIC LETTER FEH WITH DOT BELOW",
    "06A4": "ARABIC LETTER VEH",
    "06A5": "ARABIC LETTER FEH WITH THREE DOTS BELOW",
    "06A6": "ARABIC LETTER PEHEH",
    "06A7": "ARABIC LETTER QAF WITH DOT ABOVE",
    "06A8": "ARABIC LETTER QAF WITH THREE DOTS ABOVE",
    "06A9": "ARABIC LETTER KEHEH",
    "06AA": "ARABIC LETTER SWASH KAF",
    "06AB": "ARABIC LETTER KAF WITH RING",
    "06AC": "ARABIC LETTER KAF WITH DOT ABOVE",
    "06AD": "ARABIC LETTER NG",
    "06AE": "ARABIC LETTER KAF WITH THREE DOTS BELOW",
    "06AF": "ARABIC LETTER GAF",
    "06B0": "ARABIC LETTER GAF WITH RING",
    "06B1": "ARABIC LETTER NGOEH",
    "06B2": "ARABIC LETTER GAF WITH TWO DOTS BELOW",
    "06B3": "ARABIC LETTER GUEH",
    "06B4": "ARABIC LETTER GAF WITH THREE DOTS ABOVE",
    "06B5": "ARABIC LETTER LAM WITH SMALL V",
    "06B6": "ARABIC LETTER LAM WITH DOT ABOVE",
    "06B7": "ARABIC LETTER LAM WITH THREE DOTS ABOVE",
    "06B8": "ARABIC LETTER LAM WITH THREE DOTS BELOW",
    "06B9": "ARABIC LETTER NOON WITH DOT BELOW",
    "06BA": "ARABIC LETTER NOON GHUNNA",
    "06BB": "ARABIC LETTER RNOON",
    "06BC": "ARABIC LETTER NOON WITH RING",
    "06BD": "ARABIC LETTER NOON WITH THREE DOTS ABOVE",
    "06BE": "ARABIC LETTER HEH DOACHASHMEE",
    "06BF": "ARABIC LETTER TCHEH WITH DOT ABOVE",
    "06C0": "ARABIC LETTER HEH WITH YEH ABOVE",
    "06C1": "ARABIC LETTER HEH GOAL",
    "06C2": "ARABIC LETTER HEH GOAL WITH HAMZA ABOVE",
    "06C3": "ARABIC LETTER TEH MARBUTA GOAL",
    "06C4": "ARABIC LETTER WAW WITH RING",
    "06C5": "ARABIC LETTER KIRGHIZ OE",
    "06C6": "ARABIC LETTER OE",
    "06C7": "ARABIC LETTER U",
    "06C8": "ARABIC LETTER YU",
    "06C9": "ARABIC LETTER KIRGHIZ YU",
    "06CA": "ARABIC LETTER WAW WITH TWO DOTS ABOVE",
    "06CB": "ARABIC LETTER VE",
    "06CC": "ARABIC LETTER FARSI YEH",
    "06CD": "ARABIC LETTER YEH WITH TAIL",
    "06CE": "ARABIC LETTER YEH WITH SMALL V",
    "06CF": "ARABIC LETTER WAW WITH DOT ABOVE",
    "06D0": "ARABIC LETTER E",
    "06D1": "ARABIC LETTER YEH WITH THREE DOTS BELOW",
    "06D2": "ARABIC LETTER YEH BARREE",
    "06D3": "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE",
    "06D4": "ARABIC FULL STOP",
    "06D5": "ARABIC LETTER AE",
    "06D6": "ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA",
    "06D7": "ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA",
    "06D8": "ARABIC SMALL HIGH MEEM INITIAL FORM",
    "06D9": "ARABIC SMALL HIGH LAM ALEF",
    "06DA": "ARABIC SMALL HIGH JEEM",
    "06DB": "ARABIC SMALL HIGH THREE DOTS",
    "06DC": "ARABIC SMALL HIGH SEEN",
    "06DD": "ARABIC END OF AYAH",
    "06DE": "ARABIC START OF RUB EL HIZB",
    "06DF": "ARABIC SMALL HIGH ROUNDED ZERO",
    "06E0": "ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO",
    "06E1": "ARABIC SMALL HIGH DOTLESS HEAD OF KHAH",
    "06E2": "ARABIC SMALL HIGH MEEM ISOLATED FORM",
    "06E3": "ARABIC SMALL LOW SEEN",
    "06E4": "ARABIC SMALL HIGH MADDA",
    "06E5": "ARABIC SMALL WAW",
    "06E6": "ARABIC SMALL YEH",
    "06E7": "ARABIC SMALL HIGH YEH",
    "06E8": "ARABIC SMALL HIGH NOON",
    "06E9": "ARABIC PLACE OF SAJDAH",
    "06EA": "ARABIC EMPTY CENTRE LOW STOP",
    "06EB": "ARABIC EMPTY CENTRE HIGH STOP",
    "06EC": "ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE",
    "06ED": "ARABIC SMALL LOW MEEM",
    "06EE": "ARABIC LETTER DAL WITH INVERTED V",
    "06EF": "ARABIC LETTER REH WITH INVERTED V",
    "06F0": "EXTENDED ARABIC-INDIC DIGIT ZERO",
    "06F1": "EXTENDED ARABIC-INDIC DIGIT ONE",
    "06F2": "EXTENDED ARABIC-INDIC DIGIT TWO",
    "06F3": "EXTENDED ARABIC-INDIC DIGIT THREE",
    "06F4": "EXTENDED ARABIC-INDIC DIGIT FOUR",
    "06F5": "EXTENDED ARABIC-INDIC DIGIT FIVE",
    "06F6": "EXTENDED ARABIC-INDIC DIGIT SIX",
    "06F7": "EXTENDED ARABIC-INDIC DIGIT SEVEN",
    "06F8": "EXTENDED ARABIC-INDIC DIGIT EIGHT",
    "06F9": "EXTENDED ARABIC-INDIC DIGIT NINE",
    "06FA": "ARABIC LETTER SHEEN WITH DOT BELOW",
    "06FB": "ARABIC LETTER DAD WITH DOT BELOW",
    "06FC": "ARABIC LETTER GHAIN WITH DOT BELOW",
    "06FD": "ARABIC SIGN SINDHI AMPERSAND",
    "06FE": "ARABIC SIGN SINDHI POSTPOSITION MEN",
    "06FF": "ARABIC LETTER HEH WITH INVERTED V",
    "0700": "SYRIAC END OF PARAGRAPH",
    "0701": "SYRIAC SUPRALINEAR FULL STOP",
    "0702": "SYRIAC SUBLINEAR FULL STOP",
    "0703": "SYRIAC SUPRALINEAR COLON",
    "0704": "SYRIAC SUBLINEAR COLON",
    "0705": "SYRIAC HORIZONTAL COLON",
    "0706": "SYRIAC COLON SKEWED LEFT",
    "0707": "SYRIAC COLON SKEWED RIGHT",
    "0708": "SYRIAC SUPRALINEAR COLON SKEWED LEFT",
    "0709": "SYRIAC SUBLINEAR COLON SKEWED RIGHT",
    "070A": "SYRIAC CONTRACTION",
    "070B": "SYRIAC HARKLEAN OBELUS",
    "070C": "SYRIAC HARKLEAN METOBELUS",
    "070D": "SYRIAC HARKLEAN ASTERISCUS",
    "070F": "SYRIAC ABBREVIATION MARK",
    "0710": "SYRIAC LETTER ALAPH",
    "0711": "SYRIAC LETTER SUPERSCRIPT ALAPH",
    "0712": "SYRIAC LETTER BETH",
    "0713": "SYRIAC LETTER GAMAL",
    "0714": "SYRIAC LETTER GAMAL GARSHUNI",
    "0715": "SYRIAC LETTER DALATH",
    "0716": "SYRIAC LETTER DOTLESS DALATH RISH",
    "0717": "SYRIAC LETTER HE",
    "0718": "SYRIAC LETTER WAW",
    "0719": "SYRIAC LETTER ZAIN",
    "071A": "SYRIAC LETTER HETH",
    "071B": "SYRIAC LETTER TETH",
    "071C": "SYRIAC LETTER TETH GARSHUNI",
    "071D": "SYRIAC LETTER YUDH",
    "071E": "SYRIAC LETTER YUDH HE",
    "071F": "SYRIAC LETTER KAPH",
    "0720": "SYRIAC LETTER LAMADH",
    "0721": "SYRIAC LETTER MIM",
    "0722": "SYRIAC LETTER NUN",
    "0723": "SYRIAC LETTER SEMKATH",
    "0724": "SYRIAC LETTER FINAL SEMKATH",
    "0725": "SYRIAC LETTER E",
    "0726": "SYRIAC LETTER PE",
    "0727": "SYRIAC LETTER REVERSED PE",
    "0728": "SYRIAC LETTER SADHE",
    "0729": "SYRIAC LETTER QAPH",
    "072A": "SYRIAC LETTER RISH",
    "072B": "SYRIAC LETTER SHIN",
    "072C": "SYRIAC LETTER TAW",
    "072D": "SYRIAC LETTER PERSIAN BHETH",
    "072E": "SYRIAC LETTER PERSIAN GHAMAL",
    "072F": "SYRIAC LETTER PERSIAN DHALATH",
    "0730": "SYRIAC PTHAHA ABOVE",
    "0731": "SYRIAC PTHAHA BELOW",
    "0732": "SYRIAC PTHAHA DOTTED",
    "0733": "SYRIAC ZQAPHA ABOVE",
    "0734": "SYRIAC ZQAPHA BELOW",
    "0735": "SYRIAC ZQAPHA DOTTED",
    "0736": "SYRIAC RBASA ABOVE",
    "0737": "SYRIAC RBASA BELOW",
    "0738": "SYRIAC DOTTED ZLAMA HORIZONTAL",
    "0739": "SYRIAC DOTTED ZLAMA ANGULAR",
    "073A": "SYRIAC HBASA ABOVE",
    "073B": "SYRIAC HBASA BELOW",
    "073C": "SYRIAC HBASA-ESASA DOTTED",
    "073D": "SYRIAC ESASA ABOVE",
    "073E": "SYRIAC ESASA BELOW",
    "073F": "SYRIAC RWAHA",
    "0740": "SYRIAC FEMININE DOT",
    "0741": "SYRIAC QUSHSHAYA",
    "0742": "SYRIAC RUKKAKHA",
    "0743": "SYRIAC TWO VERTICAL DOTS ABOVE",
    "0744": "SYRIAC TWO VERTICAL DOTS BELOW",
    "0745": "SYRIAC THREE DOTS ABOVE",
    "0746": "SYRIAC THREE DOTS BELOW",
    "0747": "SYRIAC OBLIQUE LINE ABOVE",
    "0748": "SYRIAC OBLIQUE LINE BELOW",
    "0749": "SYRIAC MUSIC",
    "074A": "SYRIAC BARREKH",
    "074D": "SYRIAC LETTER SOGDIAN ZHAIN",
    "074E": "SYRIAC LETTER SOGDIAN KHAPH",
    "074F": "SYRIAC LETTER SOGDIAN FE",
    "0750": "ARABIC LETTER BEH WITH THREE DOTS HORIZONTALLY BELOW",
    "0751": "ARABIC LETTER BEH WITH DOT BELOW AND THREE DOTS ABOVE",
    "0752": "ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW",
    "0753": "ARABIC LETTER BEH WITH THREE DOTS POINTING UPWARDS BELOW AND TWO DOTS ABOVE",
    "0754": "ARABIC LETTER BEH WITH TWO DOTS BELOW AND DOT ABOVE",
    "0755": "ARABIC LETTER BEH WITH INVERTED SMALL V BELOW",
    "0756": "ARABIC LETTER BEH WITH SMALL V",
    "0757": "ARABIC LETTER HAH WITH TWO DOTS ABOVE",
    "0758": "ARABIC LETTER HAH WITH THREE DOTS POINTING UPWARDS BELOW",
    "0759": "ARABIC LETTER DAL WITH TWO DOTS VERTICALLY BELOW AND SMALL TAH",
    "075A": "ARABIC LETTER DAL WITH INVERTED SMALL V BELOW",
    "075B": "ARABIC LETTER REH WITH STROKE",
    "075C": "ARABIC LETTER SEEN WITH FOUR DOTS ABOVE",
    "075D": "ARABIC LETTER AIN WITH TWO DOTS ABOVE",
    "075E": "ARABIC LETTER AIN WITH THREE DOTS POINTING DOWNWARDS ABOVE",
    "075F": "ARABIC LETTER AIN WITH TWO DOTS VERTICALLY ABOVE",
    "0760": "ARABIC LETTER FEH WITH TWO DOTS BELOW",
    "0761": "ARABIC LETTER FEH WITH THREE DOTS POINTING UPWARDS BELOW",
    "0762": "ARABIC LETTER KEHEH WITH DOT ABOVE",
    "0763": "ARABIC LETTER KEHEH WITH THREE DOTS ABOVE",
    "0764": "ARABIC LETTER KEHEH WITH THREE DOTS POINTING UPWARDS BELOW",
    "0765": "ARABIC LETTER MEEM WITH DOT ABOVE",
    "0766": "ARABIC LETTER MEEM WITH DOT BELOW",
    "0767": "ARABIC LETTER NOON WITH TWO DOTS BELOW",
    "0768": "ARABIC LETTER NOON WITH SMALL TAH",
    "0769": "ARABIC LETTER NOON WITH SMALL V",
    "076A": "ARABIC LETTER LAM WITH BAR",
    "076B": "ARABIC LETTER REH WITH TWO DOTS VERTICALLY ABOVE",
    "076C": "ARABIC LETTER REH WITH HAMZA ABOVE",
    "076D": "ARABIC LETTER SEEN WITH TWO DOTS VERTICALLY ABOVE",
    "076E": "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH BELOW",
    "076F": "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
    "0770": "ARABIC LETTER SEEN WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
    "0771": "ARABIC LETTER REH WITH SMALL ARABIC LETTER TAH AND TWO DOTS",
    "0772": "ARABIC LETTER HAH WITH SMALL ARABIC LETTER TAH ABOVE",
    "0773": "ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
    "0774": "ARABIC LETTER ALEF WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
    "0775": "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
    "0776": "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
    "0777": "ARABIC LETTER FARSI YEH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW",
    "0778": "ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
    "0779": "ARABIC LETTER WAW WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
    "077A": "ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT TWO ABOVE",
    "077B": "ARABIC LETTER YEH BARREE WITH EXTENDED ARABIC-INDIC DIGIT THREE ABOVE",
    "077C": "ARABIC LETTER HAH WITH EXTENDED ARABIC-INDIC DIGIT FOUR BELOW",
    "077D": "ARABIC LETTER SEEN WITH EXTENDED ARABIC-INDIC DIGIT FOUR ABOVE",
    "077E": "ARABIC LETTER SEEN WITH INVERTED V",
    "077F": "ARABIC LETTER KAF WITH TWO DOTS ABOVE",
    "0780": "THAANA LETTER HAA",
    "0781": "THAANA LETTER SHAVIYANI",
    "0782": "THAANA LETTER NOONU",
    "0783": "THAANA LETTER RAA",
    "0784": "THAANA LETTER BAA",
    "0785": "THAANA LETTER LHAVIYANI",
    "0786": "THAANA LETTER KAAFU",
    "0787": "THAANA LETTER ALIFU",
    "0788": "THAANA LETTER VAAVU",
    "0789": "THAANA LETTER MEEMU",
    "078A": "THAANA LETTER FAAFU",
    "078B": "THAANA LETTER DHAALU",
    "078C": "THAANA LETTER THAA",
    "078D": "THAANA LETTER LAAMU",
    "078E": "THAANA LETTER GAAFU",
    "078F": "THAANA LETTER GNAVIYANI",
    "0790": "THAANA LETTER SEENU",
    "0791": "THAANA LETTER DAVIYANI",
    "0792": "THAANA LETTER ZAVIYANI",
    "0793": "THAANA LETTER TAVIYANI",
    "0794": "THAANA LETTER YAA",
    "0795": "THAANA LETTER PAVIYANI",
    "0796": "THAANA LETTER JAVIYANI",
    "0797": "THAANA LETTER CHAVIYANI",
    "0798": "THAANA LETTER TTAA",
    "0799": "THAANA LETTER HHAA",
    "079A": "THAANA LETTER KHAA",
    "079B": "THAANA LETTER THAALU",
    "079C": "THAANA LETTER ZAA",
    "079D": "THAANA LETTER SHEENU",
    "079E": "THAANA LETTER SAADHU",
    "079F": "THAANA LETTER DAADHU",
    "07A0": "THAANA LETTER TO",
    "07A1": "THAANA LETTER ZO",
    "07A2": "THAANA LETTER AINU",
    "07A3": "THAANA LETTER GHAINU",
    "07A4": "THAANA LETTER QAAFU",
    "07A5": "THAANA LETTER WAAVU",
    "07A6": "THAANA ABAFILI",
    "07A7": "THAANA AABAAFILI",
    "07A8": "THAANA IBIFILI",
    "07A9": "THAANA EEBEEFILI",
    "07AA": "THAANA UBUFILI",
    "07AB": "THAANA OOBOOFILI",
    "07AC": "THAANA EBEFILI",
    "07AD": "THAANA EYBEYFILI",
    "07AE": "THAANA OBOFILI",
    "07AF": "THAANA OABOAFILI",
    "07B0": "THAANA SUKUN",
    "07B1": "THAANA LETTER NAA",
    "07C0": "NKO DIGIT ZERO",
    "07C1": "NKO DIGIT ONE",
    "07C2": "NKO DIGIT TWO",
    "07C3": "NKO DIGIT THREE",
    "07C4": "NKO DIGIT FOUR",
    "07C5": "NKO DIGIT FIVE",
    "07C6": "NKO DIGIT SIX",
    "07C7": "NKO DIGIT SEVEN",
    "07C8": "NKO DIGIT EIGHT",
    "07C9": "NKO DIGIT NINE",
    "07CA": "NKO LETTER A",
    "07CB": "NKO LETTER EE",
    "07CC": "NKO LETTER I",
    "07CD": "NKO LETTER E",
    "07CE": "NKO LETTER U",
    "07CF": "NKO LETTER OO",
    "07D0": "NKO LETTER O",
    "07D1": "NKO LETTER DAGBASINNA",
    "07D2": "NKO LETTER N",
    "07D3": "NKO LETTER BA",
    "07D4": "NKO LETTER PA",
    "07D5": "NKO LETTER TA",
    "07D6": "NKO LETTER JA",
    "07D7": "NKO LETTER CHA",
    "07D8": "NKO LETTER DA",
    "07D9": "NKO LETTER RA",
    "07DA": "NKO LETTER RRA",
    "07DB": "NKO LETTER SA",
    "07DC": "NKO LETTER GBA",
    "07DD": "NKO LETTER FA",
    "07DE": "NKO LETTER KA",
    "07DF": "NKO LETTER LA",
    "07E0": "NKO LETTER NA WOLOSO",
    "07E1": "NKO LETTER MA",
    "07E2": "NKO LETTER NYA",
    "07E3": "NKO LETTER NA",
    "07E4": "NKO LETTER HA",
    "07E5": "NKO LETTER WA",
    "07E6": "NKO LETTER YA",
    "07E7": "NKO LETTER NYA WOLOSO",
    "07E8": "NKO LETTER JONA JA",
    "07E9": "NKO LETTER JONA CHA",
    "07EA": "NKO LETTER JONA RA",
    "07EB": "NKO COMBINING SHORT HIGH TONE",
    "07EC": "NKO COMBINING SHORT LOW TONE",
    "07ED": "NKO COMBINING SHORT RISING TONE",
    "07EE": "NKO COMBINING LONG DESCENDING TONE",
    "07EF": "NKO COMBINING LONG HIGH TONE",
    "07F0": "NKO COMBINING LONG LOW TONE",
    "07F1": "NKO COMBINING LONG RISING TONE",
    "07F2": "NKO COMBINING NASALIZATION MARK",
    "07F3": "NKO COMBINING DOUBLE DOT ABOVE",
    "07F4": "NKO HIGH TONE APOSTROPHE",
    "07F5": "NKO LOW TONE APOSTROPHE",
    "07F6": "NKO SYMBOL OO DENNEN",
    "07F7": "NKO SYMBOL GBAKURUNEN",
    "07F8": "NKO COMMA",
    "07F9": "NKO EXCLAMATION MARK",
    "07FA": "NKO LAJANYALAN",
    "0800": "SAMARITAN LETTER ALAF",
    "0801": "SAMARITAN LETTER BIT",
    "0802": "SAMARITAN LETTER GAMAN",
    "0803": "SAMARITAN LETTER DALAT",
    "0804": "SAMARITAN LETTER IY",
    "0805": "SAMARITAN LETTER BAA",
    "0806": "SAMARITAN LETTER ZEN",
    "0807": "SAMARITAN LETTER IT",
    "0808": "SAMARITAN LETTER TIT",
    "0809": "SAMARITAN LETTER YUT",
    "080A": "SAMARITAN LETTER KAAF",
    "080B": "SAMARITAN LETTER LABAT",
    "080C": "SAMARITAN LETTER MIM",
    "080D": "SAMARITAN LETTER NUN",
    "080E": "SAMARITAN LETTER SINGAAT",
    "080F": "SAMARITAN LETTER IN",
    "0810": "SAMARITAN LETTER FI",
    "0811": "SAMARITAN LETTER TSAADIY",
    "0812": "SAMARITAN LETTER QUF",
    "0813": "SAMARITAN LETTER RISH",
    "0814": "SAMARITAN LETTER SHAN",
    "0815": "SAMARITAN LETTER TAAF",
    "0816": "SAMARITAN MARK IN",
    "0817": "SAMARITAN MARK IN-ALAF",
    "0818": "SAMARITAN MARK OCCLUSION",
    "0819": "SAMARITAN MARK DAGESH",
    "081A": "SAMARITAN MODIFIER LETTER EPENTHETIC YUT",
    "081B": "SAMARITAN MARK EPENTHETIC YUT",
    "081C": "SAMARITAN VOWEL SIGN LONG E",
    "081D": "SAMARITAN VOWEL SIGN E",
    "081E": "SAMARITAN VOWEL SIGN OVERLONG AA",
    "081F": "SAMARITAN VOWEL SIGN LONG AA",
    "0820": "SAMARITAN VOWEL SIGN AA",
    "0821": "SAMARITAN VOWEL SIGN OVERLONG A",
    "0822": "SAMARITAN VOWEL SIGN LONG A",
    "0823": "SAMARITAN VOWEL SIGN A",
    "0824": "SAMARITAN MODIFIER LETTER SHORT A",
    "0825": "SAMARITAN VOWEL SIGN SHORT A",
    "0826": "SAMARITAN VOWEL SIGN LONG U",
    "0827": "SAMARITAN VOWEL SIGN U",
    "0828": "SAMARITAN MODIFIER LETTER I",
    "0829": "SAMARITAN VOWEL SIGN LONG I",
    "082A": "SAMARITAN VOWEL SIGN I",
    "082B": "SAMARITAN VOWEL SIGN O",
    "082C": "SAMARITAN VOWEL SIGN SUKUN",
    "082D": "SAMARITAN MARK NEQUDAA",
    "0830": "SAMARITAN PUNCTUATION NEQUDAA",
    "0831": "SAMARITAN PUNCTUATION AFSAAQ",
    "0832": "SAMARITAN PUNCTUATION ANGED",
    "0833": "SAMARITAN PUNCTUATION BAU",
    "0834": "SAMARITAN PUNCTUATION ATMAAU",
    "0835": "SAMARITAN PUNCTUATION SHIYYAALAA",
    "0836": "SAMARITAN ABBREVIATION MARK",
    "0837": "SAMARITAN PUNCTUATION MELODIC QITSA",
    "0838": "SAMARITAN PUNCTUATION ZIQAA",
    "0839": "SAMARITAN PUNCTUATION QITSA",
    "083A": "SAMARITAN PUNCTUATION ZAEF",
    "083B": "SAMARITAN PUNCTUATION TURU",
    "083C": "SAMARITAN PUNCTUATION ARKAANU",
    "083D": "SAMARITAN PUNCTUATION SOF MASHFAAT",
    "083E": "SAMARITAN PUNCTUATION ANNAAU",
    "0840": "MANDAIC LETTER HALQA",
    "0841": "MANDAIC LETTER AB",
    "0842": "MANDAIC LETTER AG",
    "0843": "MANDAIC LETTER AD",
    "0844": "MANDAIC LETTER AH",
    "0845": "MANDAIC LETTER USHENNA",
    "0846": "MANDAIC LETTER AZ",
    "0847": "MANDAIC LETTER IT",
    "0848": "MANDAIC LETTER ATT",
    "0849": "MANDAIC LETTER AKSA",
    "084A": "MANDAIC LETTER AK",
    "084B": "MANDAIC LETTER AL",
    "084C": "MANDAIC LETTER AM",
    "084D": "MANDAIC LETTER AN",
    "084E": "MANDAIC LETTER AS",
    "084F": "MANDAIC LETTER IN",
    "0850": "MANDAIC LETTER AP",
    "0851": "MANDAIC LETTER ASZ",
    "0852": "MANDAIC LETTER AQ",
    "0853": "MANDAIC LETTER AR",
    "0854": "MANDAIC LETTER ASH",
    "0855": "MANDAIC LETTER AT",
    "0856": "MANDAIC LETTER DUSHENNA",
    "0857": "MANDAIC LETTER KAD",
    "0858": "MANDAIC LETTER AIN",
    "0859": "MANDAIC AFFRICATION MARK",
    "085A": "MANDAIC VOCALIZATION MARK",
    "085B": "MANDAIC GEMINATION MARK",
    "085E": "MANDAIC PUNCTUATION",
    "08A0": "ARABIC LETTER BEH WITH SMALL V BELOW",
    "08A1": "ARABIC LETTER BEH WITH HAMZA ABOVE",
    "08A2": "ARABIC LETTER JEEM WITH TWO DOTS ABOVE",
    "08A3": "ARABIC LETTER TAH WITH TWO DOTS ABOVE",
    "08A4": "ARABIC LETTER FEH WITH DOT BELOW AND THREE DOTS ABOVE",
    "08A5": "ARABIC LETTER QAF WITH DOT BELOW",
    "08A6": "ARABIC LETTER LAM WITH DOUBLE BAR",
    "08A7": "ARABIC LETTER MEEM WITH THREE DOTS ABOVE",
    "08A8": "ARABIC LETTER YEH WITH TWO DOTS BELOW AND HAMZA ABOVE",
    "08A9": "ARABIC LETTER YEH WITH TWO DOTS BELOW AND DOT ABOVE",
    "08AA": "ARABIC LETTER REH WITH LOOP",
    "08AB": "ARABIC LETTER WAW WITH DOT WITHIN",
    "08AC": "ARABIC LETTER ROHINGYA YEH",
    "08AD": "ARABIC LETTER LOW ALEF",
    "08AE": "ARABIC LETTER DAL WITH THREE DOTS BELOW",
    "08AF": "ARABIC LETTER SAD WITH THREE DOTS BELOW",
    "08B0": "ARABIC LETTER GAF WITH INVERTED STROKE",
    "08B1": "ARABIC LETTER STRAIGHT WAW",
    "08B2": "ARABIC LETTER ZAIN WITH INVERTED V ABOVE",
    "08B3": "ARABIC LETTER AIN WITH THREE DOTS BELOW",
    "08B4": "ARABIC LETTER KAF WITH DOT BELOW",
    "08B6": "ARABIC LETTER BEH WITH SMALL MEEM ABOVE",
    "08B7": "ARABIC LETTER PEH WITH SMALL MEEM ABOVE",
    "08B8": "ARABIC LETTER TEH WITH SMALL TEH ABOVE",
    "08B9": "ARABIC LETTER REH WITH SMALL NOON ABOVE",
    "08BA": "ARABIC LETTER YEH WITH TWO DOTS BELOW AND SMALL NOON ABOVE",
    "08BB": "ARABIC LETTER AFRICAN FEH",
    "08BC": "ARABIC LETTER AFRICAN QAF",
    "08BD": "ARABIC LETTER AFRICAN NOON",
    "08D4": "ARABIC SMALL HIGH WORD AR-RUB",
    "08D5": "ARABIC SMALL HIGH SAD",
    "08D6": "ARABIC SMALL HIGH AIN",
    "08D7": "ARABIC SMALL HIGH QAF",
    "08D8": "ARABIC SMALL HIGH NOON WITH KASRA",
    "08D9": "ARABIC SMALL LOW NOON WITH KASRA",
    "08DA": "ARABIC SMALL HIGH WORD ATH-THALATHA",
    "08DB": "ARABIC SMALL HIGH WORD AS-SAJDA",
    "08DC": "ARABIC SMALL HIGH WORD AN-NISF",
    "08DD": "ARABIC SMALL HIGH WORD SAKTA",
    "08DE": "ARABIC SMALL HIGH WORD QIF",
    "08DF": "ARABIC SMALL HIGH WORD WAQFA",
    "08E0": "ARABIC SMALL HIGH FOOTNOTE MARKER",
    "08E1": "ARABIC SMALL HIGH SIGN SAFHA",
    "08E2": "ARABIC DISPUTED END OF AYAH",
    "08E3": "ARABIC TURNED DAMMA BELOW",
    "08E4": "ARABIC CURLY FATHA",
    "08E5": "ARABIC CURLY DAMMA",
    "08E6": "ARABIC CURLY KASRA",
    "08E7": "ARABIC CURLY FATHATAN",
    "08E8": "ARABIC CURLY DAMMATAN",
    "08E9": "ARABIC CURLY KASRATAN",
    "08EA": "ARABIC TONE ONE DOT ABOVE",
    "08EB": "ARABIC TONE TWO DOTS ABOVE",
    "08EC": "ARABIC TONE LOOP ABOVE",
    "08ED": "ARABIC TONE ONE DOT BELOW",
    "08EE": "ARABIC TONE TWO DOTS BELOW",
    "08EF": "ARABIC TONE LOOP BELOW",
    "08F0": "ARABIC OPEN FATHATAN",
    "08F1": "ARABIC OPEN DAMMATAN",
    "08F2": "ARABIC OPEN KASRATAN",
    "08F3": "ARABIC SMALL HIGH WAW",
    "08F4": "ARABIC FATHA WITH RING",
    "08F5": "ARABIC FATHA WITH DOT ABOVE",
    "08F6": "ARABIC KASRA WITH DOT BELOW",
    "08F7": "ARABIC LEFT ARROWHEAD ABOVE",
    "08F8": "ARABIC RIGHT ARROWHEAD ABOVE",
    "08F9": "ARABIC LEFT ARROWHEAD BELOW",
    "08FA": "ARABIC RIGHT ARROWHEAD BELOW",
    "08FB": "ARABIC DOUBLE RIGHT ARROWHEAD ABOVE",
    "08FC": "ARABIC DOUBLE RIGHT ARROWHEAD ABOVE WITH DOT",
    "08FD": "ARABIC RIGHT ARROWHEAD ABOVE WITH DOT",
    "08FE": "ARABIC DAMMA WITH DOT",
    "08FF": "ARABIC MARK SIDEWAYS NOON GHUNNA",
    "0900": "DEVANAGARI SIGN INVERTED CANDRABINDU",
    "0901": "DEVANAGARI SIGN CANDRABINDU",
    "0902": "DEVANAGARI SIGN ANUSVARA",
    "0903": "DEVANAGARI SIGN VISARGA",
    "0904": "DEVANAGARI LETTER SHORT A",
    "0905": "DEVANAGARI LETTER A",
    "0906": "DEVANAGARI LETTER AA",
    "0907": "DEVANAGARI LETTER I",
    "0908": "DEVANAGARI LETTER II",
    "0909": "DEVANAGARI LETTER U",
    "090A": "DEVANAGARI LETTER UU",
    "090B": "DEVANAGARI LETTER VOCALIC R",
    "090C": "DEVANAGARI LETTER VOCALIC L",
    "090D": "DEVANAGARI LETTER CANDRA E",
    "090E": "DEVANAGARI LETTER SHORT E",
    "090F": "DEVANAGARI LETTER E",
    "0910": "DEVANAGARI LETTER AI",
    "0911": "DEVANAGARI LETTER CANDRA O",
    "0912": "DEVANAGARI LETTER SHORT O",
    "0913": "DEVANAGARI LETTER O",
    "0914": "DEVANAGARI LETTER AU",
    "0915": "DEVANAGARI LETTER KA",
    "0916": "DEVANAGARI LETTER KHA",
    "0917": "DEVANAGARI LETTER GA",
    "0918": "DEVANAGARI LETTER GHA",
    "0919": "DEVANAGARI LETTER NGA",
    "091A": "DEVANAGARI LETTER CA",
    "091B": "DEVANAGARI LETTER CHA",
    "091C": "DEVANAGARI LETTER JA",
    "091D": "DEVANAGARI LETTER JHA",
    "091E": "DEVANAGARI LETTER NYA",
    "091F": "DEVANAGARI LETTER TTA",
    "0920": "DEVANAGARI LETTER TTHA",
    "0921": "DEVANAGARI LETTER DDA",
    "0922": "DEVANAGARI LETTER DDHA",
    "0923": "DEVANAGARI LETTER NNA",
    "0924": "DEVANAGARI LETTER TA",
    "0925": "DEVANAGARI LETTER THA",
    "0926": "DEVANAGARI LETTER DA",
    "0927": "DEVANAGARI LETTER DHA",
    "0928": "DEVANAGARI LETTER NA",
    "0929": "DEVANAGARI LETTER NNNA",
    "092A": "DEVANAGARI LETTER PA",
    "092B": "DEVANAGARI LETTER PHA",
    "092C": "DEVANAGARI LETTER BA",
    "092D": "DEVANAGARI LETTER BHA",
    "092E": "DEVANAGARI LETTER MA",
    "092F": "DEVANAGARI LETTER YA",
    "0930": "DEVANAGARI LETTER RA",
    "0931": "DEVANAGARI LETTER RRA",
    "0932": "DEVANAGARI LETTER LA",
    "0933": "DEVANAGARI LETTER LLA",
    "0934": "DEVANAGARI LETTER LLLA",
    "0935": "DEVANAGARI LETTER VA",
    "0936": "DEVANAGARI LETTER SHA",
    "0937": "DEVANAGARI LETTER SSA",
    "0938": "DEVANAGARI LETTER SA",
    "0939": "DEVANAGARI LETTER HA",
    "093A": "DEVANAGARI VOWEL SIGN OE",
    "093B": "DEVANAGARI VOWEL SIGN OOE",
    "093C": "DEVANAGARI SIGN NUKTA",
    "093D": "DEVANAGARI SIGN AVAGRAHA",
    "093E": "DEVANAGARI VOWEL SIGN AA",
    "093F": "DEVANAGARI VOWEL SIGN I",
    "0940": "DEVANAGARI VOWEL SIGN II",
    "0941": "DEVANAGARI VOWEL SIGN U",
    "0942": "DEVANAGARI VOWEL SIGN UU",
    "0943": "DEVANAGARI VOWEL SIGN VOCALIC R",
    "0944": "DEVANAGARI VOWEL SIGN VOCALIC RR",
    "0945": "DEVANAGARI VOWEL SIGN CANDRA E",
    "0946": "DEVANAGARI VOWEL SIGN SHORT E",
    "0947": "DEVANAGARI VOWEL SIGN E",
    "0948": "DEVANAGARI VOWEL SIGN AI",
    "0949": "DEVANAGARI VOWEL SIGN CANDRA O",
    "094A": "DEVANAGARI VOWEL SIGN SHORT O",
    "094B": "DEVANAGARI VOWEL SIGN O",
    "094C": "DEVANAGARI VOWEL SIGN AU",
    "094D": "DEVANAGARI SIGN VIRAMA",
    "094E": "DEVANAGARI VOWEL SIGN PRISHTHAMATRA E",
    "094F": "DEVANAGARI VOWEL SIGN AW",
    "0950": "DEVANAGARI OM",
    "0951": "DEVANAGARI STRESS SIGN UDATTA",
    "0952": "DEVANAGARI STRESS SIGN ANUDATTA",
    "0953": "DEVANAGARI GRAVE ACCENT",
    "0954": "DEVANAGARI ACUTE ACCENT",
    "0955": "DEVANAGARI VOWEL SIGN CANDRA LONG E",
    "0956": "DEVANAGARI VOWEL SIGN UE",
    "0957": "DEVANAGARI VOWEL SIGN UUE",
    "0958": "DEVANAGARI LETTER QA",
    "0959": "DEVANAGARI LETTER KHHA",
    "095A": "DEVANAGARI LETTER GHHA",
    "095B": "DEVANAGARI LETTER ZA",
    "095C": "DEVANAGARI LETTER DDDHA",
    "095D": "DEVANAGARI LETTER RHA",
    "095E": "DEVANAGARI LETTER FA",
    "095F": "DEVANAGARI LETTER YYA",
    "0960": "DEVANAGARI LETTER VOCALIC RR",
    "0961": "DEVANAGARI LETTER VOCALIC LL",
    "0962": "DEVANAGARI VOWEL SIGN VOCALIC L",
    "0963": "DEVANAGARI VOWEL SIGN VOCALIC LL",
    "0964": "DEVANAGARI DANDA",
    "0965": "DEVANAGARI DOUBLE DANDA",
    "0966": "DEVANAGARI DIGIT ZERO",
    "0967": "DEVANAGARI DIGIT ONE",
    "0968": "DEVANAGARI DIGIT TWO",
    "0969": "DEVANAGARI DIGIT THREE",
    "096A": "DEVANAGARI DIGIT FOUR",
    "096B": "DEVANAGARI DIGIT FIVE",
    "096C": "DEVANAGARI DIGIT SIX",
    "096D": "DEVANAGARI DIGIT SEVEN",
    "096E": "DEVANAGARI DIGIT EIGHT",
    "096F": "DEVANAGARI DIGIT NINE",
    "0970": "DEVANAGARI ABBREVIATION SIGN",
    "0971": "DEVANAGARI SIGN HIGH SPACING DOT",
    "0972": "DEVANAGARI LETTER CANDRA A",
    "0973": "DEVANAGARI LETTER OE",
    "0974": "DEVANAGARI LETTER OOE",
    "0975": "DEVANAGARI LETTER AW",
    "0976": "DEVANAGARI LETTER UE",
    "0977": "DEVANAGARI LETTER UUE",
    "0978": "DEVANAGARI LETTER MARWARI DDA",
    "0979": "DEVANAGARI LETTER ZHA",
    "097A": "DEVANAGARI LETTER HEAVY YA",
    "097B": "DEVANAGARI LETTER GGA",
    "097C": "DEVANAGARI LETTER JJA",
    "097D": "DEVANAGARI LETTER GLOTTAL STOP",
    "097E": "DEVANAGARI LETTER DDDA",
    "097F": "DEVANAGARI LETTER BBA",
    "0980": "BENGALI ANJI",
    "0981": "BENGALI SIGN CANDRABINDU",
    "0982": "BENGALI SIGN ANUSVARA",
    "0983": "BENGALI SIGN VISARGA",
    "0985": "BENGALI LETTER A",
    "0986": "BENGALI LETTER AA",
    "0987": "BENGALI LETTER I",
    "0988": "BENGALI LETTER II",
    "0989": "BENGALI LETTER U",
    "098A": "BENGALI LETTER UU",
    "098B": "BENGALI LETTER VOCALIC R",
    "098C": "BENGALI LETTER VOCALIC L",
    "098F": "BENGALI LETTER E",
    "0990": "BENGALI LETTER AI",
    "0993": "BENGALI LETTER O",
    "0994": "BENGALI LETTER AU",
    "0995": "BENGALI LETTER KA",
    "0996": "BENGALI LETTER KHA",
    "0997": "BENGALI LETTER GA",
    "0998": "BENGALI LETTER GHA",
    "0999": "BENGALI LETTER NGA",
    "099A": "BENGALI LETTER CA",
    "099B": "BENGALI LETTER CHA",
    "099C": "BENGALI LETTER JA",
    "099D": "BENGALI LETTER JHA",
    "099E": "BENGALI LETTER NYA",
    "099F": "BENGALI LETTER TTA",
    "09A0": "BENGALI LETTER TTHA",
    "09A1": "BENGALI LETTER DDA",
    "09A2": "BENGALI LETTER DDHA",
    "09A3": "BENGALI LETTER NNA",
    "09A4": "BENGALI LETTER TA",
    "09A5": "BENGALI LETTER THA",
    "09A6": "BENGALI LETTER DA",
    "09A7": "BENGALI LETTER DHA",
    "09A8": "BENGALI LETTER NA",
    "09AA": "BENGALI LETTER PA",
    "09AB": "BENGALI LETTER PHA",
    "09AC": "BENGALI LETTER BA",
    "09AD": "BENGALI LETTER BHA",
    "09AE": "BENGALI LETTER MA",
    "09AF": "BENGALI LETTER YA",
    "09B0": "BENGALI LETTER RA",
    "09B2": "BENGALI LETTER LA",
    "09B6": "BENGALI LETTER SHA",
    "09B7": "BENGALI LETTER SSA",
    "09B8": "BENGALI LETTER SA",
    "09B9": "BENGALI LETTER HA",
    "09BC": "BENGALI SIGN NUKTA",
    "09BD": "BENGALI SIGN AVAGRAHA",
    "09BE": "BENGALI VOWEL SIGN AA",
    "09BF": "BENGALI VOWEL SIGN I",
    "09C0": "BENGALI VOWEL SIGN II",
    "09C1": "BENGALI VOWEL SIGN U",
    "09C2": "BENGALI VOWEL SIGN UU",
    "09C3": "BENGALI VOWEL SIGN VOCALIC R",
    "09C4": "BENGALI VOWEL SIGN VOCALIC RR",
    "09C7": "BENGALI VOWEL SIGN E",
    "09C8": "BENGALI VOWEL SIGN AI",
    "09CB": "BENGALI VOWEL SIGN O",
    "09CC": "BENGALI VOWEL SIGN AU",
    "09CD": "BENGALI SIGN VIRAMA",
    "09CE": "BENGALI LETTER KHANDA TA",
    "09D7": "BENGALI AU LENGTH MARK",
    "09DC": "BENGALI LETTER RRA",
    "09DD": "BENGALI LETTER RHA",
    "09DF": "BENGALI LETTER YYA",
    "09E0": "BENGALI LETTER VOCALIC RR",
    "09E1": "BENGALI LETTER VOCALIC LL",
    "09E2": "BENGALI VOWEL SIGN VOCALIC L",
    "09E3": "BENGALI VOWEL SIGN VOCALIC LL",
    "09E6": "BENGALI DIGIT ZERO",
    "09E7": "BENGALI DIGIT ONE",
    "09E8": "BENGALI DIGIT TWO",
    "09E9": "BENGALI DIGIT THREE",
    "09EA": "BENGALI DIGIT FOUR",
    "09EB": "BENGALI DIGIT FIVE",
    "09EC": "BENGALI DIGIT SIX",
    "09ED": "BENGALI DIGIT SEVEN",
    "09EE": "BENGALI DIGIT EIGHT",
    "09EF": "BENGALI DIGIT NINE",
    "09F0": "BENGALI LETTER RA WITH MIDDLE DIAGONAL",
    "09F1": "BENGALI LETTER RA WITH LOWER DIAGONAL",
    "09F2": "BENGALI RUPEE MARK",
    "09F3": "BENGALI RUPEE SIGN",
    "09F4": "BENGALI CURRENCY NUMERATOR ONE",
    "09F5": "BENGALI CURRENCY NUMERATOR TWO",
    "09F6": "BENGALI CURRENCY NUMERATOR THREE",
    "09F7": "BENGALI CURRENCY NUMERATOR FOUR",
    "09F8": "BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR",
    "09F9": "BENGALI CURRENCY DENOMINATOR SIXTEEN",
    "09FA": "BENGALI ISSHAR",
    "09FB": "BENGALI GANDA MARK",
    "0A01": "GURMUKHI SIGN ADAK BINDI",
    "0A02": "GURMUKHI SIGN BINDI",
    "0A03": "GURMUKHI SIGN VISARGA",
    "0A05": "GURMUKHI LETTER A",
    "0A06": "GURMUKHI LETTER AA",
    "0A07": "GURMUKHI LETTER I",
    "0A08": "GURMUKHI LETTER II",
    "0A09": "GURMUKHI LETTER U",
    "0A0A": "GURMUKHI LETTER UU",
    "0A0F": "GURMUKHI LETTER EE",
    "0A10": "GURMUKHI LETTER AI",
    "0A13": "GURMUKHI LETTER OO",
    "0A14": "GURMUKHI LETTER AU",
    "0A15": "GURMUKHI LETTER KA",
    "0A16": "GURMUKHI LETTER KHA",
    "0A17": "GURMUKHI LETTER GA",
    "0A18": "GURMUKHI LETTER GHA",
    "0A19": "GURMUKHI LETTER NGA",
    "0A1A": "GURMUKHI LETTER CA",
    "0A1B": "GURMUKHI LETTER CHA",
    "0A1C": "GURMUKHI LETTER JA",
    "0A1D": "GURMUKHI LETTER JHA",
    "0A1E": "GURMUKHI LETTER NYA",
    "0A1F": "GURMUKHI LETTER TTA",
    "0A20": "GURMUKHI LETTER TTHA",
    "0A21": "GURMUKHI LETTER DDA",
    "0A22": "GURMUKHI LETTER DDHA",
    "0A23": "GURMUKHI LETTER NNA",
    "0A24": "GURMUKHI LETTER TA",
    "0A25": "GURMUKHI LETTER THA",
    "0A26": "GURMUKHI LETTER DA",
    "0A27": "GURMUKHI LETTER DHA",
    "0A28": "GURMUKHI LETTER NA",
    "0A2A": "GURMUKHI LETTER PA",
    "0A2B": "GURMUKHI LETTER PHA",
    "0A2C": "GURMUKHI LETTER BA",
    "0A2D": "GURMUKHI LETTER BHA",
    "0A2E": "GURMUKHI LETTER MA",
    "0A2F": "GURMUKHI LETTER YA",
    "0A30": "GURMUKHI LETTER RA",
    "0A32": "GURMUKHI LETTER LA",
    "0A33": "GURMUKHI LETTER LLA",
    "0A35": "GURMUKHI LETTER VA",
    "0A36": "GURMUKHI LETTER SHA",
    "0A38": "GURMUKHI LETTER SA",
    "0A39": "GURMUKHI LETTER HA",
    "0A3C": "GURMUKHI SIGN NUKTA",
    "0A3E": "GURMUKHI VOWEL SIGN AA",
    "0A3F": "GURMUKHI VOWEL SIGN I",
    "0A40": "GURMUKHI VOWEL SIGN II",
    "0A41": "GURMUKHI VOWEL SIGN U",
    "0A42": "GURMUKHI VOWEL SIGN UU",
    "0A47": "GURMUKHI VOWEL SIGN EE",
    "0A48": "GURMUKHI VOWEL SIGN AI",
    "0A4B": "GURMUKHI VOWEL SIGN OO",
    "0A4C": "GURMUKHI VOWEL SIGN AU",
    "0A4D": "GURMUKHI SIGN VIRAMA",
    "0A51": "GURMUKHI SIGN UDAAT",
    "0A59": "GURMUKHI LETTER KHHA",
    "0A5A": "GURMUKHI LETTER GHHA",
    "0A5B": "GURMUKHI LETTER ZA",
    "0A5C": "GURMUKHI LETTER RRA",
    "0A5E": "GURMUKHI LETTER FA",
    "0A66": "GURMUKHI DIGIT ZERO",
    "0A67": "GURMUKHI DIGIT ONE",
    "0A68": "GURMUKHI DIGIT TWO",
    "0A69": "GURMUKHI DIGIT THREE",
    "0A6A": "GURMUKHI DIGIT FOUR",
    "0A6B": "GURMUKHI DIGIT FIVE",
    "0A6C": "GURMUKHI DIGIT SIX",
    "0A6D": "GURMUKHI DIGIT SEVEN",
    "0A6E": "GURMUKHI DIGIT EIGHT",
    "0A6F": "GURMUKHI DIGIT NINE",
    "0A70": "GURMUKHI TIPPI",
    "0A71": "GURMUKHI ADDAK",
    "0A72": "GURMUKHI IRI",
    "0A73": "GURMUKHI URA",
    "0A74": "GURMUKHI EK ONKAR",
    "0A75": "GURMUKHI SIGN YAKASH",
    "0A81": "GUJARATI SIGN CANDRABINDU",
    "0A82": "GUJARATI SIGN ANUSVARA",
    "0A83": "GUJARATI SIGN VISARGA",
    "0A85": "GUJARATI LETTER A",
    "0A86": "GUJARATI LETTER AA",
    "0A87": "GUJARATI LETTER I",
    "0A88": "GUJARATI LETTER II",
    "0A89": "GUJARATI LETTER U",
    "0A8A": "GUJARATI LETTER UU",
    "0A8B": "GUJARATI LETTER VOCALIC R",
    "0A8C": "GUJARATI LETTER VOCALIC L",
    "0A8D": "GUJARATI VOWEL CANDRA E",
    "0A8F": "GUJARATI LETTER E",
    "0A90": "GUJARATI LETTER AI",
    "0A91": "GUJARATI VOWEL CANDRA O",
    "0A93": "GUJARATI LETTER O",
    "0A94": "GUJARATI LETTER AU",
    "0A95": "GUJARATI LETTER KA",
    "0A96": "GUJARATI LETTER KHA",
    "0A97": "GUJARATI LETTER GA",
    "0A98": "GUJARATI LETTER GHA",
    "0A99": "GUJARATI LETTER NGA",
    "0A9A": "GUJARATI LETTER CA",
    "0A9B": "GUJARATI LETTER CHA",
    "0A9C": "GUJARATI LETTER JA",
    "0A9D": "GUJARATI LETTER JHA",
    "0A9E": "GUJARATI LETTER NYA",
    "0A9F": "GUJARATI LETTER TTA",
    "0AA0": "GUJARATI LETTER TTHA",
    "0AA1": "GUJARATI LETTER DDA",
    "0AA2": "GUJARATI LETTER DDHA",
    "0AA3": "GUJARATI LETTER NNA",
    "0AA4": "GUJARATI LETTER TA",
    "0AA5": "GUJARATI LETTER THA",
    "0AA6": "GUJARATI LETTER DA",
    "0AA7": "GUJARATI LETTER DHA",
    "0AA8": "GUJARATI LETTER NA",
    "0AAA": "GUJARATI LETTER PA",
    "0AAB": "GUJARATI LETTER PHA",
    "0AAC": "GUJARATI LETTER BA",
    "0AAD": "GUJARATI LETTER BHA",
    "0AAE": "GUJARATI LETTER MA",
    "0AAF": "GUJARATI LETTER YA",
    "0AB0": "GUJARATI LETTER RA",
    "0AB2": "GUJARATI LETTER LA",
    "0AB3": "GUJARATI LETTER LLA",
    "0AB5": "GUJARATI LETTER VA",
    "0AB6": "GUJARATI LETTER SHA",
    "0AB7": "GUJARATI LETTER SSA",
    "0AB8": "GUJARATI LETTER SA",
    "0AB9": "GUJARATI LETTER HA",
    "0ABC": "GUJARATI SIGN NUKTA",
    "0ABD": "GUJARATI SIGN AVAGRAHA",
    "0ABE": "GUJARATI VOWEL SIGN AA",
    "0ABF": "GUJARATI VOWEL SIGN I",
    "0AC0": "GUJARATI VOWEL SIGN II",
    "0AC1": "GUJARATI VOWEL SIGN U",
    "0AC2": "GUJARATI VOWEL SIGN UU",
    "0AC3": "GUJARATI VOWEL SIGN VOCALIC R",
    "0AC4": "GUJARATI VOWEL SIGN VOCALIC RR",
    "0AC5": "GUJARATI VOWEL SIGN CANDRA E",
    "0AC7": "GUJARATI VOWEL SIGN E",
    "0AC8": "GUJARATI VOWEL SIGN AI",
    "0AC9": "GUJARATI VOWEL SIGN CANDRA O",
    "0ACB": "GUJARATI VOWEL SIGN O",
    "0ACC": "GUJARATI VOWEL SIGN AU",
    "0ACD": "GUJARATI SIGN VIRAMA",
    "0AD0": "GUJARATI OM",
    "0AE0": "GUJARATI LETTER VOCALIC RR",
    "0AE1": "GUJARATI LETTER VOCALIC LL",
    "0AE2": "GUJARATI VOWEL SIGN VOCALIC L",
    "0AE3": "GUJARATI VOWEL SIGN VOCALIC LL",
    "0AE6": "GUJARATI DIGIT ZERO",
    "0AE7": "GUJARATI DIGIT ONE",
    "0AE8": "GUJARATI DIGIT TWO",
    "0AE9": "GUJARATI DIGIT THREE",
    "0AEA": "GUJARATI DIGIT FOUR",
    "0AEB": "GUJARATI DIGIT FIVE",
    "0AEC": "GUJARATI DIGIT SIX",
    "0AED": "GUJARATI DIGIT SEVEN",
    "0AEE": "GUJARATI DIGIT EIGHT",
    "0AEF": "GUJARATI DIGIT NINE",
    "0AF0": "GUJARATI ABBREVIATION SIGN",
    "0AF1": "GUJARATI RUPEE SIGN",
    "0AF9": "GUJARATI LETTER ZHA",
    "0B01": "ORIYA SIGN CANDRABINDU",
    "0B02": "ORIYA SIGN ANUSVARA",
    "0B03": "ORIYA SIGN VISARGA",
    "0B05": "ORIYA LETTER A",
    "0B06": "ORIYA LETTER AA",
    "0B07": "ORIYA LETTER I",
    "0B08": "ORIYA LETTER II",
    "0B09": "ORIYA LETTER U",
    "0B0A": "ORIYA LETTER UU",
    "0B0B": "ORIYA LETTER VOCALIC R",
    "0B0C": "ORIYA LETTER VOCALIC L",
    "0B0F": "ORIYA LETTER E",
    "0B10": "ORIYA LETTER AI",
    "0B13": "ORIYA LETTER O",
    "0B14": "ORIYA LETTER AU",
    "0B15": "ORIYA LETTER KA",
    "0B16": "ORIYA LETTER KHA",
    "0B17": "ORIYA LETTER GA",
    "0B18": "ORIYA LETTER GHA",
    "0B19": "ORIYA LETTER NGA",
    "0B1A": "ORIYA LETTER CA",
    "0B1B": "ORIYA LETTER CHA",
    "0B1C": "ORIYA LETTER JA",
    "0B1D": "ORIYA LETTER JHA",
    "0B1E": "ORIYA LETTER NYA",
    "0B1F": "ORIYA LETTER TTA",
    "0B20": "ORIYA LETTER TTHA",
    "0B21": "ORIYA LETTER DDA",
    "0B22": "ORIYA LETTER DDHA",
    "0B23": "ORIYA LETTER NNA",
    "0B24": "ORIYA LETTER TA",
    "0B25": "ORIYA LETTER THA",
    "0B26": "ORIYA LETTER DA",
    "0B27": "ORIYA LETTER DHA",
    "0B28": "ORIYA LETTER NA",
    "0B2A": "ORIYA LETTER PA",
    "0B2B": "ORIYA LETTER PHA",
    "0B2C": "ORIYA LETTER BA",
    "0B2D": "ORIYA LETTER BHA",
    "0B2E": "ORIYA LETTER MA",
    "0B2F": "ORIYA LETTER YA",
    "0B30": "ORIYA LETTER RA",
    "0B32": "ORIYA LETTER LA",
    "0B33": "ORIYA LETTER LLA",
    "0B35": "ORIYA LETTER VA",
    "0B36": "ORIYA LETTER SHA",
    "0B37": "ORIYA LETTER SSA",
    "0B38": "ORIYA LETTER SA",
    "0B39": "ORIYA LETTER HA",
    "0B3C": "ORIYA SIGN NUKTA",
    "0B3D": "ORIYA SIGN AVAGRAHA",
    "0B3E": "ORIYA VOWEL SIGN AA",
    "0B3F": "ORIYA VOWEL SIGN I",
    "0B40": "ORIYA VOWEL SIGN II",
    "0B41": "ORIYA VOWEL SIGN U",
    "0B42": "ORIYA VOWEL SIGN UU",
    "0B43": "ORIYA VOWEL SIGN VOCALIC R",
    "0B44": "ORIYA VOWEL SIGN VOCALIC RR",
    "0B47": "ORIYA VOWEL SIGN E",
    "0B48": "ORIYA VOWEL SIGN AI",
    "0B4B": "ORIYA VOWEL SIGN O",
    "0B4C": "ORIYA VOWEL SIGN AU",
    "0B4D": "ORIYA SIGN VIRAMA",
    "0B56": "ORIYA AI LENGTH MARK",
    "0B57": "ORIYA AU LENGTH MARK",
    "0B5C": "ORIYA LETTER RRA",
    "0B5D": "ORIYA LETTER RHA",
    "0B5F": "ORIYA LETTER YYA",
    "0B60": "ORIYA LETTER VOCALIC RR",
    "0B61": "ORIYA LETTER VOCALIC LL",
    "0B62": "ORIYA VOWEL SIGN VOCALIC L",
    "0B63": "ORIYA VOWEL SIGN VOCALIC LL",
    "0B66": "ORIYA DIGIT ZERO",
    "0B67": "ORIYA DIGIT ONE",
    "0B68": "ORIYA DIGIT TWO",
    "0B69": "ORIYA DIGIT THREE",
    "0B6A": "ORIYA DIGIT FOUR",
    "0B6B": "ORIYA DIGIT FIVE",
    "0B6C": "ORIYA DIGIT SIX",
    "0B6D": "ORIYA DIGIT SEVEN",
    "0B6E": "ORIYA DIGIT EIGHT",
    "0B6F": "ORIYA DIGIT NINE",
    "0B70": "ORIYA ISSHAR",
    "0B71": "ORIYA LETTER WA",
    "0B72": "ORIYA FRACTION ONE QUARTER",
    "0B73": "ORIYA FRACTION ONE HALF",
    "0B74": "ORIYA FRACTION THREE QUARTERS",
    "0B75": "ORIYA FRACTION ONE SIXTEENTH",
    "0B76": "ORIYA FRACTION ONE EIGHTH",
    "0B77": "ORIYA FRACTION THREE SIXTEENTHS",
    "0B82": "TAMIL SIGN ANUSVARA",
    "0B83": "TAMIL SIGN VISARGA",
    "0B85": "TAMIL LETTER A",
    "0B86": "TAMIL LETTER AA",
    "0B87": "TAMIL LETTER I",
    "0B88": "TAMIL LETTER II",
    "0B89": "TAMIL LETTER U",
    "0B8A": "TAMIL LETTER UU",
    "0B8E": "TAMIL LETTER E",
    "0B8F": "TAMIL LETTER EE",
    "0B90": "TAMIL LETTER AI",
    "0B92": "TAMIL LETTER O",
    "0B93": "TAMIL LETTER OO",
    "0B94": "TAMIL LETTER AU",
    "0B95": "TAMIL LETTER KA",
    "0B99": "TAMIL LETTER NGA",
    "0B9A": "TAMIL LETTER CA",
    "0B9C": "TAMIL LETTER JA",
    "0B9E": "TAMIL LETTER NYA",
    "0B9F": "TAMIL LETTER TTA",
    "0BA3": "TAMIL LETTER NNA",
    "0BA4": "TAMIL LETTER TA",
    "0BA8": "TAMIL LETTER NA",
    "0BA9": "TAMIL LETTER NNNA",
    "0BAA": "TAMIL LETTER PA",
    "0BAE": "TAMIL LETTER MA",
    "0BAF": "TAMIL LETTER YA",
    "0BB0": "TAMIL LETTER RA",
    "0BB1": "TAMIL LETTER RRA",
    "0BB2": "TAMIL LETTER LA",
    "0BB3": "TAMIL LETTER LLA",
    "0BB4": "TAMIL LETTER LLLA",
    "0BB5": "TAMIL LETTER VA",
    "0BB6": "TAMIL LETTER SHA",
    "0BB7": "TAMIL LETTER SSA",
    "0BB8": "TAMIL LETTER SA",
    "0BB9": "TAMIL LETTER HA",
    "0BBE": "TAMIL VOWEL SIGN AA",
    "0BBF": "TAMIL VOWEL SIGN I",
    "0BC0": "TAMIL VOWEL SIGN II",
    "0BC1": "TAMIL VOWEL SIGN U",
    "0BC2": "TAMIL VOWEL SIGN UU",
    "0BC6": "TAMIL VOWEL SIGN E",
    "0BC7": "TAMIL VOWEL SIGN EE",
    "0BC8": "TAMIL VOWEL SIGN AI",
    "0BCA": "TAMIL VOWEL SIGN O",
    "0BCB": "TAMIL VOWEL SIGN OO",
    "0BCC": "TAMIL VOWEL SIGN AU",
    "0BCD": "TAMIL SIGN VIRAMA",
    "0BD0": "TAMIL OM",
    "0BD7": "TAMIL AU LENGTH MARK",
    "0BE6": "TAMIL DIGIT ZERO",
    "0BE7": "TAMIL DIGIT ONE",
    "0BE8": "TAMIL DIGIT TWO",
    "0BE9": "TAMIL DIGIT THREE",
    "0BEA": "TAMIL DIGIT FOUR",
    "0BEB": "TAMIL DIGIT FIVE",
    "0BEC": "TAMIL DIGIT SIX",
    "0BED": "TAMIL DIGIT SEVEN",
    "0BEE": "TAMIL DIGIT EIGHT",
    "0BEF": "TAMIL DIGIT NINE",
    "0BF0": "TAMIL NUMBER TEN",
    "0BF1": "TAMIL NUMBER ONE HUNDRED",
    "0BF2": "TAMIL NUMBER ONE THOUSAND",
    "0BF3": "TAMIL DAY SIGN",
    "0BF4": "TAMIL MONTH SIGN",
    "0BF5": "TAMIL YEAR SIGN",
    "0BF6": "TAMIL DEBIT SIGN",
    "0BF7": "TAMIL CREDIT SIGN",
    "0BF8": "TAMIL AS ABOVE SIGN",
    "0BF9": "TAMIL RUPEE SIGN",
    "0BFA": "TAMIL NUMBER SIGN",
    "0C00": "TELUGU SIGN COMBINING CANDRABINDU ABOVE",
    "0C01": "TELUGU SIGN CANDRABINDU",
    "0C02": "TELUGU SIGN ANUSVARA",
    "0C03": "TELUGU SIGN VISARGA",
    "0C05": "TELUGU LETTER A",
    "0C06": "TELUGU LETTER AA",
    "0C07": "TELUGU LETTER I",
    "0C08": "TELUGU LETTER II",
    "0C09": "TELUGU LETTER U",
    "0C0A": "TELUGU LETTER UU",
    "0C0B": "TELUGU LETTER VOCALIC R",
    "0C0C": "TELUGU LETTER VOCALIC L",
    "0C0E": "TELUGU LETTER E",
    "0C0F": "TELUGU LETTER EE",
    "0C10": "TELUGU LETTER AI",
    "0C12": "TELUGU LETTER O",
    "0C13": "TELUGU LETTER OO",
    "0C14": "TELUGU LETTER AU",
    "0C15": "TELUGU LETTER KA",
    "0C16": "TELUGU LETTER KHA",
    "0C17": "TELUGU LETTER GA",
    "0C18": "TELUGU LETTER GHA",
    "0C19": "TELUGU LETTER NGA",
    "0C1A": "TELUGU LETTER CA",
    "0C1B": "TELUGU LETTER CHA",
    "0C1C": "TELUGU LETTER JA",
    "0C1D": "TELUGU LETTER JHA",
    "0C1E": "TELUGU LETTER NYA",
    "0C1F": "TELUGU LETTER TTA",
    "0C20": "TELUGU LETTER TTHA",
    "0C21": "TELUGU LETTER DDA",
    "0C22": "TELUGU LETTER DDHA",
    "0C23": "TELUGU LETTER NNA",
    "0C24": "TELUGU LETTER TA",
    "0C25": "TELUGU LETTER THA",
    "0C26": "TELUGU LETTER DA",
    "0C27": "TELUGU LETTER DHA",
    "0C28": "TELUGU LETTER NA",
    "0C2A": "TELUGU LETTER PA",
    "0C2B": "TELUGU LETTER PHA",
    "0C2C": "TELUGU LETTER BA",
    "0C2D": "TELUGU LETTER BHA",
    "0C2E": "TELUGU LETTER MA",
    "0C2F": "TELUGU LETTER YA",
    "0C30": "TELUGU LETTER RA",
    "0C31": "TELUGU LETTER RRA",
    "0C32": "TELUGU LETTER LA",
    "0C33": "TELUGU LETTER LLA",
    "0C34": "TELUGU LETTER LLLA",
    "0C35": "TELUGU LETTER VA",
    "0C36": "TELUGU LETTER SHA",
    "0C37": "TELUGU LETTER SSA",
    "0C38": "TELUGU LETTER SA",
    "0C39": "TELUGU LETTER HA",
    "0C3D": "TELUGU SIGN AVAGRAHA",
    "0C3E": "TELUGU VOWEL SIGN AA",
    "0C3F": "TELUGU VOWEL SIGN I",
    "0C40": "TELUGU VOWEL SIGN II",
    "0C41": "TELUGU VOWEL SIGN U",
    "0C42": "TELUGU VOWEL SIGN UU",
    "0C43": "TELUGU VOWEL SIGN VOCALIC R",
    "0C44": "TELUGU VOWEL SIGN VOCALIC RR",
    "0C46": "TELUGU VOWEL SIGN E",
    "0C47": "TELUGU VOWEL SIGN EE",
    "0C48": "TELUGU VOWEL SIGN AI",
    "0C4A": "TELUGU VOWEL SIGN O",
    "0C4B": "TELUGU VOWEL SIGN OO",
    "0C4C": "TELUGU VOWEL SIGN AU",
    "0C4D": "TELUGU SIGN VIRAMA",
    "0C55": "TELUGU LENGTH MARK",
    "0C56": "TELUGU AI LENGTH MARK",
    "0C58": "TELUGU LETTER TSA",
    "0C59": "TELUGU LETTER DZA",
    "0C5A": "TELUGU LETTER RRRA",
    "0C60": "TELUGU LETTER VOCALIC RR",
    "0C61": "TELUGU LETTER VOCALIC LL",
    "0C62": "TELUGU VOWEL SIGN VOCALIC L",
    "0C63": "TELUGU VOWEL SIGN VOCALIC LL",
    "0C66": "TELUGU DIGIT ZERO",
    "0C67": "TELUGU DIGIT ONE",
    "0C68": "TELUGU DIGIT TWO",
    "0C69": "TELUGU DIGIT THREE",
    "0C6A": "TELUGU DIGIT FOUR",
    "0C6B": "TELUGU DIGIT FIVE",
    "0C6C": "TELUGU DIGIT SIX",
    "0C6D": "TELUGU DIGIT SEVEN",
    "0C6E": "TELUGU DIGIT EIGHT",
    "0C6F": "TELUGU DIGIT NINE",
    "0C78": "TELUGU FRACTION DIGIT ZERO FOR ODD POWERS OF FOUR",
    "0C79": "TELUGU FRACTION DIGIT ONE FOR ODD POWERS OF FOUR",
    "0C7A": "TELUGU FRACTION DIGIT TWO FOR ODD POWERS OF FOUR",
    "0C7B": "TELUGU FRACTION DIGIT THREE FOR ODD POWERS OF FOUR",
    "0C7C": "TELUGU FRACTION DIGIT ONE FOR EVEN POWERS OF FOUR",
    "0C7D": "TELUGU FRACTION DIGIT TWO FOR EVEN POWERS OF FOUR",
    "0C7E": "TELUGU FRACTION DIGIT THREE FOR EVEN POWERS OF FOUR",
    "0C7F": "TELUGU SIGN TUUMU",
    "0C80": "KANNADA SIGN SPACING CANDRABINDU",
    "0C81": "KANNADA SIGN CANDRABINDU",
    "0C82": "KANNADA SIGN ANUSVARA",
    "0C83": "KANNADA SIGN VISARGA",
    "0C85": "KANNADA LETTER A",
    "0C86": "KANNADA LETTER AA",
    "0C87": "KANNADA LETTER I",
    "0C88": "KANNADA LETTER II",
    "0C89": "KANNADA LETTER U",
    "0C8A": "KANNADA LETTER UU",
    "0C8B": "KANNADA LETTER VOCALIC R",
    "0C8C": "KANNADA LETTER VOCALIC L",
    "0C8E": "KANNADA LETTER E",
    "0C8F": "KANNADA LETTER EE",
    "0C90": "KANNADA LETTER AI",
    "0C92": "KANNADA LETTER O",
    "0C93": "KANNADA LETTER OO",
    "0C94": "KANNADA LETTER AU",
    "0C95": "KANNADA LETTER KA",
    "0C96": "KANNADA LETTER KHA",
    "0C97": "KANNADA LETTER GA",
    "0C98": "KANNADA LETTER GHA",
    "0C99": "KANNADA LETTER NGA",
    "0C9A": "KANNADA LETTER CA",
    "0C9B": "KANNADA LETTER CHA",
    "0C9C": "KANNADA LETTER JA",
    "0C9D": "KANNADA LETTER JHA",
    "0C9E": "KANNADA LETTER NYA",
    "0C9F": "KANNADA LETTER TTA",
    "0CA0": "KANNADA LETTER TTHA",
    "0CA1": "KANNADA LETTER DDA",
    "0CA2": "KANNADA LETTER DDHA",
    "0CA3": "KANNADA LETTER NNA",
    "0CA4": "KANNADA LETTER TA",
    "0CA5": "KANNADA LETTER THA",
    "0CA6": "KANNADA LETTER DA",
    "0CA7": "KANNADA LETTER DHA",
    "0CA8": "KANNADA LETTER NA",
    "0CAA": "KANNADA LETTER PA",
    "0CAB": "KANNADA LETTER PHA",
    "0CAC": "KANNADA LETTER BA",
    "0CAD": "KANNADA LETTER BHA",
    "0CAE": "KANNADA LETTER MA",
    "0CAF": "KANNADA LETTER YA",
    "0CB0": "KANNADA LETTER RA",
    "0CB1": "KANNADA LETTER RRA",
    "0CB2": "KANNADA LETTER LA",
    "0CB3": "KANNADA LETTER LLA",
    "0CB5": "KANNADA LETTER VA",
    "0CB6": "KANNADA LETTER SHA",
    "0CB7": "KANNADA LETTER SSA",
    "0CB8": "KANNADA LETTER SA",
    "0CB9": "KANNADA LETTER HA",
    "0CBC": "KANNADA SIGN NUKTA",
    "0CBD": "KANNADA SIGN AVAGRAHA",
    "0CBE": "KANNADA VOWEL SIGN AA",
    "0CBF": "KANNADA VOWEL SIGN I",
    "0CC0": "KANNADA VOWEL SIGN II",
    "0CC1": "KANNADA VOWEL SIGN U",
    "0CC2": "KANNADA VOWEL SIGN UU",
    "0CC3": "KANNADA VOWEL SIGN VOCALIC R",
    "0CC4": "KANNADA VOWEL SIGN VOCALIC RR",
    "0CC6": "KANNADA VOWEL SIGN E",
    "0CC7": "KANNADA VOWEL SIGN EE",
    "0CC8": "KANNADA VOWEL SIGN AI",
    "0CCA": "KANNADA VOWEL SIGN O",
    "0CCB": "KANNADA VOWEL SIGN OO",
    "0CCC": "KANNADA VOWEL SIGN AU",
    "0CCD": "KANNADA SIGN VIRAMA",
    "0CD5": "KANNADA LENGTH MARK",
    "0CD6": "KANNADA AI LENGTH MARK",
    "0CDE": "KANNADA LETTER FA",
    "0CE0": "KANNADA LETTER VOCALIC RR",
    "0CE1": "KANNADA LETTER VOCALIC LL",
    "0CE2": "KANNADA VOWEL SIGN VOCALIC L",
    "0CE3": "KANNADA VOWEL SIGN VOCALIC LL",
    "0CE6": "KANNADA DIGIT ZERO",
    "0CE7": "KANNADA DIGIT ONE",
    "0CE8": "KANNADA DIGIT TWO",
    "0CE9": "KANNADA DIGIT THREE",
    "0CEA": "KANNADA DIGIT FOUR",
    "0CEB": "KANNADA DIGIT FIVE",
    "0CEC": "KANNADA DIGIT SIX",
    "0CED": "KANNADA DIGIT SEVEN",
    "0CEE": "KANNADA DIGIT EIGHT",
    "0CEF": "KANNADA DIGIT NINE",
    "0CF1": "KANNADA SIGN JIHVAMULIYA",
    "0CF2": "KANNADA SIGN UPADHMANIYA",
    "0D01": "MALAYALAM SIGN CANDRABINDU",
    "0D02": "MALAYALAM SIGN ANUSVARA",
    "0D03": "MALAYALAM SIGN VISARGA",
    "0D05": "MALAYALAM LETTER A",
    "0D06": "MALAYALAM LETTER AA",
    "0D07": "MALAYALAM LETTER I",
    "0D08": "MALAYALAM LETTER II",
    "0D09": "MALAYALAM LETTER U",
    "0D0A": "MALAYALAM LETTER UU",
    "0D0B": "MALAYALAM LETTER VOCALIC R",
    "0D0C": "MALAYALAM LETTER VOCALIC L",
    "0D0E": "MALAYALAM LETTER E",
    "0D0F": "MALAYALAM LETTER EE",
    "0D10": "MALAYALAM LETTER AI",
    "0D12": "MALAYALAM LETTER O",
    "0D13": "MALAYALAM LETTER OO",
    "0D14": "MALAYALAM LETTER AU",
    "0D15": "MALAYALAM LETTER KA",
    "0D16": "MALAYALAM LETTER KHA",
    "0D17": "MALAYALAM LETTER GA",
    "0D18": "MALAYALAM LETTER GHA",
    "0D19": "MALAYALAM LETTER NGA",
    "0D1A": "MALAYALAM LETTER CA",
    "0D1B": "MALAYALAM LETTER CHA",
    "0D1C": "MALAYALAM LETTER JA",
    "0D1D": "MALAYALAM LETTER JHA",
    "0D1E": "MALAYALAM LETTER NYA",
    "0D1F": "MALAYALAM LETTER TTA",
    "0D20": "MALAYALAM LETTER TTHA",
    "0D21": "MALAYALAM LETTER DDA",
    "0D22": "MALAYALAM LETTER DDHA",
    "0D23": "MALAYALAM LETTER NNA",
    "0D24": "MALAYALAM LETTER TA",
    "0D25": "MALAYALAM LETTER THA",
    "0D26": "MALAYALAM LETTER DA",
    "0D27": "MALAYALAM LETTER DHA",
    "0D28": "MALAYALAM LETTER NA",
    "0D29": "MALAYALAM LETTER NNNA",
    "0D2A": "MALAYALAM LETTER PA",
    "0D2B": "MALAYALAM LETTER PHA",
    "0D2C": "MALAYALAM LETTER BA",
    "0D2D": "MALAYALAM LETTER BHA",
    "0D2E": "MALAYALAM LETTER MA",
    "0D2F": "MALAYALAM LETTER YA",
    "0D30": "MALAYALAM LETTER RA",
    "0D31": "MALAYALAM LETTER RRA",
    "0D32": "MALAYALAM LETTER LA",
    "0D33": "MALAYALAM LETTER LLA",
    "0D34": "MALAYALAM LETTER LLLA",
    "0D35": "MALAYALAM LETTER VA",
    "0D36": "MALAYALAM LETTER SHA",
    "0D37": "MALAYALAM LETTER SSA",
    "0D38": "MALAYALAM LETTER SA",
    "0D39": "MALAYALAM LETTER HA",
    "0D3A": "MALAYALAM LETTER TTTA",
    "0D3D": "MALAYALAM SIGN AVAGRAHA",
    "0D3E": "MALAYALAM VOWEL SIGN AA",
    "0D3F": "MALAYALAM VOWEL SIGN I",
    "0D40": "MALAYALAM VOWEL SIGN II",
    "0D41": "MALAYALAM VOWEL SIGN U",
    "0D42": "MALAYALAM VOWEL SIGN UU",
    "0D43": "MALAYALAM VOWEL SIGN VOCALIC R",
    "0D44": "MALAYALAM VOWEL SIGN VOCALIC RR",
    "0D46": "MALAYALAM VOWEL SIGN E",
    "0D47": "MALAYALAM VOWEL SIGN EE",
    "0D48": "MALAYALAM VOWEL SIGN AI",
    "0D4A": "MALAYALAM VOWEL SIGN O",
    "0D4B": "MALAYALAM VOWEL SIGN OO",
    "0D4C": "MALAYALAM VOWEL SIGN AU",
    "0D4D": "MALAYALAM SIGN VIRAMA",
    "0D4E": "MALAYALAM LETTER DOT REPH",
    "0D4F": "MALAYALAM SIGN PARA",
    "0D54": "MALAYALAM LETTER CHILLU M",
    "0D55": "MALAYALAM LETTER CHILLU Y",
    "0D56": "MALAYALAM LETTER CHILLU LLL",
    "0D57": "MALAYALAM AU LENGTH MARK",
    "0D58": "MALAYALAM FRACTION ONE ONE-HUNDRED-AND-SIXTIETH",
    "0D59": "MALAYALAM FRACTION ONE FORTIETH",
    "0D5A": "MALAYALAM FRACTION THREE EIGHTIETHS",
    "0D5B": "MALAYALAM FRACTION ONE TWENTIETH",
    "0D5C": "MALAYALAM FRACTION ONE TENTH",
    "0D5D": "MALAYALAM FRACTION THREE TWENTIETHS",
    "0D5E": "MALAYALAM FRACTION ONE FIFTH",
    "0D5F": "MALAYALAM LETTER ARCHAIC II",
    "0D60": "MALAYALAM LETTER VOCALIC RR",
    "0D61": "MALAYALAM LETTER VOCALIC LL",
    "0D62": "MALAYALAM VOWEL SIGN VOCALIC L",
    "0D63": "MALAYALAM VOWEL SIGN VOCALIC LL",
    "0D66": "MALAYALAM DIGIT ZERO",
    "0D67": "MALAYALAM DIGIT ONE",
    "0D68": "MALAYALAM DIGIT TWO",
    "0D69": "MALAYALAM DIGIT THREE",
    "0D6A": "MALAYALAM DIGIT FOUR",
    "0D6B": "MALAYALAM DIGIT FIVE",
    "0D6C": "MALAYALAM DIGIT SIX",
    "0D6D": "MALAYALAM DIGIT SEVEN",
    "0D6E": "MALAYALAM DIGIT EIGHT",
    "0D6F": "MALAYALAM DIGIT NINE",
    "0D70": "MALAYALAM NUMBER TEN",
    "0D71": "MALAYALAM NUMBER ONE HUNDRED",
    "0D72": "MALAYALAM NUMBER ONE THOUSAND",
    "0D73": "MALAYALAM FRACTION ONE QUARTER",
    "0D74": "MALAYALAM FRACTION ONE HALF",
    "0D75": "MALAYALAM FRACTION THREE QUARTERS",
    "0D76": "MALAYALAM FRACTION ONE SIXTEENTH",
    "0D77": "MALAYALAM FRACTION ONE EIGHTH",
    "0D78": "MALAYALAM FRACTION THREE SIXTEENTHS",
    "0D79": "MALAYALAM DATE MARK",
    "0D7A": "MALAYALAM LETTER CHILLU NN",
    "0D7B": "MALAYALAM LETTER CHILLU N",
    "0D7C": "MALAYALAM LETTER CHILLU RR",
    "0D7D": "MALAYALAM LETTER CHILLU L",
    "0D7E": "MALAYALAM LETTER CHILLU LL",
    "0D7F": "MALAYALAM LETTER CHILLU K",
    "0D82": "SINHALA SIGN ANUSVARAYA",
    "0D83": "SINHALA SIGN VISARGAYA",
    "0D85": "SINHALA LETTER AYANNA",
    "0D86": "SINHALA LETTER AAYANNA",
    "0D87": "SINHALA LETTER AEYANNA",
    "0D88": "SINHALA LETTER AEEYANNA",
    "0D89": "SINHALA LETTER IYANNA",
    "0D8A": "SINHALA LETTER IIYANNA",
    "0D8B": "SINHALA LETTER UYANNA",
    "0D8C": "SINHALA LETTER UUYANNA",
    "0D8D": "SINHALA LETTER IRUYANNA",
    "0D8E": "SINHALA LETTER IRUUYANNA",
    "0D8F": "SINHALA LETTER ILUYANNA",
    "0D90": "SINHALA LETTER ILUUYANNA",
    "0D91": "SINHALA LETTER EYANNA",
    "0D92": "SINHALA LETTER EEYANNA",
    "0D93": "SINHALA LETTER AIYANNA",
    "0D94": "SINHALA LETTER OYANNA",
    "0D95": "SINHALA LETTER OOYANNA",
    "0D96": "SINHALA LETTER AUYANNA",
    "0D9A": "SINHALA LETTER ALPAPRAANA KAYANNA",
    "0D9B": "SINHALA LETTER MAHAAPRAANA KAYANNA",
    "0D9C": "SINHALA LETTER ALPAPRAANA GAYANNA",
    "0D9D": "SINHALA LETTER MAHAAPRAANA GAYANNA",
    "0D9E": "SINHALA LETTER KANTAJA NAASIKYAYA",
    "0D9F": "SINHALA LETTER SANYAKA GAYANNA",
    "0DA0": "SINHALA LETTER ALPAPRAANA CAYANNA",
    "0DA1": "SINHALA LETTER MAHAAPRAANA CAYANNA",
    "0DA2": "SINHALA LETTER ALPAPRAANA JAYANNA",
    "0DA3": "SINHALA LETTER MAHAAPRAANA JAYANNA",
    "0DA4": "SINHALA LETTER TAALUJA NAASIKYAYA",
    "0DA5": "SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA",
    "0DA6": "SINHALA LETTER SANYAKA JAYANNA",
    "0DA7": "SINHALA LETTER ALPAPRAANA TTAYANNA",
    "0DA8": "SINHALA LETTER MAHAAPRAANA TTAYANNA",
    "0DA9": "SINHALA LETTER ALPAPRAANA DDAYANNA",
    "0DAA": "SINHALA LETTER MAHAAPRAANA DDAYANNA",
    "0DAB": "SINHALA LETTER MUURDHAJA NAYANNA",
    "0DAC": "SINHALA LETTER SANYAKA DDAYANNA",
    "0DAD": "SINHALA LETTER ALPAPRAANA TAYANNA",
    "0DAE": "SINHALA LETTER MAHAAPRAANA TAYANNA",
    "0DAF": "SINHALA LETTER ALPAPRAANA DAYANNA",
    "0DB0": "SINHALA LETTER MAHAAPRAANA DAYANNA",
    "0DB1": "SINHALA LETTER DANTAJA NAYANNA",
    "0DB3": "SINHALA LETTER SANYAKA DAYANNA",
    "0DB4": "SINHALA LETTER ALPAPRAANA PAYANNA",
    "0DB5": "SINHALA LETTER MAHAAPRAANA PAYANNA",
    "0DB6": "SINHALA LETTER ALPAPRAANA BAYANNA",
    "0DB7": "SINHALA LETTER MAHAAPRAANA BAYANNA",
    "0DB8": "SINHALA LETTER MAYANNA",
    "0DB9": "SINHALA LETTER AMBA BAYANNA",
    "0DBA": "SINHALA LETTER YAYANNA",
    "0DBB": "SINHALA LETTER RAYANNA",
    "0DBD": "SINHALA LETTER DANTAJA LAYANNA",
    "0DC0": "SINHALA LETTER VAYANNA",
    "0DC1": "SINHALA LETTER TAALUJA SAYANNA",
    "0DC2": "SINHALA LETTER MUURDHAJA SAYANNA",
    "0DC3": "SINHALA LETTER DANTAJA SAYANNA",
    "0DC4": "SINHALA LETTER HAYANNA",
    "0DC5": "SINHALA LETTER MUURDHAJA LAYANNA",
    "0DC6": "SINHALA LETTER FAYANNA",
    "0DCA": "SINHALA SIGN AL-LAKUNA",
    "0DCF": "SINHALA VOWEL SIGN AELA-PILLA",
    "0DD0": "SINHALA VOWEL SIGN KETTI AEDA-PILLA",
    "0DD1": "SINHALA VOWEL SIGN DIGA AEDA-PILLA",
    "0DD2": "SINHALA VOWEL SIGN KETTI IS-PILLA",
    "0DD3": "SINHALA VOWEL SIGN DIGA IS-PILLA",
    "0DD4": "SINHALA VOWEL SIGN KETTI PAA-PILLA",
    "0DD6": "SINHALA VOWEL SIGN DIGA PAA-PILLA",
    "0DD8": "SINHALA VOWEL SIGN GAETTA-PILLA",
    "0DD9": "SINHALA VOWEL SIGN KOMBUVA",
    "0DDA": "SINHALA VOWEL SIGN DIGA KOMBUVA",
    "0DDB": "SINHALA VOWEL SIGN KOMBU DEKA",
    "0DDC": "SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA",
    "0DDD": "SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA",
    "0DDE": "SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA",
    "0DDF": "SINHALA VOWEL SIGN GAYANUKITTA",
    "0DE6": "SINHALA LITH DIGIT ZERO",
    "0DE7": "SINHALA LITH DIGIT ONE",
    "0DE8": "SINHALA LITH DIGIT TWO",
    "0DE9": "SINHALA LITH DIGIT THREE",
    "0DEA": "SINHALA LITH DIGIT FOUR",
    "0DEB": "SINHALA LITH DIGIT FIVE",
    "0DEC": "SINHALA LITH DIGIT SIX",
    "0DED": "SINHALA LITH DIGIT SEVEN",
    "0DEE": "SINHALA LITH DIGIT EIGHT",
    "0DEF": "SINHALA LITH DIGIT NINE",
    "0DF2": "SINHALA VOWEL SIGN DIGA GAETTA-PILLA",
    "0DF3": "SINHALA VOWEL SIGN DIGA GAYANUKITTA",
    "0DF4": "SINHALA PUNCTUATION KUNDDALIYA",
    "0E01": "THAI CHARACTER KO KAI",
    "0E02": "THAI CHARACTER KHO KHAI",
    "0E03": "THAI CHARACTER KHO KHUAT",
    "0E04": "THAI CHARACTER KHO KHWAI",
    "0E05": "THAI CHARACTER KHO KHON",
    "0E06": "THAI CHARACTER KHO RAKHANG",
    "0E07": "THAI CHARACTER NGO NGU",
    "0E08": "THAI CHARACTER CHO CHAN",
    "0E09": "THAI CHARACTER CHO CHING",
    "0E0A": "THAI CHARACTER CHO CHANG",
    "0E0B": "THAI CHARACTER SO SO",
    "0E0C": "THAI CHARACTER CHO CHOE",
    "0E0D": "THAI CHARACTER YO YING",
    "0E0E": "THAI CHARACTER DO CHADA",
    "0E0F": "THAI CHARACTER TO PATAK",
    "0E10": "THAI CHARACTER THO THAN",
    "0E11": "THAI CHARACTER THO NANGMONTHO",
    "0E12": "THAI CHARACTER THO PHUTHAO",
    "0E13": "THAI CHARACTER NO NEN",
    "0E14": "THAI CHARACTER DO DEK",
    "0E15": "THAI CHARACTER TO TAO",
    "0E16": "THAI CHARACTER THO THUNG",
    "0E17": "THAI CHARACTER THO THAHAN",
    "0E18": "THAI CHARACTER THO THONG",
    "0E19": "THAI CHARACTER NO NU",
    "0E1A": "THAI CHARACTER BO BAIMAI",
    "0E1B": "THAI CHARACTER PO PLA",
    "0E1C": "THAI CHARACTER PHO PHUNG",
    "0E1D": "THAI CHARACTER FO FA",
    "0E1E": "THAI CHARACTER PHO PHAN",
    "0E1F": "THAI CHARACTER FO FAN",
    "0E20": "THAI CHARACTER PHO SAMPHAO",
    "0E21": "THAI CHARACTER MO MA",
    "0E22": "THAI CHARACTER YO YAK",
    "0E23": "THAI CHARACTER RO RUA",
    "0E24": "THAI CHARACTER RU",
    "0E25": "THAI CHARACTER LO LING",
    "0E26": "THAI CHARACTER LU",
    "0E27": "THAI CHARACTER WO WAEN",
    "0E28": "THAI CHARACTER SO SALA",
    "0E29": "THAI CHARACTER SO RUSI",
    "0E2A": "THAI CHARACTER SO SUA",
    "0E2B": "THAI CHARACTER HO HIP",
    "0E2C": "THAI CHARACTER LO CHULA",
    "0E2D": "THAI CHARACTER O ANG",
    "0E2E": "THAI CHARACTER HO NOKHUK",
    "0E2F": "THAI CHARACTER PAIYANNOI",
    "0E30": "THAI CHARACTER SARA A",
    "0E31": "THAI CHARACTER MAI HAN-AKAT",
    "0E32": "THAI CHARACTER SARA AA",
    "0E33": "THAI CHARACTER SARA AM",
    "0E34": "THAI CHARACTER SARA I",
    "0E35": "THAI CHARACTER SARA II",
    "0E36": "THAI CHARACTER SARA UE",
    "0E37": "THAI CHARACTER SARA UEE",
    "0E38": "THAI CHARACTER SARA U",
    "0E39": "THAI CHARACTER SARA UU",
    "0E3A": "THAI CHARACTER PHINTHU",
    "0E3F": "THAI CURRENCY SYMBOL BAHT",
    "0E40": "THAI CHARACTER SARA E",
    "0E41": "THAI CHARACTER SARA AE",
    "0E42": "THAI CHARACTER SARA O",
    "0E43": "THAI CHARACTER SARA AI MAIMUAN",
    "0E44": "THAI CHARACTER SARA AI MAIMALAI",
    "0E45": "THAI CHARACTER LAKKHANGYAO",
    "0E46": "THAI CHARACTER MAIYAMOK",
    "0E47": "THAI CHARACTER MAITAIKHU",
    "0E48": "THAI CHARACTER MAI EK",
    "0E49": "THAI CHARACTER MAI THO",
    "0E4A": "THAI CHARACTER MAI TRI",
    "0E4B": "THAI CHARACTER MAI CHATTAWA",
    "0E4C": "THAI CHARACTER THANTHAKHAT",
    "0E4D": "THAI CHARACTER NIKHAHIT",
    "0E4E": "THAI CHARACTER YAMAKKAN",
    "0E4F": "THAI CHARACTER FONGMAN",
    "0E50": "THAI DIGIT ZERO",
    "0E51": "THAI DIGIT ONE",
    "0E52": "THAI DIGIT TWO",
    "0E53": "THAI DIGIT THREE",
    "0E54": "THAI DIGIT FOUR",
    "0E55": "THAI DIGIT FIVE",
    "0E56": "THAI DIGIT SIX",
    "0E57": "THAI DIGIT SEVEN",
    "0E58": "THAI DIGIT EIGHT",
    "0E59": "THAI DIGIT NINE",
    "0E5A": "THAI CHARACTER ANGKHANKHU",
    "0E5B": "THAI CHARACTER KHOMUT",
    "0E81": "LAO LETTER KO",
    "0E82": "LAO LETTER KHO SUNG",
    "0E84": "LAO LETTER KHO TAM",
    "0E87": "LAO LETTER NGO",
    "0E88": "LAO LETTER CO",
    "0E8A": "LAO LETTER SO TAM",
    "0E8D": "LAO LETTER NYO",
    "0E94": "LAO LETTER DO",
    "0E95": "LAO LETTER TO",
    "0E96": "LAO LETTER THO SUNG",
    "0E97": "LAO LETTER THO TAM",
    "0E99": "LAO LETTER NO",
    "0E9A": "LAO LETTER BO",
    "0E9B": "LAO LETTER PO",
    "0E9C": "LAO LETTER PHO SUNG",
    "0E9D": "LAO LETTER FO TAM",
    "0E9E": "LAO LETTER PHO TAM",
    "0E9F": "LAO LETTER FO SUNG",
    "0EA1": "LAO LETTER MO",
    "0EA2": "LAO LETTER YO",
    "0EA3": "LAO LETTER LO LING",
    "0EA5": "LAO LETTER LO LOOT",
    "0EA7": "LAO LETTER WO",
    "0EAA": "LAO LETTER SO SUNG",
    "0EAB": "LAO LETTER HO SUNG",
    "0EAD": "LAO LETTER O",
    "0EAE": "LAO LETTER HO TAM",
    "0EAF": "LAO ELLIPSIS",
    "0EB0": "LAO VOWEL SIGN A",
    "0EB1": "LAO VOWEL SIGN MAI KAN",
    "0EB2": "LAO VOWEL SIGN AA",
    "0EB3": "LAO VOWEL SIGN AM",
    "0EB4": "LAO VOWEL SIGN I",
    "0EB5": "LAO VOWEL SIGN II",
    "0EB6": "LAO VOWEL SIGN Y",
    "0EB7": "LAO VOWEL SIGN YY",
    "0EB8": "LAO VOWEL SIGN U",
    "0EB9": "LAO VOWEL SIGN UU",
    "0EBB": "LAO VOWEL SIGN MAI KON",
    "0EBC": "LAO SEMIVOWEL SIGN LO",
    "0EBD": "LAO SEMIVOWEL SIGN NYO",
    "0EC0": "LAO VOWEL SIGN E",
    "0EC1": "LAO VOWEL SIGN EI",
    "0EC2": "LAO VOWEL SIGN O",
    "0EC3": "LAO VOWEL SIGN AY",
    "0EC4": "LAO VOWEL SIGN AI",
    "0EC6": "LAO KO LA",
    "0EC8": "LAO TONE MAI EK",
    "0EC9": "LAO TONE MAI THO",
    "0ECA": "LAO TONE MAI TI",
    "0ECB": "LAO TONE MAI CATAWA",
    "0ECC": "LAO CANCELLATION MARK",
    "0ECD": "LAO NIGGAHITA",
    "0ED0": "LAO DIGIT ZERO",
    "0ED1": "LAO DIGIT ONE",
    "0ED2": "LAO DIGIT TWO",
    "0ED3": "LAO DIGIT THREE",
    "0ED4": "LAO DIGIT FOUR",
    "0ED5": "LAO DIGIT FIVE",
    "0ED6": "LAO DIGIT SIX",
    "0ED7": "LAO DIGIT SEVEN",
    "0ED8": "LAO DIGIT EIGHT",
    "0ED9": "LAO DIGIT NINE",
    "0EDC": "LAO HO NO",
    "0EDD": "LAO HO MO",
    "0EDE": "LAO LETTER KHMU GO",
    "0EDF": "LAO LETTER KHMU NYO",
    "0F00": "TIBETAN SYLLABLE OM",
    "0F01": "TIBETAN MARK GTER YIG MGO TRUNCATED A",
    "0F02": "TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA",
    "0F03": "TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA",
    "0F04": "TIBETAN MARK INITIAL YIG MGO MDUN MA",
    "0F05": "TIBETAN MARK CLOSING YIG MGO SGAB MA",
    "0F06": "TIBETAN MARK CARET YIG MGO PHUR SHAD MA",
    "0F07": "TIBETAN MARK YIG MGO TSHEG SHAD MA",
    "0F08": "TIBETAN MARK SBRUL SHAD",
    "0F09": "TIBETAN MARK BSKUR YIG MGO",
    "0F0A": "TIBETAN MARK BKA- SHOG YIG MGO",
    "0F0B": "TIBETAN MARK INTERSYLLABIC TSHEG",
    "0F0C": "TIBETAN MARK DELIMITER TSHEG BSTAR",
    "0F0D": "TIBETAN MARK SHAD",
    "0F0E": "TIBETAN MARK NYIS SHAD",
    "0F0F": "TIBETAN MARK TSHEG SHAD",
    "0F10": "TIBETAN MARK NYIS TSHEG SHAD",
    "0F11": "TIBETAN MARK RIN CHEN SPUNGS SHAD",
    "0F12": "TIBETAN MARK RGYA GRAM SHAD",
    "0F13": "TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN",
    "0F14": "TIBETAN MARK GTER TSHEG",
    "0F15": "TIBETAN LOGOTYPE SIGN CHAD RTAGS",
    "0F16": "TIBETAN LOGOTYPE SIGN LHAG RTAGS",
    "0F17": "TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS",
    "0F18": "TIBETAN ASTROLOGICAL SIGN -KHYUD PA",
    "0F19": "TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS",
    "0F1A": "TIBETAN SIGN RDEL DKAR GCIG",
    "0F1B": "TIBETAN SIGN RDEL DKAR GNYIS",
    "0F1C": "TIBETAN SIGN RDEL DKAR GSUM",
    "0F1D": "TIBETAN SIGN RDEL NAG GCIG",
    "0F1E": "TIBETAN SIGN RDEL NAG GNYIS",
    "0F1F": "TIBETAN SIGN RDEL DKAR RDEL NAG",
    "0F20": "TIBETAN DIGIT ZERO",
    "0F21": "TIBETAN DIGIT ONE",
    "0F22": "TIBETAN DIGIT TWO",
    "0F23": "TIBETAN DIGIT THREE",
    "0F24": "TIBETAN DIGIT FOUR",
    "0F25": "TIBETAN DIGIT FIVE",
    "0F26": "TIBETAN DIGIT SIX",
    "0F27": "TIBETAN DIGIT SEVEN",
    "0F28": "TIBETAN DIGIT EIGHT",
    "0F29": "TIBETAN DIGIT NINE",
    "0F2A": "TIBETAN DIGIT HALF ONE",
    "0F2B": "TIBETAN DIGIT HALF TWO",
    "0F2C": "TIBETAN DIGIT HALF THREE",
    "0F2D": "TIBETAN DIGIT HALF FOUR",
    "0F2E": "TIBETAN DIGIT HALF FIVE",
    "0F2F": "TIBETAN DIGIT HALF SIX",
    "0F30": "TIBETAN DIGIT HALF SEVEN",
    "0F31": "TIBETAN DIGIT HALF EIGHT",
    "0F32": "TIBETAN DIGIT HALF NINE",
    "0F33": "TIBETAN DIGIT HALF ZERO",
    "0F34": "TIBETAN MARK BSDUS RTAGS",
    "0F35": "TIBETAN MARK NGAS BZUNG NYI ZLA",
    "0F36": "TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN",
    "0F37": "TIBETAN MARK NGAS BZUNG SGOR RTAGS",
    "0F38": "TIBETAN MARK CHE MGO",
    "0F39": "TIBETAN MARK TSA -PHRU",
    "0F3A": "TIBETAN MARK GUG RTAGS GYON",
    "0F3B": "TIBETAN MARK GUG RTAGS GYAS",
    "0F3C": "TIBETAN MARK ANG KHANG GYON",
    "0F3D": "TIBETAN MARK ANG KHANG GYAS",
    "0F3E": "TIBETAN SIGN YAR TSHES",
    "0F3F": "TIBETAN SIGN MAR TSHES",
    "0F40": "TIBETAN LETTER KA",
    "0F41": "TIBETAN LETTER KHA",
    "0F42": "TIBETAN LETTER GA",
    "0F43": "TIBETAN LETTER GHA",
    "0F44": "TIBETAN LETTER NGA",
    "0F45": "TIBETAN LETTER CA",
    "0F46": "TIBETAN LETTER CHA",
    "0F47": "TIBETAN LETTER JA",
    "0F49": "TIBETAN LETTER NYA",
    "0F4A": "TIBETAN LETTER TTA",
    "0F4B": "TIBETAN LETTER TTHA",
    "0F4C": "TIBETAN LETTER DDA",
    "0F4D": "TIBETAN LETTER DDHA",
    "0F4E": "TIBETAN LETTER NNA",
    "0F4F": "TIBETAN LETTER TA",
    "0F50": "TIBETAN LETTER THA",
    "0F51": "TIBETAN LETTER DA",
    "0F52": "TIBETAN LETTER DHA",
    "0F53": "TIBETAN LETTER NA",
    "0F54": "TIBETAN LETTER PA",
    "0F55": "TIBETAN LETTER PHA",
    "0F56": "TIBETAN LETTER BA",
    "0F57": "TIBETAN LETTER BHA",
    "0F58": "TIBETAN LETTER MA",
    "0F59": "TIBETAN LETTER TSA",
    "0F5A": "TIBETAN LETTER TSHA",
    "0F5B": "TIBETAN LETTER DZA",
    "0F5C": "TIBETAN LETTER DZHA",
    "0F5D": "TIBETAN LETTER WA",
    "0F5E": "TIBETAN LETTER ZHA",
    "0F5F": "TIBETAN LETTER ZA",
    "0F60": "TIBETAN LETTER -A",
    "0F61": "TIBETAN LETTER YA",
    "0F62": "TIBETAN LETTER RA",
    "0F63": "TIBETAN LETTER LA",
    "0F64": "TIBETAN LETTER SHA",
    "0F65": "TIBETAN LETTER SSA",
    "0F66": "TIBETAN LETTER SA",
    "0F67": "TIBETAN LETTER HA",
    "0F68": "TIBETAN LETTER A",
    "0F69": "TIBETAN LETTER KSSA",
    "0F6A": "TIBETAN LETTER FIXED-FORM RA",
    "0F6B": "TIBETAN LETTER KKA",
    "0F6C": "TIBETAN LETTER RRA",
    "0F71": "TIBETAN VOWEL SIGN AA",
    "0F72": "TIBETAN VOWEL SIGN I",
    "0F73": "TIBETAN VOWEL SIGN II",
    "0F74": "TIBETAN VOWEL SIGN U",
    "0F75": "TIBETAN VOWEL SIGN UU",
    "0F76": "TIBETAN VOWEL SIGN VOCALIC R",
    "0F77": "TIBETAN VOWEL SIGN VOCALIC RR",
    "0F78": "TIBETAN VOWEL SIGN VOCALIC L",
    "0F79": "TIBETAN VOWEL SIGN VOCALIC LL",
    "0F7A": "TIBETAN VOWEL SIGN E",
    "0F7B": "TIBETAN VOWEL SIGN EE",
    "0F7C": "TIBETAN VOWEL SIGN O",
    "0F7D": "TIBETAN VOWEL SIGN OO",
    "0F7E": "TIBETAN SIGN RJES SU NGA RO",
    "0F7F": "TIBETAN SIGN RNAM BCAD",
    "0F80": "TIBETAN VOWEL SIGN REVERSED I",
    "0F81": "TIBETAN VOWEL SIGN REVERSED II",
    "0F82": "TIBETAN SIGN NYI ZLA NAA DA",
    "0F83": "TIBETAN SIGN SNA LDAN",
    "0F84": "TIBETAN MARK HALANTA",
    "0F85": "TIBETAN MARK PALUTA",
    "0F86": "TIBETAN SIGN LCI RTAGS",
    "0F87": "TIBETAN SIGN YANG RTAGS",
    "0F88": "TIBETAN SIGN LCE TSA CAN",
    "0F89": "TIBETAN SIGN MCHU CAN",
    "0F8A": "TIBETAN SIGN GRU CAN RGYINGS",
    "0F8B": "TIBETAN SIGN GRU MED RGYINGS",
    "0F8C": "TIBETAN SIGN INVERTED MCHU CAN",
    "0F8D": "TIBETAN SUBJOINED SIGN LCE TSA CAN",
    "0F8E": "TIBETAN SUBJOINED SIGN MCHU CAN",
    "0F8F": "TIBETAN SUBJOINED SIGN INVERTED MCHU CAN",
    "0F90": "TIBETAN SUBJOINED LETTER KA",
    "0F91": "TIBETAN SUBJOINED LETTER KHA",
    "0F92": "TIBETAN SUBJOINED LETTER GA",
    "0F93": "TIBETAN SUBJOINED LETTER GHA",
    "0F94": "TIBETAN SUBJOINED LETTER NGA",
    "0F95": "TIBETAN SUBJOINED LETTER CA",
    "0F96": "TIBETAN SUBJOINED LETTER CHA",
    "0F97": "TIBETAN SUBJOINED LETTER JA",
    "0F99": "TIBETAN SUBJOINED LETTER NYA",
    "0F9A": "TIBETAN SUBJOINED LETTER TTA",
    "0F9B": "TIBETAN SUBJOINED LETTER TTHA",
    "0F9C": "TIBETAN SUBJOINED LETTER DDA",
    "0F9D": "TIBETAN SUBJOINED LETTER DDHA",
    "0F9E": "TIBETAN SUBJOINED LETTER NNA",
    "0F9F": "TIBETAN SUBJOINED LETTER TA",
    "0FA0": "TIBETAN SUBJOINED LETTER THA",
    "0FA1": "TIBETAN SUBJOINED LETTER DA",
    "0FA2": "TIBETAN SUBJOINED LETTER DHA",
    "0FA3": "TIBETAN SUBJOINED LETTER NA",
    "0FA4": "TIBETAN SUBJOINED LETTER PA",
    "0FA5": "TIBETAN SUBJOINED LETTER PHA",
    "0FA6": "TIBETAN SUBJOINED LETTER BA",
    "0FA7": "TIBETAN SUBJOINED LETTER BHA",
    "0FA8": "TIBETAN SUBJOINED LETTER MA",
    "0FA9": "TIBETAN SUBJOINED LETTER TSA",
    "0FAA": "TIBETAN SUBJOINED LETTER TSHA",
    "0FAB": "TIBETAN SUBJOINED LETTER DZA",
    "0FAC": "TIBETAN SUBJOINED LETTER DZHA",
    "0FAD": "TIBETAN SUBJOINED LETTER WA",
    "0FAE": "TIBETAN SUBJOINED LETTER ZHA",
    "0FAF": "TIBETAN SUBJOINED LETTER ZA",
    "0FB0": "TIBETAN SUBJOINED LETTER -A",
    "0FB1": "TIBETAN SUBJOINED LETTER YA",
    "0FB2": "TIBETAN SUBJOINED LETTER RA",
    "0FB3": "TIBETAN SUBJOINED LETTER LA",
    "0FB4": "TIBETAN SUBJOINED LETTER SHA",
    "0FB5": "TIBETAN SUBJOINED LETTER SSA",
    "0FB6": "TIBETAN SUBJOINED LETTER SA",
    "0FB7": "TIBETAN SUBJOINED LETTER HA",
    "0FB8": "TIBETAN SUBJOINED LETTER A",
    "0FB9": "TIBETAN SUBJOINED LETTER KSSA",
    "0FBA": "TIBETAN SUBJOINED LETTER FIXED-FORM WA",
    "0FBB": "TIBETAN SUBJOINED LETTER FIXED-FORM YA",
    "0FBC": "TIBETAN SUBJOINED LETTER FIXED-FORM RA",
    "0FBE": "TIBETAN KU RU KHA",
    "0FBF": "TIBETAN KU RU KHA BZHI MIG CAN",
    "0FC0": "TIBETAN CANTILLATION SIGN HEAVY BEAT",
    "0FC1": "TIBETAN CANTILLATION SIGN LIGHT BEAT",
    "0FC2": "TIBETAN CANTILLATION SIGN CANG TE-U",
    "0FC3": "TIBETAN CANTILLATION SIGN SBUB -CHAL",
    "0FC4": "TIBETAN SYMBOL DRIL BU",
    "0FC5": "TIBETAN SYMBOL RDO RJE",
    "0FC6": "TIBETAN SYMBOL PADMA GDAN",
    "0FC7": "TIBETAN SYMBOL RDO RJE RGYA GRAM",
    "0FC8": "TIBETAN SYMBOL PHUR PA",
    "0FC9": "TIBETAN SYMBOL NOR BU",
    "0FCA": "TIBETAN SYMBOL NOR BU NYIS -KHYIL",
    "0FCB": "TIBETAN SYMBOL NOR BU GSUM -KHYIL",
    "0FCC": "TIBETAN SYMBOL NOR BU BZHI -KHYIL",
    "0FCE": "TIBETAN SIGN RDEL NAG RDEL DKAR",
    "0FCF": "TIBETAN SIGN RDEL NAG GSUM",
    "0FD0": "TIBETAN MARK BSKA- SHOG GI MGO RGYAN",
    "0FD1": "TIBETAN MARK MNYAM YIG GI MGO RGYAN",
    "0FD2": "TIBETAN MARK NYIS TSHEG",
    "0FD3": "TIBETAN MARK INITIAL BRDA RNYING YIG MGO MDUN MA",
    "0FD4": "TIBETAN MARK CLOSING BRDA RNYING YIG MGO SGAB MA",
    "0FD5": "RIGHT-FACING SVASTI SIGN",
    "0FD6": "LEFT-FACING SVASTI SIGN",
    "0FD7": "RIGHT-FACING SVASTI SIGN WITH DOTS",
    "0FD8": "LEFT-FACING SVASTI SIGN WITH DOTS",
    "0FD9": "TIBETAN MARK LEADING MCHAN RTAGS",
    "0FDA": "TIBETAN MARK TRAILING MCHAN RTAGS",
    "1000": "MYANMAR LETTER KA",
    "1001": "MYANMAR LETTER KHA",
    "1002": "MYANMAR LETTER GA",
    "1003": "MYANMAR LETTER GHA",
    "1004": "MYANMAR LETTER NGA",
    "1005": "MYANMAR LETTER CA",
    "1006": "MYANMAR LETTER CHA",
    "1007": "MYANMAR LETTER JA",
    "1008": "MYANMAR LETTER JHA",
    "1009": "MYANMAR LETTER NYA",
    "100A": "MYANMAR LETTER NNYA",
    "100B": "MYANMAR LETTER TTA",
    "100C": "MYANMAR LETTER TTHA",
    "100D": "MYANMAR LETTER DDA",
    "100E": "MYANMAR LETTER DDHA",
    "100F": "MYANMAR LETTER NNA",
    "1010": "MYANMAR LETTER TA",
    "1011": "MYANMAR LETTER THA",
    "1012": "MYANMAR LETTER DA",
    "1013": "MYANMAR LETTER DHA",
    "1014": "MYANMAR LETTER NA",
    "1015": "MYANMAR LETTER PA",
    "1016": "MYANMAR LETTER PHA",
    "1017": "MYANMAR LETTER BA",
    "1018": "MYANMAR LETTER BHA",
    "1019": "MYANMAR LETTER MA",
    "101A": "MYANMAR LETTER YA",
    "101B": "MYANMAR LETTER RA",
    "101C": "MYANMAR LETTER LA",
    "101D": "MYANMAR LETTER WA",
    "101E": "MYANMAR LETTER SA",
    "101F": "MYANMAR LETTER HA",
    "1020": "MYANMAR LETTER LLA",
    "1021": "MYANMAR LETTER A",
    "1022": "MYANMAR LETTER SHAN A",
    "1023": "MYANMAR LETTER I",
    "1024": "MYANMAR LETTER II",
    "1025": "MYANMAR LETTER U",
    "1026": "MYANMAR LETTER UU",
    "1027": "MYANMAR LETTER E",
    "1028": "MYANMAR LETTER MON E",
    "1029": "MYANMAR LETTER O",
    "102A": "MYANMAR LETTER AU",
    "102B": "MYANMAR VOWEL SIGN TALL AA",
    "102C": "MYANMAR VOWEL SIGN AA",
    "102D": "MYANMAR VOWEL SIGN I",
    "102E": "MYANMAR VOWEL SIGN II",
    "102F": "MYANMAR VOWEL SIGN U",
    "1030": "MYANMAR VOWEL SIGN UU",
    "1031": "MYANMAR VOWEL SIGN E",
    "1032": "MYANMAR VOWEL SIGN AI",
    "1033": "MYANMAR VOWEL SIGN MON II",
    "1034": "MYANMAR VOWEL SIGN MON O",
    "1035": "MYANMAR VOWEL SIGN E ABOVE",
    "1036": "MYANMAR SIGN ANUSVARA",
    "1037": "MYANMAR SIGN DOT BELOW",
    "1038": "MYANMAR SIGN VISARGA",
    "1039": "MYANMAR SIGN VIRAMA",
    "103A": "MYANMAR SIGN ASAT",
    "103B": "MYANMAR CONSONANT SIGN MEDIAL YA",
    "103C": "MYANMAR CONSONANT SIGN MEDIAL RA",
    "103D": "MYANMAR CONSONANT SIGN MEDIAL WA",
    "103E": "MYANMAR CONSONANT SIGN MEDIAL HA",
    "103F": "MYANMAR LETTER GREAT SA",
    "1040": "MYANMAR DIGIT ZERO",
    "1041": "MYANMAR DIGIT ONE",
    "1042": "MYANMAR DIGIT TWO",
    "1043": "MYANMAR DIGIT THREE",
    "1044": "MYANMAR DIGIT FOUR",
    "1045": "MYANMAR DIGIT FIVE",
    "1046": "MYANMAR DIGIT SIX",
    "1047": "MYANMAR DIGIT SEVEN",
    "1048": "MYANMAR DIGIT EIGHT",
    "1049": "MYANMAR DIGIT NINE",
    "104A": "MYANMAR SIGN LITTLE SECTION",
    "104B": "MYANMAR SIGN SECTION",
    "104C": "MYANMAR SYMBOL LOCATIVE",
    "104D": "MYANMAR SYMBOL COMPLETED",
    "104E": "MYANMAR SYMBOL AFOREMENTIONED",
    "104F": "MYANMAR SYMBOL GENITIVE",
    "1050": "MYANMAR LETTER SHA",
    "1051": "MYANMAR LETTER SSA",
    "1052": "MYANMAR LETTER VOCALIC R",
    "1053": "MYANMAR LETTER VOCALIC RR",
    "1054": "MYANMAR LETTER VOCALIC L",
    "1055": "MYANMAR LETTER VOCALIC LL",
    "1056": "MYANMAR VOWEL SIGN VOCALIC R",
    "1057": "MYANMAR VOWEL SIGN VOCALIC RR",
    "1058": "MYANMAR VOWEL SIGN VOCALIC L",
    "1059": "MYANMAR VOWEL SIGN VOCALIC LL",
    "105A": "MYANMAR LETTER MON NGA",
    "105B": "MYANMAR LETTER MON JHA",
    "105C": "MYANMAR LETTER MON BBA",
    "105D": "MYANMAR LETTER MON BBE",
    "105E": "MYANMAR CONSONANT SIGN MON MEDIAL NA",
    "105F": "MYANMAR CONSONANT SIGN MON MEDIAL MA",
    "1060": "MYANMAR CONSONANT SIGN MON MEDIAL LA",
    "1061": "MYANMAR LETTER SGAW KAREN SHA",
    "1062": "MYANMAR VOWEL SIGN SGAW KAREN EU",
    "1063": "MYANMAR TONE MARK SGAW KAREN HATHI",
    "1064": "MYANMAR TONE MARK SGAW KAREN KE PHO",
    "1065": "MYANMAR LETTER WESTERN PWO KAREN THA",
    "1066": "MYANMAR LETTER WESTERN PWO KAREN PWA",
    "1067": "MYANMAR VOWEL SIGN WESTERN PWO KAREN EU",
    "1068": "MYANMAR VOWEL SIGN WESTERN PWO KAREN UE",
    "1069": "MYANMAR SIGN WESTERN PWO KAREN TONE-1",
    "106A": "MYANMAR SIGN WESTERN PWO KAREN TONE-2",
    "106B": "MYANMAR SIGN WESTERN PWO KAREN TONE-3",
    "106C": "MYANMAR SIGN WESTERN PWO KAREN TONE-4",
    "106D": "MYANMAR SIGN WESTERN PWO KAREN TONE-5",
    "106E": "MYANMAR LETTER EASTERN PWO KAREN NNA",
    "106F": "MYANMAR LETTER EASTERN PWO KAREN YWA",
    "1070": "MYANMAR LETTER EASTERN PWO KAREN GHWA",
    "1071": "MYANMAR VOWEL SIGN GEBA KAREN I",
    "1072": "MYANMAR VOWEL SIGN KAYAH OE",
    "1073": "MYANMAR VOWEL SIGN KAYAH U",
    "1074": "MYANMAR VOWEL SIGN KAYAH EE",
    "1075": "MYANMAR LETTER SHAN KA",
    "1076": "MYANMAR LETTER SHAN KHA",
    "1077": "MYANMAR LETTER SHAN GA",
    "1078": "MYANMAR LETTER SHAN CA",
    "1079": "MYANMAR LETTER SHAN ZA",
    "107A": "MYANMAR LETTER SHAN NYA",
    "107B": "MYANMAR LETTER SHAN DA",
    "107C": "MYANMAR LETTER SHAN NA",
    "107D": "MYANMAR LETTER SHAN PHA",
    "107E": "MYANMAR LETTER SHAN FA",
    "107F": "MYANMAR LETTER SHAN BA",
    "1080": "MYANMAR LETTER SHAN THA",
    "1081": "MYANMAR LETTER SHAN HA",
    "1082": "MYANMAR CONSONANT SIGN SHAN MEDIAL WA",
    "1083": "MYANMAR VOWEL SIGN SHAN AA",
    "1084": "MYANMAR VOWEL SIGN SHAN E",
    "1085": "MYANMAR VOWEL SIGN SHAN E ABOVE",
    "1086": "MYANMAR VOWEL SIGN SHAN FINAL Y",
    "1087": "MYANMAR SIGN SHAN TONE-2",
    "1088": "MYANMAR SIGN SHAN TONE-3",
    "1089": "MYANMAR SIGN SHAN TONE-5",
    "108A": "MYANMAR SIGN SHAN TONE-6",
    "108B": "MYANMAR SIGN SHAN COUNCIL TONE-2",
    "108C": "MYANMAR SIGN SHAN COUNCIL TONE-3",
    "108D": "MYANMAR SIGN SHAN COUNCIL EMPHATIC TONE",
    "108E": "MYANMAR LETTER RUMAI PALAUNG FA",
    "108F": "MYANMAR SIGN RUMAI PALAUNG TONE-5",
    "1090": "MYANMAR SHAN DIGIT ZERO",
    "1091": "MYANMAR SHAN DIGIT ONE",
    "1092": "MYANMAR SHAN DIGIT TWO",
    "1093": "MYANMAR SHAN DIGIT THREE",
    "1094": "MYANMAR SHAN DIGIT FOUR",
    "1095": "MYANMAR SHAN DIGIT FIVE",
    "1096": "MYANMAR SHAN DIGIT SIX",
    "1097": "MYANMAR SHAN DIGIT SEVEN",
    "1098": "MYANMAR SHAN DIGIT EIGHT",
    "1099": "MYANMAR SHAN DIGIT NINE",
    "109A": "MYANMAR SIGN KHAMTI TONE-1",
    "109B": "MYANMAR SIGN KHAMTI TONE-3",
    "109C": "MYANMAR VOWEL SIGN AITON A",
    "109D": "MYANMAR VOWEL SIGN AITON AI",
    "109E": "MYANMAR SYMBOL SHAN ONE",
    "109F": "MYANMAR SYMBOL SHAN EXCLAMATION",
    "10A0": "GEORGIAN CAPITAL LETTER AN",
    "10A1": "GEORGIAN CAPITAL LETTER BAN",
    "10A2": "GEORGIAN CAPITAL LETTER GAN",
    "10A3": "GEORGIAN CAPITAL LETTER DON",
    "10A4": "GEORGIAN CAPITAL LETTER EN",
    "10A5": "GEORGIAN CAPITAL LETTER VIN",
    "10A6": "GEORGIAN CAPITAL LETTER ZEN",
    "10A7": "GEORGIAN CAPITAL LETTER TAN",
    "10A8": "GEORGIAN CAPITAL LETTER IN",
    "10A9": "GEORGIAN CAPITAL LETTER KAN",
    "10AA": "GEORGIAN CAPITAL LETTER LAS",
    "10AB": "GEORGIAN CAPITAL LETTER MAN",
    "10AC": "GEORGIAN CAPITAL LETTER NAR",
    "10AD": "GEORGIAN CAPITAL LETTER ON",
    "10AE": "GEORGIAN CAPITAL LETTER PAR",
    "10AF": "GEORGIAN CAPITAL LETTER ZHAR",
    "10B0": "GEORGIAN CAPITAL LETTER RAE",
    "10B1": "GEORGIAN CAPITAL LETTER SAN",
    "10B2": "GEORGIAN CAPITAL LETTER TAR",
    "10B3": "GEORGIAN CAPITAL LETTER UN",
    "10B4": "GEORGIAN CAPITAL LETTER PHAR",
    "10B5": "GEORGIAN CAPITAL LETTER KHAR",
    "10B6": "GEORGIAN CAPITAL LETTER GHAN",
    "10B7": "GEORGIAN CAPITAL LETTER QAR",
    "10B8": "GEORGIAN CAPITAL LETTER SHIN",
    "10B9": "GEORGIAN CAPITAL LETTER CHIN",
    "10BA": "GEORGIAN CAPITAL LETTER CAN",
    "10BB": "GEORGIAN CAPITAL LETTER JIL",
    "10BC": "GEORGIAN CAPITAL LETTER CIL",
    "10BD": "GEORGIAN CAPITAL LETTER CHAR",
    "10BE": "GEORGIAN CAPITAL LETTER XAN",
    "10BF": "GEORGIAN CAPITAL LETTER JHAN",
    "10C0": "GEORGIAN CAPITAL LETTER HAE",
    "10C1": "GEORGIAN CAPITAL LETTER HE",
    "10C2": "GEORGIAN CAPITAL LETTER HIE",
    "10C3": "GEORGIAN CAPITAL LETTER WE",
    "10C4": "GEORGIAN CAPITAL LETTER HAR",
    "10C5": "GEORGIAN CAPITAL LETTER HOE",
    "10C7": "GEORGIAN CAPITAL LETTER YN",
    "10CD": "GEORGIAN CAPITAL LETTER AEN",
    "10D0": "GEORGIAN LETTER AN",
    "10D1": "GEORGIAN LETTER BAN",
    "10D2": "GEORGIAN LETTER GAN",
    "10D3": "GEORGIAN LETTER DON",
    "10D4": "GEORGIAN LETTER EN",
    "10D5": "GEORGIAN LETTER VIN",
    "10D6": "GEORGIAN LETTER ZEN",
    "10D7": "GEORGIAN LETTER TAN",
    "10D8": "GEORGIAN LETTER IN",
    "10D9": "GEORGIAN LETTER KAN",
    "10DA": "GEORGIAN LETTER LAS",
    "10DB": "GEORGIAN LETTER MAN",
    "10DC": "GEORGIAN LETTER NAR",
    "10DD": "GEORGIAN LETTER ON",
    "10DE": "GEORGIAN LETTER PAR",
    "10DF": "GEORGIAN LETTER ZHAR",
    "10E0": "GEORGIAN LETTER RAE",
    "10E1": "GEORGIAN LETTER SAN",
    "10E2": "GEORGIAN LETTER TAR",
    "10E3": "GEORGIAN LETTER UN",
    "10E4": "GEORGIAN LETTER PHAR",
    "10E5": "GEORGIAN LETTER KHAR",
    "10E6": "GEORGIAN LETTER GHAN",
    "10E7": "GEORGIAN LETTER QAR",
    "10E8": "GEORGIAN LETTER SHIN",
    "10E9": "GEORGIAN LETTER CHIN",
    "10EA": "GEORGIAN LETTER CAN",
    "10EB": "GEORGIAN LETTER JIL",
    "10EC": "GEORGIAN LETTER CIL",
    "10ED": "GEORGIAN LETTER CHAR",
    "10EE": "GEORGIAN LETTER XAN",
    "10EF": "GEORGIAN LETTER JHAN",
    "10F0": "GEORGIAN LETTER HAE",
    "10F1": "GEORGIAN LETTER HE",
    "10F2": "GEORGIAN LETTER HIE",
    "10F3": "GEORGIAN LETTER WE",
    "10F4": "GEORGIAN LETTER HAR",
    "10F5": "GEORGIAN LETTER HOE",
    "10F6": "GEORGIAN LETTER FI",
    "10F7": "GEORGIAN LETTER YN",
    "10F8": "GEORGIAN LETTER ELIFI",
    "10F9": "GEORGIAN LETTER TURNED GAN",
    "10FA": "GEORGIAN LETTER AIN",
    "10FB": "GEORGIAN PARAGRAPH SEPARATOR",
    "10FC": "MODIFIER LETTER GEORGIAN NAR",
    "10FD": "GEORGIAN LETTER AEN",
    "10FE": "GEORGIAN LETTER HARD SIGN",
    "10FF": "GEORGIAN LETTER LABIAL SIGN",
    "1100": "HANGUL CHOSEONG KIYEOK",
    "1101": "HANGUL CHOSEONG SSANGKIYEOK",
    "1102": "HANGUL CHOSEONG NIEUN",
    "1103": "HANGUL CHOSEONG TIKEUT",
    "1104": "HANGUL CHOSEONG SSANGTIKEUT",
    "1105": "HANGUL CHOSEONG RIEUL",
    "1106": "HANGUL CHOSEONG MIEUM",
    "1107": "HANGUL CHOSEONG PIEUP",
    "1108": "HANGUL CHOSEONG SSANGPIEUP",
    "1109": "HANGUL CHOSEONG SIOS",
    "110A": "HANGUL CHOSEONG SSANGSIOS",
    "110B": "HANGUL CHOSEONG IEUNG",
    "110C": "HANGUL CHOSEONG CIEUC",
    "110D": "HANGUL CHOSEONG SSANGCIEUC",
    "110E": "HANGUL CHOSEONG CHIEUCH",
    "110F": "HANGUL CHOSEONG KHIEUKH",
    "1110": "HANGUL CHOSEONG THIEUTH",
    "1111": "HANGUL CHOSEONG PHIEUPH",
    "1112": "HANGUL CHOSEONG HIEUH",
    "1113": "HANGUL CHOSEONG NIEUN-KIYEOK",
    "1114": "HANGUL CHOSEONG SSANGNIEUN",
    "1115": "HANGUL CHOSEONG NIEUN-TIKEUT",
    "1116": "HANGUL CHOSEONG NIEUN-PIEUP",
    "1117": "HANGUL CHOSEONG TIKEUT-KIYEOK",
    "1118": "HANGUL CHOSEONG RIEUL-NIEUN",
    "1119": "HANGUL CHOSEONG SSANGRIEUL",
    "111A": "HANGUL CHOSEONG RIEUL-HIEUH",
    "111B": "HANGUL CHOSEONG KAPYEOUNRIEUL",
    "111C": "HANGUL CHOSEONG MIEUM-PIEUP",
    "111D": "HANGUL CHOSEONG KAPYEOUNMIEUM",
    "111E": "HANGUL CHOSEONG PIEUP-KIYEOK",
    "111F": "HANGUL CHOSEONG PIEUP-NIEUN",
    "1120": "HANGUL CHOSEONG PIEUP-TIKEUT",
    "1121": "HANGUL CHOSEONG PIEUP-SIOS",
    "1122": "HANGUL CHOSEONG PIEUP-SIOS-KIYEOK",
    "1123": "HANGUL CHOSEONG PIEUP-SIOS-TIKEUT",
    "1124": "HANGUL CHOSEONG PIEUP-SIOS-PIEUP",
    "1125": "HANGUL CHOSEONG PIEUP-SSANGSIOS",
    "1126": "HANGUL CHOSEONG PIEUP-SIOS-CIEUC",
    "1127": "HANGUL CHOSEONG PIEUP-CIEUC",
    "1128": "HANGUL CHOSEONG PIEUP-CHIEUCH",
    "1129": "HANGUL CHOSEONG PIEUP-THIEUTH",
    "112A": "HANGUL CHOSEONG PIEUP-PHIEUPH",
    "112B": "HANGUL CHOSEONG KAPYEOUNPIEUP",
    "112C": "HANGUL CHOSEONG KAPYEOUNSSANGPIEUP",
    "112D": "HANGUL CHOSEONG SIOS-KIYEOK",
    "112E": "HANGUL CHOSEONG SIOS-NIEUN",
    "112F": "HANGUL CHOSEONG SIOS-TIKEUT",
    "1130": "HANGUL CHOSEONG SIOS-RIEUL",
    "1131": "HANGUL CHOSEONG SIOS-MIEUM",
    "1132": "HANGUL CHOSEONG SIOS-PIEUP",
    "1133": "HANGUL CHOSEONG SIOS-PIEUP-KIYEOK",
    "1134": "HANGUL CHOSEONG SIOS-SSANGSIOS",
    "1135": "HANGUL CHOSEONG SIOS-IEUNG",
    "1136": "HANGUL CHOSEONG SIOS-CIEUC",
    "1137": "HANGUL CHOSEONG SIOS-CHIEUCH",
    "1138": "HANGUL CHOSEONG SIOS-KHIEUKH",
    "1139": "HANGUL CHOSEONG SIOS-THIEUTH",
    "113A": "HANGUL CHOSEONG SIOS-PHIEUPH",
    "113B": "HANGUL CHOSEONG SIOS-HIEUH",
    "113C": "HANGUL CHOSEONG CHITUEUMSIOS",
    "113D": "HANGUL CHOSEONG CHITUEUMSSANGSIOS",
    "113E": "HANGUL CHOSEONG CEONGCHIEUMSIOS",
    "113F": "HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS",
    "1140": "HANGUL CHOSEONG PANSIOS",
    "1141": "HANGUL CHOSEONG IEUNG-KIYEOK",
    "1142": "HANGUL CHOSEONG IEUNG-TIKEUT",
    "1143": "HANGUL CHOSEONG IEUNG-MIEUM",
    "1144": "HANGUL CHOSEONG IEUNG-PIEUP",
    "1145": "HANGUL CHOSEONG IEUNG-SIOS",
    "1146": "HANGUL CHOSEONG IEUNG-PANSIOS",
    "1147": "HANGUL CHOSEONG SSANGIEUNG",
    "1148": "HANGUL CHOSEONG IEUNG-CIEUC",
    "1149": "HANGUL CHOSEONG IEUNG-CHIEUCH",
    "114A": "HANGUL CHOSEONG IEUNG-THIEUTH",
    "114B": "HANGUL CHOSEONG IEUNG-PHIEUPH",
    "114C": "HANGUL CHOSEONG YESIEUNG",
    "114D": "HANGUL CHOSEONG CIEUC-IEUNG",
    "114E": "HANGUL CHOSEONG CHITUEUMCIEUC",
    "114F": "HANGUL CHOSEONG CHITUEUMSSANGCIEUC",
    "1150": "HANGUL CHOSEONG CEONGCHIEUMCIEUC",
    "1151": "HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC",
    "1152": "HANGUL CHOSEONG CHIEUCH-KHIEUKH",
    "1153": "HANGUL CHOSEONG CHIEUCH-HIEUH",
    "1154": "HANGUL CHOSEONG CHITUEUMCHIEUCH",
    "1155": "HANGUL CHOSEONG CEONGCHIEUMCHIEUCH",
    "1156": "HANGUL CHOSEONG PHIEUPH-PIEUP",
    "1157": "HANGUL CHOSEONG KAPYEOUNPHIEUPH",
    "1158": "HANGUL CHOSEONG SSANGHIEUH",
    "1159": "HANGUL CHOSEONG YEORINHIEUH",
    "115A": "HANGUL CHOSEONG KIYEOK-TIKEUT",
    "115B": "HANGUL CHOSEONG NIEUN-SIOS",
    "115C": "HANGUL CHOSEONG NIEUN-CIEUC",
    "115D": "HANGUL CHOSEONG NIEUN-HIEUH",
    "115E": "HANGUL CHOSEONG TIKEUT-RIEUL",
    "115F": "HANGUL CHOSEONG FILLER",
    "1160": "HANGUL JUNGSEONG FILLER",
    "1161": "HANGUL JUNGSEONG A",
    "1162": "HANGUL JUNGSEONG AE",
    "1163": "HANGUL JUNGSEONG YA",
    "1164": "HANGUL JUNGSEONG YAE",
    "1165": "HANGUL JUNGSEONG EO",
    "1166": "HANGUL JUNGSEONG E",
    "1167": "HANGUL JUNGSEONG YEO",
    "1168": "HANGUL JUNGSEONG YE",
    "1169": "HANGUL JUNGSEONG O",
    "116A": "HANGUL JUNGSEONG WA",
    "116B": "HANGUL JUNGSEONG WAE",
    "116C": "HANGUL JUNGSEONG OE",
    "116D": "HANGUL JUNGSEONG YO",
    "116E": "HANGUL JUNGSEONG U",
    "116F": "HANGUL JUNGSEONG WEO",
    "1170": "HANGUL JUNGSEONG WE",
    "1171": "HANGUL JUNGSEONG WI",
    "1172": "HANGUL JUNGSEONG YU",
    "1173": "HANGUL JUNGSEONG EU",
    "1174": "HANGUL JUNGSEONG YI",
    "1175": "HANGUL JUNGSEONG I",
    "1176": "HANGUL JUNGSEONG A-O",
    "1177": "HANGUL JUNGSEONG A-U",
    "1178": "HANGUL JUNGSEONG YA-O",
    "1179": "HANGUL JUNGSEONG YA-YO",
    "117A": "HANGUL JUNGSEONG EO-O",
    "117B": "HANGUL JUNGSEONG EO-U",
    "117C": "HANGUL JUNGSEONG EO-EU",
    "117D": "HANGUL JUNGSEONG YEO-O",
    "117E": "HANGUL JUNGSEONG YEO-U",
    "117F": "HANGUL JUNGSEONG O-EO",
    "1180": "HANGUL JUNGSEONG O-E",
    "1181": "HANGUL JUNGSEONG O-YE",
    "1182": "HANGUL JUNGSEONG O-O",
    "1183": "HANGUL JUNGSEONG O-U",
    "1184": "HANGUL JUNGSEONG YO-YA",
    "1185": "HANGUL JUNGSEONG YO-YAE",
    "1186": "HANGUL JUNGSEONG YO-YEO",
    "1187": "HANGUL JUNGSEONG YO-O",
    "1188": "HANGUL JUNGSEONG YO-I",
    "1189": "HANGUL JUNGSEONG U-A",
    "118A": "HANGUL JUNGSEONG U-AE",
    "118B": "HANGUL JUNGSEONG U-EO-EU",
    "118C": "HANGUL JUNGSEONG U-YE",
    "118D": "HANGUL JUNGSEONG U-U",
    "118E": "HANGUL JUNGSEONG YU-A",
    "118F": "HANGUL JUNGSEONG YU-EO",
    "1190": "HANGUL JUNGSEONG YU-E",
    "1191": "HANGUL JUNGSEONG YU-YEO",
    "1192": "HANGUL JUNGSEONG YU-YE",
    "1193": "HANGUL JUNGSEONG YU-U",
    "1194": "HANGUL JUNGSEONG YU-I",
    "1195": "HANGUL JUNGSEONG EU-U",
    "1196": "HANGUL JUNGSEONG EU-EU",
    "1197": "HANGUL JUNGSEONG YI-U",
    "1198": "HANGUL JUNGSEONG I-A",
    "1199": "HANGUL JUNGSEONG I-YA",
    "119A": "HANGUL JUNGSEONG I-O",
    "119B": "HANGUL JUNGSEONG I-U",
    "119C": "HANGUL JUNGSEONG I-EU",
    "119D": "HANGUL JUNGSEONG I-ARAEA",
    "119E": "HANGUL JUNGSEONG ARAEA",
    "119F": "HANGUL JUNGSEONG ARAEA-EO",
    "11A0": "HANGUL JUNGSEONG ARAEA-U",
    "11A1": "HANGUL JUNGSEONG ARAEA-I",
    "11A2": "HANGUL JUNGSEONG SSANGARAEA",
    "11A3": "HANGUL JUNGSEONG A-EU",
    "11A4": "HANGUL JUNGSEONG YA-U",
    "11A5": "HANGUL JUNGSEONG YEO-YA",
    "11A6": "HANGUL JUNGSEONG O-YA",
    "11A7": "HANGUL JUNGSEONG O-YAE",
    "11A8": "HANGUL JONGSEONG KIYEOK",
    "11A9": "HANGUL JONGSEONG SSANGKIYEOK",
    "11AA": "HANGUL JONGSEONG KIYEOK-SIOS",
    "11AB": "HANGUL JONGSEONG NIEUN",
    "11AC": "HANGUL JONGSEONG NIEUN-CIEUC",
    "11AD": "HANGUL JONGSEONG NIEUN-HIEUH",
    "11AE": "HANGUL JONGSEONG TIKEUT",
    "11AF": "HANGUL JONGSEONG RIEUL",
    "11B0": "HANGUL JONGSEONG RIEUL-KIYEOK",
    "11B1": "HANGUL JONGSEONG RIEUL-MIEUM",
    "11B2": "HANGUL JONGSEONG RIEUL-PIEUP",
    "11B3": "HANGUL JONGSEONG RIEUL-SIOS",
    "11B4": "HANGUL JONGSEONG RIEUL-THIEUTH",
    "11B5": "HANGUL JONGSEONG RIEUL-PHIEUPH",
    "11B6": "HANGUL JONGSEONG RIEUL-HIEUH",
    "11B7": "HANGUL JONGSEONG MIEUM",
    "11B8": "HANGUL JONGSEONG PIEUP",
    "11B9": "HANGUL JONGSEONG PIEUP-SIOS",
    "11BA": "HANGUL JONGSEONG SIOS",
    "11BB": "HANGUL JONGSEONG SSANGSIOS",
    "11BC": "HANGUL JONGSEONG IEUNG",
    "11BD": "HANGUL JONGSEONG CIEUC",
    "11BE": "HANGUL JONGSEONG CHIEUCH",
    "11BF": "HANGUL JONGSEONG KHIEUKH",
    "11C0": "HANGUL JONGSEONG THIEUTH",
    "11C1": "HANGUL JONGSEONG PHIEUPH",
    "11C2": "HANGUL JONGSEONG HIEUH",
    "11C3": "HANGUL JONGSEONG KIYEOK-RIEUL",
    "11C4": "HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK",
    "11C5": "HANGUL JONGSEONG NIEUN-KIYEOK",
    "11C6": "HANGUL JONGSEONG NIEUN-TIKEUT",
    "11C7": "HANGUL JONGSEONG NIEUN-SIOS",
    "11C8": "HANGUL JONGSEONG NIEUN-PANSIOS",
    "11C9": "HANGUL JONGSEONG NIEUN-THIEUTH",
    "11CA": "HANGUL JONGSEONG TIKEUT-KIYEOK",
    "11CB": "HANGUL JONGSEONG TIKEUT-RIEUL",
    "11CC": "HANGUL JONGSEONG RIEUL-KIYEOK-SIOS",
    "11CD": "HANGUL JONGSEONG RIEUL-NIEUN",
    "11CE": "HANGUL JONGSEONG RIEUL-TIKEUT",
    "11CF": "HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH",
    "11D0": "HANGUL JONGSEONG SSANGRIEUL",
    "11D1": "HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK",
    "11D2": "HANGUL JONGSEONG RIEUL-MIEUM-SIOS",
    "11D3": "HANGUL JONGSEONG RIEUL-PIEUP-SIOS",
    "11D4": "HANGUL JONGSEONG RIEUL-PIEUP-HIEUH",
    "11D5": "HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP",
    "11D6": "HANGUL JONGSEONG RIEUL-SSANGSIOS",
    "11D7": "HANGUL JONGSEONG RIEUL-PANSIOS",
    "11D8": "HANGUL JONGSEONG RIEUL-KHIEUKH",
    "11D9": "HANGUL JONGSEONG RIEUL-YEORINHIEUH",
    "11DA": "HANGUL JONGSEONG MIEUM-KIYEOK",
    "11DB": "HANGUL JONGSEONG MIEUM-RIEUL",
    "11DC": "HANGUL JONGSEONG MIEUM-PIEUP",
    "11DD": "HANGUL JONGSEONG MIEUM-SIOS",
    "11DE": "HANGUL JONGSEONG MIEUM-SSANGSIOS",
    "11DF": "HANGUL JONGSEONG MIEUM-PANSIOS",
    "11E0": "HANGUL JONGSEONG MIEUM-CHIEUCH",
    "11E1": "HANGUL JONGSEONG MIEUM-HIEUH",
    "11E2": "HANGUL JONGSEONG KAPYEOUNMIEUM",
    "11E3": "HANGUL JONGSEONG PIEUP-RIEUL",
    "11E4": "HANGUL JONGSEONG PIEUP-PHIEUPH",
    "11E5": "HANGUL JONGSEONG PIEUP-HIEUH",
    "11E6": "HANGUL JONGSEONG KAPYEOUNPIEUP",
    "11E7": "HANGUL JONGSEONG SIOS-KIYEOK",
    "11E8": "HANGUL JONGSEONG SIOS-TIKEUT",
    "11E9": "HANGUL JONGSEONG SIOS-RIEUL",
    "11EA": "HANGUL JONGSEONG SIOS-PIEUP",
    "11EB": "HANGUL JONGSEONG PANSIOS",
    "11EC": "HANGUL JONGSEONG IEUNG-KIYEOK",
    "11ED": "HANGUL JONGSEONG IEUNG-SSANGKIYEOK",
    "11EE": "HANGUL JONGSEONG SSANGIEUNG",
    "11EF": "HANGUL JONGSEONG IEUNG-KHIEUKH",
    "11F0": "HANGUL JONGSEONG YESIEUNG",
    "11F1": "HANGUL JONGSEONG YESIEUNG-SIOS",
    "11F2": "HANGUL JONGSEONG YESIEUNG-PANSIOS",
    "11F3": "HANGUL JONGSEONG PHIEUPH-PIEUP",
    "11F4": "HANGUL JONGSEONG KAPYEOUNPHIEUPH",
    "11F5": "HANGUL JONGSEONG HIEUH-NIEUN",
    "11F6": "HANGUL JONGSEONG HIEUH-RIEUL",
    "11F7": "HANGUL JONGSEONG HIEUH-MIEUM",
    "11F8": "HANGUL JONGSEONG HIEUH-PIEUP",
    "11F9": "HANGUL JONGSEONG YEORINHIEUH",
    "11FA": "HANGUL JONGSEONG KIYEOK-NIEUN",
    "11FB": "HANGUL JONGSEONG KIYEOK-PIEUP",
    "11FC": "HANGUL JONGSEONG KIYEOK-CHIEUCH",
    "11FD": "HANGUL JONGSEONG KIYEOK-KHIEUKH",
    "11FE": "HANGUL JONGSEONG KIYEOK-HIEUH",
    "11FF": "HANGUL JONGSEONG SSANGNIEUN",
    "1200": "ETHIOPIC SYLLABLE HA",
    "1201": "ETHIOPIC SYLLABLE HU",
    "1202": "ETHIOPIC SYLLABLE HI",
    "1203": "ETHIOPIC SYLLABLE HAA",
    "1204": "ETHIOPIC SYLLABLE HEE",
    "1205": "ETHIOPIC SYLLABLE HE",
    "1206": "ETHIOPIC SYLLABLE HO",
    "1207": "ETHIOPIC SYLLABLE HOA",
    "1208": "ETHIOPIC SYLLABLE LA",
    "1209": "ETHIOPIC SYLLABLE LU",
    "120A": "ETHIOPIC SYLLABLE LI",
    "120B": "ETHIOPIC SYLLABLE LAA",
    "120C": "ETHIOPIC SYLLABLE LEE",
    "120D": "ETHIOPIC SYLLABLE LE",
    "120E": "ETHIOPIC SYLLABLE LO",
    "120F": "ETHIOPIC SYLLABLE LWA",
    "1210": "ETHIOPIC SYLLABLE HHA",
    "1211": "ETHIOPIC SYLLABLE HHU",
    "1212": "ETHIOPIC SYLLABLE HHI",
    "1213": "ETHIOPIC SYLLABLE HHAA",
    "1214": "ETHIOPIC SYLLABLE HHEE",
    "1215": "ETHIOPIC SYLLABLE HHE",
    "1216": "ETHIOPIC SYLLABLE HHO",
    "1217": "ETHIOPIC SYLLABLE HHWA",
    "1218": "ETHIOPIC SYLLABLE MA",
    "1219": "ETHIOPIC SYLLABLE MU",
    "121A": "ETHIOPIC SYLLABLE MI",
    "121B": "ETHIOPIC SYLLABLE MAA",
    "121C": "ETHIOPIC SYLLABLE MEE",
    "121D": "ETHIOPIC SYLLABLE ME",
    "121E": "ETHIOPIC SYLLABLE MO",
    "121F": "ETHIOPIC SYLLABLE MWA",
    "1220": "ETHIOPIC SYLLABLE SZA",
    "1221": "ETHIOPIC SYLLABLE SZU",
    "1222": "ETHIOPIC SYLLABLE SZI",
    "1223": "ETHIOPIC SYLLABLE SZAA",
    "1224": "ETHIOPIC SYLLABLE SZEE",
    "1225": "ETHIOPIC SYLLABLE SZE",
    "1226": "ETHIOPIC SYLLABLE SZO",
    "1227": "ETHIOPIC SYLLABLE SZWA",
    "1228": "ETHIOPIC SYLLABLE RA",
    "1229": "ETHIOPIC SYLLABLE RU",
    "122A": "ETHIOPIC SYLLABLE RI",
    "122B": "ETHIOPIC SYLLABLE RAA",
    "122C": "ETHIOPIC SYLLABLE REE",
    "122D": "ETHIOPIC SYLLABLE RE",
    "122E": "ETHIOPIC SYLLABLE RO",
    "122F": "ETHIOPIC SYLLABLE RWA",
    "1230": "ETHIOPIC SYLLABLE SA",
    "1231": "ETHIOPIC SYLLABLE SU",
    "1232": "ETHIOPIC SYLLABLE SI",
    "1233": "ETHIOPIC SYLLABLE SAA",
    "1234": "ETHIOPIC SYLLABLE SEE",
    "1235": "ETHIOPIC SYLLABLE SE",
    "1236": "ETHIOPIC SYLLABLE SO",
    "1237": "ETHIOPIC SYLLABLE SWA",
    "1238": "ETHIOPIC SYLLABLE SHA",
    "1239": "ETHIOPIC SYLLABLE SHU",
    "123A": "ETHIOPIC SYLLABLE SHI",
    "123B": "ETHIOPIC SYLLABLE SHAA",
    "123C": "ETHIOPIC SYLLABLE SHEE",
    "123D": "ETHIOPIC SYLLABLE SHE",
    "123E": "ETHIOPIC SYLLABLE SHO",
    "123F": "ETHIOPIC SYLLABLE SHWA",
    "1240": "ETHIOPIC SYLLABLE QA",
    "1241": "ETHIOPIC SYLLABLE QU",
    "1242": "ETHIOPIC SYLLABLE QI",
    "1243": "ETHIOPIC SYLLABLE QAA",
    "1244": "ETHIOPIC SYLLABLE QEE",
    "1245": "ETHIOPIC SYLLABLE QE",
    "1246": "ETHIOPIC SYLLABLE QO",
    "1247": "ETHIOPIC SYLLABLE QOA",
    "1248": "ETHIOPIC SYLLABLE QWA",
    "124A": "ETHIOPIC SYLLABLE QWI",
    "124B": "ETHIOPIC SYLLABLE QWAA",
    "124C": "ETHIOPIC SYLLABLE QWEE",
    "124D": "ETHIOPIC SYLLABLE QWE",
    "1250": "ETHIOPIC SYLLABLE QHA",
    "1251": "ETHIOPIC SYLLABLE QHU",
    "1252": "ETHIOPIC SYLLABLE QHI",
    "1253": "ETHIOPIC SYLLABLE QHAA",
    "1254": "ETHIOPIC SYLLABLE QHEE",
    "1255": "ETHIOPIC SYLLABLE QHE",
    "1256": "ETHIOPIC SYLLABLE QHO",
    "1258": "ETHIOPIC SYLLABLE QHWA",
    "125A": "ETHIOPIC SYLLABLE QHWI",
    "125B": "ETHIOPIC SYLLABLE QHWAA",
    "125C": "ETHIOPIC SYLLABLE QHWEE",
    "125D": "ETHIOPIC SYLLABLE QHWE",
    "1260": "ETHIOPIC SYLLABLE BA",
    "1261": "ETHIOPIC SYLLABLE BU",
    "1262": "ETHIOPIC SYLLABLE BI",
    "1263": "ETHIOPIC SYLLABLE BAA",
    "1264": "ETHIOPIC SYLLABLE BEE",
    "1265": "ETHIOPIC SYLLABLE BE",
    "1266": "ETHIOPIC SYLLABLE BO",
    "1267": "ETHIOPIC SYLLABLE BWA",
    "1268": "ETHIOPIC SYLLABLE VA",
    "1269": "ETHIOPIC SYLLABLE VU",
    "126A": "ETHIOPIC SYLLABLE VI",
    "126B": "ETHIOPIC SYLLABLE VAA",
    "126C": "ETHIOPIC SYLLABLE VEE",
    "126D": "ETHIOPIC SYLLABLE VE",
    "126E": "ETHIOPIC SYLLABLE VO",
    "126F": "ETHIOPIC SYLLABLE VWA",
    "1270": "ETHIOPIC SYLLABLE TA",
    "1271": "ETHIOPIC SYLLABLE TU",
    "1272": "ETHIOPIC SYLLABLE TI",
    "1273": "ETHIOPIC SYLLABLE TAA",
    "1274": "ETHIOPIC SYLLABLE TEE",
    "1275": "ETHIOPIC SYLLABLE TE",
    "1276": "ETHIOPIC SYLLABLE TO",
    "1277": "ETHIOPIC SYLLABLE TWA",
    "1278": "ETHIOPIC SYLLABLE CA",
    "1279": "ETHIOPIC SYLLABLE CU",
    "127A": "ETHIOPIC SYLLABLE CI",
    "127B": "ETHIOPIC SYLLABLE CAA",
    "127C": "ETHIOPIC SYLLABLE CEE",
    "127D": "ETHIOPIC SYLLABLE CE",
    "127E": "ETHIOPIC SYLLABLE CO",
    "127F": "ETHIOPIC SYLLABLE CWA",
    "1280": "ETHIOPIC SYLLABLE XA",
    "1281": "ETHIOPIC SYLLABLE XU",
    "1282": "ETHIOPIC SYLLABLE XI",
    "1283": "ETHIOPIC SYLLABLE XAA",
    "1284": "ETHIOPIC SYLLABLE XEE",
    "1285": "ETHIOPIC SYLLABLE XE",
    "1286": "ETHIOPIC SYLLABLE XO",
    "1287": "ETHIOPIC SYLLABLE XOA",
    "1288": "ETHIOPIC SYLLABLE XWA",
    "128A": "ETHIOPIC SYLLABLE XWI",
    "128B": "ETHIOPIC SYLLABLE XWAA",
    "128C": "ETHIOPIC SYLLABLE XWEE",
    "128D": "ETHIOPIC SYLLABLE XWE",
    "1290": "ETHIOPIC SYLLABLE NA",
    "1291": "ETHIOPIC SYLLABLE NU",
    "1292": "ETHIOPIC SYLLABLE NI",
    "1293": "ETHIOPIC SYLLABLE NAA",
    "1294": "ETHIOPIC SYLLABLE NEE",
    "1295": "ETHIOPIC SYLLABLE NE",
    "1296": "ETHIOPIC SYLLABLE NO",
    "1297": "ETHIOPIC SYLLABLE NWA",
    "1298": "ETHIOPIC SYLLABLE NYA",
    "1299": "ETHIOPIC SYLLABLE NYU",
    "129A": "ETHIOPIC SYLLABLE NYI",
    "129B": "ETHIOPIC SYLLABLE NYAA",
    "129C": "ETHIOPIC SYLLABLE NYEE",
    "129D": "ETHIOPIC SYLLABLE NYE",
    "129E": "ETHIOPIC SYLLABLE NYO",
    "129F": "ETHIOPIC SYLLABLE NYWA",
    "12A0": "ETHIOPIC SYLLABLE GLOTTAL A",
    "12A1": "ETHIOPIC SYLLABLE GLOTTAL U",
    "12A2": "ETHIOPIC SYLLABLE GLOTTAL I",
    "12A3": "ETHIOPIC SYLLABLE GLOTTAL AA",
    "12A4": "ETHIOPIC SYLLABLE GLOTTAL EE",
    "12A5": "ETHIOPIC SYLLABLE GLOTTAL E",
    "12A6": "ETHIOPIC SYLLABLE GLOTTAL O",
    "12A7": "ETHIOPIC SYLLABLE GLOTTAL WA",
    "12A8": "ETHIOPIC SYLLABLE KA",
    "12A9": "ETHIOPIC SYLLABLE KU",
    "12AA": "ETHIOPIC SYLLABLE KI",
    "12AB": "ETHIOPIC SYLLABLE KAA",
    "12AC": "ETHIOPIC SYLLABLE KEE",
    "12AD": "ETHIOPIC SYLLABLE KE",
    "12AE": "ETHIOPIC SYLLABLE KO",
    "12AF": "ETHIOPIC SYLLABLE KOA",
    "12B0": "ETHIOPIC SYLLABLE KWA",
    "12B2": "ETHIOPIC SYLLABLE KWI",
    "12B3": "ETHIOPIC SYLLABLE KWAA",
    "12B4": "ETHIOPIC SYLLABLE KWEE",
    "12B5": "ETHIOPIC SYLLABLE KWE",
    "12B8": "ETHIOPIC SYLLABLE KXA",
    "12B9": "ETHIOPIC SYLLABLE KXU",
    "12BA": "ETHIOPIC SYLLABLE KXI",
    "12BB": "ETHIOPIC SYLLABLE KXAA",
    "12BC": "ETHIOPIC SYLLABLE KXEE",
    "12BD": "ETHIOPIC SYLLABLE KXE",
    "12BE": "ETHIOPIC SYLLABLE KXO",
    "12C0": "ETHIOPIC SYLLABLE KXWA",
    "12C2": "ETHIOPIC SYLLABLE KXWI",
    "12C3": "ETHIOPIC SYLLABLE KXWAA",
    "12C4": "ETHIOPIC SYLLABLE KXWEE",
    "12C5": "ETHIOPIC SYLLABLE KXWE",
    "12C8": "ETHIOPIC SYLLABLE WA",
    "12C9": "ETHIOPIC SYLLABLE WU",
    "12CA": "ETHIOPIC SYLLABLE WI",
    "12CB": "ETHIOPIC SYLLABLE WAA",
    "12CC": "ETHIOPIC SYLLABLE WEE",
    "12CD": "ETHIOPIC SYLLABLE WE",
    "12CE": "ETHIOPIC SYLLABLE WO",
    "12CF": "ETHIOPIC SYLLABLE WOA",
    "12D0": "ETHIOPIC SYLLABLE PHARYNGEAL A",
    "12D1": "ETHIOPIC SYLLABLE PHARYNGEAL U",
    "12D2": "ETHIOPIC SYLLABLE PHARYNGEAL I",
    "12D3": "ETHIOPIC SYLLABLE PHARYNGEAL AA",
    "12D4": "ETHIOPIC SYLLABLE PHARYNGEAL EE",
    "12D5": "ETHIOPIC SYLLABLE PHARYNGEAL E",
    "12D6": "ETHIOPIC SYLLABLE PHARYNGEAL O",
    "12D8": "ETHIOPIC SYLLABLE ZA",
    "12D9": "ETHIOPIC SYLLABLE ZU",
    "12DA": "ETHIOPIC SYLLABLE ZI",
    "12DB": "ETHIOPIC SYLLABLE ZAA",
    "12DC": "ETHIOPIC SYLLABLE ZEE",
    "12DD": "ETHIOPIC SYLLABLE ZE",
    "12DE": "ETHIOPIC SYLLABLE ZO",
    "12DF": "ETHIOPIC SYLLABLE ZWA",
    "12E0": "ETHIOPIC SYLLABLE ZHA",
    "12E1": "ETHIOPIC SYLLABLE ZHU",
    "12E2": "ETHIOPIC SYLLABLE ZHI",
    "12E3": "ETHIOPIC SYLLABLE ZHAA",
    "12E4": "ETHIOPIC SYLLABLE ZHEE",
    "12E5": "ETHIOPIC SYLLABLE ZHE",
    "12E6": "ETHIOPIC SYLLABLE ZHO",
    "12E7": "ETHIOPIC SYLLABLE ZHWA",
    "12E8": "ETHIOPIC SYLLABLE YA",
    "12E9": "ETHIOPIC SYLLABLE YU",
    "12EA": "ETHIOPIC SYLLABLE YI",
    "12EB": "ETHIOPIC SYLLABLE YAA",
    "12EC": "ETHIOPIC SYLLABLE YEE",
    "12ED": "ETHIOPIC SYLLABLE YE",
    "12EE": "ETHIOPIC SYLLABLE YO",
    "12EF": "ETHIOPIC SYLLABLE YOA",
    "12F0": "ETHIOPIC SYLLABLE DA",
    "12F1": "ETHIOPIC SYLLABLE DU",
    "12F2": "ETHIOPIC SYLLABLE DI",
    "12F3": "ETHIOPIC SYLLABLE DAA",
    "12F4": "ETHIOPIC SYLLABLE DEE",
    "12F5": "ETHIOPIC SYLLABLE DE",
    "12F6": "ETHIOPIC SYLLABLE DO",
    "12F7": "ETHIOPIC SYLLABLE DWA",
    "12F8": "ETHIOPIC SYLLABLE DDA",
    "12F9": "ETHIOPIC SYLLABLE DDU",
    "12FA": "ETHIOPIC SYLLABLE DDI",
    "12FB": "ETHIOPIC SYLLABLE DDAA",
    "12FC": "ETHIOPIC SYLLABLE DDEE",
    "12FD": "ETHIOPIC SYLLABLE DDE",
    "12FE": "ETHIOPIC SYLLABLE DDO",
    "12FF": "ETHIOPIC SYLLABLE DDWA",
    "1300": "ETHIOPIC SYLLABLE JA",
    "1301": "ETHIOPIC SYLLABLE JU",
    "1302": "ETHIOPIC SYLLABLE JI",
    "1303": "ETHIOPIC SYLLABLE JAA",
    "1304": "ETHIOPIC SYLLABLE JEE",
    "1305": "ETHIOPIC SYLLABLE JE",
    "1306": "ETHIOPIC SYLLABLE JO",
    "1307": "ETHIOPIC SYLLABLE JWA",
    "1308": "ETHIOPIC SYLLABLE GA",
    "1309": "ETHIOPIC SYLLABLE GU",
    "130A": "ETHIOPIC SYLLABLE GI",
    "130B": "ETHIOPIC SYLLABLE GAA",
    "130C": "ETHIOPIC SYLLABLE GEE",
    "130D": "ETHIOPIC SYLLABLE GE",
    "130E": "ETHIOPIC SYLLABLE GO",
    "130F": "ETHIOPIC SYLLABLE GOA",
    "1310": "ETHIOPIC SYLLABLE GWA",
    "1312": "ETHIOPIC SYLLABLE GWI",
    "1313": "ETHIOPIC SYLLABLE GWAA",
    "1314": "ETHIOPIC SYLLABLE GWEE",
    "1315": "ETHIOPIC SYLLABLE GWE",
    "1318": "ETHIOPIC SYLLABLE GGA",
    "1319": "ETHIOPIC SYLLABLE GGU",
    "131A": "ETHIOPIC SYLLABLE GGI",
    "131B": "ETHIOPIC SYLLABLE GGAA",
    "131C": "ETHIOPIC SYLLABLE GGEE",
    "131D": "ETHIOPIC SYLLABLE GGE",
    "131E": "ETHIOPIC SYLLABLE GGO",
    "131F": "ETHIOPIC SYLLABLE GGWAA",
    "1320": "ETHIOPIC SYLLABLE THA",
    "1321": "ETHIOPIC SYLLABLE THU",
    "1322": "ETHIOPIC SYLLABLE THI",
    "1323": "ETHIOPIC SYLLABLE THAA",
    "1324": "ETHIOPIC SYLLABLE THEE",
    "1325": "ETHIOPIC SYLLABLE THE",
    "1326": "ETHIOPIC SYLLABLE THO",
    "1327": "ETHIOPIC SYLLABLE THWA",
    "1328": "ETHIOPIC SYLLABLE CHA",
    "1329": "ETHIOPIC SYLLABLE CHU",
    "132A": "ETHIOPIC SYLLABLE CHI",
    "132B": "ETHIOPIC SYLLABLE CHAA",
    "132C": "ETHIOPIC SYLLABLE CHEE",
    "132D": "ETHIOPIC SYLLABLE CHE",
    "132E": "ETHIOPIC SYLLABLE CHO",
    "132F": "ETHIOPIC SYLLABLE CHWA",
    "1330": "ETHIOPIC SYLLABLE PHA",
    "1331": "ETHIOPIC SYLLABLE PHU",
    "1332": "ETHIOPIC SYLLABLE PHI",
    "1333": "ETHIOPIC SYLLABLE PHAA",
    "1334": "ETHIOPIC SYLLABLE PHEE",
    "1335": "ETHIOPIC SYLLABLE PHE",
    "1336": "ETHIOPIC SYLLABLE PHO",
    "1337": "ETHIOPIC SYLLABLE PHWA",
    "1338": "ETHIOPIC SYLLABLE TSA",
    "1339": "ETHIOPIC SYLLABLE TSU",
    "133A": "ETHIOPIC SYLLABLE TSI",
    "133B": "ETHIOPIC SYLLABLE TSAA",
    "133C": "ETHIOPIC SYLLABLE TSEE",
    "133D": "ETHIOPIC SYLLABLE TSE",
    "133E": "ETHIOPIC SYLLABLE TSO",
    "133F": "ETHIOPIC SYLLABLE TSWA",
    "1340": "ETHIOPIC SYLLABLE TZA",
    "1341": "ETHIOPIC SYLLABLE TZU",
    "1342": "ETHIOPIC SYLLABLE TZI",
    "1343": "ETHIOPIC SYLLABLE TZAA",
    "1344": "ETHIOPIC SYLLABLE TZEE",
    "1345": "ETHIOPIC SYLLABLE TZE",
    "1346": "ETHIOPIC SYLLABLE TZO",
    "1347": "ETHIOPIC SYLLABLE TZOA",
    "1348": "ETHIOPIC SYLLABLE FA",
    "1349": "ETHIOPIC SYLLABLE FU",
    "134A": "ETHIOPIC SYLLABLE FI",
    "134B": "ETHIOPIC SYLLABLE FAA",
    "134C": "ETHIOPIC SYLLABLE FEE",
    "134D": "ETHIOPIC SYLLABLE FE",
    "134E": "ETHIOPIC SYLLABLE FO",
    "134F": "ETHIOPIC SYLLABLE FWA",
    "1350": "ETHIOPIC SYLLABLE PA",
    "1351": "ETHIOPIC SYLLABLE PU",
    "1352": "ETHIOPIC SYLLABLE PI",
    "1353": "ETHIOPIC SYLLABLE PAA",
    "1354": "ETHIOPIC SYLLABLE PEE",
    "1355": "ETHIOPIC SYLLABLE PE",
    "1356": "ETHIOPIC SYLLABLE PO",
    "1357": "ETHIOPIC SYLLABLE PWA",
    "1358": "ETHIOPIC SYLLABLE RYA",
    "1359": "ETHIOPIC SYLLABLE MYA",
    "135A": "ETHIOPIC SYLLABLE FYA",
    "135D": "ETHIOPIC COMBINING GEMINATION AND VOWEL LENGTH MARK",
    "135E": "ETHIOPIC COMBINING VOWEL LENGTH MARK",
    "135F": "ETHIOPIC COMBINING GEMINATION MARK",
    "1360": "ETHIOPIC SECTION MARK",
    "1361": "ETHIOPIC WORDSPACE",
    "1362": "ETHIOPIC FULL STOP",
    "1363": "ETHIOPIC COMMA",
    "1364": "ETHIOPIC SEMICOLON",
    "1365": "ETHIOPIC COLON",
    "1366": "ETHIOPIC PREFACE COLON",
    "1367": "ETHIOPIC QUESTION MARK",
    "1368": "ETHIOPIC PARAGRAPH SEPARATOR",
    "1369": "ETHIOPIC DIGIT ONE",
    "136A": "ETHIOPIC DIGIT TWO",
    "136B": "ETHIOPIC DIGIT THREE",
    "136C": "ETHIOPIC DIGIT FOUR",
    "136D": "ETHIOPIC DIGIT FIVE",
    "136E": "ETHIOPIC DIGIT SIX",
    "136F": "ETHIOPIC DIGIT SEVEN",
    "1370": "ETHIOPIC DIGIT EIGHT",
    "1371": "ETHIOPIC DIGIT NINE",
    "1372": "ETHIOPIC NUMBER TEN",
    "1373": "ETHIOPIC NUMBER TWENTY",
    "1374": "ETHIOPIC NUMBER THIRTY",
    "1375": "ETHIOPIC NUMBER FORTY",
    "1376": "ETHIOPIC NUMBER FIFTY",
    "1377": "ETHIOPIC NUMBER SIXTY",
    "1378": "ETHIOPIC NUMBER SEVENTY",
    "1379": "ETHIOPIC NUMBER EIGHTY",
    "137A": "ETHIOPIC NUMBER NINETY",
    "137B": "ETHIOPIC NUMBER HUNDRED",
    "137C": "ETHIOPIC NUMBER TEN THOUSAND",
    "1380": "ETHIOPIC SYLLABLE SEBATBEIT MWA",
    "1381": "ETHIOPIC SYLLABLE MWI",
    "1382": "ETHIOPIC SYLLABLE MWEE",
    "1383": "ETHIOPIC SYLLABLE MWE",
    "1384": "ETHIOPIC SYLLABLE SEBATBEIT BWA",
    "1385": "ETHIOPIC SYLLABLE BWI",
    "1386": "ETHIOPIC SYLLABLE BWEE",
    "1387": "ETHIOPIC SYLLABLE BWE",
    "1388": "ETHIOPIC SYLLABLE SEBATBEIT FWA",
    "1389": "ETHIOPIC SYLLABLE FWI",
    "138A": "ETHIOPIC SYLLABLE FWEE",
    "138B": "ETHIOPIC SYLLABLE FWE",
    "138C": "ETHIOPIC SYLLABLE SEBATBEIT PWA",
    "138D": "ETHIOPIC SYLLABLE PWI",
    "138E": "ETHIOPIC SYLLABLE PWEE",
    "138F": "ETHIOPIC SYLLABLE PWE",
    "1390": "ETHIOPIC TONAL MARK YIZET",
    "1391": "ETHIOPIC TONAL MARK DERET",
    "1392": "ETHIOPIC TONAL MARK RIKRIK",
    "1393": "ETHIOPIC TONAL MARK SHORT RIKRIK",
    "1394": "ETHIOPIC TONAL MARK DIFAT",
    "1395": "ETHIOPIC TONAL MARK KENAT",
    "1396": "ETHIOPIC TONAL MARK CHIRET",
    "1397": "ETHIOPIC TONAL MARK HIDET",
    "1398": "ETHIOPIC TONAL MARK DERET-HIDET",
    "1399": "ETHIOPIC TONAL MARK KURT",
    "13A0": "CHEROKEE LETTER A",
    "13A1": "CHEROKEE LETTER E",
    "13A2": "CHEROKEE LETTER I",
    "13A3": "CHEROKEE LETTER O",
    "13A4": "CHEROKEE LETTER U",
    "13A5": "CHEROKEE LETTER V",
    "13A6": "CHEROKEE LETTER GA",
    "13A7": "CHEROKEE LETTER KA",
    "13A8": "CHEROKEE LETTER GE",
    "13A9": "CHEROKEE LETTER GI",
    "13AA": "CHEROKEE LETTER GO",
    "13AB": "CHEROKEE LETTER GU",
    "13AC": "CHEROKEE LETTER GV",
    "13AD": "CHEROKEE LETTER HA",
    "13AE": "CHEROKEE LETTER HE",
    "13AF": "CHEROKEE LETTER HI",
    "13B0": "CHEROKEE LETTER HO",
    "13B1": "CHEROKEE LETTER HU",
    "13B2": "CHEROKEE LETTER HV",
    "13B3": "CHEROKEE LETTER LA",
    "13B4": "CHEROKEE LETTER LE",
    "13B5": "CHEROKEE LETTER LI",
    "13B6": "CHEROKEE LETTER LO",
    "13B7": "CHEROKEE LETTER LU",
    "13B8": "CHEROKEE LETTER LV",
    "13B9": "CHEROKEE LETTER MA",
    "13BA": "CHEROKEE LETTER ME",
    "13BB": "CHEROKEE LETTER MI",
    "13BC": "CHEROKEE LETTER MO",
    "13BD": "CHEROKEE LETTER MU",
    "13BE": "CHEROKEE LETTER NA",
    "13BF": "CHEROKEE LETTER HNA",
    "13C0": "CHEROKEE LETTER NAH",
    "13C1": "CHEROKEE LETTER NE",
    "13C2": "CHEROKEE LETTER NI",
    "13C3": "CHEROKEE LETTER NO",
    "13C4": "CHEROKEE LETTER NU",
    "13C5": "CHEROKEE LETTER NV",
    "13C6": "CHEROKEE LETTER QUA",
    "13C7": "CHEROKEE LETTER QUE",
    "13C8": "CHEROKEE LETTER QUI",
    "13C9": "CHEROKEE LETTER QUO",
    "13CA": "CHEROKEE LETTER QUU",
    "13CB": "CHEROKEE LETTER QUV",
    "13CC": "CHEROKEE LETTER SA",
    "13CD": "CHEROKEE LETTER S",
    "13CE": "CHEROKEE LETTER SE",
    "13CF": "CHEROKEE LETTER SI",
    "13D0": "CHEROKEE LETTER SO",
    "13D1": "CHEROKEE LETTER SU",
    "13D2": "CHEROKEE LETTER SV",
    "13D3": "CHEROKEE LETTER DA",
    "13D4": "CHEROKEE LETTER TA",
    "13D5": "CHEROKEE LETTER DE",
    "13D6": "CHEROKEE LETTER TE",
    "13D7": "CHEROKEE LETTER DI",
    "13D8": "CHEROKEE LETTER TI",
    "13D9": "CHEROKEE LETTER DO",
    "13DA": "CHEROKEE LETTER DU",
    "13DB": "CHEROKEE LETTER DV",
    "13DC": "CHEROKEE LETTER DLA",
    "13DD": "CHEROKEE LETTER TLA",
    "13DE": "CHEROKEE LETTER TLE",
    "13DF": "CHEROKEE LETTER TLI",
    "13E0": "CHEROKEE LETTER TLO",
    "13E1": "CHEROKEE LETTER TLU",
    "13E2": "CHEROKEE LETTER TLV",
    "13E3": "CHEROKEE LETTER TSA",
    "13E4": "CHEROKEE LETTER TSE",
    "13E5": "CHEROKEE LETTER TSI",
    "13E6": "CHEROKEE LETTER TSO",
    "13E7": "CHEROKEE LETTER TSU",
    "13E8": "CHEROKEE LETTER TSV",
    "13E9": "CHEROKEE LETTER WA",
    "13EA": "CHEROKEE LETTER WE",
    "13EB": "CHEROKEE LETTER WI",
    "13EC": "CHEROKEE LETTER WO",
    "13ED": "CHEROKEE LETTER WU",
    "13EE": "CHEROKEE LETTER WV",
    "13EF": "CHEROKEE LETTER YA",
    "13F0": "CHEROKEE LETTER YE",
    "13F1": "CHEROKEE LETTER YI",
    "13F2": "CHEROKEE LETTER YO",
    "13F3": "CHEROKEE LETTER YU",
    "13F4": "CHEROKEE LETTER YV",
    "13F5": "CHEROKEE LETTER MV",
    "13F8": "CHEROKEE SMALL LETTER YE",
    "13F9": "CHEROKEE SMALL LETTER YI",
    "13FA": "CHEROKEE SMALL LETTER YO",
    "13FB": "CHEROKEE SMALL LETTER YU",
    "13FC": "CHEROKEE SMALL LETTER YV",
    "13FD": "CHEROKEE SMALL LETTER MV",
    "1400": "CANADIAN SYLLABICS HYPHEN",
    "1401": "CANADIAN SYLLABICS E",
    "1402": "CANADIAN SYLLABICS AAI",
    "1403": "CANADIAN SYLLABICS I",
    "1404": "CANADIAN SYLLABICS II",
    "1405": "CANADIAN SYLLABICS O",
    "1406": "CANADIAN SYLLABICS OO",
    "1407": "CANADIAN SYLLABICS Y-CREE OO",
    "1408": "CANADIAN SYLLABICS CARRIER EE",
    "1409": "CANADIAN SYLLABICS CARRIER I",
    "140A": "CANADIAN SYLLABICS A",
    "140B": "CANADIAN SYLLABICS AA",
    "140C": "CANADIAN SYLLABICS WE",
    "140D": "CANADIAN SYLLABICS WEST-CREE WE",
    "140E": "CANADIAN SYLLABICS WI",
    "140F": "CANADIAN SYLLABICS WEST-CREE WI",
    "1410": "CANADIAN SYLLABICS WII",
    "1411": "CANADIAN SYLLABICS WEST-CREE WII",
    "1412": "CANADIAN SYLLABICS WO",
    "1413": "CANADIAN SYLLABICS WEST-CREE WO",
    "1414": "CANADIAN SYLLABICS WOO",
    "1415": "CANADIAN SYLLABICS WEST-CREE WOO",
    "1416": "CANADIAN SYLLABICS NASKAPI WOO",
    "1417": "CANADIAN SYLLABICS WA",
    "1418": "CANADIAN SYLLABICS WEST-CREE WA",
    "1419": "CANADIAN SYLLABICS WAA",
    "141A": "CANADIAN SYLLABICS WEST-CREE WAA",
    "141B": "CANADIAN SYLLABICS NASKAPI WAA",
    "141C": "CANADIAN SYLLABICS AI",
    "141D": "CANADIAN SYLLABICS Y-CREE W",
    "141E": "CANADIAN SYLLABICS GLOTTAL STOP",
    "141F": "CANADIAN SYLLABICS FINAL ACUTE",
    "1420": "CANADIAN SYLLABICS FINAL GRAVE",
    "1421": "CANADIAN SYLLABICS FINAL BOTTOM HALF RING",
    "1422": "CANADIAN SYLLABICS FINAL TOP HALF RING",
    "1423": "CANADIAN SYLLABICS FINAL RIGHT HALF RING",
    "1424": "CANADIAN SYLLABICS FINAL RING",
    "1425": "CANADIAN SYLLABICS FINAL DOUBLE ACUTE",
    "1426": "CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES",
    "1427": "CANADIAN SYLLABICS FINAL MIDDLE DOT",
    "1428": "CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE",
    "1429": "CANADIAN SYLLABICS FINAL PLUS",
    "142A": "CANADIAN SYLLABICS FINAL DOWN TACK",
    "142B": "CANADIAN SYLLABICS EN",
    "142C": "CANADIAN SYLLABICS IN",
    "142D": "CANADIAN SYLLABICS ON",
    "142E": "CANADIAN SYLLABICS AN",
    "142F": "CANADIAN SYLLABICS PE",
    "1430": "CANADIAN SYLLABICS PAAI",
    "1431": "CANADIAN SYLLABICS PI",
    "1432": "CANADIAN SYLLABICS PII",
    "1433": "CANADIAN SYLLABICS PO",
    "1434": "CANADIAN SYLLABICS POO",
    "1435": "CANADIAN SYLLABICS Y-CREE POO",
    "1436": "CANADIAN SYLLABICS CARRIER HEE",
    "1437": "CANADIAN SYLLABICS CARRIER HI",
    "1438": "CANADIAN SYLLABICS PA",
    "1439": "CANADIAN SYLLABICS PAA",
    "143A": "CANADIAN SYLLABICS PWE",
    "143B": "CANADIAN SYLLABICS WEST-CREE PWE",
    "143C": "CANADIAN SYLLABICS PWI",
    "143D": "CANADIAN SYLLABICS WEST-CREE PWI",
    "143E": "CANADIAN SYLLABICS PWII",
    "143F": "CANADIAN SYLLABICS WEST-CREE PWII",
    "1440": "CANADIAN SYLLABICS PWO",
    "1441": "CANADIAN SYLLABICS WEST-CREE PWO",
    "1442": "CANADIAN SYLLABICS PWOO",
    "1443": "CANADIAN SYLLABICS WEST-CREE PWOO",
    "1444": "CANADIAN SYLLABICS PWA",
    "1445": "CANADIAN SYLLABICS WEST-CREE PWA",
    "1446": "CANADIAN SYLLABICS PWAA",
    "1447": "CANADIAN SYLLABICS WEST-CREE PWAA",
    "1448": "CANADIAN SYLLABICS Y-CREE PWAA",
    "1449": "CANADIAN SYLLABICS P",
    "144A": "CANADIAN SYLLABICS WEST-CREE P",
    "144B": "CANADIAN SYLLABICS CARRIER H",
    "144C": "CANADIAN SYLLABICS TE",
    "144D": "CANADIAN SYLLABICS TAAI",
    "144E": "CANADIAN SYLLABICS TI",
    "144F": "CANADIAN SYLLABICS TII",
    "1450": "CANADIAN SYLLABICS TO",
    "1451": "CANADIAN SYLLABICS TOO",
    "1452": "CANADIAN SYLLABICS Y-CREE TOO",
    "1453": "CANADIAN SYLLABICS CARRIER DEE",
    "1454": "CANADIAN SYLLABICS CARRIER DI",
    "1455": "CANADIAN SYLLABICS TA",
    "1456": "CANADIAN SYLLABICS TAA",
    "1457": "CANADIAN SYLLABICS TWE",
    "1458": "CANADIAN SYLLABICS WEST-CREE TWE",
    "1459": "CANADIAN SYLLABICS TWI",
    "145A": "CANADIAN SYLLABICS WEST-CREE TWI",
    "145B": "CANADIAN SYLLABICS TWII",
    "145C": "CANADIAN SYLLABICS WEST-CREE TWII",
    "145D": "CANADIAN SYLLABICS TWO",
    "145E": "CANADIAN SYLLABICS WEST-CREE TWO",
    "145F": "CANADIAN SYLLABICS TWOO",
    "1460": "CANADIAN SYLLABICS WEST-CREE TWOO",
    "1461": "CANADIAN SYLLABICS TWA",
    "1462": "CANADIAN SYLLABICS WEST-CREE TWA",
    "1463": "CANADIAN SYLLABICS TWAA",
    "1464": "CANADIAN SYLLABICS WEST-CREE TWAA",
    "1465": "CANADIAN SYLLABICS NASKAPI TWAA",
    "1466": "CANADIAN SYLLABICS T",
    "1467": "CANADIAN SYLLABICS TTE",
    "1468": "CANADIAN SYLLABICS TTI",
    "1469": "CANADIAN SYLLABICS TTO",
    "146A": "CANADIAN SYLLABICS TTA",
    "146B": "CANADIAN SYLLABICS KE",
    "146C": "CANADIAN SYLLABICS KAAI",
    "146D": "CANADIAN SYLLABICS KI",
    "146E": "CANADIAN SYLLABICS KII",
    "146F": "CANADIAN SYLLABICS KO",
    "1470": "CANADIAN SYLLABICS KOO",
    "1471": "CANADIAN SYLLABICS Y-CREE KOO",
    "1472": "CANADIAN SYLLABICS KA",
    "1473": "CANADIAN SYLLABICS KAA",
    "1474": "CANADIAN SYLLABICS KWE",
    "1475": "CANADIAN SYLLABICS WEST-CREE KWE",
    "1476": "CANADIAN SYLLABICS KWI",
    "1477": "CANADIAN SYLLABICS WEST-CREE KWI",
    "1478": "CANADIAN SYLLABICS KWII",
    "1479": "CANADIAN SYLLABICS WEST-CREE KWII",
    "147A": "CANADIAN SYLLABICS KWO",
    "147B": "CANADIAN SYLLABICS WEST-CREE KWO",
    "147C": "CANADIAN SYLLABICS KWOO",
    "147D": "CANADIAN SYLLABICS WEST-CREE KWOO",
    "147E": "CANADIAN SYLLABICS KWA",
    "147F": "CANADIAN SYLLABICS WEST-CREE KWA",
    "1480": "CANADIAN SYLLABICS KWAA",
    "1481": "CANADIAN SYLLABICS WEST-CREE KWAA",
    "1482": "CANADIAN SYLLABICS NASKAPI KWAA",
    "1483": "CANADIAN SYLLABICS K",
    "1484": "CANADIAN SYLLABICS KW",
    "1485": "CANADIAN SYLLABICS SOUTH-SLAVEY KEH",
    "1486": "CANADIAN SYLLABICS SOUTH-SLAVEY KIH",
    "1487": "CANADIAN SYLLABICS SOUTH-SLAVEY KOH",
    "1488": "CANADIAN SYLLABICS SOUTH-SLAVEY KAH",
    "1489": "CANADIAN SYLLABICS CE",
    "148A": "CANADIAN SYLLABICS CAAI",
    "148B": "CANADIAN SYLLABICS CI",
    "148C": "CANADIAN SYLLABICS CII",
    "148D": "CANADIAN SYLLABICS CO",
    "148E": "CANADIAN SYLLABICS COO",
    "148F": "CANADIAN SYLLABICS Y-CREE COO",
    "1490": "CANADIAN SYLLABICS CA",
    "1491": "CANADIAN SYLLABICS CAA",
    "1492": "CANADIAN SYLLABICS CWE",
    "1493": "CANADIAN SYLLABICS WEST-CREE CWE",
    "1494": "CANADIAN SYLLABICS CWI",
    "1495": "CANADIAN SYLLABICS WEST-CREE CWI",
    "1496": "CANADIAN SYLLABICS CWII",
    "1497": "CANADIAN SYLLABICS WEST-CREE CWII",
    "1498": "CANADIAN SYLLABICS CWO",
    "1499": "CANADIAN SYLLABICS WEST-CREE CWO",
    "149A": "CANADIAN SYLLABICS CWOO",
    "149B": "CANADIAN SYLLABICS WEST-CREE CWOO",
    "149C": "CANADIAN SYLLABICS CWA",
    "149D": "CANADIAN SYLLABICS WEST-CREE CWA",
    "149E": "CANADIAN SYLLABICS CWAA",
    "149F": "CANADIAN SYLLABICS WEST-CREE CWAA",
    "14A0": "CANADIAN SYLLABICS NASKAPI CWAA",
    "14A1": "CANADIAN SYLLABICS C",
    "14A2": "CANADIAN SYLLABICS SAYISI TH",
    "14A3": "CANADIAN SYLLABICS ME",
    "14A4": "CANADIAN SYLLABICS MAAI",
    "14A5": "CANADIAN SYLLABICS MI",
    "14A6": "CANADIAN SYLLABICS MII",
    "14A7": "CANADIAN SYLLABICS MO",
    "14A8": "CANADIAN SYLLABICS MOO",
    "14A9": "CANADIAN SYLLABICS Y-CREE MOO",
    "14AA": "CANADIAN SYLLABICS MA",
    "14AB": "CANADIAN SYLLABICS MAA",
    "14AC": "CANADIAN SYLLABICS MWE",
    "14AD": "CANADIAN SYLLABICS WEST-CREE MWE",
    "14AE": "CANADIAN SYLLABICS MWI",
    "14AF": "CANADIAN SYLLABICS WEST-CREE MWI",
    "14B0": "CANADIAN SYLLABICS MWII",
    "14B1": "CANADIAN SYLLABICS WEST-CREE MWII",
    "14B2": "CANADIAN SYLLABICS MWO",
    "14B3": "CANADIAN SYLLABICS WEST-CREE MWO",
    "14B4": "CANADIAN SYLLABICS MWOO",
    "14B5": "CANADIAN SYLLABICS WEST-CREE MWOO",
    "14B6": "CANADIAN SYLLABICS MWA",
    "14B7": "CANADIAN SYLLABICS WEST-CREE MWA",
    "14B8": "CANADIAN SYLLABICS MWAA",
    "14B9": "CANADIAN SYLLABICS WEST-CREE MWAA",
    "14BA": "CANADIAN SYLLABICS NASKAPI MWAA",
    "14BB": "CANADIAN SYLLABICS M",
    "14BC": "CANADIAN SYLLABICS WEST-CREE M",
    "14BD": "CANADIAN SYLLABICS MH",
    "14BE": "CANADIAN SYLLABICS ATHAPASCAN M",
    "14BF": "CANADIAN SYLLABICS SAYISI M",
    "14C0": "CANADIAN SYLLABICS NE",
    "14C1": "CANADIAN SYLLABICS NAAI",
    "14C2": "CANADIAN SYLLABICS NI",
    "14C3": "CANADIAN SYLLABICS NII",
    "14C4": "CANADIAN SYLLABICS NO",
    "14C5": "CANADIAN SYLLABICS NOO",
    "14C6": "CANADIAN SYLLABICS Y-CREE NOO",
    "14C7": "CANADIAN SYLLABICS NA",
    "14C8": "CANADIAN SYLLABICS NAA",
    "14C9": "CANADIAN SYLLABICS NWE",
    "14CA": "CANADIAN SYLLABICS WEST-CREE NWE",
    "14CB": "CANADIAN SYLLABICS NWA",
    "14CC": "CANADIAN SYLLABICS WEST-CREE NWA",
    "14CD": "CANADIAN SYLLABICS NWAA",
    "14CE": "CANADIAN SYLLABICS WEST-CREE NWAA",
    "14CF": "CANADIAN SYLLABICS NASKAPI NWAA",
    "14D0": "CANADIAN SYLLABICS N",
    "14D1": "CANADIAN SYLLABICS CARRIER NG",
    "14D2": "CANADIAN SYLLABICS NH",
    "14D3": "CANADIAN SYLLABICS LE",
    "14D4": "CANADIAN SYLLABICS LAAI",
    "14D5": "CANADIAN SYLLABICS LI",
    "14D6": "CANADIAN SYLLABICS LII",
    "14D7": "CANADIAN SYLLABICS LO",
    "14D8": "CANADIAN SYLLABICS LOO",
    "14D9": "CANADIAN SYLLABICS Y-CREE LOO",
    "14DA": "CANADIAN SYLLABICS LA",
    "14DB": "CANADIAN SYLLABICS LAA",
    "14DC": "CANADIAN SYLLABICS LWE",
    "14DD": "CANADIAN SYLLABICS WEST-CREE LWE",
    "14DE": "CANADIAN SYLLABICS LWI",
    "14DF": "CANADIAN SYLLABICS WEST-CREE LWI",
    "14E0": "CANADIAN SYLLABICS LWII",
    "14E1": "CANADIAN SYLLABICS WEST-CREE LWII",
    "14E2": "CANADIAN SYLLABICS LWO",
    "14E3": "CANADIAN SYLLABICS WEST-CREE LWO",
    "14E4": "CANADIAN SYLLABICS LWOO",
    "14E5": "CANADIAN SYLLABICS WEST-CREE LWOO",
    "14E6": "CANADIAN SYLLABICS LWA",
    "14E7": "CANADIAN SYLLABICS WEST-CREE LWA",
    "14E8": "CANADIAN SYLLABICS LWAA",
    "14E9": "CANADIAN SYLLABICS WEST-CREE LWAA",
    "14EA": "CANADIAN SYLLABICS L",
    "14EB": "CANADIAN SYLLABICS WEST-CREE L",
    "14EC": "CANADIAN SYLLABICS MEDIAL L",
    "14ED": "CANADIAN SYLLABICS SE",
    "14EE": "CANADIAN SYLLABICS SAAI",
    "14EF": "CANADIAN SYLLABICS SI",
    "14F0": "CANADIAN SYLLABICS SII",
    "14F1": "CANADIAN SYLLABICS SO",
    "14F2": "CANADIAN SYLLABICS SOO",
    "14F3": "CANADIAN SYLLABICS Y-CREE SOO",
    "14F4": "CANADIAN SYLLABICS SA",
    "14F5": "CANADIAN SYLLABICS SAA",
    "14F6": "CANADIAN SYLLABICS SWE",
    "14F7": "CANADIAN SYLLABICS WEST-CREE SWE",
    "14F8": "CANADIAN SYLLABICS SWI",
    "14F9": "CANADIAN SYLLABICS WEST-CREE SWI",
    "14FA": "CANADIAN SYLLABICS SWII",
    "14FB": "CANADIAN SYLLABICS WEST-CREE SWII",
    "14FC": "CANADIAN SYLLABICS SWO",
    "14FD": "CANADIAN SYLLABICS WEST-CREE SWO",
    "14FE": "CANADIAN SYLLABICS SWOO",
    "14FF": "CANADIAN SYLLABICS WEST-CREE SWOO",
    "1500": "CANADIAN SYLLABICS SWA",
    "1501": "CANADIAN SYLLABICS WEST-CREE SWA",
    "1502": "CANADIAN SYLLABICS SWAA",
    "1503": "CANADIAN SYLLABICS WEST-CREE SWAA",
    "1504": "CANADIAN SYLLABICS NASKAPI SWAA",
    "1505": "CANADIAN SYLLABICS S",
    "1506": "CANADIAN SYLLABICS ATHAPASCAN S",
    "1507": "CANADIAN SYLLABICS SW",
    "1508": "CANADIAN SYLLABICS BLACKFOOT S",
    "1509": "CANADIAN SYLLABICS MOOSE-CREE SK",
    "150A": "CANADIAN SYLLABICS NASKAPI SKW",
    "150B": "CANADIAN SYLLABICS NASKAPI S-W",
    "150C": "CANADIAN SYLLABICS NASKAPI SPWA",
    "150D": "CANADIAN SYLLABICS NASKAPI STWA",
    "150E": "CANADIAN SYLLABICS NASKAPI SKWA",
    "150F": "CANADIAN SYLLABICS NASKAPI SCWA",
    "1510": "CANADIAN SYLLABICS SHE",
    "1511": "CANADIAN SYLLABICS SHI",
    "1512": "CANADIAN SYLLABICS SHII",
    "1513": "CANADIAN SYLLABICS SHO",
    "1514": "CANADIAN SYLLABICS SHOO",
    "1515": "CANADIAN SYLLABICS SHA",
    "1516": "CANADIAN SYLLABICS SHAA",
    "1517": "CANADIAN SYLLABICS SHWE",
    "1518": "CANADIAN SYLLABICS WEST-CREE SHWE",
    "1519": "CANADIAN SYLLABICS SHWI",
    "151A": "CANADIAN SYLLABICS WEST-CREE SHWI",
    "151B": "CANADIAN SYLLABICS SHWII",
    "151C": "CANADIAN SYLLABICS WEST-CREE SHWII",
    "151D": "CANADIAN SYLLABICS SHWO",
    "151E": "CANADIAN SYLLABICS WEST-CREE SHWO",
    "151F": "CANADIAN SYLLABICS SHWOO",
    "1520": "CANADIAN SYLLABICS WEST-CREE SHWOO",
    "1521": "CANADIAN SYLLABICS SHWA",
    "1522": "CANADIAN SYLLABICS WEST-CREE SHWA",
    "1523": "CANADIAN SYLLABICS SHWAA",
    "1524": "CANADIAN SYLLABICS WEST-CREE SHWAA",
    "1525": "CANADIAN SYLLABICS SH",
    "1526": "CANADIAN SYLLABICS YE",
    "1527": "CANADIAN SYLLABICS YAAI",
    "1528": "CANADIAN SYLLABICS YI",
    "1529": "CANADIAN SYLLABICS YII",
    "152A": "CANADIAN SYLLABICS YO",
    "152B": "CANADIAN SYLLABICS YOO",
    "152C": "CANADIAN SYLLABICS Y-CREE YOO",
    "152D": "CANADIAN SYLLABICS YA",
    "152E": "CANADIAN SYLLABICS YAA",
    "152F": "CANADIAN SYLLABICS YWE",
    "1530": "CANADIAN SYLLABICS WEST-CREE YWE",
    "1531": "CANADIAN SYLLABICS YWI",
    "1532": "CANADIAN SYLLABICS WEST-CREE YWI",
    "1533": "CANADIAN SYLLABICS YWII",
    "1534": "CANADIAN SYLLABICS WEST-CREE YWII",
    "1535": "CANADIAN SYLLABICS YWO",
    "1536": "CANADIAN SYLLABICS WEST-CREE YWO",
    "1537": "CANADIAN SYLLABICS YWOO",
    "1538": "CANADIAN SYLLABICS WEST-CREE YWOO",
    "1539": "CANADIAN SYLLABICS YWA",
    "153A": "CANADIAN SYLLABICS WEST-CREE YWA",
    "153B": "CANADIAN SYLLABICS YWAA",
    "153C": "CANADIAN SYLLABICS WEST-CREE YWAA",
    "153D": "CANADIAN SYLLABICS NASKAPI YWAA",
    "153E": "CANADIAN SYLLABICS Y",
    "153F": "CANADIAN SYLLABICS BIBLE-CREE Y",
    "1540": "CANADIAN SYLLABICS WEST-CREE Y",
    "1541": "CANADIAN SYLLABICS SAYISI YI",
    "1542": "CANADIAN SYLLABICS RE",
    "1543": "CANADIAN SYLLABICS R-CREE RE",
    "1544": "CANADIAN SYLLABICS WEST-CREE LE",
    "1545": "CANADIAN SYLLABICS RAAI",
    "1546": "CANADIAN SYLLABICS RI",
    "1547": "CANADIAN SYLLABICS RII",
    "1548": "CANADIAN SYLLABICS RO",
    "1549": "CANADIAN SYLLABICS ROO",
    "154A": "CANADIAN SYLLABICS WEST-CREE LO",
    "154B": "CANADIAN SYLLABICS RA",
    "154C": "CANADIAN SYLLABICS RAA",
    "154D": "CANADIAN SYLLABICS WEST-CREE LA",
    "154E": "CANADIAN SYLLABICS RWAA",
    "154F": "CANADIAN SYLLABICS WEST-CREE RWAA",
    "1550": "CANADIAN SYLLABICS R",
    "1551": "CANADIAN SYLLABICS WEST-CREE R",
    "1552": "CANADIAN SYLLABICS MEDIAL R",
    "1553": "CANADIAN SYLLABICS FE",
    "1554": "CANADIAN SYLLABICS FAAI",
    "1555": "CANADIAN SYLLABICS FI",
    "1556": "CANADIAN SYLLABICS FII",
    "1557": "CANADIAN SYLLABICS FO",
    "1558": "CANADIAN SYLLABICS FOO",
    "1559": "CANADIAN SYLLABICS FA",
    "155A": "CANADIAN SYLLABICS FAA",
    "155B": "CANADIAN SYLLABICS FWAA",
    "155C": "CANADIAN SYLLABICS WEST-CREE FWAA",
    "155D": "CANADIAN SYLLABICS F",
    "155E": "CANADIAN SYLLABICS THE",
    "155F": "CANADIAN SYLLABICS N-CREE THE",
    "1560": "CANADIAN SYLLABICS THI",
    "1561": "CANADIAN SYLLABICS N-CREE THI",
    "1562": "CANADIAN SYLLABICS THII",
    "1563": "CANADIAN SYLLABICS N-CREE THII",
    "1564": "CANADIAN SYLLABICS THO",
    "1565": "CANADIAN SYLLABICS THOO",
    "1566": "CANADIAN SYLLABICS THA",
    "1567": "CANADIAN SYLLABICS THAA",
    "1568": "CANADIAN SYLLABICS THWAA",
    "1569": "CANADIAN SYLLABICS WEST-CREE THWAA",
    "156A": "CANADIAN SYLLABICS TH",
    "156B": "CANADIAN SYLLABICS TTHE",
    "156C": "CANADIAN SYLLABICS TTHI",
    "156D": "CANADIAN SYLLABICS TTHO",
    "156E": "CANADIAN SYLLABICS TTHA",
    "156F": "CANADIAN SYLLABICS TTH",
    "1570": "CANADIAN SYLLABICS TYE",
    "1571": "CANADIAN SYLLABICS TYI",
    "1572": "CANADIAN SYLLABICS TYO",
    "1573": "CANADIAN SYLLABICS TYA",
    "1574": "CANADIAN SYLLABICS NUNAVIK HE",
    "1575": "CANADIAN SYLLABICS NUNAVIK HI",
    "1576": "CANADIAN SYLLABICS NUNAVIK HII",
    "1577": "CANADIAN SYLLABICS NUNAVIK HO",
    "1578": "CANADIAN SYLLABICS NUNAVIK HOO",
    "1579": "CANADIAN SYLLABICS NUNAVIK HA",
    "157A": "CANADIAN SYLLABICS NUNAVIK HAA",
    "157B": "CANADIAN SYLLABICS NUNAVIK H",
    "157C": "CANADIAN SYLLABICS NUNAVUT H",
    "157D": "CANADIAN SYLLABICS HK",
    "157E": "CANADIAN SYLLABICS QAAI",
    "157F": "CANADIAN SYLLABICS QI",
    "1580": "CANADIAN SYLLABICS QII",
    "1581": "CANADIAN SYLLABICS QO",
    "1582": "CANADIAN SYLLABICS QOO",
    "1583": "CANADIAN SYLLABICS QA",
    "1584": "CANADIAN SYLLABICS QAA",
    "1585": "CANADIAN SYLLABICS Q",
    "1586": "CANADIAN SYLLABICS TLHE",
    "1587": "CANADIAN SYLLABICS TLHI",
    "1588": "CANADIAN SYLLABICS TLHO",
    "1589": "CANADIAN SYLLABICS TLHA",
    "158A": "CANADIAN SYLLABICS WEST-CREE RE",
    "158B": "CANADIAN SYLLABICS WEST-CREE RI",
    "158C": "CANADIAN SYLLABICS WEST-CREE RO",
    "158D": "CANADIAN SYLLABICS WEST-CREE RA",
    "158E": "CANADIAN SYLLABICS NGAAI",
    "158F": "CANADIAN SYLLABICS NGI",
    "1590": "CANADIAN SYLLABICS NGII",
    "1591": "CANADIAN SYLLABICS NGO",
    "1592": "CANADIAN SYLLABICS NGOO",
    "1593": "CANADIAN SYLLABICS NGA",
    "1594": "CANADIAN SYLLABICS NGAA",
    "1595": "CANADIAN SYLLABICS NG",
    "1596": "CANADIAN SYLLABICS NNG",
    "1597": "CANADIAN SYLLABICS SAYISI SHE",
    "1598": "CANADIAN SYLLABICS SAYISI SHI",
    "1599": "CANADIAN SYLLABICS SAYISI SHO",
    "159A": "CANADIAN SYLLABICS SAYISI SHA",
    "159B": "CANADIAN SYLLABICS WOODS-CREE THE",
    "159C": "CANADIAN SYLLABICS WOODS-CREE THI",
    "159D": "CANADIAN SYLLABICS WOODS-CREE THO",
    "159E": "CANADIAN SYLLABICS WOODS-CREE THA",
    "159F": "CANADIAN SYLLABICS WOODS-CREE TH",
    "15A0": "CANADIAN SYLLABICS LHI",
    "15A1": "CANADIAN SYLLABICS LHII",
    "15A2": "CANADIAN SYLLABICS LHO",
    "15A3": "CANADIAN SYLLABICS LHOO",
    "15A4": "CANADIAN SYLLABICS LHA",
    "15A5": "CANADIAN SYLLABICS LHAA",
    "15A6": "CANADIAN SYLLABICS LH",
    "15A7": "CANADIAN SYLLABICS TH-CREE THE",
    "15A8": "CANADIAN SYLLABICS TH-CREE THI",
    "15A9": "CANADIAN SYLLABICS TH-CREE THII",
    "15AA": "CANADIAN SYLLABICS TH-CREE THO",
    "15AB": "CANADIAN SYLLABICS TH-CREE THOO",
    "15AC": "CANADIAN SYLLABICS TH-CREE THA",
    "15AD": "CANADIAN SYLLABICS TH-CREE THAA",
    "15AE": "CANADIAN SYLLABICS TH-CREE TH",
    "15AF": "CANADIAN SYLLABICS AIVILIK B",
    "15B0": "CANADIAN SYLLABICS BLACKFOOT E",
    "15B1": "CANADIAN SYLLABICS BLACKFOOT I",
    "15B2": "CANADIAN SYLLABICS BLACKFOOT O",
    "15B3": "CANADIAN SYLLABICS BLACKFOOT A",
    "15B4": "CANADIAN SYLLABICS BLACKFOOT WE",
    "15B5": "CANADIAN SYLLABICS BLACKFOOT WI",
    "15B6": "CANADIAN SYLLABICS BLACKFOOT WO",
    "15B7": "CANADIAN SYLLABICS BLACKFOOT WA",
    "15B8": "CANADIAN SYLLABICS BLACKFOOT NE",
    "15B9": "CANADIAN SYLLABICS BLACKFOOT NI",
    "15BA": "CANADIAN SYLLABICS BLACKFOOT NO",
    "15BB": "CANADIAN SYLLABICS BLACKFOOT NA",
    "15BC": "CANADIAN SYLLABICS BLACKFOOT KE",
    "15BD": "CANADIAN SYLLABICS BLACKFOOT KI",
    "15BE": "CANADIAN SYLLABICS BLACKFOOT KO",
    "15BF": "CANADIAN SYLLABICS BLACKFOOT KA",
    "15C0": "CANADIAN SYLLABICS SAYISI HE",
    "15C1": "CANADIAN SYLLABICS SAYISI HI",
    "15C2": "CANADIAN SYLLABICS SAYISI HO",
    "15C3": "CANADIAN SYLLABICS SAYISI HA",
    "15C4": "CANADIAN SYLLABICS CARRIER GHU",
    "15C5": "CANADIAN SYLLABICS CARRIER GHO",
    "15C6": "CANADIAN SYLLABICS CARRIER GHE",
    "15C7": "CANADIAN SYLLABICS CARRIER GHEE",
    "15C8": "CANADIAN SYLLABICS CARRIER GHI",
    "15C9": "CANADIAN SYLLABICS CARRIER GHA",
    "15CA": "CANADIAN SYLLABICS CARRIER RU",
    "15CB": "CANADIAN SYLLABICS CARRIER RO",
    "15CC": "CANADIAN SYLLABICS CARRIER RE",
    "15CD": "CANADIAN SYLLABICS CARRIER REE",
    "15CE": "CANADIAN SYLLABICS CARRIER RI",
    "15CF": "CANADIAN SYLLABICS CARRIER RA",
    "15D0": "CANADIAN SYLLABICS CARRIER WU",
    "15D1": "CANADIAN SYLLABICS CARRIER WO",
    "15D2": "CANADIAN SYLLABICS CARRIER WE",
    "15D3": "CANADIAN SYLLABICS CARRIER WEE",
    "15D4": "CANADIAN SYLLABICS CARRIER WI",
    "15D5": "CANADIAN SYLLABICS CARRIER WA",
    "15D6": "CANADIAN SYLLABICS CARRIER HWU",
    "15D7": "CANADIAN SYLLABICS CARRIER HWO",
    "15D8": "CANADIAN SYLLABICS CARRIER HWE",
    "15D9": "CANADIAN SYLLABICS CARRIER HWEE",
    "15DA": "CANADIAN SYLLABICS CARRIER HWI",
    "15DB": "CANADIAN SYLLABICS CARRIER HWA",
    "15DC": "CANADIAN SYLLABICS CARRIER THU",
    "15DD": "CANADIAN SYLLABICS CARRIER THO",
    "15DE": "CANADIAN SYLLABICS CARRIER THE",
    "15DF": "CANADIAN SYLLABICS CARRIER THEE",
    "15E0": "CANADIAN SYLLABICS CARRIER THI",
    "15E1": "CANADIAN SYLLABICS CARRIER THA",
    "15E2": "CANADIAN SYLLABICS CARRIER TTU",
    "15E3": "CANADIAN SYLLABICS CARRIER TTO",
    "15E4": "CANADIAN SYLLABICS CARRIER TTE",
    "15E5": "CANADIAN SYLLABICS CARRIER TTEE",
    "15E6": "CANADIAN SYLLABICS CARRIER TTI",
    "15E7": "CANADIAN SYLLABICS CARRIER TTA",
    "15E8": "CANADIAN SYLLABICS CARRIER PU",
    "15E9": "CANADIAN SYLLABICS CARRIER PO",
    "15EA": "CANADIAN SYLLABICS CARRIER PE",
    "15EB": "CANADIAN SYLLABICS CARRIER PEE",
    "15EC": "CANADIAN SYLLABICS CARRIER PI",
    "15ED": "CANADIAN SYLLABICS CARRIER PA",
    "15EE": "CANADIAN SYLLABICS CARRIER P",
    "15EF": "CANADIAN SYLLABICS CARRIER GU",
    "15F0": "CANADIAN SYLLABICS CARRIER GO",
    "15F1": "CANADIAN SYLLABICS CARRIER GE",
    "15F2": "CANADIAN SYLLABICS CARRIER GEE",
    "15F3": "CANADIAN SYLLABICS CARRIER GI",
    "15F4": "CANADIAN SYLLABICS CARRIER GA",
    "15F5": "CANADIAN SYLLABICS CARRIER KHU",
    "15F6": "CANADIAN SYLLABICS CARRIER KHO",
    "15F7": "CANADIAN SYLLABICS CARRIER KHE",
    "15F8": "CANADIAN SYLLABICS CARRIER KHEE",
    "15F9": "CANADIAN SYLLABICS CARRIER KHI",
    "15FA": "CANADIAN SYLLABICS CARRIER KHA",
    "15FB": "CANADIAN SYLLABICS CARRIER KKU",
    "15FC": "CANADIAN SYLLABICS CARRIER KKO",
    "15FD": "CANADIAN SYLLABICS CARRIER KKE",
    "15FE": "CANADIAN SYLLABICS CARRIER KKEE",
    "15FF": "CANADIAN SYLLABICS CARRIER KKI",
    "1600": "CANADIAN SYLLABICS CARRIER KKA",
    "1601": "CANADIAN SYLLABICS CARRIER KK",
    "1602": "CANADIAN SYLLABICS CARRIER NU",
    "1603": "CANADIAN SYLLABICS CARRIER NO",
    "1604": "CANADIAN SYLLABICS CARRIER NE",
    "1605": "CANADIAN SYLLABICS CARRIER NEE",
    "1606": "CANADIAN SYLLABICS CARRIER NI",
    "1607": "CANADIAN SYLLABICS CARRIER NA",
    "1608": "CANADIAN SYLLABICS CARRIER MU",
    "1609": "CANADIAN SYLLABICS CARRIER MO",
    "160A": "CANADIAN SYLLABICS CARRIER ME",
    "160B": "CANADIAN SYLLABICS CARRIER MEE",
    "160C": "CANADIAN SYLLABICS CARRIER MI",
    "160D": "CANADIAN SYLLABICS CARRIER MA",
    "160E": "CANADIAN SYLLABICS CARRIER YU",
    "160F": "CANADIAN SYLLABICS CARRIER YO",
    "1610": "CANADIAN SYLLABICS CARRIER YE",
    "1611": "CANADIAN SYLLABICS CARRIER YEE",
    "1612": "CANADIAN SYLLABICS CARRIER YI",
    "1613": "CANADIAN SYLLABICS CARRIER YA",
    "1614": "CANADIAN SYLLABICS CARRIER JU",
    "1615": "CANADIAN SYLLABICS SAYISI JU",
    "1616": "CANADIAN SYLLABICS CARRIER JO",
    "1617": "CANADIAN SYLLABICS CARRIER JE",
    "1618": "CANADIAN SYLLABICS CARRIER JEE",
    "1619": "CANADIAN SYLLABICS CARRIER JI",
    "161A": "CANADIAN SYLLABICS SAYISI JI",
    "161B": "CANADIAN SYLLABICS CARRIER JA",
    "161C": "CANADIAN SYLLABICS CARRIER JJU",
    "161D": "CANADIAN SYLLABICS CARRIER JJO",
    "161E": "CANADIAN SYLLABICS CARRIER JJE",
    "161F": "CANADIAN SYLLABICS CARRIER JJEE",
    "1620": "CANADIAN SYLLABICS CARRIER JJI",
    "1621": "CANADIAN SYLLABICS CARRIER JJA",
    "1622": "CANADIAN SYLLABICS CARRIER LU",
    "1623": "CANADIAN SYLLABICS CARRIER LO",
    "1624": "CANADIAN SYLLABICS CARRIER LE",
    "1625": "CANADIAN SYLLABICS CARRIER LEE",
    "1626": "CANADIAN SYLLABICS CARRIER LI",
    "1627": "CANADIAN SYLLABICS CARRIER LA",
    "1628": "CANADIAN SYLLABICS CARRIER DLU",
    "1629": "CANADIAN SYLLABICS CARRIER DLO",
    "162A": "CANADIAN SYLLABICS CARRIER DLE",
    "162B": "CANADIAN SYLLABICS CARRIER DLEE",
    "162C": "CANADIAN SYLLABICS CARRIER DLI",
    "162D": "CANADIAN SYLLABICS CARRIER DLA",
    "162E": "CANADIAN SYLLABICS CARRIER LHU",
    "162F": "CANADIAN SYLLABICS CARRIER LHO",
    "1630": "CANADIAN SYLLABICS CARRIER LHE",
    "1631": "CANADIAN SYLLABICS CARRIER LHEE",
    "1632": "CANADIAN SYLLABICS CARRIER LHI",
    "1633": "CANADIAN SYLLABICS CARRIER LHA",
    "1634": "CANADIAN SYLLABICS CARRIER TLHU",
    "1635": "CANADIAN SYLLABICS CARRIER TLHO",
    "1636": "CANADIAN SYLLABICS CARRIER TLHE",
    "1637": "CANADIAN SYLLABICS CARRIER TLHEE",
    "1638": "CANADIAN SYLLABICS CARRIER TLHI",
    "1639": "CANADIAN SYLLABICS CARRIER TLHA",
    "163A": "CANADIAN SYLLABICS CARRIER TLU",
    "163B": "CANADIAN SYLLABICS CARRIER TLO",
    "163C": "CANADIAN SYLLABICS CARRIER TLE",
    "163D": "CANADIAN SYLLABICS CARRIER TLEE",
    "163E": "CANADIAN SYLLABICS CARRIER TLI",
    "163F": "CANADIAN SYLLABICS CARRIER TLA",
    "1640": "CANADIAN SYLLABICS CARRIER ZU",
    "1641": "CANADIAN SYLLABICS CARRIER ZO",
    "1642": "CANADIAN SYLLABICS CARRIER ZE",
    "1643": "CANADIAN SYLLABICS CARRIER ZEE",
    "1644": "CANADIAN SYLLABICS CARRIER ZI",
    "1645": "CANADIAN SYLLABICS CARRIER ZA",
    "1646": "CANADIAN SYLLABICS CARRIER Z",
    "1647": "CANADIAN SYLLABICS CARRIER INITIAL Z",
    "1648": "CANADIAN SYLLABICS CARRIER DZU",
    "1649": "CANADIAN SYLLABICS CARRIER DZO",
    "164A": "CANADIAN SYLLABICS CARRIER DZE",
    "164B": "CANADIAN SYLLABICS CARRIER DZEE",
    "164C": "CANADIAN SYLLABICS CARRIER DZI",
    "164D": "CANADIAN SYLLABICS CARRIER DZA",
    "164E": "CANADIAN SYLLABICS CARRIER SU",
    "164F": "CANADIAN SYLLABICS CARRIER SO",
    "1650": "CANADIAN SYLLABICS CARRIER SE",
    "1651": "CANADIAN SYLLABICS CARRIER SEE",
    "1652": "CANADIAN SYLLABICS CARRIER SI",
    "1653": "CANADIAN SYLLABICS CARRIER SA",
    "1654": "CANADIAN SYLLABICS CARRIER SHU",
    "1655": "CANADIAN SYLLABICS CARRIER SHO",
    "1656": "CANADIAN SYLLABICS CARRIER SHE",
    "1657": "CANADIAN SYLLABICS CARRIER SHEE",
    "1658": "CANADIAN SYLLABICS CARRIER SHI",
    "1659": "CANADIAN SYLLABICS CARRIER SHA",
    "165A": "CANADIAN SYLLABICS CARRIER SH",
    "165B": "CANADIAN SYLLABICS CARRIER TSU",
    "165C": "CANADIAN SYLLABICS CARRIER TSO",
    "165D": "CANADIAN SYLLABICS CARRIER TSE",
    "165E": "CANADIAN SYLLABICS CARRIER TSEE",
    "165F": "CANADIAN SYLLABICS CARRIER TSI",
    "1660": "CANADIAN SYLLABICS CARRIER TSA",
    "1661": "CANADIAN SYLLABICS CARRIER CHU",
    "1662": "CANADIAN SYLLABICS CARRIER CHO",
    "1663": "CANADIAN SYLLABICS CARRIER CHE",
    "1664": "CANADIAN SYLLABICS CARRIER CHEE",
    "1665": "CANADIAN SYLLABICS CARRIER CHI",
    "1666": "CANADIAN SYLLABICS CARRIER CHA",
    "1667": "CANADIAN SYLLABICS CARRIER TTSU",
    "1668": "CANADIAN SYLLABICS CARRIER TTSO",
    "1669": "CANADIAN SYLLABICS CARRIER TTSE",
    "166A": "CANADIAN SYLLABICS CARRIER TTSEE",
    "166B": "CANADIAN SYLLABICS CARRIER TTSI",
    "166C": "CANADIAN SYLLABICS CARRIER TTSA",
    "166D": "CANADIAN SYLLABICS CHI SIGN",
    "166E": "CANADIAN SYLLABICS FULL STOP",
    "166F": "CANADIAN SYLLABICS QAI",
    "1670": "CANADIAN SYLLABICS NGAI",
    "1671": "CANADIAN SYLLABICS NNGI",
    "1672": "CANADIAN SYLLABICS NNGII",
    "1673": "CANADIAN SYLLABICS NNGO",
    "1674": "CANADIAN SYLLABICS NNGOO",
    "1675": "CANADIAN SYLLABICS NNGA",
    "1676": "CANADIAN SYLLABICS NNGAA",
    "1677": "CANADIAN SYLLABICS WOODS-CREE THWEE",
    "1678": "CANADIAN SYLLABICS WOODS-CREE THWI",
    "1679": "CANADIAN SYLLABICS WOODS-CREE THWII",
    "167A": "CANADIAN SYLLABICS WOODS-CREE THWO",
    "167B": "CANADIAN SYLLABICS WOODS-CREE THWOO",
    "167C": "CANADIAN SYLLABICS WOODS-CREE THWA",
    "167D": "CANADIAN SYLLABICS WOODS-CREE THWAA",
    "167E": "CANADIAN SYLLABICS WOODS-CREE FINAL TH",
    "167F": "CANADIAN SYLLABICS BLACKFOOT W",
    "1680": "OGHAM SPACE MARK",
    "1681": "OGHAM LETTER BEITH",
    "1682": "OGHAM LETTER LUIS",
    "1683": "OGHAM LETTER FEARN",
    "1684": "OGHAM LETTER SAIL",
    "1685": "OGHAM LETTER NION",
    "1686": "OGHAM LETTER UATH",
    "1687": "OGHAM LETTER DAIR",
    "1688": "OGHAM LETTER TINNE",
    "1689": "OGHAM LETTER COLL",
    "168A": "OGHAM LETTER CEIRT",
    "168B": "OGHAM LETTER MUIN",
    "168C": "OGHAM LETTER GORT",
    "168D": "OGHAM LETTER NGEADAL",
    "168E": "OGHAM LETTER STRAIF",
    "168F": "OGHAM LETTER RUIS",
    "1690": "OGHAM LETTER AILM",
    "1691": "OGHAM LETTER ONN",
    "1692": "OGHAM LETTER UR",
    "1693": "OGHAM LETTER EADHADH",
    "1694": "OGHAM LETTER IODHADH",
    "1695": "OGHAM LETTER EABHADH",
    "1696": "OGHAM LETTER OR",
    "1697": "OGHAM LETTER UILLEANN",
    "1698": "OGHAM LETTER IFIN",
    "1699": "OGHAM LETTER EAMHANCHOLL",
    "169A": "OGHAM LETTER PEITH",
    "169B": "OGHAM FEATHER MARK",
    "169C": "OGHAM REVERSED FEATHER MARK",
    "16A0": "RUNIC LETTER FEHU FEOH FE F",
    "16A1": "RUNIC LETTER V",
    "16A2": "RUNIC LETTER URUZ UR U",
    "16A3": "RUNIC LETTER YR",
    "16A4": "RUNIC LETTER Y",
    "16A5": "RUNIC LETTER W",
    "16A6": "RUNIC LETTER THURISAZ THURS THORN",
    "16A7": "RUNIC LETTER ETH",
    "16A8": "RUNIC LETTER ANSUZ A",
    "16A9": "RUNIC LETTER OS O",
    "16AA": "RUNIC LETTER AC A",
    "16AB": "RUNIC LETTER AESC",
    "16AC": "RUNIC LETTER LONG-BRANCH-OSS O",
    "16AD": "RUNIC LETTER SHORT-TWIG-OSS O",
    "16AE": "RUNIC LETTER O",
    "16AF": "RUNIC LETTER OE",
    "16B0": "RUNIC LETTER ON",
    "16B1": "RUNIC LETTER RAIDO RAD REID R",
    "16B2": "RUNIC LETTER KAUNA",
    "16B3": "RUNIC LETTER CEN",
    "16B4": "RUNIC LETTER KAUN K",
    "16B5": "RUNIC LETTER G",
    "16B6": "RUNIC LETTER ENG",
    "16B7": "RUNIC LETTER GEBO GYFU G",
    "16B8": "RUNIC LETTER GAR",
    "16B9": "RUNIC LETTER WUNJO WYNN W",
    "16BA": "RUNIC LETTER HAGLAZ H",
    "16BB": "RUNIC LETTER HAEGL H",
    "16BC": "RUNIC LETTER LONG-BRANCH-HAGALL H",
    "16BD": "RUNIC LETTER SHORT-TWIG-HAGALL H",
    "16BE": "RUNIC LETTER NAUDIZ NYD NAUD N",
    "16BF": "RUNIC LETTER SHORT-TWIG-NAUD N",
    "16C0": "RUNIC LETTER DOTTED-N",
    "16C1": "RUNIC LETTER ISAZ IS ISS I",
    "16C2": "RUNIC LETTER E",
    "16C3": "RUNIC LETTER JERAN J",
    "16C4": "RUNIC LETTER GER",
    "16C5": "RUNIC LETTER LONG-BRANCH-AR AE",
    "16C6": "RUNIC LETTER SHORT-TWIG-AR A",
    "16C7": "RUNIC LETTER IWAZ EOH",
    "16C8": "RUNIC LETTER PERTHO PEORTH P",
    "16C9": "RUNIC LETTER ALGIZ EOLHX",
    "16CA": "RUNIC LETTER SOWILO S",
    "16CB": "RUNIC LETTER SIGEL LONG-BRANCH-SOL S",
    "16CC": "RUNIC LETTER SHORT-TWIG-SOL S",
    "16CD": "RUNIC LETTER C",
    "16CE": "RUNIC LETTER Z",
    "16CF": "RUNIC LETTER TIWAZ TIR TYR T",
    "16D0": "RUNIC LETTER SHORT-TWIG-TYR T",
    "16D1": "RUNIC LETTER D",
    "16D2": "RUNIC LETTER BERKANAN BEORC BJARKAN B",
    "16D3": "RUNIC LETTER SHORT-TWIG-BJARKAN B",
    "16D4": "RUNIC LETTER DOTTED-P",
    "16D5": "RUNIC LETTER OPEN-P",
    "16D6": "RUNIC LETTER EHWAZ EH E",
    "16D7": "RUNIC LETTER MANNAZ MAN M",
    "16D8": "RUNIC LETTER LONG-BRANCH-MADR M",
    "16D9": "RUNIC LETTER SHORT-TWIG-MADR M",
    "16DA": "RUNIC LETTER LAUKAZ LAGU LOGR L",
    "16DB": "RUNIC LETTER DOTTED-L",
    "16DC": "RUNIC LETTER INGWAZ",
    "16DD": "RUNIC LETTER ING",
    "16DE": "RUNIC LETTER DAGAZ DAEG D",
    "16DF": "RUNIC LETTER OTHALAN ETHEL O",
    "16E0": "RUNIC LETTER EAR",
    "16E1": "RUNIC LETTER IOR",
    "16E2": "RUNIC LETTER CWEORTH",
    "16E3": "RUNIC LETTER CALC",
    "16E4": "RUNIC LETTER CEALC",
    "16E5": "RUNIC LETTER STAN",
    "16E6": "RUNIC LETTER LONG-BRANCH-YR",
    "16E7": "RUNIC LETTER SHORT-TWIG-YR",
    "16E8": "RUNIC LETTER ICELANDIC-YR",
    "16E9": "RUNIC LETTER Q",
    "16EA": "RUNIC LETTER X",
    "16EB": "RUNIC SINGLE PUNCTUATION",
    "16EC": "RUNIC MULTIPLE PUNCTUATION",
    "16ED": "RUNIC CROSS PUNCTUATION",
    "16EE": "RUNIC ARLAUG SYMBOL",
    "16EF": "RUNIC TVIMADUR SYMBOL",
    "16F0": "RUNIC BELGTHOR SYMBOL",
    "16F1": "RUNIC LETTER K",
    "16F2": "RUNIC LETTER SH",
    "16F3": "RUNIC LETTER OO",
    "16F4": "RUNIC LETTER FRANKS CASKET OS",
    "16F5": "RUNIC LETTER FRANKS CASKET IS",
    "16F6": "RUNIC LETTER FRANKS CASKET EH",
    "16F7": "RUNIC LETTER FRANKS CASKET AC",
    "16F8": "RUNIC LETTER FRANKS CASKET AESC",
    "1700": "TAGALOG LETTER A",
    "1701": "TAGALOG LETTER I",
    "1702": "TAGALOG LETTER U",
    "1703": "TAGALOG LETTER KA",
    "1704": "TAGALOG LETTER GA",
    "1705": "TAGALOG LETTER NGA",
    "1706": "TAGALOG LETTER TA",
    "1707": "TAGALOG LETTER DA",
    "1708": "TAGALOG LETTER NA",
    "1709": "TAGALOG LETTER PA",
    "170A": "TAGALOG LETTER BA",
    "170B": "TAGALOG LETTER MA",
    "170C": "TAGALOG LETTER YA",
    "170E": "TAGALOG LETTER LA",
    "170F": "TAGALOG LETTER WA",
    "1710": "TAGALOG LETTER SA",
    "1711": "TAGALOG LETTER HA",
    "1712": "TAGALOG VOWEL SIGN I",
    "1713": "TAGALOG VOWEL SIGN U",
    "1714": "TAGALOG SIGN VIRAMA",
    "1720": "HANUNOO LETTER A",
    "1721": "HANUNOO LETTER I",
    "1722": "HANUNOO LETTER U",
    "1723": "HANUNOO LETTER KA",
    "1724": "HANUNOO LETTER GA",
    "1725": "HANUNOO LETTER NGA",
    "1726": "HANUNOO LETTER TA",
    "1727": "HANUNOO LETTER DA",
    "1728": "HANUNOO LETTER NA",
    "1729": "HANUNOO LETTER PA",
    "172A": "HANUNOO LETTER BA",
    "172B": "HANUNOO LETTER MA",
    "172C": "HANUNOO LETTER YA",
    "172D": "HANUNOO LETTER RA",
    "172E": "HANUNOO LETTER LA",
    "172F": "HANUNOO LETTER WA",
    "1730": "HANUNOO LETTER SA",
    "1731": "HANUNOO LETTER HA",
    "1732": "HANUNOO VOWEL SIGN I",
    "1733": "HANUNOO VOWEL SIGN U",
    "1734": "HANUNOO SIGN PAMUDPOD",
    "1735": "PHILIPPINE SINGLE PUNCTUATION",
    "1736": "PHILIPPINE DOUBLE PUNCTUATION",
    "1740": "BUHID LETTER A",
    "1741": "BUHID LETTER I",
    "1742": "BUHID LETTER U",
    "1743": "BUHID LETTER KA",
    "1744": "BUHID LETTER GA",
    "1745": "BUHID LETTER NGA",
    "1746": "BUHID LETTER TA",
    "1747": "BUHID LETTER DA",
    "1748": "BUHID LETTER NA",
    "1749": "BUHID LETTER PA",
    "174A": "BUHID LETTER BA",
    "174B": "BUHID LETTER MA",
    "174C": "BUHID LETTER YA",
    "174D": "BUHID LETTER RA",
    "174E": "BUHID LETTER LA",
    "174F": "BUHID LETTER WA",
    "1750": "BUHID LETTER SA",
    "1751": "BUHID LETTER HA",
    "1752": "BUHID VOWEL SIGN I",
    "1753": "BUHID VOWEL SIGN U",
    "1760": "TAGBANWA LETTER A",
    "1761": "TAGBANWA LETTER I",
    "1762": "TAGBANWA LETTER U",
    "1763": "TAGBANWA LETTER KA",
    "1764": "TAGBANWA LETTER GA",
    "1765": "TAGBANWA LETTER NGA",
    "1766": "TAGBANWA LETTER TA",
    "1767": "TAGBANWA LETTER DA",
    "1768": "TAGBANWA LETTER NA",
    "1769": "TAGBANWA LETTER PA",
    "176A": "TAGBANWA LETTER BA",
    "176B": "TAGBANWA LETTER MA",
    "176C": "TAGBANWA LETTER YA",
    "176E": "TAGBANWA LETTER LA",
    "176F": "TAGBANWA LETTER WA",
    "1770": "TAGBANWA LETTER SA",
    "1772": "TAGBANWA VOWEL SIGN I",
    "1773": "TAGBANWA VOWEL SIGN U",
    "1780": "KHMER LETTER KA",
    "1781": "KHMER LETTER KHA",
    "1782": "KHMER LETTER KO",
    "1783": "KHMER LETTER KHO",
    "1784": "KHMER LETTER NGO",
    "1785": "KHMER LETTER CA",
    "1786": "KHMER LETTER CHA",
    "1787": "KHMER LETTER CO",
    "1788": "KHMER LETTER CHO",
    "1789": "KHMER LETTER NYO",
    "178A": "KHMER LETTER DA",
    "178B": "KHMER LETTER TTHA",
    "178C": "KHMER LETTER DO",
    "178D": "KHMER LETTER TTHO",
    "178E": "KHMER LETTER NNO",
    "178F": "KHMER LETTER TA",
    "1790": "KHMER LETTER THA",
    "1791": "KHMER LETTER TO",
    "1792": "KHMER LETTER THO",
    "1793": "KHMER LETTER NO",
    "1794": "KHMER LETTER BA",
    "1795": "KHMER LETTER PHA",
    "1796": "KHMER LETTER PO",
    "1797": "KHMER LETTER PHO",
    "1798": "KHMER LETTER MO",
    "1799": "KHMER LETTER YO",
    "179A": "KHMER LETTER RO",
    "179B": "KHMER LETTER LO",
    "179C": "KHMER LETTER VO",
    "179D": "KHMER LETTER SHA",
    "179E": "KHMER LETTER SSO",
    "179F": "KHMER LETTER SA",
    "17A0": "KHMER LETTER HA",
    "17A1": "KHMER LETTER LA",
    "17A2": "KHMER LETTER QA",
    "17A3": "KHMER INDEPENDENT VOWEL QAQ",
    "17A4": "KHMER INDEPENDENT VOWEL QAA",
    "17A5": "KHMER INDEPENDENT VOWEL QI",
    "17A6": "KHMER INDEPENDENT VOWEL QII",
    "17A7": "KHMER INDEPENDENT VOWEL QU",
    "17A8": "KHMER INDEPENDENT VOWEL QUK",
    "17A9": "KHMER INDEPENDENT VOWEL QUU",
    "17AA": "KHMER INDEPENDENT VOWEL QUUV",
    "17AB": "KHMER INDEPENDENT VOWEL RY",
    "17AC": "KHMER INDEPENDENT VOWEL RYY",
    "17AD": "KHMER INDEPENDENT VOWEL LY",
    "17AE": "KHMER INDEPENDENT VOWEL LYY",
    "17AF": "KHMER INDEPENDENT VOWEL QE",
    "17B0": "KHMER INDEPENDENT VOWEL QAI",
    "17B1": "KHMER INDEPENDENT VOWEL QOO TYPE ONE",
    "17B2": "KHMER INDEPENDENT VOWEL QOO TYPE TWO",
    "17B3": "KHMER INDEPENDENT VOWEL QAU",
    "17B4": "KHMER VOWEL INHERENT AQ",
    "17B5": "KHMER VOWEL INHERENT AA",
    "17B6": "KHMER VOWEL SIGN AA",
    "17B7": "KHMER VOWEL SIGN I",
    "17B8": "KHMER VOWEL SIGN II",
    "17B9": "KHMER VOWEL SIGN Y",
    "17BA": "KHMER VOWEL SIGN YY",
    "17BB": "KHMER VOWEL SIGN U",
    "17BC": "KHMER VOWEL SIGN UU",
    "17BD": "KHMER VOWEL SIGN UA",
    "17BE": "KHMER VOWEL SIGN OE",
    "17BF": "KHMER VOWEL SIGN YA",
    "17C0": "KHMER VOWEL SIGN IE",
    "17C1": "KHMER VOWEL SIGN E",
    "17C2": "KHMER VOWEL SIGN AE",
    "17C3": "KHMER VOWEL SIGN AI",
    "17C4": "KHMER VOWEL SIGN OO",
    "17C5": "KHMER VOWEL SIGN AU",
    "17C6": "KHMER SIGN NIKAHIT",
    "17C7": "KHMER SIGN REAHMUK",
    "17C8": "KHMER SIGN YUUKALEAPINTU",
    "17C9": "KHMER SIGN MUUSIKATOAN",
    "17CA": "KHMER SIGN TRIISAP",
    "17CB": "KHMER SIGN BANTOC",
    "17CC": "KHMER SIGN ROBAT",
    "17CD": "KHMER SIGN TOANDAKHIAT",
    "17CE": "KHMER SIGN KAKABAT",
    "17CF": "KHMER SIGN AHSDA",
    "17D0": "KHMER SIGN SAMYOK SANNYA",
    "17D1": "KHMER SIGN VIRIAM",
    "17D2": "KHMER SIGN COENG",
    "17D3": "KHMER SIGN BATHAMASAT",
    "17D4": "KHMER SIGN KHAN",
    "17D5": "KHMER SIGN BARIYOOSAN",
    "17D6": "KHMER SIGN CAMNUC PII KUUH",
    "17D7": "KHMER SIGN LEK TOO",
    "17D8": "KHMER SIGN BEYYAL",
    "17D9": "KHMER SIGN PHNAEK MUAN",
    "17DA": "KHMER SIGN KOOMUUT",
    "17DB": "KHMER CURRENCY SYMBOL RIEL",
    "17DC": "KHMER SIGN AVAKRAHASANYA",
    "17DD": "KHMER SIGN ATTHACAN",
    "17E0": "KHMER DIGIT ZERO",
    "17E1": "KHMER DIGIT ONE",
    "17E2": "KHMER DIGIT TWO",
    "17E3": "KHMER DIGIT THREE",
    "17E4": "KHMER DIGIT FOUR",
    "17E5": "KHMER DIGIT FIVE",
    "17E6": "KHMER DIGIT SIX",
    "17E7": "KHMER DIGIT SEVEN",
    "17E8": "KHMER DIGIT EIGHT",
    "17E9": "KHMER DIGIT NINE",
    "17F0": "KHMER SYMBOL LEK ATTAK SON",
    "17F1": "KHMER SYMBOL LEK ATTAK MUOY",
    "17F2": "KHMER SYMBOL LEK ATTAK PII",
    "17F3": "KHMER SYMBOL LEK ATTAK BEI",
    "17F4": "KHMER SYMBOL LEK ATTAK BUON",
    "17F5": "KHMER SYMBOL LEK ATTAK PRAM",
    "17F6": "KHMER SYMBOL LEK ATTAK PRAM-MUOY",
    "17F7": "KHMER SYMBOL LEK ATTAK PRAM-PII",
    "17F8": "KHMER SYMBOL LEK ATTAK PRAM-BEI",
    "17F9": "KHMER SYMBOL LEK ATTAK PRAM-BUON",
    "1800": "MONGOLIAN BIRGA",
    "1801": "MONGOLIAN ELLIPSIS",
    "1802": "MONGOLIAN COMMA",
    "1803": "MONGOLIAN FULL STOP",
    "1804": "MONGOLIAN COLON",
    "1805": "MONGOLIAN FOUR DOTS",
    "1806": "MONGOLIAN TODO SOFT HYPHEN",
    "1807": "MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER",
    "1808": "MONGOLIAN MANCHU COMMA",
    "1809": "MONGOLIAN MANCHU FULL STOP",
    "180A": "MONGOLIAN NIRUGU",
    "180B": "MONGOLIAN FREE VARIATION SELECTOR ONE",
    "180C": "MONGOLIAN FREE VARIATION SELECTOR TWO",
    "180D": "MONGOLIAN FREE VARIATION SELECTOR THREE",
    "180E": "MONGOLIAN VOWEL SEPARATOR",
    "1810": "MONGOLIAN DIGIT ZERO",
    "1811": "MONGOLIAN DIGIT ONE",
    "1812": "MONGOLIAN DIGIT TWO",
    "1813": "MONGOLIAN DIGIT THREE",
    "1814": "MONGOLIAN DIGIT FOUR",
    "1815": "MONGOLIAN DIGIT FIVE",
    "1816": "MONGOLIAN DIGIT SIX",
    "1817": "MONGOLIAN DIGIT SEVEN",
    "1818": "MONGOLIAN DIGIT EIGHT",
    "1819": "MONGOLIAN DIGIT NINE",
    "1820": "MONGOLIAN LETTER A",
    "1821": "MONGOLIAN LETTER E",
    "1822": "MONGOLIAN LETTER I",
    "1823": "MONGOLIAN LETTER O",
    "1824": "MONGOLIAN LETTER U",
    "1825": "MONGOLIAN LETTER OE",
    "1826": "MONGOLIAN LETTER UE",
    "1827": "MONGOLIAN LETTER EE",
    "1828": "MONGOLIAN LETTER NA",
    "1829": "MONGOLIAN LETTER ANG",
    "182A": "MONGOLIAN LETTER BA",
    "182B": "MONGOLIAN LETTER PA",
    "182C": "MONGOLIAN LETTER QA",
    "182D": "MONGOLIAN LETTER GA",
    "182E": "MONGOLIAN LETTER MA",
    "182F": "MONGOLIAN LETTER LA",
    "1830": "MONGOLIAN LETTER SA",
    "1831": "MONGOLIAN LETTER SHA",
    "1832": "MONGOLIAN LETTER TA",
    "1833": "MONGOLIAN LETTER DA",
    "1834": "MONGOLIAN LETTER CHA",
    "1835": "MONGOLIAN LETTER JA",
    "1836": "MONGOLIAN LETTER YA",
    "1837": "MONGOLIAN LETTER RA",
    "1838": "MONGOLIAN LETTER WA",
    "1839": "MONGOLIAN LETTER FA",
    "183A": "MONGOLIAN LETTER KA",
    "183B": "MONGOLIAN LETTER KHA",
    "183C": "MONGOLIAN LETTER TSA",
    "183D": "MONGOLIAN LETTER ZA",
    "183E": "MONGOLIAN LETTER HAA",
    "183F": "MONGOLIAN LETTER ZRA",
    "1840": "MONGOLIAN LETTER LHA",
    "1841": "MONGOLIAN LETTER ZHI",
    "1842": "MONGOLIAN LETTER CHI",
    "1843": "MONGOLIAN LETTER TODO LONG VOWEL SIGN",
    "1844": "MONGOLIAN LETTER TODO E",
    "1845": "MONGOLIAN LETTER TODO I",
    "1846": "MONGOLIAN LETTER TODO O",
    "1847": "MONGOLIAN LETTER TODO U",
    "1848": "MONGOLIAN LETTER TODO OE",
    "1849": "MONGOLIAN LETTER TODO UE",
    "184A": "MONGOLIAN LETTER TODO ANG",
    "184B": "MONGOLIAN LETTER TODO BA",
    "184C": "MONGOLIAN LETTER TODO PA",
    "184D": "MONGOLIAN LETTER TODO QA",
    "184E": "MONGOLIAN LETTER TODO GA",
    "184F": "MONGOLIAN LETTER TODO MA",
    "1850": "MONGOLIAN LETTER TODO TA",
    "1851": "MONGOLIAN LETTER TODO DA",
    "1852": "MONGOLIAN LETTER TODO CHA",
    "1853": "MONGOLIAN LETTER TODO JA",
    "1854": "MONGOLIAN LETTER TODO TSA",
    "1855": "MONGOLIAN LETTER TODO YA",
    "1856": "MONGOLIAN LETTER TODO WA",
    "1857": "MONGOLIAN LETTER TODO KA",
    "1858": "MONGOLIAN LETTER TODO GAA",
    "1859": "MONGOLIAN LETTER TODO HAA",
    "185A": "MONGOLIAN LETTER TODO JIA",
    "185B": "MONGOLIAN LETTER TODO NIA",
    "185C": "MONGOLIAN LETTER TODO DZA",
    "185D": "MONGOLIAN LETTER SIBE E",
    "185E": "MONGOLIAN LETTER SIBE I",
    "185F": "MONGOLIAN LETTER SIBE IY",
    "1860": "MONGOLIAN LETTER SIBE UE",
    "1861": "MONGOLIAN LETTER SIBE U",
    "1862": "MONGOLIAN LETTER SIBE ANG",
    "1863": "MONGOLIAN LETTER SIBE KA",
    "1864": "MONGOLIAN LETTER SIBE GA",
    "1865": "MONGOLIAN LETTER SIBE HA",
    "1866": "MONGOLIAN LETTER SIBE PA",
    "1867": "MONGOLIAN LETTER SIBE SHA",
    "1868": "MONGOLIAN LETTER SIBE TA",
    "1869": "MONGOLIAN LETTER SIBE DA",
    "186A": "MONGOLIAN LETTER SIBE JA",
    "186B": "MONGOLIAN LETTER SIBE FA",
    "186C": "MONGOLIAN LETTER SIBE GAA",
    "186D": "MONGOLIAN LETTER SIBE HAA",
    "186E": "MONGOLIAN LETTER SIBE TSA",
    "186F": "MONGOLIAN LETTER SIBE ZA",
    "1870": "MONGOLIAN LETTER SIBE RAA",
    "1871": "MONGOLIAN LETTER SIBE CHA",
    "1872": "MONGOLIAN LETTER SIBE ZHA",
    "1873": "MONGOLIAN LETTER MANCHU I",
    "1874": "MONGOLIAN LETTER MANCHU KA",
    "1875": "MONGOLIAN LETTER MANCHU RA",
    "1876": "MONGOLIAN LETTER MANCHU FA",
    "1877": "MONGOLIAN LETTER MANCHU ZHA",
    "1880": "MONGOLIAN LETTER ALI GALI ANUSVARA ONE",
    "1881": "MONGOLIAN LETTER ALI GALI VISARGA ONE",
    "1882": "MONGOLIAN LETTER ALI GALI DAMARU",
    "1883": "MONGOLIAN LETTER ALI GALI UBADAMA",
    "1884": "MONGOLIAN LETTER ALI GALI INVERTED UBADAMA",
    "1885": "MONGOLIAN LETTER ALI GALI BALUDA",
    "1886": "MONGOLIAN LETTER ALI GALI THREE BALUDA",
    "1887": "MONGOLIAN LETTER ALI GALI A",
    "1888": "MONGOLIAN LETTER ALI GALI I",
    "1889": "MONGOLIAN LETTER ALI GALI KA",
    "188A": "MONGOLIAN LETTER ALI GALI NGA",
    "188B": "MONGOLIAN LETTER ALI GALI CA",
    "188C": "MONGOLIAN LETTER ALI GALI TTA",
    "188D": "MONGOLIAN LETTER ALI GALI TTHA",
    "188E": "MONGOLIAN LETTER ALI GALI DDA",
    "188F": "MONGOLIAN LETTER ALI GALI NNA",
    "1890": "MONGOLIAN LETTER ALI GALI TA",
    "1891": "MONGOLIAN LETTER ALI GALI DA",
    "1892": "MONGOLIAN LETTER ALI GALI PA",
    "1893": "MONGOLIAN LETTER ALI GALI PHA",
    "1894": "MONGOLIAN LETTER ALI GALI SSA",
    "1895": "MONGOLIAN LETTER ALI GALI ZHA",
    "1896": "MONGOLIAN LETTER ALI GALI ZA",
    "1897": "MONGOLIAN LETTER ALI GALI AH",
    "1898": "MONGOLIAN LETTER TODO ALI GALI TA",
    "1899": "MONGOLIAN LETTER TODO ALI GALI ZHA",
    "189A": "MONGOLIAN LETTER MANCHU ALI GALI GHA",
    "189B": "MONGOLIAN LETTER MANCHU ALI GALI NGA",
    "189C": "MONGOLIAN LETTER MANCHU ALI GALI CA",
    "189D": "MONGOLIAN LETTER MANCHU ALI GALI JHA",
    "189E": "MONGOLIAN LETTER MANCHU ALI GALI TTA",
    "189F": "MONGOLIAN LETTER MANCHU ALI GALI DDHA",
    "18A0": "MONGOLIAN LETTER MANCHU ALI GALI TA",
    "18A1": "MONGOLIAN LETTER MANCHU ALI GALI DHA",
    "18A2": "MONGOLIAN LETTER MANCHU ALI GALI SSA",
    "18A3": "MONGOLIAN LETTER MANCHU ALI GALI CYA",
    "18A4": "MONGOLIAN LETTER MANCHU ALI GALI ZHA",
    "18A5": "MONGOLIAN LETTER MANCHU ALI GALI ZA",
    "18A6": "MONGOLIAN LETTER ALI GALI HALF U",
    "18A7": "MONGOLIAN LETTER ALI GALI HALF YA",
    "18A8": "MONGOLIAN LETTER MANCHU ALI GALI BHA",
    "18A9": "MONGOLIAN LETTER ALI GALI DAGALGA",
    "18AA": "MONGOLIAN LETTER MANCHU ALI GALI LHA",
    "18B0": "CANADIAN SYLLABICS OY",
    "18B1": "CANADIAN SYLLABICS AY",
    "18B2": "CANADIAN SYLLABICS AAY",
    "18B3": "CANADIAN SYLLABICS WAY",
    "18B4": "CANADIAN SYLLABICS POY",
    "18B5": "CANADIAN SYLLABICS PAY",
    "18B6": "CANADIAN SYLLABICS PWOY",
    "18B7": "CANADIAN SYLLABICS TAY",
    "18B8": "CANADIAN SYLLABICS KAY",
    "18B9": "CANADIAN SYLLABICS KWAY",
    "18BA": "CANADIAN SYLLABICS MAY",
    "18BB": "CANADIAN SYLLABICS NOY",
    "18BC": "CANADIAN SYLLABICS NAY",
    "18BD": "CANADIAN SYLLABICS LAY",
    "18BE": "CANADIAN SYLLABICS SOY",
    "18BF": "CANADIAN SYLLABICS SAY",
    "18C0": "CANADIAN SYLLABICS SHOY",
    "18C1": "CANADIAN SYLLABICS SHAY",
    "18C2": "CANADIAN SYLLABICS SHWOY",
    "18C3": "CANADIAN SYLLABICS YOY",
    "18C4": "CANADIAN SYLLABICS YAY",
    "18C5": "CANADIAN SYLLABICS RAY",
    "18C6": "CANADIAN SYLLABICS NWI",
    "18C7": "CANADIAN SYLLABICS OJIBWAY NWI",
    "18C8": "CANADIAN SYLLABICS NWII",
    "18C9": "CANADIAN SYLLABICS OJIBWAY NWII",
    "18CA": "CANADIAN SYLLABICS NWO",
    "18CB": "CANADIAN SYLLABICS OJIBWAY NWO",
    "18CC": "CANADIAN SYLLABICS NWOO",
    "18CD": "CANADIAN SYLLABICS OJIBWAY NWOO",
    "18CE": "CANADIAN SYLLABICS RWEE",
    "18CF": "CANADIAN SYLLABICS RWI",
    "18D0": "CANADIAN SYLLABICS RWII",
    "18D1": "CANADIAN SYLLABICS RWO",
    "18D2": "CANADIAN SYLLABICS RWOO",
    "18D3": "CANADIAN SYLLABICS RWA",
    "18D4": "CANADIAN SYLLABICS OJIBWAY P",
    "18D5": "CANADIAN SYLLABICS OJIBWAY T",
    "18D6": "CANADIAN SYLLABICS OJIBWAY K",
    "18D7": "CANADIAN SYLLABICS OJIBWAY C",
    "18D8": "CANADIAN SYLLABICS OJIBWAY M",
    "18D9": "CANADIAN SYLLABICS OJIBWAY N",
    "18DA": "CANADIAN SYLLABICS OJIBWAY S",
    "18DB": "CANADIAN SYLLABICS OJIBWAY SH",
    "18DC": "CANADIAN SYLLABICS EASTERN W",
    "18DD": "CANADIAN SYLLABICS WESTERN W",
    "18DE": "CANADIAN SYLLABICS FINAL SMALL RING",
    "18DF": "CANADIAN SYLLABICS FINAL RAISED DOT",
    "18E0": "CANADIAN SYLLABICS R-CREE RWE",
    "18E1": "CANADIAN SYLLABICS WEST-CREE LOO",
    "18E2": "CANADIAN SYLLABICS WEST-CREE LAA",
    "18E3": "CANADIAN SYLLABICS THWE",
    "18E4": "CANADIAN SYLLABICS THWA",
    "18E5": "CANADIAN SYLLABICS TTHWE",
    "18E6": "CANADIAN SYLLABICS TTHOO",
    "18E7": "CANADIAN SYLLABICS TTHAA",
    "18E8": "CANADIAN SYLLABICS TLHWE",
    "18E9": "CANADIAN SYLLABICS TLHOO",
    "18EA": "CANADIAN SYLLABICS SAYISI SHWE",
    "18EB": "CANADIAN SYLLABICS SAYISI SHOO",
    "18EC": "CANADIAN SYLLABICS SAYISI HOO",
    "18ED": "CANADIAN SYLLABICS CARRIER GWU",
    "18EE": "CANADIAN SYLLABICS CARRIER DENE GEE",
    "18EF": "CANADIAN SYLLABICS CARRIER GAA",
    "18F0": "CANADIAN SYLLABICS CARRIER GWA",
    "18F1": "CANADIAN SYLLABICS SAYISI JUU",
    "18F2": "CANADIAN SYLLABICS CARRIER JWA",
    "18F3": "CANADIAN SYLLABICS BEAVER DENE L",
    "18F4": "CANADIAN SYLLABICS BEAVER DENE R",
    "18F5": "CANADIAN SYLLABICS CARRIER DENTAL S",
    "1900": "LIMBU VOWEL-CARRIER LETTER",
    "1901": "LIMBU LETTER KA",
    "1902": "LIMBU LETTER KHA",
    "1903": "LIMBU LETTER GA",
    "1904": "LIMBU LETTER GHA",
    "1905": "LIMBU LETTER NGA",
    "1906": "LIMBU LETTER CA",
    "1907": "LIMBU LETTER CHA",
    "1908": "LIMBU LETTER JA",
    "1909": "LIMBU LETTER JHA",
    "190A": "LIMBU LETTER YAN",
    "190B": "LIMBU LETTER TA",
    "190C": "LIMBU LETTER THA",
    "190D": "LIMBU LETTER DA",
    "190E": "LIMBU LETTER DHA",
    "190F": "LIMBU LETTER NA",
    "1910": "LIMBU LETTER PA",
    "1911": "LIMBU LETTER PHA",
    "1912": "LIMBU LETTER BA",
    "1913": "LIMBU LETTER BHA",
    "1914": "LIMBU LETTER MA",
    "1915": "LIMBU LETTER YA",
    "1916": "LIMBU LETTER RA",
    "1917": "LIMBU LETTER LA",
    "1918": "LIMBU LETTER WA",
    "1919": "LIMBU LETTER SHA",
    "191A": "LIMBU LETTER SSA",
    "191B": "LIMBU LETTER SA",
    "191C": "LIMBU LETTER HA",
    "191D": "LIMBU LETTER GYAN",
    "191E": "LIMBU LETTER TRA",
    "1920": "LIMBU VOWEL SIGN A",
    "1921": "LIMBU VOWEL SIGN I",
    "1922": "LIMBU VOWEL SIGN U",
    "1923": "LIMBU VOWEL SIGN EE",
    "1924": "LIMBU VOWEL SIGN AI",
    "1925": "LIMBU VOWEL SIGN OO",
    "1926": "LIMBU VOWEL SIGN AU",
    "1927": "LIMBU VOWEL SIGN E",
    "1928": "LIMBU VOWEL SIGN O",
    "1929": "LIMBU SUBJOINED LETTER YA",
    "192A": "LIMBU SUBJOINED LETTER RA",
    "192B": "LIMBU SUBJOINED LETTER WA",
    "1930": "LIMBU SMALL LETTER KA",
    "1931": "LIMBU SMALL LETTER NGA",
    "1932": "LIMBU SMALL LETTER ANUSVARA",
    "1933": "LIMBU SMALL LETTER TA",
    "1934": "LIMBU SMALL LETTER NA",
    "1935": "LIMBU SMALL LETTER PA",
    "1936": "LIMBU SMALL LETTER MA",
    "1937": "LIMBU SMALL LETTER RA",
    "1938": "LIMBU SMALL LETTER LA",
    "1939": "LIMBU SIGN MUKPHRENG",
    "193A": "LIMBU SIGN KEMPHRENG",
    "193B": "LIMBU SIGN SA-I",
    "1940": "LIMBU SIGN LOO",
    "1944": "LIMBU EXCLAMATION MARK",
    "1945": "LIMBU QUESTION MARK",
    "1946": "LIMBU DIGIT ZERO",
    "1947": "LIMBU DIGIT ONE",
    "1948": "LIMBU DIGIT TWO",
    "1949": "LIMBU DIGIT THREE",
    "194A": "LIMBU DIGIT FOUR",
    "194B": "LIMBU DIGIT FIVE",
    "194C": "LIMBU DIGIT SIX",
    "194D": "LIMBU DIGIT SEVEN",
    "194E": "LIMBU DIGIT EIGHT",
    "194F": "LIMBU DIGIT NINE",
    "1950": "TAI LE LETTER KA",
    "1951": "TAI LE LETTER XA",
    "1952": "TAI LE LETTER NGA",
    "1953": "TAI LE LETTER TSA",
    "1954": "TAI LE LETTER SA",
    "1955": "TAI LE LETTER YA",
    "1956": "TAI LE LETTER TA",
    "1957": "TAI LE LETTER THA",
    "1958": "TAI LE LETTER LA",
    "1959": "TAI LE LETTER PA",
    "195A": "TAI LE LETTER PHA",
    "195B": "TAI LE LETTER MA",
    "195C": "TAI LE LETTER FA",
    "195D": "TAI LE LETTER VA",
    "195E": "TAI LE LETTER HA",
    "195F": "TAI LE LETTER QA",
    "1960": "TAI LE LETTER KHA",
    "1961": "TAI LE LETTER TSHA",
    "1962": "TAI LE LETTER NA",
    "1963": "TAI LE LETTER A",
    "1964": "TAI LE LETTER I",
    "1965": "TAI LE LETTER EE",
    "1966": "TAI LE LETTER EH",
    "1967": "TAI LE LETTER U",
    "1968": "TAI LE LETTER OO",
    "1969": "TAI LE LETTER O",
    "196A": "TAI LE LETTER UE",
    "196B": "TAI LE LETTER E",
    "196C": "TAI LE LETTER AUE",
    "196D": "TAI LE LETTER AI",
    "1970": "TAI LE LETTER TONE-2",
    "1971": "TAI LE LETTER TONE-3",
    "1972": "TAI LE LETTER TONE-4",
    "1973": "TAI LE LETTER TONE-5",
    "1974": "TAI LE LETTER TONE-6",
    "1980": "NEW TAI LUE LETTER HIGH QA",
    "1981": "NEW TAI LUE LETTER LOW QA",
    "1982": "NEW TAI LUE LETTER HIGH KA",
    "1983": "NEW TAI LUE LETTER HIGH XA",
    "1984": "NEW TAI LUE LETTER HIGH NGA",
    "1985": "NEW TAI LUE LETTER LOW KA",
    "1986": "NEW TAI LUE LETTER LOW XA",
    "1987": "NEW TAI LUE LETTER LOW NGA",
    "1988": "NEW TAI LUE LETTER HIGH TSA",
    "1989": "NEW TAI LUE LETTER HIGH SA",
    "198A": "NEW TAI LUE LETTER HIGH YA",
    "198B": "NEW TAI LUE LETTER LOW TSA",
    "198C": "NEW TAI LUE LETTER LOW SA",
    "198D": "NEW TAI LUE LETTER LOW YA",
    "198E": "NEW TAI LUE LETTER HIGH TA",
    "198F": "NEW TAI LUE LETTER HIGH THA",
    "1990": "NEW TAI LUE LETTER HIGH NA",
    "1991": "NEW TAI LUE LETTER LOW TA",
    "1992": "NEW TAI LUE LETTER LOW THA",
    "1993": "NEW TAI LUE LETTER LOW NA",
    "1994": "NEW TAI LUE LETTER HIGH PA",
    "1995": "NEW TAI LUE LETTER HIGH PHA",
    "1996": "NEW TAI LUE LETTER HIGH MA",
    "1997": "NEW TAI LUE LETTER LOW PA",
    "1998": "NEW TAI LUE LETTER LOW PHA",
    "1999": "NEW TAI LUE LETTER LOW MA",
    "199A": "NEW TAI LUE LETTER HIGH FA",
    "199B": "NEW TAI LUE LETTER HIGH VA",
    "199C": "NEW TAI LUE LETTER HIGH LA",
    "199D": "NEW TAI LUE LETTER LOW FA",
    "199E": "NEW TAI LUE LETTER LOW VA",
    "199F": "NEW TAI LUE LETTER LOW LA",
    "19A0": "NEW TAI LUE LETTER HIGH HA",
    "19A1": "NEW TAI LUE LETTER HIGH DA",
    "19A2": "NEW TAI LUE LETTER HIGH BA",
    "19A3": "NEW TAI LUE LETTER LOW HA",
    "19A4": "NEW TAI LUE LETTER LOW DA",
    "19A5": "NEW TAI LUE LETTER LOW BA",
    "19A6": "NEW TAI LUE LETTER HIGH KVA",
    "19A7": "NEW TAI LUE LETTER HIGH XVA",
    "19A8": "NEW TAI LUE LETTER LOW KVA",
    "19A9": "NEW TAI LUE LETTER LOW XVA",
    "19AA": "NEW TAI LUE LETTER HIGH SUA",
    "19AB": "NEW TAI LUE LETTER LOW SUA",
    "19B0": "NEW TAI LUE VOWEL SIGN VOWEL SHORTENER",
    "19B1": "NEW TAI LUE VOWEL SIGN AA",
    "19B2": "NEW TAI LUE VOWEL SIGN II",
    "19B3": "NEW TAI LUE VOWEL SIGN U",
    "19B4": "NEW TAI LUE VOWEL SIGN UU",
    "19B5": "NEW TAI LUE VOWEL SIGN E",
    "19B6": "NEW TAI LUE VOWEL SIGN AE",
    "19B7": "NEW TAI LUE VOWEL SIGN O",
    "19B8": "NEW TAI LUE VOWEL SIGN OA",
    "19B9": "NEW TAI LUE VOWEL SIGN UE",
    "19BA": "NEW TAI LUE VOWEL SIGN AY",
    "19BB": "NEW TAI LUE VOWEL SIGN AAY",
    "19BC": "NEW TAI LUE VOWEL SIGN UY",
    "19BD": "NEW TAI LUE VOWEL SIGN OY",
    "19BE": "NEW TAI LUE VOWEL SIGN OAY",
    "19BF": "NEW TAI LUE VOWEL SIGN UEY",
    "19C0": "NEW TAI LUE VOWEL SIGN IY",
    "19C1": "NEW TAI LUE LETTER FINAL V",
    "19C2": "NEW TAI LUE LETTER FINAL NG",
    "19C3": "NEW TAI LUE LETTER FINAL N",
    "19C4": "NEW TAI LUE LETTER FINAL M",
    "19C5": "NEW TAI LUE LETTER FINAL K",
    "19C6": "NEW TAI LUE LETTER FINAL D",
    "19C7": "NEW TAI LUE LETTER FINAL B",
    "19C8": "NEW TAI LUE TONE MARK-1",
    "19C9": "NEW TAI LUE TONE MARK-2",
    "19D0": "NEW TAI LUE DIGIT ZERO",
    "19D1": "NEW TAI LUE DIGIT ONE",
    "19D2": "NEW TAI LUE DIGIT TWO",
    "19D3": "NEW TAI LUE DIGIT THREE",
    "19D4": "NEW TAI LUE DIGIT FOUR",
    "19D5": "NEW TAI LUE DIGIT FIVE",
    "19D6": "NEW TAI LUE DIGIT SIX",
    "19D7": "NEW TAI LUE DIGIT SEVEN",
    "19D8": "NEW TAI LUE DIGIT EIGHT",
    "19D9": "NEW TAI LUE DIGIT NINE",
    "19DA": "NEW TAI LUE THAM DIGIT ONE",
    "19DE": "NEW TAI LUE SIGN LAE",
    "19DF": "NEW TAI LUE SIGN LAEV",
    "19E0": "KHMER SYMBOL PATHAMASAT",
    "19E1": "KHMER SYMBOL MUOY KOET",
    "19E2": "KHMER SYMBOL PII KOET",
    "19E3": "KHMER SYMBOL BEI KOET",
    "19E4": "KHMER SYMBOL BUON KOET",
    "19E5": "KHMER SYMBOL PRAM KOET",
    "19E6": "KHMER SYMBOL PRAM-MUOY KOET",
    "19E7": "KHMER SYMBOL PRAM-PII KOET",
    "19E8": "KHMER SYMBOL PRAM-BEI KOET",
    "19E9": "KHMER SYMBOL PRAM-BUON KOET",
    "19EA": "KHMER SYMBOL DAP KOET",
    "19EB": "KHMER SYMBOL DAP-MUOY KOET",
    "19EC": "KHMER SYMBOL DAP-PII KOET",
    "19ED": "KHMER SYMBOL DAP-BEI KOET",
    "19EE": "KHMER SYMBOL DAP-BUON KOET",
    "19EF": "KHMER SYMBOL DAP-PRAM KOET",
    "19F0": "KHMER SYMBOL TUTEYASAT",
    "19F1": "KHMER SYMBOL MUOY ROC",
    "19F2": "KHMER SYMBOL PII ROC",
    "19F3": "KHMER SYMBOL BEI ROC",
    "19F4": "KHMER SYMBOL BUON ROC",
    "19F5": "KHMER SYMBOL PRAM ROC",
    "19F6": "KHMER SYMBOL PRAM-MUOY ROC",
    "19F7": "KHMER SYMBOL PRAM-PII ROC",
    "19F8": "KHMER SYMBOL PRAM-BEI ROC",
    "19F9": "KHMER SYMBOL PRAM-BUON ROC",
    "19FA": "KHMER SYMBOL DAP ROC",
    "19FB": "KHMER SYMBOL DAP-MUOY ROC",
    "19FC": "KHMER SYMBOL DAP-PII ROC",
    "19FD": "KHMER SYMBOL DAP-BEI ROC",
    "19FE": "KHMER SYMBOL DAP-BUON ROC",
    "19FF": "KHMER SYMBOL DAP-PRAM ROC",
    "1A00": "BUGINESE LETTER KA",
    "1A01": "BUGINESE LETTER GA",
    "1A02": "BUGINESE LETTER NGA",
    "1A03": "BUGINESE LETTER NGKA",
    "1A04": "BUGINESE LETTER PA",
    "1A05": "BUGINESE LETTER BA",
    "1A06": "BUGINESE LETTER MA",
    "1A07": "BUGINESE LETTER MPA",
    "1A08": "BUGINESE LETTER TA",
    "1A09": "BUGINESE LETTER DA",
    "1A0A": "BUGINESE LETTER NA",
    "1A0B": "BUGINESE LETTER NRA",
    "1A0C": "BUGINESE LETTER CA",
    "1A0D": "BUGINESE LETTER JA",
    "1A0E": "BUGINESE LETTER NYA",
    "1A0F": "BUGINESE LETTER NYCA",
    "1A10": "BUGINESE LETTER YA",
    "1A11": "BUGINESE LETTER RA",
    "1A12": "BUGINESE LETTER LA",
    "1A13": "BUGINESE LETTER VA",
    "1A14": "BUGINESE LETTER SA",
    "1A15": "BUGINESE LETTER A",
    "1A16": "BUGINESE LETTER HA",
    "1A17": "BUGINESE VOWEL SIGN I",
    "1A18": "BUGINESE VOWEL SIGN U",
    "1A19": "BUGINESE VOWEL SIGN E",
    "1A1A": "BUGINESE VOWEL SIGN O",
    "1A1B": "BUGINESE VOWEL SIGN AE",
    "1A1E": "BUGINESE PALLAWA",
    "1A1F": "BUGINESE END OF SECTION",
    "1A20": "TAI THAM LETTER HIGH KA",
    "1A21": "TAI THAM LETTER HIGH KHA",
    "1A22": "TAI THAM LETTER HIGH KXA",
    "1A23": "TAI THAM LETTER LOW KA",
    "1A24": "TAI THAM LETTER LOW KXA",
    "1A25": "TAI THAM LETTER LOW KHA",
    "1A26": "TAI THAM LETTER NGA",
    "1A27": "TAI THAM LETTER HIGH CA",
    "1A28": "TAI THAM LETTER HIGH CHA",
    "1A29": "TAI THAM LETTER LOW CA",
    "1A2A": "TAI THAM LETTER LOW SA",
    "1A2B": "TAI THAM LETTER LOW CHA",
    "1A2C": "TAI THAM LETTER NYA",
    "1A2D": "TAI THAM LETTER RATA",
    "1A2E": "TAI THAM LETTER HIGH RATHA",
    "1A2F": "TAI THAM LETTER DA",
    "1A30": "TAI THAM LETTER LOW RATHA",
    "1A31": "TAI THAM LETTER RANA",
    "1A32": "TAI THAM LETTER HIGH TA",
    "1A33": "TAI THAM LETTER HIGH THA",
    "1A34": "TAI THAM LETTER LOW TA",
    "1A35": "TAI THAM LETTER LOW THA",
    "1A36": "TAI THAM LETTER NA",
    "1A37": "TAI THAM LETTER BA",
    "1A38": "TAI THAM LETTER HIGH PA",
    "1A39": "TAI THAM LETTER HIGH PHA",
    "1A3A": "TAI THAM LETTER HIGH FA",
    "1A3B": "TAI THAM LETTER LOW PA",
    "1A3C": "TAI THAM LETTER LOW FA",
    "1A3D": "TAI THAM LETTER LOW PHA",
    "1A3E": "TAI THAM LETTER MA",
    "1A3F": "TAI THAM LETTER LOW YA",
    "1A40": "TAI THAM LETTER HIGH YA",
    "1A41": "TAI THAM LETTER RA",
    "1A42": "TAI THAM LETTER RUE",
    "1A43": "TAI THAM LETTER LA",
    "1A44": "TAI THAM LETTER LUE",
    "1A45": "TAI THAM LETTER WA",
    "1A46": "TAI THAM LETTER HIGH SHA",
    "1A47": "TAI THAM LETTER HIGH SSA",
    "1A48": "TAI THAM LETTER HIGH SA",
    "1A49": "TAI THAM LETTER HIGH HA",
    "1A4A": "TAI THAM LETTER LLA",
    "1A4B": "TAI THAM LETTER A",
    "1A4C": "TAI THAM LETTER LOW HA",
    "1A4D": "TAI THAM LETTER I",
    "1A4E": "TAI THAM LETTER II",
    "1A4F": "TAI THAM LETTER U",
    "1A50": "TAI THAM LETTER UU",
    "1A51": "TAI THAM LETTER EE",
    "1A52": "TAI THAM LETTER OO",
    "1A53": "TAI THAM LETTER LAE",
    "1A54": "TAI THAM LETTER GREAT SA",
    "1A55": "TAI THAM CONSONANT SIGN MEDIAL RA",
    "1A56": "TAI THAM CONSONANT SIGN MEDIAL LA",
    "1A57": "TAI THAM CONSONANT SIGN LA TANG LAI",
    "1A58": "TAI THAM SIGN MAI KANG LAI",
    "1A59": "TAI THAM CONSONANT SIGN FINAL NGA",
    "1A5A": "TAI THAM CONSONANT SIGN LOW PA",
    "1A5B": "TAI THAM CONSONANT SIGN HIGH RATHA OR LOW PA",
    "1A5C": "TAI THAM CONSONANT SIGN MA",
    "1A5D": "TAI THAM CONSONANT SIGN BA",
    "1A5E": "TAI THAM CONSONANT SIGN SA",
    "1A60": "TAI THAM SIGN SAKOT",
    "1A61": "TAI THAM VOWEL SIGN A",
    "1A62": "TAI THAM VOWEL SIGN MAI SAT",
    "1A63": "TAI THAM VOWEL SIGN AA",
    "1A64": "TAI THAM VOWEL SIGN TALL AA",
    "1A65": "TAI THAM VOWEL SIGN I",
    "1A66": "TAI THAM VOWEL SIGN II",
    "1A67": "TAI THAM VOWEL SIGN UE",
    "1A68": "TAI THAM VOWEL SIGN UUE",
    "1A69": "TAI THAM VOWEL SIGN U",
    "1A6A": "TAI THAM VOWEL SIGN UU",
    "1A6B": "TAI THAM VOWEL SIGN O",
    "1A6C": "TAI THAM VOWEL SIGN OA BELOW",
    "1A6D": "TAI THAM VOWEL SIGN OY",
    "1A6E": "TAI THAM VOWEL SIGN E",
    "1A6F": "TAI THAM VOWEL SIGN AE",
    "1A70": "TAI THAM VOWEL SIGN OO",
    "1A71": "TAI THAM VOWEL SIGN AI",
    "1A72": "TAI THAM VOWEL SIGN THAM AI",
    "1A73": "TAI THAM VOWEL SIGN OA ABOVE",
    "1A74": "TAI THAM SIGN MAI KANG",
    "1A75": "TAI THAM SIGN TONE-1",
    "1A76": "TAI THAM SIGN TONE-2",
    "1A77": "TAI THAM SIGN KHUEN TONE-3",
    "1A78": "TAI THAM SIGN KHUEN TONE-4",
    "1A79": "TAI THAM SIGN KHUEN TONE-5",
    "1A7A": "TAI THAM SIGN RA HAAM",
    "1A7B": "TAI THAM SIGN MAI SAM",
    "1A7C": "TAI THAM SIGN KHUEN-LUE KARAN",
    "1A7F": "TAI THAM COMBINING CRYPTOGRAMMIC DOT",
    "1A80": "TAI THAM HORA DIGIT ZERO",
    "1A81": "TAI THAM HORA DIGIT ONE",
    "1A82": "TAI THAM HORA DIGIT TWO",
    "1A83": "TAI THAM HORA DIGIT THREE",
    "1A84": "TAI THAM HORA DIGIT FOUR",
    "1A85": "TAI THAM HORA DIGIT FIVE",
    "1A86": "TAI THAM HORA DIGIT SIX",
    "1A87": "TAI THAM HORA DIGIT SEVEN",
    "1A88": "TAI THAM HORA DIGIT EIGHT",
    "1A89": "TAI THAM HORA DIGIT NINE",
    "1A90": "TAI THAM THAM DIGIT ZERO",
    "1A91": "TAI THAM THAM DIGIT ONE",
    "1A92": "TAI THAM THAM DIGIT TWO",
    "1A93": "TAI THAM THAM DIGIT THREE",
    "1A94": "TAI THAM THAM DIGIT FOUR",
    "1A95": "TAI THAM THAM DIGIT FIVE",
    "1A96": "TAI THAM THAM DIGIT SIX",
    "1A97": "TAI THAM THAM DIGIT SEVEN",
    "1A98": "TAI THAM THAM DIGIT EIGHT",
    "1A99": "TAI THAM THAM DIGIT NINE",
    "1AA0": "TAI THAM SIGN WIANG",
    "1AA1": "TAI THAM SIGN WIANGWAAK",
    "1AA2": "TAI THAM SIGN SAWAN",
    "1AA3": "TAI THAM SIGN KEOW",
    "1AA4": "TAI THAM SIGN HOY",
    "1AA5": "TAI THAM SIGN DOKMAI",
    "1AA6": "TAI THAM SIGN REVERSED ROTATED RANA",
    "1AA7": "TAI THAM SIGN MAI YAMOK",
    "1AA8": "TAI THAM SIGN KAAN",
    "1AA9": "TAI THAM SIGN KAANKUU",
    "1AAA": "TAI THAM SIGN SATKAAN",
    "1AAB": "TAI THAM SIGN SATKAANKUU",
    "1AAC": "TAI THAM SIGN HANG",
    "1AAD": "TAI THAM SIGN CAANG",
    "1AB0": "COMBINING DOUBLED CIRCUMFLEX ACCENT",
    "1AB1": "COMBINING DIAERESIS-RING",
    "1AB2": "COMBINING INFINITY",
    "1AB3": "COMBINING DOWNWARDS ARROW",
    "1AB4": "COMBINING TRIPLE DOT",
    "1AB5": "COMBINING X-X BELOW",
    "1AB6": "COMBINING WIGGLY LINE BELOW",
    "1AB7": "COMBINING OPEN MARK BELOW",
    "1AB8": "COMBINING DOUBLE OPEN MARK BELOW",
    "1AB9": "COMBINING LIGHT CENTRALIZATION STROKE BELOW",
    "1ABA": "COMBINING STRONG CENTRALIZATION STROKE BELOW",
    "1ABB": "COMBINING PARENTHESES ABOVE",
    "1ABC": "COMBINING DOUBLE PARENTHESES ABOVE",
    "1ABD": "COMBINING PARENTHESES BELOW",
    "1ABE": "COMBINING PARENTHESES OVERLAY",
    "1B00": "BALINESE SIGN ULU RICEM",
    "1B01": "BALINESE SIGN ULU CANDRA",
    "1B02": "BALINESE SIGN CECEK",
    "1B03": "BALINESE SIGN SURANG",
    "1B04": "BALINESE SIGN BISAH",
    "1B05": "BALINESE LETTER AKARA",
    "1B06": "BALINESE LETTER AKARA TEDUNG",
    "1B07": "BALINESE LETTER IKARA",
    "1B08": "BALINESE LETTER IKARA TEDUNG",
    "1B09": "BALINESE LETTER UKARA",
    "1B0A": "BALINESE LETTER UKARA TEDUNG",
    "1B0B": "BALINESE LETTER RA REPA",
    "1B0C": "BALINESE LETTER RA REPA TEDUNG",
    "1B0D": "BALINESE LETTER LA LENGA",
    "1B0E": "BALINESE LETTER LA LENGA TEDUNG",
    "1B0F": "BALINESE LETTER EKARA",
    "1B10": "BALINESE LETTER AIKARA",
    "1B11": "BALINESE LETTER OKARA",
    "1B12": "BALINESE LETTER OKARA TEDUNG",
    "1B13": "BALINESE LETTER KA",
    "1B14": "BALINESE LETTER KA MAHAPRANA",
    "1B15": "BALINESE LETTER GA",
    "1B16": "BALINESE LETTER GA GORA",
    "1B17": "BALINESE LETTER NGA",
    "1B18": "BALINESE LETTER CA",
    "1B19": "BALINESE LETTER CA LACA",
    "1B1A": "BALINESE LETTER JA",
    "1B1B": "BALINESE LETTER JA JERA",
    "1B1C": "BALINESE LETTER NYA",
    "1B1D": "BALINESE LETTER TA LATIK",
    "1B1E": "BALINESE LETTER TA MURDA MAHAPRANA",
    "1B1F": "BALINESE LETTER DA MURDA ALPAPRANA",
    "1B20": "BALINESE LETTER DA MURDA MAHAPRANA",
    "1B21": "BALINESE LETTER NA RAMBAT",
    "1B22": "BALINESE LETTER TA",
    "1B23": "BALINESE LETTER TA TAWA",
    "1B24": "BALINESE LETTER DA",
    "1B25": "BALINESE LETTER DA MADU",
    "1B26": "BALINESE LETTER NA",
    "1B27": "BALINESE LETTER PA",
    "1B28": "BALINESE LETTER PA KAPAL",
    "1B29": "BALINESE LETTER BA",
    "1B2A": "BALINESE LETTER BA KEMBANG",
    "1B2B": "BALINESE LETTER MA",
    "1B2C": "BALINESE LETTER YA",
    "1B2D": "BALINESE LETTER RA",
    "1B2E": "BALINESE LETTER LA",
    "1B2F": "BALINESE LETTER WA",
    "1B30": "BALINESE LETTER SA SAGA",
    "1B31": "BALINESE LETTER SA SAPA",
    "1B32": "BALINESE LETTER SA",
    "1B33": "BALINESE LETTER HA",
    "1B34": "BALINESE SIGN REREKAN",
    "1B35": "BALINESE VOWEL SIGN TEDUNG",
    "1B36": "BALINESE VOWEL SIGN ULU",
    "1B37": "BALINESE VOWEL SIGN ULU SARI",
    "1B38": "BALINESE VOWEL SIGN SUKU",
    "1B39": "BALINESE VOWEL SIGN SUKU ILUT",
    "1B3A": "BALINESE VOWEL SIGN RA REPA",
    "1B3B": "BALINESE VOWEL SIGN RA REPA TEDUNG",
    "1B3C": "BALINESE VOWEL SIGN LA LENGA",
    "1B3D": "BALINESE VOWEL SIGN LA LENGA TEDUNG",
    "1B3E": "BALINESE VOWEL SIGN TALING",
    "1B3F": "BALINESE VOWEL SIGN TALING REPA",
    "1B40": "BALINESE VOWEL SIGN TALING TEDUNG",
    "1B41": "BALINESE VOWEL SIGN TALING REPA TEDUNG",
    "1B42": "BALINESE VOWEL SIGN PEPET",
    "1B43": "BALINESE VOWEL SIGN PEPET TEDUNG",
    "1B44": "BALINESE ADEG ADEG",
    "1B45": "BALINESE LETTER KAF SASAK",
    "1B46": "BALINESE LETTER KHOT SASAK",
    "1B47": "BALINESE LETTER TZIR SASAK",
    "1B48": "BALINESE LETTER EF SASAK",
    "1B49": "BALINESE LETTER VE SASAK",
    "1B4A": "BALINESE LETTER ZAL SASAK",
    "1B4B": "BALINESE LETTER ASYURA SASAK",
    "1B50": "BALINESE DIGIT ZERO",
    "1B51": "BALINESE DIGIT ONE",
    "1B52": "BALINESE DIGIT TWO",
    "1B53": "BALINESE DIGIT THREE",
    "1B54": "BALINESE DIGIT FOUR",
    "1B55": "BALINESE DIGIT FIVE",
    "1B56": "BALINESE DIGIT SIX",
    "1B57": "BALINESE DIGIT SEVEN",
    "1B58": "BALINESE DIGIT EIGHT",
    "1B59": "BALINESE DIGIT NINE",
    "1B5A": "BALINESE PANTI",
    "1B5B": "BALINESE PAMADA",
    "1B5C": "BALINESE WINDU",
    "1B5D": "BALINESE CARIK PAMUNGKAH",
    "1B5E": "BALINESE CARIK SIKI",
    "1B5F": "BALINESE CARIK PAREREN",
    "1B60": "BALINESE PAMENENG",
    "1B61": "BALINESE MUSICAL SYMBOL DONG",
    "1B62": "BALINESE MUSICAL SYMBOL DENG",
    "1B63": "BALINESE MUSICAL SYMBOL DUNG",
    "1B64": "BALINESE MUSICAL SYMBOL DANG",
    "1B65": "BALINESE MUSICAL SYMBOL DANG SURANG",
    "1B66": "BALINESE MUSICAL SYMBOL DING",
    "1B67": "BALINESE MUSICAL SYMBOL DAENG",
    "1B68": "BALINESE MUSICAL SYMBOL DEUNG",
    "1B69": "BALINESE MUSICAL SYMBOL DAING",
    "1B6A": "BALINESE MUSICAL SYMBOL DANG GEDE",
    "1B6B": "BALINESE MUSICAL SYMBOL COMBINING TEGEH",
    "1B6C": "BALINESE MUSICAL SYMBOL COMBINING ENDEP",
    "1B6D": "BALINESE MUSICAL SYMBOL COMBINING KEMPUL",
    "1B6E": "BALINESE MUSICAL SYMBOL COMBINING KEMPLI",
    "1B6F": "BALINESE MUSICAL SYMBOL COMBINING JEGOGAN",
    "1B70": "BALINESE MUSICAL SYMBOL COMBINING KEMPUL WITH JEGOGAN",
    "1B71": "BALINESE MUSICAL SYMBOL COMBINING KEMPLI WITH JEGOGAN",
    "1B72": "BALINESE MUSICAL SYMBOL COMBINING BENDE",
    "1B73": "BALINESE MUSICAL SYMBOL COMBINING GONG",
    "1B74": "BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DUG",
    "1B75": "BALINESE MUSICAL SYMBOL RIGHT-HAND OPEN DAG",
    "1B76": "BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TUK",
    "1B77": "BALINESE MUSICAL SYMBOL RIGHT-HAND CLOSED TAK",
    "1B78": "BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PANG",
    "1B79": "BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PUNG",
    "1B7A": "BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLAK",
    "1B7B": "BALINESE MUSICAL SYMBOL LEFT-HAND CLOSED PLUK",
    "1B7C": "BALINESE MUSICAL SYMBOL LEFT-HAND OPEN PING",
    "1B80": "SUNDANESE SIGN PANYECEK",
    "1B81": "SUNDANESE SIGN PANGLAYAR",
    "1B82": "SUNDANESE SIGN PANGWISAD",
    "1B83": "SUNDANESE LETTER A",
    "1B84": "SUNDANESE LETTER I",
    "1B85": "SUNDANESE LETTER U",
    "1B86": "SUNDANESE LETTER AE",
    "1B87": "SUNDANESE LETTER O",
    "1B88": "SUNDANESE LETTER E",
    "1B89": "SUNDANESE LETTER EU",
    "1B8A": "SUNDANESE LETTER KA",
    "1B8B": "SUNDANESE LETTER QA",
    "1B8C": "SUNDANESE LETTER GA",
    "1B8D": "SUNDANESE LETTER NGA",
    "1B8E": "SUNDANESE LETTER CA",
    "1B8F": "SUNDANESE LETTER JA",
    "1B90": "SUNDANESE LETTER ZA",
    "1B91": "SUNDANESE LETTER NYA",
    "1B92": "SUNDANESE LETTER TA",
    "1B93": "SUNDANESE LETTER DA",
    "1B94": "SUNDANESE LETTER NA",
    "1B95": "SUNDANESE LETTER PA",
    "1B96": "SUNDANESE LETTER FA",
    "1B97": "SUNDANESE LETTER VA",
    "1B98": "SUNDANESE LETTER BA",
    "1B99": "SUNDANESE LETTER MA",
    "1B9A": "SUNDANESE LETTER YA",
    "1B9B": "SUNDANESE LETTER RA",
    "1B9C": "SUNDANESE LETTER LA",
    "1B9D": "SUNDANESE LETTER WA",
    "1B9E": "SUNDANESE LETTER SA",
    "1B9F": "SUNDANESE LETTER XA",
    "1BA0": "SUNDANESE LETTER HA",
    "1BA1": "SUNDANESE CONSONANT SIGN PAMINGKAL",
    "1BA2": "SUNDANESE CONSONANT SIGN PANYAKRA",
    "1BA3": "SUNDANESE CONSONANT SIGN PANYIKU",
    "1BA4": "SUNDANESE VOWEL SIGN PANGHULU",
    "1BA5": "SUNDANESE VOWEL SIGN PANYUKU",
    "1BA6": "SUNDANESE VOWEL SIGN PANAELAENG",
    "1BA7": "SUNDANESE VOWEL SIGN PANOLONG",
    "1BA8": "SUNDANESE VOWEL SIGN PAMEPET",
    "1BA9": "SUNDANESE VOWEL SIGN PANEULEUNG",
    "1BAA": "SUNDANESE SIGN PAMAAEH",
    "1BAB": "SUNDANESE SIGN VIRAMA",
    "1BAC": "SUNDANESE CONSONANT SIGN PASANGAN MA",
    "1BAD": "SUNDANESE CONSONANT SIGN PASANGAN WA",
    "1BAE": "SUNDANESE LETTER KHA",
    "1BAF": "SUNDANESE LETTER SYA",
    "1BB0": "SUNDANESE DIGIT ZERO",
    "1BB1": "SUNDANESE DIGIT ONE",
    "1BB2": "SUNDANESE DIGIT TWO",
    "1BB3": "SUNDANESE DIGIT THREE",
    "1BB4": "SUNDANESE DIGIT FOUR",
    "1BB5": "SUNDANESE DIGIT FIVE",
    "1BB6": "SUNDANESE DIGIT SIX",
    "1BB7": "SUNDANESE DIGIT SEVEN",
    "1BB8": "SUNDANESE DIGIT EIGHT",
    "1BB9": "SUNDANESE DIGIT NINE",
    "1BBA": "SUNDANESE AVAGRAHA",
    "1BBB": "SUNDANESE LETTER REU",
    "1BBC": "SUNDANESE LETTER LEU",
    "1BBD": "SUNDANESE LETTER BHA",
    "1BBE": "SUNDANESE LETTER FINAL K",
    "1BBF": "SUNDANESE LETTER FINAL M",
    "1BC0": "BATAK LETTER A",
    "1BC1": "BATAK LETTER SIMALUNGUN A",
    "1BC2": "BATAK LETTER HA",
    "1BC3": "BATAK LETTER SIMALUNGUN HA",
    "1BC4": "BATAK LETTER MANDAILING HA",
    "1BC5": "BATAK LETTER BA",
    "1BC6": "BATAK LETTER KARO BA",
    "1BC7": "BATAK LETTER PA",
    "1BC8": "BATAK LETTER SIMALUNGUN PA",
    "1BC9": "BATAK LETTER NA",
    "1BCA": "BATAK LETTER MANDAILING NA",
    "1BCB": "BATAK LETTER WA",
    "1BCC": "BATAK LETTER SIMALUNGUN WA",
    "1BCD": "BATAK LETTER PAKPAK WA",
    "1BCE": "BATAK LETTER GA",
    "1BCF": "BATAK LETTER SIMALUNGUN GA",
    "1BD0": "BATAK LETTER JA",
    "1BD1": "BATAK LETTER DA",
    "1BD2": "BATAK LETTER RA",
    "1BD3": "BATAK LETTER SIMALUNGUN RA",
    "1BD4": "BATAK LETTER MA",
    "1BD5": "BATAK LETTER SIMALUNGUN MA",
    "1BD6": "BATAK LETTER SOUTHERN TA",
    "1BD7": "BATAK LETTER NORTHERN TA",
    "1BD8": "BATAK LETTER SA",
    "1BD9": "BATAK LETTER SIMALUNGUN SA",
    "1BDA": "BATAK LETTER MANDAILING SA",
    "1BDB": "BATAK LETTER YA",
    "1BDC": "BATAK LETTER SIMALUNGUN YA",
    "1BDD": "BATAK LETTER NGA",
    "1BDE": "BATAK LETTER LA",
    "1BDF": "BATAK LETTER SIMALUNGUN LA",
    "1BE0": "BATAK LETTER NYA",
    "1BE1": "BATAK LETTER CA",
    "1BE2": "BATAK LETTER NDA",
    "1BE3": "BATAK LETTER MBA",
    "1BE4": "BATAK LETTER I",
    "1BE5": "BATAK LETTER U",
    "1BE6": "BATAK SIGN TOMPI",
    "1BE7": "BATAK VOWEL SIGN E",
    "1BE8": "BATAK VOWEL SIGN PAKPAK E",
    "1BE9": "BATAK VOWEL SIGN EE",
    "1BEA": "BATAK VOWEL SIGN I",
    "1BEB": "BATAK VOWEL SIGN KARO I",
    "1BEC": "BATAK VOWEL SIGN O",
    "1BED": "BATAK VOWEL SIGN KARO O",
    "1BEE": "BATAK VOWEL SIGN U",
    "1BEF": "BATAK VOWEL SIGN U FOR SIMALUNGUN SA",
    "1BF0": "BATAK CONSONANT SIGN NG",
    "1BF1": "BATAK CONSONANT SIGN H",
    "1BF2": "BATAK PANGOLAT",
    "1BF3": "BATAK PANONGONAN",
    "1BFC": "BATAK SYMBOL BINDU NA METEK",
    "1BFD": "BATAK SYMBOL BINDU PINARBORAS",
    "1BFE": "BATAK SYMBOL BINDU JUDUL",
    "1BFF": "BATAK SYMBOL BINDU PANGOLAT",
    "1C00": "LEPCHA LETTER KA",
    "1C01": "LEPCHA LETTER KLA",
    "1C02": "LEPCHA LETTER KHA",
    "1C03": "LEPCHA LETTER GA",
    "1C04": "LEPCHA LETTER GLA",
    "1C05": "LEPCHA LETTER NGA",
    "1C06": "LEPCHA LETTER CA",
    "1C07": "LEPCHA LETTER CHA",
    "1C08": "LEPCHA LETTER JA",
    "1C09": "LEPCHA LETTER NYA",
    "1C0A": "LEPCHA LETTER TA",
    "1C0B": "LEPCHA LETTER THA",
    "1C0C": "LEPCHA LETTER DA",
    "1C0D": "LEPCHA LETTER NA",
    "1C0E": "LEPCHA LETTER PA",
    "1C0F": "LEPCHA LETTER PLA",
    "1C10": "LEPCHA LETTER PHA",
    "1C11": "LEPCHA LETTER FA",
    "1C12": "LEPCHA LETTER FLA",
    "1C13": "LEPCHA LETTER BA",
    "1C14": "LEPCHA LETTER BLA",
    "1C15": "LEPCHA LETTER MA",
    "1C16": "LEPCHA LETTER MLA",
    "1C17": "LEPCHA LETTER TSA",
    "1C18": "LEPCHA LETTER TSHA",
    "1C19": "LEPCHA LETTER DZA",
    "1C1A": "LEPCHA LETTER YA",
    "1C1B": "LEPCHA LETTER RA",
    "1C1C": "LEPCHA LETTER LA",
    "1C1D": "LEPCHA LETTER HA",
    "1C1E": "LEPCHA LETTER HLA",
    "1C1F": "LEPCHA LETTER VA",
    "1C20": "LEPCHA LETTER SA",
    "1C21": "LEPCHA LETTER SHA",
    "1C22": "LEPCHA LETTER WA",
    "1C23": "LEPCHA LETTER A",
    "1C24": "LEPCHA SUBJOINED LETTER YA",
    "1C25": "LEPCHA SUBJOINED LETTER RA",
    "1C26": "LEPCHA VOWEL SIGN AA",
    "1C27": "LEPCHA VOWEL SIGN I",
    "1C28": "LEPCHA VOWEL SIGN O",
    "1C29": "LEPCHA VOWEL SIGN OO",
    "1C2A": "LEPCHA VOWEL SIGN U",
    "1C2B": "LEPCHA VOWEL SIGN UU",
    "1C2C": "LEPCHA VOWEL SIGN E",
    "1C2D": "LEPCHA CONSONANT SIGN K",
    "1C2E": "LEPCHA CONSONANT SIGN M",
    "1C2F": "LEPCHA CONSONANT SIGN L",
    "1C30": "LEPCHA CONSONANT SIGN N",
    "1C31": "LEPCHA CONSONANT SIGN P",
    "1C32": "LEPCHA CONSONANT SIGN R",
    "1C33": "LEPCHA CONSONANT SIGN T",
    "1C34": "LEPCHA CONSONANT SIGN NYIN-DO",
    "1C35": "LEPCHA CONSONANT SIGN KANG",
    "1C36": "LEPCHA SIGN RAN",
    "1C37": "LEPCHA SIGN NUKTA",
    "1C3B": "LEPCHA PUNCTUATION TA-ROL",
    "1C3C": "LEPCHA PUNCTUATION NYET THYOOM TA-ROL",
    "1C3D": "LEPCHA PUNCTUATION CER-WA",
    "1C3E": "LEPCHA PUNCTUATION TSHOOK CER-WA",
    "1C3F": "LEPCHA PUNCTUATION TSHOOK",
    "1C40": "LEPCHA DIGIT ZERO",
    "1C41": "LEPCHA DIGIT ONE",
    "1C42": "LEPCHA DIGIT TWO",
    "1C43": "LEPCHA DIGIT THREE",
    "1C44": "LEPCHA DIGIT FOUR",
    "1C45": "LEPCHA DIGIT FIVE",
    "1C46": "LEPCHA DIGIT SIX",
    "1C47": "LEPCHA DIGIT SEVEN",
    "1C48": "LEPCHA DIGIT EIGHT",
    "1C49": "LEPCHA DIGIT NINE",
    "1C4D": "LEPCHA LETTER TTA",
    "1C4E": "LEPCHA LETTER TTHA",
    "1C4F": "LEPCHA LETTER DDA",
    "1C50": "OL CHIKI DIGIT ZERO",
    "1C51": "OL CHIKI DIGIT ONE",
    "1C52": "OL CHIKI DIGIT TWO",
    "1C53": "OL CHIKI DIGIT THREE",
    "1C54": "OL CHIKI DIGIT FOUR",
    "1C55": "OL CHIKI DIGIT FIVE",
    "1C56": "OL CHIKI DIGIT SIX",
    "1C57": "OL CHIKI DIGIT SEVEN",
    "1C58": "OL CHIKI DIGIT EIGHT",
    "1C59": "OL CHIKI DIGIT NINE",
    "1C5A": "OL CHIKI LETTER LA",
    "1C5B": "OL CHIKI LETTER AT",
    "1C5C": "OL CHIKI LETTER AG",
    "1C5D": "OL CHIKI LETTER ANG",
    "1C5E": "OL CHIKI LETTER AL",
    "1C5F": "OL CHIKI LETTER LAA",
    "1C60": "OL CHIKI LETTER AAK",
    "1C61": "OL CHIKI LETTER AAJ",
    "1C62": "OL CHIKI LETTER AAM",
    "1C63": "OL CHIKI LETTER AAW",
    "1C64": "OL CHIKI LETTER LI",
    "1C65": "OL CHIKI LETTER IS",
    "1C66": "OL CHIKI LETTER IH",
    "1C67": "OL CHIKI LETTER INY",
    "1C68": "OL CHIKI LETTER IR",
    "1C69": "OL CHIKI LETTER LU",
    "1C6A": "OL CHIKI LETTER UC",
    "1C6B": "OL CHIKI LETTER UD",
    "1C6C": "OL CHIKI LETTER UNN",
    "1C6D": "OL CHIKI LETTER UY",
    "1C6E": "OL CHIKI LETTER LE",
    "1C6F": "OL CHIKI LETTER EP",
    "1C70": "OL CHIKI LETTER EDD",
    "1C71": "OL CHIKI LETTER EN",
    "1C72": "OL CHIKI LETTER ERR",
    "1C73": "OL CHIKI LETTER LO",
    "1C74": "OL CHIKI LETTER OTT",
    "1C75": "OL CHIKI LETTER OB",
    "1C76": "OL CHIKI LETTER OV",
    "1C77": "OL CHIKI LETTER OH",
    "1C78": "OL CHIKI MU TTUDDAG",
    "1C79": "OL CHIKI GAAHLAA TTUDDAAG",
    "1C7A": "OL CHIKI MU-GAAHLAA TTUDDAAG",
    "1C7B": "OL CHIKI RELAA",
    "1C7C": "OL CHIKI PHAARKAA",
    "1C7D": "OL CHIKI AHAD",
    "1C7E": "OL CHIKI PUNCTUATION MUCAAD",
    "1C7F": "OL CHIKI PUNCTUATION DOUBLE MUCAAD",
    "1C80": "CYRILLIC SMALL LETTER ROUNDED VE",
    "1C81": "CYRILLIC SMALL LETTER LONG-LEGGED DE",
    "1C82": "CYRILLIC SMALL LETTER NARROW O",
    "1C83": "CYRILLIC SMALL LETTER WIDE ES",
    "1C84": "CYRILLIC SMALL LETTER TALL TE",
    "1C85": "CYRILLIC SMALL LETTER THREE-LEGGED TE",
    "1C86": "CYRILLIC SMALL LETTER TALL HARD SIGN",
    "1C87": "CYRILLIC SMALL LETTER TALL YAT",
    "1C88": "CYRILLIC SMALL LETTER UNBLENDED UK",
    "1CC0": "SUNDANESE PUNCTUATION BINDU SURYA",
    "1CC1": "SUNDANESE PUNCTUATION BINDU PANGLONG",
    "1CC2": "SUNDANESE PUNCTUATION BINDU PURNAMA",
    "1CC3": "SUNDANESE PUNCTUATION BINDU CAKRA",
    "1CC4": "SUNDANESE PUNCTUATION BINDU LEU SATANGA",
    "1CC5": "SUNDANESE PUNCTUATION BINDU KA SATANGA",
    "1CC6": "SUNDANESE PUNCTUATION BINDU DA SATANGA",
    "1CC7": "SUNDANESE PUNCTUATION BINDU BA SATANGA",
    "1CD0": "VEDIC TONE KARSHANA",
    "1CD1": "VEDIC TONE SHARA",
    "1CD2": "VEDIC TONE PRENKHA",
    "1CD3": "VEDIC SIGN NIHSHVASA",
    "1CD4": "VEDIC SIGN YAJURVEDIC MIDLINE SVARITA",
    "1CD5": "VEDIC TONE YAJURVEDIC AGGRAVATED INDEPENDENT SVARITA",
    "1CD6": "VEDIC TONE YAJURVEDIC INDEPENDENT SVARITA",
    "1CD7": "VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA",
    "1CD8": "VEDIC TONE CANDRA BELOW",
    "1CD9": "VEDIC TONE YAJURVEDIC KATHAKA INDEPENDENT SVARITA SCHROEDER",
    "1CDA": "VEDIC TONE DOUBLE SVARITA",
    "1CDB": "VEDIC TONE TRIPLE SVARITA",
    "1CDC": "VEDIC TONE KATHAKA ANUDATTA",
    "1CDD": "VEDIC TONE DOT BELOW",
    "1CDE": "VEDIC TONE TWO DOTS BELOW",
    "1CDF": "VEDIC TONE THREE DOTS BELOW",
    "1CE0": "VEDIC TONE RIGVEDIC KASHMIRI INDEPENDENT SVARITA",
    "1CE1": "VEDIC TONE ATHARVAVEDIC INDEPENDENT SVARITA",
    "1CE2": "VEDIC SIGN VISARGA SVARITA",
    "1CE3": "VEDIC SIGN VISARGA UDATTA",
    "1CE4": "VEDIC SIGN REVERSED VISARGA UDATTA",
    "1CE5": "VEDIC SIGN VISARGA ANUDATTA",
    "1CE6": "VEDIC SIGN REVERSED VISARGA ANUDATTA",
    "1CE7": "VEDIC SIGN VISARGA UDATTA WITH TAIL",
    "1CE8": "VEDIC SIGN VISARGA ANUDATTA WITH TAIL",
    "1CE9": "VEDIC SIGN ANUSVARA ANTARGOMUKHA",
    "1CEA": "VEDIC SIGN ANUSVARA BAHIRGOMUKHA",
    "1CEB": "VEDIC SIGN ANUSVARA VAMAGOMUKHA",
    "1CEC": "VEDIC SIGN ANUSVARA VAMAGOMUKHA WITH TAIL",
    "1CED": "VEDIC SIGN TIRYAK",
    "1CEE": "VEDIC SIGN HEXIFORM LONG ANUSVARA",
    "1CEF": "VEDIC SIGN LONG ANUSVARA",
    "1CF0": "VEDIC SIGN RTHANG LONG ANUSVARA",
    "1CF1": "VEDIC SIGN ANUSVARA UBHAYATO MUKHA",
    "1CF2": "VEDIC SIGN ARDHAVISARGA",
    "1CF3": "VEDIC SIGN ROTATED ARDHAVISARGA",
    "1CF4": "VEDIC TONE CANDRA ABOVE",
    "1CF5": "VEDIC SIGN JIHVAMULIYA",
    "1CF6": "VEDIC SIGN UPADHMANIYA",
    "1CF8": "VEDIC TONE RING ABOVE",
    "1CF9": "VEDIC TONE DOUBLE RING ABOVE",
    "1D00": "LATIN LETTER SMALL CAPITAL A",
    "1D01": "LATIN LETTER SMALL CAPITAL AE",
    "1D02": "LATIN SMALL LETTER TURNED AE",
    "1D03": "LATIN LETTER SMALL CAPITAL BARRED B",
    "1D04": "LATIN LETTER SMALL CAPITAL C",
    "1D05": "LATIN LETTER SMALL CAPITAL D",
    "1D06": "LATIN LETTER SMALL CAPITAL ETH",
    "1D07": "LATIN LETTER SMALL CAPITAL E",
    "1D08": "LATIN SMALL LETTER TURNED OPEN E",
    "1D09": "LATIN SMALL LETTER TURNED I",
    "1D0A": "LATIN LETTER SMALL CAPITAL J",
    "1D0B": "LATIN LETTER SMALL CAPITAL K",
    "1D0C": "LATIN LETTER SMALL CAPITAL L WITH STROKE",
    "1D0D": "LATIN LETTER SMALL CAPITAL M",
    "1D0E": "LATIN LETTER SMALL CAPITAL REVERSED N",
    "1D0F": "LATIN LETTER SMALL CAPITAL O",
    "1D10": "LATIN LETTER SMALL CAPITAL OPEN O",
    "1D11": "LATIN SMALL LETTER SIDEWAYS O",
    "1D12": "LATIN SMALL LETTER SIDEWAYS OPEN O",
    "1D13": "LATIN SMALL LETTER SIDEWAYS O WITH STROKE",
    "1D14": "LATIN SMALL LETTER TURNED OE",
    "1D15": "LATIN LETTER SMALL CAPITAL OU",
    "1D16": "LATIN SMALL LETTER TOP HALF O",
    "1D17": "LATIN SMALL LETTER BOTTOM HALF O",
    "1D18": "LATIN LETTER SMALL CAPITAL P",
    "1D19": "LATIN LETTER SMALL CAPITAL REVERSED R",
    "1D1A": "LATIN LETTER SMALL CAPITAL TURNED R",
    "1D1B": "LATIN LETTER SMALL CAPITAL T",
    "1D1C": "LATIN LETTER SMALL CAPITAL U",
    "1D1D": "LATIN SMALL LETTER SIDEWAYS U",
    "1D1E": "LATIN SMALL LETTER SIDEWAYS DIAERESIZED U",
    "1D1F": "LATIN SMALL LETTER SIDEWAYS TURNED M",
    "1D20": "LATIN LETTER SMALL CAPITAL V",
    "1D21": "LATIN LETTER SMALL CAPITAL W",
    "1D22": "LATIN LETTER SMALL CAPITAL Z",
    "1D23": "LATIN LETTER SMALL CAPITAL EZH",
    "1D24": "LATIN LETTER VOICED LARYNGEAL SPIRANT",
    "1D25": "LATIN LETTER AIN",
    "1D26": "GREEK LETTER SMALL CAPITAL GAMMA",
    "1D27": "GREEK LETTER SMALL CAPITAL LAMDA",
    "1D28": "GREEK LETTER SMALL CAPITAL PI",
    "1D29": "GREEK LETTER SMALL CAPITAL RHO",
    "1D2A": "GREEK LETTER SMALL CAPITAL PSI",
    "1D2B": "CYRILLIC LETTER SMALL CAPITAL EL",
    "1D2C": "MODIFIER LETTER CAPITAL A",
    "1D2D": "MODIFIER LETTER CAPITAL AE",
    "1D2E": "MODIFIER LETTER CAPITAL B",
    "1D2F": "MODIFIER LETTER CAPITAL BARRED B",
    "1D30": "MODIFIER LETTER CAPITAL D",
    "1D31": "MODIFIER LETTER CAPITAL E",
    "1D32": "MODIFIER LETTER CAPITAL REVERSED E",
    "1D33": "MODIFIER LETTER CAPITAL G",
    "1D34": "MODIFIER LETTER CAPITAL H",
    "1D35": "MODIFIER LETTER CAPITAL I",
    "1D36": "MODIFIER LETTER CAPITAL J",
    "1D37": "MODIFIER LETTER CAPITAL K",
    "1D38": "MODIFIER LETTER CAPITAL L",
    "1D39": "MODIFIER LETTER CAPITAL M",
    "1D3A": "MODIFIER LETTER CAPITAL N",
    "1D3B": "MODIFIER LETTER CAPITAL REVERSED N",
    "1D3C": "MODIFIER LETTER CAPITAL O",
    "1D3D": "MODIFIER LETTER CAPITAL OU",
    "1D3E": "MODIFIER LETTER CAPITAL P",
    "1D3F": "MODIFIER LETTER CAPITAL R",
    "1D40": "MODIFIER LETTER CAPITAL T",
    "1D41": "MODIFIER LETTER CAPITAL U",
    "1D42": "MODIFIER LETTER CAPITAL W",
    "1D43": "MODIFIER LETTER SMALL A",
    "1D44": "MODIFIER LETTER SMALL TURNED A",
    "1D45": "MODIFIER LETTER SMALL ALPHA",
    "1D46": "MODIFIER LETTER SMALL TURNED AE",
    "1D47": "MODIFIER LETTER SMALL B",
    "1D48": "MODIFIER LETTER SMALL D",
    "1D49": "MODIFIER LETTER SMALL E",
    "1D4A": "MODIFIER LETTER SMALL SCHWA",
    "1D4B": "MODIFIER LETTER SMALL OPEN E",
    "1D4C": "MODIFIER LETTER SMALL TURNED OPEN E",
    "1D4D": "MODIFIER LETTER SMALL G",
    "1D4E": "MODIFIER LETTER SMALL TURNED I",
    "1D4F": "MODIFIER LETTER SMALL K",
    "1D50": "MODIFIER LETTER SMALL M",
    "1D51": "MODIFIER LETTER SMALL ENG",
    "1D52": "MODIFIER LETTER SMALL O",
    "1D53": "MODIFIER LETTER SMALL OPEN O",
    "1D54": "MODIFIER LETTER SMALL TOP HALF O",
    "1D55": "MODIFIER LETTER SMALL BOTTOM HALF O",
    "1D56": "MODIFIER LETTER SMALL P",
    "1D57": "MODIFIER LETTER SMALL T",
    "1D58": "MODIFIER LETTER SMALL U",
    "1D59": "MODIFIER LETTER SMALL SIDEWAYS U",
    "1D5A": "MODIFIER LETTER SMALL TURNED M",
    "1D5B": "MODIFIER LETTER SMALL V",
    "1D5C": "MODIFIER LETTER SMALL AIN",
    "1D5D": "MODIFIER LETTER SMALL BETA",
    "1D5E": "MODIFIER LETTER SMALL GREEK GAMMA",
    "1D5F": "MODIFIER LETTER SMALL DELTA",
    "1D60": "MODIFIER LETTER SMALL GREEK PHI",
    "1D61": "MODIFIER LETTER SMALL CHI",
    "1D62": "LATIN SUBSCRIPT SMALL LETTER I",
    "1D63": "LATIN SUBSCRIPT SMALL LETTER R",
    "1D64": "LATIN SUBSCRIPT SMALL LETTER U",
    "1D65": "LATIN SUBSCRIPT SMALL LETTER V",
    "1D66": "GREEK SUBSCRIPT SMALL LETTER BETA",
    "1D67": "GREEK SUBSCRIPT SMALL LETTER GAMMA",
    "1D68": "GREEK SUBSCRIPT SMALL LETTER RHO",
    "1D69": "GREEK SUBSCRIPT SMALL LETTER PHI",
    "1D6A": "GREEK SUBSCRIPT SMALL LETTER CHI",
    "1D6B": "LATIN SMALL LETTER UE",
    "1D6C": "LATIN SMALL LETTER B WITH MIDDLE TILDE",
    "1D6D": "LATIN SMALL LETTER D WITH MIDDLE TILDE",
    "1D6E": "LATIN SMALL LETTER F WITH MIDDLE TILDE",
    "1D6F": "LATIN SMALL LETTER M WITH MIDDLE TILDE",
    "1D70": "LATIN SMALL LETTER N WITH MIDDLE TILDE",
    "1D71": "LATIN SMALL LETTER P WITH MIDDLE TILDE",
    "1D72": "LATIN SMALL LETTER R WITH MIDDLE TILDE",
    "1D73": "LATIN SMALL LETTER R WITH FISHHOOK AND MIDDLE TILDE",
    "1D74": "LATIN SMALL LETTER S WITH MIDDLE TILDE",
    "1D75": "LATIN SMALL LETTER T WITH MIDDLE TILDE",
    "1D76": "LATIN SMALL LETTER Z WITH MIDDLE TILDE",
    "1D77": "LATIN SMALL LETTER TURNED G",
    "1D78": "MODIFIER LETTER CYRILLIC EN",
    "1D79": "LATIN SMALL LETTER INSULAR G",
    "1D7A": "LATIN SMALL LETTER TH WITH STRIKETHROUGH",
    "1D7B": "LATIN SMALL CAPITAL LETTER I WITH STROKE",
    "1D7C": "LATIN SMALL LETTER IOTA WITH STROKE",
    "1D7D": "LATIN SMALL LETTER P WITH STROKE",
    "1D7E": "LATIN SMALL CAPITAL LETTER U WITH STROKE",
    "1D7F": "LATIN SMALL LETTER UPSILON WITH STROKE",
    "1D80": "LATIN SMALL LETTER B WITH PALATAL HOOK",
    "1D81": "LATIN SMALL LETTER D WITH PALATAL HOOK",
    "1D82": "LATIN SMALL LETTER F WITH PALATAL HOOK",
    "1D83": "LATIN SMALL LETTER G WITH PALATAL HOOK",
    "1D84": "LATIN SMALL LETTER K WITH PALATAL HOOK",
    "1D85": "LATIN SMALL LETTER L WITH PALATAL HOOK",
    "1D86": "LATIN SMALL LETTER M WITH PALATAL HOOK",
    "1D87": "LATIN SMALL LETTER N WITH PALATAL HOOK",
    "1D88": "LATIN SMALL LETTER P WITH PALATAL HOOK",
    "1D89": "LATIN SMALL LETTER R WITH PALATAL HOOK",
    "1D8A": "LATIN SMALL LETTER S WITH PALATAL HOOK",
    "1D8B": "LATIN SMALL LETTER ESH WITH PALATAL HOOK",
    "1D8C": "LATIN SMALL LETTER V WITH PALATAL HOOK",
    "1D8D": "LATIN SMALL LETTER X WITH PALATAL HOOK",
    "1D8E": "LATIN SMALL LETTER Z WITH PALATAL HOOK",
    "1D8F": "LATIN SMALL LETTER A WITH RETROFLEX HOOK",
    "1D90": "LATIN SMALL LETTER ALPHA WITH RETROFLEX HOOK",
    "1D91": "LATIN SMALL LETTER D WITH HOOK AND TAIL",
    "1D92": "LATIN SMALL LETTER E WITH RETROFLEX HOOK",
    "1D93": "LATIN SMALL LETTER OPEN E WITH RETROFLEX HOOK",
    "1D94": "LATIN SMALL LETTER REVERSED OPEN E WITH RETROFLEX HOOK",
    "1D95": "LATIN SMALL LETTER SCHWA WITH RETROFLEX HOOK",
    "1D96": "LATIN SMALL LETTER I WITH RETROFLEX HOOK",
    "1D97": "LATIN SMALL LETTER OPEN O WITH RETROFLEX HOOK",
    "1D98": "LATIN SMALL LETTER ESH WITH RETROFLEX HOOK",
    "1D99": "LATIN SMALL LETTER U WITH RETROFLEX HOOK",
    "1D9A": "LATIN SMALL LETTER EZH WITH RETROFLEX HOOK",
    "1D9B": "MODIFIER LETTER SMALL TURNED ALPHA",
    "1D9C": "MODIFIER LETTER SMALL C",
    "1D9D": "MODIFIER LETTER SMALL C WITH CURL",
    "1D9E": "MODIFIER LETTER SMALL ETH",
    "1D9F": "MODIFIER LETTER SMALL REVERSED OPEN E",
    "1DA0": "MODIFIER LETTER SMALL F",
    "1DA1": "MODIFIER LETTER SMALL DOTLESS J WITH STROKE",
    "1DA2": "MODIFIER LETTER SMALL SCRIPT G",
    "1DA3": "MODIFIER LETTER SMALL TURNED H",
    "1DA4": "MODIFIER LETTER SMALL I WITH STROKE",
    "1DA5": "MODIFIER LETTER SMALL IOTA",
    "1DA6": "MODIFIER LETTER SMALL CAPITAL I",
    "1DA7": "MODIFIER LETTER SMALL CAPITAL I WITH STROKE",
    "1DA8": "MODIFIER LETTER SMALL J WITH CROSSED-TAIL",
    "1DA9": "MODIFIER LETTER SMALL L WITH RETROFLEX HOOK",
    "1DAA": "MODIFIER LETTER SMALL L WITH PALATAL HOOK",
    "1DAB": "MODIFIER LETTER SMALL CAPITAL L",
    "1DAC": "MODIFIER LETTER SMALL M WITH HOOK",
    "1DAD": "MODIFIER LETTER SMALL TURNED M WITH LONG LEG",
    "1DAE": "MODIFIER LETTER SMALL N WITH LEFT HOOK",
    "1DAF": "MODIFIER LETTER SMALL N WITH RETROFLEX HOOK",
    "1DB0": "MODIFIER LETTER SMALL CAPITAL N",
    "1DB1": "MODIFIER LETTER SMALL BARRED O",
    "1DB2": "MODIFIER LETTER SMALL PHI",
    "1DB3": "MODIFIER LETTER SMALL S WITH HOOK",
    "1DB4": "MODIFIER LETTER SMALL ESH",
    "1DB5": "MODIFIER LETTER SMALL T WITH PALATAL HOOK",
    "1DB6": "MODIFIER LETTER SMALL U BAR",
    "1DB7": "MODIFIER LETTER SMALL UPSILON",
    "1DB8": "MODIFIER LETTER SMALL CAPITAL U",
    "1DB9": "MODIFIER LETTER SMALL V WITH HOOK",
    "1DBA": "MODIFIER LETTER SMALL TURNED V",
    "1DBB": "MODIFIER LETTER SMALL Z",
    "1DBC": "MODIFIER LETTER SMALL Z WITH RETROFLEX HOOK",
    "1DBD": "MODIFIER LETTER SMALL Z WITH CURL",
    "1DBE": "MODIFIER LETTER SMALL EZH",
    "1DBF": "MODIFIER LETTER SMALL THETA",
    "1DC0": "COMBINING DOTTED GRAVE ACCENT",
    "1DC1": "COMBINING DOTTED ACUTE ACCENT",
    "1DC2": "COMBINING SNAKE BELOW",
    "1DC3": "COMBINING SUSPENSION MARK",
    "1DC4": "COMBINING MACRON-ACUTE",
    "1DC5": "COMBINING GRAVE-MACRON",
    "1DC6": "COMBINING MACRON-GRAVE",
    "1DC7": "COMBINING ACUTE-MACRON",
    "1DC8": "COMBINING GRAVE-ACUTE-GRAVE",
    "1DC9": "COMBINING ACUTE-GRAVE-ACUTE",
    "1DCA": "COMBINING LATIN SMALL LETTER R BELOW",
    "1DCB": "COMBINING BREVE-MACRON",
    "1DCC": "COMBINING MACRON-BREVE",
    "1DCD": "COMBINING DOUBLE CIRCUMFLEX ABOVE",
    "1DCE": "COMBINING OGONEK ABOVE",
    "1DCF": "COMBINING ZIGZAG BELOW",
    "1DD0": "COMBINING IS BELOW",
    "1DD1": "COMBINING UR ABOVE",
    "1DD2": "COMBINING US ABOVE",
    "1DD3": "COMBINING LATIN SMALL LETTER FLATTENED OPEN A ABOVE",
    "1DD4": "COMBINING LATIN SMALL LETTER AE",
    "1DD5": "COMBINING LATIN SMALL LETTER AO",
    "1DD6": "COMBINING LATIN SMALL LETTER AV",
    "1DD7": "COMBINING LATIN SMALL LETTER C CEDILLA",
    "1DD8": "COMBINING LATIN SMALL LETTER INSULAR D",
    "1DD9": "COMBINING LATIN SMALL LETTER ETH",
    "1DDA": "COMBINING LATIN SMALL LETTER G",
    "1DDB": "COMBINING LATIN LETTER SMALL CAPITAL G",
    "1DDC": "COMBINING LATIN SMALL LETTER K",
    "1DDD": "COMBINING LATIN SMALL LETTER L",
    "1DDE": "COMBINING LATIN LETTER SMALL CAPITAL L",
    "1DDF": "COMBINING LATIN LETTER SMALL CAPITAL M",
    "1DE0": "COMBINING LATIN SMALL LETTER N",
    "1DE1": "COMBINING LATIN LETTER SMALL CAPITAL N",
    "1DE2": "COMBINING LATIN LETTER SMALL CAPITAL R",
    "1DE3": "COMBINING LATIN SMALL LETTER R ROTUNDA",
    "1DE4": "COMBINING LATIN SMALL LETTER S",
    "1DE5": "COMBINING LATIN SMALL LETTER LONG S",
    "1DE6": "COMBINING LATIN SMALL LETTER Z",
    "1DE7": "COMBINING LATIN SMALL LETTER ALPHA",
    "1DE8": "COMBINING LATIN SMALL LETTER B",
    "1DE9": "COMBINING LATIN SMALL LETTER BETA",
    "1DEA": "COMBINING LATIN SMALL LETTER SCHWA",
    "1DEB": "COMBINING LATIN SMALL LETTER F",
    "1DEC": "COMBINING LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDE",
    "1DED": "COMBINING LATIN SMALL LETTER O WITH LIGHT CENTRALIZATION STROKE",
    "1DEE": "COMBINING LATIN SMALL LETTER P",
    "1DEF": "COMBINING LATIN SMALL LETTER ESH",
    "1DF0": "COMBINING LATIN SMALL LETTER U WITH LIGHT CENTRALIZATION STROKE",
    "1DF1": "COMBINING LATIN SMALL LETTER W",
    "1DF2": "COMBINING LATIN SMALL LETTER A WITH DIAERESIS",
    "1DF3": "COMBINING LATIN SMALL LETTER O WITH DIAERESIS",
    "1DF4": "COMBINING LATIN SMALL LETTER U WITH DIAERESIS",
    "1DF5": "COMBINING UP TACK ABOVE",
    "1DFB": "COMBINING DELETION MARK",
    "1DFC": "COMBINING DOUBLE INVERTED BREVE BELOW",
    "1DFD": "COMBINING ALMOST EQUAL TO BELOW",
    "1DFE": "COMBINING LEFT ARROWHEAD ABOVE",
    "1DFF": "COMBINING RIGHT ARROWHEAD AND DOWN ARROWHEAD BELOW",
    "1E00": "LATIN CAPITAL LETTER A WITH RING BELOW",
    "1E01": "LATIN SMALL LETTER A WITH RING BELOW",
    "1E02": "LATIN CAPITAL LETTER B WITH DOT ABOVE",
    "1E03": "LATIN SMALL LETTER B WITH DOT ABOVE",
    "1E04": "LATIN CAPITAL LETTER B WITH DOT BELOW",
    "1E05": "LATIN SMALL LETTER B WITH DOT BELOW",
    "1E06": "LATIN CAPITAL LETTER B WITH LINE BELOW",
    "1E07": "LATIN SMALL LETTER B WITH LINE BELOW",
    "1E08": "LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE",
    "1E09": "LATIN SMALL LETTER C WITH CEDILLA AND ACUTE",
    "1E0A": "LATIN CAPITAL LETTER D WITH DOT ABOVE",
    "1E0B": "LATIN SMALL LETTER D WITH DOT ABOVE",
    "1E0C": "LATIN CAPITAL LETTER D WITH DOT BELOW",
    "1E0D": "LATIN SMALL LETTER D WITH DOT BELOW",
    "1E0E": "LATIN CAPITAL LETTER D WITH LINE BELOW",
    "1E0F": "LATIN SMALL LETTER D WITH LINE BELOW",
    "1E10": "LATIN CAPITAL LETTER D WITH CEDILLA",
    "1E11": "LATIN SMALL LETTER D WITH CEDILLA",
    "1E12": "LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW",
    "1E13": "LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW",
    "1E14": "LATIN CAPITAL LETTER E WITH MACRON AND GRAVE",
    "1E15": "LATIN SMALL LETTER E WITH MACRON AND GRAVE",
    "1E16": "LATIN CAPITAL LETTER E WITH MACRON AND ACUTE",
    "1E17": "LATIN SMALL LETTER E WITH MACRON AND ACUTE",
    "1E18": "LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW",
    "1E19": "LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW",
    "1E1A": "LATIN CAPITAL LETTER E WITH TILDE BELOW",
    "1E1B": "LATIN SMALL LETTER E WITH TILDE BELOW",
    "1E1C": "LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE",
    "1E1D": "LATIN SMALL LETTER E WITH CEDILLA AND BREVE",
    "1E1E": "LATIN CAPITAL LETTER F WITH DOT ABOVE",
    "1E1F": "LATIN SMALL LETTER F WITH DOT ABOVE",
    "1E20": "LATIN CAPITAL LETTER G WITH MACRON",
    "1E21": "LATIN SMALL LETTER G WITH MACRON",
    "1E22": "LATIN CAPITAL LETTER H WITH DOT ABOVE",
    "1E23": "LATIN SMALL LETTER H WITH DOT ABOVE",
    "1E24": "LATIN CAPITAL LETTER H WITH DOT BELOW",
    "1E25": "LATIN SMALL LETTER H WITH DOT BELOW",
    "1E26": "LATIN CAPITAL LETTER H WITH DIAERESIS",
    "1E27": "LATIN SMALL LETTER H WITH DIAERESIS",
    "1E28": "LATIN CAPITAL LETTER H WITH CEDILLA",
    "1E29": "LATIN SMALL LETTER H WITH CEDILLA",
    "1E2A": "LATIN CAPITAL LETTER H WITH BREVE BELOW",
    "1E2B": "LATIN SMALL LETTER H WITH BREVE BELOW",
    "1E2C": "LATIN CAPITAL LETTER I WITH TILDE BELOW",
    "1E2D": "LATIN SMALL LETTER I WITH TILDE BELOW",
    "1E2E": "LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE",
    "1E2F": "LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE",
    "1E30": "LATIN CAPITAL LETTER K WITH ACUTE",
    "1E31": "LATIN SMALL LETTER K WITH ACUTE",
    "1E32": "LATIN CAPITAL LETTER K WITH DOT BELOW",
    "1E33": "LATIN SMALL LETTER K WITH DOT BELOW",
    "1E34": "LATIN CAPITAL LETTER K WITH LINE BELOW",
    "1E35": "LATIN SMALL LETTER K WITH LINE BELOW",
    "1E36": "LATIN CAPITAL LETTER L WITH DOT BELOW",
    "1E37": "LATIN SMALL LETTER L WITH DOT BELOW",
    "1E38": "LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON",
    "1E39": "LATIN SMALL LETTER L WITH DOT BELOW AND MACRON",
    "1E3A": "LATIN CAPITAL LETTER L WITH LINE BELOW",
    "1E3B": "LATIN SMALL LETTER L WITH LINE BELOW",
    "1E3C": "LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW",
    "1E3D": "LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW",
    "1E3E": "LATIN CAPITAL LETTER M WITH ACUTE",
    "1E3F": "LATIN SMALL LETTER M WITH ACUTE",
    "1E40": "LATIN CAPITAL LETTER M WITH DOT ABOVE",
    "1E41": "LATIN SMALL LETTER M WITH DOT ABOVE",
    "1E42": "LATIN CAPITAL LETTER M WITH DOT BELOW",
    "1E43": "LATIN SMALL LETTER M WITH DOT BELOW",
    "1E44": "LATIN CAPITAL LETTER N WITH DOT ABOVE",
    "1E45": "LATIN SMALL LETTER N WITH DOT ABOVE",
    "1E46": "LATIN CAPITAL LETTER N WITH DOT BELOW",
    "1E47": "LATIN SMALL LETTER N WITH DOT BELOW",
    "1E48": "LATIN CAPITAL LETTER N WITH LINE BELOW",
    "1E49": "LATIN SMALL LETTER N WITH LINE BELOW",
    "1E4A": "LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW",
    "1E4B": "LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW",
    "1E4C": "LATIN CAPITAL LETTER O WITH TILDE AND ACUTE",
    "1E4D": "LATIN SMALL LETTER O WITH TILDE AND ACUTE",
    "1E4E": "LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS",
    "1E4F": "LATIN SMALL LETTER O WITH TILDE AND DIAERESIS",
    "1E50": "LATIN CAPITAL LETTER O WITH MACRON AND GRAVE",
    "1E51": "LATIN SMALL LETTER O WITH MACRON AND GRAVE",
    "1E52": "LATIN CAPITAL LETTER O WITH MACRON AND ACUTE",
    "1E53": "LATIN SMALL LETTER O WITH MACRON AND ACUTE",
    "1E54": "LATIN CAPITAL LETTER P WITH ACUTE",
    "1E55": "LATIN SMALL LETTER P WITH ACUTE",
    "1E56": "LATIN CAPITAL LETTER P WITH DOT ABOVE",
    "1E57": "LATIN SMALL LETTER P WITH DOT ABOVE",
    "1E58": "LATIN CAPITAL LETTER R WITH DOT ABOVE",
    "1E59": "LATIN SMALL LETTER R WITH DOT ABOVE",
    "1E5A": "LATIN CAPITAL LETTER R WITH DOT BELOW",
    "1E5B": "LATIN SMALL LETTER R WITH DOT BELOW",
    "1E5C": "LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON",
    "1E5D": "LATIN SMALL LETTER R WITH DOT BELOW AND MACRON",
    "1E5E": "LATIN CAPITAL LETTER R WITH LINE BELOW",
    "1E5F": "LATIN SMALL LETTER R WITH LINE BELOW",
    "1E60": "LATIN CAPITAL LETTER S WITH DOT ABOVE",
    "1E61": "LATIN SMALL LETTER S WITH DOT ABOVE",
    "1E62": "LATIN CAPITAL LETTER S WITH DOT BELOW",
    "1E63": "LATIN SMALL LETTER S WITH DOT BELOW",
    "1E64": "LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE",
    "1E65": "LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE",
    "1E66": "LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE",
    "1E67": "LATIN SMALL LETTER S WITH CARON AND DOT ABOVE",
    "1E68": "LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE",
    "1E69": "LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE",
    "1E6A": "LATIN CAPITAL LETTER T WITH DOT ABOVE",
    "1E6B": "LATIN SMALL LETTER T WITH DOT ABOVE",
    "1E6C": "LATIN CAPITAL LETTER T WITH DOT BELOW",
    "1E6D": "LATIN SMALL LETTER T WITH DOT BELOW",
    "1E6E": "LATIN CAPITAL LETTER T WITH LINE BELOW",
    "1E6F": "LATIN SMALL LETTER T WITH LINE BELOW",
    "1E70": "LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW",
    "1E71": "LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW",
    "1E72": "LATIN CAPITAL LETTER U WITH DIAERESIS BELOW",
    "1E73": "LATIN SMALL LETTER U WITH DIAERESIS BELOW",
    "1E74": "LATIN CAPITAL LETTER U WITH TILDE BELOW",
    "1E75": "LATIN SMALL LETTER U WITH TILDE BELOW",
    "1E76": "LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW",
    "1E77": "LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW",
    "1E78": "LATIN CAPITAL LETTER U WITH TILDE AND ACUTE",
    "1E79": "LATIN SMALL LETTER U WITH TILDE AND ACUTE",
    "1E7A": "LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS",
    "1E7B": "LATIN SMALL LETTER U WITH MACRON AND DIAERESIS",
    "1E7C": "LATIN CAPITAL LETTER V WITH TILDE",
    "1E7D": "LATIN SMALL LETTER V WITH TILDE",
    "1E7E": "LATIN CAPITAL LETTER V WITH DOT BELOW",
    "1E7F": "LATIN SMALL LETTER V WITH DOT BELOW",
    "1E80": "LATIN CAPITAL LETTER W WITH GRAVE",
    "1E81": "LATIN SMALL LETTER W WITH GRAVE",
    "1E82": "LATIN CAPITAL LETTER W WITH ACUTE",
    "1E83": "LATIN SMALL LETTER W WITH ACUTE",
    "1E84": "LATIN CAPITAL LETTER W WITH DIAERESIS",
    "1E85": "LATIN SMALL LETTER W WITH DIAERESIS",
    "1E86": "LATIN CAPITAL LETTER W WITH DOT ABOVE",
    "1E87": "LATIN SMALL LETTER W WITH DOT ABOVE",
    "1E88": "LATIN CAPITAL LETTER W WITH DOT BELOW",
    "1E89": "LATIN SMALL LETTER W WITH DOT BELOW",
    "1E8A": "LATIN CAPITAL LETTER X WITH DOT ABOVE",
    "1E8B": "LATIN SMALL LETTER X WITH DOT ABOVE",
    "1E8C": "LATIN CAPITAL LETTER X WITH DIAERESIS",
    "1E8D": "LATIN SMALL LETTER X WITH DIAERESIS",
    "1E8E": "LATIN CAPITAL LETTER Y WITH DOT ABOVE",
    "1E8F": "LATIN SMALL LETTER Y WITH DOT ABOVE",
    "1E90": "LATIN CAPITAL LETTER Z WITH CIRCUMFLEX",
    "1E91": "LATIN SMALL LETTER Z WITH CIRCUMFLEX",
    "1E92": "LATIN CAPITAL LETTER Z WITH DOT BELOW",
    "1E93": "LATIN SMALL LETTER Z WITH DOT BELOW",
    "1E94": "LATIN CAPITAL LETTER Z WITH LINE BELOW",
    "1E95": "LATIN SMALL LETTER Z WITH LINE BELOW",
    "1E96": "LATIN SMALL LETTER H WITH LINE BELOW",
    "1E97": "LATIN SMALL LETTER T WITH DIAERESIS",
    "1E98": "LATIN SMALL LETTER W WITH RING ABOVE",
    "1E99": "LATIN SMALL LETTER Y WITH RING ABOVE",
    "1E9A": "LATIN SMALL LETTER A WITH RIGHT HALF RING",
    "1E9B": "LATIN SMALL LETTER LONG S WITH DOT ABOVE",
    "1E9C": "LATIN SMALL LETTER LONG S WITH DIAGONAL STROKE",
    "1E9D": "LATIN SMALL LETTER LONG S WITH HIGH STROKE",
    "1E9E": "LATIN CAPITAL LETTER SHARP S",
    "1E9F": "LATIN SMALL LETTER DELTA",
    "1EA0": "LATIN CAPITAL LETTER A WITH DOT BELOW",
    "1EA1": "LATIN SMALL LETTER A WITH DOT BELOW",
    "1EA2": "LATIN CAPITAL LETTER A WITH HOOK ABOVE",
    "1EA3": "LATIN SMALL LETTER A WITH HOOK ABOVE",
    "1EA4": "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE",
    "1EA5": "LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE",
    "1EA6": "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE",
    "1EA7": "LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE",
    "1EA8": "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE",
    "1EA9": "LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE",
    "1EAA": "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE",
    "1EAB": "LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE",
    "1EAC": "LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW",
    "1EAD": "LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW",
    "1EAE": "LATIN CAPITAL LETTER A WITH BREVE AND ACUTE",
    "1EAF": "LATIN SMALL LETTER A WITH BREVE AND ACUTE",
    "1EB0": "LATIN CAPITAL LETTER A WITH BREVE AND GRAVE",
    "1EB1": "LATIN SMALL LETTER A WITH BREVE AND GRAVE",
    "1EB2": "LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE",
    "1EB3": "LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE",
    "1EB4": "LATIN CAPITAL LETTER A WITH BREVE AND TILDE",
    "1EB5": "LATIN SMALL LETTER A WITH BREVE AND TILDE",
    "1EB6": "LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW",
    "1EB7": "LATIN SMALL LETTER A WITH BREVE AND DOT BELOW",
    "1EB8": "LATIN CAPITAL LETTER E WITH DOT BELOW",
    "1EB9": "LATIN SMALL LETTER E WITH DOT BELOW",
    "1EBA": "LATIN CAPITAL LETTER E WITH HOOK ABOVE",
    "1EBB": "LATIN SMALL LETTER E WITH HOOK ABOVE",
    "1EBC": "LATIN CAPITAL LETTER E WITH TILDE",
    "1EBD": "LATIN SMALL LETTER E WITH TILDE",
    "1EBE": "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE",
    "1EBF": "LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE",
    "1EC0": "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE",
    "1EC1": "LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE",
    "1EC2": "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE",
    "1EC3": "LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE",
    "1EC4": "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE",
    "1EC5": "LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE",
    "1EC6": "LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW",
    "1EC7": "LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW",
    "1EC8": "LATIN CAPITAL LETTER I WITH HOOK ABOVE",
    "1EC9": "LATIN SMALL LETTER I WITH HOOK ABOVE",
    "1ECA": "LATIN CAPITAL LETTER I WITH DOT BELOW",
    "1ECB": "LATIN SMALL LETTER I WITH DOT BELOW",
    "1ECC": "LATIN CAPITAL LETTER O WITH DOT BELOW",
    "1ECD": "LATIN SMALL LETTER O WITH DOT BELOW",
    "1ECE": "LATIN CAPITAL LETTER O WITH HOOK ABOVE",
    "1ECF": "LATIN SMALL LETTER O WITH HOOK ABOVE",
    "1ED0": "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE",
    "1ED1": "LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE",
    "1ED2": "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE",
    "1ED3": "LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE",
    "1ED4": "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE",
    "1ED5": "LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE",
    "1ED6": "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE",
    "1ED7": "LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE",
    "1ED8": "LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW",
    "1ED9": "LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW",
    "1EDA": "LATIN CAPITAL LETTER O WITH HORN AND ACUTE",
    "1EDB": "LATIN SMALL LETTER O WITH HORN AND ACUTE",
    "1EDC": "LATIN CAPITAL LETTER O WITH HORN AND GRAVE",
    "1EDD": "LATIN SMALL LETTER O WITH HORN AND GRAVE",
    "1EDE": "LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE",
    "1EDF": "LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE",
    "1EE0": "LATIN CAPITAL LETTER O WITH HORN AND TILDE",
    "1EE1": "LATIN SMALL LETTER O WITH HORN AND TILDE",
    "1EE2": "LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW",
    "1EE3": "LATIN SMALL LETTER O WITH HORN AND DOT BELOW",
    "1EE4": "LATIN CAPITAL LETTER U WITH DOT BELOW",
    "1EE5": "LATIN SMALL LETTER U WITH DOT BELOW",
    "1EE6": "LATIN CAPITAL LETTER U WITH HOOK ABOVE",
    "1EE7": "LATIN SMALL LETTER U WITH HOOK ABOVE",
    "1EE8": "LATIN CAPITAL LETTER U WITH HORN AND ACUTE",
    "1EE9": "LATIN SMALL LETTER U WITH HORN AND ACUTE",
    "1EEA": "LATIN CAPITAL LETTER U WITH HORN AND GRAVE",
    "1EEB": "LATIN SMALL LETTER U WITH HORN AND GRAVE",
    "1EEC": "LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE",
    "1EED": "LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE",
    "1EEE": "LATIN CAPITAL LETTER U WITH HORN AND TILDE",
    "1EEF": "LATIN SMALL LETTER U WITH HORN AND TILDE",
    "1EF0": "LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW",
    "1EF1": "LATIN SMALL LETTER U WITH HORN AND DOT BELOW",
    "1EF2": "LATIN CAPITAL LETTER Y WITH GRAVE",
    "1EF3": "LATIN SMALL LETTER Y WITH GRAVE",
    "1EF4": "LATIN CAPITAL LETTER Y WITH DOT BELOW",
    "1EF5": "LATIN SMALL LETTER Y WITH DOT BELOW",
    "1EF6": "LATIN CAPITAL LETTER Y WITH HOOK ABOVE",
    "1EF7": "LATIN SMALL LETTER Y WITH HOOK ABOVE",
    "1EF8": "LATIN CAPITAL LETTER Y WITH TILDE",
    "1EF9": "LATIN SMALL LETTER Y WITH TILDE",
    "1EFA": "LATIN CAPITAL LETTER MIDDLE-WELSH LL",
    "1EFB": "LATIN SMALL LETTER MIDDLE-WELSH LL",
    "1EFC": "LATIN CAPITAL LETTER MIDDLE-WELSH V",
    "1EFD": "LATIN SMALL LETTER MIDDLE-WELSH V",
    "1EFE": "LATIN CAPITAL LETTER Y WITH LOOP",
    "1EFF": "LATIN SMALL LETTER Y WITH LOOP",
    "1F00": "GREEK SMALL LETTER ALPHA WITH PSILI",
    "1F01": "GREEK SMALL LETTER ALPHA WITH DASIA",
    "1F02": "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA",
    "1F03": "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA",
    "1F04": "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA",
    "1F05": "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA",
    "1F06": "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI",
    "1F07": "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI",
    "1F08": "GREEK CAPITAL LETTER ALPHA WITH PSILI",
    "1F09": "GREEK CAPITAL LETTER ALPHA WITH DASIA",
    "1F0A": "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA",
    "1F0B": "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA",
    "1F0C": "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA",
    "1F0D": "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA",
    "1F0E": "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI",
    "1F0F": "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI",
    "1F10": "GREEK SMALL LETTER EPSILON WITH PSILI",
    "1F11": "GREEK SMALL LETTER EPSILON WITH DASIA",
    "1F12": "GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA",
    "1F13": "GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA",
    "1F14": "GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA",
    "1F15": "GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA",
    "1F18": "GREEK CAPITAL LETTER EPSILON WITH PSILI",
    "1F19": "GREEK CAPITAL LETTER EPSILON WITH DASIA",
    "1F1A": "GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA",
    "1F1B": "GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA",
    "1F1C": "GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA",
    "1F1D": "GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA",
    "1F20": "GREEK SMALL LETTER ETA WITH PSILI",
    "1F21": "GREEK SMALL LETTER ETA WITH DASIA",
    "1F22": "GREEK SMALL LETTER ETA WITH PSILI AND VARIA",
    "1F23": "GREEK SMALL LETTER ETA WITH DASIA AND VARIA",
    "1F24": "GREEK SMALL LETTER ETA WITH PSILI AND OXIA",
    "1F25": "GREEK SMALL LETTER ETA WITH DASIA AND OXIA",
    "1F26": "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI",
    "1F27": "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI",
    "1F28": "GREEK CAPITAL LETTER ETA WITH PSILI",
    "1F29": "GREEK CAPITAL LETTER ETA WITH DASIA",
    "1F2A": "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA",
    "1F2B": "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA",
    "1F2C": "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA",
    "1F2D": "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA",
    "1F2E": "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI",
    "1F2F": "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI",
    "1F30": "GREEK SMALL LETTER IOTA WITH PSILI",
    "1F31": "GREEK SMALL LETTER IOTA WITH DASIA",
    "1F32": "GREEK SMALL LETTER IOTA WITH PSILI AND VARIA",
    "1F33": "GREEK SMALL LETTER IOTA WITH DASIA AND VARIA",
    "1F34": "GREEK SMALL LETTER IOTA WITH PSILI AND OXIA",
    "1F35": "GREEK SMALL LETTER IOTA WITH DASIA AND OXIA",
    "1F36": "GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI",
    "1F37": "GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI",
    "1F38": "GREEK CAPITAL LETTER IOTA WITH PSILI",
    "1F39": "GREEK CAPITAL LETTER IOTA WITH DASIA",
    "1F3A": "GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA",
    "1F3B": "GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA",
    "1F3C": "GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA",
    "1F3D": "GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA",
    "1F3E": "GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI",
    "1F3F": "GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI",
    "1F40": "GREEK SMALL LETTER OMICRON WITH PSILI",
    "1F41": "GREEK SMALL LETTER OMICRON WITH DASIA",
    "1F42": "GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA",
    "1F43": "GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA",
    "1F44": "GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA",
    "1F45": "GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA",
    "1F48": "GREEK CAPITAL LETTER OMICRON WITH PSILI",
    "1F49": "GREEK CAPITAL LETTER OMICRON WITH DASIA",
    "1F4A": "GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA",
    "1F4B": "GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA",
    "1F4C": "GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA",
    "1F4D": "GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA",
    "1F50": "GREEK SMALL LETTER UPSILON WITH PSILI",
    "1F51": "GREEK SMALL LETTER UPSILON WITH DASIA",
    "1F52": "GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA",
    "1F53": "GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA",
    "1F54": "GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA",
    "1F55": "GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA",
    "1F56": "GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI",
    "1F57": "GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI",
    "1F59": "GREEK CAPITAL LETTER UPSILON WITH DASIA",
    "1F5B": "GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA",
    "1F5D": "GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA",
    "1F5F": "GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI",
    "1F60": "GREEK SMALL LETTER OMEGA WITH PSILI",
    "1F61": "GREEK SMALL LETTER OMEGA WITH DASIA",
    "1F62": "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA",
    "1F63": "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA",
    "1F64": "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA",
    "1F65": "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA",
    "1F66": "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI",
    "1F67": "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI",
    "1F68": "GREEK CAPITAL LETTER OMEGA WITH PSILI",
    "1F69": "GREEK CAPITAL LETTER OMEGA WITH DASIA",
    "1F6A": "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA",
    "1F6B": "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA",
    "1F6C": "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA",
    "1F6D": "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA",
    "1F6E": "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI",
    "1F6F": "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI",
    "1F70": "GREEK SMALL LETTER ALPHA WITH VARIA",
    "1F71": "GREEK SMALL LETTER ALPHA WITH OXIA",
    "1F72": "GREEK SMALL LETTER EPSILON WITH VARIA",
    "1F73": "GREEK SMALL LETTER EPSILON WITH OXIA",
    "1F74": "GREEK SMALL LETTER ETA WITH VARIA",
    "1F75": "GREEK SMALL LETTER ETA WITH OXIA",
    "1F76": "GREEK SMALL LETTER IOTA WITH VARIA",
    "1F77": "GREEK SMALL LETTER IOTA WITH OXIA",
    "1F78": "GREEK SMALL LETTER OMICRON WITH VARIA",
    "1F79": "GREEK SMALL LETTER OMICRON WITH OXIA",
    "1F7A": "GREEK SMALL LETTER UPSILON WITH VARIA",
    "1F7B": "GREEK SMALL LETTER UPSILON WITH OXIA",
    "1F7C": "GREEK SMALL LETTER OMEGA WITH VARIA",
    "1F7D": "GREEK SMALL LETTER OMEGA WITH OXIA",
    "1F80": "GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI",
    "1F81": "GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI",
    "1F82": "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
    "1F83": "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
    "1F84": "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
    "1F85": "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
    "1F86": "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
    "1F87": "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
    "1F88": "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI",
    "1F89": "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI",
    "1F8A": "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
    "1F8B": "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
    "1F8C": "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
    "1F8D": "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
    "1F8E": "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
    "1F8F": "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
    "1F90": "GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI",
    "1F91": "GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI",
    "1F92": "GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
    "1F93": "GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
    "1F94": "GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
    "1F95": "GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
    "1F96": "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
    "1F97": "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
    "1F98": "GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI",
    "1F99": "GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI",
    "1F9A": "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
    "1F9B": "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
    "1F9C": "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
    "1F9D": "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
    "1F9E": "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
    "1F9F": "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
    "1FA0": "GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI",
    "1FA1": "GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI",
    "1FA2": "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI",
    "1FA3": "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI",
    "1FA4": "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI",
    "1FA5": "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI",
    "1FA6": "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI",
    "1FA7": "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI",
    "1FA8": "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI",
    "1FA9": "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI",
    "1FAA": "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI",
    "1FAB": "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI",
    "1FAC": "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI",
    "1FAD": "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI",
    "1FAE": "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI",
    "1FAF": "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI",
    "1FB0": "GREEK SMALL LETTER ALPHA WITH VRACHY",
    "1FB1": "GREEK SMALL LETTER ALPHA WITH MACRON",
    "1FB2": "GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI",
    "1FB3": "GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI",
    "1FB4": "GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI",
    "1FB6": "GREEK SMALL LETTER ALPHA WITH PERISPOMENI",
    "1FB7": "GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI",
    "1FB8": "GREEK CAPITAL LETTER ALPHA WITH VRACHY",
    "1FB9": "GREEK CAPITAL LETTER ALPHA WITH MACRON",
    "1FBA": "GREEK CAPITAL LETTER ALPHA WITH VARIA",
    "1FBB": "GREEK CAPITAL LETTER ALPHA WITH OXIA",
    "1FBC": "GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI",
    "1FBD": "GREEK KORONIS",
    "1FBE": "GREEK PROSGEGRAMMENI",
    "1FBF": "GREEK PSILI",
    "1FC0": "GREEK PERISPOMENI",
    "1FC1": "GREEK DIALYTIKA AND PERISPOMENI",
    "1FC2": "GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI",
    "1FC3": "GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI",
    "1FC4": "GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI",
    "1FC6": "GREEK SMALL LETTER ETA WITH PERISPOMENI",
    "1FC7": "GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI",
    "1FC8": "GREEK CAPITAL LETTER EPSILON WITH VARIA",
    "1FC9": "GREEK CAPITAL LETTER EPSILON WITH OXIA",
    "1FCA": "GREEK CAPITAL LETTER ETA WITH VARIA",
    "1FCB": "GREEK CAPITAL LETTER ETA WITH OXIA",
    "1FCC": "GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI",
    "1FCD": "GREEK PSILI AND VARIA",
    "1FCE": "GREEK PSILI AND OXIA",
    "1FCF": "GREEK PSILI AND PERISPOMENI",
    "1FD0": "GREEK SMALL LETTER IOTA WITH VRACHY",
    "1FD1": "GREEK SMALL LETTER IOTA WITH MACRON",
    "1FD2": "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA",
    "1FD3": "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA",
    "1FD6": "GREEK SMALL LETTER IOTA WITH PERISPOMENI",
    "1FD7": "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI",
    "1FD8": "GREEK CAPITAL LETTER IOTA WITH VRACHY",
    "1FD9": "GREEK CAPITAL LETTER IOTA WITH MACRON",
    "1FDA": "GREEK CAPITAL LETTER IOTA WITH VARIA",
    "1FDB": "GREEK CAPITAL LETTER IOTA WITH OXIA",
    "1FDD": "GREEK DASIA AND VARIA",
    "1FDE": "GREEK DASIA AND OXIA",
    "1FDF": "GREEK DASIA AND PERISPOMENI",
    "1FE0": "GREEK SMALL LETTER UPSILON WITH VRACHY",
    "1FE1": "GREEK SMALL LETTER UPSILON WITH MACRON",
    "1FE2": "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA",
    "1FE3": "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA",
    "1FE4": "GREEK SMALL LETTER RHO WITH PSILI",
    "1FE5": "GREEK SMALL LETTER RHO WITH DASIA",
    "1FE6": "GREEK SMALL LETTER UPSILON WITH PERISPOMENI",
    "1FE7": "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI",
    "1FE8": "GREEK CAPITAL LETTER UPSILON WITH VRACHY",
    "1FE9": "GREEK CAPITAL LETTER UPSILON WITH MACRON",
    "1FEA": "GREEK CAPITAL LETTER UPSILON WITH VARIA",
    "1FEB": "GREEK CAPITAL LETTER UPSILON WITH OXIA",
    "1FEC": "GREEK CAPITAL LETTER RHO WITH DASIA",
    "1FED": "GREEK DIALYTIKA AND VARIA",
    "1FEE": "GREEK DIALYTIKA AND OXIA",
    "1FEF": "GREEK VARIA",
    "1FF2": "GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI",
    "1FF3": "GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI",
    "1FF4": "GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI",
    "1FF6": "GREEK SMALL LETTER OMEGA WITH PERISPOMENI",
    "1FF7": "GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI",
    "1FF8": "GREEK CAPITAL LETTER OMICRON WITH VARIA",
    "1FF9": "GREEK CAPITAL LETTER OMICRON WITH OXIA",
    "1FFA": "GREEK CAPITAL LETTER OMEGA WITH VARIA",
    "1FFB": "GREEK CAPITAL LETTER OMEGA WITH OXIA",
    "1FFC": "GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI",
    "1FFD": "GREEK OXIA",
    "1FFE": "GREEK DASIA",
    "2000": "EN QUAD",
    "2001": "EM QUAD",
    "2002": "EN SPACE",
    "2003": "EM SPACE",
    "2004": "THREE-PER-EM SPACE",
    "2005": "FOUR-PER-EM SPACE",
    "2006": "SIX-PER-EM SPACE",
    "2007": "FIGURE SPACE",
    "2008": "PUNCTUATION SPACE",
    "2009": "THIN SPACE",
    "200A": "HAIR SPACE",
    "200B": "ZERO WIDTH SPACE",
    "200C": "ZERO WIDTH NON-JOINER",
    "200D": "ZERO WIDTH JOINER",
    "200E": "LEFT-TO-RIGHT MARK",
    "200F": "RIGHT-TO-LEFT MARK",
    "2010": "HYPHEN",
    "2011": "NON-BREAKING HYPHEN",
    "2012": "FIGURE DASH",
    "2013": "EN DASH",
    "2014": "EM DASH",
    "2015": "HORIZONTAL BAR",
    "2016": "DOUBLE VERTICAL LINE",
    "2017": "DOUBLE LOW LINE",
    "2018": "LEFT SINGLE QUOTATION MARK",
    "2019": "RIGHT SINGLE QUOTATION MARK",
    "201A": "SINGLE LOW-9 QUOTATION MARK",
    "201B": "SINGLE HIGH-REVERSED-9 QUOTATION MARK",
    "201C": "LEFT DOUBLE QUOTATION MARK",
    "201D": "RIGHT DOUBLE QUOTATION MARK",
    "201E": "DOUBLE LOW-9 QUOTATION MARK",
    "201F": "DOUBLE HIGH-REVERSED-9 QUOTATION MARK",
    "2020": "DAGGER",
    "2021": "DOUBLE DAGGER",
    "2022": "BULLET",
    "2023": "TRIANGULAR BULLET",
    "2024": "ONE DOT LEADER",
    "2025": "TWO DOT LEADER",
    "2026": "HORIZONTAL ELLIPSIS",
    "2027": "HYPHENATION POINT",
    "2028": "LINE SEPARATOR",
    "2029": "PARAGRAPH SEPARATOR",
    "202A": "LEFT-TO-RIGHT EMBEDDING",
    "202B": "RIGHT-TO-LEFT EMBEDDING",
    "202C": "POP DIRECTIONAL FORMATTING",
    "202D": "LEFT-TO-RIGHT OVERRIDE",
    "202E": "RIGHT-TO-LEFT OVERRIDE",
    "202F": "NARROW NO-BREAK SPACE",
    "2030": "PER MILLE SIGN",
    "2031": "PER TEN THOUSAND SIGN",
    "2032": "PRIME",
    "2033": "DOUBLE PRIME",
    "2034": "TRIPLE PRIME",
    "2035": "REVERSED PRIME",
    "2036": "REVERSED DOUBLE PRIME",
    "2037": "REVERSED TRIPLE PRIME",
    "2038": "CARET",
    "2039": "SINGLE LEFT-POINTING ANGLE QUOTATION MARK",
    "203A": "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK",
    "203B": "REFERENCE MARK",
    "203C": "DOUBLE EXCLAMATION MARK",
    "203D": "INTERROBANG",
    "203E": "OVERLINE",
    "203F": "UNDERTIE",
    "2040": "CHARACTER TIE",
    "2041": "CARET INSERTION POINT",
    "2042": "ASTERISM",
    "2043": "HYPHEN BULLET",
    "2044": "FRACTION SLASH",
    "2045": "LEFT SQUARE BRACKET WITH QUILL",
    "2046": "RIGHT SQUARE BRACKET WITH QUILL",
    "2047": "DOUBLE QUESTION MARK",
    "2048": "QUESTION EXCLAMATION MARK",
    "2049": "EXCLAMATION QUESTION MARK",
    "204A": "TIRONIAN SIGN ET",
    "204B": "REVERSED PILCROW SIGN",
    "204C": "BLACK LEFTWARDS BULLET",
    "204D": "BLACK RIGHTWARDS BULLET",
    "204E": "LOW ASTERISK",
    "204F": "REVERSED SEMICOLON",
    "2050": "CLOSE UP",
    "2051": "TWO ASTERISKS ALIGNED VERTICALLY",
    "2052": "COMMERCIAL MINUS SIGN",
    "2053": "SWUNG DASH",
    "2054": "INVERTED UNDERTIE",
    "2055": "FLOWER PUNCTUATION MARK",
    "2056": "THREE DOT PUNCTUATION",
    "2057": "QUADRUPLE PRIME",
    "2058": "FOUR DOT PUNCTUATION",
    "2059": "FIVE DOT PUNCTUATION",
    "205A": "TWO DOT PUNCTUATION",
    "205B": "FOUR DOT MARK",
    "205C": "DOTTED CROSS",
    "205D": "TRICOLON",
    "205E": "VERTICAL FOUR DOTS",
    "205F": "MEDIUM MATHEMATICAL SPACE",
    "2060": "WORD JOINER",
    "2061": "FUNCTION APPLICATION",
    "2062": "INVISIBLE TIMES",
    "2063": "INVISIBLE SEPARATOR",
    "2064": "INVISIBLE PLUS",
    "2066": "LEFT-TO-RIGHT ISOLATE",
    "2067": "RIGHT-TO-LEFT ISOLATE",
    "2068": "FIRST STRONG ISOLATE",
    "2069": "POP DIRECTIONAL ISOLATE",
    "206A": "INHIBIT SYMMETRIC SWAPPING",
    "206B": "ACTIVATE SYMMETRIC SWAPPING",
    "206C": "INHIBIT ARABIC FORM SHAPING",
    "206D": "ACTIVATE ARABIC FORM SHAPING",
    "206E": "NATIONAL DIGIT SHAPES",
    "206F": "NOMINAL DIGIT SHAPES",
    "2070": "SUPERSCRIPT ZERO",
    "2071": "SUPERSCRIPT LATIN SMALL LETTER I",
    "2074": "SUPERSCRIPT FOUR",
    "2075": "SUPERSCRIPT FIVE",
    "2076": "SUPERSCRIPT SIX",
    "2077": "SUPERSCRIPT SEVEN",
    "2078": "SUPERSCRIPT EIGHT",
    "2079": "SUPERSCRIPT NINE",
    "207A": "SUPERSCRIPT PLUS SIGN",
    "207B": "SUPERSCRIPT MINUS",
    "207C": "SUPERSCRIPT EQUALS SIGN",
    "207D": "SUPERSCRIPT LEFT PARENTHESIS",
    "207E": "SUPERSCRIPT RIGHT PARENTHESIS",
    "207F": "SUPERSCRIPT LATIN SMALL LETTER N",
    "2080": "SUBSCRIPT ZERO",
    "2081": "SUBSCRIPT ONE",
    "2082": "SUBSCRIPT TWO",
    "2083": "SUBSCRIPT THREE",
    "2084": "SUBSCRIPT FOUR",
    "2085": "SUBSCRIPT FIVE",
    "2086": "SUBSCRIPT SIX",
    "2087": "SUBSCRIPT SEVEN",
    "2088": "SUBSCRIPT EIGHT",
    "2089": "SUBSCRIPT NINE",
    "208A": "SUBSCRIPT PLUS SIGN",
    "208B": "SUBSCRIPT MINUS",
    "208C": "SUBSCRIPT EQUALS SIGN",
    "208D": "SUBSCRIPT LEFT PARENTHESIS",
    "208E": "SUBSCRIPT RIGHT PARENTHESIS",
    "2090": "LATIN SUBSCRIPT SMALL LETTER A",
    "2091": "LATIN SUBSCRIPT SMALL LETTER E",
    "2092": "LATIN SUBSCRIPT SMALL LETTER O",
    "2093": "LATIN SUBSCRIPT SMALL LETTER X",
    "2094": "LATIN SUBSCRIPT SMALL LETTER SCHWA",
    "2095": "LATIN SUBSCRIPT SMALL LETTER H",
    "2096": "LATIN SUBSCRIPT SMALL LETTER K",
    "2097": "LATIN SUBSCRIPT SMALL LETTER L",
    "2098": "LATIN SUBSCRIPT SMALL LETTER M",
    "2099": "LATIN SUBSCRIPT SMALL LETTER N",
    "209A": "LATIN SUBSCRIPT SMALL LETTER P",
    "209B": "LATIN SUBSCRIPT SMALL LETTER S",
    "209C": "LATIN SUBSCRIPT SMALL LETTER T",
    "20A0": "EURO-CURRENCY SIGN",
    "20A1": "COLON SIGN",
    "20A2": "CRUZEIRO SIGN",
    "20A3": "FRENCH FRANC SIGN",
    "20A4": "LIRA SIGN",
    "20A5": "MILL SIGN",
    "20A6": "NAIRA SIGN",
    "20A7": "PESETA SIGN",
    "20A8": "RUPEE SIGN",
    "20A9": "WON SIGN",
    "20AA": "NEW SHEQEL SIGN",
    "20AB": "DONG SIGN",
    "20AC": "EURO SIGN",
    "20AD": "KIP SIGN",
    "20AE": "TUGRIK SIGN",
    "20AF": "DRACHMA SIGN",
    "20B0": "GERMAN PENNY SIGN",
    "20B1": "PESO SIGN",
    "20B2": "GUARANI SIGN",
    "20B3": "AUSTRAL SIGN",
    "20B4": "HRYVNIA SIGN",
    "20B5": "CEDI SIGN",
    "20B6": "LIVRE TOURNOIS SIGN",
    "20B7": "SPESMILO SIGN",
    "20B8": "TENGE SIGN",
    "20B9": "INDIAN RUPEE SIGN",
    "20BA": "TURKISH LIRA SIGN",
    "20BB": "NORDIC MARK SIGN",
    "20BC": "MANAT SIGN",
    "20BD": "RUBLE SIGN",
    "20BE": "LARI SIGN",
    "20D0": "COMBINING LEFT HARPOON ABOVE",
    "20D1": "COMBINING RIGHT HARPOON ABOVE",
    "20D2": "COMBINING LONG VERTICAL LINE OVERLAY",
    "20D3": "COMBINING SHORT VERTICAL LINE OVERLAY",
    "20D4": "COMBINING ANTICLOCKWISE ARROW ABOVE",
    "20D5": "COMBINING CLOCKWISE ARROW ABOVE",
    "20D6": "COMBINING LEFT ARROW ABOVE",
    "20D7": "COMBINING RIGHT ARROW ABOVE",
    "20D8": "COMBINING RING OVERLAY",
    "20D9": "COMBINING CLOCKWISE RING OVERLAY",
    "20DA": "COMBINING ANTICLOCKWISE RING OVERLAY",
    "20DB": "COMBINING THREE DOTS ABOVE",
    "20DC": "COMBINING FOUR DOTS ABOVE",
    "20DD": "COMBINING ENCLOSING CIRCLE",
    "20DE": "COMBINING ENCLOSING SQUARE",
    "20DF": "COMBINING ENCLOSING DIAMOND",
    "20E0": "COMBINING ENCLOSING CIRCLE BACKSLASH",
    "20E1": "COMBINING LEFT RIGHT ARROW ABOVE",
    "20E2": "COMBINING ENCLOSING SCREEN",
    "20E3": "COMBINING ENCLOSING KEYCAP",
    "20E4": "COMBINING ENCLOSING UPWARD POINTING TRIANGLE",
    "20E5": "COMBINING REVERSE SOLIDUS OVERLAY",
    "20E6": "COMBINING DOUBLE VERTICAL STROKE OVERLAY",
    "20E7": "COMBINING ANNUITY SYMBOL",
    "20E8": "COMBINING TRIPLE UNDERDOT",
    "20E9": "COMBINING WIDE BRIDGE ABOVE",
    "20EA": "COMBINING LEFTWARDS ARROW OVERLAY",
    "20EB": "COMBINING LONG DOUBLE SOLIDUS OVERLAY",
    "20EC": "COMBINING RIGHTWARDS HARPOON WITH BARB DOWNWARDS",
    "20ED": "COMBINING LEFTWARDS HARPOON WITH BARB DOWNWARDS",
    "20EE": "COMBINING LEFT ARROW BELOW",
    "20EF": "COMBINING RIGHT ARROW BELOW",
    "20F0": "COMBINING ASTERISK ABOVE",
    "2100": "ACCOUNT OF",
    "2101": "ADDRESSED TO THE SUBJECT",
    "2102": "DOUBLE-STRUCK CAPITAL C",
    "2103": "DEGREE CELSIUS",
    "2104": "CENTRE LINE SYMBOL",
    "2105": "CARE OF",
    "2106": "CADA UNA",
    "2107": "EULER CONSTANT",
    "2108": "SCRUPLE",
    "2109": "DEGREE FAHRENHEIT",
    "210A": "SCRIPT SMALL G",
    "210B": "SCRIPT CAPITAL H",
    "210C": "BLACK-LETTER CAPITAL H",
    "210D": "DOUBLE-STRUCK CAPITAL H",
    "210E": "PLANCK CONSTANT",
    "210F": "PLANCK CONSTANT OVER TWO PI",
    "2110": "SCRIPT CAPITAL I",
    "2111": "BLACK-LETTER CAPITAL I",
    "2112": "SCRIPT CAPITAL L",
    "2113": "SCRIPT SMALL L",
    "2114": "L B BAR SYMBOL",
    "2115": "DOUBLE-STRUCK CAPITAL N",
    "2116": "NUMERO SIGN",
    "2117": "SOUND RECORDING COPYRIGHT",
    "2118": "SCRIPT CAPITAL P",
    "2119": "DOUBLE-STRUCK CAPITAL P",
    "211A": "DOUBLE-STRUCK CAPITAL Q",
    "211B": "SCRIPT CAPITAL R",
    "211C": "BLACK-LETTER CAPITAL R",
    "211D": "DOUBLE-STRUCK CAPITAL R",
    "211E": "PRESCRIPTION TAKE",
    "211F": "RESPONSE",
    "2120": "SERVICE MARK",
    "2121": "TELEPHONE SIGN",
    "2122": "TRADE MARK SIGN",
    "2123": "VERSICLE",
    "2124": "DOUBLE-STRUCK CAPITAL Z",
    "2125": "OUNCE SIGN",
    "2126": "OHM SIGN",
    "2127": "INVERTED OHM SIGN",
    "2128": "BLACK-LETTER CAPITAL Z",
    "2129": "TURNED GREEK SMALL LETTER IOTA",
    "212A": "KELVIN SIGN",
    "212B": "ANGSTROM SIGN",
    "212C": "SCRIPT CAPITAL B",
    "212D": "BLACK-LETTER CAPITAL C",
    "212E": "ESTIMATED SYMBOL",
    "212F": "SCRIPT SMALL E",
    "2130": "SCRIPT CAPITAL E",
    "2131": "SCRIPT CAPITAL F",
    "2132": "TURNED CAPITAL F",
    "2133": "SCRIPT CAPITAL M",
    "2134": "SCRIPT SMALL O",
    "2135": "ALEF SYMBOL",
    "2136": "BET SYMBOL",
    "2137": "GIMEL SYMBOL",
    "2138": "DALET SYMBOL",
    "2139": "INFORMATION SOURCE",
    "213A": "ROTATED CAPITAL Q",
    "213B": "FACSIMILE SIGN",
    "213C": "DOUBLE-STRUCK SMALL PI",
    "213D": "DOUBLE-STRUCK SMALL GAMMA",
    "213E": "DOUBLE-STRUCK CAPITAL GAMMA",
    "213F": "DOUBLE-STRUCK CAPITAL PI",
    "2140": "DOUBLE-STRUCK N-ARY SUMMATION",
    "2141": "TURNED SANS-SERIF CAPITAL G",
    "2142": "TURNED SANS-SERIF CAPITAL L",
    "2143": "REVERSED SANS-SERIF CAPITAL L",
    "2144": "TURNED SANS-SERIF CAPITAL Y",
    "2145": "DOUBLE-STRUCK ITALIC CAPITAL D",
    "2146": "DOUBLE-STRUCK ITALIC SMALL D",
    "2147": "DOUBLE-STRUCK ITALIC SMALL E",
    "2148": "DOUBLE-STRUCK ITALIC SMALL I",
    "2149": "DOUBLE-STRUCK ITALIC SMALL J",
    "214A": "PROPERTY LINE",
    "214B": "TURNED AMPERSAND",
    "214C": "PER SIGN",
    "214D": "AKTIESELSKAB",
    "214E": "TURNED SMALL F",
    "214F": "SYMBOL FOR SAMARITAN SOURCE",
    "2150": "VULGAR FRACTION ONE SEVENTH",
    "2151": "VULGAR FRACTION ONE NINTH",
    "2152": "VULGAR FRACTION ONE TENTH",
    "2153": "VULGAR FRACTION ONE THIRD",
    "2154": "VULGAR FRACTION TWO THIRDS",
    "2155": "VULGAR FRACTION ONE FIFTH",
    "2156": "VULGAR FRACTION TWO FIFTHS",
    "2157": "VULGAR FRACTION THREE FIFTHS",
    "2158": "VULGAR FRACTION FOUR FIFTHS",
    "2159": "VULGAR FRACTION ONE SIXTH",
    "215A": "VULGAR FRACTION FIVE SIXTHS",
    "215B": "VULGAR FRACTION ONE EIGHTH",
    "215C": "VULGAR FRACTION THREE EIGHTHS",
    "215D": "VULGAR FRACTION FIVE EIGHTHS",
    "215E": "VULGAR FRACTION SEVEN EIGHTHS",
    "215F": "FRACTION NUMERATOR ONE",
    "2160": "ROMAN NUMERAL ONE",
    "2161": "ROMAN NUMERAL TWO",
    "2162": "ROMAN NUMERAL THREE",
    "2163": "ROMAN NUMERAL FOUR",
    "2164": "ROMAN NUMERAL FIVE",
    "2165": "ROMAN NUMERAL SIX",
    "2166": "ROMAN NUMERAL SEVEN",
    "2167": "ROMAN NUMERAL EIGHT",
    "2168": "ROMAN NUMERAL NINE",
    "2169": "ROMAN NUMERAL TEN",
    "216A": "ROMAN NUMERAL ELEVEN",
    "216B": "ROMAN NUMERAL TWELVE",
    "216C": "ROMAN NUMERAL FIFTY",
    "216D": "ROMAN NUMERAL ONE HUNDRED",
    "216E": "ROMAN NUMERAL FIVE HUNDRED",
    "216F": "ROMAN NUMERAL ONE THOUSAND",
    "2170": "SMALL ROMAN NUMERAL ONE",
    "2171": "SMALL ROMAN NUMERAL TWO",
    "2172": "SMALL ROMAN NUMERAL THREE",
    "2173": "SMALL ROMAN NUMERAL FOUR",
    "2174": "SMALL ROMAN NUMERAL FIVE",
    "2175": "SMALL ROMAN NUMERAL SIX",
    "2176": "SMALL ROMAN NUMERAL SEVEN",
    "2177": "SMALL ROMAN NUMERAL EIGHT",
    "2178": "SMALL ROMAN NUMERAL NINE",
    "2179": "SMALL ROMAN NUMERAL TEN",
    "217A": "SMALL ROMAN NUMERAL ELEVEN",
    "217B": "SMALL ROMAN NUMERAL TWELVE",
    "217C": "SMALL ROMAN NUMERAL FIFTY",
    "217D": "SMALL ROMAN NUMERAL ONE HUNDRED",
    "217E": "SMALL ROMAN NUMERAL FIVE HUNDRED",
    "217F": "SMALL ROMAN NUMERAL ONE THOUSAND",
    "2180": "ROMAN NUMERAL ONE THOUSAND C D",
    "2181": "ROMAN NUMERAL FIVE THOUSAND",
    "2182": "ROMAN NUMERAL TEN THOUSAND",
    "2183": "ROMAN NUMERAL REVERSED ONE HUNDRED",
    "2184": "LATIN SMALL LETTER REVERSED C",
    "2185": "ROMAN NUMERAL SIX LATE FORM",
    "2186": "ROMAN NUMERAL FIFTY EARLY FORM",
    "2187": "ROMAN NUMERAL FIFTY THOUSAND",
    "2188": "ROMAN NUMERAL ONE HUNDRED THOUSAND",
    "2189": "VULGAR FRACTION ZERO THIRDS",
    "218A": "TURNED DIGIT TWO",
    "218B": "TURNED DIGIT THREE",
    "2190": "LEFTWARDS ARROW",
    "2191": "UPWARDS ARROW",
    "2192": "RIGHTWARDS ARROW",
    "2193": "DOWNWARDS ARROW",
    "2194": "LEFT RIGHT ARROW",
    "2195": "UP DOWN ARROW",
    "2196": "NORTH WEST ARROW",
    "2197": "NORTH EAST ARROW",
    "2198": "SOUTH EAST ARROW",
    "2199": "SOUTH WEST ARROW",
    "219A": "LEFTWARDS ARROW WITH STROKE",
    "219B": "RIGHTWARDS ARROW WITH STROKE",
    "219C": "LEFTWARDS WAVE ARROW",
    "219D": "RIGHTWARDS WAVE ARROW",
    "219E": "LEFTWARDS TWO HEADED ARROW",
    "219F": "UPWARDS TWO HEADED ARROW",
    "21A0": "RIGHTWARDS TWO HEADED ARROW",
    "21A1": "DOWNWARDS TWO HEADED ARROW",
    "21A2": "LEFTWARDS ARROW WITH TAIL",
    "21A3": "RIGHTWARDS ARROW WITH TAIL",
    "21A4": "LEFTWARDS ARROW FROM BAR",
    "21A5": "UPWARDS ARROW FROM BAR",
    "21A6": "RIGHTWARDS ARROW FROM BAR",
    "21A7": "DOWNWARDS ARROW FROM BAR",
    "21A8": "UP DOWN ARROW WITH BASE",
    "21A9": "LEFTWARDS ARROW WITH HOOK",
    "21AA": "RIGHTWARDS ARROW WITH HOOK",
    "21AB": "LEFTWARDS ARROW WITH LOOP",
    "21AC": "RIGHTWARDS ARROW WITH LOOP",
    "21AD": "LEFT RIGHT WAVE ARROW",
    "21AE": "LEFT RIGHT ARROW WITH STROKE",
    "21AF": "DOWNWARDS ZIGZAG ARROW",
    "21B0": "UPWARDS ARROW WITH TIP LEFTWARDS",
    "21B1": "UPWARDS ARROW WITH TIP RIGHTWARDS",
    "21B2": "DOWNWARDS ARROW WITH TIP LEFTWARDS",
    "21B3": "DOWNWARDS ARROW WITH TIP RIGHTWARDS",
    "21B4": "RIGHTWARDS ARROW WITH CORNER DOWNWARDS",
    "21B5": "DOWNWARDS ARROW WITH CORNER LEFTWARDS",
    "21B6": "ANTICLOCKWISE TOP SEMICIRCLE ARROW",
    "21B7": "CLOCKWISE TOP SEMICIRCLE ARROW",
    "21B8": "NORTH WEST ARROW TO LONG BAR",
    "21B9": "LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR",
    "21BA": "ANTICLOCKWISE OPEN CIRCLE ARROW",
    "21BB": "CLOCKWISE OPEN CIRCLE ARROW",
    "21BC": "LEFTWARDS HARPOON WITH BARB UPWARDS",
    "21BD": "LEFTWARDS HARPOON WITH BARB DOWNWARDS",
    "21BE": "UPWARDS HARPOON WITH BARB RIGHTWARDS",
    "21BF": "UPWARDS HARPOON WITH BARB LEFTWARDS",
    "21C0": "RIGHTWARDS HARPOON WITH BARB UPWARDS",
    "21C1": "RIGHTWARDS HARPOON WITH BARB DOWNWARDS",
    "21C2": "DOWNWARDS HARPOON WITH BARB RIGHTWARDS",
    "21C3": "DOWNWARDS HARPOON WITH BARB LEFTWARDS",
    "21C4": "RIGHTWARDS ARROW OVER LEFTWARDS ARROW",
    "21C5": "UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW",
    "21C6": "LEFTWARDS ARROW OVER RIGHTWARDS ARROW",
    "21C7": "LEFTWARDS PAIRED ARROWS",
    "21C8": "UPWARDS PAIRED ARROWS",
    "21C9": "RIGHTWARDS PAIRED ARROWS",
    "21CA": "DOWNWARDS PAIRED ARROWS",
    "21CB": "LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON",
    "21CC": "RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON",
    "21CD": "LEFTWARDS DOUBLE ARROW WITH STROKE",
    "21CE": "LEFT RIGHT DOUBLE ARROW WITH STROKE",
    "21CF": "RIGHTWARDS DOUBLE ARROW WITH STROKE",
    "21D0": "LEFTWARDS DOUBLE ARROW",
    "21D1": "UPWARDS DOUBLE ARROW",
    "21D2": "RIGHTWARDS DOUBLE ARROW",
    "21D3": "DOWNWARDS DOUBLE ARROW",
    "21D4": "LEFT RIGHT DOUBLE ARROW",
    "21D5": "UP DOWN DOUBLE ARROW",
    "21D6": "NORTH WEST DOUBLE ARROW",
    "21D7": "NORTH EAST DOUBLE ARROW",
    "21D8": "SOUTH EAST DOUBLE ARROW",
    "21D9": "SOUTH WEST DOUBLE ARROW",
    "21DA": "LEFTWARDS TRIPLE ARROW",
    "21DB": "RIGHTWARDS TRIPLE ARROW",
    "21DC": "LEFTWARDS SQUIGGLE ARROW",
    "21DD": "RIGHTWARDS SQUIGGLE ARROW",
    "21DE": "UPWARDS ARROW WITH DOUBLE STROKE",
    "21DF": "DOWNWARDS ARROW WITH DOUBLE STROKE",
    "21E0": "LEFTWARDS DASHED ARROW",
    "21E1": "UPWARDS DASHED ARROW",
    "21E2": "RIGHTWARDS DASHED ARROW",
    "21E3": "DOWNWARDS DASHED ARROW",
    "21E4": "LEFTWARDS ARROW TO BAR",
    "21E5": "RIGHTWARDS ARROW TO BAR",
    "21E6": "LEFTWARDS WHITE ARROW",
    "21E7": "UPWARDS WHITE ARROW",
    "21E8": "RIGHTWARDS WHITE ARROW",
    "21E9": "DOWNWARDS WHITE ARROW",
    "21EA": "UPWARDS WHITE ARROW FROM BAR",
    "21EB": "UPWARDS WHITE ARROW ON PEDESTAL",
    "21EC": "UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR",
    "21ED": "UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR",
    "21EE": "UPWARDS WHITE DOUBLE ARROW",
    "21EF": "UPWARDS WHITE DOUBLE ARROW ON PEDESTAL",
    "21F0": "RIGHTWARDS WHITE ARROW FROM WALL",
    "21F1": "NORTH WEST ARROW TO CORNER",
    "21F2": "SOUTH EAST ARROW TO CORNER",
    "21F3": "UP DOWN WHITE ARROW",
    "21F4": "RIGHT ARROW WITH SMALL CIRCLE",
    "21F5": "DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW",
    "21F6": "THREE RIGHTWARDS ARROWS",
    "21F7": "LEFTWARDS ARROW WITH VERTICAL STROKE",
    "21F8": "RIGHTWARDS ARROW WITH VERTICAL STROKE",
    "21F9": "LEFT RIGHT ARROW WITH VERTICAL STROKE",
    "21FA": "LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE",
    "21FB": "RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE",
    "21FC": "LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE",
    "21FD": "LEFTWARDS OPEN-HEADED ARROW",
    "21FE": "RIGHTWARDS OPEN-HEADED ARROW",
    "21FF": "LEFT RIGHT OPEN-HEADED ARROW",
    "2200": "FOR ALL",
    "2201": "COMPLEMENT",
    "2202": "PARTIAL DIFFERENTIAL",
    "2203": "THERE EXISTS",
    "2204": "THERE DOES NOT EXIST",
    "2205": "EMPTY SET",
    "2206": "INCREMENT",
    "2207": "NABLA",
    "2208": "ELEMENT OF",
    "2209": "NOT AN ELEMENT OF",
    "220A": "SMALL ELEMENT OF",
    "220B": "CONTAINS AS MEMBER",
    "220C": "DOES NOT CONTAIN AS MEMBER",
    "220D": "SMALL CONTAINS AS MEMBER",
    "220E": "END OF PROOF",
    "220F": "N-ARY PRODUCT",
    "2210": "N-ARY COPRODUCT",
    "2211": "N-ARY SUMMATION",
    "2212": "MINUS SIGN",
    "2213": "MINUS-OR-PLUS SIGN",
    "2214": "DOT PLUS",
    "2215": "DIVISION SLASH",
    "2216": "SET MINUS",
    "2217": "ASTERISK OPERATOR",
    "2218": "RING OPERATOR",
    "2219": "BULLET OPERATOR",
    "221A": "SQUARE ROOT",
    "221B": "CUBE ROOT",
    "221C": "FOURTH ROOT",
    "221D": "PROPORTIONAL TO",
    "221E": "INFINITY",
    "221F": "RIGHT ANGLE",
    "2220": "ANGLE",
    "2221": "MEASURED ANGLE",
    "2222": "SPHERICAL ANGLE",
    "2223": "DIVIDES",
    "2224": "DOES NOT DIVIDE",
    "2225": "PARALLEL TO",
    "2226": "NOT PARALLEL TO",
    "2227": "LOGICAL AND",
    "2228": "LOGICAL OR",
    "2229": "INTERSECTION",
    "222A": "UNION",
    "222B": "INTEGRAL",
    "222C": "DOUBLE INTEGRAL",
    "222D": "TRIPLE INTEGRAL",
    "222E": "CONTOUR INTEGRAL",
    "222F": "SURFACE INTEGRAL",
    "2230": "VOLUME INTEGRAL",
    "2231": "CLOCKWISE INTEGRAL",
    "2232": "CLOCKWISE CONTOUR INTEGRAL",
    "2233": "ANTICLOCKWISE CONTOUR INTEGRAL",
    "2234": "THEREFORE",
    "2235": "BECAUSE",
    "2236": "RATIO",
    "2237": "PROPORTION",
    "2238": "DOT MINUS",
    "2239": "EXCESS",
    "223A": "GEOMETRIC PROPORTION",
    "223B": "HOMOTHETIC",
    "223C": "TILDE OPERATOR",
    "223D": "REVERSED TILDE",
    "223E": "INVERTED LAZY S",
    "223F": "SINE WAVE",
    "2240": "WREATH PRODUCT",
    "2241": "NOT TILDE",
    "2242": "MINUS TILDE",
    "2243": "ASYMPTOTICALLY EQUAL TO",
    "2244": "NOT ASYMPTOTICALLY EQUAL TO",
    "2245": "APPROXIMATELY EQUAL TO",
    "2246": "APPROXIMATELY BUT NOT ACTUALLY EQUAL TO",
    "2247": "NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO",
    "2248": "ALMOST EQUAL TO",
    "2249": "NOT ALMOST EQUAL TO",
    "224A": "ALMOST EQUAL OR EQUAL TO",
    "224B": "TRIPLE TILDE",
    "224C": "ALL EQUAL TO",
    "224D": "EQUIVALENT TO",
    "224E": "GEOMETRICALLY EQUIVALENT TO",
    "224F": "DIFFERENCE BETWEEN",
    "2250": "APPROACHES THE LIMIT",
    "2251": "GEOMETRICALLY EQUAL TO",
    "2252": "APPROXIMATELY EQUAL TO OR THE IMAGE OF",
    "2253": "IMAGE OF OR APPROXIMATELY EQUAL TO",
    "2254": "COLON EQUALS",
    "2255": "EQUALS COLON",
    "2256": "RING IN EQUAL TO",
    "2257": "RING EQUAL TO",
    "2258": "CORRESPONDS TO",
    "2259": "ESTIMATES",
    "225A": "EQUIANGULAR TO",
    "225B": "STAR EQUALS",
    "225C": "DELTA EQUAL TO",
    "225D": "EQUAL TO BY DEFINITION",
    "225E": "MEASURED BY",
    "225F": "QUESTIONED EQUAL TO",
    "2260": "NOT EQUAL TO",
    "2261": "IDENTICAL TO",
    "2262": "NOT IDENTICAL TO",
    "2263": "STRICTLY EQUIVALENT TO",
    "2264": "LESS-THAN OR EQUAL TO",
    "2265": "GREATER-THAN OR EQUAL TO",
    "2266": "LESS-THAN OVER EQUAL TO",
    "2267": "GREATER-THAN OVER EQUAL TO",
    "2268": "LESS-THAN BUT NOT EQUAL TO",
    "2269": "GREATER-THAN BUT NOT EQUAL TO",
    "226A": "MUCH LESS-THAN",
    "226B": "MUCH GREATER-THAN",
    "226C": "BETWEEN",
    "226D": "NOT EQUIVALENT TO",
    "226E": "NOT LESS-THAN",
    "226F": "NOT GREATER-THAN",
    "2270": "NEITHER LESS-THAN NOR EQUAL TO",
    "2271": "NEITHER GREATER-THAN NOR EQUAL TO",
    "2272": "LESS-THAN OR EQUIVALENT TO",
    "2273": "GREATER-THAN OR EQUIVALENT TO",
    "2274": "NEITHER LESS-THAN NOR EQUIVALENT TO",
    "2275": "NEITHER GREATER-THAN NOR EQUIVALENT TO",
    "2276": "LESS-THAN OR GREATER-THAN",
    "2277": "GREATER-THAN OR LESS-THAN",
    "2278": "NEITHER LESS-THAN NOR GREATER-THAN",
    "2279": "NEITHER GREATER-THAN NOR LESS-THAN",
    "227A": "PRECEDES",
    "227B": "SUCCEEDS",
    "227C": "PRECEDES OR EQUAL TO",
    "227D": "SUCCEEDS OR EQUAL TO",
    "227E": "PRECEDES OR EQUIVALENT TO",
    "227F": "SUCCEEDS OR EQUIVALENT TO",
    "2280": "DOES NOT PRECEDE",
    "2281": "DOES NOT SUCCEED",
    "2282": "SUBSET OF",
    "2283": "SUPERSET OF",
    "2284": "NOT A SUBSET OF",
    "2285": "NOT A SUPERSET OF",
    "2286": "SUBSET OF OR EQUAL TO",
    "2287": "SUPERSET OF OR EQUAL TO",
    "2288": "NEITHER A SUBSET OF NOR EQUAL TO",
    "2289": "NEITHER A SUPERSET OF NOR EQUAL TO",
    "228A": "SUBSET OF WITH NOT EQUAL TO",
    "228B": "SUPERSET OF WITH NOT EQUAL TO",
    "228C": "MULTISET",
    "228D": "MULTISET MULTIPLICATION",
    "228E": "MULTISET UNION",
    "228F": "SQUARE IMAGE OF",
    "2290": "SQUARE ORIGINAL OF",
    "2291": "SQUARE IMAGE OF OR EQUAL TO",
    "2292": "SQUARE ORIGINAL OF OR EQUAL TO",
    "2293": "SQUARE CAP",
    "2294": "SQUARE CUP",
    "2295": "CIRCLED PLUS",
    "2296": "CIRCLED MINUS",
    "2297": "CIRCLED TIMES",
    "2298": "CIRCLED DIVISION SLASH",
    "2299": "CIRCLED DOT OPERATOR",
    "229A": "CIRCLED RING OPERATOR",
    "229B": "CIRCLED ASTERISK OPERATOR",
    "229C": "CIRCLED EQUALS",
    "229D": "CIRCLED DASH",
    "229E": "SQUARED PLUS",
    "229F": "SQUARED MINUS",
    "22A0": "SQUARED TIMES",
    "22A1": "SQUARED DOT OPERATOR",
    "22A2": "RIGHT TACK",
    "22A3": "LEFT TACK",
    "22A4": "DOWN TACK",
    "22A5": "UP TACK",
    "22A6": "ASSERTION",
    "22A7": "MODELS",
    "22A8": "TRUE",
    "22A9": "FORCES",
    "22AA": "TRIPLE VERTICAL BAR RIGHT TURNSTILE",
    "22AB": "DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE",
    "22AC": "DOES NOT PROVE",
    "22AD": "NOT TRUE",
    "22AE": "DOES NOT FORCE",
    "22AF": "NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE",
    "22B0": "PRECEDES UNDER RELATION",
    "22B1": "SUCCEEDS UNDER RELATION",
    "22B2": "NORMAL SUBGROUP OF",
    "22B3": "CONTAINS AS NORMAL SUBGROUP",
    "22B4": "NORMAL SUBGROUP OF OR EQUAL TO",
    "22B5": "CONTAINS AS NORMAL SUBGROUP OR EQUAL TO",
    "22B6": "ORIGINAL OF",
    "22B7": "IMAGE OF",
    "22B8": "MULTIMAP",
    "22B9": "HERMITIAN CONJUGATE MATRIX",
    "22BA": "INTERCALATE",
    "22BB": "XOR",
    "22BC": "NAND",
    "22BD": "NOR",
    "22BE": "RIGHT ANGLE WITH ARC",
    "22BF": "RIGHT TRIANGLE",
    "22C0": "N-ARY LOGICAL AND",
    "22C1": "N-ARY LOGICAL OR",
    "22C2": "N-ARY INTERSECTION",
    "22C3": "N-ARY UNION",
    "22C4": "DIAMOND OPERATOR",
    "22C5": "DOT OPERATOR",
    "22C6": "STAR OPERATOR",
    "22C7": "DIVISION TIMES",
    "22C8": "BOWTIE",
    "22C9": "LEFT NORMAL FACTOR SEMIDIRECT PRODUCT",
    "22CA": "RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT",
    "22CB": "LEFT SEMIDIRECT PRODUCT",
    "22CC": "RIGHT SEMIDIRECT PRODUCT",
    "22CD": "REVERSED TILDE EQUALS",
    "22CE": "CURLY LOGICAL OR",
    "22CF": "CURLY LOGICAL AND",
    "22D0": "DOUBLE SUBSET",
    "22D1": "DOUBLE SUPERSET",
    "22D2": "DOUBLE INTERSECTION",
    "22D3": "DOUBLE UNION",
    "22D4": "PITCHFORK",
    "22D5": "EQUAL AND PARALLEL TO",
    "22D6": "LESS-THAN WITH DOT",
    "22D7": "GREATER-THAN WITH DOT",
    "22D8": "VERY MUCH LESS-THAN",
    "22D9": "VERY MUCH GREATER-THAN",
    "22DA": "LESS-THAN EQUAL TO OR GREATER-THAN",
    "22DB": "GREATER-THAN EQUAL TO OR LESS-THAN",
    "22DC": "EQUAL TO OR LESS-THAN",
    "22DD": "EQUAL TO OR GREATER-THAN",
    "22DE": "EQUAL TO OR PRECEDES",
    "22DF": "EQUAL TO OR SUCCEEDS",
    "22E0": "DOES NOT PRECEDE OR EQUAL",
    "22E1": "DOES NOT SUCCEED OR EQUAL",
    "22E2": "NOT SQUARE IMAGE OF OR EQUAL TO",
    "22E3": "NOT SQUARE ORIGINAL OF OR EQUAL TO",
    "22E4": "SQUARE IMAGE OF OR NOT EQUAL TO",
    "22E5": "SQUARE ORIGINAL OF OR NOT EQUAL TO",
    "22E6": "LESS-THAN BUT NOT EQUIVALENT TO",
    "22E7": "GREATER-THAN BUT NOT EQUIVALENT TO",
    "22E8": "PRECEDES BUT NOT EQUIVALENT TO",
    "22E9": "SUCCEEDS BUT NOT EQUIVALENT TO",
    "22EA": "NOT NORMAL SUBGROUP OF",
    "22EB": "DOES NOT CONTAIN AS NORMAL SUBGROUP",
    "22EC": "NOT NORMAL SUBGROUP OF OR EQUAL TO",
    "22ED": "DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL",
    "22EE": "VERTICAL ELLIPSIS",
    "22EF": "MIDLINE HORIZONTAL ELLIPSIS",
    "22F0": "UP RIGHT DIAGONAL ELLIPSIS",
    "22F1": "DOWN RIGHT DIAGONAL ELLIPSIS",
    "22F2": "ELEMENT OF WITH LONG HORIZONTAL STROKE",
    "22F3": "ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
    "22F4": "SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
    "22F5": "ELEMENT OF WITH DOT ABOVE",
    "22F6": "ELEMENT OF WITH OVERBAR",
    "22F7": "SMALL ELEMENT OF WITH OVERBAR",
    "22F8": "ELEMENT OF WITH UNDERBAR",
    "22F9": "ELEMENT OF WITH TWO HORIZONTAL STROKES",
    "22FA": "CONTAINS WITH LONG HORIZONTAL STROKE",
    "22FB": "CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
    "22FC": "SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE",
    "22FD": "CONTAINS WITH OVERBAR",
    "22FE": "SMALL CONTAINS WITH OVERBAR",
    "22FF": "Z NOTATION BAG MEMBERSHIP",
    "2300": "DIAMETER SIGN",
    "2301": "ELECTRIC ARROW",
    "2302": "HOUSE",
    "2303": "UP ARROWHEAD",
    "2304": "DOWN ARROWHEAD",
    "2305": "PROJECTIVE",
    "2306": "PERSPECTIVE",
    "2307": "WAVY LINE",
    "2308": "LEFT CEILING",
    "2309": "RIGHT CEILING",
    "230A": "LEFT FLOOR",
    "230B": "RIGHT FLOOR",
    "230C": "BOTTOM RIGHT CROP",
    "230D": "BOTTOM LEFT CROP",
    "230E": "TOP RIGHT CROP",
    "230F": "TOP LEFT CROP",
    "2310": "REVERSED NOT SIGN",
    "2311": "SQUARE LOZENGE",
    "2312": "ARC",
    "2313": "SEGMENT",
    "2314": "SECTOR",
    "2315": "TELEPHONE RECORDER",
    "2316": "POSITION INDICATOR",
    "2317": "VIEWDATA SQUARE",
    "2318": "PLACE OF INTEREST SIGN",
    "2319": "TURNED NOT SIGN",
    "231A": "WATCH",
    "231B": "HOURGLASS",
    "231C": "TOP LEFT CORNER",
    "231D": "TOP RIGHT CORNER",
    "231E": "BOTTOM LEFT CORNER",
    "231F": "BOTTOM RIGHT CORNER",
    "2320": "TOP HALF INTEGRAL",
    "2321": "BOTTOM HALF INTEGRAL",
    "2322": "FROWN",
    "2323": "SMILE",
    "2324": "UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS",
    "2325": "OPTION KEY",
    "2326": "ERASE TO THE RIGHT",
    "2327": "X IN A RECTANGLE BOX",
    "2328": "KEYBOARD",
    "2329": "LEFT-POINTING ANGLE BRACKET",
    "232A": "RIGHT-POINTING ANGLE BRACKET",
    "232B": "ERASE TO THE LEFT",
    "232C": "BENZENE RING",
    "232D": "CYLINDRICITY",
    "232E": "ALL AROUND-PROFILE",
    "232F": "SYMMETRY",
    "2330": "TOTAL RUNOUT",
    "2331": "DIMENSION ORIGIN",
    "2332": "CONICAL TAPER",
    "2333": "SLOPE",
    "2334": "COUNTERBORE",
    "2335": "COUNTERSINK",
    "2336": "APL FUNCTIONAL SYMBOL I-BEAM",
    "2337": "APL FUNCTIONAL SYMBOL SQUISH QUAD",
    "2338": "APL FUNCTIONAL SYMBOL QUAD EQUAL",
    "2339": "APL FUNCTIONAL SYMBOL QUAD DIVIDE",
    "233A": "APL FUNCTIONAL SYMBOL QUAD DIAMOND",
    "233B": "APL FUNCTIONAL SYMBOL QUAD JOT",
    "233C": "APL FUNCTIONAL SYMBOL QUAD CIRCLE",
    "233D": "APL FUNCTIONAL SYMBOL CIRCLE STILE",
    "233E": "APL FUNCTIONAL SYMBOL CIRCLE JOT",
    "233F": "APL FUNCTIONAL SYMBOL SLASH BAR",
    "2340": "APL FUNCTIONAL SYMBOL BACKSLASH BAR",
    "2341": "APL FUNCTIONAL SYMBOL QUAD SLASH",
    "2342": "APL FUNCTIONAL SYMBOL QUAD BACKSLASH",
    "2343": "APL FUNCTIONAL SYMBOL QUAD LESS-THAN",
    "2344": "APL FUNCTIONAL SYMBOL QUAD GREATER-THAN",
    "2345": "APL FUNCTIONAL SYMBOL LEFTWARDS VANE",
    "2346": "APL FUNCTIONAL SYMBOL RIGHTWARDS VANE",
    "2347": "APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW",
    "2348": "APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW",
    "2349": "APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH",
    "234A": "APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR",
    "234B": "APL FUNCTIONAL SYMBOL DELTA STILE",
    "234C": "APL FUNCTIONAL SYMBOL QUAD DOWN CARET",
    "234D": "APL FUNCTIONAL SYMBOL QUAD DELTA",
    "234E": "APL FUNCTIONAL SYMBOL DOWN TACK JOT",
    "234F": "APL FUNCTIONAL SYMBOL UPWARDS VANE",
    "2350": "APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW",
    "2351": "APL FUNCTIONAL SYMBOL UP TACK OVERBAR",
    "2352": "APL FUNCTIONAL SYMBOL DEL STILE",
    "2353": "APL FUNCTIONAL SYMBOL QUAD UP CARET",
    "2354": "APL FUNCTIONAL SYMBOL QUAD DEL",
    "2355": "APL FUNCTIONAL SYMBOL UP TACK JOT",
    "2356": "APL FUNCTIONAL SYMBOL DOWNWARDS VANE",
    "2357": "APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW",
    "2358": "APL FUNCTIONAL SYMBOL QUOTE UNDERBAR",
    "2359": "APL FUNCTIONAL SYMBOL DELTA UNDERBAR",
    "235A": "APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR",
    "235B": "APL FUNCTIONAL SYMBOL JOT UNDERBAR",
    "235C": "APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR",
    "235D": "APL FUNCTIONAL SYMBOL UP SHOE JOT",
    "235E": "APL FUNCTIONAL SYMBOL QUOTE QUAD",
    "235F": "APL FUNCTIONAL SYMBOL CIRCLE STAR",
    "2360": "APL FUNCTIONAL SYMBOL QUAD COLON",
    "2361": "APL FUNCTIONAL SYMBOL UP TACK DIAERESIS",
    "2362": "APL FUNCTIONAL SYMBOL DEL DIAERESIS",
    "2363": "APL FUNCTIONAL SYMBOL STAR DIAERESIS",
    "2364": "APL FUNCTIONAL SYMBOL JOT DIAERESIS",
    "2365": "APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS",
    "2366": "APL FUNCTIONAL SYMBOL DOWN SHOE STILE",
    "2367": "APL FUNCTIONAL SYMBOL LEFT SHOE STILE",
    "2368": "APL FUNCTIONAL SYMBOL TILDE DIAERESIS",
    "2369": "APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS",
    "236A": "APL FUNCTIONAL SYMBOL COMMA BAR",
    "236B": "APL FUNCTIONAL SYMBOL DEL TILDE",
    "236C": "APL FUNCTIONAL SYMBOL ZILDE",
    "236D": "APL FUNCTIONAL SYMBOL STILE TILDE",
    "236E": "APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR",
    "236F": "APL FUNCTIONAL SYMBOL QUAD NOT EQUAL",
    "2370": "APL FUNCTIONAL SYMBOL QUAD QUESTION",
    "2371": "APL FUNCTIONAL SYMBOL DOWN CARET TILDE",
    "2372": "APL FUNCTIONAL SYMBOL UP CARET TILDE",
    "2373": "APL FUNCTIONAL SYMBOL IOTA",
    "2374": "APL FUNCTIONAL SYMBOL RHO",
    "2375": "APL FUNCTIONAL SYMBOL OMEGA",
    "2376": "APL FUNCTIONAL SYMBOL ALPHA UNDERBAR",
    "2377": "APL FUNCTIONAL SYMBOL EPSILON UNDERBAR",
    "2378": "APL FUNCTIONAL SYMBOL IOTA UNDERBAR",
    "2379": "APL FUNCTIONAL SYMBOL OMEGA UNDERBAR",
    "237A": "APL FUNCTIONAL SYMBOL ALPHA",
    "237B": "NOT CHECK MARK",
    "237C": "RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW",
    "237D": "SHOULDERED OPEN BOX",
    "237E": "BELL SYMBOL",
    "237F": "VERTICAL LINE WITH MIDDLE DOT",
    "2380": "INSERTION SYMBOL",
    "2381": "CONTINUOUS UNDERLINE SYMBOL",
    "2382": "DISCONTINUOUS UNDERLINE SYMBOL",
    "2383": "EMPHASIS SYMBOL",
    "2384": "COMPOSITION SYMBOL",
    "2385": "WHITE SQUARE WITH CENTRE VERTICAL LINE",
    "2386": "ENTER SYMBOL",
    "2387": "ALTERNATIVE KEY SYMBOL",
    "2388": "HELM SYMBOL",
    "2389": "CIRCLED HORIZONTAL BAR WITH NOTCH",
    "238A": "CIRCLED TRIANGLE DOWN",
    "238B": "BROKEN CIRCLE WITH NORTHWEST ARROW",
    "238C": "UNDO SYMBOL",
    "238D": "MONOSTABLE SYMBOL",
    "238E": "HYSTERESIS SYMBOL",
    "238F": "OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL",
    "2390": "OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL",
    "2391": "PASSIVE-PULL-DOWN-OUTPUT SYMBOL",
    "2392": "PASSIVE-PULL-UP-OUTPUT SYMBOL",
    "2393": "DIRECT CURRENT SYMBOL FORM TWO",
    "2394": "SOFTWARE-FUNCTION SYMBOL",
    "2395": "APL FUNCTIONAL SYMBOL QUAD",
    "2396": "DECIMAL SEPARATOR KEY SYMBOL",
    "2397": "PREVIOUS PAGE",
    "2398": "NEXT PAGE",
    "2399": "PRINT SCREEN SYMBOL",
    "239A": "CLEAR SCREEN SYMBOL",
    "239B": "LEFT PARENTHESIS UPPER HOOK",
    "239C": "LEFT PARENTHESIS EXTENSION",
    "239D": "LEFT PARENTHESIS LOWER HOOK",
    "239E": "RIGHT PARENTHESIS UPPER HOOK",
    "239F": "RIGHT PARENTHESIS EXTENSION",
    "23A0": "RIGHT PARENTHESIS LOWER HOOK",
    "23A1": "LEFT SQUARE BRACKET UPPER CORNER",
    "23A2": "LEFT SQUARE BRACKET EXTENSION",
    "23A3": "LEFT SQUARE BRACKET LOWER CORNER",
    "23A4": "RIGHT SQUARE BRACKET UPPER CORNER",
    "23A5": "RIGHT SQUARE BRACKET EXTENSION",
    "23A6": "RIGHT SQUARE BRACKET LOWER CORNER",
    "23A7": "LEFT CURLY BRACKET UPPER HOOK",
    "23A8": "LEFT CURLY BRACKET MIDDLE PIECE",
    "23A9": "LEFT CURLY BRACKET LOWER HOOK",
    "23AA": "CURLY BRACKET EXTENSION",
    "23AB": "RIGHT CURLY BRACKET UPPER HOOK",
    "23AC": "RIGHT CURLY BRACKET MIDDLE PIECE",
    "23AD": "RIGHT CURLY BRACKET LOWER HOOK",
    "23AE": "INTEGRAL EXTENSION",
    "23AF": "HORIZONTAL LINE EXTENSION",
    "23B0": "UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION",
    "23B1": "UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION",
    "23B2": "SUMMATION TOP",
    "23B3": "SUMMATION BOTTOM",
    "23B4": "TOP SQUARE BRACKET",
    "23B5": "BOTTOM SQUARE BRACKET",
    "23B6": "BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET",
    "23B7": "RADICAL SYMBOL BOTTOM",
    "23B8": "LEFT VERTICAL BOX LINE",
    "23B9": "RIGHT VERTICAL BOX LINE",
    "23BA": "HORIZONTAL SCAN LINE-1",
    "23BB": "HORIZONTAL SCAN LINE-3",
    "23BC": "HORIZONTAL SCAN LINE-7",
    "23BD": "HORIZONTAL SCAN LINE-9",
    "23BE": "DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT",
    "23BF": "DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT",
    "23C0": "DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE",
    "23C1": "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE",
    "23C2": "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE",
    "23C3": "DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE",
    "23C4": "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE",
    "23C5": "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE",
    "23C6": "DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE",
    "23C7": "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE",
    "23C8": "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE",
    "23C9": "DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL",
    "23CA": "DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL",
    "23CB": "DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT",
    "23CC": "DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT",
    "23CD": "SQUARE FOOT",
    "23CE": "RETURN SYMBOL",
    "23CF": "EJECT SYMBOL",
    "23D0": "VERTICAL LINE EXTENSION",
    "23D1": "METRICAL BREVE",
    "23D2": "METRICAL LONG OVER SHORT",
    "23D3": "METRICAL SHORT OVER LONG",
    "23D4": "METRICAL LONG OVER TWO SHORTS",
    "23D5": "METRICAL TWO SHORTS OVER LONG",
    "23D6": "METRICAL TWO SHORTS JOINED",
    "23D7": "METRICAL TRISEME",
    "23D8": "METRICAL TETRASEME",
    "23D9": "METRICAL PENTASEME",
    "23DA": "EARTH GROUND",
    "23DB": "FUSE",
    "23DC": "TOP PARENTHESIS",
    "23DD": "BOTTOM PARENTHESIS",
    "23DE": "TOP CURLY BRACKET",
    "23DF": "BOTTOM CURLY BRACKET",
    "23E0": "TOP TORTOISE SHELL BRACKET",
    "23E1": "BOTTOM TORTOISE SHELL BRACKET",
    "23E2": "WHITE TRAPEZIUM",
    "23E3": "BENZENE RING WITH CIRCLE",
    "23E4": "STRAIGHTNESS",
    "23E5": "FLATNESS",
    "23E6": "AC CURRENT",
    "23E7": "ELECTRICAL INTERSECTION",
    "23E8": "DECIMAL EXPONENT SYMBOL",
    "23E9": "BLACK RIGHT-POINTING DOUBLE TRIANGLE",
    "23EA": "BLACK LEFT-POINTING DOUBLE TRIANGLE",
    "23EB": "BLACK UP-POINTING DOUBLE TRIANGLE",
    "23EC": "BLACK DOWN-POINTING DOUBLE TRIANGLE",
    "23ED": "BLACK RIGHT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR",
    "23EE": "BLACK LEFT-POINTING DOUBLE TRIANGLE WITH VERTICAL BAR",
    "23EF": "BLACK RIGHT-POINTING TRIANGLE WITH DOUBLE VERTICAL BAR",
    "23F0": "ALARM CLOCK",
    "23F1": "STOPWATCH",
    "23F2": "TIMER CLOCK",
    "23F3": "HOURGLASS WITH FLOWING SAND",
    "23F4": "BLACK MEDIUM LEFT-POINTING TRIANGLE",
    "23F5": "BLACK MEDIUM RIGHT-POINTING TRIANGLE",
    "23F6": "BLACK MEDIUM UP-POINTING TRIANGLE",
    "23F7": "BLACK MEDIUM DOWN-POINTING TRIANGLE",
    "23F8": "DOUBLE VERTICAL BAR",
    "23F9": "BLACK SQUARE FOR STOP",
    "23FA": "BLACK CIRCLE FOR RECORD",
    "23FB": "POWER SYMBOL",
    "23FC": "POWER ON-OFF SYMBOL",
    "23FD": "POWER ON SYMBOL",
    "23FE": "POWER SLEEP SYMBOL",
    "2400": "SYMBOL FOR NULL",
    "2401": "SYMBOL FOR START OF HEADING",
    "2402": "SYMBOL FOR START OF TEXT",
    "2403": "SYMBOL FOR END OF TEXT",
    "2404": "SYMBOL FOR END OF TRANSMISSION",
    "2405": "SYMBOL FOR ENQUIRY",
    "2406": "SYMBOL FOR ACKNOWLEDGE",
    "2407": "SYMBOL FOR BELL",
    "2408": "SYMBOL FOR BACKSPACE",
    "2409": "SYMBOL FOR HORIZONTAL TABULATION",
    "240A": "SYMBOL FOR LINE FEED",
    "240B": "SYMBOL FOR VERTICAL TABULATION",
    "240C": "SYMBOL FOR FORM FEED",
    "240D": "SYMBOL FOR CARRIAGE RETURN",
    "240E": "SYMBOL FOR SHIFT OUT",
    "240F": "SYMBOL FOR SHIFT IN",
    "2410": "SYMBOL FOR DATA LINK ESCAPE",
    "2411": "SYMBOL FOR DEVICE CONTROL ONE",
    "2412": "SYMBOL FOR DEVICE CONTROL TWO",
    "2413": "SYMBOL FOR DEVICE CONTROL THREE",
    "2414": "SYMBOL FOR DEVICE CONTROL FOUR",
    "2415": "SYMBOL FOR NEGATIVE ACKNOWLEDGE",
    "2416": "SYMBOL FOR SYNCHRONOUS IDLE",
    "2417": "SYMBOL FOR END OF TRANSMISSION BLOCK",
    "2418": "SYMBOL FOR CANCEL",
    "2419": "SYMBOL FOR END OF MEDIUM",
    "241A": "SYMBOL FOR SUBSTITUTE",
    "241B": "SYMBOL FOR ESCAPE",
    "241C": "SYMBOL FOR FILE SEPARATOR",
    "241D": "SYMBOL FOR GROUP SEPARATOR",
    "241E": "SYMBOL FOR RECORD SEPARATOR",
    "241F": "SYMBOL FOR UNIT SEPARATOR",
    "2420": "SYMBOL FOR SPACE",
    "2421": "SYMBOL FOR DELETE",
    "2422": "BLANK SYMBOL",
    "2423": "OPEN BOX",
    "2424": "SYMBOL FOR NEWLINE",
    "2425": "SYMBOL FOR DELETE FORM TWO",
    "2426": "SYMBOL FOR SUBSTITUTE FORM TWO",
    "2440": "OCR HOOK",
    "2441": "OCR CHAIR",
    "2442": "OCR FORK",
    "2443": "OCR INVERTED FORK",
    "2444": "OCR BELT BUCKLE",
    "2445": "OCR BOW TIE",
    "2446": "OCR BRANCH BANK IDENTIFICATION",
    "2447": "OCR AMOUNT OF CHECK",
    "2448": "OCR DASH",
    "2449": "OCR CUSTOMER ACCOUNT NUMBER",
    "244A": "OCR DOUBLE BACKSLASH",
    "2460": "CIRCLED DIGIT ONE",
    "2461": "CIRCLED DIGIT TWO",
    "2462": "CIRCLED DIGIT THREE",
    "2463": "CIRCLED DIGIT FOUR",
    "2464": "CIRCLED DIGIT FIVE",
    "2465": "CIRCLED DIGIT SIX",
    "2466": "CIRCLED DIGIT SEVEN",
    "2467": "CIRCLED DIGIT EIGHT",
    "2468": "CIRCLED DIGIT NINE",
    "2469": "CIRCLED NUMBER TEN",
    "246A": "CIRCLED NUMBER ELEVEN",
    "246B": "CIRCLED NUMBER TWELVE",
    "246C": "CIRCLED NUMBER THIRTEEN",
    "246D": "CIRCLED NUMBER FOURTEEN",
    "246E": "CIRCLED NUMBER FIFTEEN",
    "246F": "CIRCLED NUMBER SIXTEEN",
    "2470": "CIRCLED NUMBER SEVENTEEN",
    "2471": "CIRCLED NUMBER EIGHTEEN",
    "2472": "CIRCLED NUMBER NINETEEN",
    "2473": "CIRCLED NUMBER TWENTY",
    "2474": "PARENTHESIZED DIGIT ONE",
    "2475": "PARENTHESIZED DIGIT TWO",
    "2476": "PARENTHESIZED DIGIT THREE",
    "2477": "PARENTHESIZED DIGIT FOUR",
    "2478": "PARENTHESIZED DIGIT FIVE",
    "2479": "PARENTHESIZED DIGIT SIX",
    "247A": "PARENTHESIZED DIGIT SEVEN",
    "247B": "PARENTHESIZED DIGIT EIGHT",
    "247C": "PARENTHESIZED DIGIT NINE",
    "247D": "PARENTHESIZED NUMBER TEN",
    "247E": "PARENTHESIZED NUMBER ELEVEN",
    "247F": "PARENTHESIZED NUMBER TWELVE",
    "2480": "PARENTHESIZED NUMBER THIRTEEN",
    "2481": "PARENTHESIZED NUMBER FOURTEEN",
    "2482": "PARENTHESIZED NUMBER FIFTEEN",
    "2483": "PARENTHESIZED NUMBER SIXTEEN",
    "2484": "PARENTHESIZED NUMBER SEVENTEEN",
    "2485": "PARENTHESIZED NUMBER EIGHTEEN",
    "2486": "PARENTHESIZED NUMBER NINETEEN",
    "2487": "PARENTHESIZED NUMBER TWENTY",
    "2488": "DIGIT ONE FULL STOP",
    "2489": "DIGIT TWO FULL STOP",
    "248A": "DIGIT THREE FULL STOP",
    "248B": "DIGIT FOUR FULL STOP",
    "248C": "DIGIT FIVE FULL STOP",
    "248D": "DIGIT SIX FULL STOP",
    "248E": "DIGIT SEVEN FULL STOP",
    "248F": "DIGIT EIGHT FULL STOP",
    "2490": "DIGIT NINE FULL STOP",
    "2491": "NUMBER TEN FULL STOP",
    "2492": "NUMBER ELEVEN FULL STOP",
    "2493": "NUMBER TWELVE FULL STOP",
    "2494": "NUMBER THIRTEEN FULL STOP",
    "2495": "NUMBER FOURTEEN FULL STOP",
    "2496": "NUMBER FIFTEEN FULL STOP",
    "2497": "NUMBER SIXTEEN FULL STOP",
    "2498": "NUMBER SEVENTEEN FULL STOP",
    "2499": "NUMBER EIGHTEEN FULL STOP",
    "249A": "NUMBER NINETEEN FULL STOP",
    "249B": "NUMBER TWENTY FULL STOP",
    "249C": "PARENTHESIZED LATIN SMALL LETTER A",
    "249D": "PARENTHESIZED LATIN SMALL LETTER B",
    "249E": "PARENTHESIZED LATIN SMALL LETTER C",
    "249F": "PARENTHESIZED LATIN SMALL LETTER D",
    "24A0": "PARENTHESIZED LATIN SMALL LETTER E",
    "24A1": "PARENTHESIZED LATIN SMALL LETTER F",
    "24A2": "PARENTHESIZED LATIN SMALL LETTER G",
    "24A3": "PARENTHESIZED LATIN SMALL LETTER H",
    "24A4": "PARENTHESIZED LATIN SMALL LETTER I",
    "24A5": "PARENTHESIZED LATIN SMALL LETTER J",
    "24A6": "PARENTHESIZED LATIN SMALL LETTER K",
    "24A7": "PARENTHESIZED LATIN SMALL LETTER L",
    "24A8": "PARENTHESIZED LATIN SMALL LETTER M",
    "24A9": "PARENTHESIZED LATIN SMALL LETTER N",
    "24AA": "PARENTHESIZED LATIN SMALL LETTER O",
    "24AB": "PARENTHESIZED LATIN SMALL LETTER P",
    "24AC": "PARENTHESIZED LATIN SMALL LETTER Q",
    "24AD": "PARENTHESIZED LATIN SMALL LETTER R",
    "24AE": "PARENTHESIZED LATIN SMALL LETTER S",
    "24AF": "PARENTHESIZED LATIN SMALL LETTER T",
    "24B0": "PARENTHESIZED LATIN SMALL LETTER U",
    "24B1": "PARENTHESIZED LATIN SMALL LETTER V",
    "24B2": "PARENTHESIZED LATIN SMALL LETTER W",
    "24B3": "PARENTHESIZED LATIN SMALL LETTER X",
    "24B4": "PARENTHESIZED LATIN SMALL LETTER Y",
    "24B5": "PARENTHESIZED LATIN SMALL LETTER Z",
    "24B6": "CIRCLED LATIN CAPITAL LETTER A",
    "24B7": "CIRCLED LATIN CAPITAL LETTER B",
    "24B8": "CIRCLED LATIN CAPITAL LETTER C",
    "24B9": "CIRCLED LATIN CAPITAL LETTER D",
    "24BA": "CIRCLED LATIN CAPITAL LETTER E",
    "24BB": "CIRCLED LATIN CAPITAL LETTER F",
    "24BC": "CIRCLED LATIN CAPITAL LETTER G",
    "24BD": "CIRCLED LATIN CAPITAL LETTER H",
    "24BE": "CIRCLED LATIN CAPITAL LETTER I",
    "24BF": "CIRCLED LATIN CAPITAL LETTER J",
    "24C0": "CIRCLED LATIN CAPITAL LETTER K",
    "24C1": "CIRCLED LATIN CAPITAL LETTER L",
    "24C2": "CIRCLED LATIN CAPITAL LETTER M",
    "24C3": "CIRCLED LATIN CAPITAL LETTER N",
    "24C4": "CIRCLED LATIN CAPITAL LETTER O",
    "24C5": "CIRCLED LATIN CAPITAL LETTER P",
    "24C6": "CIRCLED LATIN CAPITAL LETTER Q",
    "24C7": "CIRCLED LATIN CAPITAL LETTER R",
    "24C8": "CIRCLED LATIN CAPITAL LETTER S",
    "24C9": "CIRCLED LATIN CAPITAL LETTER T",
    "24CA": "CIRCLED LATIN CAPITAL LETTER U",
    "24CB": "CIRCLED LATIN CAPITAL LETTER V",
    "24CC": "CIRCLED LATIN CAPITAL LETTER W",
    "24CD": "CIRCLED LATIN CAPITAL LETTER X",
    "24CE": "CIRCLED LATIN CAPITAL LETTER Y",
    "24CF": "CIRCLED LATIN CAPITAL LETTER Z",
    "24D0": "CIRCLED LATIN SMALL LETTER A",
    "24D1": "CIRCLED LATIN SMALL LETTER B",
    "24D2": "CIRCLED LATIN SMALL LETTER C",
    "24D3": "CIRCLED LATIN SMALL LETTER D",
    "24D4": "CIRCLED LATIN SMALL LETTER E",
    "24D5": "CIRCLED LATIN SMALL LETTER F",
    "24D6": "CIRCLED LATIN SMALL LETTER G",
    "24D7": "CIRCLED LATIN SMALL LETTER H",
    "24D8": "CIRCLED LATIN SMALL LETTER I",
    "24D9": "CIRCLED LATIN SMALL LETTER J",
    "24DA": "CIRCLED LATIN SMALL LETTER K",
    "24DB": "CIRCLED LATIN SMALL LETTER L",
    "24DC": "CIRCLED LATIN SMALL LETTER M",
    "24DD": "CIRCLED LATIN SMALL LETTER N",
    "24DE": "CIRCLED LATIN SMALL LETTER O",
    "24DF": "CIRCLED LATIN SMALL LETTER P",
    "24E0": "CIRCLED LATIN SMALL LETTER Q",
    "24E1": "CIRCLED LATIN SMALL LETTER R",
    "24E2": "CIRCLED LATIN SMALL LETTER S",
    "24E3": "CIRCLED LATIN SMALL LETTER T",
    "24E4": "CIRCLED LATIN SMALL LETTER U",
    "24E5": "CIRCLED LATIN SMALL LETTER V",
    "24E6": "CIRCLED LATIN SMALL LETTER W",
    "24E7": "CIRCLED LATIN SMALL LETTER X",
    "24E8": "CIRCLED LATIN SMALL LETTER Y",
    "24E9": "CIRCLED LATIN SMALL LETTER Z",
    "24EA": "CIRCLED DIGIT ZERO",
    "24EB": "NEGATIVE CIRCLED NUMBER ELEVEN",
    "24EC": "NEGATIVE CIRCLED NUMBER TWELVE",
    "24ED": "NEGATIVE CIRCLED NUMBER THIRTEEN",
    "24EE": "NEGATIVE CIRCLED NUMBER FOURTEEN",
    "24EF": "NEGATIVE CIRCLED NUMBER FIFTEEN",
    "24F0": "NEGATIVE CIRCLED NUMBER SIXTEEN",
    "24F1": "NEGATIVE CIRCLED NUMBER SEVENTEEN",
    "24F2": "NEGATIVE CIRCLED NUMBER EIGHTEEN",
    "24F3": "NEGATIVE CIRCLED NUMBER NINETEEN",
    "24F4": "NEGATIVE CIRCLED NUMBER TWENTY",
    "24F5": "DOUBLE CIRCLED DIGIT ONE",
    "24F6": "DOUBLE CIRCLED DIGIT TWO",
    "24F7": "DOUBLE CIRCLED DIGIT THREE",
    "24F8": "DOUBLE CIRCLED DIGIT FOUR",
    "24F9": "DOUBLE CIRCLED DIGIT FIVE",
    "24FA": "DOUBLE CIRCLED DIGIT SIX",
    "24FB": "DOUBLE CIRCLED DIGIT SEVEN",
    "24FC": "DOUBLE CIRCLED DIGIT EIGHT",
    "24FD": "DOUBLE CIRCLED DIGIT NINE",
    "24FE": "DOUBLE CIRCLED NUMBER TEN",
    "24FF": "NEGATIVE CIRCLED DIGIT ZERO",
    "2500": "BOX DRAWINGS LIGHT HORIZONTAL",
    "2501": "BOX DRAWINGS HEAVY HORIZONTAL",
    "2502": "BOX DRAWINGS LIGHT VERTICAL",
    "2503": "BOX DRAWINGS HEAVY VERTICAL",
    "2504": "BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL",
    "2505": "BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL",
    "2506": "BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL",
    "2507": "BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL",
    "2508": "BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL",
    "2509": "BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL",
    "250A": "BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL",
    "250B": "BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL",
    "250C": "BOX DRAWINGS LIGHT DOWN AND RIGHT",
    "250D": "BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY",
    "250E": "BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT",
    "250F": "BOX DRAWINGS HEAVY DOWN AND RIGHT",
    "2510": "BOX DRAWINGS LIGHT DOWN AND LEFT",
    "2511": "BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY",
    "2512": "BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT",
    "2513": "BOX DRAWINGS HEAVY DOWN AND LEFT",
    "2514": "BOX DRAWINGS LIGHT UP AND RIGHT",
    "2515": "BOX DRAWINGS UP LIGHT AND RIGHT HEAVY",
    "2516": "BOX DRAWINGS UP HEAVY AND RIGHT LIGHT",
    "2517": "BOX DRAWINGS HEAVY UP AND RIGHT",
    "2518": "BOX DRAWINGS LIGHT UP AND LEFT",
    "2519": "BOX DRAWINGS UP LIGHT AND LEFT HEAVY",
    "251A": "BOX DRAWINGS UP HEAVY AND LEFT LIGHT",
    "251B": "BOX DRAWINGS HEAVY UP AND LEFT",
    "251C": "BOX DRAWINGS LIGHT VERTICAL AND RIGHT",
    "251D": "BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY",
    "251E": "BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT",
    "251F": "BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT",
    "2520": "BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT",
    "2521": "BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY",
    "2522": "BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY",
    "2523": "BOX DRAWINGS HEAVY VERTICAL AND RIGHT",
    "2524": "BOX DRAWINGS LIGHT VERTICAL AND LEFT",
    "2525": "BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY",
    "2526": "BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT",
    "2527": "BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT",
    "2528": "BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT",
    "2529": "BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY",
    "252A": "BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY",
    "252B": "BOX DRAWINGS HEAVY VERTICAL AND LEFT",
    "252C": "BOX DRAWINGS LIGHT DOWN AND HORIZONTAL",
    "252D": "BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT",
    "252E": "BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT",
    "252F": "BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY",
    "2530": "BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT",
    "2531": "BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY",
    "2532": "BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY",
    "2533": "BOX DRAWINGS HEAVY DOWN AND HORIZONTAL",
    "2534": "BOX DRAWINGS LIGHT UP AND HORIZONTAL",
    "2535": "BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT",
    "2536": "BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT",
    "2537": "BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY",
    "2538": "BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT",
    "2539": "BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY",
    "253A": "BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY",
    "253B": "BOX DRAWINGS HEAVY UP AND HORIZONTAL",
    "253C": "BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL",
    "253D": "BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT",
    "253E": "BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT",
    "253F": "BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY",
    "2540": "BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT",
    "2541": "BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT",
    "2542": "BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT",
    "2543": "BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT",
    "2544": "BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT",
    "2545": "BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT",
    "2546": "BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT",
    "2547": "BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY",
    "2548": "BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY",
    "2549": "BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY",
    "254A": "BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY",
    "254B": "BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL",
    "254C": "BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL",
    "254D": "BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL",
    "254E": "BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL",
    "254F": "BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL",
    "2550": "BOX DRAWINGS DOUBLE HORIZONTAL",
    "2551": "BOX DRAWINGS DOUBLE VERTICAL",
    "2552": "BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE",
    "2553": "BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE",
    "2554": "BOX DRAWINGS DOUBLE DOWN AND RIGHT",
    "2555": "BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE",
    "2556": "BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE",
    "2557": "BOX DRAWINGS DOUBLE DOWN AND LEFT",
    "2558": "BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE",
    "2559": "BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE",
    "255A": "BOX DRAWINGS DOUBLE UP AND RIGHT",
    "255B": "BOX DRAWINGS UP SINGLE AND LEFT DOUBLE",
    "255C": "BOX DRAWINGS UP DOUBLE AND LEFT SINGLE",
    "255D": "BOX DRAWINGS DOUBLE UP AND LEFT",
    "255E": "BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE",
    "255F": "BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE",
    "2560": "BOX DRAWINGS DOUBLE VERTICAL AND RIGHT",
    "2561": "BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE",
    "2562": "BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE",
    "2563": "BOX DRAWINGS DOUBLE VERTICAL AND LEFT",
    "2564": "BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE",
    "2565": "BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE",
    "2566": "BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL",
    "2567": "BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE",
    "2568": "BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE",
    "2569": "BOX DRAWINGS DOUBLE UP AND HORIZONTAL",
    "256A": "BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE",
    "256B": "BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE",
    "256C": "BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL",
    "256D": "BOX DRAWINGS LIGHT ARC DOWN AND RIGHT",
    "256E": "BOX DRAWINGS LIGHT ARC DOWN AND LEFT",
    "256F": "BOX DRAWINGS LIGHT ARC UP AND LEFT",
    "2570": "BOX DRAWINGS LIGHT ARC UP AND RIGHT",
    "2571": "BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT",
    "2572": "BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT",
    "2573": "BOX DRAWINGS LIGHT DIAGONAL CROSS",
    "2574": "BOX DRAWINGS LIGHT LEFT",
    "2575": "BOX DRAWINGS LIGHT UP",
    "2576": "BOX DRAWINGS LIGHT RIGHT",
    "2577": "BOX DRAWINGS LIGHT DOWN",
    "2578": "BOX DRAWINGS HEAVY LEFT",
    "2579": "BOX DRAWINGS HEAVY UP",
    "257A": "BOX DRAWINGS HEAVY RIGHT",
    "257B": "BOX DRAWINGS HEAVY DOWN",
    "257C": "BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT",
    "257D": "BOX DRAWINGS LIGHT UP AND HEAVY DOWN",
    "257E": "BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT",
    "257F": "BOX DRAWINGS HEAVY UP AND LIGHT DOWN",
    "2580": "UPPER HALF BLOCK",
    "2581": "LOWER ONE EIGHTH BLOCK",
    "2582": "LOWER ONE QUARTER BLOCK",
    "2583": "LOWER THREE EIGHTHS BLOCK",
    "2584": "LOWER HALF BLOCK",
    "2585": "LOWER FIVE EIGHTHS BLOCK",
    "2586": "LOWER THREE QUARTERS BLOCK",
    "2587": "LOWER SEVEN EIGHTHS BLOCK",
    "2588": "FULL BLOCK",
    "2589": "LEFT SEVEN EIGHTHS BLOCK",
    "258A": "LEFT THREE QUARTERS BLOCK",
    "258B": "LEFT FIVE EIGHTHS BLOCK",
    "258C": "LEFT HALF BLOCK",
    "258D": "LEFT THREE EIGHTHS BLOCK",
    "258E": "LEFT ONE QUARTER BLOCK",
    "258F": "LEFT ONE EIGHTH BLOCK",
    "2590": "RIGHT HALF BLOCK",
    "2591": "LIGHT SHADE",
    "2592": "MEDIUM SHADE",
    "2593": "DARK SHADE",
    "2594": "UPPER ONE EIGHTH BLOCK",
    "2595": "RIGHT ONE EIGHTH BLOCK",
    "2596": "QUADRANT LOWER LEFT",
    "2597": "QUADRANT LOWER RIGHT",
    "2598": "QUADRANT UPPER LEFT",
    "2599": "QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT",
    "259A": "QUADRANT UPPER LEFT AND LOWER RIGHT",
    "259B": "QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT",
    "259C": "QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT",
    "259D": "QUADRANT UPPER RIGHT",
    "259E": "QUADRANT UPPER RIGHT AND LOWER LEFT",
    "259F": "QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT",
    "25A0": "BLACK SQUARE",
    "25A1": "WHITE SQUARE",
    "25A2": "WHITE SQUARE WITH ROUNDED CORNERS",
    "25A3": "WHITE SQUARE CONTAINING BLACK SMALL SQUARE",
    "25A4": "SQUARE WITH HORIZONTAL FILL",
    "25A5": "SQUARE WITH VERTICAL FILL",
    "25A6": "SQUARE WITH ORTHOGONAL CROSSHATCH FILL",
    "25A7": "SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL",
    "25A8": "SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL",
    "25A9": "SQUARE WITH DIAGONAL CROSSHATCH FILL",
    "25AA": "BLACK SMALL SQUARE",
    "25AB": "WHITE SMALL SQUARE",
    "25AC": "BLACK RECTANGLE",
    "25AD": "WHITE RECTANGLE",
    "25AE": "BLACK VERTICAL RECTANGLE",
    "25AF": "WHITE VERTICAL RECTANGLE",
    "25B0": "BLACK PARALLELOGRAM",
    "25B1": "WHITE PARALLELOGRAM",
    "25B2": "BLACK UP-POINTING TRIANGLE",
    "25B3": "WHITE UP-POINTING TRIANGLE",
    "25B4": "BLACK UP-POINTING SMALL TRIANGLE",
    "25B5": "WHITE UP-POINTING SMALL TRIANGLE",
    "25B6": "BLACK RIGHT-POINTING TRIANGLE",
    "25B7": "WHITE RIGHT-POINTING TRIANGLE",
    "25B8": "BLACK RIGHT-POINTING SMALL TRIANGLE",
    "25B9": "WHITE RIGHT-POINTING SMALL TRIANGLE",
    "25BA": "BLACK RIGHT-POINTING POINTER",
    "25BB": "WHITE RIGHT-POINTING POINTER",
    "25BC": "BLACK DOWN-POINTING TRIANGLE",
    "25BD": "WHITE DOWN-POINTING TRIANGLE",
    "25BE": "BLACK DOWN-POINTING SMALL TRIANGLE",
    "25BF": "WHITE DOWN-POINTING SMALL TRIANGLE",
    "25C0": "BLACK LEFT-POINTING TRIANGLE",
    "25C1": "WHITE LEFT-POINTING TRIANGLE",
    "25C2": "BLACK LEFT-POINTING SMALL TRIANGLE",
    "25C3": "WHITE LEFT-POINTING SMALL TRIANGLE",
    "25C4": "BLACK LEFT-POINTING POINTER",
    "25C5": "WHITE LEFT-POINTING POINTER",
    "25C6": "BLACK DIAMOND",
    "25C7": "WHITE DIAMOND",
    "25C8": "WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND",
    "25C9": "FISHEYE",
    "25CA": "LOZENGE",
    "25CB": "WHITE CIRCLE",
    "25CC": "DOTTED CIRCLE",
    "25CD": "CIRCLE WITH VERTICAL FILL",
    "25CE": "BULLSEYE",
    "25CF": "BLACK CIRCLE",
    "25D0": "CIRCLE WITH LEFT HALF BLACK",
    "25D1": "CIRCLE WITH RIGHT HALF BLACK",
    "25D2": "CIRCLE WITH LOWER HALF BLACK",
    "25D3": "CIRCLE WITH UPPER HALF BLACK",
    "25D4": "CIRCLE WITH UPPER RIGHT QUADRANT BLACK",
    "25D5": "CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK",
    "25D6": "LEFT HALF BLACK CIRCLE",
    "25D7": "RIGHT HALF BLACK CIRCLE",
    "25D8": "INVERSE BULLET",
    "25D9": "INVERSE WHITE CIRCLE",
    "25DA": "UPPER HALF INVERSE WHITE CIRCLE",
    "25DB": "LOWER HALF INVERSE WHITE CIRCLE",
    "25DC": "UPPER LEFT QUADRANT CIRCULAR ARC",
    "25DD": "UPPER RIGHT QUADRANT CIRCULAR ARC",
    "25DE": "LOWER RIGHT QUADRANT CIRCULAR ARC",
    "25DF": "LOWER LEFT QUADRANT CIRCULAR ARC",
    "25E0": "UPPER HALF CIRCLE",
    "25E1": "LOWER HALF CIRCLE",
    "25E2": "BLACK LOWER RIGHT TRIANGLE",
    "25E3": "BLACK LOWER LEFT TRIANGLE",
    "25E4": "BLACK UPPER LEFT TRIANGLE",
    "25E5": "BLACK UPPER RIGHT TRIANGLE",
    "25E6": "WHITE BULLET",
    "25E7": "SQUARE WITH LEFT HALF BLACK",
    "25E8": "SQUARE WITH RIGHT HALF BLACK",
    "25E9": "SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK",
    "25EA": "SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK",
    "25EB": "WHITE SQUARE WITH VERTICAL BISECTING LINE",
    "25EC": "WHITE UP-POINTING TRIANGLE WITH DOT",
    "25ED": "UP-POINTING TRIANGLE WITH LEFT HALF BLACK",
    "25EE": "UP-POINTING TRIANGLE WITH RIGHT HALF BLACK",
    "25EF": "LARGE CIRCLE",
    "25F0": "WHITE SQUARE WITH UPPER LEFT QUADRANT",
    "25F1": "WHITE SQUARE WITH LOWER LEFT QUADRANT",
    "25F2": "WHITE SQUARE WITH LOWER RIGHT QUADRANT",
    "25F3": "WHITE SQUARE WITH UPPER RIGHT QUADRANT",
    "25F4": "WHITE CIRCLE WITH UPPER LEFT QUADRANT",
    "25F5": "WHITE CIRCLE WITH LOWER LEFT QUADRANT",
    "25F6": "WHITE CIRCLE WITH LOWER RIGHT QUADRANT",
    "25F7": "WHITE CIRCLE WITH UPPER RIGHT QUADRANT",
    "25F8": "UPPER LEFT TRIANGLE",
    "25F9": "UPPER RIGHT TRIANGLE",
    "25FA": "LOWER LEFT TRIANGLE",
    "25FB": "WHITE MEDIUM SQUARE",
    "25FC": "BLACK MEDIUM SQUARE",
    "25FD": "WHITE MEDIUM SMALL SQUARE",
    "25FE": "BLACK MEDIUM SMALL SQUARE",
    "25FF": "LOWER RIGHT TRIANGLE",
    "2600": "BLACK SUN WITH RAYS",
    "2601": "CLOUD",
    "2602": "UMBRELLA",
    "2603": "SNOWMAN",
    "2604": "COMET",
    "2605": "BLACK STAR",
    "2606": "WHITE STAR",
    "2607": "LIGHTNING",
    "2608": "THUNDERSTORM",
    "2609": "SUN",
    "260A": "ASCENDING NODE",
    "260B": "DESCENDING NODE",
    "260C": "CONJUNCTION",
    "260D": "OPPOSITION",
    "260E": "BLACK TELEPHONE",
    "260F": "WHITE TELEPHONE",
    "2610": "BALLOT BOX",
    "2611": "BALLOT BOX WITH CHECK",
    "2612": "BALLOT BOX WITH X",
    "2613": "SALTIRE",
    "2614": "UMBRELLA WITH RAIN DROPS",
    "2615": "HOT BEVERAGE",
    "2616": "WHITE SHOGI PIECE",
    "2617": "BLACK SHOGI PIECE",
    "2618": "SHAMROCK",
    "2619": "REVERSED ROTATED FLORAL HEART BULLET",
    "261A": "BLACK LEFT POINTING INDEX",
    "261B": "BLACK RIGHT POINTING INDEX",
    "261C": "WHITE LEFT POINTING INDEX",
    "261D": "WHITE UP POINTING INDEX",
    "261E": "WHITE RIGHT POINTING INDEX",
    "261F": "WHITE DOWN POINTING INDEX",
    "2620": "SKULL AND CROSSBONES",
    "2621": "CAUTION SIGN",
    "2622": "RADIOACTIVE SIGN",
    "2623": "BIOHAZARD SIGN",
    "2624": "CADUCEUS",
    "2625": "ANKH",
    "2626": "ORTHODOX CROSS",
    "2627": "CHI RHO",
    "2628": "CROSS OF LORRAINE",
    "2629": "CROSS OF JERUSALEM",
    "262A": "STAR AND CRESCENT",
    "262B": "FARSI SYMBOL",
    "262C": "ADI SHAKTI",
    "262D": "HAMMER AND SICKLE",
    "262E": "PEACE SYMBOL",
    "262F": "YIN YANG",
    "2630": "TRIGRAM FOR HEAVEN",
    "2631": "TRIGRAM FOR LAKE",
    "2632": "TRIGRAM FOR FIRE",
    "2633": "TRIGRAM FOR THUNDER",
    "2634": "TRIGRAM FOR WIND",
    "2635": "TRIGRAM FOR WATER",
    "2636": "TRIGRAM FOR MOUNTAIN",
    "2637": "TRIGRAM FOR EARTH",
    "2638": "WHEEL OF DHARMA",
    "2639": "WHITE FROWNING FACE",
    "263A": "WHITE SMILING FACE",
    "263B": "BLACK SMILING FACE",
    "263C": "WHITE SUN WITH RAYS",
    "263D": "FIRST QUARTER MOON",
    "263E": "LAST QUARTER MOON",
    "263F": "MERCURY",
    "2640": "FEMALE SIGN",
    "2641": "EARTH",
    "2642": "MALE SIGN",
    "2643": "JUPITER",
    "2644": "SATURN",
    "2645": "URANUS",
    "2646": "NEPTUNE",
    "2647": "PLUTO",
    "2648": "ARIES",
    "2649": "TAURUS",
    "264A": "GEMINI",
    "264B": "CANCER",
    "264C": "LEO",
    "264D": "VIRGO",
    "264E": "LIBRA",
    "264F": "SCORPIUS",
    "2650": "SAGITTARIUS",
    "2651": "CAPRICORN",
    "2652": "AQUARIUS",
    "2653": "PISCES",
    "2654": "WHITE CHESS KING",
    "2655": "WHITE CHESS QUEEN",
    "2656": "WHITE CHESS ROOK",
    "2657": "WHITE CHESS BISHOP",
    "2658": "WHITE CHESS KNIGHT",
    "2659": "WHITE CHESS PAWN",
    "265A": "BLACK CHESS KING",
    "265B": "BLACK CHESS QUEEN",
    "265C": "BLACK CHESS ROOK",
    "265D": "BLACK CHESS BISHOP",
    "265E": "BLACK CHESS KNIGHT",
    "265F": "BLACK CHESS PAWN",
    "2660": "BLACK SPADE SUIT",
    "2661": "WHITE HEART SUIT",
    "2662": "WHITE DIAMOND SUIT",
    "2663": "BLACK CLUB SUIT",
    "2664": "WHITE SPADE SUIT",
    "2665": "BLACK HEART SUIT",
    "2666": "BLACK DIAMOND SUIT",
    "2667": "WHITE CLUB SUIT",
    "2668": "HOT SPRINGS",
    "2669": "QUARTER NOTE",
    "266A": "EIGHTH NOTE",
    "266B": "BEAMED EIGHTH NOTES",
    "266C": "BEAMED SIXTEENTH NOTES",
    "266D": "MUSIC FLAT SIGN",
    "266E": "MUSIC NATURAL SIGN",
    "266F": "MUSIC SHARP SIGN",
    "2670": "WEST SYRIAC CROSS",
    "2671": "EAST SYRIAC CROSS",
    "2672": "UNIVERSAL RECYCLING SYMBOL",
    "2673": "RECYCLING SYMBOL FOR TYPE-1 PLASTICS",
    "2674": "RECYCLING SYMBOL FOR TYPE-2 PLASTICS",
    "2675": "RECYCLING SYMBOL FOR TYPE-3 PLASTICS",
    "2676": "RECYCLING SYMBOL FOR TYPE-4 PLASTICS",
    "2677": "RECYCLING SYMBOL FOR TYPE-5 PLASTICS",
    "2678": "RECYCLING SYMBOL FOR TYPE-6 PLASTICS",
    "2679": "RECYCLING SYMBOL FOR TYPE-7 PLASTICS",
    "267A": "RECYCLING SYMBOL FOR GENERIC MATERIALS",
    "267B": "BLACK UNIVERSAL RECYCLING SYMBOL",
    "267C": "RECYCLED PAPER SYMBOL",
    "267D": "PARTIALLY-RECYCLED PAPER SYMBOL",
    "267E": "PERMANENT PAPER SIGN",
    "267F": "WHEELCHAIR SYMBOL",
    "2680": "DIE FACE-1",
    "2681": "DIE FACE-2",
    "2682": "DIE FACE-3",
    "2683": "DIE FACE-4",
    "2684": "DIE FACE-5",
    "2685": "DIE FACE-6",
    "2686": "WHITE CIRCLE WITH DOT RIGHT",
    "2687": "WHITE CIRCLE WITH TWO DOTS",
    "2688": "BLACK CIRCLE WITH WHITE DOT RIGHT",
    "2689": "BLACK CIRCLE WITH TWO WHITE DOTS",
    "268A": "MONOGRAM FOR YANG",
    "268B": "MONOGRAM FOR YIN",
    "268C": "DIGRAM FOR GREATER YANG",
    "268D": "DIGRAM FOR LESSER YIN",
    "268E": "DIGRAM FOR LESSER YANG",
    "268F": "DIGRAM FOR GREATER YIN",
    "2690": "WHITE FLAG",
    "2691": "BLACK FLAG",
    "2692": "HAMMER AND PICK",
    "2693": "ANCHOR",
    "2694": "CROSSED SWORDS",
    "2695": "STAFF OF AESCULAPIUS",
    "2696": "SCALES",
    "2697": "ALEMBIC",
    "2698": "FLOWER",
    "2699": "GEAR",
    "269A": "STAFF OF HERMES",
    "269B": "ATOM SYMBOL",
    "269C": "FLEUR-DE-LIS",
    "269D": "OUTLINED WHITE STAR",
    "269E": "THREE LINES CONVERGING RIGHT",
    "269F": "THREE LINES CONVERGING LEFT",
    "26A0": "WARNING SIGN",
    "26A1": "HIGH VOLTAGE SIGN",
    "26A2": "DOUBLED FEMALE SIGN",
    "26A3": "DOUBLED MALE SIGN",
    "26A4": "INTERLOCKED FEMALE AND MALE SIGN",
    "26A5": "MALE AND FEMALE SIGN",
    "26A6": "MALE WITH STROKE SIGN",
    "26A7": "MALE WITH STROKE AND MALE AND FEMALE SIGN",
    "26A8": "VERTICAL MALE WITH STROKE SIGN",
    "26A9": "HORIZONTAL MALE WITH STROKE SIGN",
    "26AA": "MEDIUM WHITE CIRCLE",
    "26AB": "MEDIUM BLACK CIRCLE",
    "26AC": "MEDIUM SMALL WHITE CIRCLE",
    "26AD": "MARRIAGE SYMBOL",
    "26AE": "DIVORCE SYMBOL",
    "26AF": "UNMARRIED PARTNERSHIP SYMBOL",
    "26B0": "COFFIN",
    "26B1": "FUNERAL URN",
    "26B2": "NEUTER",
    "26B3": "CERES",
    "26B4": "PALLAS",
    "26B5": "JUNO",
    "26B6": "VESTA",
    "26B7": "CHIRON",
    "26B8": "BLACK MOON LILITH",
    "26B9": "SEXTILE",
    "26BA": "SEMISEXTILE",
    "26BB": "QUINCUNX",
    "26BC": "SESQUIQUADRATE",
    "26BD": "SOCCER BALL",
    "26BE": "BASEBALL",
    "26BF": "SQUARED KEY",
    "26C0": "WHITE DRAUGHTS MAN",
    "26C1": "WHITE DRAUGHTS KING",
    "26C2": "BLACK DRAUGHTS MAN",
    "26C3": "BLACK DRAUGHTS KING",
    "26C4": "SNOWMAN WITHOUT SNOW",
    "26C5": "SUN BEHIND CLOUD",
    "26C6": "RAIN",
    "26C7": "BLACK SNOWMAN",
    "26C8": "THUNDER CLOUD AND RAIN",
    "26C9": "TURNED WHITE SHOGI PIECE",
    "26CA": "TURNED BLACK SHOGI PIECE",
    "26CB": "WHITE DIAMOND IN SQUARE",
    "26CC": "CROSSING LANES",
    "26CD": "DISABLED CAR",
    "26CE": "OPHIUCHUS",
    "26CF": "PICK",
    "26D0": "CAR SLIDING",
    "26D1": "HELMET WITH WHITE CROSS",
    "26D2": "CIRCLED CROSSING LANES",
    "26D3": "CHAINS",
    "26D4": "NO ENTRY",
    "26D5": "ALTERNATE ONE-WAY LEFT WAY TRAFFIC",
    "26D6": "BLACK TWO-WAY LEFT WAY TRAFFIC",
    "26D7": "WHITE TWO-WAY LEFT WAY TRAFFIC",
    "26D8": "BLACK LEFT LANE MERGE",
    "26D9": "WHITE LEFT LANE MERGE",
    "26DA": "DRIVE SLOW SIGN",
    "26DB": "HEAVY WHITE DOWN-POINTING TRIANGLE",
    "26DC": "LEFT CLOSED ENTRY",
    "26DD": "SQUARED SALTIRE",
    "26DE": "FALLING DIAGONAL IN WHITE CIRCLE IN BLACK SQUARE",
    "26DF": "BLACK TRUCK",
    "26E0": "RESTRICTED LEFT ENTRY-1",
    "26E1": "RESTRICTED LEFT ENTRY-2",
    "26E2": "ASTRONOMICAL SYMBOL FOR URANUS",
    "26E3": "HEAVY CIRCLE WITH STROKE AND TWO DOTS ABOVE",
    "26E4": "PENTAGRAM",
    "26E5": "RIGHT-HANDED INTERLACED PENTAGRAM",
    "26E6": "LEFT-HANDED INTERLACED PENTAGRAM",
    "26E7": "INVERTED PENTAGRAM",
    "26E8": "BLACK CROSS ON SHIELD",
    "26E9": "SHINTO SHRINE",
    "26EA": "CHURCH",
    "26EB": "CASTLE",
    "26EC": "HISTORIC SITE",
    "26ED": "GEAR WITHOUT HUB",
    "26EE": "GEAR WITH HANDLES",
    "26EF": "MAP SYMBOL FOR LIGHTHOUSE",
    "26F0": "MOUNTAIN",
    "26F1": "UMBRELLA ON GROUND",
    "26F2": "FOUNTAIN",
    "26F3": "FLAG IN HOLE",
    "26F4": "FERRY",
    "26F5": "SAILBOAT",
    "26F6": "SQUARE FOUR CORNERS",
    "26F7": "SKIER",
    "26F8": "ICE SKATE",
    "26F9": "PERSON WITH BALL",
    "26FA": "TENT",
    "26FB": "JAPANESE BANK SYMBOL",
    "26FC": "HEADSTONE GRAVEYARD SYMBOL",
    "26FD": "FUEL PUMP",
    "26FE": "CUP ON BLACK SQUARE",
    "26FF": "WHITE FLAG WITH HORIZONTAL MIDDLE BLACK STRIPE",
    "2700": "BLACK SAFETY SCISSORS",
    "2701": "UPPER BLADE SCISSORS",
    "2702": "BLACK SCISSORS",
    "2703": "LOWER BLADE SCISSORS",
    "2704": "WHITE SCISSORS",
    "2705": "WHITE HEAVY CHECK MARK",
    "2706": "TELEPHONE LOCATION SIGN",
    "2707": "TAPE DRIVE",
    "2708": "AIRPLANE",
    "2709": "ENVELOPE",
    "270A": "RAISED FIST",
    "270B": "RAISED HAND",
    "270C": "VICTORY HAND",
    "270D": "WRITING HAND",
    "270E": "LOWER RIGHT PENCIL",
    "270F": "PENCIL",
    "2710": "UPPER RIGHT PENCIL",
    "2711": "WHITE NIB",
    "2712": "BLACK NIB",
    "2713": "CHECK MARK",
    "2714": "HEAVY CHECK MARK",
    "2715": "MULTIPLICATION X",
    "2716": "HEAVY MULTIPLICATION X",
    "2717": "BALLOT X",
    "2718": "HEAVY BALLOT X",
    "2719": "OUTLINED GREEK CROSS",
    "271A": "HEAVY GREEK CROSS",
    "271B": "OPEN CENTRE CROSS",
    "271C": "HEAVY OPEN CENTRE CROSS",
    "271D": "LATIN CROSS",
    "271E": "SHADOWED WHITE LATIN CROSS",
    "271F": "OUTLINED LATIN CROSS",
    "2720": "MALTESE CROSS",
    "2721": "STAR OF DAVID",
    "2722": "FOUR TEARDROP-SPOKED ASTERISK",
    "2723": "FOUR BALLOON-SPOKED ASTERISK",
    "2724": "HEAVY FOUR BALLOON-SPOKED ASTERISK",
    "2725": "FOUR CLUB-SPOKED ASTERISK",
    "2726": "BLACK FOUR POINTED STAR",
    "2727": "WHITE FOUR POINTED STAR",
    "2728": "SPARKLES",
    "2729": "STRESS OUTLINED WHITE STAR",
    "272A": "CIRCLED WHITE STAR",
    "272B": "OPEN CENTRE BLACK STAR",
    "272C": "BLACK CENTRE WHITE STAR",
    "272D": "OUTLINED BLACK STAR",
    "272E": "HEAVY OUTLINED BLACK STAR",
    "272F": "PINWHEEL STAR",
    "2730": "SHADOWED WHITE STAR",
    "2731": "HEAVY ASTERISK",
    "2732": "OPEN CENTRE ASTERISK",
    "2733": "EIGHT SPOKED ASTERISK",
    "2734": "EIGHT POINTED BLACK STAR",
    "2735": "EIGHT POINTED PINWHEEL STAR",
    "2736": "SIX POINTED BLACK STAR",
    "2737": "EIGHT POINTED RECTILINEAR BLACK STAR",
    "2738": "HEAVY EIGHT POINTED RECTILINEAR BLACK STAR",
    "2739": "TWELVE POINTED BLACK STAR",
    "273A": "SIXTEEN POINTED ASTERISK",
    "273B": "TEARDROP-SPOKED ASTERISK",
    "273C": "OPEN CENTRE TEARDROP-SPOKED ASTERISK",
    "273D": "HEAVY TEARDROP-SPOKED ASTERISK",
    "273E": "SIX PETALLED BLACK AND WHITE FLORETTE",
    "273F": "BLACK FLORETTE",
    "2740": "WHITE FLORETTE",
    "2741": "EIGHT PETALLED OUTLINED BLACK FLORETTE",
    "2742": "CIRCLED OPEN CENTRE EIGHT POINTED STAR",
    "2743": "HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK",
    "2744": "SNOWFLAKE",
    "2745": "TIGHT TRIFOLIATE SNOWFLAKE",
    "2746": "HEAVY CHEVRON SNOWFLAKE",
    "2747": "SPARKLE",
    "2748": "HEAVY SPARKLE",
    "2749": "BALLOON-SPOKED ASTERISK",
    "274A": "EIGHT TEARDROP-SPOKED PROPELLER ASTERISK",
    "274B": "HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK",
    "274C": "CROSS MARK",
    "274D": "SHADOWED WHITE CIRCLE",
    "274E": "NEGATIVE SQUARED CROSS MARK",
    "274F": "LOWER RIGHT DROP-SHADOWED WHITE SQUARE",
    "2750": "UPPER RIGHT DROP-SHADOWED WHITE SQUARE",
    "2751": "LOWER RIGHT SHADOWED WHITE SQUARE",
    "2752": "UPPER RIGHT SHADOWED WHITE SQUARE",
    "2753": "BLACK QUESTION MARK ORNAMENT",
    "2754": "WHITE QUESTION MARK ORNAMENT",
    "2755": "WHITE EXCLAMATION MARK ORNAMENT",
    "2756": "BLACK DIAMOND MINUS WHITE X",
    "2757": "HEAVY EXCLAMATION MARK SYMBOL",
    "2758": "LIGHT VERTICAL BAR",
    "2759": "MEDIUM VERTICAL BAR",
    "275A": "HEAVY VERTICAL BAR",
    "275B": "HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT",
    "275C": "HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT",
    "275D": "HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT",
    "275E": "HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT",
    "275F": "HEAVY LOW SINGLE COMMA QUOTATION MARK ORNAMENT",
    "2760": "HEAVY LOW DOUBLE COMMA QUOTATION MARK ORNAMENT",
    "2761": "CURVED STEM PARAGRAPH SIGN ORNAMENT",
    "2762": "HEAVY EXCLAMATION MARK ORNAMENT",
    "2763": "HEAVY HEART EXCLAMATION MARK ORNAMENT",
    "2764": "HEAVY BLACK HEART",
    "2765": "ROTATED HEAVY BLACK HEART BULLET",
    "2766": "FLORAL HEART",
    "2767": "ROTATED FLORAL HEART BULLET",
    "2768": "MEDIUM LEFT PARENTHESIS ORNAMENT",
    "2769": "MEDIUM RIGHT PARENTHESIS ORNAMENT",
    "276A": "MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT",
    "276B": "MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT",
    "276C": "MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT",
    "276D": "MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT",
    "276E": "HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT",
    "276F": "HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT",
    "2770": "HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT",
    "2771": "HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT",
    "2772": "LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT",
    "2773": "LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT",
    "2774": "MEDIUM LEFT CURLY BRACKET ORNAMENT",
    "2775": "MEDIUM RIGHT CURLY BRACKET ORNAMENT",
    "2776": "DINGBAT NEGATIVE CIRCLED DIGIT ONE",
    "2777": "DINGBAT NEGATIVE CIRCLED DIGIT TWO",
    "2778": "DINGBAT NEGATIVE CIRCLED DIGIT THREE",
    "2779": "DINGBAT NEGATIVE CIRCLED DIGIT FOUR",
    "277A": "DINGBAT NEGATIVE CIRCLED DIGIT FIVE",
    "277B": "DINGBAT NEGATIVE CIRCLED DIGIT SIX",
    "277C": "DINGBAT NEGATIVE CIRCLED DIGIT SEVEN",
    "277D": "DINGBAT NEGATIVE CIRCLED DIGIT EIGHT",
    "277E": "DINGBAT NEGATIVE CIRCLED DIGIT NINE",
    "277F": "DINGBAT NEGATIVE CIRCLED NUMBER TEN",
    "2780": "DINGBAT CIRCLED SANS-SERIF DIGIT ONE",
    "2781": "DINGBAT CIRCLED SANS-SERIF DIGIT TWO",
    "2782": "DINGBAT CIRCLED SANS-SERIF DIGIT THREE",
    "2783": "DINGBAT CIRCLED SANS-SERIF DIGIT FOUR",
    "2784": "DINGBAT CIRCLED SANS-SERIF DIGIT FIVE",
    "2785": "DINGBAT CIRCLED SANS-SERIF DIGIT SIX",
    "2786": "DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN",
    "2787": "DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT",
    "2788": "DINGBAT CIRCLED SANS-SERIF DIGIT NINE",
    "2789": "DINGBAT CIRCLED SANS-SERIF NUMBER TEN",
    "278A": "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE",
    "278B": "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO",
    "278C": "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE",
    "278D": "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR",
    "278E": "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE",
    "278F": "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX",
    "2790": "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN",
    "2791": "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT",
    "2792": "DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE",
    "2793": "DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN",
    "2794": "HEAVY WIDE-HEADED RIGHTWARDS ARROW",
    "2795": "HEAVY PLUS SIGN",
    "2796": "HEAVY MINUS SIGN",
    "2797": "HEAVY DIVISION SIGN",
    "2798": "HEAVY SOUTH EAST ARROW",
    "2799": "HEAVY RIGHTWARDS ARROW",
    "279A": "HEAVY NORTH EAST ARROW",
    "279B": "DRAFTING POINT RIGHTWARDS ARROW",
    "279C": "HEAVY ROUND-TIPPED RIGHTWARDS ARROW",
    "279D": "TRIANGLE-HEADED RIGHTWARDS ARROW",
    "279E": "HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW",
    "279F": "DASHED TRIANGLE-HEADED RIGHTWARDS ARROW",
    "27A0": "HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW",
    "27A1": "BLACK RIGHTWARDS ARROW",
    "27A2": "THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD",
    "27A3": "THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD",
    "27A4": "BLACK RIGHTWARDS ARROWHEAD",
    "27A5": "HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW",
    "27A6": "HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW",
    "27A7": "SQUAT BLACK RIGHTWARDS ARROW",
    "27A8": "HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW",
    "27A9": "RIGHT-SHADED WHITE RIGHTWARDS ARROW",
    "27AA": "LEFT-SHADED WHITE RIGHTWARDS ARROW",
    "27AB": "BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW",
    "27AC": "FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW",
    "27AD": "HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
    "27AE": "HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
    "27AF": "NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
    "27B0": "CURLY LOOP",
    "27B1": "NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW",
    "27B2": "CIRCLED HEAVY WHITE RIGHTWARDS ARROW",
    "27B3": "WHITE-FEATHERED RIGHTWARDS ARROW",
    "27B4": "BLACK-FEATHERED SOUTH EAST ARROW",
    "27B5": "BLACK-FEATHERED RIGHTWARDS ARROW",
    "27B6": "BLACK-FEATHERED NORTH EAST ARROW",
    "27B7": "HEAVY BLACK-FEATHERED SOUTH EAST ARROW",
    "27B8": "HEAVY BLACK-FEATHERED RIGHTWARDS ARROW",
    "27B9": "HEAVY BLACK-FEATHERED NORTH EAST ARROW",
    "27BA": "TEARDROP-BARBED RIGHTWARDS ARROW",
    "27BB": "HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW",
    "27BC": "WEDGE-TAILED RIGHTWARDS ARROW",
    "27BD": "HEAVY WEDGE-TAILED RIGHTWARDS ARROW",
    "27BE": "OPEN-OUTLINED RIGHTWARDS ARROW",
    "27BF": "DOUBLE CURLY LOOP",
    "27C0": "THREE DIMENSIONAL ANGLE",
    "27C1": "WHITE TRIANGLE CONTAINING SMALL WHITE TRIANGLE",
    "27C2": "PERPENDICULAR",
    "27C3": "OPEN SUBSET",
    "27C4": "OPEN SUPERSET",
    "27C5": "LEFT S-SHAPED BAG DELIMITER",
    "27C6": "RIGHT S-SHAPED BAG DELIMITER",
    "27C7": "OR WITH DOT INSIDE",
    "27C8": "REVERSE SOLIDUS PRECEDING SUBSET",
    "27C9": "SUPERSET PRECEDING SOLIDUS",
    "27CA": "VERTICAL BAR WITH HORIZONTAL STROKE",
    "27CB": "MATHEMATICAL RISING DIAGONAL",
    "27CC": "LONG DIVISION",
    "27CD": "MATHEMATICAL FALLING DIAGONAL",
    "27CE": "SQUARED LOGICAL AND",
    "27CF": "SQUARED LOGICAL OR",
    "27D0": "WHITE DIAMOND WITH CENTRED DOT",
    "27D1": "AND WITH DOT",
    "27D2": "ELEMENT OF OPENING UPWARDS",
    "27D3": "LOWER RIGHT CORNER WITH DOT",
    "27D4": "UPPER LEFT CORNER WITH DOT",
    "27D5": "LEFT OUTER JOIN",
    "27D6": "RIGHT OUTER JOIN",
    "27D7": "FULL OUTER JOIN",
    "27D8": "LARGE UP TACK",
    "27D9": "LARGE DOWN TACK",
    "27DA": "LEFT AND RIGHT DOUBLE TURNSTILE",
    "27DB": "LEFT AND RIGHT TACK",
    "27DC": "LEFT MULTIMAP",
    "27DD": "LONG RIGHT TACK",
    "27DE": "LONG LEFT TACK",
    "27DF": "UP TACK WITH CIRCLE ABOVE",
    "27E0": "LOZENGE DIVIDED BY HORIZONTAL RULE",
    "27E1": "WHITE CONCAVE-SIDED DIAMOND",
    "27E2": "WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK",
    "27E3": "WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK",
    "27E4": "WHITE SQUARE WITH LEFTWARDS TICK",
    "27E5": "WHITE SQUARE WITH RIGHTWARDS TICK",
    "27E6": "MATHEMATICAL LEFT WHITE SQUARE BRACKET",
    "27E7": "MATHEMATICAL RIGHT WHITE SQUARE BRACKET",
    "27E8": "MATHEMATICAL LEFT ANGLE BRACKET",
    "27E9": "MATHEMATICAL RIGHT ANGLE BRACKET",
    "27EA": "MATHEMATICAL LEFT DOUBLE ANGLE BRACKET",
    "27EB": "MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET",
    "27EC": "MATHEMATICAL LEFT WHITE TORTOISE SHELL BRACKET",
    "27ED": "MATHEMATICAL RIGHT WHITE TORTOISE SHELL BRACKET",
    "27EE": "MATHEMATICAL LEFT FLATTENED PARENTHESIS",
    "27EF": "MATHEMATICAL RIGHT FLATTENED PARENTHESIS",
    "27F0": "UPWARDS QUADRUPLE ARROW",
    "27F1": "DOWNWARDS QUADRUPLE ARROW",
    "27F2": "ANTICLOCKWISE GAPPED CIRCLE ARROW",
    "27F3": "CLOCKWISE GAPPED CIRCLE ARROW",
    "27F4": "RIGHT ARROW WITH CIRCLED PLUS",
    "27F5": "LONG LEFTWARDS ARROW",
    "27F6": "LONG RIGHTWARDS ARROW",
    "27F7": "LONG LEFT RIGHT ARROW",
    "27F8": "LONG LEFTWARDS DOUBLE ARROW",
    "27F9": "LONG RIGHTWARDS DOUBLE ARROW",
    "27FA": "LONG LEFT RIGHT DOUBLE ARROW",
    "27FB": "LONG LEFTWARDS ARROW FROM BAR",
    "27FC": "LONG RIGHTWARDS ARROW FROM BAR",
    "27FD": "LONG LEFTWARDS DOUBLE ARROW FROM BAR",
    "27FE": "LONG RIGHTWARDS DOUBLE ARROW FROM BAR",
    "27FF": "LONG RIGHTWARDS SQUIGGLE ARROW",
    "2800": "BRAILLE PATTERN BLANK",
    "2801": "BRAILLE PATTERN DOTS-1",
    "2802": "BRAILLE PATTERN DOTS-2",
    "2803": "BRAILLE PATTERN DOTS-12",
    "2804": "BRAILLE PATTERN DOTS-3",
    "2805": "BRAILLE PATTERN DOTS-13",
    "2806": "BRAILLE PATTERN DOTS-23",
    "2807": "BRAILLE PATTERN DOTS-123",
    "2808": "BRAILLE PATTERN DOTS-4",
    "2809": "BRAILLE PATTERN DOTS-14",
    "280A": "BRAILLE PATTERN DOTS-24",
    "280B": "BRAILLE PATTERN DOTS-124",
    "280C": "BRAILLE PATTERN DOTS-34",
    "280D": "BRAILLE PATTERN DOTS-134",
    "280E": "BRAILLE PATTERN DOTS-234",
    "280F": "BRAILLE PATTERN DOTS-1234",
    "2810": "BRAILLE PATTERN DOTS-5",
    "2811": "BRAILLE PATTERN DOTS-15",
    "2812": "BRAILLE PATTERN DOTS-25",
    "2813": "BRAILLE PATTERN DOTS-125",
    "2814": "BRAILLE PATTERN DOTS-35",
    "2815": "BRAILLE PATTERN DOTS-135",
    "2816": "BRAILLE PATTERN DOTS-235",
    "2817": "BRAILLE PATTERN DOTS-1235",
    "2818": "BRAILLE PATTERN DOTS-45",
    "2819": "BRAILLE PATTERN DOTS-145",
    "281A": "BRAILLE PATTERN DOTS-245",
    "281B": "BRAILLE PATTERN DOTS-1245",
    "281C": "BRAILLE PATTERN DOTS-345",
    "281D": "BRAILLE PATTERN DOTS-1345",
    "281E": "BRAILLE PATTERN DOTS-2345",
    "281F": "BRAILLE PATTERN DOTS-12345",
    "2820": "BRAILLE PATTERN DOTS-6",
    "2821": "BRAILLE PATTERN DOTS-16",
    "2822": "BRAILLE PATTERN DOTS-26",
    "2823": "BRAILLE PATTERN DOTS-126",
    "2824": "BRAILLE PATTERN DOTS-36",
    "2825": "BRAILLE PATTERN DOTS-136",
    "2826": "BRAILLE PATTERN DOTS-236",
    "2827": "BRAILLE PATTERN DOTS-1236",
    "2828": "BRAILLE PATTERN DOTS-46",
    "2829": "BRAILLE PATTERN DOTS-146",
    "282A": "BRAILLE PATTERN DOTS-246",
    "282B": "BRAILLE PATTERN DOTS-1246",
    "282C": "BRAILLE PATTERN DOTS-346",
    "282D": "BRAILLE PATTERN DOTS-1346",
    "282E": "BRAILLE PATTERN DOTS-2346",
    "282F": "BRAILLE PATTERN DOTS-12346",
    "2830": "BRAILLE PATTERN DOTS-56",
    "2831": "BRAILLE PATTERN DOTS-156",
    "2832": "BRAILLE PATTERN DOTS-256",
    "2833": "BRAILLE PATTERN DOTS-1256",
    "2834": "BRAILLE PATTERN DOTS-356",
    "2835": "BRAILLE PATTERN DOTS-1356",
    "2836": "BRAILLE PATTERN DOTS-2356",
    "2837": "BRAILLE PATTERN DOTS-12356",
    "2838": "BRAILLE PATTERN DOTS-456",
    "2839": "BRAILLE PATTERN DOTS-1456",
    "283A": "BRAILLE PATTERN DOTS-2456",
    "283B": "BRAILLE PATTERN DOTS-12456",
    "283C": "BRAILLE PATTERN DOTS-3456",
    "283D": "BRAILLE PATTERN DOTS-13456",
    "283E": "BRAILLE PATTERN DOTS-23456",
    "283F": "BRAILLE PATTERN DOTS-123456",
    "2840": "BRAILLE PATTERN DOTS-7",
    "2841": "BRAILLE PATTERN DOTS-17",
    "2842": "BRAILLE PATTERN DOTS-27",
    "2843": "BRAILLE PATTERN DOTS-127",
    "2844": "BRAILLE PATTERN DOTS-37",
    "2845": "BRAILLE PATTERN DOTS-137",
    "2846": "BRAILLE PATTERN DOTS-237",
    "2847": "BRAILLE PATTERN DOTS-1237",
    "2848": "BRAILLE PATTERN DOTS-47",
    "2849": "BRAILLE PATTERN DOTS-147",
    "284A": "BRAILLE PATTERN DOTS-247",
    "284B": "BRAILLE PATTERN DOTS-1247",
    "284C": "BRAILLE PATTERN DOTS-347",
    "284D": "BRAILLE PATTERN DOTS-1347",
    "284E": "BRAILLE PATTERN DOTS-2347",
    "284F": "BRAILLE PATTERN DOTS-12347",
    "2850": "BRAILLE PATTERN DOTS-57",
    "2851": "BRAILLE PATTERN DOTS-157",
    "2852": "BRAILLE PATTERN DOTS-257",
    "2853": "BRAILLE PATTERN DOTS-1257",
    "2854": "BRAILLE PATTERN DOTS-357",
    "2855": "BRAILLE PATTERN DOTS-1357",
    "2856": "BRAILLE PATTERN DOTS-2357",
    "2857": "BRAILLE PATTERN DOTS-12357",
    "2858": "BRAILLE PATTERN DOTS-457",
    "2859": "BRAILLE PATTERN DOTS-1457",
    "285A": "BRAILLE PATTERN DOTS-2457",
    "285B": "BRAILLE PATTERN DOTS-12457",
    "285C": "BRAILLE PATTERN DOTS-3457",
    "285D": "BRAILLE PATTERN DOTS-13457",
    "285E": "BRAILLE PATTERN DOTS-23457",
    "285F": "BRAILLE PATTERN DOTS-123457",
    "2860": "BRAILLE PATTERN DOTS-67",
    "2861": "BRAILLE PATTERN DOTS-167",
    "2862": "BRAILLE PATTERN DOTS-267",
    "2863": "BRAILLE PATTERN DOTS-1267",
    "2864": "BRAILLE PATTERN DOTS-367",
    "2865": "BRAILLE PATTERN DOTS-1367",
    "2866": "BRAILLE PATTERN DOTS-2367",
    "2867": "BRAILLE PATTERN DOTS-12367",
    "2868": "BRAILLE PATTERN DOTS-467",
    "2869": "BRAILLE PATTERN DOTS-1467",
    "286A": "BRAILLE PATTERN DOTS-2467",
    "286B": "BRAILLE PATTERN DOTS-12467",
    "286C": "BRAILLE PATTERN DOTS-3467",
    "286D": "BRAILLE PATTERN DOTS-13467",
    "286E": "BRAILLE PATTERN DOTS-23467",
    "286F": "BRAILLE PATTERN DOTS-123467",
    "2870": "BRAILLE PATTERN DOTS-567",
    "2871": "BRAILLE PATTERN DOTS-1567",
    "2872": "BRAILLE PATTERN DOTS-2567",
    "2873": "BRAILLE PATTERN DOTS-12567",
    "2874": "BRAILLE PATTERN DOTS-3567",
    "2875": "BRAILLE PATTERN DOTS-13567",
    "2876": "BRAILLE PATTERN DOTS-23567",
    "2877": "BRAILLE PATTERN DOTS-123567",
    "2878": "BRAILLE PATTERN DOTS-4567",
    "2879": "BRAILLE PATTERN DOTS-14567",
    "287A": "BRAILLE PATTERN DOTS-24567",
    "287B": "BRAILLE PATTERN DOTS-124567",
    "287C": "BRAILLE PATTERN DOTS-34567",
    "287D": "BRAILLE PATTERN DOTS-134567",
    "287E": "BRAILLE PATTERN DOTS-234567",
    "287F": "BRAILLE PATTERN DOTS-1234567",
    "2880": "BRAILLE PATTERN DOTS-8",
    "2881": "BRAILLE PATTERN DOTS-18",
    "2882": "BRAILLE PATTERN DOTS-28",
    "2883": "BRAILLE PATTERN DOTS-128",
    "2884": "BRAILLE PATTERN DOTS-38",
    "2885": "BRAILLE PATTERN DOTS-138",
    "2886": "BRAILLE PATTERN DOTS-238",
    "2887": "BRAILLE PATTERN DOTS-1238",
    "2888": "BRAILLE PATTERN DOTS-48",
    "2889": "BRAILLE PATTERN DOTS-148",
    "288A": "BRAILLE PATTERN DOTS-248",
    "288B": "BRAILLE PATTERN DOTS-1248",
    "288C": "BRAILLE PATTERN DOTS-348",
    "288D": "BRAILLE PATTERN DOTS-1348",
    "288E": "BRAILLE PATTERN DOTS-2348",
    "288F": "BRAILLE PATTERN DOTS-12348",
    "2890": "BRAILLE PATTERN DOTS-58",
    "2891": "BRAILLE PATTERN DOTS-158",
    "2892": "BRAILLE PATTERN DOTS-258",
    "2893": "BRAILLE PATTERN DOTS-1258",
    "2894": "BRAILLE PATTERN DOTS-358",
    "2895": "BRAILLE PATTERN DOTS-1358",
    "2896": "BRAILLE PATTERN DOTS-2358",
    "2897": "BRAILLE PATTERN DOTS-12358",
    "2898": "BRAILLE PATTERN DOTS-458",
    "2899": "BRAILLE PATTERN DOTS-1458",
    "289A": "BRAILLE PATTERN DOTS-2458",
    "289B": "BRAILLE PATTERN DOTS-12458",
    "289C": "BRAILLE PATTERN DOTS-3458",
    "289D": "BRAILLE PATTERN DOTS-13458",
    "289E": "BRAILLE PATTERN DOTS-23458",
    "289F": "BRAILLE PATTERN DOTS-123458",
    "28A0": "BRAILLE PATTERN DOTS-68",
    "28A1": "BRAILLE PATTERN DOTS-168",
    "28A2": "BRAILLE PATTERN DOTS-268",
    "28A3": "BRAILLE PATTERN DOTS-1268",
    "28A4": "BRAILLE PATTERN DOTS-368",
    "28A5": "BRAILLE PATTERN DOTS-1368",
    "28A6": "BRAILLE PATTERN DOTS-2368",
    "28A7": "BRAILLE PATTERN DOTS-12368",
    "28A8": "BRAILLE PATTERN DOTS-468",
    "28A9": "BRAILLE PATTERN DOTS-1468",
    "28AA": "BRAILLE PATTERN DOTS-2468",
    "28AB": "BRAILLE PATTERN DOTS-12468",
    "28AC": "BRAILLE PATTERN DOTS-3468",
    "28AD": "BRAILLE PATTERN DOTS-13468",
    "28AE": "BRAILLE PATTERN DOTS-23468",
    "28AF": "BRAILLE PATTERN DOTS-123468",
    "28B0": "BRAILLE PATTERN DOTS-568",
    "28B1": "BRAILLE PATTERN DOTS-1568",
    "28B2": "BRAILLE PATTERN DOTS-2568",
    "28B3": "BRAILLE PATTERN DOTS-12568",
    "28B4": "BRAILLE PATTERN DOTS-3568",
    "28B5": "BRAILLE PATTERN DOTS-13568",
    "28B6": "BRAILLE PATTERN DOTS-23568",
    "28B7": "BRAILLE PATTERN DOTS-123568",
    "28B8": "BRAILLE PATTERN DOTS-4568",
    "28B9": "BRAILLE PATTERN DOTS-14568",
    "28BA": "BRAILLE PATTERN DOTS-24568",
    "28BB": "BRAILLE PATTERN DOTS-124568",
    "28BC": "BRAILLE PATTERN DOTS-34568",
    "28BD": "BRAILLE PATTERN DOTS-134568",
    "28BE": "BRAILLE PATTERN DOTS-234568",
    "28BF": "BRAILLE PATTERN DOTS-1234568",
    "28C0": "BRAILLE PATTERN DOTS-78",
    "28C1": "BRAILLE PATTERN DOTS-178",
    "28C2": "BRAILLE PATTERN DOTS-278",
    "28C3": "BRAILLE PATTERN DOTS-1278",
    "28C4": "BRAILLE PATTERN DOTS-378",
    "28C5": "BRAILLE PATTERN DOTS-1378",
    "28C6": "BRAILLE PATTERN DOTS-2378",
    "28C7": "BRAILLE PATTERN DOTS-12378",
    "28C8": "BRAILLE PATTERN DOTS-478",
    "28C9": "BRAILLE PATTERN DOTS-1478",
    "28CA": "BRAILLE PATTERN DOTS-2478",
    "28CB": "BRAILLE PATTERN DOTS-12478",
    "28CC": "BRAILLE PATTERN DOTS-3478",
    "28CD": "BRAILLE PATTERN DOTS-13478",
    "28CE": "BRAILLE PATTERN DOTS-23478",
    "28CF": "BRAILLE PATTERN DOTS-123478",
    "28D0": "BRAILLE PATTERN DOTS-578",
    "28D1": "BRAILLE PATTERN DOTS-1578",
    "28D2": "BRAILLE PATTERN DOTS-2578",
    "28D3": "BRAILLE PATTERN DOTS-12578",
    "28D4": "BRAILLE PATTERN DOTS-3578",
    "28D5": "BRAILLE PATTERN DOTS-13578",
    "28D6": "BRAILLE PATTERN DOTS-23578",
    "28D7": "BRAILLE PATTERN DOTS-123578",
    "28D8": "BRAILLE PATTERN DOTS-4578",
    "28D9": "BRAILLE PATTERN DOTS-14578",
    "28DA": "BRAILLE PATTERN DOTS-24578",
    "28DB": "BRAILLE PATTERN DOTS-124578",
    "28DC": "BRAILLE PATTERN DOTS-34578",
    "28DD": "BRAILLE PATTERN DOTS-134578",
    "28DE": "BRAILLE PATTERN DOTS-234578",
    "28DF": "BRAILLE PATTERN DOTS-1234578",
    "28E0": "BRAILLE PATTERN DOTS-678",
    "28E1": "BRAILLE PATTERN DOTS-1678",
    "28E2": "BRAILLE PATTERN DOTS-2678",
    "28E3": "BRAILLE PATTERN DOTS-12678",
    "28E4": "BRAILLE PATTERN DOTS-3678",
    "28E5": "BRAILLE PATTERN DOTS-13678",
    "28E6": "BRAILLE PATTERN DOTS-23678",
    "28E7": "BRAILLE PATTERN DOTS-123678",
    "28E8": "BRAILLE PATTERN DOTS-4678",
    "28E9": "BRAILLE PATTERN DOTS-14678",
    "28EA": "BRAILLE PATTERN DOTS-24678",
    "28EB": "BRAILLE PATTERN DOTS-124678",
    "28EC": "BRAILLE PATTERN DOTS-34678",
    "28ED": "BRAILLE PATTERN DOTS-134678",
    "28EE": "BRAILLE PATTERN DOTS-234678",
    "28EF": "BRAILLE PATTERN DOTS-1234678",
    "28F0": "BRAILLE PATTERN DOTS-5678",
    "28F1": "BRAILLE PATTERN DOTS-15678",
    "28F2": "BRAILLE PATTERN DOTS-25678",
    "28F3": "BRAILLE PATTERN DOTS-125678",
    "28F4": "BRAILLE PATTERN DOTS-35678",
    "28F5": "BRAILLE PATTERN DOTS-135678",
    "28F6": "BRAILLE PATTERN DOTS-235678",
    "28F7": "BRAILLE PATTERN DOTS-1235678",
    "28F8": "BRAILLE PATTERN DOTS-45678",
    "28F9": "BRAILLE PATTERN DOTS-145678",
    "28FA": "BRAILLE PATTERN DOTS-245678",
    "28FB": "BRAILLE PATTERN DOTS-1245678",
    "28FC": "BRAILLE PATTERN DOTS-345678",
    "28FD": "BRAILLE PATTERN DOTS-1345678",
    "28FE": "BRAILLE PATTERN DOTS-2345678",
    "28FF": "BRAILLE PATTERN DOTS-12345678",
    "2900": "RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE",
    "2901": "RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE",
    "2902": "LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE",
    "2903": "RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE",
    "2904": "LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE",
    "2905": "RIGHTWARDS TWO-HEADED ARROW FROM BAR",
    "2906": "LEFTWARDS DOUBLE ARROW FROM BAR",
    "2907": "RIGHTWARDS DOUBLE ARROW FROM BAR",
    "2908": "DOWNWARDS ARROW WITH HORIZONTAL STROKE",
    "2909": "UPWARDS ARROW WITH HORIZONTAL STROKE",
    "290A": "UPWARDS TRIPLE ARROW",
    "290B": "DOWNWARDS TRIPLE ARROW",
    "290C": "LEFTWARDS DOUBLE DASH ARROW",
    "290D": "RIGHTWARDS DOUBLE DASH ARROW",
    "290E": "LEFTWARDS TRIPLE DASH ARROW",
    "290F": "RIGHTWARDS TRIPLE DASH ARROW",
    "2910": "RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW",
    "2911": "RIGHTWARDS ARROW WITH DOTTED STEM",
    "2912": "UPWARDS ARROW TO BAR",
    "2913": "DOWNWARDS ARROW TO BAR",
    "2914": "RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE",
    "2915": "RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE",
    "2916": "RIGHTWARDS TWO-HEADED ARROW WITH TAIL",
    "2917": "RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE",
    "2918": "RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE",
    "2919": "LEFTWARDS ARROW-TAIL",
    "291A": "RIGHTWARDS ARROW-TAIL",
    "291B": "LEFTWARDS DOUBLE ARROW-TAIL",
    "291C": "RIGHTWARDS DOUBLE ARROW-TAIL",
    "291D": "LEFTWARDS ARROW TO BLACK DIAMOND",
    "291E": "RIGHTWARDS ARROW TO BLACK DIAMOND",
    "291F": "LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND",
    "2920": "RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND",
    "2921": "NORTH WEST AND SOUTH EAST ARROW",
    "2922": "NORTH EAST AND SOUTH WEST ARROW",
    "2923": "NORTH WEST ARROW WITH HOOK",
    "2924": "NORTH EAST ARROW WITH HOOK",
    "2925": "SOUTH EAST ARROW WITH HOOK",
    "2926": "SOUTH WEST ARROW WITH HOOK",
    "2927": "NORTH WEST ARROW AND NORTH EAST ARROW",
    "2928": "NORTH EAST ARROW AND SOUTH EAST ARROW",
    "2929": "SOUTH EAST ARROW AND SOUTH WEST ARROW",
    "292A": "SOUTH WEST ARROW AND NORTH WEST ARROW",
    "292B": "RISING DIAGONAL CROSSING FALLING DIAGONAL",
    "292C": "FALLING DIAGONAL CROSSING RISING DIAGONAL",
    "292D": "SOUTH EAST ARROW CROSSING NORTH EAST ARROW",
    "292E": "NORTH EAST ARROW CROSSING SOUTH EAST ARROW",
    "292F": "FALLING DIAGONAL CROSSING NORTH EAST ARROW",
    "2930": "RISING DIAGONAL CROSSING SOUTH EAST ARROW",
    "2931": "NORTH EAST ARROW CROSSING NORTH WEST ARROW",
    "2932": "NORTH WEST ARROW CROSSING NORTH EAST ARROW",
    "2933": "WAVE ARROW POINTING DIRECTLY RIGHT",
    "2934": "ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS",
    "2935": "ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS",
    "2936": "ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS",
    "2937": "ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS",
    "2938": "RIGHT-SIDE ARC CLOCKWISE ARROW",
    "2939": "LEFT-SIDE ARC ANTICLOCKWISE ARROW",
    "293A": "TOP ARC ANTICLOCKWISE ARROW",
    "293B": "BOTTOM ARC ANTICLOCKWISE ARROW",
    "293C": "TOP ARC CLOCKWISE ARROW WITH MINUS",
    "293D": "TOP ARC ANTICLOCKWISE ARROW WITH PLUS",
    "293E": "LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW",
    "293F": "LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW",
    "2940": "ANTICLOCKWISE CLOSED CIRCLE ARROW",
    "2941": "CLOCKWISE CLOSED CIRCLE ARROW",
    "2942": "RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW",
    "2943": "LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW",
    "2944": "SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW",
    "2945": "RIGHTWARDS ARROW WITH PLUS BELOW",
    "2946": "LEFTWARDS ARROW WITH PLUS BELOW",
    "2947": "RIGHTWARDS ARROW THROUGH X",
    "2948": "LEFT RIGHT ARROW THROUGH SMALL CIRCLE",
    "2949": "UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE",
    "294A": "LEFT BARB UP RIGHT BARB DOWN HARPOON",
    "294B": "LEFT BARB DOWN RIGHT BARB UP HARPOON",
    "294C": "UP BARB RIGHT DOWN BARB LEFT HARPOON",
    "294D": "UP BARB LEFT DOWN BARB RIGHT HARPOON",
    "294E": "LEFT BARB UP RIGHT BARB UP HARPOON",
    "294F": "UP BARB RIGHT DOWN BARB RIGHT HARPOON",
    "2950": "LEFT BARB DOWN RIGHT BARB DOWN HARPOON",
    "2951": "UP BARB LEFT DOWN BARB LEFT HARPOON",
    "2952": "LEFTWARDS HARPOON WITH BARB UP TO BAR",
    "2953": "RIGHTWARDS HARPOON WITH BARB UP TO BAR",
    "2954": "UPWARDS HARPOON WITH BARB RIGHT TO BAR",
    "2955": "DOWNWARDS HARPOON WITH BARB RIGHT TO BAR",
    "2956": "LEFTWARDS HARPOON WITH BARB DOWN TO BAR",
    "2957": "RIGHTWARDS HARPOON WITH BARB DOWN TO BAR",
    "2958": "UPWARDS HARPOON WITH BARB LEFT TO BAR",
    "2959": "DOWNWARDS HARPOON WITH BARB LEFT TO BAR",
    "295A": "LEFTWARDS HARPOON WITH BARB UP FROM BAR",
    "295B": "RIGHTWARDS HARPOON WITH BARB UP FROM BAR",
    "295C": "UPWARDS HARPOON WITH BARB RIGHT FROM BAR",
    "295D": "DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR",
    "295E": "LEFTWARDS HARPOON WITH BARB DOWN FROM BAR",
    "295F": "RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR",
    "2960": "UPWARDS HARPOON WITH BARB LEFT FROM BAR",
    "2961": "DOWNWARDS HARPOON WITH BARB LEFT FROM BAR",
    "2962": "LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN",
    "2963": "UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT",
    "2964": "RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN",
    "2965": "DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT",
    "2966": "LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP",
    "2967": "LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN",
    "2968": "RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP",
    "2969": "RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN",
    "296A": "LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH",
    "296B": "LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH",
    "296C": "RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH",
    "296D": "RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH",
    "296E": "UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT",
    "296F": "DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT",
    "2970": "RIGHT DOUBLE ARROW WITH ROUNDED HEAD",
    "2971": "EQUALS SIGN ABOVE RIGHTWARDS ARROW",
    "2972": "TILDE OPERATOR ABOVE RIGHTWARDS ARROW",
    "2973": "LEFTWARDS ARROW ABOVE TILDE OPERATOR",
    "2974": "RIGHTWARDS ARROW ABOVE TILDE OPERATOR",
    "2975": "RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO",
    "2976": "LESS-THAN ABOVE LEFTWARDS ARROW",
    "2977": "LEFTWARDS ARROW THROUGH LESS-THAN",
    "2978": "GREATER-THAN ABOVE RIGHTWARDS ARROW",
    "2979": "SUBSET ABOVE RIGHTWARDS ARROW",
    "297A": "LEFTWARDS ARROW THROUGH SUBSET",
    "297B": "SUPERSET ABOVE LEFTWARDS ARROW",
    "297C": "LEFT FISH TAIL",
    "297D": "RIGHT FISH TAIL",
    "297E": "UP FISH TAIL",
    "297F": "DOWN FISH TAIL",
    "2980": "TRIPLE VERTICAL BAR DELIMITER",
    "2981": "Z NOTATION SPOT",
    "2982": "Z NOTATION TYPE COLON",
    "2983": "LEFT WHITE CURLY BRACKET",
    "2984": "RIGHT WHITE CURLY BRACKET",
    "2985": "LEFT WHITE PARENTHESIS",
    "2986": "RIGHT WHITE PARENTHESIS",
    "2987": "Z NOTATION LEFT IMAGE BRACKET",
    "2988": "Z NOTATION RIGHT IMAGE BRACKET",
    "2989": "Z NOTATION LEFT BINDING BRACKET",
    "298A": "Z NOTATION RIGHT BINDING BRACKET",
    "298B": "LEFT SQUARE BRACKET WITH UNDERBAR",
    "298C": "RIGHT SQUARE BRACKET WITH UNDERBAR",
    "298D": "LEFT SQUARE BRACKET WITH TICK IN TOP CORNER",
    "298E": "RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER",
    "298F": "LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER",
    "2990": "RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER",
    "2991": "LEFT ANGLE BRACKET WITH DOT",
    "2992": "RIGHT ANGLE BRACKET WITH DOT",
    "2993": "LEFT ARC LESS-THAN BRACKET",
    "2994": "RIGHT ARC GREATER-THAN BRACKET",
    "2995": "DOUBLE LEFT ARC GREATER-THAN BRACKET",
    "2996": "DOUBLE RIGHT ARC LESS-THAN BRACKET",
    "2997": "LEFT BLACK TORTOISE SHELL BRACKET",
    "2998": "RIGHT BLACK TORTOISE SHELL BRACKET",
    "2999": "DOTTED FENCE",
    "299A": "VERTICAL ZIGZAG LINE",
    "299B": "MEASURED ANGLE OPENING LEFT",
    "299C": "RIGHT ANGLE VARIANT WITH SQUARE",
    "299D": "MEASURED RIGHT ANGLE WITH DOT",
    "299E": "ANGLE WITH S INSIDE",
    "299F": "ACUTE ANGLE",
    "29A0": "SPHERICAL ANGLE OPENING LEFT",
    "29A1": "SPHERICAL ANGLE OPENING UP",
    "29A2": "TURNED ANGLE",
    "29A3": "REVERSED ANGLE",
    "29A4": "ANGLE WITH UNDERBAR",
    "29A5": "REVERSED ANGLE WITH UNDERBAR",
    "29A6": "OBLIQUE ANGLE OPENING UP",
    "29A7": "OBLIQUE ANGLE OPENING DOWN",
    "29A8": "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT",
    "29A9": "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT",
    "29AA": "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT",
    "29AB": "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT",
    "29AC": "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP",
    "29AD": "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP",
    "29AE": "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN",
    "29AF": "MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN",
    "29B0": "REVERSED EMPTY SET",
    "29B1": "EMPTY SET WITH OVERBAR",
    "29B2": "EMPTY SET WITH SMALL CIRCLE ABOVE",
    "29B3": "EMPTY SET WITH RIGHT ARROW ABOVE",
    "29B4": "EMPTY SET WITH LEFT ARROW ABOVE",
    "29B5": "CIRCLE WITH HORIZONTAL BAR",
    "29B6": "CIRCLED VERTICAL BAR",
    "29B7": "CIRCLED PARALLEL",
    "29B8": "CIRCLED REVERSE SOLIDUS",
    "29B9": "CIRCLED PERPENDICULAR",
    "29BA": "CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR",
    "29BB": "CIRCLE WITH SUPERIMPOSED X",
    "29BC": "CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN",
    "29BD": "UP ARROW THROUGH CIRCLE",
    "29BE": "CIRCLED WHITE BULLET",
    "29BF": "CIRCLED BULLET",
    "29C0": "CIRCLED LESS-THAN",
    "29C1": "CIRCLED GREATER-THAN",
    "29C2": "CIRCLE WITH SMALL CIRCLE TO THE RIGHT",
    "29C3": "CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT",
    "29C4": "SQUARED RISING DIAGONAL SLASH",
    "29C5": "SQUARED FALLING DIAGONAL SLASH",
    "29C6": "SQUARED ASTERISK",
    "29C7": "SQUARED SMALL CIRCLE",
    "29C8": "SQUARED SQUARE",
    "29C9": "TWO JOINED SQUARES",
    "29CA": "TRIANGLE WITH DOT ABOVE",
    "29CB": "TRIANGLE WITH UNDERBAR",
    "29CC": "S IN TRIANGLE",
    "29CD": "TRIANGLE WITH SERIFS AT BOTTOM",
    "29CE": "RIGHT TRIANGLE ABOVE LEFT TRIANGLE",
    "29CF": "LEFT TRIANGLE BESIDE VERTICAL BAR",
    "29D0": "VERTICAL BAR BESIDE RIGHT TRIANGLE",
    "29D1": "BOWTIE WITH LEFT HALF BLACK",
    "29D2": "BOWTIE WITH RIGHT HALF BLACK",
    "29D3": "BLACK BOWTIE",
    "29D4": "TIMES WITH LEFT HALF BLACK",
    "29D5": "TIMES WITH RIGHT HALF BLACK",
    "29D6": "WHITE HOURGLASS",
    "29D7": "BLACK HOURGLASS",
    "29D8": "LEFT WIGGLY FENCE",
    "29D9": "RIGHT WIGGLY FENCE",
    "29DA": "LEFT DOUBLE WIGGLY FENCE",
    "29DB": "RIGHT DOUBLE WIGGLY FENCE",
    "29DC": "INCOMPLETE INFINITY",
    "29DD": "TIE OVER INFINITY",
    "29DE": "INFINITY NEGATED WITH VERTICAL BAR",
    "29DF": "DOUBLE-ENDED MULTIMAP",
    "29E0": "SQUARE WITH CONTOURED OUTLINE",
    "29E1": "INCREASES AS",
    "29E2": "SHUFFLE PRODUCT",
    "29E3": "EQUALS SIGN AND SLANTED PARALLEL",
    "29E4": "EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE",
    "29E5": "IDENTICAL TO AND SLANTED PARALLEL",
    "29E6": "GLEICH STARK",
    "29E7": "THERMODYNAMIC",
    "29E8": "DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK",
    "29E9": "DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK",
    "29EA": "BLACK DIAMOND WITH DOWN ARROW",
    "29EB": "BLACK LOZENGE",
    "29EC": "WHITE CIRCLE WITH DOWN ARROW",
    "29ED": "BLACK CIRCLE WITH DOWN ARROW",
    "29EE": "ERROR-BARRED WHITE SQUARE",
    "29EF": "ERROR-BARRED BLACK SQUARE",
    "29F0": "ERROR-BARRED WHITE DIAMOND",
    "29F1": "ERROR-BARRED BLACK DIAMOND",
    "29F2": "ERROR-BARRED WHITE CIRCLE",
    "29F3": "ERROR-BARRED BLACK CIRCLE",
    "29F4": "RULE-DELAYED",
    "29F5": "REVERSE SOLIDUS OPERATOR",
    "29F6": "SOLIDUS WITH OVERBAR",
    "29F7": "REVERSE SOLIDUS WITH HORIZONTAL STROKE",
    "29F8": "BIG SOLIDUS",
    "29F9": "BIG REVERSE SOLIDUS",
    "29FA": "DOUBLE PLUS",
    "29FB": "TRIPLE PLUS",
    "29FC": "LEFT-POINTING CURVED ANGLE BRACKET",
    "29FD": "RIGHT-POINTING CURVED ANGLE BRACKET",
    "29FE": "TINY",
    "29FF": "MINY",
    "2A00": "N-ARY CIRCLED DOT OPERATOR",
    "2A01": "N-ARY CIRCLED PLUS OPERATOR",
    "2A02": "N-ARY CIRCLED TIMES OPERATOR",
    "2A03": "N-ARY UNION OPERATOR WITH DOT",
    "2A04": "N-ARY UNION OPERATOR WITH PLUS",
    "2A05": "N-ARY SQUARE INTERSECTION OPERATOR",
    "2A06": "N-ARY SQUARE UNION OPERATOR",
    "2A07": "TWO LOGICAL AND OPERATOR",
    "2A08": "TWO LOGICAL OR OPERATOR",
    "2A09": "N-ARY TIMES OPERATOR",
    "2A0A": "MODULO TWO SUM",
    "2A0B": "SUMMATION WITH INTEGRAL",
    "2A0C": "QUADRUPLE INTEGRAL OPERATOR",
    "2A0D": "FINITE PART INTEGRAL",
    "2A0E": "INTEGRAL WITH DOUBLE STROKE",
    "2A0F": "INTEGRAL AVERAGE WITH SLASH",
    "2A10": "CIRCULATION FUNCTION",
    "2A11": "ANTICLOCKWISE INTEGRATION",
    "2A12": "LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE",
    "2A13": "LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE",
    "2A14": "LINE INTEGRATION NOT INCLUDING THE POLE",
    "2A15": "INTEGRAL AROUND A POINT OPERATOR",
    "2A16": "QUATERNION INTEGRAL OPERATOR",
    "2A17": "INTEGRAL WITH LEFTWARDS ARROW WITH HOOK",
    "2A18": "INTEGRAL WITH TIMES SIGN",
    "2A19": "INTEGRAL WITH INTERSECTION",
    "2A1A": "INTEGRAL WITH UNION",
    "2A1B": "INTEGRAL WITH OVERBAR",
    "2A1C": "INTEGRAL WITH UNDERBAR",
    "2A1D": "JOIN",
    "2A1E": "LARGE LEFT TRIANGLE OPERATOR",
    "2A1F": "Z NOTATION SCHEMA COMPOSITION",
    "2A20": "Z NOTATION SCHEMA PIPING",
    "2A21": "Z NOTATION SCHEMA PROJECTION",
    "2A22": "PLUS SIGN WITH SMALL CIRCLE ABOVE",
    "2A23": "PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE",
    "2A24": "PLUS SIGN WITH TILDE ABOVE",
    "2A25": "PLUS SIGN WITH DOT BELOW",
    "2A26": "PLUS SIGN WITH TILDE BELOW",
    "2A27": "PLUS SIGN WITH SUBSCRIPT TWO",
    "2A28": "PLUS SIGN WITH BLACK TRIANGLE",
    "2A29": "MINUS SIGN WITH COMMA ABOVE",
    "2A2A": "MINUS SIGN WITH DOT BELOW",
    "2A2B": "MINUS SIGN WITH FALLING DOTS",
    "2A2C": "MINUS SIGN WITH RISING DOTS",
    "2A2D": "PLUS SIGN IN LEFT HALF CIRCLE",
    "2A2E": "PLUS SIGN IN RIGHT HALF CIRCLE",
    "2A2F": "VECTOR OR CROSS PRODUCT",
    "2A30": "MULTIPLICATION SIGN WITH DOT ABOVE",
    "2A31": "MULTIPLICATION SIGN WITH UNDERBAR",
    "2A32": "SEMIDIRECT PRODUCT WITH BOTTOM CLOSED",
    "2A33": "SMASH PRODUCT",
    "2A34": "MULTIPLICATION SIGN IN LEFT HALF CIRCLE",
    "2A35": "MULTIPLICATION SIGN IN RIGHT HALF CIRCLE",
    "2A36": "CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT",
    "2A37": "MULTIPLICATION SIGN IN DOUBLE CIRCLE",
    "2A38": "CIRCLED DIVISION SIGN",
    "2A39": "PLUS SIGN IN TRIANGLE",
    "2A3A": "MINUS SIGN IN TRIANGLE",
    "2A3B": "MULTIPLICATION SIGN IN TRIANGLE",
    "2A3C": "INTERIOR PRODUCT",
    "2A3D": "RIGHTHAND INTERIOR PRODUCT",
    "2A3E": "Z NOTATION RELATIONAL COMPOSITION",
    "2A3F": "AMALGAMATION OR COPRODUCT",
    "2A40": "INTERSECTION WITH DOT",
    "2A41": "UNION WITH MINUS SIGN",
    "2A42": "UNION WITH OVERBAR",
    "2A43": "INTERSECTION WITH OVERBAR",
    "2A44": "INTERSECTION WITH LOGICAL AND",
    "2A45": "UNION WITH LOGICAL OR",
    "2A46": "UNION ABOVE INTERSECTION",
    "2A47": "INTERSECTION ABOVE UNION",
    "2A48": "UNION ABOVE BAR ABOVE INTERSECTION",
    "2A49": "INTERSECTION ABOVE BAR ABOVE UNION",
    "2A4A": "UNION BESIDE AND JOINED WITH UNION",
    "2A4B": "INTERSECTION BESIDE AND JOINED WITH INTERSECTION",
    "2A4C": "CLOSED UNION WITH SERIFS",
    "2A4D": "CLOSED INTERSECTION WITH SERIFS",
    "2A4E": "DOUBLE SQUARE INTERSECTION",
    "2A4F": "DOUBLE SQUARE UNION",
    "2A50": "CLOSED UNION WITH SERIFS AND SMASH PRODUCT",
    "2A51": "LOGICAL AND WITH DOT ABOVE",
    "2A52": "LOGICAL OR WITH DOT ABOVE",
    "2A53": "DOUBLE LOGICAL AND",
    "2A54": "DOUBLE LOGICAL OR",
    "2A55": "TWO INTERSECTING LOGICAL AND",
    "2A56": "TWO INTERSECTING LOGICAL OR",
    "2A57": "SLOPING LARGE OR",
    "2A58": "SLOPING LARGE AND",
    "2A59": "LOGICAL OR OVERLAPPING LOGICAL AND",
    "2A5A": "LOGICAL AND WITH MIDDLE STEM",
    "2A5B": "LOGICAL OR WITH MIDDLE STEM",
    "2A5C": "LOGICAL AND WITH HORIZONTAL DASH",
    "2A5D": "LOGICAL OR WITH HORIZONTAL DASH",
    "2A5E": "LOGICAL AND WITH DOUBLE OVERBAR",
    "2A5F": "LOGICAL AND WITH UNDERBAR",
    "2A60": "LOGICAL AND WITH DOUBLE UNDERBAR",
    "2A61": "SMALL VEE WITH UNDERBAR",
    "2A62": "LOGICAL OR WITH DOUBLE OVERBAR",
    "2A63": "LOGICAL OR WITH DOUBLE UNDERBAR",
    "2A64": "Z NOTATION DOMAIN ANTIRESTRICTION",
    "2A65": "Z NOTATION RANGE ANTIRESTRICTION",
    "2A66": "EQUALS SIGN WITH DOT BELOW",
    "2A67": "IDENTICAL WITH DOT ABOVE",
    "2A68": "TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE",
    "2A69": "TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE",
    "2A6A": "TILDE OPERATOR WITH DOT ABOVE",
    "2A6B": "TILDE OPERATOR WITH RISING DOTS",
    "2A6C": "SIMILAR MINUS SIMILAR",
    "2A6D": "CONGRUENT WITH DOT ABOVE",
    "2A6E": "EQUALS WITH ASTERISK",
    "2A6F": "ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT",
    "2A70": "APPROXIMATELY EQUAL OR EQUAL TO",
    "2A71": "EQUALS SIGN ABOVE PLUS SIGN",
    "2A72": "PLUS SIGN ABOVE EQUALS SIGN",
    "2A73": "EQUALS SIGN ABOVE TILDE OPERATOR",
    "2A74": "DOUBLE COLON EQUAL",
    "2A75": "TWO CONSECUTIVE EQUALS SIGNS",
    "2A76": "THREE CONSECUTIVE EQUALS SIGNS",
    "2A77": "EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW",
    "2A78": "EQUIVALENT WITH FOUR DOTS ABOVE",
    "2A79": "LESS-THAN WITH CIRCLE INSIDE",
    "2A7A": "GREATER-THAN WITH CIRCLE INSIDE",
    "2A7B": "LESS-THAN WITH QUESTION MARK ABOVE",
    "2A7C": "GREATER-THAN WITH QUESTION MARK ABOVE",
    "2A7D": "LESS-THAN OR SLANTED EQUAL TO",
    "2A7E": "GREATER-THAN OR SLANTED EQUAL TO",
    "2A7F": "LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE",
    "2A80": "GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE",
    "2A81": "LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE",
    "2A82": "GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE",
    "2A83": "LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT",
    "2A84": "GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT",
    "2A85": "LESS-THAN OR APPROXIMATE",
    "2A86": "GREATER-THAN OR APPROXIMATE",
    "2A87": "LESS-THAN AND SINGLE-LINE NOT EQUAL TO",
    "2A88": "GREATER-THAN AND SINGLE-LINE NOT EQUAL TO",
    "2A89": "LESS-THAN AND NOT APPROXIMATE",
    "2A8A": "GREATER-THAN AND NOT APPROXIMATE",
    "2A8B": "LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN",
    "2A8C": "GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN",
    "2A8D": "LESS-THAN ABOVE SIMILAR OR EQUAL",
    "2A8E": "GREATER-THAN ABOVE SIMILAR OR EQUAL",
    "2A8F": "LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN",
    "2A90": "GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN",
    "2A91": "LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL",
    "2A92": "GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL",
    "2A93": "LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL",
    "2A94": "GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL",
    "2A95": "SLANTED EQUAL TO OR LESS-THAN",
    "2A96": "SLANTED EQUAL TO OR GREATER-THAN",
    "2A97": "SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE",
    "2A98": "SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE",
    "2A99": "DOUBLE-LINE EQUAL TO OR LESS-THAN",
    "2A9A": "DOUBLE-LINE EQUAL TO OR GREATER-THAN",
    "2A9B": "DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN",
    "2A9C": "DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN",
    "2A9D": "SIMILAR OR LESS-THAN",
    "2A9E": "SIMILAR OR GREATER-THAN",
    "2A9F": "SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN",
    "2AA0": "SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN",
    "2AA1": "DOUBLE NESTED LESS-THAN",
    "2AA2": "DOUBLE NESTED GREATER-THAN",
    "2AA3": "DOUBLE NESTED LESS-THAN WITH UNDERBAR",
    "2AA4": "GREATER-THAN OVERLAPPING LESS-THAN",
    "2AA5": "GREATER-THAN BESIDE LESS-THAN",
    "2AA6": "LESS-THAN CLOSED BY CURVE",
    "2AA7": "GREATER-THAN CLOSED BY CURVE",
    "2AA8": "LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL",
    "2AA9": "GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL",
    "2AAA": "SMALLER THAN",
    "2AAB": "LARGER THAN",
    "2AAC": "SMALLER THAN OR EQUAL TO",
    "2AAD": "LARGER THAN OR EQUAL TO",
    "2AAE": "EQUALS SIGN WITH BUMPY ABOVE",
    "2AAF": "PRECEDES ABOVE SINGLE-LINE EQUALS SIGN",
    "2AB0": "SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN",
    "2AB1": "PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO",
    "2AB2": "SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO",
    "2AB3": "PRECEDES ABOVE EQUALS SIGN",
    "2AB4": "SUCCEEDS ABOVE EQUALS SIGN",
    "2AB5": "PRECEDES ABOVE NOT EQUAL TO",
    "2AB6": "SUCCEEDS ABOVE NOT EQUAL TO",
    "2AB7": "PRECEDES ABOVE ALMOST EQUAL TO",
    "2AB8": "SUCCEEDS ABOVE ALMOST EQUAL TO",
    "2AB9": "PRECEDES ABOVE NOT ALMOST EQUAL TO",
    "2ABA": "SUCCEEDS ABOVE NOT ALMOST EQUAL TO",
    "2ABB": "DOUBLE PRECEDES",
    "2ABC": "DOUBLE SUCCEEDS",
    "2ABD": "SUBSET WITH DOT",
    "2ABE": "SUPERSET WITH DOT",
    "2ABF": "SUBSET WITH PLUS SIGN BELOW",
    "2AC0": "SUPERSET WITH PLUS SIGN BELOW",
    "2AC1": "SUBSET WITH MULTIPLICATION SIGN BELOW",
    "2AC2": "SUPERSET WITH MULTIPLICATION SIGN BELOW",
    "2AC3": "SUBSET OF OR EQUAL TO WITH DOT ABOVE",
    "2AC4": "SUPERSET OF OR EQUAL TO WITH DOT ABOVE",
    "2AC5": "SUBSET OF ABOVE EQUALS SIGN",
    "2AC6": "SUPERSET OF ABOVE EQUALS SIGN",
    "2AC7": "SUBSET OF ABOVE TILDE OPERATOR",
    "2AC8": "SUPERSET OF ABOVE TILDE OPERATOR",
    "2AC9": "SUBSET OF ABOVE ALMOST EQUAL TO",
    "2ACA": "SUPERSET OF ABOVE ALMOST EQUAL TO",
    "2ACB": "SUBSET OF ABOVE NOT EQUAL TO",
    "2ACC": "SUPERSET OF ABOVE NOT EQUAL TO",
    "2ACD": "SQUARE LEFT OPEN BOX OPERATOR",
    "2ACE": "SQUARE RIGHT OPEN BOX OPERATOR",
    "2ACF": "CLOSED SUBSET",
    "2AD0": "CLOSED SUPERSET",
    "2AD1": "CLOSED SUBSET OR EQUAL TO",
    "2AD2": "CLOSED SUPERSET OR EQUAL TO",
    "2AD3": "SUBSET ABOVE SUPERSET",
    "2AD4": "SUPERSET ABOVE SUBSET",
    "2AD5": "SUBSET ABOVE SUBSET",
    "2AD6": "SUPERSET ABOVE SUPERSET",
    "2AD7": "SUPERSET BESIDE SUBSET",
    "2AD8": "SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET",
    "2AD9": "ELEMENT OF OPENING DOWNWARDS",
    "2ADA": "PITCHFORK WITH TEE TOP",
    "2ADB": "TRANSVERSAL INTERSECTION",
    "2ADC": "FORKING",
    "2ADD": "NONFORKING",
    "2ADE": "SHORT LEFT TACK",
    "2ADF": "SHORT DOWN TACK",
    "2AE0": "SHORT UP TACK",
    "2AE1": "PERPENDICULAR WITH S",
    "2AE2": "VERTICAL BAR TRIPLE RIGHT TURNSTILE",
    "2AE3": "DOUBLE VERTICAL BAR LEFT TURNSTILE",
    "2AE4": "VERTICAL BAR DOUBLE LEFT TURNSTILE",
    "2AE5": "DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE",
    "2AE6": "LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL",
    "2AE7": "SHORT DOWN TACK WITH OVERBAR",
    "2AE8": "SHORT UP TACK WITH UNDERBAR",
    "2AE9": "SHORT UP TACK ABOVE SHORT DOWN TACK",
    "2AEA": "DOUBLE DOWN TACK",
    "2AEB": "DOUBLE UP TACK",
    "2AEC": "DOUBLE STROKE NOT SIGN",
    "2AED": "REVERSED DOUBLE STROKE NOT SIGN",
    "2AEE": "DOES NOT DIVIDE WITH REVERSED NEGATION SLASH",
    "2AEF": "VERTICAL LINE WITH CIRCLE ABOVE",
    "2AF0": "VERTICAL LINE WITH CIRCLE BELOW",
    "2AF1": "DOWN TACK WITH CIRCLE BELOW",
    "2AF2": "PARALLEL WITH HORIZONTAL STROKE",
    "2AF3": "PARALLEL WITH TILDE OPERATOR",
    "2AF4": "TRIPLE VERTICAL BAR BINARY RELATION",
    "2AF5": "TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE",
    "2AF6": "TRIPLE COLON OPERATOR",
    "2AF7": "TRIPLE NESTED LESS-THAN",
    "2AF8": "TRIPLE NESTED GREATER-THAN",
    "2AF9": "DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO",
    "2AFA": "DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO",
    "2AFB": "TRIPLE SOLIDUS BINARY RELATION",
    "2AFC": "LARGE TRIPLE VERTICAL BAR OPERATOR",
    "2AFD": "DOUBLE SOLIDUS OPERATOR",
    "2AFE": "WHITE VERTICAL BAR",
    "2AFF": "N-ARY WHITE VERTICAL BAR",
    "2B00": "NORTH EAST WHITE ARROW",
    "2B01": "NORTH WEST WHITE ARROW",
    "2B02": "SOUTH EAST WHITE ARROW",
    "2B03": "SOUTH WEST WHITE ARROW",
    "2B04": "LEFT RIGHT WHITE ARROW",
    "2B05": "LEFTWARDS BLACK ARROW",
    "2B06": "UPWARDS BLACK ARROW",
    "2B07": "DOWNWARDS BLACK ARROW",
    "2B08": "NORTH EAST BLACK ARROW",
    "2B09": "NORTH WEST BLACK ARROW",
    "2B0A": "SOUTH EAST BLACK ARROW",
    "2B0B": "SOUTH WEST BLACK ARROW",
    "2B0C": "LEFT RIGHT BLACK ARROW",
    "2B0D": "UP DOWN BLACK ARROW",
    "2B0E": "RIGHTWARDS ARROW WITH TIP DOWNWARDS",
    "2B0F": "RIGHTWARDS ARROW WITH TIP UPWARDS",
    "2B10": "LEFTWARDS ARROW WITH TIP DOWNWARDS",
    "2B11": "LEFTWARDS ARROW WITH TIP UPWARDS",
    "2B12": "SQUARE WITH TOP HALF BLACK",
    "2B13": "SQUARE WITH BOTTOM HALF BLACK",
    "2B14": "SQUARE WITH UPPER RIGHT DIAGONAL HALF BLACK",
    "2B15": "SQUARE WITH LOWER LEFT DIAGONAL HALF BLACK",
    "2B16": "DIAMOND WITH LEFT HALF BLACK",
    "2B17": "DIAMOND WITH RIGHT HALF BLACK",
    "2B18": "DIAMOND WITH TOP HALF BLACK",
    "2B19": "DIAMOND WITH BOTTOM HALF BLACK",
    "2B1A": "DOTTED SQUARE",
    "2B1B": "BLACK LARGE SQUARE",
    "2B1C": "WHITE LARGE SQUARE",
    "2B1D": "BLACK VERY SMALL SQUARE",
    "2B1E": "WHITE VERY SMALL SQUARE",
    "2B1F": "BLACK PENTAGON",
    "2B20": "WHITE PENTAGON",
    "2B21": "WHITE HEXAGON",
    "2B22": "BLACK HEXAGON",
    "2B23": "HORIZONTAL BLACK HEXAGON",
    "2B24": "BLACK LARGE CIRCLE",
    "2B25": "BLACK MEDIUM DIAMOND",
    "2B26": "WHITE MEDIUM DIAMOND",
    "2B27": "BLACK MEDIUM LOZENGE",
    "2B28": "WHITE MEDIUM LOZENGE",
    "2B29": "BLACK SMALL DIAMOND",
    "2B2A": "BLACK SMALL LOZENGE",
    "2B2B": "WHITE SMALL LOZENGE",
    "2B2C": "BLACK HORIZONTAL ELLIPSE",
    "2B2D": "WHITE HORIZONTAL ELLIPSE",
    "2B2E": "BLACK VERTICAL ELLIPSE",
    "2B2F": "WHITE VERTICAL ELLIPSE",
    "2B30": "LEFT ARROW WITH SMALL CIRCLE",
    "2B31": "THREE LEFTWARDS ARROWS",
    "2B32": "LEFT ARROW WITH CIRCLED PLUS",
    "2B33": "LONG LEFTWARDS SQUIGGLE ARROW",
    "2B34": "LEFTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE",
    "2B35": "LEFTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE",
    "2B36": "LEFTWARDS TWO-HEADED ARROW FROM BAR",
    "2B37": "LEFTWARDS TWO-HEADED TRIPLE DASH ARROW",
    "2B38": "LEFTWARDS ARROW WITH DOTTED STEM",
    "2B39": "LEFTWARDS ARROW WITH TAIL WITH VERTICAL STROKE",
    "2B3A": "LEFTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE",
    "2B3B": "LEFTWARDS TWO-HEADED ARROW WITH TAIL",
    "2B3C": "LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE",
    "2B3D": "LEFTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE",
    "2B3E": "LEFTWARDS ARROW THROUGH X",
    "2B3F": "WAVE ARROW POINTING DIRECTLY LEFT",
    "2B40": "EQUALS SIGN ABOVE LEFTWARDS ARROW",
    "2B41": "REVERSE TILDE OPERATOR ABOVE LEFTWARDS ARROW",
    "2B42": "LEFTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO",
    "2B43": "RIGHTWARDS ARROW THROUGH GREATER-THAN",
    "2B44": "RIGHTWARDS ARROW THROUGH SUPERSET",
    "2B45": "LEFTWARDS QUADRUPLE ARROW",
    "2B46": "RIGHTWARDS QUADRUPLE ARROW",
    "2B47": "REVERSE TILDE OPERATOR ABOVE RIGHTWARDS ARROW",
    "2B48": "RIGHTWARDS ARROW ABOVE REVERSE ALMOST EQUAL TO",
    "2B49": "TILDE OPERATOR ABOVE LEFTWARDS ARROW",
    "2B4A": "LEFTWARDS ARROW ABOVE ALMOST EQUAL TO",
    "2B4B": "LEFTWARDS ARROW ABOVE REVERSE TILDE OPERATOR",
    "2B4C": "RIGHTWARDS ARROW ABOVE REVERSE TILDE OPERATOR",
    "2B4D": "DOWNWARDS TRIANGLE-HEADED ZIGZAG ARROW",
    "2B4E": "SHORT SLANTED NORTH ARROW",
    "2B4F": "SHORT BACKSLANTED SOUTH ARROW",
    "2B50": "WHITE MEDIUM STAR",
    "2B51": "BLACK SMALL STAR",
    "2B52": "WHITE SMALL STAR",
    "2B53": "BLACK RIGHT-POINTING PENTAGON",
    "2B54": "WHITE RIGHT-POINTING PENTAGON",
    "2B55": "HEAVY LARGE CIRCLE",
    "2B56": "HEAVY OVAL WITH OVAL INSIDE",
    "2B57": "HEAVY CIRCLE WITH CIRCLE INSIDE",
    "2B58": "HEAVY CIRCLE",
    "2B59": "HEAVY CIRCLED SALTIRE",
    "2B5A": "SLANTED NORTH ARROW WITH HOOKED HEAD",
    "2B5B": "BACKSLANTED SOUTH ARROW WITH HOOKED TAIL",
    "2B5C": "SLANTED NORTH ARROW WITH HORIZONTAL TAIL",
    "2B5D": "BACKSLANTED SOUTH ARROW WITH HORIZONTAL TAIL",
    "2B5E": "BENT ARROW POINTING DOWNWARDS THEN NORTH EAST",
    "2B5F": "SHORT BENT ARROW POINTING DOWNWARDS THEN NORTH EAST",
    "2B60": "LEFTWARDS TRIANGLE-HEADED ARROW",
    "2B61": "UPWARDS TRIANGLE-HEADED ARROW",
    "2B62": "RIGHTWARDS TRIANGLE-HEADED ARROW",
    "2B63": "DOWNWARDS TRIANGLE-HEADED ARROW",
    "2B64": "LEFT RIGHT TRIANGLE-HEADED ARROW",
    "2B65": "UP DOWN TRIANGLE-HEADED ARROW",
    "2B66": "NORTH WEST TRIANGLE-HEADED ARROW",
    "2B67": "NORTH EAST TRIANGLE-HEADED ARROW",
    "2B68": "SOUTH EAST TRIANGLE-HEADED ARROW",
    "2B69": "SOUTH WEST TRIANGLE-HEADED ARROW",
    "2B6A": "LEFTWARDS TRIANGLE-HEADED DASHED ARROW",
    "2B6B": "UPWARDS TRIANGLE-HEADED DASHED ARROW",
    "2B6C": "RIGHTWARDS TRIANGLE-HEADED DASHED ARROW",
    "2B6D": "DOWNWARDS TRIANGLE-HEADED DASHED ARROW",
    "2B6E": "CLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROW",
    "2B6F": "ANTICLOCKWISE TRIANGLE-HEADED OPEN CIRCLE ARROW",
    "2B70": "LEFTWARDS TRIANGLE-HEADED ARROW TO BAR",
    "2B71": "UPWARDS TRIANGLE-HEADED ARROW TO BAR",
    "2B72": "RIGHTWARDS TRIANGLE-HEADED ARROW TO BAR",
    "2B73": "DOWNWARDS TRIANGLE-HEADED ARROW TO BAR",
    "2B76": "NORTH WEST TRIANGLE-HEADED ARROW TO BAR",
    "2B77": "NORTH EAST TRIANGLE-HEADED ARROW TO BAR",
    "2B78": "SOUTH EAST TRIANGLE-HEADED ARROW TO BAR",
    "2B79": "SOUTH WEST TRIANGLE-HEADED ARROW TO BAR",
    "2B7A": "LEFTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE",
    "2B7B": "UPWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE",
    "2B7C": "RIGHTWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE",
    "2B7D": "DOWNWARDS TRIANGLE-HEADED ARROW WITH DOUBLE HORIZONTAL STROKE",
    "2B7E": "HORIZONTAL TAB KEY",
    "2B7F": "VERTICAL TAB KEY",
    "2B80": "LEFTWARDS TRIANGLE-HEADED ARROW OVER RIGHTWARDS TRIANGLE-HEADED ARROW",
    "2B81": "UPWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF DOWNWARDS TRIANGLE-HEADED ARROW",
    "2B82": "RIGHTWARDS TRIANGLE-HEADED ARROW OVER LEFTWARDS TRIANGLE-HEADED ARROW",
    "2B83": "DOWNWARDS TRIANGLE-HEADED ARROW LEFTWARDS OF UPWARDS TRIANGLE-HEADED ARROW",
    "2B84": "LEFTWARDS TRIANGLE-HEADED PAIRED ARROWS",
    "2B85": "UPWARDS TRIANGLE-HEADED PAIRED ARROWS",
    "2B86": "RIGHTWARDS TRIANGLE-HEADED PAIRED ARROWS",
    "2B87": "DOWNWARDS TRIANGLE-HEADED PAIRED ARROWS",
    "2B88": "LEFTWARDS BLACK CIRCLED WHITE ARROW",
    "2B89": "UPWARDS BLACK CIRCLED WHITE ARROW",
    "2B8A": "RIGHTWARDS BLACK CIRCLED WHITE ARROW",
    "2B8B": "DOWNWARDS BLACK CIRCLED WHITE ARROW",
    "2B8C": "ANTICLOCKWISE TRIANGLE-HEADED RIGHT U-SHAPED ARROW",
    "2B8D": "ANTICLOCKWISE TRIANGLE-HEADED BOTTOM U-SHAPED ARROW",
    "2B8E": "ANTICLOCKWISE TRIANGLE-HEADED LEFT U-SHAPED ARROW",
    "2B8F": "ANTICLOCKWISE TRIANGLE-HEADED TOP U-SHAPED ARROW",
    "2B90": "RETURN LEFT",
    "2B91": "RETURN RIGHT",
    "2B92": "NEWLINE LEFT",
    "2B93": "NEWLINE RIGHT",
    "2B94": "FOUR CORNER ARROWS CIRCLING ANTICLOCKWISE",
    "2B95": "RIGHTWARDS BLACK ARROW",
    "2B98": "THREE-D TOP-LIGHTED LEFTWARDS EQUILATERAL ARROWHEAD",
    "2B99": "THREE-D RIGHT-LIGHTED UPWARDS EQUILATERAL ARROWHEAD",
    "2B9A": "THREE-D TOP-LIGHTED RIGHTWARDS EQUILATERAL ARROWHEAD",
    "2B9B": "THREE-D LEFT-LIGHTED DOWNWARDS EQUILATERAL ARROWHEAD",
    "2B9C": "BLACK LEFTWARDS EQUILATERAL ARROWHEAD",
    "2B9D": "BLACK UPWARDS EQUILATERAL ARROWHEAD",
    "2B9E": "BLACK RIGHTWARDS EQUILATERAL ARROWHEAD",
    "2B9F": "BLACK DOWNWARDS EQUILATERAL ARROWHEAD",
    "2BA0": "DOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDS",
    "2BA1": "DOWNWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDS",
    "2BA2": "UPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP LEFTWARDS",
    "2BA3": "UPWARDS TRIANGLE-HEADED ARROW WITH LONG TIP RIGHTWARDS",
    "2BA4": "LEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDS",
    "2BA5": "RIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP UPWARDS",
    "2BA6": "LEFTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDS",
    "2BA7": "RIGHTWARDS TRIANGLE-HEADED ARROW WITH LONG TIP DOWNWARDS",
    "2BA8": "BLACK CURVED DOWNWARDS AND LEFTWARDS ARROW",
    "2BA9": "BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW",
    "2BAA": "BLACK CURVED UPWARDS AND LEFTWARDS ARROW",
    "2BAB": "BLACK CURVED UPWARDS AND RIGHTWARDS ARROW",
    "2BAC": "BLACK CURVED LEFTWARDS AND UPWARDS ARROW",
    "2BAD": "BLACK CURVED RIGHTWARDS AND UPWARDS ARROW",
    "2BAE": "BLACK CURVED LEFTWARDS AND DOWNWARDS ARROW",
    "2BAF": "BLACK CURVED RIGHTWARDS AND DOWNWARDS ARROW",
    "2BB0": "RIBBON ARROW DOWN LEFT",
    "2BB1": "RIBBON ARROW DOWN RIGHT",
    "2BB2": "RIBBON ARROW UP LEFT",
    "2BB3": "RIBBON ARROW UP RIGHT",
    "2BB4": "RIBBON ARROW LEFT UP",
    "2BB5": "RIBBON ARROW RIGHT UP",
    "2BB6": "RIBBON ARROW LEFT DOWN",
    "2BB7": "RIBBON ARROW RIGHT DOWN",
    "2BB8": "UPWARDS WHITE ARROW FROM BAR WITH HORIZONTAL BAR",
    "2BB9": "UP ARROWHEAD IN A RECTANGLE BOX",
    "2BBD": "BALLOT BOX WITH LIGHT X",
    "2BBE": "CIRCLED X",
    "2BBF": "CIRCLED BOLD X",
    "2BC0": "BLACK SQUARE CENTRED",
    "2BC1": "BLACK DIAMOND CENTRED",
    "2BC2": "TURNED BLACK PENTAGON",
    "2BC3": "HORIZONTAL BLACK OCTAGON",
    "2BC4": "BLACK OCTAGON",
    "2BC5": "BLACK MEDIUM UP-POINTING TRIANGLE CENTRED",
    "2BC6": "BLACK MEDIUM DOWN-POINTING TRIANGLE CENTRED",
    "2BC7": "BLACK MEDIUM LEFT-POINTING TRIANGLE CENTRED",
    "2BC8": "BLACK MEDIUM RIGHT-POINTING TRIANGLE CENTRED",
    "2BCA": "TOP HALF BLACK CIRCLE",
    "2BCB": "BOTTOM HALF BLACK CIRCLE",
    "2BCC": "LIGHT FOUR POINTED BLACK CUSP",
    "2BCD": "ROTATED LIGHT FOUR POINTED BLACK CUSP",
    "2BCE": "WHITE FOUR POINTED CUSP",
    "2BCF": "ROTATED WHITE FOUR POINTED CUSP",
    "2BD0": "SQUARE POSITION INDICATOR",
    "2BD1": "UNCERTAINTY SIGN",
    "2BEC": "LEFTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS",
    "2BED": "UPWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS",
    "2BEE": "RIGHTWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS",
    "2BEF": "DOWNWARDS TWO-HEADED ARROW WITH TRIANGLE ARROWHEADS",
    "2C00": "GLAGOLITIC CAPITAL LETTER AZU",
    "2C01": "GLAGOLITIC CAPITAL LETTER BUKY",
    "2C02": "GLAGOLITIC CAPITAL LETTER VEDE",
    "2C03": "GLAGOLITIC CAPITAL LETTER GLAGOLI",
    "2C04": "GLAGOLITIC CAPITAL LETTER DOBRO",
    "2C05": "GLAGOLITIC CAPITAL LETTER YESTU",
    "2C06": "GLAGOLITIC CAPITAL LETTER ZHIVETE",
    "2C07": "GLAGOLITIC CAPITAL LETTER DZELO",
    "2C08": "GLAGOLITIC CAPITAL LETTER ZEMLJA",
    "2C09": "GLAGOLITIC CAPITAL LETTER IZHE",
    "2C0A": "GLAGOLITIC CAPITAL LETTER INITIAL IZHE",
    "2C0B": "GLAGOLITIC CAPITAL LETTER I",
    "2C0C": "GLAGOLITIC CAPITAL LETTER DJERVI",
    "2C0D": "GLAGOLITIC CAPITAL LETTER KAKO",
    "2C0E": "GLAGOLITIC CAPITAL LETTER LJUDIJE",
    "2C0F": "GLAGOLITIC CAPITAL LETTER MYSLITE",
    "2C10": "GLAGOLITIC CAPITAL LETTER NASHI",
    "2C11": "GLAGOLITIC CAPITAL LETTER ONU",
    "2C12": "GLAGOLITIC CAPITAL LETTER POKOJI",
    "2C13": "GLAGOLITIC CAPITAL LETTER RITSI",
    "2C14": "GLAGOLITIC CAPITAL LETTER SLOVO",
    "2C15": "GLAGOLITIC CAPITAL LETTER TVRIDO",
    "2C16": "GLAGOLITIC CAPITAL LETTER UKU",
    "2C17": "GLAGOLITIC CAPITAL LETTER FRITU",
    "2C18": "GLAGOLITIC CAPITAL LETTER HERU",
    "2C19": "GLAGOLITIC CAPITAL LETTER OTU",
    "2C1A": "GLAGOLITIC CAPITAL LETTER PE",
    "2C1B": "GLAGOLITIC CAPITAL LETTER SHTA",
    "2C1C": "GLAGOLITIC CAPITAL LETTER TSI",
    "2C1D": "GLAGOLITIC CAPITAL LETTER CHRIVI",
    "2C1E": "GLAGOLITIC CAPITAL LETTER SHA",
    "2C1F": "GLAGOLITIC CAPITAL LETTER YERU",
    "2C20": "GLAGOLITIC CAPITAL LETTER YERI",
    "2C21": "GLAGOLITIC CAPITAL LETTER YATI",
    "2C22": "GLAGOLITIC CAPITAL LETTER SPIDERY HA",
    "2C23": "GLAGOLITIC CAPITAL LETTER YU",
    "2C24": "GLAGOLITIC CAPITAL LETTER SMALL YUS",
    "2C25": "GLAGOLITIC CAPITAL LETTER SMALL YUS WITH TAIL",
    "2C26": "GLAGOLITIC CAPITAL LETTER YO",
    "2C27": "GLAGOLITIC CAPITAL LETTER IOTATED SMALL YUS",
    "2C28": "GLAGOLITIC CAPITAL LETTER BIG YUS",
    "2C29": "GLAGOLITIC CAPITAL LETTER IOTATED BIG YUS",
    "2C2A": "GLAGOLITIC CAPITAL LETTER FITA",
    "2C2B": "GLAGOLITIC CAPITAL LETTER IZHITSA",
    "2C2C": "GLAGOLITIC CAPITAL LETTER SHTAPIC",
    "2C2D": "GLAGOLITIC CAPITAL LETTER TROKUTASTI A",
    "2C2E": "GLAGOLITIC CAPITAL LETTER LATINATE MYSLITE",
    "2C30": "GLAGOLITIC SMALL LETTER AZU",
    "2C31": "GLAGOLITIC SMALL LETTER BUKY",
    "2C32": "GLAGOLITIC SMALL LETTER VEDE",
    "2C33": "GLAGOLITIC SMALL LETTER GLAGOLI",
    "2C34": "GLAGOLITIC SMALL LETTER DOBRO",
    "2C35": "GLAGOLITIC SMALL LETTER YESTU",
    "2C36": "GLAGOLITIC SMALL LETTER ZHIVETE",
    "2C37": "GLAGOLITIC SMALL LETTER DZELO",
    "2C38": "GLAGOLITIC SMALL LETTER ZEMLJA",
    "2C39": "GLAGOLITIC SMALL LETTER IZHE",
    "2C3A": "GLAGOLITIC SMALL LETTER INITIAL IZHE",
    "2C3B": "GLAGOLITIC SMALL LETTER I",
    "2C3C": "GLAGOLITIC SMALL LETTER DJERVI",
    "2C3D": "GLAGOLITIC SMALL LETTER KAKO",
    "2C3E": "GLAGOLITIC SMALL LETTER LJUDIJE",
    "2C3F": "GLAGOLITIC SMALL LETTER MYSLITE",
    "2C40": "GLAGOLITIC SMALL LETTER NASHI",
    "2C41": "GLAGOLITIC SMALL LETTER ONU",
    "2C42": "GLAGOLITIC SMALL LETTER POKOJI",
    "2C43": "GLAGOLITIC SMALL LETTER RITSI",
    "2C44": "GLAGOLITIC SMALL LETTER SLOVO",
    "2C45": "GLAGOLITIC SMALL LETTER TVRIDO",
    "2C46": "GLAGOLITIC SMALL LETTER UKU",
    "2C47": "GLAGOLITIC SMALL LETTER FRITU",
    "2C48": "GLAGOLITIC SMALL LETTER HERU",
    "2C49": "GLAGOLITIC SMALL LETTER OTU",
    "2C4A": "GLAGOLITIC SMALL LETTER PE",
    "2C4B": "GLAGOLITIC SMALL LETTER SHTA",
    "2C4C": "GLAGOLITIC SMALL LETTER TSI",
    "2C4D": "GLAGOLITIC SMALL LETTER CHRIVI",
    "2C4E": "GLAGOLITIC SMALL LETTER SHA",
    "2C4F": "GLAGOLITIC SMALL LETTER YERU",
    "2C50": "GLAGOLITIC SMALL LETTER YERI",
    "2C51": "GLAGOLITIC SMALL LETTER YATI",
    "2C52": "GLAGOLITIC SMALL LETTER SPIDERY HA",
    "2C53": "GLAGOLITIC SMALL LETTER YU",
    "2C54": "GLAGOLITIC SMALL LETTER SMALL YUS",
    "2C55": "GLAGOLITIC SMALL LETTER SMALL YUS WITH TAIL",
    "2C56": "GLAGOLITIC SMALL LETTER YO",
    "2C57": "GLAGOLITIC SMALL LETTER IOTATED SMALL YUS",
    "2C58": "GLAGOLITIC SMALL LETTER BIG YUS",
    "2C59": "GLAGOLITIC SMALL LETTER IOTATED BIG YUS",
    "2C5A": "GLAGOLITIC SMALL LETTER FITA",
    "2C5B": "GLAGOLITIC SMALL LETTER IZHITSA",
    "2C5C": "GLAGOLITIC SMALL LETTER SHTAPIC",
    "2C5D": "GLAGOLITIC SMALL LETTER TROKUTASTI A",
    "2C5E": "GLAGOLITIC SMALL LETTER LATINATE MYSLITE",
    "2C60": "LATIN CAPITAL LETTER L WITH DOUBLE BAR",
    "2C61": "LATIN SMALL LETTER L WITH DOUBLE BAR",
    "2C62": "LATIN CAPITAL LETTER L WITH MIDDLE TILDE",
    "2C63": "LATIN CAPITAL LETTER P WITH STROKE",
    "2C64": "LATIN CAPITAL LETTER R WITH TAIL",
    "2C65": "LATIN SMALL LETTER A WITH STROKE",
    "2C66": "LATIN SMALL LETTER T WITH DIAGONAL STROKE",
    "2C67": "LATIN CAPITAL LETTER H WITH DESCENDER",
    "2C68": "LATIN SMALL LETTER H WITH DESCENDER",
    "2C69": "LATIN CAPITAL LETTER K WITH DESCENDER",
    "2C6A": "LATIN SMALL LETTER K WITH DESCENDER",
    "2C6B": "LATIN CAPITAL LETTER Z WITH DESCENDER",
    "2C6C": "LATIN SMALL LETTER Z WITH DESCENDER",
    "2C6D": "LATIN CAPITAL LETTER ALPHA",
    "2C6E": "LATIN CAPITAL LETTER M WITH HOOK",
    "2C6F": "LATIN CAPITAL LETTER TURNED A",
    "2C70": "LATIN CAPITAL LETTER TURNED ALPHA",
    "2C71": "LATIN SMALL LETTER V WITH RIGHT HOOK",
    "2C72": "LATIN CAPITAL LETTER W WITH HOOK",
    "2C73": "LATIN SMALL LETTER W WITH HOOK",
    "2C74": "LATIN SMALL LETTER V WITH CURL",
    "2C75": "LATIN CAPITAL LETTER HALF H",
    "2C76": "LATIN SMALL LETTER HALF H",
    "2C77": "LATIN SMALL LETTER TAILLESS PHI",
    "2C78": "LATIN SMALL LETTER E WITH NOTCH",
    "2C79": "LATIN SMALL LETTER TURNED R WITH TAIL",
    "2C7A": "LATIN SMALL LETTER O WITH LOW RING INSIDE",
    "2C7B": "LATIN LETTER SMALL CAPITAL TURNED E",
    "2C7C": "LATIN SUBSCRIPT SMALL LETTER J",
    "2C7D": "MODIFIER LETTER CAPITAL V",
    "2C7E": "LATIN CAPITAL LETTER S WITH SWASH TAIL",
    "2C7F": "LATIN CAPITAL LETTER Z WITH SWASH TAIL",
    "2C80": "COPTIC CAPITAL LETTER ALFA",
    "2C81": "COPTIC SMALL LETTER ALFA",
    "2C82": "COPTIC CAPITAL LETTER VIDA",
    "2C83": "COPTIC SMALL LETTER VIDA",
    "2C84": "COPTIC CAPITAL LETTER GAMMA",
    "2C85": "COPTIC SMALL LETTER GAMMA",
    "2C86": "COPTIC CAPITAL LETTER DALDA",
    "2C87": "COPTIC SMALL LETTER DALDA",
    "2C88": "COPTIC CAPITAL LETTER EIE",
    "2C89": "COPTIC SMALL LETTER EIE",
    "2C8A": "COPTIC CAPITAL LETTER SOU",
    "2C8B": "COPTIC SMALL LETTER SOU",
    "2C8C": "COPTIC CAPITAL LETTER ZATA",
    "2C8D": "COPTIC SMALL LETTER ZATA",
    "2C8E": "COPTIC CAPITAL LETTER HATE",
    "2C8F": "COPTIC SMALL LETTER HATE",
    "2C90": "COPTIC CAPITAL LETTER THETHE",
    "2C91": "COPTIC SMALL LETTER THETHE",
    "2C92": "COPTIC CAPITAL LETTER IAUDA",
    "2C93": "COPTIC SMALL LETTER IAUDA",
    "2C94": "COPTIC CAPITAL LETTER KAPA",
    "2C95": "COPTIC SMALL LETTER KAPA",
    "2C96": "COPTIC CAPITAL LETTER LAULA",
    "2C97": "COPTIC SMALL LETTER LAULA",
    "2C98": "COPTIC CAPITAL LETTER MI",
    "2C99": "COPTIC SMALL LETTER MI",
    "2C9A": "COPTIC CAPITAL LETTER NI",
    "2C9B": "COPTIC SMALL LETTER NI",
    "2C9C": "COPTIC CAPITAL LETTER KSI",
    "2C9D": "COPTIC SMALL LETTER KSI",
    "2C9E": "COPTIC CAPITAL LETTER O",
    "2C9F": "COPTIC SMALL LETTER O",
    "2CA0": "COPTIC CAPITAL LETTER PI",
    "2CA1": "COPTIC SMALL LETTER PI",
    "2CA2": "COPTIC CAPITAL LETTER RO",
    "2CA3": "COPTIC SMALL LETTER RO",
    "2CA4": "COPTIC CAPITAL LETTER SIMA",
    "2CA5": "COPTIC SMALL LETTER SIMA",
    "2CA6": "COPTIC CAPITAL LETTER TAU",
    "2CA7": "COPTIC SMALL LETTER TAU",
    "2CA8": "COPTIC CAPITAL LETTER UA",
    "2CA9": "COPTIC SMALL LETTER UA",
    "2CAA": "COPTIC CAPITAL LETTER FI",
    "2CAB": "COPTIC SMALL LETTER FI",
    "2CAC": "COPTIC CAPITAL LETTER KHI",
    "2CAD": "COPTIC SMALL LETTER KHI",
    "2CAE": "COPTIC CAPITAL LETTER PSI",
    "2CAF": "COPTIC SMALL LETTER PSI",
    "2CB0": "COPTIC CAPITAL LETTER OOU",
    "2CB1": "COPTIC SMALL LETTER OOU",
    "2CB2": "COPTIC CAPITAL LETTER DIALECT-P ALEF",
    "2CB3": "COPTIC SMALL LETTER DIALECT-P ALEF",
    "2CB4": "COPTIC CAPITAL LETTER OLD COPTIC AIN",
    "2CB5": "COPTIC SMALL LETTER OLD COPTIC AIN",
    "2CB6": "COPTIC CAPITAL LETTER CRYPTOGRAMMIC EIE",
    "2CB7": "COPTIC SMALL LETTER CRYPTOGRAMMIC EIE",
    "2CB8": "COPTIC CAPITAL LETTER DIALECT-P KAPA",
    "2CB9": "COPTIC SMALL LETTER DIALECT-P KAPA",
    "2CBA": "COPTIC CAPITAL LETTER DIALECT-P NI",
    "2CBB": "COPTIC SMALL LETTER DIALECT-P NI",
    "2CBC": "COPTIC CAPITAL LETTER CRYPTOGRAMMIC NI",
    "2CBD": "COPTIC SMALL LETTER CRYPTOGRAMMIC NI",
    "2CBE": "COPTIC CAPITAL LETTER OLD COPTIC OOU",
    "2CBF": "COPTIC SMALL LETTER OLD COPTIC OOU",
    "2CC0": "COPTIC CAPITAL LETTER SAMPI",
    "2CC1": "COPTIC SMALL LETTER SAMPI",
    "2CC2": "COPTIC CAPITAL LETTER CROSSED SHEI",
    "2CC3": "COPTIC SMALL LETTER CROSSED SHEI",
    "2CC4": "COPTIC CAPITAL LETTER OLD COPTIC SHEI",
    "2CC5": "COPTIC SMALL LETTER OLD COPTIC SHEI",
    "2CC6": "COPTIC CAPITAL LETTER OLD COPTIC ESH",
    "2CC7": "COPTIC SMALL LETTER OLD COPTIC ESH",
    "2CC8": "COPTIC CAPITAL LETTER AKHMIMIC KHEI",
    "2CC9": "COPTIC SMALL LETTER AKHMIMIC KHEI",
    "2CCA": "COPTIC CAPITAL LETTER DIALECT-P HORI",
    "2CCB": "COPTIC SMALL LETTER DIALECT-P HORI",
    "2CCC": "COPTIC CAPITAL LETTER OLD COPTIC HORI",
    "2CCD": "COPTIC SMALL LETTER OLD COPTIC HORI",
    "2CCE": "COPTIC CAPITAL LETTER OLD COPTIC HA",
    "2CCF": "COPTIC SMALL LETTER OLD COPTIC HA",
    "2CD0": "COPTIC CAPITAL LETTER L-SHAPED HA",
    "2CD1": "COPTIC SMALL LETTER L-SHAPED HA",
    "2CD2": "COPTIC CAPITAL LETTER OLD COPTIC HEI",
    "2CD3": "COPTIC SMALL LETTER OLD COPTIC HEI",
    "2CD4": "COPTIC CAPITAL LETTER OLD COPTIC HAT",
    "2CD5": "COPTIC SMALL LETTER OLD COPTIC HAT",
    "2CD6": "COPTIC CAPITAL LETTER OLD COPTIC GANGIA",
    "2CD7": "COPTIC SMALL LETTER OLD COPTIC GANGIA",
    "2CD8": "COPTIC CAPITAL LETTER OLD COPTIC DJA",
    "2CD9": "COPTIC SMALL LETTER OLD COPTIC DJA",
    "2CDA": "COPTIC CAPITAL LETTER OLD COPTIC SHIMA",
    "2CDB": "COPTIC SMALL LETTER OLD COPTIC SHIMA",
    "2CDC": "COPTIC CAPITAL LETTER OLD NUBIAN SHIMA",
    "2CDD": "COPTIC SMALL LETTER OLD NUBIAN SHIMA",
    "2CDE": "COPTIC CAPITAL LETTER OLD NUBIAN NGI",
    "2CDF": "COPTIC SMALL LETTER OLD NUBIAN NGI",
    "2CE0": "COPTIC CAPITAL LETTER OLD NUBIAN NYI",
    "2CE1": "COPTIC SMALL LETTER OLD NUBIAN NYI",
    "2CE2": "COPTIC CAPITAL LETTER OLD NUBIAN WAU",
    "2CE3": "COPTIC SMALL LETTER OLD NUBIAN WAU",
    "2CE4": "COPTIC SYMBOL KAI",
    "2CE5": "COPTIC SYMBOL MI RO",
    "2CE6": "COPTIC SYMBOL PI RO",
    "2CE7": "COPTIC SYMBOL STAUROS",
    "2CE8": "COPTIC SYMBOL TAU RO",
    "2CE9": "COPTIC SYMBOL KHI RO",
    "2CEA": "COPTIC SYMBOL SHIMA SIMA",
    "2CEB": "COPTIC CAPITAL LETTER CRYPTOGRAMMIC SHEI",
    "2CEC": "COPTIC SMALL LETTER CRYPTOGRAMMIC SHEI",
    "2CED": "COPTIC CAPITAL LETTER CRYPTOGRAMMIC GANGIA",
    "2CEE": "COPTIC SMALL LETTER CRYPTOGRAMMIC GANGIA",
    "2CEF": "COPTIC COMBINING NI ABOVE",
    "2CF0": "COPTIC COMBINING SPIRITUS ASPER",
    "2CF1": "COPTIC COMBINING SPIRITUS LENIS",
    "2CF2": "COPTIC CAPITAL LETTER BOHAIRIC KHEI",
    "2CF3": "COPTIC SMALL LETTER BOHAIRIC KHEI",
    "2CF9": "COPTIC OLD NUBIAN FULL STOP",
    "2CFA": "COPTIC OLD NUBIAN DIRECT QUESTION MARK",
    "2CFB": "COPTIC OLD NUBIAN INDIRECT QUESTION MARK",
    "2CFC": "COPTIC OLD NUBIAN VERSE DIVIDER",
    "2CFD": "COPTIC FRACTION ONE HALF",
    "2CFE": "COPTIC FULL STOP",
    "2CFF": "COPTIC MORPHOLOGICAL DIVIDER",
    "2D00": "GEORGIAN SMALL LETTER AN",
    "2D01": "GEORGIAN SMALL LETTER BAN",
    "2D02": "GEORGIAN SMALL LETTER GAN",
    "2D03": "GEORGIAN SMALL LETTER DON",
    "2D04": "GEORGIAN SMALL LETTER EN",
    "2D05": "GEORGIAN SMALL LETTER VIN",
    "2D06": "GEORGIAN SMALL LETTER ZEN",
    "2D07": "GEORGIAN SMALL LETTER TAN",
    "2D08": "GEORGIAN SMALL LETTER IN",
    "2D09": "GEORGIAN SMALL LETTER KAN",
    "2D0A": "GEORGIAN SMALL LETTER LAS",
    "2D0B": "GEORGIAN SMALL LETTER MAN",
    "2D0C": "GEORGIAN SMALL LETTER NAR",
    "2D0D": "GEORGIAN SMALL LETTER ON",
    "2D0E": "GEORGIAN SMALL LETTER PAR",
    "2D0F": "GEORGIAN SMALL LETTER ZHAR",
    "2D10": "GEORGIAN SMALL LETTER RAE",
    "2D11": "GEORGIAN SMALL LETTER SAN",
    "2D12": "GEORGIAN SMALL LETTER TAR",
    "2D13": "GEORGIAN SMALL LETTER UN",
    "2D14": "GEORGIAN SMALL LETTER PHAR",
    "2D15": "GEORGIAN SMALL LETTER KHAR",
    "2D16": "GEORGIAN SMALL LETTER GHAN",
    "2D17": "GEORGIAN SMALL LETTER QAR",
    "2D18": "GEORGIAN SMALL LETTER SHIN",
    "2D19": "GEORGIAN SMALL LETTER CHIN",
    "2D1A": "GEORGIAN SMALL LETTER CAN",
    "2D1B": "GEORGIAN SMALL LETTER JIL",
    "2D1C": "GEORGIAN SMALL LETTER CIL",
    "2D1D": "GEORGIAN SMALL LETTER CHAR",
    "2D1E": "GEORGIAN SMALL LETTER XAN",
    "2D1F": "GEORGIAN SMALL LETTER JHAN",
    "2D20": "GEORGIAN SMALL LETTER HAE",
    "2D21": "GEORGIAN SMALL LETTER HE",
    "2D22": "GEORGIAN SMALL LETTER HIE",
    "2D23": "GEORGIAN SMALL LETTER WE",
    "2D24": "GEORGIAN SMALL LETTER HAR",
    "2D25": "GEORGIAN SMALL LETTER HOE",
    "2D27": "GEORGIAN SMALL LETTER YN",
    "2D2D": "GEORGIAN SMALL LETTER AEN",
    "2D30": "TIFINAGH LETTER YA",
    "2D31": "TIFINAGH LETTER YAB",
    "2D32": "TIFINAGH LETTER YABH",
    "2D33": "TIFINAGH LETTER YAG",
    "2D34": "TIFINAGH LETTER YAGHH",
    "2D35": "TIFINAGH LETTER BERBER ACADEMY YAJ",
    "2D36": "TIFINAGH LETTER YAJ",
    "2D37": "TIFINAGH LETTER YAD",
    "2D38": "TIFINAGH LETTER YADH",
    "2D39": "TIFINAGH LETTER YADD",
    "2D3A": "TIFINAGH LETTER YADDH",
    "2D3B": "TIFINAGH LETTER YEY",
    "2D3C": "TIFINAGH LETTER YAF",
    "2D3D": "TIFINAGH LETTER YAK",
    "2D3E": "TIFINAGH LETTER TUAREG YAK",
    "2D3F": "TIFINAGH LETTER YAKHH",
    "2D40": "TIFINAGH LETTER YAH",
    "2D41": "TIFINAGH LETTER BERBER ACADEMY YAH",
    "2D42": "TIFINAGH LETTER TUAREG YAH",
    "2D43": "TIFINAGH LETTER YAHH",
    "2D44": "TIFINAGH LETTER YAA",
    "2D45": "TIFINAGH LETTER YAKH",
    "2D46": "TIFINAGH LETTER TUAREG YAKH",
    "2D47": "TIFINAGH LETTER YAQ",
    "2D48": "TIFINAGH LETTER TUAREG YAQ",
    "2D49": "TIFINAGH LETTER YI",
    "2D4A": "TIFINAGH LETTER YAZH",
    "2D4B": "TIFINAGH LETTER AHAGGAR YAZH",
    "2D4C": "TIFINAGH LETTER TUAREG YAZH",
    "2D4D": "TIFINAGH LETTER YAL",
    "2D4E": "TIFINAGH LETTER YAM",
    "2D4F": "TIFINAGH LETTER YAN",
    "2D50": "TIFINAGH LETTER TUAREG YAGN",
    "2D51": "TIFINAGH LETTER TUAREG YANG",
    "2D52": "TIFINAGH LETTER YAP",
    "2D53": "TIFINAGH LETTER YU",
    "2D54": "TIFINAGH LETTER YAR",
    "2D55": "TIFINAGH LETTER YARR",
    "2D56": "TIFINAGH LETTER YAGH",
    "2D57": "TIFINAGH LETTER TUAREG YAGH",
    "2D58": "TIFINAGH LETTER AYER YAGH",
    "2D59": "TIFINAGH LETTER YAS",
    "2D5A": "TIFINAGH LETTER YASS",
    "2D5B": "TIFINAGH LETTER YASH",
    "2D5C": "TIFINAGH LETTER YAT",
    "2D5D": "TIFINAGH LETTER YATH",
    "2D5E": "TIFINAGH LETTER YACH",
    "2D5F": "TIFINAGH LETTER YATT",
    "2D60": "TIFINAGH LETTER YAV",
    "2D61": "TIFINAGH LETTER YAW",
    "2D62": "TIFINAGH LETTER YAY",
    "2D63": "TIFINAGH LETTER YAZ",
    "2D64": "TIFINAGH LETTER TAWELLEMET YAZ",
    "2D65": "TIFINAGH LETTER YAZZ",
    "2D66": "TIFINAGH LETTER YE",
    "2D67": "TIFINAGH LETTER YO",
    "2D6F": "TIFINAGH MODIFIER LETTER LABIALIZATION MARK",
    "2D70": "TIFINAGH SEPARATOR MARK",
    "2D7F": "TIFINAGH CONSONANT JOINER",
    "2D80": "ETHIOPIC SYLLABLE LOA",
    "2D81": "ETHIOPIC SYLLABLE MOA",
    "2D82": "ETHIOPIC SYLLABLE ROA",
    "2D83": "ETHIOPIC SYLLABLE SOA",
    "2D84": "ETHIOPIC SYLLABLE SHOA",
    "2D85": "ETHIOPIC SYLLABLE BOA",
    "2D86": "ETHIOPIC SYLLABLE TOA",
    "2D87": "ETHIOPIC SYLLABLE COA",
    "2D88": "ETHIOPIC SYLLABLE NOA",
    "2D89": "ETHIOPIC SYLLABLE NYOA",
    "2D8A": "ETHIOPIC SYLLABLE GLOTTAL OA",
    "2D8B": "ETHIOPIC SYLLABLE ZOA",
    "2D8C": "ETHIOPIC SYLLABLE DOA",
    "2D8D": "ETHIOPIC SYLLABLE DDOA",
    "2D8E": "ETHIOPIC SYLLABLE JOA",
    "2D8F": "ETHIOPIC SYLLABLE THOA",
    "2D90": "ETHIOPIC SYLLABLE CHOA",
    "2D91": "ETHIOPIC SYLLABLE PHOA",
    "2D92": "ETHIOPIC SYLLABLE POA",
    "2D93": "ETHIOPIC SYLLABLE GGWA",
    "2D94": "ETHIOPIC SYLLABLE GGWI",
    "2D95": "ETHIOPIC SYLLABLE GGWEE",
    "2D96": "ETHIOPIC SYLLABLE GGWE",
    "2DA0": "ETHIOPIC SYLLABLE SSA",
    "2DA1": "ETHIOPIC SYLLABLE SSU",
    "2DA2": "ETHIOPIC SYLLABLE SSI",
    "2DA3": "ETHIOPIC SYLLABLE SSAA",
    "2DA4": "ETHIOPIC SYLLABLE SSEE",
    "2DA5": "ETHIOPIC SYLLABLE SSE",
    "2DA6": "ETHIOPIC SYLLABLE SSO",
    "2DA8": "ETHIOPIC SYLLABLE CCA",
    "2DA9": "ETHIOPIC SYLLABLE CCU",
    "2DAA": "ETHIOPIC SYLLABLE CCI",
    "2DAB": "ETHIOPIC SYLLABLE CCAA",
    "2DAC": "ETHIOPIC SYLLABLE CCEE",
    "2DAD": "ETHIOPIC SYLLABLE CCE",
    "2DAE": "ETHIOPIC SYLLABLE CCO",
    "2DB0": "ETHIOPIC SYLLABLE ZZA",
    "2DB1": "ETHIOPIC SYLLABLE ZZU",
    "2DB2": "ETHIOPIC SYLLABLE ZZI",
    "2DB3": "ETHIOPIC SYLLABLE ZZAA",
    "2DB4": "ETHIOPIC SYLLABLE ZZEE",
    "2DB5": "ETHIOPIC SYLLABLE ZZE",
    "2DB6": "ETHIOPIC SYLLABLE ZZO",
    "2DB8": "ETHIOPIC SYLLABLE CCHA",
    "2DB9": "ETHIOPIC SYLLABLE CCHU",
    "2DBA": "ETHIOPIC SYLLABLE CCHI",
    "2DBB": "ETHIOPIC SYLLABLE CCHAA",
    "2DBC": "ETHIOPIC SYLLABLE CCHEE",
    "2DBD": "ETHIOPIC SYLLABLE CCHE",
    "2DBE": "ETHIOPIC SYLLABLE CCHO",
    "2DC0": "ETHIOPIC SYLLABLE QYA",
    "2DC1": "ETHIOPIC SYLLABLE QYU",
    "2DC2": "ETHIOPIC SYLLABLE QYI",
    "2DC3": "ETHIOPIC SYLLABLE QYAA",
    "2DC4": "ETHIOPIC SYLLABLE QYEE",
    "2DC5": "ETHIOPIC SYLLABLE QYE",
    "2DC6": "ETHIOPIC SYLLABLE QYO",
    "2DC8": "ETHIOPIC SYLLABLE KYA",
    "2DC9": "ETHIOPIC SYLLABLE KYU",
    "2DCA": "ETHIOPIC SYLLABLE KYI",
    "2DCB": "ETHIOPIC SYLLABLE KYAA",
    "2DCC": "ETHIOPIC SYLLABLE KYEE",
    "2DCD": "ETHIOPIC SYLLABLE KYE",
    "2DCE": "ETHIOPIC SYLLABLE KYO",
    "2DD0": "ETHIOPIC SYLLABLE XYA",
    "2DD1": "ETHIOPIC SYLLABLE XYU",
    "2DD2": "ETHIOPIC SYLLABLE XYI",
    "2DD3": "ETHIOPIC SYLLABLE XYAA",
    "2DD4": "ETHIOPIC SYLLABLE XYEE",
    "2DD5": "ETHIOPIC SYLLABLE XYE",
    "2DD6": "ETHIOPIC SYLLABLE XYO",
    "2DD8": "ETHIOPIC SYLLABLE GYA",
    "2DD9": "ETHIOPIC SYLLABLE GYU",
    "2DDA": "ETHIOPIC SYLLABLE GYI",
    "2DDB": "ETHIOPIC SYLLABLE GYAA",
    "2DDC": "ETHIOPIC SYLLABLE GYEE",
    "2DDD": "ETHIOPIC SYLLABLE GYE",
    "2DDE": "ETHIOPIC SYLLABLE GYO",
    "2DE0": "COMBINING CYRILLIC LETTER BE",
    "2DE1": "COMBINING CYRILLIC LETTER VE",
    "2DE2": "COMBINING CYRILLIC LETTER GHE",
    "2DE3": "COMBINING CYRILLIC LETTER DE",
    "2DE4": "COMBINING CYRILLIC LETTER ZHE",
    "2DE5": "COMBINING CYRILLIC LETTER ZE",
    "2DE6": "COMBINING CYRILLIC LETTER KA",
    "2DE7": "COMBINING CYRILLIC LETTER EL",
    "2DE8": "COMBINING CYRILLIC LETTER EM",
    "2DE9": "COMBINING CYRILLIC LETTER EN",
    "2DEA": "COMBINING CYRILLIC LETTER O",
    "2DEB": "COMBINING CYRILLIC LETTER PE",
    "2DEC": "COMBINING CYRILLIC LETTER ER",
    "2DED": "COMBINING CYRILLIC LETTER ES",
    "2DEE": "COMBINING CYRILLIC LETTER TE",
    "2DEF": "COMBINING CYRILLIC LETTER HA",
    "2DF0": "COMBINING CYRILLIC LETTER TSE",
    "2DF1": "COMBINING CYRILLIC LETTER CHE",
    "2DF2": "COMBINING CYRILLIC LETTER SHA",
    "2DF3": "COMBINING CYRILLIC LETTER SHCHA",
    "2DF4": "COMBINING CYRILLIC LETTER FITA",
    "2DF5": "COMBINING CYRILLIC LETTER ES-TE",
    "2DF6": "COMBINING CYRILLIC LETTER A",
    "2DF7": "COMBINING CYRILLIC LETTER IE",
    "2DF8": "COMBINING CYRILLIC LETTER DJERV",
    "2DF9": "COMBINING CYRILLIC LETTER MONOGRAPH UK",
    "2DFA": "COMBINING CYRILLIC LETTER YAT",
    "2DFB": "COMBINING CYRILLIC LETTER YU",
    "2DFC": "COMBINING CYRILLIC LETTER IOTIFIED A",
    "2DFD": "COMBINING CYRILLIC LETTER LITTLE YUS",
    "2DFE": "COMBINING CYRILLIC LETTER BIG YUS",
    "2DFF": "COMBINING CYRILLIC LETTER IOTIFIED BIG YUS",
    "2E00": "RIGHT ANGLE SUBSTITUTION MARKER",
    "2E01": "RIGHT ANGLE DOTTED SUBSTITUTION MARKER",
    "2E02": "LEFT SUBSTITUTION BRACKET",
    "2E03": "RIGHT SUBSTITUTION BRACKET",
    "2E04": "LEFT DOTTED SUBSTITUTION BRACKET",
    "2E05": "RIGHT DOTTED SUBSTITUTION BRACKET",
    "2E06": "RAISED INTERPOLATION MARKER",
    "2E07": "RAISED DOTTED INTERPOLATION MARKER",
    "2E08": "DOTTED TRANSPOSITION MARKER",
    "2E09": "LEFT TRANSPOSITION BRACKET",
    "2E0A": "RIGHT TRANSPOSITION BRACKET",
    "2E0B": "RAISED SQUARE",
    "2E0C": "LEFT RAISED OMISSION BRACKET",
    "2E0D": "RIGHT RAISED OMISSION BRACKET",
    "2E0E": "EDITORIAL CORONIS",
    "2E0F": "PARAGRAPHOS",
    "2E10": "FORKED PARAGRAPHOS",
    "2E11": "REVERSED FORKED PARAGRAPHOS",
    "2E12": "HYPODIASTOLE",
    "2E13": "DOTTED OBELOS",
    "2E14": "DOWNWARDS ANCORA",
    "2E15": "UPWARDS ANCORA",
    "2E16": "DOTTED RIGHT-POINTING ANGLE",
    "2E17": "DOUBLE OBLIQUE HYPHEN",
    "2E18": "INVERTED INTERROBANG",
    "2E19": "PALM BRANCH",
    "2E1A": "HYPHEN WITH DIAERESIS",
    "2E1B": "TILDE WITH RING ABOVE",
    "2E1C": "LEFT LOW PARAPHRASE BRACKET",
    "2E1D": "RIGHT LOW PARAPHRASE BRACKET",
    "2E1E": "TILDE WITH DOT ABOVE",
    "2E1F": "TILDE WITH DOT BELOW",
    "2E20": "LEFT VERTICAL BAR WITH QUILL",
    "2E21": "RIGHT VERTICAL BAR WITH QUILL",
    "2E22": "TOP LEFT HALF BRACKET",
    "2E23": "TOP RIGHT HALF BRACKET",
    "2E24": "BOTTOM LEFT HALF BRACKET",
    "2E25": "BOTTOM RIGHT HALF BRACKET",
    "2E26": "LEFT SIDEWAYS U BRACKET",
    "2E27": "RIGHT SIDEWAYS U BRACKET",
    "2E28": "LEFT DOUBLE PARENTHESIS",
    "2E29": "RIGHT DOUBLE PARENTHESIS",
    "2E2A": "TWO DOTS OVER ONE DOT PUNCTUATION",
    "2E2B": "ONE DOT OVER TWO DOTS PUNCTUATION",
    "2E2C": "SQUARED FOUR DOT PUNCTUATION",
    "2E2D": "FIVE DOT MARK",
    "2E2E": "REVERSED QUESTION MARK",
    "2E2F": "VERTICAL TILDE",
    "2E30": "RING POINT",
    "2E31": "WORD SEPARATOR MIDDLE DOT",
    "2E32": "TURNED COMMA",
    "2E33": "RAISED DOT",
    "2E34": "RAISED COMMA",
    "2E35": "TURNED SEMICOLON",
    "2E36": "DAGGER WITH LEFT GUARD",
    "2E37": "DAGGER WITH RIGHT GUARD",
    "2E38": "TURNED DAGGER",
    "2E39": "TOP HALF SECTION SIGN",
    "2E3A": "TWO-EM DASH",
    "2E3B": "THREE-EM DASH",
    "2E3C": "STENOGRAPHIC FULL STOP",
    "2E3D": "VERTICAL SIX DOTS",
    "2E3E": "WIGGLY VERTICAL LINE",
    "2E3F": "CAPITULUM",
    "2E40": "DOUBLE HYPHEN",
    "2E41": "REVERSED COMMA",
    "2E42": "DOUBLE LOW-REVERSED-9 QUOTATION MARK",
    "2E43": "DASH WITH LEFT UPTURN",
    "2E44": "DOUBLE SUSPENSION MARK",
    "2E80": "CJK RADICAL REPEAT",
    "2E81": "CJK RADICAL CLIFF",
    "2E82": "CJK RADICAL SECOND ONE",
    "2E83": "CJK RADICAL SECOND TWO",
    "2E84": "CJK RADICAL SECOND THREE",
    "2E85": "CJK RADICAL PERSON",
    "2E86": "CJK RADICAL BOX",
    "2E87": "CJK RADICAL TABLE",
    "2E88": "CJK RADICAL KNIFE ONE",
    "2E89": "CJK RADICAL KNIFE TWO",
    "2E8A": "CJK RADICAL DIVINATION",
    "2E8B": "CJK RADICAL SEAL",
    "2E8C": "CJK RADICAL SMALL ONE",
    "2E8D": "CJK RADICAL SMALL TWO",
    "2E8E": "CJK RADICAL LAME ONE",
    "2E8F": "CJK RADICAL LAME TWO",
    "2E90": "CJK RADICAL LAME THREE",
    "2E91": "CJK RADICAL LAME FOUR",
    "2E92": "CJK RADICAL SNAKE",
    "2E93": "CJK RADICAL THREAD",
    "2E94": "CJK RADICAL SNOUT ONE",
    "2E95": "CJK RADICAL SNOUT TWO",
    "2E96": "CJK RADICAL HEART ONE",
    "2E97": "CJK RADICAL HEART TWO",
    "2E98": "CJK RADICAL HAND",
    "2E99": "CJK RADICAL RAP",
    "2E9B": "CJK RADICAL CHOKE",
    "2E9C": "CJK RADICAL SUN",
    "2E9D": "CJK RADICAL MOON",
    "2E9E": "CJK RADICAL DEATH",
    "2E9F": "CJK RADICAL MOTHER",
    "2EA0": "CJK RADICAL CIVILIAN",
    "2EA1": "CJK RADICAL WATER ONE",
    "2EA2": "CJK RADICAL WATER TWO",
    "2EA3": "CJK RADICAL FIRE",
    "2EA4": "CJK RADICAL PAW ONE",
    "2EA5": "CJK RADICAL PAW TWO",
    "2EA6": "CJK RADICAL SIMPLIFIED HALF TREE TRUNK",
    "2EA7": "CJK RADICAL COW",
    "2EA8": "CJK RADICAL DOG",
    "2EA9": "CJK RADICAL JADE",
    "2EAA": "CJK RADICAL BOLT OF CLOTH",
    "2EAB": "CJK RADICAL EYE",
    "2EAC": "CJK RADICAL SPIRIT ONE",
    "2EAD": "CJK RADICAL SPIRIT TWO",
    "2EAE": "CJK RADICAL BAMBOO",
    "2EAF": "CJK RADICAL SILK",
    "2EB0": "CJK RADICAL C-SIMPLIFIED SILK",
    "2EB1": "CJK RADICAL NET ONE",
    "2EB2": "CJK RADICAL NET TWO",
    "2EB3": "CJK RADICAL NET THREE",
    "2EB4": "CJK RADICAL NET FOUR",
    "2EB5": "CJK RADICAL MESH",
    "2EB6": "CJK RADICAL SHEEP",
    "2EB7": "CJK RADICAL RAM",
    "2EB8": "CJK RADICAL EWE",
    "2EB9": "CJK RADICAL OLD",
    "2EBA": "CJK RADICAL BRUSH ONE",
    "2EBB": "CJK RADICAL BRUSH TWO",
    "2EBC": "CJK RADICAL MEAT",
    "2EBD": "CJK RADICAL MORTAR",
    "2EBE": "CJK RADICAL GRASS ONE",
    "2EBF": "CJK RADICAL GRASS TWO",
    "2EC0": "CJK RADICAL GRASS THREE",
    "2EC1": "CJK RADICAL TIGER",
    "2EC2": "CJK RADICAL CLOTHES",
    "2EC3": "CJK RADICAL WEST ONE",
    "2EC4": "CJK RADICAL WEST TWO",
    "2EC5": "CJK RADICAL C-SIMPLIFIED SEE",
    "2EC6": "CJK RADICAL SIMPLIFIED HORN",
    "2EC7": "CJK RADICAL HORN",
    "2EC8": "CJK RADICAL C-SIMPLIFIED SPEECH",
    "2EC9": "CJK RADICAL C-SIMPLIFIED SHELL",
    "2ECA": "CJK RADICAL FOOT",
    "2ECB": "CJK RADICAL C-SIMPLIFIED CART",
    "2ECC": "CJK RADICAL SIMPLIFIED WALK",
    "2ECD": "CJK RADICAL WALK ONE",
    "2ECE": "CJK RADICAL WALK TWO",
    "2ECF": "CJK RADICAL CITY",
    "2ED0": "CJK RADICAL C-SIMPLIFIED GOLD",
    "2ED1": "CJK RADICAL LONG ONE",
    "2ED2": "CJK RADICAL LONG TWO",
    "2ED3": "CJK RADICAL C-SIMPLIFIED LONG",
    "2ED4": "CJK RADICAL C-SIMPLIFIED GATE",
    "2ED5": "CJK RADICAL MOUND ONE",
    "2ED6": "CJK RADICAL MOUND TWO",
    "2ED7": "CJK RADICAL RAIN",
    "2ED8": "CJK RADICAL BLUE",
    "2ED9": "CJK RADICAL C-SIMPLIFIED TANNED LEATHER",
    "2EDA": "CJK RADICAL C-SIMPLIFIED LEAF",
    "2EDB": "CJK RADICAL C-SIMPLIFIED WIND",
    "2EDC": "CJK RADICAL C-SIMPLIFIED FLY",
    "2EDD": "CJK RADICAL EAT ONE",
    "2EDE": "CJK RADICAL EAT TWO",
    "2EDF": "CJK RADICAL EAT THREE",
    "2EE0": "CJK RADICAL C-SIMPLIFIED EAT",
    "2EE1": "CJK RADICAL HEAD",
    "2EE2": "CJK RADICAL C-SIMPLIFIED HORSE",
    "2EE3": "CJK RADICAL BONE",
    "2EE4": "CJK RADICAL GHOST",
    "2EE5": "CJK RADICAL C-SIMPLIFIED FISH",
    "2EE6": "CJK RADICAL C-SIMPLIFIED BIRD",
    "2EE7": "CJK RADICAL C-SIMPLIFIED SALT",
    "2EE8": "CJK RADICAL SIMPLIFIED WHEAT",
    "2EE9": "CJK RADICAL SIMPLIFIED YELLOW",
    "2EEA": "CJK RADICAL C-SIMPLIFIED FROG",
    "2EEB": "CJK RADICAL J-SIMPLIFIED EVEN",
    "2EEC": "CJK RADICAL C-SIMPLIFIED EVEN",
    "2EED": "CJK RADICAL J-SIMPLIFIED TOOTH",
    "2EEE": "CJK RADICAL C-SIMPLIFIED TOOTH",
    "2EEF": "CJK RADICAL J-SIMPLIFIED DRAGON",
    "2EF0": "CJK RADICAL C-SIMPLIFIED DRAGON",
    "2EF1": "CJK RADICAL TURTLE",
    "2EF2": "CJK RADICAL J-SIMPLIFIED TURTLE",
    "2EF3": "CJK RADICAL C-SIMPLIFIED TURTLE",
    "2F00": "KANGXI RADICAL ONE",
    "2F01": "KANGXI RADICAL LINE",
    "2F02": "KANGXI RADICAL DOT",
    "2F03": "KANGXI RADICAL SLASH",
    "2F04": "KANGXI RADICAL SECOND",
    "2F05": "KANGXI RADICAL HOOK",
    "2F06": "KANGXI RADICAL TWO",
    "2F07": "KANGXI RADICAL LID",
    "2F08": "KANGXI RADICAL MAN",
    "2F09": "KANGXI RADICAL LEGS",
    "2F0A": "KANGXI RADICAL ENTER",
    "2F0B": "KANGXI RADICAL EIGHT",
    "2F0C": "KANGXI RADICAL DOWN BOX",
    "2F0D": "KANGXI RADICAL COVER",
    "2F0E": "KANGXI RADICAL ICE",
    "2F0F": "KANGXI RADICAL TABLE",
    "2F10": "KANGXI RADICAL OPEN BOX",
    "2F11": "KANGXI RADICAL KNIFE",
    "2F12": "KANGXI RADICAL POWER",
    "2F13": "KANGXI RADICAL WRAP",
    "2F14": "KANGXI RADICAL SPOON",
    "2F15": "KANGXI RADICAL RIGHT OPEN BOX",
    "2F16": "KANGXI RADICAL HIDING ENCLOSURE",
    "2F17": "KANGXI RADICAL TEN",
    "2F18": "KANGXI RADICAL DIVINATION",
    "2F19": "KANGXI RADICAL SEAL",
    "2F1A": "KANGXI RADICAL CLIFF",
    "2F1B": "KANGXI RADICAL PRIVATE",
    "2F1C": "KANGXI RADICAL AGAIN",
    "2F1D": "KANGXI RADICAL MOUTH",
    "2F1E": "KANGXI RADICAL ENCLOSURE",
    "2F1F": "KANGXI RADICAL EARTH",
    "2F20": "KANGXI RADICAL SCHOLAR",
    "2F21": "KANGXI RADICAL GO",
    "2F22": "KANGXI RADICAL GO SLOWLY",
    "2F23": "KANGXI RADICAL EVENING",
    "2F24": "KANGXI RADICAL BIG",
    "2F25": "KANGXI RADICAL WOMAN",
    "2F26": "KANGXI RADICAL CHILD",
    "2F27": "KANGXI RADICAL ROOF",
    "2F28": "KANGXI RADICAL INCH",
    "2F29": "KANGXI RADICAL SMALL",
    "2F2A": "KANGXI RADICAL LAME",
    "2F2B": "KANGXI RADICAL CORPSE",
    "2F2C": "KANGXI RADICAL SPROUT",
    "2F2D": "KANGXI RADICAL MOUNTAIN",
    "2F2E": "KANGXI RADICAL RIVER",
    "2F2F": "KANGXI RADICAL WORK",
    "2F30": "KANGXI RADICAL ONESELF",
    "2F31": "KANGXI RADICAL TURBAN",
    "2F32": "KANGXI RADICAL DRY",
    "2F33": "KANGXI RADICAL SHORT THREAD",
    "2F34": "KANGXI RADICAL DOTTED CLIFF",
    "2F35": "KANGXI RADICAL LONG STRIDE",
    "2F36": "KANGXI RADICAL TWO HANDS",
    "2F37": "KANGXI RADICAL SHOOT",
    "2F38": "KANGXI RADICAL BOW",
    "2F39": "KANGXI RADICAL SNOUT",
    "2F3A": "KANGXI RADICAL BRISTLE",
    "2F3B": "KANGXI RADICAL STEP",
    "2F3C": "KANGXI RADICAL HEART",
    "2F3D": "KANGXI RADICAL HALBERD",
    "2F3E": "KANGXI RADICAL DOOR",
    "2F3F": "KANGXI RADICAL HAND",
    "2F40": "KANGXI RADICAL BRANCH",
    "2F41": "KANGXI RADICAL RAP",
    "2F42": "KANGXI RADICAL SCRIPT",
    "2F43": "KANGXI RADICAL DIPPER",
    "2F44": "KANGXI RADICAL AXE",
    "2F45": "KANGXI RADICAL SQUARE",
    "2F46": "KANGXI RADICAL NOT",
    "2F47": "KANGXI RADICAL SUN",
    "2F48": "KANGXI RADICAL SAY",
    "2F49": "KANGXI RADICAL MOON",
    "2F4A": "KANGXI RADICAL TREE",
    "2F4B": "KANGXI RADICAL LACK",
    "2F4C": "KANGXI RADICAL STOP",
    "2F4D": "KANGXI RADICAL DEATH",
    "2F4E": "KANGXI RADICAL WEAPON",
    "2F4F": "KANGXI RADICAL DO NOT",
    "2F50": "KANGXI RADICAL COMPARE",
    "2F51": "KANGXI RADICAL FUR",
    "2F52": "KANGXI RADICAL CLAN",
    "2F53": "KANGXI RADICAL STEAM",
    "2F54": "KANGXI RADICAL WATER",
    "2F55": "KANGXI RADICAL FIRE",
    "2F56": "KANGXI RADICAL CLAW",
    "2F57": "KANGXI RADICAL FATHER",
    "2F58": "KANGXI RADICAL DOUBLE X",
    "2F59": "KANGXI RADICAL HALF TREE TRUNK",
    "2F5A": "KANGXI RADICAL SLICE",
    "2F5B": "KANGXI RADICAL FANG",
    "2F5C": "KANGXI RADICAL COW",
    "2F5D": "KANGXI RADICAL DOG",
    "2F5E": "KANGXI RADICAL PROFOUND",
    "2F5F": "KANGXI RADICAL JADE",
    "2F60": "KANGXI RADICAL MELON",
    "2F61": "KANGXI RADICAL TILE",
    "2F62": "KANGXI RADICAL SWEET",
    "2F63": "KANGXI RADICAL LIFE",
    "2F64": "KANGXI RADICAL USE",
    "2F65": "KANGXI RADICAL FIELD",
    "2F66": "KANGXI RADICAL BOLT OF CLOTH",
    "2F67": "KANGXI RADICAL SICKNESS",
    "2F68": "KANGXI RADICAL DOTTED TENT",
    "2F69": "KANGXI RADICAL WHITE",
    "2F6A": "KANGXI RADICAL SKIN",
    "2F6B": "KANGXI RADICAL DISH",
    "2F6C": "KANGXI RADICAL EYE",
    "2F6D": "KANGXI RADICAL SPEAR",
    "2F6E": "KANGXI RADICAL ARROW",
    "2F6F": "KANGXI RADICAL STONE",
    "2F70": "KANGXI RADICAL SPIRIT",
    "2F71": "KANGXI RADICAL TRACK",
    "2F72": "KANGXI RADICAL GRAIN",
    "2F73": "KANGXI RADICAL CAVE",
    "2F74": "KANGXI RADICAL STAND",
    "2F75": "KANGXI RADICAL BAMBOO",
    "2F76": "KANGXI RADICAL RICE",
    "2F77": "KANGXI RADICAL SILK",
    "2F78": "KANGXI RADICAL JAR",
    "2F79": "KANGXI RADICAL NET",
    "2F7A": "KANGXI RADICAL SHEEP",
    "2F7B": "KANGXI RADICAL FEATHER",
    "2F7C": "KANGXI RADICAL OLD",
    "2F7D": "KANGXI RADICAL AND",
    "2F7E": "KANGXI RADICAL PLOW",
    "2F7F": "KANGXI RADICAL EAR",
    "2F80": "KANGXI RADICAL BRUSH",
    "2F81": "KANGXI RADICAL MEAT",
    "2F82": "KANGXI RADICAL MINISTER",
    "2F83": "KANGXI RADICAL SELF",
    "2F84": "KANGXI RADICAL ARRIVE",
    "2F85": "KANGXI RADICAL MORTAR",
    "2F86": "KANGXI RADICAL TONGUE",
    "2F87": "KANGXI RADICAL OPPOSE",
    "2F88": "KANGXI RADICAL BOAT",
    "2F89": "KANGXI RADICAL STOPPING",
    "2F8A": "KANGXI RADICAL COLOR",
    "2F8B": "KANGXI RADICAL GRASS",
    "2F8C": "KANGXI RADICAL TIGER",
    "2F8D": "KANGXI RADICAL INSECT",
    "2F8E": "KANGXI RADICAL BLOOD",
    "2F8F": "KANGXI RADICAL WALK ENCLOSURE",
    "2F90": "KANGXI RADICAL CLOTHES",
    "2F91": "KANGXI RADICAL WEST",
    "2F92": "KANGXI RADICAL SEE",
    "2F93": "KANGXI RADICAL HORN",
    "2F94": "KANGXI RADICAL SPEECH",
    "2F95": "KANGXI RADICAL VALLEY",
    "2F96": "KANGXI RADICAL BEAN",
    "2F97": "KANGXI RADICAL PIG",
    "2F98": "KANGXI RADICAL BADGER",
    "2F99": "KANGXI RADICAL SHELL",
    "2F9A": "KANGXI RADICAL RED",
    "2F9B": "KANGXI RADICAL RUN",
    "2F9C": "KANGXI RADICAL FOOT",
    "2F9D": "KANGXI RADICAL BODY",
    "2F9E": "KANGXI RADICAL CART",
    "2F9F": "KANGXI RADICAL BITTER",
    "2FA0": "KANGXI RADICAL MORNING",
    "2FA1": "KANGXI RADICAL WALK",
    "2FA2": "KANGXI RADICAL CITY",
    "2FA3": "KANGXI RADICAL WINE",
    "2FA4": "KANGXI RADICAL DISTINGUISH",
    "2FA5": "KANGXI RADICAL VILLAGE",
    "2FA6": "KANGXI RADICAL GOLD",
    "2FA7": "KANGXI RADICAL LONG",
    "2FA8": "KANGXI RADICAL GATE",
    "2FA9": "KANGXI RADICAL MOUND",
    "2FAA": "KANGXI RADICAL SLAVE",
    "2FAB": "KANGXI RADICAL SHORT TAILED BIRD",
    "2FAC": "KANGXI RADICAL RAIN",
    "2FAD": "KANGXI RADICAL BLUE",
    "2FAE": "KANGXI RADICAL WRONG",
    "2FAF": "KANGXI RADICAL FACE",
    "2FB0": "KANGXI RADICAL LEATHER",
    "2FB1": "KANGXI RADICAL TANNED LEATHER",
    "2FB2": "KANGXI RADICAL LEEK",
    "2FB3": "KANGXI RADICAL SOUND",
    "2FB4": "KANGXI RADICAL LEAF",
    "2FB5": "KANGXI RADICAL WIND",
    "2FB6": "KANGXI RADICAL FLY",
    "2FB7": "KANGXI RADICAL EAT",
    "2FB8": "KANGXI RADICAL HEAD",
    "2FB9": "KANGXI RADICAL FRAGRANT",
    "2FBA": "KANGXI RADICAL HORSE",
    "2FBB": "KANGXI RADICAL BONE",
    "2FBC": "KANGXI RADICAL TALL",
    "2FBD": "KANGXI RADICAL HAIR",
    "2FBE": "KANGXI RADICAL FIGHT",
    "2FBF": "KANGXI RADICAL SACRIFICIAL WINE",
    "2FC0": "KANGXI RADICAL CAULDRON",
    "2FC1": "KANGXI RADICAL GHOST",
    "2FC2": "KANGXI RADICAL FISH",
    "2FC3": "KANGXI RADICAL BIRD",
    "2FC4": "KANGXI RADICAL SALT",
    "2FC5": "KANGXI RADICAL DEER",
    "2FC6": "KANGXI RADICAL WHEAT",
    "2FC7": "KANGXI RADICAL HEMP",
    "2FC8": "KANGXI RADICAL YELLOW",
    "2FC9": "KANGXI RADICAL MILLET",
    "2FCA": "KANGXI RADICAL BLACK",
    "2FCB": "KANGXI RADICAL EMBROIDERY",
    "2FCC": "KANGXI RADICAL FROG",
    "2FCD": "KANGXI RADICAL TRIPOD",
    "2FCE": "KANGXI RADICAL DRUM",
    "2FCF": "KANGXI RADICAL RAT",
    "2FD0": "KANGXI RADICAL NOSE",
    "2FD1": "KANGXI RADICAL EVEN",
    "2FD2": "KANGXI RADICAL TOOTH",
    "2FD3": "KANGXI RADICAL DRAGON",
    "2FD4": "KANGXI RADICAL TURTLE",
    "2FD5": "KANGXI RADICAL FLUTE",
    "2FF0": "IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT",
    "2FF1": "IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW",
    "2FF2": "IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT",
    "2FF3": "IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW",
    "2FF4": "IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND",
    "2FF5": "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE",
    "2FF6": "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW",
    "2FF7": "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT",
    "2FF8": "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT",
    "2FF9": "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT",
    "2FFA": "IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT",
    "2FFB": "IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID",
    "3000": "IDEOGRAPHIC SPACE",
    "3001": "IDEOGRAPHIC COMMA",
    "3002": "IDEOGRAPHIC FULL STOP",
    "3003": "DITTO MARK",
    "3004": "JAPANESE INDUSTRIAL STANDARD SYMBOL",
    "3005": "IDEOGRAPHIC ITERATION MARK",
    "3006": "IDEOGRAPHIC CLOSING MARK",
    "3007": "IDEOGRAPHIC NUMBER ZERO",
    "3008": "LEFT ANGLE BRACKET",
    "3009": "RIGHT ANGLE BRACKET",
    "300A": "LEFT DOUBLE ANGLE BRACKET",
    "300B": "RIGHT DOUBLE ANGLE BRACKET",
    "300C": "LEFT CORNER BRACKET",
    "300D": "RIGHT CORNER BRACKET",
    "300E": "LEFT WHITE CORNER BRACKET",
    "300F": "RIGHT WHITE CORNER BRACKET",
    "3010": "LEFT BLACK LENTICULAR BRACKET",
    "3011": "RIGHT BLACK LENTICULAR BRACKET",
    "3012": "POSTAL MARK",
    "3013": "GETA MARK",
    "3014": "LEFT TORTOISE SHELL BRACKET",
    "3015": "RIGHT TORTOISE SHELL BRACKET",
    "3016": "LEFT WHITE LENTICULAR BRACKET",
    "3017": "RIGHT WHITE LENTICULAR BRACKET",
    "3018": "LEFT WHITE TORTOISE SHELL BRACKET",
    "3019": "RIGHT WHITE TORTOISE SHELL BRACKET",
    "301A": "LEFT WHITE SQUARE BRACKET",
    "301B": "RIGHT WHITE SQUARE BRACKET",
    "301C": "WAVE DASH",
    "301D": "REVERSED DOUBLE PRIME QUOTATION MARK",
    "301E": "DOUBLE PRIME QUOTATION MARK",
    "301F": "LOW DOUBLE PRIME QUOTATION MARK",
    "3020": "POSTAL MARK FACE",
    "3021": "HANGZHOU NUMERAL ONE",
    "3022": "HANGZHOU NUMERAL TWO",
    "3023": "HANGZHOU NUMERAL THREE",
    "3024": "HANGZHOU NUMERAL FOUR",
    "3025": "HANGZHOU NUMERAL FIVE",
    "3026": "HANGZHOU NUMERAL SIX",
    "3027": "HANGZHOU NUMERAL SEVEN",
    "3028": "HANGZHOU NUMERAL EIGHT",
    "3029": "HANGZHOU NUMERAL NINE",
    "302A": "IDEOGRAPHIC LEVEL TONE MARK",
    "302B": "IDEOGRAPHIC RISING TONE MARK",
    "302C": "IDEOGRAPHIC DEPARTING TONE MARK",
    "302D": "IDEOGRAPHIC ENTERING TONE MARK",
    "302E": "HANGUL SINGLE DOT TONE MARK",
    "302F": "HANGUL DOUBLE DOT TONE MARK",
    "3030": "WAVY DASH",
    "3031": "VERTICAL KANA REPEAT MARK",
    "3032": "VERTICAL KANA REPEAT WITH VOICED SOUND MARK",
    "3033": "VERTICAL KANA REPEAT MARK UPPER HALF",
    "3034": "VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF",
    "3035": "VERTICAL KANA REPEAT MARK LOWER HALF",
    "3036": "CIRCLED POSTAL MARK",
    "3037": "IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL",
    "3038": "HANGZHOU NUMERAL TEN",
    "3039": "HANGZHOU NUMERAL TWENTY",
    "303A": "HANGZHOU NUMERAL THIRTY",
    "303B": "VERTICAL IDEOGRAPHIC ITERATION MARK",
    "303C": "MASU MARK",
    "303D": "PART ALTERNATION MARK",
    "303E": "IDEOGRAPHIC VARIATION INDICATOR",
    "303F": "IDEOGRAPHIC HALF FILL SPACE",
    "3041": "HIRAGANA LETTER SMALL A",
    "3042": "HIRAGANA LETTER A",
    "3043": "HIRAGANA LETTER SMALL I",
    "3044": "HIRAGANA LETTER I",
    "3045": "HIRAGANA LETTER SMALL U",
    "3046": "HIRAGANA LETTER U",
    "3047": "HIRAGANA LETTER SMALL E",
    "3048": "HIRAGANA LETTER E",
    "3049": "HIRAGANA LETTER SMALL O",
    "304A": "HIRAGANA LETTER O",
    "304B": "HIRAGANA LETTER KA",
    "304C": "HIRAGANA LETTER GA",
    "304D": "HIRAGANA LETTER KI",
    "304E": "HIRAGANA LETTER GI",
    "304F": "HIRAGANA LETTER KU",
    "3050": "HIRAGANA LETTER GU",
    "3051": "HIRAGANA LETTER KE",
    "3052": "HIRAGANA LETTER GE",
    "3053": "HIRAGANA LETTER KO",
    "3054": "HIRAGANA LETTER GO",
    "3055": "HIRAGANA LETTER SA",
    "3056": "HIRAGANA LETTER ZA",
    "3057": "HIRAGANA LETTER SI",
    "3058": "HIRAGANA LETTER ZI",
    "3059": "HIRAGANA LETTER SU",
    "305A": "HIRAGANA LETTER ZU",
    "305B": "HIRAGANA LETTER SE",
    "305C": "HIRAGANA LETTER ZE",
    "305D": "HIRAGANA LETTER SO",
    "305E": "HIRAGANA LETTER ZO",
    "305F": "HIRAGANA LETTER TA",
    "3060": "HIRAGANA LETTER DA",
    "3061": "HIRAGANA LETTER TI",
    "3062": "HIRAGANA LETTER DI",
    "3063": "HIRAGANA LETTER SMALL TU",
    "3064": "HIRAGANA LETTER TU",
    "3065": "HIRAGANA LETTER DU",
    "3066": "HIRAGANA LETTER TE",
    "3067": "HIRAGANA LETTER DE",
    "3068": "HIRAGANA LETTER TO",
    "3069": "HIRAGANA LETTER DO",
    "306A": "HIRAGANA LETTER NA",
    "306B": "HIRAGANA LETTER NI",
    "306C": "HIRAGANA LETTER NU",
    "306D": "HIRAGANA LETTER NE",
    "306E": "HIRAGANA LETTER NO",
    "306F": "HIRAGANA LETTER HA",
    "3070": "HIRAGANA LETTER BA",
    "3071": "HIRAGANA LETTER PA",
    "3072": "HIRAGANA LETTER HI",
    "3073": "HIRAGANA LETTER BI",
    "3074": "HIRAGANA LETTER PI",
    "3075": "HIRAGANA LETTER HU",
    "3076": "HIRAGANA LETTER BU",
    "3077": "HIRAGANA LETTER PU",
    "3078": "HIRAGANA LETTER HE",
    "3079": "HIRAGANA LETTER BE",
    "307A": "HIRAGANA LETTER PE",
    "307B": "HIRAGANA LETTER HO",
    "307C": "HIRAGANA LETTER BO",
    "307D": "HIRAGANA LETTER PO",
    "307E": "HIRAGANA LETTER MA",
    "307F": "HIRAGANA LETTER MI",
    "3080": "HIRAGANA LETTER MU",
    "3081": "HIRAGANA LETTER ME",
    "3082": "HIRAGANA LETTER MO",
    "3083": "HIRAGANA LETTER SMALL YA",
    "3084": "HIRAGANA LETTER YA",
    "3085": "HIRAGANA LETTER SMALL YU",
    "3086": "HIRAGANA LETTER YU",
    "3087": "HIRAGANA LETTER SMALL YO",
    "3088": "HIRAGANA LETTER YO",
    "3089": "HIRAGANA LETTER RA",
    "308A": "HIRAGANA LETTER RI",
    "308B": "HIRAGANA LETTER RU",
    "308C": "HIRAGANA LETTER RE",
    "308D": "HIRAGANA LETTER RO",
    "308E": "HIRAGANA LETTER SMALL WA",
    "308F": "HIRAGANA LETTER WA",
    "3090": "HIRAGANA LETTER WI",
    "3091": "HIRAGANA LETTER WE",
    "3092": "HIRAGANA LETTER WO",
    "3093": "HIRAGANA LETTER N",
    "3094": "HIRAGANA LETTER VU",
    "3095": "HIRAGANA LETTER SMALL KA",
    "3096": "HIRAGANA LETTER SMALL KE",
    "3099": "COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK",
    "309A": "COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK",
    "309B": "KATAKANA-HIRAGANA VOICED SOUND MARK",
    "309C": "KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK",
    "309D": "HIRAGANA ITERATION MARK",
    "309E": "HIRAGANA VOICED ITERATION MARK",
    "309F": "HIRAGANA DIGRAPH YORI",
    "30A0": "KATAKANA-HIRAGANA DOUBLE HYPHEN",
    "30A1": "KATAKANA LETTER SMALL A",
    "30A2": "KATAKANA LETTER A",
    "30A3": "KATAKANA LETTER SMALL I",
    "30A4": "KATAKANA LETTER I",
    "30A5": "KATAKANA LETTER SMALL U",
    "30A6": "KATAKANA LETTER U",
    "30A7": "KATAKANA LETTER SMALL E",
    "30A8": "KATAKANA LETTER E",
    "30A9": "KATAKANA LETTER SMALL O",
    "30AA": "KATAKANA LETTER O",
    "30AB": "KATAKANA LETTER KA",
    "30AC": "KATAKANA LETTER GA",
    "30AD": "KATAKANA LETTER KI",
    "30AE": "KATAKANA LETTER GI",
    "30AF": "KATAKANA LETTER KU",
    "30B0": "KATAKANA LETTER GU",
    "30B1": "KATAKANA LETTER KE",
    "30B2": "KATAKANA LETTER GE",
    "30B3": "KATAKANA LETTER KO",
    "30B4": "KATAKANA LETTER GO",
    "30B5": "KATAKANA LETTER SA",
    "30B6": "KATAKANA LETTER ZA",
    "30B7": "KATAKANA LETTER SI",
    "30B8": "KATAKANA LETTER ZI",
    "30B9": "KATAKANA LETTER SU",
    "30BA": "KATAKANA LETTER ZU",
    "30BB": "KATAKANA LETTER SE",
    "30BC": "KATAKANA LETTER ZE",
    "30BD": "KATAKANA LETTER SO",
    "30BE": "KATAKANA LETTER ZO",
    "30BF": "KATAKANA LETTER TA",
    "30C0": "KATAKANA LETTER DA",
    "30C1": "KATAKANA LETTER TI",
    "30C2": "KATAKANA LETTER DI",
    "30C3": "KATAKANA LETTER SMALL TU",
    "30C4": "KATAKANA LETTER TU",
    "30C5": "KATAKANA LETTER DU",
    "30C6": "KATAKANA LETTER TE",
    "30C7": "KATAKANA LETTER DE",
    "30C8": "KATAKANA LETTER TO",
    "30C9": "KATAKANA LETTER DO",
    "30CA": "KATAKANA LETTER NA",
    "30CB": "KATAKANA LETTER NI",
    "30CC": "KATAKANA LETTER NU",
    "30CD": "KATAKANA LETTER NE",
    "30CE": "KATAKANA LETTER NO",
    "30CF": "KATAKANA LETTER HA",
    "30D0": "KATAKANA LETTER BA",
    "30D1": "KATAKANA LETTER PA",
    "30D2": "KATAKANA LETTER HI",
    "30D3": "KATAKANA LETTER BI",
    "30D4": "KATAKANA LETTER PI",
    "30D5": "KATAKANA LETTER HU",
    "30D6": "KATAKANA LETTER BU",
    "30D7": "KATAKANA LETTER PU",
    "30D8": "KATAKANA LETTER HE",
    "30D9": "KATAKANA LETTER BE",
    "30DA": "KATAKANA LETTER PE",
    "30DB": "KATAKANA LETTER HO",
    "30DC": "KATAKANA LETTER BO",
    "30DD": "KATAKANA LETTER PO",
    "30DE": "KATAKANA LETTER MA",
    "30DF": "KATAKANA LETTER MI",
    "30E0": "KATAKANA LETTER MU",
    "30E1": "KATAKANA LETTER ME",
    "30E2": "KATAKANA LETTER MO",
    "30E3": "KATAKANA LETTER SMALL YA",
    "30E4": "KATAKANA LETTER YA",
    "30E5": "KATAKANA LETTER SMALL YU",
    "30E6": "KATAKANA LETTER YU",
    "30E7": "KATAKANA LETTER SMALL YO",
    "30E8": "KATAKANA LETTER YO",
    "30E9": "KATAKANA LETTER RA",
    "30EA": "KATAKANA LETTER RI",
    "30EB": "KATAKANA LETTER RU",
    "30EC": "KATAKANA LETTER RE",
    "30ED": "KATAKANA LETTER RO",
    "30EE": "KATAKANA LETTER SMALL WA",
    "30EF": "KATAKANA LETTER WA",
    "30F0": "KATAKANA LETTER WI",
    "30F1": "KATAKANA LETTER WE",
    "30F2": "KATAKANA LETTER WO",
    "30F3": "KATAKANA LETTER N",
    "30F4": "KATAKANA LETTER VU",
    "30F5": "KATAKANA LETTER SMALL KA",
    "30F6": "KATAKANA LETTER SMALL KE",
    "30F7": "KATAKANA LETTER VA",
    "30F8": "KATAKANA LETTER VI",
    "30F9": "KATAKANA LETTER VE",
    "30FA": "KATAKANA LETTER VO",
    "30FB": "KATAKANA MIDDLE DOT",
    "30FC": "KATAKANA-HIRAGANA PROLONGED SOUND MARK",
    "30FD": "KATAKANA ITERATION MARK",
    "30FE": "KATAKANA VOICED ITERATION MARK",
    "30FF": "KATAKANA DIGRAPH KOTO",
    "3105": "BOPOMOFO LETTER B",
    "3106": "BOPOMOFO LETTER P",
    "3107": "BOPOMOFO LETTER M",
    "3108": "BOPOMOFO LETTER F",
    "3109": "BOPOMOFO LETTER D",
    "310A": "BOPOMOFO LETTER T",
    "310B": "BOPOMOFO LETTER N",
    "310C": "BOPOMOFO LETTER L",
    "310D": "BOPOMOFO LETTER G",
    "310E": "BOPOMOFO LETTER K",
    "310F": "BOPOMOFO LETTER H",
    "3110": "BOPOMOFO LETTER J",
    "3111": "BOPOMOFO LETTER Q",
    "3112": "BOPOMOFO LETTER X",
    "3113": "BOPOMOFO LETTER ZH",
    "3114": "BOPOMOFO LETTER CH",
    "3115": "BOPOMOFO LETTER SH",
    "3116": "BOPOMOFO LETTER R",
    "3117": "BOPOMOFO LETTER Z",
    "3118": "BOPOMOFO LETTER C",
    "3119": "BOPOMOFO LETTER S",
    "311A": "BOPOMOFO LETTER A",
    "311B": "BOPOMOFO LETTER O",
    "311C": "BOPOMOFO LETTER E",
    "311D": "BOPOMOFO LETTER EH",
    "311E": "BOPOMOFO LETTER AI",
    "311F": "BOPOMOFO LETTER EI",
    "3120": "BOPOMOFO LETTER AU",
    "3121": "BOPOMOFO LETTER OU",
    "3122": "BOPOMOFO LETTER AN",
    "3123": "BOPOMOFO LETTER EN",
    "3124": "BOPOMOFO LETTER ANG",
    "3125": "BOPOMOFO LETTER ENG",
    "3126": "BOPOMOFO LETTER ER",
    "3127": "BOPOMOFO LETTER I",
    "3128": "BOPOMOFO LETTER U",
    "3129": "BOPOMOFO LETTER IU",
    "312A": "BOPOMOFO LETTER V",
    "312B": "BOPOMOFO LETTER NG",
    "312C": "BOPOMOFO LETTER GN",
    "312D": "BOPOMOFO LETTER IH",
    "3131": "HANGUL LETTER KIYEOK",
    "3132": "HANGUL LETTER SSANGKIYEOK",
    "3133": "HANGUL LETTER KIYEOK-SIOS",
    "3134": "HANGUL LETTER NIEUN",
    "3135": "HANGUL LETTER NIEUN-CIEUC",
    "3136": "HANGUL LETTER NIEUN-HIEUH",
    "3137": "HANGUL LETTER TIKEUT",
    "3138": "HANGUL LETTER SSANGTIKEUT",
    "3139": "HANGUL LETTER RIEUL",
    "313A": "HANGUL LETTER RIEUL-KIYEOK",
    "313B": "HANGUL LETTER RIEUL-MIEUM",
    "313C": "HANGUL LETTER RIEUL-PIEUP",
    "313D": "HANGUL LETTER RIEUL-SIOS",
    "313E": "HANGUL LETTER RIEUL-THIEUTH",
    "313F": "HANGUL LETTER RIEUL-PHIEUPH",
    "3140": "HANGUL LETTER RIEUL-HIEUH",
    "3141": "HANGUL LETTER MIEUM",
    "3142": "HANGUL LETTER PIEUP",
    "3143": "HANGUL LETTER SSANGPIEUP",
    "3144": "HANGUL LETTER PIEUP-SIOS",
    "3145": "HANGUL LETTER SIOS",
    "3146": "HANGUL LETTER SSANGSIOS",
    "3147": "HANGUL LETTER IEUNG",
    "3148": "HANGUL LETTER CIEUC",
    "3149": "HANGUL LETTER SSANGCIEUC",
    "314A": "HANGUL LETTER CHIEUCH",
    "314B": "HANGUL LETTER KHIEUKH",
    "314C": "HANGUL LETTER THIEUTH",
    "314D": "HANGUL LETTER PHIEUPH",
    "314E": "HANGUL LETTER HIEUH",
    "314F": "HANGUL LETTER A",
    "3150": "HANGUL LETTER AE",
    "3151": "HANGUL LETTER YA",
    "3152": "HANGUL LETTER YAE",
    "3153": "HANGUL LETTER EO",
    "3154": "HANGUL LETTER E",
    "3155": "HANGUL LETTER YEO",
    "3156": "HANGUL LETTER YE",
    "3157": "HANGUL LETTER O",
    "3158": "HANGUL LETTER WA",
    "3159": "HANGUL LETTER WAE",
    "315A": "HANGUL LETTER OE",
    "315B": "HANGUL LETTER YO",
    "315C": "HANGUL LETTER U",
    "315D": "HANGUL LETTER WEO",
    "315E": "HANGUL LETTER WE",
    "315F": "HANGUL LETTER WI",
    "3160": "HANGUL LETTER YU",
    "3161": "HANGUL LETTER EU",
    "3162": "HANGUL LETTER YI",
    "3163": "HANGUL LETTER I",
    "3164": "HANGUL FILLER",
    "3165": "HANGUL LETTER SSANGNIEUN",
    "3166": "HANGUL LETTER NIEUN-TIKEUT",
    "3167": "HANGUL LETTER NIEUN-SIOS",
    "3168": "HANGUL LETTER NIEUN-PANSIOS",
    "3169": "HANGUL LETTER RIEUL-KIYEOK-SIOS",
    "316A": "HANGUL LETTER RIEUL-TIKEUT",
    "316B": "HANGUL LETTER RIEUL-PIEUP-SIOS",
    "316C": "HANGUL LETTER RIEUL-PANSIOS",
    "316D": "HANGUL LETTER RIEUL-YEORINHIEUH",
    "316E": "HANGUL LETTER MIEUM-PIEUP",
    "316F": "HANGUL LETTER MIEUM-SIOS",
    "3170": "HANGUL LETTER MIEUM-PANSIOS",
    "3171": "HANGUL LETTER KAPYEOUNMIEUM",
    "3172": "HANGUL LETTER PIEUP-KIYEOK",
    "3173": "HANGUL LETTER PIEUP-TIKEUT",
    "3174": "HANGUL LETTER PIEUP-SIOS-KIYEOK",
    "3175": "HANGUL LETTER PIEUP-SIOS-TIKEUT",
    "3176": "HANGUL LETTER PIEUP-CIEUC",
    "3177": "HANGUL LETTER PIEUP-THIEUTH",
    "3178": "HANGUL LETTER KAPYEOUNPIEUP",
    "3179": "HANGUL LETTER KAPYEOUNSSANGPIEUP",
    "317A": "HANGUL LETTER SIOS-KIYEOK",
    "317B": "HANGUL LETTER SIOS-NIEUN",
    "317C": "HANGUL LETTER SIOS-TIKEUT",
    "317D": "HANGUL LETTER SIOS-PIEUP",
    "317E": "HANGUL LETTER SIOS-CIEUC",
    "317F": "HANGUL LETTER PANSIOS",
    "3180": "HANGUL LETTER SSANGIEUNG",
    "3181": "HANGUL LETTER YESIEUNG",
    "3182": "HANGUL LETTER YESIEUNG-SIOS",
    "3183": "HANGUL LETTER YESIEUNG-PANSIOS",
    "3184": "HANGUL LETTER KAPYEOUNPHIEUPH",
    "3185": "HANGUL LETTER SSANGHIEUH",
    "3186": "HANGUL LETTER YEORINHIEUH",
    "3187": "HANGUL LETTER YO-YA",
    "3188": "HANGUL LETTER YO-YAE",
    "3189": "HANGUL LETTER YO-I",
    "318A": "HANGUL LETTER YU-YEO",
    "318B": "HANGUL LETTER YU-YE",
    "318C": "HANGUL LETTER YU-I",
    "318D": "HANGUL LETTER ARAEA",
    "318E": "HANGUL LETTER ARAEAE",
    "3190": "IDEOGRAPHIC ANNOTATION LINKING MARK",
    "3191": "IDEOGRAPHIC ANNOTATION REVERSE MARK",
    "3192": "IDEOGRAPHIC ANNOTATION ONE MARK",
    "3193": "IDEOGRAPHIC ANNOTATION TWO MARK",
    "3194": "IDEOGRAPHIC ANNOTATION THREE MARK",
    "3195": "IDEOGRAPHIC ANNOTATION FOUR MARK",
    "3196": "IDEOGRAPHIC ANNOTATION TOP MARK",
    "3197": "IDEOGRAPHIC ANNOTATION MIDDLE MARK",
    "3198": "IDEOGRAPHIC ANNOTATION BOTTOM MARK",
    "3199": "IDEOGRAPHIC ANNOTATION FIRST MARK",
    "319A": "IDEOGRAPHIC ANNOTATION SECOND MARK",
    "319B": "IDEOGRAPHIC ANNOTATION THIRD MARK",
    "319C": "IDEOGRAPHIC ANNOTATION FOURTH MARK",
    "319D": "IDEOGRAPHIC ANNOTATION HEAVEN MARK",
    "319E": "IDEOGRAPHIC ANNOTATION EARTH MARK",
    "319F": "IDEOGRAPHIC ANNOTATION MAN MARK",
    "31A0": "BOPOMOFO LETTER BU",
    "31A1": "BOPOMOFO LETTER ZI",
    "31A2": "BOPOMOFO LETTER JI",
    "31A3": "BOPOMOFO LETTER GU",
    "31A4": "BOPOMOFO LETTER EE",
    "31A5": "BOPOMOFO LETTER ENN",
    "31A6": "BOPOMOFO LETTER OO",
    "31A7": "BOPOMOFO LETTER ONN",
    "31A8": "BOPOMOFO LETTER IR",
    "31A9": "BOPOMOFO LETTER ANN",
    "31AA": "BOPOMOFO LETTER INN",
    "31AB": "BOPOMOFO LETTER UNN",
    "31AC": "BOPOMOFO LETTER IM",
    "31AD": "BOPOMOFO LETTER NGG",
    "31AE": "BOPOMOFO LETTER AINN",
    "31AF": "BOPOMOFO LETTER AUNN",
    "31B0": "BOPOMOFO LETTER AM",
    "31B1": "BOPOMOFO LETTER OM",
    "31B2": "BOPOMOFO LETTER ONG",
    "31B3": "BOPOMOFO LETTER INNN",
    "31B4": "BOPOMOFO FINAL LETTER P",
    "31B5": "BOPOMOFO FINAL LETTER T",
    "31B6": "BOPOMOFO FINAL LETTER K",
    "31B7": "BOPOMOFO FINAL LETTER H",
    "31B8": "BOPOMOFO LETTER GH",
    "31B9": "BOPOMOFO LETTER LH",
    "31BA": "BOPOMOFO LETTER ZY",
    "31C0": "CJK STROKE T",
    "31C1": "CJK STROKE WG",
    "31C2": "CJK STROKE XG",
    "31C3": "CJK STROKE BXG",
    "31C4": "CJK STROKE SW",
    "31C5": "CJK STROKE HZZ",
    "31C6": "CJK STROKE HZG",
    "31C7": "CJK STROKE HP",
    "31C8": "CJK STROKE HZWG",
    "31C9": "CJK STROKE SZWG",
    "31CA": "CJK STROKE HZT",
    "31CB": "CJK STROKE HZZP",
    "31CC": "CJK STROKE HPWG",
    "31CD": "CJK STROKE HZW",
    "31CE": "CJK STROKE HZZZ",
    "31CF": "CJK STROKE N",
    "31D0": "CJK STROKE H",
    "31D1": "CJK STROKE S",
    "31D2": "CJK STROKE P",
    "31D3": "CJK STROKE SP",
    "31D4": "CJK STROKE D",
    "31D5": "CJK STROKE HZ",
    "31D6": "CJK STROKE HG",
    "31D7": "CJK STROKE SZ",
    "31D8": "CJK STROKE SWZ",
    "31D9": "CJK STROKE ST",
    "31DA": "CJK STROKE SG",
    "31DB": "CJK STROKE PD",
    "31DC": "CJK STROKE PZ",
    "31DD": "CJK STROKE TN",
    "31DE": "CJK STROKE SZZ",
    "31DF": "CJK STROKE SWG",
    "31E0": "CJK STROKE HXWG",
    "31E1": "CJK STROKE HZZZG",
    "31E2": "CJK STROKE PG",
    "31E3": "CJK STROKE Q",
    "31F0": "KATAKANA LETTER SMALL KU",
    "31F1": "KATAKANA LETTER SMALL SI",
    "31F2": "KATAKANA LETTER SMALL SU",
    "31F3": "KATAKANA LETTER SMALL TO",
    "31F4": "KATAKANA LETTER SMALL NU",
    "31F5": "KATAKANA LETTER SMALL HA",
    "31F6": "KATAKANA LETTER SMALL HI",
    "31F7": "KATAKANA LETTER SMALL HU",
    "31F8": "KATAKANA LETTER SMALL HE",
    "31F9": "KATAKANA LETTER SMALL HO",
    "31FA": "KATAKANA LETTER SMALL MU",
    "31FB": "KATAKANA LETTER SMALL RA",
    "31FC": "KATAKANA LETTER SMALL RI",
    "31FD": "KATAKANA LETTER SMALL RU",
    "31FE": "KATAKANA LETTER SMALL RE",
    "31FF": "KATAKANA LETTER SMALL RO",
    "3200": "PARENTHESIZED HANGUL KIYEOK",
    "3201": "PARENTHESIZED HANGUL NIEUN",
    "3202": "PARENTHESIZED HANGUL TIKEUT",
    "3203": "PARENTHESIZED HANGUL RIEUL",
    "3204": "PARENTHESIZED HANGUL MIEUM",
    "3205": "PARENTHESIZED HANGUL PIEUP",
    "3206": "PARENTHESIZED HANGUL SIOS",
    "3207": "PARENTHESIZED HANGUL IEUNG",
    "3208": "PARENTHESIZED HANGUL CIEUC",
    "3209": "PARENTHESIZED HANGUL CHIEUCH",
    "320A": "PARENTHESIZED HANGUL KHIEUKH",
    "320B": "PARENTHESIZED HANGUL THIEUTH",
    "320C": "PARENTHESIZED HANGUL PHIEUPH",
    "320D": "PARENTHESIZED HANGUL HIEUH",
    "320E": "PARENTHESIZED HANGUL KIYEOK A",
    "320F": "PARENTHESIZED HANGUL NIEUN A",
    "3210": "PARENTHESIZED HANGUL TIKEUT A",
    "3211": "PARENTHESIZED HANGUL RIEUL A",
    "3212": "PARENTHESIZED HANGUL MIEUM A",
    "3213": "PARENTHESIZED HANGUL PIEUP A",
    "3214": "PARENTHESIZED HANGUL SIOS A",
    "3215": "PARENTHESIZED HANGUL IEUNG A",
    "3216": "PARENTHESIZED HANGUL CIEUC A",
    "3217": "PARENTHESIZED HANGUL CHIEUCH A",
    "3218": "PARENTHESIZED HANGUL KHIEUKH A",
    "3219": "PARENTHESIZED HANGUL THIEUTH A",
    "321A": "PARENTHESIZED HANGUL PHIEUPH A",
    "321B": "PARENTHESIZED HANGUL HIEUH A",
    "321C": "PARENTHESIZED HANGUL CIEUC U",
    "321D": "PARENTHESIZED KOREAN CHARACTER OJEON",
    "321E": "PARENTHESIZED KOREAN CHARACTER O HU",
    "3220": "PARENTHESIZED IDEOGRAPH ONE",
    "3221": "PARENTHESIZED IDEOGRAPH TWO",
    "3222": "PARENTHESIZED IDEOGRAPH THREE",
    "3223": "PARENTHESIZED IDEOGRAPH FOUR",
    "3224": "PARENTHESIZED IDEOGRAPH FIVE",
    "3225": "PARENTHESIZED IDEOGRAPH SIX",
    "3226": "PARENTHESIZED IDEOGRAPH SEVEN",
    "3227": "PARENTHESIZED IDEOGRAPH EIGHT",
    "3228": "PARENTHESIZED IDEOGRAPH NINE",
    "3229": "PARENTHESIZED IDEOGRAPH TEN",
    "322A": "PARENTHESIZED IDEOGRAPH MOON",
    "322B": "PARENTHESIZED IDEOGRAPH FIRE",
    "322C": "PARENTHESIZED IDEOGRAPH WATER",
    "322D": "PARENTHESIZED IDEOGRAPH WOOD",
    "322E": "PARENTHESIZED IDEOGRAPH METAL",
    "322F": "PARENTHESIZED IDEOGRAPH EARTH",
    "3230": "PARENTHESIZED IDEOGRAPH SUN",
    "3231": "PARENTHESIZED IDEOGRAPH STOCK",
    "3232": "PARENTHESIZED IDEOGRAPH HAVE",
    "3233": "PARENTHESIZED IDEOGRAPH SOCIETY",
    "3234": "PARENTHESIZED IDEOGRAPH NAME",
    "3235": "PARENTHESIZED IDEOGRAPH SPECIAL",
    "3236": "PARENTHESIZED IDEOGRAPH FINANCIAL",
    "3237": "PARENTHESIZED IDEOGRAPH CONGRATULATION",
    "3238": "PARENTHESIZED IDEOGRAPH LABOR",
    "3239": "PARENTHESIZED IDEOGRAPH REPRESENT",
    "323A": "PARENTHESIZED IDEOGRAPH CALL",
    "323B": "PARENTHESIZED IDEOGRAPH STUDY",
    "323C": "PARENTHESIZED IDEOGRAPH SUPERVISE",
    "323D": "PARENTHESIZED IDEOGRAPH ENTERPRISE",
    "323E": "PARENTHESIZED IDEOGRAPH RESOURCE",
    "323F": "PARENTHESIZED IDEOGRAPH ALLIANCE",
    "3240": "PARENTHESIZED IDEOGRAPH FESTIVAL",
    "3241": "PARENTHESIZED IDEOGRAPH REST",
    "3242": "PARENTHESIZED IDEOGRAPH SELF",
    "3243": "PARENTHESIZED IDEOGRAPH REACH",
    "3244": "CIRCLED IDEOGRAPH QUESTION",
    "3245": "CIRCLED IDEOGRAPH KINDERGARTEN",
    "3246": "CIRCLED IDEOGRAPH SCHOOL",
    "3247": "CIRCLED IDEOGRAPH KOTO",
    "3248": "CIRCLED NUMBER TEN ON BLACK SQUARE",
    "3249": "CIRCLED NUMBER TWENTY ON BLACK SQUARE",
    "324A": "CIRCLED NUMBER THIRTY ON BLACK SQUARE",
    "324B": "CIRCLED NUMBER FORTY ON BLACK SQUARE",
    "324C": "CIRCLED NUMBER FIFTY ON BLACK SQUARE",
    "324D": "CIRCLED NUMBER SIXTY ON BLACK SQUARE",
    "324E": "CIRCLED NUMBER SEVENTY ON BLACK SQUARE",
    "324F": "CIRCLED NUMBER EIGHTY ON BLACK SQUARE",
    "3250": "PARTNERSHIP SIGN",
    "3251": "CIRCLED NUMBER TWENTY ONE",
    "3252": "CIRCLED NUMBER TWENTY TWO",
    "3253": "CIRCLED NUMBER TWENTY THREE",
    "3254": "CIRCLED NUMBER TWENTY FOUR",
    "3255": "CIRCLED NUMBER TWENTY FIVE",
    "3256": "CIRCLED NUMBER TWENTY SIX",
    "3257": "CIRCLED NUMBER TWENTY SEVEN",
    "3258": "CIRCLED NUMBER TWENTY EIGHT",
    "3259": "CIRCLED NUMBER TWENTY NINE",
    "325A": "CIRCLED NUMBER THIRTY",
    "325B": "CIRCLED NUMBER THIRTY ONE",
    "325C": "CIRCLED NUMBER THIRTY TWO",
    "325D": "CIRCLED NUMBER THIRTY THREE",
    "325E": "CIRCLED NUMBER THIRTY FOUR",
    "325F": "CIRCLED NUMBER THIRTY FIVE",
    "3260": "CIRCLED HANGUL KIYEOK",
    "3261": "CIRCLED HANGUL NIEUN",
    "3262": "CIRCLED HANGUL TIKEUT",
    "3263": "CIRCLED HANGUL RIEUL",
    "3264": "CIRCLED HANGUL MIEUM",
    "3265": "CIRCLED HANGUL PIEUP",
    "3266": "CIRCLED HANGUL SIOS",
    "3267": "CIRCLED HANGUL IEUNG",
    "3268": "CIRCLED HANGUL CIEUC",
    "3269": "CIRCLED HANGUL CHIEUCH",
    "326A": "CIRCLED HANGUL KHIEUKH",
    "326B": "CIRCLED HANGUL THIEUTH",
    "326C": "CIRCLED HANGUL PHIEUPH",
    "326D": "CIRCLED HANGUL HIEUH",
    "326E": "CIRCLED HANGUL KIYEOK A",
    "326F": "CIRCLED HANGUL NIEUN A",
    "3270": "CIRCLED HANGUL TIKEUT A",
    "3271": "CIRCLED HANGUL RIEUL A",
    "3272": "CIRCLED HANGUL MIEUM A",
    "3273": "CIRCLED HANGUL PIEUP A",
    "3274": "CIRCLED HANGUL SIOS A",
    "3275": "CIRCLED HANGUL IEUNG A",
    "3276": "CIRCLED HANGUL CIEUC A",
    "3277": "CIRCLED HANGUL CHIEUCH A",
    "3278": "CIRCLED HANGUL KHIEUKH A",
    "3279": "CIRCLED HANGUL THIEUTH A",
    "327A": "CIRCLED HANGUL PHIEUPH A",
    "327B": "CIRCLED HANGUL HIEUH A",
    "327C": "CIRCLED KOREAN CHARACTER CHAMKO",
    "327D": "CIRCLED KOREAN CHARACTER JUEUI",
    "327E": "CIRCLED HANGUL IEUNG U",
    "327F": "KOREAN STANDARD SYMBOL",
    "3280": "CIRCLED IDEOGRAPH ONE",
    "3281": "CIRCLED IDEOGRAPH TWO",
    "3282": "CIRCLED IDEOGRAPH THREE",
    "3283": "CIRCLED IDEOGRAPH FOUR",
    "3284": "CIRCLED IDEOGRAPH FIVE",
    "3285": "CIRCLED IDEOGRAPH SIX",
    "3286": "CIRCLED IDEOGRAPH SEVEN",
    "3287": "CIRCLED IDEOGRAPH EIGHT",
    "3288": "CIRCLED IDEOGRAPH NINE",
    "3289": "CIRCLED IDEOGRAPH TEN",
    "328A": "CIRCLED IDEOGRAPH MOON",
    "328B": "CIRCLED IDEOGRAPH FIRE",
    "328C": "CIRCLED IDEOGRAPH WATER",
    "328D": "CIRCLED IDEOGRAPH WOOD",
    "328E": "CIRCLED IDEOGRAPH METAL",
    "328F": "CIRCLED IDEOGRAPH EARTH",
    "3290": "CIRCLED IDEOGRAPH SUN",
    "3291": "CIRCLED IDEOGRAPH STOCK",
    "3292": "CIRCLED IDEOGRAPH HAVE",
    "3293": "CIRCLED IDEOGRAPH SOCIETY",
    "3294": "CIRCLED IDEOGRAPH NAME",
    "3295": "CIRCLED IDEOGRAPH SPECIAL",
    "3296": "CIRCLED IDEOGRAPH FINANCIAL",
    "3297": "CIRCLED IDEOGRAPH CONGRATULATION",
    "3298": "CIRCLED IDEOGRAPH LABOR",
    "3299": "CIRCLED IDEOGRAPH SECRET",
    "329A": "CIRCLED IDEOGRAPH MALE",
    "329B": "CIRCLED IDEOGRAPH FEMALE",
    "329C": "CIRCLED IDEOGRAPH SUITABLE",
    "329D": "CIRCLED IDEOGRAPH EXCELLENT",
    "329E": "CIRCLED IDEOGRAPH PRINT",
    "329F": "CIRCLED IDEOGRAPH ATTENTION",
    "32A0": "CIRCLED IDEOGRAPH ITEM",
    "32A1": "CIRCLED IDEOGRAPH REST",
    "32A2": "CIRCLED IDEOGRAPH COPY",
    "32A3": "CIRCLED IDEOGRAPH CORRECT",
    "32A4": "CIRCLED IDEOGRAPH HIGH",
    "32A5": "CIRCLED IDEOGRAPH CENTRE",
    "32A6": "CIRCLED IDEOGRAPH LOW",
    "32A7": "CIRCLED IDEOGRAPH LEFT",
    "32A8": "CIRCLED IDEOGRAPH RIGHT",
    "32A9": "CIRCLED IDEOGRAPH MEDICINE",
    "32AA": "CIRCLED IDEOGRAPH RELIGION",
    "32AB": "CIRCLED IDEOGRAPH STUDY",
    "32AC": "CIRCLED IDEOGRAPH SUPERVISE",
    "32AD": "CIRCLED IDEOGRAPH ENTERPRISE",
    "32AE": "CIRCLED IDEOGRAPH RESOURCE",
    "32AF": "CIRCLED IDEOGRAPH ALLIANCE",
    "32B0": "CIRCLED IDEOGRAPH NIGHT",
    "32B1": "CIRCLED NUMBER THIRTY SIX",
    "32B2": "CIRCLED NUMBER THIRTY SEVEN",
    "32B3": "CIRCLED NUMBER THIRTY EIGHT",
    "32B4": "CIRCLED NUMBER THIRTY NINE",
    "32B5": "CIRCLED NUMBER FORTY",
    "32B6": "CIRCLED NUMBER FORTY ONE",
    "32B7": "CIRCLED NUMBER FORTY TWO",
    "32B8": "CIRCLED NUMBER FORTY THREE",
    "32B9": "CIRCLED NUMBER FORTY FOUR",
    "32BA": "CIRCLED NUMBER FORTY FIVE",
    "32BB": "CIRCLED NUMBER FORTY SIX",
    "32BC": "CIRCLED NUMBER FORTY SEVEN",
    "32BD": "CIRCLED NUMBER FORTY EIGHT",
    "32BE": "CIRCLED NUMBER FORTY NINE",
    "32BF": "CIRCLED NUMBER FIFTY",
    "32C0": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY",
    "32C1": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY",
    "32C2": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH",
    "32C3": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL",
    "32C4": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY",
    "32C5": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE",
    "32C6": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY",
    "32C7": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST",
    "32C8": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER",
    "32C9": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER",
    "32CA": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER",
    "32CB": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER",
    "32CC": "SQUARE HG",
    "32CD": "SQUARE ERG",
    "32CE": "SQUARE EV",
    "32CF": "LIMITED LIABILITY SIGN",
    "32D0": "CIRCLED KATAKANA A",
    "32D1": "CIRCLED KATAKANA I",
    "32D2": "CIRCLED KATAKANA U",
    "32D3": "CIRCLED KATAKANA E",
    "32D4": "CIRCLED KATAKANA O",
    "32D5": "CIRCLED KATAKANA KA",
    "32D6": "CIRCLED KATAKANA KI",
    "32D7": "CIRCLED KATAKANA KU",
    "32D8": "CIRCLED KATAKANA KE",
    "32D9": "CIRCLED KATAKANA KO",
    "32DA": "CIRCLED KATAKANA SA",
    "32DB": "CIRCLED KATAKANA SI",
    "32DC": "CIRCLED KATAKANA SU",
    "32DD": "CIRCLED KATAKANA SE",
    "32DE": "CIRCLED KATAKANA SO",
    "32DF": "CIRCLED KATAKANA TA",
    "32E0": "CIRCLED KATAKANA TI",
    "32E1": "CIRCLED KATAKANA TU",
    "32E2": "CIRCLED KATAKANA TE",
    "32E3": "CIRCLED KATAKANA TO",
    "32E4": "CIRCLED KATAKANA NA",
    "32E5": "CIRCLED KATAKANA NI",
    "32E6": "CIRCLED KATAKANA NU",
    "32E7": "CIRCLED KATAKANA NE",
    "32E8": "CIRCLED KATAKANA NO",
    "32E9": "CIRCLED KATAKANA HA",
    "32EA": "CIRCLED KATAKANA HI",
    "32EB": "CIRCLED KATAKANA HU",
    "32EC": "CIRCLED KATAKANA HE",
    "32ED": "CIRCLED KATAKANA HO",
    "32EE": "CIRCLED KATAKANA MA",
    "32EF": "CIRCLED KATAKANA MI",
    "32F0": "CIRCLED KATAKANA MU",
    "32F1": "CIRCLED KATAKANA ME",
    "32F2": "CIRCLED KATAKANA MO",
    "32F3": "CIRCLED KATAKANA YA",
    "32F4": "CIRCLED KATAKANA YU",
    "32F5": "CIRCLED KATAKANA YO",
    "32F6": "CIRCLED KATAKANA RA",
    "32F7": "CIRCLED KATAKANA RI",
    "32F8": "CIRCLED KATAKANA RU",
    "32F9": "CIRCLED KATAKANA RE",
    "32FA": "CIRCLED KATAKANA RO",
    "32FB": "CIRCLED KATAKANA WA",
    "32FC": "CIRCLED KATAKANA WI",
    "32FD": "CIRCLED KATAKANA WE",
    "32FE": "CIRCLED KATAKANA WO",
    "3300": "SQUARE APAATO",
    "3301": "SQUARE ARUHUA",
    "3302": "SQUARE ANPEA",
    "3303": "SQUARE AARU",
    "3304": "SQUARE ININGU",
    "3305": "SQUARE INTI",
    "3306": "SQUARE UON",
    "3307": "SQUARE ESUKUUDO",
    "3308": "SQUARE EEKAA",
    "3309": "SQUARE ONSU",
    "330A": "SQUARE OOMU",
    "330B": "SQUARE KAIRI",
    "330C": "SQUARE KARATTO",
    "330D": "SQUARE KARORII",
    "330E": "SQUARE GARON",
    "330F": "SQUARE GANMA",
    "3310": "SQUARE GIGA",
    "3311": "SQUARE GINII",
    "3312": "SQUARE KYURII",
    "3313": "SQUARE GIRUDAA",
    "3314": "SQUARE KIRO",
    "3315": "SQUARE KIROGURAMU",
    "3316": "SQUARE KIROMEETORU",
    "3317": "SQUARE KIROWATTO",
    "3318": "SQUARE GURAMU",
    "3319": "SQUARE GURAMUTON",
    "331A": "SQUARE KURUZEIRO",
    "331B": "SQUARE KUROONE",
    "331C": "SQUARE KEESU",
    "331D": "SQUARE KORUNA",
    "331E": "SQUARE KOOPO",
    "331F": "SQUARE SAIKURU",
    "3320": "SQUARE SANTIIMU",
    "3321": "SQUARE SIRINGU",
    "3322": "SQUARE SENTI",
    "3323": "SQUARE SENTO",
    "3324": "SQUARE DAASU",
    "3325": "SQUARE DESI",
    "3326": "SQUARE DORU",
    "3327": "SQUARE TON",
    "3328": "SQUARE NANO",
    "3329": "SQUARE NOTTO",
    "332A": "SQUARE HAITU",
    "332B": "SQUARE PAASENTO",
    "332C": "SQUARE PAATU",
    "332D": "SQUARE BAARERU",
    "332E": "SQUARE PIASUTORU",
    "332F": "SQUARE PIKURU",
    "3330": "SQUARE PIKO",
    "3331": "SQUARE BIRU",
    "3332": "SQUARE HUARADDO",
    "3333": "SQUARE HUIITO",
    "3334": "SQUARE BUSSYERU",
    "3335": "SQUARE HURAN",
    "3336": "SQUARE HEKUTAARU",
    "3337": "SQUARE PESO",
    "3338": "SQUARE PENIHI",
    "3339": "SQUARE HERUTU",
    "333A": "SQUARE PENSU",
    "333B": "SQUARE PEEZI",
    "333C": "SQUARE BEETA",
    "333D": "SQUARE POINTO",
    "333E": "SQUARE BORUTO",
    "333F": "SQUARE HON",
    "3340": "SQUARE PONDO",
    "3341": "SQUARE HOORU",
    "3342": "SQUARE HOON",
    "3343": "SQUARE MAIKURO",
    "3344": "SQUARE MAIRU",
    "3345": "SQUARE MAHHA",
    "3346": "SQUARE MARUKU",
    "3347": "SQUARE MANSYON",
    "3348": "SQUARE MIKURON",
    "3349": "SQUARE MIRI",
    "334A": "SQUARE MIRIBAARU",
    "334B": "SQUARE MEGA",
    "334C": "SQUARE MEGATON",
    "334D": "SQUARE MEETORU",
    "334E": "SQUARE YAADO",
    "334F": "SQUARE YAARU",
    "3350": "SQUARE YUAN",
    "3351": "SQUARE RITTORU",
    "3352": "SQUARE RIRA",
    "3353": "SQUARE RUPII",
    "3354": "SQUARE RUUBURU",
    "3355": "SQUARE REMU",
    "3356": "SQUARE RENTOGEN",
    "3357": "SQUARE WATTO",
    "3358": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO",
    "3359": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE",
    "335A": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO",
    "335B": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE",
    "335C": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR",
    "335D": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE",
    "335E": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX",
    "335F": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN",
    "3360": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT",
    "3361": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE",
    "3362": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN",
    "3363": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN",
    "3364": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE",
    "3365": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN",
    "3366": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN",
    "3367": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN",
    "3368": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN",
    "3369": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN",
    "336A": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN",
    "336B": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN",
    "336C": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY",
    "336D": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE",
    "336E": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO",
    "336F": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE",
    "3370": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR",
    "3371": "SQUARE HPA",
    "3372": "SQUARE DA",
    "3373": "SQUARE AU",
    "3374": "SQUARE BAR",
    "3375": "SQUARE OV",
    "3376": "SQUARE PC",
    "3377": "SQUARE DM",
    "3378": "SQUARE DM SQUARED",
    "3379": "SQUARE DM CUBED",
    "337A": "SQUARE IU",
    "337B": "SQUARE ERA NAME HEISEI",
    "337C": "SQUARE ERA NAME SYOUWA",
    "337D": "SQUARE ERA NAME TAISYOU",
    "337E": "SQUARE ERA NAME MEIZI",
    "337F": "SQUARE CORPORATION",
    "3380": "SQUARE PA AMPS",
    "3381": "SQUARE NA",
    "3382": "SQUARE MU A",
    "3383": "SQUARE MA",
    "3384": "SQUARE KA",
    "3385": "SQUARE KB",
    "3386": "SQUARE MB",
    "3387": "SQUARE GB",
    "3388": "SQUARE CAL",
    "3389": "SQUARE KCAL",
    "338A": "SQUARE PF",
    "338B": "SQUARE NF",
    "338C": "SQUARE MU F",
    "338D": "SQUARE MU G",
    "338E": "SQUARE MG",
    "338F": "SQUARE KG",
    "3390": "SQUARE HZ",
    "3391": "SQUARE KHZ",
    "3392": "SQUARE MHZ",
    "3393": "SQUARE GHZ",
    "3394": "SQUARE THZ",
    "3395": "SQUARE MU L",
    "3396": "SQUARE ML",
    "3397": "SQUARE DL",
    "3398": "SQUARE KL",
    "3399": "SQUARE FM",
    "339A": "SQUARE NM",
    "339B": "SQUARE MU M",
    "339C": "SQUARE MM",
    "339D": "SQUARE CM",
    "339E": "SQUARE KM",
    "339F": "SQUARE MM SQUARED",
    "33A0": "SQUARE CM SQUARED",
    "33A1": "SQUARE M SQUARED",
    "33A2": "SQUARE KM SQUARED",
    "33A3": "SQUARE MM CUBED",
    "33A4": "SQUARE CM CUBED",
    "33A5": "SQUARE M CUBED",
    "33A6": "SQUARE KM CUBED",
    "33A7": "SQUARE M OVER S",
    "33A8": "SQUARE M OVER S SQUARED",
    "33A9": "SQUARE PA",
    "33AA": "SQUARE KPA",
    "33AB": "SQUARE MPA",
    "33AC": "SQUARE GPA",
    "33AD": "SQUARE RAD",
    "33AE": "SQUARE RAD OVER S",
    "33AF": "SQUARE RAD OVER S SQUARED",
    "33B0": "SQUARE PS",
    "33B1": "SQUARE NS",
    "33B2": "SQUARE MU S",
    "33B3": "SQUARE MS",
    "33B4": "SQUARE PV",
    "33B5": "SQUARE NV",
    "33B6": "SQUARE MU V",
    "33B7": "SQUARE MV",
    "33B8": "SQUARE KV",
    "33B9": "SQUARE MV MEGA",
    "33BA": "SQUARE PW",
    "33BB": "SQUARE NW",
    "33BC": "SQUARE MU W",
    "33BD": "SQUARE MW",
    "33BE": "SQUARE KW",
    "33BF": "SQUARE MW MEGA",
    "33C0": "SQUARE K OHM",
    "33C1": "SQUARE M OHM",
    "33C2": "SQUARE AM",
    "33C3": "SQUARE BQ",
    "33C4": "SQUARE CC",
    "33C5": "SQUARE CD",
    "33C6": "SQUARE C OVER KG",
    "33C7": "SQUARE CO",
    "33C8": "SQUARE DB",
    "33C9": "SQUARE GY",
    "33CA": "SQUARE HA",
    "33CB": "SQUARE HP",
    "33CC": "SQUARE IN",
    "33CD": "SQUARE KK",
    "33CE": "SQUARE KM CAPITAL",
    "33CF": "SQUARE KT",
    "33D0": "SQUARE LM",
    "33D1": "SQUARE LN",
    "33D2": "SQUARE LOG",
    "33D3": "SQUARE LX",
    "33D4": "SQUARE MB SMALL",
    "33D5": "SQUARE MIL",
    "33D6": "SQUARE MOL",
    "33D7": "SQUARE PH",
    "33D8": "SQUARE PM",
    "33D9": "SQUARE PPM",
    "33DA": "SQUARE PR",
    "33DB": "SQUARE SR",
    "33DC": "SQUARE SV",
    "33DD": "SQUARE WB",
    "33DE": "SQUARE V OVER M",
    "33DF": "SQUARE A OVER M",
    "33E0": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE",
    "33E1": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO",
    "33E2": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE",
    "33E3": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR",
    "33E4": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE",
    "33E5": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX",
    "33E6": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN",
    "33E7": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT",
    "33E8": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE",
    "33E9": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN",
    "33EA": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN",
    "33EB": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE",
    "33EC": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN",
    "33ED": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN",
    "33EE": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN",
    "33EF": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN",
    "33F0": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN",
    "33F1": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN",
    "33F2": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN",
    "33F3": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY",
    "33F4": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE",
    "33F5": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO",
    "33F6": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE",
    "33F7": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR",
    "33F8": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE",
    "33F9": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX",
    "33FA": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN",
    "33FB": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT",
    "33FC": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE",
    "33FD": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY",
    "33FE": "IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE",
    "33FF": "SQUARE GAL",
    # "3400":  "<CJK Ideograph Extension A, First>", */
    # "4DB5":  "<CJK Ideograph Extension A, Last>", */
    "4DC0": "HEXAGRAM FOR THE CREATIVE HEAVEN",
    "4DC1": "HEXAGRAM FOR THE RECEPTIVE EARTH",
    "4DC2": "HEXAGRAM FOR DIFFICULTY AT THE BEGINNING",
    "4DC3": "HEXAGRAM FOR YOUTHFUL FOLLY",
    "4DC4": "HEXAGRAM FOR WAITING",
    "4DC5": "HEXAGRAM FOR CONFLICT",
    "4DC6": "HEXAGRAM FOR THE ARMY",
    "4DC7": "HEXAGRAM FOR HOLDING TOGETHER",
    "4DC8": "HEXAGRAM FOR SMALL TAMING",
    "4DC9": "HEXAGRAM FOR TREADING",
    "4DCA": "HEXAGRAM FOR PEACE",
    "4DCB": "HEXAGRAM FOR STANDSTILL",
    "4DCC": "HEXAGRAM FOR FELLOWSHIP",
    "4DCD": "HEXAGRAM FOR GREAT POSSESSION",
    "4DCE": "HEXAGRAM FOR MODESTY",
    "4DCF": "HEXAGRAM FOR ENTHUSIASM",
    "4DD0": "HEXAGRAM FOR FOLLOWING",
    "4DD1": "HEXAGRAM FOR WORK ON THE DECAYED",
    "4DD2": "HEXAGRAM FOR APPROACH",
    "4DD3": "HEXAGRAM FOR CONTEMPLATION",
    "4DD4": "HEXAGRAM FOR BITING THROUGH",
    "4DD5": "HEXAGRAM FOR GRACE",
    "4DD6": "HEXAGRAM FOR SPLITTING APART",
    "4DD7": "HEXAGRAM FOR RETURN",
    "4DD8": "HEXAGRAM FOR INNOCENCE",
    "4DD9": "HEXAGRAM FOR GREAT TAMING",
    "4DDA": "HEXAGRAM FOR MOUTH CORNERS",
    "4DDB": "HEXAGRAM FOR GREAT PREPONDERANCE",
    "4DDC": "HEXAGRAM FOR THE ABYSMAL WATER",
    "4DDD": "HEXAGRAM FOR THE CLINGING FIRE",
    "4DDE": "HEXAGRAM FOR INFLUENCE",
    "4DDF": "HEXAGRAM FOR DURATION",
    "4DE0": "HEXAGRAM FOR RETREAT",
    "4DE1": "HEXAGRAM FOR GREAT POWER",
    "4DE2": "HEXAGRAM FOR PROGRESS",
    "4DE3": "HEXAGRAM FOR DARKENING OF THE LIGHT",
    "4DE4": "HEXAGRAM FOR THE FAMILY",
    "4DE5": "HEXAGRAM FOR OPPOSITION",
    "4DE6": "HEXAGRAM FOR OBSTRUCTION",
    "4DE7": "HEXAGRAM FOR DELIVERANCE",
    "4DE8": "HEXAGRAM FOR DECREASE",
    "4DE9": "HEXAGRAM FOR INCREASE",
    "4DEA": "HEXAGRAM FOR BREAKTHROUGH",
    "4DEB": "HEXAGRAM FOR COMING TO MEET",
    "4DEC": "HEXAGRAM FOR GATHERING TOGETHER",
    "4DED": "HEXAGRAM FOR PUSHING UPWARD",
    "4DEE": "HEXAGRAM FOR OPPRESSION",
    "4DEF": "HEXAGRAM FOR THE WELL",
    "4DF0": "HEXAGRAM FOR REVOLUTION",
    "4DF1": "HEXAGRAM FOR THE CAULDRON",
    "4DF2": "HEXAGRAM FOR THE AROUSING THUNDER",
    "4DF3": "HEXAGRAM FOR THE KEEPING STILL MOUNTAIN",
    "4DF4": "HEXAGRAM FOR DEVELOPMENT",
    "4DF5": "HEXAGRAM FOR THE MARRYING MAIDEN",
    "4DF6": "HEXAGRAM FOR ABUNDANCE",
    "4DF7": "HEXAGRAM FOR THE WANDERER",
    "4DF8": "HEXAGRAM FOR THE GENTLE WIND",
    "4DF9": "HEXAGRAM FOR THE JOYOUS LAKE",
    "4DFA": "HEXAGRAM FOR DISPERSION",
    "4DFB": "HEXAGRAM FOR LIMITATION",
    "4DFC": "HEXAGRAM FOR INNER TRUTH",
    "4DFD": "HEXAGRAM FOR SMALL PREPONDERANCE",
    "4DFE": "HEXAGRAM FOR AFTER COMPLETION",
    "4DFF": "HEXAGRAM FOR BEFORE COMPLETION",
    # "4E00":  "<CJK Ideograph, First>", */
    # "9FD5":  "<CJK Ideograph, Last>", */
    "A000": "YI SYLLABLE IT",
    "A001": "YI SYLLABLE IX",
    "A002": "YI SYLLABLE I",
    "A003": "YI SYLLABLE IP",
    "A004": "YI SYLLABLE IET",
    "A005": "YI SYLLABLE IEX",
    "A006": "YI SYLLABLE IE",
    "A007": "YI SYLLABLE IEP",
    "A008": "YI SYLLABLE AT",
    "A009": "YI SYLLABLE AX",
    "A00A": "YI SYLLABLE A",
    "A00B": "YI SYLLABLE AP",
    "A00C": "YI SYLLABLE UOX",
    "A00D": "YI SYLLABLE UO",
    "A00E": "YI SYLLABLE UOP",
    "A00F": "YI SYLLABLE OT",
    "A010": "YI SYLLABLE OX",
    "A011": "YI SYLLABLE O",
    "A012": "YI SYLLABLE OP",
    "A013": "YI SYLLABLE EX",
    "A014": "YI SYLLABLE E",
    "A015": "YI SYLLABLE WU",
    "A016": "YI SYLLABLE BIT",
    "A017": "YI SYLLABLE BIX",
    "A018": "YI SYLLABLE BI",
    "A019": "YI SYLLABLE BIP",
    "A01A": "YI SYLLABLE BIET",
    "A01B": "YI SYLLABLE BIEX",
    "A01C": "YI SYLLABLE BIE",
    "A01D": "YI SYLLABLE BIEP",
    "A01E": "YI SYLLABLE BAT",
    "A01F": "YI SYLLABLE BAX",
    "A020": "YI SYLLABLE BA",
    "A021": "YI SYLLABLE BAP",
    "A022": "YI SYLLABLE BUOX",
    "A023": "YI SYLLABLE BUO",
    "A024": "YI SYLLABLE BUOP",
    "A025": "YI SYLLABLE BOT",
    "A026": "YI SYLLABLE BOX",
    "A027": "YI SYLLABLE BO",
    "A028": "YI SYLLABLE BOP",
    "A029": "YI SYLLABLE BEX",
    "A02A": "YI SYLLABLE BE",
    "A02B": "YI SYLLABLE BEP",
    "A02C": "YI SYLLABLE BUT",
    "A02D": "YI SYLLABLE BUX",
    "A02E": "YI SYLLABLE BU",
    "A02F": "YI SYLLABLE BUP",
    "A030": "YI SYLLABLE BURX",
    "A031": "YI SYLLABLE BUR",
    "A032": "YI SYLLABLE BYT",
    "A033": "YI SYLLABLE BYX",
    "A034": "YI SYLLABLE BY",
    "A035": "YI SYLLABLE BYP",
    "A036": "YI SYLLABLE BYRX",
    "A037": "YI SYLLABLE BYR",
    "A038": "YI SYLLABLE PIT",
    "A039": "YI SYLLABLE PIX",
    "A03A": "YI SYLLABLE PI",
    "A03B": "YI SYLLABLE PIP",
    "A03C": "YI SYLLABLE PIEX",
    "A03D": "YI SYLLABLE PIE",
    "A03E": "YI SYLLABLE PIEP",
    "A03F": "YI SYLLABLE PAT",
    "A040": "YI SYLLABLE PAX",
    "A041": "YI SYLLABLE PA",
    "A042": "YI SYLLABLE PAP",
    "A043": "YI SYLLABLE PUOX",
    "A044": "YI SYLLABLE PUO",
    "A045": "YI SYLLABLE PUOP",
    "A046": "YI SYLLABLE POT",
    "A047": "YI SYLLABLE POX",
    "A048": "YI SYLLABLE PO",
    "A049": "YI SYLLABLE POP",
    "A04A": "YI SYLLABLE PUT",
    "A04B": "YI SYLLABLE PUX",
    "A04C": "YI SYLLABLE PU",
    "A04D": "YI SYLLABLE PUP",
    "A04E": "YI SYLLABLE PURX",
    "A04F": "YI SYLLABLE PUR",
    "A050": "YI SYLLABLE PYT",
    "A051": "YI SYLLABLE PYX",
    "A052": "YI SYLLABLE PY",
    "A053": "YI SYLLABLE PYP",
    "A054": "YI SYLLABLE PYRX",
    "A055": "YI SYLLABLE PYR",
    "A056": "YI SYLLABLE BBIT",
    "A057": "YI SYLLABLE BBIX",
    "A058": "YI SYLLABLE BBI",
    "A059": "YI SYLLABLE BBIP",
    "A05A": "YI SYLLABLE BBIET",
    "A05B": "YI SYLLABLE BBIEX",
    "A05C": "YI SYLLABLE BBIE",
    "A05D": "YI SYLLABLE BBIEP",
    "A05E": "YI SYLLABLE BBAT",
    "A05F": "YI SYLLABLE BBAX",
    "A060": "YI SYLLABLE BBA",
    "A061": "YI SYLLABLE BBAP",
    "A062": "YI SYLLABLE BBUOX",
    "A063": "YI SYLLABLE BBUO",
    "A064": "YI SYLLABLE BBUOP",
    "A065": "YI SYLLABLE BBOT",
    "A066": "YI SYLLABLE BBOX",
    "A067": "YI SYLLABLE BBO",
    "A068": "YI SYLLABLE BBOP",
    "A069": "YI SYLLABLE BBEX",
    "A06A": "YI SYLLABLE BBE",
    "A06B": "YI SYLLABLE BBEP",
    "A06C": "YI SYLLABLE BBUT",
    "A06D": "YI SYLLABLE BBUX",
    "A06E": "YI SYLLABLE BBU",
    "A06F": "YI SYLLABLE BBUP",
    "A070": "YI SYLLABLE BBURX",
    "A071": "YI SYLLABLE BBUR",
    "A072": "YI SYLLABLE BBYT",
    "A073": "YI SYLLABLE BBYX",
    "A074": "YI SYLLABLE BBY",
    "A075": "YI SYLLABLE BBYP",
    "A076": "YI SYLLABLE NBIT",
    "A077": "YI SYLLABLE NBIX",
    "A078": "YI SYLLABLE NBI",
    "A079": "YI SYLLABLE NBIP",
    "A07A": "YI SYLLABLE NBIEX",
    "A07B": "YI SYLLABLE NBIE",
    "A07C": "YI SYLLABLE NBIEP",
    "A07D": "YI SYLLABLE NBAT",
    "A07E": "YI SYLLABLE NBAX",
    "A07F": "YI SYLLABLE NBA",
    "A080": "YI SYLLABLE NBAP",
    "A081": "YI SYLLABLE NBOT",
    "A082": "YI SYLLABLE NBOX",
    "A083": "YI SYLLABLE NBO",
    "A084": "YI SYLLABLE NBOP",
    "A085": "YI SYLLABLE NBUT",
    "A086": "YI SYLLABLE NBUX",
    "A087": "YI SYLLABLE NBU",
    "A088": "YI SYLLABLE NBUP",
    "A089": "YI SYLLABLE NBURX",
    "A08A": "YI SYLLABLE NBUR",
    "A08B": "YI SYLLABLE NBYT",
    "A08C": "YI SYLLABLE NBYX",
    "A08D": "YI SYLLABLE NBY",
    "A08E": "YI SYLLABLE NBYP",
    "A08F": "YI SYLLABLE NBYRX",
    "A090": "YI SYLLABLE NBYR",
    "A091": "YI SYLLABLE HMIT",
    "A092": "YI SYLLABLE HMIX",
    "A093": "YI SYLLABLE HMI",
    "A094": "YI SYLLABLE HMIP",
    "A095": "YI SYLLABLE HMIEX",
    "A096": "YI SYLLABLE HMIE",
    "A097": "YI SYLLABLE HMIEP",
    "A098": "YI SYLLABLE HMAT",
    "A099": "YI SYLLABLE HMAX",
    "A09A": "YI SYLLABLE HMA",
    "A09B": "YI SYLLABLE HMAP",
    "A09C": "YI SYLLABLE HMUOX",
    "A09D": "YI SYLLABLE HMUO",
    "A09E": "YI SYLLABLE HMUOP",
    "A09F": "YI SYLLABLE HMOT",
    "A0A0": "YI SYLLABLE HMOX",
    "A0A1": "YI SYLLABLE HMO",
    "A0A2": "YI SYLLABLE HMOP",
    "A0A3": "YI SYLLABLE HMUT",
    "A0A4": "YI SYLLABLE HMUX",
    "A0A5": "YI SYLLABLE HMU",
    "A0A6": "YI SYLLABLE HMUP",
    "A0A7": "YI SYLLABLE HMURX",
    "A0A8": "YI SYLLABLE HMUR",
    "A0A9": "YI SYLLABLE HMYX",
    "A0AA": "YI SYLLABLE HMY",
    "A0AB": "YI SYLLABLE HMYP",
    "A0AC": "YI SYLLABLE HMYRX",
    "A0AD": "YI SYLLABLE HMYR",
    "A0AE": "YI SYLLABLE MIT",
    "A0AF": "YI SYLLABLE MIX",
    "A0B0": "YI SYLLABLE MI",
    "A0B1": "YI SYLLABLE MIP",
    "A0B2": "YI SYLLABLE MIEX",
    "A0B3": "YI SYLLABLE MIE",
    "A0B4": "YI SYLLABLE MIEP",
    "A0B5": "YI SYLLABLE MAT",
    "A0B6": "YI SYLLABLE MAX",
    "A0B7": "YI SYLLABLE MA",
    "A0B8": "YI SYLLABLE MAP",
    "A0B9": "YI SYLLABLE MUOT",
    "A0BA": "YI SYLLABLE MUOX",
    "A0BB": "YI SYLLABLE MUO",
    "A0BC": "YI SYLLABLE MUOP",
    "A0BD": "YI SYLLABLE MOT",
    "A0BE": "YI SYLLABLE MOX",
    "A0BF": "YI SYLLABLE MO",
    "A0C0": "YI SYLLABLE MOP",
    "A0C1": "YI SYLLABLE MEX",
    "A0C2": "YI SYLLABLE ME",
    "A0C3": "YI SYLLABLE MUT",
    "A0C4": "YI SYLLABLE MUX",
    "A0C5": "YI SYLLABLE MU",
    "A0C6": "YI SYLLABLE MUP",
    "A0C7": "YI SYLLABLE MURX",
    "A0C8": "YI SYLLABLE MUR",
    "A0C9": "YI SYLLABLE MYT",
    "A0CA": "YI SYLLABLE MYX",
    "A0CB": "YI SYLLABLE MY",
    "A0CC": "YI SYLLABLE MYP",
    "A0CD": "YI SYLLABLE FIT",
    "A0CE": "YI SYLLABLE FIX",
    "A0CF": "YI SYLLABLE FI",
    "A0D0": "YI SYLLABLE FIP",
    "A0D1": "YI SYLLABLE FAT",
    "A0D2": "YI SYLLABLE FAX",
    "A0D3": "YI SYLLABLE FA",
    "A0D4": "YI SYLLABLE FAP",
    "A0D5": "YI SYLLABLE FOX",
    "A0D6": "YI SYLLABLE FO",
    "A0D7": "YI SYLLABLE FOP",
    "A0D8": "YI SYLLABLE FUT",
    "A0D9": "YI SYLLABLE FUX",
    "A0DA": "YI SYLLABLE FU",
    "A0DB": "YI SYLLABLE FUP",
    "A0DC": "YI SYLLABLE FURX",
    "A0DD": "YI SYLLABLE FUR",
    "A0DE": "YI SYLLABLE FYT",
    "A0DF": "YI SYLLABLE FYX",
    "A0E0": "YI SYLLABLE FY",
    "A0E1": "YI SYLLABLE FYP",
    "A0E2": "YI SYLLABLE VIT",
    "A0E3": "YI SYLLABLE VIX",
    "A0E4": "YI SYLLABLE VI",
    "A0E5": "YI SYLLABLE VIP",
    "A0E6": "YI SYLLABLE VIET",
    "A0E7": "YI SYLLABLE VIEX",
    "A0E8": "YI SYLLABLE VIE",
    "A0E9": "YI SYLLABLE VIEP",
    "A0EA": "YI SYLLABLE VAT",
    "A0EB": "YI SYLLABLE VAX",
    "A0EC": "YI SYLLABLE VA",
    "A0ED": "YI SYLLABLE VAP",
    "A0EE": "YI SYLLABLE VOT",
    "A0EF": "YI SYLLABLE VOX",
    "A0F0": "YI SYLLABLE VO",
    "A0F1": "YI SYLLABLE VOP",
    "A0F2": "YI SYLLABLE VEX",
    "A0F3": "YI SYLLABLE VEP",
    "A0F4": "YI SYLLABLE VUT",
    "A0F5": "YI SYLLABLE VUX",
    "A0F6": "YI SYLLABLE VU",
    "A0F7": "YI SYLLABLE VUP",
    "A0F8": "YI SYLLABLE VURX",
    "A0F9": "YI SYLLABLE VUR",
    "A0FA": "YI SYLLABLE VYT",
    "A0FB": "YI SYLLABLE VYX",
    "A0FC": "YI SYLLABLE VY",
    "A0FD": "YI SYLLABLE VYP",
    "A0FE": "YI SYLLABLE VYRX",
    "A0FF": "YI SYLLABLE VYR",
    "A100": "YI SYLLABLE DIT",
    "A101": "YI SYLLABLE DIX",
    "A102": "YI SYLLABLE DI",
    "A103": "YI SYLLABLE DIP",
    "A104": "YI SYLLABLE DIEX",
    "A105": "YI SYLLABLE DIE",
    "A106": "YI SYLLABLE DIEP",
    "A107": "YI SYLLABLE DAT",
    "A108": "YI SYLLABLE DAX",
    "A109": "YI SYLLABLE DA",
    "A10A": "YI SYLLABLE DAP",
    "A10B": "YI SYLLABLE DUOX",
    "A10C": "YI SYLLABLE DUO",
    "A10D": "YI SYLLABLE DOT",
    "A10E": "YI SYLLABLE DOX",
    "A10F": "YI SYLLABLE DO",
    "A110": "YI SYLLABLE DOP",
    "A111": "YI SYLLABLE DEX",
    "A112": "YI SYLLABLE DE",
    "A113": "YI SYLLABLE DEP",
    "A114": "YI SYLLABLE DUT",
    "A115": "YI SYLLABLE DUX",
    "A116": "YI SYLLABLE DU",
    "A117": "YI SYLLABLE DUP",
    "A118": "YI SYLLABLE DURX",
    "A119": "YI SYLLABLE DUR",
    "A11A": "YI SYLLABLE TIT",
    "A11B": "YI SYLLABLE TIX",
    "A11C": "YI SYLLABLE TI",
    "A11D": "YI SYLLABLE TIP",
    "A11E": "YI SYLLABLE TIEX",
    "A11F": "YI SYLLABLE TIE",
    "A120": "YI SYLLABLE TIEP",
    "A121": "YI SYLLABLE TAT",
    "A122": "YI SYLLABLE TAX",
    "A123": "YI SYLLABLE TA",
    "A124": "YI SYLLABLE TAP",
    "A125": "YI SYLLABLE TUOT",
    "A126": "YI SYLLABLE TUOX",
    "A127": "YI SYLLABLE TUO",
    "A128": "YI SYLLABLE TUOP",
    "A129": "YI SYLLABLE TOT",
    "A12A": "YI SYLLABLE TOX",
    "A12B": "YI SYLLABLE TO",
    "A12C": "YI SYLLABLE TOP",
    "A12D": "YI SYLLABLE TEX",
    "A12E": "YI SYLLABLE TE",
    "A12F": "YI SYLLABLE TEP",
    "A130": "YI SYLLABLE TUT",
    "A131": "YI SYLLABLE TUX",
    "A132": "YI SYLLABLE TU",
    "A133": "YI SYLLABLE TUP",
    "A134": "YI SYLLABLE TURX",
    "A135": "YI SYLLABLE TUR",
    "A136": "YI SYLLABLE DDIT",
    "A137": "YI SYLLABLE DDIX",
    "A138": "YI SYLLABLE DDI",
    "A139": "YI SYLLABLE DDIP",
    "A13A": "YI SYLLABLE DDIEX",
    "A13B": "YI SYLLABLE DDIE",
    "A13C": "YI SYLLABLE DDIEP",
    "A13D": "YI SYLLABLE DDAT",
    "A13E": "YI SYLLABLE DDAX",
    "A13F": "YI SYLLABLE DDA",
    "A140": "YI SYLLABLE DDAP",
    "A141": "YI SYLLABLE DDUOX",
    "A142": "YI SYLLABLE DDUO",
    "A143": "YI SYLLABLE DDUOP",
    "A144": "YI SYLLABLE DDOT",
    "A145": "YI SYLLABLE DDOX",
    "A146": "YI SYLLABLE DDO",
    "A147": "YI SYLLABLE DDOP",
    "A148": "YI SYLLABLE DDEX",
    "A149": "YI SYLLABLE DDE",
    "A14A": "YI SYLLABLE DDEP",
    "A14B": "YI SYLLABLE DDUT",
    "A14C": "YI SYLLABLE DDUX",
    "A14D": "YI SYLLABLE DDU",
    "A14E": "YI SYLLABLE DDUP",
    "A14F": "YI SYLLABLE DDURX",
    "A150": "YI SYLLABLE DDUR",
    "A151": "YI SYLLABLE NDIT",
    "A152": "YI SYLLABLE NDIX",
    "A153": "YI SYLLABLE NDI",
    "A154": "YI SYLLABLE NDIP",
    "A155": "YI SYLLABLE NDIEX",
    "A156": "YI SYLLABLE NDIE",
    "A157": "YI SYLLABLE NDAT",
    "A158": "YI SYLLABLE NDAX",
    "A159": "YI SYLLABLE NDA",
    "A15A": "YI SYLLABLE NDAP",
    "A15B": "YI SYLLABLE NDOT",
    "A15C": "YI SYLLABLE NDOX",
    "A15D": "YI SYLLABLE NDO",
    "A15E": "YI SYLLABLE NDOP",
    "A15F": "YI SYLLABLE NDEX",
    "A160": "YI SYLLABLE NDE",
    "A161": "YI SYLLABLE NDEP",
    "A162": "YI SYLLABLE NDUT",
    "A163": "YI SYLLABLE NDUX",
    "A164": "YI SYLLABLE NDU",
    "A165": "YI SYLLABLE NDUP",
    "A166": "YI SYLLABLE NDURX",
    "A167": "YI SYLLABLE NDUR",
    "A168": "YI SYLLABLE HNIT",
    "A169": "YI SYLLABLE HNIX",
    "A16A": "YI SYLLABLE HNI",
    "A16B": "YI SYLLABLE HNIP",
    "A16C": "YI SYLLABLE HNIET",
    "A16D": "YI SYLLABLE HNIEX",
    "A16E": "YI SYLLABLE HNIE",
    "A16F": "YI SYLLABLE HNIEP",
    "A170": "YI SYLLABLE HNAT",
    "A171": "YI SYLLABLE HNAX",
    "A172": "YI SYLLABLE HNA",
    "A173": "YI SYLLABLE HNAP",
    "A174": "YI SYLLABLE HNUOX",
    "A175": "YI SYLLABLE HNUO",
    "A176": "YI SYLLABLE HNOT",
    "A177": "YI SYLLABLE HNOX",
    "A178": "YI SYLLABLE HNOP",
    "A179": "YI SYLLABLE HNEX",
    "A17A": "YI SYLLABLE HNE",
    "A17B": "YI SYLLABLE HNEP",
    "A17C": "YI SYLLABLE HNUT",
    "A17D": "YI SYLLABLE NIT",
    "A17E": "YI SYLLABLE NIX",
    "A17F": "YI SYLLABLE NI",
    "A180": "YI SYLLABLE NIP",
    "A181": "YI SYLLABLE NIEX",
    "A182": "YI SYLLABLE NIE",
    "A183": "YI SYLLABLE NIEP",
    "A184": "YI SYLLABLE NAX",
    "A185": "YI SYLLABLE NA",
    "A186": "YI SYLLABLE NAP",
    "A187": "YI SYLLABLE NUOX",
    "A188": "YI SYLLABLE NUO",
    "A189": "YI SYLLABLE NUOP",
    "A18A": "YI SYLLABLE NOT",
    "A18B": "YI SYLLABLE NOX",
    "A18C": "YI SYLLABLE NO",
    "A18D": "YI SYLLABLE NOP",
    "A18E": "YI SYLLABLE NEX",
    "A18F": "YI SYLLABLE NE",
    "A190": "YI SYLLABLE NEP",
    "A191": "YI SYLLABLE NUT",
    "A192": "YI SYLLABLE NUX",
    "A193": "YI SYLLABLE NU",
    "A194": "YI SYLLABLE NUP",
    "A195": "YI SYLLABLE NURX",
    "A196": "YI SYLLABLE NUR",
    "A197": "YI SYLLABLE HLIT",
    "A198": "YI SYLLABLE HLIX",
    "A199": "YI SYLLABLE HLI",
    "A19A": "YI SYLLABLE HLIP",
    "A19B": "YI SYLLABLE HLIEX",
    "A19C": "YI SYLLABLE HLIE",
    "A19D": "YI SYLLABLE HLIEP",
    "A19E": "YI SYLLABLE HLAT",
    "A19F": "YI SYLLABLE HLAX",
    "A1A0": "YI SYLLABLE HLA",
    "A1A1": "YI SYLLABLE HLAP",
    "A1A2": "YI SYLLABLE HLUOX",
    "A1A3": "YI SYLLABLE HLUO",
    "A1A4": "YI SYLLABLE HLUOP",
    "A1A5": "YI SYLLABLE HLOX",
    "A1A6": "YI SYLLABLE HLO",
    "A1A7": "YI SYLLABLE HLOP",
    "A1A8": "YI SYLLABLE HLEX",
    "A1A9": "YI SYLLABLE HLE",
    "A1AA": "YI SYLLABLE HLEP",
    "A1AB": "YI SYLLABLE HLUT",
    "A1AC": "YI SYLLABLE HLUX",
    "A1AD": "YI SYLLABLE HLU",
    "A1AE": "YI SYLLABLE HLUP",
    "A1AF": "YI SYLLABLE HLURX",
    "A1B0": "YI SYLLABLE HLUR",
    "A1B1": "YI SYLLABLE HLYT",
    "A1B2": "YI SYLLABLE HLYX",
    "A1B3": "YI SYLLABLE HLY",
    "A1B4": "YI SYLLABLE HLYP",
    "A1B5": "YI SYLLABLE HLYRX",
    "A1B6": "YI SYLLABLE HLYR",
    "A1B7": "YI SYLLABLE LIT",
    "A1B8": "YI SYLLABLE LIX",
    "A1B9": "YI SYLLABLE LI",
    "A1BA": "YI SYLLABLE LIP",
    "A1BB": "YI SYLLABLE LIET",
    "A1BC": "YI SYLLABLE LIEX",
    "A1BD": "YI SYLLABLE LIE",
    "A1BE": "YI SYLLABLE LIEP",
    "A1BF": "YI SYLLABLE LAT",
    "A1C0": "YI SYLLABLE LAX",
    "A1C1": "YI SYLLABLE LA",
    "A1C2": "YI SYLLABLE LAP",
    "A1C3": "YI SYLLABLE LUOT",
    "A1C4": "YI SYLLABLE LUOX",
    "A1C5": "YI SYLLABLE LUO",
    "A1C6": "YI SYLLABLE LUOP",
    "A1C7": "YI SYLLABLE LOT",
    "A1C8": "YI SYLLABLE LOX",
    "A1C9": "YI SYLLABLE LO",
    "A1CA": "YI SYLLABLE LOP",
    "A1CB": "YI SYLLABLE LEX",
    "A1CC": "YI SYLLABLE LE",
    "A1CD": "YI SYLLABLE LEP",
    "A1CE": "YI SYLLABLE LUT",
    "A1CF": "YI SYLLABLE LUX",
    "A1D0": "YI SYLLABLE LU",
    "A1D1": "YI SYLLABLE LUP",
    "A1D2": "YI SYLLABLE LURX",
    "A1D3": "YI SYLLABLE LUR",
    "A1D4": "YI SYLLABLE LYT",
    "A1D5": "YI SYLLABLE LYX",
    "A1D6": "YI SYLLABLE LY",
    "A1D7": "YI SYLLABLE LYP",
    "A1D8": "YI SYLLABLE LYRX",
    "A1D9": "YI SYLLABLE LYR",
    "A1DA": "YI SYLLABLE GIT",
    "A1DB": "YI SYLLABLE GIX",
    "A1DC": "YI SYLLABLE GI",
    "A1DD": "YI SYLLABLE GIP",
    "A1DE": "YI SYLLABLE GIET",
    "A1DF": "YI SYLLABLE GIEX",
    "A1E0": "YI SYLLABLE GIE",
    "A1E1": "YI SYLLABLE GIEP",
    "A1E2": "YI SYLLABLE GAT",
    "A1E3": "YI SYLLABLE GAX",
    "A1E4": "YI SYLLABLE GA",
    "A1E5": "YI SYLLABLE GAP",
    "A1E6": "YI SYLLABLE GUOT",
    "A1E7": "YI SYLLABLE GUOX",
    "A1E8": "YI SYLLABLE GUO",
    "A1E9": "YI SYLLABLE GUOP",
    "A1EA": "YI SYLLABLE GOT",
    "A1EB": "YI SYLLABLE GOX",
    "A1EC": "YI SYLLABLE GO",
    "A1ED": "YI SYLLABLE GOP",
    "A1EE": "YI SYLLABLE GET",
    "A1EF": "YI SYLLABLE GEX",
    "A1F0": "YI SYLLABLE GE",
    "A1F1": "YI SYLLABLE GEP",
    "A1F2": "YI SYLLABLE GUT",
    "A1F3": "YI SYLLABLE GUX",
    "A1F4": "YI SYLLABLE GU",
    "A1F5": "YI SYLLABLE GUP",
    "A1F6": "YI SYLLABLE GURX",
    "A1F7": "YI SYLLABLE GUR",
    "A1F8": "YI SYLLABLE KIT",
    "A1F9": "YI SYLLABLE KIX",
    "A1FA": "YI SYLLABLE KI",
    "A1FB": "YI SYLLABLE KIP",
    "A1FC": "YI SYLLABLE KIEX",
    "A1FD": "YI SYLLABLE KIE",
    "A1FE": "YI SYLLABLE KIEP",
    "A1FF": "YI SYLLABLE KAT",
    "A200": "YI SYLLABLE KAX",
    "A201": "YI SYLLABLE KA",
    "A202": "YI SYLLABLE KAP",
    "A203": "YI SYLLABLE KUOX",
    "A204": "YI SYLLABLE KUO",
    "A205": "YI SYLLABLE KUOP",
    "A206": "YI SYLLABLE KOT",
    "A207": "YI SYLLABLE KOX",
    "A208": "YI SYLLABLE KO",
    "A209": "YI SYLLABLE KOP",
    "A20A": "YI SYLLABLE KET",
    "A20B": "YI SYLLABLE KEX",
    "A20C": "YI SYLLABLE KE",
    "A20D": "YI SYLLABLE KEP",
    "A20E": "YI SYLLABLE KUT",
    "A20F": "YI SYLLABLE KUX",
    "A210": "YI SYLLABLE KU",
    "A211": "YI SYLLABLE KUP",
    "A212": "YI SYLLABLE KURX",
    "A213": "YI SYLLABLE KUR",
    "A214": "YI SYLLABLE GGIT",
    "A215": "YI SYLLABLE GGIX",
    "A216": "YI SYLLABLE GGI",
    "A217": "YI SYLLABLE GGIEX",
    "A218": "YI SYLLABLE GGIE",
    "A219": "YI SYLLABLE GGIEP",
    "A21A": "YI SYLLABLE GGAT",
    "A21B": "YI SYLLABLE GGAX",
    "A21C": "YI SYLLABLE GGA",
    "A21D": "YI SYLLABLE GGAP",
    "A21E": "YI SYLLABLE GGUOT",
    "A21F": "YI SYLLABLE GGUOX",
    "A220": "YI SYLLABLE GGUO",
    "A221": "YI SYLLABLE GGUOP",
    "A222": "YI SYLLABLE GGOT",
    "A223": "YI SYLLABLE GGOX",
    "A224": "YI SYLLABLE GGO",
    "A225": "YI SYLLABLE GGOP",
    "A226": "YI SYLLABLE GGET",
    "A227": "YI SYLLABLE GGEX",
    "A228": "YI SYLLABLE GGE",
    "A229": "YI SYLLABLE GGEP",
    "A22A": "YI SYLLABLE GGUT",
    "A22B": "YI SYLLABLE GGUX",
    "A22C": "YI SYLLABLE GGU",
    "A22D": "YI SYLLABLE GGUP",
    "A22E": "YI SYLLABLE GGURX",
    "A22F": "YI SYLLABLE GGUR",
    "A230": "YI SYLLABLE MGIEX",
    "A231": "YI SYLLABLE MGIE",
    "A232": "YI SYLLABLE MGAT",
    "A233": "YI SYLLABLE MGAX",
    "A234": "YI SYLLABLE MGA",
    "A235": "YI SYLLABLE MGAP",
    "A236": "YI SYLLABLE MGUOX",
    "A237": "YI SYLLABLE MGUO",
    "A238": "YI SYLLABLE MGUOP",
    "A239": "YI SYLLABLE MGOT",
    "A23A": "YI SYLLABLE MGOX",
    "A23B": "YI SYLLABLE MGO",
    "A23C": "YI SYLLABLE MGOP",
    "A23D": "YI SYLLABLE MGEX",
    "A23E": "YI SYLLABLE MGE",
    "A23F": "YI SYLLABLE MGEP",
    "A240": "YI SYLLABLE MGUT",
    "A241": "YI SYLLABLE MGUX",
    "A242": "YI SYLLABLE MGU",
    "A243": "YI SYLLABLE MGUP",
    "A244": "YI SYLLABLE MGURX",
    "A245": "YI SYLLABLE MGUR",
    "A246": "YI SYLLABLE HXIT",
    "A247": "YI SYLLABLE HXIX",
    "A248": "YI SYLLABLE HXI",
    "A249": "YI SYLLABLE HXIP",
    "A24A": "YI SYLLABLE HXIET",
    "A24B": "YI SYLLABLE HXIEX",
    "A24C": "YI SYLLABLE HXIE",
    "A24D": "YI SYLLABLE HXIEP",
    "A24E": "YI SYLLABLE HXAT",
    "A24F": "YI SYLLABLE HXAX",
    "A250": "YI SYLLABLE HXA",
    "A251": "YI SYLLABLE HXAP",
    "A252": "YI SYLLABLE HXUOT",
    "A253": "YI SYLLABLE HXUOX",
    "A254": "YI SYLLABLE HXUO",
    "A255": "YI SYLLABLE HXUOP",
    "A256": "YI SYLLABLE HXOT",
    "A257": "YI SYLLABLE HXOX",
    "A258": "YI SYLLABLE HXO",
    "A259": "YI SYLLABLE HXOP",
    "A25A": "YI SYLLABLE HXEX",
    "A25B": "YI SYLLABLE HXE",
    "A25C": "YI SYLLABLE HXEP",
    "A25D": "YI SYLLABLE NGIEX",
    "A25E": "YI SYLLABLE NGIE",
    "A25F": "YI SYLLABLE NGIEP",
    "A260": "YI SYLLABLE NGAT",
    "A261": "YI SYLLABLE NGAX",
    "A262": "YI SYLLABLE NGA",
    "A263": "YI SYLLABLE NGAP",
    "A264": "YI SYLLABLE NGUOT",
    "A265": "YI SYLLABLE NGUOX",
    "A266": "YI SYLLABLE NGUO",
    "A267": "YI SYLLABLE NGOT",
    "A268": "YI SYLLABLE NGOX",
    "A269": "YI SYLLABLE NGO",
    "A26A": "YI SYLLABLE NGOP",
    "A26B": "YI SYLLABLE NGEX",
    "A26C": "YI SYLLABLE NGE",
    "A26D": "YI SYLLABLE NGEP",
    "A26E": "YI SYLLABLE HIT",
    "A26F": "YI SYLLABLE HIEX",
    "A270": "YI SYLLABLE HIE",
    "A271": "YI SYLLABLE HAT",
    "A272": "YI SYLLABLE HAX",
    "A273": "YI SYLLABLE HA",
    "A274": "YI SYLLABLE HAP",
    "A275": "YI SYLLABLE HUOT",
    "A276": "YI SYLLABLE HUOX",
    "A277": "YI SYLLABLE HUO",
    "A278": "YI SYLLABLE HUOP",
    "A279": "YI SYLLABLE HOT",
    "A27A": "YI SYLLABLE HOX",
    "A27B": "YI SYLLABLE HO",
    "A27C": "YI SYLLABLE HOP",
    "A27D": "YI SYLLABLE HEX",
    "A27E": "YI SYLLABLE HE",
    "A27F": "YI SYLLABLE HEP",
    "A280": "YI SYLLABLE WAT",
    "A281": "YI SYLLABLE WAX",
    "A282": "YI SYLLABLE WA",
    "A283": "YI SYLLABLE WAP",
    "A284": "YI SYLLABLE WUOX",
    "A285": "YI SYLLABLE WUO",
    "A286": "YI SYLLABLE WUOP",
    "A287": "YI SYLLABLE WOX",
    "A288": "YI SYLLABLE WO",
    "A289": "YI SYLLABLE WOP",
    "A28A": "YI SYLLABLE WEX",
    "A28B": "YI SYLLABLE WE",
    "A28C": "YI SYLLABLE WEP",
    "A28D": "YI SYLLABLE ZIT",
    "A28E": "YI SYLLABLE ZIX",
    "A28F": "YI SYLLABLE ZI",
    "A290": "YI SYLLABLE ZIP",
    "A291": "YI SYLLABLE ZIEX",
    "A292": "YI SYLLABLE ZIE",
    "A293": "YI SYLLABLE ZIEP",
    "A294": "YI SYLLABLE ZAT",
    "A295": "YI SYLLABLE ZAX",
    "A296": "YI SYLLABLE ZA",
    "A297": "YI SYLLABLE ZAP",
    "A298": "YI SYLLABLE ZUOX",
    "A299": "YI SYLLABLE ZUO",
    "A29A": "YI SYLLABLE ZUOP",
    "A29B": "YI SYLLABLE ZOT",
    "A29C": "YI SYLLABLE ZOX",
    "A29D": "YI SYLLABLE ZO",
    "A29E": "YI SYLLABLE ZOP",
    "A29F": "YI SYLLABLE ZEX",
    "A2A0": "YI SYLLABLE ZE",
    "A2A1": "YI SYLLABLE ZEP",
    "A2A2": "YI SYLLABLE ZUT",
    "A2A3": "YI SYLLABLE ZUX",
    "A2A4": "YI SYLLABLE ZU",
    "A2A5": "YI SYLLABLE ZUP",
    "A2A6": "YI SYLLABLE ZURX",
    "A2A7": "YI SYLLABLE ZUR",
    "A2A8": "YI SYLLABLE ZYT",
    "A2A9": "YI SYLLABLE ZYX",
    "A2AA": "YI SYLLABLE ZY",
    "A2AB": "YI SYLLABLE ZYP",
    "A2AC": "YI SYLLABLE ZYRX",
    "A2AD": "YI SYLLABLE ZYR",
    "A2AE": "YI SYLLABLE CIT",
    "A2AF": "YI SYLLABLE CIX",
    "A2B0": "YI SYLLABLE CI",
    "A2B1": "YI SYLLABLE CIP",
    "A2B2": "YI SYLLABLE CIET",
    "A2B3": "YI SYLLABLE CIEX",
    "A2B4": "YI SYLLABLE CIE",
    "A2B5": "YI SYLLABLE CIEP",
    "A2B6": "YI SYLLABLE CAT",
    "A2B7": "YI SYLLABLE CAX",
    "A2B8": "YI SYLLABLE CA",
    "A2B9": "YI SYLLABLE CAP",
    "A2BA": "YI SYLLABLE CUOX",
    "A2BB": "YI SYLLABLE CUO",
    "A2BC": "YI SYLLABLE CUOP",
    "A2BD": "YI SYLLABLE COT",
    "A2BE": "YI SYLLABLE COX",
    "A2BF": "YI SYLLABLE CO",
    "A2C0": "YI SYLLABLE COP",
    "A2C1": "YI SYLLABLE CEX",
    "A2C2": "YI SYLLABLE CE",
    "A2C3": "YI SYLLABLE CEP",
    "A2C4": "YI SYLLABLE CUT",
    "A2C5": "YI SYLLABLE CUX",
    "A2C6": "YI SYLLABLE CU",
    "A2C7": "YI SYLLABLE CUP",
    "A2C8": "YI SYLLABLE CURX",
    "A2C9": "YI SYLLABLE CUR",
    "A2CA": "YI SYLLABLE CYT",
    "A2CB": "YI SYLLABLE CYX",
    "A2CC": "YI SYLLABLE CY",
    "A2CD": "YI SYLLABLE CYP",
    "A2CE": "YI SYLLABLE CYRX",
    "A2CF": "YI SYLLABLE CYR",
    "A2D0": "YI SYLLABLE ZZIT",
    "A2D1": "YI SYLLABLE ZZIX",
    "A2D2": "YI SYLLABLE ZZI",
    "A2D3": "YI SYLLABLE ZZIP",
    "A2D4": "YI SYLLABLE ZZIET",
    "A2D5": "YI SYLLABLE ZZIEX",
    "A2D6": "YI SYLLABLE ZZIE",
    "A2D7": "YI SYLLABLE ZZIEP",
    "A2D8": "YI SYLLABLE ZZAT",
    "A2D9": "YI SYLLABLE ZZAX",
    "A2DA": "YI SYLLABLE ZZA",
    "A2DB": "YI SYLLABLE ZZAP",
    "A2DC": "YI SYLLABLE ZZOX",
    "A2DD": "YI SYLLABLE ZZO",
    "A2DE": "YI SYLLABLE ZZOP",
    "A2DF": "YI SYLLABLE ZZEX",
    "A2E0": "YI SYLLABLE ZZE",
    "A2E1": "YI SYLLABLE ZZEP",
    "A2E2": "YI SYLLABLE ZZUX",
    "A2E3": "YI SYLLABLE ZZU",
    "A2E4": "YI SYLLABLE ZZUP",
    "A2E5": "YI SYLLABLE ZZURX",
    "A2E6": "YI SYLLABLE ZZUR",
    "A2E7": "YI SYLLABLE ZZYT",
    "A2E8": "YI SYLLABLE ZZYX",
    "A2E9": "YI SYLLABLE ZZY",
    "A2EA": "YI SYLLABLE ZZYP",
    "A2EB": "YI SYLLABLE ZZYRX",
    "A2EC": "YI SYLLABLE ZZYR",
    "A2ED": "YI SYLLABLE NZIT",
    "A2EE": "YI SYLLABLE NZIX",
    "A2EF": "YI SYLLABLE NZI",
    "A2F0": "YI SYLLABLE NZIP",
    "A2F1": "YI SYLLABLE NZIEX",
    "A2F2": "YI SYLLABLE NZIE",
    "A2F3": "YI SYLLABLE NZIEP",
    "A2F4": "YI SYLLABLE NZAT",
    "A2F5": "YI SYLLABLE NZAX",
    "A2F6": "YI SYLLABLE NZA",
    "A2F7": "YI SYLLABLE NZAP",
    "A2F8": "YI SYLLABLE NZUOX",
    "A2F9": "YI SYLLABLE NZUO",
    "A2FA": "YI SYLLABLE NZOX",
    "A2FB": "YI SYLLABLE NZOP",
    "A2FC": "YI SYLLABLE NZEX",
    "A2FD": "YI SYLLABLE NZE",
    "A2FE": "YI SYLLABLE NZUX",
    "A2FF": "YI SYLLABLE NZU",
    "A300": "YI SYLLABLE NZUP",
    "A301": "YI SYLLABLE NZURX",
    "A302": "YI SYLLABLE NZUR",
    "A303": "YI SYLLABLE NZYT",
    "A304": "YI SYLLABLE NZYX",
    "A305": "YI SYLLABLE NZY",
    "A306": "YI SYLLABLE NZYP",
    "A307": "YI SYLLABLE NZYRX",
    "A308": "YI SYLLABLE NZYR",
    "A309": "YI SYLLABLE SIT",
    "A30A": "YI SYLLABLE SIX",
    "A30B": "YI SYLLABLE SI",
    "A30C": "YI SYLLABLE SIP",
    "A30D": "YI SYLLABLE SIEX",
    "A30E": "YI SYLLABLE SIE",
    "A30F": "YI SYLLABLE SIEP",
    "A310": "YI SYLLABLE SAT",
    "A311": "YI SYLLABLE SAX",
    "A312": "YI SYLLABLE SA",
    "A313": "YI SYLLABLE SAP",
    "A314": "YI SYLLABLE SUOX",
    "A315": "YI SYLLABLE SUO",
    "A316": "YI SYLLABLE SUOP",
    "A317": "YI SYLLABLE SOT",
    "A318": "YI SYLLABLE SOX",
    "A319": "YI SYLLABLE SO",
    "A31A": "YI SYLLABLE SOP",
    "A31B": "YI SYLLABLE SEX",
    "A31C": "YI SYLLABLE SE",
    "A31D": "YI SYLLABLE SEP",
    "A31E": "YI SYLLABLE SUT",
    "A31F": "YI SYLLABLE SUX",
    "A320": "YI SYLLABLE SU",
    "A321": "YI SYLLABLE SUP",
    "A322": "YI SYLLABLE SURX",
    "A323": "YI SYLLABLE SUR",
    "A324": "YI SYLLABLE SYT",
    "A325": "YI SYLLABLE SYX",
    "A326": "YI SYLLABLE SY",
    "A327": "YI SYLLABLE SYP",
    "A328": "YI SYLLABLE SYRX",
    "A329": "YI SYLLABLE SYR",
    "A32A": "YI SYLLABLE SSIT",
    "A32B": "YI SYLLABLE SSIX",
    "A32C": "YI SYLLABLE SSI",
    "A32D": "YI SYLLABLE SSIP",
    "A32E": "YI SYLLABLE SSIEX",
    "A32F": "YI SYLLABLE SSIE",
    "A330": "YI SYLLABLE SSIEP",
    "A331": "YI SYLLABLE SSAT",
    "A332": "YI SYLLABLE SSAX",
    "A333": "YI SYLLABLE SSA",
    "A334": "YI SYLLABLE SSAP",
    "A335": "YI SYLLABLE SSOT",
    "A336": "YI SYLLABLE SSOX",
    "A337": "YI SYLLABLE SSO",
    "A338": "YI SYLLABLE SSOP",
    "A339": "YI SYLLABLE SSEX",
    "A33A": "YI SYLLABLE SSE",
    "A33B": "YI SYLLABLE SSEP",
    "A33C": "YI SYLLABLE SSUT",
    "A33D": "YI SYLLABLE SSUX",
    "A33E": "YI SYLLABLE SSU",
    "A33F": "YI SYLLABLE SSUP",
    "A340": "YI SYLLABLE SSYT",
    "A341": "YI SYLLABLE SSYX",
    "A342": "YI SYLLABLE SSY",
    "A343": "YI SYLLABLE SSYP",
    "A344": "YI SYLLABLE SSYRX",
    "A345": "YI SYLLABLE SSYR",
    "A346": "YI SYLLABLE ZHAT",
    "A347": "YI SYLLABLE ZHAX",
    "A348": "YI SYLLABLE ZHA",
    "A349": "YI SYLLABLE ZHAP",
    "A34A": "YI SYLLABLE ZHUOX",
    "A34B": "YI SYLLABLE ZHUO",
    "A34C": "YI SYLLABLE ZHUOP",
    "A34D": "YI SYLLABLE ZHOT",
    "A34E": "YI SYLLABLE ZHOX",
    "A34F": "YI SYLLABLE ZHO",
    "A350": "YI SYLLABLE ZHOP",
    "A351": "YI SYLLABLE ZHET",
    "A352": "YI SYLLABLE ZHEX",
    "A353": "YI SYLLABLE ZHE",
    "A354": "YI SYLLABLE ZHEP",
    "A355": "YI SYLLABLE ZHUT",
    "A356": "YI SYLLABLE ZHUX",
    "A357": "YI SYLLABLE ZHU",
    "A358": "YI SYLLABLE ZHUP",
    "A359": "YI SYLLABLE ZHURX",
    "A35A": "YI SYLLABLE ZHUR",
    "A35B": "YI SYLLABLE ZHYT",
    "A35C": "YI SYLLABLE ZHYX",
    "A35D": "YI SYLLABLE ZHY",
    "A35E": "YI SYLLABLE ZHYP",
    "A35F": "YI SYLLABLE ZHYRX",
    "A360": "YI SYLLABLE ZHYR",
    "A361": "YI SYLLABLE CHAT",
    "A362": "YI SYLLABLE CHAX",
    "A363": "YI SYLLABLE CHA",
    "A364": "YI SYLLABLE CHAP",
    "A365": "YI SYLLABLE CHUOT",
    "A366": "YI SYLLABLE CHUOX",
    "A367": "YI SYLLABLE CHUO",
    "A368": "YI SYLLABLE CHUOP",
    "A369": "YI SYLLABLE CHOT",
    "A36A": "YI SYLLABLE CHOX",
    "A36B": "YI SYLLABLE CHO",
    "A36C": "YI SYLLABLE CHOP",
    "A36D": "YI SYLLABLE CHET",
    "A36E": "YI SYLLABLE CHEX",
    "A36F": "YI SYLLABLE CHE",
    "A370": "YI SYLLABLE CHEP",
    "A371": "YI SYLLABLE CHUX",
    "A372": "YI SYLLABLE CHU",
    "A373": "YI SYLLABLE CHUP",
    "A374": "YI SYLLABLE CHURX",
    "A375": "YI SYLLABLE CHUR",
    "A376": "YI SYLLABLE CHYT",
    "A377": "YI SYLLABLE CHYX",
    "A378": "YI SYLLABLE CHY",
    "A379": "YI SYLLABLE CHYP",
    "A37A": "YI SYLLABLE CHYRX",
    "A37B": "YI SYLLABLE CHYR",
    "A37C": "YI SYLLABLE RRAX",
    "A37D": "YI SYLLABLE RRA",
    "A37E": "YI SYLLABLE RRUOX",
    "A37F": "YI SYLLABLE RRUO",
    "A380": "YI SYLLABLE RROT",
    "A381": "YI SYLLABLE RROX",
    "A382": "YI SYLLABLE RRO",
    "A383": "YI SYLLABLE RROP",
    "A384": "YI SYLLABLE RRET",
    "A385": "YI SYLLABLE RREX",
    "A386": "YI SYLLABLE RRE",
    "A387": "YI SYLLABLE RREP",
    "A388": "YI SYLLABLE RRUT",
    "A389": "YI SYLLABLE RRUX",
    "A38A": "YI SYLLABLE RRU",
    "A38B": "YI SYLLABLE RRUP",
    "A38C": "YI SYLLABLE RRURX",
    "A38D": "YI SYLLABLE RRUR",
    "A38E": "YI SYLLABLE RRYT",
    "A38F": "YI SYLLABLE RRYX",
    "A390": "YI SYLLABLE RRY",
    "A391": "YI SYLLABLE RRYP",
    "A392": "YI SYLLABLE RRYRX",
    "A393": "YI SYLLABLE RRYR",
    "A394": "YI SYLLABLE NRAT",
    "A395": "YI SYLLABLE NRAX",
    "A396": "YI SYLLABLE NRA",
    "A397": "YI SYLLABLE NRAP",
    "A398": "YI SYLLABLE NROX",
    "A399": "YI SYLLABLE NRO",
    "A39A": "YI SYLLABLE NROP",
    "A39B": "YI SYLLABLE NRET",
    "A39C": "YI SYLLABLE NREX",
    "A39D": "YI SYLLABLE NRE",
    "A39E": "YI SYLLABLE NREP",
    "A39F": "YI SYLLABLE NRUT",
    "A3A0": "YI SYLLABLE NRUX",
    "A3A1": "YI SYLLABLE NRU",
    "A3A2": "YI SYLLABLE NRUP",
    "A3A3": "YI SYLLABLE NRURX",
    "A3A4": "YI SYLLABLE NRUR",
    "A3A5": "YI SYLLABLE NRYT",
    "A3A6": "YI SYLLABLE NRYX",
    "A3A7": "YI SYLLABLE NRY",
    "A3A8": "YI SYLLABLE NRYP",
    "A3A9": "YI SYLLABLE NRYRX",
    "A3AA": "YI SYLLABLE NRYR",
    "A3AB": "YI SYLLABLE SHAT",
    "A3AC": "YI SYLLABLE SHAX",
    "A3AD": "YI SYLLABLE SHA",
    "A3AE": "YI SYLLABLE SHAP",
    "A3AF": "YI SYLLABLE SHUOX",
    "A3B0": "YI SYLLABLE SHUO",
    "A3B1": "YI SYLLABLE SHUOP",
    "A3B2": "YI SYLLABLE SHOT",
    "A3B3": "YI SYLLABLE SHOX",
    "A3B4": "YI SYLLABLE SHO",
    "A3B5": "YI SYLLABLE SHOP",
    "A3B6": "YI SYLLABLE SHET",
    "A3B7": "YI SYLLABLE SHEX",
    "A3B8": "YI SYLLABLE SHE",
    "A3B9": "YI SYLLABLE SHEP",
    "A3BA": "YI SYLLABLE SHUT",
    "A3BB": "YI SYLLABLE SHUX",
    "A3BC": "YI SYLLABLE SHU",
    "A3BD": "YI SYLLABLE SHUP",
    "A3BE": "YI SYLLABLE SHURX",
    "A3BF": "YI SYLLABLE SHUR",
    "A3C0": "YI SYLLABLE SHYT",
    "A3C1": "YI SYLLABLE SHYX",
    "A3C2": "YI SYLLABLE SHY",
    "A3C3": "YI SYLLABLE SHYP",
    "A3C4": "YI SYLLABLE SHYRX",
    "A3C5": "YI SYLLABLE SHYR",
    "A3C6": "YI SYLLABLE RAT",
    "A3C7": "YI SYLLABLE RAX",
    "A3C8": "YI SYLLABLE RA",
    "A3C9": "YI SYLLABLE RAP",
    "A3CA": "YI SYLLABLE RUOX",
    "A3CB": "YI SYLLABLE RUO",
    "A3CC": "YI SYLLABLE RUOP",
    "A3CD": "YI SYLLABLE ROT",
    "A3CE": "YI SYLLABLE ROX",
    "A3CF": "YI SYLLABLE RO",
    "A3D0": "YI SYLLABLE ROP",
    "A3D1": "YI SYLLABLE REX",
    "A3D2": "YI SYLLABLE RE",
    "A3D3": "YI SYLLABLE REP",
    "A3D4": "YI SYLLABLE RUT",
    "A3D5": "YI SYLLABLE RUX",
    "A3D6": "YI SYLLABLE RU",
    "A3D7": "YI SYLLABLE RUP",
    "A3D8": "YI SYLLABLE RURX",
    "A3D9": "YI SYLLABLE RUR",
    "A3DA": "YI SYLLABLE RYT",
    "A3DB": "YI SYLLABLE RYX",
    "A3DC": "YI SYLLABLE RY",
    "A3DD": "YI SYLLABLE RYP",
    "A3DE": "YI SYLLABLE RYRX",
    "A3DF": "YI SYLLABLE RYR",
    "A3E0": "YI SYLLABLE JIT",
    "A3E1": "YI SYLLABLE JIX",
    "A3E2": "YI SYLLABLE JI",
    "A3E3": "YI SYLLABLE JIP",
    "A3E4": "YI SYLLABLE JIET",
    "A3E5": "YI SYLLABLE JIEX",
    "A3E6": "YI SYLLABLE JIE",
    "A3E7": "YI SYLLABLE JIEP",
    "A3E8": "YI SYLLABLE JUOT",
    "A3E9": "YI SYLLABLE JUOX",
    "A3EA": "YI SYLLABLE JUO",
    "A3EB": "YI SYLLABLE JUOP",
    "A3EC": "YI SYLLABLE JOT",
    "A3ED": "YI SYLLABLE JOX",
    "A3EE": "YI SYLLABLE JO",
    "A3EF": "YI SYLLABLE JOP",
    "A3F0": "YI SYLLABLE JUT",
    "A3F1": "YI SYLLABLE JUX",
    "A3F2": "YI SYLLABLE JU",
    "A3F3": "YI SYLLABLE JUP",
    "A3F4": "YI SYLLABLE JURX",
    "A3F5": "YI SYLLABLE JUR",
    "A3F6": "YI SYLLABLE JYT",
    "A3F7": "YI SYLLABLE JYX",
    "A3F8": "YI SYLLABLE JY",
    "A3F9": "YI SYLLABLE JYP",
    "A3FA": "YI SYLLABLE JYRX",
    "A3FB": "YI SYLLABLE JYR",
    "A3FC": "YI SYLLABLE QIT",
    "A3FD": "YI SYLLABLE QIX",
    "A3FE": "YI SYLLABLE QI",
    "A3FF": "YI SYLLABLE QIP",
    "A400": "YI SYLLABLE QIET",
    "A401": "YI SYLLABLE QIEX",
    "A402": "YI SYLLABLE QIE",
    "A403": "YI SYLLABLE QIEP",
    "A404": "YI SYLLABLE QUOT",
    "A405": "YI SYLLABLE QUOX",
    "A406": "YI SYLLABLE QUO",
    "A407": "YI SYLLABLE QUOP",
    "A408": "YI SYLLABLE QOT",
    "A409": "YI SYLLABLE QOX",
    "A40A": "YI SYLLABLE QO",
    "A40B": "YI SYLLABLE QOP",
    "A40C": "YI SYLLABLE QUT",
    "A40D": "YI SYLLABLE QUX",
    "A40E": "YI SYLLABLE QU",
    "A40F": "YI SYLLABLE QUP",
    "A410": "YI SYLLABLE QURX",
    "A411": "YI SYLLABLE QUR",
    "A412": "YI SYLLABLE QYT",
    "A413": "YI SYLLABLE QYX",
    "A414": "YI SYLLABLE QY",
    "A415": "YI SYLLABLE QYP",
    "A416": "YI SYLLABLE QYRX",
    "A417": "YI SYLLABLE QYR",
    "A418": "YI SYLLABLE JJIT",
    "A419": "YI SYLLABLE JJIX",
    "A41A": "YI SYLLABLE JJI",
    "A41B": "YI SYLLABLE JJIP",
    "A41C": "YI SYLLABLE JJIET",
    "A41D": "YI SYLLABLE JJIEX",
    "A41E": "YI SYLLABLE JJIE",
    "A41F": "YI SYLLABLE JJIEP",
    "A420": "YI SYLLABLE JJUOX",
    "A421": "YI SYLLABLE JJUO",
    "A422": "YI SYLLABLE JJUOP",
    "A423": "YI SYLLABLE JJOT",
    "A424": "YI SYLLABLE JJOX",
    "A425": "YI SYLLABLE JJO",
    "A426": "YI SYLLABLE JJOP",
    "A427": "YI SYLLABLE JJUT",
    "A428": "YI SYLLABLE JJUX",
    "A429": "YI SYLLABLE JJU",
    "A42A": "YI SYLLABLE JJUP",
    "A42B": "YI SYLLABLE JJURX",
    "A42C": "YI SYLLABLE JJUR",
    "A42D": "YI SYLLABLE JJYT",
    "A42E": "YI SYLLABLE JJYX",
    "A42F": "YI SYLLABLE JJY",
    "A430": "YI SYLLABLE JJYP",
    "A431": "YI SYLLABLE NJIT",
    "A432": "YI SYLLABLE NJIX",
    "A433": "YI SYLLABLE NJI",
    "A434": "YI SYLLABLE NJIP",
    "A435": "YI SYLLABLE NJIET",
    "A436": "YI SYLLABLE NJIEX",
    "A437": "YI SYLLABLE NJIE",
    "A438": "YI SYLLABLE NJIEP",
    "A439": "YI SYLLABLE NJUOX",
    "A43A": "YI SYLLABLE NJUO",
    "A43B": "YI SYLLABLE NJOT",
    "A43C": "YI SYLLABLE NJOX",
    "A43D": "YI SYLLABLE NJO",
    "A43E": "YI SYLLABLE NJOP",
    "A43F": "YI SYLLABLE NJUX",
    "A440": "YI SYLLABLE NJU",
    "A441": "YI SYLLABLE NJUP",
    "A442": "YI SYLLABLE NJURX",
    "A443": "YI SYLLABLE NJUR",
    "A444": "YI SYLLABLE NJYT",
    "A445": "YI SYLLABLE NJYX",
    "A446": "YI SYLLABLE NJY",
    "A447": "YI SYLLABLE NJYP",
    "A448": "YI SYLLABLE NJYRX",
    "A449": "YI SYLLABLE NJYR",
    "A44A": "YI SYLLABLE NYIT",
    "A44B": "YI SYLLABLE NYIX",
    "A44C": "YI SYLLABLE NYI",
    "A44D": "YI SYLLABLE NYIP",
    "A44E": "YI SYLLABLE NYIET",
    "A44F": "YI SYLLABLE NYIEX",
    "A450": "YI SYLLABLE NYIE",
    "A451": "YI SYLLABLE NYIEP",
    "A452": "YI SYLLABLE NYUOX",
    "A453": "YI SYLLABLE NYUO",
    "A454": "YI SYLLABLE NYUOP",
    "A455": "YI SYLLABLE NYOT",
    "A456": "YI SYLLABLE NYOX",
    "A457": "YI SYLLABLE NYO",
    "A458": "YI SYLLABLE NYOP",
    "A459": "YI SYLLABLE NYUT",
    "A45A": "YI SYLLABLE NYUX",
    "A45B": "YI SYLLABLE NYU",
    "A45C": "YI SYLLABLE NYUP",
    "A45D": "YI SYLLABLE XIT",
    "A45E": "YI SYLLABLE XIX",
    "A45F": "YI SYLLABLE XI",
    "A460": "YI SYLLABLE XIP",
    "A461": "YI SYLLABLE XIET",
    "A462": "YI SYLLABLE XIEX",
    "A463": "YI SYLLABLE XIE",
    "A464": "YI SYLLABLE XIEP",
    "A465": "YI SYLLABLE XUOX",
    "A466": "YI SYLLABLE XUO",
    "A467": "YI SYLLABLE XOT",
    "A468": "YI SYLLABLE XOX",
    "A469": "YI SYLLABLE XO",
    "A46A": "YI SYLLABLE XOP",
    "A46B": "YI SYLLABLE XYT",
    "A46C": "YI SYLLABLE XYX",
    "A46D": "YI SYLLABLE XY",
    "A46E": "YI SYLLABLE XYP",
    "A46F": "YI SYLLABLE XYRX",
    "A470": "YI SYLLABLE XYR",
    "A471": "YI SYLLABLE YIT",
    "A472": "YI SYLLABLE YIX",
    "A473": "YI SYLLABLE YI",
    "A474": "YI SYLLABLE YIP",
    "A475": "YI SYLLABLE YIET",
    "A476": "YI SYLLABLE YIEX",
    "A477": "YI SYLLABLE YIE",
    "A478": "YI SYLLABLE YIEP",
    "A479": "YI SYLLABLE YUOT",
    "A47A": "YI SYLLABLE YUOX",
    "A47B": "YI SYLLABLE YUO",
    "A47C": "YI SYLLABLE YUOP",
    "A47D": "YI SYLLABLE YOT",
    "A47E": "YI SYLLABLE YOX",
    "A47F": "YI SYLLABLE YO",
    "A480": "YI SYLLABLE YOP",
    "A481": "YI SYLLABLE YUT",
    "A482": "YI SYLLABLE YUX",
    "A483": "YI SYLLABLE YU",
    "A484": "YI SYLLABLE YUP",
    "A485": "YI SYLLABLE YURX",
    "A486": "YI SYLLABLE YUR",
    "A487": "YI SYLLABLE YYT",
    "A488": "YI SYLLABLE YYX",
    "A489": "YI SYLLABLE YY",
    "A48A": "YI SYLLABLE YYP",
    "A48B": "YI SYLLABLE YYRX",
    "A48C": "YI SYLLABLE YYR",
    "A490": "YI RADICAL QOT",
    "A491": "YI RADICAL LI",
    "A492": "YI RADICAL KIT",
    "A493": "YI RADICAL NYIP",
    "A494": "YI RADICAL CYP",
    "A495": "YI RADICAL SSI",
    "A496": "YI RADICAL GGOP",
    "A497": "YI RADICAL GEP",
    "A498": "YI RADICAL MI",
    "A499": "YI RADICAL HXIT",
    "A49A": "YI RADICAL LYR",
    "A49B": "YI RADICAL BBUT",
    "A49C": "YI RADICAL MOP",
    "A49D": "YI RADICAL YO",
    "A49E": "YI RADICAL PUT",
    "A49F": "YI RADICAL HXUO",
    "A4A0": "YI RADICAL TAT",
    "A4A1": "YI RADICAL GA",
    "A4A2": "YI RADICAL ZUP",
    "A4A3": "YI RADICAL CYT",
    "A4A4": "YI RADICAL DDUR",
    "A4A5": "YI RADICAL BUR",
    "A4A6": "YI RADICAL GGUO",
    "A4A7": "YI RADICAL NYOP",
    "A4A8": "YI RADICAL TU",
    "A4A9": "YI RADICAL OP",
    "A4AA": "YI RADICAL JJUT",
    "A4AB": "YI RADICAL ZOT",
    "A4AC": "YI RADICAL PYT",
    "A4AD": "YI RADICAL HMO",
    "A4AE": "YI RADICAL YIT",
    "A4AF": "YI RADICAL VUR",
    "A4B0": "YI RADICAL SHY",
    "A4B1": "YI RADICAL VEP",
    "A4B2": "YI RADICAL ZA",
    "A4B3": "YI RADICAL JO",
    "A4B4": "YI RADICAL NZUP",
    "A4B5": "YI RADICAL JJY",
    "A4B6": "YI RADICAL GOT",
    "A4B7": "YI RADICAL JJIE",
    "A4B8": "YI RADICAL WO",
    "A4B9": "YI RADICAL DU",
    "A4BA": "YI RADICAL SHUR",
    "A4BB": "YI RADICAL LIE",
    "A4BC": "YI RADICAL CY",
    "A4BD": "YI RADICAL CUOP",
    "A4BE": "YI RADICAL CIP",
    "A4BF": "YI RADICAL HXOP",
    "A4C0": "YI RADICAL SHAT",
    "A4C1": "YI RADICAL ZUR",
    "A4C2": "YI RADICAL SHOP",
    "A4C3": "YI RADICAL CHE",
    "A4C4": "YI RADICAL ZZIET",
    "A4C5": "YI RADICAL NBIE",
    "A4C6": "YI RADICAL KE",
    "A4D0": "LISU LETTER BA",
    "A4D1": "LISU LETTER PA",
    "A4D2": "LISU LETTER PHA",
    "A4D3": "LISU LETTER DA",
    "A4D4": "LISU LETTER TA",
    "A4D5": "LISU LETTER THA",
    "A4D6": "LISU LETTER GA",
    "A4D7": "LISU LETTER KA",
    "A4D8": "LISU LETTER KHA",
    "A4D9": "LISU LETTER JA",
    "A4DA": "LISU LETTER CA",
    "A4DB": "LISU LETTER CHA",
    "A4DC": "LISU LETTER DZA",
    "A4DD": "LISU LETTER TSA",
    "A4DE": "LISU LETTER TSHA",
    "A4DF": "LISU LETTER MA",
    "A4E0": "LISU LETTER NA",
    "A4E1": "LISU LETTER LA",
    "A4E2": "LISU LETTER SA",
    "A4E3": "LISU LETTER ZHA",
    "A4E4": "LISU LETTER ZA",
    "A4E5": "LISU LETTER NGA",
    "A4E6": "LISU LETTER HA",
    "A4E7": "LISU LETTER XA",
    "A4E8": "LISU LETTER HHA",
    "A4E9": "LISU LETTER FA",
    "A4EA": "LISU LETTER WA",
    "A4EB": "LISU LETTER SHA",
    "A4EC": "LISU LETTER YA",
    "A4ED": "LISU LETTER GHA",
    "A4EE": "LISU LETTER A",
    "A4EF": "LISU LETTER AE",
    "A4F0": "LISU LETTER E",
    "A4F1": "LISU LETTER EU",
    "A4F2": "LISU LETTER I",
    "A4F3": "LISU LETTER O",
    "A4F4": "LISU LETTER U",
    "A4F5": "LISU LETTER UE",
    "A4F6": "LISU LETTER UH",
    "A4F7": "LISU LETTER OE",
    "A4F8": "LISU LETTER TONE MYA TI",
    "A4F9": "LISU LETTER TONE NA PO",
    "A4FA": "LISU LETTER TONE MYA CYA",
    "A4FB": "LISU LETTER TONE MYA BO",
    "A4FC": "LISU LETTER TONE MYA NA",
    "A4FD": "LISU LETTER TONE MYA JEU",
    "A4FE": "LISU PUNCTUATION COMMA",
    "A4FF": "LISU PUNCTUATION FULL STOP",
    "A500": "VAI SYLLABLE EE",
    "A501": "VAI SYLLABLE EEN",
    "A502": "VAI SYLLABLE HEE",
    "A503": "VAI SYLLABLE WEE",
    "A504": "VAI SYLLABLE WEEN",
    "A505": "VAI SYLLABLE PEE",
    "A506": "VAI SYLLABLE BHEE",
    "A507": "VAI SYLLABLE BEE",
    "A508": "VAI SYLLABLE MBEE",
    "A509": "VAI SYLLABLE KPEE",
    "A50A": "VAI SYLLABLE MGBEE",
    "A50B": "VAI SYLLABLE GBEE",
    "A50C": "VAI SYLLABLE FEE",
    "A50D": "VAI SYLLABLE VEE",
    "A50E": "VAI SYLLABLE TEE",
    "A50F": "VAI SYLLABLE THEE",
    "A510": "VAI SYLLABLE DHEE",
    "A511": "VAI SYLLABLE DHHEE",
    "A512": "VAI SYLLABLE LEE",
    "A513": "VAI SYLLABLE REE",
    "A514": "VAI SYLLABLE DEE",
    "A515": "VAI SYLLABLE NDEE",
    "A516": "VAI SYLLABLE SEE",
    "A517": "VAI SYLLABLE SHEE",
    "A518": "VAI SYLLABLE ZEE",
    "A519": "VAI SYLLABLE ZHEE",
    "A51A": "VAI SYLLABLE CEE",
    "A51B": "VAI SYLLABLE JEE",
    "A51C": "VAI SYLLABLE NJEE",
    "A51D": "VAI SYLLABLE YEE",
    "A51E": "VAI SYLLABLE KEE",
    "A51F": "VAI SYLLABLE NGGEE",
    "A520": "VAI SYLLABLE GEE",
    "A521": "VAI SYLLABLE MEE",
    "A522": "VAI SYLLABLE NEE",
    "A523": "VAI SYLLABLE NYEE",
    "A524": "VAI SYLLABLE I",
    "A525": "VAI SYLLABLE IN",
    "A526": "VAI SYLLABLE HI",
    "A527": "VAI SYLLABLE HIN",
    "A528": "VAI SYLLABLE WI",
    "A529": "VAI SYLLABLE WIN",
    "A52A": "VAI SYLLABLE PI",
    "A52B": "VAI SYLLABLE BHI",
    "A52C": "VAI SYLLABLE BI",
    "A52D": "VAI SYLLABLE MBI",
    "A52E": "VAI SYLLABLE KPI",
    "A52F": "VAI SYLLABLE MGBI",
    "A530": "VAI SYLLABLE GBI",
    "A531": "VAI SYLLABLE FI",
    "A532": "VAI SYLLABLE VI",
    "A533": "VAI SYLLABLE TI",
    "A534": "VAI SYLLABLE THI",
    "A535": "VAI SYLLABLE DHI",
    "A536": "VAI SYLLABLE DHHI",
    "A537": "VAI SYLLABLE LI",
    "A538": "VAI SYLLABLE RI",
    "A539": "VAI SYLLABLE DI",
    "A53A": "VAI SYLLABLE NDI",
    "A53B": "VAI SYLLABLE SI",
    "A53C": "VAI SYLLABLE SHI",
    "A53D": "VAI SYLLABLE ZI",
    "A53E": "VAI SYLLABLE ZHI",
    "A53F": "VAI SYLLABLE CI",
    "A540": "VAI SYLLABLE JI",
    "A541": "VAI SYLLABLE NJI",
    "A542": "VAI SYLLABLE YI",
    "A543": "VAI SYLLABLE KI",
    "A544": "VAI SYLLABLE NGGI",
    "A545": "VAI SYLLABLE GI",
    "A546": "VAI SYLLABLE MI",
    "A547": "VAI SYLLABLE NI",
    "A548": "VAI SYLLABLE NYI",
    "A549": "VAI SYLLABLE A",
    "A54A": "VAI SYLLABLE AN",
    "A54B": "VAI SYLLABLE NGAN",
    "A54C": "VAI SYLLABLE HA",
    "A54D": "VAI SYLLABLE HAN",
    "A54E": "VAI SYLLABLE WA",
    "A54F": "VAI SYLLABLE WAN",
    "A550": "VAI SYLLABLE PA",
    "A551": "VAI SYLLABLE BHA",
    "A552": "VAI SYLLABLE BA",
    "A553": "VAI SYLLABLE MBA",
    "A554": "VAI SYLLABLE KPA",
    "A555": "VAI SYLLABLE KPAN",
    "A556": "VAI SYLLABLE MGBA",
    "A557": "VAI SYLLABLE GBA",
    "A558": "VAI SYLLABLE FA",
    "A559": "VAI SYLLABLE VA",
    "A55A": "VAI SYLLABLE TA",
    "A55B": "VAI SYLLABLE THA",
    "A55C": "VAI SYLLABLE DHA",
    "A55D": "VAI SYLLABLE DHHA",
    "A55E": "VAI SYLLABLE LA",
    "A55F": "VAI SYLLABLE RA",
    "A560": "VAI SYLLABLE DA",
    "A561": "VAI SYLLABLE NDA",
    "A562": "VAI SYLLABLE SA",
    "A563": "VAI SYLLABLE SHA",
    "A564": "VAI SYLLABLE ZA",
    "A565": "VAI SYLLABLE ZHA",
    "A566": "VAI SYLLABLE CA",
    "A567": "VAI SYLLABLE JA",
    "A568": "VAI SYLLABLE NJA",
    "A569": "VAI SYLLABLE YA",
    "A56A": "VAI SYLLABLE KA",
    "A56B": "VAI SYLLABLE KAN",
    "A56C": "VAI SYLLABLE NGGA",
    "A56D": "VAI SYLLABLE GA",
    "A56E": "VAI SYLLABLE MA",
    "A56F": "VAI SYLLABLE NA",
    "A570": "VAI SYLLABLE NYA",
    "A571": "VAI SYLLABLE OO",
    "A572": "VAI SYLLABLE OON",
    "A573": "VAI SYLLABLE HOO",
    "A574": "VAI SYLLABLE WOO",
    "A575": "VAI SYLLABLE WOON",
    "A576": "VAI SYLLABLE POO",
    "A577": "VAI SYLLABLE BHOO",
    "A578": "VAI SYLLABLE BOO",
    "A579": "VAI SYLLABLE MBOO",
    "A57A": "VAI SYLLABLE KPOO",
    "A57B": "VAI SYLLABLE MGBOO",
    "A57C": "VAI SYLLABLE GBOO",
    "A57D": "VAI SYLLABLE FOO",
    "A57E": "VAI SYLLABLE VOO",
    "A57F": "VAI SYLLABLE TOO",
    "A580": "VAI SYLLABLE THOO",
    "A581": "VAI SYLLABLE DHOO",
    "A582": "VAI SYLLABLE DHHOO",
    "A583": "VAI SYLLABLE LOO",
    "A584": "VAI SYLLABLE ROO",
    "A585": "VAI SYLLABLE DOO",
    "A586": "VAI SYLLABLE NDOO",
    "A587": "VAI SYLLABLE SOO",
    "A588": "VAI SYLLABLE SHOO",
    "A589": "VAI SYLLABLE ZOO",
    "A58A": "VAI SYLLABLE ZHOO",
    "A58B": "VAI SYLLABLE COO",
    "A58C": "VAI SYLLABLE JOO",
    "A58D": "VAI SYLLABLE NJOO",
    "A58E": "VAI SYLLABLE YOO",
    "A58F": "VAI SYLLABLE KOO",
    "A590": "VAI SYLLABLE NGGOO",
    "A591": "VAI SYLLABLE GOO",
    "A592": "VAI SYLLABLE MOO",
    "A593": "VAI SYLLABLE NOO",
    "A594": "VAI SYLLABLE NYOO",
    "A595": "VAI SYLLABLE U",
    "A596": "VAI SYLLABLE UN",
    "A597": "VAI SYLLABLE HU",
    "A598": "VAI SYLLABLE HUN",
    "A599": "VAI SYLLABLE WU",
    "A59A": "VAI SYLLABLE WUN",
    "A59B": "VAI SYLLABLE PU",
    "A59C": "VAI SYLLABLE BHU",
    "A59D": "VAI SYLLABLE BU",
    "A59E": "VAI SYLLABLE MBU",
    "A59F": "VAI SYLLABLE KPU",
    "A5A0": "VAI SYLLABLE MGBU",
    "A5A1": "VAI SYLLABLE GBU",
    "A5A2": "VAI SYLLABLE FU",
    "A5A3": "VAI SYLLABLE VU",
    "A5A4": "VAI SYLLABLE TU",
    "A5A5": "VAI SYLLABLE THU",
    "A5A6": "VAI SYLLABLE DHU",
    "A5A7": "VAI SYLLABLE DHHU",
    "A5A8": "VAI SYLLABLE LU",
    "A5A9": "VAI SYLLABLE RU",
    "A5AA": "VAI SYLLABLE DU",
    "A5AB": "VAI SYLLABLE NDU",
    "A5AC": "VAI SYLLABLE SU",
    "A5AD": "VAI SYLLABLE SHU",
    "A5AE": "VAI SYLLABLE ZU",
    "A5AF": "VAI SYLLABLE ZHU",
    "A5B0": "VAI SYLLABLE CU",
    "A5B1": "VAI SYLLABLE JU",
    "A5B2": "VAI SYLLABLE NJU",
    "A5B3": "VAI SYLLABLE YU",
    "A5B4": "VAI SYLLABLE KU",
    "A5B5": "VAI SYLLABLE NGGU",
    "A5B6": "VAI SYLLABLE GU",
    "A5B7": "VAI SYLLABLE MU",
    "A5B8": "VAI SYLLABLE NU",
    "A5B9": "VAI SYLLABLE NYU",
    "A5BA": "VAI SYLLABLE O",
    "A5BB": "VAI SYLLABLE ON",
    "A5BC": "VAI SYLLABLE NGON",
    "A5BD": "VAI SYLLABLE HO",
    "A5BE": "VAI SYLLABLE HON",
    "A5BF": "VAI SYLLABLE WO",
    "A5C0": "VAI SYLLABLE WON",
    "A5C1": "VAI SYLLABLE PO",
    "A5C2": "VAI SYLLABLE BHO",
    "A5C3": "VAI SYLLABLE BO",
    "A5C4": "VAI SYLLABLE MBO",
    "A5C5": "VAI SYLLABLE KPO",
    "A5C6": "VAI SYLLABLE MGBO",
    "A5C7": "VAI SYLLABLE GBO",
    "A5C8": "VAI SYLLABLE GBON",
    "A5C9": "VAI SYLLABLE FO",
    "A5CA": "VAI SYLLABLE VO",
    "A5CB": "VAI SYLLABLE TO",
    "A5CC": "VAI SYLLABLE THO",
    "A5CD": "VAI SYLLABLE DHO",
    "A5CE": "VAI SYLLABLE DHHO",
    "A5CF": "VAI SYLLABLE LO",
    "A5D0": "VAI SYLLABLE RO",
    "A5D1": "VAI SYLLABLE DO",
    "A5D2": "VAI SYLLABLE NDO",
    "A5D3": "VAI SYLLABLE SO",
    "A5D4": "VAI SYLLABLE SHO",
    "A5D5": "VAI SYLLABLE ZO",
    "A5D6": "VAI SYLLABLE ZHO",
    "A5D7": "VAI SYLLABLE CO",
    "A5D8": "VAI SYLLABLE JO",
    "A5D9": "VAI SYLLABLE NJO",
    "A5DA": "VAI SYLLABLE YO",
    "A5DB": "VAI SYLLABLE KO",
    "A5DC": "VAI SYLLABLE NGGO",
    "A5DD": "VAI SYLLABLE GO",
    "A5DE": "VAI SYLLABLE MO",
    "A5DF": "VAI SYLLABLE NO",
    "A5E0": "VAI SYLLABLE NYO",
    "A5E1": "VAI SYLLABLE E",
    "A5E2": "VAI SYLLABLE EN",
    "A5E3": "VAI SYLLABLE NGEN",
    "A5E4": "VAI SYLLABLE HE",
    "A5E5": "VAI SYLLABLE HEN",
    "A5E6": "VAI SYLLABLE WE",
    "A5E7": "VAI SYLLABLE WEN",
    "A5E8": "VAI SYLLABLE PE",
    "A5E9": "VAI SYLLABLE BHE",
    "A5EA": "VAI SYLLABLE BE",
    "A5EB": "VAI SYLLABLE MBE",
    "A5EC": "VAI SYLLABLE KPE",
    "A5ED": "VAI SYLLABLE KPEN",
    "A5EE": "VAI SYLLABLE MGBE",
    "A5EF": "VAI SYLLABLE GBE",
    "A5F0": "VAI SYLLABLE GBEN",
    "A5F1": "VAI SYLLABLE FE",
    "A5F2": "VAI SYLLABLE VE",
    "A5F3": "VAI SYLLABLE TE",
    "A5F4": "VAI SYLLABLE THE",
    "A5F5": "VAI SYLLABLE DHE",
    "A5F6": "VAI SYLLABLE DHHE",
    "A5F7": "VAI SYLLABLE LE",
    "A5F8": "VAI SYLLABLE RE",
    "A5F9": "VAI SYLLABLE DE",
    "A5FA": "VAI SYLLABLE NDE",
    "A5FB": "VAI SYLLABLE SE",
    "A5FC": "VAI SYLLABLE SHE",
    "A5FD": "VAI SYLLABLE ZE",
    "A5FE": "VAI SYLLABLE ZHE",
    "A5FF": "VAI SYLLABLE CE",
    "A600": "VAI SYLLABLE JE",
    "A601": "VAI SYLLABLE NJE",
    "A602": "VAI SYLLABLE YE",
    "A603": "VAI SYLLABLE KE",
    "A604": "VAI SYLLABLE NGGE",
    "A605": "VAI SYLLABLE NGGEN",
    "A606": "VAI SYLLABLE GE",
    "A607": "VAI SYLLABLE GEN",
    "A608": "VAI SYLLABLE ME",
    "A609": "VAI SYLLABLE NE",
    "A60A": "VAI SYLLABLE NYE",
    "A60B": "VAI SYLLABLE NG",
    "A60C": "VAI SYLLABLE LENGTHENER",
    "A60D": "VAI COMMA",
    "A60E": "VAI FULL STOP",
    "A60F": "VAI QUESTION MARK",
    "A610": "VAI SYLLABLE NDOLE FA",
    "A611": "VAI SYLLABLE NDOLE KA",
    "A612": "VAI SYLLABLE NDOLE SOO",
    "A613": "VAI SYMBOL FEENG",
    "A614": "VAI SYMBOL KEENG",
    "A615": "VAI SYMBOL TING",
    "A616": "VAI SYMBOL NII",
    "A617": "VAI SYMBOL BANG",
    "A618": "VAI SYMBOL FAA",
    "A619": "VAI SYMBOL TAA",
    "A61A": "VAI SYMBOL DANG",
    "A61B": "VAI SYMBOL DOONG",
    "A61C": "VAI SYMBOL KUNG",
    "A61D": "VAI SYMBOL TONG",
    "A61E": "VAI SYMBOL DO-O",
    "A61F": "VAI SYMBOL JONG",
    "A620": "VAI DIGIT ZERO",
    "A621": "VAI DIGIT ONE",
    "A622": "VAI DIGIT TWO",
    "A623": "VAI DIGIT THREE",
    "A624": "VAI DIGIT FOUR",
    "A625": "VAI DIGIT FIVE",
    "A626": "VAI DIGIT SIX",
    "A627": "VAI DIGIT SEVEN",
    "A628": "VAI DIGIT EIGHT",
    "A629": "VAI DIGIT NINE",
    "A62A": "VAI SYLLABLE NDOLE MA",
    "A62B": "VAI SYLLABLE NDOLE DO",
    "A640": "CYRILLIC CAPITAL LETTER ZEMLYA",
    "A641": "CYRILLIC SMALL LETTER ZEMLYA",
    "A642": "CYRILLIC CAPITAL LETTER DZELO",
    "A643": "CYRILLIC SMALL LETTER DZELO",
    "A644": "CYRILLIC CAPITAL LETTER REVERSED DZE",
    "A645": "CYRILLIC SMALL LETTER REVERSED DZE",
    "A646": "CYRILLIC CAPITAL LETTER IOTA",
    "A647": "CYRILLIC SMALL LETTER IOTA",
    "A648": "CYRILLIC CAPITAL LETTER DJERV",
    "A649": "CYRILLIC SMALL LETTER DJERV",
    "A64A": "CYRILLIC CAPITAL LETTER MONOGRAPH UK",
    "A64B": "CYRILLIC SMALL LETTER MONOGRAPH UK",
    "A64C": "CYRILLIC CAPITAL LETTER BROAD OMEGA",
    "A64D": "CYRILLIC SMALL LETTER BROAD OMEGA",
    "A64E": "CYRILLIC CAPITAL LETTER NEUTRAL YER",
    "A64F": "CYRILLIC SMALL LETTER NEUTRAL YER",
    "A650": "CYRILLIC CAPITAL LETTER YERU WITH BACK YER",
    "A651": "CYRILLIC SMALL LETTER YERU WITH BACK YER",
    "A652": "CYRILLIC CAPITAL LETTER IOTIFIED YAT",
    "A653": "CYRILLIC SMALL LETTER IOTIFIED YAT",
    "A654": "CYRILLIC CAPITAL LETTER REVERSED YU",
    "A655": "CYRILLIC SMALL LETTER REVERSED YU",
    "A656": "CYRILLIC CAPITAL LETTER IOTIFIED A",
    "A657": "CYRILLIC SMALL LETTER IOTIFIED A",
    "A658": "CYRILLIC CAPITAL LETTER CLOSED LITTLE YUS",
    "A659": "CYRILLIC SMALL LETTER CLOSED LITTLE YUS",
    "A65A": "CYRILLIC CAPITAL LETTER BLENDED YUS",
    "A65B": "CYRILLIC SMALL LETTER BLENDED YUS",
    "A65C": "CYRILLIC CAPITAL LETTER IOTIFIED CLOSED LITTLE YUS",
    "A65D": "CYRILLIC SMALL LETTER IOTIFIED CLOSED LITTLE YUS",
    "A65E": "CYRILLIC CAPITAL LETTER YN",
    "A65F": "CYRILLIC SMALL LETTER YN",
    "A660": "CYRILLIC CAPITAL LETTER REVERSED TSE",
    "A661": "CYRILLIC SMALL LETTER REVERSED TSE",
    "A662": "CYRILLIC CAPITAL LETTER SOFT DE",
    "A663": "CYRILLIC SMALL LETTER SOFT DE",
    "A664": "CYRILLIC CAPITAL LETTER SOFT EL",
    "A665": "CYRILLIC SMALL LETTER SOFT EL",
    "A666": "CYRILLIC CAPITAL LETTER SOFT EM",
    "A667": "CYRILLIC SMALL LETTER SOFT EM",
    "A668": "CYRILLIC CAPITAL LETTER MONOCULAR O",
    "A669": "CYRILLIC SMALL LETTER MONOCULAR O",
    "A66A": "CYRILLIC CAPITAL LETTER BINOCULAR O",
    "A66B": "CYRILLIC SMALL LETTER BINOCULAR O",
    "A66C": "CYRILLIC CAPITAL LETTER DOUBLE MONOCULAR O",
    "A66D": "CYRILLIC SMALL LETTER DOUBLE MONOCULAR O",
    "A66E": "CYRILLIC LETTER MULTIOCULAR O",
    "A66F": "COMBINING CYRILLIC VZMET",
    "A670": "COMBINING CYRILLIC TEN MILLIONS SIGN",
    "A671": "COMBINING CYRILLIC HUNDRED MILLIONS SIGN",
    "A672": "COMBINING CYRILLIC THOUSAND MILLIONS SIGN",
    "A673": "SLAVONIC ASTERISK",
    "A674": "COMBINING CYRILLIC LETTER UKRAINIAN IE",
    "A675": "COMBINING CYRILLIC LETTER I",
    "A676": "COMBINING CYRILLIC LETTER YI",
    "A677": "COMBINING CYRILLIC LETTER U",
    "A678": "COMBINING CYRILLIC LETTER HARD SIGN",
    "A679": "COMBINING CYRILLIC LETTER YERU",
    "A67A": "COMBINING CYRILLIC LETTER SOFT SIGN",
    "A67B": "COMBINING CYRILLIC LETTER OMEGA",
    "A67C": "COMBINING CYRILLIC KAVYKA",
    "A67D": "COMBINING CYRILLIC PAYEROK",
    "A67E": "CYRILLIC KAVYKA",
    "A67F": "CYRILLIC PAYEROK",
    "A680": "CYRILLIC CAPITAL LETTER DWE",
    "A681": "CYRILLIC SMALL LETTER DWE",
    "A682": "CYRILLIC CAPITAL LETTER DZWE",
    "A683": "CYRILLIC SMALL LETTER DZWE",
    "A684": "CYRILLIC CAPITAL LETTER ZHWE",
    "A685": "CYRILLIC SMALL LETTER ZHWE",
    "A686": "CYRILLIC CAPITAL LETTER CCHE",
    "A687": "CYRILLIC SMALL LETTER CCHE",
    "A688": "CYRILLIC CAPITAL LETTER DZZE",
    "A689": "CYRILLIC SMALL LETTER DZZE",
    "A68A": "CYRILLIC CAPITAL LETTER TE WITH MIDDLE HOOK",
    "A68B": "CYRILLIC SMALL LETTER TE WITH MIDDLE HOOK",
    "A68C": "CYRILLIC CAPITAL LETTER TWE",
    "A68D": "CYRILLIC SMALL LETTER TWE",
    "A68E": "CYRILLIC CAPITAL LETTER TSWE",
    "A68F": "CYRILLIC SMALL LETTER TSWE",
    "A690": "CYRILLIC CAPITAL LETTER TSSE",
    "A691": "CYRILLIC SMALL LETTER TSSE",
    "A692": "CYRILLIC CAPITAL LETTER TCHE",
    "A693": "CYRILLIC SMALL LETTER TCHE",
    "A694": "CYRILLIC CAPITAL LETTER HWE",
    "A695": "CYRILLIC SMALL LETTER HWE",
    "A696": "CYRILLIC CAPITAL LETTER SHWE",
    "A697": "CYRILLIC SMALL LETTER SHWE",
    "A698": "CYRILLIC CAPITAL LETTER DOUBLE O",
    "A699": "CYRILLIC SMALL LETTER DOUBLE O",
    "A69A": "CYRILLIC CAPITAL LETTER CROSSED O",
    "A69B": "CYRILLIC SMALL LETTER CROSSED O",
    "A69C": "MODIFIER LETTER CYRILLIC HARD SIGN",
    "A69D": "MODIFIER LETTER CYRILLIC SOFT SIGN",
    "A69E": "COMBINING CYRILLIC LETTER EF",
    "A69F": "COMBINING CYRILLIC LETTER IOTIFIED E",
    "A6A0": "BAMUM LETTER A",
    "A6A1": "BAMUM LETTER KA",
    "A6A2": "BAMUM LETTER U",
    "A6A3": "BAMUM LETTER KU",
    "A6A4": "BAMUM LETTER EE",
    "A6A5": "BAMUM LETTER REE",
    "A6A6": "BAMUM LETTER TAE",
    "A6A7": "BAMUM LETTER O",
    "A6A8": "BAMUM LETTER NYI",
    "A6A9": "BAMUM LETTER I",
    "A6AA": "BAMUM LETTER LA",
    "A6AB": "BAMUM LETTER PA",
    "A6AC": "BAMUM LETTER RII",
    "A6AD": "BAMUM LETTER RIEE",
    "A6AE": "BAMUM LETTER LEEEE",
    "A6AF": "BAMUM LETTER MEEEE",
    "A6B0": "BAMUM LETTER TAA",
    "A6B1": "BAMUM LETTER NDAA",
    "A6B2": "BAMUM LETTER NJAEM",
    "A6B3": "BAMUM LETTER M",
    "A6B4": "BAMUM LETTER SUU",
    "A6B5": "BAMUM LETTER MU",
    "A6B6": "BAMUM LETTER SHII",
    "A6B7": "BAMUM LETTER SI",
    "A6B8": "BAMUM LETTER SHEUX",
    "A6B9": "BAMUM LETTER SEUX",
    "A6BA": "BAMUM LETTER KYEE",
    "A6BB": "BAMUM LETTER KET",
    "A6BC": "BAMUM LETTER NUAE",
    "A6BD": "BAMUM LETTER NU",
    "A6BE": "BAMUM LETTER NJUAE",
    "A6BF": "BAMUM LETTER YOQ",
    "A6C0": "BAMUM LETTER SHU",
    "A6C1": "BAMUM LETTER YUQ",
    "A6C2": "BAMUM LETTER YA",
    "A6C3": "BAMUM LETTER NSHA",
    "A6C4": "BAMUM LETTER KEUX",
    "A6C5": "BAMUM LETTER PEUX",
    "A6C6": "BAMUM LETTER NJEE",
    "A6C7": "BAMUM LETTER NTEE",
    "A6C8": "BAMUM LETTER PUE",
    "A6C9": "BAMUM LETTER WUE",
    "A6CA": "BAMUM LETTER PEE",
    "A6CB": "BAMUM LETTER FEE",
    "A6CC": "BAMUM LETTER RU",
    "A6CD": "BAMUM LETTER LU",
    "A6CE": "BAMUM LETTER MI",
    "A6CF": "BAMUM LETTER NI",
    "A6D0": "BAMUM LETTER REUX",
    "A6D1": "BAMUM LETTER RAE",
    "A6D2": "BAMUM LETTER KEN",
    "A6D3": "BAMUM LETTER NGKWAEN",
    "A6D4": "BAMUM LETTER NGGA",
    "A6D5": "BAMUM LETTER NGA",
    "A6D6": "BAMUM LETTER SHO",
    "A6D7": "BAMUM LETTER PUAE",
    "A6D8": "BAMUM LETTER FU",
    "A6D9": "BAMUM LETTER FOM",
    "A6DA": "BAMUM LETTER WA",
    "A6DB": "BAMUM LETTER NA",
    "A6DC": "BAMUM LETTER LI",
    "A6DD": "BAMUM LETTER PI",
    "A6DE": "BAMUM LETTER LOQ",
    "A6DF": "BAMUM LETTER KO",
    "A6E0": "BAMUM LETTER MBEN",
    "A6E1": "BAMUM LETTER REN",
    "A6E2": "BAMUM LETTER MEN",
    "A6E3": "BAMUM LETTER MA",
    "A6E4": "BAMUM LETTER TI",
    "A6E5": "BAMUM LETTER KI",
    "A6E6": "BAMUM LETTER MO",
    "A6E7": "BAMUM LETTER MBAA",
    "A6E8": "BAMUM LETTER TET",
    "A6E9": "BAMUM LETTER KPA",
    "A6EA": "BAMUM LETTER TEN",
    "A6EB": "BAMUM LETTER NTUU",
    "A6EC": "BAMUM LETTER SAMBA",
    "A6ED": "BAMUM LETTER FAAMAE",
    "A6EE": "BAMUM LETTER KOVUU",
    "A6EF": "BAMUM LETTER KOGHOM",
    "A6F0": "BAMUM COMBINING MARK KOQNDON",
    "A6F1": "BAMUM COMBINING MARK TUKWENTIS",
    "A6F2": "BAMUM NJAEMLI",
    "A6F3": "BAMUM FULL STOP",
    "A6F4": "BAMUM COLON",
    "A6F5": "BAMUM COMMA",
    "A6F6": "BAMUM SEMICOLON",
    "A6F7": "BAMUM QUESTION MARK",
    "A700": "MODIFIER LETTER CHINESE TONE YIN PING",
    "A701": "MODIFIER LETTER CHINESE TONE YANG PING",
    "A702": "MODIFIER LETTER CHINESE TONE YIN SHANG",
    "A703": "MODIFIER LETTER CHINESE TONE YANG SHANG",
    "A704": "MODIFIER LETTER CHINESE TONE YIN QU",
    "A705": "MODIFIER LETTER CHINESE TONE YANG QU",
    "A706": "MODIFIER LETTER CHINESE TONE YIN RU",
    "A707": "MODIFIER LETTER CHINESE TONE YANG RU",
    "A708": "MODIFIER LETTER EXTRA-HIGH DOTTED TONE BAR",
    "A709": "MODIFIER LETTER HIGH DOTTED TONE BAR",
    "A70A": "MODIFIER LETTER MID DOTTED TONE BAR",
    "A70B": "MODIFIER LETTER LOW DOTTED TONE BAR",
    "A70C": "MODIFIER LETTER EXTRA-LOW DOTTED TONE BAR",
    "A70D": "MODIFIER LETTER EXTRA-HIGH DOTTED LEFT-STEM TONE BAR",
    "A70E": "MODIFIER LETTER HIGH DOTTED LEFT-STEM TONE BAR",
    "A70F": "MODIFIER LETTER MID DOTTED LEFT-STEM TONE BAR",
    "A710": "MODIFIER LETTER LOW DOTTED LEFT-STEM TONE BAR",
    "A711": "MODIFIER LETTER EXTRA-LOW DOTTED LEFT-STEM TONE BAR",
    "A712": "MODIFIER LETTER EXTRA-HIGH LEFT-STEM TONE BAR",
    "A713": "MODIFIER LETTER HIGH LEFT-STEM TONE BAR",
    "A714": "MODIFIER LETTER MID LEFT-STEM TONE BAR",
    "A715": "MODIFIER LETTER LOW LEFT-STEM TONE BAR",
    "A716": "MODIFIER LETTER EXTRA-LOW LEFT-STEM TONE BAR",
    "A717": "MODIFIER LETTER DOT VERTICAL BAR",
    "A718": "MODIFIER LETTER DOT SLASH",
    "A719": "MODIFIER LETTER DOT HORIZONTAL BAR",
    "A71A": "MODIFIER LETTER LOWER RIGHT CORNER ANGLE",
    "A71B": "MODIFIER LETTER RAISED UP ARROW",
    "A71C": "MODIFIER LETTER RAISED DOWN ARROW",
    "A71D": "MODIFIER LETTER RAISED EXCLAMATION MARK",
    "A71E": "MODIFIER LETTER RAISED INVERTED EXCLAMATION MARK",
    "A71F": "MODIFIER LETTER LOW INVERTED EXCLAMATION MARK",
    "A720": "MODIFIER LETTER STRESS AND HIGH TONE",
    "A721": "MODIFIER LETTER STRESS AND LOW TONE",
    "A722": "LATIN CAPITAL LETTER EGYPTOLOGICAL ALEF",
    "A723": "LATIN SMALL LETTER EGYPTOLOGICAL ALEF",
    "A724": "LATIN CAPITAL LETTER EGYPTOLOGICAL AIN",
    "A725": "LATIN SMALL LETTER EGYPTOLOGICAL AIN",
    "A726": "LATIN CAPITAL LETTER HENG",
    "A727": "LATIN SMALL LETTER HENG",
    "A728": "LATIN CAPITAL LETTER TZ",
    "A729": "LATIN SMALL LETTER TZ",
    "A72A": "LATIN CAPITAL LETTER TRESILLO",
    "A72B": "LATIN SMALL LETTER TRESILLO",
    "A72C": "LATIN CAPITAL LETTER CUATRILLO",
    "A72D": "LATIN SMALL LETTER CUATRILLO",
    "A72E": "LATIN CAPITAL LETTER CUATRILLO WITH COMMA",
    "A72F": "LATIN SMALL LETTER CUATRILLO WITH COMMA",
    "A730": "LATIN LETTER SMALL CAPITAL F",
    "A731": "LATIN LETTER SMALL CAPITAL S",
    "A732": "LATIN CAPITAL LETTER AA",
    "A733": "LATIN SMALL LETTER AA",
    "A734": "LATIN CAPITAL LETTER AO",
    "A735": "LATIN SMALL LETTER AO",
    "A736": "LATIN CAPITAL LETTER AU",
    "A737": "LATIN SMALL LETTER AU",
    "A738": "LATIN CAPITAL LETTER AV",
    "A739": "LATIN SMALL LETTER AV",
    "A73A": "LATIN CAPITAL LETTER AV WITH HORIZONTAL BAR",
    "A73B": "LATIN SMALL LETTER AV WITH HORIZONTAL BAR",
    "A73C": "LATIN CAPITAL LETTER AY",
    "A73D": "LATIN SMALL LETTER AY",
    "A73E": "LATIN CAPITAL LETTER REVERSED C WITH DOT",
    "A73F": "LATIN SMALL LETTER REVERSED C WITH DOT",
    "A740": "LATIN CAPITAL LETTER K WITH STROKE",
    "A741": "LATIN SMALL LETTER K WITH STROKE",
    "A742": "LATIN CAPITAL LETTER K WITH DIAGONAL STROKE",
    "A743": "LATIN SMALL LETTER K WITH DIAGONAL STROKE",
    "A744": "LATIN CAPITAL LETTER K WITH STROKE AND DIAGONAL STROKE",
    "A745": "LATIN SMALL LETTER K WITH STROKE AND DIAGONAL STROKE",
    "A746": "LATIN CAPITAL LETTER BROKEN L",
    "A747": "LATIN SMALL LETTER BROKEN L",
    "A748": "LATIN CAPITAL LETTER L WITH HIGH STROKE",
    "A749": "LATIN SMALL LETTER L WITH HIGH STROKE",
    "A74A": "LATIN CAPITAL LETTER O WITH LONG STROKE OVERLAY",
    "A74B": "LATIN SMALL LETTER O WITH LONG STROKE OVERLAY",
    "A74C": "LATIN CAPITAL LETTER O WITH LOOP",
    "A74D": "LATIN SMALL LETTER O WITH LOOP",
    "A74E": "LATIN CAPITAL LETTER OO",
    "A74F": "LATIN SMALL LETTER OO",
    "A750": "LATIN CAPITAL LETTER P WITH STROKE THROUGH DESCENDER",
    "A751": "LATIN SMALL LETTER P WITH STROKE THROUGH DESCENDER",
    "A752": "LATIN CAPITAL LETTER P WITH FLOURISH",
    "A753": "LATIN SMALL LETTER P WITH FLOURISH",
    "A754": "LATIN CAPITAL LETTER P WITH SQUIRREL TAIL",
    "A755": "LATIN SMALL LETTER P WITH SQUIRREL TAIL",
    "A756": "LATIN CAPITAL LETTER Q WITH STROKE THROUGH DESCENDER",
    "A757": "LATIN SMALL LETTER Q WITH STROKE THROUGH DESCENDER",
    "A758": "LATIN CAPITAL LETTER Q WITH DIAGONAL STROKE",
    "A759": "LATIN SMALL LETTER Q WITH DIAGONAL STROKE",
    "A75A": "LATIN CAPITAL LETTER R ROTUNDA",
    "A75B": "LATIN SMALL LETTER R ROTUNDA",
    "A75C": "LATIN CAPITAL LETTER RUM ROTUNDA",
    "A75D": "LATIN SMALL LETTER RUM ROTUNDA",
    "A75E": "LATIN CAPITAL LETTER V WITH DIAGONAL STROKE",
    "A75F": "LATIN SMALL LETTER V WITH DIAGONAL STROKE",
    "A760": "LATIN CAPITAL LETTER VY",
    "A761": "LATIN SMALL LETTER VY",
    "A762": "LATIN CAPITAL LETTER VISIGOTHIC Z",
    "A763": "LATIN SMALL LETTER VISIGOTHIC Z",
    "A764": "LATIN CAPITAL LETTER THORN WITH STROKE",
    "A765": "LATIN SMALL LETTER THORN WITH STROKE",
    "A766": "LATIN CAPITAL LETTER THORN WITH STROKE THROUGH DESCENDER",
    "A767": "LATIN SMALL LETTER THORN WITH STROKE THROUGH DESCENDER",
    "A768": "LATIN CAPITAL LETTER VEND",
    "A769": "LATIN SMALL LETTER VEND",
    "A76A": "LATIN CAPITAL LETTER ET",
    "A76B": "LATIN SMALL LETTER ET",
    "A76C": "LATIN CAPITAL LETTER IS",
    "A76D": "LATIN SMALL LETTER IS",
    "A76E": "LATIN CAPITAL LETTER CON",
    "A76F": "LATIN SMALL LETTER CON",
    "A770": "MODIFIER LETTER US",
    "A771": "LATIN SMALL LETTER DUM",
    "A772": "LATIN SMALL LETTER LUM",
    "A773": "LATIN SMALL LETTER MUM",
    "A774": "LATIN SMALL LETTER NUM",
    "A775": "LATIN SMALL LETTER RUM",
    "A776": "LATIN LETTER SMALL CAPITAL RUM",
    "A777": "LATIN SMALL LETTER TUM",
    "A778": "LATIN SMALL LETTER UM",
    "A779": "LATIN CAPITAL LETTER INSULAR D",
    "A77A": "LATIN SMALL LETTER INSULAR D",
    "A77B": "LATIN CAPITAL LETTER INSULAR F",
    "A77C": "LATIN SMALL LETTER INSULAR F",
    "A77D": "LATIN CAPITAL LETTER INSULAR G",
    "A77E": "LATIN CAPITAL LETTER TURNED INSULAR G",
    "A77F": "LATIN SMALL LETTER TURNED INSULAR G",
    "A780": "LATIN CAPITAL LETTER TURNED L",
    "A781": "LATIN SMALL LETTER TURNED L",
    "A782": "LATIN CAPITAL LETTER INSULAR R",
    "A783": "LATIN SMALL LETTER INSULAR R",
    "A784": "LATIN CAPITAL LETTER INSULAR S",
    "A785": "LATIN SMALL LETTER INSULAR S",
    "A786": "LATIN CAPITAL LETTER INSULAR T",
    "A787": "LATIN SMALL LETTER INSULAR T",
    "A788": "MODIFIER LETTER LOW CIRCUMFLEX ACCENT",
    "A789": "MODIFIER LETTER COLON",
    "A78A": "MODIFIER LETTER SHORT EQUALS SIGN",
    "A78B": "LATIN CAPITAL LETTER SALTILLO",
    "A78C": "LATIN SMALL LETTER SALTILLO",
    "A78D": "LATIN CAPITAL LETTER TURNED H",
    "A78E": "LATIN SMALL LETTER L WITH RETROFLEX HOOK AND BELT",
    "A78F": "LATIN LETTER SINOLOGICAL DOT",
    "A790": "LATIN CAPITAL LETTER N WITH DESCENDER",
    "A791": "LATIN SMALL LETTER N WITH DESCENDER",
    "A792": "LATIN CAPITAL LETTER C WITH BAR",
    "A793": "LATIN SMALL LETTER C WITH BAR",
    "A794": "LATIN SMALL LETTER C WITH PALATAL HOOK",
    "A795": "LATIN SMALL LETTER H WITH PALATAL HOOK",
    "A796": "LATIN CAPITAL LETTER B WITH FLOURISH",
    "A797": "LATIN SMALL LETTER B WITH FLOURISH",
    "A798": "LATIN CAPITAL LETTER F WITH STROKE",
    "A799": "LATIN SMALL LETTER F WITH STROKE",
    "A79A": "LATIN CAPITAL LETTER VOLAPUK AE",
    "A79B": "LATIN SMALL LETTER VOLAPUK AE",
    "A79C": "LATIN CAPITAL LETTER VOLAPUK OE",
    "A79D": "LATIN SMALL LETTER VOLAPUK OE",
    "A79E": "LATIN CAPITAL LETTER VOLAPUK UE",
    "A79F": "LATIN SMALL LETTER VOLAPUK UE",
    "A7A0": "LATIN CAPITAL LETTER G WITH OBLIQUE STROKE",
    "A7A1": "LATIN SMALL LETTER G WITH OBLIQUE STROKE",
    "A7A2": "LATIN CAPITAL LETTER K WITH OBLIQUE STROKE",
    "A7A3": "LATIN SMALL LETTER K WITH OBLIQUE STROKE",
    "A7A4": "LATIN CAPITAL LETTER N WITH OBLIQUE STROKE",
    "A7A5": "LATIN SMALL LETTER N WITH OBLIQUE STROKE",
    "A7A6": "LATIN CAPITAL LETTER R WITH OBLIQUE STROKE",
    "A7A7": "LATIN SMALL LETTER R WITH OBLIQUE STROKE",
    "A7A8": "LATIN CAPITAL LETTER S WITH OBLIQUE STROKE",
    "A7A9": "LATIN SMALL LETTER S WITH OBLIQUE STROKE",
    "A7AA": "LATIN CAPITAL LETTER H WITH HOOK",
    "A7AB": "LATIN CAPITAL LETTER REVERSED OPEN E",
    "A7AC": "LATIN CAPITAL LETTER SCRIPT G",
    "A7AD": "LATIN CAPITAL LETTER L WITH BELT",
    "A7AE": "LATIN CAPITAL LETTER SMALL CAPITAL I",
    "A7B0": "LATIN CAPITAL LETTER TURNED K",
    "A7B1": "LATIN CAPITAL LETTER TURNED T",
    "A7B2": "LATIN CAPITAL LETTER J WITH CROSSED-TAIL",
    "A7B3": "LATIN CAPITAL LETTER CHI",
    "A7B4": "LATIN CAPITAL LETTER BETA",
    "A7B5": "LATIN SMALL LETTER BETA",
    "A7B6": "LATIN CAPITAL LETTER OMEGA",
    "A7B7": "LATIN SMALL LETTER OMEGA",
    "A7F7": "LATIN EPIGRAPHIC LETTER SIDEWAYS I",
    "A7F8": "MODIFIER LETTER CAPITAL H WITH STROKE",
    "A7F9": "MODIFIER LETTER SMALL LIGATURE OE",
    "A7FA": "LATIN LETTER SMALL CAPITAL TURNED M",
    "A7FB": "LATIN EPIGRAPHIC LETTER REVERSED F",
    "A7FC": "LATIN EPIGRAPHIC LETTER REVERSED P",
    "A7FD": "LATIN EPIGRAPHIC LETTER INVERTED M",
    "A7FE": "LATIN EPIGRAPHIC LETTER I LONGA",
    "A7FF": "LATIN EPIGRAPHIC LETTER ARCHAIC M",
    "A800": "SYLOTI NAGRI LETTER A",
    "A801": "SYLOTI NAGRI LETTER I",
    "A802": "SYLOTI NAGRI SIGN DVISVARA",
    "A803": "SYLOTI NAGRI LETTER U",
    "A804": "SYLOTI NAGRI LETTER E",
    "A805": "SYLOTI NAGRI LETTER O",
    "A806": "SYLOTI NAGRI SIGN HASANTA",
    "A807": "SYLOTI NAGRI LETTER KO",
    "A808": "SYLOTI NAGRI LETTER KHO",
    "A809": "SYLOTI NAGRI LETTER GO",
    "A80A": "SYLOTI NAGRI LETTER GHO",
    "A80B": "SYLOTI NAGRI SIGN ANUSVARA",
    "A80C": "SYLOTI NAGRI LETTER CO",
    "A80D": "SYLOTI NAGRI LETTER CHO",
    "A80E": "SYLOTI NAGRI LETTER JO",
    "A80F": "SYLOTI NAGRI LETTER JHO",
    "A810": "SYLOTI NAGRI LETTER TTO",
    "A811": "SYLOTI NAGRI LETTER TTHO",
    "A812": "SYLOTI NAGRI LETTER DDO",
    "A813": "SYLOTI NAGRI LETTER DDHO",
    "A814": "SYLOTI NAGRI LETTER TO",
    "A815": "SYLOTI NAGRI LETTER THO",
    "A816": "SYLOTI NAGRI LETTER DO",
    "A817": "SYLOTI NAGRI LETTER DHO",
    "A818": "SYLOTI NAGRI LETTER NO",
    "A819": "SYLOTI NAGRI LETTER PO",
    "A81A": "SYLOTI NAGRI LETTER PHO",
    "A81B": "SYLOTI NAGRI LETTER BO",
    "A81C": "SYLOTI NAGRI LETTER BHO",
    "A81D": "SYLOTI NAGRI LETTER MO",
    "A81E": "SYLOTI NAGRI LETTER RO",
    "A81F": "SYLOTI NAGRI LETTER LO",
    "A820": "SYLOTI NAGRI LETTER RRO",
    "A821": "SYLOTI NAGRI LETTER SO",
    "A822": "SYLOTI NAGRI LETTER HO",
    "A823": "SYLOTI NAGRI VOWEL SIGN A",
    "A824": "SYLOTI NAGRI VOWEL SIGN I",
    "A825": "SYLOTI NAGRI VOWEL SIGN U",
    "A826": "SYLOTI NAGRI VOWEL SIGN E",
    "A827": "SYLOTI NAGRI VOWEL SIGN OO",
    "A828": "SYLOTI NAGRI POETRY MARK-1",
    "A829": "SYLOTI NAGRI POETRY MARK-2",
    "A82A": "SYLOTI NAGRI POETRY MARK-3",
    "A82B": "SYLOTI NAGRI POETRY MARK-4",
    "A830": "NORTH INDIC FRACTION ONE QUARTER",
    "A831": "NORTH INDIC FRACTION ONE HALF",
    "A832": "NORTH INDIC FRACTION THREE QUARTERS",
    "A833": "NORTH INDIC FRACTION ONE SIXTEENTH",
    "A834": "NORTH INDIC FRACTION ONE EIGHTH",
    "A835": "NORTH INDIC FRACTION THREE SIXTEENTHS",
    "A836": "NORTH INDIC QUARTER MARK",
    "A837": "NORTH INDIC PLACEHOLDER MARK",
    "A838": "NORTH INDIC RUPEE MARK",
    "A839": "NORTH INDIC QUANTITY MARK",
    "A840": "PHAGS-PA LETTER KA",
    "A841": "PHAGS-PA LETTER KHA",
    "A842": "PHAGS-PA LETTER GA",
    "A843": "PHAGS-PA LETTER NGA",
    "A844": "PHAGS-PA LETTER CA",
    "A845": "PHAGS-PA LETTER CHA",
    "A846": "PHAGS-PA LETTER JA",
    "A847": "PHAGS-PA LETTER NYA",
    "A848": "PHAGS-PA LETTER TA",
    "A849": "PHAGS-PA LETTER THA",
    "A84A": "PHAGS-PA LETTER DA",
    "A84B": "PHAGS-PA LETTER NA",
    "A84C": "PHAGS-PA LETTER PA",
    "A84D": "PHAGS-PA LETTER PHA",
    "A84E": "PHAGS-PA LETTER BA",
    "A84F": "PHAGS-PA LETTER MA",
    "A850": "PHAGS-PA LETTER TSA",
    "A851": "PHAGS-PA LETTER TSHA",
    "A852": "PHAGS-PA LETTER DZA",
    "A853": "PHAGS-PA LETTER WA",
    "A854": "PHAGS-PA LETTER ZHA",
    "A855": "PHAGS-PA LETTER ZA",
    "A856": "PHAGS-PA LETTER SMALL A",
    "A857": "PHAGS-PA LETTER YA",
    "A858": "PHAGS-PA LETTER RA",
    "A859": "PHAGS-PA LETTER LA",
    "A85A": "PHAGS-PA LETTER SHA",
    "A85B": "PHAGS-PA LETTER SA",
    "A85C": "PHAGS-PA LETTER HA",
    "A85D": "PHAGS-PA LETTER A",
    "A85E": "PHAGS-PA LETTER I",
    "A85F": "PHAGS-PA LETTER U",
    "A860": "PHAGS-PA LETTER E",
    "A861": "PHAGS-PA LETTER O",
    "A862": "PHAGS-PA LETTER QA",
    "A863": "PHAGS-PA LETTER XA",
    "A864": "PHAGS-PA LETTER FA",
    "A865": "PHAGS-PA LETTER GGA",
    "A866": "PHAGS-PA LETTER EE",
    "A867": "PHAGS-PA SUBJOINED LETTER WA",
    "A868": "PHAGS-PA SUBJOINED LETTER YA",
    "A869": "PHAGS-PA LETTER TTA",
    "A86A": "PHAGS-PA LETTER TTHA",
    "A86B": "PHAGS-PA LETTER DDA",
    "A86C": "PHAGS-PA LETTER NNA",
    "A86D": "PHAGS-PA LETTER ALTERNATE YA",
    "A86E": "PHAGS-PA LETTER VOICELESS SHA",
    "A86F": "PHAGS-PA LETTER VOICED HA",
    "A870": "PHAGS-PA LETTER ASPIRATED FA",
    "A871": "PHAGS-PA SUBJOINED LETTER RA",
    "A872": "PHAGS-PA SUPERFIXED LETTER RA",
    "A873": "PHAGS-PA LETTER CANDRABINDU",
    "A874": "PHAGS-PA SINGLE HEAD MARK",
    "A875": "PHAGS-PA DOUBLE HEAD MARK",
    "A876": "PHAGS-PA MARK SHAD",
    "A877": "PHAGS-PA MARK DOUBLE SHAD",
    "A880": "SAURASHTRA SIGN ANUSVARA",
    "A881": "SAURASHTRA SIGN VISARGA",
    "A882": "SAURASHTRA LETTER A",
    "A883": "SAURASHTRA LETTER AA",
    "A884": "SAURASHTRA LETTER I",
    "A885": "SAURASHTRA LETTER II",
    "A886": "SAURASHTRA LETTER U",
    "A887": "SAURASHTRA LETTER UU",
    "A888": "SAURASHTRA LETTER VOCALIC R",
    "A889": "SAURASHTRA LETTER VOCALIC RR",
    "A88A": "SAURASHTRA LETTER VOCALIC L",
    "A88B": "SAURASHTRA LETTER VOCALIC LL",
    "A88C": "SAURASHTRA LETTER E",
    "A88D": "SAURASHTRA LETTER EE",
    "A88E": "SAURASHTRA LETTER AI",
    "A88F": "SAURASHTRA LETTER O",
    "A890": "SAURASHTRA LETTER OO",
    "A891": "SAURASHTRA LETTER AU",
    "A892": "SAURASHTRA LETTER KA",
    "A893": "SAURASHTRA LETTER KHA",
    "A894": "SAURASHTRA LETTER GA",
    "A895": "SAURASHTRA LETTER GHA",
    "A896": "SAURASHTRA LETTER NGA",
    "A897": "SAURASHTRA LETTER CA",
    "A898": "SAURASHTRA LETTER CHA",
    "A899": "SAURASHTRA LETTER JA",
    "A89A": "SAURASHTRA LETTER JHA",
    "A89B": "SAURASHTRA LETTER NYA",
    "A89C": "SAURASHTRA LETTER TTA",
    "A89D": "SAURASHTRA LETTER TTHA",
    "A89E": "SAURASHTRA LETTER DDA",
    "A89F": "SAURASHTRA LETTER DDHA",
    "A8A0": "SAURASHTRA LETTER NNA",
    "A8A1": "SAURASHTRA LETTER TA",
    "A8A2": "SAURASHTRA LETTER THA",
    "A8A3": "SAURASHTRA LETTER DA",
    "A8A4": "SAURASHTRA LETTER DHA",
    "A8A5": "SAURASHTRA LETTER NA",
    "A8A6": "SAURASHTRA LETTER PA",
    "A8A7": "SAURASHTRA LETTER PHA",
    "A8A8": "SAURASHTRA LETTER BA",
    "A8A9": "SAURASHTRA LETTER BHA",
    "A8AA": "SAURASHTRA LETTER MA",
    "A8AB": "SAURASHTRA LETTER YA",
    "A8AC": "SAURASHTRA LETTER RA",
    "A8AD": "SAURASHTRA LETTER LA",
    "A8AE": "SAURASHTRA LETTER VA",
    "A8AF": "SAURASHTRA LETTER SHA",
    "A8B0": "SAURASHTRA LETTER SSA",
    "A8B1": "SAURASHTRA LETTER SA",
    "A8B2": "SAURASHTRA LETTER HA",
    "A8B3": "SAURASHTRA LETTER LLA",
    "A8B4": "SAURASHTRA CONSONANT SIGN HAARU",
    "A8B5": "SAURASHTRA VOWEL SIGN AA",
    "A8B6": "SAURASHTRA VOWEL SIGN I",
    "A8B7": "SAURASHTRA VOWEL SIGN II",
    "A8B8": "SAURASHTRA VOWEL SIGN U",
    "A8B9": "SAURASHTRA VOWEL SIGN UU",
    "A8BA": "SAURASHTRA VOWEL SIGN VOCALIC R",
    "A8BB": "SAURASHTRA VOWEL SIGN VOCALIC RR",
    "A8BC": "SAURASHTRA VOWEL SIGN VOCALIC L",
    "A8BD": "SAURASHTRA VOWEL SIGN VOCALIC LL",
    "A8BE": "SAURASHTRA VOWEL SIGN E",
    "A8BF": "SAURASHTRA VOWEL SIGN EE",
    "A8C0": "SAURASHTRA VOWEL SIGN AI",
    "A8C1": "SAURASHTRA VOWEL SIGN O",
    "A8C2": "SAURASHTRA VOWEL SIGN OO",
    "A8C3": "SAURASHTRA VOWEL SIGN AU",
    "A8C4": "SAURASHTRA SIGN VIRAMA",
    "A8C5": "SAURASHTRA SIGN CANDRABINDU",
    "A8CE": "SAURASHTRA DANDA",
    "A8CF": "SAURASHTRA DOUBLE DANDA",
    "A8D0": "SAURASHTRA DIGIT ZERO",
    "A8D1": "SAURASHTRA DIGIT ONE",
    "A8D2": "SAURASHTRA DIGIT TWO",
    "A8D3": "SAURASHTRA DIGIT THREE",
    "A8D4": "SAURASHTRA DIGIT FOUR",
    "A8D5": "SAURASHTRA DIGIT FIVE",
    "A8D6": "SAURASHTRA DIGIT SIX",
    "A8D7": "SAURASHTRA DIGIT SEVEN",
    "A8D8": "SAURASHTRA DIGIT EIGHT",
    "A8D9": "SAURASHTRA DIGIT NINE",
    "A8E0": "COMBINING DEVANAGARI DIGIT ZERO",
    "A8E1": "COMBINING DEVANAGARI DIGIT ONE",
    "A8E2": "COMBINING DEVANAGARI DIGIT TWO",
    "A8E3": "COMBINING DEVANAGARI DIGIT THREE",
    "A8E4": "COMBINING DEVANAGARI DIGIT FOUR",
    "A8E5": "COMBINING DEVANAGARI DIGIT FIVE",
    "A8E6": "COMBINING DEVANAGARI DIGIT SIX",
    "A8E7": "COMBINING DEVANAGARI DIGIT SEVEN",
    "A8E8": "COMBINING DEVANAGARI DIGIT EIGHT",
    "A8E9": "COMBINING DEVANAGARI DIGIT NINE",
    "A8EA": "COMBINING DEVANAGARI LETTER A",
    "A8EB": "COMBINING DEVANAGARI LETTER U",
    "A8EC": "COMBINING DEVANAGARI LETTER KA",
    "A8ED": "COMBINING DEVANAGARI LETTER NA",
    "A8EE": "COMBINING DEVANAGARI LETTER PA",
    "A8EF": "COMBINING DEVANAGARI LETTER RA",
    "A8F0": "COMBINING DEVANAGARI LETTER VI",
    "A8F1": "COMBINING DEVANAGARI SIGN AVAGRAHA",
    "A8F2": "DEVANAGARI SIGN SPACING CANDRABINDU",
    "A8F3": "DEVANAGARI SIGN CANDRABINDU VIRAMA",
    "A8F4": "DEVANAGARI SIGN DOUBLE CANDRABINDU VIRAMA",
    "A8F5": "DEVANAGARI SIGN CANDRABINDU TWO",
    "A8F6": "DEVANAGARI SIGN CANDRABINDU THREE",
    "A8F7": "DEVANAGARI SIGN CANDRABINDU AVAGRAHA",
    "A8F8": "DEVANAGARI SIGN PUSHPIKA",
    "A8F9": "DEVANAGARI GAP FILLER",
    "A8FA": "DEVANAGARI CARET",
    "A8FB": "DEVANAGARI HEADSTROKE",
    "A8FC": "DEVANAGARI SIGN SIDDHAM",
    "A8FD": "DEVANAGARI JAIN OM",
    "A900": "KAYAH LI DIGIT ZERO",
    "A901": "KAYAH LI DIGIT ONE",
    "A902": "KAYAH LI DIGIT TWO",
    "A903": "KAYAH LI DIGIT THREE",
    "A904": "KAYAH LI DIGIT FOUR",
    "A905": "KAYAH LI DIGIT FIVE",
    "A906": "KAYAH LI DIGIT SIX",
    "A907": "KAYAH LI DIGIT SEVEN",
    "A908": "KAYAH LI DIGIT EIGHT",
    "A909": "KAYAH LI DIGIT NINE",
    "A90A": "KAYAH LI LETTER KA",
    "A90B": "KAYAH LI LETTER KHA",
    "A90C": "KAYAH LI LETTER GA",
    "A90D": "KAYAH LI LETTER NGA",
    "A90E": "KAYAH LI LETTER SA",
    "A90F": "KAYAH LI LETTER SHA",
    "A910": "KAYAH LI LETTER ZA",
    "A911": "KAYAH LI LETTER NYA",
    "A912": "KAYAH LI LETTER TA",
    "A913": "KAYAH LI LETTER HTA",
    "A914": "KAYAH LI LETTER NA",
    "A915": "KAYAH LI LETTER PA",
    "A916": "KAYAH LI LETTER PHA",
    "A917": "KAYAH LI LETTER MA",
    "A918": "KAYAH LI LETTER DA",
    "A919": "KAYAH LI LETTER BA",
    "A91A": "KAYAH LI LETTER RA",
    "A91B": "KAYAH LI LETTER YA",
    "A91C": "KAYAH LI LETTER LA",
    "A91D": "KAYAH LI LETTER WA",
    "A91E": "KAYAH LI LETTER THA",
    "A91F": "KAYAH LI LETTER HA",
    "A920": "KAYAH LI LETTER VA",
    "A921": "KAYAH LI LETTER CA",
    "A922": "KAYAH LI LETTER A",
    "A923": "KAYAH LI LETTER OE",
    "A924": "KAYAH LI LETTER I",
    "A925": "KAYAH LI LETTER OO",
    "A926": "KAYAH LI VOWEL UE",
    "A927": "KAYAH LI VOWEL E",
    "A928": "KAYAH LI VOWEL U",
    "A929": "KAYAH LI VOWEL EE",
    "A92A": "KAYAH LI VOWEL O",
    "A92B": "KAYAH LI TONE PLOPHU",
    "A92C": "KAYAH LI TONE CALYA",
    "A92D": "KAYAH LI TONE CALYA PLOPHU",
    "A92E": "KAYAH LI SIGN CWI",
    "A92F": "KAYAH LI SIGN SHYA",
    "A930": "REJANG LETTER KA",
    "A931": "REJANG LETTER GA",
    "A932": "REJANG LETTER NGA",
    "A933": "REJANG LETTER TA",
    "A934": "REJANG LETTER DA",
    "A935": "REJANG LETTER NA",
    "A936": "REJANG LETTER PA",
    "A937": "REJANG LETTER BA",
    "A938": "REJANG LETTER MA",
    "A939": "REJANG LETTER CA",
    "A93A": "REJANG LETTER JA",
    "A93B": "REJANG LETTER NYA",
    "A93C": "REJANG LETTER SA",
    "A93D": "REJANG LETTER RA",
    "A93E": "REJANG LETTER LA",
    "A93F": "REJANG LETTER YA",
    "A940": "REJANG LETTER WA",
    "A941": "REJANG LETTER HA",
    "A942": "REJANG LETTER MBA",
    "A943": "REJANG LETTER NGGA",
    "A944": "REJANG LETTER NDA",
    "A945": "REJANG LETTER NYJA",
    "A946": "REJANG LETTER A",
    "A947": "REJANG VOWEL SIGN I",
    "A948": "REJANG VOWEL SIGN U",
    "A949": "REJANG VOWEL SIGN E",
    "A94A": "REJANG VOWEL SIGN AI",
    "A94B": "REJANG VOWEL SIGN O",
    "A94C": "REJANG VOWEL SIGN AU",
    "A94D": "REJANG VOWEL SIGN EU",
    "A94E": "REJANG VOWEL SIGN EA",
    "A94F": "REJANG CONSONANT SIGN NG",
    "A950": "REJANG CONSONANT SIGN N",
    "A951": "REJANG CONSONANT SIGN R",
    "A952": "REJANG CONSONANT SIGN H",
    "A953": "REJANG VIRAMA",
    "A95F": "REJANG SECTION MARK",
    "A960": "HANGUL CHOSEONG TIKEUT-MIEUM",
    "A961": "HANGUL CHOSEONG TIKEUT-PIEUP",
    "A962": "HANGUL CHOSEONG TIKEUT-SIOS",
    "A963": "HANGUL CHOSEONG TIKEUT-CIEUC",
    "A964": "HANGUL CHOSEONG RIEUL-KIYEOK",
    "A965": "HANGUL CHOSEONG RIEUL-SSANGKIYEOK",
    "A966": "HANGUL CHOSEONG RIEUL-TIKEUT",
    "A967": "HANGUL CHOSEONG RIEUL-SSANGTIKEUT",
    "A968": "HANGUL CHOSEONG RIEUL-MIEUM",
    "A969": "HANGUL CHOSEONG RIEUL-PIEUP",
    "A96A": "HANGUL CHOSEONG RIEUL-SSANGPIEUP",
    "A96B": "HANGUL CHOSEONG RIEUL-KAPYEOUNPIEUP",
    "A96C": "HANGUL CHOSEONG RIEUL-SIOS",
    "A96D": "HANGUL CHOSEONG RIEUL-CIEUC",
    "A96E": "HANGUL CHOSEONG RIEUL-KHIEUKH",
    "A96F": "HANGUL CHOSEONG MIEUM-KIYEOK",
    "A970": "HANGUL CHOSEONG MIEUM-TIKEUT",
    "A971": "HANGUL CHOSEONG MIEUM-SIOS",
    "A972": "HANGUL CHOSEONG PIEUP-SIOS-THIEUTH",
    "A973": "HANGUL CHOSEONG PIEUP-KHIEUKH",
    "A974": "HANGUL CHOSEONG PIEUP-HIEUH",
    "A975": "HANGUL CHOSEONG SSANGSIOS-PIEUP",
    "A976": "HANGUL CHOSEONG IEUNG-RIEUL",
    "A977": "HANGUL CHOSEONG IEUNG-HIEUH",
    "A978": "HANGUL CHOSEONG SSANGCIEUC-HIEUH",
    "A979": "HANGUL CHOSEONG SSANGTHIEUTH",
    "A97A": "HANGUL CHOSEONG PHIEUPH-HIEUH",
    "A97B": "HANGUL CHOSEONG HIEUH-SIOS",
    "A97C": "HANGUL CHOSEONG SSANGYEORINHIEUH",
    "A980": "JAVANESE SIGN PANYANGGA",
    "A981": "JAVANESE SIGN CECAK",
    "A982": "JAVANESE SIGN LAYAR",
    "A983": "JAVANESE SIGN WIGNYAN",
    "A984": "JAVANESE LETTER A",
    "A985": "JAVANESE LETTER I KAWI",
    "A986": "JAVANESE LETTER I",
    "A987": "JAVANESE LETTER II",
    "A988": "JAVANESE LETTER U",
    "A989": "JAVANESE LETTER PA CEREK",
    "A98A": "JAVANESE LETTER NGA LELET",
    "A98B": "JAVANESE LETTER NGA LELET RASWADI",
    "A98C": "JAVANESE LETTER E",
    "A98D": "JAVANESE LETTER AI",
    "A98E": "JAVANESE LETTER O",
    "A98F": "JAVANESE LETTER KA",
    "A990": "JAVANESE LETTER KA SASAK",
    "A991": "JAVANESE LETTER KA MURDA",
    "A992": "JAVANESE LETTER GA",
    "A993": "JAVANESE LETTER GA MURDA",
    "A994": "JAVANESE LETTER NGA",
    "A995": "JAVANESE LETTER CA",
    "A996": "JAVANESE LETTER CA MURDA",
    "A997": "JAVANESE LETTER JA",
    "A998": "JAVANESE LETTER NYA MURDA",
    "A999": "JAVANESE LETTER JA MAHAPRANA",
    "A99A": "JAVANESE LETTER NYA",
    "A99B": "JAVANESE LETTER TTA",
    "A99C": "JAVANESE LETTER TTA MAHAPRANA",
    "A99D": "JAVANESE LETTER DDA",
    "A99E": "JAVANESE LETTER DDA MAHAPRANA",
    "A99F": "JAVANESE LETTER NA MURDA",
    "A9A0": "JAVANESE LETTER TA",
    "A9A1": "JAVANESE LETTER TA MURDA",
    "A9A2": "JAVANESE LETTER DA",
    "A9A3": "JAVANESE LETTER DA MAHAPRANA",
    "A9A4": "JAVANESE LETTER NA",
    "A9A5": "JAVANESE LETTER PA",
    "A9A6": "JAVANESE LETTER PA MURDA",
    "A9A7": "JAVANESE LETTER BA",
    "A9A8": "JAVANESE LETTER BA MURDA",
    "A9A9": "JAVANESE LETTER MA",
    "A9AA": "JAVANESE LETTER YA",
    "A9AB": "JAVANESE LETTER RA",
    "A9AC": "JAVANESE LETTER RA AGUNG",
    "A9AD": "JAVANESE LETTER LA",
    "A9AE": "JAVANESE LETTER WA",
    "A9AF": "JAVANESE LETTER SA MURDA",
    "A9B0": "JAVANESE LETTER SA MAHAPRANA",
    "A9B1": "JAVANESE LETTER SA",
    "A9B2": "JAVANESE LETTER HA",
    "A9B3": "JAVANESE SIGN CECAK TELU",
    "A9B4": "JAVANESE VOWEL SIGN TARUNG",
    "A9B5": "JAVANESE VOWEL SIGN TOLONG",
    "A9B6": "JAVANESE VOWEL SIGN WULU",
    "A9B7": "JAVANESE VOWEL SIGN WULU MELIK",
    "A9B8": "JAVANESE VOWEL SIGN SUKU",
    "A9B9": "JAVANESE VOWEL SIGN SUKU MENDUT",
    "A9BA": "JAVANESE VOWEL SIGN TALING",
    "A9BB": "JAVANESE VOWEL SIGN DIRGA MURE",
    "A9BC": "JAVANESE VOWEL SIGN PEPET",
    "A9BD": "JAVANESE CONSONANT SIGN KERET",
    "A9BE": "JAVANESE CONSONANT SIGN PENGKAL",
    "A9BF": "JAVANESE CONSONANT SIGN CAKRA",
    "A9C0": "JAVANESE PANGKON",
    "A9C1": "JAVANESE LEFT RERENGGAN",
    "A9C2": "JAVANESE RIGHT RERENGGAN",
    "A9C3": "JAVANESE PADA ANDAP",
    "A9C4": "JAVANESE PADA MADYA",
    "A9C5": "JAVANESE PADA LUHUR",
    "A9C6": "JAVANESE PADA WINDU",
    "A9C7": "JAVANESE PADA PANGKAT",
    "A9C8": "JAVANESE PADA LINGSA",
    "A9C9": "JAVANESE PADA LUNGSI",
    "A9CA": "JAVANESE PADA ADEG",
    "A9CB": "JAVANESE PADA ADEG ADEG",
    "A9CC": "JAVANESE PADA PISELEH",
    "A9CD": "JAVANESE TURNED PADA PISELEH",
    "A9CF": "JAVANESE PANGRANGKEP",
    "A9D0": "JAVANESE DIGIT ZERO",
    "A9D1": "JAVANESE DIGIT ONE",
    "A9D2": "JAVANESE DIGIT TWO",
    "A9D3": "JAVANESE DIGIT THREE",
    "A9D4": "JAVANESE DIGIT FOUR",
    "A9D5": "JAVANESE DIGIT FIVE",
    "A9D6": "JAVANESE DIGIT SIX",
    "A9D7": "JAVANESE DIGIT SEVEN",
    "A9D8": "JAVANESE DIGIT EIGHT",
    "A9D9": "JAVANESE DIGIT NINE",
    "A9DE": "JAVANESE PADA TIRTA TUMETES",
    "A9DF": "JAVANESE PADA ISEN-ISEN",
    "A9E0": "MYANMAR LETTER SHAN GHA",
    "A9E1": "MYANMAR LETTER SHAN CHA",
    "A9E2": "MYANMAR LETTER SHAN JHA",
    "A9E3": "MYANMAR LETTER SHAN NNA",
    "A9E4": "MYANMAR LETTER SHAN BHA",
    "A9E5": "MYANMAR SIGN SHAN SAW",
    "A9E6": "MYANMAR MODIFIER LETTER SHAN REDUPLICATION",
    "A9E7": "MYANMAR LETTER TAI LAING NYA",
    "A9E8": "MYANMAR LETTER TAI LAING FA",
    "A9E9": "MYANMAR LETTER TAI LAING GA",
    "A9EA": "MYANMAR LETTER TAI LAING GHA",
    "A9EB": "MYANMAR LETTER TAI LAING JA",
    "A9EC": "MYANMAR LETTER TAI LAING JHA",
    "A9ED": "MYANMAR LETTER TAI LAING DDA",
    "A9EE": "MYANMAR LETTER TAI LAING DDHA",
    "A9EF": "MYANMAR LETTER TAI LAING NNA",
    "A9F0": "MYANMAR TAI LAING DIGIT ZERO",
    "A9F1": "MYANMAR TAI LAING DIGIT ONE",
    "A9F2": "MYANMAR TAI LAING DIGIT TWO",
    "A9F3": "MYANMAR TAI LAING DIGIT THREE",
    "A9F4": "MYANMAR TAI LAING DIGIT FOUR",
    "A9F5": "MYANMAR TAI LAING DIGIT FIVE",
    "A9F6": "MYANMAR TAI LAING DIGIT SIX",
    "A9F7": "MYANMAR TAI LAING DIGIT SEVEN",
    "A9F8": "MYANMAR TAI LAING DIGIT EIGHT",
    "A9F9": "MYANMAR TAI LAING DIGIT NINE",
    "A9FA": "MYANMAR LETTER TAI LAING LLA",
    "A9FB": "MYANMAR LETTER TAI LAING DA",
    "A9FC": "MYANMAR LETTER TAI LAING DHA",
    "A9FD": "MYANMAR LETTER TAI LAING BA",
    "A9FE": "MYANMAR LETTER TAI LAING BHA",
    "AA00": "CHAM LETTER A",
    "AA01": "CHAM LETTER I",
    "AA02": "CHAM LETTER U",
    "AA03": "CHAM LETTER E",
    "AA04": "CHAM LETTER AI",
    "AA05": "CHAM LETTER O",
    "AA06": "CHAM LETTER KA",
    "AA07": "CHAM LETTER KHA",
    "AA08": "CHAM LETTER GA",
    "AA09": "CHAM LETTER GHA",
    "AA0A": "CHAM LETTER NGUE",
    "AA0B": "CHAM LETTER NGA",
    "AA0C": "CHAM LETTER CHA",
    "AA0D": "CHAM LETTER CHHA",
    "AA0E": "CHAM LETTER JA",
    "AA0F": "CHAM LETTER JHA",
    "AA10": "CHAM LETTER NHUE",
    "AA11": "CHAM LETTER NHA",
    "AA12": "CHAM LETTER NHJA",
    "AA13": "CHAM LETTER TA",
    "AA14": "CHAM LETTER THA",
    "AA15": "CHAM LETTER DA",
    "AA16": "CHAM LETTER DHA",
    "AA17": "CHAM LETTER NUE",
    "AA18": "CHAM LETTER NA",
    "AA19": "CHAM LETTER DDA",
    "AA1A": "CHAM LETTER PA",
    "AA1B": "CHAM LETTER PPA",
    "AA1C": "CHAM LETTER PHA",
    "AA1D": "CHAM LETTER BA",
    "AA1E": "CHAM LETTER BHA",
    "AA1F": "CHAM LETTER MUE",
    "AA20": "CHAM LETTER MA",
    "AA21": "CHAM LETTER BBA",
    "AA22": "CHAM LETTER YA",
    "AA23": "CHAM LETTER RA",
    "AA24": "CHAM LETTER LA",
    "AA25": "CHAM LETTER VA",
    "AA26": "CHAM LETTER SSA",
    "AA27": "CHAM LETTER SA",
    "AA28": "CHAM LETTER HA",
    "AA29": "CHAM VOWEL SIGN AA",
    "AA2A": "CHAM VOWEL SIGN I",
    "AA2B": "CHAM VOWEL SIGN II",
    "AA2C": "CHAM VOWEL SIGN EI",
    "AA2D": "CHAM VOWEL SIGN U",
    "AA2E": "CHAM VOWEL SIGN OE",
    "AA2F": "CHAM VOWEL SIGN O",
    "AA30": "CHAM VOWEL SIGN AI",
    "AA31": "CHAM VOWEL SIGN AU",
    "AA32": "CHAM VOWEL SIGN UE",
    "AA33": "CHAM CONSONANT SIGN YA",
    "AA34": "CHAM CONSONANT SIGN RA",
    "AA35": "CHAM CONSONANT SIGN LA",
    "AA36": "CHAM CONSONANT SIGN WA",
    "AA40": "CHAM LETTER FINAL K",
    "AA41": "CHAM LETTER FINAL G",
    "AA42": "CHAM LETTER FINAL NG",
    "AA43": "CHAM CONSONANT SIGN FINAL NG",
    "AA44": "CHAM LETTER FINAL CH",
    "AA45": "CHAM LETTER FINAL T",
    "AA46": "CHAM LETTER FINAL N",
    "AA47": "CHAM LETTER FINAL P",
    "AA48": "CHAM LETTER FINAL Y",
    "AA49": "CHAM LETTER FINAL R",
    "AA4A": "CHAM LETTER FINAL L",
    "AA4B": "CHAM LETTER FINAL SS",
    "AA4C": "CHAM CONSONANT SIGN FINAL M",
    "AA4D": "CHAM CONSONANT SIGN FINAL H",
    "AA50": "CHAM DIGIT ZERO",
    "AA51": "CHAM DIGIT ONE",
    "AA52": "CHAM DIGIT TWO",
    "AA53": "CHAM DIGIT THREE",
    "AA54": "CHAM DIGIT FOUR",
    "AA55": "CHAM DIGIT FIVE",
    "AA56": "CHAM DIGIT SIX",
    "AA57": "CHAM DIGIT SEVEN",
    "AA58": "CHAM DIGIT EIGHT",
    "AA59": "CHAM DIGIT NINE",
    "AA5C": "CHAM PUNCTUATION SPIRAL",
    "AA5D": "CHAM PUNCTUATION DANDA",
    "AA5E": "CHAM PUNCTUATION DOUBLE DANDA",
    "AA5F": "CHAM PUNCTUATION TRIPLE DANDA",
    "AA60": "MYANMAR LETTER KHAMTI GA",
    "AA61": "MYANMAR LETTER KHAMTI CA",
    "AA62": "MYANMAR LETTER KHAMTI CHA",
    "AA63": "MYANMAR LETTER KHAMTI JA",
    "AA64": "MYANMAR LETTER KHAMTI JHA",
    "AA65": "MYANMAR LETTER KHAMTI NYA",
    "AA66": "MYANMAR LETTER KHAMTI TTA",
    "AA67": "MYANMAR LETTER KHAMTI TTHA",
    "AA68": "MYANMAR LETTER KHAMTI DDA",
    "AA69": "MYANMAR LETTER KHAMTI DDHA",
    "AA6A": "MYANMAR LETTER KHAMTI DHA",
    "AA6B": "MYANMAR LETTER KHAMTI NA",
    "AA6C": "MYANMAR LETTER KHAMTI SA",
    "AA6D": "MYANMAR LETTER KHAMTI HA",
    "AA6E": "MYANMAR LETTER KHAMTI HHA",
    "AA6F": "MYANMAR LETTER KHAMTI FA",
    "AA70": "MYANMAR MODIFIER LETTER KHAMTI REDUPLICATION",
    "AA71": "MYANMAR LETTER KHAMTI XA",
    "AA72": "MYANMAR LETTER KHAMTI ZA",
    "AA73": "MYANMAR LETTER KHAMTI RA",
    "AA74": "MYANMAR LOGOGRAM KHAMTI OAY",
    "AA75": "MYANMAR LOGOGRAM KHAMTI QN",
    "AA76": "MYANMAR LOGOGRAM KHAMTI HM",
    "AA77": "MYANMAR SYMBOL AITON EXCLAMATION",
    "AA78": "MYANMAR SYMBOL AITON ONE",
    "AA79": "MYANMAR SYMBOL AITON TWO",
    "AA7A": "MYANMAR LETTER AITON RA",
    "AA7B": "MYANMAR SIGN PAO KAREN TONE",
    "AA7C": "MYANMAR SIGN TAI LAING TONE-2",
    "AA7D": "MYANMAR SIGN TAI LAING TONE-5",
    "AA7E": "MYANMAR LETTER SHWE PALAUNG CHA",
    "AA7F": "MYANMAR LETTER SHWE PALAUNG SHA",
    "AA80": "TAI VIET LETTER LOW KO",
    "AA81": "TAI VIET LETTER HIGH KO",
    "AA82": "TAI VIET LETTER LOW KHO",
    "AA83": "TAI VIET LETTER HIGH KHO",
    "AA84": "TAI VIET LETTER LOW KHHO",
    "AA85": "TAI VIET LETTER HIGH KHHO",
    "AA86": "TAI VIET LETTER LOW GO",
    "AA87": "TAI VIET LETTER HIGH GO",
    "AA88": "TAI VIET LETTER LOW NGO",
    "AA89": "TAI VIET LETTER HIGH NGO",
    "AA8A": "TAI VIET LETTER LOW CO",
    "AA8B": "TAI VIET LETTER HIGH CO",
    "AA8C": "TAI VIET LETTER LOW CHO",
    "AA8D": "TAI VIET LETTER HIGH CHO",
    "AA8E": "TAI VIET LETTER LOW SO",
    "AA8F": "TAI VIET LETTER HIGH SO",
    "AA90": "TAI VIET LETTER LOW NYO",
    "AA91": "TAI VIET LETTER HIGH NYO",
    "AA92": "TAI VIET LETTER LOW DO",
    "AA93": "TAI VIET LETTER HIGH DO",
    "AA94": "TAI VIET LETTER LOW TO",
    "AA95": "TAI VIET LETTER HIGH TO",
    "AA96": "TAI VIET LETTER LOW THO",
    "AA97": "TAI VIET LETTER HIGH THO",
    "AA98": "TAI VIET LETTER LOW NO",
    "AA99": "TAI VIET LETTER HIGH NO",
    "AA9A": "TAI VIET LETTER LOW BO",
    "AA9B": "TAI VIET LETTER HIGH BO",
    "AA9C": "TAI VIET LETTER LOW PO",
    "AA9D": "TAI VIET LETTER HIGH PO",
    "AA9E": "TAI VIET LETTER LOW PHO",
    "AA9F": "TAI VIET LETTER HIGH PHO",
    "AAA0": "TAI VIET LETTER LOW FO",
    "AAA1": "TAI VIET LETTER HIGH FO",
    "AAA2": "TAI VIET LETTER LOW MO",
    "AAA3": "TAI VIET LETTER HIGH MO",
    "AAA4": "TAI VIET LETTER LOW YO",
    "AAA5": "TAI VIET LETTER HIGH YO",
    "AAA6": "TAI VIET LETTER LOW RO",
    "AAA7": "TAI VIET LETTER HIGH RO",
    "AAA8": "TAI VIET LETTER LOW LO",
    "AAA9": "TAI VIET LETTER HIGH LO",
    "AAAA": "TAI VIET LETTER LOW VO",
    "AAAB": "TAI VIET LETTER HIGH VO",
    "AAAC": "TAI VIET LETTER LOW HO",
    "AAAD": "TAI VIET LETTER HIGH HO",
    "AAAE": "TAI VIET LETTER LOW O",
    "AAAF": "TAI VIET LETTER HIGH O",
    "AAB0": "TAI VIET MAI KANG",
    "AAB1": "TAI VIET VOWEL AA",
    "AAB2": "TAI VIET VOWEL I",
    "AAB3": "TAI VIET VOWEL UE",
    "AAB4": "TAI VIET VOWEL U",
    "AAB5": "TAI VIET VOWEL E",
    "AAB6": "TAI VIET VOWEL O",
    "AAB7": "TAI VIET MAI KHIT",
    "AAB8": "TAI VIET VOWEL IA",
    "AAB9": "TAI VIET VOWEL UEA",
    "AABA": "TAI VIET VOWEL UA",
    "AABB": "TAI VIET VOWEL AUE",
    "AABC": "TAI VIET VOWEL AY",
    "AABD": "TAI VIET VOWEL AN",
    "AABE": "TAI VIET VOWEL AM",
    "AABF": "TAI VIET TONE MAI EK",
    "AAC0": "TAI VIET TONE MAI NUENG",
    "AAC1": "TAI VIET TONE MAI THO",
    "AAC2": "TAI VIET TONE MAI SONG",
    "AADB": "TAI VIET SYMBOL KON",
    "AADC": "TAI VIET SYMBOL NUENG",
    "AADD": "TAI VIET SYMBOL SAM",
    "AADE": "TAI VIET SYMBOL HO HOI",
    "AADF": "TAI VIET SYMBOL KOI KOI",
    "AAE0": "MEETEI MAYEK LETTER E",
    "AAE1": "MEETEI MAYEK LETTER O",
    "AAE2": "MEETEI MAYEK LETTER CHA",
    "AAE3": "MEETEI MAYEK LETTER NYA",
    "AAE4": "MEETEI MAYEK LETTER TTA",
    "AAE5": "MEETEI MAYEK LETTER TTHA",
    "AAE6": "MEETEI MAYEK LETTER DDA",
    "AAE7": "MEETEI MAYEK LETTER DDHA",
    "AAE8": "MEETEI MAYEK LETTER NNA",
    "AAE9": "MEETEI MAYEK LETTER SHA",
    "AAEA": "MEETEI MAYEK LETTER SSA",
    "AAEB": "MEETEI MAYEK VOWEL SIGN II",
    "AAEC": "MEETEI MAYEK VOWEL SIGN UU",
    "AAED": "MEETEI MAYEK VOWEL SIGN AAI",
    "AAEE": "MEETEI MAYEK VOWEL SIGN AU",
    "AAEF": "MEETEI MAYEK VOWEL SIGN AAU",
    "AAF0": "MEETEI MAYEK CHEIKHAN",
    "AAF1": "MEETEI MAYEK AHANG KHUDAM",
    "AAF2": "MEETEI MAYEK ANJI",
    "AAF3": "MEETEI MAYEK SYLLABLE REPETITION MARK",
    "AAF4": "MEETEI MAYEK WORD REPETITION MARK",
    "AAF5": "MEETEI MAYEK VOWEL SIGN VISARGA",
    "AAF6": "MEETEI MAYEK VIRAMA",
    "AB01": "ETHIOPIC SYLLABLE TTHU",
    "AB02": "ETHIOPIC SYLLABLE TTHI",
    "AB03": "ETHIOPIC SYLLABLE TTHAA",
    "AB04": "ETHIOPIC SYLLABLE TTHEE",
    "AB05": "ETHIOPIC SYLLABLE TTHE",
    "AB06": "ETHIOPIC SYLLABLE TTHO",
    "AB09": "ETHIOPIC SYLLABLE DDHU",
    "AB0A": "ETHIOPIC SYLLABLE DDHI",
    "AB0B": "ETHIOPIC SYLLABLE DDHAA",
    "AB0C": "ETHIOPIC SYLLABLE DDHEE",
    "AB0D": "ETHIOPIC SYLLABLE DDHE",
    "AB0E": "ETHIOPIC SYLLABLE DDHO",
    "AB11": "ETHIOPIC SYLLABLE DZU",
    "AB12": "ETHIOPIC SYLLABLE DZI",
    "AB13": "ETHIOPIC SYLLABLE DZAA",
    "AB14": "ETHIOPIC SYLLABLE DZEE",
    "AB15": "ETHIOPIC SYLLABLE DZE",
    "AB16": "ETHIOPIC SYLLABLE DZO",
    "AB20": "ETHIOPIC SYLLABLE CCHHA",
    "AB21": "ETHIOPIC SYLLABLE CCHHU",
    "AB22": "ETHIOPIC SYLLABLE CCHHI",
    "AB23": "ETHIOPIC SYLLABLE CCHHAA",
    "AB24": "ETHIOPIC SYLLABLE CCHHEE",
    "AB25": "ETHIOPIC SYLLABLE CCHHE",
    "AB26": "ETHIOPIC SYLLABLE CCHHO",
    "AB28": "ETHIOPIC SYLLABLE BBA",
    "AB29": "ETHIOPIC SYLLABLE BBU",
    "AB2A": "ETHIOPIC SYLLABLE BBI",
    "AB2B": "ETHIOPIC SYLLABLE BBAA",
    "AB2C": "ETHIOPIC SYLLABLE BBEE",
    "AB2D": "ETHIOPIC SYLLABLE BBE",
    "AB2E": "ETHIOPIC SYLLABLE BBO",
    "AB30": "LATIN SMALL LETTER BARRED ALPHA",
    "AB31": "LATIN SMALL LETTER A REVERSED-SCHWA",
    "AB32": "LATIN SMALL LETTER BLACKLETTER E",
    "AB33": "LATIN SMALL LETTER BARRED E",
    "AB34": "LATIN SMALL LETTER E WITH FLOURISH",
    "AB35": "LATIN SMALL LETTER LENIS F",
    "AB36": "LATIN SMALL LETTER SCRIPT G WITH CROSSED-TAIL",
    "AB37": "LATIN SMALL LETTER L WITH INVERTED LAZY S",
    "AB38": "LATIN SMALL LETTER L WITH DOUBLE MIDDLE TILDE",
    "AB39": "LATIN SMALL LETTER L WITH MIDDLE RING",
    "AB3A": "LATIN SMALL LETTER M WITH CROSSED-TAIL",
    "AB3B": "LATIN SMALL LETTER N WITH CROSSED-TAIL",
    "AB3C": "LATIN SMALL LETTER ENG WITH CROSSED-TAIL",
    "AB3D": "LATIN SMALL LETTER BLACKLETTER O",
    "AB3E": "LATIN SMALL LETTER BLACKLETTER O WITH STROKE",
    "AB3F": "LATIN SMALL LETTER OPEN O WITH STROKE",
    "AB40": "LATIN SMALL LETTER INVERTED OE",
    "AB41": "LATIN SMALL LETTER TURNED OE WITH STROKE",
    "AB42": "LATIN SMALL LETTER TURNED OE WITH HORIZONTAL STROKE",
    "AB43": "LATIN SMALL LETTER TURNED O OPEN-O",
    "AB44": "LATIN SMALL LETTER TURNED O OPEN-O WITH STROKE",
    "AB45": "LATIN SMALL LETTER STIRRUP R",
    "AB46": "LATIN LETTER SMALL CAPITAL R WITH RIGHT LEG",
    "AB47": "LATIN SMALL LETTER R WITHOUT HANDLE",
    "AB48": "LATIN SMALL LETTER DOUBLE R",
    "AB49": "LATIN SMALL LETTER R WITH CROSSED-TAIL",
    "AB4A": "LATIN SMALL LETTER DOUBLE R WITH CROSSED-TAIL",
    "AB4B": "LATIN SMALL LETTER SCRIPT R",
    "AB4C": "LATIN SMALL LETTER SCRIPT R WITH RING",
    "AB4D": "LATIN SMALL LETTER BASELINE ESH",
    "AB4E": "LATIN SMALL LETTER U WITH SHORT RIGHT LEG",
    "AB4F": "LATIN SMALL LETTER U BAR WITH SHORT RIGHT LEG",
    "AB50": "LATIN SMALL LETTER UI",
    "AB51": "LATIN SMALL LETTER TURNED UI",
    "AB52": "LATIN SMALL LETTER U WITH LEFT HOOK",
    "AB53": "LATIN SMALL LETTER CHI",
    "AB54": "LATIN SMALL LETTER CHI WITH LOW RIGHT RING",
    "AB55": "LATIN SMALL LETTER CHI WITH LOW LEFT SERIF",
    "AB56": "LATIN SMALL LETTER X WITH LOW RIGHT RING",
    "AB57": "LATIN SMALL LETTER X WITH LONG LEFT LEG",
    "AB58": "LATIN SMALL LETTER X WITH LONG LEFT LEG AND LOW RIGHT RING",
    "AB59": "LATIN SMALL LETTER X WITH LONG LEFT LEG WITH SERIF",
    "AB5A": "LATIN SMALL LETTER Y WITH SHORT RIGHT LEG",
    "AB5B": "MODIFIER BREVE WITH INVERTED BREVE",
    "AB5C": "MODIFIER LETTER SMALL HENG",
    "AB5D": "MODIFIER LETTER SMALL L WITH INVERTED LAZY S",
    "AB5E": "MODIFIER LETTER SMALL L WITH MIDDLE TILDE",
    "AB5F": "MODIFIER LETTER SMALL U WITH LEFT HOOK",
    "AB60": "LATIN SMALL LETTER SAKHA YAT",
    "AB61": "LATIN SMALL LETTER IOTIFIED E",
    "AB62": "LATIN SMALL LETTER OPEN OE",
    "AB63": "LATIN SMALL LETTER UO",
    "AB64": "LATIN SMALL LETTER INVERTED ALPHA",
    "AB65": "GREEK LETTER SMALL CAPITAL OMEGA",
    "AB70": "CHEROKEE SMALL LETTER A",
    "AB71": "CHEROKEE SMALL LETTER E",
    "AB72": "CHEROKEE SMALL LETTER I",
    "AB73": "CHEROKEE SMALL LETTER O",
    "AB74": "CHEROKEE SMALL LETTER U",
    "AB75": "CHEROKEE SMALL LETTER V",
    "AB76": "CHEROKEE SMALL LETTER GA",
    "AB77": "CHEROKEE SMALL LETTER KA",
    "AB78": "CHEROKEE SMALL LETTER GE",
    "AB79": "CHEROKEE SMALL LETTER GI",
    "AB7A": "CHEROKEE SMALL LETTER GO",
    "AB7B": "CHEROKEE SMALL LETTER GU",
    "AB7C": "CHEROKEE SMALL LETTER GV",
    "AB7D": "CHEROKEE SMALL LETTER HA",
    "AB7E": "CHEROKEE SMALL LETTER HE",
    "AB7F": "CHEROKEE SMALL LETTER HI",
    "AB80": "CHEROKEE SMALL LETTER HO",
    "AB81": "CHEROKEE SMALL LETTER HU",
    "AB82": "CHEROKEE SMALL LETTER HV",
    "AB83": "CHEROKEE SMALL LETTER LA",
    "AB84": "CHEROKEE SMALL LETTER LE",
    "AB85": "CHEROKEE SMALL LETTER LI",
    "AB86": "CHEROKEE SMALL LETTER LO",
    "AB87": "CHEROKEE SMALL LETTER LU",
    "AB88": "CHEROKEE SMALL LETTER LV",
    "AB89": "CHEROKEE SMALL LETTER MA",
    "AB8A": "CHEROKEE SMALL LETTER ME",
    "AB8B": "CHEROKEE SMALL LETTER MI",
    "AB8C": "CHEROKEE SMALL LETTER MO",
    "AB8D": "CHEROKEE SMALL LETTER MU",
    "AB8E": "CHEROKEE SMALL LETTER NA",
    "AB8F": "CHEROKEE SMALL LETTER HNA",
    "AB90": "CHEROKEE SMALL LETTER NAH",
    "AB91": "CHEROKEE SMALL LETTER NE",
    "AB92": "CHEROKEE SMALL LETTER NI",
    "AB93": "CHEROKEE SMALL LETTER NO",
    "AB94": "CHEROKEE SMALL LETTER NU",
    "AB95": "CHEROKEE SMALL LETTER NV",
    "AB96": "CHEROKEE SMALL LETTER QUA",
    "AB97": "CHEROKEE SMALL LETTER QUE",
    "AB98": "CHEROKEE SMALL LETTER QUI",
    "AB99": "CHEROKEE SMALL LETTER QUO",
    "AB9A": "CHEROKEE SMALL LETTER QUU",
    "AB9B": "CHEROKEE SMALL LETTER QUV",
    "AB9C": "CHEROKEE SMALL LETTER SA",
    "AB9D": "CHEROKEE SMALL LETTER S",
    "AB9E": "CHEROKEE SMALL LETTER SE",
    "AB9F": "CHEROKEE SMALL LETTER SI",
    "ABA0": "CHEROKEE SMALL LETTER SO",
    "ABA1": "CHEROKEE SMALL LETTER SU",
    "ABA2": "CHEROKEE SMALL LETTER SV",
    "ABA3": "CHEROKEE SMALL LETTER DA",
    "ABA4": "CHEROKEE SMALL LETTER TA",
    "ABA5": "CHEROKEE SMALL LETTER DE",
    "ABA6": "CHEROKEE SMALL LETTER TE",
    "ABA7": "CHEROKEE SMALL LETTER DI",
    "ABA8": "CHEROKEE SMALL LETTER TI",
    "ABA9": "CHEROKEE SMALL LETTER DO",
    "ABAA": "CHEROKEE SMALL LETTER DU",
    "ABAB": "CHEROKEE SMALL LETTER DV",
    "ABAC": "CHEROKEE SMALL LETTER DLA",
    "ABAD": "CHEROKEE SMALL LETTER TLA",
    "ABAE": "CHEROKEE SMALL LETTER TLE",
    "ABAF": "CHEROKEE SMALL LETTER TLI",
    "ABB0": "CHEROKEE SMALL LETTER TLO",
    "ABB1": "CHEROKEE SMALL LETTER TLU",
    "ABB2": "CHEROKEE SMALL LETTER TLV",
    "ABB3": "CHEROKEE SMALL LETTER TSA",
    "ABB4": "CHEROKEE SMALL LETTER TSE",
    "ABB5": "CHEROKEE SMALL LETTER TSI",
    "ABB6": "CHEROKEE SMALL LETTER TSO",
    "ABB7": "CHEROKEE SMALL LETTER TSU",
    "ABB8": "CHEROKEE SMALL LETTER TSV",
    "ABB9": "CHEROKEE SMALL LETTER WA",
    "ABBA": "CHEROKEE SMALL LETTER WE",
    "ABBB": "CHEROKEE SMALL LETTER WI",
    "ABBC": "CHEROKEE SMALL LETTER WO",
    "ABBD": "CHEROKEE SMALL LETTER WU",
    "ABBE": "CHEROKEE SMALL LETTER WV",
    "ABBF": "CHEROKEE SMALL LETTER YA",
    "ABC0": "MEETEI MAYEK LETTER KOK",
    "ABC1": "MEETEI MAYEK LETTER SAM",
    "ABC2": "MEETEI MAYEK LETTER LAI",
    "ABC3": "MEETEI MAYEK LETTER MIT",
    "ABC4": "MEETEI MAYEK LETTER PA",
    "ABC5": "MEETEI MAYEK LETTER NA",
    "ABC6": "MEETEI MAYEK LETTER CHIL",
    "ABC7": "MEETEI MAYEK LETTER TIL",
    "ABC8": "MEETEI MAYEK LETTER KHOU",
    "ABC9": "MEETEI MAYEK LETTER NGOU",
    "ABCA": "MEETEI MAYEK LETTER THOU",
    "ABCB": "MEETEI MAYEK LETTER WAI",
    "ABCC": "MEETEI MAYEK LETTER YANG",
    "ABCD": "MEETEI MAYEK LETTER HUK",
    "ABCE": "MEETEI MAYEK LETTER UN",
    "ABCF": "MEETEI MAYEK LETTER I",
    "ABD0": "MEETEI MAYEK LETTER PHAM",
    "ABD1": "MEETEI MAYEK LETTER ATIYA",
    "ABD2": "MEETEI MAYEK LETTER GOK",
    "ABD3": "MEETEI MAYEK LETTER JHAM",
    "ABD4": "MEETEI MAYEK LETTER RAI",
    "ABD5": "MEETEI MAYEK LETTER BA",
    "ABD6": "MEETEI MAYEK LETTER JIL",
    "ABD7": "MEETEI MAYEK LETTER DIL",
    "ABD8": "MEETEI MAYEK LETTER GHOU",
    "ABD9": "MEETEI MAYEK LETTER DHOU",
    "ABDA": "MEETEI MAYEK LETTER BHAM",
    "ABDB": "MEETEI MAYEK LETTER KOK LONSUM",
    "ABDC": "MEETEI MAYEK LETTER LAI LONSUM",
    "ABDD": "MEETEI MAYEK LETTER MIT LONSUM",
    "ABDE": "MEETEI MAYEK LETTER PA LONSUM",
    "ABDF": "MEETEI MAYEK LETTER NA LONSUM",
    "ABE0": "MEETEI MAYEK LETTER TIL LONSUM",
    "ABE1": "MEETEI MAYEK LETTER NGOU LONSUM",
    "ABE2": "MEETEI MAYEK LETTER I LONSUM",
    "ABE3": "MEETEI MAYEK VOWEL SIGN ONAP",
    "ABE4": "MEETEI MAYEK VOWEL SIGN INAP",
    "ABE5": "MEETEI MAYEK VOWEL SIGN ANAP",
    "ABE6": "MEETEI MAYEK VOWEL SIGN YENAP",
    "ABE7": "MEETEI MAYEK VOWEL SIGN SOUNAP",
    "ABE8": "MEETEI MAYEK VOWEL SIGN UNAP",
    "ABE9": "MEETEI MAYEK VOWEL SIGN CHEINAP",
    "ABEA": "MEETEI MAYEK VOWEL SIGN NUNG",
    "ABEB": "MEETEI MAYEK CHEIKHEI",
    "ABEC": "MEETEI MAYEK LUM IYEK",
    "ABED": "MEETEI MAYEK APUN IYEK",
    "ABF0": "MEETEI MAYEK DIGIT ZERO",
    "ABF1": "MEETEI MAYEK DIGIT ONE",
    "ABF2": "MEETEI MAYEK DIGIT TWO",
    "ABF3": "MEETEI MAYEK DIGIT THREE",
    "ABF4": "MEETEI MAYEK DIGIT FOUR",
    "ABF5": "MEETEI MAYEK DIGIT FIVE",
    "ABF6": "MEETEI MAYEK DIGIT SIX",
    "ABF7": "MEETEI MAYEK DIGIT SEVEN",
    "ABF8": "MEETEI MAYEK DIGIT EIGHT",
    "ABF9": "MEETEI MAYEK DIGIT NINE",
    # "AC00":  "<Hangul Syllable, First>", */
    # "D7A3":  "<Hangul Syllable, Last>", */
    "D7B0": "HANGUL JUNGSEONG O-YEO",
    "D7B1": "HANGUL JUNGSEONG O-O-I",
    "D7B2": "HANGUL JUNGSEONG YO-A",
    "D7B3": "HANGUL JUNGSEONG YO-AE",
    "D7B4": "HANGUL JUNGSEONG YO-EO",
    "D7B5": "HANGUL JUNGSEONG U-YEO",
    "D7B6": "HANGUL JUNGSEONG U-I-I",
    "D7B7": "HANGUL JUNGSEONG YU-AE",
    "D7B8": "HANGUL JUNGSEONG YU-O",
    "D7B9": "HANGUL JUNGSEONG EU-A",
    "D7BA": "HANGUL JUNGSEONG EU-EO",
    "D7BB": "HANGUL JUNGSEONG EU-E",
    "D7BC": "HANGUL JUNGSEONG EU-O",
    "D7BD": "HANGUL JUNGSEONG I-YA-O",
    "D7BE": "HANGUL JUNGSEONG I-YAE",
    "D7BF": "HANGUL JUNGSEONG I-YEO",
    "D7C0": "HANGUL JUNGSEONG I-YE",
    "D7C1": "HANGUL JUNGSEONG I-O-I",
    "D7C2": "HANGUL JUNGSEONG I-YO",
    "D7C3": "HANGUL JUNGSEONG I-YU",
    "D7C4": "HANGUL JUNGSEONG I-I",
    "D7C5": "HANGUL JUNGSEONG ARAEA-A",
    "D7C6": "HANGUL JUNGSEONG ARAEA-E",
    "D7CB": "HANGUL JONGSEONG NIEUN-RIEUL",
    "D7CC": "HANGUL JONGSEONG NIEUN-CHIEUCH",
    "D7CD": "HANGUL JONGSEONG SSANGTIKEUT",
    "D7CE": "HANGUL JONGSEONG SSANGTIKEUT-PIEUP",
    "D7CF": "HANGUL JONGSEONG TIKEUT-PIEUP",
    "D7D0": "HANGUL JONGSEONG TIKEUT-SIOS",
    "D7D1": "HANGUL JONGSEONG TIKEUT-SIOS-KIYEOK",
    "D7D2": "HANGUL JONGSEONG TIKEUT-CIEUC",
    "D7D3": "HANGUL JONGSEONG TIKEUT-CHIEUCH",
    "D7D4": "HANGUL JONGSEONG TIKEUT-THIEUTH",
    "D7D5": "HANGUL JONGSEONG RIEUL-SSANGKIYEOK",
    "D7D6": "HANGUL JONGSEONG RIEUL-KIYEOK-HIEUH",
    "D7D7": "HANGUL JONGSEONG SSANGRIEUL-KHIEUKH",
    "D7D8": "HANGUL JONGSEONG RIEUL-MIEUM-HIEUH",
    "D7D9": "HANGUL JONGSEONG RIEUL-PIEUP-TIKEUT",
    "D7DA": "HANGUL JONGSEONG RIEUL-PIEUP-PHIEUPH",
    "D7DB": "HANGUL JONGSEONG RIEUL-YESIEUNG",
    "D7DC": "HANGUL JONGSEONG RIEUL-YEORINHIEUH-HIEUH",
    "D7DD": "HANGUL JONGSEONG KAPYEOUNRIEUL",
    "D7DE": "HANGUL JONGSEONG MIEUM-NIEUN",
    "D7DF": "HANGUL JONGSEONG MIEUM-SSANGNIEUN",
    "D7E0": "HANGUL JONGSEONG SSANGMIEUM",
    "D7E1": "HANGUL JONGSEONG MIEUM-PIEUP-SIOS",
    "D7E2": "HANGUL JONGSEONG MIEUM-CIEUC",
    "D7E3": "HANGUL JONGSEONG PIEUP-TIKEUT",
    "D7E4": "HANGUL JONGSEONG PIEUP-RIEUL-PHIEUPH",
    "D7E5": "HANGUL JONGSEONG PIEUP-MIEUM",
    "D7E6": "HANGUL JONGSEONG SSANGPIEUP",
    "D7E7": "HANGUL JONGSEONG PIEUP-SIOS-TIKEUT",
    "D7E8": "HANGUL JONGSEONG PIEUP-CIEUC",
    "D7E9": "HANGUL JONGSEONG PIEUP-CHIEUCH",
    "D7EA": "HANGUL JONGSEONG SIOS-MIEUM",
    "D7EB": "HANGUL JONGSEONG SIOS-KAPYEOUNPIEUP",
    "D7EC": "HANGUL JONGSEONG SSANGSIOS-KIYEOK",
    "D7ED": "HANGUL JONGSEONG SSANGSIOS-TIKEUT",
    "D7EE": "HANGUL JONGSEONG SIOS-PANSIOS",
    "D7EF": "HANGUL JONGSEONG SIOS-CIEUC",
    "D7F0": "HANGUL JONGSEONG SIOS-CHIEUCH",
    "D7F1": "HANGUL JONGSEONG SIOS-THIEUTH",
    "D7F2": "HANGUL JONGSEONG SIOS-HIEUH",
    "D7F3": "HANGUL JONGSEONG PANSIOS-PIEUP",
    "D7F4": "HANGUL JONGSEONG PANSIOS-KAPYEOUNPIEUP",
    "D7F5": "HANGUL JONGSEONG YESIEUNG-MIEUM",
    "D7F6": "HANGUL JONGSEONG YESIEUNG-HIEUH",
    "D7F7": "HANGUL JONGSEONG CIEUC-PIEUP",
    "D7F8": "HANGUL JONGSEONG CIEUC-SSANGPIEUP",
    "D7F9": "HANGUL JONGSEONG SSANGCIEUC",
    "D7FA": "HANGUL JONGSEONG PHIEUPH-SIOS",
    "D7FB": "HANGUL JONGSEONG PHIEUPH-THIEUTH",
    # "D800":  "<Non Private Use High Surrogate, First>", */
    # "DB7F":  "<Non Private Use High Surrogate, Last>", */
    # "DB80":  "<Private Use High Surrogate, First>", */
    # "DBFF":  "<Private Use High Surrogate, Last>", */
    # "DC00":  "<Low Surrogate, First>", */
    # "DFFF":  "<Low Surrogate, Last>", */
    # "E000":  "<Private Use, First>", */
    # "F8FF":  "<Private Use, Last>", */
    "F900": "CJK COMPATIBILITY IDEOGRAPH-F900",
    "F901": "CJK COMPATIBILITY IDEOGRAPH-F901",
    "F902": "CJK COMPATIBILITY IDEOGRAPH-F902",
    "F903": "CJK COMPATIBILITY IDEOGRAPH-F903",
    "F904": "CJK COMPATIBILITY IDEOGRAPH-F904",
    "F905": "CJK COMPATIBILITY IDEOGRAPH-F905",
    "F906": "CJK COMPATIBILITY IDEOGRAPH-F906",
    "F907": "CJK COMPATIBILITY IDEOGRAPH-F907",
    "F908": "CJK COMPATIBILITY IDEOGRAPH-F908",
    "F909": "CJK COMPATIBILITY IDEOGRAPH-F909",
    "F90A": "CJK COMPATIBILITY IDEOGRAPH-F90A",
    "F90B": "CJK COMPATIBILITY IDEOGRAPH-F90B",
    "F90C": "CJK COMPATIBILITY IDEOGRAPH-F90C",
    "F90D": "CJK COMPATIBILITY IDEOGRAPH-F90D",
    "F90E": "CJK COMPATIBILITY IDEOGRAPH-F90E",
    "F90F": "CJK COMPATIBILITY IDEOGRAPH-F90F",
    "F910": "CJK COMPATIBILITY IDEOGRAPH-F910",
    "F911": "CJK COMPATIBILITY IDEOGRAPH-F911",
    "F912": "CJK COMPATIBILITY IDEOGRAPH-F912",
    "F913": "CJK COMPATIBILITY IDEOGRAPH-F913",
    "F914": "CJK COMPATIBILITY IDEOGRAPH-F914",
    "F915": "CJK COMPATIBILITY IDEOGRAPH-F915",
    "F916": "CJK COMPATIBILITY IDEOGRAPH-F916",
    "F917": "CJK COMPATIBILITY IDEOGRAPH-F917",
    "F918": "CJK COMPATIBILITY IDEOGRAPH-F918",
    "F919": "CJK COMPATIBILITY IDEOGRAPH-F919",
    "F91A": "CJK COMPATIBILITY IDEOGRAPH-F91A",
    "F91B": "CJK COMPATIBILITY IDEOGRAPH-F91B",
    "F91C": "CJK COMPATIBILITY IDEOGRAPH-F91C",
    "F91D": "CJK COMPATIBILITY IDEOGRAPH-F91D",
    "F91E": "CJK COMPATIBILITY IDEOGRAPH-F91E",
    "F91F": "CJK COMPATIBILITY IDEOGRAPH-F91F",
    "F920": "CJK COMPATIBILITY IDEOGRAPH-F920",
    "F921": "CJK COMPATIBILITY IDEOGRAPH-F921",
    "F922": "CJK COMPATIBILITY IDEOGRAPH-F922",
    "F923": "CJK COMPATIBILITY IDEOGRAPH-F923",
    "F924": "CJK COMPATIBILITY IDEOGRAPH-F924",
    "F925": "CJK COMPATIBILITY IDEOGRAPH-F925",
    "F926": "CJK COMPATIBILITY IDEOGRAPH-F926",
    "F927": "CJK COMPATIBILITY IDEOGRAPH-F927",
    "F928": "CJK COMPATIBILITY IDEOGRAPH-F928",
    "F929": "CJK COMPATIBILITY IDEOGRAPH-F929",
    "F92A": "CJK COMPATIBILITY IDEOGRAPH-F92A",
    "F92B": "CJK COMPATIBILITY IDEOGRAPH-F92B",
    "F92C": "CJK COMPATIBILITY IDEOGRAPH-F92C",
    "F92D": "CJK COMPATIBILITY IDEOGRAPH-F92D",
    "F92E": "CJK COMPATIBILITY IDEOGRAPH-F92E",
    "F92F": "CJK COMPATIBILITY IDEOGRAPH-F92F",
    "F930": "CJK COMPATIBILITY IDEOGRAPH-F930",
    "F931": "CJK COMPATIBILITY IDEOGRAPH-F931",
    "F932": "CJK COMPATIBILITY IDEOGRAPH-F932",
    "F933": "CJK COMPATIBILITY IDEOGRAPH-F933",
    "F934": "CJK COMPATIBILITY IDEOGRAPH-F934",
    "F935": "CJK COMPATIBILITY IDEOGRAPH-F935",
    "F936": "CJK COMPATIBILITY IDEOGRAPH-F936",
    "F937": "CJK COMPATIBILITY IDEOGRAPH-F937",
    "F938": "CJK COMPATIBILITY IDEOGRAPH-F938",
    "F939": "CJK COMPATIBILITY IDEOGRAPH-F939",
    "F93A": "CJK COMPATIBILITY IDEOGRAPH-F93A",
    "F93B": "CJK COMPATIBILITY IDEOGRAPH-F93B",
    "F93C": "CJK COMPATIBILITY IDEOGRAPH-F93C",
    "F93D": "CJK COMPATIBILITY IDEOGRAPH-F93D",
    "F93E": "CJK COMPATIBILITY IDEOGRAPH-F93E",
    "F93F": "CJK COMPATIBILITY IDEOGRAPH-F93F",
    "F940": "CJK COMPATIBILITY IDEOGRAPH-F940",
    "F941": "CJK COMPATIBILITY IDEOGRAPH-F941",
    "F942": "CJK COMPATIBILITY IDEOGRAPH-F942",
    "F943": "CJK COMPATIBILITY IDEOGRAPH-F943",
    "F944": "CJK COMPATIBILITY IDEOGRAPH-F944",
    "F945": "CJK COMPATIBILITY IDEOGRAPH-F945",
    "F946": "CJK COMPATIBILITY IDEOGRAPH-F946",
    "F947": "CJK COMPATIBILITY IDEOGRAPH-F947",
    "F948": "CJK COMPATIBILITY IDEOGRAPH-F948",
    "F949": "CJK COMPATIBILITY IDEOGRAPH-F949",
    "F94A": "CJK COMPATIBILITY IDEOGRAPH-F94A",
    "F94B": "CJK COMPATIBILITY IDEOGRAPH-F94B",
    "F94C": "CJK COMPATIBILITY IDEOGRAPH-F94C",
    "F94D": "CJK COMPATIBILITY IDEOGRAPH-F94D",
    "F94E": "CJK COMPATIBILITY IDEOGRAPH-F94E",
    "F94F": "CJK COMPATIBILITY IDEOGRAPH-F94F",
    "F950": "CJK COMPATIBILITY IDEOGRAPH-F950",
    "F951": "CJK COMPATIBILITY IDEOGRAPH-F951",
    "F952": "CJK COMPATIBILITY IDEOGRAPH-F952",
    "F953": "CJK COMPATIBILITY IDEOGRAPH-F953",
    "F954": "CJK COMPATIBILITY IDEOGRAPH-F954",
    "F955": "CJK COMPATIBILITY IDEOGRAPH-F955",
    "F956": "CJK COMPATIBILITY IDEOGRAPH-F956",
    "F957": "CJK COMPATIBILITY IDEOGRAPH-F957",
    "F958": "CJK COMPATIBILITY IDEOGRAPH-F958",
    "F959": "CJK COMPATIBILITY IDEOGRAPH-F959",
    "F95A": "CJK COMPATIBILITY IDEOGRAPH-F95A",
    "F95B": "CJK COMPATIBILITY IDEOGRAPH-F95B",
    "F95C": "CJK COMPATIBILITY IDEOGRAPH-F95C",
    "F95D": "CJK COMPATIBILITY IDEOGRAPH-F95D",
    "F95E": "CJK COMPATIBILITY IDEOGRAPH-F95E",
    "F95F": "CJK COMPATIBILITY IDEOGRAPH-F95F",
    "F960": "CJK COMPATIBILITY IDEOGRAPH-F960",
    "F961": "CJK COMPATIBILITY IDEOGRAPH-F961",
    "F962": "CJK COMPATIBILITY IDEOGRAPH-F962",
    "F963": "CJK COMPATIBILITY IDEOGRAPH-F963",
    "F964": "CJK COMPATIBILITY IDEOGRAPH-F964",
    "F965": "CJK COMPATIBILITY IDEOGRAPH-F965",
    "F966": "CJK COMPATIBILITY IDEOGRAPH-F966",
    "F967": "CJK COMPATIBILITY IDEOGRAPH-F967",
    "F968": "CJK COMPATIBILITY IDEOGRAPH-F968",
    "F969": "CJK COMPATIBILITY IDEOGRAPH-F969",
    "F96A": "CJK COMPATIBILITY IDEOGRAPH-F96A",
    "F96B": "CJK COMPATIBILITY IDEOGRAPH-F96B",
    "F96C": "CJK COMPATIBILITY IDEOGRAPH-F96C",
    "F96D": "CJK COMPATIBILITY IDEOGRAPH-F96D",
    "F96E": "CJK COMPATIBILITY IDEOGRAPH-F96E",
    "F96F": "CJK COMPATIBILITY IDEOGRAPH-F96F",
    "F970": "CJK COMPATIBILITY IDEOGRAPH-F970",
    "F971": "CJK COMPATIBILITY IDEOGRAPH-F971",
    "F972": "CJK COMPATIBILITY IDEOGRAPH-F972",
    "F973": "CJK COMPATIBILITY IDEOGRAPH-F973",
    "F974": "CJK COMPATIBILITY IDEOGRAPH-F974",
    "F975": "CJK COMPATIBILITY IDEOGRAPH-F975",
    "F976": "CJK COMPATIBILITY IDEOGRAPH-F976",
    "F977": "CJK COMPATIBILITY IDEOGRAPH-F977",
    "F978": "CJK COMPATIBILITY IDEOGRAPH-F978",
    "F979": "CJK COMPATIBILITY IDEOGRAPH-F979",
    "F97A": "CJK COMPATIBILITY IDEOGRAPH-F97A",
    "F97B": "CJK COMPATIBILITY IDEOGRAPH-F97B",
    "F97C": "CJK COMPATIBILITY IDEOGRAPH-F97C",
    "F97D": "CJK COMPATIBILITY IDEOGRAPH-F97D",
    "F97E": "CJK COMPATIBILITY IDEOGRAPH-F97E",
    "F97F": "CJK COMPATIBILITY IDEOGRAPH-F97F",
    "F980": "CJK COMPATIBILITY IDEOGRAPH-F980",
    "F981": "CJK COMPATIBILITY IDEOGRAPH-F981",
    "F982": "CJK COMPATIBILITY IDEOGRAPH-F982",
    "F983": "CJK COMPATIBILITY IDEOGRAPH-F983",
    "F984": "CJK COMPATIBILITY IDEOGRAPH-F984",
    "F985": "CJK COMPATIBILITY IDEOGRAPH-F985",
    "F986": "CJK COMPATIBILITY IDEOGRAPH-F986",
    "F987": "CJK COMPATIBILITY IDEOGRAPH-F987",
    "F988": "CJK COMPATIBILITY IDEOGRAPH-F988",
    "F989": "CJK COMPATIBILITY IDEOGRAPH-F989",
    "F98A": "CJK COMPATIBILITY IDEOGRAPH-F98A",
    "F98B": "CJK COMPATIBILITY IDEOGRAPH-F98B",
    "F98C": "CJK COMPATIBILITY IDEOGRAPH-F98C",
    "F98D": "CJK COMPATIBILITY IDEOGRAPH-F98D",
    "F98E": "CJK COMPATIBILITY IDEOGRAPH-F98E",
    "F98F": "CJK COMPATIBILITY IDEOGRAPH-F98F",
    "F990": "CJK COMPATIBILITY IDEOGRAPH-F990",
    "F991": "CJK COMPATIBILITY IDEOGRAPH-F991",
    "F992": "CJK COMPATIBILITY IDEOGRAPH-F992",
    "F993": "CJK COMPATIBILITY IDEOGRAPH-F993",
    "F994": "CJK COMPATIBILITY IDEOGRAPH-F994",
    "F995": "CJK COMPATIBILITY IDEOGRAPH-F995",
    "F996": "CJK COMPATIBILITY IDEOGRAPH-F996",
    "F997": "CJK COMPATIBILITY IDEOGRAPH-F997",
    "F998": "CJK COMPATIBILITY IDEOGRAPH-F998",
    "F999": "CJK COMPATIBILITY IDEOGRAPH-F999",
    "F99A": "CJK COMPATIBILITY IDEOGRAPH-F99A",
    "F99B": "CJK COMPATIBILITY IDEOGRAPH-F99B",
    "F99C": "CJK COMPATIBILITY IDEOGRAPH-F99C",
    "F99D": "CJK COMPATIBILITY IDEOGRAPH-F99D",
    "F99E": "CJK COMPATIBILITY IDEOGRAPH-F99E",
    "F99F": "CJK COMPATIBILITY IDEOGRAPH-F99F",
    "F9A0": "CJK COMPATIBILITY IDEOGRAPH-F9A0",
    "F9A1": "CJK COMPATIBILITY IDEOGRAPH-F9A1",
    "F9A2": "CJK COMPATIBILITY IDEOGRAPH-F9A2",
    "F9A3": "CJK COMPATIBILITY IDEOGRAPH-F9A3",
    "F9A4": "CJK COMPATIBILITY IDEOGRAPH-F9A4",
    "F9A5": "CJK COMPATIBILITY IDEOGRAPH-F9A5",
    "F9A6": "CJK COMPATIBILITY IDEOGRAPH-F9A6",
    "F9A7": "CJK COMPATIBILITY IDEOGRAPH-F9A7",
    "F9A8": "CJK COMPATIBILITY IDEOGRAPH-F9A8",
    "F9A9": "CJK COMPATIBILITY IDEOGRAPH-F9A9",
    "F9AA": "CJK COMPATIBILITY IDEOGRAPH-F9AA",
    "F9AB": "CJK COMPATIBILITY IDEOGRAPH-F9AB",
    "F9AC": "CJK COMPATIBILITY IDEOGRAPH-F9AC",
    "F9AD": "CJK COMPATIBILITY IDEOGRAPH-F9AD",
    "F9AE": "CJK COMPATIBILITY IDEOGRAPH-F9AE",
    "F9AF": "CJK COMPATIBILITY IDEOGRAPH-F9AF",
    "F9B0": "CJK COMPATIBILITY IDEOGRAPH-F9B0",
    "F9B1": "CJK COMPATIBILITY IDEOGRAPH-F9B1",
    "F9B2": "CJK COMPATIBILITY IDEOGRAPH-F9B2",
    "F9B3": "CJK COMPATIBILITY IDEOGRAPH-F9B3",
    "F9B4": "CJK COMPATIBILITY IDEOGRAPH-F9B4",
    "F9B5": "CJK COMPATIBILITY IDEOGRAPH-F9B5",
    "F9B6": "CJK COMPATIBILITY IDEOGRAPH-F9B6",
    "F9B7": "CJK COMPATIBILITY IDEOGRAPH-F9B7",
    "F9B8": "CJK COMPATIBILITY IDEOGRAPH-F9B8",
    "F9B9": "CJK COMPATIBILITY IDEOGRAPH-F9B9",
    "F9BA": "CJK COMPATIBILITY IDEOGRAPH-F9BA",
    "F9BB": "CJK COMPATIBILITY IDEOGRAPH-F9BB",
    "F9BC": "CJK COMPATIBILITY IDEOGRAPH-F9BC",
    "F9BD": "CJK COMPATIBILITY IDEOGRAPH-F9BD",
    "F9BE": "CJK COMPATIBILITY IDEOGRAPH-F9BE",
    "F9BF": "CJK COMPATIBILITY IDEOGRAPH-F9BF",
    "F9C0": "CJK COMPATIBILITY IDEOGRAPH-F9C0",
    "F9C1": "CJK COMPATIBILITY IDEOGRAPH-F9C1",
    "F9C2": "CJK COMPATIBILITY IDEOGRAPH-F9C2",
    "F9C3": "CJK COMPATIBILITY IDEOGRAPH-F9C3",
    "F9C4": "CJK COMPATIBILITY IDEOGRAPH-F9C4",
    "F9C5": "CJK COMPATIBILITY IDEOGRAPH-F9C5",
    "F9C6": "CJK COMPATIBILITY IDEOGRAPH-F9C6",
    "F9C7": "CJK COMPATIBILITY IDEOGRAPH-F9C7",
    "F9C8": "CJK COMPATIBILITY IDEOGRAPH-F9C8",
    "F9C9": "CJK COMPATIBILITY IDEOGRAPH-F9C9",
    "F9CA": "CJK COMPATIBILITY IDEOGRAPH-F9CA",
    "F9CB": "CJK COMPATIBILITY IDEOGRAPH-F9CB",
    "F9CC": "CJK COMPATIBILITY IDEOGRAPH-F9CC",
    "F9CD": "CJK COMPATIBILITY IDEOGRAPH-F9CD",
    "F9CE": "CJK COMPATIBILITY IDEOGRAPH-F9CE",
    "F9CF": "CJK COMPATIBILITY IDEOGRAPH-F9CF",
    "F9D0": "CJK COMPATIBILITY IDEOGRAPH-F9D0",
    "F9D1": "CJK COMPATIBILITY IDEOGRAPH-F9D1",
    "F9D2": "CJK COMPATIBILITY IDEOGRAPH-F9D2",
    "F9D3": "CJK COMPATIBILITY IDEOGRAPH-F9D3",
    "F9D4": "CJK COMPATIBILITY IDEOGRAPH-F9D4",
    "F9D5": "CJK COMPATIBILITY IDEOGRAPH-F9D5",
    "F9D6": "CJK COMPATIBILITY IDEOGRAPH-F9D6",
    "F9D7": "CJK COMPATIBILITY IDEOGRAPH-F9D7",
    "F9D8": "CJK COMPATIBILITY IDEOGRAPH-F9D8",
    "F9D9": "CJK COMPATIBILITY IDEOGRAPH-F9D9",
    "F9DA": "CJK COMPATIBILITY IDEOGRAPH-F9DA",
    "F9DB": "CJK COMPATIBILITY IDEOGRAPH-F9DB",
    "F9DC": "CJK COMPATIBILITY IDEOGRAPH-F9DC",
    "F9DD": "CJK COMPATIBILITY IDEOGRAPH-F9DD",
    "F9DE": "CJK COMPATIBILITY IDEOGRAPH-F9DE",
    "F9DF": "CJK COMPATIBILITY IDEOGRAPH-F9DF",
    "F9E0": "CJK COMPATIBILITY IDEOGRAPH-F9E0",
    "F9E1": "CJK COMPATIBILITY IDEOGRAPH-F9E1",
    "F9E2": "CJK COMPATIBILITY IDEOGRAPH-F9E2",
    "F9E3": "CJK COMPATIBILITY IDEOGRAPH-F9E3",
    "F9E4": "CJK COMPATIBILITY IDEOGRAPH-F9E4",
    "F9E5": "CJK COMPATIBILITY IDEOGRAPH-F9E5",
    "F9E6": "CJK COMPATIBILITY IDEOGRAPH-F9E6",
    "F9E7": "CJK COMPATIBILITY IDEOGRAPH-F9E7",
    "F9E8": "CJK COMPATIBILITY IDEOGRAPH-F9E8",
    "F9E9": "CJK COMPATIBILITY IDEOGRAPH-F9E9",
    "F9EA": "CJK COMPATIBILITY IDEOGRAPH-F9EA",
    "F9EB": "CJK COMPATIBILITY IDEOGRAPH-F9EB",
    "F9EC": "CJK COMPATIBILITY IDEOGRAPH-F9EC",
    "F9ED": "CJK COMPATIBILITY IDEOGRAPH-F9ED",
    "F9EE": "CJK COMPATIBILITY IDEOGRAPH-F9EE",
    "F9EF": "CJK COMPATIBILITY IDEOGRAPH-F9EF",
    "F9F0": "CJK COMPATIBILITY IDEOGRAPH-F9F0",
    "F9F1": "CJK COMPATIBILITY IDEOGRAPH-F9F1",
    "F9F2": "CJK COMPATIBILITY IDEOGRAPH-F9F2",
    "F9F3": "CJK COMPATIBILITY IDEOGRAPH-F9F3",
    "F9F4": "CJK COMPATIBILITY IDEOGRAPH-F9F4",
    "F9F5": "CJK COMPATIBILITY IDEOGRAPH-F9F5",
    "F9F6": "CJK COMPATIBILITY IDEOGRAPH-F9F6",
    "F9F7": "CJK COMPATIBILITY IDEOGRAPH-F9F7",
    "F9F8": "CJK COMPATIBILITY IDEOGRAPH-F9F8",
    "F9F9": "CJK COMPATIBILITY IDEOGRAPH-F9F9",
    "F9FA": "CJK COMPATIBILITY IDEOGRAPH-F9FA",
    "F9FB": "CJK COMPATIBILITY IDEOGRAPH-F9FB",
    "F9FC": "CJK COMPATIBILITY IDEOGRAPH-F9FC",
    "F9FD": "CJK COMPATIBILITY IDEOGRAPH-F9FD",
    "F9FE": "CJK COMPATIBILITY IDEOGRAPH-F9FE",
    "F9FF": "CJK COMPATIBILITY IDEOGRAPH-F9FF",
    "FA00": "CJK COMPATIBILITY IDEOGRAPH-FA00",
    "FA01": "CJK COMPATIBILITY IDEOGRAPH-FA01",
    "FA02": "CJK COMPATIBILITY IDEOGRAPH-FA02",
    "FA03": "CJK COMPATIBILITY IDEOGRAPH-FA03",
    "FA04": "CJK COMPATIBILITY IDEOGRAPH-FA04",
    "FA05": "CJK COMPATIBILITY IDEOGRAPH-FA05",
    "FA06": "CJK COMPATIBILITY IDEOGRAPH-FA06",
    "FA07": "CJK COMPATIBILITY IDEOGRAPH-FA07",
    "FA08": "CJK COMPATIBILITY IDEOGRAPH-FA08",
    "FA09": "CJK COMPATIBILITY IDEOGRAPH-FA09",
    "FA0A": "CJK COMPATIBILITY IDEOGRAPH-FA0A",
    "FA0B": "CJK COMPATIBILITY IDEOGRAPH-FA0B",
    "FA0C": "CJK COMPATIBILITY IDEOGRAPH-FA0C",
    "FA0D": "CJK COMPATIBILITY IDEOGRAPH-FA0D",
    "FA0E": "CJK COMPATIBILITY IDEOGRAPH-FA0E",
    "FA0F": "CJK COMPATIBILITY IDEOGRAPH-FA0F",
    "FA10": "CJK COMPATIBILITY IDEOGRAPH-FA10",
    "FA11": "CJK COMPATIBILITY IDEOGRAPH-FA11",
    "FA12": "CJK COMPATIBILITY IDEOGRAPH-FA12",
    "FA13": "CJK COMPATIBILITY IDEOGRAPH-FA13",
    "FA14": "CJK COMPATIBILITY IDEOGRAPH-FA14",
    "FA15": "CJK COMPATIBILITY IDEOGRAPH-FA15",
    "FA16": "CJK COMPATIBILITY IDEOGRAPH-FA16",
    "FA17": "CJK COMPATIBILITY IDEOGRAPH-FA17",
    "FA18": "CJK COMPATIBILITY IDEOGRAPH-FA18",
    "FA19": "CJK COMPATIBILITY IDEOGRAPH-FA19",
    "FA1A": "CJK COMPATIBILITY IDEOGRAPH-FA1A",
    "FA1B": "CJK COMPATIBILITY IDEOGRAPH-FA1B",
    "FA1C": "CJK COMPATIBILITY IDEOGRAPH-FA1C",
    "FA1D": "CJK COMPATIBILITY IDEOGRAPH-FA1D",
    "FA1E": "CJK COMPATIBILITY IDEOGRAPH-FA1E",
    "FA1F": "CJK COMPATIBILITY IDEOGRAPH-FA1F",
    "FA20": "CJK COMPATIBILITY IDEOGRAPH-FA20",
    "FA21": "CJK COMPATIBILITY IDEOGRAPH-FA21",
    "FA22": "CJK COMPATIBILITY IDEOGRAPH-FA22",
    "FA23": "CJK COMPATIBILITY IDEOGRAPH-FA23",
    "FA24": "CJK COMPATIBILITY IDEOGRAPH-FA24",
    "FA25": "CJK COMPATIBILITY IDEOGRAPH-FA25",
    "FA26": "CJK COMPATIBILITY IDEOGRAPH-FA26",
    "FA27": "CJK COMPATIBILITY IDEOGRAPH-FA27",
    "FA28": "CJK COMPATIBILITY IDEOGRAPH-FA28",
    "FA29": "CJK COMPATIBILITY IDEOGRAPH-FA29",
    "FA2A": "CJK COMPATIBILITY IDEOGRAPH-FA2A",
    "FA2B": "CJK COMPATIBILITY IDEOGRAPH-FA2B",
    "FA2C": "CJK COMPATIBILITY IDEOGRAPH-FA2C",
    "FA2D": "CJK COMPATIBILITY IDEOGRAPH-FA2D",
    "FA2E": "CJK COMPATIBILITY IDEOGRAPH-FA2E",
    "FA2F": "CJK COMPATIBILITY IDEOGRAPH-FA2F",
    "FA30": "CJK COMPATIBILITY IDEOGRAPH-FA30",
    "FA31": "CJK COMPATIBILITY IDEOGRAPH-FA31",
    "FA32": "CJK COMPATIBILITY IDEOGRAPH-FA32",
    "FA33": "CJK COMPATIBILITY IDEOGRAPH-FA33",
    "FA34": "CJK COMPATIBILITY IDEOGRAPH-FA34",
    "FA35": "CJK COMPATIBILITY IDEOGRAPH-FA35",
    "FA36": "CJK COMPATIBILITY IDEOGRAPH-FA36",
    "FA37": "CJK COMPATIBILITY IDEOGRAPH-FA37",
    "FA38": "CJK COMPATIBILITY IDEOGRAPH-FA38",
    "FA39": "CJK COMPATIBILITY IDEOGRAPH-FA39",
    "FA3A": "CJK COMPATIBILITY IDEOGRAPH-FA3A",
    "FA3B": "CJK COMPATIBILITY IDEOGRAPH-FA3B",
    "FA3C": "CJK COMPATIBILITY IDEOGRAPH-FA3C",
    "FA3D": "CJK COMPATIBILITY IDEOGRAPH-FA3D",
    "FA3E": "CJK COMPATIBILITY IDEOGRAPH-FA3E",
    "FA3F": "CJK COMPATIBILITY IDEOGRAPH-FA3F",
    "FA40": "CJK COMPATIBILITY IDEOGRAPH-FA40",
    "FA41": "CJK COMPATIBILITY IDEOGRAPH-FA41",
    "FA42": "CJK COMPATIBILITY IDEOGRAPH-FA42",
    "FA43": "CJK COMPATIBILITY IDEOGRAPH-FA43",
    "FA44": "CJK COMPATIBILITY IDEOGRAPH-FA44",
    "FA45": "CJK COMPATIBILITY IDEOGRAPH-FA45",
    "FA46": "CJK COMPATIBILITY IDEOGRAPH-FA46",
    "FA47": "CJK COMPATIBILITY IDEOGRAPH-FA47",
    "FA48": "CJK COMPATIBILITY IDEOGRAPH-FA48",
    "FA49": "CJK COMPATIBILITY IDEOGRAPH-FA49",
    "FA4A": "CJK COMPATIBILITY IDEOGRAPH-FA4A",
    "FA4B": "CJK COMPATIBILITY IDEOGRAPH-FA4B",
    "FA4C": "CJK COMPATIBILITY IDEOGRAPH-FA4C",
    "FA4D": "CJK COMPATIBILITY IDEOGRAPH-FA4D",
    "FA4E": "CJK COMPATIBILITY IDEOGRAPH-FA4E",
    "FA4F": "CJK COMPATIBILITY IDEOGRAPH-FA4F",
    "FA50": "CJK COMPATIBILITY IDEOGRAPH-FA50",
    "FA51": "CJK COMPATIBILITY IDEOGRAPH-FA51",
    "FA52": "CJK COMPATIBILITY IDEOGRAPH-FA52",
    "FA53": "CJK COMPATIBILITY IDEOGRAPH-FA53",
    "FA54": "CJK COMPATIBILITY IDEOGRAPH-FA54",
    "FA55": "CJK COMPATIBILITY IDEOGRAPH-FA55",
    "FA56": "CJK COMPATIBILITY IDEOGRAPH-FA56",
    "FA57": "CJK COMPATIBILITY IDEOGRAPH-FA57",
    "FA58": "CJK COMPATIBILITY IDEOGRAPH-FA58",
    "FA59": "CJK COMPATIBILITY IDEOGRAPH-FA59",
    "FA5A": "CJK COMPATIBILITY IDEOGRAPH-FA5A",
    "FA5B": "CJK COMPATIBILITY IDEOGRAPH-FA5B",
    "FA5C": "CJK COMPATIBILITY IDEOGRAPH-FA5C",
    "FA5D": "CJK COMPATIBILITY IDEOGRAPH-FA5D",
    "FA5E": "CJK COMPATIBILITY IDEOGRAPH-FA5E",
    "FA5F": "CJK COMPATIBILITY IDEOGRAPH-FA5F",
    "FA60": "CJK COMPATIBILITY IDEOGRAPH-FA60",
    "FA61": "CJK COMPATIBILITY IDEOGRAPH-FA61",
    "FA62": "CJK COMPATIBILITY IDEOGRAPH-FA62",
    "FA63": "CJK COMPATIBILITY IDEOGRAPH-FA63",
    "FA64": "CJK COMPATIBILITY IDEOGRAPH-FA64",
    "FA65": "CJK COMPATIBILITY IDEOGRAPH-FA65",
    "FA66": "CJK COMPATIBILITY IDEOGRAPH-FA66",
    "FA67": "CJK COMPATIBILITY IDEOGRAPH-FA67",
    "FA68": "CJK COMPATIBILITY IDEOGRAPH-FA68",
    "FA69": "CJK COMPATIBILITY IDEOGRAPH-FA69",
    "FA6A": "CJK COMPATIBILITY IDEOGRAPH-FA6A",
    "FA6B": "CJK COMPATIBILITY IDEOGRAPH-FA6B",
    "FA6C": "CJK COMPATIBILITY IDEOGRAPH-FA6C",
    "FA6D": "CJK COMPATIBILITY IDEOGRAPH-FA6D",
    "FA70": "CJK COMPATIBILITY IDEOGRAPH-FA70",
    "FA71": "CJK COMPATIBILITY IDEOGRAPH-FA71",
    "FA72": "CJK COMPATIBILITY IDEOGRAPH-FA72",
    "FA73": "CJK COMPATIBILITY IDEOGRAPH-FA73",
    "FA74": "CJK COMPATIBILITY IDEOGRAPH-FA74",
    "FA75": "CJK COMPATIBILITY IDEOGRAPH-FA75",
    "FA76": "CJK COMPATIBILITY IDEOGRAPH-FA76",
    "FA77": "CJK COMPATIBILITY IDEOGRAPH-FA77",
    "FA78": "CJK COMPATIBILITY IDEOGRAPH-FA78",
    "FA79": "CJK COMPATIBILITY IDEOGRAPH-FA79",
    "FA7A": "CJK COMPATIBILITY IDEOGRAPH-FA7A",
    "FA7B": "CJK COMPATIBILITY IDEOGRAPH-FA7B",
    "FA7C": "CJK COMPATIBILITY IDEOGRAPH-FA7C",
    "FA7D": "CJK COMPATIBILITY IDEOGRAPH-FA7D",
    "FA7E": "CJK COMPATIBILITY IDEOGRAPH-FA7E",
    "FA7F": "CJK COMPATIBILITY IDEOGRAPH-FA7F",
    "FA80": "CJK COMPATIBILITY IDEOGRAPH-FA80",
    "FA81": "CJK COMPATIBILITY IDEOGRAPH-FA81",
    "FA82": "CJK COMPATIBILITY IDEOGRAPH-FA82",
    "FA83": "CJK COMPATIBILITY IDEOGRAPH-FA83",
    "FA84": "CJK COMPATIBILITY IDEOGRAPH-FA84",
    "FA85": "CJK COMPATIBILITY IDEOGRAPH-FA85",
    "FA86": "CJK COMPATIBILITY IDEOGRAPH-FA86",
    "FA87": "CJK COMPATIBILITY IDEOGRAPH-FA87",
    "FA88": "CJK COMPATIBILITY IDEOGRAPH-FA88",
    "FA89": "CJK COMPATIBILITY IDEOGRAPH-FA89",
    "FA8A": "CJK COMPATIBILITY IDEOGRAPH-FA8A",
    "FA8B": "CJK COMPATIBILITY IDEOGRAPH-FA8B",
    "FA8C": "CJK COMPATIBILITY IDEOGRAPH-FA8C",
    "FA8D": "CJK COMPATIBILITY IDEOGRAPH-FA8D",
    "FA8E": "CJK COMPATIBILITY IDEOGRAPH-FA8E",
    "FA8F": "CJK COMPATIBILITY IDEOGRAPH-FA8F",
    "FA90": "CJK COMPATIBILITY IDEOGRAPH-FA90",
    "FA91": "CJK COMPATIBILITY IDEOGRAPH-FA91",
    "FA92": "CJK COMPATIBILITY IDEOGRAPH-FA92",
    "FA93": "CJK COMPATIBILITY IDEOGRAPH-FA93",
    "FA94": "CJK COMPATIBILITY IDEOGRAPH-FA94",
    "FA95": "CJK COMPATIBILITY IDEOGRAPH-FA95",
    "FA96": "CJK COMPATIBILITY IDEOGRAPH-FA96",
    "FA97": "CJK COMPATIBILITY IDEOGRAPH-FA97",
    "FA98": "CJK COMPATIBILITY IDEOGRAPH-FA98",
    "FA99": "CJK COMPATIBILITY IDEOGRAPH-FA99",
    "FA9A": "CJK COMPATIBILITY IDEOGRAPH-FA9A",
    "FA9B": "CJK COMPATIBILITY IDEOGRAPH-FA9B",
    "FA9C": "CJK COMPATIBILITY IDEOGRAPH-FA9C",
    "FA9D": "CJK COMPATIBILITY IDEOGRAPH-FA9D",
    "FA9E": "CJK COMPATIBILITY IDEOGRAPH-FA9E",
    "FA9F": "CJK COMPATIBILITY IDEOGRAPH-FA9F",
    "FAA0": "CJK COMPATIBILITY IDEOGRAPH-FAA0",
    "FAA1": "CJK COMPATIBILITY IDEOGRAPH-FAA1",
    "FAA2": "CJK COMPATIBILITY IDEOGRAPH-FAA2",
    "FAA3": "CJK COMPATIBILITY IDEOGRAPH-FAA3",
    "FAA4": "CJK COMPATIBILITY IDEOGRAPH-FAA4",
    "FAA5": "CJK COMPATIBILITY IDEOGRAPH-FAA5",
    "FAA6": "CJK COMPATIBILITY IDEOGRAPH-FAA6",
    "FAA7": "CJK COMPATIBILITY IDEOGRAPH-FAA7",
    "FAA8": "CJK COMPATIBILITY IDEOGRAPH-FAA8",
    "FAA9": "CJK COMPATIBILITY IDEOGRAPH-FAA9",
    "FAAA": "CJK COMPATIBILITY IDEOGRAPH-FAAA",
    "FAAB": "CJK COMPATIBILITY IDEOGRAPH-FAAB",
    "FAAC": "CJK COMPATIBILITY IDEOGRAPH-FAAC",
    "FAAD": "CJK COMPATIBILITY IDEOGRAPH-FAAD",
    "FAAE": "CJK COMPATIBILITY IDEOGRAPH-FAAE",
    "FAAF": "CJK COMPATIBILITY IDEOGRAPH-FAAF",
    "FAB0": "CJK COMPATIBILITY IDEOGRAPH-FAB0",
    "FAB1": "CJK COMPATIBILITY IDEOGRAPH-FAB1",
    "FAB2": "CJK COMPATIBILITY IDEOGRAPH-FAB2",
    "FAB3": "CJK COMPATIBILITY IDEOGRAPH-FAB3",
    "FAB4": "CJK COMPATIBILITY IDEOGRAPH-FAB4",
    "FAB5": "CJK COMPATIBILITY IDEOGRAPH-FAB5",
    "FAB6": "CJK COMPATIBILITY IDEOGRAPH-FAB6",
    "FAB7": "CJK COMPATIBILITY IDEOGRAPH-FAB7",
    "FAB8": "CJK COMPATIBILITY IDEOGRAPH-FAB8",
    "FAB9": "CJK COMPATIBILITY IDEOGRAPH-FAB9",
    "FABA": "CJK COMPATIBILITY IDEOGRAPH-FABA",
    "FABB": "CJK COMPATIBILITY IDEOGRAPH-FABB",
    "FABC": "CJK COMPATIBILITY IDEOGRAPH-FABC",
    "FABD": "CJK COMPATIBILITY IDEOGRAPH-FABD",
    "FABE": "CJK COMPATIBILITY IDEOGRAPH-FABE",
    "FABF": "CJK COMPATIBILITY IDEOGRAPH-FABF",
    "FAC0": "CJK COMPATIBILITY IDEOGRAPH-FAC0",
    "FAC1": "CJK COMPATIBILITY IDEOGRAPH-FAC1",
    "FAC2": "CJK COMPATIBILITY IDEOGRAPH-FAC2",
    "FAC3": "CJK COMPATIBILITY IDEOGRAPH-FAC3",
    "FAC4": "CJK COMPATIBILITY IDEOGRAPH-FAC4",
    "FAC5": "CJK COMPATIBILITY IDEOGRAPH-FAC5",
    "FAC6": "CJK COMPATIBILITY IDEOGRAPH-FAC6",
    "FAC7": "CJK COMPATIBILITY IDEOGRAPH-FAC7",
    "FAC8": "CJK COMPATIBILITY IDEOGRAPH-FAC8",
    "FAC9": "CJK COMPATIBILITY IDEOGRAPH-FAC9",
    "FACA": "CJK COMPATIBILITY IDEOGRAPH-FACA",
    "FACB": "CJK COMPATIBILITY IDEOGRAPH-FACB",
    "FACC": "CJK COMPATIBILITY IDEOGRAPH-FACC",
    "FACD": "CJK COMPATIBILITY IDEOGRAPH-FACD",
    "FACE": "CJK COMPATIBILITY IDEOGRAPH-FACE",
    "FACF": "CJK COMPATIBILITY IDEOGRAPH-FACF",
    "FAD0": "CJK COMPATIBILITY IDEOGRAPH-FAD0",
    "FAD1": "CJK COMPATIBILITY IDEOGRAPH-FAD1",
    "FAD2": "CJK COMPATIBILITY IDEOGRAPH-FAD2",
    "FAD3": "CJK COMPATIBILITY IDEOGRAPH-FAD3",
    "FAD4": "CJK COMPATIBILITY IDEOGRAPH-FAD4",
    "FAD5": "CJK COMPATIBILITY IDEOGRAPH-FAD5",
    "FAD6": "CJK COMPATIBILITY IDEOGRAPH-FAD6",
    "FAD7": "CJK COMPATIBILITY IDEOGRAPH-FAD7",
    "FAD8": "CJK COMPATIBILITY IDEOGRAPH-FAD8",
    "FAD9": "CJK COMPATIBILITY IDEOGRAPH-FAD9",
    "FB00": "LATIN SMALL LIGATURE FF",
    "FB01": "LATIN SMALL LIGATURE FI",
    "FB02": "LATIN SMALL LIGATURE FL",
    "FB03": "LATIN SMALL LIGATURE FFI",
    "FB04": "LATIN SMALL LIGATURE FFL",
    "FB05": "LATIN SMALL LIGATURE LONG S T",
    "FB06": "LATIN SMALL LIGATURE ST",
    "FB13": "ARMENIAN SMALL LIGATURE MEN NOW",
    "FB14": "ARMENIAN SMALL LIGATURE MEN ECH",
    "FB15": "ARMENIAN SMALL LIGATURE MEN INI",
    "FB16": "ARMENIAN SMALL LIGATURE VEW NOW",
    "FB17": "ARMENIAN SMALL LIGATURE MEN XEH",
    "FB1D": "HEBREW LETTER YOD WITH HIRIQ",
    "FB1E": "HEBREW POINT JUDEO-SPANISH VARIKA",
    "FB1F": "HEBREW LIGATURE YIDDISH YOD YOD PATAH",
    "FB20": "HEBREW LETTER ALTERNATIVE AYIN",
    "FB21": "HEBREW LETTER WIDE ALEF",
    "FB22": "HEBREW LETTER WIDE DALET",
    "FB23": "HEBREW LETTER WIDE HE",
    "FB24": "HEBREW LETTER WIDE KAF",
    "FB25": "HEBREW LETTER WIDE LAMED",
    "FB26": "HEBREW LETTER WIDE FINAL MEM",
    "FB27": "HEBREW LETTER WIDE RESH",
    "FB28": "HEBREW LETTER WIDE TAV",
    "FB29": "HEBREW LETTER ALTERNATIVE PLUS SIGN",
    "FB2A": "HEBREW LETTER SHIN WITH SHIN DOT",
    "FB2B": "HEBREW LETTER SHIN WITH SIN DOT",
    "FB2C": "HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT",
    "FB2D": "HEBREW LETTER SHIN WITH DAGESH AND SIN DOT",
    "FB2E": "HEBREW LETTER ALEF WITH PATAH",
    "FB2F": "HEBREW LETTER ALEF WITH QAMATS",
    "FB30": "HEBREW LETTER ALEF WITH MAPIQ",
    "FB31": "HEBREW LETTER BET WITH DAGESH",
    "FB32": "HEBREW LETTER GIMEL WITH DAGESH",
    "FB33": "HEBREW LETTER DALET WITH DAGESH",
    "FB34": "HEBREW LETTER HE WITH MAPIQ",
    "FB35": "HEBREW LETTER VAV WITH DAGESH",
    "FB36": "HEBREW LETTER ZAYIN WITH DAGESH",
    "FB38": "HEBREW LETTER TET WITH DAGESH",
    "FB39": "HEBREW LETTER YOD WITH DAGESH",
    "FB3A": "HEBREW LETTER FINAL KAF WITH DAGESH",
    "FB3B": "HEBREW LETTER KAF WITH DAGESH",
    "FB3C": "HEBREW LETTER LAMED WITH DAGESH",
    "FB3E": "HEBREW LETTER MEM WITH DAGESH",
    "FB40": "HEBREW LETTER NUN WITH DAGESH",
    "FB41": "HEBREW LETTER SAMEKH WITH DAGESH",
    "FB43": "HEBREW LETTER FINAL PE WITH DAGESH",
    "FB44": "HEBREW LETTER PE WITH DAGESH",
    "FB46": "HEBREW LETTER TSADI WITH DAGESH",
    "FB47": "HEBREW LETTER QOF WITH DAGESH",
    "FB48": "HEBREW LETTER RESH WITH DAGESH",
    "FB49": "HEBREW LETTER SHIN WITH DAGESH",
    "FB4A": "HEBREW LETTER TAV WITH DAGESH",
    "FB4B": "HEBREW LETTER VAV WITH HOLAM",
    "FB4C": "HEBREW LETTER BET WITH RAFE",
    "FB4D": "HEBREW LETTER KAF WITH RAFE",
    "FB4E": "HEBREW LETTER PE WITH RAFE",
    "FB4F": "HEBREW LIGATURE ALEF LAMED",
    "FB50": "ARABIC LETTER ALEF WASLA ISOLATED FORM",
    "FB51": "ARABIC LETTER ALEF WASLA FINAL FORM",
    "FB52": "ARABIC LETTER BEEH ISOLATED FORM",
    "FB53": "ARABIC LETTER BEEH FINAL FORM",
    "FB54": "ARABIC LETTER BEEH INITIAL FORM",
    "FB55": "ARABIC LETTER BEEH MEDIAL FORM",
    "FB56": "ARABIC LETTER PEH ISOLATED FORM",
    "FB57": "ARABIC LETTER PEH FINAL FORM",
    "FB58": "ARABIC LETTER PEH INITIAL FORM",
    "FB59": "ARABIC LETTER PEH MEDIAL FORM",
    "FB5A": "ARABIC LETTER BEHEH ISOLATED FORM",
    "FB5B": "ARABIC LETTER BEHEH FINAL FORM",
    "FB5C": "ARABIC LETTER BEHEH INITIAL FORM",
    "FB5D": "ARABIC LETTER BEHEH MEDIAL FORM",
    "FB5E": "ARABIC LETTER TTEHEH ISOLATED FORM",
    "FB5F": "ARABIC LETTER TTEHEH FINAL FORM",
    "FB60": "ARABIC LETTER TTEHEH INITIAL FORM",
    "FB61": "ARABIC LETTER TTEHEH MEDIAL FORM",
    "FB62": "ARABIC LETTER TEHEH ISOLATED FORM",
    "FB63": "ARABIC LETTER TEHEH FINAL FORM",
    "FB64": "ARABIC LETTER TEHEH INITIAL FORM",
    "FB65": "ARABIC LETTER TEHEH MEDIAL FORM",
    "FB66": "ARABIC LETTER TTEH ISOLATED FORM",
    "FB67": "ARABIC LETTER TTEH FINAL FORM",
    "FB68": "ARABIC LETTER TTEH INITIAL FORM",
    "FB69": "ARABIC LETTER TTEH MEDIAL FORM",
    "FB6A": "ARABIC LETTER VEH ISOLATED FORM",
    "FB6B": "ARABIC LETTER VEH FINAL FORM",
    "FB6C": "ARABIC LETTER VEH INITIAL FORM",
    "FB6D": "ARABIC LETTER VEH MEDIAL FORM",
    "FB6E": "ARABIC LETTER PEHEH ISOLATED FORM",
    "FB6F": "ARABIC LETTER PEHEH FINAL FORM",
    "FB70": "ARABIC LETTER PEHEH INITIAL FORM",
    "FB71": "ARABIC LETTER PEHEH MEDIAL FORM",
    "FB72": "ARABIC LETTER DYEH ISOLATED FORM",
    "FB73": "ARABIC LETTER DYEH FINAL FORM",
    "FB74": "ARABIC LETTER DYEH INITIAL FORM",
    "FB75": "ARABIC LETTER DYEH MEDIAL FORM",
    "FB76": "ARABIC LETTER NYEH ISOLATED FORM",
    "FB77": "ARABIC LETTER NYEH FINAL FORM",
    "FB78": "ARABIC LETTER NYEH INITIAL FORM",
    "FB79": "ARABIC LETTER NYEH MEDIAL FORM",
    "FB7A": "ARABIC LETTER TCHEH ISOLATED FORM",
    "FB7B": "ARABIC LETTER TCHEH FINAL FORM",
    "FB7C": "ARABIC LETTER TCHEH INITIAL FORM",
    "FB7D": "ARABIC LETTER TCHEH MEDIAL FORM",
    "FB7E": "ARABIC LETTER TCHEHEH ISOLATED FORM",
    "FB7F": "ARABIC LETTER TCHEHEH FINAL FORM",
    "FB80": "ARABIC LETTER TCHEHEH INITIAL FORM",
    "FB81": "ARABIC LETTER TCHEHEH MEDIAL FORM",
    "FB82": "ARABIC LETTER DDAHAL ISOLATED FORM",
    "FB83": "ARABIC LETTER DDAHAL FINAL FORM",
    "FB84": "ARABIC LETTER DAHAL ISOLATED FORM",
    "FB85": "ARABIC LETTER DAHAL FINAL FORM",
    "FB86": "ARABIC LETTER DUL ISOLATED FORM",
    "FB87": "ARABIC LETTER DUL FINAL FORM",
    "FB88": "ARABIC LETTER DDAL ISOLATED FORM",
    "FB89": "ARABIC LETTER DDAL FINAL FORM",
    "FB8A": "ARABIC LETTER JEH ISOLATED FORM",
    "FB8B": "ARABIC LETTER JEH FINAL FORM",
    "FB8C": "ARABIC LETTER RREH ISOLATED FORM",
    "FB8D": "ARABIC LETTER RREH FINAL FORM",
    "FB8E": "ARABIC LETTER KEHEH ISOLATED FORM",
    "FB8F": "ARABIC LETTER KEHEH FINAL FORM",
    "FB90": "ARABIC LETTER KEHEH INITIAL FORM",
    "FB91": "ARABIC LETTER KEHEH MEDIAL FORM",
    "FB92": "ARABIC LETTER GAF ISOLATED FORM",
    "FB93": "ARABIC LETTER GAF FINAL FORM",
    "FB94": "ARABIC LETTER GAF INITIAL FORM",
    "FB95": "ARABIC LETTER GAF MEDIAL FORM",
    "FB96": "ARABIC LETTER GUEH ISOLATED FORM",
    "FB97": "ARABIC LETTER GUEH FINAL FORM",
    "FB98": "ARABIC LETTER GUEH INITIAL FORM",
    "FB99": "ARABIC LETTER GUEH MEDIAL FORM",
    "FB9A": "ARABIC LETTER NGOEH ISOLATED FORM",
    "FB9B": "ARABIC LETTER NGOEH FINAL FORM",
    "FB9C": "ARABIC LETTER NGOEH INITIAL FORM",
    "FB9D": "ARABIC LETTER NGOEH MEDIAL FORM",
    "FB9E": "ARABIC LETTER NOON GHUNNA ISOLATED FORM",
    "FB9F": "ARABIC LETTER NOON GHUNNA FINAL FORM",
    "FBA0": "ARABIC LETTER RNOON ISOLATED FORM",
    "FBA1": "ARABIC LETTER RNOON FINAL FORM",
    "FBA2": "ARABIC LETTER RNOON INITIAL FORM",
    "FBA3": "ARABIC LETTER RNOON MEDIAL FORM",
    "FBA4": "ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM",
    "FBA5": "ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM",
    "FBA6": "ARABIC LETTER HEH GOAL ISOLATED FORM",
    "FBA7": "ARABIC LETTER HEH GOAL FINAL FORM",
    "FBA8": "ARABIC LETTER HEH GOAL INITIAL FORM",
    "FBA9": "ARABIC LETTER HEH GOAL MEDIAL FORM",
    "FBAA": "ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM",
    "FBAB": "ARABIC LETTER HEH DOACHASHMEE FINAL FORM",
    "FBAC": "ARABIC LETTER HEH DOACHASHMEE INITIAL FORM",
    "FBAD": "ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM",
    "FBAE": "ARABIC LETTER YEH BARREE ISOLATED FORM",
    "FBAF": "ARABIC LETTER YEH BARREE FINAL FORM",
    "FBB0": "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM",
    "FBB1": "ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM",
    "FBB2": "ARABIC SYMBOL DOT ABOVE",
    "FBB3": "ARABIC SYMBOL DOT BELOW",
    "FBB4": "ARABIC SYMBOL TWO DOTS ABOVE",
    "FBB5": "ARABIC SYMBOL TWO DOTS BELOW",
    "FBB6": "ARABIC SYMBOL THREE DOTS ABOVE",
    "FBB7": "ARABIC SYMBOL THREE DOTS BELOW",
    "FBB8": "ARABIC SYMBOL THREE DOTS POINTING DOWNWARDS ABOVE",
    "FBB9": "ARABIC SYMBOL THREE DOTS POINTING DOWNWARDS BELOW",
    "FBBA": "ARABIC SYMBOL FOUR DOTS ABOVE",
    "FBBB": "ARABIC SYMBOL FOUR DOTS BELOW",
    "FBBC": "ARABIC SYMBOL DOUBLE VERTICAL BAR BELOW",
    "FBBD": "ARABIC SYMBOL TWO DOTS VERTICALLY ABOVE",
    "FBBE": "ARABIC SYMBOL TWO DOTS VERTICALLY BELOW",
    "FBBF": "ARABIC SYMBOL RING",
    "FBC0": "ARABIC SYMBOL SMALL TAH ABOVE",
    "FBC1": "ARABIC SYMBOL SMALL TAH BELOW",
    "FBD3": "ARABIC LETTER NG ISOLATED FORM",
    "FBD4": "ARABIC LETTER NG FINAL FORM",
    "FBD5": "ARABIC LETTER NG INITIAL FORM",
    "FBD6": "ARABIC LETTER NG MEDIAL FORM",
    "FBD7": "ARABIC LETTER U ISOLATED FORM",
    "FBD8": "ARABIC LETTER U FINAL FORM",
    "FBD9": "ARABIC LETTER OE ISOLATED FORM",
    "FBDA": "ARABIC LETTER OE FINAL FORM",
    "FBDB": "ARABIC LETTER YU ISOLATED FORM",
    "FBDC": "ARABIC LETTER YU FINAL FORM",
    "FBDD": "ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM",
    "FBDE": "ARABIC LETTER VE ISOLATED FORM",
    "FBDF": "ARABIC LETTER VE FINAL FORM",
    "FBE0": "ARABIC LETTER KIRGHIZ OE ISOLATED FORM",
    "FBE1": "ARABIC LETTER KIRGHIZ OE FINAL FORM",
    "FBE2": "ARABIC LETTER KIRGHIZ YU ISOLATED FORM",
    "FBE3": "ARABIC LETTER KIRGHIZ YU FINAL FORM",
    "FBE4": "ARABIC LETTER E ISOLATED FORM",
    "FBE5": "ARABIC LETTER E FINAL FORM",
    "FBE6": "ARABIC LETTER E INITIAL FORM",
    "FBE7": "ARABIC LETTER E MEDIAL FORM",
    "FBE8": "ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM",
    "FBE9": "ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM",
    "FBEA": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM",
    "FBEB": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM",
    "FBEC": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM",
    "FBED": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM",
    "FBEE": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM",
    "FBEF": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM",
    "FBF0": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM",
    "FBF1": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM",
    "FBF2": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM",
    "FBF3": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM",
    "FBF4": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM",
    "FBF5": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM",
    "FBF6": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM",
    "FBF7": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM",
    "FBF8": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM",
    "FBF9": "ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM",
    "FBFA": "ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM",
    "FBFB": "ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM",
    "FBFC": "ARABIC LETTER FARSI YEH ISOLATED FORM",
    "FBFD": "ARABIC LETTER FARSI YEH FINAL FORM",
    "FBFE": "ARABIC LETTER FARSI YEH INITIAL FORM",
    "FBFF": "ARABIC LETTER FARSI YEH MEDIAL FORM",
    "FC00": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM",
    "FC01": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM",
    "FC02": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM",
    "FC03": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM",
    "FC04": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM",
    "FC05": "ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM",
    "FC06": "ARABIC LIGATURE BEH WITH HAH ISOLATED FORM",
    "FC07": "ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM",
    "FC08": "ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM",
    "FC09": "ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM",
    "FC0A": "ARABIC LIGATURE BEH WITH YEH ISOLATED FORM",
    "FC0B": "ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM",
    "FC0C": "ARABIC LIGATURE TEH WITH HAH ISOLATED FORM",
    "FC0D": "ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM",
    "FC0E": "ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM",
    "FC0F": "ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM",
    "FC10": "ARABIC LIGATURE TEH WITH YEH ISOLATED FORM",
    "FC11": "ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM",
    "FC12": "ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM",
    "FC13": "ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM",
    "FC14": "ARABIC LIGATURE THEH WITH YEH ISOLATED FORM",
    "FC15": "ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM",
    "FC16": "ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM",
    "FC17": "ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM",
    "FC18": "ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM",
    "FC19": "ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM",
    "FC1A": "ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM",
    "FC1B": "ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM",
    "FC1C": "ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM",
    "FC1D": "ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM",
    "FC1E": "ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM",
    "FC1F": "ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM",
    "FC20": "ARABIC LIGATURE SAD WITH HAH ISOLATED FORM",
    "FC21": "ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM",
    "FC22": "ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM",
    "FC23": "ARABIC LIGATURE DAD WITH HAH ISOLATED FORM",
    "FC24": "ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM",
    "FC25": "ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM",
    "FC26": "ARABIC LIGATURE TAH WITH HAH ISOLATED FORM",
    "FC27": "ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM",
    "FC28": "ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM",
    "FC29": "ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM",
    "FC2A": "ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM",
    "FC2B": "ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM",
    "FC2C": "ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM",
    "FC2D": "ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM",
    "FC2E": "ARABIC LIGATURE FEH WITH HAH ISOLATED FORM",
    "FC2F": "ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM",
    "FC30": "ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM",
    "FC31": "ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM",
    "FC32": "ARABIC LIGATURE FEH WITH YEH ISOLATED FORM",
    "FC33": "ARABIC LIGATURE QAF WITH HAH ISOLATED FORM",
    "FC34": "ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM",
    "FC35": "ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM",
    "FC36": "ARABIC LIGATURE QAF WITH YEH ISOLATED FORM",
    "FC37": "ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM",
    "FC38": "ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM",
    "FC39": "ARABIC LIGATURE KAF WITH HAH ISOLATED FORM",
    "FC3A": "ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM",
    "FC3B": "ARABIC LIGATURE KAF WITH LAM ISOLATED FORM",
    "FC3C": "ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM",
    "FC3D": "ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM",
    "FC3E": "ARABIC LIGATURE KAF WITH YEH ISOLATED FORM",
    "FC3F": "ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM",
    "FC40": "ARABIC LIGATURE LAM WITH HAH ISOLATED FORM",
    "FC41": "ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM",
    "FC42": "ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM",
    "FC43": "ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM",
    "FC44": "ARABIC LIGATURE LAM WITH YEH ISOLATED FORM",
    "FC45": "ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM",
    "FC46": "ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM",
    "FC47": "ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM",
    "FC48": "ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM",
    "FC49": "ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM",
    "FC4A": "ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM",
    "FC4B": "ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM",
    "FC4C": "ARABIC LIGATURE NOON WITH HAH ISOLATED FORM",
    "FC4D": "ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM",
    "FC4E": "ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM",
    "FC4F": "ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM",
    "FC50": "ARABIC LIGATURE NOON WITH YEH ISOLATED FORM",
    "FC51": "ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM",
    "FC52": "ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM",
    "FC53": "ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM",
    "FC54": "ARABIC LIGATURE HEH WITH YEH ISOLATED FORM",
    "FC55": "ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM",
    "FC56": "ARABIC LIGATURE YEH WITH HAH ISOLATED FORM",
    "FC57": "ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM",
    "FC58": "ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM",
    "FC59": "ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM",
    "FC5A": "ARABIC LIGATURE YEH WITH YEH ISOLATED FORM",
    "FC5B": "ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM",
    "FC5C": "ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM",
    "FC5D": "ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM",
    "FC5E": "ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM",
    "FC5F": "ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM",
    "FC60": "ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM",
    "FC61": "ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM",
    "FC62": "ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM",
    "FC63": "ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM",
    "FC64": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM",
    "FC65": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM",
    "FC66": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM",
    "FC67": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM",
    "FC68": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM",
    "FC69": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM",
    "FC6A": "ARABIC LIGATURE BEH WITH REH FINAL FORM",
    "FC6B": "ARABIC LIGATURE BEH WITH ZAIN FINAL FORM",
    "FC6C": "ARABIC LIGATURE BEH WITH MEEM FINAL FORM",
    "FC6D": "ARABIC LIGATURE BEH WITH NOON FINAL FORM",
    "FC6E": "ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM",
    "FC6F": "ARABIC LIGATURE BEH WITH YEH FINAL FORM",
    "FC70": "ARABIC LIGATURE TEH WITH REH FINAL FORM",
    "FC71": "ARABIC LIGATURE TEH WITH ZAIN FINAL FORM",
    "FC72": "ARABIC LIGATURE TEH WITH MEEM FINAL FORM",
    "FC73": "ARABIC LIGATURE TEH WITH NOON FINAL FORM",
    "FC74": "ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM",
    "FC75": "ARABIC LIGATURE TEH WITH YEH FINAL FORM",
    "FC76": "ARABIC LIGATURE THEH WITH REH FINAL FORM",
    "FC77": "ARABIC LIGATURE THEH WITH ZAIN FINAL FORM",
    "FC78": "ARABIC LIGATURE THEH WITH MEEM FINAL FORM",
    "FC79": "ARABIC LIGATURE THEH WITH NOON FINAL FORM",
    "FC7A": "ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM",
    "FC7B": "ARABIC LIGATURE THEH WITH YEH FINAL FORM",
    "FC7C": "ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM",
    "FC7D": "ARABIC LIGATURE FEH WITH YEH FINAL FORM",
    "FC7E": "ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM",
    "FC7F": "ARABIC LIGATURE QAF WITH YEH FINAL FORM",
    "FC80": "ARABIC LIGATURE KAF WITH ALEF FINAL FORM",
    "FC81": "ARABIC LIGATURE KAF WITH LAM FINAL FORM",
    "FC82": "ARABIC LIGATURE KAF WITH MEEM FINAL FORM",
    "FC83": "ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM",
    "FC84": "ARABIC LIGATURE KAF WITH YEH FINAL FORM",
    "FC85": "ARABIC LIGATURE LAM WITH MEEM FINAL FORM",
    "FC86": "ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM",
    "FC87": "ARABIC LIGATURE LAM WITH YEH FINAL FORM",
    "FC88": "ARABIC LIGATURE MEEM WITH ALEF FINAL FORM",
    "FC89": "ARABIC LIGATURE MEEM WITH MEEM FINAL FORM",
    "FC8A": "ARABIC LIGATURE NOON WITH REH FINAL FORM",
    "FC8B": "ARABIC LIGATURE NOON WITH ZAIN FINAL FORM",
    "FC8C": "ARABIC LIGATURE NOON WITH MEEM FINAL FORM",
    "FC8D": "ARABIC LIGATURE NOON WITH NOON FINAL FORM",
    "FC8E": "ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM",
    "FC8F": "ARABIC LIGATURE NOON WITH YEH FINAL FORM",
    "FC90": "ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM",
    "FC91": "ARABIC LIGATURE YEH WITH REH FINAL FORM",
    "FC92": "ARABIC LIGATURE YEH WITH ZAIN FINAL FORM",
    "FC93": "ARABIC LIGATURE YEH WITH MEEM FINAL FORM",
    "FC94": "ARABIC LIGATURE YEH WITH NOON FINAL FORM",
    "FC95": "ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM",
    "FC96": "ARABIC LIGATURE YEH WITH YEH FINAL FORM",
    "FC97": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM",
    "FC98": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM",
    "FC99": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM",
    "FC9A": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM",
    "FC9B": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM",
    "FC9C": "ARABIC LIGATURE BEH WITH JEEM INITIAL FORM",
    "FC9D": "ARABIC LIGATURE BEH WITH HAH INITIAL FORM",
    "FC9E": "ARABIC LIGATURE BEH WITH KHAH INITIAL FORM",
    "FC9F": "ARABIC LIGATURE BEH WITH MEEM INITIAL FORM",
    "FCA0": "ARABIC LIGATURE BEH WITH HEH INITIAL FORM",
    "FCA1": "ARABIC LIGATURE TEH WITH JEEM INITIAL FORM",
    "FCA2": "ARABIC LIGATURE TEH WITH HAH INITIAL FORM",
    "FCA3": "ARABIC LIGATURE TEH WITH KHAH INITIAL FORM",
    "FCA4": "ARABIC LIGATURE TEH WITH MEEM INITIAL FORM",
    "FCA5": "ARABIC LIGATURE TEH WITH HEH INITIAL FORM",
    "FCA6": "ARABIC LIGATURE THEH WITH MEEM INITIAL FORM",
    "FCA7": "ARABIC LIGATURE JEEM WITH HAH INITIAL FORM",
    "FCA8": "ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM",
    "FCA9": "ARABIC LIGATURE HAH WITH JEEM INITIAL FORM",
    "FCAA": "ARABIC LIGATURE HAH WITH MEEM INITIAL FORM",
    "FCAB": "ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM",
    "FCAC": "ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM",
    "FCAD": "ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM",
    "FCAE": "ARABIC LIGATURE SEEN WITH HAH INITIAL FORM",
    "FCAF": "ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM",
    "FCB0": "ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM",
    "FCB1": "ARABIC LIGATURE SAD WITH HAH INITIAL FORM",
    "FCB2": "ARABIC LIGATURE SAD WITH KHAH INITIAL FORM",
    "FCB3": "ARABIC LIGATURE SAD WITH MEEM INITIAL FORM",
    "FCB4": "ARABIC LIGATURE DAD WITH JEEM INITIAL FORM",
    "FCB5": "ARABIC LIGATURE DAD WITH HAH INITIAL FORM",
    "FCB6": "ARABIC LIGATURE DAD WITH KHAH INITIAL FORM",
    "FCB7": "ARABIC LIGATURE DAD WITH MEEM INITIAL FORM",
    "FCB8": "ARABIC LIGATURE TAH WITH HAH INITIAL FORM",
    "FCB9": "ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM",
    "FCBA": "ARABIC LIGATURE AIN WITH JEEM INITIAL FORM",
    "FCBB": "ARABIC LIGATURE AIN WITH MEEM INITIAL FORM",
    "FCBC": "ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM",
    "FCBD": "ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM",
    "FCBE": "ARABIC LIGATURE FEH WITH JEEM INITIAL FORM",
    "FCBF": "ARABIC LIGATURE FEH WITH HAH INITIAL FORM",
    "FCC0": "ARABIC LIGATURE FEH WITH KHAH INITIAL FORM",
    "FCC1": "ARABIC LIGATURE FEH WITH MEEM INITIAL FORM",
    "FCC2": "ARABIC LIGATURE QAF WITH HAH INITIAL FORM",
    "FCC3": "ARABIC LIGATURE QAF WITH MEEM INITIAL FORM",
    "FCC4": "ARABIC LIGATURE KAF WITH JEEM INITIAL FORM",
    "FCC5": "ARABIC LIGATURE KAF WITH HAH INITIAL FORM",
    "FCC6": "ARABIC LIGATURE KAF WITH KHAH INITIAL FORM",
    "FCC7": "ARABIC LIGATURE KAF WITH LAM INITIAL FORM",
    "FCC8": "ARABIC LIGATURE KAF WITH MEEM INITIAL FORM",
    "FCC9": "ARABIC LIGATURE LAM WITH JEEM INITIAL FORM",
    "FCCA": "ARABIC LIGATURE LAM WITH HAH INITIAL FORM",
    "FCCB": "ARABIC LIGATURE LAM WITH KHAH INITIAL FORM",
    "FCCC": "ARABIC LIGATURE LAM WITH MEEM INITIAL FORM",
    "FCCD": "ARABIC LIGATURE LAM WITH HEH INITIAL FORM",
    "FCCE": "ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM",
    "FCCF": "ARABIC LIGATURE MEEM WITH HAH INITIAL FORM",
    "FCD0": "ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM",
    "FCD1": "ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM",
    "FCD2": "ARABIC LIGATURE NOON WITH JEEM INITIAL FORM",
    "FCD3": "ARABIC LIGATURE NOON WITH HAH INITIAL FORM",
    "FCD4": "ARABIC LIGATURE NOON WITH KHAH INITIAL FORM",
    "FCD5": "ARABIC LIGATURE NOON WITH MEEM INITIAL FORM",
    "FCD6": "ARABIC LIGATURE NOON WITH HEH INITIAL FORM",
    "FCD7": "ARABIC LIGATURE HEH WITH JEEM INITIAL FORM",
    "FCD8": "ARABIC LIGATURE HEH WITH MEEM INITIAL FORM",
    "FCD9": "ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM",
    "FCDA": "ARABIC LIGATURE YEH WITH JEEM INITIAL FORM",
    "FCDB": "ARABIC LIGATURE YEH WITH HAH INITIAL FORM",
    "FCDC": "ARABIC LIGATURE YEH WITH KHAH INITIAL FORM",
    "FCDD": "ARABIC LIGATURE YEH WITH MEEM INITIAL FORM",
    "FCDE": "ARABIC LIGATURE YEH WITH HEH INITIAL FORM",
    "FCDF": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM",
    "FCE0": "ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM",
    "FCE1": "ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM",
    "FCE2": "ARABIC LIGATURE BEH WITH HEH MEDIAL FORM",
    "FCE3": "ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM",
    "FCE4": "ARABIC LIGATURE TEH WITH HEH MEDIAL FORM",
    "FCE5": "ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM",
    "FCE6": "ARABIC LIGATURE THEH WITH HEH MEDIAL FORM",
    "FCE7": "ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM",
    "FCE8": "ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM",
    "FCE9": "ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM",
    "FCEA": "ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM",
    "FCEB": "ARABIC LIGATURE KAF WITH LAM MEDIAL FORM",
    "FCEC": "ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM",
    "FCED": "ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM",
    "FCEE": "ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM",
    "FCEF": "ARABIC LIGATURE NOON WITH HEH MEDIAL FORM",
    "FCF0": "ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM",
    "FCF1": "ARABIC LIGATURE YEH WITH HEH MEDIAL FORM",
    "FCF2": "ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM",
    "FCF3": "ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM",
    "FCF4": "ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM",
    "FCF5": "ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM",
    "FCF6": "ARABIC LIGATURE TAH WITH YEH ISOLATED FORM",
    "FCF7": "ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM",
    "FCF8": "ARABIC LIGATURE AIN WITH YEH ISOLATED FORM",
    "FCF9": "ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM",
    "FCFA": "ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM",
    "FCFB": "ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM",
    "FCFC": "ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM",
    "FCFD": "ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM",
    "FCFE": "ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM",
    "FCFF": "ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM",
    "FD00": "ARABIC LIGATURE HAH WITH YEH ISOLATED FORM",
    "FD01": "ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM",
    "FD02": "ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM",
    "FD03": "ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM",
    "FD04": "ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM",
    "FD05": "ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM",
    "FD06": "ARABIC LIGATURE SAD WITH YEH ISOLATED FORM",
    "FD07": "ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM",
    "FD08": "ARABIC LIGATURE DAD WITH YEH ISOLATED FORM",
    "FD09": "ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM",
    "FD0A": "ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM",
    "FD0B": "ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM",
    "FD0C": "ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM",
    "FD0D": "ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM",
    "FD0E": "ARABIC LIGATURE SEEN WITH REH ISOLATED FORM",
    "FD0F": "ARABIC LIGATURE SAD WITH REH ISOLATED FORM",
    "FD10": "ARABIC LIGATURE DAD WITH REH ISOLATED FORM",
    "FD11": "ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM",
    "FD12": "ARABIC LIGATURE TAH WITH YEH FINAL FORM",
    "FD13": "ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM",
    "FD14": "ARABIC LIGATURE AIN WITH YEH FINAL FORM",
    "FD15": "ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM",
    "FD16": "ARABIC LIGATURE GHAIN WITH YEH FINAL FORM",
    "FD17": "ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM",
    "FD18": "ARABIC LIGATURE SEEN WITH YEH FINAL FORM",
    "FD19": "ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM",
    "FD1A": "ARABIC LIGATURE SHEEN WITH YEH FINAL FORM",
    "FD1B": "ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM",
    "FD1C": "ARABIC LIGATURE HAH WITH YEH FINAL FORM",
    "FD1D": "ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM",
    "FD1E": "ARABIC LIGATURE JEEM WITH YEH FINAL FORM",
    "FD1F": "ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM",
    "FD20": "ARABIC LIGATURE KHAH WITH YEH FINAL FORM",
    "FD21": "ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM",
    "FD22": "ARABIC LIGATURE SAD WITH YEH FINAL FORM",
    "FD23": "ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM",
    "FD24": "ARABIC LIGATURE DAD WITH YEH FINAL FORM",
    "FD25": "ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM",
    "FD26": "ARABIC LIGATURE SHEEN WITH HAH FINAL FORM",
    "FD27": "ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM",
    "FD28": "ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM",
    "FD29": "ARABIC LIGATURE SHEEN WITH REH FINAL FORM",
    "FD2A": "ARABIC LIGATURE SEEN WITH REH FINAL FORM",
    "FD2B": "ARABIC LIGATURE SAD WITH REH FINAL FORM",
    "FD2C": "ARABIC LIGATURE DAD WITH REH FINAL FORM",
    "FD2D": "ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM",
    "FD2E": "ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM",
    "FD2F": "ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM",
    "FD30": "ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM",
    "FD31": "ARABIC LIGATURE SEEN WITH HEH INITIAL FORM",
    "FD32": "ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM",
    "FD33": "ARABIC LIGATURE TAH WITH MEEM INITIAL FORM",
    "FD34": "ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM",
    "FD35": "ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM",
    "FD36": "ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM",
    "FD37": "ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM",
    "FD38": "ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM",
    "FD39": "ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM",
    "FD3A": "ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM",
    "FD3B": "ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM",
    "FD3C": "ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM",
    "FD3D": "ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM",
    "FD3E": "ORNATE LEFT PARENTHESIS",
    "FD3F": "ORNATE RIGHT PARENTHESIS",
    "FD50": "ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM",
    "FD51": "ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM",
    "FD52": "ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM",
    "FD53": "ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM",
    "FD54": "ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM",
    "FD55": "ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM",
    "FD56": "ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM",
    "FD57": "ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM",
    "FD58": "ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM",
    "FD59": "ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM",
    "FD5A": "ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM",
    "FD5B": "ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM",
    "FD5C": "ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM",
    "FD5D": "ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM",
    "FD5E": "ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM",
    "FD5F": "ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM",
    "FD60": "ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM",
    "FD61": "ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM",
    "FD62": "ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM",
    "FD63": "ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM",
    "FD64": "ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM",
    "FD65": "ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM",
    "FD66": "ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM",
    "FD67": "ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM",
    "FD68": "ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM",
    "FD69": "ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM",
    "FD6A": "ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM",
    "FD6B": "ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM",
    "FD6C": "ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM",
    "FD6D": "ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM",
    "FD6E": "ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM",
    "FD6F": "ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM",
    "FD70": "ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM",
    "FD71": "ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM",
    "FD72": "ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM",
    "FD73": "ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM",
    "FD74": "ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM",
    "FD75": "ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM",
    "FD76": "ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM",
    "FD77": "ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM",
    "FD78": "ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM",
    "FD79": "ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM",
    "FD7A": "ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM",
    "FD7B": "ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM",
    "FD7C": "ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM",
    "FD7D": "ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM",
    "FD7E": "ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM",
    "FD7F": "ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM",
    "FD80": "ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM",
    "FD81": "ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM",
    "FD82": "ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM",
    "FD83": "ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM",
    "FD84": "ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM",
    "FD85": "ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM",
    "FD86": "ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM",
    "FD87": "ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM",
    "FD88": "ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM",
    "FD89": "ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM",
    "FD8A": "ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM",
    "FD8B": "ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM",
    "FD8C": "ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM",
    "FD8D": "ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM",
    "FD8E": "ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM",
    "FD8F": "ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM",
    "FD92": "ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM",
    "FD93": "ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM",
    "FD94": "ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM",
    "FD95": "ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM",
    "FD96": "ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM",
    "FD97": "ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM",
    "FD98": "ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM",
    "FD99": "ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM",
    "FD9A": "ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM",
    "FD9B": "ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM",
    "FD9C": "ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM",
    "FD9D": "ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM",
    "FD9E": "ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM",
    "FD9F": "ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM",
    "FDA0": "ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM",
    "FDA1": "ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM",
    "FDA2": "ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM",
    "FDA3": "ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM",
    "FDA4": "ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM",
    "FDA5": "ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM",
    "FDA6": "ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM",
    "FDA7": "ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM",
    "FDA8": "ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM",
    "FDA9": "ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM",
    "FDAA": "ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM",
    "FDAB": "ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM",
    "FDAC": "ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM",
    "FDAD": "ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM",
    "FDAE": "ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM",
    "FDAF": "ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM",
    "FDB0": "ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM",
    "FDB1": "ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM",
    "FDB2": "ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM",
    "FDB3": "ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM",
    "FDB4": "ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM",
    "FDB5": "ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM",
    "FDB6": "ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM",
    "FDB7": "ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM",
    "FDB8": "ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM",
    "FDB9": "ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM",
    "FDBA": "ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM",
    "FDBB": "ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM",
    "FDBC": "ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM",
    "FDBD": "ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM",
    "FDBE": "ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM",
    "FDBF": "ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM",
    "FDC0": "ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM",
    "FDC1": "ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM",
    "FDC2": "ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM",
    "FDC3": "ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM",
    "FDC4": "ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM",
    "FDC5": "ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM",
    "FDC6": "ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM",
    "FDC7": "ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM",
    "FDF0": "ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM",
    "FDF1": "ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM",
    "FDF2": "ARABIC LIGATURE ALLAH ISOLATED FORM",
    "FDF3": "ARABIC LIGATURE AKBAR ISOLATED FORM",
    "FDF4": "ARABIC LIGATURE MOHAMMAD ISOLATED FORM",
    "FDF5": "ARABIC LIGATURE SALAM ISOLATED FORM",
    "FDF6": "ARABIC LIGATURE RASOUL ISOLATED FORM",
    "FDF7": "ARABIC LIGATURE ALAYHE ISOLATED FORM",
    "FDF8": "ARABIC LIGATURE WASALLAM ISOLATED FORM",
    "FDF9": "ARABIC LIGATURE SALLA ISOLATED FORM",
    "FDFA": "ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM",
    "FDFB": "ARABIC LIGATURE JALLAJALALOUHOU",
    "FDFC": "RIAL SIGN",
    "FDFD": "ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM",
    "FE00": "VARIATION SELECTOR-1",
    "FE01": "VARIATION SELECTOR-2",
    "FE02": "VARIATION SELECTOR-3",
    "FE03": "VARIATION SELECTOR-4",
    "FE04": "VARIATION SELECTOR-5",
    "FE05": "VARIATION SELECTOR-6",
    "FE06": "VARIATION SELECTOR-7",
    "FE07": "VARIATION SELECTOR-8",
    "FE08": "VARIATION SELECTOR-9",
    "FE09": "VARIATION SELECTOR-10",
    "FE0A": "VARIATION SELECTOR-11",
    "FE0B": "VARIATION SELECTOR-12",
    "FE0C": "VARIATION SELECTOR-13",
    "FE0D": "VARIATION SELECTOR-14",
    "FE0E": "VARIATION SELECTOR-15",
    "FE0F": "VARIATION SELECTOR-16",
    "FE10": "PRESENTATION FORM FOR VERTICAL COMMA",
    "FE11": "PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC COMMA",
    "FE12": "PRESENTATION FORM FOR VERTICAL IDEOGRAPHIC FULL STOP",
    "FE13": "PRESENTATION FORM FOR VERTICAL COLON",
    "FE14": "PRESENTATION FORM FOR VERTICAL SEMICOLON",
    "FE15": "PRESENTATION FORM FOR VERTICAL EXCLAMATION MARK",
    "FE16": "PRESENTATION FORM FOR VERTICAL QUESTION MARK",
    "FE17": "PRESENTATION FORM FOR VERTICAL LEFT WHITE LENTICULAR BRACKET",
    "FE18": "PRESENTATION FORM FOR VERTICAL RIGHT WHITE LENTICULAR BRAKCET",
    "FE19": "PRESENTATION FORM FOR VERTICAL HORIZONTAL ELLIPSIS",
    "FE20": "COMBINING LIGATURE LEFT HALF",
    "FE21": "COMBINING LIGATURE RIGHT HALF",
    "FE22": "COMBINING DOUBLE TILDE LEFT HALF",
    "FE23": "COMBINING DOUBLE TILDE RIGHT HALF",
    "FE24": "COMBINING MACRON LEFT HALF",
    "FE25": "COMBINING MACRON RIGHT HALF",
    "FE26": "COMBINING CONJOINING MACRON",
    "FE27": "COMBINING LIGATURE LEFT HALF BELOW",
    "FE28": "COMBINING LIGATURE RIGHT HALF BELOW",
    "FE29": "COMBINING TILDE LEFT HALF BELOW",
    "FE2A": "COMBINING TILDE RIGHT HALF BELOW",
    "FE2B": "COMBINING MACRON LEFT HALF BELOW",
    "FE2C": "COMBINING MACRON RIGHT HALF BELOW",
    "FE2D": "COMBINING CONJOINING MACRON BELOW",
    "FE2E": "COMBINING CYRILLIC TITLO LEFT HALF",
    "FE2F": "COMBINING CYRILLIC TITLO RIGHT HALF",
    "FE30": "PRESENTATION FORM FOR VERTICAL TWO DOT LEADER",
    "FE31": "PRESENTATION FORM FOR VERTICAL EM DASH",
    "FE32": "PRESENTATION FORM FOR VERTICAL EN DASH",
    "FE33": "PRESENTATION FORM FOR VERTICAL LOW LINE",
    "FE34": "PRESENTATION FORM FOR VERTICAL WAVY LOW LINE",
    "FE35": "PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS",
    "FE36": "PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS",
    "FE37": "PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET",
    "FE38": "PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET",
    "FE39": "PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET",
    "FE3A": "PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET",
    "FE3B": "PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET",
    "FE3C": "PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET",
    "FE3D": "PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET",
    "FE3E": "PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET",
    "FE3F": "PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET",
    "FE40": "PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET",
    "FE41": "PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET",
    "FE42": "PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET",
    "FE43": "PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET",
    "FE44": "PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET",
    "FE45": "SESAME DOT",
    "FE46": "WHITE SESAME DOT",
    "FE47": "PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET",
    "FE48": "PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET",
    "FE49": "DASHED OVERLINE",
    "FE4A": "CENTRELINE OVERLINE",
    "FE4B": "WAVY OVERLINE",
    "FE4C": "DOUBLE WAVY OVERLINE",
    "FE4D": "DASHED LOW LINE",
    "FE4E": "CENTRELINE LOW LINE",
    "FE4F": "WAVY LOW LINE",
    "FE50": "SMALL COMMA",
    "FE51": "SMALL IDEOGRAPHIC COMMA",
    "FE52": "SMALL FULL STOP",
    "FE54": "SMALL SEMICOLON",
    "FE55": "SMALL COLON",
    "FE56": "SMALL QUESTION MARK",
    "FE57": "SMALL EXCLAMATION MARK",
    "FE58": "SMALL EM DASH",
    "FE59": "SMALL LEFT PARENTHESIS",
    "FE5A": "SMALL RIGHT PARENTHESIS",
    "FE5B": "SMALL LEFT CURLY BRACKET",
    "FE5C": "SMALL RIGHT CURLY BRACKET",
    "FE5D": "SMALL LEFT TORTOISE SHELL BRACKET",
    "FE5E": "SMALL RIGHT TORTOISE SHELL BRACKET",
    "FE5F": "SMALL NUMBER SIGN",
    "FE60": "SMALL AMPERSAND",
    "FE61": "SMALL ASTERISK",
    "FE62": "SMALL PLUS SIGN",
    "FE63": "SMALL HYPHEN-MINUS",
    "FE64": "SMALL LESS-THAN SIGN",
    "FE65": "SMALL GREATER-THAN SIGN",
    "FE66": "SMALL EQUALS SIGN",
    "FE68": "SMALL REVERSE SOLIDUS",
    "FE69": "SMALL DOLLAR SIGN",
    "FE6A": "SMALL PERCENT SIGN",
    "FE6B": "SMALL COMMERCIAL AT",
    "FE70": "ARABIC FATHATAN ISOLATED FORM",
    "FE71": "ARABIC TATWEEL WITH FATHATAN ABOVE",
    "FE72": "ARABIC DAMMATAN ISOLATED FORM",
    "FE73": "ARABIC TAIL FRAGMENT",
    "FE74": "ARABIC KASRATAN ISOLATED FORM",
    "FE76": "ARABIC FATHA ISOLATED FORM",
    "FE77": "ARABIC FATHA MEDIAL FORM",
    "FE78": "ARABIC DAMMA ISOLATED FORM",
    "FE79": "ARABIC DAMMA MEDIAL FORM",
    "FE7A": "ARABIC KASRA ISOLATED FORM",
    "FE7B": "ARABIC KASRA MEDIAL FORM",
    "FE7C": "ARABIC SHADDA ISOLATED FORM",
    "FE7D": "ARABIC SHADDA MEDIAL FORM",
    "FE7E": "ARABIC SUKUN ISOLATED FORM",
    "FE7F": "ARABIC SUKUN MEDIAL FORM",
    "FE80": "ARABIC LETTER HAMZA ISOLATED FORM",
    "FE81": "ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM",
    "FE82": "ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM",
    "FE83": "ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM",
    "FE84": "ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM",
    "FE85": "ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM",
    "FE86": "ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM",
    "FE87": "ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM",
    "FE88": "ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM",
    "FE89": "ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM",
    "FE8A": "ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM",
    "FE8B": "ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM",
    "FE8C": "ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM",
    "FE8D": "ARABIC LETTER ALEF ISOLATED FORM",
    "FE8E": "ARABIC LETTER ALEF FINAL FORM",
    "FE8F": "ARABIC LETTER BEH ISOLATED FORM",
    "FE90": "ARABIC LETTER BEH FINAL FORM",
    "FE91": "ARABIC LETTER BEH INITIAL FORM",
    "FE92": "ARABIC LETTER BEH MEDIAL FORM",
    "FE93": "ARABIC LETTER TEH MARBUTA ISOLATED FORM",
    "FE94": "ARABIC LETTER TEH MARBUTA FINAL FORM",
    "FE95": "ARABIC LETTER TEH ISOLATED FORM",
    "FE96": "ARABIC LETTER TEH FINAL FORM",
    "FE97": "ARABIC LETTER TEH INITIAL FORM",
    "FE98": "ARABIC LETTER TEH MEDIAL FORM",
    "FE99": "ARABIC LETTER THEH ISOLATED FORM",
    "FE9A": "ARABIC LETTER THEH FINAL FORM",
    "FE9B": "ARABIC LETTER THEH INITIAL FORM",
    "FE9C": "ARABIC LETTER THEH MEDIAL FORM",
    "FE9D": "ARABIC LETTER JEEM ISOLATED FORM",
    "FE9E": "ARABIC LETTER JEEM FINAL FORM",
    "FE9F": "ARABIC LETTER JEEM INITIAL FORM",
    "FEA0": "ARABIC LETTER JEEM MEDIAL FORM",
    "FEA1": "ARABIC LETTER HAH ISOLATED FORM",
    "FEA2": "ARABIC LETTER HAH FINAL FORM",
    "FEA3": "ARABIC LETTER HAH INITIAL FORM",
    "FEA4": "ARABIC LETTER HAH MEDIAL FORM",
    "FEA5": "ARABIC LETTER KHAH ISOLATED FORM",
    "FEA6": "ARABIC LETTER KHAH FINAL FORM",
    "FEA7": "ARABIC LETTER KHAH INITIAL FORM",
    "FEA8": "ARABIC LETTER KHAH MEDIAL FORM",
    "FEA9": "ARABIC LETTER DAL ISOLATED FORM",
    "FEAA": "ARABIC LETTER DAL FINAL FORM",
    "FEAB": "ARABIC LETTER THAL ISOLATED FORM",
    "FEAC": "ARABIC LETTER THAL FINAL FORM",
    "FEAD": "ARABIC LETTER REH ISOLATED FORM",
    "FEAE": "ARABIC LETTER REH FINAL FORM",
    "FEAF": "ARABIC LETTER ZAIN ISOLATED FORM",
    "FEB0": "ARABIC LETTER ZAIN FINAL FORM",
    "FEB1": "ARABIC LETTER SEEN ISOLATED FORM",
    "FEB2": "ARABIC LETTER SEEN FINAL FORM",
    "FEB3": "ARABIC LETTER SEEN INITIAL FORM",
    "FEB4": "ARABIC LETTER SEEN MEDIAL FORM",
    "FEB5": "ARABIC LETTER SHEEN ISOLATED FORM",
    "FEB6": "ARABIC LETTER SHEEN FINAL FORM",
    "FEB7": "ARABIC LETTER SHEEN INITIAL FORM",
    "FEB8": "ARABIC LETTER SHEEN MEDIAL FORM",
    "FEB9": "ARABIC LETTER SAD ISOLATED FORM",
    "FEBA": "ARABIC LETTER SAD FINAL FORM",
    "FEBB": "ARABIC LETTER SAD INITIAL FORM",
    "FEBC": "ARABIC LETTER SAD MEDIAL FORM",
    "FEBD": "ARABIC LETTER DAD ISOLATED FORM",
    "FEBE": "ARABIC LETTER DAD FINAL FORM",
    "FEBF": "ARABIC LETTER DAD INITIAL FORM",
    "FEC0": "ARABIC LETTER DAD MEDIAL FORM",
    "FEC1": "ARABIC LETTER TAH ISOLATED FORM",
    "FEC2": "ARABIC LETTER TAH FINAL FORM",
    "FEC3": "ARABIC LETTER TAH INITIAL FORM",
    "FEC4": "ARABIC LETTER TAH MEDIAL FORM",
    "FEC5": "ARABIC LETTER ZAH ISOLATED FORM",
    "FEC6": "ARABIC LETTER ZAH FINAL FORM",
    "FEC7": "ARABIC LETTER ZAH INITIAL FORM",
    "FEC8": "ARABIC LETTER ZAH MEDIAL FORM",
    "FEC9": "ARABIC LETTER AIN ISOLATED FORM",
    "FECA": "ARABIC LETTER AIN FINAL FORM",
    "FECB": "ARABIC LETTER AIN INITIAL FORM",
    "FECC": "ARABIC LETTER AIN MEDIAL FORM",
    "FECD": "ARABIC LETTER GHAIN ISOLATED FORM",
    "FECE": "ARABIC LETTER GHAIN FINAL FORM",
    "FECF": "ARABIC LETTER GHAIN INITIAL FORM",
    "FED0": "ARABIC LETTER GHAIN MEDIAL FORM",
    "FED1": "ARABIC LETTER FEH ISOLATED FORM",
    "FED2": "ARABIC LETTER FEH FINAL FORM",
    "FED3": "ARABIC LETTER FEH INITIAL FORM",
    "FED4": "ARABIC LETTER FEH MEDIAL FORM",
    "FED5": "ARABIC LETTER QAF ISOLATED FORM",
    "FED6": "ARABIC LETTER QAF FINAL FORM",
    "FED7": "ARABIC LETTER QAF INITIAL FORM",
    "FED8": "ARABIC LETTER QAF MEDIAL FORM",
    "FED9": "ARABIC LETTER KAF ISOLATED FORM",
    "FEDA": "ARABIC LETTER KAF FINAL FORM",
    "FEDB": "ARABIC LETTER KAF INITIAL FORM",
    "FEDC": "ARABIC LETTER KAF MEDIAL FORM",
    "FEDD": "ARABIC LETTER LAM ISOLATED FORM",
    "FEDE": "ARABIC LETTER LAM FINAL FORM",
    "FEDF": "ARABIC LETTER LAM INITIAL FORM",
    "FEE0": "ARABIC LETTER LAM MEDIAL FORM",
    "FEE1": "ARABIC LETTER MEEM ISOLATED FORM",
    "FEE2": "ARABIC LETTER MEEM FINAL FORM",
    "FEE3": "ARABIC LETTER MEEM INITIAL FORM",
    "FEE4": "ARABIC LETTER MEEM MEDIAL FORM",
    "FEE5": "ARABIC LETTER NOON ISOLATED FORM",
    "FEE6": "ARABIC LETTER NOON FINAL FORM",
    "FEE7": "ARABIC LETTER NOON INITIAL FORM",
    "FEE8": "ARABIC LETTER NOON MEDIAL FORM",
    "FEE9": "ARABIC LETTER HEH ISOLATED FORM",
    "FEEA": "ARABIC LETTER HEH FINAL FORM",
    "FEEB": "ARABIC LETTER HEH INITIAL FORM",
    "FEEC": "ARABIC LETTER HEH MEDIAL FORM",
    "FEED": "ARABIC LETTER WAW ISOLATED FORM",
    "FEEE": "ARABIC LETTER WAW FINAL FORM",
    "FEEF": "ARABIC LETTER ALEF MAKSURA ISOLATED FORM",
    "FEF0": "ARABIC LETTER ALEF MAKSURA FINAL FORM",
    "FEF1": "ARABIC LETTER YEH ISOLATED FORM",
    "FEF2": "ARABIC LETTER YEH FINAL FORM",
    "FEF3": "ARABIC LETTER YEH INITIAL FORM",
    "FEF4": "ARABIC LETTER YEH MEDIAL FORM",
    "FEF5": "ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM",
    "FEF6": "ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM",
    "FEF7": "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM",
    "FEF8": "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM",
    "FEF9": "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM",
    "FEFA": "ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM",
    "FEFB": "ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM",
    "FEFC": "ARABIC LIGATURE LAM WITH ALEF FINAL FORM",
    "FEFF": "ZERO WIDTH NO-BREAK SPACE",
    "FF01": "FULLWIDTH EXCLAMATION MARK",
    "FF02": "FULLWIDTH QUOTATION MARK",
    "FF03": "FULLWIDTH NUMBER SIGN",
    "FF04": "FULLWIDTH DOLLAR SIGN",
    "FF05": "FULLWIDTH PERCENT SIGN",
    "FF06": "FULLWIDTH AMPERSAND",
    "FF07": "FULLWIDTH APOSTROPHE",
    "FF08": "FULLWIDTH LEFT PARENTHESIS",
    "FF09": "FULLWIDTH RIGHT PARENTHESIS",
    "FF0A": "FULLWIDTH ASTERISK",
    "FF0B": "FULLWIDTH PLUS SIGN",
    "FF0C": "FULLWIDTH COMMA",
    "FF0D": "FULLWIDTH HYPHEN-MINUS",
    "FF0E": "FULLWIDTH FULL STOP",
    "FF0F": "FULLWIDTH SOLIDUS",
    "FF10": "FULLWIDTH DIGIT ZERO",
    "FF11": "FULLWIDTH DIGIT ONE",
    "FF12": "FULLWIDTH DIGIT TWO",
    "FF13": "FULLWIDTH DIGIT THREE",
    "FF14": "FULLWIDTH DIGIT FOUR",
    "FF15": "FULLWIDTH DIGIT FIVE",
    "FF16": "FULLWIDTH DIGIT SIX",
    "FF17": "FULLWIDTH DIGIT SEVEN",
    "FF18": "FULLWIDTH DIGIT EIGHT",
    "FF19": "FULLWIDTH DIGIT NINE",
    "FF1A": "FULLWIDTH COLON",
    "FF1B": "FULLWIDTH SEMICOLON",
    "FF1C": "FULLWIDTH LESS-THAN SIGN",
    "FF1D": "FULLWIDTH EQUALS SIGN",
    "FF1E": "FULLWIDTH GREATER-THAN SIGN",
    "FF1F": "FULLWIDTH QUESTION MARK",
    "FF20": "FULLWIDTH COMMERCIAL AT",
    "FF21": "FULLWIDTH LATIN CAPITAL LETTER A",
    "FF22": "FULLWIDTH LATIN CAPITAL LETTER B",
    "FF23": "FULLWIDTH LATIN CAPITAL LETTER C",
    "FF24": "FULLWIDTH LATIN CAPITAL LETTER D",
    "FF25": "FULLWIDTH LATIN CAPITAL LETTER E",
    "FF26": "FULLWIDTH LATIN CAPITAL LETTER F",
    "FF27": "FULLWIDTH LATIN CAPITAL LETTER G",
    "FF28": "FULLWIDTH LATIN CAPITAL LETTER H",
    "FF29": "FULLWIDTH LATIN CAPITAL LETTER I",
    "FF2A": "FULLWIDTH LATIN CAPITAL LETTER J",
    "FF2B": "FULLWIDTH LATIN CAPITAL LETTER K",
    "FF2C": "FULLWIDTH LATIN CAPITAL LETTER L",
    "FF2D": "FULLWIDTH LATIN CAPITAL LETTER M",
    "FF2E": "FULLWIDTH LATIN CAPITAL LETTER N",
    "FF2F": "FULLWIDTH LATIN CAPITAL LETTER O",
    "FF30": "FULLWIDTH LATIN CAPITAL LETTER P",
    "FF31": "FULLWIDTH LATIN CAPITAL LETTER Q",
    "FF32": "FULLWIDTH LATIN CAPITAL LETTER R",
    "FF33": "FULLWIDTH LATIN CAPITAL LETTER S",
    "FF34": "FULLWIDTH LATIN CAPITAL LETTER T",
    "FF35": "FULLWIDTH LATIN CAPITAL LETTER U",
    "FF36": "FULLWIDTH LATIN CAPITAL LETTER V",
    "FF37": "FULLWIDTH LATIN CAPITAL LETTER W",
    "FF38": "FULLWIDTH LATIN CAPITAL LETTER X",
    "FF39": "FULLWIDTH LATIN CAPITAL LETTER Y",
    "FF3A": "FULLWIDTH LATIN CAPITAL LETTER Z",
    "FF3B": "FULLWIDTH LEFT SQUARE BRACKET",
    "FF3C": "FULLWIDTH REVERSE SOLIDUS",
    "FF3D": "FULLWIDTH RIGHT SQUARE BRACKET",
    "FF3E": "FULLWIDTH CIRCUMFLEX ACCENT",
    "FF3F": "FULLWIDTH LOW LINE",
    "FF40": "FULLWIDTH GRAVE ACCENT",
    "FF41": "FULLWIDTH LATIN SMALL LETTER A",
    "FF42": "FULLWIDTH LATIN SMALL LETTER B",
    "FF43": "FULLWIDTH LATIN SMALL LETTER C",
    "FF44": "FULLWIDTH LATIN SMALL LETTER D",
    "FF45": "FULLWIDTH LATIN SMALL LETTER E",
    "FF46": "FULLWIDTH LATIN SMALL LETTER F",
    "FF47": "FULLWIDTH LATIN SMALL LETTER G",
    "FF48": "FULLWIDTH LATIN SMALL LETTER H",
    "FF49": "FULLWIDTH LATIN SMALL LETTER I",
    "FF4A": "FULLWIDTH LATIN SMALL LETTER J",
    "FF4B": "FULLWIDTH LATIN SMALL LETTER K",
    "FF4C": "FULLWIDTH LATIN SMALL LETTER L",
    "FF4D": "FULLWIDTH LATIN SMALL LETTER M",
    "FF4E": "FULLWIDTH LATIN SMALL LETTER N",
    "FF4F": "FULLWIDTH LATIN SMALL LETTER O",
    "FF50": "FULLWIDTH LATIN SMALL LETTER P",
    "FF51": "FULLWIDTH LATIN SMALL LETTER Q",
    "FF52": "FULLWIDTH LATIN SMALL LETTER R",
    "FF53": "FULLWIDTH LATIN SMALL LETTER S",
    "FF54": "FULLWIDTH LATIN SMALL LETTER T",
    "FF55": "FULLWIDTH LATIN SMALL LETTER U",
    "FF56": "FULLWIDTH LATIN SMALL LETTER V",
    "FF57": "FULLWIDTH LATIN SMALL LETTER W",
    "FF58": "FULLWIDTH LATIN SMALL LETTER X",
    "FF59": "FULLWIDTH LATIN SMALL LETTER Y",
    "FF5A": "FULLWIDTH LATIN SMALL LETTER Z",
    "FF5B": "FULLWIDTH LEFT CURLY BRACKET",
    "FF5C": "FULLWIDTH VERTICAL LINE",
    "FF5D": "FULLWIDTH RIGHT CURLY BRACKET",
    "FF5E": "FULLWIDTH TILDE",
    "FF5F": "FULLWIDTH LEFT WHITE PARENTHESIS",
    "FF60": "FULLWIDTH RIGHT WHITE PARENTHESIS",
    "FF61": "HALFWIDTH IDEOGRAPHIC FULL STOP",
    "FF62": "HALFWIDTH LEFT CORNER BRACKET",
    "FF63": "HALFWIDTH RIGHT CORNER BRACKET",
    "FF64": "HALFWIDTH IDEOGRAPHIC COMMA",
    "FF65": "HALFWIDTH KATAKANA MIDDLE DOT",
    "FF66": "HALFWIDTH KATAKANA LETTER WO",
    "FF67": "HALFWIDTH KATAKANA LETTER SMALL A",
    "FF68": "HALFWIDTH KATAKANA LETTER SMALL I",
    "FF69": "HALFWIDTH KATAKANA LETTER SMALL U",
    "FF6A": "HALFWIDTH KATAKANA LETTER SMALL E",
    "FF6B": "HALFWIDTH KATAKANA LETTER SMALL O",
    "FF6C": "HALFWIDTH KATAKANA LETTER SMALL YA",
    "FF6D": "HALFWIDTH KATAKANA LETTER SMALL YU",
    "FF6E": "HALFWIDTH KATAKANA LETTER SMALL YO",
    "FF6F": "HALFWIDTH KATAKANA LETTER SMALL TU",
    "FF70": "HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK",
    "FF71": "HALFWIDTH KATAKANA LETTER A",
    "FF72": "HALFWIDTH KATAKANA LETTER I",
    "FF73": "HALFWIDTH KATAKANA LETTER U",
    "FF74": "HALFWIDTH KATAKANA LETTER E",
    "FF75": "HALFWIDTH KATAKANA LETTER O",
    "FF76": "HALFWIDTH KATAKANA LETTER KA",
    "FF77": "HALFWIDTH KATAKANA LETTER KI",
    "FF78": "HALFWIDTH KATAKANA LETTER KU",
    "FF79": "HALFWIDTH KATAKANA LETTER KE",
    "FF7A": "HALFWIDTH KATAKANA LETTER KO",
    "FF7B": "HALFWIDTH KATAKANA LETTER SA",
    "FF7C": "HALFWIDTH KATAKANA LETTER SI",
    "FF7D": "HALFWIDTH KATAKANA LETTER SU",
    "FF7E": "HALFWIDTH KATAKANA LETTER SE",
    "FF7F": "HALFWIDTH KATAKANA LETTER SO",
    "FF80": "HALFWIDTH KATAKANA LETTER TA",
    "FF81": "HALFWIDTH KATAKANA LETTER TI",
    "FF82": "HALFWIDTH KATAKANA LETTER TU",
    "FF83": "HALFWIDTH KATAKANA LETTER TE",
    "FF84": "HALFWIDTH KATAKANA LETTER TO",
    "FF85": "HALFWIDTH KATAKANA LETTER NA",
    "FF86": "HALFWIDTH KATAKANA LETTER NI",
    "FF87": "HALFWIDTH KATAKANA LETTER NU",
    "FF88": "HALFWIDTH KATAKANA LETTER NE",
    "FF89": "HALFWIDTH KATAKANA LETTER NO",
    "FF8A": "HALFWIDTH KATAKANA LETTER HA",
    "FF8B": "HALFWIDTH KATAKANA LETTER HI",
    "FF8C": "HALFWIDTH KATAKANA LETTER HU",
    "FF8D": "HALFWIDTH KATAKANA LETTER HE",
    "FF8E": "HALFWIDTH KATAKANA LETTER HO",
    "FF8F": "HALFWIDTH KATAKANA LETTER MA",
    "FF90": "HALFWIDTH KATAKANA LETTER MI",
    "FF91": "HALFWIDTH KATAKANA LETTER MU",
    "FF92": "HALFWIDTH KATAKANA LETTER ME",
    "FF93": "HALFWIDTH KATAKANA LETTER MO",
    "FF94": "HALFWIDTH KATAKANA LETTER YA",
    "FF95": "HALFWIDTH KATAKANA LETTER YU",
    "FF96": "HALFWIDTH KATAKANA LETTER YO",
    "FF97": "HALFWIDTH KATAKANA LETTER RA",
    "FF98": "HALFWIDTH KATAKANA LETTER RI",
    "FF99": "HALFWIDTH KATAKANA LETTER RU",
    "FF9A": "HALFWIDTH KATAKANA LETTER RE",
    "FF9B": "HALFWIDTH KATAKANA LETTER RO",
    "FF9C": "HALFWIDTH KATAKANA LETTER WA",
    "FF9D": "HALFWIDTH KATAKANA LETTER N",
    "FF9E": "HALFWIDTH KATAKANA VOICED SOUND MARK",
    "FF9F": "HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK",
    "FFA0": "HALFWIDTH HANGUL FILLER",
    "FFA1": "HALFWIDTH HANGUL LETTER KIYEOK",
    "FFA2": "HALFWIDTH HANGUL LETTER SSANGKIYEOK",
    "FFA3": "HALFWIDTH HANGUL LETTER KIYEOK-SIOS",
    "FFA4": "HALFWIDTH HANGUL LETTER NIEUN",
    "FFA5": "HALFWIDTH HANGUL LETTER NIEUN-CIEUC",
    "FFA6": "HALFWIDTH HANGUL LETTER NIEUN-HIEUH",
    "FFA7": "HALFWIDTH HANGUL LETTER TIKEUT",
    "FFA8": "HALFWIDTH HANGUL LETTER SSANGTIKEUT",
    "FFA9": "HALFWIDTH HANGUL LETTER RIEUL",
    "FFAA": "HALFWIDTH HANGUL LETTER RIEUL-KIYEOK",
    "FFAB": "HALFWIDTH HANGUL LETTER RIEUL-MIEUM",
    "FFAC": "HALFWIDTH HANGUL LETTER RIEUL-PIEUP",
    "FFAD": "HALFWIDTH HANGUL LETTER RIEUL-SIOS",
    "FFAE": "HALFWIDTH HANGUL LETTER RIEUL-THIEUTH",
    "FFAF": "HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH",
    "FFB0": "HALFWIDTH HANGUL LETTER RIEUL-HIEUH",
    "FFB1": "HALFWIDTH HANGUL LETTER MIEUM",
    "FFB2": "HALFWIDTH HANGUL LETTER PIEUP",
    "FFB3": "HALFWIDTH HANGUL LETTER SSANGPIEUP",
    "FFB4": "HALFWIDTH HANGUL LETTER PIEUP-SIOS",
    "FFB5": "HALFWIDTH HANGUL LETTER SIOS",
    "FFB6": "HALFWIDTH HANGUL LETTER SSANGSIOS",
    "FFB7": "HALFWIDTH HANGUL LETTER IEUNG",
    "FFB8": "HALFWIDTH HANGUL LETTER CIEUC",
    "FFB9": "HALFWIDTH HANGUL LETTER SSANGCIEUC",
    "FFBA": "HALFWIDTH HANGUL LETTER CHIEUCH",
    "FFBB": "HALFWIDTH HANGUL LETTER KHIEUKH",
    "FFBC": "HALFWIDTH HANGUL LETTER THIEUTH",
    "FFBD": "HALFWIDTH HANGUL LETTER PHIEUPH",
    "FFBE": "HALFWIDTH HANGUL LETTER HIEUH",
    "FFC2": "HALFWIDTH HANGUL LETTER A",
    "FFC3": "HALFWIDTH HANGUL LETTER AE",
    "FFC4": "HALFWIDTH HANGUL LETTER YA",
    "FFC5": "HALFWIDTH HANGUL LETTER YAE",
    "FFC6": "HALFWIDTH HANGUL LETTER EO",
    "FFC7": "HALFWIDTH HANGUL LETTER E",
    "FFCA": "HALFWIDTH HANGUL LETTER YEO",
    "FFCB": "HALFWIDTH HANGUL LETTER YE",
    "FFCC": "HALFWIDTH HANGUL LETTER O",
    "FFCD": "HALFWIDTH HANGUL LETTER WA",
    "FFCE": "HALFWIDTH HANGUL LETTER WAE",
    "FFCF": "HALFWIDTH HANGUL LETTER OE",
    "FFD2": "HALFWIDTH HANGUL LETTER YO",
    "FFD3": "HALFWIDTH HANGUL LETTER U",
    "FFD4": "HALFWIDTH HANGUL LETTER WEO",
    "FFD5": "HALFWIDTH HANGUL LETTER WE",
    "FFD6": "HALFWIDTH HANGUL LETTER WI",
    "FFD7": "HALFWIDTH HANGUL LETTER YU",
    "FFDA": "HALFWIDTH HANGUL LETTER EU",
    "FFDB": "HALFWIDTH HANGUL LETTER YI",
    "FFDC": "HALFWIDTH HANGUL LETTER I",
    "FFE0": "FULLWIDTH CENT SIGN",
    "FFE1": "FULLWIDTH POUND SIGN",
    "FFE2": "FULLWIDTH NOT SIGN",
    "FFE3": "FULLWIDTH MACRON",
    "FFE4": "FULLWIDTH BROKEN BAR",
    "FFE5": "FULLWIDTH YEN SIGN",
    "FFE6": "FULLWIDTH WON SIGN",
    "FFE8": "HALFWIDTH FORMS LIGHT VERTICAL",
    "FFE9": "HALFWIDTH LEFTWARDS ARROW",
    "FFEA": "HALFWIDTH UPWARDS ARROW",
    "FFEB": "HALFWIDTH RIGHTWARDS ARROW",
    "FFEC": "HALFWIDTH DOWNWARDS ARROW",
    "FFED": "HALFWIDTH BLACK SQUARE",
    "FFEE": "HALFWIDTH WHITE CIRCLE",
    "FFF9": "INTERLINEAR ANNOTATION ANCHOR",
    "FFFA": "INTERLINEAR ANNOTATION SEPARATOR",
    "FFFB": "INTERLINEAR ANNOTATION TERMINATOR",
    "FFFC": "OBJECT REPLACEMENT CHARACTER",
    "FFFD": "REPLACEMENT CHARACTER",
    "10000": "LINEAR B SYLLABLE B008 A",
    "10001": "LINEAR B SYLLABLE B038 E",
    "10002": "LINEAR B SYLLABLE B028 I",
    "10003": "LINEAR B SYLLABLE B061 O",
    "10004": "LINEAR B SYLLABLE B010 U",
    "10005": "LINEAR B SYLLABLE B001 DA",
    "10006": "LINEAR B SYLLABLE B045 DE",
    "10007": "LINEAR B SYLLABLE B007 DI",
    "10008": "LINEAR B SYLLABLE B014 DO",
    "10009": "LINEAR B SYLLABLE B051 DU",
    "1000A": "LINEAR B SYLLABLE B057 JA",
    "1000B": "LINEAR B SYLLABLE B046 JE",
    "1000D": "LINEAR B SYLLABLE B036 JO",
    "1000E": "LINEAR B SYLLABLE B065 JU",
    "1000F": "LINEAR B SYLLABLE B077 KA",
    "10010": "LINEAR B SYLLABLE B044 KE",
    "10011": "LINEAR B SYLLABLE B067 KI",
    "10012": "LINEAR B SYLLABLE B070 KO",
    "10013": "LINEAR B SYLLABLE B081 KU",
    "10014": "LINEAR B SYLLABLE B080 MA",
    "10015": "LINEAR B SYLLABLE B013 ME",
    "10016": "LINEAR B SYLLABLE B073 MI",
    "10017": "LINEAR B SYLLABLE B015 MO",
    "10018": "LINEAR B SYLLABLE B023 MU",
    "10019": "LINEAR B SYLLABLE B006 NA",
    "1001A": "LINEAR B SYLLABLE B024 NE",
    "1001B": "LINEAR B SYLLABLE B030 NI",
    "1001C": "LINEAR B SYLLABLE B052 NO",
    "1001D": "LINEAR B SYLLABLE B055 NU",
    "1001E": "LINEAR B SYLLABLE B003 PA",
    "1001F": "LINEAR B SYLLABLE B072 PE",
    "10020": "LINEAR B SYLLABLE B039 PI",
    "10021": "LINEAR B SYLLABLE B011 PO",
    "10022": "LINEAR B SYLLABLE B050 PU",
    "10023": "LINEAR B SYLLABLE B016 QA",
    "10024": "LINEAR B SYLLABLE B078 QE",
    "10025": "LINEAR B SYLLABLE B021 QI",
    "10026": "LINEAR B SYLLABLE B032 QO",
    "10028": "LINEAR B SYLLABLE B060 RA",
    "10029": "LINEAR B SYLLABLE B027 RE",
    "1002A": "LINEAR B SYLLABLE B053 RI",
    "1002B": "LINEAR B SYLLABLE B002 RO",
    "1002C": "LINEAR B SYLLABLE B026 RU",
    "1002D": "LINEAR B SYLLABLE B031 SA",
    "1002E": "LINEAR B SYLLABLE B009 SE",
    "1002F": "LINEAR B SYLLABLE B041 SI",
    "10030": "LINEAR B SYLLABLE B012 SO",
    "10031": "LINEAR B SYLLABLE B058 SU",
    "10032": "LINEAR B SYLLABLE B059 TA",
    "10033": "LINEAR B SYLLABLE B004 TE",
    "10034": "LINEAR B SYLLABLE B037 TI",
    "10035": "LINEAR B SYLLABLE B005 TO",
    "10036": "LINEAR B SYLLABLE B069 TU",
    "10037": "LINEAR B SYLLABLE B054 WA",
    "10038": "LINEAR B SYLLABLE B075 WE",
    "10039": "LINEAR B SYLLABLE B040 WI",
    "1003A": "LINEAR B SYLLABLE B042 WO",
    "1003C": "LINEAR B SYLLABLE B017 ZA",
    "1003D": "LINEAR B SYLLABLE B074 ZE",
    "1003F": "LINEAR B SYLLABLE B020 ZO",
    "10040": "LINEAR B SYLLABLE B025 A2",
    "10041": "LINEAR B SYLLABLE B043 A3",
    "10042": "LINEAR B SYLLABLE B085 AU",
    "10043": "LINEAR B SYLLABLE B071 DWE",
    "10044": "LINEAR B SYLLABLE B090 DWO",
    "10045": "LINEAR B SYLLABLE B048 NWA",
    "10046": "LINEAR B SYLLABLE B029 PU2",
    "10047": "LINEAR B SYLLABLE B062 PTE",
    "10048": "LINEAR B SYLLABLE B076 RA2",
    "10049": "LINEAR B SYLLABLE B033 RA3",
    "1004A": "LINEAR B SYLLABLE B068 RO2",
    "1004B": "LINEAR B SYLLABLE B066 TA2",
    "1004C": "LINEAR B SYLLABLE B087 TWE",
    "1004D": "LINEAR B SYLLABLE B091 TWO",
    "10050": "LINEAR B SYMBOL B018",
    "10051": "LINEAR B SYMBOL B019",
    "10052": "LINEAR B SYMBOL B022",
    "10053": "LINEAR B SYMBOL B034",
    "10054": "LINEAR B SYMBOL B047",
    "10055": "LINEAR B SYMBOL B049",
    "10056": "LINEAR B SYMBOL B056",
    "10057": "LINEAR B SYMBOL B063",
    "10058": "LINEAR B SYMBOL B064",
    "10059": "LINEAR B SYMBOL B079",
    "1005A": "LINEAR B SYMBOL B082",
    "1005B": "LINEAR B SYMBOL B083",
    "1005C": "LINEAR B SYMBOL B086",
    "1005D": "LINEAR B SYMBOL B089",
    "10080": "LINEAR B IDEOGRAM B100 MAN",
    "10081": "LINEAR B IDEOGRAM B102 WOMAN",
    "10082": "LINEAR B IDEOGRAM B104 DEER",
    "10083": "LINEAR B IDEOGRAM B105 EQUID",
    "10084": "LINEAR B IDEOGRAM B105F MARE",
    "10085": "LINEAR B IDEOGRAM B105M STALLION",
    "10086": "LINEAR B IDEOGRAM B106F EWE",
    "10087": "LINEAR B IDEOGRAM B106M RAM",
    "10088": "LINEAR B IDEOGRAM B107F SHE-GOAT",
    "10089": "LINEAR B IDEOGRAM B107M HE-GOAT",
    "1008A": "LINEAR B IDEOGRAM B108F SOW",
    "1008B": "LINEAR B IDEOGRAM B108M BOAR",
    "1008C": "LINEAR B IDEOGRAM B109F COW",
    "1008D": "LINEAR B IDEOGRAM B109M BULL",
    "1008E": "LINEAR B IDEOGRAM B120 WHEAT",
    "1008F": "LINEAR B IDEOGRAM B121 BARLEY",
    "10090": "LINEAR B IDEOGRAM B122 OLIVE",
    "10091": "LINEAR B IDEOGRAM B123 SPICE",
    "10092": "LINEAR B IDEOGRAM B125 CYPERUS",
    "10093": "LINEAR B MONOGRAM B127 KAPO",
    "10094": "LINEAR B MONOGRAM B128 KANAKO",
    "10095": "LINEAR B IDEOGRAM B130 OIL",
    "10096": "LINEAR B IDEOGRAM B131 WINE",
    "10097": "LINEAR B IDEOGRAM B132",
    "10098": "LINEAR B MONOGRAM B133 AREPA",
    "10099": "LINEAR B MONOGRAM B135 MERI",
    "1009A": "LINEAR B IDEOGRAM B140 BRONZE",
    "1009B": "LINEAR B IDEOGRAM B141 GOLD",
    "1009C": "LINEAR B IDEOGRAM B142",
    "1009D": "LINEAR B IDEOGRAM B145 WOOL",
    "1009E": "LINEAR B IDEOGRAM B146",
    "1009F": "LINEAR B IDEOGRAM B150",
    "100A0": "LINEAR B IDEOGRAM B151 HORN",
    "100A1": "LINEAR B IDEOGRAM B152",
    "100A2": "LINEAR B IDEOGRAM B153",
    "100A3": "LINEAR B IDEOGRAM B154",
    "100A4": "LINEAR B MONOGRAM B156 TURO2",
    "100A5": "LINEAR B IDEOGRAM B157",
    "100A6": "LINEAR B IDEOGRAM B158",
    "100A7": "LINEAR B IDEOGRAM B159 CLOTH",
    "100A8": "LINEAR B IDEOGRAM B160",
    "100A9": "LINEAR B IDEOGRAM B161",
    "100AA": "LINEAR B IDEOGRAM B162 GARMENT",
    "100AB": "LINEAR B IDEOGRAM B163 ARMOUR",
    "100AC": "LINEAR B IDEOGRAM B164",
    "100AD": "LINEAR B IDEOGRAM B165",
    "100AE": "LINEAR B IDEOGRAM B166",
    "100AF": "LINEAR B IDEOGRAM B167",
    "100B0": "LINEAR B IDEOGRAM B168",
    "100B1": "LINEAR B IDEOGRAM B169",
    "100B2": "LINEAR B IDEOGRAM B170",
    "100B3": "LINEAR B IDEOGRAM B171",
    "100B4": "LINEAR B IDEOGRAM B172",
    "100B5": "LINEAR B IDEOGRAM B173 MONTH",
    "100B6": "LINEAR B IDEOGRAM B174",
    "100B7": "LINEAR B IDEOGRAM B176 TREE",
    "100B8": "LINEAR B IDEOGRAM B177",
    "100B9": "LINEAR B IDEOGRAM B178",
    "100BA": "LINEAR B IDEOGRAM B179",
    "100BB": "LINEAR B IDEOGRAM B180",
    "100BC": "LINEAR B IDEOGRAM B181",
    "100BD": "LINEAR B IDEOGRAM B182",
    "100BE": "LINEAR B IDEOGRAM B183",
    "100BF": "LINEAR B IDEOGRAM B184",
    "100C0": "LINEAR B IDEOGRAM B185",
    "100C1": "LINEAR B IDEOGRAM B189",
    "100C2": "LINEAR B IDEOGRAM B190",
    "100C3": "LINEAR B IDEOGRAM B191 HELMET",
    "100C4": "LINEAR B IDEOGRAM B220 FOOTSTOOL",
    "100C5": "LINEAR B IDEOGRAM B225 BATHTUB",
    "100C6": "LINEAR B IDEOGRAM B230 SPEAR",
    "100C7": "LINEAR B IDEOGRAM B231 ARROW",
    "100C8": "LINEAR B IDEOGRAM B232",
    "100C9": "LINEAR B IDEOGRAM B233 SWORD",
    "100CA": "LINEAR B IDEOGRAM B234",
    "100CB": "LINEAR B IDEOGRAM B236",
    "100CC": "LINEAR B IDEOGRAM B240 WHEELED CHARIOT",
    "100CD": "LINEAR B IDEOGRAM B241 CHARIOT",
    "100CE": "LINEAR B IDEOGRAM B242 CHARIOT FRAME",
    "100CF": "LINEAR B IDEOGRAM B243 WHEEL",
    "100D0": "LINEAR B IDEOGRAM B245",
    "100D1": "LINEAR B IDEOGRAM B246",
    "100D2": "LINEAR B MONOGRAM B247 DIPTE",
    "100D3": "LINEAR B IDEOGRAM B248",
    "100D4": "LINEAR B IDEOGRAM B249",
    "100D5": "LINEAR B IDEOGRAM B251",
    "100D6": "LINEAR B IDEOGRAM B252",
    "100D7": "LINEAR B IDEOGRAM B253",
    "100D8": "LINEAR B IDEOGRAM B254 DART",
    "100D9": "LINEAR B IDEOGRAM B255",
    "100DA": "LINEAR B IDEOGRAM B256",
    "100DB": "LINEAR B IDEOGRAM B257",
    "100DC": "LINEAR B IDEOGRAM B258",
    "100DD": "LINEAR B IDEOGRAM B259",
    "100DE": "LINEAR B IDEOGRAM VESSEL B155",
    "100DF": "LINEAR B IDEOGRAM VESSEL B200",
    "100E0": "LINEAR B IDEOGRAM VESSEL B201",
    "100E1": "LINEAR B IDEOGRAM VESSEL B202",
    "100E2": "LINEAR B IDEOGRAM VESSEL B203",
    "100E3": "LINEAR B IDEOGRAM VESSEL B204",
    "100E4": "LINEAR B IDEOGRAM VESSEL B205",
    "100E5": "LINEAR B IDEOGRAM VESSEL B206",
    "100E6": "LINEAR B IDEOGRAM VESSEL B207",
    "100E7": "LINEAR B IDEOGRAM VESSEL B208",
    "100E8": "LINEAR B IDEOGRAM VESSEL B209",
    "100E9": "LINEAR B IDEOGRAM VESSEL B210",
    "100EA": "LINEAR B IDEOGRAM VESSEL B211",
    "100EB": "LINEAR B IDEOGRAM VESSEL B212",
    "100EC": "LINEAR B IDEOGRAM VESSEL B213",
    "100ED": "LINEAR B IDEOGRAM VESSEL B214",
    "100EE": "LINEAR B IDEOGRAM VESSEL B215",
    "100EF": "LINEAR B IDEOGRAM VESSEL B216",
    "100F0": "LINEAR B IDEOGRAM VESSEL B217",
    "100F1": "LINEAR B IDEOGRAM VESSEL B218",
    "100F2": "LINEAR B IDEOGRAM VESSEL B219",
    "100F3": "LINEAR B IDEOGRAM VESSEL B221",
    "100F4": "LINEAR B IDEOGRAM VESSEL B222",
    "100F5": "LINEAR B IDEOGRAM VESSEL B226",
    "100F6": "LINEAR B IDEOGRAM VESSEL B227",
    "100F7": "LINEAR B IDEOGRAM VESSEL B228",
    "100F8": "LINEAR B IDEOGRAM VESSEL B229",
    "100F9": "LINEAR B IDEOGRAM VESSEL B250",
    "100FA": "LINEAR B IDEOGRAM VESSEL B305",
    "10100": "AEGEAN WORD SEPARATOR LINE",
    "10101": "AEGEAN WORD SEPARATOR DOT",
    "10102": "AEGEAN CHECK MARK",
    "10107": "AEGEAN NUMBER ONE",
    "10108": "AEGEAN NUMBER TWO",
    "10109": "AEGEAN NUMBER THREE",
    "1010A": "AEGEAN NUMBER FOUR",
    "1010B": "AEGEAN NUMBER FIVE",
    "1010C": "AEGEAN NUMBER SIX",
    "1010D": "AEGEAN NUMBER SEVEN",
    "1010E": "AEGEAN NUMBER EIGHT",
    "1010F": "AEGEAN NUMBER NINE",
    "10110": "AEGEAN NUMBER TEN",
    "10111": "AEGEAN NUMBER TWENTY",
    "10112": "AEGEAN NUMBER THIRTY",
    "10113": "AEGEAN NUMBER FORTY",
    "10114": "AEGEAN NUMBER FIFTY",
    "10115": "AEGEAN NUMBER SIXTY",
    "10116": "AEGEAN NUMBER SEVENTY",
    "10117": "AEGEAN NUMBER EIGHTY",
    "10118": "AEGEAN NUMBER NINETY",
    "10119": "AEGEAN NUMBER ONE HUNDRED",
    "1011A": "AEGEAN NUMBER TWO HUNDRED",
    "1011B": "AEGEAN NUMBER THREE HUNDRED",
    "1011C": "AEGEAN NUMBER FOUR HUNDRED",
    "1011D": "AEGEAN NUMBER FIVE HUNDRED",
    "1011E": "AEGEAN NUMBER SIX HUNDRED",
    "1011F": "AEGEAN NUMBER SEVEN HUNDRED",
    "10120": "AEGEAN NUMBER EIGHT HUNDRED",
    "10121": "AEGEAN NUMBER NINE HUNDRED",
    "10122": "AEGEAN NUMBER ONE THOUSAND",
    "10123": "AEGEAN NUMBER TWO THOUSAND",
    "10124": "AEGEAN NUMBER THREE THOUSAND",
    "10125": "AEGEAN NUMBER FOUR THOUSAND",
    "10126": "AEGEAN NUMBER FIVE THOUSAND",
    "10127": "AEGEAN NUMBER SIX THOUSAND",
    "10128": "AEGEAN NUMBER SEVEN THOUSAND",
    "10129": "AEGEAN NUMBER EIGHT THOUSAND",
    "1012A": "AEGEAN NUMBER NINE THOUSAND",
    "1012B": "AEGEAN NUMBER TEN THOUSAND",
    "1012C": "AEGEAN NUMBER TWENTY THOUSAND",
    "1012D": "AEGEAN NUMBER THIRTY THOUSAND",
    "1012E": "AEGEAN NUMBER FORTY THOUSAND",
    "1012F": "AEGEAN NUMBER FIFTY THOUSAND",
    "10130": "AEGEAN NUMBER SIXTY THOUSAND",
    "10131": "AEGEAN NUMBER SEVENTY THOUSAND",
    "10132": "AEGEAN NUMBER EIGHTY THOUSAND",
    "10133": "AEGEAN NUMBER NINETY THOUSAND",
    "10137": "AEGEAN WEIGHT BASE UNIT",
    "10138": "AEGEAN WEIGHT FIRST SUBUNIT",
    "10139": "AEGEAN WEIGHT SECOND SUBUNIT",
    "1013A": "AEGEAN WEIGHT THIRD SUBUNIT",
    "1013B": "AEGEAN WEIGHT FOURTH SUBUNIT",
    "1013C": "AEGEAN DRY MEASURE FIRST SUBUNIT",
    "1013D": "AEGEAN LIQUID MEASURE FIRST SUBUNIT",
    "1013E": "AEGEAN MEASURE SECOND SUBUNIT",
    "1013F": "AEGEAN MEASURE THIRD SUBUNIT",
    "10140": "GREEK ACROPHONIC ATTIC ONE QUARTER",
    "10141": "GREEK ACROPHONIC ATTIC ONE HALF",
    "10142": "GREEK ACROPHONIC ATTIC ONE DRACHMA",
    "10143": "GREEK ACROPHONIC ATTIC FIVE",
    "10144": "GREEK ACROPHONIC ATTIC FIFTY",
    "10145": "GREEK ACROPHONIC ATTIC FIVE HUNDRED",
    "10146": "GREEK ACROPHONIC ATTIC FIVE THOUSAND",
    "10147": "GREEK ACROPHONIC ATTIC FIFTY THOUSAND",
    "10148": "GREEK ACROPHONIC ATTIC FIVE TALENTS",
    "10149": "GREEK ACROPHONIC ATTIC TEN TALENTS",
    "1014A": "GREEK ACROPHONIC ATTIC FIFTY TALENTS",
    "1014B": "GREEK ACROPHONIC ATTIC ONE HUNDRED TALENTS",
    "1014C": "GREEK ACROPHONIC ATTIC FIVE HUNDRED TALENTS",
    "1014D": "GREEK ACROPHONIC ATTIC ONE THOUSAND TALENTS",
    "1014E": "GREEK ACROPHONIC ATTIC FIVE THOUSAND TALENTS",
    "1014F": "GREEK ACROPHONIC ATTIC FIVE STATERS",
    "10150": "GREEK ACROPHONIC ATTIC TEN STATERS",
    "10151": "GREEK ACROPHONIC ATTIC FIFTY STATERS",
    "10152": "GREEK ACROPHONIC ATTIC ONE HUNDRED STATERS",
    "10153": "GREEK ACROPHONIC ATTIC FIVE HUNDRED STATERS",
    "10154": "GREEK ACROPHONIC ATTIC ONE THOUSAND STATERS",
    "10155": "GREEK ACROPHONIC ATTIC TEN THOUSAND STATERS",
    "10156": "GREEK ACROPHONIC ATTIC FIFTY THOUSAND STATERS",
    "10157": "GREEK ACROPHONIC ATTIC TEN MNAS",
    "10158": "GREEK ACROPHONIC HERAEUM ONE PLETHRON",
    "10159": "GREEK ACROPHONIC THESPIAN ONE",
    "1015A": "GREEK ACROPHONIC HERMIONIAN ONE",
    "1015B": "GREEK ACROPHONIC EPIDAUREAN TWO",
    "1015C": "GREEK ACROPHONIC THESPIAN TWO",
    "1015D": "GREEK ACROPHONIC CYRENAIC TWO DRACHMAS",
    "1015E": "GREEK ACROPHONIC EPIDAUREAN TWO DRACHMAS",
    "1015F": "GREEK ACROPHONIC TROEZENIAN FIVE",
    "10160": "GREEK ACROPHONIC TROEZENIAN TEN",
    "10161": "GREEK ACROPHONIC TROEZENIAN TEN ALTERNATE FORM",
    "10162": "GREEK ACROPHONIC HERMIONIAN TEN",
    "10163": "GREEK ACROPHONIC MESSENIAN TEN",
    "10164": "GREEK ACROPHONIC THESPIAN TEN",
    "10165": "GREEK ACROPHONIC THESPIAN THIRTY",
    "10166": "GREEK ACROPHONIC TROEZENIAN FIFTY",
    "10167": "GREEK ACROPHONIC TROEZENIAN FIFTY ALTERNATE FORM",
    "10168": "GREEK ACROPHONIC HERMIONIAN FIFTY",
    "10169": "GREEK ACROPHONIC THESPIAN FIFTY",
    "1016A": "GREEK ACROPHONIC THESPIAN ONE HUNDRED",
    "1016B": "GREEK ACROPHONIC THESPIAN THREE HUNDRED",
    "1016C": "GREEK ACROPHONIC EPIDAUREAN FIVE HUNDRED",
    "1016D": "GREEK ACROPHONIC TROEZENIAN FIVE HUNDRED",
    "1016E": "GREEK ACROPHONIC THESPIAN FIVE HUNDRED",
    "1016F": "GREEK ACROPHONIC CARYSTIAN FIVE HUNDRED",
    "10170": "GREEK ACROPHONIC NAXIAN FIVE HUNDRED",
    "10171": "GREEK ACROPHONIC THESPIAN ONE THOUSAND",
    "10172": "GREEK ACROPHONIC THESPIAN FIVE THOUSAND",
    "10173": "GREEK ACROPHONIC DELPHIC FIVE MNAS",
    "10174": "GREEK ACROPHONIC STRATIAN FIFTY MNAS",
    "10175": "GREEK ONE HALF SIGN",
    "10176": "GREEK ONE HALF SIGN ALTERNATE FORM",
    "10177": "GREEK TWO THIRDS SIGN",
    "10178": "GREEK THREE QUARTERS SIGN",
    "10179": "GREEK YEAR SIGN",
    "1017A": "GREEK TALENT SIGN",
    "1017B": "GREEK DRACHMA SIGN",
    "1017C": "GREEK OBOL SIGN",
    "1017D": "GREEK TWO OBOLS SIGN",
    "1017E": "GREEK THREE OBOLS SIGN",
    "1017F": "GREEK FOUR OBOLS SIGN",
    "10180": "GREEK FIVE OBOLS SIGN",
    "10181": "GREEK METRETES SIGN",
    "10182": "GREEK KYATHOS BASE SIGN",
    "10183": "GREEK LITRA SIGN",
    "10184": "GREEK OUNKIA SIGN",
    "10185": "GREEK XESTES SIGN",
    "10186": "GREEK ARTABE SIGN",
    "10187": "GREEK AROURA SIGN",
    "10188": "GREEK GRAMMA SIGN",
    "10189": "GREEK TRYBLION BASE SIGN",
    "1018A": "GREEK ZERO SIGN",
    "1018B": "GREEK ONE QUARTER SIGN",
    "1018C": "GREEK SINUSOID SIGN",
    "1018D": "GREEK INDICTION SIGN",
    "1018E": "NOMISMA SIGN",
    "10190": "ROMAN SEXTANS SIGN",
    "10191": "ROMAN UNCIA SIGN",
    "10192": "ROMAN SEMUNCIA SIGN",
    "10193": "ROMAN SEXTULA SIGN",
    "10194": "ROMAN DIMIDIA SEXTULA SIGN",
    "10195": "ROMAN SILIQUA SIGN",
    "10196": "ROMAN DENARIUS SIGN",
    "10197": "ROMAN QUINARIUS SIGN",
    "10198": "ROMAN SESTERTIUS SIGN",
    "10199": "ROMAN DUPONDIUS SIGN",
    "1019A": "ROMAN AS SIGN",
    "1019B": "ROMAN CENTURIAL SIGN",
    "101A0": "GREEK SYMBOL TAU RHO",
    "101D0": "PHAISTOS DISC SIGN PEDESTRIAN",
    "101D1": "PHAISTOS DISC SIGN PLUMED HEAD",
    "101D2": "PHAISTOS DISC SIGN TATTOOED HEAD",
    "101D3": "PHAISTOS DISC SIGN CAPTIVE",
    "101D4": "PHAISTOS DISC SIGN CHILD",
    "101D5": "PHAISTOS DISC SIGN WOMAN",
    "101D6": "PHAISTOS DISC SIGN HELMET",
    "101D7": "PHAISTOS DISC SIGN GAUNTLET",
    "101D8": "PHAISTOS DISC SIGN TIARA",
    "101D9": "PHAISTOS DISC SIGN ARROW",
    "101DA": "PHAISTOS DISC SIGN BOW",
    "101DB": "PHAISTOS DISC SIGN SHIELD",
    "101DC": "PHAISTOS DISC SIGN CLUB",
    "101DD": "PHAISTOS DISC SIGN MANACLES",
    "101DE": "PHAISTOS DISC SIGN MATTOCK",
    "101DF": "PHAISTOS DISC SIGN SAW",
    "101E0": "PHAISTOS DISC SIGN LID",
    "101E1": "PHAISTOS DISC SIGN BOOMERANG",
    "101E2": "PHAISTOS DISC SIGN CARPENTRY PLANE",
    "101E3": "PHAISTOS DISC SIGN DOLIUM",
    "101E4": "PHAISTOS DISC SIGN COMB",
    "101E5": "PHAISTOS DISC SIGN SLING",
    "101E6": "PHAISTOS DISC SIGN COLUMN",
    "101E7": "PHAISTOS DISC SIGN BEEHIVE",
    "101E8": "PHAISTOS DISC SIGN SHIP",
    "101E9": "PHAISTOS DISC SIGN HORN",
    "101EA": "PHAISTOS DISC SIGN HIDE",
    "101EB": "PHAISTOS DISC SIGN BULLS LEG",
    "101EC": "PHAISTOS DISC SIGN CAT",
    "101ED": "PHAISTOS DISC SIGN RAM",
    "101EE": "PHAISTOS DISC SIGN EAGLE",
    "101EF": "PHAISTOS DISC SIGN DOVE",
    "101F0": "PHAISTOS DISC SIGN TUNNY",
    "101F1": "PHAISTOS DISC SIGN BEE",
    "101F2": "PHAISTOS DISC SIGN PLANE TREE",
    "101F3": "PHAISTOS DISC SIGN VINE",
    "101F4": "PHAISTOS DISC SIGN PAPYRUS",
    "101F5": "PHAISTOS DISC SIGN ROSETTE",
    "101F6": "PHAISTOS DISC SIGN LILY",
    "101F7": "PHAISTOS DISC SIGN OX BACK",
    "101F8": "PHAISTOS DISC SIGN FLUTE",
    "101F9": "PHAISTOS DISC SIGN GRATER",
    "101FA": "PHAISTOS DISC SIGN STRAINER",
    "101FB": "PHAISTOS DISC SIGN SMALL AXE",
    "101FC": "PHAISTOS DISC SIGN WAVY BAND",
    "101FD": "PHAISTOS DISC SIGN COMBINING OBLIQUE STROKE",
    "10280": "LYCIAN LETTER A",
    "10281": "LYCIAN LETTER E",
    "10282": "LYCIAN LETTER B",
    "10283": "LYCIAN LETTER BH",
    "10284": "LYCIAN LETTER G",
    "10285": "LYCIAN LETTER D",
    "10286": "LYCIAN LETTER I",
    "10287": "LYCIAN LETTER W",
    "10288": "LYCIAN LETTER Z",
    "10289": "LYCIAN LETTER TH",
    "1028A": "LYCIAN LETTER J",
    "1028B": "LYCIAN LETTER K",
    "1028C": "LYCIAN LETTER Q",
    "1028D": "LYCIAN LETTER L",
    "1028E": "LYCIAN LETTER M",
    "1028F": "LYCIAN LETTER N",
    "10290": "LYCIAN LETTER MM",
    "10291": "LYCIAN LETTER NN",
    "10292": "LYCIAN LETTER U",
    "10293": "LYCIAN LETTER P",
    "10294": "LYCIAN LETTER KK",
    "10295": "LYCIAN LETTER R",
    "10296": "LYCIAN LETTER S",
    "10297": "LYCIAN LETTER T",
    "10298": "LYCIAN LETTER TT",
    "10299": "LYCIAN LETTER AN",
    "1029A": "LYCIAN LETTER EN",
    "1029B": "LYCIAN LETTER H",
    "1029C": "LYCIAN LETTER X",
    "102A0": "CARIAN LETTER A",
    "102A1": "CARIAN LETTER P2",
    "102A2": "CARIAN LETTER D",
    "102A3": "CARIAN LETTER L",
    "102A4": "CARIAN LETTER UUU",
    "102A5": "CARIAN LETTER R",
    "102A6": "CARIAN LETTER LD",
    "102A7": "CARIAN LETTER A2",
    "102A8": "CARIAN LETTER Q",
    "102A9": "CARIAN LETTER B",
    "102AA": "CARIAN LETTER M",
    "102AB": "CARIAN LETTER O",
    "102AC": "CARIAN LETTER D2",
    "102AD": "CARIAN LETTER T",
    "102AE": "CARIAN LETTER SH",
    "102AF": "CARIAN LETTER SH2",
    "102B0": "CARIAN LETTER S",
    "102B1": "CARIAN LETTER C-18",
    "102B2": "CARIAN LETTER U",
    "102B3": "CARIAN LETTER NN",
    "102B4": "CARIAN LETTER X",
    "102B5": "CARIAN LETTER N",
    "102B6": "CARIAN LETTER TT2",
    "102B7": "CARIAN LETTER P",
    "102B8": "CARIAN LETTER SS",
    "102B9": "CARIAN LETTER I",
    "102BA": "CARIAN LETTER E",
    "102BB": "CARIAN LETTER UUUU",
    "102BC": "CARIAN LETTER K",
    "102BD": "CARIAN LETTER K2",
    "102BE": "CARIAN LETTER ND",
    "102BF": "CARIAN LETTER UU",
    "102C0": "CARIAN LETTER G",
    "102C1": "CARIAN LETTER G2",
    "102C2": "CARIAN LETTER ST",
    "102C3": "CARIAN LETTER ST2",
    "102C4": "CARIAN LETTER NG",
    "102C5": "CARIAN LETTER II",
    "102C6": "CARIAN LETTER C-39",
    "102C7": "CARIAN LETTER TT",
    "102C8": "CARIAN LETTER UUU2",
    "102C9": "CARIAN LETTER RR",
    "102CA": "CARIAN LETTER MB",
    "102CB": "CARIAN LETTER MB2",
    "102CC": "CARIAN LETTER MB3",
    "102CD": "CARIAN LETTER MB4",
    "102CE": "CARIAN LETTER LD2",
    "102CF": "CARIAN LETTER E2",
    "102D0": "CARIAN LETTER UUU3",
    "102E0": "COPTIC EPACT THOUSANDS MARK",
    "102E1": "COPTIC EPACT DIGIT ONE",
    "102E2": "COPTIC EPACT DIGIT TWO",
    "102E3": "COPTIC EPACT DIGIT THREE",
    "102E4": "COPTIC EPACT DIGIT FOUR",
    "102E5": "COPTIC EPACT DIGIT FIVE",
    "102E6": "COPTIC EPACT DIGIT SIX",
    "102E7": "COPTIC EPACT DIGIT SEVEN",
    "102E8": "COPTIC EPACT DIGIT EIGHT",
    "102E9": "COPTIC EPACT DIGIT NINE",
    "102EA": "COPTIC EPACT NUMBER TEN",
    "102EB": "COPTIC EPACT NUMBER TWENTY",
    "102EC": "COPTIC EPACT NUMBER THIRTY",
    "102ED": "COPTIC EPACT NUMBER FORTY",
    "102EE": "COPTIC EPACT NUMBER FIFTY",
    "102EF": "COPTIC EPACT NUMBER SIXTY",
    "102F0": "COPTIC EPACT NUMBER SEVENTY",
    "102F1": "COPTIC EPACT NUMBER EIGHTY",
    "102F2": "COPTIC EPACT NUMBER NINETY",
    "102F3": "COPTIC EPACT NUMBER ONE HUNDRED",
    "102F4": "COPTIC EPACT NUMBER TWO HUNDRED",
    "102F5": "COPTIC EPACT NUMBER THREE HUNDRED",
    "102F6": "COPTIC EPACT NUMBER FOUR HUNDRED",
    "102F7": "COPTIC EPACT NUMBER FIVE HUNDRED",
    "102F8": "COPTIC EPACT NUMBER SIX HUNDRED",
    "102F9": "COPTIC EPACT NUMBER SEVEN HUNDRED",
    "102FA": "COPTIC EPACT NUMBER EIGHT HUNDRED",
    "102FB": "COPTIC EPACT NUMBER NINE HUNDRED",
    "10300": "OLD ITALIC LETTER A",
    "10301": "OLD ITALIC LETTER BE",
    "10302": "OLD ITALIC LETTER KE",
    "10303": "OLD ITALIC LETTER DE",
    "10304": "OLD ITALIC LETTER E",
    "10305": "OLD ITALIC LETTER VE",
    "10306": "OLD ITALIC LETTER ZE",
    "10307": "OLD ITALIC LETTER HE",
    "10308": "OLD ITALIC LETTER THE",
    "10309": "OLD ITALIC LETTER I",
    "1030A": "OLD ITALIC LETTER KA",
    "1030B": "OLD ITALIC LETTER EL",
    "1030C": "OLD ITALIC LETTER EM",
    "1030D": "OLD ITALIC LETTER EN",
    "1030E": "OLD ITALIC LETTER ESH",
    "1030F": "OLD ITALIC LETTER O",
    "10310": "OLD ITALIC LETTER PE",
    "10311": "OLD ITALIC LETTER SHE",
    "10312": "OLD ITALIC LETTER KU",
    "10313": "OLD ITALIC LETTER ER",
    "10314": "OLD ITALIC LETTER ES",
    "10315": "OLD ITALIC LETTER TE",
    "10316": "OLD ITALIC LETTER U",
    "10317": "OLD ITALIC LETTER EKS",
    "10318": "OLD ITALIC LETTER PHE",
    "10319": "OLD ITALIC LETTER KHE",
    "1031A": "OLD ITALIC LETTER EF",
    "1031B": "OLD ITALIC LETTER ERS",
    "1031C": "OLD ITALIC LETTER CHE",
    "1031D": "OLD ITALIC LETTER II",
    "1031E": "OLD ITALIC LETTER UU",
    "1031F": "OLD ITALIC LETTER ESS",
    "10320": "OLD ITALIC NUMERAL ONE",
    "10321": "OLD ITALIC NUMERAL FIVE",
    "10322": "OLD ITALIC NUMERAL TEN",
    "10323": "OLD ITALIC NUMERAL FIFTY",
    "10330": "GOTHIC LETTER AHSA",
    "10331": "GOTHIC LETTER BAIRKAN",
    "10332": "GOTHIC LETTER GIBA",
    "10333": "GOTHIC LETTER DAGS",
    "10334": "GOTHIC LETTER AIHVUS",
    "10335": "GOTHIC LETTER QAIRTHRA",
    "10336": "GOTHIC LETTER IUJA",
    "10337": "GOTHIC LETTER HAGL",
    "10338": "GOTHIC LETTER THIUTH",
    "10339": "GOTHIC LETTER EIS",
    "1033A": "GOTHIC LETTER KUSMA",
    "1033B": "GOTHIC LETTER LAGUS",
    "1033C": "GOTHIC LETTER MANNA",
    "1033D": "GOTHIC LETTER NAUTHS",
    "1033E": "GOTHIC LETTER JER",
    "1033F": "GOTHIC LETTER URUS",
    "10340": "GOTHIC LETTER PAIRTHRA",
    "10341": "GOTHIC LETTER NINETY",
    "10342": "GOTHIC LETTER RAIDA",
    "10343": "GOTHIC LETTER SAUIL",
    "10344": "GOTHIC LETTER TEIWS",
    "10345": "GOTHIC LETTER WINJA",
    "10346": "GOTHIC LETTER FAIHU",
    "10347": "GOTHIC LETTER IGGWS",
    "10348": "GOTHIC LETTER HWAIR",
    "10349": "GOTHIC LETTER OTHAL",
    "1034A": "GOTHIC LETTER NINE HUNDRED",
    "10350": "OLD PERMIC LETTER AN",
    "10351": "OLD PERMIC LETTER BUR",
    "10352": "OLD PERMIC LETTER GAI",
    "10353": "OLD PERMIC LETTER DOI",
    "10354": "OLD PERMIC LETTER E",
    "10355": "OLD PERMIC LETTER ZHOI",
    "10356": "OLD PERMIC LETTER DZHOI",
    "10357": "OLD PERMIC LETTER ZATA",
    "10358": "OLD PERMIC LETTER DZITA",
    "10359": "OLD PERMIC LETTER I",
    "1035A": "OLD PERMIC LETTER KOKE",
    "1035B": "OLD PERMIC LETTER LEI",
    "1035C": "OLD PERMIC LETTER MENOE",
    "1035D": "OLD PERMIC LETTER NENOE",
    "1035E": "OLD PERMIC LETTER VOOI",
    "1035F": "OLD PERMIC LETTER PEEI",
    "10360": "OLD PERMIC LETTER REI",
    "10361": "OLD PERMIC LETTER SII",
    "10362": "OLD PERMIC LETTER TAI",
    "10363": "OLD PERMIC LETTER U",
    "10364": "OLD PERMIC LETTER CHERY",
    "10365": "OLD PERMIC LETTER SHOOI",
    "10366": "OLD PERMIC LETTER SHCHOOI",
    "10367": "OLD PERMIC LETTER YRY",
    "10368": "OLD PERMIC LETTER YERU",
    "10369": "OLD PERMIC LETTER O",
    "1036A": "OLD PERMIC LETTER OO",
    "1036B": "OLD PERMIC LETTER EF",
    "1036C": "OLD PERMIC LETTER HA",
    "1036D": "OLD PERMIC LETTER TSIU",
    "1036E": "OLD PERMIC LETTER VER",
    "1036F": "OLD PERMIC LETTER YER",
    "10370": "OLD PERMIC LETTER YERI",
    "10371": "OLD PERMIC LETTER YAT",
    "10372": "OLD PERMIC LETTER IE",
    "10373": "OLD PERMIC LETTER YU",
    "10374": "OLD PERMIC LETTER YA",
    "10375": "OLD PERMIC LETTER IA",
    "10376": "COMBINING OLD PERMIC LETTER AN",
    "10377": "COMBINING OLD PERMIC LETTER DOI",
    "10378": "COMBINING OLD PERMIC LETTER ZATA",
    "10379": "COMBINING OLD PERMIC LETTER NENOE",
    "1037A": "COMBINING OLD PERMIC LETTER SII",
    "10380": "UGARITIC LETTER ALPA",
    "10381": "UGARITIC LETTER BETA",
    "10382": "UGARITIC LETTER GAMLA",
    "10383": "UGARITIC LETTER KHA",
    "10384": "UGARITIC LETTER DELTA",
    "10385": "UGARITIC LETTER HO",
    "10386": "UGARITIC LETTER WO",
    "10387": "UGARITIC LETTER ZETA",
    "10388": "UGARITIC LETTER HOTA",
    "10389": "UGARITIC LETTER TET",
    "1038A": "UGARITIC LETTER YOD",
    "1038B": "UGARITIC LETTER KAF",
    "1038C": "UGARITIC LETTER SHIN",
    "1038D": "UGARITIC LETTER LAMDA",
    "1038E": "UGARITIC LETTER MEM",
    "1038F": "UGARITIC LETTER DHAL",
    "10390": "UGARITIC LETTER NUN",
    "10391": "UGARITIC LETTER ZU",
    "10392": "UGARITIC LETTER SAMKA",
    "10393": "UGARITIC LETTER AIN",
    "10394": "UGARITIC LETTER PU",
    "10395": "UGARITIC LETTER SADE",
    "10396": "UGARITIC LETTER QOPA",
    "10397": "UGARITIC LETTER RASHA",
    "10398": "UGARITIC LETTER THANNA",
    "10399": "UGARITIC LETTER GHAIN",
    "1039A": "UGARITIC LETTER TO",
    "1039B": "UGARITIC LETTER I",
    "1039C": "UGARITIC LETTER U",
    "1039D": "UGARITIC LETTER SSU",
    "1039F": "UGARITIC WORD DIVIDER",
    "103A0": "OLD PERSIAN SIGN A",
    "103A1": "OLD PERSIAN SIGN I",
    "103A2": "OLD PERSIAN SIGN U",
    "103A3": "OLD PERSIAN SIGN KA",
    "103A4": "OLD PERSIAN SIGN KU",
    "103A5": "OLD PERSIAN SIGN GA",
    "103A6": "OLD PERSIAN SIGN GU",
    "103A7": "OLD PERSIAN SIGN XA",
    "103A8": "OLD PERSIAN SIGN CA",
    "103A9": "OLD PERSIAN SIGN JA",
    "103AA": "OLD PERSIAN SIGN JI",
    "103AB": "OLD PERSIAN SIGN TA",
    "103AC": "OLD PERSIAN SIGN TU",
    "103AD": "OLD PERSIAN SIGN DA",
    "103AE": "OLD PERSIAN SIGN DI",
    "103AF": "OLD PERSIAN SIGN DU",
    "103B0": "OLD PERSIAN SIGN THA",
    "103B1": "OLD PERSIAN SIGN PA",
    "103B2": "OLD PERSIAN SIGN BA",
    "103B3": "OLD PERSIAN SIGN FA",
    "103B4": "OLD PERSIAN SIGN NA",
    "103B5": "OLD PERSIAN SIGN NU",
    "103B6": "OLD PERSIAN SIGN MA",
    "103B7": "OLD PERSIAN SIGN MI",
    "103B8": "OLD PERSIAN SIGN MU",
    "103B9": "OLD PERSIAN SIGN YA",
    "103BA": "OLD PERSIAN SIGN VA",
    "103BB": "OLD PERSIAN SIGN VI",
    "103BC": "OLD PERSIAN SIGN RA",
    "103BD": "OLD PERSIAN SIGN RU",
    "103BE": "OLD PERSIAN SIGN LA",
    "103BF": "OLD PERSIAN SIGN SA",
    "103C0": "OLD PERSIAN SIGN ZA",
    "103C1": "OLD PERSIAN SIGN SHA",
    "103C2": "OLD PERSIAN SIGN SSA",
    "103C3": "OLD PERSIAN SIGN HA",
    "103C8": "OLD PERSIAN SIGN AURAMAZDAA",
    "103C9": "OLD PERSIAN SIGN AURAMAZDAA-2",
    "103CA": "OLD PERSIAN SIGN AURAMAZDAAHA",
    "103CB": "OLD PERSIAN SIGN XSHAAYATHIYA",
    "103CC": "OLD PERSIAN SIGN DAHYAAUSH",
    "103CD": "OLD PERSIAN SIGN DAHYAAUSH-2",
    "103CE": "OLD PERSIAN SIGN BAGA",
    "103CF": "OLD PERSIAN SIGN BUUMISH",
    "103D0": "OLD PERSIAN WORD DIVIDER",
    "103D1": "OLD PERSIAN NUMBER ONE",
    "103D2": "OLD PERSIAN NUMBER TWO",
    "103D3": "OLD PERSIAN NUMBER TEN",
    "103D4": "OLD PERSIAN NUMBER TWENTY",
    "103D5": "OLD PERSIAN NUMBER HUNDRED",
    "10400": "DESERET CAPITAL LETTER LONG I",
    "10401": "DESERET CAPITAL LETTER LONG E",
    "10402": "DESERET CAPITAL LETTER LONG A",
    "10403": "DESERET CAPITAL LETTER LONG AH",
    "10404": "DESERET CAPITAL LETTER LONG O",
    "10405": "DESERET CAPITAL LETTER LONG OO",
    "10406": "DESERET CAPITAL LETTER SHORT I",
    "10407": "DESERET CAPITAL LETTER SHORT E",
    "10408": "DESERET CAPITAL LETTER SHORT A",
    "10409": "DESERET CAPITAL LETTER SHORT AH",
    "1040A": "DESERET CAPITAL LETTER SHORT O",
    "1040B": "DESERET CAPITAL LETTER SHORT OO",
    "1040C": "DESERET CAPITAL LETTER AY",
    "1040D": "DESERET CAPITAL LETTER OW",
    "1040E": "DESERET CAPITAL LETTER WU",
    "1040F": "DESERET CAPITAL LETTER YEE",
    "10410": "DESERET CAPITAL LETTER H",
    "10411": "DESERET CAPITAL LETTER PEE",
    "10412": "DESERET CAPITAL LETTER BEE",
    "10413": "DESERET CAPITAL LETTER TEE",
    "10414": "DESERET CAPITAL LETTER DEE",
    "10415": "DESERET CAPITAL LETTER CHEE",
    "10416": "DESERET CAPITAL LETTER JEE",
    "10417": "DESERET CAPITAL LETTER KAY",
    "10418": "DESERET CAPITAL LETTER GAY",
    "10419": "DESERET CAPITAL LETTER EF",
    "1041A": "DESERET CAPITAL LETTER VEE",
    "1041B": "DESERET CAPITAL LETTER ETH",
    "1041C": "DESERET CAPITAL LETTER THEE",
    "1041D": "DESERET CAPITAL LETTER ES",
    "1041E": "DESERET CAPITAL LETTER ZEE",
    "1041F": "DESERET CAPITAL LETTER ESH",
    "10420": "DESERET CAPITAL LETTER ZHEE",
    "10421": "DESERET CAPITAL LETTER ER",
    "10422": "DESERET CAPITAL LETTER EL",
    "10423": "DESERET CAPITAL LETTER EM",
    "10424": "DESERET CAPITAL LETTER EN",
    "10425": "DESERET CAPITAL LETTER ENG",
    "10426": "DESERET CAPITAL LETTER OI",
    "10427": "DESERET CAPITAL LETTER EW",
    "10428": "DESERET SMALL LETTER LONG I",
    "10429": "DESERET SMALL LETTER LONG E",
    "1042A": "DESERET SMALL LETTER LONG A",
    "1042B": "DESERET SMALL LETTER LONG AH",
    "1042C": "DESERET SMALL LETTER LONG O",
    "1042D": "DESERET SMALL LETTER LONG OO",
    "1042E": "DESERET SMALL LETTER SHORT I",
    "1042F": "DESERET SMALL LETTER SHORT E",
    "10430": "DESERET SMALL LETTER SHORT A",
    "10431": "DESERET SMALL LETTER SHORT AH",
    "10432": "DESERET SMALL LETTER SHORT O",
    "10433": "DESERET SMALL LETTER SHORT OO",
    "10434": "DESERET SMALL LETTER AY",
    "10435": "DESERET SMALL LETTER OW",
    "10436": "DESERET SMALL LETTER WU",
    "10437": "DESERET SMALL LETTER YEE",
    "10438": "DESERET SMALL LETTER H",
    "10439": "DESERET SMALL LETTER PEE",
    "1043A": "DESERET SMALL LETTER BEE",
    "1043B": "DESERET SMALL LETTER TEE",
    "1043C": "DESERET SMALL LETTER DEE",
    "1043D": "DESERET SMALL LETTER CHEE",
    "1043E": "DESERET SMALL LETTER JEE",
    "1043F": "DESERET SMALL LETTER KAY",
    "10440": "DESERET SMALL LETTER GAY",
    "10441": "DESERET SMALL LETTER EF",
    "10442": "DESERET SMALL LETTER VEE",
    "10443": "DESERET SMALL LETTER ETH",
    "10444": "DESERET SMALL LETTER THEE",
    "10445": "DESERET SMALL LETTER ES",
    "10446": "DESERET SMALL LETTER ZEE",
    "10447": "DESERET SMALL LETTER ESH",
    "10448": "DESERET SMALL LETTER ZHEE",
    "10449": "DESERET SMALL LETTER ER",
    "1044A": "DESERET SMALL LETTER EL",
    "1044B": "DESERET SMALL LETTER EM",
    "1044C": "DESERET SMALL LETTER EN",
    "1044D": "DESERET SMALL LETTER ENG",
    "1044E": "DESERET SMALL LETTER OI",
    "1044F": "DESERET SMALL LETTER EW",
    "10450": "SHAVIAN LETTER PEEP",
    "10451": "SHAVIAN LETTER TOT",
    "10452": "SHAVIAN LETTER KICK",
    "10453": "SHAVIAN LETTER FEE",
    "10454": "SHAVIAN LETTER THIGH",
    "10455": "SHAVIAN LETTER SO",
    "10456": "SHAVIAN LETTER SURE",
    "10457": "SHAVIAN LETTER CHURCH",
    "10458": "SHAVIAN LETTER YEA",
    "10459": "SHAVIAN LETTER HUNG",
    "1045A": "SHAVIAN LETTER BIB",
    "1045B": "SHAVIAN LETTER DEAD",
    "1045C": "SHAVIAN LETTER GAG",
    "1045D": "SHAVIAN LETTER VOW",
    "1045E": "SHAVIAN LETTER THEY",
    "1045F": "SHAVIAN LETTER ZOO",
    "10460": "SHAVIAN LETTER MEASURE",
    "10461": "SHAVIAN LETTER JUDGE",
    "10462": "SHAVIAN LETTER WOE",
    "10463": "SHAVIAN LETTER HA-HA",
    "10464": "SHAVIAN LETTER LOLL",
    "10465": "SHAVIAN LETTER MIME",
    "10466": "SHAVIAN LETTER IF",
    "10467": "SHAVIAN LETTER EGG",
    "10468": "SHAVIAN LETTER ASH",
    "10469": "SHAVIAN LETTER ADO",
    "1046A": "SHAVIAN LETTER ON",
    "1046B": "SHAVIAN LETTER WOOL",
    "1046C": "SHAVIAN LETTER OUT",
    "1046D": "SHAVIAN LETTER AH",
    "1046E": "SHAVIAN LETTER ROAR",
    "1046F": "SHAVIAN LETTER NUN",
    "10470": "SHAVIAN LETTER EAT",
    "10471": "SHAVIAN LETTER AGE",
    "10472": "SHAVIAN LETTER ICE",
    "10473": "SHAVIAN LETTER UP",
    "10474": "SHAVIAN LETTER OAK",
    "10475": "SHAVIAN LETTER OOZE",
    "10476": "SHAVIAN LETTER OIL",
    "10477": "SHAVIAN LETTER AWE",
    "10478": "SHAVIAN LETTER ARE",
    "10479": "SHAVIAN LETTER OR",
    "1047A": "SHAVIAN LETTER AIR",
    "1047B": "SHAVIAN LETTER ERR",
    "1047C": "SHAVIAN LETTER ARRAY",
    "1047D": "SHAVIAN LETTER EAR",
    "1047E": "SHAVIAN LETTER IAN",
    "1047F": "SHAVIAN LETTER YEW",
    "10480": "OSMANYA LETTER ALEF",
    "10481": "OSMANYA LETTER BA",
    "10482": "OSMANYA LETTER TA",
    "10483": "OSMANYA LETTER JA",
    "10484": "OSMANYA LETTER XA",
    "10485": "OSMANYA LETTER KHA",
    "10486": "OSMANYA LETTER DEEL",
    "10487": "OSMANYA LETTER RA",
    "10488": "OSMANYA LETTER SA",
    "10489": "OSMANYA LETTER SHIIN",
    "1048A": "OSMANYA LETTER DHA",
    "1048B": "OSMANYA LETTER CAYN",
    "1048C": "OSMANYA LETTER GA",
    "1048D": "OSMANYA LETTER FA",
    "1048E": "OSMANYA LETTER QAAF",
    "1048F": "OSMANYA LETTER KAAF",
    "10490": "OSMANYA LETTER LAAN",
    "10491": "OSMANYA LETTER MIIN",
    "10492": "OSMANYA LETTER NUUN",
    "10493": "OSMANYA LETTER WAW",
    "10494": "OSMANYA LETTER HA",
    "10495": "OSMANYA LETTER YA",
    "10496": "OSMANYA LETTER A",
    "10497": "OSMANYA LETTER E",
    "10498": "OSMANYA LETTER I",
    "10499": "OSMANYA LETTER O",
    "1049A": "OSMANYA LETTER U",
    "1049B": "OSMANYA LETTER AA",
    "1049C": "OSMANYA LETTER EE",
    "1049D": "OSMANYA LETTER OO",
    "104A0": "OSMANYA DIGIT ZERO",
    "104A1": "OSMANYA DIGIT ONE",
    "104A2": "OSMANYA DIGIT TWO",
    "104A3": "OSMANYA DIGIT THREE",
    "104A4": "OSMANYA DIGIT FOUR",
    "104A5": "OSMANYA DIGIT FIVE",
    "104A6": "OSMANYA DIGIT SIX",
    "104A7": "OSMANYA DIGIT SEVEN",
    "104A8": "OSMANYA DIGIT EIGHT",
    "104A9": "OSMANYA DIGIT NINE",
    "104B0": "OSAGE CAPITAL LETTER A",
    "104B1": "OSAGE CAPITAL LETTER AI",
    "104B2": "OSAGE CAPITAL LETTER AIN",
    "104B3": "OSAGE CAPITAL LETTER AH",
    "104B4": "OSAGE CAPITAL LETTER BRA",
    "104B5": "OSAGE CAPITAL LETTER CHA",
    "104B6": "OSAGE CAPITAL LETTER EHCHA",
    "104B7": "OSAGE CAPITAL LETTER E",
    "104B8": "OSAGE CAPITAL LETTER EIN",
    "104B9": "OSAGE CAPITAL LETTER HA",
    "104BA": "OSAGE CAPITAL LETTER HYA",
    "104BB": "OSAGE CAPITAL LETTER I",
    "104BC": "OSAGE CAPITAL LETTER KA",
    "104BD": "OSAGE CAPITAL LETTER EHKA",
    "104BE": "OSAGE CAPITAL LETTER KYA",
    "104BF": "OSAGE CAPITAL LETTER LA",
    "104C0": "OSAGE CAPITAL LETTER MA",
    "104C1": "OSAGE CAPITAL LETTER NA",
    "104C2": "OSAGE CAPITAL LETTER O",
    "104C3": "OSAGE CAPITAL LETTER OIN",
    "104C4": "OSAGE CAPITAL LETTER PA",
    "104C5": "OSAGE CAPITAL LETTER EHPA",
    "104C6": "OSAGE CAPITAL LETTER SA",
    "104C7": "OSAGE CAPITAL LETTER SHA",
    "104C8": "OSAGE CAPITAL LETTER TA",
    "104C9": "OSAGE CAPITAL LETTER EHTA",
    "104CA": "OSAGE CAPITAL LETTER TSA",
    "104CB": "OSAGE CAPITAL LETTER EHTSA",
    "104CC": "OSAGE CAPITAL LETTER TSHA",
    "104CD": "OSAGE CAPITAL LETTER DHA",
    "104CE": "OSAGE CAPITAL LETTER U",
    "104CF": "OSAGE CAPITAL LETTER WA",
    "104D0": "OSAGE CAPITAL LETTER KHA",
    "104D1": "OSAGE CAPITAL LETTER GHA",
    "104D2": "OSAGE CAPITAL LETTER ZA",
    "104D3": "OSAGE CAPITAL LETTER ZHA",
    "104D8": "OSAGE SMALL LETTER A",
    "104D9": "OSAGE SMALL LETTER AI",
    "104DA": "OSAGE SMALL LETTER AIN",
    "104DB": "OSAGE SMALL LETTER AH",
    "104DC": "OSAGE SMALL LETTER BRA",
    "104DD": "OSAGE SMALL LETTER CHA",
    "104DE": "OSAGE SMALL LETTER EHCHA",
    "104DF": "OSAGE SMALL LETTER E",
    "104E0": "OSAGE SMALL LETTER EIN",
    "104E1": "OSAGE SMALL LETTER HA",
    "104E2": "OSAGE SMALL LETTER HYA",
    "104E3": "OSAGE SMALL LETTER I",
    "104E4": "OSAGE SMALL LETTER KA",
    "104E5": "OSAGE SMALL LETTER EHKA",
    "104E6": "OSAGE SMALL LETTER KYA",
    "104E7": "OSAGE SMALL LETTER LA",
    "104E8": "OSAGE SMALL LETTER MA",
    "104E9": "OSAGE SMALL LETTER NA",
    "104EA": "OSAGE SMALL LETTER O",
    "104EB": "OSAGE SMALL LETTER OIN",
    "104EC": "OSAGE SMALL LETTER PA",
    "104ED": "OSAGE SMALL LETTER EHPA",
    "104EE": "OSAGE SMALL LETTER SA",
    "104EF": "OSAGE SMALL LETTER SHA",
    "104F0": "OSAGE SMALL LETTER TA",
    "104F1": "OSAGE SMALL LETTER EHTA",
    "104F2": "OSAGE SMALL LETTER TSA",
    "104F3": "OSAGE SMALL LETTER EHTSA",
    "104F4": "OSAGE SMALL LETTER TSHA",
    "104F5": "OSAGE SMALL LETTER DHA",
    "104F6": "OSAGE SMALL LETTER U",
    "104F7": "OSAGE SMALL LETTER WA",
    "104F8": "OSAGE SMALL LETTER KHA",
    "104F9": "OSAGE SMALL LETTER GHA",
    "104FA": "OSAGE SMALL LETTER ZA",
    "104FB": "OSAGE SMALL LETTER ZHA",
    "10500": "ELBASAN LETTER A",
    "10501": "ELBASAN LETTER BE",
    "10502": "ELBASAN LETTER CE",
    "10503": "ELBASAN LETTER CHE",
    "10504": "ELBASAN LETTER DE",
    "10505": "ELBASAN LETTER NDE",
    "10506": "ELBASAN LETTER DHE",
    "10507": "ELBASAN LETTER EI",
    "10508": "ELBASAN LETTER E",
    "10509": "ELBASAN LETTER FE",
    "1050A": "ELBASAN LETTER GE",
    "1050B": "ELBASAN LETTER GJE",
    "1050C": "ELBASAN LETTER HE",
    "1050D": "ELBASAN LETTER I",
    "1050E": "ELBASAN LETTER JE",
    "1050F": "ELBASAN LETTER KE",
    "10510": "ELBASAN LETTER LE",
    "10511": "ELBASAN LETTER LLE",
    "10512": "ELBASAN LETTER ME",
    "10513": "ELBASAN LETTER NE",
    "10514": "ELBASAN LETTER NA",
    "10515": "ELBASAN LETTER NJE",
    "10516": "ELBASAN LETTER O",
    "10517": "ELBASAN LETTER PE",
    "10518": "ELBASAN LETTER QE",
    "10519": "ELBASAN LETTER RE",
    "1051A": "ELBASAN LETTER RRE",
    "1051B": "ELBASAN LETTER SE",
    "1051C": "ELBASAN LETTER SHE",
    "1051D": "ELBASAN LETTER TE",
    "1051E": "ELBASAN LETTER THE",
    "1051F": "ELBASAN LETTER U",
    "10520": "ELBASAN LETTER VE",
    "10521": "ELBASAN LETTER XE",
    "10522": "ELBASAN LETTER Y",
    "10523": "ELBASAN LETTER ZE",
    "10524": "ELBASAN LETTER ZHE",
    "10525": "ELBASAN LETTER GHE",
    "10526": "ELBASAN LETTER GHAMMA",
    "10527": "ELBASAN LETTER KHE",
    "10530": "CAUCASIAN ALBANIAN LETTER ALT",
    "10531": "CAUCASIAN ALBANIAN LETTER BET",
    "10532": "CAUCASIAN ALBANIAN LETTER GIM",
    "10533": "CAUCASIAN ALBANIAN LETTER DAT",
    "10534": "CAUCASIAN ALBANIAN LETTER EB",
    "10535": "CAUCASIAN ALBANIAN LETTER ZARL",
    "10536": "CAUCASIAN ALBANIAN LETTER EYN",
    "10537": "CAUCASIAN ALBANIAN LETTER ZHIL",
    "10538": "CAUCASIAN ALBANIAN LETTER TAS",
    "10539": "CAUCASIAN ALBANIAN LETTER CHA",
    "1053A": "CAUCASIAN ALBANIAN LETTER YOWD",
    "1053B": "CAUCASIAN ALBANIAN LETTER ZHA",
    "1053C": "CAUCASIAN ALBANIAN LETTER IRB",
    "1053D": "CAUCASIAN ALBANIAN LETTER SHA",
    "1053E": "CAUCASIAN ALBANIAN LETTER LAN",
    "1053F": "CAUCASIAN ALBANIAN LETTER INYA",
    "10540": "CAUCASIAN ALBANIAN LETTER XEYN",
    "10541": "CAUCASIAN ALBANIAN LETTER DYAN",
    "10542": "CAUCASIAN ALBANIAN LETTER CAR",
    "10543": "CAUCASIAN ALBANIAN LETTER JHOX",
    "10544": "CAUCASIAN ALBANIAN LETTER KAR",
    "10545": "CAUCASIAN ALBANIAN LETTER LYIT",
    "10546": "CAUCASIAN ALBANIAN LETTER HEYT",
    "10547": "CAUCASIAN ALBANIAN LETTER QAY",
    "10548": "CAUCASIAN ALBANIAN LETTER AOR",
    "10549": "CAUCASIAN ALBANIAN LETTER CHOY",
    "1054A": "CAUCASIAN ALBANIAN LETTER CHI",
    "1054B": "CAUCASIAN ALBANIAN LETTER CYAY",
    "1054C": "CAUCASIAN ALBANIAN LETTER MAQ",
    "1054D": "CAUCASIAN ALBANIAN LETTER QAR",
    "1054E": "CAUCASIAN ALBANIAN LETTER NOWC",
    "1054F": "CAUCASIAN ALBANIAN LETTER DZYAY",
    "10550": "CAUCASIAN ALBANIAN LETTER SHAK",
    "10551": "CAUCASIAN ALBANIAN LETTER JAYN",
    "10552": "CAUCASIAN ALBANIAN LETTER ON",
    "10553": "CAUCASIAN ALBANIAN LETTER TYAY",
    "10554": "CAUCASIAN ALBANIAN LETTER FAM",
    "10555": "CAUCASIAN ALBANIAN LETTER DZAY",
    "10556": "CAUCASIAN ALBANIAN LETTER CHAT",
    "10557": "CAUCASIAN ALBANIAN LETTER PEN",
    "10558": "CAUCASIAN ALBANIAN LETTER GHEYS",
    "10559": "CAUCASIAN ALBANIAN LETTER RAT",
    "1055A": "CAUCASIAN ALBANIAN LETTER SEYK",
    "1055B": "CAUCASIAN ALBANIAN LETTER VEYZ",
    "1055C": "CAUCASIAN ALBANIAN LETTER TIWR",
    "1055D": "CAUCASIAN ALBANIAN LETTER SHOY",
    "1055E": "CAUCASIAN ALBANIAN LETTER IWN",
    "1055F": "CAUCASIAN ALBANIAN LETTER CYAW",
    "10560": "CAUCASIAN ALBANIAN LETTER CAYN",
    "10561": "CAUCASIAN ALBANIAN LETTER YAYD",
    "10562": "CAUCASIAN ALBANIAN LETTER PIWR",
    "10563": "CAUCASIAN ALBANIAN LETTER KIW",
    "1056F": "CAUCASIAN ALBANIAN CITATION MARK",
    "10600": "LINEAR A SIGN AB001",
    "10601": "LINEAR A SIGN AB002",
    "10602": "LINEAR A SIGN AB003",
    "10603": "LINEAR A SIGN AB004",
    "10604": "LINEAR A SIGN AB005",
    "10605": "LINEAR A SIGN AB006",
    "10606": "LINEAR A SIGN AB007",
    "10607": "LINEAR A SIGN AB008",
    "10608": "LINEAR A SIGN AB009",
    "10609": "LINEAR A SIGN AB010",
    "1060A": "LINEAR A SIGN AB011",
    "1060B": "LINEAR A SIGN AB013",
    "1060C": "LINEAR A SIGN AB016",
    "1060D": "LINEAR A SIGN AB017",
    "1060E": "LINEAR A SIGN AB020",
    "1060F": "LINEAR A SIGN AB021",
    "10610": "LINEAR A SIGN AB021F",
    "10611": "LINEAR A SIGN AB021M",
    "10612": "LINEAR A SIGN AB022",
    "10613": "LINEAR A SIGN AB022F",
    "10614": "LINEAR A SIGN AB022M",
    "10615": "LINEAR A SIGN AB023",
    "10616": "LINEAR A SIGN AB023M",
    "10617": "LINEAR A SIGN AB024",
    "10618": "LINEAR A SIGN AB026",
    "10619": "LINEAR A SIGN AB027",
    "1061A": "LINEAR A SIGN AB028",
    "1061B": "LINEAR A SIGN A028B",
    "1061C": "LINEAR A SIGN AB029",
    "1061D": "LINEAR A SIGN AB030",
    "1061E": "LINEAR A SIGN AB031",
    "1061F": "LINEAR A SIGN AB034",
    "10620": "LINEAR A SIGN AB037",
    "10621": "LINEAR A SIGN AB038",
    "10622": "LINEAR A SIGN AB039",
    "10623": "LINEAR A SIGN AB040",
    "10624": "LINEAR A SIGN AB041",
    "10625": "LINEAR A SIGN AB044",
    "10626": "LINEAR A SIGN AB045",
    "10627": "LINEAR A SIGN AB046",
    "10628": "LINEAR A SIGN AB047",
    "10629": "LINEAR A SIGN AB048",
    "1062A": "LINEAR A SIGN AB049",
    "1062B": "LINEAR A SIGN AB050",
    "1062C": "LINEAR A SIGN AB051",
    "1062D": "LINEAR A SIGN AB053",
    "1062E": "LINEAR A SIGN AB054",
    "1062F": "LINEAR A SIGN AB055",
    "10630": "LINEAR A SIGN AB056",
    "10631": "LINEAR A SIGN AB057",
    "10632": "LINEAR A SIGN AB058",
    "10633": "LINEAR A SIGN AB059",
    "10634": "LINEAR A SIGN AB060",
    "10635": "LINEAR A SIGN AB061",
    "10636": "LINEAR A SIGN AB065",
    "10637": "LINEAR A SIGN AB066",
    "10638": "LINEAR A SIGN AB067",
    "10639": "LINEAR A SIGN AB069",
    "1063A": "LINEAR A SIGN AB070",
    "1063B": "LINEAR A SIGN AB073",
    "1063C": "LINEAR A SIGN AB074",
    "1063D": "LINEAR A SIGN AB076",
    "1063E": "LINEAR A SIGN AB077",
    "1063F": "LINEAR A SIGN AB078",
    "10640": "LINEAR A SIGN AB079",
    "10641": "LINEAR A SIGN AB080",
    "10642": "LINEAR A SIGN AB081",
    "10643": "LINEAR A SIGN AB082",
    "10644": "LINEAR A SIGN AB085",
    "10645": "LINEAR A SIGN AB086",
    "10646": "LINEAR A SIGN AB087",
    "10647": "LINEAR A SIGN A100-102",
    "10648": "LINEAR A SIGN AB118",
    "10649": "LINEAR A SIGN AB120",
    "1064A": "LINEAR A SIGN A120B",
    "1064B": "LINEAR A SIGN AB122",
    "1064C": "LINEAR A SIGN AB123",
    "1064D": "LINEAR A SIGN AB131A",
    "1064E": "LINEAR A SIGN AB131B",
    "1064F": "LINEAR A SIGN A131C",
    "10650": "LINEAR A SIGN AB164",
    "10651": "LINEAR A SIGN AB171",
    "10652": "LINEAR A SIGN AB180",
    "10653": "LINEAR A SIGN AB188",
    "10654": "LINEAR A SIGN AB191",
    "10655": "LINEAR A SIGN A301",
    "10656": "LINEAR A SIGN A302",
    "10657": "LINEAR A SIGN A303",
    "10658": "LINEAR A SIGN A304",
    "10659": "LINEAR A SIGN A305",
    "1065A": "LINEAR A SIGN A306",
    "1065B": "LINEAR A SIGN A307",
    "1065C": "LINEAR A SIGN A308",
    "1065D": "LINEAR A SIGN A309A",
    "1065E": "LINEAR A SIGN A309B",
    "1065F": "LINEAR A SIGN A309C",
    "10660": "LINEAR A SIGN A310",
    "10661": "LINEAR A SIGN A311",
    "10662": "LINEAR A SIGN A312",
    "10663": "LINEAR A SIGN A313A",
    "10664": "LINEAR A SIGN A313B",
    "10665": "LINEAR A SIGN A313C",
    "10666": "LINEAR A SIGN A314",
    "10667": "LINEAR A SIGN A315",
    "10668": "LINEAR A SIGN A316",
    "10669": "LINEAR A SIGN A317",
    "1066A": "LINEAR A SIGN A318",
    "1066B": "LINEAR A SIGN A319",
    "1066C": "LINEAR A SIGN A320",
    "1066D": "LINEAR A SIGN A321",
    "1066E": "LINEAR A SIGN A322",
    "1066F": "LINEAR A SIGN A323",
    "10670": "LINEAR A SIGN A324",
    "10671": "LINEAR A SIGN A325",
    "10672": "LINEAR A SIGN A326",
    "10673": "LINEAR A SIGN A327",
    "10674": "LINEAR A SIGN A328",
    "10675": "LINEAR A SIGN A329",
    "10676": "LINEAR A SIGN A330",
    "10677": "LINEAR A SIGN A331",
    "10678": "LINEAR A SIGN A332",
    "10679": "LINEAR A SIGN A333",
    "1067A": "LINEAR A SIGN A334",
    "1067B": "LINEAR A SIGN A335",
    "1067C": "LINEAR A SIGN A336",
    "1067D": "LINEAR A SIGN A337",
    "1067E": "LINEAR A SIGN A338",
    "1067F": "LINEAR A SIGN A339",
    "10680": "LINEAR A SIGN A340",
    "10681": "LINEAR A SIGN A341",
    "10682": "LINEAR A SIGN A342",
    "10683": "LINEAR A SIGN A343",
    "10684": "LINEAR A SIGN A344",
    "10685": "LINEAR A SIGN A345",
    "10686": "LINEAR A SIGN A346",
    "10687": "LINEAR A SIGN A347",
    "10688": "LINEAR A SIGN A348",
    "10689": "LINEAR A SIGN A349",
    "1068A": "LINEAR A SIGN A350",
    "1068B": "LINEAR A SIGN A351",
    "1068C": "LINEAR A SIGN A352",
    "1068D": "LINEAR A SIGN A353",
    "1068E": "LINEAR A SIGN A354",
    "1068F": "LINEAR A SIGN A355",
    "10690": "LINEAR A SIGN A356",
    "10691": "LINEAR A SIGN A357",
    "10692": "LINEAR A SIGN A358",
    "10693": "LINEAR A SIGN A359",
    "10694": "LINEAR A SIGN A360",
    "10695": "LINEAR A SIGN A361",
    "10696": "LINEAR A SIGN A362",
    "10697": "LINEAR A SIGN A363",
    "10698": "LINEAR A SIGN A364",
    "10699": "LINEAR A SIGN A365",
    "1069A": "LINEAR A SIGN A366",
    "1069B": "LINEAR A SIGN A367",
    "1069C": "LINEAR A SIGN A368",
    "1069D": "LINEAR A SIGN A369",
    "1069E": "LINEAR A SIGN A370",
    "1069F": "LINEAR A SIGN A371",
    "106A0": "LINEAR A SIGN A400-VAS",
    "106A1": "LINEAR A SIGN A401-VAS",
    "106A2": "LINEAR A SIGN A402-VAS",
    "106A3": "LINEAR A SIGN A403-VAS",
    "106A4": "LINEAR A SIGN A404-VAS",
    "106A5": "LINEAR A SIGN A405-VAS",
    "106A6": "LINEAR A SIGN A406-VAS",
    "106A7": "LINEAR A SIGN A407-VAS",
    "106A8": "LINEAR A SIGN A408-VAS",
    "106A9": "LINEAR A SIGN A409-VAS",
    "106AA": "LINEAR A SIGN A410-VAS",
    "106AB": "LINEAR A SIGN A411-VAS",
    "106AC": "LINEAR A SIGN A412-VAS",
    "106AD": "LINEAR A SIGN A413-VAS",
    "106AE": "LINEAR A SIGN A414-VAS",
    "106AF": "LINEAR A SIGN A415-VAS",
    "106B0": "LINEAR A SIGN A416-VAS",
    "106B1": "LINEAR A SIGN A417-VAS",
    "106B2": "LINEAR A SIGN A418-VAS",
    "106B3": "LINEAR A SIGN A501",
    "106B4": "LINEAR A SIGN A502",
    "106B5": "LINEAR A SIGN A503",
    "106B6": "LINEAR A SIGN A504",
    "106B7": "LINEAR A SIGN A505",
    "106B8": "LINEAR A SIGN A506",
    "106B9": "LINEAR A SIGN A508",
    "106BA": "LINEAR A SIGN A509",
    "106BB": "LINEAR A SIGN A510",
    "106BC": "LINEAR A SIGN A511",
    "106BD": "LINEAR A SIGN A512",
    "106BE": "LINEAR A SIGN A513",
    "106BF": "LINEAR A SIGN A515",
    "106C0": "LINEAR A SIGN A516",
    "106C1": "LINEAR A SIGN A520",
    "106C2": "LINEAR A SIGN A521",
    "106C3": "LINEAR A SIGN A523",
    "106C4": "LINEAR A SIGN A524",
    "106C5": "LINEAR A SIGN A525",
    "106C6": "LINEAR A SIGN A526",
    "106C7": "LINEAR A SIGN A527",
    "106C8": "LINEAR A SIGN A528",
    "106C9": "LINEAR A SIGN A529",
    "106CA": "LINEAR A SIGN A530",
    "106CB": "LINEAR A SIGN A531",
    "106CC": "LINEAR A SIGN A532",
    "106CD": "LINEAR A SIGN A534",
    "106CE": "LINEAR A SIGN A535",
    "106CF": "LINEAR A SIGN A536",
    "106D0": "LINEAR A SIGN A537",
    "106D1": "LINEAR A SIGN A538",
    "106D2": "LINEAR A SIGN A539",
    "106D3": "LINEAR A SIGN A540",
    "106D4": "LINEAR A SIGN A541",
    "106D5": "LINEAR A SIGN A542",
    "106D6": "LINEAR A SIGN A545",
    "106D7": "LINEAR A SIGN A547",
    "106D8": "LINEAR A SIGN A548",
    "106D9": "LINEAR A SIGN A549",
    "106DA": "LINEAR A SIGN A550",
    "106DB": "LINEAR A SIGN A551",
    "106DC": "LINEAR A SIGN A552",
    "106DD": "LINEAR A SIGN A553",
    "106DE": "LINEAR A SIGN A554",
    "106DF": "LINEAR A SIGN A555",
    "106E0": "LINEAR A SIGN A556",
    "106E1": "LINEAR A SIGN A557",
    "106E2": "LINEAR A SIGN A559",
    "106E3": "LINEAR A SIGN A563",
    "106E4": "LINEAR A SIGN A564",
    "106E5": "LINEAR A SIGN A565",
    "106E6": "LINEAR A SIGN A566",
    "106E7": "LINEAR A SIGN A568",
    "106E8": "LINEAR A SIGN A569",
    "106E9": "LINEAR A SIGN A570",
    "106EA": "LINEAR A SIGN A571",
    "106EB": "LINEAR A SIGN A572",
    "106EC": "LINEAR A SIGN A573",
    "106ED": "LINEAR A SIGN A574",
    "106EE": "LINEAR A SIGN A575",
    "106EF": "LINEAR A SIGN A576",
    "106F0": "LINEAR A SIGN A577",
    "106F1": "LINEAR A SIGN A578",
    "106F2": "LINEAR A SIGN A579",
    "106F3": "LINEAR A SIGN A580",
    "106F4": "LINEAR A SIGN A581",
    "106F5": "LINEAR A SIGN A582",
    "106F6": "LINEAR A SIGN A583",
    "106F7": "LINEAR A SIGN A584",
    "106F8": "LINEAR A SIGN A585",
    "106F9": "LINEAR A SIGN A586",
    "106FA": "LINEAR A SIGN A587",
    "106FB": "LINEAR A SIGN A588",
    "106FC": "LINEAR A SIGN A589",
    "106FD": "LINEAR A SIGN A591",
    "106FE": "LINEAR A SIGN A592",
    "106FF": "LINEAR A SIGN A594",
    "10700": "LINEAR A SIGN A595",
    "10701": "LINEAR A SIGN A596",
    "10702": "LINEAR A SIGN A598",
    "10703": "LINEAR A SIGN A600",
    "10704": "LINEAR A SIGN A601",
    "10705": "LINEAR A SIGN A602",
    "10706": "LINEAR A SIGN A603",
    "10707": "LINEAR A SIGN A604",
    "10708": "LINEAR A SIGN A606",
    "10709": "LINEAR A SIGN A608",
    "1070A": "LINEAR A SIGN A609",
    "1070B": "LINEAR A SIGN A610",
    "1070C": "LINEAR A SIGN A611",
    "1070D": "LINEAR A SIGN A612",
    "1070E": "LINEAR A SIGN A613",
    "1070F": "LINEAR A SIGN A614",
    "10710": "LINEAR A SIGN A615",
    "10711": "LINEAR A SIGN A616",
    "10712": "LINEAR A SIGN A617",
    "10713": "LINEAR A SIGN A618",
    "10714": "LINEAR A SIGN A619",
    "10715": "LINEAR A SIGN A620",
    "10716": "LINEAR A SIGN A621",
    "10717": "LINEAR A SIGN A622",
    "10718": "LINEAR A SIGN A623",
    "10719": "LINEAR A SIGN A624",
    "1071A": "LINEAR A SIGN A626",
    "1071B": "LINEAR A SIGN A627",
    "1071C": "LINEAR A SIGN A628",
    "1071D": "LINEAR A SIGN A629",
    "1071E": "LINEAR A SIGN A634",
    "1071F": "LINEAR A SIGN A637",
    "10720": "LINEAR A SIGN A638",
    "10721": "LINEAR A SIGN A640",
    "10722": "LINEAR A SIGN A642",
    "10723": "LINEAR A SIGN A643",
    "10724": "LINEAR A SIGN A644",
    "10725": "LINEAR A SIGN A645",
    "10726": "LINEAR A SIGN A646",
    "10727": "LINEAR A SIGN A648",
    "10728": "LINEAR A SIGN A649",
    "10729": "LINEAR A SIGN A651",
    "1072A": "LINEAR A SIGN A652",
    "1072B": "LINEAR A SIGN A653",
    "1072C": "LINEAR A SIGN A654",
    "1072D": "LINEAR A SIGN A655",
    "1072E": "LINEAR A SIGN A656",
    "1072F": "LINEAR A SIGN A657",
    "10730": "LINEAR A SIGN A658",
    "10731": "LINEAR A SIGN A659",
    "10732": "LINEAR A SIGN A660",
    "10733": "LINEAR A SIGN A661",
    "10734": "LINEAR A SIGN A662",
    "10735": "LINEAR A SIGN A663",
    "10736": "LINEAR A SIGN A664",
    "10740": "LINEAR A SIGN A701 A",
    "10741": "LINEAR A SIGN A702 B",
    "10742": "LINEAR A SIGN A703 D",
    "10743": "LINEAR A SIGN A704 E",
    "10744": "LINEAR A SIGN A705 F",
    "10745": "LINEAR A SIGN A706 H",
    "10746": "LINEAR A SIGN A707 J",
    "10747": "LINEAR A SIGN A708 K",
    "10748": "LINEAR A SIGN A709 L",
    "10749": "LINEAR A SIGN A709-2 L2",
    "1074A": "LINEAR A SIGN A709-3 L3",
    "1074B": "LINEAR A SIGN A709-4 L4",
    "1074C": "LINEAR A SIGN A709-6 L6",
    "1074D": "LINEAR A SIGN A710 W",
    "1074E": "LINEAR A SIGN A711 X",
    "1074F": "LINEAR A SIGN A712 Y",
    "10750": "LINEAR A SIGN A713 OMEGA",
    "10751": "LINEAR A SIGN A714 ABB",
    "10752": "LINEAR A SIGN A715 BB",
    "10753": "LINEAR A SIGN A717 DD",
    "10754": "LINEAR A SIGN A726 EYYY",
    "10755": "LINEAR A SIGN A732 JE",
    "10760": "LINEAR A SIGN A800",
    "10761": "LINEAR A SIGN A801",
    "10762": "LINEAR A SIGN A802",
    "10763": "LINEAR A SIGN A803",
    "10764": "LINEAR A SIGN A804",
    "10765": "LINEAR A SIGN A805",
    "10766": "LINEAR A SIGN A806",
    "10767": "LINEAR A SIGN A807",
    "10800": "CYPRIOT SYLLABLE A",
    "10801": "CYPRIOT SYLLABLE E",
    "10802": "CYPRIOT SYLLABLE I",
    "10803": "CYPRIOT SYLLABLE O",
    "10804": "CYPRIOT SYLLABLE U",
    "10805": "CYPRIOT SYLLABLE JA",
    "10808": "CYPRIOT SYLLABLE JO",
    "1080A": "CYPRIOT SYLLABLE KA",
    "1080B": "CYPRIOT SYLLABLE KE",
    "1080C": "CYPRIOT SYLLABLE KI",
    "1080D": "CYPRIOT SYLLABLE KO",
    "1080E": "CYPRIOT SYLLABLE KU",
    "1080F": "CYPRIOT SYLLABLE LA",
    "10810": "CYPRIOT SYLLABLE LE",
    "10811": "CYPRIOT SYLLABLE LI",
    "10812": "CYPRIOT SYLLABLE LO",
    "10813": "CYPRIOT SYLLABLE LU",
    "10814": "CYPRIOT SYLLABLE MA",
    "10815": "CYPRIOT SYLLABLE ME",
    "10816": "CYPRIOT SYLLABLE MI",
    "10817": "CYPRIOT SYLLABLE MO",
    "10818": "CYPRIOT SYLLABLE MU",
    "10819": "CYPRIOT SYLLABLE NA",
    "1081A": "CYPRIOT SYLLABLE NE",
    "1081B": "CYPRIOT SYLLABLE NI",
    "1081C": "CYPRIOT SYLLABLE NO",
    "1081D": "CYPRIOT SYLLABLE NU",
    "1081E": "CYPRIOT SYLLABLE PA",
    "1081F": "CYPRIOT SYLLABLE PE",
    "10820": "CYPRIOT SYLLABLE PI",
    "10821": "CYPRIOT SYLLABLE PO",
    "10822": "CYPRIOT SYLLABLE PU",
    "10823": "CYPRIOT SYLLABLE RA",
    "10824": "CYPRIOT SYLLABLE RE",
    "10825": "CYPRIOT SYLLABLE RI",
    "10826": "CYPRIOT SYLLABLE RO",
    "10827": "CYPRIOT SYLLABLE RU",
    "10828": "CYPRIOT SYLLABLE SA",
    "10829": "CYPRIOT SYLLABLE SE",
    "1082A": "CYPRIOT SYLLABLE SI",
    "1082B": "CYPRIOT SYLLABLE SO",
    "1082C": "CYPRIOT SYLLABLE SU",
    "1082D": "CYPRIOT SYLLABLE TA",
    "1082E": "CYPRIOT SYLLABLE TE",
    "1082F": "CYPRIOT SYLLABLE TI",
    "10830": "CYPRIOT SYLLABLE TO",
    "10831": "CYPRIOT SYLLABLE TU",
    "10832": "CYPRIOT SYLLABLE WA",
    "10833": "CYPRIOT SYLLABLE WE",
    "10834": "CYPRIOT SYLLABLE WI",
    "10835": "CYPRIOT SYLLABLE WO",
    "10837": "CYPRIOT SYLLABLE XA",
    "10838": "CYPRIOT SYLLABLE XE",
    "1083C": "CYPRIOT SYLLABLE ZA",
    "1083F": "CYPRIOT SYLLABLE ZO",
    "10840": "IMPERIAL ARAMAIC LETTER ALEPH",
    "10841": "IMPERIAL ARAMAIC LETTER BETH",
    "10842": "IMPERIAL ARAMAIC LETTER GIMEL",
    "10843": "IMPERIAL ARAMAIC LETTER DALETH",
    "10844": "IMPERIAL ARAMAIC LETTER HE",
    "10845": "IMPERIAL ARAMAIC LETTER WAW",
    "10846": "IMPERIAL ARAMAIC LETTER ZAYIN",
    "10847": "IMPERIAL ARAMAIC LETTER HETH",
    "10848": "IMPERIAL ARAMAIC LETTER TETH",
    "10849": "IMPERIAL ARAMAIC LETTER YODH",
    "1084A": "IMPERIAL ARAMAIC LETTER KAPH",
    "1084B": "IMPERIAL ARAMAIC LETTER LAMEDH",
    "1084C": "IMPERIAL ARAMAIC LETTER MEM",
    "1084D": "IMPERIAL ARAMAIC LETTER NUN",
    "1084E": "IMPERIAL ARAMAIC LETTER SAMEKH",
    "1084F": "IMPERIAL ARAMAIC LETTER AYIN",
    "10850": "IMPERIAL ARAMAIC LETTER PE",
    "10851": "IMPERIAL ARAMAIC LETTER SADHE",
    "10852": "IMPERIAL ARAMAIC LETTER QOPH",
    "10853": "IMPERIAL ARAMAIC LETTER RESH",
    "10854": "IMPERIAL ARAMAIC LETTER SHIN",
    "10855": "IMPERIAL ARAMAIC LETTER TAW",
    "10857": "IMPERIAL ARAMAIC SECTION SIGN",
    "10858": "IMPERIAL ARAMAIC NUMBER ONE",
    "10859": "IMPERIAL ARAMAIC NUMBER TWO",
    "1085A": "IMPERIAL ARAMAIC NUMBER THREE",
    "1085B": "IMPERIAL ARAMAIC NUMBER TEN",
    "1085C": "IMPERIAL ARAMAIC NUMBER TWENTY",
    "1085D": "IMPERIAL ARAMAIC NUMBER ONE HUNDRED",
    "1085E": "IMPERIAL ARAMAIC NUMBER ONE THOUSAND",
    "1085F": "IMPERIAL ARAMAIC NUMBER TEN THOUSAND",
    "10860": "PALMYRENE LETTER ALEPH",
    "10861": "PALMYRENE LETTER BETH",
    "10862": "PALMYRENE LETTER GIMEL",
    "10863": "PALMYRENE LETTER DALETH",
    "10864": "PALMYRENE LETTER HE",
    "10865": "PALMYRENE LETTER WAW",
    "10866": "PALMYRENE LETTER ZAYIN",
    "10867": "PALMYRENE LETTER HETH",
    "10868": "PALMYRENE LETTER TETH",
    "10869": "PALMYRENE LETTER YODH",
    "1086A": "PALMYRENE LETTER KAPH",
    "1086B": "PALMYRENE LETTER LAMEDH",
    "1086C": "PALMYRENE LETTER MEM",
    "1086D": "PALMYRENE LETTER FINAL NUN",
    "1086E": "PALMYRENE LETTER NUN",
    "1086F": "PALMYRENE LETTER SAMEKH",
    "10870": "PALMYRENE LETTER AYIN",
    "10871": "PALMYRENE LETTER PE",
    "10872": "PALMYRENE LETTER SADHE",
    "10873": "PALMYRENE LETTER QOPH",
    "10874": "PALMYRENE LETTER RESH",
    "10875": "PALMYRENE LETTER SHIN",
    "10876": "PALMYRENE LETTER TAW",
    "10877": "PALMYRENE LEFT-POINTING FLEURON",
    "10878": "PALMYRENE RIGHT-POINTING FLEURON",
    "10879": "PALMYRENE NUMBER ONE",
    "1087A": "PALMYRENE NUMBER TWO",
    "1087B": "PALMYRENE NUMBER THREE",
    "1087C": "PALMYRENE NUMBER FOUR",
    "1087D": "PALMYRENE NUMBER FIVE",
    "1087E": "PALMYRENE NUMBER TEN",
    "1087F": "PALMYRENE NUMBER TWENTY",
    "10880": "NABATAEAN LETTER FINAL ALEPH",
    "10881": "NABATAEAN LETTER ALEPH",
    "10882": "NABATAEAN LETTER FINAL BETH",
    "10883": "NABATAEAN LETTER BETH",
    "10884": "NABATAEAN LETTER GIMEL",
    "10885": "NABATAEAN LETTER DALETH",
    "10886": "NABATAEAN LETTER FINAL HE",
    "10887": "NABATAEAN LETTER HE",
    "10888": "NABATAEAN LETTER WAW",
    "10889": "NABATAEAN LETTER ZAYIN",
    "1088A": "NABATAEAN LETTER HETH",
    "1088B": "NABATAEAN LETTER TETH",
    "1088C": "NABATAEAN LETTER FINAL YODH",
    "1088D": "NABATAEAN LETTER YODH",
    "1088E": "NABATAEAN LETTER FINAL KAPH",
    "1088F": "NABATAEAN LETTER KAPH",
    "10890": "NABATAEAN LETTER FINAL LAMEDH",
    "10891": "NABATAEAN LETTER LAMEDH",
    "10892": "NABATAEAN LETTER FINAL MEM",
    "10893": "NABATAEAN LETTER MEM",
    "10894": "NABATAEAN LETTER FINAL NUN",
    "10895": "NABATAEAN LETTER NUN",
    "10896": "NABATAEAN LETTER SAMEKH",
    "10897": "NABATAEAN LETTER AYIN",
    "10898": "NABATAEAN LETTER PE",
    "10899": "NABATAEAN LETTER SADHE",
    "1089A": "NABATAEAN LETTER QOPH",
    "1089B": "NABATAEAN LETTER RESH",
    "1089C": "NABATAEAN LETTER FINAL SHIN",
    "1089D": "NABATAEAN LETTER SHIN",
    "1089E": "NABATAEAN LETTER TAW",
    "108A7": "NABATAEAN NUMBER ONE",
    "108A8": "NABATAEAN NUMBER TWO",
    "108A9": "NABATAEAN NUMBER THREE",
    "108AA": "NABATAEAN NUMBER FOUR",
    "108AB": "NABATAEAN CRUCIFORM NUMBER FOUR",
    "108AC": "NABATAEAN NUMBER FIVE",
    "108AD": "NABATAEAN NUMBER TEN",
    "108AE": "NABATAEAN NUMBER TWENTY",
    "108AF": "NABATAEAN NUMBER ONE HUNDRED",
    "108E0": "HATRAN LETTER ALEPH",
    "108E1": "HATRAN LETTER BETH",
    "108E2": "HATRAN LETTER GIMEL",
    "108E3": "HATRAN LETTER DALETH-RESH",
    "108E4": "HATRAN LETTER HE",
    "108E5": "HATRAN LETTER WAW",
    "108E6": "HATRAN LETTER ZAYN",
    "108E7": "HATRAN LETTER HETH",
    "108E8": "HATRAN LETTER TETH",
    "108E9": "HATRAN LETTER YODH",
    "108EA": "HATRAN LETTER KAPH",
    "108EB": "HATRAN LETTER LAMEDH",
    "108EC": "HATRAN LETTER MEM",
    "108ED": "HATRAN LETTER NUN",
    "108EE": "HATRAN LETTER SAMEKH",
    "108EF": "HATRAN LETTER AYN",
    "108F0": "HATRAN LETTER PE",
    "108F1": "HATRAN LETTER SADHE",
    "108F2": "HATRAN LETTER QOPH",
    "108F4": "HATRAN LETTER SHIN",
    "108F5": "HATRAN LETTER TAW",
    "108FB": "HATRAN NUMBER ONE",
    "108FC": "HATRAN NUMBER FIVE",
    "108FD": "HATRAN NUMBER TEN",
    "108FE": "HATRAN NUMBER TWENTY",
    "108FF": "HATRAN NUMBER ONE HUNDRED",
    "10900": "PHOENICIAN LETTER ALF",
    "10901": "PHOENICIAN LETTER BET",
    "10902": "PHOENICIAN LETTER GAML",
    "10903": "PHOENICIAN LETTER DELT",
    "10904": "PHOENICIAN LETTER HE",
    "10905": "PHOENICIAN LETTER WAU",
    "10906": "PHOENICIAN LETTER ZAI",
    "10907": "PHOENICIAN LETTER HET",
    "10908": "PHOENICIAN LETTER TET",
    "10909": "PHOENICIAN LETTER YOD",
    "1090A": "PHOENICIAN LETTER KAF",
    "1090B": "PHOENICIAN LETTER LAMD",
    "1090C": "PHOENICIAN LETTER MEM",
    "1090D": "PHOENICIAN LETTER NUN",
    "1090E": "PHOENICIAN LETTER SEMK",
    "1090F": "PHOENICIAN LETTER AIN",
    "10910": "PHOENICIAN LETTER PE",
    "10911": "PHOENICIAN LETTER SADE",
    "10912": "PHOENICIAN LETTER QOF",
    "10913": "PHOENICIAN LETTER ROSH",
    "10914": "PHOENICIAN LETTER SHIN",
    "10915": "PHOENICIAN LETTER TAU",
    "10916": "PHOENICIAN NUMBER ONE",
    "10917": "PHOENICIAN NUMBER TEN",
    "10918": "PHOENICIAN NUMBER TWENTY",
    "10919": "PHOENICIAN NUMBER ONE HUNDRED",
    "1091A": "PHOENICIAN NUMBER TWO",
    "1091B": "PHOENICIAN NUMBER THREE",
    "1091F": "PHOENICIAN WORD SEPARATOR",
    "10920": "LYDIAN LETTER A",
    "10921": "LYDIAN LETTER B",
    "10922": "LYDIAN LETTER G",
    "10923": "LYDIAN LETTER D",
    "10924": "LYDIAN LETTER E",
    "10925": "LYDIAN LETTER V",
    "10926": "LYDIAN LETTER I",
    "10927": "LYDIAN LETTER Y",
    "10928": "LYDIAN LETTER K",
    "10929": "LYDIAN LETTER L",
    "1092A": "LYDIAN LETTER M",
    "1092B": "LYDIAN LETTER N",
    "1092C": "LYDIAN LETTER O",
    "1092D": "LYDIAN LETTER R",
    "1092E": "LYDIAN LETTER SS",
    "1092F": "LYDIAN LETTER T",
    "10930": "LYDIAN LETTER U",
    "10931": "LYDIAN LETTER F",
    "10932": "LYDIAN LETTER Q",
    "10933": "LYDIAN LETTER S",
    "10934": "LYDIAN LETTER TT",
    "10935": "LYDIAN LETTER AN",
    "10936": "LYDIAN LETTER EN",
    "10937": "LYDIAN LETTER LY",
    "10938": "LYDIAN LETTER NN",
    "10939": "LYDIAN LETTER C",
    "1093F": "LYDIAN TRIANGULAR MARK",
    "10980": "MEROITIC HIEROGLYPHIC LETTER A",
    "10981": "MEROITIC HIEROGLYPHIC LETTER E",
    "10982": "MEROITIC HIEROGLYPHIC LETTER I",
    "10983": "MEROITIC HIEROGLYPHIC LETTER O",
    "10984": "MEROITIC HIEROGLYPHIC LETTER YA",
    "10985": "MEROITIC HIEROGLYPHIC LETTER WA",
    "10986": "MEROITIC HIEROGLYPHIC LETTER BA",
    "10987": "MEROITIC HIEROGLYPHIC LETTER BA-2",
    "10988": "MEROITIC HIEROGLYPHIC LETTER PA",
    "10989": "MEROITIC HIEROGLYPHIC LETTER MA",
    "1098A": "MEROITIC HIEROGLYPHIC LETTER NA",
    "1098B": "MEROITIC HIEROGLYPHIC LETTER NA-2",
    "1098C": "MEROITIC HIEROGLYPHIC LETTER NE",
    "1098D": "MEROITIC HIEROGLYPHIC LETTER NE-2",
    "1098E": "MEROITIC HIEROGLYPHIC LETTER RA",
    "1098F": "MEROITIC HIEROGLYPHIC LETTER RA-2",
    "10990": "MEROITIC HIEROGLYPHIC LETTER LA",
    "10991": "MEROITIC HIEROGLYPHIC LETTER KHA",
    "10992": "MEROITIC HIEROGLYPHIC LETTER HHA",
    "10993": "MEROITIC HIEROGLYPHIC LETTER SA",
    "10994": "MEROITIC HIEROGLYPHIC LETTER SA-2",
    "10995": "MEROITIC HIEROGLYPHIC LETTER SE",
    "10996": "MEROITIC HIEROGLYPHIC LETTER KA",
    "10997": "MEROITIC HIEROGLYPHIC LETTER QA",
    "10998": "MEROITIC HIEROGLYPHIC LETTER TA",
    "10999": "MEROITIC HIEROGLYPHIC LETTER TA-2",
    "1099A": "MEROITIC HIEROGLYPHIC LETTER TE",
    "1099B": "MEROITIC HIEROGLYPHIC LETTER TE-2",
    "1099C": "MEROITIC HIEROGLYPHIC LETTER TO",
    "1099D": "MEROITIC HIEROGLYPHIC LETTER DA",
    "1099E": "MEROITIC HIEROGLYPHIC SYMBOL VIDJ",
    "1099F": "MEROITIC HIEROGLYPHIC SYMBOL VIDJ-2",
    "109A0": "MEROITIC CURSIVE LETTER A",
    "109A1": "MEROITIC CURSIVE LETTER E",
    "109A2": "MEROITIC CURSIVE LETTER I",
    "109A3": "MEROITIC CURSIVE LETTER O",
    "109A4": "MEROITIC CURSIVE LETTER YA",
    "109A5": "MEROITIC CURSIVE LETTER WA",
    "109A6": "MEROITIC CURSIVE LETTER BA",
    "109A7": "MEROITIC CURSIVE LETTER PA",
    "109A8": "MEROITIC CURSIVE LETTER MA",
    "109A9": "MEROITIC CURSIVE LETTER NA",
    "109AA": "MEROITIC CURSIVE LETTER NE",
    "109AB": "MEROITIC CURSIVE LETTER RA",
    "109AC": "MEROITIC CURSIVE LETTER LA",
    "109AD": "MEROITIC CURSIVE LETTER KHA",
    "109AE": "MEROITIC CURSIVE LETTER HHA",
    "109AF": "MEROITIC CURSIVE LETTER SA",
    "109B0": "MEROITIC CURSIVE LETTER ARCHAIC SA",
    "109B1": "MEROITIC CURSIVE LETTER SE",
    "109B2": "MEROITIC CURSIVE LETTER KA",
    "109B3": "MEROITIC CURSIVE LETTER QA",
    "109B4": "MEROITIC CURSIVE LETTER TA",
    "109B5": "MEROITIC CURSIVE LETTER TE",
    "109B6": "MEROITIC CURSIVE LETTER TO",
    "109B7": "MEROITIC CURSIVE LETTER DA",
    "109BC": "MEROITIC CURSIVE FRACTION ELEVEN TWELFTHS",
    "109BD": "MEROITIC CURSIVE FRACTION ONE HALF",
    "109BE": "MEROITIC CURSIVE LOGOGRAM RMT",
    "109BF": "MEROITIC CURSIVE LOGOGRAM IMN",
    "109C0": "MEROITIC CURSIVE NUMBER ONE",
    "109C1": "MEROITIC CURSIVE NUMBER TWO",
    "109C2": "MEROITIC CURSIVE NUMBER THREE",
    "109C3": "MEROITIC CURSIVE NUMBER FOUR",
    "109C4": "MEROITIC CURSIVE NUMBER FIVE",
    "109C5": "MEROITIC CURSIVE NUMBER SIX",
    "109C6": "MEROITIC CURSIVE NUMBER SEVEN",
    "109C7": "MEROITIC CURSIVE NUMBER EIGHT",
    "109C8": "MEROITIC CURSIVE NUMBER NINE",
    "109C9": "MEROITIC CURSIVE NUMBER TEN",
    "109CA": "MEROITIC CURSIVE NUMBER TWENTY",
    "109CB": "MEROITIC CURSIVE NUMBER THIRTY",
    "109CC": "MEROITIC CURSIVE NUMBER FORTY",
    "109CD": "MEROITIC CURSIVE NUMBER FIFTY",
    "109CE": "MEROITIC CURSIVE NUMBER SIXTY",
    "109CF": "MEROITIC CURSIVE NUMBER SEVENTY",
    "109D2": "MEROITIC CURSIVE NUMBER ONE HUNDRED",
    "109D3": "MEROITIC CURSIVE NUMBER TWO HUNDRED",
    "109D4": "MEROITIC CURSIVE NUMBER THREE HUNDRED",
    "109D5": "MEROITIC CURSIVE NUMBER FOUR HUNDRED",
    "109D6": "MEROITIC CURSIVE NUMBER FIVE HUNDRED",
    "109D7": "MEROITIC CURSIVE NUMBER SIX HUNDRED",
    "109D8": "MEROITIC CURSIVE NUMBER SEVEN HUNDRED",
    "109D9": "MEROITIC CURSIVE NUMBER EIGHT HUNDRED",
    "109DA": "MEROITIC CURSIVE NUMBER NINE HUNDRED",
    "109DB": "MEROITIC CURSIVE NUMBER ONE THOUSAND",
    "109DC": "MEROITIC CURSIVE NUMBER TWO THOUSAND",
    "109DD": "MEROITIC CURSIVE NUMBER THREE THOUSAND",
    "109DE": "MEROITIC CURSIVE NUMBER FOUR THOUSAND",
    "109DF": "MEROITIC CURSIVE NUMBER FIVE THOUSAND",
    "109E0": "MEROITIC CURSIVE NUMBER SIX THOUSAND",
    "109E1": "MEROITIC CURSIVE NUMBER SEVEN THOUSAND",
    "109E2": "MEROITIC CURSIVE NUMBER EIGHT THOUSAND",
    "109E3": "MEROITIC CURSIVE NUMBER NINE THOUSAND",
    "109E4": "MEROITIC CURSIVE NUMBER TEN THOUSAND",
    "109E5": "MEROITIC CURSIVE NUMBER TWENTY THOUSAND",
    "109E6": "MEROITIC CURSIVE NUMBER THIRTY THOUSAND",
    "109E7": "MEROITIC CURSIVE NUMBER FORTY THOUSAND",
    "109E8": "MEROITIC CURSIVE NUMBER FIFTY THOUSAND",
    "109E9": "MEROITIC CURSIVE NUMBER SIXTY THOUSAND",
    "109EA": "MEROITIC CURSIVE NUMBER SEVENTY THOUSAND",
    "109EB": "MEROITIC CURSIVE NUMBER EIGHTY THOUSAND",
    "109EC": "MEROITIC CURSIVE NUMBER NINETY THOUSAND",
    "109ED": "MEROITIC CURSIVE NUMBER ONE HUNDRED THOUSAND",
    "109EE": "MEROITIC CURSIVE NUMBER TWO HUNDRED THOUSAND",
    "109EF": "MEROITIC CURSIVE NUMBER THREE HUNDRED THOUSAND",
    "109F0": "MEROITIC CURSIVE NUMBER FOUR HUNDRED THOUSAND",
    "109F1": "MEROITIC CURSIVE NUMBER FIVE HUNDRED THOUSAND",
    "109F2": "MEROITIC CURSIVE NUMBER SIX HUNDRED THOUSAND",
    "109F3": "MEROITIC CURSIVE NUMBER SEVEN HUNDRED THOUSAND",
    "109F4": "MEROITIC CURSIVE NUMBER EIGHT HUNDRED THOUSAND",
    "109F5": "MEROITIC CURSIVE NUMBER NINE HUNDRED THOUSAND",
    "109F6": "MEROITIC CURSIVE FRACTION ONE TWELFTH",
    "109F7": "MEROITIC CURSIVE FRACTION TWO TWELFTHS",
    "109F8": "MEROITIC CURSIVE FRACTION THREE TWELFTHS",
    "109F9": "MEROITIC CURSIVE FRACTION FOUR TWELFTHS",
    "109FA": "MEROITIC CURSIVE FRACTION FIVE TWELFTHS",
    "109FB": "MEROITIC CURSIVE FRACTION SIX TWELFTHS",
    "109FC": "MEROITIC CURSIVE FRACTION SEVEN TWELFTHS",
    "109FD": "MEROITIC CURSIVE FRACTION EIGHT TWELFTHS",
    "109FE": "MEROITIC CURSIVE FRACTION NINE TWELFTHS",
    "109FF": "MEROITIC CURSIVE FRACTION TEN TWELFTHS",
    "10A00": "KHAROSHTHI LETTER A",
    "10A01": "KHAROSHTHI VOWEL SIGN I",
    "10A02": "KHAROSHTHI VOWEL SIGN U",
    "10A03": "KHAROSHTHI VOWEL SIGN VOCALIC R",
    "10A05": "KHAROSHTHI VOWEL SIGN E",
    "10A06": "KHAROSHTHI VOWEL SIGN O",
    "10A0C": "KHAROSHTHI VOWEL LENGTH MARK",
    "10A0D": "KHAROSHTHI SIGN DOUBLE RING BELOW",
    "10A0E": "KHAROSHTHI SIGN ANUSVARA",
    "10A0F": "KHAROSHTHI SIGN VISARGA",
    "10A10": "KHAROSHTHI LETTER KA",
    "10A11": "KHAROSHTHI LETTER KHA",
    "10A12": "KHAROSHTHI LETTER GA",
    "10A13": "KHAROSHTHI LETTER GHA",
    "10A15": "KHAROSHTHI LETTER CA",
    "10A16": "KHAROSHTHI LETTER CHA",
    "10A17": "KHAROSHTHI LETTER JA",
    "10A19": "KHAROSHTHI LETTER NYA",
    "10A1A": "KHAROSHTHI LETTER TTA",
    "10A1B": "KHAROSHTHI LETTER TTHA",
    "10A1C": "KHAROSHTHI LETTER DDA",
    "10A1D": "KHAROSHTHI LETTER DDHA",
    "10A1E": "KHAROSHTHI LETTER NNA",
    "10A1F": "KHAROSHTHI LETTER TA",
    "10A20": "KHAROSHTHI LETTER THA",
    "10A21": "KHAROSHTHI LETTER DA",
    "10A22": "KHAROSHTHI LETTER DHA",
    "10A23": "KHAROSHTHI LETTER NA",
    "10A24": "KHAROSHTHI LETTER PA",
    "10A25": "KHAROSHTHI LETTER PHA",
    "10A26": "KHAROSHTHI LETTER BA",
    "10A27": "KHAROSHTHI LETTER BHA",
    "10A28": "KHAROSHTHI LETTER MA",
    "10A29": "KHAROSHTHI LETTER YA",
    "10A2A": "KHAROSHTHI LETTER RA",
    "10A2B": "KHAROSHTHI LETTER LA",
    "10A2C": "KHAROSHTHI LETTER VA",
    "10A2D": "KHAROSHTHI LETTER SHA",
    "10A2E": "KHAROSHTHI LETTER SSA",
    "10A2F": "KHAROSHTHI LETTER SA",
    "10A30": "KHAROSHTHI LETTER ZA",
    "10A31": "KHAROSHTHI LETTER HA",
    "10A32": "KHAROSHTHI LETTER KKA",
    "10A33": "KHAROSHTHI LETTER TTTHA",
    "10A38": "KHAROSHTHI SIGN BAR ABOVE",
    "10A39": "KHAROSHTHI SIGN CAUDA",
    "10A3A": "KHAROSHTHI SIGN DOT BELOW",
    "10A3F": "KHAROSHTHI VIRAMA",
    "10A40": "KHAROSHTHI DIGIT ONE",
    "10A41": "KHAROSHTHI DIGIT TWO",
    "10A42": "KHAROSHTHI DIGIT THREE",
    "10A43": "KHAROSHTHI DIGIT FOUR",
    "10A44": "KHAROSHTHI NUMBER TEN",
    "10A45": "KHAROSHTHI NUMBER TWENTY",
    "10A46": "KHAROSHTHI NUMBER ONE HUNDRED",
    "10A47": "KHAROSHTHI NUMBER ONE THOUSAND",
    "10A50": "KHAROSHTHI PUNCTUATION DOT",
    "10A51": "KHAROSHTHI PUNCTUATION SMALL CIRCLE",
    "10A52": "KHAROSHTHI PUNCTUATION CIRCLE",
    "10A53": "KHAROSHTHI PUNCTUATION CRESCENT BAR",
    "10A54": "KHAROSHTHI PUNCTUATION MANGALAM",
    "10A55": "KHAROSHTHI PUNCTUATION LOTUS",
    "10A56": "KHAROSHTHI PUNCTUATION DANDA",
    "10A57": "KHAROSHTHI PUNCTUATION DOUBLE DANDA",
    "10A58": "KHAROSHTHI PUNCTUATION LINES",
    "10A60": "OLD SOUTH ARABIAN LETTER HE",
    "10A61": "OLD SOUTH ARABIAN LETTER LAMEDH",
    "10A62": "OLD SOUTH ARABIAN LETTER HETH",
    "10A63": "OLD SOUTH ARABIAN LETTER MEM",
    "10A64": "OLD SOUTH ARABIAN LETTER QOPH",
    "10A65": "OLD SOUTH ARABIAN LETTER WAW",
    "10A66": "OLD SOUTH ARABIAN LETTER SHIN",
    "10A67": "OLD SOUTH ARABIAN LETTER RESH",
    "10A68": "OLD SOUTH ARABIAN LETTER BETH",
    "10A69": "OLD SOUTH ARABIAN LETTER TAW",
    "10A6A": "OLD SOUTH ARABIAN LETTER SAT",
    "10A6B": "OLD SOUTH ARABIAN LETTER KAPH",
    "10A6C": "OLD SOUTH ARABIAN LETTER NUN",
    "10A6D": "OLD SOUTH ARABIAN LETTER KHETH",
    "10A6E": "OLD SOUTH ARABIAN LETTER SADHE",
    "10A6F": "OLD SOUTH ARABIAN LETTER SAMEKH",
    "10A70": "OLD SOUTH ARABIAN LETTER FE",
    "10A71": "OLD SOUTH ARABIAN LETTER ALEF",
    "10A72": "OLD SOUTH ARABIAN LETTER AYN",
    "10A73": "OLD SOUTH ARABIAN LETTER DHADHE",
    "10A74": "OLD SOUTH ARABIAN LETTER GIMEL",
    "10A75": "OLD SOUTH ARABIAN LETTER DALETH",
    "10A76": "OLD SOUTH ARABIAN LETTER GHAYN",
    "10A77": "OLD SOUTH ARABIAN LETTER TETH",
    "10A78": "OLD SOUTH ARABIAN LETTER ZAYN",
    "10A79": "OLD SOUTH ARABIAN LETTER DHALETH",
    "10A7A": "OLD SOUTH ARABIAN LETTER YODH",
    "10A7B": "OLD SOUTH ARABIAN LETTER THAW",
    "10A7C": "OLD SOUTH ARABIAN LETTER THETH",
    "10A7D": "OLD SOUTH ARABIAN NUMBER ONE",
    "10A7E": "OLD SOUTH ARABIAN NUMBER FIFTY",
    "10A7F": "OLD SOUTH ARABIAN NUMERIC INDICATOR",
    "10A80": "OLD NORTH ARABIAN LETTER HEH",
    "10A81": "OLD NORTH ARABIAN LETTER LAM",
    "10A82": "OLD NORTH ARABIAN LETTER HAH",
    "10A83": "OLD NORTH ARABIAN LETTER MEEM",
    "10A84": "OLD NORTH ARABIAN LETTER QAF",
    "10A85": "OLD NORTH ARABIAN LETTER WAW",
    "10A86": "OLD NORTH ARABIAN LETTER ES-2",
    "10A87": "OLD NORTH ARABIAN LETTER REH",
    "10A88": "OLD NORTH ARABIAN LETTER BEH",
    "10A89": "OLD NORTH ARABIAN LETTER TEH",
    "10A8A": "OLD NORTH ARABIAN LETTER ES-1",
    "10A8B": "OLD NORTH ARABIAN LETTER KAF",
    "10A8C": "OLD NORTH ARABIAN LETTER NOON",
    "10A8D": "OLD NORTH ARABIAN LETTER KHAH",
    "10A8E": "OLD NORTH ARABIAN LETTER SAD",
    "10A8F": "OLD NORTH ARABIAN LETTER ES-3",
    "10A90": "OLD NORTH ARABIAN LETTER FEH",
    "10A91": "OLD NORTH ARABIAN LETTER ALEF",
    "10A92": "OLD NORTH ARABIAN LETTER AIN",
    "10A93": "OLD NORTH ARABIAN LETTER DAD",
    "10A94": "OLD NORTH ARABIAN LETTER GEEM",
    "10A95": "OLD NORTH ARABIAN LETTER DAL",
    "10A96": "OLD NORTH ARABIAN LETTER GHAIN",
    "10A97": "OLD NORTH ARABIAN LETTER TAH",
    "10A98": "OLD NORTH ARABIAN LETTER ZAIN",
    "10A99": "OLD NORTH ARABIAN LETTER THAL",
    "10A9A": "OLD NORTH ARABIAN LETTER YEH",
    "10A9B": "OLD NORTH ARABIAN LETTER THEH",
    "10A9C": "OLD NORTH ARABIAN LETTER ZAH",
    "10A9D": "OLD NORTH ARABIAN NUMBER ONE",
    "10A9E": "OLD NORTH ARABIAN NUMBER TEN",
    "10A9F": "OLD NORTH ARABIAN NUMBER TWENTY",
    "10AC0": "MANICHAEAN LETTER ALEPH",
    "10AC1": "MANICHAEAN LETTER BETH",
    "10AC2": "MANICHAEAN LETTER BHETH",
    "10AC3": "MANICHAEAN LETTER GIMEL",
    "10AC4": "MANICHAEAN LETTER GHIMEL",
    "10AC5": "MANICHAEAN LETTER DALETH",
    "10AC6": "MANICHAEAN LETTER HE",
    "10AC7": "MANICHAEAN LETTER WAW",
    "10AC8": "MANICHAEAN SIGN UD",
    "10AC9": "MANICHAEAN LETTER ZAYIN",
    "10ACA": "MANICHAEAN LETTER ZHAYIN",
    "10ACB": "MANICHAEAN LETTER JAYIN",
    "10ACC": "MANICHAEAN LETTER JHAYIN",
    "10ACD": "MANICHAEAN LETTER HETH",
    "10ACE": "MANICHAEAN LETTER TETH",
    "10ACF": "MANICHAEAN LETTER YODH",
    "10AD0": "MANICHAEAN LETTER KAPH",
    "10AD1": "MANICHAEAN LETTER XAPH",
    "10AD2": "MANICHAEAN LETTER KHAPH",
    "10AD3": "MANICHAEAN LETTER LAMEDH",
    "10AD4": "MANICHAEAN LETTER DHAMEDH",
    "10AD5": "MANICHAEAN LETTER THAMEDH",
    "10AD6": "MANICHAEAN LETTER MEM",
    "10AD7": "MANICHAEAN LETTER NUN",
    "10AD8": "MANICHAEAN LETTER SAMEKH",
    "10AD9": "MANICHAEAN LETTER AYIN",
    "10ADA": "MANICHAEAN LETTER AAYIN",
    "10ADB": "MANICHAEAN LETTER PE",
    "10ADC": "MANICHAEAN LETTER FE",
    "10ADD": "MANICHAEAN LETTER SADHE",
    "10ADE": "MANICHAEAN LETTER QOPH",
    "10ADF": "MANICHAEAN LETTER XOPH",
    "10AE0": "MANICHAEAN LETTER QHOPH",
    "10AE1": "MANICHAEAN LETTER RESH",
    "10AE2": "MANICHAEAN LETTER SHIN",
    "10AE3": "MANICHAEAN LETTER SSHIN",
    "10AE4": "MANICHAEAN LETTER TAW",
    "10AE5": "MANICHAEAN ABBREVIATION MARK ABOVE",
    "10AE6": "MANICHAEAN ABBREVIATION MARK BELOW",
    "10AEB": "MANICHAEAN NUMBER ONE",
    "10AEC": "MANICHAEAN NUMBER FIVE",
    "10AED": "MANICHAEAN NUMBER TEN",
    "10AEE": "MANICHAEAN NUMBER TWENTY",
    "10AEF": "MANICHAEAN NUMBER ONE HUNDRED",
    "10AF0": "MANICHAEAN PUNCTUATION STAR",
    "10AF1": "MANICHAEAN PUNCTUATION FLEURON",
    "10AF2": "MANICHAEAN PUNCTUATION DOUBLE DOT WITHIN DOT",
    "10AF3": "MANICHAEAN PUNCTUATION DOT WITHIN DOT",
    "10AF4": "MANICHAEAN PUNCTUATION DOT",
    "10AF5": "MANICHAEAN PUNCTUATION TWO DOTS",
    "10AF6": "MANICHAEAN PUNCTUATION LINE FILLER",
    "10B00": "AVESTAN LETTER A",
    "10B01": "AVESTAN LETTER AA",
    "10B02": "AVESTAN LETTER AO",
    "10B03": "AVESTAN LETTER AAO",
    "10B04": "AVESTAN LETTER AN",
    "10B05": "AVESTAN LETTER AAN",
    "10B06": "AVESTAN LETTER AE",
    "10B07": "AVESTAN LETTER AEE",
    "10B08": "AVESTAN LETTER E",
    "10B09": "AVESTAN LETTER EE",
    "10B0A": "AVESTAN LETTER O",
    "10B0B": "AVESTAN LETTER OO",
    "10B0C": "AVESTAN LETTER I",
    "10B0D": "AVESTAN LETTER II",
    "10B0E": "AVESTAN LETTER U",
    "10B0F": "AVESTAN LETTER UU",
    "10B10": "AVESTAN LETTER KE",
    "10B11": "AVESTAN LETTER XE",
    "10B12": "AVESTAN LETTER XYE",
    "10B13": "AVESTAN LETTER XVE",
    "10B14": "AVESTAN LETTER GE",
    "10B15": "AVESTAN LETTER GGE",
    "10B16": "AVESTAN LETTER GHE",
    "10B17": "AVESTAN LETTER CE",
    "10B18": "AVESTAN LETTER JE",
    "10B19": "AVESTAN LETTER TE",
    "10B1A": "AVESTAN LETTER THE",
    "10B1B": "AVESTAN LETTER DE",
    "10B1C": "AVESTAN LETTER DHE",
    "10B1D": "AVESTAN LETTER TTE",
    "10B1E": "AVESTAN LETTER PE",
    "10B1F": "AVESTAN LETTER FE",
    "10B20": "AVESTAN LETTER BE",
    "10B21": "AVESTAN LETTER BHE",
    "10B22": "AVESTAN LETTER NGE",
    "10B23": "AVESTAN LETTER NGYE",
    "10B24": "AVESTAN LETTER NGVE",
    "10B25": "AVESTAN LETTER NE",
    "10B26": "AVESTAN LETTER NYE",
    "10B27": "AVESTAN LETTER NNE",
    "10B28": "AVESTAN LETTER ME",
    "10B29": "AVESTAN LETTER HME",
    "10B2A": "AVESTAN LETTER YYE",
    "10B2B": "AVESTAN LETTER YE",
    "10B2C": "AVESTAN LETTER VE",
    "10B2D": "AVESTAN LETTER RE",
    "10B2E": "AVESTAN LETTER LE",
    "10B2F": "AVESTAN LETTER SE",
    "10B30": "AVESTAN LETTER ZE",
    "10B31": "AVESTAN LETTER SHE",
    "10B32": "AVESTAN LETTER ZHE",
    "10B33": "AVESTAN LETTER SHYE",
    "10B34": "AVESTAN LETTER SSHE",
    "10B35": "AVESTAN LETTER HE",
    "10B39": "AVESTAN ABBREVIATION MARK",
    "10B3A": "TINY TWO DOTS OVER ONE DOT PUNCTUATION",
    "10B3B": "SMALL TWO DOTS OVER ONE DOT PUNCTUATION",
    "10B3C": "LARGE TWO DOTS OVER ONE DOT PUNCTUATION",
    "10B3D": "LARGE ONE DOT OVER TWO DOTS PUNCTUATION",
    "10B3E": "LARGE TWO RINGS OVER ONE RING PUNCTUATION",
    "10B3F": "LARGE ONE RING OVER TWO RINGS PUNCTUATION",
    "10B40": "INSCRIPTIONAL PARTHIAN LETTER ALEPH",
    "10B41": "INSCRIPTIONAL PARTHIAN LETTER BETH",
    "10B42": "INSCRIPTIONAL PARTHIAN LETTER GIMEL",
    "10B43": "INSCRIPTIONAL PARTHIAN LETTER DALETH",
    "10B44": "INSCRIPTIONAL PARTHIAN LETTER HE",
    "10B45": "INSCRIPTIONAL PARTHIAN LETTER WAW",
    "10B46": "INSCRIPTIONAL PARTHIAN LETTER ZAYIN",
    "10B47": "INSCRIPTIONAL PARTHIAN LETTER HETH",
    "10B48": "INSCRIPTIONAL PARTHIAN LETTER TETH",
    "10B49": "INSCRIPTIONAL PARTHIAN LETTER YODH",
    "10B4A": "INSCRIPTIONAL PARTHIAN LETTER KAPH",
    "10B4B": "INSCRIPTIONAL PARTHIAN LETTER LAMEDH",
    "10B4C": "INSCRIPTIONAL PARTHIAN LETTER MEM",
    "10B4D": "INSCRIPTIONAL PARTHIAN LETTER NUN",
    "10B4E": "INSCRIPTIONAL PARTHIAN LETTER SAMEKH",
    "10B4F": "INSCRIPTIONAL PARTHIAN LETTER AYIN",
    "10B50": "INSCRIPTIONAL PARTHIAN LETTER PE",
    "10B51": "INSCRIPTIONAL PARTHIAN LETTER SADHE",
    "10B52": "INSCRIPTIONAL PARTHIAN LETTER QOPH",
    "10B53": "INSCRIPTIONAL PARTHIAN LETTER RESH",
    "10B54": "INSCRIPTIONAL PARTHIAN LETTER SHIN",
    "10B55": "INSCRIPTIONAL PARTHIAN LETTER TAW",
    "10B58": "INSCRIPTIONAL PARTHIAN NUMBER ONE",
    "10B59": "INSCRIPTIONAL PARTHIAN NUMBER TWO",
    "10B5A": "INSCRIPTIONAL PARTHIAN NUMBER THREE",
    "10B5B": "INSCRIPTIONAL PARTHIAN NUMBER FOUR",
    "10B5C": "INSCRIPTIONAL PARTHIAN NUMBER TEN",
    "10B5D": "INSCRIPTIONAL PARTHIAN NUMBER TWENTY",
    "10B5E": "INSCRIPTIONAL PARTHIAN NUMBER ONE HUNDRED",
    "10B5F": "INSCRIPTIONAL PARTHIAN NUMBER ONE THOUSAND",
    "10B60": "INSCRIPTIONAL PAHLAVI LETTER ALEPH",
    "10B61": "INSCRIPTIONAL PAHLAVI LETTER BETH",
    "10B62": "INSCRIPTIONAL PAHLAVI LETTER GIMEL",
    "10B63": "INSCRIPTIONAL PAHLAVI LETTER DALETH",
    "10B64": "INSCRIPTIONAL PAHLAVI LETTER HE",
    "10B65": "INSCRIPTIONAL PAHLAVI LETTER WAW-AYIN-RESH",
    "10B66": "INSCRIPTIONAL PAHLAVI LETTER ZAYIN",
    "10B67": "INSCRIPTIONAL PAHLAVI LETTER HETH",
    "10B68": "INSCRIPTIONAL PAHLAVI LETTER TETH",
    "10B69": "INSCRIPTIONAL PAHLAVI LETTER YODH",
    "10B6A": "INSCRIPTIONAL PAHLAVI LETTER KAPH",
    "10B6B": "INSCRIPTIONAL PAHLAVI LETTER LAMEDH",
    "10B6C": "INSCRIPTIONAL PAHLAVI LETTER MEM-QOPH",
    "10B6D": "INSCRIPTIONAL PAHLAVI LETTER NUN",
    "10B6E": "INSCRIPTIONAL PAHLAVI LETTER SAMEKH",
    "10B6F": "INSCRIPTIONAL PAHLAVI LETTER PE",
    "10B70": "INSCRIPTIONAL PAHLAVI LETTER SADHE",
    "10B71": "INSCRIPTIONAL PAHLAVI LETTER SHIN",
    "10B72": "INSCRIPTIONAL PAHLAVI LETTER TAW",
    "10B78": "INSCRIPTIONAL PAHLAVI NUMBER ONE",
    "10B79": "INSCRIPTIONAL PAHLAVI NUMBER TWO",
    "10B7A": "INSCRIPTIONAL PAHLAVI NUMBER THREE",
    "10B7B": "INSCRIPTIONAL PAHLAVI NUMBER FOUR",
    "10B7C": "INSCRIPTIONAL PAHLAVI NUMBER TEN",
    "10B7D": "INSCRIPTIONAL PAHLAVI NUMBER TWENTY",
    "10B7E": "INSCRIPTIONAL PAHLAVI NUMBER ONE HUNDRED",
    "10B7F": "INSCRIPTIONAL PAHLAVI NUMBER ONE THOUSAND",
    "10B80": "PSALTER PAHLAVI LETTER ALEPH",
    "10B81": "PSALTER PAHLAVI LETTER BETH",
    "10B82": "PSALTER PAHLAVI LETTER GIMEL",
    "10B83": "PSALTER PAHLAVI LETTER DALETH",
    "10B84": "PSALTER PAHLAVI LETTER HE",
    "10B85": "PSALTER PAHLAVI LETTER WAW-AYIN-RESH",
    "10B86": "PSALTER PAHLAVI LETTER ZAYIN",
    "10B87": "PSALTER PAHLAVI LETTER HETH",
    "10B88": "PSALTER PAHLAVI LETTER YODH",
    "10B89": "PSALTER PAHLAVI LETTER KAPH",
    "10B8A": "PSALTER PAHLAVI LETTER LAMEDH",
    "10B8B": "PSALTER PAHLAVI LETTER MEM-QOPH",
    "10B8C": "PSALTER PAHLAVI LETTER NUN",
    "10B8D": "PSALTER PAHLAVI LETTER SAMEKH",
    "10B8E": "PSALTER PAHLAVI LETTER PE",
    "10B8F": "PSALTER PAHLAVI LETTER SADHE",
    "10B90": "PSALTER PAHLAVI LETTER SHIN",
    "10B91": "PSALTER PAHLAVI LETTER TAW",
    "10B99": "PSALTER PAHLAVI SECTION MARK",
    "10B9A": "PSALTER PAHLAVI TURNED SECTION MARK",
    "10B9B": "PSALTER PAHLAVI FOUR DOTS WITH CROSS",
    "10B9C": "PSALTER PAHLAVI FOUR DOTS WITH DOT",
    "10BA9": "PSALTER PAHLAVI NUMBER ONE",
    "10BAA": "PSALTER PAHLAVI NUMBER TWO",
    "10BAB": "PSALTER PAHLAVI NUMBER THREE",
    "10BAC": "PSALTER PAHLAVI NUMBER FOUR",
    "10BAD": "PSALTER PAHLAVI NUMBER TEN",
    "10BAE": "PSALTER PAHLAVI NUMBER TWENTY",
    "10BAF": "PSALTER PAHLAVI NUMBER ONE HUNDRED",
    "10C00": "OLD TURKIC LETTER ORKHON A",
    "10C01": "OLD TURKIC LETTER YENISEI A",
    "10C02": "OLD TURKIC LETTER YENISEI AE",
    "10C03": "OLD TURKIC LETTER ORKHON I",
    "10C04": "OLD TURKIC LETTER YENISEI I",
    "10C05": "OLD TURKIC LETTER YENISEI E",
    "10C06": "OLD TURKIC LETTER ORKHON O",
    "10C07": "OLD TURKIC LETTER ORKHON OE",
    "10C08": "OLD TURKIC LETTER YENISEI OE",
    "10C09": "OLD TURKIC LETTER ORKHON AB",
    "10C0A": "OLD TURKIC LETTER YENISEI AB",
    "10C0B": "OLD TURKIC LETTER ORKHON AEB",
    "10C0C": "OLD TURKIC LETTER YENISEI AEB",
    "10C0D": "OLD TURKIC LETTER ORKHON AG",
    "10C0E": "OLD TURKIC LETTER YENISEI AG",
    "10C0F": "OLD TURKIC LETTER ORKHON AEG",
    "10C10": "OLD TURKIC LETTER YENISEI AEG",
    "10C11": "OLD TURKIC LETTER ORKHON AD",
    "10C12": "OLD TURKIC LETTER YENISEI AD",
    "10C13": "OLD TURKIC LETTER ORKHON AED",
    "10C14": "OLD TURKIC LETTER ORKHON EZ",
    "10C15": "OLD TURKIC LETTER YENISEI EZ",
    "10C16": "OLD TURKIC LETTER ORKHON AY",
    "10C17": "OLD TURKIC LETTER YENISEI AY",
    "10C18": "OLD TURKIC LETTER ORKHON AEY",
    "10C19": "OLD TURKIC LETTER YENISEI AEY",
    "10C1A": "OLD TURKIC LETTER ORKHON AEK",
    "10C1B": "OLD TURKIC LETTER YENISEI AEK",
    "10C1C": "OLD TURKIC LETTER ORKHON OEK",
    "10C1D": "OLD TURKIC LETTER YENISEI OEK",
    "10C1E": "OLD TURKIC LETTER ORKHON AL",
    "10C1F": "OLD TURKIC LETTER YENISEI AL",
    "10C20": "OLD TURKIC LETTER ORKHON AEL",
    "10C21": "OLD TURKIC LETTER ORKHON ELT",
    "10C22": "OLD TURKIC LETTER ORKHON EM",
    "10C23": "OLD TURKIC LETTER ORKHON AN",
    "10C24": "OLD TURKIC LETTER ORKHON AEN",
    "10C25": "OLD TURKIC LETTER YENISEI AEN",
    "10C26": "OLD TURKIC LETTER ORKHON ENT",
    "10C27": "OLD TURKIC LETTER YENISEI ENT",
    "10C28": "OLD TURKIC LETTER ORKHON ENC",
    "10C29": "OLD TURKIC LETTER YENISEI ENC",
    "10C2A": "OLD TURKIC LETTER ORKHON ENY",
    "10C2B": "OLD TURKIC LETTER YENISEI ENY",
    "10C2C": "OLD TURKIC LETTER YENISEI ANG",
    "10C2D": "OLD TURKIC LETTER ORKHON ENG",
    "10C2E": "OLD TURKIC LETTER YENISEI AENG",
    "10C2F": "OLD TURKIC LETTER ORKHON EP",
    "10C30": "OLD TURKIC LETTER ORKHON OP",
    "10C31": "OLD TURKIC LETTER ORKHON IC",
    "10C32": "OLD TURKIC LETTER ORKHON EC",
    "10C33": "OLD TURKIC LETTER YENISEI EC",
    "10C34": "OLD TURKIC LETTER ORKHON AQ",
    "10C35": "OLD TURKIC LETTER YENISEI AQ",
    "10C36": "OLD TURKIC LETTER ORKHON IQ",
    "10C37": "OLD TURKIC LETTER YENISEI IQ",
    "10C38": "OLD TURKIC LETTER ORKHON OQ",
    "10C39": "OLD TURKIC LETTER YENISEI OQ",
    "10C3A": "OLD TURKIC LETTER ORKHON AR",
    "10C3B": "OLD TURKIC LETTER YENISEI AR",
    "10C3C": "OLD TURKIC LETTER ORKHON AER",
    "10C3D": "OLD TURKIC LETTER ORKHON AS",
    "10C3E": "OLD TURKIC LETTER ORKHON AES",
    "10C3F": "OLD TURKIC LETTER ORKHON ASH",
    "10C40": "OLD TURKIC LETTER YENISEI ASH",
    "10C41": "OLD TURKIC LETTER ORKHON ESH",
    "10C42": "OLD TURKIC LETTER YENISEI ESH",
    "10C43": "OLD TURKIC LETTER ORKHON AT",
    "10C44": "OLD TURKIC LETTER YENISEI AT",
    "10C45": "OLD TURKIC LETTER ORKHON AET",
    "10C46": "OLD TURKIC LETTER YENISEI AET",
    "10C47": "OLD TURKIC LETTER ORKHON OT",
    "10C48": "OLD TURKIC LETTER ORKHON BASH",
    "10C80": "OLD HUNGARIAN CAPITAL LETTER A",
    "10C81": "OLD HUNGARIAN CAPITAL LETTER AA",
    "10C82": "OLD HUNGARIAN CAPITAL LETTER EB",
    "10C83": "OLD HUNGARIAN CAPITAL LETTER AMB",
    "10C84": "OLD HUNGARIAN CAPITAL LETTER EC",
    "10C85": "OLD HUNGARIAN CAPITAL LETTER ENC",
    "10C86": "OLD HUNGARIAN CAPITAL LETTER ECS",
    "10C87": "OLD HUNGARIAN CAPITAL LETTER ED",
    "10C88": "OLD HUNGARIAN CAPITAL LETTER AND",
    "10C89": "OLD HUNGARIAN CAPITAL LETTER E",
    "10C8A": "OLD HUNGARIAN CAPITAL LETTER CLOSE E",
    "10C8B": "OLD HUNGARIAN CAPITAL LETTER EE",
    "10C8C": "OLD HUNGARIAN CAPITAL LETTER EF",
    "10C8D": "OLD HUNGARIAN CAPITAL LETTER EG",
    "10C8E": "OLD HUNGARIAN CAPITAL LETTER EGY",
    "10C8F": "OLD HUNGARIAN CAPITAL LETTER EH",
    "10C90": "OLD HUNGARIAN CAPITAL LETTER I",
    "10C91": "OLD HUNGARIAN CAPITAL LETTER II",
    "10C92": "OLD HUNGARIAN CAPITAL LETTER EJ",
    "10C93": "OLD HUNGARIAN CAPITAL LETTER EK",
    "10C94": "OLD HUNGARIAN CAPITAL LETTER AK",
    "10C95": "OLD HUNGARIAN CAPITAL LETTER UNK",
    "10C96": "OLD HUNGARIAN CAPITAL LETTER EL",
    "10C97": "OLD HUNGARIAN CAPITAL LETTER ELY",
    "10C98": "OLD HUNGARIAN CAPITAL LETTER EM",
    "10C99": "OLD HUNGARIAN CAPITAL LETTER EN",
    "10C9A": "OLD HUNGARIAN CAPITAL LETTER ENY",
    "10C9B": "OLD HUNGARIAN CAPITAL LETTER O",
    "10C9C": "OLD HUNGARIAN CAPITAL LETTER OO",
    "10C9D": "OLD HUNGARIAN CAPITAL LETTER NIKOLSBURG OE",
    "10C9E": "OLD HUNGARIAN CAPITAL LETTER RUDIMENTA OE",
    "10C9F": "OLD HUNGARIAN CAPITAL LETTER OEE",
    "10CA0": "OLD HUNGARIAN CAPITAL LETTER EP",
    "10CA1": "OLD HUNGARIAN CAPITAL LETTER EMP",
    "10CA2": "OLD HUNGARIAN CAPITAL LETTER ER",
    "10CA3": "OLD HUNGARIAN CAPITAL LETTER SHORT ER",
    "10CA4": "OLD HUNGARIAN CAPITAL LETTER ES",
    "10CA5": "OLD HUNGARIAN CAPITAL LETTER ESZ",
    "10CA6": "OLD HUNGARIAN CAPITAL LETTER ET",
    "10CA7": "OLD HUNGARIAN CAPITAL LETTER ENT",
    "10CA8": "OLD HUNGARIAN CAPITAL LETTER ETY",
    "10CA9": "OLD HUNGARIAN CAPITAL LETTER ECH",
    "10CAA": "OLD HUNGARIAN CAPITAL LETTER U",
    "10CAB": "OLD HUNGARIAN CAPITAL LETTER UU",
    "10CAC": "OLD HUNGARIAN CAPITAL LETTER NIKOLSBURG UE",
    "10CAD": "OLD HUNGARIAN CAPITAL LETTER RUDIMENTA UE",
    "10CAE": "OLD HUNGARIAN CAPITAL LETTER EV",
    "10CAF": "OLD HUNGARIAN CAPITAL LETTER EZ",
    "10CB0": "OLD HUNGARIAN CAPITAL LETTER EZS",
    "10CB1": "OLD HUNGARIAN CAPITAL LETTER ENT-SHAPED SIGN",
    "10CB2": "OLD HUNGARIAN CAPITAL LETTER US",
    "10CC0": "OLD HUNGARIAN SMALL LETTER A",
    "10CC1": "OLD HUNGARIAN SMALL LETTER AA",
    "10CC2": "OLD HUNGARIAN SMALL LETTER EB",
    "10CC3": "OLD HUNGARIAN SMALL LETTER AMB",
    "10CC4": "OLD HUNGARIAN SMALL LETTER EC",
    "10CC5": "OLD HUNGARIAN SMALL LETTER ENC",
    "10CC6": "OLD HUNGARIAN SMALL LETTER ECS",
    "10CC7": "OLD HUNGARIAN SMALL LETTER ED",
    "10CC8": "OLD HUNGARIAN SMALL LETTER AND",
    "10CC9": "OLD HUNGARIAN SMALL LETTER E",
    "10CCA": "OLD HUNGARIAN SMALL LETTER CLOSE E",
    "10CCB": "OLD HUNGARIAN SMALL LETTER EE",
    "10CCC": "OLD HUNGARIAN SMALL LETTER EF",
    "10CCD": "OLD HUNGARIAN SMALL LETTER EG",
    "10CCE": "OLD HUNGARIAN SMALL LETTER EGY",
    "10CCF": "OLD HUNGARIAN SMALL LETTER EH",
    "10CD0": "OLD HUNGARIAN SMALL LETTER I",
    "10CD1": "OLD HUNGARIAN SMALL LETTER II",
    "10CD2": "OLD HUNGARIAN SMALL LETTER EJ",
    "10CD3": "OLD HUNGARIAN SMALL LETTER EK",
    "10CD4": "OLD HUNGARIAN SMALL LETTER AK",
    "10CD5": "OLD HUNGARIAN SMALL LETTER UNK",
    "10CD6": "OLD HUNGARIAN SMALL LETTER EL",
    "10CD7": "OLD HUNGARIAN SMALL LETTER ELY",
    "10CD8": "OLD HUNGARIAN SMALL LETTER EM",
    "10CD9": "OLD HUNGARIAN SMALL LETTER EN",
    "10CDA": "OLD HUNGARIAN SMALL LETTER ENY",
    "10CDB": "OLD HUNGARIAN SMALL LETTER O",
    "10CDC": "OLD HUNGARIAN SMALL LETTER OO",
    "10CDD": "OLD HUNGARIAN SMALL LETTER NIKOLSBURG OE",
    "10CDE": "OLD HUNGARIAN SMALL LETTER RUDIMENTA OE",
    "10CDF": "OLD HUNGARIAN SMALL LETTER OEE",
    "10CE0": "OLD HUNGARIAN SMALL LETTER EP",
    "10CE1": "OLD HUNGARIAN SMALL LETTER EMP",
    "10CE2": "OLD HUNGARIAN SMALL LETTER ER",
    "10CE3": "OLD HUNGARIAN SMALL LETTER SHORT ER",
    "10CE4": "OLD HUNGARIAN SMALL LETTER ES",
    "10CE5": "OLD HUNGARIAN SMALL LETTER ESZ",
    "10CE6": "OLD HUNGARIAN SMALL LETTER ET",
    "10CE7": "OLD HUNGARIAN SMALL LETTER ENT",
    "10CE8": "OLD HUNGARIAN SMALL LETTER ETY",
    "10CE9": "OLD HUNGARIAN SMALL LETTER ECH",
    "10CEA": "OLD HUNGARIAN SMALL LETTER U",
    "10CEB": "OLD HUNGARIAN SMALL LETTER UU",
    "10CEC": "OLD HUNGARIAN SMALL LETTER NIKOLSBURG UE",
    "10CED": "OLD HUNGARIAN SMALL LETTER RUDIMENTA UE",
    "10CEE": "OLD HUNGARIAN SMALL LETTER EV",
    "10CEF": "OLD HUNGARIAN SMALL LETTER EZ",
    "10CF0": "OLD HUNGARIAN SMALL LETTER EZS",
    "10CF1": "OLD HUNGARIAN SMALL LETTER ENT-SHAPED SIGN",
    "10CF2": "OLD HUNGARIAN SMALL LETTER US",
    "10CFA": "OLD HUNGARIAN NUMBER ONE",
    "10CFB": "OLD HUNGARIAN NUMBER FIVE",
    "10CFC": "OLD HUNGARIAN NUMBER TEN",
    "10CFD": "OLD HUNGARIAN NUMBER FIFTY",
    "10CFE": "OLD HUNGARIAN NUMBER ONE HUNDRED",
    "10CFF": "OLD HUNGARIAN NUMBER ONE THOUSAND",
    "10E60": "RUMI DIGIT ONE",
    "10E61": "RUMI DIGIT TWO",
    "10E62": "RUMI DIGIT THREE",
    "10E63": "RUMI DIGIT FOUR",
    "10E64": "RUMI DIGIT FIVE",
    "10E65": "RUMI DIGIT SIX",
    "10E66": "RUMI DIGIT SEVEN",
    "10E67": "RUMI DIGIT EIGHT",
    "10E68": "RUMI DIGIT NINE",
    "10E69": "RUMI NUMBER TEN",
    "10E6A": "RUMI NUMBER TWENTY",
    "10E6B": "RUMI NUMBER THIRTY",
    "10E6C": "RUMI NUMBER FORTY",
    "10E6D": "RUMI NUMBER FIFTY",
    "10E6E": "RUMI NUMBER SIXTY",
    "10E6F": "RUMI NUMBER SEVENTY",
    "10E70": "RUMI NUMBER EIGHTY",
    "10E71": "RUMI NUMBER NINETY",
    "10E72": "RUMI NUMBER ONE HUNDRED",
    "10E73": "RUMI NUMBER TWO HUNDRED",
    "10E74": "RUMI NUMBER THREE HUNDRED",
    "10E75": "RUMI NUMBER FOUR HUNDRED",
    "10E76": "RUMI NUMBER FIVE HUNDRED",
    "10E77": "RUMI NUMBER SIX HUNDRED",
    "10E78": "RUMI NUMBER SEVEN HUNDRED",
    "10E79": "RUMI NUMBER EIGHT HUNDRED",
    "10E7A": "RUMI NUMBER NINE HUNDRED",
    "10E7B": "RUMI FRACTION ONE HALF",
    "10E7C": "RUMI FRACTION ONE QUARTER",
    "10E7D": "RUMI FRACTION ONE THIRD",
    "10E7E": "RUMI FRACTION TWO THIRDS",
    "11000": "BRAHMI SIGN CANDRABINDU",
    "11001": "BRAHMI SIGN ANUSVARA",
    "11002": "BRAHMI SIGN VISARGA",
    "11003": "BRAHMI SIGN JIHVAMULIYA",
    "11004": "BRAHMI SIGN UPADHMANIYA",
    "11005": "BRAHMI LETTER A",
    "11006": "BRAHMI LETTER AA",
    "11007": "BRAHMI LETTER I",
    "11008": "BRAHMI LETTER II",
    "11009": "BRAHMI LETTER U",
    "1100A": "BRAHMI LETTER UU",
    "1100B": "BRAHMI LETTER VOCALIC R",
    "1100C": "BRAHMI LETTER VOCALIC RR",
    "1100D": "BRAHMI LETTER VOCALIC L",
    "1100E": "BRAHMI LETTER VOCALIC LL",
    "1100F": "BRAHMI LETTER E",
    "11010": "BRAHMI LETTER AI",
    "11011": "BRAHMI LETTER O",
    "11012": "BRAHMI LETTER AU",
    "11013": "BRAHMI LETTER KA",
    "11014": "BRAHMI LETTER KHA",
    "11015": "BRAHMI LETTER GA",
    "11016": "BRAHMI LETTER GHA",
    "11017": "BRAHMI LETTER NGA",
    "11018": "BRAHMI LETTER CA",
    "11019": "BRAHMI LETTER CHA",
    "1101A": "BRAHMI LETTER JA",
    "1101B": "BRAHMI LETTER JHA",
    "1101C": "BRAHMI LETTER NYA",
    "1101D": "BRAHMI LETTER TTA",
    "1101E": "BRAHMI LETTER TTHA",
    "1101F": "BRAHMI LETTER DDA",
    "11020": "BRAHMI LETTER DDHA",
    "11021": "BRAHMI LETTER NNA",
    "11022": "BRAHMI LETTER TA",
    "11023": "BRAHMI LETTER THA",
    "11024": "BRAHMI LETTER DA",
    "11025": "BRAHMI LETTER DHA",
    "11026": "BRAHMI LETTER NA",
    "11027": "BRAHMI LETTER PA",
    "11028": "BRAHMI LETTER PHA",
    "11029": "BRAHMI LETTER BA",
    "1102A": "BRAHMI LETTER BHA",
    "1102B": "BRAHMI LETTER MA",
    "1102C": "BRAHMI LETTER YA",
    "1102D": "BRAHMI LETTER RA",
    "1102E": "BRAHMI LETTER LA",
    "1102F": "BRAHMI LETTER VA",
    "11030": "BRAHMI LETTER SHA",
    "11031": "BRAHMI LETTER SSA",
    "11032": "BRAHMI LETTER SA",
    "11033": "BRAHMI LETTER HA",
    "11034": "BRAHMI LETTER LLA",
    "11035": "BRAHMI LETTER OLD TAMIL LLLA",
    "11036": "BRAHMI LETTER OLD TAMIL RRA",
    "11037": "BRAHMI LETTER OLD TAMIL NNNA",
    "11038": "BRAHMI VOWEL SIGN AA",
    "11039": "BRAHMI VOWEL SIGN BHATTIPROLU AA",
    "1103A": "BRAHMI VOWEL SIGN I",
    "1103B": "BRAHMI VOWEL SIGN II",
    "1103C": "BRAHMI VOWEL SIGN U",
    "1103D": "BRAHMI VOWEL SIGN UU",
    "1103E": "BRAHMI VOWEL SIGN VOCALIC R",
    "1103F": "BRAHMI VOWEL SIGN VOCALIC RR",
    "11040": "BRAHMI VOWEL SIGN VOCALIC L",
    "11041": "BRAHMI VOWEL SIGN VOCALIC LL",
    "11042": "BRAHMI VOWEL SIGN E",
    "11043": "BRAHMI VOWEL SIGN AI",
    "11044": "BRAHMI VOWEL SIGN O",
    "11045": "BRAHMI VOWEL SIGN AU",
    "11046": "BRAHMI VIRAMA",
    "11047": "BRAHMI DANDA",
    "11048": "BRAHMI DOUBLE DANDA",
    "11049": "BRAHMI PUNCTUATION DOT",
    "1104A": "BRAHMI PUNCTUATION DOUBLE DOT",
    "1104B": "BRAHMI PUNCTUATION LINE",
    "1104C": "BRAHMI PUNCTUATION CRESCENT BAR",
    "1104D": "BRAHMI PUNCTUATION LOTUS",
    "11052": "BRAHMI NUMBER ONE",
    "11053": "BRAHMI NUMBER TWO",
    "11054": "BRAHMI NUMBER THREE",
    "11055": "BRAHMI NUMBER FOUR",
    "11056": "BRAHMI NUMBER FIVE",
    "11057": "BRAHMI NUMBER SIX",
    "11058": "BRAHMI NUMBER SEVEN",
    "11059": "BRAHMI NUMBER EIGHT",
    "1105A": "BRAHMI NUMBER NINE",
    "1105B": "BRAHMI NUMBER TEN",
    "1105C": "BRAHMI NUMBER TWENTY",
    "1105D": "BRAHMI NUMBER THIRTY",
    "1105E": "BRAHMI NUMBER FORTY",
    "1105F": "BRAHMI NUMBER FIFTY",
    "11060": "BRAHMI NUMBER SIXTY",
    "11061": "BRAHMI NUMBER SEVENTY",
    "11062": "BRAHMI NUMBER EIGHTY",
    "11063": "BRAHMI NUMBER NINETY",
    "11064": "BRAHMI NUMBER ONE HUNDRED",
    "11065": "BRAHMI NUMBER ONE THOUSAND",
    "11066": "BRAHMI DIGIT ZERO",
    "11067": "BRAHMI DIGIT ONE",
    "11068": "BRAHMI DIGIT TWO",
    "11069": "BRAHMI DIGIT THREE",
    "1106A": "BRAHMI DIGIT FOUR",
    "1106B": "BRAHMI DIGIT FIVE",
    "1106C": "BRAHMI DIGIT SIX",
    "1106D": "BRAHMI DIGIT SEVEN",
    "1106E": "BRAHMI DIGIT EIGHT",
    "1106F": "BRAHMI DIGIT NINE",
    "1107F": "BRAHMI NUMBER JOINER",
    "11080": "KAITHI SIGN CANDRABINDU",
    "11081": "KAITHI SIGN ANUSVARA",
    "11082": "KAITHI SIGN VISARGA",
    "11083": "KAITHI LETTER A",
    "11084": "KAITHI LETTER AA",
    "11085": "KAITHI LETTER I",
    "11086": "KAITHI LETTER II",
    "11087": "KAITHI LETTER U",
    "11088": "KAITHI LETTER UU",
    "11089": "KAITHI LETTER E",
    "1108A": "KAITHI LETTER AI",
    "1108B": "KAITHI LETTER O",
    "1108C": "KAITHI LETTER AU",
    "1108D": "KAITHI LETTER KA",
    "1108E": "KAITHI LETTER KHA",
    "1108F": "KAITHI LETTER GA",
    "11090": "KAITHI LETTER GHA",
    "11091": "KAITHI LETTER NGA",
    "11092": "KAITHI LETTER CA",
    "11093": "KAITHI LETTER CHA",
    "11094": "KAITHI LETTER JA",
    "11095": "KAITHI LETTER JHA",
    "11096": "KAITHI LETTER NYA",
    "11097": "KAITHI LETTER TTA",
    "11098": "KAITHI LETTER TTHA",
    "11099": "KAITHI LETTER DDA",
    "1109A": "KAITHI LETTER DDDHA",
    "1109B": "KAITHI LETTER DDHA",
    "1109C": "KAITHI LETTER RHA",
    "1109D": "KAITHI LETTER NNA",
    "1109E": "KAITHI LETTER TA",
    "1109F": "KAITHI LETTER THA",
    "110A0": "KAITHI LETTER DA",
    "110A1": "KAITHI LETTER DHA",
    "110A2": "KAITHI LETTER NA",
    "110A3": "KAITHI LETTER PA",
    "110A4": "KAITHI LETTER PHA",
    "110A5": "KAITHI LETTER BA",
    "110A6": "KAITHI LETTER BHA",
    "110A7": "KAITHI LETTER MA",
    "110A8": "KAITHI LETTER YA",
    "110A9": "KAITHI LETTER RA",
    "110AA": "KAITHI LETTER LA",
    "110AB": "KAITHI LETTER VA",
    "110AC": "KAITHI LETTER SHA",
    "110AD": "KAITHI LETTER SSA",
    "110AE": "KAITHI LETTER SA",
    "110AF": "KAITHI LETTER HA",
    "110B0": "KAITHI VOWEL SIGN AA",
    "110B1": "KAITHI VOWEL SIGN I",
    "110B2": "KAITHI VOWEL SIGN II",
    "110B3": "KAITHI VOWEL SIGN U",
    "110B4": "KAITHI VOWEL SIGN UU",
    "110B5": "KAITHI VOWEL SIGN E",
    "110B6": "KAITHI VOWEL SIGN AI",
    "110B7": "KAITHI VOWEL SIGN O",
    "110B8": "KAITHI VOWEL SIGN AU",
    "110B9": "KAITHI SIGN VIRAMA",
    "110BA": "KAITHI SIGN NUKTA",
    "110BB": "KAITHI ABBREVIATION SIGN",
    "110BC": "KAITHI ENUMERATION SIGN",
    "110BD": "KAITHI NUMBER SIGN",
    "110BE": "KAITHI SECTION MARK",
    "110BF": "KAITHI DOUBLE SECTION MARK",
    "110C0": "KAITHI DANDA",
    "110C1": "KAITHI DOUBLE DANDA",
    "110D0": "SORA SOMPENG LETTER SAH",
    "110D1": "SORA SOMPENG LETTER TAH",
    "110D2": "SORA SOMPENG LETTER BAH",
    "110D3": "SORA SOMPENG LETTER CAH",
    "110D4": "SORA SOMPENG LETTER DAH",
    "110D5": "SORA SOMPENG LETTER GAH",
    "110D6": "SORA SOMPENG LETTER MAH",
    "110D7": "SORA SOMPENG LETTER NGAH",
    "110D8": "SORA SOMPENG LETTER LAH",
    "110D9": "SORA SOMPENG LETTER NAH",
    "110DA": "SORA SOMPENG LETTER VAH",
    "110DB": "SORA SOMPENG LETTER PAH",
    "110DC": "SORA SOMPENG LETTER YAH",
    "110DD": "SORA SOMPENG LETTER RAH",
    "110DE": "SORA SOMPENG LETTER HAH",
    "110DF": "SORA SOMPENG LETTER KAH",
    "110E0": "SORA SOMPENG LETTER JAH",
    "110E1": "SORA SOMPENG LETTER NYAH",
    "110E2": "SORA SOMPENG LETTER AH",
    "110E3": "SORA SOMPENG LETTER EEH",
    "110E4": "SORA SOMPENG LETTER IH",
    "110E5": "SORA SOMPENG LETTER UH",
    "110E6": "SORA SOMPENG LETTER OH",
    "110E7": "SORA SOMPENG LETTER EH",
    "110E8": "SORA SOMPENG LETTER MAE",
    "110F0": "SORA SOMPENG DIGIT ZERO",
    "110F1": "SORA SOMPENG DIGIT ONE",
    "110F2": "SORA SOMPENG DIGIT TWO",
    "110F3": "SORA SOMPENG DIGIT THREE",
    "110F4": "SORA SOMPENG DIGIT FOUR",
    "110F5": "SORA SOMPENG DIGIT FIVE",
    "110F6": "SORA SOMPENG DIGIT SIX",
    "110F7": "SORA SOMPENG DIGIT SEVEN",
    "110F8": "SORA SOMPENG DIGIT EIGHT",
    "110F9": "SORA SOMPENG DIGIT NINE",
    "11100": "CHAKMA SIGN CANDRABINDU",
    "11101": "CHAKMA SIGN ANUSVARA",
    "11102": "CHAKMA SIGN VISARGA",
    "11103": "CHAKMA LETTER AA",
    "11104": "CHAKMA LETTER I",
    "11105": "CHAKMA LETTER U",
    "11106": "CHAKMA LETTER E",
    "11107": "CHAKMA LETTER KAA",
    "11108": "CHAKMA LETTER KHAA",
    "11109": "CHAKMA LETTER GAA",
    "1110A": "CHAKMA LETTER GHAA",
    "1110B": "CHAKMA LETTER NGAA",
    "1110C": "CHAKMA LETTER CAA",
    "1110D": "CHAKMA LETTER CHAA",
    "1110E": "CHAKMA LETTER JAA",
    "1110F": "CHAKMA LETTER JHAA",
    "11110": "CHAKMA LETTER NYAA",
    "11111": "CHAKMA LETTER TTAA",
    "11112": "CHAKMA LETTER TTHAA",
    "11113": "CHAKMA LETTER DDAA",
    "11114": "CHAKMA LETTER DDHAA",
    "11115": "CHAKMA LETTER NNAA",
    "11116": "CHAKMA LETTER TAA",
    "11117": "CHAKMA LETTER THAA",
    "11118": "CHAKMA LETTER DAA",
    "11119": "CHAKMA LETTER DHAA",
    "1111A": "CHAKMA LETTER NAA",
    "1111B": "CHAKMA LETTER PAA",
    "1111C": "CHAKMA LETTER PHAA",
    "1111D": "CHAKMA LETTER BAA",
    "1111E": "CHAKMA LETTER BHAA",
    "1111F": "CHAKMA LETTER MAA",
    "11120": "CHAKMA LETTER YYAA",
    "11121": "CHAKMA LETTER YAA",
    "11122": "CHAKMA LETTER RAA",
    "11123": "CHAKMA LETTER LAA",
    "11124": "CHAKMA LETTER WAA",
    "11125": "CHAKMA LETTER SAA",
    "11126": "CHAKMA LETTER HAA",
    "11127": "CHAKMA VOWEL SIGN A",
    "11128": "CHAKMA VOWEL SIGN I",
    "11129": "CHAKMA VOWEL SIGN II",
    "1112A": "CHAKMA VOWEL SIGN U",
    "1112B": "CHAKMA VOWEL SIGN UU",
    "1112C": "CHAKMA VOWEL SIGN E",
    "1112D": "CHAKMA VOWEL SIGN AI",
    "1112E": "CHAKMA VOWEL SIGN O",
    "1112F": "CHAKMA VOWEL SIGN AU",
    "11130": "CHAKMA VOWEL SIGN OI",
    "11131": "CHAKMA O MARK",
    "11132": "CHAKMA AU MARK",
    "11133": "CHAKMA VIRAMA",
    "11134": "CHAKMA MAAYYAA",
    "11136": "CHAKMA DIGIT ZERO",
    "11137": "CHAKMA DIGIT ONE",
    "11138": "CHAKMA DIGIT TWO",
    "11139": "CHAKMA DIGIT THREE",
    "1113A": "CHAKMA DIGIT FOUR",
    "1113B": "CHAKMA DIGIT FIVE",
    "1113C": "CHAKMA DIGIT SIX",
    "1113D": "CHAKMA DIGIT SEVEN",
    "1113E": "CHAKMA DIGIT EIGHT",
    "1113F": "CHAKMA DIGIT NINE",
    "11140": "CHAKMA SECTION MARK",
    "11141": "CHAKMA DANDA",
    "11142": "CHAKMA DOUBLE DANDA",
    "11143": "CHAKMA QUESTION MARK",
    "11150": "MAHAJANI LETTER A",
    "11151": "MAHAJANI LETTER I",
    "11152": "MAHAJANI LETTER U",
    "11153": "MAHAJANI LETTER E",
    "11154": "MAHAJANI LETTER O",
    "11155": "MAHAJANI LETTER KA",
    "11156": "MAHAJANI LETTER KHA",
    "11157": "MAHAJANI LETTER GA",
    "11158": "MAHAJANI LETTER GHA",
    "11159": "MAHAJANI LETTER CA",
    "1115A": "MAHAJANI LETTER CHA",
    "1115B": "MAHAJANI LETTER JA",
    "1115C": "MAHAJANI LETTER JHA",
    "1115D": "MAHAJANI LETTER NYA",
    "1115E": "MAHAJANI LETTER TTA",
    "1115F": "MAHAJANI LETTER TTHA",
    "11160": "MAHAJANI LETTER DDA",
    "11161": "MAHAJANI LETTER DDHA",
    "11162": "MAHAJANI LETTER NNA",
    "11163": "MAHAJANI LETTER TA",
    "11164": "MAHAJANI LETTER THA",
    "11165": "MAHAJANI LETTER DA",
    "11166": "MAHAJANI LETTER DHA",
    "11167": "MAHAJANI LETTER NA",
    "11168": "MAHAJANI LETTER PA",
    "11169": "MAHAJANI LETTER PHA",
    "1116A": "MAHAJANI LETTER BA",
    "1116B": "MAHAJANI LETTER BHA",
    "1116C": "MAHAJANI LETTER MA",
    "1116D": "MAHAJANI LETTER RA",
    "1116E": "MAHAJANI LETTER LA",
    "1116F": "MAHAJANI LETTER VA",
    "11170": "MAHAJANI LETTER SA",
    "11171": "MAHAJANI LETTER HA",
    "11172": "MAHAJANI LETTER RRA",
    "11173": "MAHAJANI SIGN NUKTA",
    "11174": "MAHAJANI ABBREVIATION SIGN",
    "11175": "MAHAJANI SECTION MARK",
    "11176": "MAHAJANI LIGATURE SHRI",
    "11180": "SHARADA SIGN CANDRABINDU",
    "11181": "SHARADA SIGN ANUSVARA",
    "11182": "SHARADA SIGN VISARGA",
    "11183": "SHARADA LETTER A",
    "11184": "SHARADA LETTER AA",
    "11185": "SHARADA LETTER I",
    "11186": "SHARADA LETTER II",
    "11187": "SHARADA LETTER U",
    "11188": "SHARADA LETTER UU",
    "11189": "SHARADA LETTER VOCALIC R",
    "1118A": "SHARADA LETTER VOCALIC RR",
    "1118B": "SHARADA LETTER VOCALIC L",
    "1118C": "SHARADA LETTER VOCALIC LL",
    "1118D": "SHARADA LETTER E",
    "1118E": "SHARADA LETTER AI",
    "1118F": "SHARADA LETTER O",
    "11190": "SHARADA LETTER AU",
    "11191": "SHARADA LETTER KA",
    "11192": "SHARADA LETTER KHA",
    "11193": "SHARADA LETTER GA",
    "11194": "SHARADA LETTER GHA",
    "11195": "SHARADA LETTER NGA",
    "11196": "SHARADA LETTER CA",
    "11197": "SHARADA LETTER CHA",
    "11198": "SHARADA LETTER JA",
    "11199": "SHARADA LETTER JHA",
    "1119A": "SHARADA LETTER NYA",
    "1119B": "SHARADA LETTER TTA",
    "1119C": "SHARADA LETTER TTHA",
    "1119D": "SHARADA LETTER DDA",
    "1119E": "SHARADA LETTER DDHA",
    "1119F": "SHARADA LETTER NNA",
    "111A0": "SHARADA LETTER TA",
    "111A1": "SHARADA LETTER THA",
    "111A2": "SHARADA LETTER DA",
    "111A3": "SHARADA LETTER DHA",
    "111A4": "SHARADA LETTER NA",
    "111A5": "SHARADA LETTER PA",
    "111A6": "SHARADA LETTER PHA",
    "111A7": "SHARADA LETTER BA",
    "111A8": "SHARADA LETTER BHA",
    "111A9": "SHARADA LETTER MA",
    "111AA": "SHARADA LETTER YA",
    "111AB": "SHARADA LETTER RA",
    "111AC": "SHARADA LETTER LA",
    "111AD": "SHARADA LETTER LLA",
    "111AE": "SHARADA LETTER VA",
    "111AF": "SHARADA LETTER SHA",
    "111B0": "SHARADA LETTER SSA",
    "111B1": "SHARADA LETTER SA",
    "111B2": "SHARADA LETTER HA",
    "111B3": "SHARADA VOWEL SIGN AA",
    "111B4": "SHARADA VOWEL SIGN I",
    "111B5": "SHARADA VOWEL SIGN II",
    "111B6": "SHARADA VOWEL SIGN U",
    "111B7": "SHARADA VOWEL SIGN UU",
    "111B8": "SHARADA VOWEL SIGN VOCALIC R",
    "111B9": "SHARADA VOWEL SIGN VOCALIC RR",
    "111BA": "SHARADA VOWEL SIGN VOCALIC L",
    "111BB": "SHARADA VOWEL SIGN VOCALIC LL",
    "111BC": "SHARADA VOWEL SIGN E",
    "111BD": "SHARADA VOWEL SIGN AI",
    "111BE": "SHARADA VOWEL SIGN O",
    "111BF": "SHARADA VOWEL SIGN AU",
    "111C0": "SHARADA SIGN VIRAMA",
    "111C1": "SHARADA SIGN AVAGRAHA",
    "111C2": "SHARADA SIGN JIHVAMULIYA",
    "111C3": "SHARADA SIGN UPADHMANIYA",
    "111C4": "SHARADA OM",
    "111C5": "SHARADA DANDA",
    "111C6": "SHARADA DOUBLE DANDA",
    "111C7": "SHARADA ABBREVIATION SIGN",
    "111C8": "SHARADA SEPARATOR",
    "111C9": "SHARADA SANDHI MARK",
    "111CA": "SHARADA SIGN NUKTA",
    "111CB": "SHARADA VOWEL MODIFIER MARK",
    "111CC": "SHARADA EXTRA SHORT VOWEL MARK",
    "111CD": "SHARADA SUTRA MARK",
    "111D0": "SHARADA DIGIT ZERO",
    "111D1": "SHARADA DIGIT ONE",
    "111D2": "SHARADA DIGIT TWO",
    "111D3": "SHARADA DIGIT THREE",
    "111D4": "SHARADA DIGIT FOUR",
    "111D5": "SHARADA DIGIT FIVE",
    "111D6": "SHARADA DIGIT SIX",
    "111D7": "SHARADA DIGIT SEVEN",
    "111D8": "SHARADA DIGIT EIGHT",
    "111D9": "SHARADA DIGIT NINE",
    "111DA": "SHARADA EKAM",
    "111DB": "SHARADA SIGN SIDDHAM",
    "111DC": "SHARADA HEADSTROKE",
    "111DD": "SHARADA CONTINUATION SIGN",
    "111DE": "SHARADA SECTION MARK-1",
    "111DF": "SHARADA SECTION MARK-2",
    "111E1": "SINHALA ARCHAIC DIGIT ONE",
    "111E2": "SINHALA ARCHAIC DIGIT TWO",
    "111E3": "SINHALA ARCHAIC DIGIT THREE",
    "111E4": "SINHALA ARCHAIC DIGIT FOUR",
    "111E5": "SINHALA ARCHAIC DIGIT FIVE",
    "111E6": "SINHALA ARCHAIC DIGIT SIX",
    "111E7": "SINHALA ARCHAIC DIGIT SEVEN",
    "111E8": "SINHALA ARCHAIC DIGIT EIGHT",
    "111E9": "SINHALA ARCHAIC DIGIT NINE",
    "111EA": "SINHALA ARCHAIC NUMBER TEN",
    "111EB": "SINHALA ARCHAIC NUMBER TWENTY",
    "111EC": "SINHALA ARCHAIC NUMBER THIRTY",
    "111ED": "SINHALA ARCHAIC NUMBER FORTY",
    "111EE": "SINHALA ARCHAIC NUMBER FIFTY",
    "111EF": "SINHALA ARCHAIC NUMBER SIXTY",
    "111F0": "SINHALA ARCHAIC NUMBER SEVENTY",
    "111F1": "SINHALA ARCHAIC NUMBER EIGHTY",
    "111F2": "SINHALA ARCHAIC NUMBER NINETY",
    "111F3": "SINHALA ARCHAIC NUMBER ONE HUNDRED",
    "111F4": "SINHALA ARCHAIC NUMBER ONE THOUSAND",
    "11200": "KHOJKI LETTER A",
    "11201": "KHOJKI LETTER AA",
    "11202": "KHOJKI LETTER I",
    "11203": "KHOJKI LETTER U",
    "11204": "KHOJKI LETTER E",
    "11205": "KHOJKI LETTER AI",
    "11206": "KHOJKI LETTER O",
    "11207": "KHOJKI LETTER AU",
    "11208": "KHOJKI LETTER KA",
    "11209": "KHOJKI LETTER KHA",
    "1120A": "KHOJKI LETTER GA",
    "1120B": "KHOJKI LETTER GGA",
    "1120C": "KHOJKI LETTER GHA",
    "1120D": "KHOJKI LETTER NGA",
    "1120E": "KHOJKI LETTER CA",
    "1120F": "KHOJKI LETTER CHA",
    "11210": "KHOJKI LETTER JA",
    "11211": "KHOJKI LETTER JJA",
    "11213": "KHOJKI LETTER NYA",
    "11214": "KHOJKI LETTER TTA",
    "11215": "KHOJKI LETTER TTHA",
    "11216": "KHOJKI LETTER DDA",
    "11217": "KHOJKI LETTER DDHA",
    "11218": "KHOJKI LETTER NNA",
    "11219": "KHOJKI LETTER TA",
    "1121A": "KHOJKI LETTER THA",
    "1121B": "KHOJKI LETTER DA",
    "1121C": "KHOJKI LETTER DDDA",
    "1121D": "KHOJKI LETTER DHA",
    "1121E": "KHOJKI LETTER NA",
    "1121F": "KHOJKI LETTER PA",
    "11220": "KHOJKI LETTER PHA",
    "11221": "KHOJKI LETTER BA",
    "11222": "KHOJKI LETTER BBA",
    "11223": "KHOJKI LETTER BHA",
    "11224": "KHOJKI LETTER MA",
    "11225": "KHOJKI LETTER YA",
    "11226": "KHOJKI LETTER RA",
    "11227": "KHOJKI LETTER LA",
    "11228": "KHOJKI LETTER VA",
    "11229": "KHOJKI LETTER SA",
    "1122A": "KHOJKI LETTER HA",
    "1122B": "KHOJKI LETTER LLA",
    "1122C": "KHOJKI VOWEL SIGN AA",
    "1122D": "KHOJKI VOWEL SIGN I",
    "1122E": "KHOJKI VOWEL SIGN II",
    "1122F": "KHOJKI VOWEL SIGN U",
    "11230": "KHOJKI VOWEL SIGN E",
    "11231": "KHOJKI VOWEL SIGN AI",
    "11232": "KHOJKI VOWEL SIGN O",
    "11233": "KHOJKI VOWEL SIGN AU",
    "11234": "KHOJKI SIGN ANUSVARA",
    "11235": "KHOJKI SIGN VIRAMA",
    "11236": "KHOJKI SIGN NUKTA",
    "11237": "KHOJKI SIGN SHADDA",
    "11238": "KHOJKI DANDA",
    "11239": "KHOJKI DOUBLE DANDA",
    "1123A": "KHOJKI WORD SEPARATOR",
    "1123B": "KHOJKI SECTION MARK",
    "1123C": "KHOJKI DOUBLE SECTION MARK",
    "1123D": "KHOJKI ABBREVIATION SIGN",
    "1123E": "KHOJKI SIGN SUKUN",
    "11280": "MULTANI LETTER A",
    "11281": "MULTANI LETTER I",
    "11282": "MULTANI LETTER U",
    "11283": "MULTANI LETTER E",
    "11284": "MULTANI LETTER KA",
    "11285": "MULTANI LETTER KHA",
    "11286": "MULTANI LETTER GA",
    "11288": "MULTANI LETTER GHA",
    "1128A": "MULTANI LETTER CA",
    "1128B": "MULTANI LETTER CHA",
    "1128C": "MULTANI LETTER JA",
    "1128D": "MULTANI LETTER JJA",
    "1128F": "MULTANI LETTER NYA",
    "11290": "MULTANI LETTER TTA",
    "11291": "MULTANI LETTER TTHA",
    "11292": "MULTANI LETTER DDA",
    "11293": "MULTANI LETTER DDDA",
    "11294": "MULTANI LETTER DDHA",
    "11295": "MULTANI LETTER NNA",
    "11296": "MULTANI LETTER TA",
    "11297": "MULTANI LETTER THA",
    "11298": "MULTANI LETTER DA",
    "11299": "MULTANI LETTER DHA",
    "1129A": "MULTANI LETTER NA",
    "1129B": "MULTANI LETTER PA",
    "1129C": "MULTANI LETTER PHA",
    "1129D": "MULTANI LETTER BA",
    "1129F": "MULTANI LETTER BHA",
    "112A0": "MULTANI LETTER MA",
    "112A1": "MULTANI LETTER YA",
    "112A2": "MULTANI LETTER RA",
    "112A3": "MULTANI LETTER LA",
    "112A4": "MULTANI LETTER VA",
    "112A5": "MULTANI LETTER SA",
    "112A6": "MULTANI LETTER HA",
    "112A7": "MULTANI LETTER RRA",
    "112A8": "MULTANI LETTER RHA",
    "112A9": "MULTANI SECTION MARK",
    "112B0": "KHUDAWADI LETTER A",
    "112B1": "KHUDAWADI LETTER AA",
    "112B2": "KHUDAWADI LETTER I",
    "112B3": "KHUDAWADI LETTER II",
    "112B4": "KHUDAWADI LETTER U",
    "112B5": "KHUDAWADI LETTER UU",
    "112B6": "KHUDAWADI LETTER E",
    "112B7": "KHUDAWADI LETTER AI",
    "112B8": "KHUDAWADI LETTER O",
    "112B9": "KHUDAWADI LETTER AU",
    "112BA": "KHUDAWADI LETTER KA",
    "112BB": "KHUDAWADI LETTER KHA",
    "112BC": "KHUDAWADI LETTER GA",
    "112BD": "KHUDAWADI LETTER GGA",
    "112BE": "KHUDAWADI LETTER GHA",
    "112BF": "KHUDAWADI LETTER NGA",
    "112C0": "KHUDAWADI LETTER CA",
    "112C1": "KHUDAWADI LETTER CHA",
    "112C2": "KHUDAWADI LETTER JA",
    "112C3": "KHUDAWADI LETTER JJA",
    "112C4": "KHUDAWADI LETTER JHA",
    "112C5": "KHUDAWADI LETTER NYA",
    "112C6": "KHUDAWADI LETTER TTA",
    "112C7": "KHUDAWADI LETTER TTHA",
    "112C8": "KHUDAWADI LETTER DDA",
    "112C9": "KHUDAWADI LETTER DDDA",
    "112CA": "KHUDAWADI LETTER RRA",
    "112CB": "KHUDAWADI LETTER DDHA",
    "112CC": "KHUDAWADI LETTER NNA",
    "112CD": "KHUDAWADI LETTER TA",
    "112CE": "KHUDAWADI LETTER THA",
    "112CF": "KHUDAWADI LETTER DA",
    "112D0": "KHUDAWADI LETTER DHA",
    "112D1": "KHUDAWADI LETTER NA",
    "112D2": "KHUDAWADI LETTER PA",
    "112D3": "KHUDAWADI LETTER PHA",
    "112D4": "KHUDAWADI LETTER BA",
    "112D5": "KHUDAWADI LETTER BBA",
    "112D6": "KHUDAWADI LETTER BHA",
    "112D7": "KHUDAWADI LETTER MA",
    "112D8": "KHUDAWADI LETTER YA",
    "112D9": "KHUDAWADI LETTER RA",
    "112DA": "KHUDAWADI LETTER LA",
    "112DB": "KHUDAWADI LETTER VA",
    "112DC": "KHUDAWADI LETTER SHA",
    "112DD": "KHUDAWADI LETTER SA",
    "112DE": "KHUDAWADI LETTER HA",
    "112DF": "KHUDAWADI SIGN ANUSVARA",
    "112E0": "KHUDAWADI VOWEL SIGN AA",
    "112E1": "KHUDAWADI VOWEL SIGN I",
    "112E2": "KHUDAWADI VOWEL SIGN II",
    "112E3": "KHUDAWADI VOWEL SIGN U",
    "112E4": "KHUDAWADI VOWEL SIGN UU",
    "112E5": "KHUDAWADI VOWEL SIGN E",
    "112E6": "KHUDAWADI VOWEL SIGN AI",
    "112E7": "KHUDAWADI VOWEL SIGN O",
    "112E8": "KHUDAWADI VOWEL SIGN AU",
    "112E9": "KHUDAWADI SIGN NUKTA",
    "112EA": "KHUDAWADI SIGN VIRAMA",
    "112F0": "KHUDAWADI DIGIT ZERO",
    "112F1": "KHUDAWADI DIGIT ONE",
    "112F2": "KHUDAWADI DIGIT TWO",
    "112F3": "KHUDAWADI DIGIT THREE",
    "112F4": "KHUDAWADI DIGIT FOUR",
    "112F5": "KHUDAWADI DIGIT FIVE",
    "112F6": "KHUDAWADI DIGIT SIX",
    "112F7": "KHUDAWADI DIGIT SEVEN",
    "112F8": "KHUDAWADI DIGIT EIGHT",
    "112F9": "KHUDAWADI DIGIT NINE",
    "11300": "GRANTHA SIGN COMBINING ANUSVARA ABOVE",
    "11301": "GRANTHA SIGN CANDRABINDU",
    "11302": "GRANTHA SIGN ANUSVARA",
    "11303": "GRANTHA SIGN VISARGA",
    "11305": "GRANTHA LETTER A",
    "11306": "GRANTHA LETTER AA",
    "11307": "GRANTHA LETTER I",
    "11308": "GRANTHA LETTER II",
    "11309": "GRANTHA LETTER U",
    "1130A": "GRANTHA LETTER UU",
    "1130B": "GRANTHA LETTER VOCALIC R",
    "1130C": "GRANTHA LETTER VOCALIC L",
    "1130F": "GRANTHA LETTER EE",
    "11310": "GRANTHA LETTER AI",
    "11313": "GRANTHA LETTER OO",
    "11314": "GRANTHA LETTER AU",
    "11315": "GRANTHA LETTER KA",
    "11316": "GRANTHA LETTER KHA",
    "11317": "GRANTHA LETTER GA",
    "11318": "GRANTHA LETTER GHA",
    "11319": "GRANTHA LETTER NGA",
    "1131A": "GRANTHA LETTER CA",
    "1131B": "GRANTHA LETTER CHA",
    "1131C": "GRANTHA LETTER JA",
    "1131D": "GRANTHA LETTER JHA",
    "1131E": "GRANTHA LETTER NYA",
    "1131F": "GRANTHA LETTER TTA",
    "11320": "GRANTHA LETTER TTHA",
    "11321": "GRANTHA LETTER DDA",
    "11322": "GRANTHA LETTER DDHA",
    "11323": "GRANTHA LETTER NNA",
    "11324": "GRANTHA LETTER TA",
    "11325": "GRANTHA LETTER THA",
    "11326": "GRANTHA LETTER DA",
    "11327": "GRANTHA LETTER DHA",
    "11328": "GRANTHA LETTER NA",
    "1132A": "GRANTHA LETTER PA",
    "1132B": "GRANTHA LETTER PHA",
    "1132C": "GRANTHA LETTER BA",
    "1132D": "GRANTHA LETTER BHA",
    "1132E": "GRANTHA LETTER MA",
    "1132F": "GRANTHA LETTER YA",
    "11330": "GRANTHA LETTER RA",
    "11332": "GRANTHA LETTER LA",
    "11333": "GRANTHA LETTER LLA",
    "11335": "GRANTHA LETTER VA",
    "11336": "GRANTHA LETTER SHA",
    "11337": "GRANTHA LETTER SSA",
    "11338": "GRANTHA LETTER SA",
    "11339": "GRANTHA LETTER HA",
    "1133C": "GRANTHA SIGN NUKTA",
    "1133D": "GRANTHA SIGN AVAGRAHA",
    "1133E": "GRANTHA VOWEL SIGN AA",
    "1133F": "GRANTHA VOWEL SIGN I",
    "11340": "GRANTHA VOWEL SIGN II",
    "11341": "GRANTHA VOWEL SIGN U",
    "11342": "GRANTHA VOWEL SIGN UU",
    "11343": "GRANTHA VOWEL SIGN VOCALIC R",
    "11344": "GRANTHA VOWEL SIGN VOCALIC RR",
    "11347": "GRANTHA VOWEL SIGN EE",
    "11348": "GRANTHA VOWEL SIGN AI",
    "1134B": "GRANTHA VOWEL SIGN OO",
    "1134C": "GRANTHA VOWEL SIGN AU",
    "1134D": "GRANTHA SIGN VIRAMA",
    "11350": "GRANTHA OM",
    "11357": "GRANTHA AU LENGTH MARK",
    "1135D": "GRANTHA SIGN PLUTA",
    "1135E": "GRANTHA LETTER VEDIC ANUSVARA",
    "1135F": "GRANTHA LETTER VEDIC DOUBLE ANUSVARA",
    "11360": "GRANTHA LETTER VOCALIC RR",
    "11361": "GRANTHA LETTER VOCALIC LL",
    "11362": "GRANTHA VOWEL SIGN VOCALIC L",
    "11363": "GRANTHA VOWEL SIGN VOCALIC LL",
    "11366": "COMBINING GRANTHA DIGIT ZERO",
    "11367": "COMBINING GRANTHA DIGIT ONE",
    "11368": "COMBINING GRANTHA DIGIT TWO",
    "11369": "COMBINING GRANTHA DIGIT THREE",
    "1136A": "COMBINING GRANTHA DIGIT FOUR",
    "1136B": "COMBINING GRANTHA DIGIT FIVE",
    "1136C": "COMBINING GRANTHA DIGIT SIX",
    "11370": "COMBINING GRANTHA LETTER A",
    "11371": "COMBINING GRANTHA LETTER KA",
    "11372": "COMBINING GRANTHA LETTER NA",
    "11373": "COMBINING GRANTHA LETTER VI",
    "11374": "COMBINING GRANTHA LETTER PA",
    "11400": "NEWA LETTER A",
    "11401": "NEWA LETTER AA",
    "11402": "NEWA LETTER I",
    "11403": "NEWA LETTER II",
    "11404": "NEWA LETTER U",
    "11405": "NEWA LETTER UU",
    "11406": "NEWA LETTER VOCALIC R",
    "11407": "NEWA LETTER VOCALIC RR",
    "11408": "NEWA LETTER VOCALIC L",
    "11409": "NEWA LETTER VOCALIC LL",
    "1140A": "NEWA LETTER E",
    "1140B": "NEWA LETTER AI",
    "1140C": "NEWA LETTER O",
    "1140D": "NEWA LETTER AU",
    "1140E": "NEWA LETTER KA",
    "1140F": "NEWA LETTER KHA",
    "11410": "NEWA LETTER GA",
    "11411": "NEWA LETTER GHA",
    "11412": "NEWA LETTER NGA",
    "11413": "NEWA LETTER NGHA",
    "11414": "NEWA LETTER CA",
    "11415": "NEWA LETTER CHA",
    "11416": "NEWA LETTER JA",
    "11417": "NEWA LETTER JHA",
    "11418": "NEWA LETTER NYA",
    "11419": "NEWA LETTER NYHA",
    "1141A": "NEWA LETTER TTA",
    "1141B": "NEWA LETTER TTHA",
    "1141C": "NEWA LETTER DDA",
    "1141D": "NEWA LETTER DDHA",
    "1141E": "NEWA LETTER NNA",
    "1141F": "NEWA LETTER TA",
    "11420": "NEWA LETTER THA",
    "11421": "NEWA LETTER DA",
    "11422": "NEWA LETTER DHA",
    "11423": "NEWA LETTER NA",
    "11424": "NEWA LETTER NHA",
    "11425": "NEWA LETTER PA",
    "11426": "NEWA LETTER PHA",
    "11427": "NEWA LETTER BA",
    "11428": "NEWA LETTER BHA",
    "11429": "NEWA LETTER MA",
    "1142A": "NEWA LETTER MHA",
    "1142B": "NEWA LETTER YA",
    "1142C": "NEWA LETTER RA",
    "1142D": "NEWA LETTER RHA",
    "1142E": "NEWA LETTER LA",
    "1142F": "NEWA LETTER LHA",
    "11430": "NEWA LETTER WA",
    "11431": "NEWA LETTER SHA",
    "11432": "NEWA LETTER SSA",
    "11433": "NEWA LETTER SA",
    "11434": "NEWA LETTER HA",
    "11435": "NEWA VOWEL SIGN AA",
    "11436": "NEWA VOWEL SIGN I",
    "11437": "NEWA VOWEL SIGN II",
    "11438": "NEWA VOWEL SIGN U",
    "11439": "NEWA VOWEL SIGN UU",
    "1143A": "NEWA VOWEL SIGN VOCALIC R",
    "1143B": "NEWA VOWEL SIGN VOCALIC RR",
    "1143C": "NEWA VOWEL SIGN VOCALIC L",
    "1143D": "NEWA VOWEL SIGN VOCALIC LL",
    "1143E": "NEWA VOWEL SIGN E",
    "1143F": "NEWA VOWEL SIGN AI",
    "11440": "NEWA VOWEL SIGN O",
    "11441": "NEWA VOWEL SIGN AU",
    "11442": "NEWA SIGN VIRAMA",
    "11443": "NEWA SIGN CANDRABINDU",
    "11444": "NEWA SIGN ANUSVARA",
    "11445": "NEWA SIGN VISARGA",
    "11446": "NEWA SIGN NUKTA",
    "11447": "NEWA SIGN AVAGRAHA",
    "11448": "NEWA SIGN FINAL ANUSVARA",
    "11449": "NEWA OM",
    "1144A": "NEWA SIDDHI",
    "1144B": "NEWA DANDA",
    "1144C": "NEWA DOUBLE DANDA",
    "1144D": "NEWA COMMA",
    "1144E": "NEWA GAP FILLER",
    "1144F": "NEWA ABBREVIATION SIGN",
    "11450": "NEWA DIGIT ZERO",
    "11451": "NEWA DIGIT ONE",
    "11452": "NEWA DIGIT TWO",
    "11453": "NEWA DIGIT THREE",
    "11454": "NEWA DIGIT FOUR",
    "11455": "NEWA DIGIT FIVE",
    "11456": "NEWA DIGIT SIX",
    "11457": "NEWA DIGIT SEVEN",
    "11458": "NEWA DIGIT EIGHT",
    "11459": "NEWA DIGIT NINE",
    "1145B": "NEWA PLACEHOLDER MARK",
    "1145D": "NEWA INSERTION SIGN",
    "11480": "TIRHUTA ANJI",
    "11481": "TIRHUTA LETTER A",
    "11482": "TIRHUTA LETTER AA",
    "11483": "TIRHUTA LETTER I",
    "11484": "TIRHUTA LETTER II",
    "11485": "TIRHUTA LETTER U",
    "11486": "TIRHUTA LETTER UU",
    "11487": "TIRHUTA LETTER VOCALIC R",
    "11488": "TIRHUTA LETTER VOCALIC RR",
    "11489": "TIRHUTA LETTER VOCALIC L",
    "1148A": "TIRHUTA LETTER VOCALIC LL",
    "1148B": "TIRHUTA LETTER E",
    "1148C": "TIRHUTA LETTER AI",
    "1148D": "TIRHUTA LETTER O",
    "1148E": "TIRHUTA LETTER AU",
    "1148F": "TIRHUTA LETTER KA",
    "11490": "TIRHUTA LETTER KHA",
    "11491": "TIRHUTA LETTER GA",
    "11492": "TIRHUTA LETTER GHA",
    "11493": "TIRHUTA LETTER NGA",
    "11494": "TIRHUTA LETTER CA",
    "11495": "TIRHUTA LETTER CHA",
    "11496": "TIRHUTA LETTER JA",
    "11497": "TIRHUTA LETTER JHA",
    "11498": "TIRHUTA LETTER NYA",
    "11499": "TIRHUTA LETTER TTA",
    "1149A": "TIRHUTA LETTER TTHA",
    "1149B": "TIRHUTA LETTER DDA",
    "1149C": "TIRHUTA LETTER DDHA",
    "1149D": "TIRHUTA LETTER NNA",
    "1149E": "TIRHUTA LETTER TA",
    "1149F": "TIRHUTA LETTER THA",
    "114A0": "TIRHUTA LETTER DA",
    "114A1": "TIRHUTA LETTER DHA",
    "114A2": "TIRHUTA LETTER NA",
    "114A3": "TIRHUTA LETTER PA",
    "114A4": "TIRHUTA LETTER PHA",
    "114A5": "TIRHUTA LETTER BA",
    "114A6": "TIRHUTA LETTER BHA",
    "114A7": "TIRHUTA LETTER MA",
    "114A8": "TIRHUTA LETTER YA",
    "114A9": "TIRHUTA LETTER RA",
    "114AA": "TIRHUTA LETTER LA",
    "114AB": "TIRHUTA LETTER VA",
    "114AC": "TIRHUTA LETTER SHA",
    "114AD": "TIRHUTA LETTER SSA",
    "114AE": "TIRHUTA LETTER SA",
    "114AF": "TIRHUTA LETTER HA",
    "114B0": "TIRHUTA VOWEL SIGN AA",
    "114B1": "TIRHUTA VOWEL SIGN I",
    "114B2": "TIRHUTA VOWEL SIGN II",
    "114B3": "TIRHUTA VOWEL SIGN U",
    "114B4": "TIRHUTA VOWEL SIGN UU",
    "114B5": "TIRHUTA VOWEL SIGN VOCALIC R",
    "114B6": "TIRHUTA VOWEL SIGN VOCALIC RR",
    "114B7": "TIRHUTA VOWEL SIGN VOCALIC L",
    "114B8": "TIRHUTA VOWEL SIGN VOCALIC LL",
    "114B9": "TIRHUTA VOWEL SIGN E",
    "114BA": "TIRHUTA VOWEL SIGN SHORT E",
    "114BB": "TIRHUTA VOWEL SIGN AI",
    "114BC": "TIRHUTA VOWEL SIGN O",
    "114BD": "TIRHUTA VOWEL SIGN SHORT O",
    "114BE": "TIRHUTA VOWEL SIGN AU",
    "114BF": "TIRHUTA SIGN CANDRABINDU",
    "114C0": "TIRHUTA SIGN ANUSVARA",
    "114C1": "TIRHUTA SIGN VISARGA",
    "114C2": "TIRHUTA SIGN VIRAMA",
    "114C3": "TIRHUTA SIGN NUKTA",
    "114C4": "TIRHUTA SIGN AVAGRAHA",
    "114C5": "TIRHUTA GVANG",
    "114C6": "TIRHUTA ABBREVIATION SIGN",
    "114C7": "TIRHUTA OM",
    "114D0": "TIRHUTA DIGIT ZERO",
    "114D1": "TIRHUTA DIGIT ONE",
    "114D2": "TIRHUTA DIGIT TWO",
    "114D3": "TIRHUTA DIGIT THREE",
    "114D4": "TIRHUTA DIGIT FOUR",
    "114D5": "TIRHUTA DIGIT FIVE",
    "114D6": "TIRHUTA DIGIT SIX",
    "114D7": "TIRHUTA DIGIT SEVEN",
    "114D8": "TIRHUTA DIGIT EIGHT",
    "114D9": "TIRHUTA DIGIT NINE",
    "11580": "SIDDHAM LETTER A",
    "11581": "SIDDHAM LETTER AA",
    "11582": "SIDDHAM LETTER I",
    "11583": "SIDDHAM LETTER II",
    "11584": "SIDDHAM LETTER U",
    "11585": "SIDDHAM LETTER UU",
    "11586": "SIDDHAM LETTER VOCALIC R",
    "11587": "SIDDHAM LETTER VOCALIC RR",
    "11588": "SIDDHAM LETTER VOCALIC L",
    "11589": "SIDDHAM LETTER VOCALIC LL",
    "1158A": "SIDDHAM LETTER E",
    "1158B": "SIDDHAM LETTER AI",
    "1158C": "SIDDHAM LETTER O",
    "1158D": "SIDDHAM LETTER AU",
    "1158E": "SIDDHAM LETTER KA",
    "1158F": "SIDDHAM LETTER KHA",
    "11590": "SIDDHAM LETTER GA",
    "11591": "SIDDHAM LETTER GHA",
    "11592": "SIDDHAM LETTER NGA",
    "11593": "SIDDHAM LETTER CA",
    "11594": "SIDDHAM LETTER CHA",
    "11595": "SIDDHAM LETTER JA",
    "11596": "SIDDHAM LETTER JHA",
    "11597": "SIDDHAM LETTER NYA",
    "11598": "SIDDHAM LETTER TTA",
    "11599": "SIDDHAM LETTER TTHA",
    "1159A": "SIDDHAM LETTER DDA",
    "1159B": "SIDDHAM LETTER DDHA",
    "1159C": "SIDDHAM LETTER NNA",
    "1159D": "SIDDHAM LETTER TA",
    "1159E": "SIDDHAM LETTER THA",
    "1159F": "SIDDHAM LETTER DA",
    "115A0": "SIDDHAM LETTER DHA",
    "115A1": "SIDDHAM LETTER NA",
    "115A2": "SIDDHAM LETTER PA",
    "115A3": "SIDDHAM LETTER PHA",
    "115A4": "SIDDHAM LETTER BA",
    "115A5": "SIDDHAM LETTER BHA",
    "115A6": "SIDDHAM LETTER MA",
    "115A7": "SIDDHAM LETTER YA",
    "115A8": "SIDDHAM LETTER RA",
    "115A9": "SIDDHAM LETTER LA",
    "115AA": "SIDDHAM LETTER VA",
    "115AB": "SIDDHAM LETTER SHA",
    "115AC": "SIDDHAM LETTER SSA",
    "115AD": "SIDDHAM LETTER SA",
    "115AE": "SIDDHAM LETTER HA",
    "115AF": "SIDDHAM VOWEL SIGN AA",
    "115B0": "SIDDHAM VOWEL SIGN I",
    "115B1": "SIDDHAM VOWEL SIGN II",
    "115B2": "SIDDHAM VOWEL SIGN U",
    "115B3": "SIDDHAM VOWEL SIGN UU",
    "115B4": "SIDDHAM VOWEL SIGN VOCALIC R",
    "115B5": "SIDDHAM VOWEL SIGN VOCALIC RR",
    "115B8": "SIDDHAM VOWEL SIGN E",
    "115B9": "SIDDHAM VOWEL SIGN AI",
    "115BA": "SIDDHAM VOWEL SIGN O",
    "115BB": "SIDDHAM VOWEL SIGN AU",
    "115BC": "SIDDHAM SIGN CANDRABINDU",
    "115BD": "SIDDHAM SIGN ANUSVARA",
    "115BE": "SIDDHAM SIGN VISARGA",
    "115BF": "SIDDHAM SIGN VIRAMA",
    "115C0": "SIDDHAM SIGN NUKTA",
    "115C1": "SIDDHAM SIGN SIDDHAM",
    "115C2": "SIDDHAM DANDA",
    "115C3": "SIDDHAM DOUBLE DANDA",
    "115C4": "SIDDHAM SEPARATOR DOT",
    "115C5": "SIDDHAM SEPARATOR BAR",
    "115C6": "SIDDHAM REPETITION MARK-1",
    "115C7": "SIDDHAM REPETITION MARK-2",
    "115C8": "SIDDHAM REPETITION MARK-3",
    "115C9": "SIDDHAM END OF TEXT MARK",
    "115CA": "SIDDHAM SECTION MARK WITH TRIDENT AND U-SHAPED ORNAMENTS",
    "115CB": "SIDDHAM SECTION MARK WITH TRIDENT AND DOTTED CRESCENTS",
    "115CC": "SIDDHAM SECTION MARK WITH RAYS AND DOTTED CRESCENTS",
    "115CD": "SIDDHAM SECTION MARK WITH RAYS AND DOTTED DOUBLE CRESCENTS",
    "115CE": "SIDDHAM SECTION MARK WITH RAYS AND DOTTED TRIPLE CRESCENTS",
    "115CF": "SIDDHAM SECTION MARK DOUBLE RING",
    "115D0": "SIDDHAM SECTION MARK DOUBLE RING WITH RAYS",
    "115D1": "SIDDHAM SECTION MARK WITH DOUBLE CRESCENTS",
    "115D2": "SIDDHAM SECTION MARK WITH TRIPLE CRESCENTS",
    "115D3": "SIDDHAM SECTION MARK WITH QUADRUPLE CRESCENTS",
    "115D4": "SIDDHAM SECTION MARK WITH SEPTUPLE CRESCENTS",
    "115D5": "SIDDHAM SECTION MARK WITH CIRCLES AND RAYS",
    "115D6": "SIDDHAM SECTION MARK WITH CIRCLES AND TWO ENCLOSURES",
    "115D7": "SIDDHAM SECTION MARK WITH CIRCLES AND FOUR ENCLOSURES",
    "115D8": "SIDDHAM LETTER THREE-CIRCLE ALTERNATE I",
    "115D9": "SIDDHAM LETTER TWO-CIRCLE ALTERNATE I",
    "115DA": "SIDDHAM LETTER TWO-CIRCLE ALTERNATE II",
    "115DB": "SIDDHAM LETTER ALTERNATE U",
    "115DC": "SIDDHAM VOWEL SIGN ALTERNATE U",
    "115DD": "SIDDHAM VOWEL SIGN ALTERNATE UU",
    "11600": "MODI LETTER A",
    "11601": "MODI LETTER AA",
    "11602": "MODI LETTER I",
    "11603": "MODI LETTER II",
    "11604": "MODI LETTER U",
    "11605": "MODI LETTER UU",
    "11606": "MODI LETTER VOCALIC R",
    "11607": "MODI LETTER VOCALIC RR",
    "11608": "MODI LETTER VOCALIC L",
    "11609": "MODI LETTER VOCALIC LL",
    "1160A": "MODI LETTER E",
    "1160B": "MODI LETTER AI",
    "1160C": "MODI LETTER O",
    "1160D": "MODI LETTER AU",
    "1160E": "MODI LETTER KA",
    "1160F": "MODI LETTER KHA",
    "11610": "MODI LETTER GA",
    "11611": "MODI LETTER GHA",
    "11612": "MODI LETTER NGA",
    "11613": "MODI LETTER CA",
    "11614": "MODI LETTER CHA",
    "11615": "MODI LETTER JA",
    "11616": "MODI LETTER JHA",
    "11617": "MODI LETTER NYA",
    "11618": "MODI LETTER TTA",
    "11619": "MODI LETTER TTHA",
    "1161A": "MODI LETTER DDA",
    "1161B": "MODI LETTER DDHA",
    "1161C": "MODI LETTER NNA",
    "1161D": "MODI LETTER TA",
    "1161E": "MODI LETTER THA",
    "1161F": "MODI LETTER DA",
    "11620": "MODI LETTER DHA",
    "11621": "MODI LETTER NA",
    "11622": "MODI LETTER PA",
    "11623": "MODI LETTER PHA",
    "11624": "MODI LETTER BA",
    "11625": "MODI LETTER BHA",
    "11626": "MODI LETTER MA",
    "11627": "MODI LETTER YA",
    "11628": "MODI LETTER RA",
    "11629": "MODI LETTER LA",
    "1162A": "MODI LETTER VA",
    "1162B": "MODI LETTER SHA",
    "1162C": "MODI LETTER SSA",
    "1162D": "MODI LETTER SA",
    "1162E": "MODI LETTER HA",
    "1162F": "MODI LETTER LLA",
    "11630": "MODI VOWEL SIGN AA",
    "11631": "MODI VOWEL SIGN I",
    "11632": "MODI VOWEL SIGN II",
    "11633": "MODI VOWEL SIGN U",
    "11634": "MODI VOWEL SIGN UU",
    "11635": "MODI VOWEL SIGN VOCALIC R",
    "11636": "MODI VOWEL SIGN VOCALIC RR",
    "11637": "MODI VOWEL SIGN VOCALIC L",
    "11638": "MODI VOWEL SIGN VOCALIC LL",
    "11639": "MODI VOWEL SIGN E",
    "1163A": "MODI VOWEL SIGN AI",
    "1163B": "MODI VOWEL SIGN O",
    "1163C": "MODI VOWEL SIGN AU",
    "1163D": "MODI SIGN ANUSVARA",
    "1163E": "MODI SIGN VISARGA",
    "1163F": "MODI SIGN VIRAMA",
    "11640": "MODI SIGN ARDHACANDRA",
    "11641": "MODI DANDA",
    "11642": "MODI DOUBLE DANDA",
    "11643": "MODI ABBREVIATION SIGN",
    "11644": "MODI SIGN HUVA",
    "11650": "MODI DIGIT ZERO",
    "11651": "MODI DIGIT ONE",
    "11652": "MODI DIGIT TWO",
    "11653": "MODI DIGIT THREE",
    "11654": "MODI DIGIT FOUR",
    "11655": "MODI DIGIT FIVE",
    "11656": "MODI DIGIT SIX",
    "11657": "MODI DIGIT SEVEN",
    "11658": "MODI DIGIT EIGHT",
    "11659": "MODI DIGIT NINE",
    "11660": "MONGOLIAN BIRGA WITH ORNAMENT",
    "11661": "MONGOLIAN ROTATED BIRGA",
    "11662": "MONGOLIAN DOUBLE BIRGA WITH ORNAMENT",
    "11663": "MONGOLIAN TRIPLE BIRGA WITH ORNAMENT",
    "11664": "MONGOLIAN BIRGA WITH DOUBLE ORNAMENT",
    "11665": "MONGOLIAN ROTATED BIRGA WITH ORNAMENT",
    "11666": "MONGOLIAN ROTATED BIRGA WITH DOUBLE ORNAMENT",
    "11667": "MONGOLIAN INVERTED BIRGA",
    "11668": "MONGOLIAN INVERTED BIRGA WITH DOUBLE ORNAMENT",
    "11669": "MONGOLIAN SWIRL BIRGA",
    "1166A": "MONGOLIAN SWIRL BIRGA WITH ORNAMENT",
    "1166B": "MONGOLIAN SWIRL BIRGA WITH DOUBLE ORNAMENT",
    "1166C": "MONGOLIAN TURNED SWIRL BIRGA WITH DOUBLE ORNAMENT",
    "11680": "TAKRI LETTER A",
    "11681": "TAKRI LETTER AA",
    "11682": "TAKRI LETTER I",
    "11683": "TAKRI LETTER II",
    "11684": "TAKRI LETTER U",
    "11685": "TAKRI LETTER UU",
    "11686": "TAKRI LETTER E",
    "11687": "TAKRI LETTER AI",
    "11688": "TAKRI LETTER O",
    "11689": "TAKRI LETTER AU",
    "1168A": "TAKRI LETTER KA",
    "1168B": "TAKRI LETTER KHA",
    "1168C": "TAKRI LETTER GA",
    "1168D": "TAKRI LETTER GHA",
    "1168E": "TAKRI LETTER NGA",
    "1168F": "TAKRI LETTER CA",
    "11690": "TAKRI LETTER CHA",
    "11691": "TAKRI LETTER JA",
    "11692": "TAKRI LETTER JHA",
    "11693": "TAKRI LETTER NYA",
    "11694": "TAKRI LETTER TTA",
    "11695": "TAKRI LETTER TTHA",
    "11696": "TAKRI LETTER DDA",
    "11697": "TAKRI LETTER DDHA",
    "11698": "TAKRI LETTER NNA",
    "11699": "TAKRI LETTER TA",
    "1169A": "TAKRI LETTER THA",
    "1169B": "TAKRI LETTER DA",
    "1169C": "TAKRI LETTER DHA",
    "1169D": "TAKRI LETTER NA",
    "1169E": "TAKRI LETTER PA",
    "1169F": "TAKRI LETTER PHA",
    "116A0": "TAKRI LETTER BA",
    "116A1": "TAKRI LETTER BHA",
    "116A2": "TAKRI LETTER MA",
    "116A3": "TAKRI LETTER YA",
    "116A4": "TAKRI LETTER RA",
    "116A5": "TAKRI LETTER LA",
    "116A6": "TAKRI LETTER VA",
    "116A7": "TAKRI LETTER SHA",
    "116A8": "TAKRI LETTER SA",
    "116A9": "TAKRI LETTER HA",
    "116AA": "TAKRI LETTER RRA",
    "116AB": "TAKRI SIGN ANUSVARA",
    "116AC": "TAKRI SIGN VISARGA",
    "116AD": "TAKRI VOWEL SIGN AA",
    "116AE": "TAKRI VOWEL SIGN I",
    "116AF": "TAKRI VOWEL SIGN II",
    "116B0": "TAKRI VOWEL SIGN U",
    "116B1": "TAKRI VOWEL SIGN UU",
    "116B2": "TAKRI VOWEL SIGN E",
    "116B3": "TAKRI VOWEL SIGN AI",
    "116B4": "TAKRI VOWEL SIGN O",
    "116B5": "TAKRI VOWEL SIGN AU",
    "116B6": "TAKRI SIGN VIRAMA",
    "116B7": "TAKRI SIGN NUKTA",
    "116C0": "TAKRI DIGIT ZERO",
    "116C1": "TAKRI DIGIT ONE",
    "116C2": "TAKRI DIGIT TWO",
    "116C3": "TAKRI DIGIT THREE",
    "116C4": "TAKRI DIGIT FOUR",
    "116C5": "TAKRI DIGIT FIVE",
    "116C6": "TAKRI DIGIT SIX",
    "116C7": "TAKRI DIGIT SEVEN",
    "116C8": "TAKRI DIGIT EIGHT",
    "116C9": "TAKRI DIGIT NINE",
    "11700": "AHOM LETTER KA",
    "11701": "AHOM LETTER KHA",
    "11702": "AHOM LETTER NGA",
    "11703": "AHOM LETTER NA",
    "11704": "AHOM LETTER TA",
    "11705": "AHOM LETTER ALTERNATE TA",
    "11706": "AHOM LETTER PA",
    "11707": "AHOM LETTER PHA",
    "11708": "AHOM LETTER BA",
    "11709": "AHOM LETTER MA",
    "1170A": "AHOM LETTER JA",
    "1170B": "AHOM LETTER CHA",
    "1170C": "AHOM LETTER THA",
    "1170D": "AHOM LETTER RA",
    "1170E": "AHOM LETTER LA",
    "1170F": "AHOM LETTER SA",
    "11710": "AHOM LETTER NYA",
    "11711": "AHOM LETTER HA",
    "11712": "AHOM LETTER A",
    "11713": "AHOM LETTER DA",
    "11714": "AHOM LETTER DHA",
    "11715": "AHOM LETTER GA",
    "11716": "AHOM LETTER ALTERNATE GA",
    "11717": "AHOM LETTER GHA",
    "11718": "AHOM LETTER BHA",
    "11719": "AHOM LETTER JHA",
    "1171D": "AHOM CONSONANT SIGN MEDIAL LA",
    "1171E": "AHOM CONSONANT SIGN MEDIAL RA",
    "1171F": "AHOM CONSONANT SIGN MEDIAL LIGATING RA",
    "11720": "AHOM VOWEL SIGN A",
    "11721": "AHOM VOWEL SIGN AA",
    "11722": "AHOM VOWEL SIGN I",
    "11723": "AHOM VOWEL SIGN II",
    "11724": "AHOM VOWEL SIGN U",
    "11725": "AHOM VOWEL SIGN UU",
    "11726": "AHOM VOWEL SIGN E",
    "11727": "AHOM VOWEL SIGN AW",
    "11728": "AHOM VOWEL SIGN O",
    "11729": "AHOM VOWEL SIGN AI",
    "1172A": "AHOM VOWEL SIGN AM",
    "1172B": "AHOM SIGN KILLER",
    "11730": "AHOM DIGIT ZERO",
    "11731": "AHOM DIGIT ONE",
    "11732": "AHOM DIGIT TWO",
    "11733": "AHOM DIGIT THREE",
    "11734": "AHOM DIGIT FOUR",
    "11735": "AHOM DIGIT FIVE",
    "11736": "AHOM DIGIT SIX",
    "11737": "AHOM DIGIT SEVEN",
    "11738": "AHOM DIGIT EIGHT",
    "11739": "AHOM DIGIT NINE",
    "1173A": "AHOM NUMBER TEN",
    "1173B": "AHOM NUMBER TWENTY",
    "1173C": "AHOM SIGN SMALL SECTION",
    "1173D": "AHOM SIGN SECTION",
    "1173E": "AHOM SIGN RULAI",
    "1173F": "AHOM SYMBOL VI",
    "118A0": "WARANG CITI CAPITAL LETTER NGAA",
    "118A1": "WARANG CITI CAPITAL LETTER A",
    "118A2": "WARANG CITI CAPITAL LETTER WI",
    "118A3": "WARANG CITI CAPITAL LETTER YU",
    "118A4": "WARANG CITI CAPITAL LETTER YA",
    "118A5": "WARANG CITI CAPITAL LETTER YO",
    "118A6": "WARANG CITI CAPITAL LETTER II",
    "118A7": "WARANG CITI CAPITAL LETTER UU",
    "118A8": "WARANG CITI CAPITAL LETTER E",
    "118A9": "WARANG CITI CAPITAL LETTER O",
    "118AA": "WARANG CITI CAPITAL LETTER ANG",
    "118AB": "WARANG CITI CAPITAL LETTER GA",
    "118AC": "WARANG CITI CAPITAL LETTER KO",
    "118AD": "WARANG CITI CAPITAL LETTER ENY",
    "118AE": "WARANG CITI CAPITAL LETTER YUJ",
    "118AF": "WARANG CITI CAPITAL LETTER UC",
    "118B0": "WARANG CITI CAPITAL LETTER ENN",
    "118B1": "WARANG CITI CAPITAL LETTER ODD",
    "118B2": "WARANG CITI CAPITAL LETTER TTE",
    "118B3": "WARANG CITI CAPITAL LETTER NUNG",
    "118B4": "WARANG CITI CAPITAL LETTER DA",
    "118B5": "WARANG CITI CAPITAL LETTER AT",
    "118B6": "WARANG CITI CAPITAL LETTER AM",
    "118B7": "WARANG CITI CAPITAL LETTER BU",
    "118B8": "WARANG CITI CAPITAL LETTER PU",
    "118B9": "WARANG CITI CAPITAL LETTER HIYO",
    "118BA": "WARANG CITI CAPITAL LETTER HOLO",
    "118BB": "WARANG CITI CAPITAL LETTER HORR",
    "118BC": "WARANG CITI CAPITAL LETTER HAR",
    "118BD": "WARANG CITI CAPITAL LETTER SSUU",
    "118BE": "WARANG CITI CAPITAL LETTER SII",
    "118BF": "WARANG CITI CAPITAL LETTER VIYO",
    "118C0": "WARANG CITI SMALL LETTER NGAA",
    "118C1": "WARANG CITI SMALL LETTER A",
    "118C2": "WARANG CITI SMALL LETTER WI",
    "118C3": "WARANG CITI SMALL LETTER YU",
    "118C4": "WARANG CITI SMALL LETTER YA",
    "118C5": "WARANG CITI SMALL LETTER YO",
    "118C6": "WARANG CITI SMALL LETTER II",
    "118C7": "WARANG CITI SMALL LETTER UU",
    "118C8": "WARANG CITI SMALL LETTER E",
    "118C9": "WARANG CITI SMALL LETTER O",
    "118CA": "WARANG CITI SMALL LETTER ANG",
    "118CB": "WARANG CITI SMALL LETTER GA",
    "118CC": "WARANG CITI SMALL LETTER KO",
    "118CD": "WARANG CITI SMALL LETTER ENY",
    "118CE": "WARANG CITI SMALL LETTER YUJ",
    "118CF": "WARANG CITI SMALL LETTER UC",
    "118D0": "WARANG CITI SMALL LETTER ENN",
    "118D1": "WARANG CITI SMALL LETTER ODD",
    "118D2": "WARANG CITI SMALL LETTER TTE",
    "118D3": "WARANG CITI SMALL LETTER NUNG",
    "118D4": "WARANG CITI SMALL LETTER DA",
    "118D5": "WARANG CITI SMALL LETTER AT",
    "118D6": "WARANG CITI SMALL LETTER AM",
    "118D7": "WARANG CITI SMALL LETTER BU",
    "118D8": "WARANG CITI SMALL LETTER PU",
    "118D9": "WARANG CITI SMALL LETTER HIYO",
    "118DA": "WARANG CITI SMALL LETTER HOLO",
    "118DB": "WARANG CITI SMALL LETTER HORR",
    "118DC": "WARANG CITI SMALL LETTER HAR",
    "118DD": "WARANG CITI SMALL LETTER SSUU",
    "118DE": "WARANG CITI SMALL LETTER SII",
    "118DF": "WARANG CITI SMALL LETTER VIYO",
    "118E0": "WARANG CITI DIGIT ZERO",
    "118E1": "WARANG CITI DIGIT ONE",
    "118E2": "WARANG CITI DIGIT TWO",
    "118E3": "WARANG CITI DIGIT THREE",
    "118E4": "WARANG CITI DIGIT FOUR",
    "118E5": "WARANG CITI DIGIT FIVE",
    "118E6": "WARANG CITI DIGIT SIX",
    "118E7": "WARANG CITI DIGIT SEVEN",
    "118E8": "WARANG CITI DIGIT EIGHT",
    "118E9": "WARANG CITI DIGIT NINE",
    "118EA": "WARANG CITI NUMBER TEN",
    "118EB": "WARANG CITI NUMBER TWENTY",
    "118EC": "WARANG CITI NUMBER THIRTY",
    "118ED": "WARANG CITI NUMBER FORTY",
    "118EE": "WARANG CITI NUMBER FIFTY",
    "118EF": "WARANG CITI NUMBER SIXTY",
    "118F0": "WARANG CITI NUMBER SEVENTY",
    "118F1": "WARANG CITI NUMBER EIGHTY",
    "118F2": "WARANG CITI NUMBER NINETY",
    "118FF": "WARANG CITI OM",
    "11AC0": "PAU CIN HAU LETTER PA",
    "11AC1": "PAU CIN HAU LETTER KA",
    "11AC2": "PAU CIN HAU LETTER LA",
    "11AC3": "PAU CIN HAU LETTER MA",
    "11AC4": "PAU CIN HAU LETTER DA",
    "11AC5": "PAU CIN HAU LETTER ZA",
    "11AC6": "PAU CIN HAU LETTER VA",
    "11AC7": "PAU CIN HAU LETTER NGA",
    "11AC8": "PAU CIN HAU LETTER HA",
    "11AC9": "PAU CIN HAU LETTER GA",
    "11ACA": "PAU CIN HAU LETTER KHA",
    "11ACB": "PAU CIN HAU LETTER SA",
    "11ACC": "PAU CIN HAU LETTER BA",
    "11ACD": "PAU CIN HAU LETTER CA",
    "11ACE": "PAU CIN HAU LETTER TA",
    "11ACF": "PAU CIN HAU LETTER THA",
    "11AD0": "PAU CIN HAU LETTER NA",
    "11AD1": "PAU CIN HAU LETTER PHA",
    "11AD2": "PAU CIN HAU LETTER RA",
    "11AD3": "PAU CIN HAU LETTER FA",
    "11AD4": "PAU CIN HAU LETTER CHA",
    "11AD5": "PAU CIN HAU LETTER A",
    "11AD6": "PAU CIN HAU LETTER E",
    "11AD7": "PAU CIN HAU LETTER I",
    "11AD8": "PAU CIN HAU LETTER O",
    "11AD9": "PAU CIN HAU LETTER U",
    "11ADA": "PAU CIN HAU LETTER UA",
    "11ADB": "PAU CIN HAU LETTER IA",
    "11ADC": "PAU CIN HAU LETTER FINAL P",
    "11ADD": "PAU CIN HAU LETTER FINAL K",
    "11ADE": "PAU CIN HAU LETTER FINAL T",
    "11ADF": "PAU CIN HAU LETTER FINAL M",
    "11AE0": "PAU CIN HAU LETTER FINAL N",
    "11AE1": "PAU CIN HAU LETTER FINAL L",
    "11AE2": "PAU CIN HAU LETTER FINAL W",
    "11AE3": "PAU CIN HAU LETTER FINAL NG",
    "11AE4": "PAU CIN HAU LETTER FINAL Y",
    "11AE5": "PAU CIN HAU RISING TONE LONG",
    "11AE6": "PAU CIN HAU RISING TONE",
    "11AE7": "PAU CIN HAU SANDHI GLOTTAL STOP",
    "11AE8": "PAU CIN HAU RISING TONE LONG FINAL",
    "11AE9": "PAU CIN HAU RISING TONE FINAL",
    "11AEA": "PAU CIN HAU SANDHI GLOTTAL STOP FINAL",
    "11AEB": "PAU CIN HAU SANDHI TONE LONG",
    "11AEC": "PAU CIN HAU SANDHI TONE",
    "11AED": "PAU CIN HAU SANDHI TONE LONG FINAL",
    "11AEE": "PAU CIN HAU SANDHI TONE FINAL",
    "11AEF": "PAU CIN HAU MID-LEVEL TONE",
    "11AF0": "PAU CIN HAU GLOTTAL STOP VARIANT",
    "11AF1": "PAU CIN HAU MID-LEVEL TONE LONG FINAL",
    "11AF2": "PAU CIN HAU MID-LEVEL TONE FINAL",
    "11AF3": "PAU CIN HAU LOW-FALLING TONE LONG",
    "11AF4": "PAU CIN HAU LOW-FALLING TONE",
    "11AF5": "PAU CIN HAU GLOTTAL STOP",
    "11AF6": "PAU CIN HAU LOW-FALLING TONE LONG FINAL",
    "11AF7": "PAU CIN HAU LOW-FALLING TONE FINAL",
    "11AF8": "PAU CIN HAU GLOTTAL STOP FINAL",
    "11C00": "BHAIKSUKI LETTER A",
    "11C01": "BHAIKSUKI LETTER AA",
    "11C02": "BHAIKSUKI LETTER I",
    "11C03": "BHAIKSUKI LETTER II",
    "11C04": "BHAIKSUKI LETTER U",
    "11C05": "BHAIKSUKI LETTER UU",
    "11C06": "BHAIKSUKI LETTER VOCALIC R",
    "11C07": "BHAIKSUKI LETTER VOCALIC RR",
    "11C08": "BHAIKSUKI LETTER VOCALIC L",
    "11C0A": "BHAIKSUKI LETTER E",
    "11C0B": "BHAIKSUKI LETTER AI",
    "11C0C": "BHAIKSUKI LETTER O",
    "11C0D": "BHAIKSUKI LETTER AU",
    "11C0E": "BHAIKSUKI LETTER KA",
    "11C0F": "BHAIKSUKI LETTER KHA",
    "11C10": "BHAIKSUKI LETTER GA",
    "11C11": "BHAIKSUKI LETTER GHA",
    "11C12": "BHAIKSUKI LETTER NGA",
    "11C13": "BHAIKSUKI LETTER CA",
    "11C14": "BHAIKSUKI LETTER CHA",
    "11C15": "BHAIKSUKI LETTER JA",
    "11C16": "BHAIKSUKI LETTER JHA",
    "11C17": "BHAIKSUKI LETTER NYA",
    "11C18": "BHAIKSUKI LETTER TTA",
    "11C19": "BHAIKSUKI LETTER TTHA",
    "11C1A": "BHAIKSUKI LETTER DDA",
    "11C1B": "BHAIKSUKI LETTER DDHA",
    "11C1C": "BHAIKSUKI LETTER NNA",
    "11C1D": "BHAIKSUKI LETTER TA",
    "11C1E": "BHAIKSUKI LETTER THA",
    "11C1F": "BHAIKSUKI LETTER DA",
    "11C20": "BHAIKSUKI LETTER DHA",
    "11C21": "BHAIKSUKI LETTER NA",
    "11C22": "BHAIKSUKI LETTER PA",
    "11C23": "BHAIKSUKI LETTER PHA",
    "11C24": "BHAIKSUKI LETTER BA",
    "11C25": "BHAIKSUKI LETTER BHA",
    "11C26": "BHAIKSUKI LETTER MA",
    "11C27": "BHAIKSUKI LETTER YA",
    "11C28": "BHAIKSUKI LETTER RA",
    "11C29": "BHAIKSUKI LETTER LA",
    "11C2A": "BHAIKSUKI LETTER VA",
    "11C2B": "BHAIKSUKI LETTER SHA",
    "11C2C": "BHAIKSUKI LETTER SSA",
    "11C2D": "BHAIKSUKI LETTER SA",
    "11C2E": "BHAIKSUKI LETTER HA",
    "11C2F": "BHAIKSUKI VOWEL SIGN AA",
    "11C30": "BHAIKSUKI VOWEL SIGN I",
    "11C31": "BHAIKSUKI VOWEL SIGN II",
    "11C32": "BHAIKSUKI VOWEL SIGN U",
    "11C33": "BHAIKSUKI VOWEL SIGN UU",
    "11C34": "BHAIKSUKI VOWEL SIGN VOCALIC R",
    "11C35": "BHAIKSUKI VOWEL SIGN VOCALIC RR",
    "11C36": "BHAIKSUKI VOWEL SIGN VOCALIC L",
    "11C38": "BHAIKSUKI VOWEL SIGN E",
    "11C39": "BHAIKSUKI VOWEL SIGN AI",
    "11C3A": "BHAIKSUKI VOWEL SIGN O",
    "11C3B": "BHAIKSUKI VOWEL SIGN AU",
    "11C3C": "BHAIKSUKI SIGN CANDRABINDU",
    "11C3D": "BHAIKSUKI SIGN ANUSVARA",
    "11C3E": "BHAIKSUKI SIGN VISARGA",
    "11C3F": "BHAIKSUKI SIGN VIRAMA",
    "11C40": "BHAIKSUKI SIGN AVAGRAHA",
    "11C41": "BHAIKSUKI DANDA",
    "11C42": "BHAIKSUKI DOUBLE DANDA",
    "11C43": "BHAIKSUKI WORD SEPARATOR",
    "11C44": "BHAIKSUKI GAP FILLER-1",
    "11C45": "BHAIKSUKI GAP FILLER-2",
    "11C50": "BHAIKSUKI DIGIT ZERO",
    "11C51": "BHAIKSUKI DIGIT ONE",
    "11C52": "BHAIKSUKI DIGIT TWO",
    "11C53": "BHAIKSUKI DIGIT THREE",
    "11C54": "BHAIKSUKI DIGIT FOUR",
    "11C55": "BHAIKSUKI DIGIT FIVE",
    "11C56": "BHAIKSUKI DIGIT SIX",
    "11C57": "BHAIKSUKI DIGIT SEVEN",
    "11C58": "BHAIKSUKI DIGIT EIGHT",
    "11C59": "BHAIKSUKI DIGIT NINE",
    "11C5A": "BHAIKSUKI NUMBER ONE",
    "11C5B": "BHAIKSUKI NUMBER TWO",
    "11C5C": "BHAIKSUKI NUMBER THREE",
    "11C5D": "BHAIKSUKI NUMBER FOUR",
    "11C5E": "BHAIKSUKI NUMBER FIVE",
    "11C5F": "BHAIKSUKI NUMBER SIX",
    "11C60": "BHAIKSUKI NUMBER SEVEN",
    "11C61": "BHAIKSUKI NUMBER EIGHT",
    "11C62": "BHAIKSUKI NUMBER NINE",
    "11C63": "BHAIKSUKI NUMBER TEN",
    "11C64": "BHAIKSUKI NUMBER TWENTY",
    "11C65": "BHAIKSUKI NUMBER THIRTY",
    "11C66": "BHAIKSUKI NUMBER FORTY",
    "11C67": "BHAIKSUKI NUMBER FIFTY",
    "11C68": "BHAIKSUKI NUMBER SIXTY",
    "11C69": "BHAIKSUKI NUMBER SEVENTY",
    "11C6A": "BHAIKSUKI NUMBER EIGHTY",
    "11C6B": "BHAIKSUKI NUMBER NINETY",
    "11C6C": "BHAIKSUKI HUNDREDS UNIT MARK",
    "11C70": "MARCHEN HEAD MARK",
    "11C71": "MARCHEN MARK SHAD",
    "11C72": "MARCHEN LETTER KA",
    "11C73": "MARCHEN LETTER KHA",
    "11C74": "MARCHEN LETTER GA",
    "11C75": "MARCHEN LETTER NGA",
    "11C76": "MARCHEN LETTER CA",
    "11C77": "MARCHEN LETTER CHA",
    "11C78": "MARCHEN LETTER JA",
    "11C79": "MARCHEN LETTER NYA",
    "11C7A": "MARCHEN LETTER TA",
    "11C7B": "MARCHEN LETTER THA",
    "11C7C": "MARCHEN LETTER DA",
    "11C7D": "MARCHEN LETTER NA",
    "11C7E": "MARCHEN LETTER PA",
    "11C7F": "MARCHEN LETTER PHA",
    "11C80": "MARCHEN LETTER BA",
    "11C81": "MARCHEN LETTER MA",
    "11C82": "MARCHEN LETTER TSA",
    "11C83": "MARCHEN LETTER TSHA",
    "11C84": "MARCHEN LETTER DZA",
    "11C85": "MARCHEN LETTER WA",
    "11C86": "MARCHEN LETTER ZHA",
    "11C87": "MARCHEN LETTER ZA",
    "11C88": "MARCHEN LETTER -A",
    "11C89": "MARCHEN LETTER YA",
    "11C8A": "MARCHEN LETTER RA",
    "11C8B": "MARCHEN LETTER LA",
    "11C8C": "MARCHEN LETTER SHA",
    "11C8D": "MARCHEN LETTER SA",
    "11C8E": "MARCHEN LETTER HA",
    "11C8F": "MARCHEN LETTER A",
    "11C92": "MARCHEN SUBJOINED LETTER KA",
    "11C93": "MARCHEN SUBJOINED LETTER KHA",
    "11C94": "MARCHEN SUBJOINED LETTER GA",
    "11C95": "MARCHEN SUBJOINED LETTER NGA",
    "11C96": "MARCHEN SUBJOINED LETTER CA",
    "11C97": "MARCHEN SUBJOINED LETTER CHA",
    "11C98": "MARCHEN SUBJOINED LETTER JA",
    "11C99": "MARCHEN SUBJOINED LETTER NYA",
    "11C9A": "MARCHEN SUBJOINED LETTER TA",
    "11C9B": "MARCHEN SUBJOINED LETTER THA",
    "11C9C": "MARCHEN SUBJOINED LETTER DA",
    "11C9D": "MARCHEN SUBJOINED LETTER NA",
    "11C9E": "MARCHEN SUBJOINED LETTER PA",
    "11C9F": "MARCHEN SUBJOINED LETTER PHA",
    "11CA0": "MARCHEN SUBJOINED LETTER BA",
    "11CA1": "MARCHEN SUBJOINED LETTER MA",
    "11CA2": "MARCHEN SUBJOINED LETTER TSA",
    "11CA3": "MARCHEN SUBJOINED LETTER TSHA",
    "11CA4": "MARCHEN SUBJOINED LETTER DZA",
    "11CA5": "MARCHEN SUBJOINED LETTER WA",
    "11CA6": "MARCHEN SUBJOINED LETTER ZHA",
    "11CA7": "MARCHEN SUBJOINED LETTER ZA",
    "11CA9": "MARCHEN SUBJOINED LETTER YA",
    "11CAA": "MARCHEN SUBJOINED LETTER RA",
    "11CAB": "MARCHEN SUBJOINED LETTER LA",
    "11CAC": "MARCHEN SUBJOINED LETTER SHA",
    "11CAD": "MARCHEN SUBJOINED LETTER SA",
    "11CAE": "MARCHEN SUBJOINED LETTER HA",
    "11CAF": "MARCHEN SUBJOINED LETTER A",
    "11CB0": "MARCHEN VOWEL SIGN AA",
    "11CB1": "MARCHEN VOWEL SIGN I",
    "11CB2": "MARCHEN VOWEL SIGN U",
    "11CB3": "MARCHEN VOWEL SIGN E",
    "11CB4": "MARCHEN VOWEL SIGN O",
    "11CB5": "MARCHEN SIGN ANUSVARA",
    "11CB6": "MARCHEN SIGN CANDRABINDU",
    "12000": "CUNEIFORM SIGN A",
    "12001": "CUNEIFORM SIGN A TIMES A",
    "12002": "CUNEIFORM SIGN A TIMES BAD",
    "12003": "CUNEIFORM SIGN A TIMES GAN2 TENU",
    "12004": "CUNEIFORM SIGN A TIMES HA",
    "12005": "CUNEIFORM SIGN A TIMES IGI",
    "12006": "CUNEIFORM SIGN A TIMES LAGAR GUNU",
    "12007": "CUNEIFORM SIGN A TIMES MUSH",
    "12008": "CUNEIFORM SIGN A TIMES SAG",
    "12009": "CUNEIFORM SIGN A2",
    "1200A": "CUNEIFORM SIGN AB",
    "1200B": "CUNEIFORM SIGN AB TIMES ASH2",
    "1200C": "CUNEIFORM SIGN AB TIMES DUN3 GUNU",
    "1200D": "CUNEIFORM SIGN AB TIMES GAL",
    "1200E": "CUNEIFORM SIGN AB TIMES GAN2 TENU",
    "1200F": "CUNEIFORM SIGN AB TIMES HA",
    "12010": "CUNEIFORM SIGN AB TIMES IGI GUNU",
    "12011": "CUNEIFORM SIGN AB TIMES IMIN",
    "12012": "CUNEIFORM SIGN AB TIMES LAGAB",
    "12013": "CUNEIFORM SIGN AB TIMES SHESH",
    "12014": "CUNEIFORM SIGN AB TIMES U PLUS U PLUS U",
    "12015": "CUNEIFORM SIGN AB GUNU",
    "12016": "CUNEIFORM SIGN AB2",
    "12017": "CUNEIFORM SIGN AB2 TIMES BALAG",
    "12018": "CUNEIFORM SIGN AB2 TIMES GAN2 TENU",
    "12019": "CUNEIFORM SIGN AB2 TIMES ME PLUS EN",
    "1201A": "CUNEIFORM SIGN AB2 TIMES SHA3",
    "1201B": "CUNEIFORM SIGN AB2 TIMES TAK4",
    "1201C": "CUNEIFORM SIGN AD",
    "1201D": "CUNEIFORM SIGN AK",
    "1201E": "CUNEIFORM SIGN AK TIMES ERIN2",
    "1201F": "CUNEIFORM SIGN AK TIMES SHITA PLUS GISH",
    "12020": "CUNEIFORM SIGN AL",
    "12021": "CUNEIFORM SIGN AL TIMES AL",
    "12022": "CUNEIFORM SIGN AL TIMES DIM2",
    "12023": "CUNEIFORM SIGN AL TIMES GISH",
    "12024": "CUNEIFORM SIGN AL TIMES HA",
    "12025": "CUNEIFORM SIGN AL TIMES KAD3",
    "12026": "CUNEIFORM SIGN AL TIMES KI",
    "12027": "CUNEIFORM SIGN AL TIMES SHE",
    "12028": "CUNEIFORM SIGN AL TIMES USH",
    "12029": "CUNEIFORM SIGN ALAN",
    "1202A": "CUNEIFORM SIGN ALEPH",
    "1202B": "CUNEIFORM SIGN AMAR",
    "1202C": "CUNEIFORM SIGN AMAR TIMES SHE",
    "1202D": "CUNEIFORM SIGN AN",
    "1202E": "CUNEIFORM SIGN AN OVER AN",
    "1202F": "CUNEIFORM SIGN AN THREE TIMES",
    "12030": "CUNEIFORM SIGN AN PLUS NAGA OPPOSING AN PLUS NAGA",
    "12031": "CUNEIFORM SIGN AN PLUS NAGA SQUARED",
    "12032": "CUNEIFORM SIGN ANSHE",
    "12033": "CUNEIFORM SIGN APIN",
    "12034": "CUNEIFORM SIGN ARAD",
    "12035": "CUNEIFORM SIGN ARAD TIMES KUR",
    "12036": "CUNEIFORM SIGN ARKAB",
    "12037": "CUNEIFORM SIGN ASAL2",
    "12038": "CUNEIFORM SIGN ASH",
    "12039": "CUNEIFORM SIGN ASH ZIDA TENU",
    "1203A": "CUNEIFORM SIGN ASH KABA TENU",
    "1203B": "CUNEIFORM SIGN ASH OVER ASH TUG2 OVER TUG2 TUG2 OVER TUG2 PAP",
    "1203C": "CUNEIFORM SIGN ASH OVER ASH OVER ASH",
    "1203D": "CUNEIFORM SIGN ASH OVER ASH OVER ASH CROSSING ASH OVER ASH OVER ASH",
    "1203E": "CUNEIFORM SIGN ASH2",
    "1203F": "CUNEIFORM SIGN ASHGAB",
    "12040": "CUNEIFORM SIGN BA",
    "12041": "CUNEIFORM SIGN BAD",
    "12042": "CUNEIFORM SIGN BAG3",
    "12043": "CUNEIFORM SIGN BAHAR2",
    "12044": "CUNEIFORM SIGN BAL",
    "12045": "CUNEIFORM SIGN BAL OVER BAL",
    "12046": "CUNEIFORM SIGN BALAG",
    "12047": "CUNEIFORM SIGN BAR",
    "12048": "CUNEIFORM SIGN BARA2",
    "12049": "CUNEIFORM SIGN BI",
    "1204A": "CUNEIFORM SIGN BI TIMES A",
    "1204B": "CUNEIFORM SIGN BI TIMES GAR",
    "1204C": "CUNEIFORM SIGN BI TIMES IGI GUNU",
    "1204D": "CUNEIFORM SIGN BU",
    "1204E": "CUNEIFORM SIGN BU OVER BU AB",
    "1204F": "CUNEIFORM SIGN BU OVER BU UN",
    "12050": "CUNEIFORM SIGN BU CROSSING BU",
    "12051": "CUNEIFORM SIGN BULUG",
    "12052": "CUNEIFORM SIGN BULUG OVER BULUG",
    "12053": "CUNEIFORM SIGN BUR",
    "12054": "CUNEIFORM SIGN BUR2",
    "12055": "CUNEIFORM SIGN DA",
    "12056": "CUNEIFORM SIGN DAG",
    "12057": "CUNEIFORM SIGN DAG KISIM5 TIMES A PLUS MASH",
    "12058": "CUNEIFORM SIGN DAG KISIM5 TIMES AMAR",
    "12059": "CUNEIFORM SIGN DAG KISIM5 TIMES BALAG",
    "1205A": "CUNEIFORM SIGN DAG KISIM5 TIMES BI",
    "1205B": "CUNEIFORM SIGN DAG KISIM5 TIMES GA",
    "1205C": "CUNEIFORM SIGN DAG KISIM5 TIMES GA PLUS MASH",
    "1205D": "CUNEIFORM SIGN DAG KISIM5 TIMES GI",
    "1205E": "CUNEIFORM SIGN DAG KISIM5 TIMES GIR2",
    "1205F": "CUNEIFORM SIGN DAG KISIM5 TIMES GUD",
    "12060": "CUNEIFORM SIGN DAG KISIM5 TIMES HA",
    "12061": "CUNEIFORM SIGN DAG KISIM5 TIMES IR",
    "12062": "CUNEIFORM SIGN DAG KISIM5 TIMES IR PLUS LU",
    "12063": "CUNEIFORM SIGN DAG KISIM5 TIMES KAK",
    "12064": "CUNEIFORM SIGN DAG KISIM5 TIMES LA",
    "12065": "CUNEIFORM SIGN DAG KISIM5 TIMES LU",
    "12066": "CUNEIFORM SIGN DAG KISIM5 TIMES LU PLUS MASH2",
    "12067": "CUNEIFORM SIGN DAG KISIM5 TIMES LUM",
    "12068": "CUNEIFORM SIGN DAG KISIM5 TIMES NE",
    "12069": "CUNEIFORM SIGN DAG KISIM5 TIMES PAP PLUS PAP",
    "1206A": "CUNEIFORM SIGN DAG KISIM5 TIMES SI",
    "1206B": "CUNEIFORM SIGN DAG KISIM5 TIMES TAK4",
    "1206C": "CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS GIR2",
    "1206D": "CUNEIFORM SIGN DAG KISIM5 TIMES USH",
    "1206E": "CUNEIFORM SIGN DAM",
    "1206F": "CUNEIFORM SIGN DAR",
    "12070": "CUNEIFORM SIGN DARA3",
    "12071": "CUNEIFORM SIGN DARA4",
    "12072": "CUNEIFORM SIGN DI",
    "12073": "CUNEIFORM SIGN DIB",
    "12074": "CUNEIFORM SIGN DIM",
    "12075": "CUNEIFORM SIGN DIM TIMES SHE",
    "12076": "CUNEIFORM SIGN DIM2",
    "12077": "CUNEIFORM SIGN DIN",
    "12078": "CUNEIFORM SIGN DIN KASKAL U GUNU DISH",
    "12079": "CUNEIFORM SIGN DISH",
    "1207A": "CUNEIFORM SIGN DU",
    "1207B": "CUNEIFORM SIGN DU OVER DU",
    "1207C": "CUNEIFORM SIGN DU GUNU",
    "1207D": "CUNEIFORM SIGN DU SHESHIG",
    "1207E": "CUNEIFORM SIGN DUB",
    "1207F": "CUNEIFORM SIGN DUB TIMES ESH2",
    "12080": "CUNEIFORM SIGN DUB2",
    "12081": "CUNEIFORM SIGN DUG",
    "12082": "CUNEIFORM SIGN DUGUD",
    "12083": "CUNEIFORM SIGN DUH",
    "12084": "CUNEIFORM SIGN DUN",
    "12085": "CUNEIFORM SIGN DUN3",
    "12086": "CUNEIFORM SIGN DUN3 GUNU",
    "12087": "CUNEIFORM SIGN DUN3 GUNU GUNU",
    "12088": "CUNEIFORM SIGN DUN4",
    "12089": "CUNEIFORM SIGN DUR2",
    "1208A": "CUNEIFORM SIGN E",
    "1208B": "CUNEIFORM SIGN E TIMES PAP",
    "1208C": "CUNEIFORM SIGN E OVER E NUN OVER NUN",
    "1208D": "CUNEIFORM SIGN E2",
    "1208E": "CUNEIFORM SIGN E2 TIMES A PLUS HA PLUS DA",
    "1208F": "CUNEIFORM SIGN E2 TIMES GAR",
    "12090": "CUNEIFORM SIGN E2 TIMES MI",
    "12091": "CUNEIFORM SIGN E2 TIMES SAL",
    "12092": "CUNEIFORM SIGN E2 TIMES SHE",
    "12093": "CUNEIFORM SIGN E2 TIMES U",
    "12094": "CUNEIFORM SIGN EDIN",
    "12095": "CUNEIFORM SIGN EGIR",
    "12096": "CUNEIFORM SIGN EL",
    "12097": "CUNEIFORM SIGN EN",
    "12098": "CUNEIFORM SIGN EN TIMES GAN2",
    "12099": "CUNEIFORM SIGN EN TIMES GAN2 TENU",
    "1209A": "CUNEIFORM SIGN EN TIMES ME",
    "1209B": "CUNEIFORM SIGN EN CROSSING EN",
    "1209C": "CUNEIFORM SIGN EN OPPOSING EN",
    "1209D": "CUNEIFORM SIGN EN SQUARED",
    "1209E": "CUNEIFORM SIGN EREN",
    "1209F": "CUNEIFORM SIGN ERIN2",
    "120A0": "CUNEIFORM SIGN ESH2",
    "120A1": "CUNEIFORM SIGN EZEN",
    "120A2": "CUNEIFORM SIGN EZEN TIMES A",
    "120A3": "CUNEIFORM SIGN EZEN TIMES A PLUS LAL",
    "120A4": "CUNEIFORM SIGN EZEN TIMES A PLUS LAL TIMES LAL",
    "120A5": "CUNEIFORM SIGN EZEN TIMES AN",
    "120A6": "CUNEIFORM SIGN EZEN TIMES BAD",
    "120A7": "CUNEIFORM SIGN EZEN TIMES DUN3 GUNU",
    "120A8": "CUNEIFORM SIGN EZEN TIMES DUN3 GUNU GUNU",
    "120A9": "CUNEIFORM SIGN EZEN TIMES HA",
    "120AA": "CUNEIFORM SIGN EZEN TIMES HA GUNU",
    "120AB": "CUNEIFORM SIGN EZEN TIMES IGI GUNU",
    "120AC": "CUNEIFORM SIGN EZEN TIMES KASKAL",
    "120AD": "CUNEIFORM SIGN EZEN TIMES KASKAL SQUARED",
    "120AE": "CUNEIFORM SIGN EZEN TIMES KU3",
    "120AF": "CUNEIFORM SIGN EZEN TIMES LA",
    "120B0": "CUNEIFORM SIGN EZEN TIMES LAL TIMES LAL",
    "120B1": "CUNEIFORM SIGN EZEN TIMES LI",
    "120B2": "CUNEIFORM SIGN EZEN TIMES LU",
    "120B3": "CUNEIFORM SIGN EZEN TIMES U2",
    "120B4": "CUNEIFORM SIGN EZEN TIMES UD",
    "120B5": "CUNEIFORM SIGN GA",
    "120B6": "CUNEIFORM SIGN GA GUNU",
    "120B7": "CUNEIFORM SIGN GA2",
    "120B8": "CUNEIFORM SIGN GA2 TIMES A PLUS DA PLUS HA",
    "120B9": "CUNEIFORM SIGN GA2 TIMES A PLUS HA",
    "120BA": "CUNEIFORM SIGN GA2 TIMES A PLUS IGI",
    "120BB": "CUNEIFORM SIGN GA2 TIMES AB2 TENU PLUS TAB",
    "120BC": "CUNEIFORM SIGN GA2 TIMES AN",
    "120BD": "CUNEIFORM SIGN GA2 TIMES ASH",
    "120BE": "CUNEIFORM SIGN GA2 TIMES ASH2 PLUS GAL",
    "120BF": "CUNEIFORM SIGN GA2 TIMES BAD",
    "120C0": "CUNEIFORM SIGN GA2 TIMES BAR PLUS RA",
    "120C1": "CUNEIFORM SIGN GA2 TIMES BUR",
    "120C2": "CUNEIFORM SIGN GA2 TIMES BUR PLUS RA",
    "120C3": "CUNEIFORM SIGN GA2 TIMES DA",
    "120C4": "CUNEIFORM SIGN GA2 TIMES DI",
    "120C5": "CUNEIFORM SIGN GA2 TIMES DIM TIMES SHE",
    "120C6": "CUNEIFORM SIGN GA2 TIMES DUB",
    "120C7": "CUNEIFORM SIGN GA2 TIMES EL",
    "120C8": "CUNEIFORM SIGN GA2 TIMES EL PLUS LA",
    "120C9": "CUNEIFORM SIGN GA2 TIMES EN",
    "120CA": "CUNEIFORM SIGN GA2 TIMES EN TIMES GAN2 TENU",
    "120CB": "CUNEIFORM SIGN GA2 TIMES GAN2 TENU",
    "120CC": "CUNEIFORM SIGN GA2 TIMES GAR",
    "120CD": "CUNEIFORM SIGN GA2 TIMES GI",
    "120CE": "CUNEIFORM SIGN GA2 TIMES GI4",
    "120CF": "CUNEIFORM SIGN GA2 TIMES GI4 PLUS A",
    "120D0": "CUNEIFORM SIGN GA2 TIMES GIR2 PLUS SU",
    "120D1": "CUNEIFORM SIGN GA2 TIMES HA PLUS LU PLUS ESH2",
    "120D2": "CUNEIFORM SIGN GA2 TIMES HAL",
    "120D3": "CUNEIFORM SIGN GA2 TIMES HAL PLUS LA",
    "120D4": "CUNEIFORM SIGN GA2 TIMES HI PLUS LI",
    "120D5": "CUNEIFORM SIGN GA2 TIMES HUB2",
    "120D6": "CUNEIFORM SIGN GA2 TIMES IGI GUNU",
    "120D7": "CUNEIFORM SIGN GA2 TIMES ISH PLUS HU PLUS ASH",
    "120D8": "CUNEIFORM SIGN GA2 TIMES KAK",
    "120D9": "CUNEIFORM SIGN GA2 TIMES KASKAL",
    "120DA": "CUNEIFORM SIGN GA2 TIMES KID",
    "120DB": "CUNEIFORM SIGN GA2 TIMES KID PLUS LAL",
    "120DC": "CUNEIFORM SIGN GA2 TIMES KU3 PLUS AN",
    "120DD": "CUNEIFORM SIGN GA2 TIMES LA",
    "120DE": "CUNEIFORM SIGN GA2 TIMES ME PLUS EN",
    "120DF": "CUNEIFORM SIGN GA2 TIMES MI",
    "120E0": "CUNEIFORM SIGN GA2 TIMES NUN",
    "120E1": "CUNEIFORM SIGN GA2 TIMES NUN OVER NUN",
    "120E2": "CUNEIFORM SIGN GA2 TIMES PA",
    "120E3": "CUNEIFORM SIGN GA2 TIMES SAL",
    "120E4": "CUNEIFORM SIGN GA2 TIMES SAR",
    "120E5": "CUNEIFORM SIGN GA2 TIMES SHE",
    "120E6": "CUNEIFORM SIGN GA2 TIMES SHE PLUS TUR",
    "120E7": "CUNEIFORM SIGN GA2 TIMES SHID",
    "120E8": "CUNEIFORM SIGN GA2 TIMES SUM",
    "120E9": "CUNEIFORM SIGN GA2 TIMES TAK4",
    "120EA": "CUNEIFORM SIGN GA2 TIMES U",
    "120EB": "CUNEIFORM SIGN GA2 TIMES UD",
    "120EC": "CUNEIFORM SIGN GA2 TIMES UD PLUS DU",
    "120ED": "CUNEIFORM SIGN GA2 OVER GA2",
    "120EE": "CUNEIFORM SIGN GABA",
    "120EF": "CUNEIFORM SIGN GABA CROSSING GABA",
    "120F0": "CUNEIFORM SIGN GAD",
    "120F1": "CUNEIFORM SIGN GAD OVER GAD GAR OVER GAR",
    "120F2": "CUNEIFORM SIGN GAL",
    "120F3": "CUNEIFORM SIGN GAL GAD OVER GAD GAR OVER GAR",
    "120F4": "CUNEIFORM SIGN GALAM",
    "120F5": "CUNEIFORM SIGN GAM",
    "120F6": "CUNEIFORM SIGN GAN",
    "120F7": "CUNEIFORM SIGN GAN2",
    "120F8": "CUNEIFORM SIGN GAN2 TENU",
    "120F9": "CUNEIFORM SIGN GAN2 OVER GAN2",
    "120FA": "CUNEIFORM SIGN GAN2 CROSSING GAN2",
    "120FB": "CUNEIFORM SIGN GAR",
    "120FC": "CUNEIFORM SIGN GAR3",
    "120FD": "CUNEIFORM SIGN GASHAN",
    "120FE": "CUNEIFORM SIGN GESHTIN",
    "120FF": "CUNEIFORM SIGN GESHTIN TIMES KUR",
    "12100": "CUNEIFORM SIGN GI",
    "12101": "CUNEIFORM SIGN GI TIMES E",
    "12102": "CUNEIFORM SIGN GI TIMES U",
    "12103": "CUNEIFORM SIGN GI CROSSING GI",
    "12104": "CUNEIFORM SIGN GI4",
    "12105": "CUNEIFORM SIGN GI4 OVER GI4",
    "12106": "CUNEIFORM SIGN GI4 CROSSING GI4",
    "12107": "CUNEIFORM SIGN GIDIM",
    "12108": "CUNEIFORM SIGN GIR2",
    "12109": "CUNEIFORM SIGN GIR2 GUNU",
    "1210A": "CUNEIFORM SIGN GIR3",
    "1210B": "CUNEIFORM SIGN GIR3 TIMES A PLUS IGI",
    "1210C": "CUNEIFORM SIGN GIR3 TIMES GAN2 TENU",
    "1210D": "CUNEIFORM SIGN GIR3 TIMES IGI",
    "1210E": "CUNEIFORM SIGN GIR3 TIMES LU PLUS IGI",
    "1210F": "CUNEIFORM SIGN GIR3 TIMES PA",
    "12110": "CUNEIFORM SIGN GISAL",
    "12111": "CUNEIFORM SIGN GISH",
    "12112": "CUNEIFORM SIGN GISH CROSSING GISH",
    "12113": "CUNEIFORM SIGN GISH TIMES BAD",
    "12114": "CUNEIFORM SIGN GISH TIMES TAK4",
    "12115": "CUNEIFORM SIGN GISH TENU",
    "12116": "CUNEIFORM SIGN GU",
    "12117": "CUNEIFORM SIGN GU CROSSING GU",
    "12118": "CUNEIFORM SIGN GU2",
    "12119": "CUNEIFORM SIGN GU2 TIMES KAK",
    "1211A": "CUNEIFORM SIGN GU2 TIMES KAK TIMES IGI GUNU",
    "1211B": "CUNEIFORM SIGN GU2 TIMES NUN",
    "1211C": "CUNEIFORM SIGN GU2 TIMES SAL PLUS TUG2",
    "1211D": "CUNEIFORM SIGN GU2 GUNU",
    "1211E": "CUNEIFORM SIGN GUD",
    "1211F": "CUNEIFORM SIGN GUD TIMES A PLUS KUR",
    "12120": "CUNEIFORM SIGN GUD TIMES KUR",
    "12121": "CUNEIFORM SIGN GUD OVER GUD LUGAL",
    "12122": "CUNEIFORM SIGN GUL",
    "12123": "CUNEIFORM SIGN GUM",
    "12124": "CUNEIFORM SIGN GUM TIMES SHE",
    "12125": "CUNEIFORM SIGN GUR",
    "12126": "CUNEIFORM SIGN GUR7",
    "12127": "CUNEIFORM SIGN GURUN",
    "12128": "CUNEIFORM SIGN GURUSH",
    "12129": "CUNEIFORM SIGN HA",
    "1212A": "CUNEIFORM SIGN HA TENU",
    "1212B": "CUNEIFORM SIGN HA GUNU",
    "1212C": "CUNEIFORM SIGN HAL",
    "1212D": "CUNEIFORM SIGN HI",
    "1212E": "CUNEIFORM SIGN HI TIMES ASH",
    "1212F": "CUNEIFORM SIGN HI TIMES ASH2",
    "12130": "CUNEIFORM SIGN HI TIMES BAD",
    "12131": "CUNEIFORM SIGN HI TIMES DISH",
    "12132": "CUNEIFORM SIGN HI TIMES GAD",
    "12133": "CUNEIFORM SIGN HI TIMES KIN",
    "12134": "CUNEIFORM SIGN HI TIMES NUN",
    "12135": "CUNEIFORM SIGN HI TIMES SHE",
    "12136": "CUNEIFORM SIGN HI TIMES U",
    "12137": "CUNEIFORM SIGN HU",
    "12138": "CUNEIFORM SIGN HUB2",
    "12139": "CUNEIFORM SIGN HUB2 TIMES AN",
    "1213A": "CUNEIFORM SIGN HUB2 TIMES HAL",
    "1213B": "CUNEIFORM SIGN HUB2 TIMES KASKAL",
    "1213C": "CUNEIFORM SIGN HUB2 TIMES LISH",
    "1213D": "CUNEIFORM SIGN HUB2 TIMES UD",
    "1213E": "CUNEIFORM SIGN HUL2",
    "1213F": "CUNEIFORM SIGN I",
    "12140": "CUNEIFORM SIGN I A",
    "12141": "CUNEIFORM SIGN IB",
    "12142": "CUNEIFORM SIGN IDIM",
    "12143": "CUNEIFORM SIGN IDIM OVER IDIM BUR",
    "12144": "CUNEIFORM SIGN IDIM OVER IDIM SQUARED",
    "12145": "CUNEIFORM SIGN IG",
    "12146": "CUNEIFORM SIGN IGI",
    "12147": "CUNEIFORM SIGN IGI DIB",
    "12148": "CUNEIFORM SIGN IGI RI",
    "12149": "CUNEIFORM SIGN IGI OVER IGI SHIR OVER SHIR UD OVER UD",
    "1214A": "CUNEIFORM SIGN IGI GUNU",
    "1214B": "CUNEIFORM SIGN IL",
    "1214C": "CUNEIFORM SIGN IL TIMES GAN2 TENU",
    "1214D": "CUNEIFORM SIGN IL2",
    "1214E": "CUNEIFORM SIGN IM",
    "1214F": "CUNEIFORM SIGN IM TIMES TAK4",
    "12150": "CUNEIFORM SIGN IM CROSSING IM",
    "12151": "CUNEIFORM SIGN IM OPPOSING IM",
    "12152": "CUNEIFORM SIGN IM SQUARED",
    "12153": "CUNEIFORM SIGN IMIN",
    "12154": "CUNEIFORM SIGN IN",
    "12155": "CUNEIFORM SIGN IR",
    "12156": "CUNEIFORM SIGN ISH",
    "12157": "CUNEIFORM SIGN KA",
    "12158": "CUNEIFORM SIGN KA TIMES A",
    "12159": "CUNEIFORM SIGN KA TIMES AD",
    "1215A": "CUNEIFORM SIGN KA TIMES AD PLUS KU3",
    "1215B": "CUNEIFORM SIGN KA TIMES ASH2",
    "1215C": "CUNEIFORM SIGN KA TIMES BAD",
    "1215D": "CUNEIFORM SIGN KA TIMES BALAG",
    "1215E": "CUNEIFORM SIGN KA TIMES BAR",
    "1215F": "CUNEIFORM SIGN KA TIMES BI",
    "12160": "CUNEIFORM SIGN KA TIMES ERIN2",
    "12161": "CUNEIFORM SIGN KA TIMES ESH2",
    "12162": "CUNEIFORM SIGN KA TIMES GA",
    "12163": "CUNEIFORM SIGN KA TIMES GAL",
    "12164": "CUNEIFORM SIGN KA TIMES GAN2 TENU",
    "12165": "CUNEIFORM SIGN KA TIMES GAR",
    "12166": "CUNEIFORM SIGN KA TIMES GAR PLUS SHA3 PLUS A",
    "12167": "CUNEIFORM SIGN KA TIMES GI",
    "12168": "CUNEIFORM SIGN KA TIMES GIR2",
    "12169": "CUNEIFORM SIGN KA TIMES GISH PLUS SAR",
    "1216A": "CUNEIFORM SIGN KA TIMES GISH CROSSING GISH",
    "1216B": "CUNEIFORM SIGN KA TIMES GU",
    "1216C": "CUNEIFORM SIGN KA TIMES GUR7",
    "1216D": "CUNEIFORM SIGN KA TIMES IGI",
    "1216E": "CUNEIFORM SIGN KA TIMES IM",
    "1216F": "CUNEIFORM SIGN KA TIMES KAK",
    "12170": "CUNEIFORM SIGN KA TIMES KI",
    "12171": "CUNEIFORM SIGN KA TIMES KID",
    "12172": "CUNEIFORM SIGN KA TIMES LI",
    "12173": "CUNEIFORM SIGN KA TIMES LU",
    "12174": "CUNEIFORM SIGN KA TIMES ME",
    "12175": "CUNEIFORM SIGN KA TIMES ME PLUS DU",
    "12176": "CUNEIFORM SIGN KA TIMES ME PLUS GI",
    "12177": "CUNEIFORM SIGN KA TIMES ME PLUS TE",
    "12178": "CUNEIFORM SIGN KA TIMES MI",
    "12179": "CUNEIFORM SIGN KA TIMES MI PLUS NUNUZ",
    "1217A": "CUNEIFORM SIGN KA TIMES NE",
    "1217B": "CUNEIFORM SIGN KA TIMES NUN",
    "1217C": "CUNEIFORM SIGN KA TIMES PI",
    "1217D": "CUNEIFORM SIGN KA TIMES RU",
    "1217E": "CUNEIFORM SIGN KA TIMES SA",
    "1217F": "CUNEIFORM SIGN KA TIMES SAR",
    "12180": "CUNEIFORM SIGN KA TIMES SHA",
    "12181": "CUNEIFORM SIGN KA TIMES SHE",
    "12182": "CUNEIFORM SIGN KA TIMES SHID",
    "12183": "CUNEIFORM SIGN KA TIMES SHU",
    "12184": "CUNEIFORM SIGN KA TIMES SIG",
    "12185": "CUNEIFORM SIGN KA TIMES SUHUR",
    "12186": "CUNEIFORM SIGN KA TIMES TAR",
    "12187": "CUNEIFORM SIGN KA TIMES U",
    "12188": "CUNEIFORM SIGN KA TIMES U2",
    "12189": "CUNEIFORM SIGN KA TIMES UD",
    "1218A": "CUNEIFORM SIGN KA TIMES UMUM TIMES PA",
    "1218B": "CUNEIFORM SIGN KA TIMES USH",
    "1218C": "CUNEIFORM SIGN KA TIMES ZI",
    "1218D": "CUNEIFORM SIGN KA2",
    "1218E": "CUNEIFORM SIGN KA2 CROSSING KA2",
    "1218F": "CUNEIFORM SIGN KAB",
    "12190": "CUNEIFORM SIGN KAD2",
    "12191": "CUNEIFORM SIGN KAD3",
    "12192": "CUNEIFORM SIGN KAD4",
    "12193": "CUNEIFORM SIGN KAD5",
    "12194": "CUNEIFORM SIGN KAD5 OVER KAD5",
    "12195": "CUNEIFORM SIGN KAK",
    "12196": "CUNEIFORM SIGN KAK TIMES IGI GUNU",
    "12197": "CUNEIFORM SIGN KAL",
    "12198": "CUNEIFORM SIGN KAL TIMES BAD",
    "12199": "CUNEIFORM SIGN KAL CROSSING KAL",
    "1219A": "CUNEIFORM SIGN KAM2",
    "1219B": "CUNEIFORM SIGN KAM4",
    "1219C": "CUNEIFORM SIGN KASKAL",
    "1219D": "CUNEIFORM SIGN KASKAL LAGAB TIMES U OVER LAGAB TIMES U",
    "1219E": "CUNEIFORM SIGN KASKAL OVER KASKAL LAGAB TIMES U OVER LAGAB TIMES U",
    "1219F": "CUNEIFORM SIGN KESH2",
    "121A0": "CUNEIFORM SIGN KI",
    "121A1": "CUNEIFORM SIGN KI TIMES BAD",
    "121A2": "CUNEIFORM SIGN KI TIMES U",
    "121A3": "CUNEIFORM SIGN KI TIMES UD",
    "121A4": "CUNEIFORM SIGN KID",
    "121A5": "CUNEIFORM SIGN KIN",
    "121A6": "CUNEIFORM SIGN KISAL",
    "121A7": "CUNEIFORM SIGN KISH",
    "121A8": "CUNEIFORM SIGN KISIM5",
    "121A9": "CUNEIFORM SIGN KISIM5 OVER KISIM5",
    "121AA": "CUNEIFORM SIGN KU",
    "121AB": "CUNEIFORM SIGN KU OVER HI TIMES ASH2 KU OVER HI TIMES ASH2",
    "121AC": "CUNEIFORM SIGN KU3",
    "121AD": "CUNEIFORM SIGN KU4",
    "121AE": "CUNEIFORM SIGN KU4 VARIANT FORM",
    "121AF": "CUNEIFORM SIGN KU7",
    "121B0": "CUNEIFORM SIGN KUL",
    "121B1": "CUNEIFORM SIGN KUL GUNU",
    "121B2": "CUNEIFORM SIGN KUN",
    "121B3": "CUNEIFORM SIGN KUR",
    "121B4": "CUNEIFORM SIGN KUR OPPOSING KUR",
    "121B5": "CUNEIFORM SIGN KUSHU2",
    "121B6": "CUNEIFORM SIGN KWU318",
    "121B7": "CUNEIFORM SIGN LA",
    "121B8": "CUNEIFORM SIGN LAGAB",
    "121B9": "CUNEIFORM SIGN LAGAB TIMES A",
    "121BA": "CUNEIFORM SIGN LAGAB TIMES A PLUS DA PLUS HA",
    "121BB": "CUNEIFORM SIGN LAGAB TIMES A PLUS GAR",
    "121BC": "CUNEIFORM SIGN LAGAB TIMES A PLUS LAL",
    "121BD": "CUNEIFORM SIGN LAGAB TIMES AL",
    "121BE": "CUNEIFORM SIGN LAGAB TIMES AN",
    "121BF": "CUNEIFORM SIGN LAGAB TIMES ASH ZIDA TENU",
    "121C0": "CUNEIFORM SIGN LAGAB TIMES BAD",
    "121C1": "CUNEIFORM SIGN LAGAB TIMES BI",
    "121C2": "CUNEIFORM SIGN LAGAB TIMES DAR",
    "121C3": "CUNEIFORM SIGN LAGAB TIMES EN",
    "121C4": "CUNEIFORM SIGN LAGAB TIMES GA",
    "121C5": "CUNEIFORM SIGN LAGAB TIMES GAR",
    "121C6": "CUNEIFORM SIGN LAGAB TIMES GUD",
    "121C7": "CUNEIFORM SIGN LAGAB TIMES GUD PLUS GUD",
    "121C8": "CUNEIFORM SIGN LAGAB TIMES HA",
    "121C9": "CUNEIFORM SIGN LAGAB TIMES HAL",
    "121CA": "CUNEIFORM SIGN LAGAB TIMES HI TIMES NUN",
    "121CB": "CUNEIFORM SIGN LAGAB TIMES IGI GUNU",
    "121CC": "CUNEIFORM SIGN LAGAB TIMES IM",
    "121CD": "CUNEIFORM SIGN LAGAB TIMES IM PLUS HA",
    "121CE": "CUNEIFORM SIGN LAGAB TIMES IM PLUS LU",
    "121CF": "CUNEIFORM SIGN LAGAB TIMES KI",
    "121D0": "CUNEIFORM SIGN LAGAB TIMES KIN",
    "121D1": "CUNEIFORM SIGN LAGAB TIMES KU3",
    "121D2": "CUNEIFORM SIGN LAGAB TIMES KUL",
    "121D3": "CUNEIFORM SIGN LAGAB TIMES KUL PLUS HI PLUS A",
    "121D4": "CUNEIFORM SIGN LAGAB TIMES LAGAB",
    "121D5": "CUNEIFORM SIGN LAGAB TIMES LISH",
    "121D6": "CUNEIFORM SIGN LAGAB TIMES LU",
    "121D7": "CUNEIFORM SIGN LAGAB TIMES LUL",
    "121D8": "CUNEIFORM SIGN LAGAB TIMES ME",
    "121D9": "CUNEIFORM SIGN LAGAB TIMES ME PLUS EN",
    "121DA": "CUNEIFORM SIGN LAGAB TIMES MUSH",
    "121DB": "CUNEIFORM SIGN LAGAB TIMES NE",
    "121DC": "CUNEIFORM SIGN LAGAB TIMES SHE PLUS SUM",
    "121DD": "CUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH PLUS ERIN2",
    "121DE": "CUNEIFORM SIGN LAGAB TIMES SHITA PLUS GISH TENU",
    "121DF": "CUNEIFORM SIGN LAGAB TIMES SHU2",
    "121E0": "CUNEIFORM SIGN LAGAB TIMES SHU2 PLUS SHU2",
    "121E1": "CUNEIFORM SIGN LAGAB TIMES SUM",
    "121E2": "CUNEIFORM SIGN LAGAB TIMES TAG",
    "121E3": "CUNEIFORM SIGN LAGAB TIMES TAK4",
    "121E4": "CUNEIFORM SIGN LAGAB TIMES TE PLUS A PLUS SU PLUS NA",
    "121E5": "CUNEIFORM SIGN LAGAB TIMES U",
    "121E6": "CUNEIFORM SIGN LAGAB TIMES U PLUS A",
    "121E7": "CUNEIFORM SIGN LAGAB TIMES U PLUS U PLUS U",
    "121E8": "CUNEIFORM SIGN LAGAB TIMES U2 PLUS ASH",
    "121E9": "CUNEIFORM SIGN LAGAB TIMES UD",
    "121EA": "CUNEIFORM SIGN LAGAB TIMES USH",
    "121EB": "CUNEIFORM SIGN LAGAB SQUARED",
    "121EC": "CUNEIFORM SIGN LAGAR",
    "121ED": "CUNEIFORM SIGN LAGAR TIMES SHE",
    "121EE": "CUNEIFORM SIGN LAGAR TIMES SHE PLUS SUM",
    "121EF": "CUNEIFORM SIGN LAGAR GUNU",
    "121F0": "CUNEIFORM SIGN LAGAR GUNU OVER LAGAR GUNU SHE",
    "121F1": "CUNEIFORM SIGN LAHSHU",
    "121F2": "CUNEIFORM SIGN LAL",
    "121F3": "CUNEIFORM SIGN LAL TIMES LAL",
    "121F4": "CUNEIFORM SIGN LAM",
    "121F5": "CUNEIFORM SIGN LAM TIMES KUR",
    "121F6": "CUNEIFORM SIGN LAM TIMES KUR PLUS RU",
    "121F7": "CUNEIFORM SIGN LI",
    "121F8": "CUNEIFORM SIGN LIL",
    "121F9": "CUNEIFORM SIGN LIMMU2",
    "121FA": "CUNEIFORM SIGN LISH",
    "121FB": "CUNEIFORM SIGN LU",
    "121FC": "CUNEIFORM SIGN LU TIMES BAD",
    "121FD": "CUNEIFORM SIGN LU2",
    "121FE": "CUNEIFORM SIGN LU2 TIMES AL",
    "121FF": "CUNEIFORM SIGN LU2 TIMES BAD",
    "12200": "CUNEIFORM SIGN LU2 TIMES ESH2",
    "12201": "CUNEIFORM SIGN LU2 TIMES ESH2 TENU",
    "12202": "CUNEIFORM SIGN LU2 TIMES GAN2 TENU",
    "12203": "CUNEIFORM SIGN LU2 TIMES HI TIMES BAD",
    "12204": "CUNEIFORM SIGN LU2 TIMES IM",
    "12205": "CUNEIFORM SIGN LU2 TIMES KAD2",
    "12206": "CUNEIFORM SIGN LU2 TIMES KAD3",
    "12207": "CUNEIFORM SIGN LU2 TIMES KAD3 PLUS ASH",
    "12208": "CUNEIFORM SIGN LU2 TIMES KI",
    "12209": "CUNEIFORM SIGN LU2 TIMES LA PLUS ASH",
    "1220A": "CUNEIFORM SIGN LU2 TIMES LAGAB",
    "1220B": "CUNEIFORM SIGN LU2 TIMES ME PLUS EN",
    "1220C": "CUNEIFORM SIGN LU2 TIMES NE",
    "1220D": "CUNEIFORM SIGN LU2 TIMES NU",
    "1220E": "CUNEIFORM SIGN LU2 TIMES SI PLUS ASH",
    "1220F": "CUNEIFORM SIGN LU2 TIMES SIK2 PLUS BU",
    "12210": "CUNEIFORM SIGN LU2 TIMES TUG2",
    "12211": "CUNEIFORM SIGN LU2 TENU",
    "12212": "CUNEIFORM SIGN LU2 CROSSING LU2",
    "12213": "CUNEIFORM SIGN LU2 OPPOSING LU2",
    "12214": "CUNEIFORM SIGN LU2 SQUARED",
    "12215": "CUNEIFORM SIGN LU2 SHESHIG",
    "12216": "CUNEIFORM SIGN LU3",
    "12217": "CUNEIFORM SIGN LUGAL",
    "12218": "CUNEIFORM SIGN LUGAL OVER LUGAL",
    "12219": "CUNEIFORM SIGN LUGAL OPPOSING LUGAL",
    "1221A": "CUNEIFORM SIGN LUGAL SHESHIG",
    "1221B": "CUNEIFORM SIGN LUH",
    "1221C": "CUNEIFORM SIGN LUL",
    "1221D": "CUNEIFORM SIGN LUM",
    "1221E": "CUNEIFORM SIGN LUM OVER LUM",
    "1221F": "CUNEIFORM SIGN LUM OVER LUM GAR OVER GAR",
    "12220": "CUNEIFORM SIGN MA",
    "12221": "CUNEIFORM SIGN MA TIMES TAK4",
    "12222": "CUNEIFORM SIGN MA GUNU",
    "12223": "CUNEIFORM SIGN MA2",
    "12224": "CUNEIFORM SIGN MAH",
    "12225": "CUNEIFORM SIGN MAR",
    "12226": "CUNEIFORM SIGN MASH",
    "12227": "CUNEIFORM SIGN MASH2",
    "12228": "CUNEIFORM SIGN ME",
    "12229": "CUNEIFORM SIGN MES",
    "1222A": "CUNEIFORM SIGN MI",
    "1222B": "CUNEIFORM SIGN MIN",
    "1222C": "CUNEIFORM SIGN MU",
    "1222D": "CUNEIFORM SIGN MU OVER MU",
    "1222E": "CUNEIFORM SIGN MUG",
    "1222F": "CUNEIFORM SIGN MUG GUNU",
    "12230": "CUNEIFORM SIGN MUNSUB",
    "12231": "CUNEIFORM SIGN MURGU2",
    "12232": "CUNEIFORM SIGN MUSH",
    "12233": "CUNEIFORM SIGN MUSH TIMES A",
    "12234": "CUNEIFORM SIGN MUSH TIMES KUR",
    "12235": "CUNEIFORM SIGN MUSH TIMES ZA",
    "12236": "CUNEIFORM SIGN MUSH OVER MUSH",
    "12237": "CUNEIFORM SIGN MUSH OVER MUSH TIMES A PLUS NA",
    "12238": "CUNEIFORM SIGN MUSH CROSSING MUSH",
    "12239": "CUNEIFORM SIGN MUSH3",
    "1223A": "CUNEIFORM SIGN MUSH3 TIMES A",
    "1223B": "CUNEIFORM SIGN MUSH3 TIMES A PLUS DI",
    "1223C": "CUNEIFORM SIGN MUSH3 TIMES DI",
    "1223D": "CUNEIFORM SIGN MUSH3 GUNU",
    "1223E": "CUNEIFORM SIGN NA",
    "1223F": "CUNEIFORM SIGN NA2",
    "12240": "CUNEIFORM SIGN NAGA",
    "12241": "CUNEIFORM SIGN NAGA INVERTED",
    "12242": "CUNEIFORM SIGN NAGA TIMES SHU TENU",
    "12243": "CUNEIFORM SIGN NAGA OPPOSING NAGA",
    "12244": "CUNEIFORM SIGN NAGAR",
    "12245": "CUNEIFORM SIGN NAM NUTILLU",
    "12246": "CUNEIFORM SIGN NAM",
    "12247": "CUNEIFORM SIGN NAM2",
    "12248": "CUNEIFORM SIGN NE",
    "12249": "CUNEIFORM SIGN NE TIMES A",
    "1224A": "CUNEIFORM SIGN NE TIMES UD",
    "1224B": "CUNEIFORM SIGN NE SHESHIG",
    "1224C": "CUNEIFORM SIGN NI",
    "1224D": "CUNEIFORM SIGN NI TIMES E",
    "1224E": "CUNEIFORM SIGN NI2",
    "1224F": "CUNEIFORM SIGN NIM",
    "12250": "CUNEIFORM SIGN NIM TIMES GAN2 TENU",
    "12251": "CUNEIFORM SIGN NIM TIMES GAR PLUS GAN2 TENU",
    "12252": "CUNEIFORM SIGN NINDA2",
    "12253": "CUNEIFORM SIGN NINDA2 TIMES AN",
    "12254": "CUNEIFORM SIGN NINDA2 TIMES ASH",
    "12255": "CUNEIFORM SIGN NINDA2 TIMES ASH PLUS ASH",
    "12256": "CUNEIFORM SIGN NINDA2 TIMES GUD",
    "12257": "CUNEIFORM SIGN NINDA2 TIMES ME PLUS GAN2 TENU",
    "12258": "CUNEIFORM SIGN NINDA2 TIMES NE",
    "12259": "CUNEIFORM SIGN NINDA2 TIMES NUN",
    "1225A": "CUNEIFORM SIGN NINDA2 TIMES SHE",
    "1225B": "CUNEIFORM SIGN NINDA2 TIMES SHE PLUS A AN",
    "1225C": "CUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH",
    "1225D": "CUNEIFORM SIGN NINDA2 TIMES SHE PLUS ASH PLUS ASH",
    "1225E": "CUNEIFORM SIGN NINDA2 TIMES U2 PLUS ASH",
    "1225F": "CUNEIFORM SIGN NINDA2 TIMES USH",
    "12260": "CUNEIFORM SIGN NISAG",
    "12261": "CUNEIFORM SIGN NU",
    "12262": "CUNEIFORM SIGN NU11",
    "12263": "CUNEIFORM SIGN NUN",
    "12264": "CUNEIFORM SIGN NUN LAGAR TIMES GAR",
    "12265": "CUNEIFORM SIGN NUN LAGAR TIMES MASH",
    "12266": "CUNEIFORM SIGN NUN LAGAR TIMES SAL",
    "12267": "CUNEIFORM SIGN NUN LAGAR TIMES SAL OVER NUN LAGAR TIMES SAL",
    "12268": "CUNEIFORM SIGN NUN LAGAR TIMES USH",
    "12269": "CUNEIFORM SIGN NUN TENU",
    "1226A": "CUNEIFORM SIGN NUN OVER NUN",
    "1226B": "CUNEIFORM SIGN NUN CROSSING NUN",
    "1226C": "CUNEIFORM SIGN NUN CROSSING NUN LAGAR OVER LAGAR",
    "1226D": "CUNEIFORM SIGN NUNUZ",
    "1226E": "CUNEIFORM SIGN NUNUZ AB2 TIMES ASHGAB",
    "1226F": "CUNEIFORM SIGN NUNUZ AB2 TIMES BI",
    "12270": "CUNEIFORM SIGN NUNUZ AB2 TIMES DUG",
    "12271": "CUNEIFORM SIGN NUNUZ AB2 TIMES GUD",
    "12272": "CUNEIFORM SIGN NUNUZ AB2 TIMES IGI GUNU",
    "12273": "CUNEIFORM SIGN NUNUZ AB2 TIMES KAD3",
    "12274": "CUNEIFORM SIGN NUNUZ AB2 TIMES LA",
    "12275": "CUNEIFORM SIGN NUNUZ AB2 TIMES NE",
    "12276": "CUNEIFORM SIGN NUNUZ AB2 TIMES SILA3",
    "12277": "CUNEIFORM SIGN NUNUZ AB2 TIMES U2",
    "12278": "CUNEIFORM SIGN NUNUZ KISIM5 TIMES BI",
    "12279": "CUNEIFORM SIGN NUNUZ KISIM5 TIMES BI U",
    "1227A": "CUNEIFORM SIGN PA",
    "1227B": "CUNEIFORM SIGN PAD",
    "1227C": "CUNEIFORM SIGN PAN",
    "1227D": "CUNEIFORM SIGN PAP",
    "1227E": "CUNEIFORM SIGN PESH2",
    "1227F": "CUNEIFORM SIGN PI",
    "12280": "CUNEIFORM SIGN PI TIMES A",
    "12281": "CUNEIFORM SIGN PI TIMES AB",
    "12282": "CUNEIFORM SIGN PI TIMES BI",
    "12283": "CUNEIFORM SIGN PI TIMES BU",
    "12284": "CUNEIFORM SIGN PI TIMES E",
    "12285": "CUNEIFORM SIGN PI TIMES I",
    "12286": "CUNEIFORM SIGN PI TIMES IB",
    "12287": "CUNEIFORM SIGN PI TIMES U",
    "12288": "CUNEIFORM SIGN PI TIMES U2",
    "12289": "CUNEIFORM SIGN PI CROSSING PI",
    "1228A": "CUNEIFORM SIGN PIRIG",
    "1228B": "CUNEIFORM SIGN PIRIG TIMES KAL",
    "1228C": "CUNEIFORM SIGN PIRIG TIMES UD",
    "1228D": "CUNEIFORM SIGN PIRIG TIMES ZA",
    "1228E": "CUNEIFORM SIGN PIRIG OPPOSING PIRIG",
    "1228F": "CUNEIFORM SIGN RA",
    "12290": "CUNEIFORM SIGN RAB",
    "12291": "CUNEIFORM SIGN RI",
    "12292": "CUNEIFORM SIGN RU",
    "12293": "CUNEIFORM SIGN SA",
    "12294": "CUNEIFORM SIGN SAG NUTILLU",
    "12295": "CUNEIFORM SIGN SAG",
    "12296": "CUNEIFORM SIGN SAG TIMES A",
    "12297": "CUNEIFORM SIGN SAG TIMES DU",
    "12298": "CUNEIFORM SIGN SAG TIMES DUB",
    "12299": "CUNEIFORM SIGN SAG TIMES HA",
    "1229A": "CUNEIFORM SIGN SAG TIMES KAK",
    "1229B": "CUNEIFORM SIGN SAG TIMES KUR",
    "1229C": "CUNEIFORM SIGN SAG TIMES LUM",
    "1229D": "CUNEIFORM SIGN SAG TIMES MI",
    "1229E": "CUNEIFORM SIGN SAG TIMES NUN",
    "1229F": "CUNEIFORM SIGN SAG TIMES SAL",
    "122A0": "CUNEIFORM SIGN SAG TIMES SHID",
    "122A1": "CUNEIFORM SIGN SAG TIMES TAB",
    "122A2": "CUNEIFORM SIGN SAG TIMES U2",
    "122A3": "CUNEIFORM SIGN SAG TIMES UB",
    "122A4": "CUNEIFORM SIGN SAG TIMES UM",
    "122A5": "CUNEIFORM SIGN SAG TIMES UR",
    "122A6": "CUNEIFORM SIGN SAG TIMES USH",
    "122A7": "CUNEIFORM SIGN SAG OVER SAG",
    "122A8": "CUNEIFORM SIGN SAG GUNU",
    "122A9": "CUNEIFORM SIGN SAL",
    "122AA": "CUNEIFORM SIGN SAL LAGAB TIMES ASH2",
    "122AB": "CUNEIFORM SIGN SANGA2",
    "122AC": "CUNEIFORM SIGN SAR",
    "122AD": "CUNEIFORM SIGN SHA",
    "122AE": "CUNEIFORM SIGN SHA3",
    "122AF": "CUNEIFORM SIGN SHA3 TIMES A",
    "122B0": "CUNEIFORM SIGN SHA3 TIMES BAD",
    "122B1": "CUNEIFORM SIGN SHA3 TIMES GISH",
    "122B2": "CUNEIFORM SIGN SHA3 TIMES NE",
    "122B3": "CUNEIFORM SIGN SHA3 TIMES SHU2",
    "122B4": "CUNEIFORM SIGN SHA3 TIMES TUR",
    "122B5": "CUNEIFORM SIGN SHA3 TIMES U",
    "122B6": "CUNEIFORM SIGN SHA3 TIMES U PLUS A",
    "122B7": "CUNEIFORM SIGN SHA6",
    "122B8": "CUNEIFORM SIGN SHAB6",
    "122B9": "CUNEIFORM SIGN SHAR2",
    "122BA": "CUNEIFORM SIGN SHE",
    "122BB": "CUNEIFORM SIGN SHE HU",
    "122BC": "CUNEIFORM SIGN SHE OVER SHE GAD OVER GAD GAR OVER GAR",
    "122BD": "CUNEIFORM SIGN SHE OVER SHE TAB OVER TAB GAR OVER GAR",
    "122BE": "CUNEIFORM SIGN SHEG9",
    "122BF": "CUNEIFORM SIGN SHEN",
    "122C0": "CUNEIFORM SIGN SHESH",
    "122C1": "CUNEIFORM SIGN SHESH2",
    "122C2": "CUNEIFORM SIGN SHESHLAM",
    "122C3": "CUNEIFORM SIGN SHID",
    "122C4": "CUNEIFORM SIGN SHID TIMES A",
    "122C5": "CUNEIFORM SIGN SHID TIMES IM",
    "122C6": "CUNEIFORM SIGN SHIM",
    "122C7": "CUNEIFORM SIGN SHIM TIMES A",
    "122C8": "CUNEIFORM SIGN SHIM TIMES BAL",
    "122C9": "CUNEIFORM SIGN SHIM TIMES BULUG",
    "122CA": "CUNEIFORM SIGN SHIM TIMES DIN",
    "122CB": "CUNEIFORM SIGN SHIM TIMES GAR",
    "122CC": "CUNEIFORM SIGN SHIM TIMES IGI",
    "122CD": "CUNEIFORM SIGN SHIM TIMES IGI GUNU",
    "122CE": "CUNEIFORM SIGN SHIM TIMES KUSHU2",
    "122CF": "CUNEIFORM SIGN SHIM TIMES LUL",
    "122D0": "CUNEIFORM SIGN SHIM TIMES MUG",
    "122D1": "CUNEIFORM SIGN SHIM TIMES SAL",
    "122D2": "CUNEIFORM SIGN SHINIG",
    "122D3": "CUNEIFORM SIGN SHIR",
    "122D4": "CUNEIFORM SIGN SHIR TENU",
    "122D5": "CUNEIFORM SIGN SHIR OVER SHIR BUR OVER BUR",
    "122D6": "CUNEIFORM SIGN SHITA",
    "122D7": "CUNEIFORM SIGN SHU",
    "122D8": "CUNEIFORM SIGN SHU OVER INVERTED SHU",
    "122D9": "CUNEIFORM SIGN SHU2",
    "122DA": "CUNEIFORM SIGN SHUBUR",
    "122DB": "CUNEIFORM SIGN SI",
    "122DC": "CUNEIFORM SIGN SI GUNU",
    "122DD": "CUNEIFORM SIGN SIG",
    "122DE": "CUNEIFORM SIGN SIG4",
    "122DF": "CUNEIFORM SIGN SIG4 OVER SIG4 SHU2",
    "122E0": "CUNEIFORM SIGN SIK2",
    "122E1": "CUNEIFORM SIGN SILA3",
    "122E2": "CUNEIFORM SIGN SU",
    "122E3": "CUNEIFORM SIGN SU OVER SU",
    "122E4": "CUNEIFORM SIGN SUD",
    "122E5": "CUNEIFORM SIGN SUD2",
    "122E6": "CUNEIFORM SIGN SUHUR",
    "122E7": "CUNEIFORM SIGN SUM",
    "122E8": "CUNEIFORM SIGN SUMASH",
    "122E9": "CUNEIFORM SIGN SUR",
    "122EA": "CUNEIFORM SIGN SUR9",
    "122EB": "CUNEIFORM SIGN TA",
    "122EC": "CUNEIFORM SIGN TA ASTERISK",
    "122ED": "CUNEIFORM SIGN TA TIMES HI",
    "122EE": "CUNEIFORM SIGN TA TIMES MI",
    "122EF": "CUNEIFORM SIGN TA GUNU",
    "122F0": "CUNEIFORM SIGN TAB",
    "122F1": "CUNEIFORM SIGN TAB OVER TAB NI OVER NI DISH OVER DISH",
    "122F2": "CUNEIFORM SIGN TAB SQUARED",
    "122F3": "CUNEIFORM SIGN TAG",
    "122F4": "CUNEIFORM SIGN TAG TIMES BI",
    "122F5": "CUNEIFORM SIGN TAG TIMES GUD",
    "122F6": "CUNEIFORM SIGN TAG TIMES SHE",
    "122F7": "CUNEIFORM SIGN TAG TIMES SHU",
    "122F8": "CUNEIFORM SIGN TAG TIMES TUG2",
    "122F9": "CUNEIFORM SIGN TAG TIMES UD",
    "122FA": "CUNEIFORM SIGN TAK4",
    "122FB": "CUNEIFORM SIGN TAR",
    "122FC": "CUNEIFORM SIGN TE",
    "122FD": "CUNEIFORM SIGN TE GUNU",
    "122FE": "CUNEIFORM SIGN TI",
    "122FF": "CUNEIFORM SIGN TI TENU",
    "12300": "CUNEIFORM SIGN TIL",
    "12301": "CUNEIFORM SIGN TIR",
    "12302": "CUNEIFORM SIGN TIR TIMES TAK4",
    "12303": "CUNEIFORM SIGN TIR OVER TIR",
    "12304": "CUNEIFORM SIGN TIR OVER TIR GAD OVER GAD GAR OVER GAR",
    "12305": "CUNEIFORM SIGN TU",
    "12306": "CUNEIFORM SIGN TUG2",
    "12307": "CUNEIFORM SIGN TUK",
    "12308": "CUNEIFORM SIGN TUM",
    "12309": "CUNEIFORM SIGN TUR",
    "1230A": "CUNEIFORM SIGN TUR OVER TUR ZA OVER ZA",
    "1230B": "CUNEIFORM SIGN U",
    "1230C": "CUNEIFORM SIGN U GUD",
    "1230D": "CUNEIFORM SIGN U U U",
    "1230E": "CUNEIFORM SIGN U OVER U PA OVER PA GAR OVER GAR",
    "1230F": "CUNEIFORM SIGN U OVER U SUR OVER SUR",
    "12310": "CUNEIFORM SIGN U OVER U U REVERSED OVER U REVERSED",
    "12311": "CUNEIFORM SIGN U2",
    "12312": "CUNEIFORM SIGN UB",
    "12313": "CUNEIFORM SIGN UD",
    "12314": "CUNEIFORM SIGN UD KUSHU2",
    "12315": "CUNEIFORM SIGN UD TIMES BAD",
    "12316": "CUNEIFORM SIGN UD TIMES MI",
    "12317": "CUNEIFORM SIGN UD TIMES U PLUS U PLUS U",
    "12318": "CUNEIFORM SIGN UD TIMES U PLUS U PLUS U GUNU",
    "12319": "CUNEIFORM SIGN UD GUNU",
    "1231A": "CUNEIFORM SIGN UD SHESHIG",
    "1231B": "CUNEIFORM SIGN UD SHESHIG TIMES BAD",
    "1231C": "CUNEIFORM SIGN UDUG",
    "1231D": "CUNEIFORM SIGN UM",
    "1231E": "CUNEIFORM SIGN UM TIMES LAGAB",
    "1231F": "CUNEIFORM SIGN UM TIMES ME PLUS DA",
    "12320": "CUNEIFORM SIGN UM TIMES SHA3",
    "12321": "CUNEIFORM SIGN UM TIMES U",
    "12322": "CUNEIFORM SIGN UMBIN",
    "12323": "CUNEIFORM SIGN UMUM",
    "12324": "CUNEIFORM SIGN UMUM TIMES KASKAL",
    "12325": "CUNEIFORM SIGN UMUM TIMES PA",
    "12326": "CUNEIFORM SIGN UN",
    "12327": "CUNEIFORM SIGN UN GUNU",
    "12328": "CUNEIFORM SIGN UR",
    "12329": "CUNEIFORM SIGN UR CROSSING UR",
    "1232A": "CUNEIFORM SIGN UR SHESHIG",
    "1232B": "CUNEIFORM SIGN UR2",
    "1232C": "CUNEIFORM SIGN UR2 TIMES A PLUS HA",
    "1232D": "CUNEIFORM SIGN UR2 TIMES A PLUS NA",
    "1232E": "CUNEIFORM SIGN UR2 TIMES AL",
    "1232F": "CUNEIFORM SIGN UR2 TIMES HA",
    "12330": "CUNEIFORM SIGN UR2 TIMES NUN",
    "12331": "CUNEIFORM SIGN UR2 TIMES U2",
    "12332": "CUNEIFORM SIGN UR2 TIMES U2 PLUS ASH",
    "12333": "CUNEIFORM SIGN UR2 TIMES U2 PLUS BI",
    "12334": "CUNEIFORM SIGN UR4",
    "12335": "CUNEIFORM SIGN URI",
    "12336": "CUNEIFORM SIGN URI3",
    "12337": "CUNEIFORM SIGN URU",
    "12338": "CUNEIFORM SIGN URU TIMES A",
    "12339": "CUNEIFORM SIGN URU TIMES ASHGAB",
    "1233A": "CUNEIFORM SIGN URU TIMES BAR",
    "1233B": "CUNEIFORM SIGN URU TIMES DUN",
    "1233C": "CUNEIFORM SIGN URU TIMES GA",
    "1233D": "CUNEIFORM SIGN URU TIMES GAL",
    "1233E": "CUNEIFORM SIGN URU TIMES GAN2 TENU",
    "1233F": "CUNEIFORM SIGN URU TIMES GAR",
    "12340": "CUNEIFORM SIGN URU TIMES GU",
    "12341": "CUNEIFORM SIGN URU TIMES HA",
    "12342": "CUNEIFORM SIGN URU TIMES IGI",
    "12343": "CUNEIFORM SIGN URU TIMES IM",
    "12344": "CUNEIFORM SIGN URU TIMES ISH",
    "12345": "CUNEIFORM SIGN URU TIMES KI",
    "12346": "CUNEIFORM SIGN URU TIMES LUM",
    "12347": "CUNEIFORM SIGN URU TIMES MIN",
    "12348": "CUNEIFORM SIGN URU TIMES PA",
    "12349": "CUNEIFORM SIGN URU TIMES SHE",
    "1234A": "CUNEIFORM SIGN URU TIMES SIG4",
    "1234B": "CUNEIFORM SIGN URU TIMES TU",
    "1234C": "CUNEIFORM SIGN URU TIMES U PLUS GUD",
    "1234D": "CUNEIFORM SIGN URU TIMES UD",
    "1234E": "CUNEIFORM SIGN URU TIMES URUDA",
    "1234F": "CUNEIFORM SIGN URUDA",
    "12350": "CUNEIFORM SIGN URUDA TIMES U",
    "12351": "CUNEIFORM SIGN USH",
    "12352": "CUNEIFORM SIGN USH TIMES A",
    "12353": "CUNEIFORM SIGN USH TIMES KU",
    "12354": "CUNEIFORM SIGN USH TIMES KUR",
    "12355": "CUNEIFORM SIGN USH TIMES TAK4",
    "12356": "CUNEIFORM SIGN USHX",
    "12357": "CUNEIFORM SIGN USH2",
    "12358": "CUNEIFORM SIGN USHUMX",
    "12359": "CUNEIFORM SIGN UTUKI",
    "1235A": "CUNEIFORM SIGN UZ3",
    "1235B": "CUNEIFORM SIGN UZ3 TIMES KASKAL",
    "1235C": "CUNEIFORM SIGN UZU",
    "1235D": "CUNEIFORM SIGN ZA",
    "1235E": "CUNEIFORM SIGN ZA TENU",
    "1235F": "CUNEIFORM SIGN ZA SQUARED TIMES KUR",
    "12360": "CUNEIFORM SIGN ZAG",
    "12361": "CUNEIFORM SIGN ZAMX",
    "12362": "CUNEIFORM SIGN ZE2",
    "12363": "CUNEIFORM SIGN ZI",
    "12364": "CUNEIFORM SIGN ZI OVER ZI",
    "12365": "CUNEIFORM SIGN ZI3",
    "12366": "CUNEIFORM SIGN ZIB",
    "12367": "CUNEIFORM SIGN ZIB KABA TENU",
    "12368": "CUNEIFORM SIGN ZIG",
    "12369": "CUNEIFORM SIGN ZIZ2",
    "1236A": "CUNEIFORM SIGN ZU",
    "1236B": "CUNEIFORM SIGN ZU5",
    "1236C": "CUNEIFORM SIGN ZU5 TIMES A",
    "1236D": "CUNEIFORM SIGN ZUBUR",
    "1236E": "CUNEIFORM SIGN ZUM",
    "1236F": "CUNEIFORM SIGN KAP ELAMITE",
    "12370": "CUNEIFORM SIGN AB TIMES NUN",
    "12371": "CUNEIFORM SIGN AB2 TIMES A",
    "12372": "CUNEIFORM SIGN AMAR TIMES KUG",
    "12373": "CUNEIFORM SIGN DAG KISIM5 TIMES U2 PLUS MASH",
    "12374": "CUNEIFORM SIGN DAG3",
    "12375": "CUNEIFORM SIGN DISH PLUS SHU",
    "12376": "CUNEIFORM SIGN DUB TIMES SHE",
    "12377": "CUNEIFORM SIGN EZEN TIMES GUD",
    "12378": "CUNEIFORM SIGN EZEN TIMES SHE",
    "12379": "CUNEIFORM SIGN GA2 TIMES AN PLUS KAK PLUS A",
    "1237A": "CUNEIFORM SIGN GA2 TIMES ASH2",
    "1237B": "CUNEIFORM SIGN GE22",
    "1237C": "CUNEIFORM SIGN GIG",
    "1237D": "CUNEIFORM SIGN HUSH",
    "1237E": "CUNEIFORM SIGN KA TIMES ANSHE",
    "1237F": "CUNEIFORM SIGN KA TIMES ASH3",
    "12380": "CUNEIFORM SIGN KA TIMES GISH",
    "12381": "CUNEIFORM SIGN KA TIMES GUD",
    "12382": "CUNEIFORM SIGN KA TIMES HI TIMES ASH2",
    "12383": "CUNEIFORM SIGN KA TIMES LUM",
    "12384": "CUNEIFORM SIGN KA TIMES PA",
    "12385": "CUNEIFORM SIGN KA TIMES SHUL",
    "12386": "CUNEIFORM SIGN KA TIMES TU",
    "12387": "CUNEIFORM SIGN KA TIMES UR2",
    "12388": "CUNEIFORM SIGN LAGAB TIMES GI",
    "12389": "CUNEIFORM SIGN LU2 SHESHIG TIMES BAD",
    "1238A": "CUNEIFORM SIGN LU2 TIMES ESH2 PLUS LAL",
    "1238B": "CUNEIFORM SIGN LU2 TIMES SHU",
    "1238C": "CUNEIFORM SIGN MESH",
    "1238D": "CUNEIFORM SIGN MUSH3 TIMES ZA",
    "1238E": "CUNEIFORM SIGN NA4",
    "1238F": "CUNEIFORM SIGN NIN",
    "12390": "CUNEIFORM SIGN NIN9",
    "12391": "CUNEIFORM SIGN NINDA2 TIMES BAL",
    "12392": "CUNEIFORM SIGN NINDA2 TIMES GI",
    "12393": "CUNEIFORM SIGN NU11 ROTATED NINETY DEGREES",
    "12394": "CUNEIFORM SIGN PESH2 ASTERISK",
    "12395": "CUNEIFORM SIGN PIR2",
    "12396": "CUNEIFORM SIGN SAG TIMES IGI GUNU",
    "12397": "CUNEIFORM SIGN TI2",
    "12398": "CUNEIFORM SIGN UM TIMES ME",
    "12399": "CUNEIFORM SIGN U U",
    "12400": "CUNEIFORM NUMERIC SIGN TWO ASH",
    "12401": "CUNEIFORM NUMERIC SIGN THREE ASH",
    "12402": "CUNEIFORM NUMERIC SIGN FOUR ASH",
    "12403": "CUNEIFORM NUMERIC SIGN FIVE ASH",
    "12404": "CUNEIFORM NUMERIC SIGN SIX ASH",
    "12405": "CUNEIFORM NUMERIC SIGN SEVEN ASH",
    "12406": "CUNEIFORM NUMERIC SIGN EIGHT ASH",
    "12407": "CUNEIFORM NUMERIC SIGN NINE ASH",
    "12408": "CUNEIFORM NUMERIC SIGN THREE DISH",
    "12409": "CUNEIFORM NUMERIC SIGN FOUR DISH",
    "1240A": "CUNEIFORM NUMERIC SIGN FIVE DISH",
    "1240B": "CUNEIFORM NUMERIC SIGN SIX DISH",
    "1240C": "CUNEIFORM NUMERIC SIGN SEVEN DISH",
    "1240D": "CUNEIFORM NUMERIC SIGN EIGHT DISH",
    "1240E": "CUNEIFORM NUMERIC SIGN NINE DISH",
    "1240F": "CUNEIFORM NUMERIC SIGN FOUR U",
    "12410": "CUNEIFORM NUMERIC SIGN FIVE U",
    "12411": "CUNEIFORM NUMERIC SIGN SIX U",
    "12412": "CUNEIFORM NUMERIC SIGN SEVEN U",
    "12413": "CUNEIFORM NUMERIC SIGN EIGHT U",
    "12414": "CUNEIFORM NUMERIC SIGN NINE U",
    "12415": "CUNEIFORM NUMERIC SIGN ONE GESH2",
    "12416": "CUNEIFORM NUMERIC SIGN TWO GESH2",
    "12417": "CUNEIFORM NUMERIC SIGN THREE GESH2",
    "12418": "CUNEIFORM NUMERIC SIGN FOUR GESH2",
    "12419": "CUNEIFORM NUMERIC SIGN FIVE GESH2",
    "1241A": "CUNEIFORM NUMERIC SIGN SIX GESH2",
    "1241B": "CUNEIFORM NUMERIC SIGN SEVEN GESH2",
    "1241C": "CUNEIFORM NUMERIC SIGN EIGHT GESH2",
    "1241D": "CUNEIFORM NUMERIC SIGN NINE GESH2",
    "1241E": "CUNEIFORM NUMERIC SIGN ONE GESHU",
    "1241F": "CUNEIFORM NUMERIC SIGN TWO GESHU",
    "12420": "CUNEIFORM NUMERIC SIGN THREE GESHU",
    "12421": "CUNEIFORM NUMERIC SIGN FOUR GESHU",
    "12422": "CUNEIFORM NUMERIC SIGN FIVE GESHU",
    "12423": "CUNEIFORM NUMERIC SIGN TWO SHAR2",
    "12424": "CUNEIFORM NUMERIC SIGN THREE SHAR2",
    "12425": "CUNEIFORM NUMERIC SIGN THREE SHAR2 VARIANT FORM",
    "12426": "CUNEIFORM NUMERIC SIGN FOUR SHAR2",
    "12427": "CUNEIFORM NUMERIC SIGN FIVE SHAR2",
    "12428": "CUNEIFORM NUMERIC SIGN SIX SHAR2",
    "12429": "CUNEIFORM NUMERIC SIGN SEVEN SHAR2",
    "1242A": "CUNEIFORM NUMERIC SIGN EIGHT SHAR2",
    "1242B": "CUNEIFORM NUMERIC SIGN NINE SHAR2",
    "1242C": "CUNEIFORM NUMERIC SIGN ONE SHARU",
    "1242D": "CUNEIFORM NUMERIC SIGN TWO SHARU",
    "1242E": "CUNEIFORM NUMERIC SIGN THREE SHARU",
    "1242F": "CUNEIFORM NUMERIC SIGN THREE SHARU VARIANT FORM",
    "12430": "CUNEIFORM NUMERIC SIGN FOUR SHARU",
    "12431": "CUNEIFORM NUMERIC SIGN FIVE SHARU",
    "12432": "CUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS DISH",
    "12433": "CUNEIFORM NUMERIC SIGN SHAR2 TIMES GAL PLUS MIN",
    "12434": "CUNEIFORM NUMERIC SIGN ONE BURU",
    "12435": "CUNEIFORM NUMERIC SIGN TWO BURU",
    "12436": "CUNEIFORM NUMERIC SIGN THREE BURU",
    "12437": "CUNEIFORM NUMERIC SIGN THREE BURU VARIANT FORM",
    "12438": "CUNEIFORM NUMERIC SIGN FOUR BURU",
    "12439": "CUNEIFORM NUMERIC SIGN FIVE BURU",
    "1243A": "CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH16",
    "1243B": "CUNEIFORM NUMERIC SIGN THREE VARIANT FORM ESH21",
    "1243C": "CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU",
    "1243D": "CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU4",
    "1243E": "CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU A",
    "1243F": "CUNEIFORM NUMERIC SIGN FOUR VARIANT FORM LIMMU B",
    "12440": "CUNEIFORM NUMERIC SIGN SIX VARIANT FORM ASH9",
    "12441": "CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN3",
    "12442": "CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN A",
    "12443": "CUNEIFORM NUMERIC SIGN SEVEN VARIANT FORM IMIN B",
    "12444": "CUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU",
    "12445": "CUNEIFORM NUMERIC SIGN EIGHT VARIANT FORM USSU3",
    "12446": "CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU",
    "12447": "CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU3",
    "12448": "CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU4",
    "12449": "CUNEIFORM NUMERIC SIGN NINE VARIANT FORM ILIMMU A",
    "1244A": "CUNEIFORM NUMERIC SIGN TWO ASH TENU",
    "1244B": "CUNEIFORM NUMERIC SIGN THREE ASH TENU",
    "1244C": "CUNEIFORM NUMERIC SIGN FOUR ASH TENU",
    "1244D": "CUNEIFORM NUMERIC SIGN FIVE ASH TENU",
    "1244E": "CUNEIFORM NUMERIC SIGN SIX ASH TENU",
    "1244F": "CUNEIFORM NUMERIC SIGN ONE BAN2",
    "12450": "CUNEIFORM NUMERIC SIGN TWO BAN2",
    "12451": "CUNEIFORM NUMERIC SIGN THREE BAN2",
    "12452": "CUNEIFORM NUMERIC SIGN FOUR BAN2",
    "12453": "CUNEIFORM NUMERIC SIGN FOUR BAN2 VARIANT FORM",
    "12454": "CUNEIFORM NUMERIC SIGN FIVE BAN2",
    "12455": "CUNEIFORM NUMERIC SIGN FIVE BAN2 VARIANT FORM",
    "12456": "CUNEIFORM NUMERIC SIGN NIGIDAMIN",
    "12457": "CUNEIFORM NUMERIC SIGN NIGIDAESH",
    "12458": "CUNEIFORM NUMERIC SIGN ONE ESHE3",
    "12459": "CUNEIFORM NUMERIC SIGN TWO ESHE3",
    "1245A": "CUNEIFORM NUMERIC SIGN ONE THIRD DISH",
    "1245B": "CUNEIFORM NUMERIC SIGN TWO THIRDS DISH",
    "1245C": "CUNEIFORM NUMERIC SIGN FIVE SIXTHS DISH",
    "1245D": "CUNEIFORM NUMERIC SIGN ONE THIRD VARIANT FORM A",
    "1245E": "CUNEIFORM NUMERIC SIGN TWO THIRDS VARIANT FORM A",
    "1245F": "CUNEIFORM NUMERIC SIGN ONE EIGHTH ASH",
    "12460": "CUNEIFORM NUMERIC SIGN ONE QUARTER ASH",
    "12461": "CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE SIXTH",
    "12462": "CUNEIFORM NUMERIC SIGN OLD ASSYRIAN ONE QUARTER",
    "12463": "CUNEIFORM NUMERIC SIGN ONE QUARTER GUR",
    "12464": "CUNEIFORM NUMERIC SIGN ONE HALF GUR",
    "12465": "CUNEIFORM NUMERIC SIGN ELAMITE ONE THIRD",
    "12466": "CUNEIFORM NUMERIC SIGN ELAMITE TWO THIRDS",
    "12467": "CUNEIFORM NUMERIC SIGN ELAMITE FORTY",
    "12468": "CUNEIFORM NUMERIC SIGN ELAMITE FIFTY",
    "12469": "CUNEIFORM NUMERIC SIGN FOUR U VARIANT FORM",
    "1246A": "CUNEIFORM NUMERIC SIGN FIVE U VARIANT FORM",
    "1246B": "CUNEIFORM NUMERIC SIGN SIX U VARIANT FORM",
    "1246C": "CUNEIFORM NUMERIC SIGN SEVEN U VARIANT FORM",
    "1246D": "CUNEIFORM NUMERIC SIGN EIGHT U VARIANT FORM",
    "1246E": "CUNEIFORM NUMERIC SIGN NINE U VARIANT FORM",
    "12470": "CUNEIFORM PUNCTUATION SIGN OLD ASSYRIAN WORD DIVIDER",
    "12471": "CUNEIFORM PUNCTUATION SIGN VERTICAL COLON",
    "12472": "CUNEIFORM PUNCTUATION SIGN DIAGONAL COLON",
    "12473": "CUNEIFORM PUNCTUATION SIGN DIAGONAL TRICOLON",
    "12474": "CUNEIFORM PUNCTUATION SIGN DIAGONAL QUADCOLON",
    "12480": "CUNEIFORM SIGN AB TIMES NUN TENU",
    "12481": "CUNEIFORM SIGN AB TIMES SHU2",
    "12482": "CUNEIFORM SIGN AD TIMES ESH2",
    "12483": "CUNEIFORM SIGN BAD TIMES DISH TENU",
    "12484": "CUNEIFORM SIGN BAHAR2 TIMES AB2",
    "12485": "CUNEIFORM SIGN BAHAR2 TIMES NI",
    "12486": "CUNEIFORM SIGN BAHAR2 TIMES ZA",
    "12487": "CUNEIFORM SIGN BU OVER BU TIMES NA2",
    "12488": "CUNEIFORM SIGN DA TIMES TAK4",
    "12489": "CUNEIFORM SIGN DAG TIMES KUR",
    "1248A": "CUNEIFORM SIGN DIM TIMES IGI",
    "1248B": "CUNEIFORM SIGN DIM TIMES U U U",
    "1248C": "CUNEIFORM SIGN DIM2 TIMES UD",
    "1248D": "CUNEIFORM SIGN DUG TIMES ANSHE",
    "1248E": "CUNEIFORM SIGN DUG TIMES ASH",
    "1248F": "CUNEIFORM SIGN DUG TIMES ASH AT LEFT",
    "12490": "CUNEIFORM SIGN DUG TIMES DIN",
    "12491": "CUNEIFORM SIGN DUG TIMES DUN",
    "12492": "CUNEIFORM SIGN DUG TIMES ERIN2",
    "12493": "CUNEIFORM SIGN DUG TIMES GA",
    "12494": "CUNEIFORM SIGN DUG TIMES GI",
    "12495": "CUNEIFORM SIGN DUG TIMES GIR2 GUNU",
    "12496": "CUNEIFORM SIGN DUG TIMES GISH",
    "12497": "CUNEIFORM SIGN DUG TIMES HA",
    "12498": "CUNEIFORM SIGN DUG TIMES HI",
    "12499": "CUNEIFORM SIGN DUG TIMES IGI GUNU",
    "1249A": "CUNEIFORM SIGN DUG TIMES KASKAL",
    "1249B": "CUNEIFORM SIGN DUG TIMES KUR",
    "1249C": "CUNEIFORM SIGN DUG TIMES KUSHU2",
    "1249D": "CUNEIFORM SIGN DUG TIMES KUSHU2 PLUS KASKAL",
    "1249E": "CUNEIFORM SIGN DUG TIMES LAK-020",
    "1249F": "CUNEIFORM SIGN DUG TIMES LAM",
    "124A0": "CUNEIFORM SIGN DUG TIMES LAM TIMES KUR",
    "124A1": "CUNEIFORM SIGN DUG TIMES LUH PLUS GISH",
    "124A2": "CUNEIFORM SIGN DUG TIMES MASH",
    "124A3": "CUNEIFORM SIGN DUG TIMES MES",
    "124A4": "CUNEIFORM SIGN DUG TIMES MI",
    "124A5": "CUNEIFORM SIGN DUG TIMES NI",
    "124A6": "CUNEIFORM SIGN DUG TIMES PI",
    "124A7": "CUNEIFORM SIGN DUG TIMES SHE",
    "124A8": "CUNEIFORM SIGN DUG TIMES SI GUNU",
    "124A9": "CUNEIFORM SIGN E2 TIMES KUR",
    "124AA": "CUNEIFORM SIGN E2 TIMES PAP",
    "124AB": "CUNEIFORM SIGN ERIN2 X",
    "124AC": "CUNEIFORM SIGN ESH2 CROSSING ESH2",
    "124AD": "CUNEIFORM SIGN EZEN SHESHIG TIMES ASH",
    "124AE": "CUNEIFORM SIGN EZEN SHESHIG TIMES HI",
    "124AF": "CUNEIFORM SIGN EZEN SHESHIG TIMES IGI GUNU",
    "124B0": "CUNEIFORM SIGN EZEN SHESHIG TIMES LA",
    "124B1": "CUNEIFORM SIGN EZEN SHESHIG TIMES LAL",
    "124B2": "CUNEIFORM SIGN EZEN SHESHIG TIMES ME",
    "124B3": "CUNEIFORM SIGN EZEN SHESHIG TIMES MES",
    "124B4": "CUNEIFORM SIGN EZEN SHESHIG TIMES SU",
    "124B5": "CUNEIFORM SIGN EZEN TIMES SU",
    "124B6": "CUNEIFORM SIGN GA2 TIMES BAHAR2",
    "124B7": "CUNEIFORM SIGN GA2 TIMES DIM GUNU",
    "124B8": "CUNEIFORM SIGN GA2 TIMES DUG TIMES IGI GUNU",
    "124B9": "CUNEIFORM SIGN GA2 TIMES DUG TIMES KASKAL",
    "124BA": "CUNEIFORM SIGN GA2 TIMES EREN",
    "124BB": "CUNEIFORM SIGN GA2 TIMES GA",
    "124BC": "CUNEIFORM SIGN GA2 TIMES GAR PLUS DI",
    "124BD": "CUNEIFORM SIGN GA2 TIMES GAR PLUS NE",
    "124BE": "CUNEIFORM SIGN GA2 TIMES HA PLUS A",
    "124BF": "CUNEIFORM SIGN GA2 TIMES KUSHU2 PLUS KASKAL",
    "124C0": "CUNEIFORM SIGN GA2 TIMES LAM",
    "124C1": "CUNEIFORM SIGN GA2 TIMES LAM TIMES KUR",
    "124C2": "CUNEIFORM SIGN GA2 TIMES LUH",
    "124C3": "CUNEIFORM SIGN GA2 TIMES MUSH",
    "124C4": "CUNEIFORM SIGN GA2 TIMES NE",
    "124C5": "CUNEIFORM SIGN GA2 TIMES NE PLUS E2",
    "124C6": "CUNEIFORM SIGN GA2 TIMES NE PLUS GI",
    "124C7": "CUNEIFORM SIGN GA2 TIMES SHIM",
    "124C8": "CUNEIFORM SIGN GA2 TIMES ZIZ2",
    "124C9": "CUNEIFORM SIGN GABA ROTATED NINETY DEGREES",
    "124CA": "CUNEIFORM SIGN GESHTIN TIMES U",
    "124CB": "CUNEIFORM SIGN GISH TIMES GISH CROSSING GISH",
    "124CC": "CUNEIFORM SIGN GU2 TIMES IGI GUNU",
    "124CD": "CUNEIFORM SIGN GUD PLUS GISH TIMES TAK4",
    "124CE": "CUNEIFORM SIGN HA TENU GUNU",
    "124CF": "CUNEIFORM SIGN HI TIMES ASH OVER HI TIMES ASH",
    "124D0": "CUNEIFORM SIGN KA TIMES BU",
    "124D1": "CUNEIFORM SIGN KA TIMES KA",
    "124D2": "CUNEIFORM SIGN KA TIMES U U U",
    "124D3": "CUNEIFORM SIGN KA TIMES UR",
    "124D4": "CUNEIFORM SIGN LAGAB TIMES ZU OVER ZU",
    "124D5": "CUNEIFORM SIGN LAK-003",
    "124D6": "CUNEIFORM SIGN LAK-021",
    "124D7": "CUNEIFORM SIGN LAK-025",
    "124D8": "CUNEIFORM SIGN LAK-030",
    "124D9": "CUNEIFORM SIGN LAK-050",
    "124DA": "CUNEIFORM SIGN LAK-051",
    "124DB": "CUNEIFORM SIGN LAK-062",
    "124DC": "CUNEIFORM SIGN LAK-079 OVER LAK-079 GUNU",
    "124DD": "CUNEIFORM SIGN LAK-080",
    "124DE": "CUNEIFORM SIGN LAK-081 OVER LAK-081",
    "124DF": "CUNEIFORM SIGN LAK-092",
    "124E0": "CUNEIFORM SIGN LAK-130",
    "124E1": "CUNEIFORM SIGN LAK-142",
    "124E2": "CUNEIFORM SIGN LAK-210",
    "124E3": "CUNEIFORM SIGN LAK-219",
    "124E4": "CUNEIFORM SIGN LAK-220",
    "124E5": "CUNEIFORM SIGN LAK-225",
    "124E6": "CUNEIFORM SIGN LAK-228",
    "124E7": "CUNEIFORM SIGN LAK-238",
    "124E8": "CUNEIFORM SIGN LAK-265",
    "124E9": "CUNEIFORM SIGN LAK-266",
    "124EA": "CUNEIFORM SIGN LAK-343",
    "124EB": "CUNEIFORM SIGN LAK-347",
    "124EC": "CUNEIFORM SIGN LAK-348",
    "124ED": "CUNEIFORM SIGN LAK-383",
    "124EE": "CUNEIFORM SIGN LAK-384",
    "124EF": "CUNEIFORM SIGN LAK-390",
    "124F0": "CUNEIFORM SIGN LAK-441",
    "124F1": "CUNEIFORM SIGN LAK-449",
    "124F2": "CUNEIFORM SIGN LAK-449 TIMES GU",
    "124F3": "CUNEIFORM SIGN LAK-449 TIMES IGI",
    "124F4": "CUNEIFORM SIGN LAK-449 TIMES PAP PLUS LU3",
    "124F5": "CUNEIFORM SIGN LAK-449 TIMES PAP PLUS PAP PLUS LU3",
    "124F6": "CUNEIFORM SIGN LAK-449 TIMES U2 PLUS BA",
    "124F7": "CUNEIFORM SIGN LAK-450",
    "124F8": "CUNEIFORM SIGN LAK-457",
    "124F9": "CUNEIFORM SIGN LAK-470",
    "124FA": "CUNEIFORM SIGN LAK-483",
    "124FB": "CUNEIFORM SIGN LAK-490",
    "124FC": "CUNEIFORM SIGN LAK-492",
    "124FD": "CUNEIFORM SIGN LAK-493",
    "124FE": "CUNEIFORM SIGN LAK-495",
    "124FF": "CUNEIFORM SIGN LAK-550",
    "12500": "CUNEIFORM SIGN LAK-608",
    "12501": "CUNEIFORM SIGN LAK-617",
    "12502": "CUNEIFORM SIGN LAK-617 TIMES ASH",
    "12503": "CUNEIFORM SIGN LAK-617 TIMES BAD",
    "12504": "CUNEIFORM SIGN LAK-617 TIMES DUN3 GUNU GUNU",
    "12505": "CUNEIFORM SIGN LAK-617 TIMES KU3",
    "12506": "CUNEIFORM SIGN LAK-617 TIMES LA",
    "12507": "CUNEIFORM SIGN LAK-617 TIMES TAR",
    "12508": "CUNEIFORM SIGN LAK-617 TIMES TE",
    "12509": "CUNEIFORM SIGN LAK-617 TIMES U2",
    "1250A": "CUNEIFORM SIGN LAK-617 TIMES UD",
    "1250B": "CUNEIFORM SIGN LAK-617 TIMES URUDA",
    "1250C": "CUNEIFORM SIGN LAK-636",
    "1250D": "CUNEIFORM SIGN LAK-648",
    "1250E": "CUNEIFORM SIGN LAK-648 TIMES DUB",
    "1250F": "CUNEIFORM SIGN LAK-648 TIMES GA",
    "12510": "CUNEIFORM SIGN LAK-648 TIMES IGI",
    "12511": "CUNEIFORM SIGN LAK-648 TIMES IGI GUNU",
    "12512": "CUNEIFORM SIGN LAK-648 TIMES NI",
    "12513": "CUNEIFORM SIGN LAK-648 TIMES PAP PLUS PAP PLUS LU3",
    "12514": "CUNEIFORM SIGN LAK-648 TIMES SHESH PLUS KI",
    "12515": "CUNEIFORM SIGN LAK-648 TIMES UD",
    "12516": "CUNEIFORM SIGN LAK-648 TIMES URUDA",
    "12517": "CUNEIFORM SIGN LAK-724",
    "12518": "CUNEIFORM SIGN LAK-749",
    "12519": "CUNEIFORM SIGN LU2 GUNU TIMES ASH",
    "1251A": "CUNEIFORM SIGN LU2 TIMES DISH",
    "1251B": "CUNEIFORM SIGN LU2 TIMES HAL",
    "1251C": "CUNEIFORM SIGN LU2 TIMES PAP",
    "1251D": "CUNEIFORM SIGN LU2 TIMES PAP PLUS PAP PLUS LU3",
    "1251E": "CUNEIFORM SIGN LU2 TIMES TAK4",
    "1251F": "CUNEIFORM SIGN MI PLUS ZA7",
    "12520": "CUNEIFORM SIGN MUSH OVER MUSH TIMES GA",
    "12521": "CUNEIFORM SIGN MUSH OVER MUSH TIMES KAK",
    "12522": "CUNEIFORM SIGN NINDA2 TIMES DIM GUNU",
    "12523": "CUNEIFORM SIGN NINDA2 TIMES GISH",
    "12524": "CUNEIFORM SIGN NINDA2 TIMES GUL",
    "12525": "CUNEIFORM SIGN NINDA2 TIMES HI",
    "12526": "CUNEIFORM SIGN NINDA2 TIMES KESH2",
    "12527": "CUNEIFORM SIGN NINDA2 TIMES LAK-050",
    "12528": "CUNEIFORM SIGN NINDA2 TIMES MASH",
    "12529": "CUNEIFORM SIGN NINDA2 TIMES PAP PLUS PAP",
    "1252A": "CUNEIFORM SIGN NINDA2 TIMES U",
    "1252B": "CUNEIFORM SIGN NINDA2 TIMES U PLUS U",
    "1252C": "CUNEIFORM SIGN NINDA2 TIMES URUDA",
    "1252D": "CUNEIFORM SIGN SAG GUNU TIMES HA",
    "1252E": "CUNEIFORM SIGN SAG TIMES EN",
    "1252F": "CUNEIFORM SIGN SAG TIMES SHE AT LEFT",
    "12530": "CUNEIFORM SIGN SAG TIMES TAK4",
    "12531": "CUNEIFORM SIGN SHA6 TENU",
    "12532": "CUNEIFORM SIGN SHE OVER SHE",
    "12533": "CUNEIFORM SIGN SHE PLUS HUB2",
    "12534": "CUNEIFORM SIGN SHE PLUS NAM2",
    "12535": "CUNEIFORM SIGN SHE PLUS SAR",
    "12536": "CUNEIFORM SIGN SHU2 PLUS DUG TIMES NI",
    "12537": "CUNEIFORM SIGN SHU2 PLUS E2 TIMES AN",
    "12538": "CUNEIFORM SIGN SI TIMES TAK4",
    "12539": "CUNEIFORM SIGN TAK4 PLUS SAG",
    "1253A": "CUNEIFORM SIGN TUM TIMES GAN2 TENU",
    "1253B": "CUNEIFORM SIGN TUM TIMES THREE DISH",
    "1253C": "CUNEIFORM SIGN UR2 INVERTED",
    "1253D": "CUNEIFORM SIGN UR2 TIMES UD",
    "1253E": "CUNEIFORM SIGN URU TIMES DARA3",
    "1253F": "CUNEIFORM SIGN URU TIMES LAK-668",
    "12540": "CUNEIFORM SIGN URU TIMES LU3",
    "12541": "CUNEIFORM SIGN ZA7",
    "12542": "CUNEIFORM SIGN ZU OVER ZU PLUS SAR",
    "12543": "CUNEIFORM SIGN ZU5 TIMES THREE DISH TENU",
    "13000": "EGYPTIAN HIEROGLYPH A001",
    "13001": "EGYPTIAN HIEROGLYPH A002",
    "13002": "EGYPTIAN HIEROGLYPH A003",
    "13003": "EGYPTIAN HIEROGLYPH A004",
    "13004": "EGYPTIAN HIEROGLYPH A005",
    "13005": "EGYPTIAN HIEROGLYPH A005A",
    "13006": "EGYPTIAN HIEROGLYPH A006",
    "13007": "EGYPTIAN HIEROGLYPH A006A",
    "13008": "EGYPTIAN HIEROGLYPH A006B",
    "13009": "EGYPTIAN HIEROGLYPH A007",
    "1300A": "EGYPTIAN HIEROGLYPH A008",
    "1300B": "EGYPTIAN HIEROGLYPH A009",
    "1300C": "EGYPTIAN HIEROGLYPH A010",
    "1300D": "EGYPTIAN HIEROGLYPH A011",
    "1300E": "EGYPTIAN HIEROGLYPH A012",
    "1300F": "EGYPTIAN HIEROGLYPH A013",
    "13010": "EGYPTIAN HIEROGLYPH A014",
    "13011": "EGYPTIAN HIEROGLYPH A014A",
    "13012": "EGYPTIAN HIEROGLYPH A015",
    "13013": "EGYPTIAN HIEROGLYPH A016",
    "13014": "EGYPTIAN HIEROGLYPH A017",
    "13015": "EGYPTIAN HIEROGLYPH A017A",
    "13016": "EGYPTIAN HIEROGLYPH A018",
    "13017": "EGYPTIAN HIEROGLYPH A019",
    "13018": "EGYPTIAN HIEROGLYPH A020",
    "13019": "EGYPTIAN HIEROGLYPH A021",
    "1301A": "EGYPTIAN HIEROGLYPH A022",
    "1301B": "EGYPTIAN HIEROGLYPH A023",
    "1301C": "EGYPTIAN HIEROGLYPH A024",
    "1301D": "EGYPTIAN HIEROGLYPH A025",
    "1301E": "EGYPTIAN HIEROGLYPH A026",
    "1301F": "EGYPTIAN HIEROGLYPH A027",
    "13020": "EGYPTIAN HIEROGLYPH A028",
    "13021": "EGYPTIAN HIEROGLYPH A029",
    "13022": "EGYPTIAN HIEROGLYPH A030",
    "13023": "EGYPTIAN HIEROGLYPH A031",
    "13024": "EGYPTIAN HIEROGLYPH A032",
    "13025": "EGYPTIAN HIEROGLYPH A032A",
    "13026": "EGYPTIAN HIEROGLYPH A033",
    "13027": "EGYPTIAN HIEROGLYPH A034",
    "13028": "EGYPTIAN HIEROGLYPH A035",
    "13029": "EGYPTIAN HIEROGLYPH A036",
    "1302A": "EGYPTIAN HIEROGLYPH A037",
    "1302B": "EGYPTIAN HIEROGLYPH A038",
    "1302C": "EGYPTIAN HIEROGLYPH A039",
    "1302D": "EGYPTIAN HIEROGLYPH A040",
    "1302E": "EGYPTIAN HIEROGLYPH A040A",
    "1302F": "EGYPTIAN HIEROGLYPH A041",
    "13030": "EGYPTIAN HIEROGLYPH A042",
    "13031": "EGYPTIAN HIEROGLYPH A042A",
    "13032": "EGYPTIAN HIEROGLYPH A043",
    "13033": "EGYPTIAN HIEROGLYPH A043A",
    "13034": "EGYPTIAN HIEROGLYPH A044",
    "13035": "EGYPTIAN HIEROGLYPH A045",
    "13036": "EGYPTIAN HIEROGLYPH A045A",
    "13037": "EGYPTIAN HIEROGLYPH A046",
    "13038": "EGYPTIAN HIEROGLYPH A047",
    "13039": "EGYPTIAN HIEROGLYPH A048",
    "1303A": "EGYPTIAN HIEROGLYPH A049",
    "1303B": "EGYPTIAN HIEROGLYPH A050",
    "1303C": "EGYPTIAN HIEROGLYPH A051",
    "1303D": "EGYPTIAN HIEROGLYPH A052",
    "1303E": "EGYPTIAN HIEROGLYPH A053",
    "1303F": "EGYPTIAN HIEROGLYPH A054",
    "13040": "EGYPTIAN HIEROGLYPH A055",
    "13041": "EGYPTIAN HIEROGLYPH A056",
    "13042": "EGYPTIAN HIEROGLYPH A057",
    "13043": "EGYPTIAN HIEROGLYPH A058",
    "13044": "EGYPTIAN HIEROGLYPH A059",
    "13045": "EGYPTIAN HIEROGLYPH A060",
    "13046": "EGYPTIAN HIEROGLYPH A061",
    "13047": "EGYPTIAN HIEROGLYPH A062",
    "13048": "EGYPTIAN HIEROGLYPH A063",
    "13049": "EGYPTIAN HIEROGLYPH A064",
    "1304A": "EGYPTIAN HIEROGLYPH A065",
    "1304B": "EGYPTIAN HIEROGLYPH A066",
    "1304C": "EGYPTIAN HIEROGLYPH A067",
    "1304D": "EGYPTIAN HIEROGLYPH A068",
    "1304E": "EGYPTIAN HIEROGLYPH A069",
    "1304F": "EGYPTIAN HIEROGLYPH A070",
    "13050": "EGYPTIAN HIEROGLYPH B001",
    "13051": "EGYPTIAN HIEROGLYPH B002",
    "13052": "EGYPTIAN HIEROGLYPH B003",
    "13053": "EGYPTIAN HIEROGLYPH B004",
    "13054": "EGYPTIAN HIEROGLYPH B005",
    "13055": "EGYPTIAN HIEROGLYPH B005A",
    "13056": "EGYPTIAN HIEROGLYPH B006",
    "13057": "EGYPTIAN HIEROGLYPH B007",
    "13058": "EGYPTIAN HIEROGLYPH B008",
    "13059": "EGYPTIAN HIEROGLYPH B009",
    "1305A": "EGYPTIAN HIEROGLYPH C001",
    "1305B": "EGYPTIAN HIEROGLYPH C002",
    "1305C": "EGYPTIAN HIEROGLYPH C002A",
    "1305D": "EGYPTIAN HIEROGLYPH C002B",
    "1305E": "EGYPTIAN HIEROGLYPH C002C",
    "1305F": "EGYPTIAN HIEROGLYPH C003",
    "13060": "EGYPTIAN HIEROGLYPH C004",
    "13061": "EGYPTIAN HIEROGLYPH C005",
    "13062": "EGYPTIAN HIEROGLYPH C006",
    "13063": "EGYPTIAN HIEROGLYPH C007",
    "13064": "EGYPTIAN HIEROGLYPH C008",
    "13065": "EGYPTIAN HIEROGLYPH C009",
    "13066": "EGYPTIAN HIEROGLYPH C010",
    "13067": "EGYPTIAN HIEROGLYPH C010A",
    "13068": "EGYPTIAN HIEROGLYPH C011",
    "13069": "EGYPTIAN HIEROGLYPH C012",
    "1306A": "EGYPTIAN HIEROGLYPH C013",
    "1306B": "EGYPTIAN HIEROGLYPH C014",
    "1306C": "EGYPTIAN HIEROGLYPH C015",
    "1306D": "EGYPTIAN HIEROGLYPH C016",
    "1306E": "EGYPTIAN HIEROGLYPH C017",
    "1306F": "EGYPTIAN HIEROGLYPH C018",
    "13070": "EGYPTIAN HIEROGLYPH C019",
    "13071": "EGYPTIAN HIEROGLYPH C020",
    "13072": "EGYPTIAN HIEROGLYPH C021",
    "13073": "EGYPTIAN HIEROGLYPH C022",
    "13074": "EGYPTIAN HIEROGLYPH C023",
    "13075": "EGYPTIAN HIEROGLYPH C024",
    "13076": "EGYPTIAN HIEROGLYPH D001",
    "13077": "EGYPTIAN HIEROGLYPH D002",
    "13078": "EGYPTIAN HIEROGLYPH D003",
    "13079": "EGYPTIAN HIEROGLYPH D004",
    "1307A": "EGYPTIAN HIEROGLYPH D005",
    "1307B": "EGYPTIAN HIEROGLYPH D006",
    "1307C": "EGYPTIAN HIEROGLYPH D007",
    "1307D": "EGYPTIAN HIEROGLYPH D008",
    "1307E": "EGYPTIAN HIEROGLYPH D008A",
    "1307F": "EGYPTIAN HIEROGLYPH D009",
    "13080": "EGYPTIAN HIEROGLYPH D010",
    "13081": "EGYPTIAN HIEROGLYPH D011",
    "13082": "EGYPTIAN HIEROGLYPH D012",
    "13083": "EGYPTIAN HIEROGLYPH D013",
    "13084": "EGYPTIAN HIEROGLYPH D014",
    "13085": "EGYPTIAN HIEROGLYPH D015",
    "13086": "EGYPTIAN HIEROGLYPH D016",
    "13087": "EGYPTIAN HIEROGLYPH D017",
    "13088": "EGYPTIAN HIEROGLYPH D018",
    "13089": "EGYPTIAN HIEROGLYPH D019",
    "1308A": "EGYPTIAN HIEROGLYPH D020",
    "1308B": "EGYPTIAN HIEROGLYPH D021",
    "1308C": "EGYPTIAN HIEROGLYPH D022",
    "1308D": "EGYPTIAN HIEROGLYPH D023",
    "1308E": "EGYPTIAN HIEROGLYPH D024",
    "1308F": "EGYPTIAN HIEROGLYPH D025",
    "13090": "EGYPTIAN HIEROGLYPH D026",
    "13091": "EGYPTIAN HIEROGLYPH D027",
    "13092": "EGYPTIAN HIEROGLYPH D027A",
    "13093": "EGYPTIAN HIEROGLYPH D028",
    "13094": "EGYPTIAN HIEROGLYPH D029",
    "13095": "EGYPTIAN HIEROGLYPH D030",
    "13096": "EGYPTIAN HIEROGLYPH D031",
    "13097": "EGYPTIAN HIEROGLYPH D031A",
    "13098": "EGYPTIAN HIEROGLYPH D032",
    "13099": "EGYPTIAN HIEROGLYPH D033",
    "1309A": "EGYPTIAN HIEROGLYPH D034",
    "1309B": "EGYPTIAN HIEROGLYPH D034A",
    "1309C": "EGYPTIAN HIEROGLYPH D035",
    "1309D": "EGYPTIAN HIEROGLYPH D036",
    "1309E": "EGYPTIAN HIEROGLYPH D037",
    "1309F": "EGYPTIAN HIEROGLYPH D038",
    "130A0": "EGYPTIAN HIEROGLYPH D039",
    "130A1": "EGYPTIAN HIEROGLYPH D040",
    "130A2": "EGYPTIAN HIEROGLYPH D041",
    "130A3": "EGYPTIAN HIEROGLYPH D042",
    "130A4": "EGYPTIAN HIEROGLYPH D043",
    "130A5": "EGYPTIAN HIEROGLYPH D044",
    "130A6": "EGYPTIAN HIEROGLYPH D045",
    "130A7": "EGYPTIAN HIEROGLYPH D046",
    "130A8": "EGYPTIAN HIEROGLYPH D046A",
    "130A9": "EGYPTIAN HIEROGLYPH D047",
    "130AA": "EGYPTIAN HIEROGLYPH D048",
    "130AB": "EGYPTIAN HIEROGLYPH D048A",
    "130AC": "EGYPTIAN HIEROGLYPH D049",
    "130AD": "EGYPTIAN HIEROGLYPH D050",
    "130AE": "EGYPTIAN HIEROGLYPH D050A",
    "130AF": "EGYPTIAN HIEROGLYPH D050B",
    "130B0": "EGYPTIAN HIEROGLYPH D050C",
    "130B1": "EGYPTIAN HIEROGLYPH D050D",
    "130B2": "EGYPTIAN HIEROGLYPH D050E",
    "130B3": "EGYPTIAN HIEROGLYPH D050F",
    "130B4": "EGYPTIAN HIEROGLYPH D050G",
    "130B5": "EGYPTIAN HIEROGLYPH D050H",
    "130B6": "EGYPTIAN HIEROGLYPH D050I",
    "130B7": "EGYPTIAN HIEROGLYPH D051",
    "130B8": "EGYPTIAN HIEROGLYPH D052",
    "130B9": "EGYPTIAN HIEROGLYPH D052A",
    "130BA": "EGYPTIAN HIEROGLYPH D053",
    "130BB": "EGYPTIAN HIEROGLYPH D054",
    "130BC": "EGYPTIAN HIEROGLYPH D054A",
    "130BD": "EGYPTIAN HIEROGLYPH D055",
    "130BE": "EGYPTIAN HIEROGLYPH D056",
    "130BF": "EGYPTIAN HIEROGLYPH D057",
    "130C0": "EGYPTIAN HIEROGLYPH D058",
    "130C1": "EGYPTIAN HIEROGLYPH D059",
    "130C2": "EGYPTIAN HIEROGLYPH D060",
    "130C3": "EGYPTIAN HIEROGLYPH D061",
    "130C4": "EGYPTIAN HIEROGLYPH D062",
    "130C5": "EGYPTIAN HIEROGLYPH D063",
    "130C6": "EGYPTIAN HIEROGLYPH D064",
    "130C7": "EGYPTIAN HIEROGLYPH D065",
    "130C8": "EGYPTIAN HIEROGLYPH D066",
    "130C9": "EGYPTIAN HIEROGLYPH D067",
    "130CA": "EGYPTIAN HIEROGLYPH D067A",
    "130CB": "EGYPTIAN HIEROGLYPH D067B",
    "130CC": "EGYPTIAN HIEROGLYPH D067C",
    "130CD": "EGYPTIAN HIEROGLYPH D067D",
    "130CE": "EGYPTIAN HIEROGLYPH D067E",
    "130CF": "EGYPTIAN HIEROGLYPH D067F",
    "130D0": "EGYPTIAN HIEROGLYPH D067G",
    "130D1": "EGYPTIAN HIEROGLYPH D067H",
    "130D2": "EGYPTIAN HIEROGLYPH E001",
    "130D3": "EGYPTIAN HIEROGLYPH E002",
    "130D4": "EGYPTIAN HIEROGLYPH E003",
    "130D5": "EGYPTIAN HIEROGLYPH E004",
    "130D6": "EGYPTIAN HIEROGLYPH E005",
    "130D7": "EGYPTIAN HIEROGLYPH E006",
    "130D8": "EGYPTIAN HIEROGLYPH E007",
    "130D9": "EGYPTIAN HIEROGLYPH E008",
    "130DA": "EGYPTIAN HIEROGLYPH E008A",
    "130DB": "EGYPTIAN HIEROGLYPH E009",
    "130DC": "EGYPTIAN HIEROGLYPH E009A",
    "130DD": "EGYPTIAN HIEROGLYPH E010",
    "130DE": "EGYPTIAN HIEROGLYPH E011",
    "130DF": "EGYPTIAN HIEROGLYPH E012",
    "130E0": "EGYPTIAN HIEROGLYPH E013",
    "130E1": "EGYPTIAN HIEROGLYPH E014",
    "130E2": "EGYPTIAN HIEROGLYPH E015",
    "130E3": "EGYPTIAN HIEROGLYPH E016",
    "130E4": "EGYPTIAN HIEROGLYPH E016A",
    "130E5": "EGYPTIAN HIEROGLYPH E017",
    "130E6": "EGYPTIAN HIEROGLYPH E017A",
    "130E7": "EGYPTIAN HIEROGLYPH E018",
    "130E8": "EGYPTIAN HIEROGLYPH E019",
    "130E9": "EGYPTIAN HIEROGLYPH E020",
    "130EA": "EGYPTIAN HIEROGLYPH E020A",
    "130EB": "EGYPTIAN HIEROGLYPH E021",
    "130EC": "EGYPTIAN HIEROGLYPH E022",
    "130ED": "EGYPTIAN HIEROGLYPH E023",
    "130EE": "EGYPTIAN HIEROGLYPH E024",
    "130EF": "EGYPTIAN HIEROGLYPH E025",
    "130F0": "EGYPTIAN HIEROGLYPH E026",
    "130F1": "EGYPTIAN HIEROGLYPH E027",
    "130F2": "EGYPTIAN HIEROGLYPH E028",
    "130F3": "EGYPTIAN HIEROGLYPH E028A",
    "130F4": "EGYPTIAN HIEROGLYPH E029",
    "130F5": "EGYPTIAN HIEROGLYPH E030",
    "130F6": "EGYPTIAN HIEROGLYPH E031",
    "130F7": "EGYPTIAN HIEROGLYPH E032",
    "130F8": "EGYPTIAN HIEROGLYPH E033",
    "130F9": "EGYPTIAN HIEROGLYPH E034",
    "130FA": "EGYPTIAN HIEROGLYPH E034A",
    "130FB": "EGYPTIAN HIEROGLYPH E036",
    "130FC": "EGYPTIAN HIEROGLYPH E037",
    "130FD": "EGYPTIAN HIEROGLYPH E038",
    "130FE": "EGYPTIAN HIEROGLYPH F001",
    "130FF": "EGYPTIAN HIEROGLYPH F001A",
    "13100": "EGYPTIAN HIEROGLYPH F002",
    "13101": "EGYPTIAN HIEROGLYPH F003",
    "13102": "EGYPTIAN HIEROGLYPH F004",
    "13103": "EGYPTIAN HIEROGLYPH F005",
    "13104": "EGYPTIAN HIEROGLYPH F006",
    "13105": "EGYPTIAN HIEROGLYPH F007",
    "13106": "EGYPTIAN HIEROGLYPH F008",
    "13107": "EGYPTIAN HIEROGLYPH F009",
    "13108": "EGYPTIAN HIEROGLYPH F010",
    "13109": "EGYPTIAN HIEROGLYPH F011",
    "1310A": "EGYPTIAN HIEROGLYPH F012",
    "1310B": "EGYPTIAN HIEROGLYPH F013",
    "1310C": "EGYPTIAN HIEROGLYPH F013A",
    "1310D": "EGYPTIAN HIEROGLYPH F014",
    "1310E": "EGYPTIAN HIEROGLYPH F015",
    "1310F": "EGYPTIAN HIEROGLYPH F016",
    "13110": "EGYPTIAN HIEROGLYPH F017",
    "13111": "EGYPTIAN HIEROGLYPH F018",
    "13112": "EGYPTIAN HIEROGLYPH F019",
    "13113": "EGYPTIAN HIEROGLYPH F020",
    "13114": "EGYPTIAN HIEROGLYPH F021",
    "13115": "EGYPTIAN HIEROGLYPH F021A",
    "13116": "EGYPTIAN HIEROGLYPH F022",
    "13117": "EGYPTIAN HIEROGLYPH F023",
    "13118": "EGYPTIAN HIEROGLYPH F024",
    "13119": "EGYPTIAN HIEROGLYPH F025",
    "1311A": "EGYPTIAN HIEROGLYPH F026",
    "1311B": "EGYPTIAN HIEROGLYPH F027",
    "1311C": "EGYPTIAN HIEROGLYPH F028",
    "1311D": "EGYPTIAN HIEROGLYPH F029",
    "1311E": "EGYPTIAN HIEROGLYPH F030",
    "1311F": "EGYPTIAN HIEROGLYPH F031",
    "13120": "EGYPTIAN HIEROGLYPH F031A",
    "13121": "EGYPTIAN HIEROGLYPH F032",
    "13122": "EGYPTIAN HIEROGLYPH F033",
    "13123": "EGYPTIAN HIEROGLYPH F034",
    "13124": "EGYPTIAN HIEROGLYPH F035",
    "13125": "EGYPTIAN HIEROGLYPH F036",
    "13126": "EGYPTIAN HIEROGLYPH F037",
    "13127": "EGYPTIAN HIEROGLYPH F037A",
    "13128": "EGYPTIAN HIEROGLYPH F038",
    "13129": "EGYPTIAN HIEROGLYPH F038A",
    "1312A": "EGYPTIAN HIEROGLYPH F039",
    "1312B": "EGYPTIAN HIEROGLYPH F040",
    "1312C": "EGYPTIAN HIEROGLYPH F041",
    "1312D": "EGYPTIAN HIEROGLYPH F042",
    "1312E": "EGYPTIAN HIEROGLYPH F043",
    "1312F": "EGYPTIAN HIEROGLYPH F044",
    "13130": "EGYPTIAN HIEROGLYPH F045",
    "13131": "EGYPTIAN HIEROGLYPH F045A",
    "13132": "EGYPTIAN HIEROGLYPH F046",
    "13133": "EGYPTIAN HIEROGLYPH F046A",
    "13134": "EGYPTIAN HIEROGLYPH F047",
    "13135": "EGYPTIAN HIEROGLYPH F047A",
    "13136": "EGYPTIAN HIEROGLYPH F048",
    "13137": "EGYPTIAN HIEROGLYPH F049",
    "13138": "EGYPTIAN HIEROGLYPH F050",
    "13139": "EGYPTIAN HIEROGLYPH F051",
    "1313A": "EGYPTIAN HIEROGLYPH F051A",
    "1313B": "EGYPTIAN HIEROGLYPH F051B",
    "1313C": "EGYPTIAN HIEROGLYPH F051C",
    "1313D": "EGYPTIAN HIEROGLYPH F052",
    "1313E": "EGYPTIAN HIEROGLYPH F053",
    "1313F": "EGYPTIAN HIEROGLYPH G001",
    "13140": "EGYPTIAN HIEROGLYPH G002",
    "13141": "EGYPTIAN HIEROGLYPH G003",
    "13142": "EGYPTIAN HIEROGLYPH G004",
    "13143": "EGYPTIAN HIEROGLYPH G005",
    "13144": "EGYPTIAN HIEROGLYPH G006",
    "13145": "EGYPTIAN HIEROGLYPH G006A",
    "13146": "EGYPTIAN HIEROGLYPH G007",
    "13147": "EGYPTIAN HIEROGLYPH G007A",
    "13148": "EGYPTIAN HIEROGLYPH G007B",
    "13149": "EGYPTIAN HIEROGLYPH G008",
    "1314A": "EGYPTIAN HIEROGLYPH G009",
    "1314B": "EGYPTIAN HIEROGLYPH G010",
    "1314C": "EGYPTIAN HIEROGLYPH G011",
    "1314D": "EGYPTIAN HIEROGLYPH G011A",
    "1314E": "EGYPTIAN HIEROGLYPH G012",
    "1314F": "EGYPTIAN HIEROGLYPH G013",
    "13150": "EGYPTIAN HIEROGLYPH G014",
    "13151": "EGYPTIAN HIEROGLYPH G015",
    "13152": "EGYPTIAN HIEROGLYPH G016",
    "13153": "EGYPTIAN HIEROGLYPH G017",
    "13154": "EGYPTIAN HIEROGLYPH G018",
    "13155": "EGYPTIAN HIEROGLYPH G019",
    "13156": "EGYPTIAN HIEROGLYPH G020",
    "13157": "EGYPTIAN HIEROGLYPH G020A",
    "13158": "EGYPTIAN HIEROGLYPH G021",
    "13159": "EGYPTIAN HIEROGLYPH G022",
    "1315A": "EGYPTIAN HIEROGLYPH G023",
    "1315B": "EGYPTIAN HIEROGLYPH G024",
    "1315C": "EGYPTIAN HIEROGLYPH G025",
    "1315D": "EGYPTIAN HIEROGLYPH G026",
    "1315E": "EGYPTIAN HIEROGLYPH G026A",
    "1315F": "EGYPTIAN HIEROGLYPH G027",
    "13160": "EGYPTIAN HIEROGLYPH G028",
    "13161": "EGYPTIAN HIEROGLYPH G029",
    "13162": "EGYPTIAN HIEROGLYPH G030",
    "13163": "EGYPTIAN HIEROGLYPH G031",
    "13164": "EGYPTIAN HIEROGLYPH G032",
    "13165": "EGYPTIAN HIEROGLYPH G033",
    "13166": "EGYPTIAN HIEROGLYPH G034",
    "13167": "EGYPTIAN HIEROGLYPH G035",
    "13168": "EGYPTIAN HIEROGLYPH G036",
    "13169": "EGYPTIAN HIEROGLYPH G036A",
    "1316A": "EGYPTIAN HIEROGLYPH G037",
    "1316B": "EGYPTIAN HIEROGLYPH G037A",
    "1316C": "EGYPTIAN HIEROGLYPH G038",
    "1316D": "EGYPTIAN HIEROGLYPH G039",
    "1316E": "EGYPTIAN HIEROGLYPH G040",
    "1316F": "EGYPTIAN HIEROGLYPH G041",
    "13170": "EGYPTIAN HIEROGLYPH G042",
    "13171": "EGYPTIAN HIEROGLYPH G043",
    "13172": "EGYPTIAN HIEROGLYPH G043A",
    "13173": "EGYPTIAN HIEROGLYPH G044",
    "13174": "EGYPTIAN HIEROGLYPH G045",
    "13175": "EGYPTIAN HIEROGLYPH G045A",
    "13176": "EGYPTIAN HIEROGLYPH G046",
    "13177": "EGYPTIAN HIEROGLYPH G047",
    "13178": "EGYPTIAN HIEROGLYPH G048",
    "13179": "EGYPTIAN HIEROGLYPH G049",
    "1317A": "EGYPTIAN HIEROGLYPH G050",
    "1317B": "EGYPTIAN HIEROGLYPH G051",
    "1317C": "EGYPTIAN HIEROGLYPH G052",
    "1317D": "EGYPTIAN HIEROGLYPH G053",
    "1317E": "EGYPTIAN HIEROGLYPH G054",
    "1317F": "EGYPTIAN HIEROGLYPH H001",
    "13180": "EGYPTIAN HIEROGLYPH H002",
    "13181": "EGYPTIAN HIEROGLYPH H003",
    "13182": "EGYPTIAN HIEROGLYPH H004",
    "13183": "EGYPTIAN HIEROGLYPH H005",
    "13184": "EGYPTIAN HIEROGLYPH H006",
    "13185": "EGYPTIAN HIEROGLYPH H006A",
    "13186": "EGYPTIAN HIEROGLYPH H007",
    "13187": "EGYPTIAN HIEROGLYPH H008",
    "13188": "EGYPTIAN HIEROGLYPH I001",
    "13189": "EGYPTIAN HIEROGLYPH I002",
    "1318A": "EGYPTIAN HIEROGLYPH I003",
    "1318B": "EGYPTIAN HIEROGLYPH I004",
    "1318C": "EGYPTIAN HIEROGLYPH I005",
    "1318D": "EGYPTIAN HIEROGLYPH I005A",
    "1318E": "EGYPTIAN HIEROGLYPH I006",
    "1318F": "EGYPTIAN HIEROGLYPH I007",
    "13190": "EGYPTIAN HIEROGLYPH I008",
    "13191": "EGYPTIAN HIEROGLYPH I009",
    "13192": "EGYPTIAN HIEROGLYPH I009A",
    "13193": "EGYPTIAN HIEROGLYPH I010",
    "13194": "EGYPTIAN HIEROGLYPH I010A",
    "13195": "EGYPTIAN HIEROGLYPH I011",
    "13196": "EGYPTIAN HIEROGLYPH I011A",
    "13197": "EGYPTIAN HIEROGLYPH I012",
    "13198": "EGYPTIAN HIEROGLYPH I013",
    "13199": "EGYPTIAN HIEROGLYPH I014",
    "1319A": "EGYPTIAN HIEROGLYPH I015",
    "1319B": "EGYPTIAN HIEROGLYPH K001",
    "1319C": "EGYPTIAN HIEROGLYPH K002",
    "1319D": "EGYPTIAN HIEROGLYPH K003",
    "1319E": "EGYPTIAN HIEROGLYPH K004",
    "1319F": "EGYPTIAN HIEROGLYPH K005",
    "131A0": "EGYPTIAN HIEROGLYPH K006",
    "131A1": "EGYPTIAN HIEROGLYPH K007",
    "131A2": "EGYPTIAN HIEROGLYPH K008",
    "131A3": "EGYPTIAN HIEROGLYPH L001",
    "131A4": "EGYPTIAN HIEROGLYPH L002",
    "131A5": "EGYPTIAN HIEROGLYPH L002A",
    "131A6": "EGYPTIAN HIEROGLYPH L003",
    "131A7": "EGYPTIAN HIEROGLYPH L004",
    "131A8": "EGYPTIAN HIEROGLYPH L005",
    "131A9": "EGYPTIAN HIEROGLYPH L006",
    "131AA": "EGYPTIAN HIEROGLYPH L006A",
    "131AB": "EGYPTIAN HIEROGLYPH L007",
    "131AC": "EGYPTIAN HIEROGLYPH L008",
    "131AD": "EGYPTIAN HIEROGLYPH M001",
    "131AE": "EGYPTIAN HIEROGLYPH M001A",
    "131AF": "EGYPTIAN HIEROGLYPH M001B",
    "131B0": "EGYPTIAN HIEROGLYPH M002",
    "131B1": "EGYPTIAN HIEROGLYPH M003",
    "131B2": "EGYPTIAN HIEROGLYPH M003A",
    "131B3": "EGYPTIAN HIEROGLYPH M004",
    "131B4": "EGYPTIAN HIEROGLYPH M005",
    "131B5": "EGYPTIAN HIEROGLYPH M006",
    "131B6": "EGYPTIAN HIEROGLYPH M007",
    "131B7": "EGYPTIAN HIEROGLYPH M008",
    "131B8": "EGYPTIAN HIEROGLYPH M009",
    "131B9": "EGYPTIAN HIEROGLYPH M010",
    "131BA": "EGYPTIAN HIEROGLYPH M010A",
    "131BB": "EGYPTIAN HIEROGLYPH M011",
    "131BC": "EGYPTIAN HIEROGLYPH M012",
    "131BD": "EGYPTIAN HIEROGLYPH M012A",
    "131BE": "EGYPTIAN HIEROGLYPH M012B",
    "131BF": "EGYPTIAN HIEROGLYPH M012C",
    "131C0": "EGYPTIAN HIEROGLYPH M012D",
    "131C1": "EGYPTIAN HIEROGLYPH M012E",
    "131C2": "EGYPTIAN HIEROGLYPH M012F",
    "131C3": "EGYPTIAN HIEROGLYPH M012G",
    "131C4": "EGYPTIAN HIEROGLYPH M012H",
    "131C5": "EGYPTIAN HIEROGLYPH M013",
    "131C6": "EGYPTIAN HIEROGLYPH M014",
    "131C7": "EGYPTIAN HIEROGLYPH M015",
    "131C8": "EGYPTIAN HIEROGLYPH M015A",
    "131C9": "EGYPTIAN HIEROGLYPH M016",
    "131CA": "EGYPTIAN HIEROGLYPH M016A",
    "131CB": "EGYPTIAN HIEROGLYPH M017",
    "131CC": "EGYPTIAN HIEROGLYPH M017A",
    "131CD": "EGYPTIAN HIEROGLYPH M018",
    "131CE": "EGYPTIAN HIEROGLYPH M019",
    "131CF": "EGYPTIAN HIEROGLYPH M020",
    "131D0": "EGYPTIAN HIEROGLYPH M021",
    "131D1": "EGYPTIAN HIEROGLYPH M022",
    "131D2": "EGYPTIAN HIEROGLYPH M022A",
    "131D3": "EGYPTIAN HIEROGLYPH M023",
    "131D4": "EGYPTIAN HIEROGLYPH M024",
    "131D5": "EGYPTIAN HIEROGLYPH M024A",
    "131D6": "EGYPTIAN HIEROGLYPH M025",
    "131D7": "EGYPTIAN HIEROGLYPH M026",
    "131D8": "EGYPTIAN HIEROGLYPH M027",
    "131D9": "EGYPTIAN HIEROGLYPH M028",
    "131DA": "EGYPTIAN HIEROGLYPH M028A",
    "131DB": "EGYPTIAN HIEROGLYPH M029",
    "131DC": "EGYPTIAN HIEROGLYPH M030",
    "131DD": "EGYPTIAN HIEROGLYPH M031",
    "131DE": "EGYPTIAN HIEROGLYPH M031A",
    "131DF": "EGYPTIAN HIEROGLYPH M032",
    "131E0": "EGYPTIAN HIEROGLYPH M033",
    "131E1": "EGYPTIAN HIEROGLYPH M033A",
    "131E2": "EGYPTIAN HIEROGLYPH M033B",
    "131E3": "EGYPTIAN HIEROGLYPH M034",
    "131E4": "EGYPTIAN HIEROGLYPH M035",
    "131E5": "EGYPTIAN HIEROGLYPH M036",
    "131E6": "EGYPTIAN HIEROGLYPH M037",
    "131E7": "EGYPTIAN HIEROGLYPH M038",
    "131E8": "EGYPTIAN HIEROGLYPH M039",
    "131E9": "EGYPTIAN HIEROGLYPH M040",
    "131EA": "EGYPTIAN HIEROGLYPH M040A",
    "131EB": "EGYPTIAN HIEROGLYPH M041",
    "131EC": "EGYPTIAN HIEROGLYPH M042",
    "131ED": "EGYPTIAN HIEROGLYPH M043",
    "131EE": "EGYPTIAN HIEROGLYPH M044",
    "131EF": "EGYPTIAN HIEROGLYPH N001",
    "131F0": "EGYPTIAN HIEROGLYPH N002",
    "131F1": "EGYPTIAN HIEROGLYPH N003",
    "131F2": "EGYPTIAN HIEROGLYPH N004",
    "131F3": "EGYPTIAN HIEROGLYPH N005",
    "131F4": "EGYPTIAN HIEROGLYPH N006",
    "131F5": "EGYPTIAN HIEROGLYPH N007",
    "131F6": "EGYPTIAN HIEROGLYPH N008",
    "131F7": "EGYPTIAN HIEROGLYPH N009",
    "131F8": "EGYPTIAN HIEROGLYPH N010",
    "131F9": "EGYPTIAN HIEROGLYPH N011",
    "131FA": "EGYPTIAN HIEROGLYPH N012",
    "131FB": "EGYPTIAN HIEROGLYPH N013",
    "131FC": "EGYPTIAN HIEROGLYPH N014",
    "131FD": "EGYPTIAN HIEROGLYPH N015",
    "131FE": "EGYPTIAN HIEROGLYPH N016",
    "131FF": "EGYPTIAN HIEROGLYPH N017",
    "13200": "EGYPTIAN HIEROGLYPH N018",
    "13201": "EGYPTIAN HIEROGLYPH N018A",
    "13202": "EGYPTIAN HIEROGLYPH N018B",
    "13203": "EGYPTIAN HIEROGLYPH N019",
    "13204": "EGYPTIAN HIEROGLYPH N020",
    "13205": "EGYPTIAN HIEROGLYPH N021",
    "13206": "EGYPTIAN HIEROGLYPH N022",
    "13207": "EGYPTIAN HIEROGLYPH N023",
    "13208": "EGYPTIAN HIEROGLYPH N024",
    "13209": "EGYPTIAN HIEROGLYPH N025",
    "1320A": "EGYPTIAN HIEROGLYPH N025A",
    "1320B": "EGYPTIAN HIEROGLYPH N026",
    "1320C": "EGYPTIAN HIEROGLYPH N027",
    "1320D": "EGYPTIAN HIEROGLYPH N028",
    "1320E": "EGYPTIAN HIEROGLYPH N029",
    "1320F": "EGYPTIAN HIEROGLYPH N030",
    "13210": "EGYPTIAN HIEROGLYPH N031",
    "13211": "EGYPTIAN HIEROGLYPH N032",
    "13212": "EGYPTIAN HIEROGLYPH N033",
    "13213": "EGYPTIAN HIEROGLYPH N033A",
    "13214": "EGYPTIAN HIEROGLYPH N034",
    "13215": "EGYPTIAN HIEROGLYPH N034A",
    "13216": "EGYPTIAN HIEROGLYPH N035",
    "13217": "EGYPTIAN HIEROGLYPH N035A",
    "13218": "EGYPTIAN HIEROGLYPH N036",
    "13219": "EGYPTIAN HIEROGLYPH N037",
    "1321A": "EGYPTIAN HIEROGLYPH N037A",
    "1321B": "EGYPTIAN HIEROGLYPH N038",
    "1321C": "EGYPTIAN HIEROGLYPH N039",
    "1321D": "EGYPTIAN HIEROGLYPH N040",
    "1321E": "EGYPTIAN HIEROGLYPH N041",
    "1321F": "EGYPTIAN HIEROGLYPH N042",
    "13220": "EGYPTIAN HIEROGLYPH NL001",
    "13221": "EGYPTIAN HIEROGLYPH NL002",
    "13222": "EGYPTIAN HIEROGLYPH NL003",
    "13223": "EGYPTIAN HIEROGLYPH NL004",
    "13224": "EGYPTIAN HIEROGLYPH NL005",
    "13225": "EGYPTIAN HIEROGLYPH NL005A",
    "13226": "EGYPTIAN HIEROGLYPH NL006",
    "13227": "EGYPTIAN HIEROGLYPH NL007",
    "13228": "EGYPTIAN HIEROGLYPH NL008",
    "13229": "EGYPTIAN HIEROGLYPH NL009",
    "1322A": "EGYPTIAN HIEROGLYPH NL010",
    "1322B": "EGYPTIAN HIEROGLYPH NL011",
    "1322C": "EGYPTIAN HIEROGLYPH NL012",
    "1322D": "EGYPTIAN HIEROGLYPH NL013",
    "1322E": "EGYPTIAN HIEROGLYPH NL014",
    "1322F": "EGYPTIAN HIEROGLYPH NL015",
    "13230": "EGYPTIAN HIEROGLYPH NL016",
    "13231": "EGYPTIAN HIEROGLYPH NL017",
    "13232": "EGYPTIAN HIEROGLYPH NL017A",
    "13233": "EGYPTIAN HIEROGLYPH NL018",
    "13234": "EGYPTIAN HIEROGLYPH NL019",
    "13235": "EGYPTIAN HIEROGLYPH NL020",
    "13236": "EGYPTIAN HIEROGLYPH NU001",
    "13237": "EGYPTIAN HIEROGLYPH NU002",
    "13238": "EGYPTIAN HIEROGLYPH NU003",
    "13239": "EGYPTIAN HIEROGLYPH NU004",
    "1323A": "EGYPTIAN HIEROGLYPH NU005",
    "1323B": "EGYPTIAN HIEROGLYPH NU006",
    "1323C": "EGYPTIAN HIEROGLYPH NU007",
    "1323D": "EGYPTIAN HIEROGLYPH NU008",
    "1323E": "EGYPTIAN HIEROGLYPH NU009",
    "1323F": "EGYPTIAN HIEROGLYPH NU010",
    "13240": "EGYPTIAN HIEROGLYPH NU010A",
    "13241": "EGYPTIAN HIEROGLYPH NU011",
    "13242": "EGYPTIAN HIEROGLYPH NU011A",
    "13243": "EGYPTIAN HIEROGLYPH NU012",
    "13244": "EGYPTIAN HIEROGLYPH NU013",
    "13245": "EGYPTIAN HIEROGLYPH NU014",
    "13246": "EGYPTIAN HIEROGLYPH NU015",
    "13247": "EGYPTIAN HIEROGLYPH NU016",
    "13248": "EGYPTIAN HIEROGLYPH NU017",
    "13249": "EGYPTIAN HIEROGLYPH NU018",
    "1324A": "EGYPTIAN HIEROGLYPH NU018A",
    "1324B": "EGYPTIAN HIEROGLYPH NU019",
    "1324C": "EGYPTIAN HIEROGLYPH NU020",
    "1324D": "EGYPTIAN HIEROGLYPH NU021",
    "1324E": "EGYPTIAN HIEROGLYPH NU022",
    "1324F": "EGYPTIAN HIEROGLYPH NU022A",
    "13250": "EGYPTIAN HIEROGLYPH O001",
    "13251": "EGYPTIAN HIEROGLYPH O001A",
    "13252": "EGYPTIAN HIEROGLYPH O002",
    "13253": "EGYPTIAN HIEROGLYPH O003",
    "13254": "EGYPTIAN HIEROGLYPH O004",
    "13255": "EGYPTIAN HIEROGLYPH O005",
    "13256": "EGYPTIAN HIEROGLYPH O005A",
    "13257": "EGYPTIAN HIEROGLYPH O006",
    "13258": "EGYPTIAN HIEROGLYPH O006A",
    "13259": "EGYPTIAN HIEROGLYPH O006B",
    "1325A": "EGYPTIAN HIEROGLYPH O006C",
    "1325B": "EGYPTIAN HIEROGLYPH O006D",
    "1325C": "EGYPTIAN HIEROGLYPH O006E",
    "1325D": "EGYPTIAN HIEROGLYPH O006F",
    "1325E": "EGYPTIAN HIEROGLYPH O007",
    "1325F": "EGYPTIAN HIEROGLYPH O008",
    "13260": "EGYPTIAN HIEROGLYPH O009",
    "13261": "EGYPTIAN HIEROGLYPH O010",
    "13262": "EGYPTIAN HIEROGLYPH O010A",
    "13263": "EGYPTIAN HIEROGLYPH O010B",
    "13264": "EGYPTIAN HIEROGLYPH O010C",
    "13265": "EGYPTIAN HIEROGLYPH O011",
    "13266": "EGYPTIAN HIEROGLYPH O012",
    "13267": "EGYPTIAN HIEROGLYPH O013",
    "13268": "EGYPTIAN HIEROGLYPH O014",
    "13269": "EGYPTIAN HIEROGLYPH O015",
    "1326A": "EGYPTIAN HIEROGLYPH O016",
    "1326B": "EGYPTIAN HIEROGLYPH O017",
    "1326C": "EGYPTIAN HIEROGLYPH O018",
    "1326D": "EGYPTIAN HIEROGLYPH O019",
    "1326E": "EGYPTIAN HIEROGLYPH O019A",
    "1326F": "EGYPTIAN HIEROGLYPH O020",
    "13270": "EGYPTIAN HIEROGLYPH O020A",
    "13271": "EGYPTIAN HIEROGLYPH O021",
    "13272": "EGYPTIAN HIEROGLYPH O022",
    "13273": "EGYPTIAN HIEROGLYPH O023",
    "13274": "EGYPTIAN HIEROGLYPH O024",
    "13275": "EGYPTIAN HIEROGLYPH O024A",
    "13276": "EGYPTIAN HIEROGLYPH O025",
    "13277": "EGYPTIAN HIEROGLYPH O025A",
    "13278": "EGYPTIAN HIEROGLYPH O026",
    "13279": "EGYPTIAN HIEROGLYPH O027",
    "1327A": "EGYPTIAN HIEROGLYPH O028",
    "1327B": "EGYPTIAN HIEROGLYPH O029",
    "1327C": "EGYPTIAN HIEROGLYPH O029A",
    "1327D": "EGYPTIAN HIEROGLYPH O030",
    "1327E": "EGYPTIAN HIEROGLYPH O030A",
    "1327F": "EGYPTIAN HIEROGLYPH O031",
    "13280": "EGYPTIAN HIEROGLYPH O032",
    "13281": "EGYPTIAN HIEROGLYPH O033",
    "13282": "EGYPTIAN HIEROGLYPH O033A",
    "13283": "EGYPTIAN HIEROGLYPH O034",
    "13284": "EGYPTIAN HIEROGLYPH O035",
    "13285": "EGYPTIAN HIEROGLYPH O036",
    "13286": "EGYPTIAN HIEROGLYPH O036A",
    "13287": "EGYPTIAN HIEROGLYPH O036B",
    "13288": "EGYPTIAN HIEROGLYPH O036C",
    "13289": "EGYPTIAN HIEROGLYPH O036D",
    "1328A": "EGYPTIAN HIEROGLYPH O037",
    "1328B": "EGYPTIAN HIEROGLYPH O038",
    "1328C": "EGYPTIAN HIEROGLYPH O039",
    "1328D": "EGYPTIAN HIEROGLYPH O040",
    "1328E": "EGYPTIAN HIEROGLYPH O041",
    "1328F": "EGYPTIAN HIEROGLYPH O042",
    "13290": "EGYPTIAN HIEROGLYPH O043",
    "13291": "EGYPTIAN HIEROGLYPH O044",
    "13292": "EGYPTIAN HIEROGLYPH O045",
    "13293": "EGYPTIAN HIEROGLYPH O046",
    "13294": "EGYPTIAN HIEROGLYPH O047",
    "13295": "EGYPTIAN HIEROGLYPH O048",
    "13296": "EGYPTIAN HIEROGLYPH O049",
    "13297": "EGYPTIAN HIEROGLYPH O050",
    "13298": "EGYPTIAN HIEROGLYPH O050A",
    "13299": "EGYPTIAN HIEROGLYPH O050B",
    "1329A": "EGYPTIAN HIEROGLYPH O051",
    "1329B": "EGYPTIAN HIEROGLYPH P001",
    "1329C": "EGYPTIAN HIEROGLYPH P001A",
    "1329D": "EGYPTIAN HIEROGLYPH P002",
    "1329E": "EGYPTIAN HIEROGLYPH P003",
    "1329F": "EGYPTIAN HIEROGLYPH P003A",
    "132A0": "EGYPTIAN HIEROGLYPH P004",
    "132A1": "EGYPTIAN HIEROGLYPH P005",
    "132A2": "EGYPTIAN HIEROGLYPH P006",
    "132A3": "EGYPTIAN HIEROGLYPH P007",
    "132A4": "EGYPTIAN HIEROGLYPH P008",
    "132A5": "EGYPTIAN HIEROGLYPH P009",
    "132A6": "EGYPTIAN HIEROGLYPH P010",
    "132A7": "EGYPTIAN HIEROGLYPH P011",
    "132A8": "EGYPTIAN HIEROGLYPH Q001",
    "132A9": "EGYPTIAN HIEROGLYPH Q002",
    "132AA": "EGYPTIAN HIEROGLYPH Q003",
    "132AB": "EGYPTIAN HIEROGLYPH Q004",
    "132AC": "EGYPTIAN HIEROGLYPH Q005",
    "132AD": "EGYPTIAN HIEROGLYPH Q006",
    "132AE": "EGYPTIAN HIEROGLYPH Q007",
    "132AF": "EGYPTIAN HIEROGLYPH R001",
    "132B0": "EGYPTIAN HIEROGLYPH R002",
    "132B1": "EGYPTIAN HIEROGLYPH R002A",
    "132B2": "EGYPTIAN HIEROGLYPH R003",
    "132B3": "EGYPTIAN HIEROGLYPH R003A",
    "132B4": "EGYPTIAN HIEROGLYPH R003B",
    "132B5": "EGYPTIAN HIEROGLYPH R004",
    "132B6": "EGYPTIAN HIEROGLYPH R005",
    "132B7": "EGYPTIAN HIEROGLYPH R006",
    "132B8": "EGYPTIAN HIEROGLYPH R007",
    "132B9": "EGYPTIAN HIEROGLYPH R008",
    "132BA": "EGYPTIAN HIEROGLYPH R009",
    "132BB": "EGYPTIAN HIEROGLYPH R010",
    "132BC": "EGYPTIAN HIEROGLYPH R010A",
    "132BD": "EGYPTIAN HIEROGLYPH R011",
    "132BE": "EGYPTIAN HIEROGLYPH R012",
    "132BF": "EGYPTIAN HIEROGLYPH R013",
    "132C0": "EGYPTIAN HIEROGLYPH R014",
    "132C1": "EGYPTIAN HIEROGLYPH R015",
    "132C2": "EGYPTIAN HIEROGLYPH R016",
    "132C3": "EGYPTIAN HIEROGLYPH R016A",
    "132C4": "EGYPTIAN HIEROGLYPH R017",
    "132C5": "EGYPTIAN HIEROGLYPH R018",
    "132C6": "EGYPTIAN HIEROGLYPH R019",
    "132C7": "EGYPTIAN HIEROGLYPH R020",
    "132C8": "EGYPTIAN HIEROGLYPH R021",
    "132C9": "EGYPTIAN HIEROGLYPH R022",
    "132CA": "EGYPTIAN HIEROGLYPH R023",
    "132CB": "EGYPTIAN HIEROGLYPH R024",
    "132CC": "EGYPTIAN HIEROGLYPH R025",
    "132CD": "EGYPTIAN HIEROGLYPH R026",
    "132CE": "EGYPTIAN HIEROGLYPH R027",
    "132CF": "EGYPTIAN HIEROGLYPH R028",
    "132D0": "EGYPTIAN HIEROGLYPH R029",
    "132D1": "EGYPTIAN HIEROGLYPH S001",
    "132D2": "EGYPTIAN HIEROGLYPH S002",
    "132D3": "EGYPTIAN HIEROGLYPH S002A",
    "132D4": "EGYPTIAN HIEROGLYPH S003",
    "132D5": "EGYPTIAN HIEROGLYPH S004",
    "132D6": "EGYPTIAN HIEROGLYPH S005",
    "132D7": "EGYPTIAN HIEROGLYPH S006",
    "132D8": "EGYPTIAN HIEROGLYPH S006A",
    "132D9": "EGYPTIAN HIEROGLYPH S007",
    "132DA": "EGYPTIAN HIEROGLYPH S008",
    "132DB": "EGYPTIAN HIEROGLYPH S009",
    "132DC": "EGYPTIAN HIEROGLYPH S010",
    "132DD": "EGYPTIAN HIEROGLYPH S011",
    "132DE": "EGYPTIAN HIEROGLYPH S012",
    "132DF": "EGYPTIAN HIEROGLYPH S013",
    "132E0": "EGYPTIAN HIEROGLYPH S014",
    "132E1": "EGYPTIAN HIEROGLYPH S014A",
    "132E2": "EGYPTIAN HIEROGLYPH S014B",
    "132E3": "EGYPTIAN HIEROGLYPH S015",
    "132E4": "EGYPTIAN HIEROGLYPH S016",
    "132E5": "EGYPTIAN HIEROGLYPH S017",
    "132E6": "EGYPTIAN HIEROGLYPH S017A",
    "132E7": "EGYPTIAN HIEROGLYPH S018",
    "132E8": "EGYPTIAN HIEROGLYPH S019",
    "132E9": "EGYPTIAN HIEROGLYPH S020",
    "132EA": "EGYPTIAN HIEROGLYPH S021",
    "132EB": "EGYPTIAN HIEROGLYPH S022",
    "132EC": "EGYPTIAN HIEROGLYPH S023",
    "132ED": "EGYPTIAN HIEROGLYPH S024",
    "132EE": "EGYPTIAN HIEROGLYPH S025",
    "132EF": "EGYPTIAN HIEROGLYPH S026",
    "132F0": "EGYPTIAN HIEROGLYPH S026A",
    "132F1": "EGYPTIAN HIEROGLYPH S026B",
    "132F2": "EGYPTIAN HIEROGLYPH S027",
    "132F3": "EGYPTIAN HIEROGLYPH S028",
    "132F4": "EGYPTIAN HIEROGLYPH S029",
    "132F5": "EGYPTIAN HIEROGLYPH S030",
    "132F6": "EGYPTIAN HIEROGLYPH S031",
    "132F7": "EGYPTIAN HIEROGLYPH S032",
    "132F8": "EGYPTIAN HIEROGLYPH S033",
    "132F9": "EGYPTIAN HIEROGLYPH S034",
    "132FA": "EGYPTIAN HIEROGLYPH S035",
    "132FB": "EGYPTIAN HIEROGLYPH S035A",
    "132FC": "EGYPTIAN HIEROGLYPH S036",
    "132FD": "EGYPTIAN HIEROGLYPH S037",
    "132FE": "EGYPTIAN HIEROGLYPH S038",
    "132FF": "EGYPTIAN HIEROGLYPH S039",
    "13300": "EGYPTIAN HIEROGLYPH S040",
    "13301": "EGYPTIAN HIEROGLYPH S041",
    "13302": "EGYPTIAN HIEROGLYPH S042",
    "13303": "EGYPTIAN HIEROGLYPH S043",
    "13304": "EGYPTIAN HIEROGLYPH S044",
    "13305": "EGYPTIAN HIEROGLYPH S045",
    "13306": "EGYPTIAN HIEROGLYPH S046",
    "13307": "EGYPTIAN HIEROGLYPH T001",
    "13308": "EGYPTIAN HIEROGLYPH T002",
    "13309": "EGYPTIAN HIEROGLYPH T003",
    "1330A": "EGYPTIAN HIEROGLYPH T003A",
    "1330B": "EGYPTIAN HIEROGLYPH T004",
    "1330C": "EGYPTIAN HIEROGLYPH T005",
    "1330D": "EGYPTIAN HIEROGLYPH T006",
    "1330E": "EGYPTIAN HIEROGLYPH T007",
    "1330F": "EGYPTIAN HIEROGLYPH T007A",
    "13310": "EGYPTIAN HIEROGLYPH T008",
    "13311": "EGYPTIAN HIEROGLYPH T008A",
    "13312": "EGYPTIAN HIEROGLYPH T009",
    "13313": "EGYPTIAN HIEROGLYPH T009A",
    "13314": "EGYPTIAN HIEROGLYPH T010",
    "13315": "EGYPTIAN HIEROGLYPH T011",
    "13316": "EGYPTIAN HIEROGLYPH T011A",
    "13317": "EGYPTIAN HIEROGLYPH T012",
    "13318": "EGYPTIAN HIEROGLYPH T013",
    "13319": "EGYPTIAN HIEROGLYPH T014",
    "1331A": "EGYPTIAN HIEROGLYPH T015",
    "1331B": "EGYPTIAN HIEROGLYPH T016",
    "1331C": "EGYPTIAN HIEROGLYPH T016A",
    "1331D": "EGYPTIAN HIEROGLYPH T017",
    "1331E": "EGYPTIAN HIEROGLYPH T018",
    "1331F": "EGYPTIAN HIEROGLYPH T019",
    "13320": "EGYPTIAN HIEROGLYPH T020",
    "13321": "EGYPTIAN HIEROGLYPH T021",
    "13322": "EGYPTIAN HIEROGLYPH T022",
    "13323": "EGYPTIAN HIEROGLYPH T023",
    "13324": "EGYPTIAN HIEROGLYPH T024",
    "13325": "EGYPTIAN HIEROGLYPH T025",
    "13326": "EGYPTIAN HIEROGLYPH T026",
    "13327": "EGYPTIAN HIEROGLYPH T027",
    "13328": "EGYPTIAN HIEROGLYPH T028",
    "13329": "EGYPTIAN HIEROGLYPH T029",
    "1332A": "EGYPTIAN HIEROGLYPH T030",
    "1332B": "EGYPTIAN HIEROGLYPH T031",
    "1332C": "EGYPTIAN HIEROGLYPH T032",
    "1332D": "EGYPTIAN HIEROGLYPH T032A",
    "1332E": "EGYPTIAN HIEROGLYPH T033",
    "1332F": "EGYPTIAN HIEROGLYPH T033A",
    "13330": "EGYPTIAN HIEROGLYPH T034",
    "13331": "EGYPTIAN HIEROGLYPH T035",
    "13332": "EGYPTIAN HIEROGLYPH T036",
    "13333": "EGYPTIAN HIEROGLYPH U001",
    "13334": "EGYPTIAN HIEROGLYPH U002",
    "13335": "EGYPTIAN HIEROGLYPH U003",
    "13336": "EGYPTIAN HIEROGLYPH U004",
    "13337": "EGYPTIAN HIEROGLYPH U005",
    "13338": "EGYPTIAN HIEROGLYPH U006",
    "13339": "EGYPTIAN HIEROGLYPH U006A",
    "1333A": "EGYPTIAN HIEROGLYPH U006B",
    "1333B": "EGYPTIAN HIEROGLYPH U007",
    "1333C": "EGYPTIAN HIEROGLYPH U008",
    "1333D": "EGYPTIAN HIEROGLYPH U009",
    "1333E": "EGYPTIAN HIEROGLYPH U010",
    "1333F": "EGYPTIAN HIEROGLYPH U011",
    "13340": "EGYPTIAN HIEROGLYPH U012",
    "13341": "EGYPTIAN HIEROGLYPH U013",
    "13342": "EGYPTIAN HIEROGLYPH U014",
    "13343": "EGYPTIAN HIEROGLYPH U015",
    "13344": "EGYPTIAN HIEROGLYPH U016",
    "13345": "EGYPTIAN HIEROGLYPH U017",
    "13346": "EGYPTIAN HIEROGLYPH U018",
    "13347": "EGYPTIAN HIEROGLYPH U019",
    "13348": "EGYPTIAN HIEROGLYPH U020",
    "13349": "EGYPTIAN HIEROGLYPH U021",
    "1334A": "EGYPTIAN HIEROGLYPH U022",
    "1334B": "EGYPTIAN HIEROGLYPH U023",
    "1334C": "EGYPTIAN HIEROGLYPH U023A",
    "1334D": "EGYPTIAN HIEROGLYPH U024",
    "1334E": "EGYPTIAN HIEROGLYPH U025",
    "1334F": "EGYPTIAN HIEROGLYPH U026",
    "13350": "EGYPTIAN HIEROGLYPH U027",
    "13351": "EGYPTIAN HIEROGLYPH U028",
    "13352": "EGYPTIAN HIEROGLYPH U029",
    "13353": "EGYPTIAN HIEROGLYPH U029A",
    "13354": "EGYPTIAN HIEROGLYPH U030",
    "13355": "EGYPTIAN HIEROGLYPH U031",
    "13356": "EGYPTIAN HIEROGLYPH U032",
    "13357": "EGYPTIAN HIEROGLYPH U032A",
    "13358": "EGYPTIAN HIEROGLYPH U033",
    "13359": "EGYPTIAN HIEROGLYPH U034",
    "1335A": "EGYPTIAN HIEROGLYPH U035",
    "1335B": "EGYPTIAN HIEROGLYPH U036",
    "1335C": "EGYPTIAN HIEROGLYPH U037",
    "1335D": "EGYPTIAN HIEROGLYPH U038",
    "1335E": "EGYPTIAN HIEROGLYPH U039",
    "1335F": "EGYPTIAN HIEROGLYPH U040",
    "13360": "EGYPTIAN HIEROGLYPH U041",
    "13361": "EGYPTIAN HIEROGLYPH U042",
    "13362": "EGYPTIAN HIEROGLYPH V001",
    "13363": "EGYPTIAN HIEROGLYPH V001A",
    "13364": "EGYPTIAN HIEROGLYPH V001B",
    "13365": "EGYPTIAN HIEROGLYPH V001C",
    "13366": "EGYPTIAN HIEROGLYPH V001D",
    "13367": "EGYPTIAN HIEROGLYPH V001E",
    "13368": "EGYPTIAN HIEROGLYPH V001F",
    "13369": "EGYPTIAN HIEROGLYPH V001G",
    "1336A": "EGYPTIAN HIEROGLYPH V001H",
    "1336B": "EGYPTIAN HIEROGLYPH V001I",
    "1336C": "EGYPTIAN HIEROGLYPH V002",
    "1336D": "EGYPTIAN HIEROGLYPH V002A",
    "1336E": "EGYPTIAN HIEROGLYPH V003",
    "1336F": "EGYPTIAN HIEROGLYPH V004",
    "13370": "EGYPTIAN HIEROGLYPH V005",
    "13371": "EGYPTIAN HIEROGLYPH V006",
    "13372": "EGYPTIAN HIEROGLYPH V007",
    "13373": "EGYPTIAN HIEROGLYPH V007A",
    "13374": "EGYPTIAN HIEROGLYPH V007B",
    "13375": "EGYPTIAN HIEROGLYPH V008",
    "13376": "EGYPTIAN HIEROGLYPH V009",
    "13377": "EGYPTIAN HIEROGLYPH V010",
    "13378": "EGYPTIAN HIEROGLYPH V011",
    "13379": "EGYPTIAN HIEROGLYPH V011A",
    "1337A": "EGYPTIAN HIEROGLYPH V011B",
    "1337B": "EGYPTIAN HIEROGLYPH V011C",
    "1337C": "EGYPTIAN HIEROGLYPH V012",
    "1337D": "EGYPTIAN HIEROGLYPH V012A",
    "1337E": "EGYPTIAN HIEROGLYPH V012B",
    "1337F": "EGYPTIAN HIEROGLYPH V013",
    "13380": "EGYPTIAN HIEROGLYPH V014",
    "13381": "EGYPTIAN HIEROGLYPH V015",
    "13382": "EGYPTIAN HIEROGLYPH V016",
    "13383": "EGYPTIAN HIEROGLYPH V017",
    "13384": "EGYPTIAN HIEROGLYPH V018",
    "13385": "EGYPTIAN HIEROGLYPH V019",
    "13386": "EGYPTIAN HIEROGLYPH V020",
    "13387": "EGYPTIAN HIEROGLYPH V020A",
    "13388": "EGYPTIAN HIEROGLYPH V020B",
    "13389": "EGYPTIAN HIEROGLYPH V020C",
    "1338A": "EGYPTIAN HIEROGLYPH V020D",
    "1338B": "EGYPTIAN HIEROGLYPH V020E",
    "1338C": "EGYPTIAN HIEROGLYPH V020F",
    "1338D": "EGYPTIAN HIEROGLYPH V020G",
    "1338E": "EGYPTIAN HIEROGLYPH V020H",
    "1338F": "EGYPTIAN HIEROGLYPH V020I",
    "13390": "EGYPTIAN HIEROGLYPH V020J",
    "13391": "EGYPTIAN HIEROGLYPH V020K",
    "13392": "EGYPTIAN HIEROGLYPH V020L",
    "13393": "EGYPTIAN HIEROGLYPH V021",
    "13394": "EGYPTIAN HIEROGLYPH V022",
    "13395": "EGYPTIAN HIEROGLYPH V023",
    "13396": "EGYPTIAN HIEROGLYPH V023A",
    "13397": "EGYPTIAN HIEROGLYPH V024",
    "13398": "EGYPTIAN HIEROGLYPH V025",
    "13399": "EGYPTIAN HIEROGLYPH V026",
    "1339A": "EGYPTIAN HIEROGLYPH V027",
    "1339B": "EGYPTIAN HIEROGLYPH V028",
    "1339C": "EGYPTIAN HIEROGLYPH V028A",
    "1339D": "EGYPTIAN HIEROGLYPH V029",
    "1339E": "EGYPTIAN HIEROGLYPH V029A",
    "1339F": "EGYPTIAN HIEROGLYPH V030",
    "133A0": "EGYPTIAN HIEROGLYPH V030A",
    "133A1": "EGYPTIAN HIEROGLYPH V031",
    "133A2": "EGYPTIAN HIEROGLYPH V031A",
    "133A3": "EGYPTIAN HIEROGLYPH V032",
    "133A4": "EGYPTIAN HIEROGLYPH V033",
    "133A5": "EGYPTIAN HIEROGLYPH V033A",
    "133A6": "EGYPTIAN HIEROGLYPH V034",
    "133A7": "EGYPTIAN HIEROGLYPH V035",
    "133A8": "EGYPTIAN HIEROGLYPH V036",
    "133A9": "EGYPTIAN HIEROGLYPH V037",
    "133AA": "EGYPTIAN HIEROGLYPH V037A",
    "133AB": "EGYPTIAN HIEROGLYPH V038",
    "133AC": "EGYPTIAN HIEROGLYPH V039",
    "133AD": "EGYPTIAN HIEROGLYPH V040",
    "133AE": "EGYPTIAN HIEROGLYPH V040A",
    "133AF": "EGYPTIAN HIEROGLYPH W001",
    "133B0": "EGYPTIAN HIEROGLYPH W002",
    "133B1": "EGYPTIAN HIEROGLYPH W003",
    "133B2": "EGYPTIAN HIEROGLYPH W003A",
    "133B3": "EGYPTIAN HIEROGLYPH W004",
    "133B4": "EGYPTIAN HIEROGLYPH W005",
    "133B5": "EGYPTIAN HIEROGLYPH W006",
    "133B6": "EGYPTIAN HIEROGLYPH W007",
    "133B7": "EGYPTIAN HIEROGLYPH W008",
    "133B8": "EGYPTIAN HIEROGLYPH W009",
    "133B9": "EGYPTIAN HIEROGLYPH W009A",
    "133BA": "EGYPTIAN HIEROGLYPH W010",
    "133BB": "EGYPTIAN HIEROGLYPH W010A",
    "133BC": "EGYPTIAN HIEROGLYPH W011",
    "133BD": "EGYPTIAN HIEROGLYPH W012",
    "133BE": "EGYPTIAN HIEROGLYPH W013",
    "133BF": "EGYPTIAN HIEROGLYPH W014",
    "133C0": "EGYPTIAN HIEROGLYPH W014A",
    "133C1": "EGYPTIAN HIEROGLYPH W015",
    "133C2": "EGYPTIAN HIEROGLYPH W016",
    "133C3": "EGYPTIAN HIEROGLYPH W017",
    "133C4": "EGYPTIAN HIEROGLYPH W017A",
    "133C5": "EGYPTIAN HIEROGLYPH W018",
    "133C6": "EGYPTIAN HIEROGLYPH W018A",
    "133C7": "EGYPTIAN HIEROGLYPH W019",
    "133C8": "EGYPTIAN HIEROGLYPH W020",
    "133C9": "EGYPTIAN HIEROGLYPH W021",
    "133CA": "EGYPTIAN HIEROGLYPH W022",
    "133CB": "EGYPTIAN HIEROGLYPH W023",
    "133CC": "EGYPTIAN HIEROGLYPH W024",
    "133CD": "EGYPTIAN HIEROGLYPH W024A",
    "133CE": "EGYPTIAN HIEROGLYPH W025",
    "133CF": "EGYPTIAN HIEROGLYPH X001",
    "133D0": "EGYPTIAN HIEROGLYPH X002",
    "133D1": "EGYPTIAN HIEROGLYPH X003",
    "133D2": "EGYPTIAN HIEROGLYPH X004",
    "133D3": "EGYPTIAN HIEROGLYPH X004A",
    "133D4": "EGYPTIAN HIEROGLYPH X004B",
    "133D5": "EGYPTIAN HIEROGLYPH X005",
    "133D6": "EGYPTIAN HIEROGLYPH X006",
    "133D7": "EGYPTIAN HIEROGLYPH X006A",
    "133D8": "EGYPTIAN HIEROGLYPH X007",
    "133D9": "EGYPTIAN HIEROGLYPH X008",
    "133DA": "EGYPTIAN HIEROGLYPH X008A",
    "133DB": "EGYPTIAN HIEROGLYPH Y001",
    "133DC": "EGYPTIAN HIEROGLYPH Y001A",
    "133DD": "EGYPTIAN HIEROGLYPH Y002",
    "133DE": "EGYPTIAN HIEROGLYPH Y003",
    "133DF": "EGYPTIAN HIEROGLYPH Y004",
    "133E0": "EGYPTIAN HIEROGLYPH Y005",
    "133E1": "EGYPTIAN HIEROGLYPH Y006",
    "133E2": "EGYPTIAN HIEROGLYPH Y007",
    "133E3": "EGYPTIAN HIEROGLYPH Y008",
    "133E4": "EGYPTIAN HIEROGLYPH Z001",
    "133E5": "EGYPTIAN HIEROGLYPH Z002",
    "133E6": "EGYPTIAN HIEROGLYPH Z002A",
    "133E7": "EGYPTIAN HIEROGLYPH Z002B",
    "133E8": "EGYPTIAN HIEROGLYPH Z002C",
    "133E9": "EGYPTIAN HIEROGLYPH Z002D",
    "133EA": "EGYPTIAN HIEROGLYPH Z003",
    "133EB": "EGYPTIAN HIEROGLYPH Z003A",
    "133EC": "EGYPTIAN HIEROGLYPH Z003B",
    "133ED": "EGYPTIAN HIEROGLYPH Z004",
    "133EE": "EGYPTIAN HIEROGLYPH Z004A",
    "133EF": "EGYPTIAN HIEROGLYPH Z005",
    "133F0": "EGYPTIAN HIEROGLYPH Z005A",
    "133F1": "EGYPTIAN HIEROGLYPH Z006",
    "133F2": "EGYPTIAN HIEROGLYPH Z007",
    "133F3": "EGYPTIAN HIEROGLYPH Z008",
    "133F4": "EGYPTIAN HIEROGLYPH Z009",
    "133F5": "EGYPTIAN HIEROGLYPH Z010",
    "133F6": "EGYPTIAN HIEROGLYPH Z011",
    "133F7": "EGYPTIAN HIEROGLYPH Z012",
    "133F8": "EGYPTIAN HIEROGLYPH Z013",
    "133F9": "EGYPTIAN HIEROGLYPH Z014",
    "133FA": "EGYPTIAN HIEROGLYPH Z015",
    "133FB": "EGYPTIAN HIEROGLYPH Z015A",
    "133FC": "EGYPTIAN HIEROGLYPH Z015B",
    "133FD": "EGYPTIAN HIEROGLYPH Z015C",
    "133FE": "EGYPTIAN HIEROGLYPH Z015D",
    "133FF": "EGYPTIAN HIEROGLYPH Z015E",
    "13400": "EGYPTIAN HIEROGLYPH Z015F",
    "13401": "EGYPTIAN HIEROGLYPH Z015G",
    "13402": "EGYPTIAN HIEROGLYPH Z015H",
    "13403": "EGYPTIAN HIEROGLYPH Z015I",
    "13404": "EGYPTIAN HIEROGLYPH Z016",
    "13405": "EGYPTIAN HIEROGLYPH Z016A",
    "13406": "EGYPTIAN HIEROGLYPH Z016B",
    "13407": "EGYPTIAN HIEROGLYPH Z016C",
    "13408": "EGYPTIAN HIEROGLYPH Z016D",
    "13409": "EGYPTIAN HIEROGLYPH Z016E",
    "1340A": "EGYPTIAN HIEROGLYPH Z016F",
    "1340B": "EGYPTIAN HIEROGLYPH Z016G",
    "1340C": "EGYPTIAN HIEROGLYPH Z016H",
    "1340D": "EGYPTIAN HIEROGLYPH AA001",
    "1340E": "EGYPTIAN HIEROGLYPH AA002",
    "1340F": "EGYPTIAN HIEROGLYPH AA003",
    "13410": "EGYPTIAN HIEROGLYPH AA004",
    "13411": "EGYPTIAN HIEROGLYPH AA005",
    "13412": "EGYPTIAN HIEROGLYPH AA006",
    "13413": "EGYPTIAN HIEROGLYPH AA007",
    "13414": "EGYPTIAN HIEROGLYPH AA007A",
    "13415": "EGYPTIAN HIEROGLYPH AA007B",
    "13416": "EGYPTIAN HIEROGLYPH AA008",
    "13417": "EGYPTIAN HIEROGLYPH AA009",
    "13418": "EGYPTIAN HIEROGLYPH AA010",
    "13419": "EGYPTIAN HIEROGLYPH AA011",
    "1341A": "EGYPTIAN HIEROGLYPH AA012",
    "1341B": "EGYPTIAN HIEROGLYPH AA013",
    "1341C": "EGYPTIAN HIEROGLYPH AA014",
    "1341D": "EGYPTIAN HIEROGLYPH AA015",
    "1341E": "EGYPTIAN HIEROGLYPH AA016",
    "1341F": "EGYPTIAN HIEROGLYPH AA017",
    "13420": "EGYPTIAN HIEROGLYPH AA018",
    "13421": "EGYPTIAN HIEROGLYPH AA019",
    "13422": "EGYPTIAN HIEROGLYPH AA020",
    "13423": "EGYPTIAN HIEROGLYPH AA021",
    "13424": "EGYPTIAN HIEROGLYPH AA022",
    "13425": "EGYPTIAN HIEROGLYPH AA023",
    "13426": "EGYPTIAN HIEROGLYPH AA024",
    "13427": "EGYPTIAN HIEROGLYPH AA025",
    "13428": "EGYPTIAN HIEROGLYPH AA026",
    "13429": "EGYPTIAN HIEROGLYPH AA027",
    "1342A": "EGYPTIAN HIEROGLYPH AA028",
    "1342B": "EGYPTIAN HIEROGLYPH AA029",
    "1342C": "EGYPTIAN HIEROGLYPH AA030",
    "1342D": "EGYPTIAN HIEROGLYPH AA031",
    "1342E": "EGYPTIAN HIEROGLYPH AA032",
    "14400": "ANATOLIAN HIEROGLYPH A001",
    "14401": "ANATOLIAN HIEROGLYPH A002",
    "14402": "ANATOLIAN HIEROGLYPH A003",
    "14403": "ANATOLIAN HIEROGLYPH A004",
    "14404": "ANATOLIAN HIEROGLYPH A005",
    "14405": "ANATOLIAN HIEROGLYPH A006",
    "14406": "ANATOLIAN HIEROGLYPH A007",
    "14407": "ANATOLIAN HIEROGLYPH A008",
    "14408": "ANATOLIAN HIEROGLYPH A009",
    "14409": "ANATOLIAN HIEROGLYPH A010",
    "1440A": "ANATOLIAN HIEROGLYPH A010A",
    "1440B": "ANATOLIAN HIEROGLYPH A011",
    "1440C": "ANATOLIAN HIEROGLYPH A012",
    "1440D": "ANATOLIAN HIEROGLYPH A013",
    "1440E": "ANATOLIAN HIEROGLYPH A014",
    "1440F": "ANATOLIAN HIEROGLYPH A015",
    "14410": "ANATOLIAN HIEROGLYPH A016",
    "14411": "ANATOLIAN HIEROGLYPH A017",
    "14412": "ANATOLIAN HIEROGLYPH A018",
    "14413": "ANATOLIAN HIEROGLYPH A019",
    "14414": "ANATOLIAN HIEROGLYPH A020",
    "14415": "ANATOLIAN HIEROGLYPH A021",
    "14416": "ANATOLIAN HIEROGLYPH A022",
    "14417": "ANATOLIAN HIEROGLYPH A023",
    "14418": "ANATOLIAN HIEROGLYPH A024",
    "14419": "ANATOLIAN HIEROGLYPH A025",
    "1441A": "ANATOLIAN HIEROGLYPH A026",
    "1441B": "ANATOLIAN HIEROGLYPH A026A",
    "1441C": "ANATOLIAN HIEROGLYPH A027",
    "1441D": "ANATOLIAN HIEROGLYPH A028",
    "1441E": "ANATOLIAN HIEROGLYPH A029",
    "1441F": "ANATOLIAN HIEROGLYPH A030",
    "14420": "ANATOLIAN HIEROGLYPH A031",
    "14421": "ANATOLIAN HIEROGLYPH A032",
    "14422": "ANATOLIAN HIEROGLYPH A033",
    "14423": "ANATOLIAN HIEROGLYPH A034",
    "14424": "ANATOLIAN HIEROGLYPH A035",
    "14425": "ANATOLIAN HIEROGLYPH A036",
    "14426": "ANATOLIAN HIEROGLYPH A037",
    "14427": "ANATOLIAN HIEROGLYPH A038",
    "14428": "ANATOLIAN HIEROGLYPH A039",
    "14429": "ANATOLIAN HIEROGLYPH A039A",
    "1442A": "ANATOLIAN HIEROGLYPH A040",
    "1442B": "ANATOLIAN HIEROGLYPH A041",
    "1442C": "ANATOLIAN HIEROGLYPH A041A",
    "1442D": "ANATOLIAN HIEROGLYPH A042",
    "1442E": "ANATOLIAN HIEROGLYPH A043",
    "1442F": "ANATOLIAN HIEROGLYPH A044",
    "14430": "ANATOLIAN HIEROGLYPH A045",
    "14431": "ANATOLIAN HIEROGLYPH A045A",
    "14432": "ANATOLIAN HIEROGLYPH A046",
    "14433": "ANATOLIAN HIEROGLYPH A046A",
    "14434": "ANATOLIAN HIEROGLYPH A046B",
    "14435": "ANATOLIAN HIEROGLYPH A047",
    "14436": "ANATOLIAN HIEROGLYPH A048",
    "14437": "ANATOLIAN HIEROGLYPH A049",
    "14438": "ANATOLIAN HIEROGLYPH A050",
    "14439": "ANATOLIAN HIEROGLYPH A051",
    "1443A": "ANATOLIAN HIEROGLYPH A052",
    "1443B": "ANATOLIAN HIEROGLYPH A053",
    "1443C": "ANATOLIAN HIEROGLYPH A054",
    "1443D": "ANATOLIAN HIEROGLYPH A055",
    "1443E": "ANATOLIAN HIEROGLYPH A056",
    "1443F": "ANATOLIAN HIEROGLYPH A057",
    "14440": "ANATOLIAN HIEROGLYPH A058",
    "14441": "ANATOLIAN HIEROGLYPH A059",
    "14442": "ANATOLIAN HIEROGLYPH A060",
    "14443": "ANATOLIAN HIEROGLYPH A061",
    "14444": "ANATOLIAN HIEROGLYPH A062",
    "14445": "ANATOLIAN HIEROGLYPH A063",
    "14446": "ANATOLIAN HIEROGLYPH A064",
    "14447": "ANATOLIAN HIEROGLYPH A065",
    "14448": "ANATOLIAN HIEROGLYPH A066",
    "14449": "ANATOLIAN HIEROGLYPH A066A",
    "1444A": "ANATOLIAN HIEROGLYPH A066B",
    "1444B": "ANATOLIAN HIEROGLYPH A066C",
    "1444C": "ANATOLIAN HIEROGLYPH A067",
    "1444D": "ANATOLIAN HIEROGLYPH A068",
    "1444E": "ANATOLIAN HIEROGLYPH A069",
    "1444F": "ANATOLIAN HIEROGLYPH A070",
    "14450": "ANATOLIAN HIEROGLYPH A071",
    "14451": "ANATOLIAN HIEROGLYPH A072",
    "14452": "ANATOLIAN HIEROGLYPH A073",
    "14453": "ANATOLIAN HIEROGLYPH A074",
    "14454": "ANATOLIAN HIEROGLYPH A075",
    "14455": "ANATOLIAN HIEROGLYPH A076",
    "14456": "ANATOLIAN HIEROGLYPH A077",
    "14457": "ANATOLIAN HIEROGLYPH A078",
    "14458": "ANATOLIAN HIEROGLYPH A079",
    "14459": "ANATOLIAN HIEROGLYPH A080",
    "1445A": "ANATOLIAN HIEROGLYPH A081",
    "1445B": "ANATOLIAN HIEROGLYPH A082",
    "1445C": "ANATOLIAN HIEROGLYPH A083",
    "1445D": "ANATOLIAN HIEROGLYPH A084",
    "1445E": "ANATOLIAN HIEROGLYPH A085",
    "1445F": "ANATOLIAN HIEROGLYPH A086",
    "14460": "ANATOLIAN HIEROGLYPH A087",
    "14461": "ANATOLIAN HIEROGLYPH A088",
    "14462": "ANATOLIAN HIEROGLYPH A089",
    "14463": "ANATOLIAN HIEROGLYPH A090",
    "14464": "ANATOLIAN HIEROGLYPH A091",
    "14465": "ANATOLIAN HIEROGLYPH A092",
    "14466": "ANATOLIAN HIEROGLYPH A093",
    "14467": "ANATOLIAN HIEROGLYPH A094",
    "14468": "ANATOLIAN HIEROGLYPH A095",
    "14469": "ANATOLIAN HIEROGLYPH A096",
    "1446A": "ANATOLIAN HIEROGLYPH A097",
    "1446B": "ANATOLIAN HIEROGLYPH A097A",
    "1446C": "ANATOLIAN HIEROGLYPH A098",
    "1446D": "ANATOLIAN HIEROGLYPH A098A",
    "1446E": "ANATOLIAN HIEROGLYPH A099",
    "1446F": "ANATOLIAN HIEROGLYPH A100",
    "14470": "ANATOLIAN HIEROGLYPH A100A",
    "14471": "ANATOLIAN HIEROGLYPH A101",
    "14472": "ANATOLIAN HIEROGLYPH A101A",
    "14473": "ANATOLIAN HIEROGLYPH A102",
    "14474": "ANATOLIAN HIEROGLYPH A102A",
    "14475": "ANATOLIAN HIEROGLYPH A103",
    "14476": "ANATOLIAN HIEROGLYPH A104",
    "14477": "ANATOLIAN HIEROGLYPH A104A",
    "14478": "ANATOLIAN HIEROGLYPH A104B",
    "14479": "ANATOLIAN HIEROGLYPH A104C",
    "1447A": "ANATOLIAN HIEROGLYPH A105",
    "1447B": "ANATOLIAN HIEROGLYPH A105A",
    "1447C": "ANATOLIAN HIEROGLYPH A105B",
    "1447D": "ANATOLIAN HIEROGLYPH A106",
    "1447E": "ANATOLIAN HIEROGLYPH A107",
    "1447F": "ANATOLIAN HIEROGLYPH A107A",
    "14480": "ANATOLIAN HIEROGLYPH A107B",
    "14481": "ANATOLIAN HIEROGLYPH A107C",
    "14482": "ANATOLIAN HIEROGLYPH A108",
    "14483": "ANATOLIAN HIEROGLYPH A109",
    "14484": "ANATOLIAN HIEROGLYPH A110",
    "14485": "ANATOLIAN HIEROGLYPH A110A",
    "14486": "ANATOLIAN HIEROGLYPH A110B",
    "14487": "ANATOLIAN HIEROGLYPH A111",
    "14488": "ANATOLIAN HIEROGLYPH A112",
    "14489": "ANATOLIAN HIEROGLYPH A113",
    "1448A": "ANATOLIAN HIEROGLYPH A114",
    "1448B": "ANATOLIAN HIEROGLYPH A115",
    "1448C": "ANATOLIAN HIEROGLYPH A115A",
    "1448D": "ANATOLIAN HIEROGLYPH A116",
    "1448E": "ANATOLIAN HIEROGLYPH A117",
    "1448F": "ANATOLIAN HIEROGLYPH A118",
    "14490": "ANATOLIAN HIEROGLYPH A119",
    "14491": "ANATOLIAN HIEROGLYPH A120",
    "14492": "ANATOLIAN HIEROGLYPH A121",
    "14493": "ANATOLIAN HIEROGLYPH A122",
    "14494": "ANATOLIAN HIEROGLYPH A123",
    "14495": "ANATOLIAN HIEROGLYPH A124",
    "14496": "ANATOLIAN HIEROGLYPH A125",
    "14497": "ANATOLIAN HIEROGLYPH A125A",
    "14498": "ANATOLIAN HIEROGLYPH A126",
    "14499": "ANATOLIAN HIEROGLYPH A127",
    "1449A": "ANATOLIAN HIEROGLYPH A128",
    "1449B": "ANATOLIAN HIEROGLYPH A129",
    "1449C": "ANATOLIAN HIEROGLYPH A130",
    "1449D": "ANATOLIAN HIEROGLYPH A131",
    "1449E": "ANATOLIAN HIEROGLYPH A132",
    "1449F": "ANATOLIAN HIEROGLYPH A133",
    "144A0": "ANATOLIAN HIEROGLYPH A134",
    "144A1": "ANATOLIAN HIEROGLYPH A135",
    "144A2": "ANATOLIAN HIEROGLYPH A135A",
    "144A3": "ANATOLIAN HIEROGLYPH A136",
    "144A4": "ANATOLIAN HIEROGLYPH A137",
    "144A5": "ANATOLIAN HIEROGLYPH A138",
    "144A6": "ANATOLIAN HIEROGLYPH A139",
    "144A7": "ANATOLIAN HIEROGLYPH A140",
    "144A8": "ANATOLIAN HIEROGLYPH A141",
    "144A9": "ANATOLIAN HIEROGLYPH A142",
    "144AA": "ANATOLIAN HIEROGLYPH A143",
    "144AB": "ANATOLIAN HIEROGLYPH A144",
    "144AC": "ANATOLIAN HIEROGLYPH A145",
    "144AD": "ANATOLIAN HIEROGLYPH A146",
    "144AE": "ANATOLIAN HIEROGLYPH A147",
    "144AF": "ANATOLIAN HIEROGLYPH A148",
    "144B0": "ANATOLIAN HIEROGLYPH A149",
    "144B1": "ANATOLIAN HIEROGLYPH A150",
    "144B2": "ANATOLIAN HIEROGLYPH A151",
    "144B3": "ANATOLIAN HIEROGLYPH A152",
    "144B4": "ANATOLIAN HIEROGLYPH A153",
    "144B5": "ANATOLIAN HIEROGLYPH A154",
    "144B6": "ANATOLIAN HIEROGLYPH A155",
    "144B7": "ANATOLIAN HIEROGLYPH A156",
    "144B8": "ANATOLIAN HIEROGLYPH A157",
    "144B9": "ANATOLIAN HIEROGLYPH A158",
    "144BA": "ANATOLIAN HIEROGLYPH A159",
    "144BB": "ANATOLIAN HIEROGLYPH A160",
    "144BC": "ANATOLIAN HIEROGLYPH A161",
    "144BD": "ANATOLIAN HIEROGLYPH A162",
    "144BE": "ANATOLIAN HIEROGLYPH A163",
    "144BF": "ANATOLIAN HIEROGLYPH A164",
    "144C0": "ANATOLIAN HIEROGLYPH A165",
    "144C1": "ANATOLIAN HIEROGLYPH A166",
    "144C2": "ANATOLIAN HIEROGLYPH A167",
    "144C3": "ANATOLIAN HIEROGLYPH A168",
    "144C4": "ANATOLIAN HIEROGLYPH A169",
    "144C5": "ANATOLIAN HIEROGLYPH A170",
    "144C6": "ANATOLIAN HIEROGLYPH A171",
    "144C7": "ANATOLIAN HIEROGLYPH A172",
    "144C8": "ANATOLIAN HIEROGLYPH A173",
    "144C9": "ANATOLIAN HIEROGLYPH A174",
    "144CA": "ANATOLIAN HIEROGLYPH A175",
    "144CB": "ANATOLIAN HIEROGLYPH A176",
    "144CC": "ANATOLIAN HIEROGLYPH A177",
    "144CD": "ANATOLIAN HIEROGLYPH A178",
    "144CE": "ANATOLIAN HIEROGLYPH A179",
    "144CF": "ANATOLIAN HIEROGLYPH A180",
    "144D0": "ANATOLIAN HIEROGLYPH A181",
    "144D1": "ANATOLIAN HIEROGLYPH A182",
    "144D2": "ANATOLIAN HIEROGLYPH A183",
    "144D3": "ANATOLIAN HIEROGLYPH A184",
    "144D4": "ANATOLIAN HIEROGLYPH A185",
    "144D5": "ANATOLIAN HIEROGLYPH A186",
    "144D6": "ANATOLIAN HIEROGLYPH A187",
    "144D7": "ANATOLIAN HIEROGLYPH A188",
    "144D8": "ANATOLIAN HIEROGLYPH A189",
    "144D9": "ANATOLIAN HIEROGLYPH A190",
    "144DA": "ANATOLIAN HIEROGLYPH A191",
    "144DB": "ANATOLIAN HIEROGLYPH A192",
    "144DC": "ANATOLIAN HIEROGLYPH A193",
    "144DD": "ANATOLIAN HIEROGLYPH A194",
    "144DE": "ANATOLIAN HIEROGLYPH A195",
    "144DF": "ANATOLIAN HIEROGLYPH A196",
    "144E0": "ANATOLIAN HIEROGLYPH A197",
    "144E1": "ANATOLIAN HIEROGLYPH A198",
    "144E2": "ANATOLIAN HIEROGLYPH A199",
    "144E3": "ANATOLIAN HIEROGLYPH A200",
    "144E4": "ANATOLIAN HIEROGLYPH A201",
    "144E5": "ANATOLIAN HIEROGLYPH A202",
    "144E6": "ANATOLIAN HIEROGLYPH A202A",
    "144E7": "ANATOLIAN HIEROGLYPH A202B",
    "144E8": "ANATOLIAN HIEROGLYPH A203",
    "144E9": "ANATOLIAN HIEROGLYPH A204",
    "144EA": "ANATOLIAN HIEROGLYPH A205",
    "144EB": "ANATOLIAN HIEROGLYPH A206",
    "144EC": "ANATOLIAN HIEROGLYPH A207",
    "144ED": "ANATOLIAN HIEROGLYPH A207A",
    "144EE": "ANATOLIAN HIEROGLYPH A208",
    "144EF": "ANATOLIAN HIEROGLYPH A209",
    "144F0": "ANATOLIAN HIEROGLYPH A209A",
    "144F1": "ANATOLIAN HIEROGLYPH A210",
    "144F2": "ANATOLIAN HIEROGLYPH A211",
    "144F3": "ANATOLIAN HIEROGLYPH A212",
    "144F4": "ANATOLIAN HIEROGLYPH A213",
    "144F5": "ANATOLIAN HIEROGLYPH A214",
    "144F6": "ANATOLIAN HIEROGLYPH A215",
    "144F7": "ANATOLIAN HIEROGLYPH A215A",
    "144F8": "ANATOLIAN HIEROGLYPH A216",
    "144F9": "ANATOLIAN HIEROGLYPH A216A",
    "144FA": "ANATOLIAN HIEROGLYPH A217",
    "144FB": "ANATOLIAN HIEROGLYPH A218",
    "144FC": "ANATOLIAN HIEROGLYPH A219",
    "144FD": "ANATOLIAN HIEROGLYPH A220",
    "144FE": "ANATOLIAN HIEROGLYPH A221",
    "144FF": "ANATOLIAN HIEROGLYPH A222",
    "14500": "ANATOLIAN HIEROGLYPH A223",
    "14501": "ANATOLIAN HIEROGLYPH A224",
    "14502": "ANATOLIAN HIEROGLYPH A225",
    "14503": "ANATOLIAN HIEROGLYPH A226",
    "14504": "ANATOLIAN HIEROGLYPH A227",
    "14505": "ANATOLIAN HIEROGLYPH A227A",
    "14506": "ANATOLIAN HIEROGLYPH A228",
    "14507": "ANATOLIAN HIEROGLYPH A229",
    "14508": "ANATOLIAN HIEROGLYPH A230",
    "14509": "ANATOLIAN HIEROGLYPH A231",
    "1450A": "ANATOLIAN HIEROGLYPH A232",
    "1450B": "ANATOLIAN HIEROGLYPH A233",
    "1450C": "ANATOLIAN HIEROGLYPH A234",
    "1450D": "ANATOLIAN HIEROGLYPH A235",
    "1450E": "ANATOLIAN HIEROGLYPH A236",
    "1450F": "ANATOLIAN HIEROGLYPH A237",
    "14510": "ANATOLIAN HIEROGLYPH A238",
    "14511": "ANATOLIAN HIEROGLYPH A239",
    "14512": "ANATOLIAN HIEROGLYPH A240",
    "14513": "ANATOLIAN HIEROGLYPH A241",
    "14514": "ANATOLIAN HIEROGLYPH A242",
    "14515": "ANATOLIAN HIEROGLYPH A243",
    "14516": "ANATOLIAN HIEROGLYPH A244",
    "14517": "ANATOLIAN HIEROGLYPH A245",
    "14518": "ANATOLIAN HIEROGLYPH A246",
    "14519": "ANATOLIAN HIEROGLYPH A247",
    "1451A": "ANATOLIAN HIEROGLYPH A248",
    "1451B": "ANATOLIAN HIEROGLYPH A249",
    "1451C": "ANATOLIAN HIEROGLYPH A250",
    "1451D": "ANATOLIAN HIEROGLYPH A251",
    "1451E": "ANATOLIAN HIEROGLYPH A252",
    "1451F": "ANATOLIAN HIEROGLYPH A253",
    "14520": "ANATOLIAN HIEROGLYPH A254",
    "14521": "ANATOLIAN HIEROGLYPH A255",
    "14522": "ANATOLIAN HIEROGLYPH A256",
    "14523": "ANATOLIAN HIEROGLYPH A257",
    "14524": "ANATOLIAN HIEROGLYPH A258",
    "14525": "ANATOLIAN HIEROGLYPH A259",
    "14526": "ANATOLIAN HIEROGLYPH A260",
    "14527": "ANATOLIAN HIEROGLYPH A261",
    "14528": "ANATOLIAN HIEROGLYPH A262",
    "14529": "ANATOLIAN HIEROGLYPH A263",
    "1452A": "ANATOLIAN HIEROGLYPH A264",
    "1452B": "ANATOLIAN HIEROGLYPH A265",
    "1452C": "ANATOLIAN HIEROGLYPH A266",
    "1452D": "ANATOLIAN HIEROGLYPH A267",
    "1452E": "ANATOLIAN HIEROGLYPH A267A",
    "1452F": "ANATOLIAN HIEROGLYPH A268",
    "14530": "ANATOLIAN HIEROGLYPH A269",
    "14531": "ANATOLIAN HIEROGLYPH A270",
    "14532": "ANATOLIAN HIEROGLYPH A271",
    "14533": "ANATOLIAN HIEROGLYPH A272",
    "14534": "ANATOLIAN HIEROGLYPH A273",
    "14535": "ANATOLIAN HIEROGLYPH A274",
    "14536": "ANATOLIAN HIEROGLYPH A275",
    "14537": "ANATOLIAN HIEROGLYPH A276",
    "14538": "ANATOLIAN HIEROGLYPH A277",
    "14539": "ANATOLIAN HIEROGLYPH A278",
    "1453A": "ANATOLIAN HIEROGLYPH A279",
    "1453B": "ANATOLIAN HIEROGLYPH A280",
    "1453C": "ANATOLIAN HIEROGLYPH A281",
    "1453D": "ANATOLIAN HIEROGLYPH A282",
    "1453E": "ANATOLIAN HIEROGLYPH A283",
    "1453F": "ANATOLIAN HIEROGLYPH A284",
    "14540": "ANATOLIAN HIEROGLYPH A285",
    "14541": "ANATOLIAN HIEROGLYPH A286",
    "14542": "ANATOLIAN HIEROGLYPH A287",
    "14543": "ANATOLIAN HIEROGLYPH A288",
    "14544": "ANATOLIAN HIEROGLYPH A289",
    "14545": "ANATOLIAN HIEROGLYPH A289A",
    "14546": "ANATOLIAN HIEROGLYPH A290",
    "14547": "ANATOLIAN HIEROGLYPH A291",
    "14548": "ANATOLIAN HIEROGLYPH A292",
    "14549": "ANATOLIAN HIEROGLYPH A293",
    "1454A": "ANATOLIAN HIEROGLYPH A294",
    "1454B": "ANATOLIAN HIEROGLYPH A294A",
    "1454C": "ANATOLIAN HIEROGLYPH A295",
    "1454D": "ANATOLIAN HIEROGLYPH A296",
    "1454E": "ANATOLIAN HIEROGLYPH A297",
    "1454F": "ANATOLIAN HIEROGLYPH A298",
    "14550": "ANATOLIAN HIEROGLYPH A299",
    "14551": "ANATOLIAN HIEROGLYPH A299A",
    "14552": "ANATOLIAN HIEROGLYPH A300",
    "14553": "ANATOLIAN HIEROGLYPH A301",
    "14554": "ANATOLIAN HIEROGLYPH A302",
    "14555": "ANATOLIAN HIEROGLYPH A303",
    "14556": "ANATOLIAN HIEROGLYPH A304",
    "14557": "ANATOLIAN HIEROGLYPH A305",
    "14558": "ANATOLIAN HIEROGLYPH A306",
    "14559": "ANATOLIAN HIEROGLYPH A307",
    "1455A": "ANATOLIAN HIEROGLYPH A308",
    "1455B": "ANATOLIAN HIEROGLYPH A309",
    "1455C": "ANATOLIAN HIEROGLYPH A309A",
    "1455D": "ANATOLIAN HIEROGLYPH A310",
    "1455E": "ANATOLIAN HIEROGLYPH A311",
    "1455F": "ANATOLIAN HIEROGLYPH A312",
    "14560": "ANATOLIAN HIEROGLYPH A313",
    "14561": "ANATOLIAN HIEROGLYPH A314",
    "14562": "ANATOLIAN HIEROGLYPH A315",
    "14563": "ANATOLIAN HIEROGLYPH A316",
    "14564": "ANATOLIAN HIEROGLYPH A317",
    "14565": "ANATOLIAN HIEROGLYPH A318",
    "14566": "ANATOLIAN HIEROGLYPH A319",
    "14567": "ANATOLIAN HIEROGLYPH A320",
    "14568": "ANATOLIAN HIEROGLYPH A321",
    "14569": "ANATOLIAN HIEROGLYPH A322",
    "1456A": "ANATOLIAN HIEROGLYPH A323",
    "1456B": "ANATOLIAN HIEROGLYPH A324",
    "1456C": "ANATOLIAN HIEROGLYPH A325",
    "1456D": "ANATOLIAN HIEROGLYPH A326",
    "1456E": "ANATOLIAN HIEROGLYPH A327",
    "1456F": "ANATOLIAN HIEROGLYPH A328",
    "14570": "ANATOLIAN HIEROGLYPH A329",
    "14571": "ANATOLIAN HIEROGLYPH A329A",
    "14572": "ANATOLIAN HIEROGLYPH A330",
    "14573": "ANATOLIAN HIEROGLYPH A331",
    "14574": "ANATOLIAN HIEROGLYPH A332A",
    "14575": "ANATOLIAN HIEROGLYPH A332B",
    "14576": "ANATOLIAN HIEROGLYPH A332C",
    "14577": "ANATOLIAN HIEROGLYPH A333",
    "14578": "ANATOLIAN HIEROGLYPH A334",
    "14579": "ANATOLIAN HIEROGLYPH A335",
    "1457A": "ANATOLIAN HIEROGLYPH A336",
    "1457B": "ANATOLIAN HIEROGLYPH A336A",
    "1457C": "ANATOLIAN HIEROGLYPH A336B",
    "1457D": "ANATOLIAN HIEROGLYPH A336C",
    "1457E": "ANATOLIAN HIEROGLYPH A337",
    "1457F": "ANATOLIAN HIEROGLYPH A338",
    "14580": "ANATOLIAN HIEROGLYPH A339",
    "14581": "ANATOLIAN HIEROGLYPH A340",
    "14582": "ANATOLIAN HIEROGLYPH A341",
    "14583": "ANATOLIAN HIEROGLYPH A342",
    "14584": "ANATOLIAN HIEROGLYPH A343",
    "14585": "ANATOLIAN HIEROGLYPH A344",
    "14586": "ANATOLIAN HIEROGLYPH A345",
    "14587": "ANATOLIAN HIEROGLYPH A346",
    "14588": "ANATOLIAN HIEROGLYPH A347",
    "14589": "ANATOLIAN HIEROGLYPH A348",
    "1458A": "ANATOLIAN HIEROGLYPH A349",
    "1458B": "ANATOLIAN HIEROGLYPH A350",
    "1458C": "ANATOLIAN HIEROGLYPH A351",
    "1458D": "ANATOLIAN HIEROGLYPH A352",
    "1458E": "ANATOLIAN HIEROGLYPH A353",
    "1458F": "ANATOLIAN HIEROGLYPH A354",
    "14590": "ANATOLIAN HIEROGLYPH A355",
    "14591": "ANATOLIAN HIEROGLYPH A356",
    "14592": "ANATOLIAN HIEROGLYPH A357",
    "14593": "ANATOLIAN HIEROGLYPH A358",
    "14594": "ANATOLIAN HIEROGLYPH A359",
    "14595": "ANATOLIAN HIEROGLYPH A359A",
    "14596": "ANATOLIAN HIEROGLYPH A360",
    "14597": "ANATOLIAN HIEROGLYPH A361",
    "14598": "ANATOLIAN HIEROGLYPH A362",
    "14599": "ANATOLIAN HIEROGLYPH A363",
    "1459A": "ANATOLIAN HIEROGLYPH A364",
    "1459B": "ANATOLIAN HIEROGLYPH A364A",
    "1459C": "ANATOLIAN HIEROGLYPH A365",
    "1459D": "ANATOLIAN HIEROGLYPH A366",
    "1459E": "ANATOLIAN HIEROGLYPH A367",
    "1459F": "ANATOLIAN HIEROGLYPH A368",
    "145A0": "ANATOLIAN HIEROGLYPH A368A",
    "145A1": "ANATOLIAN HIEROGLYPH A369",
    "145A2": "ANATOLIAN HIEROGLYPH A370",
    "145A3": "ANATOLIAN HIEROGLYPH A371",
    "145A4": "ANATOLIAN HIEROGLYPH A371A",
    "145A5": "ANATOLIAN HIEROGLYPH A372",
    "145A6": "ANATOLIAN HIEROGLYPH A373",
    "145A7": "ANATOLIAN HIEROGLYPH A374",
    "145A8": "ANATOLIAN HIEROGLYPH A375",
    "145A9": "ANATOLIAN HIEROGLYPH A376",
    "145AA": "ANATOLIAN HIEROGLYPH A377",
    "145AB": "ANATOLIAN HIEROGLYPH A378",
    "145AC": "ANATOLIAN HIEROGLYPH A379",
    "145AD": "ANATOLIAN HIEROGLYPH A380",
    "145AE": "ANATOLIAN HIEROGLYPH A381",
    "145AF": "ANATOLIAN HIEROGLYPH A381A",
    "145B0": "ANATOLIAN HIEROGLYPH A382",
    "145B1": "ANATOLIAN HIEROGLYPH A383 RA OR RI",
    "145B2": "ANATOLIAN HIEROGLYPH A383A",
    "145B3": "ANATOLIAN HIEROGLYPH A384",
    "145B4": "ANATOLIAN HIEROGLYPH A385",
    "145B5": "ANATOLIAN HIEROGLYPH A386",
    "145B6": "ANATOLIAN HIEROGLYPH A386A",
    "145B7": "ANATOLIAN HIEROGLYPH A387",
    "145B8": "ANATOLIAN HIEROGLYPH A388",
    "145B9": "ANATOLIAN HIEROGLYPH A389",
    "145BA": "ANATOLIAN HIEROGLYPH A390",
    "145BB": "ANATOLIAN HIEROGLYPH A391",
    "145BC": "ANATOLIAN HIEROGLYPH A392",
    "145BD": "ANATOLIAN HIEROGLYPH A393 EIGHT",
    "145BE": "ANATOLIAN HIEROGLYPH A394",
    "145BF": "ANATOLIAN HIEROGLYPH A395",
    "145C0": "ANATOLIAN HIEROGLYPH A396",
    "145C1": "ANATOLIAN HIEROGLYPH A397",
    "145C2": "ANATOLIAN HIEROGLYPH A398",
    "145C3": "ANATOLIAN HIEROGLYPH A399",
    "145C4": "ANATOLIAN HIEROGLYPH A400",
    "145C5": "ANATOLIAN HIEROGLYPH A401",
    "145C6": "ANATOLIAN HIEROGLYPH A402",
    "145C7": "ANATOLIAN HIEROGLYPH A403",
    "145C8": "ANATOLIAN HIEROGLYPH A404",
    "145C9": "ANATOLIAN HIEROGLYPH A405",
    "145CA": "ANATOLIAN HIEROGLYPH A406",
    "145CB": "ANATOLIAN HIEROGLYPH A407",
    "145CC": "ANATOLIAN HIEROGLYPH A408",
    "145CD": "ANATOLIAN HIEROGLYPH A409",
    "145CE": "ANATOLIAN HIEROGLYPH A410 BEGIN LOGOGRAM MARK",
    "145CF": "ANATOLIAN HIEROGLYPH A410A END LOGOGRAM MARK",
    "145D0": "ANATOLIAN HIEROGLYPH A411",
    "145D1": "ANATOLIAN HIEROGLYPH A412",
    "145D2": "ANATOLIAN HIEROGLYPH A413",
    "145D3": "ANATOLIAN HIEROGLYPH A414",
    "145D4": "ANATOLIAN HIEROGLYPH A415",
    "145D5": "ANATOLIAN HIEROGLYPH A416",
    "145D6": "ANATOLIAN HIEROGLYPH A417",
    "145D7": "ANATOLIAN HIEROGLYPH A418",
    "145D8": "ANATOLIAN HIEROGLYPH A419",
    "145D9": "ANATOLIAN HIEROGLYPH A420",
    "145DA": "ANATOLIAN HIEROGLYPH A421",
    "145DB": "ANATOLIAN HIEROGLYPH A422",
    "145DC": "ANATOLIAN HIEROGLYPH A423",
    "145DD": "ANATOLIAN HIEROGLYPH A424",
    "145DE": "ANATOLIAN HIEROGLYPH A425",
    "145DF": "ANATOLIAN HIEROGLYPH A426",
    "145E0": "ANATOLIAN HIEROGLYPH A427",
    "145E1": "ANATOLIAN HIEROGLYPH A428",
    "145E2": "ANATOLIAN HIEROGLYPH A429",
    "145E3": "ANATOLIAN HIEROGLYPH A430",
    "145E4": "ANATOLIAN HIEROGLYPH A431",
    "145E5": "ANATOLIAN HIEROGLYPH A432",
    "145E6": "ANATOLIAN HIEROGLYPH A433",
    "145E7": "ANATOLIAN HIEROGLYPH A434",
    "145E8": "ANATOLIAN HIEROGLYPH A435",
    "145E9": "ANATOLIAN HIEROGLYPH A436",
    "145EA": "ANATOLIAN HIEROGLYPH A437",
    "145EB": "ANATOLIAN HIEROGLYPH A438",
    "145EC": "ANATOLIAN HIEROGLYPH A439",
    "145ED": "ANATOLIAN HIEROGLYPH A440",
    "145EE": "ANATOLIAN HIEROGLYPH A441",
    "145EF": "ANATOLIAN HIEROGLYPH A442",
    "145F0": "ANATOLIAN HIEROGLYPH A443",
    "145F1": "ANATOLIAN HIEROGLYPH A444",
    "145F2": "ANATOLIAN HIEROGLYPH A445",
    "145F3": "ANATOLIAN HIEROGLYPH A446",
    "145F4": "ANATOLIAN HIEROGLYPH A447",
    "145F5": "ANATOLIAN HIEROGLYPH A448",
    "145F6": "ANATOLIAN HIEROGLYPH A449",
    "145F7": "ANATOLIAN HIEROGLYPH A450",
    "145F8": "ANATOLIAN HIEROGLYPH A450A",
    "145F9": "ANATOLIAN HIEROGLYPH A451",
    "145FA": "ANATOLIAN HIEROGLYPH A452",
    "145FB": "ANATOLIAN HIEROGLYPH A453",
    "145FC": "ANATOLIAN HIEROGLYPH A454",
    "145FD": "ANATOLIAN HIEROGLYPH A455",
    "145FE": "ANATOLIAN HIEROGLYPH A456",
    "145FF": "ANATOLIAN HIEROGLYPH A457",
    "14600": "ANATOLIAN HIEROGLYPH A457A",
    "14601": "ANATOLIAN HIEROGLYPH A458",
    "14602": "ANATOLIAN HIEROGLYPH A459",
    "14603": "ANATOLIAN HIEROGLYPH A460",
    "14604": "ANATOLIAN HIEROGLYPH A461",
    "14605": "ANATOLIAN HIEROGLYPH A462",
    "14606": "ANATOLIAN HIEROGLYPH A463",
    "14607": "ANATOLIAN HIEROGLYPH A464",
    "14608": "ANATOLIAN HIEROGLYPH A465",
    "14609": "ANATOLIAN HIEROGLYPH A466",
    "1460A": "ANATOLIAN HIEROGLYPH A467",
    "1460B": "ANATOLIAN HIEROGLYPH A468",
    "1460C": "ANATOLIAN HIEROGLYPH A469",
    "1460D": "ANATOLIAN HIEROGLYPH A470",
    "1460E": "ANATOLIAN HIEROGLYPH A471",
    "1460F": "ANATOLIAN HIEROGLYPH A472",
    "14610": "ANATOLIAN HIEROGLYPH A473",
    "14611": "ANATOLIAN HIEROGLYPH A474",
    "14612": "ANATOLIAN HIEROGLYPH A475",
    "14613": "ANATOLIAN HIEROGLYPH A476",
    "14614": "ANATOLIAN HIEROGLYPH A477",
    "14615": "ANATOLIAN HIEROGLYPH A478",
    "14616": "ANATOLIAN HIEROGLYPH A479",
    "14617": "ANATOLIAN HIEROGLYPH A480",
    "14618": "ANATOLIAN HIEROGLYPH A481",
    "14619": "ANATOLIAN HIEROGLYPH A482",
    "1461A": "ANATOLIAN HIEROGLYPH A483",
    "1461B": "ANATOLIAN HIEROGLYPH A484",
    "1461C": "ANATOLIAN HIEROGLYPH A485",
    "1461D": "ANATOLIAN HIEROGLYPH A486",
    "1461E": "ANATOLIAN HIEROGLYPH A487",
    "1461F": "ANATOLIAN HIEROGLYPH A488",
    "14620": "ANATOLIAN HIEROGLYPH A489",
    "14621": "ANATOLIAN HIEROGLYPH A490",
    "14622": "ANATOLIAN HIEROGLYPH A491",
    "14623": "ANATOLIAN HIEROGLYPH A492",
    "14624": "ANATOLIAN HIEROGLYPH A493",
    "14625": "ANATOLIAN HIEROGLYPH A494",
    "14626": "ANATOLIAN HIEROGLYPH A495",
    "14627": "ANATOLIAN HIEROGLYPH A496",
    "14628": "ANATOLIAN HIEROGLYPH A497",
    "14629": "ANATOLIAN HIEROGLYPH A501",
    "1462A": "ANATOLIAN HIEROGLYPH A502",
    "1462B": "ANATOLIAN HIEROGLYPH A503",
    "1462C": "ANATOLIAN HIEROGLYPH A504",
    "1462D": "ANATOLIAN HIEROGLYPH A505",
    "1462E": "ANATOLIAN HIEROGLYPH A506",
    "1462F": "ANATOLIAN HIEROGLYPH A507",
    "14630": "ANATOLIAN HIEROGLYPH A508",
    "14631": "ANATOLIAN HIEROGLYPH A509",
    "14632": "ANATOLIAN HIEROGLYPH A510",
    "14633": "ANATOLIAN HIEROGLYPH A511",
    "14634": "ANATOLIAN HIEROGLYPH A512",
    "14635": "ANATOLIAN HIEROGLYPH A513",
    "14636": "ANATOLIAN HIEROGLYPH A514",
    "14637": "ANATOLIAN HIEROGLYPH A515",
    "14638": "ANATOLIAN HIEROGLYPH A516",
    "14639": "ANATOLIAN HIEROGLYPH A517",
    "1463A": "ANATOLIAN HIEROGLYPH A518",
    "1463B": "ANATOLIAN HIEROGLYPH A519",
    "1463C": "ANATOLIAN HIEROGLYPH A520",
    "1463D": "ANATOLIAN HIEROGLYPH A521",
    "1463E": "ANATOLIAN HIEROGLYPH A522",
    "1463F": "ANATOLIAN HIEROGLYPH A523",
    "14640": "ANATOLIAN HIEROGLYPH A524",
    "14641": "ANATOLIAN HIEROGLYPH A525",
    "14642": "ANATOLIAN HIEROGLYPH A526",
    "14643": "ANATOLIAN HIEROGLYPH A527",
    "14644": "ANATOLIAN HIEROGLYPH A528",
    "14645": "ANATOLIAN HIEROGLYPH A529",
    "14646": "ANATOLIAN HIEROGLYPH A530",
    "16800": "BAMUM LETTER PHASE-A NGKUE MFON",
    "16801": "BAMUM LETTER PHASE-A GBIEE FON",
    "16802": "BAMUM LETTER PHASE-A PON MFON PIPAEMGBIEE",
    "16803": "BAMUM LETTER PHASE-A PON MFON PIPAEMBA",
    "16804": "BAMUM LETTER PHASE-A NAA MFON",
    "16805": "BAMUM LETTER PHASE-A SHUENSHUET",
    "16806": "BAMUM LETTER PHASE-A TITA MFON",
    "16807": "BAMUM LETTER PHASE-A NZA MFON",
    "16808": "BAMUM LETTER PHASE-A SHINDA PA NJI",
    "16809": "BAMUM LETTER PHASE-A PON PA NJI PIPAEMGBIEE",
    "1680A": "BAMUM LETTER PHASE-A PON PA NJI PIPAEMBA",
    "1680B": "BAMUM LETTER PHASE-A MAEMBGBIEE",
    "1680C": "BAMUM LETTER PHASE-A TU MAEMBA",
    "1680D": "BAMUM LETTER PHASE-A NGANGU",
    "1680E": "BAMUM LETTER PHASE-A MAEMVEUX",
    "1680F": "BAMUM LETTER PHASE-A MANSUAE",
    "16810": "BAMUM LETTER PHASE-A MVEUAENGAM",
    "16811": "BAMUM LETTER PHASE-A SEUNYAM",
    "16812": "BAMUM LETTER PHASE-A NTOQPEN",
    "16813": "BAMUM LETTER PHASE-A KEUKEUTNDA",
    "16814": "BAMUM LETTER PHASE-A NKINDI",
    "16815": "BAMUM LETTER PHASE-A SUU",
    "16816": "BAMUM LETTER PHASE-A NGKUENZEUM",
    "16817": "BAMUM LETTER PHASE-A LAPAQ",
    "16818": "BAMUM LETTER PHASE-A LET KUT",
    "16819": "BAMUM LETTER PHASE-A NTAP MFAA",
    "1681A": "BAMUM LETTER PHASE-A MAEKEUP",
    "1681B": "BAMUM LETTER PHASE-A PASHAE",
    "1681C": "BAMUM LETTER PHASE-A GHEUAERAE",
    "1681D": "BAMUM LETTER PHASE-A PAMSHAE",
    "1681E": "BAMUM LETTER PHASE-A MON NGGEUAET",
    "1681F": "BAMUM LETTER PHASE-A NZUN MEUT",
    "16820": "BAMUM LETTER PHASE-A U YUQ NAE",
    "16821": "BAMUM LETTER PHASE-A GHEUAEGHEUAE",
    "16822": "BAMUM LETTER PHASE-A NTAP NTAA",
    "16823": "BAMUM LETTER PHASE-A SISA",
    "16824": "BAMUM LETTER PHASE-A MGBASA",
    "16825": "BAMUM LETTER PHASE-A MEUNJOMNDEUQ",
    "16826": "BAMUM LETTER PHASE-A MOOMPUQ",
    "16827": "BAMUM LETTER PHASE-A KAFA",
    "16828": "BAMUM LETTER PHASE-A PA LEERAEWA",
    "16829": "BAMUM LETTER PHASE-A NDA LEERAEWA",
    "1682A": "BAMUM LETTER PHASE-A PET",
    "1682B": "BAMUM LETTER PHASE-A MAEMKPEN",
    "1682C": "BAMUM LETTER PHASE-A NIKA",
    "1682D": "BAMUM LETTER PHASE-A PUP",
    "1682E": "BAMUM LETTER PHASE-A TUAEP",
    "1682F": "BAMUM LETTER PHASE-A LUAEP",
    "16830": "BAMUM LETTER PHASE-A SONJAM",
    "16831": "BAMUM LETTER PHASE-A TEUTEUWEN",
    "16832": "BAMUM LETTER PHASE-A MAENYI",
    "16833": "BAMUM LETTER PHASE-A KET",
    "16834": "BAMUM LETTER PHASE-A NDAANGGEUAET",
    "16835": "BAMUM LETTER PHASE-A KUOQ",
    "16836": "BAMUM LETTER PHASE-A MOOMEUT",
    "16837": "BAMUM LETTER PHASE-A SHUM",
    "16838": "BAMUM LETTER PHASE-A LOMMAE",
    "16839": "BAMUM LETTER PHASE-A FIRI",
    "1683A": "BAMUM LETTER PHASE-A ROM",
    "1683B": "BAMUM LETTER PHASE-A KPOQ",
    "1683C": "BAMUM LETTER PHASE-A SOQ",
    "1683D": "BAMUM LETTER PHASE-A MAP PIEET",
    "1683E": "BAMUM LETTER PHASE-A SHIRAE",
    "1683F": "BAMUM LETTER PHASE-A NTAP",
    "16840": "BAMUM LETTER PHASE-A SHOQ NSHUT YUM",
    "16841": "BAMUM LETTER PHASE-A NYIT MONGKEUAEQ",
    "16842": "BAMUM LETTER PHASE-A PAARAE",
    "16843": "BAMUM LETTER PHASE-A NKAARAE",
    "16844": "BAMUM LETTER PHASE-A UNKNOWN",
    "16845": "BAMUM LETTER PHASE-A NGGEN",
    "16846": "BAMUM LETTER PHASE-A MAESI",
    "16847": "BAMUM LETTER PHASE-A NJAM",
    "16848": "BAMUM LETTER PHASE-A MBANYI",
    "16849": "BAMUM LETTER PHASE-A NYET",
    "1684A": "BAMUM LETTER PHASE-A TEUAEN",
    "1684B": "BAMUM LETTER PHASE-A SOT",
    "1684C": "BAMUM LETTER PHASE-A PAAM",
    "1684D": "BAMUM LETTER PHASE-A NSHIEE",
    "1684E": "BAMUM LETTER PHASE-A MAEM",
    "1684F": "BAMUM LETTER PHASE-A NYI",
    "16850": "BAMUM LETTER PHASE-A KAQ",
    "16851": "BAMUM LETTER PHASE-A NSHA",
    "16852": "BAMUM LETTER PHASE-A VEE",
    "16853": "BAMUM LETTER PHASE-A LU",
    "16854": "BAMUM LETTER PHASE-A NEN",
    "16855": "BAMUM LETTER PHASE-A NAQ",
    "16856": "BAMUM LETTER PHASE-A MBAQ",
    "16857": "BAMUM LETTER PHASE-B NSHUET",
    "16858": "BAMUM LETTER PHASE-B TU MAEMGBIEE",
    "16859": "BAMUM LETTER PHASE-B SIEE",
    "1685A": "BAMUM LETTER PHASE-B SET TU",
    "1685B": "BAMUM LETTER PHASE-B LOM NTEUM",
    "1685C": "BAMUM LETTER PHASE-B MBA MAELEE",
    "1685D": "BAMUM LETTER PHASE-B KIEEM",
    "1685E": "BAMUM LETTER PHASE-B YEURAE",
    "1685F": "BAMUM LETTER PHASE-B MBAARAE",
    "16860": "BAMUM LETTER PHASE-B KAM",
    "16861": "BAMUM LETTER PHASE-B PEESHI",
    "16862": "BAMUM LETTER PHASE-B YAFU LEERAEWA",
    "16863": "BAMUM LETTER PHASE-B LAM NSHUT NYAM",
    "16864": "BAMUM LETTER PHASE-B NTIEE SHEUOQ",
    "16865": "BAMUM LETTER PHASE-B NDU NJAA",
    "16866": "BAMUM LETTER PHASE-B GHEUGHEUAEM",
    "16867": "BAMUM LETTER PHASE-B PIT",
    "16868": "BAMUM LETTER PHASE-B TU NSIEE",
    "16869": "BAMUM LETTER PHASE-B SHET NJAQ",
    "1686A": "BAMUM LETTER PHASE-B SHEUAEQTU",
    "1686B": "BAMUM LETTER PHASE-B MFON TEUAEQ",
    "1686C": "BAMUM LETTER PHASE-B MBIT MBAAKET",
    "1686D": "BAMUM LETTER PHASE-B NYI NTEUM",
    "1686E": "BAMUM LETTER PHASE-B KEUPUQ",
    "1686F": "BAMUM LETTER PHASE-B GHEUGHEN",
    "16870": "BAMUM LETTER PHASE-B KEUYEUX",
    "16871": "BAMUM LETTER PHASE-B LAANAE",
    "16872": "BAMUM LETTER PHASE-B PARUM",
    "16873": "BAMUM LETTER PHASE-B VEUM",
    "16874": "BAMUM LETTER PHASE-B NGKINDI MVOP",
    "16875": "BAMUM LETTER PHASE-B NGGEU MBU",
    "16876": "BAMUM LETTER PHASE-B WUAET",
    "16877": "BAMUM LETTER PHASE-B SAKEUAE",
    "16878": "BAMUM LETTER PHASE-B TAAM",
    "16879": "BAMUM LETTER PHASE-B MEUQ",
    "1687A": "BAMUM LETTER PHASE-B NGGUOQ",
    "1687B": "BAMUM LETTER PHASE-B NGGUOQ LARGE",
    "1687C": "BAMUM LETTER PHASE-B MFIYAQ",
    "1687D": "BAMUM LETTER PHASE-B SUE",
    "1687E": "BAMUM LETTER PHASE-B MBEURI",
    "1687F": "BAMUM LETTER PHASE-B MONTIEEN",
    "16880": "BAMUM LETTER PHASE-B NYAEMAE",
    "16881": "BAMUM LETTER PHASE-B PUNGAAM",
    "16882": "BAMUM LETTER PHASE-B MEUT NGGEET",
    "16883": "BAMUM LETTER PHASE-B FEUX",
    "16884": "BAMUM LETTER PHASE-B MBUOQ",
    "16885": "BAMUM LETTER PHASE-B FEE",
    "16886": "BAMUM LETTER PHASE-B KEUAEM",
    "16887": "BAMUM LETTER PHASE-B MA NJEUAENA",
    "16888": "BAMUM LETTER PHASE-B MA NJUQA",
    "16889": "BAMUM LETTER PHASE-B LET",
    "1688A": "BAMUM LETTER PHASE-B NGGAAM",
    "1688B": "BAMUM LETTER PHASE-B NSEN",
    "1688C": "BAMUM LETTER PHASE-B MA",
    "1688D": "BAMUM LETTER PHASE-B KIQ",
    "1688E": "BAMUM LETTER PHASE-B NGOM",
    "1688F": "BAMUM LETTER PHASE-C NGKUE MAEMBA",
    "16890": "BAMUM LETTER PHASE-C NZA",
    "16891": "BAMUM LETTER PHASE-C YUM",
    "16892": "BAMUM LETTER PHASE-C WANGKUOQ",
    "16893": "BAMUM LETTER PHASE-C NGGEN",
    "16894": "BAMUM LETTER PHASE-C NDEUAEREE",
    "16895": "BAMUM LETTER PHASE-C NGKAQ",
    "16896": "BAMUM LETTER PHASE-C GHARAE",
    "16897": "BAMUM LETTER PHASE-C MBEEKEET",
    "16898": "BAMUM LETTER PHASE-C GBAYI",
    "16899": "BAMUM LETTER PHASE-C NYIR MKPARAQ MEUN",
    "1689A": "BAMUM LETTER PHASE-C NTU MBIT",
    "1689B": "BAMUM LETTER PHASE-C MBEUM",
    "1689C": "BAMUM LETTER PHASE-C PIRIEEN",
    "1689D": "BAMUM LETTER PHASE-C NDOMBU",
    "1689E": "BAMUM LETTER PHASE-C MBAA CABBAGE-TREE",
    "1689F": "BAMUM LETTER PHASE-C KEUSHEUAEP",
    "168A0": "BAMUM LETTER PHASE-C GHAP",
    "168A1": "BAMUM LETTER PHASE-C KEUKAQ",
    "168A2": "BAMUM LETTER PHASE-C YU MUOMAE",
    "168A3": "BAMUM LETTER PHASE-C NZEUM",
    "168A4": "BAMUM LETTER PHASE-C MBUE",
    "168A5": "BAMUM LETTER PHASE-C NSEUAEN",
    "168A6": "BAMUM LETTER PHASE-C MBIT",
    "168A7": "BAMUM LETTER PHASE-C YEUQ",
    "168A8": "BAMUM LETTER PHASE-C KPARAQ",
    "168A9": "BAMUM LETTER PHASE-C KAA",
    "168AA": "BAMUM LETTER PHASE-C SEUX",
    "168AB": "BAMUM LETTER PHASE-C NDIDA",
    "168AC": "BAMUM LETTER PHASE-C TAASHAE",
    "168AD": "BAMUM LETTER PHASE-C NJUEQ",
    "168AE": "BAMUM LETTER PHASE-C TITA YUE",
    "168AF": "BAMUM LETTER PHASE-C SUAET",
    "168B0": "BAMUM LETTER PHASE-C NGGUAEN NYAM",
    "168B1": "BAMUM LETTER PHASE-C VEUX",
    "168B2": "BAMUM LETTER PHASE-C NANSANAQ",
    "168B3": "BAMUM LETTER PHASE-C MA KEUAERI",
    "168B4": "BAMUM LETTER PHASE-C NTAA",
    "168B5": "BAMUM LETTER PHASE-C NGGUON",
    "168B6": "BAMUM LETTER PHASE-C LAP",
    "168B7": "BAMUM LETTER PHASE-C MBIRIEEN",
    "168B8": "BAMUM LETTER PHASE-C MGBASAQ",
    "168B9": "BAMUM LETTER PHASE-C NTEUNGBA",
    "168BA": "BAMUM LETTER PHASE-C TEUTEUX",
    "168BB": "BAMUM LETTER PHASE-C NGGUM",
    "168BC": "BAMUM LETTER PHASE-C FUE",
    "168BD": "BAMUM LETTER PHASE-C NDEUT",
    "168BE": "BAMUM LETTER PHASE-C NSA",
    "168BF": "BAMUM LETTER PHASE-C NSHAQ",
    "168C0": "BAMUM LETTER PHASE-C BUNG",
    "168C1": "BAMUM LETTER PHASE-C VEUAEPEN",
    "168C2": "BAMUM LETTER PHASE-C MBERAE",
    "168C3": "BAMUM LETTER PHASE-C RU",
    "168C4": "BAMUM LETTER PHASE-C NJAEM",
    "168C5": "BAMUM LETTER PHASE-C LAM",
    "168C6": "BAMUM LETTER PHASE-C TITUAEP",
    "168C7": "BAMUM LETTER PHASE-C NSUOT NGOM",
    "168C8": "BAMUM LETTER PHASE-C NJEEEE",
    "168C9": "BAMUM LETTER PHASE-C KET",
    "168CA": "BAMUM LETTER PHASE-C NGGU",
    "168CB": "BAMUM LETTER PHASE-C MAESI",
    "168CC": "BAMUM LETTER PHASE-C MBUAEM",
    "168CD": "BAMUM LETTER PHASE-C LU",
    "168CE": "BAMUM LETTER PHASE-C KUT",
    "168CF": "BAMUM LETTER PHASE-C NJAM",
    "168D0": "BAMUM LETTER PHASE-C NGOM",
    "168D1": "BAMUM LETTER PHASE-C WUP",
    "168D2": "BAMUM LETTER PHASE-C NGGUEET",
    "168D3": "BAMUM LETTER PHASE-C NSOM",
    "168D4": "BAMUM LETTER PHASE-C NTEN",
    "168D5": "BAMUM LETTER PHASE-C KUOP NKAARAE",
    "168D6": "BAMUM LETTER PHASE-C NSUN",
    "168D7": "BAMUM LETTER PHASE-C NDAM",
    "168D8": "BAMUM LETTER PHASE-C MA NSIEE",
    "168D9": "BAMUM LETTER PHASE-C YAA",
    "168DA": "BAMUM LETTER PHASE-C NDAP",
    "168DB": "BAMUM LETTER PHASE-C SHUEQ",
    "168DC": "BAMUM LETTER PHASE-C SETFON",
    "168DD": "BAMUM LETTER PHASE-C MBI",
    "168DE": "BAMUM LETTER PHASE-C MAEMBA",
    "168DF": "BAMUM LETTER PHASE-C MBANYI",
    "168E0": "BAMUM LETTER PHASE-C KEUSEUX",
    "168E1": "BAMUM LETTER PHASE-C MBEUX",
    "168E2": "BAMUM LETTER PHASE-C KEUM",
    "168E3": "BAMUM LETTER PHASE-C MBAA PICKET",
    "168E4": "BAMUM LETTER PHASE-C YUWOQ",
    "168E5": "BAMUM LETTER PHASE-C NJEUX",
    "168E6": "BAMUM LETTER PHASE-C MIEE",
    "168E7": "BAMUM LETTER PHASE-C MUAE",
    "168E8": "BAMUM LETTER PHASE-C SHIQ",
    "168E9": "BAMUM LETTER PHASE-C KEN LAW",
    "168EA": "BAMUM LETTER PHASE-C KEN FATIGUE",
    "168EB": "BAMUM LETTER PHASE-C NGAQ",
    "168EC": "BAMUM LETTER PHASE-C NAQ",
    "168ED": "BAMUM LETTER PHASE-C LIQ",
    "168EE": "BAMUM LETTER PHASE-C PIN",
    "168EF": "BAMUM LETTER PHASE-C PEN",
    "168F0": "BAMUM LETTER PHASE-C TET",
    "168F1": "BAMUM LETTER PHASE-D MBUO",
    "168F2": "BAMUM LETTER PHASE-D WAP",
    "168F3": "BAMUM LETTER PHASE-D NJI",
    "168F4": "BAMUM LETTER PHASE-D MFON",
    "168F5": "BAMUM LETTER PHASE-D NJIEE",
    "168F6": "BAMUM LETTER PHASE-D LIEE",
    "168F7": "BAMUM LETTER PHASE-D NJEUT",
    "168F8": "BAMUM LETTER PHASE-D NSHEE",
    "168F9": "BAMUM LETTER PHASE-D NGGAAMAE",
    "168FA": "BAMUM LETTER PHASE-D NYAM",
    "168FB": "BAMUM LETTER PHASE-D WUAEN",
    "168FC": "BAMUM LETTER PHASE-D NGKUN",
    "168FD": "BAMUM LETTER PHASE-D SHEE",
    "168FE": "BAMUM LETTER PHASE-D NGKAP",
    "168FF": "BAMUM LETTER PHASE-D KEUAETMEUN",
    "16900": "BAMUM LETTER PHASE-D TEUT",
    "16901": "BAMUM LETTER PHASE-D SHEUAE",
    "16902": "BAMUM LETTER PHASE-D NJAP",
    "16903": "BAMUM LETTER PHASE-D SUE",
    "16904": "BAMUM LETTER PHASE-D KET",
    "16905": "BAMUM LETTER PHASE-D YAEMMAE",
    "16906": "BAMUM LETTER PHASE-D KUOM",
    "16907": "BAMUM LETTER PHASE-D SAP",
    "16908": "BAMUM LETTER PHASE-D MFEUT",
    "16909": "BAMUM LETTER PHASE-D NDEUX",
    "1690A": "BAMUM LETTER PHASE-D MALEERI",
    "1690B": "BAMUM LETTER PHASE-D MEUT",
    "1690C": "BAMUM LETTER PHASE-D SEUAEQ",
    "1690D": "BAMUM LETTER PHASE-D YEN",
    "1690E": "BAMUM LETTER PHASE-D NJEUAEM",
    "1690F": "BAMUM LETTER PHASE-D KEUOT MBUAE",
    "16910": "BAMUM LETTER PHASE-D NGKEURI",
    "16911": "BAMUM LETTER PHASE-D TU",
    "16912": "BAMUM LETTER PHASE-D GHAA",
    "16913": "BAMUM LETTER PHASE-D NGKYEE",
    "16914": "BAMUM LETTER PHASE-D FEUFEUAET",
    "16915": "BAMUM LETTER PHASE-D NDEE",
    "16916": "BAMUM LETTER PHASE-D MGBOFUM",
    "16917": "BAMUM LETTER PHASE-D LEUAEP",
    "16918": "BAMUM LETTER PHASE-D NDON",
    "16919": "BAMUM LETTER PHASE-D MONI",
    "1691A": "BAMUM LETTER PHASE-D MGBEUN",
    "1691B": "BAMUM LETTER PHASE-D PUUT",
    "1691C": "BAMUM LETTER PHASE-D MGBIEE",
    "1691D": "BAMUM LETTER PHASE-D MFO",
    "1691E": "BAMUM LETTER PHASE-D LUM",
    "1691F": "BAMUM LETTER PHASE-D NSIEEP",
    "16920": "BAMUM LETTER PHASE-D MBAA",
    "16921": "BAMUM LETTER PHASE-D KWAET",
    "16922": "BAMUM LETTER PHASE-D NYET",
    "16923": "BAMUM LETTER PHASE-D TEUAEN",
    "16924": "BAMUM LETTER PHASE-D SOT",
    "16925": "BAMUM LETTER PHASE-D YUWOQ",
    "16926": "BAMUM LETTER PHASE-D KEUM",
    "16927": "BAMUM LETTER PHASE-D RAEM",
    "16928": "BAMUM LETTER PHASE-D TEEEE",
    "16929": "BAMUM LETTER PHASE-D NGKEUAEQ",
    "1692A": "BAMUM LETTER PHASE-D MFEUAE",
    "1692B": "BAMUM LETTER PHASE-D NSIEET",
    "1692C": "BAMUM LETTER PHASE-D KEUP",
    "1692D": "BAMUM LETTER PHASE-D PIP",
    "1692E": "BAMUM LETTER PHASE-D PEUTAE",
    "1692F": "BAMUM LETTER PHASE-D NYUE",
    "16930": "BAMUM LETTER PHASE-D LET",
    "16931": "BAMUM LETTER PHASE-D NGGAAM",
    "16932": "BAMUM LETTER PHASE-D MFIEE",
    "16933": "BAMUM LETTER PHASE-D NGGWAEN",
    "16934": "BAMUM LETTER PHASE-D YUOM",
    "16935": "BAMUM LETTER PHASE-D PAP",
    "16936": "BAMUM LETTER PHASE-D YUOP",
    "16937": "BAMUM LETTER PHASE-D NDAM",
    "16938": "BAMUM LETTER PHASE-D NTEUM",
    "16939": "BAMUM LETTER PHASE-D SUAE",
    "1693A": "BAMUM LETTER PHASE-D KUN",
    "1693B": "BAMUM LETTER PHASE-D NGGEUX",
    "1693C": "BAMUM LETTER PHASE-D NGKIEE",
    "1693D": "BAMUM LETTER PHASE-D TUOT",
    "1693E": "BAMUM LETTER PHASE-D MEUN",
    "1693F": "BAMUM LETTER PHASE-D KUQ",
    "16940": "BAMUM LETTER PHASE-D NSUM",
    "16941": "BAMUM LETTER PHASE-D TEUN",
    "16942": "BAMUM LETTER PHASE-D MAENJET",
    "16943": "BAMUM LETTER PHASE-D NGGAP",
    "16944": "BAMUM LETTER PHASE-D LEUM",
    "16945": "BAMUM LETTER PHASE-D NGGUOM",
    "16946": "BAMUM LETTER PHASE-D NSHUT",
    "16947": "BAMUM LETTER PHASE-D NJUEQ",
    "16948": "BAMUM LETTER PHASE-D GHEUAE",
    "16949": "BAMUM LETTER PHASE-D KU",
    "1694A": "BAMUM LETTER PHASE-D REN OLD",
    "1694B": "BAMUM LETTER PHASE-D TAE",
    "1694C": "BAMUM LETTER PHASE-D TOQ",
    "1694D": "BAMUM LETTER PHASE-D NYI",
    "1694E": "BAMUM LETTER PHASE-D RII",
    "1694F": "BAMUM LETTER PHASE-D LEEEE",
    "16950": "BAMUM LETTER PHASE-D MEEEE",
    "16951": "BAMUM LETTER PHASE-D M",
    "16952": "BAMUM LETTER PHASE-D SUU",
    "16953": "BAMUM LETTER PHASE-D MU",
    "16954": "BAMUM LETTER PHASE-D SHII",
    "16955": "BAMUM LETTER PHASE-D SHEUX",
    "16956": "BAMUM LETTER PHASE-D KYEE",
    "16957": "BAMUM LETTER PHASE-D NU",
    "16958": "BAMUM LETTER PHASE-D SHU",
    "16959": "BAMUM LETTER PHASE-D NTEE",
    "1695A": "BAMUM LETTER PHASE-D PEE",
    "1695B": "BAMUM LETTER PHASE-D NI",
    "1695C": "BAMUM LETTER PHASE-D SHOQ",
    "1695D": "BAMUM LETTER PHASE-D PUQ",
    "1695E": "BAMUM LETTER PHASE-D MVOP",
    "1695F": "BAMUM LETTER PHASE-D LOQ",
    "16960": "BAMUM LETTER PHASE-D REN MUCH",
    "16961": "BAMUM LETTER PHASE-D TI",
    "16962": "BAMUM LETTER PHASE-D NTUU",
    "16963": "BAMUM LETTER PHASE-D MBAA SEVEN",
    "16964": "BAMUM LETTER PHASE-D SAQ",
    "16965": "BAMUM LETTER PHASE-D FAA",
    "16966": "BAMUM LETTER PHASE-E NDAP",
    "16967": "BAMUM LETTER PHASE-E TOON",
    "16968": "BAMUM LETTER PHASE-E MBEUM",
    "16969": "BAMUM LETTER PHASE-E LAP",
    "1696A": "BAMUM LETTER PHASE-E VOM",
    "1696B": "BAMUM LETTER PHASE-E LOON",
    "1696C": "BAMUM LETTER PHASE-E PAA",
    "1696D": "BAMUM LETTER PHASE-E SOM",
    "1696E": "BAMUM LETTER PHASE-E RAQ",
    "1696F": "BAMUM LETTER PHASE-E NSHUOP",
    "16970": "BAMUM LETTER PHASE-E NDUN",
    "16971": "BAMUM LETTER PHASE-E PUAE",
    "16972": "BAMUM LETTER PHASE-E TAM",
    "16973": "BAMUM LETTER PHASE-E NGKA",
    "16974": "BAMUM LETTER PHASE-E KPEUX",
    "16975": "BAMUM LETTER PHASE-E WUO",
    "16976": "BAMUM LETTER PHASE-E SEE",
    "16977": "BAMUM LETTER PHASE-E NGGEUAET",
    "16978": "BAMUM LETTER PHASE-E PAAM",
    "16979": "BAMUM LETTER PHASE-E TOO",
    "1697A": "BAMUM LETTER PHASE-E KUOP",
    "1697B": "BAMUM LETTER PHASE-E LOM",
    "1697C": "BAMUM LETTER PHASE-E NSHIEE",
    "1697D": "BAMUM LETTER PHASE-E NGOP",
    "1697E": "BAMUM LETTER PHASE-E MAEM",
    "1697F": "BAMUM LETTER PHASE-E NGKEUX",
    "16980": "BAMUM LETTER PHASE-E NGOQ",
    "16981": "BAMUM LETTER PHASE-E NSHUE",
    "16982": "BAMUM LETTER PHASE-E RIMGBA",
    "16983": "BAMUM LETTER PHASE-E NJEUX",
    "16984": "BAMUM LETTER PHASE-E PEEM",
    "16985": "BAMUM LETTER PHASE-E SAA",
    "16986": "BAMUM LETTER PHASE-E NGGURAE",
    "16987": "BAMUM LETTER PHASE-E MGBA",
    "16988": "BAMUM LETTER PHASE-E GHEUX",
    "16989": "BAMUM LETTER PHASE-E NGKEUAEM",
    "1698A": "BAMUM LETTER PHASE-E NJAEMLI",
    "1698B": "BAMUM LETTER PHASE-E MAP",
    "1698C": "BAMUM LETTER PHASE-E LOOT",
    "1698D": "BAMUM LETTER PHASE-E NGGEEEE",
    "1698E": "BAMUM LETTER PHASE-E NDIQ",
    "1698F": "BAMUM LETTER PHASE-E TAEN NTEUM",
    "16990": "BAMUM LETTER PHASE-E SET",
    "16991": "BAMUM LETTER PHASE-E PUM",
    "16992": "BAMUM LETTER PHASE-E NDAA SOFTNESS",
    "16993": "BAMUM LETTER PHASE-E NGGUAESHAE NYAM",
    "16994": "BAMUM LETTER PHASE-E YIEE",
    "16995": "BAMUM LETTER PHASE-E GHEUN",
    "16996": "BAMUM LETTER PHASE-E TUAE",
    "16997": "BAMUM LETTER PHASE-E YEUAE",
    "16998": "BAMUM LETTER PHASE-E PO",
    "16999": "BAMUM LETTER PHASE-E TUMAE",
    "1699A": "BAMUM LETTER PHASE-E KEUAE",
    "1699B": "BAMUM LETTER PHASE-E SUAEN",
    "1699C": "BAMUM LETTER PHASE-E TEUAEQ",
    "1699D": "BAMUM LETTER PHASE-E VEUAE",
    "1699E": "BAMUM LETTER PHASE-E WEUX",
    "1699F": "BAMUM LETTER PHASE-E LAAM",
    "169A0": "BAMUM LETTER PHASE-E PU",
    "169A1": "BAMUM LETTER PHASE-E TAAQ",
    "169A2": "BAMUM LETTER PHASE-E GHAAMAE",
    "169A3": "BAMUM LETTER PHASE-E NGEUREUT",
    "169A4": "BAMUM LETTER PHASE-E SHEUAEQ",
    "169A5": "BAMUM LETTER PHASE-E MGBEN",
    "169A6": "BAMUM LETTER PHASE-E MBEE",
    "169A7": "BAMUM LETTER PHASE-E NZAQ",
    "169A8": "BAMUM LETTER PHASE-E NKOM",
    "169A9": "BAMUM LETTER PHASE-E GBET",
    "169AA": "BAMUM LETTER PHASE-E TUM",
    "169AB": "BAMUM LETTER PHASE-E KUET",
    "169AC": "BAMUM LETTER PHASE-E YAP",
    "169AD": "BAMUM LETTER PHASE-E NYI CLEAVER",
    "169AE": "BAMUM LETTER PHASE-E YIT",
    "169AF": "BAMUM LETTER PHASE-E MFEUQ",
    "169B0": "BAMUM LETTER PHASE-E NDIAQ",
    "169B1": "BAMUM LETTER PHASE-E PIEEQ",
    "169B2": "BAMUM LETTER PHASE-E YUEQ",
    "169B3": "BAMUM LETTER PHASE-E LEUAEM",
    "169B4": "BAMUM LETTER PHASE-E FUE",
    "169B5": "BAMUM LETTER PHASE-E GBEUX",
    "169B6": "BAMUM LETTER PHASE-E NGKUP",
    "169B7": "BAMUM LETTER PHASE-E KET",
    "169B8": "BAMUM LETTER PHASE-E MAE",
    "169B9": "BAMUM LETTER PHASE-E NGKAAMI",
    "169BA": "BAMUM LETTER PHASE-E GHET",
    "169BB": "BAMUM LETTER PHASE-E FA",
    "169BC": "BAMUM LETTER PHASE-E NTUM",
    "169BD": "BAMUM LETTER PHASE-E PEUT",
    "169BE": "BAMUM LETTER PHASE-E YEUM",
    "169BF": "BAMUM LETTER PHASE-E NGGEUAE",
    "169C0": "BAMUM LETTER PHASE-E NYI BETWEEN",
    "169C1": "BAMUM LETTER PHASE-E NZUQ",
    "169C2": "BAMUM LETTER PHASE-E POON",
    "169C3": "BAMUM LETTER PHASE-E MIEE",
    "169C4": "BAMUM LETTER PHASE-E FUET",
    "169C5": "BAMUM LETTER PHASE-E NAE",
    "169C6": "BAMUM LETTER PHASE-E MUAE",
    "169C7": "BAMUM LETTER PHASE-E GHEUAE",
    "169C8": "BAMUM LETTER PHASE-E FU I",
    "169C9": "BAMUM LETTER PHASE-E MVI",
    "169CA": "BAMUM LETTER PHASE-E PUAQ",
    "169CB": "BAMUM LETTER PHASE-E NGKUM",
    "169CC": "BAMUM LETTER PHASE-E KUT",
    "169CD": "BAMUM LETTER PHASE-E PIET",
    "169CE": "BAMUM LETTER PHASE-E NTAP",
    "169CF": "BAMUM LETTER PHASE-E YEUAET",
    "169D0": "BAMUM LETTER PHASE-E NGGUP",
    "169D1": "BAMUM LETTER PHASE-E PA PEOPLE",
    "169D2": "BAMUM LETTER PHASE-E FU CALL",
    "169D3": "BAMUM LETTER PHASE-E FOM",
    "169D4": "BAMUM LETTER PHASE-E NJEE",
    "169D5": "BAMUM LETTER PHASE-E A",
    "169D6": "BAMUM LETTER PHASE-E TOQ",
    "169D7": "BAMUM LETTER PHASE-E O",
    "169D8": "BAMUM LETTER PHASE-E I",
    "169D9": "BAMUM LETTER PHASE-E LAQ",
    "169DA": "BAMUM LETTER PHASE-E PA PLURAL",
    "169DB": "BAMUM LETTER PHASE-E TAA",
    "169DC": "BAMUM LETTER PHASE-E TAQ",
    "169DD": "BAMUM LETTER PHASE-E NDAA MY HOUSE",
    "169DE": "BAMUM LETTER PHASE-E SHIQ",
    "169DF": "BAMUM LETTER PHASE-E YEUX",
    "169E0": "BAMUM LETTER PHASE-E NGUAE",
    "169E1": "BAMUM LETTER PHASE-E YUAEN",
    "169E2": "BAMUM LETTER PHASE-E YOQ SWIMMING",
    "169E3": "BAMUM LETTER PHASE-E YOQ COVER",
    "169E4": "BAMUM LETTER PHASE-E YUQ",
    "169E5": "BAMUM LETTER PHASE-E YUN",
    "169E6": "BAMUM LETTER PHASE-E KEUX",
    "169E7": "BAMUM LETTER PHASE-E PEUX",
    "169E8": "BAMUM LETTER PHASE-E NJEE EPOCH",
    "169E9": "BAMUM LETTER PHASE-E PUE",
    "169EA": "BAMUM LETTER PHASE-E WUE",
    "169EB": "BAMUM LETTER PHASE-E FEE",
    "169EC": "BAMUM LETTER PHASE-E VEE",
    "169ED": "BAMUM LETTER PHASE-E LU",
    "169EE": "BAMUM LETTER PHASE-E MI",
    "169EF": "BAMUM LETTER PHASE-E REUX",
    "169F0": "BAMUM LETTER PHASE-E RAE",
    "169F1": "BAMUM LETTER PHASE-E NGUAET",
    "169F2": "BAMUM LETTER PHASE-E NGA",
    "169F3": "BAMUM LETTER PHASE-E SHO",
    "169F4": "BAMUM LETTER PHASE-E SHOQ",
    "169F5": "BAMUM LETTER PHASE-E FU REMEDY",
    "169F6": "BAMUM LETTER PHASE-E NA",
    "169F7": "BAMUM LETTER PHASE-E PI",
    "169F8": "BAMUM LETTER PHASE-E LOQ",
    "169F9": "BAMUM LETTER PHASE-E KO",
    "169FA": "BAMUM LETTER PHASE-E MEN",
    "169FB": "BAMUM LETTER PHASE-E MA",
    "169FC": "BAMUM LETTER PHASE-E MAQ",
    "169FD": "BAMUM LETTER PHASE-E TEU",
    "169FE": "BAMUM LETTER PHASE-E KI",
    "169FF": "BAMUM LETTER PHASE-E MON",
    "16A00": "BAMUM LETTER PHASE-E TEN",
    "16A01": "BAMUM LETTER PHASE-E FAQ",
    "16A02": "BAMUM LETTER PHASE-E GHOM",
    "16A03": "BAMUM LETTER PHASE-F KA",
    "16A04": "BAMUM LETTER PHASE-F U",
    "16A05": "BAMUM LETTER PHASE-F KU",
    "16A06": "BAMUM LETTER PHASE-F EE",
    "16A07": "BAMUM LETTER PHASE-F REE",
    "16A08": "BAMUM LETTER PHASE-F TAE",
    "16A09": "BAMUM LETTER PHASE-F NYI",
    "16A0A": "BAMUM LETTER PHASE-F LA",
    "16A0B": "BAMUM LETTER PHASE-F RII",
    "16A0C": "BAMUM LETTER PHASE-F RIEE",
    "16A0D": "BAMUM LETTER PHASE-F MEEEE",
    "16A0E": "BAMUM LETTER PHASE-F TAA",
    "16A0F": "BAMUM LETTER PHASE-F NDAA",
    "16A10": "BAMUM LETTER PHASE-F NJAEM",
    "16A11": "BAMUM LETTER PHASE-F M",
    "16A12": "BAMUM LETTER PHASE-F SUU",
    "16A13": "BAMUM LETTER PHASE-F SHII",
    "16A14": "BAMUM LETTER PHASE-F SI",
    "16A15": "BAMUM LETTER PHASE-F SEUX",
    "16A16": "BAMUM LETTER PHASE-F KYEE",
    "16A17": "BAMUM LETTER PHASE-F KET",
    "16A18": "BAMUM LETTER PHASE-F NUAE",
    "16A19": "BAMUM LETTER PHASE-F NU",
    "16A1A": "BAMUM LETTER PHASE-F NJUAE",
    "16A1B": "BAMUM LETTER PHASE-F YOQ",
    "16A1C": "BAMUM LETTER PHASE-F SHU",
    "16A1D": "BAMUM LETTER PHASE-F YA",
    "16A1E": "BAMUM LETTER PHASE-F NSHA",
    "16A1F": "BAMUM LETTER PHASE-F PEUX",
    "16A20": "BAMUM LETTER PHASE-F NTEE",
    "16A21": "BAMUM LETTER PHASE-F WUE",
    "16A22": "BAMUM LETTER PHASE-F PEE",
    "16A23": "BAMUM LETTER PHASE-F RU",
    "16A24": "BAMUM LETTER PHASE-F NI",
    "16A25": "BAMUM LETTER PHASE-F REUX",
    "16A26": "BAMUM LETTER PHASE-F KEN",
    "16A27": "BAMUM LETTER PHASE-F NGKWAEN",
    "16A28": "BAMUM LETTER PHASE-F NGGA",
    "16A29": "BAMUM LETTER PHASE-F SHO",
    "16A2A": "BAMUM LETTER PHASE-F PUAE",
    "16A2B": "BAMUM LETTER PHASE-F FOM",
    "16A2C": "BAMUM LETTER PHASE-F WA",
    "16A2D": "BAMUM LETTER PHASE-F LI",
    "16A2E": "BAMUM LETTER PHASE-F LOQ",
    "16A2F": "BAMUM LETTER PHASE-F KO",
    "16A30": "BAMUM LETTER PHASE-F MBEN",
    "16A31": "BAMUM LETTER PHASE-F REN",
    "16A32": "BAMUM LETTER PHASE-F MA",
    "16A33": "BAMUM LETTER PHASE-F MO",
    "16A34": "BAMUM LETTER PHASE-F MBAA",
    "16A35": "BAMUM LETTER PHASE-F TET",
    "16A36": "BAMUM LETTER PHASE-F KPA",
    "16A37": "BAMUM LETTER PHASE-F SAMBA",
    "16A38": "BAMUM LETTER PHASE-F VUEQ",
    "16A40": "MRO LETTER TA",
    "16A41": "MRO LETTER NGI",
    "16A42": "MRO LETTER YO",
    "16A43": "MRO LETTER MIM",
    "16A44": "MRO LETTER BA",
    "16A45": "MRO LETTER DA",
    "16A46": "MRO LETTER A",
    "16A47": "MRO LETTER PHI",
    "16A48": "MRO LETTER KHAI",
    "16A49": "MRO LETTER HAO",
    "16A4A": "MRO LETTER DAI",
    "16A4B": "MRO LETTER CHU",
    "16A4C": "MRO LETTER KEAAE",
    "16A4D": "MRO LETTER OL",
    "16A4E": "MRO LETTER MAEM",
    "16A4F": "MRO LETTER NIN",
    "16A50": "MRO LETTER PA",
    "16A51": "MRO LETTER OO",
    "16A52": "MRO LETTER O",
    "16A53": "MRO LETTER RO",
    "16A54": "MRO LETTER SHI",
    "16A55": "MRO LETTER THEA",
    "16A56": "MRO LETTER EA",
    "16A57": "MRO LETTER WA",
    "16A58": "MRO LETTER E",
    "16A59": "MRO LETTER KO",
    "16A5A": "MRO LETTER LAN",
    "16A5B": "MRO LETTER LA",
    "16A5C": "MRO LETTER HAI",
    "16A5D": "MRO LETTER RI",
    "16A5E": "MRO LETTER TEK",
    "16A60": "MRO DIGIT ZERO",
    "16A61": "MRO DIGIT ONE",
    "16A62": "MRO DIGIT TWO",
    "16A63": "MRO DIGIT THREE",
    "16A64": "MRO DIGIT FOUR",
    "16A65": "MRO DIGIT FIVE",
    "16A66": "MRO DIGIT SIX",
    "16A67": "MRO DIGIT SEVEN",
    "16A68": "MRO DIGIT EIGHT",
    "16A69": "MRO DIGIT NINE",
    "16A6E": "MRO DANDA",
    "16A6F": "MRO DOUBLE DANDA",
    "16AD0": "BASSA VAH LETTER ENNI",
    "16AD1": "BASSA VAH LETTER KA",
    "16AD2": "BASSA VAH LETTER SE",
    "16AD3": "BASSA VAH LETTER FA",
    "16AD4": "BASSA VAH LETTER MBE",
    "16AD5": "BASSA VAH LETTER YIE",
    "16AD6": "BASSA VAH LETTER GAH",
    "16AD7": "BASSA VAH LETTER DHII",
    "16AD8": "BASSA VAH LETTER KPAH",
    "16AD9": "BASSA VAH LETTER JO",
    "16ADA": "BASSA VAH LETTER HWAH",
    "16ADB": "BASSA VAH LETTER WA",
    "16ADC": "BASSA VAH LETTER ZO",
    "16ADD": "BASSA VAH LETTER GBU",
    "16ADE": "BASSA VAH LETTER DO",
    "16ADF": "BASSA VAH LETTER CE",
    "16AE0": "BASSA VAH LETTER UWU",
    "16AE1": "BASSA VAH LETTER TO",
    "16AE2": "BASSA VAH LETTER BA",
    "16AE3": "BASSA VAH LETTER VU",
    "16AE4": "BASSA VAH LETTER YEIN",
    "16AE5": "BASSA VAH LETTER PA",
    "16AE6": "BASSA VAH LETTER WADDA",
    "16AE7": "BASSA VAH LETTER A",
    "16AE8": "BASSA VAH LETTER O",
    "16AE9": "BASSA VAH LETTER OO",
    "16AEA": "BASSA VAH LETTER U",
    "16AEB": "BASSA VAH LETTER EE",
    "16AEC": "BASSA VAH LETTER E",
    "16AED": "BASSA VAH LETTER I",
    "16AF0": "BASSA VAH COMBINING HIGH TONE",
    "16AF1": "BASSA VAH COMBINING LOW TONE",
    "16AF2": "BASSA VAH COMBINING MID TONE",
    "16AF3": "BASSA VAH COMBINING LOW-MID TONE",
    "16AF4": "BASSA VAH COMBINING HIGH-LOW TONE",
    "16AF5": "BASSA VAH FULL STOP",
    "16B00": "PAHAWH HMONG VOWEL KEEB",
    "16B01": "PAHAWH HMONG VOWEL KEEV",
    "16B02": "PAHAWH HMONG VOWEL KIB",
    "16B03": "PAHAWH HMONG VOWEL KIV",
    "16B04": "PAHAWH HMONG VOWEL KAUB",
    "16B05": "PAHAWH HMONG VOWEL KAUV",
    "16B06": "PAHAWH HMONG VOWEL KUB",
    "16B07": "PAHAWH HMONG VOWEL KUV",
    "16B08": "PAHAWH HMONG VOWEL KEB",
    "16B09": "PAHAWH HMONG VOWEL KEV",
    "16B0A": "PAHAWH HMONG VOWEL KAIB",
    "16B0B": "PAHAWH HMONG VOWEL KAIV",
    "16B0C": "PAHAWH HMONG VOWEL KOOB",
    "16B0D": "PAHAWH HMONG VOWEL KOOV",
    "16B0E": "PAHAWH HMONG VOWEL KAWB",
    "16B0F": "PAHAWH HMONG VOWEL KAWV",
    "16B10": "PAHAWH HMONG VOWEL KUAB",
    "16B11": "PAHAWH HMONG VOWEL KUAV",
    "16B12": "PAHAWH HMONG VOWEL KOB",
    "16B13": "PAHAWH HMONG VOWEL KOV",
    "16B14": "PAHAWH HMONG VOWEL KIAB",
    "16B15": "PAHAWH HMONG VOWEL KIAV",
    "16B16": "PAHAWH HMONG VOWEL KAB",
    "16B17": "PAHAWH HMONG VOWEL KAV",
    "16B18": "PAHAWH HMONG VOWEL KWB",
    "16B19": "PAHAWH HMONG VOWEL KWV",
    "16B1A": "PAHAWH HMONG VOWEL KAAB",
    "16B1B": "PAHAWH HMONG VOWEL KAAV",
    "16B1C": "PAHAWH HMONG CONSONANT VAU",
    "16B1D": "PAHAWH HMONG CONSONANT NTSAU",
    "16B1E": "PAHAWH HMONG CONSONANT LAU",
    "16B1F": "PAHAWH HMONG CONSONANT HAU",
    "16B20": "PAHAWH HMONG CONSONANT NLAU",
    "16B21": "PAHAWH HMONG CONSONANT RAU",
    "16B22": "PAHAWH HMONG CONSONANT NKAU",
    "16B23": "PAHAWH HMONG CONSONANT QHAU",
    "16B24": "PAHAWH HMONG CONSONANT YAU",
    "16B25": "PAHAWH HMONG CONSONANT HLAU",
    "16B26": "PAHAWH HMONG CONSONANT MAU",
    "16B27": "PAHAWH HMONG CONSONANT CHAU",
    "16B28": "PAHAWH HMONG CONSONANT NCHAU",
    "16B29": "PAHAWH HMONG CONSONANT HNAU",
    "16B2A": "PAHAWH HMONG CONSONANT PLHAU",
    "16B2B": "PAHAWH HMONG CONSONANT NTHAU",
    "16B2C": "PAHAWH HMONG CONSONANT NAU",
    "16B2D": "PAHAWH HMONG CONSONANT AU",
    "16B2E": "PAHAWH HMONG CONSONANT XAU",
    "16B2F": "PAHAWH HMONG CONSONANT CAU",
    "16B30": "PAHAWH HMONG MARK CIM TUB",
    "16B31": "PAHAWH HMONG MARK CIM SO",
    "16B32": "PAHAWH HMONG MARK CIM KES",
    "16B33": "PAHAWH HMONG MARK CIM KHAV",
    "16B34": "PAHAWH HMONG MARK CIM SUAM",
    "16B35": "PAHAWH HMONG MARK CIM HOM",
    "16B36": "PAHAWH HMONG MARK CIM TAUM",
    "16B37": "PAHAWH HMONG SIGN VOS THOM",
    "16B38": "PAHAWH HMONG SIGN VOS TSHAB CEEB",
    "16B39": "PAHAWH HMONG SIGN CIM CHEEM",
    "16B3A": "PAHAWH HMONG SIGN VOS THIAB",
    "16B3B": "PAHAWH HMONG SIGN VOS FEEM",
    "16B3C": "PAHAWH HMONG SIGN XYEEM NTXIV",
    "16B3D": "PAHAWH HMONG SIGN XYEEM RHO",
    "16B3E": "PAHAWH HMONG SIGN XYEEM TOV",
    "16B3F": "PAHAWH HMONG SIGN XYEEM FAIB",
    "16B40": "PAHAWH HMONG SIGN VOS SEEV",
    "16B41": "PAHAWH HMONG SIGN MEEJ SUAB",
    "16B42": "PAHAWH HMONG SIGN VOS NRUA",
    "16B43": "PAHAWH HMONG SIGN IB YAM",
    "16B44": "PAHAWH HMONG SIGN XAUS",
    "16B45": "PAHAWH HMONG SIGN CIM TSOV ROG",
    "16B50": "PAHAWH HMONG DIGIT ZERO",
    "16B51": "PAHAWH HMONG DIGIT ONE",
    "16B52": "PAHAWH HMONG DIGIT TWO",
    "16B53": "PAHAWH HMONG DIGIT THREE",
    "16B54": "PAHAWH HMONG DIGIT FOUR",
    "16B55": "PAHAWH HMONG DIGIT FIVE",
    "16B56": "PAHAWH HMONG DIGIT SIX",
    "16B57": "PAHAWH HMONG DIGIT SEVEN",
    "16B58": "PAHAWH HMONG DIGIT EIGHT",
    "16B59": "PAHAWH HMONG DIGIT NINE",
    "16B5B": "PAHAWH HMONG NUMBER TENS",
    "16B5C": "PAHAWH HMONG NUMBER HUNDREDS",
    "16B5D": "PAHAWH HMONG NUMBER TEN THOUSANDS",
    "16B5E": "PAHAWH HMONG NUMBER MILLIONS",
    "16B5F": "PAHAWH HMONG NUMBER HUNDRED MILLIONS",
    "16B60": "PAHAWH HMONG NUMBER TEN BILLIONS",
    "16B61": "PAHAWH HMONG NUMBER TRILLIONS",
    "16B63": "PAHAWH HMONG SIGN VOS LUB",
    "16B64": "PAHAWH HMONG SIGN XYOO",
    "16B65": "PAHAWH HMONG SIGN HLI",
    "16B66": "PAHAWH HMONG SIGN THIRD-STAGE HLI",
    "16B67": "PAHAWH HMONG SIGN ZWJ THAJ",
    "16B68": "PAHAWH HMONG SIGN HNUB",
    "16B69": "PAHAWH HMONG SIGN NQIG",
    "16B6A": "PAHAWH HMONG SIGN XIAB",
    "16B6B": "PAHAWH HMONG SIGN NTUJ",
    "16B6C": "PAHAWH HMONG SIGN AV",
    "16B6D": "PAHAWH HMONG SIGN TXHEEJ CEEV",
    "16B6E": "PAHAWH HMONG SIGN MEEJ TSEEB",
    "16B6F": "PAHAWH HMONG SIGN TAU",
    "16B70": "PAHAWH HMONG SIGN LOS",
    "16B71": "PAHAWH HMONG SIGN MUS",
    "16B72": "PAHAWH HMONG SIGN CIM HAIS LUS NTOG NTOG",
    "16B73": "PAHAWH HMONG SIGN CIM CUAM TSHOOJ",
    "16B74": "PAHAWH HMONG SIGN CIM TXWV",
    "16B75": "PAHAWH HMONG SIGN CIM TXWV CHWV",
    "16B76": "PAHAWH HMONG SIGN CIM PUB DAWB",
    "16B77": "PAHAWH HMONG SIGN CIM NRES TOS",
    "16B7D": "PAHAWH HMONG CLAN SIGN TSHEEJ",
    "16B7E": "PAHAWH HMONG CLAN SIGN YEEG",
    "16B7F": "PAHAWH HMONG CLAN SIGN LIS",
    "16B80": "PAHAWH HMONG CLAN SIGN LAUJ",
    "16B81": "PAHAWH HMONG CLAN SIGN XYOOJ",
    "16B82": "PAHAWH HMONG CLAN SIGN KOO",
    "16B83": "PAHAWH HMONG CLAN SIGN HAWJ",
    "16B84": "PAHAWH HMONG CLAN SIGN MUAS",
    "16B85": "PAHAWH HMONG CLAN SIGN THOJ",
    "16B86": "PAHAWH HMONG CLAN SIGN TSAB",
    "16B87": "PAHAWH HMONG CLAN SIGN PHAB",
    "16B88": "PAHAWH HMONG CLAN SIGN KHAB",
    "16B89": "PAHAWH HMONG CLAN SIGN HAM",
    "16B8A": "PAHAWH HMONG CLAN SIGN VAJ",
    "16B8B": "PAHAWH HMONG CLAN SIGN FAJ",
    "16B8C": "PAHAWH HMONG CLAN SIGN YAJ",
    "16B8D": "PAHAWH HMONG CLAN SIGN TSWB",
    "16B8E": "PAHAWH HMONG CLAN SIGN KWM",
    "16B8F": "PAHAWH HMONG CLAN SIGN VWJ",
    "16F00": "MIAO LETTER PA",
    "16F01": "MIAO LETTER BA",
    "16F02": "MIAO LETTER YI PA",
    "16F03": "MIAO LETTER PLA",
    "16F04": "MIAO LETTER MA",
    "16F05": "MIAO LETTER MHA",
    "16F06": "MIAO LETTER ARCHAIC MA",
    "16F07": "MIAO LETTER FA",
    "16F08": "MIAO LETTER VA",
    "16F09": "MIAO LETTER VFA",
    "16F0A": "MIAO LETTER TA",
    "16F0B": "MIAO LETTER DA",
    "16F0C": "MIAO LETTER YI TTA",
    "16F0D": "MIAO LETTER YI TA",
    "16F0E": "MIAO LETTER TTA",
    "16F0F": "MIAO LETTER DDA",
    "16F10": "MIAO LETTER NA",
    "16F11": "MIAO LETTER NHA",
    "16F12": "MIAO LETTER YI NNA",
    "16F13": "MIAO LETTER ARCHAIC NA",
    "16F14": "MIAO LETTER NNA",
    "16F15": "MIAO LETTER NNHA",
    "16F16": "MIAO LETTER LA",
    "16F17": "MIAO LETTER LYA",
    "16F18": "MIAO LETTER LHA",
    "16F19": "MIAO LETTER LHYA",
    "16F1A": "MIAO LETTER TLHA",
    "16F1B": "MIAO LETTER DLHA",
    "16F1C": "MIAO LETTER TLHYA",
    "16F1D": "MIAO LETTER DLHYA",
    "16F1E": "MIAO LETTER KA",
    "16F1F": "MIAO LETTER GA",
    "16F20": "MIAO LETTER YI KA",
    "16F21": "MIAO LETTER QA",
    "16F22": "MIAO LETTER QGA",
    "16F23": "MIAO LETTER NGA",
    "16F24": "MIAO LETTER NGHA",
    "16F25": "MIAO LETTER ARCHAIC NGA",
    "16F26": "MIAO LETTER HA",
    "16F27": "MIAO LETTER XA",
    "16F28": "MIAO LETTER GHA",
    "16F29": "MIAO LETTER GHHA",
    "16F2A": "MIAO LETTER TSSA",
    "16F2B": "MIAO LETTER DZZA",
    "16F2C": "MIAO LETTER NYA",
    "16F2D": "MIAO LETTER NYHA",
    "16F2E": "MIAO LETTER TSHA",
    "16F2F": "MIAO LETTER DZHA",
    "16F30": "MIAO LETTER YI TSHA",
    "16F31": "MIAO LETTER YI DZHA",
    "16F32": "MIAO LETTER REFORMED TSHA",
    "16F33": "MIAO LETTER SHA",
    "16F34": "MIAO LETTER SSA",
    "16F35": "MIAO LETTER ZHA",
    "16F36": "MIAO LETTER ZSHA",
    "16F37": "MIAO LETTER TSA",
    "16F38": "MIAO LETTER DZA",
    "16F39": "MIAO LETTER YI TSA",
    "16F3A": "MIAO LETTER SA",
    "16F3B": "MIAO LETTER ZA",
    "16F3C": "MIAO LETTER ZSA",
    "16F3D": "MIAO LETTER ZZA",
    "16F3E": "MIAO LETTER ZZSA",
    "16F3F": "MIAO LETTER ARCHAIC ZZA",
    "16F40": "MIAO LETTER ZZYA",
    "16F41": "MIAO LETTER ZZSYA",
    "16F42": "MIAO LETTER WA",
    "16F43": "MIAO LETTER AH",
    "16F44": "MIAO LETTER HHA",
    "16F50": "MIAO LETTER NASALIZATION",
    "16F51": "MIAO SIGN ASPIRATION",
    "16F52": "MIAO SIGN REFORMED VOICING",
    "16F53": "MIAO SIGN REFORMED ASPIRATION",
    "16F54": "MIAO VOWEL SIGN A",
    "16F55": "MIAO VOWEL SIGN AA",
    "16F56": "MIAO VOWEL SIGN AHH",
    "16F57": "MIAO VOWEL SIGN AN",
    "16F58": "MIAO VOWEL SIGN ANG",
    "16F59": "MIAO VOWEL SIGN O",
    "16F5A": "MIAO VOWEL SIGN OO",
    "16F5B": "MIAO VOWEL SIGN WO",
    "16F5C": "MIAO VOWEL SIGN W",
    "16F5D": "MIAO VOWEL SIGN E",
    "16F5E": "MIAO VOWEL SIGN EN",
    "16F5F": "MIAO VOWEL SIGN ENG",
    "16F60": "MIAO VOWEL SIGN OEY",
    "16F61": "MIAO VOWEL SIGN I",
    "16F62": "MIAO VOWEL SIGN IA",
    "16F63": "MIAO VOWEL SIGN IAN",
    "16F64": "MIAO VOWEL SIGN IANG",
    "16F65": "MIAO VOWEL SIGN IO",
    "16F66": "MIAO VOWEL SIGN IE",
    "16F67": "MIAO VOWEL SIGN II",
    "16F68": "MIAO VOWEL SIGN IU",
    "16F69": "MIAO VOWEL SIGN ING",
    "16F6A": "MIAO VOWEL SIGN U",
    "16F6B": "MIAO VOWEL SIGN UA",
    "16F6C": "MIAO VOWEL SIGN UAN",
    "16F6D": "MIAO VOWEL SIGN UANG",
    "16F6E": "MIAO VOWEL SIGN UU",
    "16F6F": "MIAO VOWEL SIGN UEI",
    "16F70": "MIAO VOWEL SIGN UNG",
    "16F71": "MIAO VOWEL SIGN Y",
    "16F72": "MIAO VOWEL SIGN YI",
    "16F73": "MIAO VOWEL SIGN AE",
    "16F74": "MIAO VOWEL SIGN AEE",
    "16F75": "MIAO VOWEL SIGN ERR",
    "16F76": "MIAO VOWEL SIGN ROUNDED ERR",
    "16F77": "MIAO VOWEL SIGN ER",
    "16F78": "MIAO VOWEL SIGN ROUNDED ER",
    "16F79": "MIAO VOWEL SIGN AI",
    "16F7A": "MIAO VOWEL SIGN EI",
    "16F7B": "MIAO VOWEL SIGN AU",
    "16F7C": "MIAO VOWEL SIGN OU",
    "16F7D": "MIAO VOWEL SIGN N",
    "16F7E": "MIAO VOWEL SIGN NG",
    "16F8F": "MIAO TONE RIGHT",
    "16F90": "MIAO TONE TOP RIGHT",
    "16F91": "MIAO TONE ABOVE",
    "16F92": "MIAO TONE BELOW",
    "16F93": "MIAO LETTER TONE-2",
    "16F94": "MIAO LETTER TONE-3",
    "16F95": "MIAO LETTER TONE-4",
    "16F96": "MIAO LETTER TONE-5",
    "16F97": "MIAO LETTER TONE-6",
    "16F98": "MIAO LETTER TONE-7",
    "16F99": "MIAO LETTER TONE-8",
    "16F9A": "MIAO LETTER REFORMED TONE-1",
    "16F9B": "MIAO LETTER REFORMED TONE-2",
    "16F9C": "MIAO LETTER REFORMED TONE-4",
    "16F9D": "MIAO LETTER REFORMED TONE-5",
    "16F9E": "MIAO LETTER REFORMED TONE-6",
    "16F9F": "MIAO LETTER REFORMED TONE-8",
    "16FE0": "TANGUT ITERATION MARK",
    # "17000": "<Tangut Ideograph, First>", */
    # "187EC": "<Tangut Ideograph, Last>", */
    "18800": "TANGUT COMPONENT-001",
    "18801": "TANGUT COMPONENT-002",
    "18802": "TANGUT COMPONENT-003",
    "18803": "TANGUT COMPONENT-004",
    "18804": "TANGUT COMPONENT-005",
    "18805": "TANGUT COMPONENT-006",
    "18806": "TANGUT COMPONENT-007",
    "18807": "TANGUT COMPONENT-008",
    "18808": "TANGUT COMPONENT-009",
    "18809": "TANGUT COMPONENT-010",
    "1880A": "TANGUT COMPONENT-011",
    "1880B": "TANGUT COMPONENT-012",
    "1880C": "TANGUT COMPONENT-013",
    "1880D": "TANGUT COMPONENT-014",
    "1880E": "TANGUT COMPONENT-015",
    "1880F": "TANGUT COMPONENT-016",
    "18810": "TANGUT COMPONENT-017",
    "18811": "TANGUT CO