/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.measure.Calibration;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.FolderOpener;
import ij.plugin.Raw;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.io.File;
import java.util.Properties;

public class ImportDialog {
    private String fileName;
    private String directory;
    static final String TYPE = "raw.type";
    static final String WIDTH = "raw.width";
    static final String HEIGHT = "raw.height";
    static final String OFFSET = "raw.offset";
    static final String N = "raw.n";
    static final String GAP = "raw.gap";
    static final String OPTIONS = "raw.options";
    static final int WHITE_IS_ZERO = 1;
    static final int INTEL_BYTE_ORDER = 2;
    static final int OPEN_ALL = 4;
    private static int sChoiceSelection = Prefs.getInt("raw.type", 0);
    private static int sWidth = Prefs.getInt("raw.width", 512);
    private static int sHeight = Prefs.getInt("raw.height", 512);
    private static long sOffset = Prefs.getInt("raw.offset", 0);
    private static int sNImages = Prefs.getInt("raw.n", 1);
    private static long sGapBetweenImages = Prefs.getInt("raw.gap", 0);
    private static boolean sWhiteIsZero;
    private static boolean sIntelByteOrder;
    private static boolean sVirtual;
    private int choiceSelection = sChoiceSelection;
    private int width = sWidth;
    private int height = sHeight;
    private long offset = sOffset;
    private int nImages = sNImages;
    private long gapBetweenImages = sGapBetweenImages;
    private boolean whiteIsZero = sWhiteIsZero;
    private boolean intelByteOrder = sIntelByteOrder;
    private boolean virtual = sVirtual;
    private static int options;
    private static FileInfo lastFileInfo;
    private boolean openAll;
    private static String[] types;

    public ImportDialog(String fileName, String directory) {
        this.fileName = fileName;
        this.directory = directory;
        IJ.showStatus("Importing: " + fileName);
    }

    public ImportDialog() {
    }

    boolean showDialog() {
        boolean macro;
        boolean bl = macro = Macro.getOptions() != null;
        if (macro) {
            this.height = 512;
            this.width = 512;
            this.gapBetweenImages = 0L;
            this.offset = 0L;
            this.nImages = 1;
            this.virtual = false;
            this.intelByteOrder = false;
            this.whiteIsZero = false;
        }
        if (this.choiceSelection >= types.length) {
            this.choiceSelection = 0;
        }
        this.getDimensionsFromName(this.fileName);
        GenericDialog gd = new GenericDialog("Import>Raw...");
        gd.addChoice("Image type:", types, types[this.choiceSelection]);
        gd.addNumericField("Width:", this.width, 0, 8, "pixels");
        gd.addNumericField("Height:", this.height, 0, 8, "pixels");
        gd.addNumericField("Offset to first image:", this.offset, 0, 8, "bytes");
        gd.addNumericField("Number of images:", this.nImages, 0, 8, null);
        gd.addNumericField("Gap between images:", this.gapBetweenImages, 0, 8, "bytes");
        gd.addCheckbox("White is zero", this.whiteIsZero);
        gd.addCheckbox("Little-endian byte order", this.intelByteOrder);
        gd.addCheckbox("Open all files in folder", this.openAll);
        gd.addCheckbox("Use virtual stack", this.virtual);
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/file.html#raw");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.choiceSelection = gd.getNextChoiceIndex();
        this.width = (int)gd.getNextNumber();
        this.height = (int)gd.getNextNumber();
        gd.setSmartRecording(this.offset == 0L);
        this.offset = (long)gd.getNextNumber();
        gd.setSmartRecording(this.nImages == 1);
        this.nImages = (int)gd.getNextNumber();
        gd.setSmartRecording(this.gapBetweenImages == 0L);
        this.gapBetweenImages = (long)gd.getNextNumber();
        gd.setSmartRecording(false);
        this.whiteIsZero = gd.getNextBoolean();
        this.intelByteOrder = gd.getNextBoolean();
        this.openAll = gd.getNextBoolean();
        this.virtual = gd.getNextBoolean();
        IJ.register(ImportDialog.class);
        if (!macro) {
            sChoiceSelection = this.choiceSelection;
            sWidth = this.width;
            sHeight = this.height;
            sOffset = this.offset;
            sNImages = this.nImages;
            sGapBetweenImages = this.gapBetweenImages;
            sWhiteIsZero = this.whiteIsZero;
            sIntelByteOrder = this.intelByteOrder;
            sVirtual = this.virtual;
        }
        return true;
    }

    void openAll(String[] list, FileInfo fi) {
        FolderOpener fo = new FolderOpener();
        list = fo.trimFileList(list);
        if ((list = fo.sortFileList(list)) == null) {
            return;
        }
        ImageStack stack = null;
        ImagePlus imp = null;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int digits = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].startsWith(".")) continue;
            fi.fileName = list[i];
            imp = new FileOpener(fi).openImage();
            if (imp == null) {
                IJ.log(list[i] + ": unable to open");
                continue;
            }
            if (stack == null) {
                stack = imp.createEmptyStack();
            }
            try {
                ImageStack stack2 = imp.getStack();
                int slices = stack2.getSize();
                if (digits == 0) {
                    digits = 2;
                    if (slices > 99) {
                        digits = 3;
                    }
                    if (slices > 999) {
                        digits = 4;
                    }
                    if (slices > 9999) {
                        digits = 5;
                    }
                }
                for (int n = 1; n <= slices; ++n) {
                    ImageProcessor ip = stack2.getProcessor(n);
                    if (ip.getMin() < min) {
                        min = ip.getMin();
                    }
                    if (ip.getMax() > max) {
                        max = ip.getMax();
                    }
                    String label = list[i];
                    if (slices > 1) {
                        label = label + "-" + IJ.pad(n, digits);
                    }
                    stack.addSlice(label, ip);
                }
            }
            catch (OutOfMemoryError e) {
                IJ.outOfMemory("OpenAll");
                stack.trim();
                break;
            }
            IJ.showStatus(stack.getSize() + 1 + ": " + list[i]);
        }
        Recorder.recordCall(fi.getCode() + "imp = Raw.openAll(\"" + fi.directory + "\", fi);");
        if (stack != null) {
            imp = new ImagePlus("Imported Stack", stack);
            if (imp.getBitDepth() == 16 || imp.getBitDepth() == 32) {
                imp.getProcessor().setMinAndMax(min, max);
            }
            Calibration cal = imp.getCalibration();
            if (fi.fileType == 1) {
                cal.setSigned16BitCalibration();
            }
            imp.show();
        }
    }

    public void openImage() {
        FileInfo fi = this.getFileInfo();
        if (fi == null) {
            return;
        }
        if (this.openAll) {
            if (this.virtual) {
                ImagePlus imp = Raw.openAllVirtual(this.directory, fi);
                Recorder.recordCall(fi.getCode() + "imp = Raw.openAllVirtual(\"" + this.directory + "\", fi);");
                if (imp != null) {
                    imp.setSlice(imp.getStackSize() / 2);
                    imp.show();
                    imp.setSlice(1);
                }
                return;
            }
            String[] list = new File(this.directory).list();
            if (list == null) {
                return;
            }
            this.openAll(list, fi);
        } else if (this.virtual) {
            new FileInfoVirtualStack(fi);
        } else {
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.openImage();
            String filePath = fi.directory + fi.fileName;
            Recorder.recordCall(fi.getCode() + "imp = Raw.open(\"" + filePath + "\", fi);");
            if (imp != null) {
                imp.show();
                int n = imp.getStackSize();
                if (n > 1) {
                    imp.setSlice(n / 2);
                    ImageProcessor ip = imp.getProcessor();
                    ip.resetMinAndMax();
                    imp.setDisplayRange(ip.getMin(), ip.getMax());
                }
            } else {
                IJ.error("File>Import>Raw", "File not found: " + filePath);
            }
        }
    }

    public FileInfo getFileInfo() {
        if (!this.showDialog()) {
            return null;
        }
        String imageType = types[this.choiceSelection];
        FileInfo fi = new FileInfo();
        fi.fileFormat = 1;
        fi.fileName = this.fileName;
        if (!this.directory.endsWith(File.separator) && !this.directory.endsWith("/")) {
            this.directory = this.directory + "/";
        }
        fi.directory = this.directory;
        fi.width = this.width;
        fi.height = this.height;
        if (this.offset > Integer.MAX_VALUE) {
            fi.longOffset = this.offset;
        } else {
            fi.offset = (int)this.offset;
        }
        fi.nImages = this.nImages;
        fi.gapBetweenImages = (int)this.gapBetweenImages;
        fi.longGap = this.gapBetweenImages;
        fi.intelByteOrder = this.intelByteOrder;
        fi.whiteIsZero = this.whiteIsZero;
        fi.fileType = imageType.equals("8-bit") ? 0 : (imageType.equals("16-bit Signed") ? 1 : (imageType.equals("16-bit Unsigned") ? 2 : (imageType.equals("32-bit Signed") ? 3 : (imageType.equals("32-bit Unsigned") ? 11 : (imageType.equals("32-bit Real") ? 4 : (imageType.equals("64-bit Real") ? 16 : (imageType.equals("24-bit RGB") ? 6 : (imageType.equals("24-bit RGB Planar") ? 7 : (imageType.equals("24-bit BGR") ? 10 : (imageType.equals("24-bit Integer") ? 14 : (imageType.equals("32-bit ARGB") ? 9 : (imageType.equals("32-bit ABGR") ? 18 : (imageType.equals("1-bit Bitmap") ? 8 : 0)))))))))))));
        if (IJ.debugMode) {
            IJ.log("ImportDialog: " + fi);
        }
        lastFileInfo = (FileInfo)fi.clone();
        return fi;
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(TYPE, Integer.toString(sChoiceSelection));
        prefs.put(WIDTH, Integer.toString(sWidth));
        prefs.put(HEIGHT, Integer.toString(sHeight));
        prefs.put(OFFSET, Integer.toString(sOffset > Integer.MAX_VALUE ? 0 : (int)sOffset));
        prefs.put(N, Integer.toString(sNImages));
        prefs.put(GAP, Integer.toString(sGapBetweenImages > Integer.MAX_VALUE ? 0 : (int)sGapBetweenImages));
        int options = 0;
        if (sWhiteIsZero) {
            options |= 1;
        }
        if (sIntelByteOrder) {
            options |= 2;
        }
        prefs.put(OPTIONS, Integer.toString(options));
    }

    public static FileInfo getLastFileInfo() {
        return lastFileInfo;
    }

    private void getDimensionsFromName(String name) {
        int d;
        if (name == null) {
            return;
        }
        if (!name.matches(".*[0-9]+x[0-9]+.*")) {
            return;
        }
        int lastUnderscore = name.lastIndexOf("_");
        String name2 = name;
        if (lastUnderscore >= 0) {
            name2 = name.substring(lastUnderscore);
        }
        char[] chars = new char[name2.length()];
        for (int i = 0; i < name2.length(); ++i) {
            chars[i] = Character.isDigit(name2.charAt(i)) ? (int)name2.charAt(i) : 32;
        }
        name2 = new String(chars);
        String[] numbers = Tools.split(name2);
        int n = numbers.length;
        if (n < 2) {
            return;
        }
        int w = (int)Tools.parseDouble(numbers[0], 0.0);
        if (w < 1) {
            return;
        }
        int h = (int)Tools.parseDouble(numbers[1], 0.0);
        if (h < 1) {
            return;
        }
        this.width = w;
        this.height = h;
        this.nImages = 1;
        if (n > 2 && (d = (int)Tools.parseDouble(numbers[2], 0.0)) > 0) {
            this.nImages = d;
        }
        this.guessFormat(this.directory, name);
    }

    private void guessFormat(String dir, String name) {
        if (dir == null) {
            return;
        }
        File file = new File(dir + name);
        long imageSize = (long)this.width * (long)this.height * (long)this.nImages;
        long fileSize = file.length();
        if (fileSize == 4L * imageSize) {
            this.choiceSelection = 5;
        } else if (fileSize == 2L * imageSize) {
            this.choiceSelection = 2;
        } else if (fileSize == 3L * imageSize) {
            this.choiceSelection = 7;
        } else if (fileSize == imageSize) {
            this.choiceSelection = 0;
        }
        if (name.endsWith("be.raw")) {
            this.intelByteOrder = false;
        } else if (name.endsWith("le.raw")) {
            this.intelByteOrder = true;
        }
    }

    static {
        types = new String[]{"8-bit", "16-bit Signed", "16-bit Unsigned", "32-bit Signed", "32-bit Unsigned", "32-bit Real", "64-bit Real", "24-bit RGB", "24-bit RGB Planar", "24-bit BGR", "24-bit Integer", "32-bit ARGB", "32-bit ABGR", "1-bit Bitmap"};
        options = Prefs.getInt(OPTIONS, 0);
        sWhiteIsZero = (options & 1) != 0;
        sIntelByteOrder = (options & 2) != 0;
    }
}

