/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileSaver;
import ij.io.Opener;
import java.util.Hashtable;
import java.util.Locale;

public class Macro {
    public static final String MACRO_CANCELED = "Macro canceled";
    private static Hashtable table = new Hashtable();
    static boolean abort;

    public static boolean open(String path) {
        if (path == null || path.equals("")) {
            Opener o = new Opener();
            return true;
        }
        Opener o = new Opener();
        ImagePlus img = o.openImage(path);
        if (img == null) {
            return false;
        }
        img.show();
        return true;
    }

    public static boolean saveAs(String path) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            return false;
        }
        FileSaver fs = new FileSaver(imp);
        if (path == null || path.equals("")) {
            return fs.saveAsTiff();
        }
        if (imp.getStackSize() > 1) {
            return fs.saveAsTiffStack(path);
        }
        return fs.saveAsTiff(path);
    }

    public static String getName(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            return path.substring(i + 1);
        }
        return path;
    }

    public static String getDir(String path) {
        int i = path.lastIndexOf(47);
        if (i == -1) {
            i = path.lastIndexOf(92);
        }
        if (i > 0) {
            return path.substring(0, i + 1);
        }
        return "";
    }

    public static void abort() {
        abort = true;
        if (Thread.currentThread().getName().endsWith("Macro$")) {
            table.remove(Thread.currentThread());
            throw new RuntimeException(MACRO_CANCELED);
        }
    }

    public static String getOptions() {
        String threadName = Thread.currentThread().getName();
        if (threadName.startsWith("Run$_") || threadName.startsWith("RMI TCP")) {
            Object options = table.get(Thread.currentThread());
            return options == null ? null : options + " ";
        }
        return null;
    }

    public static void setOptions(String options) {
        if (options == null || options.equals("")) {
            table.remove(Thread.currentThread());
        } else {
            table.put(Thread.currentThread(), options);
        }
    }

    public static void setOptions(Thread thread, String options) {
        if (null == thread) {
            throw new RuntimeException("Need a non-null thread instance");
        }
        if (null == options) {
            table.remove(thread);
        } else {
            table.put(thread, options);
        }
    }

    public static String getValue(String options, String key, String defaultValue) {
        key = Macro.trimKey(key);
        if (!options.endsWith(" ")) {
            options = options + " ";
        }
        key = key + '=';
        int index = -1;
        do {
            ++index;
            if ((index = options.indexOf(key, index)) >= 0) continue;
            return defaultValue;
        } while (index != 0 && Character.isLetter(options.charAt(index - 1)));
        if ((options = options.substring(index + key.length(), options.length())).charAt(0) == '\'') {
            index = options.indexOf("'", 1);
            if (index < 0) {
                return defaultValue;
            }
            return options.substring(1, index);
        }
        if (options.charAt(0) == '[') {
            int count = 1;
            index = -1;
            for (int i = 1; i < options.length(); ++i) {
                char ch = options.charAt(i);
                if (ch == '[') {
                    ++count;
                } else if (ch == ']') {
                    --count;
                }
                if (count != 0) continue;
                index = i;
                break;
            }
            if (index < 0) {
                return defaultValue;
            }
            return options.substring(1, index);
        }
        index = options.indexOf(" ");
        if (index < 0) {
            return defaultValue;
        }
        return options.substring(0, index);
    }

    public static String trimKey(String key) {
        int index = key.indexOf(" ");
        if (index > -1) {
            key = key.substring(0, index);
        }
        if ((index = key.indexOf(":")) > -1) {
            key = key.substring(0, index);
        }
        key = key.toLowerCase(Locale.US);
        return key;
    }
}

