from .config import *

def hes2raman(hesfile, datfile):
    """
    This function writes a raman calculation input file using a previously
    run hessian input file and the dat file generated by the calculation.

    Parameters
    ----------
    hesfile: string
        This should be a string that points to the input file of an
        already run hessian file. (FULL DIRECTORY STRING REQUIRED)
    datfile: string
        This should be a string that points to the DAT file of an
        already run hessian file. (FULL DIRECTORY STRING REQUIRED)

    Returns
    -------
    This function returns nothing if it terminates successfully, otherwise
    it returns ValueError.

    Example
    -------
    >>> import autogamess as ag
    >>>
    >>> datfile = '../restart/IBv6_NH3_CCSD-T_CC6_hes.dat'
    >>> hesfile = './IBv6_NH3_CCSD-T_CC6_hes.inp'
    >>>
    >>> ag.hes2raman(hesfile, datfile)
    >>>
    """
    #Define Runtyps
    rhes   = '=HESSIAN'
    rraman = '=RAMAN'

    #Define grap list indexes
    s = ' $GRAD  \n'
    e = '----- HESSIAN MATRIX AFTER PROJECTION -----\n'

    #Define file identifiers
    hes   = '_hes'
    raman = '_raman'

    #Define raman file
    ramanfile = hesfile.replace(hes, raman)

    #Open, Read then close input file
    f   = open(hesfile, 'r')
    inp = f.readlines()
    f.close()

    #Open, Read then close DAT file
    f    = open(datfile, 'r')
    grab = f.readlines()
    f.close()

    #checks if they are in file
    if check_if_exists(datfile, ctr_f(s,grab), ctr_f(e,grab)):
        raise ValueError()

    #Define start and end indexes
    start = grab.index(s)
    end   = grab.index(e)

    #Replace HESSIAN with RAMAN
    i      = ctr_f(rhes, inp)
    inp[i] = inp[i].replace(rhes, rraman)

    #Open, Write then close raman file
    f = open(ramanfile, 'w')
    f.writelines(inp)
    f.writelines(grab[start:end])
    f.close()

    return
