# Generated by Django 4.0.8 on 2023-12-13 16:41

from django.apps import apps
from django.db import migrations, models


def unset_supplier_vat(*args, **kwargs):
    print("Removing supplier VAT ID from invoices where it shouldn't be set")
    Invoice = apps.get_model("invoicing", "Invoice")

    for invoice in Invoice.objects.exclude(supplier_vat_id=''):
        if not invoice.is_supplier_vat_id_visible():
            print(f'#{invoice.id}, number {invoice.number}, supplier VAT ID = {invoice.supplier_vat_id}')
            invoice.supplier_vat_id = ''
            invoice.save(update_fields=['supplier_vat_id'])


class Migration(migrations.Migration):

    dependencies = [
        ('invoicing', '0030_invoice_supplier_is_vat_payer'),
    ]

    operations = [
        migrations.RunPython(unset_supplier_vat, migrations.RunPython.noop)
    ]
