#include "../lv_demo_music.h"
#if LV_USE_DEMO_MUSIC

/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: 
 ******************************************************************************/

#ifndef LV_DEMO_MUSIC_FONT_16_BOLD
#define LV_DEMO_MUSIC_FONT_16_BOLD 1
#endif

#if LV_DEMO_MUSIC_FONT_16_BOLD

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xe, 0xf6, 0xd, 0xf5, 0xd, 0xf4, 0xc, 0xf3,
    0xb, 0xf3, 0xa, 0xf2, 0xa, 0xf1, 0x7, 0xd0,
    0x0, 0x0, 0x4, 0x70, 0xf, 0xf6, 0xb, 0xe3,

    /* U+22 "\"" */
    0x1f, 0x90, 0xfb, 0x1f, 0x90, 0xfa, 0xf, 0x80,
    0xfa, 0xf, 0x80, 0xe9, 0x9, 0x40, 0x95,

    /* U+23 "#" */
    0x0, 0x7, 0xf0, 0x5, 0xf2, 0x0, 0x0, 0x9,
    0xd0, 0x7, 0xf0, 0x0, 0x0, 0xb, 0xc0, 0x8,
    0xe0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x8, 0x8f, 0xc8, 0x8e, 0xd8, 0x80, 0x0, 0xf,
    0x60, 0xe, 0x80, 0x0, 0x0, 0x2f, 0x40, 0xf,
    0x60, 0x0, 0x58, 0xaf, 0x98, 0x9f, 0xa8, 0x30,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x8e,
    0x0, 0x5f, 0x10, 0x0, 0x0, 0xac, 0x0, 0x7f,
    0x0, 0x0, 0x0, 0xcb, 0x0, 0x9d, 0x0, 0x0,

    /* U+24 "$" */
    0x0, 0x0, 0x58, 0x0, 0x0, 0x0, 0x0, 0x8c,
    0x0, 0x0, 0x0, 0x5c, 0xff, 0xeb, 0x40, 0x7,
    0xff, 0xff, 0xff, 0xd0, 0xf, 0xf3, 0x8c, 0x4,
    0x50, 0x2f, 0xe0, 0x8c, 0x0, 0x0, 0xf, 0xfa,
    0xac, 0x0, 0x0, 0x6, 0xff, 0xff, 0x94, 0x0,
    0x0, 0x29, 0xef, 0xff, 0xa0, 0x0, 0x0, 0x8d,
    0x8f, 0xf4, 0x0, 0x0, 0x8c, 0x9, 0xf7, 0xc,
    0x50, 0x8c, 0x1d, 0xf4, 0x4f, 0xff, 0xef, 0xff,
    0xc0, 0x4, 0xbe, 0xff, 0xd8, 0x0, 0x0, 0x0,
    0x8c, 0x0, 0x0, 0x0, 0x0, 0x8c, 0x0, 0x0,

    /* U+25 "%" */
    0x5, 0xde, 0x90, 0x0, 0x6, 0xf2, 0x0, 0x1f,
    0x74, 0xe8, 0x0, 0x1e, 0x80, 0x0, 0x6e, 0x0,
    0x8c, 0x0, 0xad, 0x0, 0x0, 0x6e, 0x0, 0x7d,
    0x4, 0xf4, 0x0, 0x0, 0x2f, 0x41, 0xc9, 0xe,
    0x90, 0x0, 0x0, 0x7, 0xff, 0xc1, 0x9e, 0x10,
    0x0, 0x0, 0x0, 0x1, 0x3, 0xf5, 0x1b, 0xec,
    0x20, 0x0, 0x0, 0xd, 0xb0, 0xcb, 0x3a, 0xd0,
    0x0, 0x0, 0x8f, 0x10, 0xf3, 0x2, 0xf2, 0x0,
    0x2, 0xf6, 0x0, 0xf3, 0x2, 0xf2, 0x0, 0xc,
    0xc0, 0x0, 0xca, 0x19, 0xd0, 0x0, 0x6f, 0x20,
    0x0, 0x2b, 0xfc, 0x20,

    /* U+26 "&" */
    0x0, 0x9, 0xef, 0xc3, 0x0, 0x0, 0x0, 0xaf,
    0xb8, 0xee, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x8f,
    0x30, 0x0, 0x0, 0xef, 0x11, 0xdf, 0x10, 0x0,
    0x0, 0x6f, 0xde, 0xf6, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0x40, 0x0, 0x0, 0x4, 0xfe, 0xbf, 0xc1,
    0x2c, 0x40, 0x1f, 0xe2, 0x9, 0xfc, 0x8f, 0x50,
    0x4f, 0xa0, 0x0, 0x9f, 0xfe, 0x0, 0x3f, 0xe1,
    0x0, 0x2e, 0xfd, 0x0, 0xb, 0xff, 0xcc, 0xff,
    0xcf, 0xb0, 0x0, 0x7d, 0xfe, 0xb4, 0x9, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+27 "'" */
    0x1f, 0x91, 0xf9, 0xf, 0x80, 0xf8, 0x9, 0x40,

    /* U+28 "(" */
    0x0, 0xee, 0x0, 0x7f, 0x70, 0xd, 0xf1, 0x2,
    0xfc, 0x0, 0x5f, 0x90, 0x8, 0xf6, 0x0, 0x9f,
    0x50, 0xa, 0xf5, 0x0, 0x9f, 0x50, 0x8, 0xf6,
    0x0, 0x5f, 0x90, 0x2, 0xfc, 0x0, 0xd, 0xf1,
    0x0, 0x7f, 0x70, 0x0, 0xee, 0x0,

    /* U+29 ")" */
    0x6f, 0x80, 0x0, 0xef, 0x10, 0x9, 0xf6, 0x0,
    0x4f, 0xb0, 0x0, 0xfe, 0x0, 0xe, 0xf1, 0x0,
    0xcf, 0x20, 0xc, 0xf3, 0x0, 0xcf, 0x20, 0xe,
    0xf1, 0x0, 0xfe, 0x0, 0x4f, 0xb0, 0x9, 0xf6,
    0x0, 0xef, 0x10, 0x6f, 0x80, 0x0,

    /* U+2A "*" */
    0x0, 0x4e, 0x0, 0x6, 0xa5, 0xe3, 0xc1, 0x4d,
    0xff, 0xfa, 0x10, 0x7f, 0xfe, 0x40, 0x8e, 0xaf,
    0x9f, 0x31, 0x14, 0xe0, 0x20, 0x0, 0x15, 0x0,
    0x0,

    /* U+2B "+" */
    0x0, 0x18, 0x40, 0x0, 0x0, 0x2f, 0x90, 0x0,
    0x0, 0x2f, 0x90, 0x0, 0xaa, 0xbf, 0xda, 0xa4,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x2f, 0x90, 0x0,
    0x0, 0x2f, 0x90, 0x0, 0x0, 0x2f, 0x90, 0x0,

    /* U+2C "," */
    0x1, 0x0, 0x2f, 0xe1, 0x3f, 0xf3, 0xb, 0xe0,
    0xd, 0x90, 0x1f, 0x40,

    /* U+2D "-" */
    0x1b, 0xbb, 0xb3, 0x2f, 0xff, 0xf4,

    /* U+2E "." */
    0xa, 0x90, 0x5f, 0xf3, 0x1d, 0xd0,

    /* U+2F "/" */
    0x0, 0x0, 0x2, 0x84, 0x0, 0x0, 0x8, 0xf4,
    0x0, 0x0, 0xe, 0xe0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x9f, 0x30, 0x0, 0x0, 0xee, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x9, 0xf3, 0x0,
    0x0, 0xe, 0xd0, 0x0, 0x0, 0x4f, 0x80, 0x0,
    0x0, 0x9f, 0x20, 0x0, 0x0, 0xed, 0x0, 0x0,
    0x4, 0xf8, 0x0, 0x0, 0xa, 0xf2, 0x0, 0x0,
    0xf, 0xd0, 0x0, 0x0, 0x5f, 0x70, 0x0, 0x0,

    /* U+30 "0" */
    0x0, 0x8, 0xef, 0xd6, 0x0, 0x0, 0xc, 0xff,
    0xef, 0xf9, 0x0, 0x8, 0xfc, 0x10, 0x3e, 0xf4,
    0x0, 0xef, 0x30, 0x0, 0x7f, 0xa0, 0x2f, 0xe0,
    0x0, 0x2, 0xfe, 0x4, 0xfd, 0x0, 0x0, 0xf,
    0xf0, 0x4f, 0xd0, 0x0, 0x0, 0xff, 0x2, 0xfe,
    0x0, 0x0, 0x2f, 0xe0, 0xe, 0xf3, 0x0, 0x7,
    0xfa, 0x0, 0x8f, 0xc1, 0x3, 0xef, 0x40, 0x0,
    0xcf, 0xfe, 0xff, 0x90, 0x0, 0x0, 0x8e, 0xfd,
    0x60, 0x0,

    /* U+31 "1" */
    0xef, 0xff, 0x9b, 0xde, 0xf9, 0x0, 0x8f, 0x90,
    0x8, 0xf9, 0x0, 0x8f, 0x90, 0x8, 0xf9, 0x0,
    0x8f, 0x90, 0x8, 0xf9, 0x0, 0x8f, 0x90, 0x8,
    0xf9, 0x0, 0x8f, 0x90, 0x8, 0xf9,

    /* U+32 "2" */
    0x3, 0xae, 0xfd, 0x80, 0x7, 0xff, 0xfe, 0xff,
    0xc0, 0x4d, 0x50, 0x3, 0xff, 0x40, 0x0, 0x0,
    0xc, 0xf5, 0x0, 0x0, 0x0, 0xef, 0x30, 0x0,
    0x0, 0x8f, 0xd0, 0x0, 0x0, 0x6f, 0xf2, 0x0,
    0x0, 0x6f, 0xf3, 0x0, 0x0, 0x6f, 0xf3, 0x0,
    0x0, 0x6f, 0xf3, 0x0, 0x0, 0x4f, 0xfe, 0xdd,
    0xdd, 0xa7, 0xff, 0xff, 0xff, 0xfd,

    /* U+33 "3" */
    0x7f, 0xff, 0xff, 0xff, 0x35, 0xdd, 0xdd, 0xef,
    0xf1, 0x0, 0x0, 0xd, 0xf5, 0x0, 0x0, 0xa,
    0xf9, 0x0, 0x0, 0x7, 0xfc, 0x0, 0x0, 0x0,
    0xef, 0xfd, 0x40, 0x0, 0x7, 0x9c, 0xff, 0x20,
    0x0, 0x0, 0xb, 0xf8, 0x0, 0x0, 0x0, 0x7f,
    0x96, 0xa2, 0x0, 0x2e, 0xf6, 0xcf, 0xff, 0xef,
    0xfd, 0x0, 0x7c, 0xff, 0xd8, 0x0,

    /* U+34 "4" */
    0x0, 0x0, 0x4, 0xfd, 0x0, 0x0, 0x0, 0x1,
    0xef, 0x30, 0x0, 0x0, 0x0, 0xcf, 0x70, 0x0,
    0x0, 0x0, 0x8f, 0xb0, 0x0, 0x0, 0x0, 0x4f,
    0xe1, 0x2, 0x10, 0x0, 0x1e, 0xf4, 0x4, 0xfb,
    0x0, 0xb, 0xf9, 0x0, 0x4f, 0xb0, 0x5, 0xff,
    0xdd, 0xdd, 0xff, 0xd9, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x5, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xb0, 0x0, 0x0, 0x0, 0x5,
    0xfb, 0x0,

    /* U+35 "5" */
    0x6, 0xff, 0xff, 0xff, 0x30, 0x8f, 0xed, 0xdd,
    0xd2, 0x9, 0xf5, 0x0, 0x0, 0x0, 0xaf, 0x30,
    0x0, 0x0, 0xc, 0xf2, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xea, 0x30, 0xc, 0xdd, 0xef, 0xff, 0x30,
    0x0, 0x0, 0x1b, 0xfb, 0x0, 0x0, 0x0, 0x4f,
    0xc2, 0xb3, 0x0, 0x1b, 0xfa, 0x9f, 0xff, 0xef,
    0xff, 0x20, 0x6b, 0xef, 0xea, 0x20,

    /* U+36 "6" */
    0x0, 0x5, 0xbe, 0xfd, 0x80, 0x0, 0x9f, 0xfe,
    0xdf, 0xc0, 0x5, 0xfe, 0x40, 0x0, 0x10, 0xd,
    0xf4, 0x0, 0x0, 0x0, 0x1f, 0xe1, 0x8a, 0x95,
    0x0, 0x3f, 0xef, 0xff, 0xff, 0xa0, 0x4f, 0xfd,
    0x30, 0x4e, 0xf5, 0x3f, 0xf4, 0x0, 0x8, 0xf9,
    0xf, 0xf3, 0x0, 0x7, 0xf9, 0xa, 0xfa, 0x0,
    0xd, 0xf5, 0x1, 0xef, 0xeb, 0xef, 0xc0, 0x0,
    0x19, 0xef, 0xe8, 0x0,

    /* U+37 "7" */
    0x8f, 0xff, 0xff, 0xff, 0xf2, 0x8f, 0xed, 0xdd,
    0xef, 0xf1, 0x8f, 0x60, 0x0, 0x7f, 0xb0, 0x7e,
    0x50, 0x0, 0xef, 0x40, 0x0, 0x0, 0x5, 0xfe,
    0x0, 0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x0,
    0x2f, 0xf1, 0x0, 0x0, 0x0, 0x9f, 0xa0, 0x0,
    0x0, 0x0, 0xef, 0x30, 0x0, 0x0, 0x6, 0xfd,
    0x0, 0x0, 0x0, 0xc, 0xf6, 0x0, 0x0, 0x0,
    0x3f, 0xf0, 0x0, 0x0,

    /* U+38 "8" */
    0x0, 0x4b, 0xff, 0xd8, 0x0, 0x5, 0xff, 0xcb,
    0xff, 0xc0, 0xd, 0xf6, 0x0, 0x1e, 0xf4, 0xe,
    0xf2, 0x0, 0xb, 0xf5, 0xa, 0xfa, 0x10, 0x5f,
    0xf1, 0x1, 0xdf, 0xff, 0xff, 0x50, 0x9, 0xff,
    0xa9, 0xdf, 0xd1, 0x2f, 0xf1, 0x0, 0xa, 0xf9,
    0x5f, 0xc0, 0x0, 0x5, 0xfc, 0x2f, 0xf3, 0x0,
    0xb, 0xf9, 0xa, 0xff, 0xcb, 0xef, 0xe2, 0x0,
    0x6c, 0xff, 0xd9, 0x10,

    /* U+39 "9" */
    0x0, 0x8d, 0xfe, 0x91, 0x0, 0xc, 0xfe, 0xbe,
    0xfe, 0x10, 0x5f, 0xd1, 0x0, 0x9f, 0xa0, 0x8f,
    0x70, 0x0, 0x2f, 0xf0, 0x8f, 0x80, 0x0, 0x3f,
    0xf3, 0x4f, 0xf4, 0x3, 0xdf, 0xf4, 0xa, 0xff,
    0xff, 0xfe, 0xf4, 0x0, 0x59, 0xa8, 0x2e, 0xf2,
    0x0, 0x0, 0x0, 0x4f, 0xd0, 0x1, 0x0, 0x4,
    0xef, 0x60, 0xb, 0xfd, 0xff, 0xf9, 0x0, 0x8,
    0xdf, 0xeb, 0x50, 0x0,

    /* U+3A ":" */
    0x1d, 0xd0, 0x5f, 0xf3, 0xa, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0x90, 0x5f, 0xf3,
    0x1d, 0xd0,

    /* U+3B ";" */
    0x1d, 0xd0, 0x5f, 0xf3, 0xa, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1d, 0xd0, 0x4f, 0xf3,
    0xc, 0xf0, 0xc, 0xa0, 0xf, 0x40, 0x2, 0x0,

    /* U+3C "<" */
    0x0, 0x0, 0x0, 0x54, 0x0, 0x2, 0x8e, 0xf6,
    0x5, 0xbf, 0xfc, 0x60, 0xdf, 0xe8, 0x20, 0x0,
    0xff, 0x93, 0x0, 0x0, 0x3a, 0xff, 0xd6, 0x10,
    0x0, 0x17, 0xdf, 0xf5, 0x0, 0x0, 0x4, 0xa6,
    0x0, 0x0, 0x0, 0x0,

    /* U+3D "=" */
    0xff, 0xff, 0xff, 0xf6, 0xaa, 0xaa, 0xaa, 0xa4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf6, 0xaa, 0xaa, 0xaa, 0xa4,

    /* U+3E ">" */
    0x82, 0x0, 0x0, 0x0, 0xff, 0xb5, 0x0, 0x0,
    0x39, 0xff, 0xe8, 0x10, 0x0, 0x5, 0xcf, 0xf5,
    0x0, 0x1, 0x6e, 0xf6, 0x4, 0xaf, 0xfd, 0x71,
    0xdf, 0xfa, 0x30, 0x0, 0xc7, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+3F "?" */
    0x4, 0xbe, 0xfd, 0x81, 0x7, 0xff, 0xed, 0xff,
    0xd0, 0x5d, 0x40, 0x3, 0xff, 0x30, 0x0, 0x0,
    0xd, 0xf3, 0x0, 0x0, 0x4, 0xfe, 0x0, 0x0,
    0x3, 0xff, 0x40, 0x0, 0x1, 0xef, 0x40, 0x0,
    0x0, 0x6f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x18, 0x30, 0x0, 0x0, 0xa, 0xfc,
    0x0, 0x0, 0x0, 0x5f, 0x70, 0x0,

    /* U+40 "@" */
    0x0, 0x0, 0x17, 0xce, 0xfd, 0xb5, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xa7, 0x67, 0xbf, 0xd2, 0x0,
    0x0, 0x7f, 0x90, 0x0, 0x0, 0x2, 0xcf, 0x20,
    0x3, 0xf8, 0x0, 0x58, 0x83, 0x49, 0x3d, 0xd0,
    0xb, 0xd0, 0xb, 0xff, 0xff, 0xdf, 0x53, 0xf4,
    0xf, 0x70, 0x7f, 0xc2, 0x17, 0xff, 0x50, 0xc9,
    0x2f, 0x40, 0xcf, 0x10, 0x0, 0xaf, 0x50, 0x9c,
    0x4f, 0x30, 0xfe, 0x0, 0x0, 0x7f, 0x50, 0x8d,
    0x2f, 0x40, 0xef, 0x0, 0x0, 0x8f, 0x50, 0x9b,
    0xf, 0x70, 0x9f, 0x60, 0x1, 0xef, 0x50, 0xd8,
    0xa, 0xd0, 0x2f, 0xfb, 0xae, 0xdf, 0xdb, 0xf2,
    0x3, 0xf8, 0x2, 0xbf, 0xe9, 0x19, 0xfe, 0x50,
    0x0, 0x7f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xa7, 0x67, 0xb8, 0x0, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb4, 0x0, 0x0,

    /* U+41 "A" */
    0x0, 0x0, 0x4, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xde, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x67, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xef, 0x1,
    0xfe, 0x0, 0x0, 0x0, 0x5, 0xf9, 0x0, 0xaf,
    0x50, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x4f, 0xb0,
    0x0, 0x0, 0x3f, 0xfb, 0xbb, 0xbf, 0xf2, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x1,
    0xff, 0x0, 0x0, 0x1, 0xff, 0x0, 0x7, 0xf9,
    0x0, 0x0, 0x0, 0xaf, 0x60, 0xd, 0xf3, 0x0,
    0x0, 0x0, 0x4f, 0xd0,

    /* U+42 "B" */
    0x8f, 0xff, 0xff, 0xeb, 0x40, 0x8, 0xfd, 0xbb,
    0xbd, 0xff, 0x50, 0x8f, 0x90, 0x0, 0x9, 0xfc,
    0x8, 0xf9, 0x0, 0x0, 0x4f, 0xd0, 0x8f, 0x90,
    0x0, 0x9, 0xfa, 0x8, 0xfd, 0xbb, 0xbd, 0xfd,
    0x10, 0x8f, 0xff, 0xff, 0xff, 0xe5, 0x8, 0xf9,
    0x0, 0x0, 0x5f, 0xf2, 0x8f, 0x90, 0x0, 0x0,
    0xbf, 0x68, 0xf9, 0x0, 0x0, 0x1e, 0xf5, 0x8f,
    0xdb, 0xbb, 0xcf, 0xfe, 0x8, 0xff, 0xff, 0xff,
    0xe9, 0x10,

    /* U+43 "C" */
    0x0, 0x2, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x5f,
    0xff, 0xef, 0xff, 0xa0, 0x3, 0xff, 0x91, 0x0,
    0x4e, 0x80, 0xc, 0xf9, 0x0, 0x0, 0x1, 0x0,
    0x1f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf9, 0x0, 0x0, 0x1, 0x0, 0x3, 0xff,
    0x92, 0x0, 0x5e, 0x90, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x2, 0x9d, 0xfe, 0xb5, 0x0,

    /* U+44 "D" */
    0x8f, 0xff, 0xff, 0xea, 0x30, 0x0, 0x8f, 0xed,
    0xdd, 0xff, 0xf9, 0x0, 0x8f, 0x90, 0x0, 0x6,
    0xff, 0x70, 0x8f, 0x90, 0x0, 0x0, 0x5f, 0xf0,
    0x8f, 0x90, 0x0, 0x0, 0xd, 0xf5, 0x8f, 0x90,
    0x0, 0x0, 0xa, 0xf7, 0x8f, 0x90, 0x0, 0x0,
    0xa, 0xf7, 0x8f, 0x90, 0x0, 0x0, 0xd, 0xf5,
    0x8f, 0x90, 0x0, 0x0, 0x5f, 0xf0, 0x8f, 0x90,
    0x0, 0x6, 0xff, 0x70, 0x8f, 0xed, 0xdd, 0xff,
    0xf9, 0x0, 0x8f, 0xff, 0xff, 0xea, 0x40, 0x0,

    /* U+45 "E" */
    0x8f, 0xff, 0xff, 0xff, 0xb8, 0xfe, 0xdd, 0xdd,
    0xd9, 0x8f, 0x90, 0x0, 0x0, 0x8, 0xf9, 0x0,
    0x0, 0x0, 0x8f, 0x90, 0x0, 0x0, 0x8, 0xfe,
    0xcc, 0xcc, 0xc0, 0x8f, 0xff, 0xff, 0xff, 0x8,
    0xf9, 0x0, 0x0, 0x0, 0x8f, 0x90, 0x0, 0x0,
    0x8, 0xf9, 0x0, 0x0, 0x0, 0x8f, 0xed, 0xdd,
    0xdd, 0xb8, 0xff, 0xff, 0xff, 0xfe,

    /* U+46 "F" */
    0x8f, 0xff, 0xff, 0xff, 0xb8, 0xfe, 0xdd, 0xdd,
    0xd9, 0x8f, 0x90, 0x0, 0x0, 0x8, 0xf9, 0x0,
    0x0, 0x0, 0x8f, 0x90, 0x0, 0x0, 0x8, 0xf9,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x8,
    0xfe, 0xdd, 0xdd, 0xd0, 0x8f, 0x90, 0x0, 0x0,
    0x8, 0xf9, 0x0, 0x0, 0x0, 0x8f, 0x90, 0x0,
    0x0, 0x8, 0xf9, 0x0, 0x0, 0x0,

    /* U+47 "G" */
    0x0, 0x2, 0x8d, 0xfe, 0xc6, 0x0, 0x0, 0x5f,
    0xff, 0xef, 0xff, 0xc0, 0x3, 0xff, 0x92, 0x0,
    0x3c, 0xa0, 0xc, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xd0,
    0x0, 0x0, 0x1, 0x20, 0x3f, 0xd0, 0x0, 0x0,
    0xd, 0xf2, 0x1f, 0xf1, 0x0, 0x0, 0xd, 0xf2,
    0xc, 0xf9, 0x0, 0x0, 0xd, 0xf2, 0x3, 0xff,
    0xa2, 0x0, 0x3e, 0xf2, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xe1, 0x0, 0x2, 0x9d, 0xff, 0xc7, 0x0,

    /* U+48 "H" */
    0x8f, 0x90, 0x0, 0x0, 0xaf, 0x78, 0xf9, 0x0,
    0x0, 0xa, 0xf7, 0x8f, 0x90, 0x0, 0x0, 0xaf,
    0x78, 0xf9, 0x0, 0x0, 0xa, 0xf7, 0x8f, 0x90,
    0x0, 0x0, 0xaf, 0x78, 0xfe, 0xdd, 0xdd, 0xdf,
    0xf7, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x78, 0xf9,
    0x0, 0x0, 0xa, 0xf7, 0x8f, 0x90, 0x0, 0x0,
    0xaf, 0x78, 0xf9, 0x0, 0x0, 0xa, 0xf7, 0x8f,
    0x90, 0x0, 0x0, 0xaf, 0x78, 0xf9, 0x0, 0x0,
    0xa, 0xf7,

    /* U+49 "I" */
    0x8f, 0x98, 0xf9, 0x8f, 0x98, 0xf9, 0x8f, 0x98,
    0xf9, 0x8f, 0x98, 0xf9, 0x8f, 0x98, 0xf9, 0x8f,
    0x98, 0xf9,

    /* U+4A "J" */
    0x0, 0xff, 0xff, 0xff, 0x0, 0xd, 0xdd, 0xdf,
    0xf0, 0x0, 0x0, 0x1, 0xff, 0x0, 0x0, 0x0,
    0x1f, 0xf0, 0x0, 0x0, 0x1, 0xff, 0x0, 0x0,
    0x0, 0x1f, 0xf0, 0x0, 0x0, 0x1, 0xff, 0x0,
    0x0, 0x0, 0x1f, 0xf0, 0x0, 0x0, 0x1, 0xff,
    0x0, 0x99, 0x0, 0x8f, 0xc0, 0xe, 0xff, 0xef,
    0xf5, 0x0, 0x1a, 0xef, 0xd6, 0x0,

    /* U+4B "K" */
    0x8f, 0x90, 0x0, 0x5, 0xfe, 0x18, 0xf9, 0x0,
    0x4, 0xff, 0x30, 0x8f, 0x90, 0x2, 0xff, 0x40,
    0x8, 0xf9, 0x2, 0xef, 0x60, 0x0, 0x8f, 0x91,
    0xdf, 0x80, 0x0, 0x8, 0xf9, 0xcf, 0xe0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0x90, 0x0, 0x8, 0xff,
    0xd5, 0xff, 0x50, 0x0, 0x8f, 0xe1, 0x7, 0xff,
    0x20, 0x8, 0xf9, 0x0, 0xa, 0xfd, 0x0, 0x8f,
    0x90, 0x0, 0xd, 0xf9, 0x8, 0xf9, 0x0, 0x0,
    0x2f, 0xf5,

    /* U+4C "L" */
    0x8f, 0x90, 0x0, 0x0, 0x8, 0xf9, 0x0, 0x0,
    0x0, 0x8f, 0x90, 0x0, 0x0, 0x8, 0xf9, 0x0,
    0x0, 0x0, 0x8f, 0x90, 0x0, 0x0, 0x8, 0xf9,
    0x0, 0x0, 0x0, 0x8f, 0x90, 0x0, 0x0, 0x8,
    0xf9, 0x0, 0x0, 0x0, 0x8f, 0x90, 0x0, 0x0,
    0x8, 0xf9, 0x0, 0x0, 0x0, 0x8f, 0xed, 0xdd,
    0xdd, 0x58, 0xff, 0xff, 0xff, 0xf7,

    /* U+4D "M" */
    0x8f, 0x70, 0x0, 0x0, 0x0, 0x3f, 0xc8, 0xff,
    0x10, 0x0, 0x0, 0xc, 0xfc, 0x8f, 0xf9, 0x0,
    0x0, 0x5, 0xff, 0xc8, 0xff, 0xf2, 0x0, 0x0,
    0xdf, 0xfc, 0x8f, 0xcf, 0xb0, 0x0, 0x7f, 0xbf,
    0xc8, 0xf7, 0xcf, 0x40, 0x1e, 0xe4, 0xfc, 0x8f,
    0x73, 0xfd, 0x8, 0xf6, 0x3f, 0xc8, 0xf7, 0x9,
    0xf8, 0xfd, 0x3, 0xfc, 0x8f, 0x70, 0x1f, 0xff,
    0x40, 0x3f, 0xc8, 0xf7, 0x0, 0x7f, 0xb0, 0x3,
    0xfc, 0x8f, 0x70, 0x0, 0x92, 0x0, 0x3f, 0xc8,
    0xf7, 0x0, 0x0, 0x0, 0x3, 0xfc,

    /* U+4E "N" */
    0x8f, 0x90, 0x0, 0x0, 0x9f, 0x78, 0xff, 0x50,
    0x0, 0x9, 0xf7, 0x8f, 0xff, 0x20, 0x0, 0x9f,
    0x78, 0xff, 0xfd, 0x0, 0x9, 0xf7, 0x8f, 0xae,
    0xfa, 0x0, 0x9f, 0x78, 0xf9, 0x3f, 0xf6, 0x9,
    0xf7, 0x8f, 0x90, 0x7f, 0xf2, 0x9f, 0x78, 0xf9,
    0x0, 0xaf, 0xda, 0xf7, 0x8f, 0x90, 0x0, 0xdf,
    0xff, 0x78, 0xf9, 0x0, 0x3, 0xff, 0xf7, 0x8f,
    0x90, 0x0, 0x6, 0xff, 0x78, 0xf9, 0x0, 0x0,
    0xa, 0xf7,

    /* U+4F "O" */
    0x0, 0x2, 0x8d, 0xfe, 0xb5, 0x0, 0x0, 0x5,
    0xff, 0xfe, 0xff, 0xfb, 0x0, 0x3, 0xff, 0x91,
    0x0, 0x5e, 0xfa, 0x0, 0xcf, 0x90, 0x0, 0x0,
    0x2f, 0xf3, 0x1f, 0xf1, 0x0, 0x0, 0x0, 0x9f,
    0x93, 0xfd, 0x0, 0x0, 0x0, 0x6, 0xfb, 0x3f,
    0xd0, 0x0, 0x0, 0x0, 0x6f, 0xb1, 0xff, 0x10,
    0x0, 0x0, 0x9, 0xf9, 0xb, 0xf9, 0x0, 0x0,
    0x2, 0xff, 0x30, 0x3f, 0xf9, 0x10, 0x5, 0xef,
    0xa0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x29, 0xdf, 0xeb, 0x50, 0x0,

    /* U+50 "P" */
    0x8f, 0xff, 0xff, 0xd7, 0x0, 0x8f, 0xed, 0xde,
    0xff, 0xc0, 0x8f, 0x90, 0x0, 0x3e, 0xf7, 0x8f,
    0x90, 0x0, 0x6, 0xfc, 0x8f, 0x90, 0x0, 0x4,
    0xfd, 0x8f, 0x90, 0x0, 0x7, 0xfb, 0x8f, 0x90,
    0x1, 0x5f, 0xf6, 0x8f, 0xff, 0xff, 0xff, 0xa0,
    0x8f, 0xed, 0xdc, 0xa5, 0x0, 0x8f, 0x90, 0x0,
    0x0, 0x0, 0x8f, 0x90, 0x0, 0x0, 0x0, 0x8f,
    0x90, 0x0, 0x0, 0x0,

    /* U+51 "Q" */
    0x0, 0x2, 0x8d, 0xfe, 0xb5, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0xef, 0xff, 0xa0, 0x0, 0x2, 0xff,
    0xa1, 0x0, 0x5e, 0xfa, 0x0, 0xb, 0xfa, 0x0,
    0x0, 0x3, 0xff, 0x30, 0x1f, 0xf1, 0x0, 0x0,
    0x0, 0xaf, 0x80, 0x3f, 0xd0, 0x0, 0x0, 0x0,
    0x6f, 0xb0, 0x4f, 0xd0, 0x0, 0x0, 0x0, 0x6f,
    0xb0, 0x2f, 0xf0, 0x0, 0x0, 0x0, 0x9f, 0x90,
    0xd, 0xf7, 0x0, 0x0, 0x1, 0xef, 0x40, 0x5,
    0xff, 0x60, 0x0, 0x2c, 0xfc, 0x0, 0x0, 0x8f,
    0xfe, 0xbc, 0xff, 0xe1, 0x0, 0x0, 0x4, 0xcf,
    0xff, 0xf9, 0x10, 0x0, 0x0, 0x0, 0x1, 0x9f,
    0xe4, 0x5, 0xa0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xff, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x28, 0x97,
    0x10,

    /* U+52 "R" */
    0x8f, 0xff, 0xff, 0xd7, 0x0, 0x8, 0xfe, 0xdd,
    0xef, 0xfc, 0x0, 0x8f, 0x90, 0x0, 0x3e, 0xf7,
    0x8, 0xf9, 0x0, 0x0, 0x6f, 0xc0, 0x8f, 0x90,
    0x0, 0x4, 0xfd, 0x8, 0xf9, 0x0, 0x0, 0x7f,
    0xb0, 0x8f, 0x90, 0x1, 0x5f, 0xf6, 0x8, 0xff,
    0xff, 0xff, 0xfa, 0x0, 0x8f, 0xec, 0xcd, 0xfb,
    0x0, 0x8, 0xf9, 0x0, 0xe, 0xf5, 0x0, 0x8f,
    0x90, 0x0, 0x3f, 0xe1, 0x8, 0xf9, 0x0, 0x0,
    0x8f, 0xb0,

    /* U+53 "S" */
    0x0, 0x5b, 0xef, 0xea, 0x30, 0x7, 0xff, 0xed,
    0xff, 0xd0, 0xf, 0xf4, 0x0, 0x5, 0x50, 0x2f,
    0xe0, 0x0, 0x0, 0x0, 0xf, 0xfa, 0x20, 0x0,
    0x0, 0x6, 0xff, 0xfe, 0x94, 0x0, 0x0, 0x28,
    0xdf, 0xff, 0xa0, 0x0, 0x0, 0x1, 0x8f, 0xf4,
    0x0, 0x0, 0x0, 0x9, 0xf7, 0xd, 0x50, 0x0,
    0x1d, 0xf5, 0x4f, 0xff, 0xdd, 0xff, 0xc0, 0x3,
    0x9d, 0xff, 0xd7, 0x0,

    /* U+54 "T" */
    0xff, 0xff, 0xff, 0xff, 0xf9, 0xcd, 0xde, 0xff,
    0xdd, 0xd7, 0x0, 0x3, 0xfd, 0x0, 0x0, 0x0,
    0x3, 0xfd, 0x0, 0x0, 0x0, 0x3, 0xfd, 0x0,
    0x0, 0x0, 0x3, 0xfd, 0x0, 0x0, 0x0, 0x3,
    0xfd, 0x0, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x0,
    0x0, 0x3, 0xfd, 0x0, 0x0, 0x0, 0x3, 0xfd,
    0x0, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x0, 0x0,
    0x3, 0xfd, 0x0, 0x0,

    /* U+55 "U" */
    0x9f, 0x70, 0x0, 0x0, 0xdf, 0x39, 0xf7, 0x0,
    0x0, 0xd, 0xf3, 0x9f, 0x70, 0x0, 0x0, 0xdf,
    0x39, 0xf7, 0x0, 0x0, 0xd, 0xf3, 0x9f, 0x70,
    0x0, 0x0, 0xdf, 0x39, 0xf7, 0x0, 0x0, 0xd,
    0xf3, 0x9f, 0x70, 0x0, 0x0, 0xdf, 0x38, 0xf9,
    0x0, 0x0, 0xe, 0xf2, 0x6f, 0xd0, 0x0, 0x3,
    0xff, 0x1, 0xff, 0x90, 0x2, 0xcf, 0xa0, 0x5,
    0xff, 0xff, 0xff, 0xe1, 0x0, 0x4, 0xbe, 0xfe,
    0x91, 0x0,

    /* U+56 "V" */
    0xd, 0xf5, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x7f,
    0xc0, 0x0, 0x0, 0xe, 0xf2, 0x1, 0xff, 0x20,
    0x0, 0x5, 0xfb, 0x0, 0xa, 0xf9, 0x0, 0x0,
    0xcf, 0x50, 0x0, 0x3f, 0xf0, 0x0, 0x2f, 0xe0,
    0x0, 0x0, 0xdf, 0x60, 0x9, 0xf8, 0x0, 0x0,
    0x6, 0xfc, 0x0, 0xff, 0x10, 0x0, 0x0, 0x1f,
    0xf3, 0x6f, 0xb0, 0x0, 0x0, 0x0, 0x9f, 0x9c,
    0xf4, 0x0, 0x0, 0x0, 0x3, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xf1, 0x0, 0x0,

    /* U+57 "W" */
    0x6f, 0xb0, 0x0, 0x0, 0xef, 0x50, 0x0, 0x4,
    0xfb, 0x1f, 0xf1, 0x0, 0x3, 0xff, 0xa0, 0x0,
    0x9, 0xf6, 0xc, 0xf5, 0x0, 0x8, 0xff, 0xf0,
    0x0, 0xe, 0xf1, 0x7, 0xfa, 0x0, 0xd, 0xfc,
    0xf4, 0x0, 0x3f, 0xc0, 0x2, 0xff, 0x0, 0x2f,
    0xc6, 0xf9, 0x0, 0x8f, 0x70, 0x0, 0xdf, 0x40,
    0x7f, 0x61, 0xfe, 0x0, 0xdf, 0x20, 0x0, 0x8f,
    0x90, 0xcf, 0x10, 0xcf, 0x32, 0xfd, 0x0, 0x0,
    0x3f, 0xe1, 0xfc, 0x0, 0x7f, 0x87, 0xf8, 0x0,
    0x0, 0xe, 0xf9, 0xf7, 0x0, 0x2f, 0xdc, 0xf3,
    0x0, 0x0, 0xa, 0xff, 0xf2, 0x0, 0xd, 0xff,
    0xe0, 0x0, 0x0, 0x5, 0xff, 0xd0, 0x0, 0x8,
    0xff, 0x90, 0x0, 0x0, 0x0, 0xff, 0x80, 0x0,
    0x3, 0xff, 0x40, 0x0,

    /* U+58 "X" */
    0x4f, 0xf1, 0x0, 0x0, 0xdf, 0x50, 0xaf, 0xb0,
    0x0, 0x9f, 0xa0, 0x1, 0xef, 0x60, 0x4f, 0xe1,
    0x0, 0x4, 0xff, 0x2d, 0xf4, 0x0, 0x0, 0x9,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x1e, 0xfe, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xf3, 0x0, 0x0, 0x0,
    0xcf, 0xcf, 0xd0, 0x0, 0x0, 0x7f, 0xc0, 0xcf,
    0x90, 0x0, 0x2f, 0xf2, 0x2, 0xff, 0x40, 0xd,
    0xf8, 0x0, 0x7, 0xfe, 0x8, 0xfd, 0x0, 0x0,
    0xc, 0xf9,

    /* U+59 "Y" */
    0xd, 0xf5, 0x0, 0x0, 0x9, 0xf6, 0x4, 0xfe,
    0x0, 0x0, 0x3f, 0xd0, 0x0, 0xbf, 0x70, 0x0,
    0xbf, 0x40, 0x0, 0x2f, 0xf1, 0x5, 0xfb, 0x0,
    0x0, 0x9, 0xf9, 0xd, 0xf3, 0x0, 0x0, 0x1,
    0xff, 0x9f, 0x90, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0x10, 0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0,

    /* U+5A "Z" */
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x3, 0xdd, 0xdd,
    0xdd, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x4f, 0xf3,
    0x0, 0x0, 0x0, 0x1e, 0xf7, 0x0, 0x0, 0x0,
    0xc, 0xfb, 0x0, 0x0, 0x0, 0x8, 0xfd, 0x10,
    0x0, 0x0, 0x4, 0xff, 0x30, 0x0, 0x0, 0x1,
    0xef, 0x60, 0x0, 0x0, 0x0, 0xcf, 0xa0, 0x0,
    0x0, 0x0, 0x8f, 0xd0, 0x0, 0x0, 0x0, 0x3f,
    0xfe, 0xdd, 0xdd, 0xdd, 0x25, 0xff, 0xff, 0xff,
    0xff, 0xf3,

    /* U+5B "[" */
    0x8f, 0xff, 0x58, 0xfd, 0xa3, 0x8f, 0x80, 0x8,
    0xf8, 0x0, 0x8f, 0x80, 0x8, 0xf8, 0x0, 0x8f,
    0x80, 0x8, 0xf8, 0x0, 0x8f, 0x80, 0x8, 0xf8,
    0x0, 0x8f, 0x80, 0x8, 0xf8, 0x0, 0x8f, 0x80,
    0x8, 0xfd, 0xa3, 0x8f, 0xff, 0x50,

    /* U+5C "\\" */
    0x48, 0x10, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0xe, 0xd0, 0x0, 0x0, 0x9, 0xf2, 0x0, 0x0,
    0x4, 0xf8, 0x0, 0x0, 0x0, 0xed, 0x0, 0x0,
    0x0, 0x9f, 0x30, 0x0, 0x0, 0x4f, 0x80, 0x0,
    0x0, 0xe, 0xe0, 0x0, 0x0, 0x9, 0xf3, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0xee, 0x0,
    0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0xd, 0xe0, 0x0, 0x0, 0x8, 0xf4,

    /* U+5D "]" */
    0xbf, 0xff, 0x17, 0xaf, 0xf1, 0x0, 0xef, 0x10,
    0xe, 0xf1, 0x0, 0xef, 0x10, 0xe, 0xf1, 0x0,
    0xef, 0x10, 0xe, 0xf1, 0x0, 0xef, 0x10, 0xe,
    0xf1, 0x0, 0xef, 0x10, 0xe, 0xf1, 0x0, 0xef,
    0x17, 0xaf, 0xf1, 0xbf, 0xff, 0x10,

    /* U+5E "^" */
    0x0, 0x4f, 0xc0, 0x0, 0x0, 0xbf, 0xf2, 0x0,
    0x1, 0xf6, 0xe9, 0x0, 0x8, 0xf0, 0x8e, 0x0,
    0xe, 0x90, 0x2f, 0x60, 0x5f, 0x30, 0xc, 0xc0,
    0xbd, 0x0, 0x5, 0xf3,

    /* U+5F "_" */
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0x33, 0x33, 0x33, 0x33,

    /* U+60 "`" */
    0x17, 0x71, 0x0, 0x4, 0xfc, 0x0, 0x0, 0x3e,
    0xb0,

    /* U+61 "a" */
    0x3, 0xae, 0xfd, 0x91, 0x0, 0xdf, 0xec, 0xff,
    0xc0, 0x4, 0x30, 0x1, 0xef, 0x40, 0x0, 0x1,
    0x19, 0xf6, 0x4, 0xdf, 0xff, 0xff, 0x71, 0xff,
    0x64, 0x4a, 0xf7, 0x4f, 0xb0, 0x0, 0xbf, 0x71,
    0xff, 0x97, 0xbf, 0xf7, 0x3, 0xcf, 0xfb, 0x8f,
    0x70,

    /* U+62 "b" */
    0xbf, 0x50, 0x0, 0x0, 0x0, 0xbf, 0x50, 0x0,
    0x0, 0x0, 0xbf, 0x50, 0x0, 0x0, 0x0, 0xbf,
    0x6a, 0xff, 0xb4, 0x0, 0xbf, 0xff, 0xde, 0xff,
    0x50, 0xbf, 0xe2, 0x0, 0x7f, 0xe0, 0xbf, 0x70,
    0x0, 0xd, 0xf4, 0xbf, 0x40, 0x0, 0xa, 0xf5,
    0xbf, 0x70, 0x0, 0xd, 0xf4, 0xbf, 0xe2, 0x0,
    0x7f, 0xe0, 0xbf, 0xff, 0xde, 0xff, 0x50, 0xbf,
    0x5a, 0xff, 0xc4, 0x0,

    /* U+63 "c" */
    0x0, 0x3a, 0xef, 0xc6, 0x0, 0x4f, 0xfe, 0xcf,
    0xf7, 0xe, 0xf7, 0x0, 0x2c, 0x44, 0xfd, 0x0,
    0x0, 0x0, 0x5f, 0xa0, 0x0, 0x0, 0x4, 0xfd,
    0x0, 0x0, 0x0, 0xe, 0xf7, 0x0, 0x2c, 0x40,
    0x4f, 0xfe, 0xdf, 0xf7, 0x0, 0x3a, 0xef, 0xc6,
    0x0,

    /* U+64 "d" */
    0x0, 0x0, 0x0, 0x5, 0xfb, 0x0, 0x0, 0x0,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x5, 0xfb, 0x0,
    0x4b, 0xff, 0xa6, 0xfb, 0x5, 0xff, 0xed, 0xff,
    0xfb, 0xe, 0xf7, 0x0, 0x2e, 0xfb, 0x4f, 0xd0,
    0x0, 0x7, 0xfb, 0x5f, 0xa0, 0x0, 0x4, 0xfb,
    0x4f, 0xc0, 0x0, 0x7, 0xfb, 0xe, 0xf5, 0x0,
    0x1e, 0xfb, 0x5, 0xff, 0xcb, 0xff, 0xfb, 0x0,
    0x4c, 0xff, 0xb6, 0xfb,

    /* U+65 "e" */
    0x0, 0x3b, 0xef, 0xb3, 0x0, 0x5, 0xff, 0xcc,
    0xff, 0x40, 0xe, 0xf4, 0x0, 0x4f, 0xd0, 0x4f,
    0xc1, 0x11, 0x1b, 0xf3, 0x5f, 0xff, 0xff, 0xff,
    0xf5, 0x4f, 0xd4, 0x44, 0x44, 0x41, 0xe, 0xf5,
    0x0, 0x7, 0x0, 0x4, 0xff, 0xec, 0xff, 0x80,
    0x0, 0x3a, 0xef, 0xd8, 0x0,

    /* U+66 "f" */
    0x0, 0x5d, 0xfe, 0x30, 0x2f, 0xfb, 0xd1, 0x6,
    0xf9, 0x0, 0xd, 0xff, 0xff, 0xe0, 0x8c, 0xfd,
    0xa9, 0x0, 0x6f, 0x90, 0x0, 0x6, 0xf9, 0x0,
    0x0, 0x6f, 0x90, 0x0, 0x6, 0xf9, 0x0, 0x0,
    0x6f, 0x90, 0x0, 0x6, 0xf9, 0x0, 0x0, 0x6f,
    0x90, 0x0,

    /* U+67 "g" */
    0x0, 0x4b, 0xff, 0xa4, 0xfc, 0x5, 0xff, 0xed,
    0xff, 0xfc, 0xe, 0xf7, 0x0, 0x2e, 0xfc, 0x4f,
    0xd0, 0x0, 0x5, 0xfc, 0x5f, 0xa0, 0x0, 0x3,
    0xfc, 0x4f, 0xd0, 0x0, 0x6, 0xfc, 0xe, 0xf7,
    0x0, 0x2e, 0xfc, 0x5, 0xff, 0xed, 0xff, 0xfc,
    0x0, 0x4b, 0xff, 0xb6, 0xfb, 0x1, 0x30, 0x0,
    0xb, 0xf7, 0xb, 0xfe, 0xdc, 0xff, 0xd0, 0x1,
    0x8d, 0xff, 0xd9, 0x10,

    /* U+68 "h" */
    0xbf, 0x50, 0x0, 0x0, 0xb, 0xf5, 0x0, 0x0,
    0x0, 0xbf, 0x50, 0x0, 0x0, 0xb, 0xf7, 0xae,
    0xfb, 0x30, 0xbf, 0xff, 0xdf, 0xff, 0x1b, 0xfe,
    0x20, 0xc, 0xf8, 0xbf, 0x70, 0x0, 0x5f, 0xab,
    0xf5, 0x0, 0x4, 0xfb, 0xbf, 0x50, 0x0, 0x4f,
    0xbb, 0xf5, 0x0, 0x4, 0xfb, 0xbf, 0x50, 0x0,
    0x4f, 0xbb, 0xf5, 0x0, 0x4, 0xfb,

    /* U+69 "i" */
    0x37, 0xe, 0xf8, 0x9f, 0x40, 0x0, 0xbf, 0x5b,
    0xf5, 0xbf, 0x5b, 0xf5, 0xbf, 0x5b, 0xf5, 0xbf,
    0x5b, 0xf5, 0xbf, 0x50,

    /* U+6A "j" */
    0x0, 0x2, 0x71, 0x0, 0xc, 0xf9, 0x0, 0x8,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf6, 0x0,
    0x9, 0xf6, 0x0, 0x9, 0xf6, 0x0, 0x9, 0xf6,
    0x0, 0x9, 0xf6, 0x0, 0x9, 0xf6, 0x0, 0x9,
    0xf6, 0x0, 0x9, 0xf6, 0x0, 0x9, 0xf6, 0x0,
    0xb, 0xf5, 0x1d, 0xcf, 0xf1, 0x3d, 0xfc, 0x30,

    /* U+6B "k" */
    0xbf, 0x50, 0x0, 0x0, 0x0, 0xbf, 0x50, 0x0,
    0x0, 0x0, 0xbf, 0x50, 0x0, 0x0, 0x0, 0xbf,
    0x50, 0x2, 0xef, 0x60, 0xbf, 0x50, 0x2e, 0xf7,
    0x0, 0xbf, 0x52, 0xef, 0x70, 0x0, 0xbf, 0x8e,
    0xf9, 0x0, 0x0, 0xbf, 0xff, 0xfc, 0x0, 0x0,
    0xbf, 0xf7, 0xdf, 0x90, 0x0, 0xbf, 0x80, 0x3f,
    0xf5, 0x0, 0xbf, 0x50, 0x6, 0xfe, 0x20, 0xbf,
    0x50, 0x0, 0x9f, 0xc0,

    /* U+6C "l" */
    0xbf, 0x5b, 0xf5, 0xbf, 0x5b, 0xf5, 0xbf, 0x5b,
    0xf5, 0xbf, 0x5b, 0xf5, 0xbf, 0x5b, 0xf5, 0xbf,
    0x5b, 0xf5,

    /* U+6D "m" */
    0xbf, 0x5b, 0xff, 0xb2, 0x3b, 0xfe, 0xb2, 0xb,
    0xff, 0xfc, 0xef, 0xef, 0xfc, 0xef, 0xe0, 0xbf,
    0xd1, 0x1, 0xef, 0xf2, 0x0, 0xdf, 0x6b, 0xf7,
    0x0, 0x9, 0xf9, 0x0, 0x7, 0xf8, 0xbf, 0x50,
    0x0, 0x8f, 0x70, 0x0, 0x6f, 0x9b, 0xf5, 0x0,
    0x8, 0xf7, 0x0, 0x6, 0xf9, 0xbf, 0x50, 0x0,
    0x8f, 0x70, 0x0, 0x6f, 0x9b, 0xf5, 0x0, 0x8,
    0xf7, 0x0, 0x6, 0xf9, 0xbf, 0x50, 0x0, 0x8f,
    0x70, 0x0, 0x6f, 0x90,

    /* U+6E "n" */
    0xbf, 0x5a, 0xef, 0xb3, 0xb, 0xff, 0xfc, 0xef,
    0xf1, 0xbf, 0xe1, 0x0, 0xbf, 0x8b, 0xf7, 0x0,
    0x5, 0xfa, 0xbf, 0x50, 0x0, 0x4f, 0xbb, 0xf5,
    0x0, 0x4, 0xfb, 0xbf, 0x50, 0x0, 0x4f, 0xbb,
    0xf5, 0x0, 0x4, 0xfb, 0xbf, 0x50, 0x0, 0x4f,
    0xb0,

    /* U+6F "o" */
    0x0, 0x3b, 0xef, 0xc6, 0x0, 0x4, 0xff, 0xed,
    0xff, 0x90, 0xe, 0xf7, 0x0, 0x3f, 0xf3, 0x4f,
    0xd0, 0x0, 0x7, 0xf9, 0x5f, 0xa0, 0x0, 0x5,
    0xfb, 0x4f, 0xd0, 0x0, 0x8, 0xf9, 0xe, 0xf7,
    0x0, 0x3f, 0xf4, 0x4, 0xff, 0xed, 0xff, 0x90,
    0x0, 0x3b, 0xef, 0xc6, 0x0,

    /* U+70 "p" */
    0xbf, 0x5b, 0xff, 0xb4, 0x0, 0xbf, 0xff, 0xbc,
    0xff, 0x50, 0xbf, 0xe1, 0x0, 0x6f, 0xe0, 0xbf,
    0x70, 0x0, 0xd, 0xf4, 0xbf, 0x40, 0x0, 0xa,
    0xf5, 0xbf, 0x70, 0x0, 0xd, 0xf4, 0xbf, 0xe2,
    0x0, 0x8f, 0xe0, 0xbf, 0xff, 0xde, 0xff, 0x50,
    0xbf, 0x6a, 0xff, 0xc4, 0x0, 0xbf, 0x50, 0x0,
    0x0, 0x0, 0xbf, 0x50, 0x0, 0x0, 0x0, 0xbf,
    0x50, 0x0, 0x0, 0x0,

    /* U+71 "q" */
    0x0, 0x4b, 0xff, 0xa5, 0xfa, 0x5, 0xff, 0xed,
    0xff, 0xfa, 0xe, 0xf7, 0x0, 0x3f, 0xfa, 0x4f,
    0xd0, 0x0, 0x7, 0xfa, 0x5f, 0xa0, 0x0, 0x5,
    0xfa, 0x4f, 0xd0, 0x0, 0x8, 0xfa, 0xf, 0xf7,
    0x0, 0x3f, 0xfa, 0x5, 0xff, 0xed, 0xff, 0xfa,
    0x0, 0x4c, 0xff, 0xa6, 0xfa, 0x0, 0x0, 0x0,
    0x5, 0xfa, 0x0, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x0, 0x5, 0xfa,

    /* U+72 "r" */
    0xbf, 0x5a, 0xe3, 0xbf, 0xef, 0xf3, 0xbf, 0xf4,
    0x0, 0xbf, 0x80, 0x0, 0xbf, 0x50, 0x0, 0xbf,
    0x50, 0x0, 0xbf, 0x50, 0x0, 0xbf, 0x50, 0x0,
    0xbf, 0x50, 0x0,

    /* U+73 "s" */
    0x2, 0xae, 0xfd, 0xa2, 0x1f, 0xfc, 0xbd, 0xf3,
    0x5f, 0xa0, 0x0, 0x20, 0x4f, 0xe7, 0x40, 0x0,
    0x8, 0xff, 0xff, 0xb1, 0x0, 0x4, 0x7c, 0xfa,
    0x5, 0x0, 0x3, 0xfc, 0x6f, 0xec, 0xbe, 0xf7,
    0x29, 0xdf, 0xfc, 0x60,

    /* U+74 "t" */
    0x6, 0xf9, 0x0, 0x0, 0x6f, 0x90, 0x0, 0xdf,
    0xff, 0xfe, 0x8, 0xcf, 0xda, 0x90, 0x6, 0xf9,
    0x0, 0x0, 0x6f, 0x90, 0x0, 0x6, 0xf9, 0x0,
    0x0, 0x6f, 0x90, 0x0, 0x5, 0xfb, 0x0, 0x0,
    0x1f, 0xfc, 0xd1, 0x0, 0x4d, 0xfd, 0x30,

    /* U+75 "u" */
    0xcf, 0x40, 0x0, 0x6f, 0x9c, 0xf4, 0x0, 0x6,
    0xf9, 0xcf, 0x40, 0x0, 0x6f, 0x9c, 0xf4, 0x0,
    0x6, 0xf9, 0xcf, 0x40, 0x0, 0x6f, 0x9b, 0xf5,
    0x0, 0x9, 0xf9, 0x8f, 0xb0, 0x2, 0xef, 0x91,
    0xff, 0xdc, 0xff, 0xf9, 0x3, 0xbe, 0xfa, 0x7f,
    0x90,

    /* U+76 "v" */
    0xd, 0xf3, 0x0, 0x0, 0xdf, 0x10, 0x7f, 0x90,
    0x0, 0x3f, 0xb0, 0x1, 0xff, 0x0, 0xa, 0xf4,
    0x0, 0xa, 0xf6, 0x1, 0xfd, 0x0, 0x0, 0x4f,
    0xc0, 0x7f, 0x70, 0x0, 0x0, 0xdf, 0x3d, 0xf1,
    0x0, 0x0, 0x7, 0xfd, 0xfa, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0x40, 0x0, 0x0, 0x0, 0xaf, 0xd0,
    0x0, 0x0,

    /* U+77 "w" */
    0xcf, 0x10, 0x0, 0x9f, 0x60, 0x0, 0x5f, 0x76,
    0xf7, 0x0, 0xf, 0xfc, 0x0, 0xa, 0xf1, 0x1f,
    0xc0, 0x5, 0xff, 0xf1, 0x0, 0xfc, 0x0, 0xbf,
    0x20, 0xaf, 0x8f, 0x70, 0x5f, 0x60, 0x5, 0xf7,
    0x1f, 0xb1, 0xfc, 0xb, 0xf1, 0x0, 0xf, 0xd6,
    0xf6, 0xa, 0xf3, 0xfb, 0x0, 0x0, 0xaf, 0xdf,
    0x0, 0x5f, 0xdf, 0x50, 0x0, 0x5, 0xff, 0xa0,
    0x0, 0xff, 0xf0, 0x0, 0x0, 0xf, 0xf4, 0x0,
    0x9, 0xfa, 0x0, 0x0,

    /* U+78 "x" */
    0x5f, 0xd0, 0x0, 0xaf, 0x70, 0xa, 0xf9, 0x5,
    0xfc, 0x0, 0x0, 0xdf, 0x6f, 0xe1, 0x0, 0x0,
    0x3f, 0xff, 0x50, 0x0, 0x0, 0xb, 0xfd, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0x70, 0x0, 0x1, 0xef,
    0x3e, 0xf3, 0x0, 0xc, 0xf6, 0x4, 0xfd, 0x0,
    0x7f, 0xb0, 0x0, 0x9f, 0xa0,

    /* U+79 "y" */
    0xd, 0xf3, 0x0, 0x0, 0xdf, 0x10, 0x7f, 0xa0,
    0x0, 0x3f, 0xa0, 0x0, 0xff, 0x10, 0xa, 0xf3,
    0x0, 0x9, 0xf7, 0x1, 0xfd, 0x0, 0x0, 0x2f,
    0xd0, 0x8f, 0x60, 0x0, 0x0, 0xbf, 0x5e, 0xe0,
    0x0, 0x0, 0x4, 0xfe, 0xf8, 0x0, 0x0, 0x0,
    0xd, 0xff, 0x20, 0x0, 0x0, 0x0, 0x7f, 0xb0,
    0x0, 0x0, 0x10, 0xb, 0xf4, 0x0, 0x0, 0xe,
    0xdd, 0xfb, 0x0, 0x0, 0x0, 0xae, 0xea, 0x10,
    0x0, 0x0,

    /* U+7A "z" */
    0x4f, 0xff, 0xff, 0xfd, 0x3a, 0xaa, 0xaf, 0xfa,
    0x0, 0x0, 0x5f, 0xd1, 0x0, 0x2, 0xff, 0x30,
    0x0, 0xd, 0xf5, 0x0, 0x0, 0xbf, 0x90, 0x0,
    0x7, 0xfc, 0x0, 0x0, 0x3f, 0xfc, 0xaa, 0xaa,
    0x6f, 0xff, 0xff, 0xff,

    /* U+7B "{" */
    0x0, 0x2b, 0xfa, 0x0, 0xaf, 0xe6, 0x0, 0xdf,
    0x30, 0x0, 0xef, 0x20, 0x0, 0xef, 0x20, 0x0,
    0xef, 0x10, 0x1c, 0xfe, 0x0, 0x2f, 0xfa, 0x0,
    0x1, 0xff, 0x10, 0x0, 0xef, 0x20, 0x0, 0xef,
    0x20, 0x0, 0xef, 0x20, 0x0, 0xdf, 0x30, 0x0,
    0x9f, 0xe7, 0x0, 0x1b, 0xfa,

    /* U+7C "|" */
    0x8f, 0x58, 0xf5, 0x8f, 0x58, 0xf5, 0x8f, 0x58,
    0xf5, 0x8f, 0x58, 0xf5, 0x8f, 0x58, 0xf5, 0x8f,
    0x58, 0xf5, 0x8f, 0x58, 0xf5, 0x8f, 0x50,

    /* U+7D "}" */
    0xbf, 0xb1, 0x0, 0x7e, 0xf9, 0x0, 0x4, 0xfc,
    0x0, 0x3, 0xfd, 0x0, 0x3, 0xfd, 0x0, 0x2,
    0xfd, 0x0, 0x0, 0xef, 0xb0, 0x0, 0xcf, 0xf1,
    0x2, 0xfe, 0x0, 0x3, 0xfd, 0x0, 0x3, 0xfd,
    0x0, 0x3, 0xfd, 0x0, 0x4, 0xfc, 0x0, 0x8e,
    0xf8, 0x0, 0xbe, 0xa1, 0x0,

    /* U+7E "~" */
    0x0, 0x77, 0x20, 0x6, 0x40, 0xaf, 0xff, 0x63,
    0xf6, 0xf, 0x71, 0x9f, 0xfd, 0x0, 0x40, 0x0,
    0x13, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 71, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 71, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24, .adv_w = 106, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 39, .adv_w = 182, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 111, .adv_w = 161, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 191, .adv_w = 220, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 275, .adv_w = 181, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 353, .adv_w = 56, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 361, .adv_w = 89, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 399, .adv_w = 89, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 437, .adv_w = 106, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 462, .adv_w = 151, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 494, .adv_w = 62, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 506, .adv_w = 99, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 512, .adv_w = 62, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 518, .adv_w = 95, .box_w = 8, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 582, .adv_w = 172, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 648, .adv_w = 98, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 678, .adv_w = 149, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 732, .adv_w = 149, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 786, .adv_w = 174, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 852, .adv_w = 150, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 906, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 966, .adv_w = 156, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1026, .adv_w = 167, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1086, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1146, .adv_w = 62, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1164, .adv_w = 62, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1188, .adv_w = 151, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 1224, .adv_w = 151, .box_w = 8, .box_h = 6, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1248, .adv_w = 151, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 1284, .adv_w = 149, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1338, .adv_w = 265, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1458, .adv_w = 192, .box_w = 14, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1542, .adv_w = 195, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1608, .adv_w = 186, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1680, .adv_w = 211, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1752, .adv_w = 172, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1806, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1860, .adv_w = 198, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1932, .adv_w = 207, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1998, .adv_w = 82, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2016, .adv_w = 135, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2070, .adv_w = 187, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2136, .adv_w = 153, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2190, .adv_w = 244, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2268, .adv_w = 207, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2334, .adv_w = 216, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2412, .adv_w = 186, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2472, .adv_w = 216, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2577, .adv_w = 187, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2643, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2703, .adv_w = 154, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2763, .adv_w = 202, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2829, .adv_w = 187, .box_w = 13, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2907, .adv_w = 293, .box_w = 18, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3015, .adv_w = 177, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3081, .adv_w = 169, .box_w = 12, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3153, .adv_w = 170, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3219, .adv_w = 90, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3257, .adv_w = 95, .box_w = 8, .box_h = 16, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 3321, .adv_w = 90, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3359, .adv_w = 151, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 3387, .adv_w = 128, .box_w = 8, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3399, .adv_w = 154, .box_w = 6, .box_h = 3, .ofs_x = 1, .ofs_y = 10},
    {.bitmap_index = 3408, .adv_w = 155, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3449, .adv_w = 176, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3509, .adv_w = 149, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3550, .adv_w = 176, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3610, .adv_w = 159, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3655, .adv_w = 94, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3697, .adv_w = 178, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3757, .adv_w = 175, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3811, .adv_w = 74, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3831, .adv_w = 76, .box_w = 6, .box_h = 16, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 3879, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3939, .adv_w = 74, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3957, .adv_w = 270, .box_w = 15, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4025, .adv_w = 175, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4066, .adv_w = 165, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4111, .adv_w = 176, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4171, .adv_w = 176, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4231, .adv_w = 108, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4258, .adv_w = 132, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4294, .adv_w = 109, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4333, .adv_w = 174, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4374, .adv_w = 148, .box_w = 11, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4424, .adv_w = 235, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4492, .adv_w = 147, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4537, .adv_w = 148, .box_w = 11, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 4603, .adv_w = 136, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4639, .adv_w = 95, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4684, .adv_w = 78, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4707, .adv_w = 95, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4752, .adv_w = 151, .box_w = 9, .box_h = 4, .ofs_x = 0, .ofs_y = 4}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 0, 1, 2, 0, 3, 4, 5,
    2, 6, 7, 8, 9, 10, 9, 10,
    11, 12, 0, 13, 14, 15, 16, 17,
    18, 19, 12, 20, 20, 0, 0, 0,
    21, 22, 23, 24, 25, 22, 26, 27,
    28, 29, 29, 30, 31, 32, 29, 29,
    22, 33, 34, 35, 3, 36, 30, 37,
    37, 38, 39, 40, 41, 42, 43, 0,
    44, 0, 45, 46, 47, 48, 49, 50,
    51, 45, 52, 52, 53, 48, 45, 45,
    46, 46, 54, 55, 56, 57, 51, 58,
    58, 59, 58, 60, 41, 0, 0, 9
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 1, 2, 0, 3, 4, 5,
    2, 6, 7, 8, 9, 10, 9, 10,
    11, 12, 13, 14, 15, 16, 17, 12,
    18, 19, 20, 21, 21, 0, 0, 0,
    22, 23, 24, 25, 23, 25, 25, 25,
    23, 25, 25, 26, 25, 25, 25, 25,
    23, 25, 23, 25, 3, 27, 28, 29,
    29, 30, 31, 32, 33, 34, 35, 0,
    36, 0, 37, 38, 39, 39, 39, 0,
    39, 38, 40, 41, 38, 38, 42, 42,
    39, 42, 39, 42, 43, 44, 45, 46,
    46, 47, 46, 48, 0, 0, 35, 9
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 3, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 12, 0, 6, -5, 0, 0, 0,
    0, -14, -15, 1, 12, 5, 4, -10,
    1, 12, 1, 10, 3, 8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 15, 3, -1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, -5,
    4, 5, 0, 0, -3, 0, -1, 3,
    0, -3, 0, -3, -1, -5, 0, 0,
    0, 0, -3, 0, 0, -3, -4, 0,
    0, -3, 0, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, -6, 0, -31, 0, 0, -5, 0,
    5, 8, 0, 0, -5, 3, 3, 8,
    5, -4, 5, 0, 0, -14, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -9, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, -12, 0, -10, -1, 0, 0, 0,
    0, 0, 9, 0, -8, -3, -1, 1,
    0, -4, 0, 0, -2, -18, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -20, -3, 8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 9, 0, 3, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 3, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    2, 5, 3, 8, -3, 0, 0, 5,
    -3, -9, -35, 1, 6, 5, 0, -3,
    0, 8, 0, 8, 0, 8, 0, -24,
    0, -3, 8, 0, 8, -3, 5, 3,
    0, 0, 1, -3, 0, 0, -4, 20,
    0, 20, 0, 8, 0, 10, 4, 4,
    0, 0, 0, -9, 0, 0, 0, 0,
    1, -2, 0, 1, -5, -4, -5, 1,
    0, -3, 0, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, -14, 0, -17, 0, 0, 0, 0,
    -2, 0, 24, -3, -4, 3, 3, -1,
    0, -4, 3, 0, 0, -14, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -24, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 15, 0, 0, -9, 0, 9, 0,
    -18, -24, -18, -5, 8, 0, 0, -17,
    0, 3, -6, 0, -4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 5, 8, -31, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 1,
    1, -3, -5, 0, -1, -1, -3, 0,
    0, -1, 0, 0, 0, -5, 0, -3,
    0, -6, -5, 0, -6, -9, -9, -4,
    0, -5, 0, -5, 0, 0, 0, 0,
    -2, 0, 0, 3, 0, 1, -3, 0,
    0, 0, 0, 3, -1, 0, 0, 0,
    -1, 3, 3, -1, 0, 0, 0, -4,
    0, -1, 0, 0, 0, 0, 0, 1,
    0, 4, -1, 0, -3, 0, -4, 0,
    0, -1, 0, 8, 0, 0, -3, 0,
    0, 0, 0, 0, -1, 1, -1, -1,
    0, -3, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -1, -1, 0,
    -3, -3, 0, 0, 0, 0, 0, 1,
    0, 0, -2, 0, -3, -3, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, 0, 0, -2, -4, 0,
    0, -8, -1, -8, 5, 0, 0, -5,
    3, 5, 6, 0, -6, -1, -3, 0,
    -1, -12, 3, -1, 2, -14, 3, 0,
    0, 1, -13, 0, -14, -3, -22, -1,
    0, -13, 0, 5, 7, 0, 4, 0,
    0, 0, 0, 1, 0, -5, -4, 0,
    0, 0, 0, -3, 0, 0, 0, -3,
    0, 0, 0, 0, 0, -1, -1, 0,
    -1, -3, 0, 0, 0, 0, 0, 0,
    0, -3, -3, 0, -2, -3, -2, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, -1, 0, -5, 3, 0, 0, -3,
    1, 3, 3, 0, 0, 0, 0, 0,
    0, -1, 0, 0, 0, 0, 0, 1,
    0, 0, -3, 0, -3, -1, -3, 0,
    0, 0, 0, 0, 0, 0, 2, 0,
    -2, 0, 0, 0, 0, -3, -4, 0,
    0, 8, -1, 1, -8, 0, 0, 6,
    -13, -13, -10, -5, 3, 0, -2, -17,
    -5, 0, -5, 0, -5, 4, -5, -16,
    0, -6, 0, 0, 1, -1, 3, -1,
    0, 3, 1, -8, -10, 0, -13, -6,
    -5, -6, -8, -3, -6, 0, -4, -6,
    0, 1, 0, -3, 0, 0, 0, 1,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -1,
    0, -1, -3, 0, -4, -6, -6, -1,
    0, -8, 0, 0, 0, 0, 0, 0,
    -2, 0, 0, 0, 0, 1, -2, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 13, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, 0, 0, -4, 0, 0, 0,
    0, -13, -8, 0, 0, 0, -4, -13,
    0, 0, -3, 3, 0, -6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 3, 0,
    1, -5, -5, 0, -3, -3, -3, 0,
    0, 0, 0, 0, 0, -8, 0, -3,
    0, -4, -3, 0, -6, -6, -8, -2,
    0, -5, 1, -8, 0, 0, 0, 0,
    20, 0, 0, 1, 0, 0, -4, 0,
    0, -11, 0, 0, 0, 0, 0, -24,
    -5, 8, 8, -3, -11, 0, 3, -4,
    0, -13, -1, -3, 3, -18, -3, 5,
    0, 4, -9, -4, -9, -9, -11, 0,
    0, -15, 0, 14, 0, 0, -1, 0,
    0, 0, -1, -1, -3, -7, -9, -1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, -1, -3, -4, 0,
    0, -5, 0, -3, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -1, 0, -5, 0, 0, 5,
    -1, 3, 0, -5, 3, -1, -1, -5,
    -3, 0, -3, -3, -2, 0, -4, -4,
    0, 0, -2, -1, -1, -4, -3, 0,
    0, -3, 0, 3, -1, 0, -5, 0,
    0, 0, -5, 0, -4, 0, -4, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 3, 0, -3, 0, -1, -3, -6,
    -1, -1, -1, -1, -1, -3, -1, 0,
    0, 0, 0, 0, -3, -2, -2, 0,
    0, 0, 0, 3, -1, 0, -1, 0,
    0, 0, -1, -3, -1, -2, -3, -2,
    3, 10, -1, 0, -6, 0, -1, 5,
    0, -3, -10, -3, 4, 1, 0, -12,
    -4, 3, -4, 2, 0, -1, -2, -8,
    0, -4, 1, 0, 0, -4, 0, 0,
    0, 3, 3, -5, -4, 0, -4, -3,
    -4, -3, -3, 0, -4, 1, -4, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -2, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    0, 0, -3, 0, 0, -3, -3, 0,
    0, 0, 0, -3, 0, 0, 0, 0,
    -1, 0, 0, 0, 0, 0, -1, 0,
    0, 0, -4, 0, -5, 0, 0, 0,
    -9, 0, 1, -6, 5, 1, -1, -12,
    0, 0, -6, -3, 0, -10, -6, -8,
    0, 0, -12, -3, -10, -10, -13, 0,
    -5, 0, 3, 17, -3, 0, -6, -3,
    -1, -3, -4, -6, -5, -9, -11, -6,
    0, 0, -1, 0, 1, 0, 0, -18,
    -1, 8, 5, -5, -9, 0, 1, -6,
    0, -13, -1, -3, 5, -23, -3, 1,
    0, 0, -17, -3, -13, -3, -19, 0,
    0, -18, 0, 14, 1, 0, -1, 0,
    0, 0, 0, -1, -1, -10, -1, 0,
    0, 0, 0, 0, -8, 0, -2, 0,
    -1, -7, -12, 0, 0, -1, -4, -8,
    -3, 0, -2, 0, 0, 0, 0, -12,
    -3, -8, -8, -3, -4, -6, -3, -4,
    0, -5, -2, -9, -4, 0, -3, -4,
    -3, -4, 0, 1, 0, -1, -8, 0,
    0, -5, 0, 0, 0, 0, 3, 0,
    1, -5, 12, 0, -3, -3, -3, 0,
    0, 0, 0, 0, 0, -8, 0, -3,
    0, -4, -3, 0, -6, -6, -8, -2,
    0, -5, 3, 10, 0, 0, 0, 0,
    20, 0, 0, 1, 0, 0, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, 0, 0, 0, 0, -1, -5,
    0, 0, 0, 0, 0, -1, 0, 0,
    0, -3, -3, 0, 0, -5, -3, 0,
    0, -5, 0, 4, -1, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0,
    5, 3, -2, 0, -8, -3, 0, 8,
    -9, -8, -5, -5, 10, 5, 3, -22,
    -2, 5, -3, 0, -3, 4, -3, -9,
    0, -3, 3, -3, -3, -8, -3, 0,
    0, 8, 5, 0, -7, 0, -14, -3,
    9, -3, -10, 1, -3, -8, -8, -3,
    3, 0, -4, 0, -6, 0, 3, 8,
    -6, -9, -10, -6, 8, 0, 1, -19,
    -3, 3, -4, -2, -6, 0, -6, -9,
    -4, -4, -3, 0, 0, -6, -6, -3,
    0, 8, 6, -3, -14, 0, -14, -3,
    0, -9, -15, -1, -8, -4, -8, -8,
    0, 0, -3, 0, -5, -2, 0, -3,
    -5, 0, 4, -9, 3, 0, 0, -14,
    0, -3, -6, -4, -2, -8, -6, -9,
    -6, 0, -8, -3, -6, -4, -8, -3,
    0, 0, 1, 12, -4, 0, -8, -3,
    0, -3, -5, -6, -7, -8, -10, -4,
    5, 0, -4, 0, -13, -3, 2, 5,
    -8, -9, -5, -9, 9, -3, 1, -24,
    -5, 5, -6, -4, -9, 0, -8, -11,
    -3, -3, -3, -3, -6, -8, -1, 0,
    0, 8, 8, -1, -17, 0, -15, -4,
    8, -10, -18, -5, -9, -11, -13, -9,
    0, 0, 0, 0, -3, 0, 0, 3,
    -3, 5, 1, -4, 5, 0, 0, -6,
    -1, 0, -1, 0, 1, 1, -2, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 3, 8, 1, 0, -3, 0,
    0, 0, 0, -1, -1, -3, 0, 0,
    1, 3, 0, 0, 0, 0, 3, 0,
    -2, 0, 10, 0, 5, 1, 1, -4,
    0, 5, 0, 0, 0, 3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 8, 0, 8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, 0, -3, 4, 0, 8, 0,
    0, 24, 3, -5, -5, 3, 3, -1,
    1, -13, 0, 0, 13, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -18, 10, 36, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, -4, -2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -1, 0, -6, 0, 0, 1, 0,
    0, 3, 32, -5, -2, 8, 6, -6,
    3, 0, 0, 3, 3, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -33, 8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -7, 0, 0, 0, -6,
    0, 0, 0, 0, -5, -1, 0, 0,
    0, -5, 0, -3, 0, -12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, -4, 0, -6, 0, 0, 0, -4,
    3, -3, 0, 0, -6, -3, -6, 0,
    0, -6, 0, -3, 0, -12, 0, -4,
    0, 0, -19, -4, -10, -4, -10, 0,
    0, -17, 0, -6, -2, 0, 0, 0,
    0, 0, 0, 0, 0, -4, -5, -2,
    0, 0, 0, 0, -5, 0, -6, 4,
    -4, 5, 0, -1, -6, -1, -4, -4,
    0, -3, -1, -1, 2, -6, -1, 0,
    0, 0, -20, -3, -5, 0, -8, 0,
    -1, -12, -2, 0, 0, -1, -2, 0,
    0, 0, 0, 2, 0, -2, -4, -1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 7, 0, 0, 0, 0,
    0, -5, 0, -1, 0, 0, 0, -5,
    3, 0, 0, 0, -6, -3, -5, 0,
    0, -7, 0, -3, 0, -12, 0, 0,
    0, 0, -24, 0, -5, -9, -13, 0,
    0, -17, 0, -2, -4, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -4, -1,
    1, 0, 0, 4, -4, 0, 9, 12,
    -3, -3, -8, 3, 12, 4, 5, -6,
    3, 10, 3, 7, 5, 6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 16, 12, -5, -3, 0, -2, 20,
    12, 20, 0, 0, 0, 3, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0,
    0, 0, -19, -3, -3, -9, -12, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0,
    0, 0, -19, -3, -3, -9, -12, 0,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -3, 0, 0, 0,
    -6, 3, 0, -3, 3, 5, 3, -8,
    0, 0, -3, 3, 0, 3, 0, 0,
    0, 0, -4, 0, -2, -1, -5, 0,
    -2, -10, 0, 15, -3, 0, -6, -1,
    0, -1, -4, 0, -3, -8, -5, -3,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 5, 0, 0,
    0, 0, -19, -3, -3, -9, -12, 0,
    0, -17, 0, 0, 0, 0, 0, 0,
    13, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -3, 0, -8, -3, -2, 8,
    -2, -3, -10, 1, 0, 1, -1, -6,
    1, 6, 1, 3, 1, 3, -6, -11,
    -3, 0, -8, -4, -6, -10, -9, 0,
    -3, -5, -3, -4, -2, -1, -3, -1,
    0, -1, -1, 4, 0, 4, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -1, -3, -3, 0,
    0, -6, 0, -1, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, -3, 0,
    0, 0, 0, 0, -2, 0, 0, -4,
    -3, 3, 0, -4, -4, -1, 0, -6,
    -1, -5, -2, -3, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 8, 0, 0, -5, 0,
    0, 0, 0, -3, 0, -3, 0, 0,
    0, 0, -1, 0, -6, 0, 0, 10,
    -4, -8, -8, 1, 4, 4, 0, -8,
    1, 4, 1, 8, 1, 9, -1, -7,
    0, 0, -7, 0, 0, -8, -6, 0,
    0, -5, 0, -4, -4, 0, -4, 0,
    -4, 0, -2, 4, 0, -3, -8, -3,
    0, 0, -2, 0, -5, 0, 0, 4,
    -6, 0, 3, -3, 3, 1, 0, -9,
    0, -1, -1, 0, -3, 4, -3, 0,
    0, 0, -8, -3, -6, 0, -8, 0,
    0, -12, 0, 9, -3, 0, -5, 0,
    4, 0, -3, 0, -3, -8, 0, -3,
    0, 0, 0, 0, -1, 0, 0, 3,
    -3, 1, 0, 0, -3, -1, 0, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, 0, 5, 0, 0, -2, 0,
    0, 0, 0, 1, 0, -3, -3, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 60,
    .right_class_cnt     = 48,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 1,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t lv_demo_music_font_16_bold = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 17,          /*The maximum line height required by the font*/
    .base_line = 3,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0)
    .underline_position = -1,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};



#endif /*#if LV_DEMO_MUSIC_FONT_16_BOLD*/

#endif /*LV_USE_DEMO_MUSIC*/

