# Mostly copied from https://github.com/stripe/stripe-python/blob/c637f2d435ae19d25df5a6f53466d9ffcdac6bd8/stripe/util.py

import logging
import os
import re
import six
import sys

import spackle

SPACKLE_LOG = os.environ.get("SPACKLE_LOG")

logger = logging.getLogger("spackle")


def _console_log_level():
    if spackle.log in ["debug", "info", "warn"]:
        return spackle.log
    elif SPACKLE_LOG in ["debug", "info", "warn"]:
        return SPACKLE_LOG
    else:
        return None


def log_debug(message, **params):
    msg = logfmt(dict(message=message, **params))
    if _console_log_level() == "debug":
        print(msg, file=sys.stderr)
    logger.debug(msg)


def log_info(message, **params):
    msg = logfmt(dict(message=message, **params))
    if _console_log_level() in ["debug", "info"]:
        print(msg, file=sys.stderr)
    logger.info(msg)


def log_warn(message, **params):
    msg = logfmt(dict(message=message, **params))
    if _console_log_level() in ["debug", "info", "warn"]:
        print(msg, file=sys.stderr)
    logger.warning(msg)


def logfmt(props):
    def fmt(key, val):
        # Handle case where val is a bytes or bytesarray
        if six.PY3 and hasattr(val, "decode"):
            val = val.decode("utf-8")
        # Check if val is already a string to avoid re-encoding into
        # ascii. Since the code is sent through 2to3, we can't just
        # use unicode(val, encoding='utf8') since it will be
        # translated incorrectly.
        if not isinstance(val, six.string_types):
            val = six.text_type(val)
        if re.search(r"\s", val):
            val = repr(val)
        # key should already be a string
        if re.search(r"\s", key):
            key = repr(key)
        return "{key}={val}".format(key=key, val=val)

    return " ".join([fmt(key, val) for key, val in sorted(props.items())])
