---
description: >-
  This document covers the four phases of the Launchable Product Rollout. These
  phases will be driven by the Launchable CS team through weekly recurring
  meetings.
---

# Launchable product rollout

## **Ramping** <a href="#ramping" id="ramping"></a>

* The Launchable CS team will meet with the teams necessary for integration.
  * **Note**: If this project was used for the POC, this phase can be skipped.
  * We will go through the following items:
    * [Intro and education](https://www.launchableinc.com/predictive-test-selection) on Launchable
      * Meet directly with developers to make sure we have a plan for an integration that will provide value.
      * Review integration from technical perspective and make sure it is supported.
        * [Supported integrations](https://docs.launchableinc.com/resources/integrations)
        * [Managing complex integrations](https://docs.launchableinc.com/sending-data-to-launchable/managing-complex-test-session-layouts)

## **Rollout** <a href="#rollout" id="rollout"></a>

* Setup an install session, or verify install after it is completed.
  * **Note**: If this project was used for the POC, we just need to verify that subsetting targets are correct for production usage. Otherwise, this phase can be skipped.
  * [Install docs](https://docs.launchableinc.com/getting-started)
  * Verify data as it comes in:
    * Launchable will collect both build and test data for \~4 weeks.
    * We will provide updates on this, as the model could be ready earlier than this as well.
    * [Implement subsetting](https://docs.launchableinc.com/resources/cli-reference#subset) and verify data.

## **Stabilization** <a href="#stabilization" id="stabilization"></a>

* Launchable will continue to support the team, and make sure the integration is working as intended.
  * Launchable will maintain a weekly call for “office hours”, as rollout continues across other teams.

## **Periodic check-ins** <a href="#periodic-check-ins" id="periodic-check-ins"></a>

* Launchable weekly call will move to a monthly check-in call after all integrations are stabilized.
