# 📚 NLPSTACK

[![Actions Status](https://github.com/altescy/nlpstack/workflows/CI/badge.svg)](https://github.com/altescy/nlpstack/actions/workflows/ci.yml)
[![Python version](https://img.shields.io/pypi/pyversions/nlpstack)](https://github.com/altescy/nlpstack)
[![pypi version](https://img.shields.io/pypi/v/nlpstack)](https://pypi.org/project/nlpstack/)
[![Documentation Status](https://readthedocs.org/projects/nlpstack/badge/?version=latest)](https://nlpstack.readthedocs.io/en/latest/?badge=latest)
[![License](https://img.shields.io/github/license/altescy/nlpstack)](https://github.com/altescy/nlpstack/blob/master/LICENSE)

A Python Library for Natural Language Processing

NLPSTACK is a Python library designed to make natural language processing (NLP) tasks more accessible and efficient.
With its key features listed below, NLPSTACK aims to become a go-to resource for developers working in NLP:

- Built on top of [PyTorch](https://pytorch.org/), NLPSTACK offers ready-to-use modules for a seamless NLP experience.
- Provides a [scikit-learn](https://scikit-learn.org/) compatible interface, ensuring familiar and easy usage.
- Allows for seamless integration of models provided by the [🤗 Transformers](https://github.com/huggingface/transformers), enabling the use of powerful pre-trained models in your NLP workflows.
- Adopts a [dependency injection](https://en.wikipedia.org/wiki/Dependency_injection) design pattern, which ensures high extensibility and makes it easy to modify specific processes.
- 🚧 **Currently in the preliminary stages of development**, NLPSTACK plans to offer user-friendly interfaces for a wide range of NLP tasks in the future, including text classification, sequence labeling, language model training..., and more!

## Installation

To install NLPSTACK, simply use the following command with pip:

```bash
pip install nlpstack
```

Please be aware that NLPSTACK is in its early development stages.
As such, be prepared for the possibility of breaking changes as the library is being developed and refined.
