# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from lusid_notifications.models.amazon_sqs_notification_type import AmazonSqsNotificationType
from lusid_notifications.models.amazon_sqs_principal_auth_notification_type import AmazonSqsPrincipalAuthNotificationType
from lusid_notifications.models.email_notification_type import EmailNotificationType
from lusid_notifications.models.sms_notification_type import SmsNotificationType
from lusid_notifications.models.webhook_notification_type import WebhookNotificationType
from typing import Union, Any, List, TYPE_CHECKING
from pydantic import StrictStr, Field

NOTIFICATIONTYPE_ONE_OF_SCHEMAS = ["AmazonSqsNotificationType", "AmazonSqsPrincipalAuthNotificationType", "EmailNotificationType", "SmsNotificationType", "WebhookNotificationType"]

class NotificationType(BaseModel):
    """
    Holds information about a Finbourne.Notifications.WebApi.Dtos.Notifications.Notification that is being created
    """
    # data type: AmazonSqsNotificationType
    oneof_schema_1_validator: Optional[AmazonSqsNotificationType] = None
    # data type: AmazonSqsPrincipalAuthNotificationType
    oneof_schema_2_validator: Optional[AmazonSqsPrincipalAuthNotificationType] = None
    # data type: EmailNotificationType
    oneof_schema_3_validator: Optional[EmailNotificationType] = None
    # data type: SmsNotificationType
    oneof_schema_4_validator: Optional[SmsNotificationType] = None
    # data type: WebhookNotificationType
    oneof_schema_5_validator: Optional[WebhookNotificationType] = None
    if TYPE_CHECKING:
        actual_instance: Union[AmazonSqsNotificationType, AmazonSqsPrincipalAuthNotificationType, EmailNotificationType, SmsNotificationType, WebhookNotificationType]
    else:
        actual_instance: Any
    one_of_schemas: List[str] = Field(NOTIFICATIONTYPE_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = NotificationType.construct()
        error_messages = []
        match = 0
        # validate data type: AmazonSqsNotificationType
        if not isinstance(v, AmazonSqsNotificationType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AmazonSqsNotificationType`")
        else:
            match += 1
        # validate data type: AmazonSqsPrincipalAuthNotificationType
        if not isinstance(v, AmazonSqsPrincipalAuthNotificationType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `AmazonSqsPrincipalAuthNotificationType`")
        else:
            match += 1
        # validate data type: EmailNotificationType
        if not isinstance(v, EmailNotificationType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `EmailNotificationType`")
        else:
            match += 1
        # validate data type: SmsNotificationType
        if not isinstance(v, SmsNotificationType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `SmsNotificationType`")
        else:
            match += 1
        # validate data type: WebhookNotificationType
        if not isinstance(v, WebhookNotificationType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WebhookNotificationType`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in NotificationType with oneOf schemas: AmazonSqsNotificationType, AmazonSqsPrincipalAuthNotificationType, EmailNotificationType, SmsNotificationType, WebhookNotificationType. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in NotificationType with oneOf schemas: AmazonSqsNotificationType, AmazonSqsPrincipalAuthNotificationType, EmailNotificationType, SmsNotificationType, WebhookNotificationType. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> NotificationType:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> NotificationType:
        """Returns the object represented by the json string"""
        instance = NotificationType.construct()
        error_messages = []
        match = 0

        # deserialize data into AmazonSqsNotificationType
        try:
            instance.actual_instance = AmazonSqsNotificationType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into AmazonSqsPrincipalAuthNotificationType
        try:
            instance.actual_instance = AmazonSqsPrincipalAuthNotificationType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into EmailNotificationType
        try:
            instance.actual_instance = EmailNotificationType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into SmsNotificationType
        try:
            instance.actual_instance = SmsNotificationType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WebhookNotificationType
        try:
            instance.actual_instance = WebhookNotificationType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into NotificationType with oneOf schemas: AmazonSqsNotificationType, AmazonSqsPrincipalAuthNotificationType, EmailNotificationType, SmsNotificationType, WebhookNotificationType. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into NotificationType with oneOf schemas: AmazonSqsNotificationType, AmazonSqsPrincipalAuthNotificationType, EmailNotificationType, SmsNotificationType, WebhookNotificationType. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        to_json = getattr(self.actual_instance, "to_json", None)
        if callable(to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        to_dict = getattr(self.actual_instance, "to_dict", None)
        if callable(to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())
