# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr

class ManualEventHeader(BaseModel):
    """
    The header of the manual event  # noqa: E501
    """
    event_type: Optional[StrictStr] = Field(None, alias="eventType", description="The event type of the manual event")
    timestamp: Optional[datetime] = Field(None, description="The timestamp of the manual event")
    user_id: Optional[StrictStr] = Field(None, alias="userId", description="The user ID of the manual event")
    request_id: Optional[StrictStr] = Field(None, alias="requestId", description="The request ID of the manual event")
    __properties = ["eventType", "timestamp", "userId", "requestId"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ManualEventHeader:
        """Create an instance of ManualEventHeader from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "event_type",
                          },
                          exclude_none=True)
        # set to None if event_type (nullable) is None
        # and __fields_set__ contains the field
        if self.event_type is None and "event_type" in self.__fields_set__:
            _dict['eventType'] = None

        # set to None if user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.user_id is None and "user_id" in self.__fields_set__:
            _dict['userId'] = None

        # set to None if request_id (nullable) is None
        # and __fields_set__ contains the field
        if self.request_id is None and "request_id" in self.__fields_set__:
            _dict['requestId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ManualEventHeader:
        """Create an instance of ManualEventHeader from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ManualEventHeader.parse_obj(obj)

        _obj = ManualEventHeader.parse_obj({
            "event_type": obj.get("eventType"),
            "timestamp": obj.get("timestamp"),
            "user_id": obj.get("userId"),
            "request_id": obj.get("requestId")
        })
        return _obj
