# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist
from lusid_notifications.models.event_field_definition import EventFieldDefinition

class EventTypeSchema(BaseModel):
    """
    An EventType object  # noqa: E501
    """
    id: Optional[StrictStr] = Field(None, description="The identifier of the event type")
    display_name: Optional[StrictStr] = Field(None, alias="displayName", description="Identifier name of the event")
    description: Optional[StrictStr] = Field(None, description="The summary of the event")
    application: Optional[StrictStr] = Field(None, description="The application associated with the event")
    header_schema: Optional[conlist(EventFieldDefinition)] = Field(None, alias="headerSchema", description="The header schema for the event type")
    body_schema: Optional[conlist(EventFieldDefinition)] = Field(None, alias="bodySchema", description="The body schema for the event type")
    href: Optional[StrictStr] = Field(None, description="A URI for retrieving this schema")
    __properties = ["id", "displayName", "description", "application", "headerSchema", "bodySchema", "href"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EventTypeSchema:
        """Create an instance of EventTypeSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "header_schema",
                            "body_schema",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in header_schema (list)
        _items = []
        if self.header_schema:
            for _item in self.header_schema:
                if _item:
                    _items.append(_item.to_dict())
            _dict['headerSchema'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in body_schema (list)
        _items = []
        if self.body_schema:
            for _item in self.body_schema:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bodySchema'] = _items
        # set to None if id (nullable) is None
        # and __fields_set__ contains the field
        if self.id is None and "id" in self.__fields_set__:
            _dict['id'] = None

        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        # set to None if application (nullable) is None
        # and __fields_set__ contains the field
        if self.application is None and "application" in self.__fields_set__:
            _dict['application'] = None

        # set to None if header_schema (nullable) is None
        # and __fields_set__ contains the field
        if self.header_schema is None and "header_schema" in self.__fields_set__:
            _dict['headerSchema'] = None

        # set to None if body_schema (nullable) is None
        # and __fields_set__ contains the field
        if self.body_schema is None and "body_schema" in self.__fields_set__:
            _dict['bodySchema'] = None

        # set to None if href (nullable) is None
        # and __fields_set__ contains the field
        if self.href is None and "href" in self.__fields_set__:
            _dict['href'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EventTypeSchema:
        """Create an instance of EventTypeSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return EventTypeSchema.parse_obj(obj)

        _obj = EventTypeSchema.parse_obj({
            "id": obj.get("id"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description"),
            "application": obj.get("application"),
            "header_schema": [EventFieldDefinition.from_dict(_item) for _item in obj.get("headerSchema")] if obj.get("headerSchema") is not None else None,
            "body_schema": [EventFieldDefinition.from_dict(_item) for _item in obj.get("bodySchema")] if obj.get("bodySchema") is not None else None,
            "href": obj.get("href")
        })
        return _obj
