# coding: utf-8

"""
    FINBOURNE Notifications API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr

class AmazonSqsNotificationTypeResponse(BaseModel):
    """
    Holds readonly information about an AWS SQS notification  # noqa: E501
    """
    type: Optional[StrictStr] = Field(None, description="The type of delivery mechanism for this notification")
    api_key_ref: Optional[StrictStr] = Field(None, alias="apiKeyRef", description="Reference to API key from Configuration Store")
    api_secret_ref: Optional[StrictStr] = Field(None, alias="apiSecretRef", description="Reference to API secret from Configuration Store")
    body: Optional[StrictStr] = Field(None, description="The body of the Amazon Queue Message")
    queue_url_ref: Optional[StrictStr] = Field(None, alias="queueUrlRef", description="Reference to queue url from Configuration Store")
    __properties = ["type", "apiKeyRef", "apiSecretRef", "body", "queueUrlRef"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AmazonSqsNotificationTypeResponse:
        """Create an instance of AmazonSqsNotificationTypeResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if type (nullable) is None
        # and __fields_set__ contains the field
        if self.type is None and "type" in self.__fields_set__:
            _dict['type'] = None

        # set to None if api_key_ref (nullable) is None
        # and __fields_set__ contains the field
        if self.api_key_ref is None and "api_key_ref" in self.__fields_set__:
            _dict['apiKeyRef'] = None

        # set to None if api_secret_ref (nullable) is None
        # and __fields_set__ contains the field
        if self.api_secret_ref is None and "api_secret_ref" in self.__fields_set__:
            _dict['apiSecretRef'] = None

        # set to None if body (nullable) is None
        # and __fields_set__ contains the field
        if self.body is None and "body" in self.__fields_set__:
            _dict['body'] = None

        # set to None if queue_url_ref (nullable) is None
        # and __fields_set__ contains the field
        if self.queue_url_ref is None and "queue_url_ref" in self.__fields_set__:
            _dict['queueUrlRef'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AmazonSqsNotificationTypeResponse:
        """Create an instance of AmazonSqsNotificationTypeResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AmazonSqsNotificationTypeResponse.parse_obj(obj)

        _obj = AmazonSqsNotificationTypeResponse.parse_obj({
            "type": obj.get("type"),
            "api_key_ref": obj.get("apiKeyRef"),
            "api_secret_ref": obj.get("apiSecretRef"),
            "body": obj.get("body"),
            "queue_url_ref": obj.get("queueUrlRef")
        })
        return _obj
