function(target_add_sanitizers TARGET_NAME)
    get_target_property(target_type ${TARGET_NAME} TYPE)
    if(target_type MATCHES "LIBRARY")
        set(linker_name "SHARED_LINKER")
    elseif(target_type MATCHES "EXECUTABLE")
        set(linker_name "EXEC_LINKER")
    elseif(target_type MATCHES "MODULE")
        set(linker_name "MODULE_LINKER")
    endif()
    foreach(sanitizer ${ARGN})
        string(TOUPPER "${sanitizer}" sanitizer)
        set(sanitizer_name CMAKE_C_FLAGS_${sanitizer}SANITIZER)
        if(${sanitizer_name})
            string(REPLACE " " ";" compile ${${sanitizer_name}})
            target_compile_options(${TARGET_NAME} PUBLIC ${compile})
        else()
            message(FATAL_ERROR "Uknown sanitizer ${sanitizer}")
        endif()
        set(sanitizer_name CMAKE_${linker_name}_FLAGS_${sanitizer}SANITIZER)
        if(${sanitizer_name})
            string(REPLACE " " ";" compile ${${sanitizer_name}})
            target_link_options(${TARGET_NAME} PUBLIC ${compile})
        endif()
    endforeach()
endfunction()
