# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class FinanceDTO(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'currency_id': 'int',
        'total_agreed': 'float',
        'total_cost': 'float',
        'profit': 'float',
        'margin': 'float',
        'receivables': 'list[ChargeDTO]',
        'payables': 'list[ChargeDTO]',
        'roi': 'float'
    }

    attribute_map = {
        'currency_id': 'currencyId',
        'total_agreed': 'totalAgreed',
        'total_cost': 'totalCost',
        'profit': 'profit',
        'margin': 'margin',
        'receivables': 'receivables',
        'payables': 'payables',
        'roi': 'ROI'
    }

    def __init__(self, currency_id=None, total_agreed=None, total_cost=None, profit=None, margin=None, receivables=None, payables=None, roi=None):  # noqa: E501
        """FinanceDTO - a model defined in Swagger"""  # noqa: E501
        self._currency_id = None
        self._total_agreed = None
        self._total_cost = None
        self._profit = None
        self._margin = None
        self._receivables = None
        self._payables = None
        self._roi = None
        self.discriminator = None
        if currency_id is not None:
            self.currency_id = currency_id
        if total_agreed is not None:
            self.total_agreed = total_agreed
        if total_cost is not None:
            self.total_cost = total_cost
        if profit is not None:
            self.profit = profit
        if margin is not None:
            self.margin = margin
        if receivables is not None:
            self.receivables = receivables
        if payables is not None:
            self.payables = payables
        if roi is not None:
            self.roi = roi

    @property
    def currency_id(self):
        """Gets the currency_id of this FinanceDTO.  # noqa: E501


        :return: The currency_id of this FinanceDTO.  # noqa: E501
        :rtype: int
        """
        return self._currency_id

    @currency_id.setter
    def currency_id(self, currency_id):
        """Sets the currency_id of this FinanceDTO.


        :param currency_id: The currency_id of this FinanceDTO.  # noqa: E501
        :type: int
        """

        self._currency_id = currency_id

    @property
    def total_agreed(self):
        """Gets the total_agreed of this FinanceDTO.  # noqa: E501


        :return: The total_agreed of this FinanceDTO.  # noqa: E501
        :rtype: float
        """
        return self._total_agreed

    @total_agreed.setter
    def total_agreed(self, total_agreed):
        """Sets the total_agreed of this FinanceDTO.


        :param total_agreed: The total_agreed of this FinanceDTO.  # noqa: E501
        :type: float
        """

        self._total_agreed = total_agreed

    @property
    def total_cost(self):
        """Gets the total_cost of this FinanceDTO.  # noqa: E501


        :return: The total_cost of this FinanceDTO.  # noqa: E501
        :rtype: float
        """
        return self._total_cost

    @total_cost.setter
    def total_cost(self, total_cost):
        """Sets the total_cost of this FinanceDTO.


        :param total_cost: The total_cost of this FinanceDTO.  # noqa: E501
        :type: float
        """

        self._total_cost = total_cost

    @property
    def profit(self):
        """Gets the profit of this FinanceDTO.  # noqa: E501


        :return: The profit of this FinanceDTO.  # noqa: E501
        :rtype: float
        """
        return self._profit

    @profit.setter
    def profit(self, profit):
        """Sets the profit of this FinanceDTO.


        :param profit: The profit of this FinanceDTO.  # noqa: E501
        :type: float
        """

        self._profit = profit

    @property
    def margin(self):
        """Gets the margin of this FinanceDTO.  # noqa: E501


        :return: The margin of this FinanceDTO.  # noqa: E501
        :rtype: float
        """
        return self._margin

    @margin.setter
    def margin(self, margin):
        """Sets the margin of this FinanceDTO.


        :param margin: The margin of this FinanceDTO.  # noqa: E501
        :type: float
        """

        self._margin = margin

    @property
    def receivables(self):
        """Gets the receivables of this FinanceDTO.  # noqa: E501


        :return: The receivables of this FinanceDTO.  # noqa: E501
        :rtype: list[ChargeDTO]
        """
        return self._receivables

    @receivables.setter
    def receivables(self, receivables):
        """Sets the receivables of this FinanceDTO.


        :param receivables: The receivables of this FinanceDTO.  # noqa: E501
        :type: list[ChargeDTO]
        """

        self._receivables = receivables

    @property
    def payables(self):
        """Gets the payables of this FinanceDTO.  # noqa: E501


        :return: The payables of this FinanceDTO.  # noqa: E501
        :rtype: list[ChargeDTO]
        """
        return self._payables

    @payables.setter
    def payables(self, payables):
        """Sets the payables of this FinanceDTO.


        :param payables: The payables of this FinanceDTO.  # noqa: E501
        :type: list[ChargeDTO]
        """

        self._payables = payables

    @property
    def roi(self):
        """Gets the roi of this FinanceDTO.  # noqa: E501


        :return: The roi of this FinanceDTO.  # noqa: E501
        :rtype: float
        """
        return self._roi

    @roi.setter
    def roi(self, roi):
        """Sets the roi of this FinanceDTO.


        :param roi: The roi of this FinanceDTO.  # noqa: E501
        :type: float
        """

        self._roi = roi

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(FinanceDTO, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FinanceDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
