# coding: utf-8

"""
    XTRF Home Portal API

    XTRF Home Portal API enables you to perform operations on Projects, Quotes, Customers, Vendors etc. as a XTRF Home Portal user. <br>The documentation is generated from OpenAPI specification 3.0 available <a href=\"/home-api/openapi.json\">here</a> <br>   The API client/consumer code may be easily generated in 60+ programming languages using an open source code generator available at the time of writing this documentation at <a href='https://editor.swagger.io/'>https://editor.swagger.io/</a> Thank you for using XTRF Application Programming interface (XTRF API). By using the API you agree to the terms below. If you disagree with any of these terms, XTRF does not grant you a license to use the XTRF API. XTRF reserves the right to update and change these terms from time to time without a prior notice of API users. You can always find the most recent version of these terms here:   # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from xtrf_api.api_client import ApiClient


class VendorInvoicesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create1(self, body, **kwargs):  # noqa: E501
        """Creates a new invoice.  # noqa: E501

        Creates a new invoice from jobs. Jobs are grouped by provider and currency, therefore multiple invoices can be created.If any of the jobs cannot be invoiced (ie. it is already invoiced) then an error is reported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create1(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProviderInvoiceCreateDTO body: Created new invoice. (required)
        :return: ProviderInvoiceCreateResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create1_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create1_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create1_with_http_info(self, body, **kwargs):  # noqa: E501
        """Creates a new invoice.  # noqa: E501

        Creates a new invoice from jobs. Jobs are grouped by provider and currency, therefore multiple invoices can be created.If any of the jobs cannot be invoiced (ie. it is already invoiced) then an error is reported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create1_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProviderInvoiceCreateDTO body: Created new invoice. (required)
        :return: ProviderInvoiceCreateResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create1`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/invoices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProviderInvoiceCreateResultDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_payment(self, body, invoice_id, **kwargs):  # noqa: E501
        """Creates a new payment on the vendor account and assigns the payment to the invoice.  # noqa: E501

        Creates a new payment on the vendor account and assigns the payment to the invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payment(body, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentDTO body: New payment. (required)
        :param int invoice_id: vendor invoice's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_payment_with_http_info(body, invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_payment_with_http_info(body, invoice_id, **kwargs)  # noqa: E501
            return data

    def create_payment_with_http_info(self, body, invoice_id, **kwargs):  # noqa: E501
        """Creates a new payment on the vendor account and assigns the payment to the invoice.  # noqa: E501

        Creates a new payment on the vendor account and assigns the payment to the invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_payment_with_http_info(body, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PaymentDTO body: New payment. (required)
        :param int invoice_id: vendor invoice's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_payment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_payment`")  # noqa: E501
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `create_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/invoices/{invoiceId}/payments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete2(self, invoice_id, **kwargs):  # noqa: E501
        """Removes a provider invoice.  # noqa: E501

        Removes a provider invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete2(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_id: provider invoice's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete2_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete2_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def delete2_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Removes a provider invoice.  # noqa: E501

        Removes a provider invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete2_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_id: provider invoice's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `delete2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/invoices/{invoiceId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete2_0(self, payment_id, **kwargs):  # noqa: E501
        """Removes a provider payment.  # noqa: E501

        Removes a provider payment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete2_0(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int payment_id: provider payment's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete2_0_with_http_info(payment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete2_0_with_http_info(payment_id, **kwargs)  # noqa: E501
            return data

    def delete2_0_with_http_info(self, payment_id, **kwargs):  # noqa: E501
        """Removes a provider payment.  # noqa: E501

        Removes a provider payment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete2_0_with_http_info(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int payment_id: provider payment's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete2_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payment_id' is set
        if ('payment_id' not in params or
                params['payment_id'] is None):
            raise ValueError("Missing the required parameter `payment_id` when calling `delete2_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in params:
            path_params['paymentId'] = params['payment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/payments/{paymentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all2(self, **kwargs):  # noqa: E501
        """Lists all vendor invoices in all statuses (including not ready and drafts) that have been updated since a specific date.  # noqa: E501

        Lists all vendor invoices in all statuses (including not ready and drafts) that have been updated since a specific date.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all2(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only vendor invoices modified since this timestamp
        :return: list[ProviderInvoiceDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all2_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all2_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all2_with_http_info(self, **kwargs):  # noqa: E501
        """Lists all vendor invoices in all statuses (including not ready and drafts) that have been updated since a specific date.  # noqa: E501

        Lists all vendor invoices in all statuses (including not ready and drafts) that have been updated since a specific date.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all2_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only vendor invoices modified since this timestamp
        :return: list[ProviderInvoiceDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updated_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all2" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'updated_since' in params:
            query_params.append(('updatedSince', params['updated_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/invoices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ProviderInvoiceDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_ids3(self, **kwargs):  # noqa: E501
        """Returns vendor invoices' internal identifiers.  # noqa: E501

        Returns vendor invoices' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids3(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only vendor invoices modified since this timestamp
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_ids3_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_ids3_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_ids3_with_http_info(self, **kwargs):  # noqa: E501
        """Returns vendor invoices' internal identifiers.  # noqa: E501

        Returns vendor invoices' internal identifiers.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_ids3_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int updated_since: only vendor invoices modified since this timestamp
        :return: list[int]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['updated_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_ids3" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'updated_since' in params:
            query_params.append(('updatedSince', params['updated_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/invoices/ids', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[int]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_by_id3(self, invoice_id, **kwargs):  # noqa: E501
        """Returns provider invoice details.  # noqa: E501

        Returns provider invoice details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id3(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_id: provider invoice's internal identifier (required)
        :return: ProviderInvoiceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_by_id3_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_by_id3_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def get_by_id3_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Returns provider invoice details.  # noqa: E501

        Returns provider invoice details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id3_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_id: provider invoice's internal identifier (required)
        :return: ProviderInvoiceDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id3" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `get_by_id3`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/invoices/{invoiceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ProviderInvoiceDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_document1(self, invoice_id, **kwargs):  # noqa: E501
        """Generates provider invoice document (PDF).  # noqa: E501

        Generates provider invoice document (PDF).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document1(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_id: provider invoice's internal identifier (required)
        :return: UrlResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_document1_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_document1_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def get_document1_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Generates provider invoice document (PDF).  # noqa: E501

        Generates provider invoice document (PDF).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document1_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_id: provider invoice's internal identifier (required)
        :return: UrlResultDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `get_document1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/invoices/{invoiceId}/document', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='UrlResultDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payments1(self, invoice_id, **kwargs):  # noqa: E501
        """Returns all payments for the vendor invoice.  # noqa: E501

        Returns all payments for the vendor invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments1(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_id: vendor invoice's internal identifier (required)
        :return: list[PaymentDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_payments1_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_payments1_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def get_payments1_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Returns all payments for the vendor invoice.  # noqa: E501

        Returns all payments for the vendor invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments1_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_id: vendor invoice's internal identifier (required)
        :return: list[PaymentDTO]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payments1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `get_payments1`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.xtrf-v1+json;charset=UTF-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/invoices/{invoiceId}/payments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PaymentDTO]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send(self, invoice_id, **kwargs):  # noqa: E501
        """Sends a provider invoice.  # noqa: E501

        Sends a provider invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_id: provider invoice's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.send_with_http_info(invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.send_with_http_info(invoice_id, **kwargs)  # noqa: E501
            return data

    def send_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Sends a provider invoice.  # noqa: E501

        Sends a provider invoice.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int invoice_id: provider invoice's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `send`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/invoices/{invoiceId}/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_status(self, body, invoice_id, **kwargs):  # noqa: E501
        """Changes invoice status to given status.  # noqa: E501

        Changes invoice status to given status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_status(body, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProviderInvoiceCreateResultDTO body: Changed invoice status to given status. (required)
        :param int invoice_id: provider invoice's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_status_with_http_info(body, invoice_id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_status_with_http_info(body, invoice_id, **kwargs)  # noqa: E501
            return data

    def set_status_with_http_info(self, body, invoice_id, **kwargs):  # noqa: E501
        """Changes invoice status to given status.  # noqa: E501

        Changes invoice status to given status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_status_with_http_info(body, invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProviderInvoiceCreateResultDTO body: Changed invoice status to given status. (required)
        :param int invoice_id: provider invoice's internal identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'invoice_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `set_status`")  # noqa: E501
        # verify the required parameter 'invoice_id' is set
        if ('invoice_id' not in params or
                params['invoice_id'] is None):
            raise ValueError("Missing the required parameter `invoice_id` when calling `set_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in params:
            path_params['invoiceId'] = params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['X-AUTH-ACCESS-TOKEN']  # noqa: E501

        return self.api_client.call_api(
            '/accounting/providers/invoices/{invoiceId}/status', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
