"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = exports.VersionProviderResource = void 0;
const custom_resource_1 = require("../lib/custom-resource");
const version_provider_1 = require("../lib/version-provider");
class VersionProviderResource extends custom_resource_1.SimpleCustomResource {
    constructor(indexFilePath) {
        super();
        this.versionProvider = new version_provider_1.VersionProvider(indexFilePath);
    }
    /**
     * @inheritdoc
     */
    /* istanbul ignore next */ // @ts-ignore
    validateInput(data) {
        return this.versionProvider.implementsIVersionProviderProperties(data);
    }
    /**
     * @inheritdoc
     */
    // @ts-ignore  -- we do not use the physicalId
    async doCreate(physicalId, resourceProperties) {
        return await this.versionProvider.getVersionUris(resourceProperties);
    }
    /**
     * @inheritdoc
     */
    /* istanbul ignore next */ // @ts-ignore
    async doDelete(physicalId, resourceProperties) {
        // Nothing to do -- we don't modify anything.
        return;
    }
}
exports.VersionProviderResource = VersionProviderResource;
/**
 * The handler used to provide the installer links for the requested version
 */
/* istanbul ignore next */
async function handler(event, context) {
    const versionProvider = new VersionProviderResource();
    return await versionProvider.handler(event, context);
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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