"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendCfnResponse = exports.CfnResponseStatus = void 0;
/* istanbul ignore file */
/* eslint-disable no-console */
/**
 * This module contains a simple helper function for sending the expected Custom Resource
 * response to CloudFormation.
 */
const https = require("https");
const url = require("url");
var CfnResponseStatus;
(function (CfnResponseStatus) {
    CfnResponseStatus["SUCCESS"] = "SUCCESS";
    CfnResponseStatus["FAILED"] = "FAILED";
})(CfnResponseStatus = exports.CfnResponseStatus || (exports.CfnResponseStatus = {}));
async function sendCfnResponse(args) {
    var _a, _b;
    // Construct the CustomResource response.
    // See: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/crpg-ref-responses.html
    const responseObject = {
        Status: args.status,
        Reason: (_a = args.reason) !== null && _a !== void 0 ? _a : `See CloudWatch Logs -- Group: '${args.context.logGroupName}'  Stream: '${args.context.logStreamName}'`,
        PhysicalResourceId: (_b = args.physicalId) !== null && _b !== void 0 ? _b : args.context.logGroupName + args.context.logStreamName,
        StackId: args.event.StackId,
        RequestId: args.event.RequestId,
        LogicalResourceId: args.event.LogicalResourceId,
        Data: args.data,
    };
    const responseBody = JSON.stringify(responseObject);
    const responseHeaders = {
        'content-type': '',
        'content-length': responseBody.length,
    };
    console.log(`CfnResponse: ${responseBody}`);
    const parsedUrl = url.parse(args.event.ResponseURL);
    const requestPromise = new Promise((resolve, reject) => {
        try {
            const request = https.request({
                hostname: parsedUrl.host,
                path: parsedUrl.path,
                method: 'PUT',
                headers: responseHeaders,
            }, resolve);
            request.on('error', reject);
            request.write(responseBody);
            request.end();
        }
        catch (e) {
            reject(e);
        }
    });
    try {
        await requestPromise;
    }
    catch (e) {
        console.error(`Could not send CustomResource response: ${JSON.stringify(e)}`);
        throw e;
    }
}
exports.sendCfnResponse = sendCfnResponse;
//# sourceMappingURL=data:application/json;base64,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