/*!
 * Copyright (c) 2012 - 2022, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
const main = (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.lenght-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
function _(t,_,n,o,r){o();t(1).__exportStar(t(2),n),t(69)},
function _(t,e,r,n,o){n();var a=function(t,e){return a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[r]=e[r])},a(t,e)};r.__extends=function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)};function i(t){var e="function"==typeof Symbol&&Symbol.iterator,r=e&&t[e],n=0;if(r)return r.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&n>=t.length&&(t=void 0),{value:t&&t[n++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function c(t,e){var r="function"==typeof Symbol&&t[Symbol.iterator];if(!r)return t;var n,o,a=r.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(n=a.next()).done;)i.push(n.value)}catch(t){o={error:t}}finally{try{n&&!n.done&&(r=a.return)&&r.call(a)}finally{if(o)throw o.error}}return i}function u(t){return this instanceof u?(this.v=t,this):new u(t)}r.__assign=function(){return r.__assign=Object.assign||function(t){for(var e,r=1,n=arguments.length;r<n;r++)for(var o in e=arguments[r])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},r.__assign.apply(this,arguments)},r.__rest=function(t,e){var r={};for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&e.indexOf(n)<0&&(r[n]=t[n]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(n=Object.getOwnPropertySymbols(t);o<n.length;o++)e.indexOf(n[o])<0&&Object.prototype.propertyIsEnumerable.call(t,n[o])&&(r[n[o]]=t[n[o]])}return r},r.__decorate=function(t,e,r,n){var o,a=arguments.length,i=a<3?e:null===n?n=Object.getOwnPropertyDescriptor(e,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,r,n);else for(var c=t.length-1;c>=0;c--)(o=t[c])&&(i=(a<3?o(i):a>3?o(e,r,i):o(e,r))||i);return a>3&&i&&Object.defineProperty(e,r,i),i},r.__param=function(t,e){return function(r,n){e(r,n,t)}},r.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},r.__awaiter=function(t,e,r,n){return new(r||(r=Promise))((function(o,a){function i(t){try{u(n.next(t))}catch(t){a(t)}}function c(t){try{u(n.throw(t))}catch(t){a(t)}}function u(t){var e;t.done?o(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e)}))).then(i,c)}u((n=n.apply(t,e||[])).next())}))},r.__generator=function(t,e){var r,n,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:c(0),throw:c(1),return:c(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function c(a){return function(c){return function(a){if(r)throw new TypeError("Generator is already executing.");for(;i;)try{if(r=1,n&&(o=2&a[0]?n.return:a[0]?n.throw||((o=n.return)&&o.call(n),0):n.next)&&!(o=o.call(n,a[1])).done)return o;switch(n=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,n=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],n=0}finally{r=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,c])}}},r.__createBinding=Object.create?function(t,e,r,n){void 0===n&&(n=r);var o=Object.getOwnPropertyDescriptor(e,r);o&&!("get"in o?!e.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return e[r]}}),Object.defineProperty(t,n,o)}:function(t,e,r,n){void 0===n&&(n=r),t[n]=e[r]},r.__exportStar=function(t,e){for(var n in t)"default"===n||Object.prototype.hasOwnProperty.call(e,n)||(0,r.__createBinding)(e,t,n)},r.__values=i,r.__read=c,r.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(c(arguments[e]));return t},r.__spreadArrays=function(){for(var t=0,e=0,r=arguments.length;e<r;e++)t+=arguments[e].length;var n=Array(t),o=0;for(e=0;e<r;e++)for(var a=arguments[e],i=0,c=a.length;i<c;i++,o++)n[o]=a[i];return n},r.__spreadArray=function(t,e,r){if(r||2===arguments.length)for(var n,o=0,a=e.length;o<a;o++)!n&&o in e||(n||(n=Array.prototype.slice.call(e,0,o)),n[o]=e[o]);return t.concat(n||Array.prototype.slice.call(e))},r.__await=u,r.__asyncGenerator=function(t,e,r){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var n,o=r.apply(t,e||[]),a=[];return n={},i("next"),i("throw"),i("return"),n[Symbol.asyncIterator]=function(){return this},n;function i(t){o[t]&&(n[t]=function(e){return new Promise((function(r,n){a.push([t,e,r,n])>1||c(t,e)}))})}function c(t,e){try{(r=o[t](e)).value instanceof u?Promise.resolve(r.value.v).then(f,l):s(a[0][2],r)}catch(t){s(a[0][3],t)}var r}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},r.__asyncDelegator=function(t){var e,r;return e={},n("next"),n("throw",(function(t){throw t})),n("return"),e[Symbol.iterator]=function(){return this},e;function n(n,o){e[n]=t[n]?function(e){return(r=!r)?{value:u(t[n](e)),done:"return"===n}:o?o(e):e}:o}},r.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,r=t[Symbol.asyncIterator];return r?r.call(t):(t=i(t),e={},n("next"),n("throw"),n("return"),e[Symbol.asyncIterator]=function(){return this},e);function n(r){e[r]=t[r]&&function(e){return new Promise((function(n,o){(function(t,e,r,n){Promise.resolve(n).then((function(e){t({value:e,done:r})}),e)})(n,o,(e=t[r](e)).done,e.value)}))}}},r.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t};var f=Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e};r.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n in t)"default"!==n&&Object.prototype.hasOwnProperty.call(t,n)&&(0,r.__createBinding)(e,t,n);return f(e,t),e},r.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},r.__classPrivateFieldGet=function(t,e,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof e?t!==e||!n:!e.has(t))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(t):n?n.value:e.get(t)},r.__classPrivateFieldSet=function(t,e,r,n,o){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!o)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof e?t!==e||!o:!e.has(t))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?o.call(t,r):o?o.value=r:e.set(t,r),r},r.__classPrivateFieldIn=function(t,e){if(null===e||"object"!=typeof e&&"function"!=typeof e)throw new TypeError("Cannot use 'in' operator on non-object");return"function"==typeof t?e===t:t.has(e)}},
function _(e,t,o,s,l){s();const r=e(1);l("version",e(3).version),l("index",e(4).index),o.embed=r.__importStar(e(4)),o.protocol=r.__importStar(e(66)),o._testing=r.__importStar(e(67));var _=e(18);l("logger",_.logger),l("set_log_level",_.set_log_level),l("settings",e(28).settings),l("Models",e(7).default_resolver),l("documents",e(5).documents),l("safely",e(68).safely)},
function _(n,e,i,o,v){o(),i.version="3.0.0-dev.16"},
function _(e,o,n,t,s){t();const r=e(5),d=e(18),i=e(38),_=e(9),c=e(8),a=e(16),u=e(52),l=e(59),m=e(64);var f=e(52);s("add_document_standalone",f.add_document_standalone),s("index",f.index),s("add_document_from_session",e(59).add_document_from_session);var w=e(65);async function g(e,o,n,t){(0,c.isString)(e)&&(e=JSON.parse((0,i.unescape)(e)));const s={};for(const[o,n]of(0,_.entries)(e))s[o]=r.Document.from_json(n);const a=[];for(const e of o){const o=(0,m._resolve_element)(e),r=(0,m._resolve_root_elements)(e);if(null!=e.docid)a.push(await(0,u.add_document_standalone)(s[e.docid],o,r,e.use_for_title));else{if(null==e.token)throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");{const s=(0,l._get_ws_url)(n,t);d.logger.debug(`embed: computed ws url: ${s}`);try{a.push(await(0,l.add_document_from_session)(s,e.token,o,r,e.use_for_title)),console.log("Bokeh items were rendered successfully")}catch(e){console.log("Error rendering Bokeh items:",e)}}}}return a}s("embed_items_notebook",w.embed_items_notebook),s("kernels",w.kernels),n.embed_item=async function(e,o){const n={},t=(0,i.uuid4)();n[t]=e.doc,null==o&&(o=e.target_id);const s={roots:{[e.root_id]:o},root_ids:[e.root_id],docid:t};await(0,a.defer)();const[r]=await g(n,[s]);return r},n.embed_items=async function(e,o,n,t){return await(0,a.defer)(),g(e,o,n,t)}},
function _(t,_,o,r,n){r();const a=t(1);a.__exportStar(t(6),o),a.__exportStar(t(39),o)},
function _(e,t,s,o,n){o();const i=e(1),_=e(7),r=e(3),l=e(18),a=e(46),c=e(45),d=e(30),h=e(47),m=e(15),u=e(25),f=e(10),v=i.__importStar(e(43)),g=e(50),p=e(51),w=e(39);h.Deserializer.register("model",p.decode_def);class b{constructor(e){this.document=e,this.subscribed_models=new Set}send_event(e){const t=new w.MessageSentEvent(this.document,"bokeh_event",e);this.document._trigger_on_change(t)}trigger(e){for(const t of this.subscribed_models)null!=e.origin&&e.origin!=t||t._process_event(e)}}s.EventManager=b,b.__name__="EventManager",s.documents=[],s.DEFAULT_TITLE="Bokeh Application";class y{constructor(e){var t;s.documents.push(this),this._init_timestamp=Date.now(),this._resolver=null!==(t=null==e?void 0:e.resolver)&&void 0!==t?t:new c.ModelResolver(_.default_resolver),this._title=s.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._new_models=new Set,this._all_models_freeze_count=0,this._callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new b(this),this.idle=new m.Signal0(this,"idle"),this._idle_roots=new WeakSet,this._interactive_timestamp=null,this._interactive_plot=null}[u.equals](e,t){return this==e}get is_idle(){for(const e of this._roots)if(!this._idle_roots.has(e))return!1;return!0}notify_idle(e){this._idle_roots.add(e),this.is_idle&&(l.logger.info(`document idle at ${Date.now()-this._init_timestamp} ms`),this.event_manager.send_event(new a.DocumentReady),this.idle.emit())}clear(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}}interactive_start(e,t=null){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new a.LODStart)),this._interactive_finalize=t,this._interactive_timestamp=Date.now()}interactive_stop(){null!=this._interactive_plot&&(this._interactive_plot.trigger_event(new a.LODEnd),null!=this._interactive_finalize&&this._interactive_finalize()),this._interactive_plot=null,this._interactive_timestamp=null,this._interactive_finalize=null}interactive_duration(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp}destructively_move(e){if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();const t=(0,f.copy)(this._roots);this.clear();for(const e of t)if(null!=e.document)throw new Error(`Somehow we didn't detach ${e}`);if(0!=this._all_models.size)throw new Error(`this._all_models still had stuff in it: ${this._all_models}`);for(const s of t)e.add_root(s);e.set_title(this._title)}_push_all_models_freeze(){this._all_models_freeze_count+=1}_pop_all_models_freeze(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()}_invalidate_all_models(){l.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()}_recompute_all_models(){let e=new Set;for(const t of this._roots)e=v.union(e,t.references());const t=new Set(this._all_models.values()),s=v.difference(t,e),o=v.difference(e,t),n=new Map;for(const t of e)n.set(t.id,t);for(const e of s)e.detach_document();for(const e of o)e.attach_document(this),this._new_models.add(e);this._all_models=n}roots(){return this._roots}_add_root(e){if((0,f.includes)(this._roots,e))return!1;this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}return!0}_remove_root(e){const t=this._roots.indexOf(e);if(t<0)return!1;this._push_all_models_freeze();try{this._roots.splice(t,1)}finally{this._pop_all_models_freeze()}return!0}_set_title(e){const t=e!=this._title;return t&&(this._title=e),t}add_root(e){this._add_root(e)&&this._trigger_on_change(new w.RootAddedEvent(this,e))}remove_root(e){this._remove_root(e)&&this._trigger_on_change(new w.RootRemovedEvent(this,e))}set_title(e){this._set_title(e)&&this._trigger_on_change(new w.TitleChangedEvent(this,e))}title(){return this._title}get_model_by_id(e){var t;return null!==(t=this._all_models.get(e))&&void 0!==t?t:null}get_model_by_name(e){const t=[];for(const s of this._all_models.values())s instanceof g.Model&&s.name==e&&t.push(s);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error(`Multiple models are named '${e}'`)}}on_message(e,t){const s=this._message_callbacks.get(e);null==s?this._message_callbacks.set(e,new Set([t])):s.add(t)}remove_on_message(e,t){var s;null===(s=this._message_callbacks.get(e))||void 0===s||s.delete(t)}_trigger_on_message(e,t){const s=this._message_callbacks.get(e);if(null!=s)for(const e of s)e(t)}on_change(e,t=!1){this._callbacks.has(e)||this._callbacks.set(e,t)}remove_on_change(e){this._callbacks.delete(e)}_trigger_on_change(e){for(const[t,s]of this._callbacks)if(!s&&e instanceof w.DocumentEventBatch)for(const s of e.events)t(s);else t(e)}to_json_string(e=!0){return JSON.stringify(this.to_json(e))}to_json(e=!0){const t=new d.Serializer({include_defaults:e}).encode(this._roots);return{version:r.version,title:this._title,roots:t}}static from_json_string(e,t){const s=JSON.parse(e);return y.from_json(s,t)}static _handle_version(e){if(null!=e.version){const t=e.version,s=-1!==t.indexOf("+")||-1!==t.indexOf("-"),o=`Library versions: JS (${r.version}) / Python (${t})`;s||r.version.replace(/-(dev|rc)\./,"$1")==t?l.logger.debug(o):(l.logger.warn("JS/Python version mismatch"),l.logger.warn(o))}else l.logger.warn("'version' field is missing")}static from_json(e,t){l.logger.debug("Creating Document from JSON"),y._handle_version(e);const s=new c.ModelResolver(_.default_resolver);if(null!=e.defs){new h.Deserializer(s).decode(e.defs)}const o=new y({resolver:s});o._push_all_models_freeze();const n=e=>null==t?void 0:t.push(e);o.on_change(n,!0);const i=new h.Deserializer(s,o._all_models,(e=>e.attach_document(o))).decode(e.roots);o.remove_on_change(n);for(const e of i)o.add_root(e);return null!=e.title&&o.set_title(e.title),o._pop_all_models_freeze(),o}replace_with_json(e){y.from_json(e).destructively_move(this)}create_json_patch(e){for(const t of e)if(t.document!=this)throw new Error("Cannot create a patch using events from a different document");const t=new Map;for(const e of this._all_models.values())this._new_models.has(e)||t.set(e,e.ref());const s={events:new d.Serializer({references:t,binary:!0}).encode(e)};return this._new_models.clear(),s}apply_json_patch(e,t=new Map){this._push_all_models_freeze();const s=new h.Deserializer(this._resolver,this._all_models,(e=>e.attach_document(this))).decode(e.events,t);for(const e of s)switch(e.kind){case"MessageSent":{const{msg_type:t,msg_data:s}=e;this._trigger_on_message(t,s);break}case"ModelChanged":{const{model:t,attr:s,new:o}=e;t.setv({[s]:o},{sync:!1});break}case"ColumnDataChanged":{const{model:t,attr:s,cols:o,data:n}=e;if(null!=o){const e=t.property(s).get_value();for(const t in e)t in n||(n[t]=e[t])}t.setv({data:n},{sync:!1,check_eq:!1});break}case"ColumnsStreamed":{const{model:t,attr:s,data:o,rollover:n}=e,i=t.property(s);t.stream_to(i,o,n,{sync:!1});break}case"ColumnsPatched":{const{model:t,attr:s,patches:o}=e,n=t.property(s);t.patch_to(n,o,{sync:!1});break}case"RootAdded":this._add_root(e.model);break;case"RootRemoved":this._remove_root(e.model);break;case"TitleChanged":this._set_title(e.title);break;default:throw new Error(`unknown patch event type '${e.kind}'`)}this._pop_all_models_freeze()}}s.Document=y,y.__name__="Document"},
function _(e,o,r,s,t){s();const l=e(8),n=e(9),a=e(14),f=e(45);r.default_resolver=new f.ModelResolver(null),r.register_models=function(e,o=!1){for(const t of(0,l.isArray)(e)?e:(0,n.values)(e))s=t,(0,l.isObject)(s)&&s.prototype instanceof a.HasProps&&r.default_resolver.register(t,o);var s}},
function _(n,t,r,i,o){i();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const e=Object.prototype.toString;function u(n){return null==n}function c(n){return!0===n||!1===n||"[object Boolean]"===e.call(n)}function f(n){return"[object Number]"===e.call(n)}function s(n){return"[object String]"===e.call(n)}function l(n){return"symbol"==typeof n}function a(n){const t=typeof n;return"function"===t||"object"===t&&!!n}function b(n){return a(n)&&Symbol.iterator in n}r.is_undefined=function(n){return void 0===n},r.is_defined=function(n){return void 0!==n},r.is_nullish=u,r.isBoolean=c,r.isNumber=f,r.isInteger=function(n){return f(n)&&Number.isInteger(n)},r.isString=s,r.isSymbol=l,r.isPrimitive=function(n){return null===n||c(n)||f(n)||s(n)||l(n)},r.isFunction=function(n){const t=e.call(n);return"[object Function]"===t||"[object AsyncFunction]"===t},r.isArray=function(n){return Array.isArray(n)},r.isArrayOf=function(n,t){for(const r of n)if(!t(r))return!1;return!0},r.isArrayableOf=function(n,t){for(const r of n)if(!t(r))return!1;return!0},r.isTypedArray=function(n){return ArrayBuffer.isView(n)&&!(n instanceof DataView)},r.isObject=a,r.isBasicObject=function(n){return a(n)&&u(n.constructor)},r.isPlainObject=function(n){return a(n)&&(u(n.constructor)||n.constructor===Object)},r.isIterable=b,r.isArrayable=function(n){return b(n)&&"length"in n}},
function _(t,e,s,n,i){var o;n();const r=t(10),{hasOwnProperty:c}=Object.prototype;function b(t){return Object.keys(t).length}s.keys=Object.keys,s.values=Object.values,s.entries=Object.entries,s.assign=Object.assign,s.to_object=Object.fromEntries,s.extend=s.assign,s.clone=function(t){return Object.assign({},t)},s.merge=function(t,e){const s=Object.create(Object.prototype),n=(0,r.concat)([Object.keys(t),Object.keys(e)]);for(const i of n){const n=c.call(t,i)?t[i]:[],o=c.call(e,i)?e[i]:[];s[i]=(0,r.union)(n,o)}return s},s.size=b,s.is_empty=function(t){return 0==b(t)};class j{constructor(t){this.obj=t,this[o]="Dict"}clear(){for(const t of(0,s.keys)(this.obj))delete this.obj[t]}delete(t){const e=t in this;return delete this.obj[t],e}get(t){return t in this.obj?this.obj[t]:void 0}has(t){return t in this.obj}set(t,e){return this.obj[t]=e,this}get size(){return b(this.obj)}get is_empty(){return 0==this.size}[(o=Symbol.toStringTag,Symbol.iterator)](){return this.entries()}*keys(){yield*(0,s.keys)(this.obj)}*values(){yield*(0,s.values)(this.obj)}*entries(){yield*(0,s.entries)(this.obj)}forEach(t,e){for(const[s,n]of this.entries())t.call(e,n,s,this)}}s.Dict=j,j.__name__="Dict",s.dict=function(t){return new j(t)}},
function _(n,t,e,r,o){r();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const i=n(11),u=n(12),c=n(13);o("map",c.map),o("reduce",c.reduce),o("min",c.min),o("min_by",c.min_by),o("max",c.max),o("max_by",c.max_by),o("sum",c.sum),o("cumsum",c.cumsum),o("every",c.every),o("some",c.some),o("find",c.find),o("find_last",c.find_last),o("find_index",c.find_index),o("find_last_index",c.find_last_index),o("sorted_index",c.sorted_index),o("is_empty",c.is_empty);const f=Array.prototype.slice;function s(n){return f.call(n)}function a(n){return[].concat(...n)}function l(n,t){return-1!==n.indexOf(t)}function m(n,t,e=1){(0,u.assert)(e>0,"'step' must be a positive number"),null==t&&(t=n,n=0);const{max:r,ceil:o,abs:i}=Math,c=n<=t?e:-e,f=r(o(i(t-n)/e),0),s=new Array(f);for(let t=0;t<f;t++,n+=c)s[t]=n;return s}e.head=function(n){return n[0]},e.tail=function(n){return n[n.length-1]},e.last=function(n){return n[n.length-1]},e.copy=s,e.concat=a,e.includes=l,e.contains=l,e.nth=function(n,t){return n[t>=0?t:n.length+t]},e.zip=function(...n){if(0==n.length)return[];const t=(0,c.min)(n.map((n=>n.length))),e=n.length,r=new Array(t);for(let o=0;o<t;o++){r[o]=new Array(e);for(let t=0;t<e;t++)r[o][t]=n[t][o]}return r},e.unzip=function(n){const t=n.length,e=(0,c.min)(n.map((n=>n.length))),r=Array(e);for(let n=0;n<e;n++)r[n]=new Array(t);for(let o=0;o<t;o++)for(let t=0;t<e;t++)r[t][o]=n[o][t];return r},e.range=m,e.linspace=function(n,t,e=100){const r=(t-n)/(e-1),o=new Array(e);for(let t=0;t<e;t++)o[t]=n+r*t;return o},e.transpose=function(n){const t=n.length,e=n[0].length,r=[];for(let o=0;o<e;o++){r[o]=[];for(let e=0;e<t;e++)r[o][e]=n[e][o]}return r},e.argmin=function(n){return(0,c.min_by)(m(n.length),(t=>n[t]))},e.argmax=function(n){return(0,c.max_by)(m(n.length),(t=>n[t]))},e.sort_by=function(n,t){const e=n.map(((n,e)=>({value:n,index:e,key:t(n)})));return e.sort(((n,t)=>{const e=n.key,r=t.key;if(e!==r){if(e>r)return 1;if(e<r)return-1}return n.index-t.index})),e.map((n=>n.value))},e.uniq=function(n){const t=new Set;for(const e of n)t.add(e);return[...t]},e.uniq_by=function(n,t){const e=[],r=[];for(const o of n){const n=t(o);l(r,n)||(r.push(n),e.push(o))}return e},e.union=function(...n){const t=new Set;for(const e of n)for(const n of e)t.add(n);return[...t]},e.intersection=function(n,...t){const e=[];n:for(const r of n)if(!l(e,r)){for(const n of t)if(!l(n,r))continue n;e.push(r)}return e},e.difference=function(n,...t){const e=a(t);return n.filter((n=>!l(e,n)))},e.remove_at=function(n,t){const e=s(n);return e.splice(t,1),e},e.remove_by=function(n,t){for(let e=0;e<n.length;)t(n[e])?n.splice(e,1):e++},e.clear=function(n){n.splice(0,n.length)},e.shuffle=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++){const t=(0,i.randomIn)(0,r);t!==r&&(e[r]=e[t]),e[t]=n[r]}return e},e.pairwise=function(n,t){const e=n.length,r=new Array(e-1);for(let o=0;o<e-1;o++)r[o]=t(n[o],n[o+1]);return r},e.reversed=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++)e[t-r-1]=n[r];return e},e.repeat=function(n,t){const e=new Array(t);for(let r=0;r<t;r++)e[r]=n;return e}},
function _(n,t,r,o,e){o();const a=n(8),u=n(12),{PI:i,abs:c,sign:f}=Math;function l(n){if(0==n)return 0;for(;n<=0;)n+=2*i;for(;n>2*i;)n-=2*i;return n}function s(n,t){return l(n-t)}function h(){return Math.random()}function m(n){switch(n){case"deg":return i/180;case"rad":return 1;case"grad":return i/200;case"turn":return 2*i}}function d(n,t){for(n=Math.abs(n),t=Math.abs(t);0!=t;)[n,t]=[t,n%t];return n}r.angle_norm=l,r.angle_dist=s,r.angle_between=function(n,t,r,o=!1){const e=s(t,r);if(0==e)return!1;if(e==2*i)return!0;const a=l(n),u=s(t,a)<=e&&s(a,r)<=e;return o?!u:u},r.random=h,r.randomIn=function(n,t){return null==t&&(t=n,n=0),n+Math.floor(Math.random()*(t-n+1))},r.atan2=function(n,t){return Math.atan2(t[1]-n[1],t[0]-n[0])},r.radians=function(n){return n*(i/180)},r.degrees=function(n){return n/(i/180)},r.resolve_angle=function(n,t){return-m(t)*n},r.to_radians_coeff=m,r.rnorm=function(n,t){let r,o;for(;r=h(),o=h(),o=(2*o-1)*Math.sqrt(1/Math.E*2),!(-4*r*r*Math.log(r)>=o*o););let e=o/r;return e=n+t*e,e},r.clamp=function(n,t,r){return n<t?t:n>r?r:n},r.log=function(n,t=Math.E){return Math.log(n)/Math.log(t)},r.gcd=d,r.lcm=function(n,...t){for(const r of t)n=Math.floor(n*r/d(n,r));return n},r.float=Symbol("float"),r.is_Floating=function(n){return(0,a.isObject)(n)&&r.float in n};class g{constructor(n,t){(0,u.assert)(0!=t,"Zero divisor");const r=d(n,t),o=f(n)*f(t);this.numer=o*c(n)/r,this.denom=c(t)/r}[r.float](){return this.numer/this.denom}toString(){return`${this.numer}/${this.denom}`}}function M(n){let t=1;for(let r=2;r<=n;r++)t*=r;return t}r.Fraction=g,g.__name__="Fraction",r.float32_epsilon=1.1920928955078125e-7,r.factorial=M,r.hermite=function(n){const t=new Array(n+1);t.fill(0);const r=M(n);for(let o=0;o<=Math.floor(n/2);o++){const e=(-1)**o*r/(M(o)*M(n-2*o))*2**(n-2*o);t[2*o]=e}return t},r.eval_poly=function(n,t){let r=0,o=1;for(let e=n.length-1;e>=0;e--)r+=o*n[e],o*=t;return r}},
function _(r,n,e,o,s){o();class t extends Error{}e.AssertionError=t,t.__name__="AssertionError",e.assert=function(r,n){if(!(!0===r||!1!==r&&r()))throw new t(null!=n?n:"Assertion failed")},e.unreachable=function(){throw new Error("unreachable code")}},
function _(n,t,e,r,o){r();const i=n(11);function l(n,t,e,...r){const o=n.length;t<0&&(t+=o),t<0?t=0:t>o&&(t=o),null==e||e>o-t?e=o-t:e<0&&(e=0);const i=o-e+r.length,l=new n.constructor(i);let u=0;for(;u<t;u++)l[u]=n[u];for(const n of r)l[u++]=n;for(let r=t+e;r<o;r++)l[u++]=n[r];return l}function u(n,t){return l(n,t,n.length-t)}function c(n,t){const e=n.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=t(n[o],o,n);return r}function f(n,t,e){const r=n.length;if(void 0===e&&0==r)throw new Error("can't reduce an empty array without an initial value");let o,i;for(void 0===e?(o=n[0],i=1):(o=e,i=0);i<r;i++)o=t(o,n[i],i,n);return o}function s(n){return function(t,e){const r=t.length;let o=n>0?0:r-1;for(;o>=0&&o<r;o+=n)if(e(t[o]))return o;return-1}}function h(n,t){let e=0,r=n.length;for(;e<r;){const o=Math.floor((e+r)/2);n[o]<t?e=o+1:r=o}return e}function a(n,t,e,r,o){const i=(o-e)/(r-t);let l=i*(n-t)+e;return isFinite(l)||(l=i*(n-r)+o,isFinite(l)||e!=o||(l=e)),l}function g(n,t){if(n<t[0])return-1;if(n>t[t.length-1])return t.length;let e=0,r=t.length-1;for(;r-e!=1;){const o=e+Math.floor((r-e)/2);n>=t[o]?e=o:r=o}return e}e.is_empty=function(n){return 0==n.length},e.copy=function(n){return Array.isArray(n)?n.slice():new n.constructor(n)},e.splice=l,e.head=u,e.insert=function(n,t,e){return l(n,e,0,t)},e.append=function(n,t){return l(n,n.length,0,t)},e.prepend=function(n,t){return l(n,0,0,t)},e.indexOf=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.subselect=function(n,t){const e=t.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=n[t[o]];return r},e.mul=function(n,t,e){const r=n.length,o=null!=e?e:new n.constructor(r);for(let e=0;e<r;e++)o[e]=n[e]*t;return o},e.map=c,e.inplace_map=function(n,t,e){const r=n.length,o=null!=e?e:n;for(let e=0;e<r;e++)o[e]=t(n[e],e)},e.filter=function(n,t){const e=n.length,r=new n.constructor(e);let o=0;for(let i=0;i<e;i++){const e=n[i];t(e,i,n)&&(r[o++]=e)}return u(r,o)},e.reduce=f,e.min=function(n){let t,e=1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],!isNaN(t)&&t<e&&(e=t);return e},e.max=function(n){let t,e=-1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],!isNaN(t)&&t>e&&(e=t);return e},e.minmax=function(n){let t,e=1/0,r=-1/0;for(let o=0,i=n.length;o<i;o++)t=n[o],isNaN(t)||(t<e&&(e=t),t>r&&(r=t));return[e,r]},e.minmax2=function(n,t){let e,r,o=1/0,i=-1/0,l=1/0,u=-1/0;const c=Math.min(n.length,t.length);for(let f=0;f<c;f++)e=n[f],r=t[f],isNaN(e)||isNaN(r)||(e<o&&(o=e),e>i&&(i=e),r<l&&(l=r),r>u&&(u=r));return[o,i,l,u]},e.min_by=function(n,t){if(0==n.length)throw new Error("min_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,i=n.length;o<i;o++){const i=n[o],l=t(i);l<r&&(e=i,r=l)}return e},e.max_by=function(n,t){if(0==n.length)throw new Error("max_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,i=n.length;o<i;o++){const i=n[o],l=t(i);l>r&&(e=i,r=l)}return e},e.sum=function(n){let t=0;for(let e=0,r=n.length;e<r;e++)t+=n[e];return t},e.cumsum=function(n){const t=new n.constructor(n.length);return f(n,((n,e,r)=>t[r]=n+e),0),t},e.every=function(n,t){for(let e=0,r=n.length;e<r;e++)if(!t(n[e]))return!1;return!0},e.some=function(n,t){for(let e=0,r=n.length;e<r;e++)if(t(n[e]))return!0;return!1},e.index_of=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.find_index=s(1),e.find_last_index=s(-1),e.find=function(n,t){const r=(0,e.find_index)(n,t);return-1==r?void 0:n[r]},e.find_last=function(n,t){const r=(0,e.find_last_index)(n,t);return-1==r?void 0:n[r]},e.sorted_index=h,e.bin_counts=function(n,t){const e=t.length-1,r=Array(e).fill(0);for(let o=0;o<n.length;o++){const l=h(t,n[o]);r[(0,i.clamp)(l-1,0,e-1)]+=1}return r},e.interpolate=function(n,t,e){const r=n.length,o=new Array(r);for(let i=0;i<r;i++){const r=n[i];if(isNaN(r)){o[i]=r;continue}const l=g(r,t);if(-1==l)o[i]=e[0];else if(l==t.length)o[i]=e[e.length-1];else if(l==t.length-1||t[l]==r)o[i]=e[l];else{const n=t[l],u=e[l],c=t[l+1],f=e[l+1];o[i]=a(r,n,u,c,f)}}return o},e.left_edge_index=g,e.norm=function(n,t,e){const r=e-t;return c(n,(n=>(n-t)/r))}},
function _(t,e,s,n,i){n();const r=t(1);var o;const c=t(15),a=r.__importStar(t(17)),h=r.__importStar(t(20)),_=t(12),u=t(38),l=t(9),p=t(8),f=t(25),d=t(30),g=t(39),y=t(25),m=t(40),v=t(41),w=r.__importStar(t(20)),b=t(27),S=t(42),$=new WeakMap;class x extends((0,c.Signalable)()){constructor(t={}){super(),this.document=null,this.destroyed=new c.Signal0(this,"destroyed"),this.change=new c.Signal0(this,"change"),this.transformchange=new c.Signal0(this,"transformchange"),this.exprchange=new c.Signal0(this,"exprchange"),this.streaming=new c.Signal0(this,"streaming"),this.patching=new c.Signal(this,"patching"),this.properties={},this._watchers=new WeakMap,this._pending=!1,this._changing=!1;const e=(0,p.isPlainObject)(t)&&"id"in t;this.id=e?t.id:(0,u.uniqueId)();for(const[t,{type:e,default_value:s,options:n}]of(0,l.entries)(this._props)){let i;e instanceof a.PropertyAlias?Object.defineProperty(this.properties,t,{get:()=>this.properties[e.attr],configurable:!1,enumerable:!1}):(i=e instanceof h.Kind?new a.PrimitiveProperty(this,t,e,s,n):new e(this,t,h.Any,s,n),this.properties[t]=i)}if(e)(0,_.assert)(1==(0,l.keys)(t).length);else{const e=t instanceof Map?t:new l.Dict(t);this.initialize_props(e),this.finalize(),this.connect_signals()}}get is_syncable(){return!0}get type(){return this.constructor.__qualified__}static get __qualified__(){let t=$.get(this);if(null==t){const{__module__:e,__name__:s}=this;t=null!=e?`${e}.${s}`:s,$.set(this,t)}return t}static set __qualified__(t){$.set(this,t)}get[Symbol.toStringTag](){return this.constructor.__qualified__}static _fix_default(t,e){if(void 0===t)return()=>a.unset;if((0,p.isFunction)(t))return t;if((0,p.isPrimitive)(t))return()=>t;{const e=new v.Cloner;return()=>e.clone(t)}}static define(t){for(const[e,s]of(0,l.entries)((0,p.isFunction)(t)?t(w):t)){if(e in this.prototype._props)throw new Error(`attempted to redefine property '${this.prototype.type}.${e}'`);if(e in this.prototype)throw new Error(`attempted to redefine attribute '${this.prototype.type}.${e}'`);Object.defineProperty(this.prototype,e,{get(){return this.properties[e].get_value()},set(t){return this.setv({[e]:t}),this},configurable:!1,enumerable:!0});const[t,n,i={}]=s,r={type:t,default_value:this._fix_default(n,e),options:i},o=Object.assign({},this.prototype._props);o[e]=r,this.prototype._props=o}}static internal(t){const e={};for(const[s,n]of(0,l.entries)((0,p.isFunction)(t)?t(w):t)){const[t,i,r={}]=n;e[s]=[t,i,Object.assign(Object.assign({},r),{internal:!0})]}this.define(e)}static mixins(t){function e(t,e){const s={};for(const[n,i]of(0,l.entries)(e))s[t+n]=i;return s}const s={},n=[];for(const i of(0,p.isArray)(t)?t:[t])if((0,p.isArray)(i)){const[t,r]=i;(0,l.extend)(s,e(t,r)),n.push([t,r])}else{const t=i;(0,l.extend)(s,t),n.push(["",t])}this.define(s),this.prototype._mixins=[...this.prototype._mixins,...n]}static override(t){for(const[e,s]of(0,l.entries)(t)){const t=this._fix_default(s,e);if(!(e in this.prototype._props))throw new Error(`attempted to override nonexistent '${this.prototype.type}.${e}'`);const n=this.prototype._props[e],i=Object.assign({},this.prototype._props);i[e]=Object.assign(Object.assign({},n),{default_value:t}),this.prototype._props=i}}static toString(){return this.__qualified__}toString(){return`${this.type}(${this.id})`}property(t){if(t in this.properties)return this.properties[t];throw new Error(`unknown property ${this.type}.${t}`)}get attributes(){const t={};for(const e of this)e.is_unset||(t[e.attr]=e.get_value());return t}[v.clone](t){const e=new Map;for(const s of this)s.dirty&&e.set(s.attr,t.clone(s.get_value()));return new this.constructor(e)}[y.equals](t,e){for(const s of this){const n=t.property(s.attr);if(!e.eq(s.get_value(),n.get_value()))return!1}return!0}[m.pretty](t){const e=t.token,s=[];for(const n of this)if(n.dirty){const i=n.get_value();s.push(`${n.attr}${e(":")} ${t.to_string(i)}`)}return`${this.constructor.__qualified__}${e("(")}${e("{")}${s.join(`${e(",")} `)}${e("}")}${e(")")}`}[d.serialize](t){const e=this.ref();t.add_ref(this,e);const s={};for(const e of this)if(e.syncable&&(t.include_defaults||e.dirty)){const n=e.get_value();s[e.attr]=t.encode(n)}const{type:n,id:i}=this,r={type:"object",name:n,id:i};return(0,l.is_empty)(s)?r:Object.assign(Object.assign({},r),{attributes:s})}initialize_props(t){const e=new Set;for(const s of this){const n=t.get(s.attr);s.initialize(n),e.add(s.attr)}for(const s of t.keys())e.has(s)||this.property(s)}finalize(){this.initialize()}initialize(){}connect_signals(){for(const t of this){if(!(t instanceof a.VectorSpec||t instanceof a.ScalarSpec))continue;if(t.is_unset)continue;const e=t.get_value();null!=e.transform&&this.connect(e.transform.change,(()=>this.transformchange.emit())),(0,b.isExpr)(e)&&this.connect(e.expr.change,(()=>this.exprchange.emit()))}}disconnect_signals(){c.Signal.disconnect_receiver(this)}destroy(){this.disconnect_signals(),this.destroyed.emit()}clone(){return(new v.Cloner).clone(this)}_clear_watchers(){this._watchers=new WeakMap}changed_for(t){const e=this._watchers.get(t);return this._watchers.set(t,!1),null==e||e}_setv(t,e){var s;const n=e.check_eq,i=new Set,r=this._changing;this._changing=!0;for(const[e,s]of t)!1!==n&&!e.is_unset&&(0,f.is_equal)(e.get_value(),s)||(e.set_value(s),i.add(e));i.size>0&&(this._clear_watchers(),this._pending=!0);for(const t of i)t.change.emit();if(!r){if(null===(s=e.no_change)||void 0===s||!s)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}return i}setv(t,e={}){var s,n;const i=(0,l.entries)(t);if(0==i.length)return;if(null!==(s=e.silent)&&void 0!==s&&s){this._clear_watchers();for(const[t,e]of i)this.properties[t].set_value(e);return}const r=new Map,o=new Map;for(const[t,e]of i){const s=this.properties[t];r.set(s,e),o.set(s,s.is_unset?void 0:s.get_value())}const c=this._setv(r,e),{document:a}=this;if(null!=a){const t=[];for(const[e,s]of o)c.has(e)&&t.push([e,s,e.get_value()]);for(const[,e,s]of t)if(this._needs_invalidate(e,s)){a._invalidate_all_models();break}(null===(n=e.sync)||void 0===n||n)&&this._push_changes(t)}}ref(){return{id:this.id}}*[Symbol.iterator](){yield*(0,l.values)(this.properties)}*syncable_properties(){for(const t of this)t.syncable&&(yield t)}static _value_record_references(t,e,s){const{recursive:n}=s;if(t instanceof x){if(!e.has(t)&&(e.add(t),n))for(const s of t.syncable_properties())if(!s.is_unset){const t=s.get_value();x._value_record_references(t,e,{recursive:n})}}else if((0,p.isArray)(t))for(const s of t)x._value_record_references(s,e,{recursive:n});else if((0,p.isPlainObject)(t))for(const s of(0,l.values)(t))x._value_record_references(s,e,{recursive:n})}references(){const t=new Set;return x._value_record_references(this,t,{recursive:!0}),t}_doc_attached(){}_doc_detached(){}attach_document(t){if(null!=this.document){if(this.document==t)return;throw new Error("models must be owned by only a single document")}this.document=t,this._doc_attached()}detach_document(){this._doc_detached(),this.document=null}_needs_invalidate(t,e){const s=new Set;x._value_record_references(e,s,{recursive:!1});const n=new Set;x._value_record_references(t,n,{recursive:!1});for(const t of s)if(!n.has(t))return!0;for(const t of n)if(!s.has(t))return!0;return!1}_push_changes(t){if(!this.is_syncable)return;const{document:e}=this;if(null==e)return;const s=[];for(const[n,,i]of t)n.syncable&&s.push(new g.ModelChangedEvent(e,this,n.attr,i));if(0!=s.length){let t;1==s.length?[t]=s:t=new g.DocumentEventBatch(e,s),e._trigger_on_change(t)}}on_change(t,e){for(const s of(0,p.isArray)(t)?t:[t])this.connect(s.change,e)}stream_to(t,e,s,{sync:n}={}){const i=t.get_value();if((0,S.stream_to_columns)(i,e,s),this._clear_watchers(),t.set_value(i),this.streaming.emit(),null!=this.document&&(null==n||n)){const n=new g.ColumnsStreamedEvent(this.document,this,t.attr,e,s);this.document._trigger_on_change(n)}}patch_to(t,e,{sync:s}={}){const n=t.get_value(),i=(0,S.patch_to_columns)(n,e);if(this._clear_watchers(),t.set_value(n),this.patching.emit([...i]),null!=this.document&&(null==s||s)){const s=new g.ColumnsPatchedEvent(this.document,this,t.attr,e);this.document._trigger_on_change(s)}}}s.HasProps=x,(o=x).prototype._props={},o.prototype._mixins=[]},
function _(n,e,t,s,l){s();const r=n(16),i=n(10);class o{constructor(n,e){this.sender=n,this.name=e}connect(n,e=null){t.receivers_for_sender.has(this.sender)||t.receivers_for_sender.set(this.sender,[]);const s=t.receivers_for_sender.get(this.sender);if(null!=f(s,this,n,e))return!1;const l=null!=e?e:n;u.has(l)||u.set(l,[]);const r=u.get(l),i={signal:this,slot:n,context:e};return s.push(i),r.push(i),!0}disconnect(n,e=null){const s=t.receivers_for_sender.get(this.sender);if(null==s||0===s.length)return!1;const l=f(s,this,n,e);if(null==l)return!1;const r=null!=e?e:n,i=u.get(r);return l.signal=null,g(s),g(i),!0}emit(n){var e;const s=null!==(e=t.receivers_for_sender.get(this.sender))&&void 0!==e?e:[];for(const{signal:e,slot:t,context:l}of s)e===this&&t.call(l,n,this.sender)}}t.Signal=o,o.__name__="Signal";class c extends o{emit(){super.emit(void 0)}}t.Signal0=c,c.__name__="Signal0",function(n){n.disconnect_between=function(n,e){const s=t.receivers_for_sender.get(n);if(null==s||0===s.length)return;const l=u.get(e);if(null!=l&&0!==l.length){for(const e of l){if(null==e.signal)return;e.signal.sender===n&&(e.signal=null)}g(s),g(l)}},n.disconnect_sender=function(n){var e;const s=t.receivers_for_sender.get(n);if(null!=s&&0!==s.length){for(const n of s){if(null==n.signal)return;const t=null!==(e=n.context)&&void 0!==e?e:n.slot;n.signal=null,g(u.get(t))}g(s)}},n.disconnect_receiver=function(n,e,s){const l=u.get(n);if(null!=l&&0!==l.length){for(const n of l){if(null==n.signal)return;if(null!=e&&n.slot!=e)continue;const l=n.signal.sender;null!=s&&s.has(l)||(n.signal=null,g(t.receivers_for_sender.get(l)))}g(l)}},n.disconnect_all=function(n){const e=t.receivers_for_sender.get(n);if(null!=e&&0!==e.length){for(const n of e)n.signal=null;g(e)}const s=u.get(n);if(null!=s&&0!==s.length){for(const n of s)n.signal=null;g(s)}}}(o||(t.Signal=o={})),t.Signalable=function(){return class{connect(n,e){return n.connect(e,this)}disconnect(n,e){return n.disconnect(e,this)}}},t.receivers_for_sender=new WeakMap;const u=new WeakMap;function f(n,e,t,s){return(0,i.find)(n,(n=>n.signal===e&&n.slot===t&&n.context===s))}const a=new Set;function g(n){0===a.size&&(async()=>{await(0,r.defer)(),function(){for(const n of a)(0,i.remove_by)(n,(n=>null==n.signal));a.clear()}()})(),a.add(n)}},
function _(e,n,t,r,o){r();const s=new MessageChannel,i=new Map;s.port1.onmessage=e=>{const n=e.data,t=i.get(n);if(null!=t)try{t()}finally{i.delete(n)}};let a=1;t.defer=function(){return new Promise((e=>{const n=a++;i.set(n,e),s.port2.postMessage(n)}))},t.delay=function(e){return new Promise((n=>setTimeout(n,e)))},t.paint=function(){return new Promise((e=>{requestAnimationFrame((()=>e()))}))},t.idle=function(){return new Promise((e=>{requestIdleCallback((()=>e()))}))}},
function _(e,t,r,n,a){n(),r.TextBaselineSpec=r.TextAlignSpec=r.FontStyleSpec=r.FontSizeSpec=r.FontSpec=r.LineDashSpec=r.LineCapSpec=r.LineJoinSpec=r.MarkerSpec=r.ArraySpec=r.NullStringSpec=r.StringSpec=void 0;const s=e(1),i=e(15),l=e(18),_=s.__importStar(e(19)),o=e(23),c=e(10),u=e(13),d=e(11),S=e(21),p=e(26),h=e(8),m=e(27),v=e(28),f=e(29),y=e(36),x=e(12),g=e(30),A=e(37);function w(e){try{return JSON.stringify(e)}catch(t){return e.toString()}}function z(e){return(0,h.isPlainObject)(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}a("Uniform",A.Uniform),a("UniformScalar",A.UniformScalar),a("UniformVector",A.UniformVector),r.isSpec=z;let b=null;r.use_theme=function(e=null){b=e},r.unset=Symbol("unset");class C{constructor(e,t,n,a,s={}){var l;this.obj=e,this.attr=t,this.kind=n,this.default_value=a,this._value=r.unset,this._initialized=!1,this._dirty=!1,this.change=new i.Signal0(this.obj,"change"),this.internal=null!==(l=s.internal)&&void 0!==l&&l,this.convert=s.convert,this.on_update=s.on_update}get syncable(){return!this.internal}get is_unset(){return this._value===r.unset}get initialized(){return this._initialized}initialize(e=r.unset){if(this._initialized)throw new Error("already initialized");let t=r.unset;if(e!==r.unset)t=e,this._dirty=!0;else{const e=this._default_override();if(e!==r.unset)t=e;else{let e=!1;if(null!=b){const r=b.get(this.obj,this.attr);void 0!==r&&(t=r,e=!0)}e||(t=this.default_value(this.obj))}}t!==r.unset?this._update(t):this._value=r.unset,this._initialized=!0}get_value(){if(this._value!==r.unset)return this._value;throw new Error(`${this.obj}.${this.attr} is unset`)}set_value(e){this._initialized?(this._update(e),this._dirty=!0):this.initialize(e),y.diagnostics.report(this)}_default_override(){return r.unset}get dirty(){return this._dirty}_update(e){var t;if(this.validate(e),null!=this.convert){const t=this.convert(e);void 0!==t&&(e=t)}this._value=e,null===(t=this.on_update)||void 0===t||t.call(this,e,this.obj)}toString(){return`Prop(${this.obj}.${this.attr}, value: ${w(this._value)})`}normalize(e){return e}validate(e){if(!this.valid(e))throw new Error(`${this.obj}.${this.attr} given invalid value: ${w(e)}`)}valid(e){return this.kind.valid(e)}}r.Property=C,C.__name__="Property";class F{constructor(e){this.attr=e}}r.PropertyAlias=F,F.__name__="PropertyAlias",r.Alias=function(e){return new F(e)};class q extends C{}r.PrimitiveProperty=q,q.__name__="PrimitiveProperty";class N extends q{_default_override(){return v.settings.dev?"Bokeh":r.unset}}r.Font=N,N.__name__="Font";class U extends C{constructor(){super(...arguments),this._value=r.unset}get_value(){if(this._value!==r.unset)return this._value;throw new Error(`${this.obj}.${this.attr} is unset`)}_update(e){if(z(e)?this._value=e:this._value={value:e},(0,h.isPlainObject)(this._value)){const{_value:e}=this;this._value[g.serialize]=t=>{const{value:r,field:n,expr:a,transform:s,units:i}=e;return t.encode_struct(void 0!==r?{type:"value",value:r,transform:s,units:i}:void 0!==n?{type:"field",field:n,transform:s,units:i}:{type:"expr",expr:a,transform:s,units:i})}}(0,m.isValue)(this._value)&&this.validate(this._value.value)}materialize(e){return e}scalar(e,t){return new A.UniformScalar(e,t)}uniform(e){var t;const r=this.get_value(),n=null!==(t=e.get_length())&&void 0!==t?t:1;if((0,m.isExpr)(r)){const{expr:t,transform:a}=r;let s=t.compute(e);return null!=a&&(s=a.compute(s)),s=this.materialize(s),this.scalar(s,n)}{const{value:e,transform:t}=r;let a=e;return null!=t&&(a=t.compute(a)),a=this.materialize(a),this.scalar(a,n)}}}r.ScalarSpec=U,U.__name__="ScalarSpec";class $ extends U{}r.AnyScalar=$,$.__name__="AnyScalar";class j extends U{}r.ColorScalar=j,j.__name__="ColorScalar";class B extends U{}r.NumberScalar=B,B.__name__="NumberScalar";class L extends U{}r.StringScalar=L,L.__name__="StringScalar";class D extends U{}r.NullStringScalar=D,D.__name__="NullStringScalar";class E extends U{}r.ArrayScalar=E,E.__name__="ArrayScalar";class P extends U{}r.LineJoinScalar=P,P.__name__="LineJoinScalar";class T extends U{}r.LineCapScalar=T,T.__name__="LineCapScalar";class V extends U{}r.LineDashScalar=V,V.__name__="LineDashScalar";class k extends U{_default_override(){return v.settings.dev?"Bokeh":r.unset}}r.FontScalar=k,k.__name__="FontScalar";class J extends U{}r.FontSizeScalar=J,J.__name__="FontSizeScalar";class X extends U{}r.FontStyleScalar=X,X.__name__="FontStyleScalar";class Y extends U{}r.TextAlignScalar=Y,Y.__name__="TextAlignScalar";class G extends U{}r.TextBaselineScalar=G,G.__name__="TextBaselineScalar";class I extends C{constructor(){super(...arguments),this._value=r.unset}get_value(){if(this._value!==r.unset)return this._value;throw new Error(`${this.obj}.${this.attr} is unset`)}_update(e){if(z(e)?this._value=e:this._value={value:e},(0,h.isPlainObject)(this._value)){const{_value:e}=this;this._value[g.serialize]=t=>{const{value:r,field:n,expr:a,transform:s,units:i}=e;return t.encode_struct(void 0!==r?{type:"value",value:r,transform:s,units:i}:void 0!==n?{type:"field",field:n,transform:s,units:i}:{type:"expr",expr:a,transform:s,units:i})}}(0,m.isValue)(this._value)&&this.validate(this._value.value)}materialize(e){return e}v_materialize(e){return e}scalar(e,t){return new A.UniformScalar(e,t)}vector(e){return new A.UniformVector(e)}uniform(e){var t;const r=this.get_value(),n=null!==(t=e.get_length())&&void 0!==t?t:1;if((0,m.isField)(r)){const{field:t,transform:a}=r;let s=e.get_column(t);return null!=s?(null!=a&&(s=a.v_compute(s)),s=this.v_materialize(s),this.vector(s)):(l.logger.warn(`attempted to retrieve property array for nonexistent field '${t}'`),this.scalar(null,n))}if((0,m.isExpr)(r)){const{expr:t,transform:n}=r;let a=t.v_compute(e);return null!=n&&(a=n.v_compute(a)),a=this.v_materialize(a),this.vector(a)}if((0,m.isValue)(r)){const{value:e,transform:t}=r;let a=e;return null!=t&&(a=t.compute(a)),a=this.materialize(a),this.scalar(a,n)}(0,x.unreachable)()}array(e){var t;let r;const n=null!==(t=e.get_length())&&void 0!==t?t:1,a=this.get_value();if((0,m.isField)(a)){const{field:t}=a,s=e.get_column(t);if(null!=s)r=this.normalize(s);else{l.logger.warn(`attempted to retrieve property array for nonexistent field '${t}'`);const e=new Float64Array(n);e.fill(NaN),r=e}}else if((0,m.isExpr)(a)){const{expr:t}=a;r=this.normalize(t.v_compute(e))}else{const e=this.normalize([a.value])[0];if((0,h.isNumber)(e)){const t=new Float64Array(n);t.fill(e),r=t}else r=(0,c.repeat)(e,n)}const{transform:s}=a;return null!=s&&(r=s.v_compute(r)),r}}r.VectorSpec=I,I.__name__="VectorSpec";class O extends I{}r.DataSpec=O,O.__name__="DataSpec";class R extends I{constructor(){super(...arguments),this._value=r.unset}_update(e){if(super._update(e),this._value!==r.unset){const{units:e}=this._value;if(null!=e&&!(0,c.includes)(this.valid_units,e))throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${e}`)}}get units(){var e;return this._value!==r.unset&&null!==(e=this._value.units)&&void 0!==e?e:this.default_units}set units(e){if(this._value===r.unset)throw new Error(`${this.obj}.${this.attr} is unset`);e!=this.default_units?this._value.units=e:delete this._value.units}}r.UnitsSpec=R,R.__name__="UnitsSpec";class M extends R{array(e){return new Float64Array(super.array(e))}}r.NumberUnitsSpec=M,M.__name__="NumberUnitsSpec";class H extends O{}r.BaseCoordinateSpec=H,H.__name__="BaseCoordinateSpec";class K extends H{}r.CoordinateSpec=K,K.__name__="CoordinateSpec";class Q extends H{}r.CoordinateSeqSpec=Q,Q.__name__="CoordinateSeqSpec";class W extends H{}r.CoordinateSeqSeqSeqSpec=W,W.__name__="CoordinateSeqSeqSeqSpec";class Z extends K{constructor(){super(...arguments),this.dimension="x"}}r.XCoordinateSpec=Z,Z.__name__="XCoordinateSpec";class ee extends K{constructor(){super(...arguments),this.dimension="y"}}r.YCoordinateSpec=ee,ee.__name__="YCoordinateSpec";class te extends Q{constructor(){super(...arguments),this.dimension="x"}}r.XCoordinateSeqSpec=te,te.__name__="XCoordinateSeqSpec";class re extends Q{constructor(){super(...arguments),this.dimension="y"}}r.YCoordinateSeqSpec=re,re.__name__="YCoordinateSeqSpec";class ne extends W{constructor(){super(...arguments),this.dimension="x"}}r.XCoordinateSeqSeqSeqSpec=ne,ne.__name__="XCoordinateSeqSeqSeqSpec";class ae extends W{constructor(){super(...arguments),this.dimension="y"}}r.YCoordinateSeqSeqSeqSpec=ae,ae.__name__="YCoordinateSeqSeqSeqSpec";class se extends M{get default_units(){return"rad"}get valid_units(){return[..._.AngleUnits]}materialize(e){return e*-(0,d.to_radians_coeff)(this.units)}v_materialize(e){const t=-(0,d.to_radians_coeff)(this.units),r=new Float32Array(e.length);return(0,u.mul)(e,t,r),r}array(e){throw new Error("not supported")}}r.AngleSpec=se,se.__name__="AngleSpec";class ie extends M{get default_units(){return"data"}get valid_units(){return[..._.SpatialUnits]}}r.DistanceSpec=ie,ie.__name__="DistanceSpec";class le extends ie{materialize(e){return null!=e?e:NaN}}r.NullDistanceSpec=le,le.__name__="NullDistanceSpec";class _e extends O{v_materialize(e){return new Uint8Array(e)}array(e){return new Uint8Array(super.array(e))}}r.BooleanSpec=_e,_e.__name__="BooleanSpec";class oe extends O{v_materialize(e){return(0,h.isTypedArray)(e)?e:new Int32Array(e)}array(e){return new Int32Array(super.array(e))}}r.IntSpec=oe,oe.__name__="IntSpec";class ce extends O{v_materialize(e){return(0,h.isTypedArray)(e)?e:new Float64Array(e)}array(e){return new Float64Array(super.array(e))}}r.NumberSpec=ce,ce.__name__="NumberSpec";class ue extends ce{valid(e){return(0,h.isNumber)(e)&&e>=0}}r.ScreenSizeSpec=ue,ue.__name__="ScreenSizeSpec";class de extends O{materialize(e){return(0,S.encode_rgba)((0,S.color2rgba)(e))}v_materialize(e){if(!(0,f.is_NDArray)(e))return this._from_css_array(e);if("uint32"==e.dtype&&1==e.dimension)return(0,p.to_big_endian)(e);if("uint8"==e.dtype&&1==e.dimension){const[t]=e.shape,r=new o.RGBAArray(4*t);let n=0;for(const t of e)r[n++]=t,r[n++]=t,r[n++]=t,r[n++]=255;return new o.ColorArray(r.buffer)}if("uint8"==e.dtype&&2==e.dimension){const[t,r]=e.shape;if(4==r)return new o.ColorArray(e.buffer);if(3==r){const n=new o.RGBAArray(4*t);for(let a=0,s=0;a<r*t;)n[s++]=e[a++],n[s++]=e[a++],n[s++]=e[a++],n[s++]=255;return new o.ColorArray(n.buffer)}}else if("float32"!=e.dtype&&"float64"!=e.dtype||2!=e.dimension){if("object"==e.dtype&&1==e.dimension)return this._from_css_array(e)}else{const[t,r]=e.shape;if(3==r||4==r){const n=new o.RGBAArray(4*t);for(let a=0,s=0;a<r*t;)n[s++]=255*e[a++],n[s++]=255*e[a++],n[s++]=255*e[a++],n[s++]=255*(3==r?1:e[a++]);return new o.ColorArray(n.buffer)}}throw new Error("invalid color array")}_from_css_array(e){const t=e.length,r=new o.RGBAArray(4*t);let n=0;for(const t of e){const[e,a,s,i]=(0,S.color2rgba)(t);r[n++]=e,r[n++]=a,r[n++]=s,r[n++]=i}return new o.ColorArray(r.buffer)}vector(e){return new A.ColorUniformVector(e)}}r.ColorSpec=de,de.__name__="ColorSpec";class Se extends O{}r.NDArraySpec=Se,Se.__name__="NDArraySpec";class pe extends O{}r.AnySpec=pe,pe.__name__="AnySpec";class he extends O{}r.StringSpec=he,he.__name__="StringSpec";class me extends O{}r.NullStringSpec=me,me.__name__="NullStringSpec";class ve extends O{}r.ArraySpec=ve,ve.__name__="ArraySpec";class fe extends O{}r.MarkerSpec=fe,fe.__name__="MarkerSpec";class ye extends O{}r.LineJoinSpec=ye,ye.__name__="LineJoinSpec";class xe extends O{}r.LineCapSpec=xe,xe.__name__="LineCapSpec";class ge extends O{}r.LineDashSpec=ge,ge.__name__="LineDashSpec";class Ae extends O{_default_override(){return v.settings.dev?"Bokeh":r.unset}}r.FontSpec=Ae,Ae.__name__="FontSpec";class we extends O{}r.FontSizeSpec=we,we.__name__="FontSizeSpec";class ze extends O{}r.FontStyleSpec=ze,ze.__name__="FontStyleSpec";class be extends O{}r.TextAlignSpec=be,be.__name__="TextAlignSpec";class Ce extends O{}r.TextBaselineSpec=Ce,Ce.__name__="TextBaselineSpec"},
function _(e,l,o,n,t){n();const s=e(8),g=e(9),r={};class i{constructor(e,l){this.name=e,this.level=l}}o.LogLevel=i,i.__name__="LogLevel";class v{constructor(e,l=v.INFO){this._name=e,this.set_level(l)}static get levels(){return Object.keys(v.log_levels)}static get(e,l=v.INFO){if(e.length>0)return e in r?r[e]:r[e]=new v(e,l);throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")}get level(){return this.get_level()}get_level(){return this._log_level}set_level(e){if(e instanceof i)this._log_level=e;else{if(!(0,s.isString)(e)||!(e in v.log_levels))throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=v.log_levels[e]}const l=`[${this._name}]`;for(const[e,o]of(0,g.entries)(v.log_levels))o.level<this._log_level.level||this._log_level.level===v.OFF.level?this[e]=function(){}:this[e]=_(e,l)}trace(...e){}debug(...e){}info(...e){}warn(...e){}error(...e){}}function _(e,l){return null!=console[e]?console[e].bind(console,l):console.log.bind(console,l)}function c(e){const l=o.logger.level;return(0,s.isString)(e)&&!(e in v.log_levels)?(console.log(`[bokeh] unrecognized logging level '${e}' passed to Bokeh.set_log_level(), ignoring`),console.log(`[bokeh] valid log levels are: ${v.levels.join(", ")}`)):(console.log(`[bokeh] setting log level to: '${(0,s.isString)(e)?e:e.level}'`),o.logger.set_level(e)),l}o.Logger=v,v.__name__="Logger",v.TRACE=new i("trace",0),v.DEBUG=new i("debug",1),v.INFO=new i("info",2),v.WARN=new i("warn",6),v.ERROR=new i("error",7),v.FATAL=new i("fatal",8),v.OFF=new i("off",9),v.log_levels={trace:v.TRACE,debug:v.DEBUG,info:v.INFO,warn:v.WARN,error:v.ERROR,fatal:v.FATAL,off:v.OFF},o.logger=v.get("bokeh"),o.set_log_level=c,o.with_log_level=function(e,l){const o=c(e);try{l()}finally{c(o)}}},
function _(e,t,n,o,i){o(),n.ToolIcon=n.VerticalAlign=n.UpdateMode=n.TooltipAttachment=n.TickLabelOrientation=n.TextureRepetition=n.TextBaseline=n.TextAlign=n.TapBehavior=void 0;const a=e(20);n.Align=(0,a.Enum)("start","center","end"),n.HAlign=(0,a.Enum)("left","center","right"),n.VAlign=(0,a.Enum)("top","center","bottom"),n.Anchor=(0,a.Enum)("top_left","top_center","top_right","center_left","center_center","center_right","bottom_left","bottom_center","bottom_right","top","left","center","right","bottom"),n.AngleUnits=(0,a.Enum)("deg","rad","grad","turn"),n.BoxOrigin=(0,a.Enum)("corner","center"),n.ButtonType=(0,a.Enum)("default","primary","success","warning","danger","light"),n.CalendarPosition=(0,a.Enum)("auto","above","below"),n.CoordinateUnits=(0,a.Enum)("canvas","screen","data"),n.ContextWhich=(0,a.Enum)("start","center","end","all"),n.Dimension=(0,a.Enum)("width","height"),n.Dimensions=(0,a.Enum)("width","height","both"),n.Direction=(0,a.Enum)("clock","anticlock"),n.Distribution=(0,a.Enum)("uniform","normal"),n.FlowMode=(0,a.Enum)("block","inline"),n.FontStyle=(0,a.Enum)("normal","italic","bold","bold italic"),n.HatchPatternType=(0,a.Enum)("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),n.HTTPMethod=(0,a.Enum)("POST","GET"),n.HexTileOrientation=(0,a.Enum)("pointytop","flattop"),n.HoverMode=(0,a.Enum)("mouse","hline","vline"),n.ImageOrigin=(0,a.Enum)("bottom_left","top_left","bottom_right","top_right"),n.LatLon=(0,a.Enum)("lat","lon"),n.LegendClickPolicy=(0,a.Enum)("none","hide","mute"),n.LegendLocation=n.Anchor,n.LineCap=(0,a.Enum)("butt","round","square"),n.LineDash=(0,a.Enum)("solid","dashed","dotted","dotdash","dashdot"),n.LineJoin=(0,a.Enum)("miter","round","bevel"),n.LinePolicy=(0,a.Enum)("prev","next","nearest","interp","none"),n.Location=(0,a.Enum)("above","below","left","right"),n.Logo=(0,a.Enum)("normal","grey"),n.MapType=(0,a.Enum)("satellite","roadmap","terrain","hybrid"),n.MarkerType=(0,a.Enum)("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","star","star_dot","triangle","triangle_dot","triangle_pin","x","y"),n.MutedPolicy=(0,a.Enum)("show","ignore"),n.Orientation=(0,a.Enum)("vertical","horizontal"),n.OutputBackend=(0,a.Enum)("canvas","svg","webgl"),n.PaddingUnits=(0,a.Enum)("percent","absolute"),n.Place=(0,a.Enum)("above","below","left","right","center"),n.PointPolicy=(0,a.Enum)("snap_to_data","follow_mouse","none"),n.RadiusDimension=(0,a.Enum)("x","y","max","min"),n.RenderLevel=(0,a.Enum)("image","underlay","glyph","guide","annotation","overlay"),n.ResetPolicy=(0,a.Enum)("standard","event_only"),n.RoundingFunction=(0,a.Enum)("round","nearest","floor","rounddown","ceil","roundup"),n.ScrollbarPolicy=(0,a.Enum)("auto","visible","hidden"),n.SelectionMode=(0,a.Enum)("replace","append","intersect","subtract"),n.Side=(0,a.Enum)("above","below","left","right"),n.SizingMode=(0,a.Enum)("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"),n.Sort=(0,a.Enum)("ascending","descending"),n.SpatialUnits=(0,a.Enum)("screen","data"),n.StartEnd=(0,a.Enum)("start","end"),n.StepMode=(0,a.Enum)("after","before","center"),n.TapBehavior=(0,a.Enum)("select","inspect"),n.TextAlign=(0,a.Enum)("left","right","center"),n.TextBaseline=(0,a.Enum)("top","middle","bottom","alphabetic","hanging","ideographic"),n.TextureRepetition=(0,a.Enum)("repeat","repeat_x","repeat_y","no_repeat"),n.TickLabelOrientation=(0,a.Enum)("vertical","horizontal","parallel","normal"),n.TooltipAttachment=(0,a.Enum)("horizontal","vertical","left","right","above","below"),n.UpdateMode=(0,a.Enum)("replace","append"),n.VerticalAlign=(0,a.Enum)("top","middle","bottom"),n.ToolIcon=(0,a.Enum)("append_mode","box_edit","box_select","box_zoom","clear_selection","copy","crosshair","freehand_draw","help","hover","intersect_mode","lasso_select","line_edit","pan","point_draw","poly_draw","poly_edit","polygon_select","range","redo","replace_mode","reset","save","subtract_mode","tap_select","undo","wheel_pan","wheel_zoom","xpan","ypan","zoom_in","zoom_out")},
function _(t,e,n,r,s){r();const i=t(1).__importStar(t(8)),a=t(21),o=t(9),_=globalThis.Map,u=globalThis.Set,{hasOwnProperty:l}=Object.prototype;class d{}n.Kind=d,d.__name__="Kind",function(t){var e;class n extends d{constructor(){super(...arguments),this[e]="Any"}valid(t){return!0}toString(){return"Any"}}e=Symbol.toStringTag,n.__name__="Any",t.Any=n;class r extends d{valid(t){return!0}toString(){return"Unknown"}}r.__name__="Unknown",t.Unknown=r;class s extends d{valid(t){return i.isBoolean(t)}toString(){return"Boolean"}}s.__name__="Boolean",t.Boolean=s;class c extends d{constructor(t){super(),this.obj_type=t}valid(t){return t instanceof this.obj_type}toString(){var t;const e=this.obj_type;return`Ref(${null!==(t=e.__name__)&&void 0!==t?t:e.toString()})`}}c.__name__="Ref",t.Ref=c;class p extends d{valid(t){return i.isObject(t)}toString(){return"AnyRef"}}p.__name__="AnyRef",t.AnyRef=p;class y extends d{valid(t){return i.isNumber(t)}toString(){return"Number"}}y.__name__="Number",t.Number=y;class S extends y{valid(t){return super.valid(t)&&i.isInteger(t)}toString(){return"Int"}}S.__name__="Int",t.Int=S;class g extends y{valid(t){return super.valid(t)&&0<=t&&t<=1}toString(){return"Percent"}}g.__name__="Percent",t.Percent=g;class m extends d{constructor(t){super(),this.types=t,this.types=t}valid(t){return this.types.some((e=>e.valid(t)))}toString(){return`Or(${this.types.map((t=>t.toString())).join(", ")})`}}m.__name__="Or",t.Or=m;class h extends d{constructor(t){super(),this.types=t,this.types=t}valid(t){if(!i.isArray(t))return!1;for(let e=0;e<this.types.length;e++){const n=this.types[e],r=t[e];if(!n.valid(r))return!1}return!0}toString(){return`Tuple(${this.types.map((t=>t.toString())).join(", ")})`}}h.__name__="Tuple",t.Tuple=h;class v extends d{constructor(t){super(),this.struct_type=t}valid(t){if(!i.isPlainObject(t))return!1;const{struct_type:e}=this;for(const n of(0,o.keys)(t))if(!l.call(e,n))return!1;for(const n in e)if(l.call(e,n)){const r=e[n],s=t[n];if(!r.valid(s))return!1}return!0}toString(){return"Struct"}}v.__name__="Struct",t.Struct=v;class f extends d{constructor(t){super(),this.item_type=t}valid(t){return i.isArray(t)||i.isTypedArray(t)}toString(){return`Arrayable(${this.item_type.toString()})`}}f.__name__="Arrayable",t.Arrayable=f;class b extends d{constructor(t){super(),this.item_type=t}valid(t){return i.isArray(t)&&t.every((t=>this.item_type.valid(t)))}toString(){return`Array(${this.item_type.toString()})`}}b.__name__="Array",t.Array=b;class x extends d{valid(t){return null===t}toString(){return"Null"}}x.__name__="Null",t.Null=x;class w extends d{constructor(t){super(),this.base_type=t}valid(t){return null===t||this.base_type.valid(t)}toString(){return`Nullable(${this.base_type.toString()})`}}w.__name__="Nullable",t.Nullable=w;class N extends d{constructor(t){super(),this.base_type=t}valid(t){return void 0===t||this.base_type.valid(t)}toString(){return`Opt(${this.base_type.toString()})`}}N.__name__="Opt",t.Opt=N;class K extends d{valid(t){return t instanceof ArrayBuffer}toString(){return"Bytes"}}K.__name__="Bytes",t.Bytes=K;class A extends d{valid(t){return i.isString(t)}toString(){return"String"}}A.__name__="String",t.String=A;class O extends A{constructor(t){super(),this.regex=t}valid(t){return super.valid(t)&&this.regex.test(t)}toString(){return`Regex(${this.regex.toString()})`}}O.__name__="Regex",t.Regex=O;class R extends d{constructor(t){super(),this.values=new u(t)}valid(t){return this.values.has(t)}*[Symbol.iterator](){yield*this.values}toString(){return`Enum(${[...this.values].map((t=>t.toString())).join(", ")})`}}R.__name__="Enum",t.Enum=R;class $ extends d{constructor(t){super(),this.item_type=t}valid(t){if(!i.isPlainObject(t))return!1;for(const e in t)if(l.call(t,e)){const n=t[e];if(!this.item_type.valid(n))return!1}return!0}toString(){return`Dict(${this.item_type.toString()})`}}$.__name__="Dict",t.Dict=$;class B extends d{constructor(t,e){super(),this.key_type=t,this.item_type=e}valid(t){if(!(t instanceof _))return!1;for(const[e,n]of t.entries())if(!this.key_type.valid(e)||!this.item_type.valid(n))return!1;return!0}toString(){return`Map(${this.key_type.toString()}, ${this.item_type.toString()})`}}B.__name__="Map",t.Map=B;class C extends d{constructor(t){super(),this.item_type=t}valid(t){if(!(t instanceof u))return!1;for(const e of t)if(!this.item_type.valid(e))return!1;return!0}toString(){return`Set(${this.item_type.toString()})`}}C.__name__="Set",t.Set=C;class M extends d{valid(t){return(0,a.is_Color)(t)}toString(){return"Color"}}M.__name__="Color",t.Color=M;class j extends A{toString(){return"CSSLength"}}j.__name__="CSSLength",t.CSSLength=j;class D extends d{valid(t){return i.isFunction(t)}toString(){return"Function(...)"}}D.__name__="Function",t.Function=D;class k extends d{constructor(t){super(),this.base_type=t}valid(t){return this.base_type.valid(t)&&t>=0}toString(){return`NonNegative(${this.base_type.toString()})`}}k.__name__="NonNegative",t.NonNegative=k;class P extends d{valid(t){return t instanceof Node}toString(){return"DOMNode"}}P.__name__="DOMNode",t.DOMNode=P}(n.Kinds||(n.Kinds={})),n.Any=new n.Kinds.Any,n.Unknown=new n.Kinds.Unknown,n.Boolean=new n.Kinds.Boolean,n.Number=new n.Kinds.Number,n.Int=new n.Kinds.Int,n.Bytes=new n.Kinds.Bytes,n.String=new n.Kinds.String;n.Regex=t=>new n.Kinds.Regex(t),n.Null=new n.Kinds.Null;n.Nullable=t=>new n.Kinds.Nullable(t);n.Opt=t=>new n.Kinds.Opt(t);n.Or=(...t)=>new n.Kinds.Or(t);n.Tuple=(...t)=>new n.Kinds.Tuple(t);n.Struct=t=>new n.Kinds.Struct(t);n.Arrayable=t=>new n.Kinds.Arrayable(t);n.Array=t=>new n.Kinds.Array(t);n.Dict=t=>new n.Kinds.Dict(t);n.Map=(t,e)=>new n.Kinds.Map(t,e);n.Set=t=>new n.Kinds.Set(t);n.Enum=(...t)=>new n.Kinds.Enum(t);n.Ref=t=>new n.Kinds.Ref(t);n.AnyRef=()=>new n.Kinds.AnyRef;n.Function=()=>new n.Kinds.Function,n.DOMNode=new n.Kinds.DOMNode;n.NonNegative=t=>new n.Kinds.NonNegative(t),n.Percent=new n.Kinds.Percent,n.Alpha=n.Percent,n.Color=new n.Kinds.Color,n.Auto=(0,n.Enum)("auto"),n.CSSLength=new n.Kinds.CSSLength,n.FontSize=n.String,n.Font=n.String,n.Angle=n.Number},
function _(n,r,t,e,s){e();const u=n(22),i=n(11),c=n(8),{round:o,sqrt:l}=Math;function a(n){return(0,i.clamp)(o(n),0,255)}function f(){return[0,0,0,0]}function g(n){return[n>>24&255,n>>16&255,n>>8&255,255&n]}function b(n,r=1){const[t,e,s,u]=(()=>{var r;if(null==n)return[0,0,0,0];if((0,c.isInteger)(n))return g(n);if((0,c.isString)(n))return null!==(r=_(n))&&void 0!==r?r:[0,0,0,0];if(2==n.length){const[r,t]=n;return b(r,t)}{const[r,t,e,s=1]=n;return[r,t,e,a(255*s)]}})();return[t,e,s,a(r*u)]}t.transparent=f,t.encode_rgba=function([n,r,t,e]){return n<<24|r<<16|t<<8|e},t.decode_rgba=g,t.color2rgba=b;const d={0:"0",1:"1",2:"2",3:"3",4:"4",5:"5",6:"6",7:"7",8:"8",9:"9",10:"a",11:"b",12:"c",13:"d",14:"e",15:"f"};function h(n){return d[n>>4]+d[15&n]}t.color2css=function(n,r){const[t,e,s,u]=b(n,r);return`rgba(${t}, ${e}, ${s}, ${u/255})`},t.color2hex=function(n,r){const[t,e,s,u]=b(n,r),i=`#${h(t)}${h(e)}${h(s)}`;return 255==u?i:`${i}${h(u)}`},t.color2hexrgb=function(n){const[r,t,e]=b(n);return`#${h(r)}${h(t)}${h(e)}`};const $=/^rgba?\(\s*(?<r>[^\s,]+?)\s+(?<g>[^\s,]+?)\s+(?<b>[^\s,]+?)(?:\s*\/\s*(?<a>[^\s,]+?))?\s*\)$/,m=/^rgba?\(\s*(?<r>[^\s,]+?)\s*,\s*(?<g>[^\s,]+?)\s*,\s*(?<b>[^\s,]+?)(?:\s*,\s*(?<a>[^\s,]+?))?\s*\)$/,N=(()=>{const n=document.createElement("canvas");n.width=1,n.height=1;const r=n.getContext("2d"),t=r.createLinearGradient(0,0,1,1);return n=>{r.fillStyle=t,r.fillStyle=n;const e=r.fillStyle;return e!=t?e:null}})();function _(n){var r;if(!(n=n.trim().toLowerCase()))return null;if("transparent"==n)return[0,0,0,0];if((0,u.is_named_color)(n))return g(u.named_colors[n]);if("#"==n[0]){const r=Number(`0x${n.substr(1)}`);if(isNaN(r))return null;switch(n.length-1){case 3:{const n=r>>8&15,t=r>>4&15,e=r>>0&15;return[n<<4|n,t<<4|t,e<<4|e,255]}case 4:{const n=r>>12&15,t=r>>8&15,e=r>>4&15,s=r>>0&15;return[n<<4|n,t<<4|t,e<<4|e,s<<4|s]}case 6:return[r>>16&255,r>>8&255,r>>0&255,255];case 8:return[r>>24&255,r>>16&255,r>>8&255,r>>0&255]}}else if(n.startsWith("rgb")){const t=null!==(r=n.match($))&&void 0!==r?r:n.match(m);if(null!=(null==t?void 0:t.groups)){let{r:n,g:r,b:e,a:s="1"}=t.groups;const u=n.endsWith("%"),i=r.endsWith("%"),c=e.endsWith("%"),o=s.endsWith("%");if(!(u&&i&&c)&&(u||i||c))return null;u&&(n=n.slice(0,-1)),i&&(r=r.slice(0,-1)),c&&(e=e.slice(0,-1)),o&&(s=s.slice(0,-1));let l=Number(n),f=Number(r),g=Number(e),b=Number(s);return isNaN(l+f+g+b)?null:(u&&(l=l/100*255),i&&(f=f/100*255),c&&(g=g/100*255),b=255*(o?b/100:b),l=a(l),f=a(f),g=a(g),b=a(b),[l,f,g,b])}}else{const r=N(n);if(null!=r)return _(r)}return null}t.css4_parse=_,t.is_Color=function(n){return!!(0,c.isInteger)(n)||(!(!(0,c.isString)(n)||null==_(n))||!(!(0,c.isArray)(n)||3!=n.length&&4!=n.length))},t.is_dark=function([n,r,t]){return 1-(.299*n+.587*r+.114*t)/255>=.6},t.brightness=function(n){const[r,t,e]=b(n);return l(.299*r**2+.587*t**2+.114*e**2)/255}},
function _(e,r,l,a,i){a();l.named_colors={aliceblue:4042850303,antiquewhite:4209760255,aqua:16777215,aquamarine:2147472639,azure:4043309055,beige:4126530815,bisque:4293182719,black:255,blanchedalmond:4293643775,blue:65535,blueviolet:2318131967,brown:2771004159,burlywood:3736635391,cadetblue:1604231423,chartreuse:2147418367,chocolate:3530104575,coral:4286533887,cornflowerblue:1687547391,cornsilk:4294499583,crimson:3692313855,cyan:16777215,darkblue:35839,darkcyan:9145343,darkgoldenrod:3095792639,darkgray:2846468607,darkgreen:6553855,darkgrey:2846468607,darkkhaki:3182914559,darkmagenta:2332068863,darkolivegreen:1433087999,darkorange:4287365375,darkorchid:2570243327,darkred:2332033279,darksalmon:3918953215,darkseagreen:2411499519,darkslateblue:1211993087,darkslategray:793726975,darkslategrey:793726975,darkturquoise:13554175,darkviolet:2483082239,deeppink:4279538687,deepskyblue:12582911,dimgray:1768516095,dimgrey:1768516095,dodgerblue:512819199,firebrick:2988581631,floralwhite:4294635775,forestgreen:579543807,fuchsia:4278255615,gainsboro:3705462015,ghostwhite:4177068031,gold:4292280575,goldenrod:3668254975,gray:2155905279,green:8388863,greenyellow:2919182335,grey:2155905279,honeydew:4043305215,hotpink:4285117695,indianred:3445382399,indigo:1258324735,ivory:4294963455,khaki:4041641215,lavender:3873897215,lavenderblush:4293981695,lawngreen:2096890111,lemonchiffon:4294626815,lightblue:2916673279,lightcoral:4034953471,lightcyan:3774873599,lightgoldenrodyellow:4210742015,lightgray:3553874943,lightgreen:2431553791,lightgrey:3553874943,lightpink:4290167295,lightsalmon:4288707327,lightseagreen:548580095,lightskyblue:2278488831,lightslategray:2005441023,lightslategrey:2005441023,lightsteelblue:2965692159,lightyellow:4294959359,lime:16711935,limegreen:852308735,linen:4210091775,magenta:4278255615,maroon:2147483903,mediumaquamarine:1724754687,mediumblue:52735,mediumorchid:3126187007,mediumpurple:2473647103,mediumseagreen:1018393087,mediumslateblue:2070474495,mediumspringgreen:16423679,mediumturquoise:1221709055,mediumvioletred:3340076543,midnightblue:421097727,mintcream:4127193855,mistyrose:4293190143,moccasin:4293178879,navajowhite:4292783615,navy:33023,oldlace:4260751103,olive:2155872511,olivedrab:1804477439,orange:4289003775,orangered:4282712319,orchid:3664828159,palegoldenrod:4008225535,palegreen:2566625535,paleturquoise:2951671551,palevioletred:3681588223,papayawhip:4293907967,peachpuff:4292524543,peru:3448061951,pink:4290825215,plum:3718307327,powderblue:2967529215,purple:2147516671,rebeccapurple:1714657791,red:4278190335,rosybrown:3163525119,royalblue:1097458175,saddlebrown:2336560127,salmon:4202722047,sandybrown:4104413439,seagreen:780883967,seashell:4294307583,sienna:2689740287,silver:3233857791,skyblue:2278484991,slateblue:1784335871,slategray:1887473919,slategrey:1887473919,snow:4294638335,springgreen:16744447,steelblue:1182971135,tan:3535047935,teal:8421631,thistle:3636451583,tomato:4284696575,turquoise:1088475391,violet:4001558271,wheat:4125012991,white:4294967295,whitesmoke:4126537215,yellow:4294902015,yellowgreen:2597139199},l.is_named_color=function(e){return e in l.named_colors}},
function _(r,t,n,a,o){a(),n.GeneratorFunction=Object.getPrototypeOf((function*(){})).constructor,n.ColorArray=Uint32Array,n.RGBAArray=Uint8ClampedArray,n.infer_type=function(r,t){return r instanceof Float64Array||r instanceof Array||t instanceof Float64Array||t instanceof Array?Float64Array:Float32Array},n.ScreenArray=Float32Array,n.to_screen=function(r){return r instanceof Float32Array?r:Float32Array.from(r)},o("Indices",r(24).BitSet)},
function _(t,s,r,e,i){var n;e();const o=t(25),a=t(12);class c{constructor(t,s=0){this.size=t,this[n]="BitSet",this._count=null,this._nwords=Math.ceil(t/32),0==s||1==s?(this._array=new Uint32Array(this._nwords),1==s&&this._array.fill(4294967295)):((0,a.assert)(s.length==this._nwords,"Initializer size mismatch"),this._array=s)}clone(){return new c(this.size,new Uint32Array(this._array))}[(n=Symbol.toStringTag,o.equals)](t,s){if(!s.eq(this.size,t.size))return!1;const{_nwords:r}=this,e=this.size%r,i=0==e?r:r-1;for(let s=0;s<i;s++)if(this._array[s]!=t._array[s])return!1;if(0==e)return!0;{const s=1<<e-1,r=s-1^s;return(this._array[i]&r)==(t._array[i]&r)}}static all_set(t){return new c(t,1)}static all_unset(t){return new c(t,0)}static from_indices(t,s){const r=new c(t);for(const t of s)r.set(t);return r}static from_booleans(t,s){const r=new c(t),e=Math.min(t,s.length);for(let t=0;t<e;t++)s[t]&&r.set(t);return r}_check_bounds(t){(0,a.assert)(0<=t&&t<this.size,`Out of bounds: 0 <= ${t} < ${this.size}`)}get(t){this._check_bounds(t);const s=t>>>5,r=31&t;return!!(this._array[s]>>r&1)}set(t,s=!0){this._check_bounds(t),this._count=null;const r=t>>>5,e=31&t;s?this._array[r]|=1<<e:this._array[r]&=~(1<<e)}unset(t){this.set(t,!1)}*[Symbol.iterator](){yield*this.ones()}get count(){let t=this._count;return null==t&&(this._count=t=this._get_count()),t}_get_count(){const{_array:t,_nwords:s,size:r}=this;let e=0;for(let i=0,n=0;n<s;n++){const s=t[n];if(0==s)i+=32;else for(let t=0;t<32&&i<r;t++,i++)s>>>t&1&&(e+=1)}return e}*ones(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(0!=s)for(let t=0;t<32&&e<r;t++,e++)s>>>t&1&&(yield e);else e+=32}}*zeros(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(4294967295!=s)for(let t=0;t<32&&e<r;t++,e++)s>>>t&1||(yield e);else e+=32}}_check_size(t){(0,a.assert)(this.size==t.size,`Size mismatch (${this.size} != ${t.size})`)}invert(){for(let t=0;t<this._nwords;t++)this._array[t]=~this._array[t]>>>0}add(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]|=t._array[s]}intersect(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]&=t._array[s]}subtract(t){this._check_size(t);for(let s=0;s<this._nwords;s++){const r=this._array[s],e=t._array[s];this._array[s]=(r^e)&r}}symmetric_subtract(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]^=t._array[s]}inversion(){const t=this.clone();return t.invert(),t}union(t){const s=this.clone();return s.add(t),s}intersection(t){const s=this.clone();return s.intersect(t),s}difference(t){const s=this.clone();return s.subtract(t),s}symmetric_difference(t){const s=this.clone();return s.symmetric_subtract(t),s}select(t){(0,a.assert)(this.size<=t.length,"Size mismatch");const s=this.count,r=new t.constructor(s);let e=0;for(const s of this)r[e++]=t[s];return r}}r.BitSet=c,c.__name__="BitSet"},
function _(t,e,r,s,n){s();const o=t(8),{hasOwnProperty:c}=Object.prototype;function a(t){return(0,o.isObject)(t)&&r.equals in t}r.equals=Symbol("equals"),r.wildcard=Symbol("wildcard");const i=Object.prototype.toString;class u{constructor(t){var e;this.a_stack=[],this.b_stack=[],this.structural=null!==(e=null==t?void 0:t.structural)&&void 0!==e&&e}eq(t,e){if(Object.is(t,e))return!0;if(t===r.wildcard||e===r.wildcard)return!0;if(null==t||null==e)return t===e;const s=i.call(t);if(s!=i.call(e))return!1;switch(s){case"[object Number]":return this.numbers(t,e);case"[object Symbol]":return t===e;case"[object RegExp]":case"[object String]":return`${t}`==`${e}`;case"[object Date]":case"[object Boolean]":return+t==+e}const{a_stack:n,b_stack:o}=this;let c=n.length;for(;c--;)if(n[c]===t)return o[c]===e;n.push(t),o.push(e);const u=(()=>{if(a(t)&&a(e))return t[r.equals](e,this);switch(s){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return this.arrays(t,e);case"[object Map]":return this.maps(t,e);case"[object Set]":return this.sets(t,e);case"[object Object]":if(t.constructor==e.constructor&&(null==t.constructor||t.constructor===Object))return this.objects(t,e);case"[object Function]":if(t.constructor==e.constructor&&t.constructor===Function)return this.eq(`${t}`,`${e}`)}if("undefined"!=typeof Node&&t instanceof Node)return this.nodes(t,e);throw Error(`can't compare objects of type ${s}`)})();return n.pop(),o.pop(),u}numbers(t,e){return Object.is(t,e)}arrays(t,e){const{length:r}=t;if(r!=e.length)return!1;for(let s=0;s<r;s++)if(!this.eq(t[s],e[s]))return!1;return!0}iterables(t,e){var r,s;const n=t[Symbol.iterator](),o=e[Symbol.iterator]();for(;;){const t=n.next(),e=o.next(),c=null!==(r=t.done)&&void 0!==r&&r,a=null!==(s=e.done)&&void 0!==s&&s;if(c&&a)return!0;if(c||a)return!1;if(!this.eq(t.value,e.value))return!1}}maps(t,e){if(t.size!=e.size)return!1;if(this.structural)return this.iterables(t.entries(),e.entries());for(const[r,s]of t)if(!e.has(r)||!this.eq(s,e.get(r)))return!1;return!0}sets(t,e){if(t.size!=e.size)return!1;if(this.structural)return this.iterables(t.entries(),e.entries());for(const r of t)if(!e.has(r))return!1;return!0}objects(t,e){const r=Object.keys(t);if(r.length!=Object.keys(e).length)return!1;for(const s of r)if(!c.call(e,s)||!this.eq(t[s],e[s]))return!1;return!0}nodes(t,e){return t.nodeType==e.nodeType&&(t.textContent==e.textContent&&!!this.iterables(t.childNodes,e.childNodes))}}r.Comparator=u,u.__name__="Comparator";const{abs:l}=Math;class b extends u{constructor(t=1e-4){super(),this.tolerance=t}numbers(t,e){return super.numbers(t,e)||l(t-e)<this.tolerance}}r.SimilarComparator=b,b.__name__="SimilarComparator",r.is_equal=function(t,e){return(new u).eq(t,e)},r.is_structurally_equal=function(t,e){return new u({structural:!0}).eq(t,e)},r.is_similar=function(t,e,r){return new b(r).eq(t,e)}},
function _(n,t,i,e,r){e(),i.is_mobile="ontouchstart"in globalThis||"undefined"!=typeof navigator&&navigator.maxTouchPoints>0,i.is_little_endian=(()=>{const n=new ArrayBuffer(4),t=new Uint8Array(n);new Uint32Array(n)[1]=168496141;let i=!0;return 10==t[4]&&11==t[5]&&12==t[6]&&13==t[7]&&(i=!1),i})(),i.BYTE_ORDER=i.is_little_endian?"little":"big",i.to_big_endian=function(n){if(i.is_little_endian){const t=new Uint32Array(n.length),i=new DataView(t.buffer);let e=0;for(const t of n)i.setUint32(e,t),e+=4;return t}return n}},
function _(i,n,e,t,u){t();const c=i(8);e.isValue=function(i){return(0,c.isPlainObject)(i)&&"value"in i},e.isField=function(i){return(0,c.isPlainObject)(i)&&"field"in i},e.isExpr=function(i){return(0,c.isPlainObject)(i)&&"expr"in i}},
function _(e,t,r,s,_){s();class i{constructor(){this._dev=!1,this._wireframe=!1,this._force_webgl=!1}set dev(e){this._dev=e}get dev(){return this._dev}set wireframe(e){this._wireframe=e}get wireframe(){return this._wireframe}set force_webgl(e){this._force_webgl=e}get force_webgl(){return this._force_webgl}}r.Settings=i,i.__name__="Settings",r.settings=new i},
function _(t,e,s,r,n){var a,i,h,u,l,o,p,c,y,_;r();const A=t(8),d=t(26),f=t(25),m=t(30),N=Symbol("__ndarray__");function g(t,e){return{type:"ndarray",array:e.encode("object"==t.dtype?Array.from(t):t.buffer),order:d.BYTE_ORDER,dtype:t.dtype,shape:t.shape}}class D extends Uint8Array{constructor(t,e){super(t),this[a]=!0,this.dtype="bool",this.shape=null!=e?e:B(t)?t.shape:[this.length],this.dimension=this.shape.length}[(a=N,f.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[m.serialize](t){return g(this,t)}}s.BoolNDArray=D,D.__name__="BoolNDArray";class q extends Uint8Array{constructor(t,e){super(t),this[i]=!0,this.dtype="uint8",this.shape=null!=e?e:B(t)?t.shape:[this.length],this.dimension=this.shape.length}[(i=N,f.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[m.serialize](t){return g(this,t)}}s.Uint8NDArray=q,q.__name__="Uint8NDArray";class b extends Int8Array{constructor(t,e){super(t),this[h]=!0,this.dtype="int8",this.shape=null!=e?e:B(t)?t.shape:[this.length],this.dimension=this.shape.length}[(h=N,f.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[m.serialize](t){return g(this,t)}}s.Int8NDArray=b,b.__name__="Int8NDArray";class w extends Uint16Array{constructor(t,e){super(t),this[u]=!0,this.dtype="uint16",this.shape=null!=e?e:B(t)?t.shape:[this.length],this.dimension=this.shape.length}[(u=N,f.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[m.serialize](t){return g(this,t)}}s.Uint16NDArray=w,w.__name__="Uint16NDArray";class U extends Int16Array{constructor(t,e){super(t),this[l]=!0,this.dtype="int16",this.shape=null!=e?e:B(t)?t.shape:[this.length],this.dimension=this.shape.length}[(l=N,f.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[m.serialize](t){return g(this,t)}}s.Int16NDArray=U,U.__name__="Int16NDArray";class I extends Uint32Array{constructor(t,e){super(t),this[o]=!0,this.dtype="uint32",this.shape=null!=e?e:B(t)?t.shape:[this.length],this.dimension=this.shape.length}[(o=N,f.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[m.serialize](t){return g(this,t)}}s.Uint32NDArray=I,I.__name__="Uint32NDArray";class x extends Int32Array{constructor(t,e){super(t),this[p]=!0,this.dtype="int32",this.shape=null!=e?e:B(t)?t.shape:[this.length],this.dimension=this.shape.length}[(p=N,f.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[m.serialize](t){return g(this,t)}}s.Int32NDArray=x,x.__name__="Int32NDArray";class z extends Float32Array{constructor(t,e){super(t),this[c]=!0,this.dtype="float32",this.shape=null!=e?e:B(t)?t.shape:[this.length],this.dimension=this.shape.length}[(c=N,f.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[m.serialize](t){return g(this,t)}}s.Float32NDArray=z,z.__name__="Float32NDArray";class F extends Float64Array{constructor(t,e){super(t),this[y]=!0,this.dtype="float64",this.shape=null!=e?e:B(t)?t.shape:[this.length],this.dimension=this.shape.length}[(y=N,f.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[m.serialize](t){return g(this,t)}}s.Float64NDArray=F,F.__name__="Float64NDArray";class j extends Array{constructor(t,e){const s=t instanceof ArrayBuffer?new Float64Array(t):t;if(super((0,A.isNumber)(s)?s:s.length),this[_]=!0,this.dtype="object",!(0,A.isNumber)(s))for(let t=0;t<s.length;t++)this[t]=s[t];this.shape=null!=e?e:B(s)?s.shape:[this.length],this.dimension=this.shape.length}[(_=N,f.equals)](t,e){return e.eq(this.shape,t.shape)&&e.arrays(this,t)}[m.serialize](t){return g(this,t)}}function B(t){return(0,A.isObject)(t)&&N in t}s.ObjectNDArray=j,j.__name__="ObjectNDArray",s.is_NDArray=B,s.ndarray=function(t,{dtype:e,shape:s}={}){switch(null==e&&(e=(()=>{switch(!0){case t instanceof Uint8Array:return"uint8";case t instanceof Int8Array:return"int8";case t instanceof Uint16Array:return"uint16";case t instanceof Int16Array:return"int16";case t instanceof Uint32Array:return"uint32";case t instanceof Int32Array:return"int32";case t instanceof Float32Array:return"float32";case t instanceof ArrayBuffer:case t instanceof Float64Array:return"float64";default:return"object"}})()),e){case"bool":return new D(t,s);case"uint8":return new q(t,s);case"int8":return new b(t,s);case"uint16":return new w(t,s);case"int16":return new U(t,s);case"uint32":return new I(t,s);case"int32":return new x(t,s);case"float32":return new z(t,s);case"float64":return new F(t,s);case"object":return new j(t,s)}}},
function _(r,e,i,a,f){a();const o=r(1);var l=r(31);f("Serializer",l.Serializer),f("SerializationError",l.SerializationError),f("serialize",l.serialize);var t=r(33);f("Buffer",t.Buffer),f("Base64Buffer",t.Base64Buffer),o.__exportStar(r(35),i)},
function _(e,r,t,n,i){n();const s=e(12),a=e(9),o=e(8),c=e(32),l=e(26),u=e(33);t.serialize=Symbol("serialize");class f extends Error{}t.SerializationError=f,f.__name__="SerializationError";class d{constructor(e){this.value=e}to_json(){return JSON.stringify(this.value)}}d.__name__="Serialized";class y{constructor(e){var r,t;this._circular=new WeakSet,this.binary=null!==(r=null==e?void 0:e.binary)&&void 0!==r&&r,this.include_defaults=null!==(t=null==e?void 0:e.include_defaults)&&void 0!==t&&t;const n=null==e?void 0:e.references;this._references=null!=n?new Map(n):new Map}get_ref(e){return this._references.get(e)}add_ref(e,r){(0,s.assert)(!this._references.has(e)),this._references.set(e,r)}to_serializable(e){return new d(this.encode(e))}encode(e){const r=this.get_ref(e);if(null!=r)return r;if(!(0,o.isObject)(e))return this._encode(e);this._circular.has(e)&&this.error("circular reference"),this._circular.add(e);try{return this._encode(e)}finally{this._circular.delete(e)}}_encode(e){if(function(e){return(0,o.isObject)(e)&&t.serialize in e}(e))return e[t.serialize](this);if((0,o.isArray)(e)){const r=e.length,t=new Array(r);for(let n=0;n<r;n++){const r=e[n];t[n]=this.encode(r)}return t}if((0,o.isTypedArray)(e))return this._encode_typed_array(e);if(e instanceof ArrayBuffer){return{type:"bytes",data:this.binary?new u.Buffer(e):new u.Base64Buffer(e)}}if((0,o.isPlainObject)(e))return{type:"map",entries:[...(0,c.map)((0,a.entries)(e),(([e,r])=>[this.encode(e),this.encode(r)]))]};if(null===e||(0,o.isBoolean)(e)||(0,o.isString)(e))return e;if((0,o.isNumber)(e))return isNaN(e)?{type:"number",value:"nan"}:isFinite(e)?e:{type:"number",value:(e<0?"-":"+")+"inf"};if(e instanceof Set)return{type:"set",entries:[...(0,c.map)(e.values(),(e=>this.encode(e)))]};if(e instanceof Map)return{type:"map",entries:[...(0,c.map)(e.entries(),(([e,r])=>[this.encode(e),this.encode(r)]))]};if((0,o.isSymbol)(e)&&null!=e.description)return{type:"symbol",name:e.description};throw new f(`${Object.prototype.toString.call(e)} is not serializable`)}encode_struct(e){const r={};for(const[t,n]of(0,a.entries)(e))void 0!==n&&(r[t]=this.encode(n));return r}error(e){throw new f(e)}_encode_typed_array(e){const r=this.encode(e.buffer),t=(()=>{switch(e.constructor){case Uint8Array:return"uint8";case Int8Array:return"int8";case Uint16Array:return"uint16";case Int16Array:return"int16";case Uint32Array:return"uint32";case Int32Array:return"int32";case Float32Array:return"float32";case Float64Array:return"float64";default:this.error(`can't serialize typed array of type '${e[Symbol.toStringTag]}'`)}})();return{type:"typed_array",array:r,order:l.BYTE_ORDER,dtype:t}}}t.Serializer=y,y.__name__="Serializer"},
function _(n,o,t,e,f){e();const i=n(10),r=n(12),{abs:l,ceil:c,max:s}=Math;function*u(n){const o=n.length;for(let t=0;t<o;t++)yield n[o-t-1]}function*a(n,o){(0,r.assert)(o>=0);for(const t of n)0==o?yield t:o-=1}function*y(n,o){const t=n.length;if(o>t)return;const e=(0,i.range)(o);for(yield e.map((o=>n[o]));;){let f;for(const n of u((0,i.range)(o)))if(e[n]!=n+t-o){f=n;break}if(null==f)return;e[f]+=1;for(const n of(0,i.range)(f+1,o))e[n]=e[n-1]+1;yield e.map((o=>n[o]))}}t.range=function*(n,o,t=1){(0,r.assert)(t>0),null==o&&(o=n,n=0);const e=n<=o?t:-t,f=s(c(l(o-n)/t),0);for(let o=0;o<f;o++,n+=e)yield n},t.reverse=u,t.enumerate=function*(n){let o=0;for(const t of n)yield[t,o++]},t.skip=a,t.tail=function*(n){yield*a(n,1)},t.join=function*(n,o){let t=!0;for(const e of n)t?t=!1:null!=o&&(yield o()),yield*e},t.interleave=function*(n,o){let t=!0;for(const e of n)t?t=!1:yield o(),yield e},t.map=function*(n,o){let t=0;for(const e of n)yield o(e,t++)},t.flat_map=function*(n,o){let t=0;for(const e of n)yield*o(e,t++)},t.every=function(n,o){for(const t of n)if(!o(t))return!1;return!0},t.some=function(n,o){for(const t of n)if(o(t))return!0;return!1},t.combinations=y,t.subsets=function*(n){for(const o of(0,i.range)(n.length+1))yield*y(n,o)}},
function _(e,f,r,s,t){s();const u=e(34),_=e(25);class a{constructor(e){this.buffer=e}to_base64(){return(0,u.buffer_to_base64)(this.buffer)}[_.equals](e,f){return f.eq(this.buffer,e.buffer)}}r.Buffer=a,a.__name__="Buffer";class n extends a{toJSON(){return this.to_base64()}}r.Base64Buffer=n,n.__name__="Base64Buffer"},
function _(t,n,e,r,o){r(),e.buffer_to_base64=function(t){const n=new Uint8Array(t),e=Array.from(n).map((t=>String.fromCharCode(t)));return btoa(e.join(""))},e.base64_to_buffer=function(t){const n=atob(t),e=n.length,r=new Uint8Array(e);for(let t=0,o=e;t<o;t++)r[t]=n.charCodeAt(t);return r.buffer},e.swap=function(t,n){switch(n){case"uint16":case"int16":!function(t){const n=new Uint8Array(t);for(let t=0,e=n.length;t<e;t+=2){const e=n[t];n[t]=n[t+1],n[t+1]=e}}(t);break;case"uint32":case"int32":case"float32":!function(t){const n=new Uint8Array(t);for(let t=0,e=n.length;t<e;t+=4){let e=n[t];n[t]=n[t+3],n[t+3]=e,e=n[t+1],n[t+1]=n[t+2],n[t+2]=e}}(t);break;case"float64":!function(t){const n=new Uint8Array(t);for(let t=0,e=n.length;t<e;t+=8){let e=n[t];n[t]=n[t+7],n[t+7]=e,e=n[t+1],n[t+1]=n[t+6],n[t+6]=e,e=n[t+2],n[t+2]=n[t+5],n[t+5]=e,e=n[t+3],n[t+3]=n[t+4],n[t+4]=e}}(t)}}},
function _(n,c,f,i,o){i()},
function _(s,t,e,n,i){n();class c{constructor(){this.listeners=new Set}connect(s){this.listeners.add(s)}disconnect(s){this.listeners.delete(s)}report(s){for(const t of this.listeners)t(s)}}e.Diagnostics=c,c.__name__="Diagnostics",e.diagnostics=new c},
function _(t,r,e,s,a){s();const i=t(25);class n{is_Scalar(){return this.is_scalar}is_Vector(){return!this.is_scalar}}e.Uniform=n,n.__name__="Uniform";class l extends n{constructor(t,r){super(),this.value=t,this.length=r,this.is_scalar=!0}get(t){return this.value}*[Symbol.iterator](){const{length:t,value:r}=this;for(let e=0;e<t;e++)yield r}select(t){return new l(this.value,t.count)}[i.equals](t,r){return r.eq(this.length,t.length)&&r.eq(this.value,t.value)}}e.UniformScalar=l,l.__name__="UniformScalar";class o extends n{constructor(t){super(),this.array=t,this.is_scalar=!1,this.length=this.array.length}get(t){return this.array[t]}*[Symbol.iterator](){yield*this.array}select(t){const r=t.select(this.array);return new this.constructor(r)}[i.equals](t,r){return r.eq(this.length,t.length)&&r.eq(this.array,t.array)}}e.UniformVector=o,o.__name__="UniformVector";class h extends o{constructor(t){super(t),this.array=t,this._view=new DataView(t.buffer)}get(t){return this._view.getUint32(4*t)}*[Symbol.iterator](){const t=this.length;for(let r=0;r<t;r++)yield this.get(r)}}e.ColorUniformVector=h,h.__name__="ColorUniformVector"},
function _(t,e,r,n,u){n();const s=t(28);function c(){const t=new Array(32),e="0123456789ABCDEF";for(let r=0;r<32;r++)t[r]=e.substr(Math.floor(16*Math.random()),1);return t[12]="4",t[16]=e.substr(3&t[16].charCodeAt(0)|8,1),t.join("")}r.startsWith=function(t,e,r=0){return t.substr(r,e.length)==e},r.uuid4=c;let a=1e3;function i(t){const e=s.settings.dev?"j"+a++:c();return null!=t?`${t}-${e}`:e}r.unique_id=i,r.uniqueId=i,r.escape=function(t){return t.replace(/(?:[&<>"'`])/g,(t=>{switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return t}}))},r.unescape=function(t){return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,((t,e)=>{switch(e){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return e}}))},r.use_strict=function(t){return`'use strict';\n${t}`},r.to_fixed=function(t,e){return t.toFixed(e).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"")},r.insert_text_on_position=function(t,e,r){const n=[];return n.push(t.slice(0,e)),n.push(r),n.push(t.slice(e)),n.join("")}},
function _(e,t,s,n,a){n();const i=e(25),r=e(30);class d{constructor(e){this.document=e}get[Symbol.toStringTag](){return this.constructor.__name__}[i.equals](e,t){return t.eq(this.document,e.document)}}s.DocumentEvent=d,d.__name__="DocumentEvent";class o extends d{constructor(e,t){super(e),this.events=t}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.events,e.events)}}s.DocumentEventBatch=o,o.__name__="DocumentEventBatch";class l extends d{}s.DocumentChangedEvent=l,l.__name__="DocumentChangedEvent";class h extends l{constructor(e,t,s){super(e),this.msg_type=t,this.msg_data=s,this.kind="MessageSent"}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.msg_type,e.msg_type)&&t.eq(this.msg_data,e.msg_data)}[r.serialize](e){return{kind:this.kind,msg_type:this.msg_type,msg_data:e.encode(this.msg_data)}}}s.MessageSentEvent=h,h.__name__="MessageSentEvent";class u extends l{constructor(e,t,s,n){super(e),this.model=t,this.attr=s,this.value=n,this.kind="ModelChanged"}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.value,e.value)}[r.serialize](e){return{kind:this.kind,model:this.model.ref(),attr:this.attr,new:e.encode(this.value)}}}s.ModelChangedEvent=u,u.__name__="ModelChangedEvent";class m extends l{constructor(e,t,s,n,a){super(e),this.model=t,this.attr=s,this.data=n,this.cols=a,this.kind="ColumnDataChanged"}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.data,e.data)&&t.eq(this.cols,e.cols)}[r.serialize](e){return{kind:this.kind,model:this.model.ref(),attr:this.attr,data:e.encode(this.data),cols:this.cols}}}s.ColumnDataChangedEvent=m,m.__name__="ColumnDataChangedEvent";class c extends l{constructor(e,t,s,n,a){super(e),this.model=t,this.attr=s,this.data=n,this.rollover=a,this.kind="ColumnsStreamed"}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.data,e.data)&&t.eq(this.rollover,e.rollover)}[r.serialize](e){return{kind:this.kind,model:this.model.ref(),attr:this.attr,data:e.encode(this.data),rollover:this.rollover}}}s.ColumnsStreamedEvent=c,c.__name__="ColumnsStreamedEvent";class _ extends l{constructor(e,t,s,n){super(e),this.model=t,this.attr=s,this.patches=n,this.kind="ColumnsPatched"}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)&&t.eq(this.attr,e.attr)&&t.eq(this.patches,e.patches)}[r.serialize](e){return{kind:this.kind,attr:this.attr,model:this.model.ref(),patches:e.encode(this.patches)}}}s.ColumnsPatchedEvent=_,_.__name__="ColumnsPatchedEvent";class q extends l{constructor(e,t){super(e),this.title=t,this.kind="TitleChanged"}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.title,e.title)}[r.serialize](e){return{kind:this.kind,title:this.title}}}s.TitleChangedEvent=q,q.__name__="TitleChangedEvent";class v extends l{constructor(e,t){super(e),this.model=t,this.kind="RootAdded"}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)}[r.serialize](e){return{kind:this.kind,model:e.encode(this.model)}}}s.RootAddedEvent=v,v.__name__="RootAddedEvent";class p extends l{constructor(e,t){super(e),this.model=t,this.kind="RootRemoved"}[i.equals](e,t){return super[i.equals](e,t)&&t.eq(this.model,e.model)}[r.serialize](e){return{kind:this.kind,model:this.model.ref()}}}s.RootRemovedEvent=p,p.__name__="RootRemovedEvent"},
function _(t,r,i,n,e){n();const s=t(8),o=t(9);i.pretty=Symbol("pretty");class u{constructor(t){this.visited=new Set,this.precision=null==t?void 0:t.precision}to_string(t){if((0,s.isObject)(t)){if(this.visited.has(t))return"<circular>";this.visited.add(t)}return function(t){return(0,s.isObject)(t)&&i.pretty in t}(t)?t[i.pretty](this):(0,s.isBoolean)(t)?this.boolean(t):(0,s.isNumber)(t)?this.number(t):(0,s.isString)(t)?this.string(t):(0,s.isArray)(t)?this.array(t):(0,s.isIterable)(t)?this.iterable(t):(0,s.isPlainObject)(t)?this.object(t):(0,s.isSymbol)(t)?this.symbol(t):t instanceof ArrayBuffer?this.array_buffer(t):`${t}`}token(t){return t}boolean(t){return`${t}`}number(t){return null!=this.precision?t.toFixed(this.precision):`${t}`}string(t){const r=t.includes("'"),i=t.includes('"');return r&&i?`\`${t.replace(/`/g,"\\`")}\``:i?`'${t}'`:`"${t}"`}symbol(t){return t.toString()}array(t){const r=this.token,i=[];for(const r of t)i.push(this.to_string(r));return`${r("[")}${i.join(`${r(",")} `)}${r("]")}`}iterable(t){var r;const i=this.token,n=null!==(r=Object(t)[Symbol.toStringTag])&&void 0!==r?r:"Object",e=this.array(t);return`${n}${i("(")}${e}${i(")")}`}object(t){const r=this.token,i=[];for(const[n,e]of(0,o.entries)(t))i.push(`${n}${r(":")} ${this.to_string(e)}`);return`${r("{")}${i.join(`${r(",")} `)}${r("}")}`}array_buffer(t){return`ArrayBuffer(#${t.byteLength})`}}i.Printer=u,u.__name__="Printer",i.to_string=function(t,r){return new u(r).to_string(t)}},
function _(n,e,t,o,r){o();const i=n(9),c=n(8);function l(n){return(0,c.isObject)(n)&&t.clone in n}t.clone=Symbol("clone"),t.is_Cloneable=l;class s extends Error{}t.CloningError=s,s.__name__="CloningError";class a{constructor(){}clone(n){if(l(n))return n[t.clone](this);if((0,c.isPrimitive)(n))return n;if((0,c.isArray)(n)){const e=n.length,t=new Array(e);for(let o=0;o<e;o++){const e=n[o];t[o]=this.clone(e)}return t}if((0,c.isPlainObject)(n)){const e={};for(const[t,o]of(0,i.entries)(n))e[t]=this.clone(o);return e}if(n instanceof Map)return new Map([...n].map((([n,e])=>[this.clone(n),this.clone(e)])));if(n instanceof Set)return new Set([...n].map((n=>this.clone(n))));throw new s(`${Object.prototype.toString.call(n)} is not cloneable`)}}t.Cloner=a,a.__name__="Cloner"},
function _(t,n,e,o,r){o();const s=t(1),l=t(8),c=t(9),u=t(43),i=s.__importStar(t(44));function f(t,n,e){if((0,l.isArray)(t)){const o=t.concat(n);return null!=e&&o.length>e?o.slice(-e):o}if((0,l.isTypedArray)(t)){const o=t.length+n.length;if(null!=e&&o>e){const r=o-e,s=t.length;let l;t.length<e?(l=new t.constructor(e),l.set(t,0)):l=t;for(let t=r,n=s;t<n;t++)l[t-r]=l[t];for(let t=0,e=n.length;t<e;t++)l[t+(s-r)]=n[t];return l}{const e=new t.constructor(n);return i.concat(t,e)}}throw new Error("unsupported array types")}function a(t,n){let e,o,r;return(0,l.isNumber)(t)?(e=t,r=t+1,o=1):(e=null!=t.start?t.start:0,r=null!=t.stop?t.stop:n,o=null!=t.step?t.step:1),[e,r,o]}function h(t,n){const e=new Set;let o=!1;for(const[r,s]of n){let n,c,u,i;if((0,l.isArray)(r)){const[o]=r;e.add(o),n=t[o].shape,c=t[o],i=s,2===r.length?(n=[1,n[0]],u=[r[0],0,r[1]]):u=r}else(0,l.isNumber)(r)?(i=[s],e.add(r)):(i=s,o=!0),u=[0,0,r],n=[1,t.length],c=t;let f=0;const[h,p,_]=a(u[1],n[0]),[m,d,g]=a(u[2],n[1]);for(let t=h;t<p;t+=_)for(let r=m;r<d;r+=g)o&&e.add(r),c[t*n[1]+r]=i[f],f++}return e}e.stream_to_column=f,e.slice=a,e.patch_to_column=h,e.stream_to_columns=function(t,n,e){for(const[o,r]of(0,c.entries)(n))t[o]=f(t[o],r,e)},e.patch_to_columns=function(t,n){let e=new Set;for(const[o,r]of(0,c.entries)(n))e=(0,u.union)(e,h(t[o],r));return e}},
function _(n,o,t,e,f){function c(...n){const o=new Set;for(const t of n)for(const n of t)o.add(n);return o}e(),t.union=c,t.intersection=function(n,...o){const t=new Set;n:for(const e of n){for(const n of o)if(!n.has(e))continue n;t.add(e)}return t},t.difference=function(n,...o){const t=new Set(n);for(const n of c(...o))t.delete(n);return t}},
function _(t,n,o,e,c){e(),o.concat=function(t,...n){let o=t.length;for(const t of n)o+=t.length;const e=new t.constructor(o);e.set(t,0);let c=t.length;for(const t of n)e.set(t,c),c+=t.length;return e}},
function _(e,s,t,n,o){n();class l{constructor(e,s=[]){this.parent=e,this._known_models=new Map;for(const e of s)this.register(e)}get(e){var s,t,n;return null!==(n=null!==(s=this._known_models.get(e))&&void 0!==s?s:null===(t=this.parent)||void 0===t?void 0:t.get(e))&&void 0!==n?n:null}register(e,s=!1){const t=e.__qualified__;s||null==this.get(t)?this._known_models.set(t,e):console.warn(`Model '${t}' was already registered with this resolver`)}get names(){return[...this._known_models.keys()]}}t.ModelResolver=l,l.__name__="ModelResolver"},
function _(e,t,s,n,a){n();var _=this&&this.__decorate||function(e,t,s,n){var a,_=arguments.length,l=_<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,s):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)l=Reflect.decorate(e,t,s,n);else for(var r=e.length-1;r>=0;r--)(a=e[r])&&(l=(_<3?a(l):_>3?a(t,s,l):a(t,s))||l);return _>3&&l&&Object.defineProperty(t,s,l),l};const l=e(30),r=e(25);function c(e){return t=>{t.prototype.event_name=e}}class o{[l.serialize](e){const{event_name:t,event_values:s}=this;return{type:"event",name:t,values:e.encode(s)}}[r.equals](e,t){return this.event_name==e.event_name&&t.eq(this.event_values,e.event_values)}}s.BokehEvent=o,o.__name__="BokehEvent";class u extends o{constructor(){super(...arguments),this.origin=null}get event_values(){return{model:this.origin}}}s.ModelEvent=u,u.__name__="ModelEvent";let i=class extends o{get event_values(){return{}}};s.DocumentReady=i,i.__name__="DocumentReady",s.DocumentReady=i=_([c("document_ready")],i);let d=class extends u{};s.ButtonClick=d,d.__name__="ButtonClick",s.ButtonClick=d=_([c("button_click")],d);let v=class extends u{constructor(e){super(),this.item=e}get event_values(){const{item:e}=this;return Object.assign(Object.assign({},super.event_values),{item:e})}};s.MenuItemClick=v,v.__name__="MenuItemClick",s.MenuItemClick=v=_([c("menu_item_click")],v);class m extends u{}s.UIEvent=m,m.__name__="UIEvent";let h=class extends m{};s.LODStart=h,h.__name__="LODStart",s.LODStart=h=_([c("lodstart")],h);let p=class extends m{};s.LODEnd=p,p.__name__="LODEnd",s.LODEnd=p=_([c("lodend")],p);let x=class extends m{constructor(e,t,s,n){super(),this.x0=e,this.x1=t,this.y0=s,this.y1=n}get event_values(){const{x0:e,x1:t,y0:s,y1:n}=this;return Object.assign(Object.assign({},super.event_values),{x0:e,x1:t,y0:s,y1:n})}};s.RangesUpdate=x,x.__name__="RangesUpdate",s.RangesUpdate=x=_([c("rangesupdate")],x);let g=class extends m{constructor(e,t){super(),this.geometry=e,this.final=t}get event_values(){const{geometry:e,final:t}=this;return Object.assign(Object.assign({},super.event_values),{geometry:e,final:t})}};s.SelectionGeometry=g,g.__name__="SelectionGeometry",s.SelectionGeometry=g=_([c("selectiongeometry")],g);let y=class extends m{};s.Reset=y,y.__name__="Reset",s.Reset=y=_([c("reset")],y);class P extends m{constructor(e,t,s,n){super(),this.sx=e,this.sy=t,this.x=s,this.y=n}get event_values(){const{sx:e,sy:t,x:s,y:n}=this;return Object.assign(Object.assign({},super.event_values),{sx:e,sy:t,x:s,y:n})}}s.PointEvent=P,P.__name__="PointEvent";let O=class extends P{constructor(e,t,s,n,a,_){super(e,t,s,n),this.delta_x=a,this.delta_y=_}get event_values(){const{delta_x:e,delta_y:t}=this;return Object.assign(Object.assign({},super.event_values),{delta_x:e,delta_y:t})}};s.Pan=O,O.__name__="Pan",s.Pan=O=_([c("pan")],O);let b=class extends P{constructor(e,t,s,n,a){super(e,t,s,n),this.scale=a}get event_values(){const{scale:e}=this;return Object.assign(Object.assign({},super.event_values),{scale:e})}};s.Pinch=b,b.__name__="Pinch",s.Pinch=b=_([c("pinch")],b);let E=class extends P{constructor(e,t,s,n,a){super(e,t,s,n),this.rotation=a}get event_values(){const{rotation:e}=this;return Object.assign(Object.assign({},super.event_values),{rotation:e})}};s.Rotate=E,E.__name__="Rotate",s.Rotate=E=_([c("rotate")],E);let R=class extends P{constructor(e,t,s,n,a){super(e,t,s,n),this.delta=a}get event_values(){const{delta:e}=this;return Object.assign(Object.assign({},super.event_values),{delta:e})}};s.MouseWheel=R,R.__name__="MouseWheel",s.MouseWheel=R=_([c("wheel")],R);let M=class extends P{};s.MouseMove=M,M.__name__="MouseMove",s.MouseMove=M=_([c("mousemove")],M);let j=class extends P{};s.MouseEnter=j,j.__name__="MouseEnter",s.MouseEnter=j=_([c("mouseenter")],j);let f=class extends P{};s.MouseLeave=f,f.__name__="MouseLeave",s.MouseLeave=f=_([c("mouseleave")],f);let S=class extends P{};s.Tap=S,S.__name__="Tap",s.Tap=S=_([c("tap")],S);let D=class extends P{};s.DoubleTap=D,D.__name__="DoubleTap",s.DoubleTap=D=_([c("doubletap")],D);let k=class extends P{};s.Press=k,k.__name__="Press",s.Press=k=_([c("press")],k);let L=class extends P{};s.PressUp=L,L.__name__="PressUp",s.PressUp=L=_([c("pressup")],L);let U=class extends P{};s.PanStart=U,U.__name__="PanStart",s.PanStart=U=_([c("panstart")],U);let C=class extends P{};s.PanEnd=C,C.__name__="PanEnd",s.PanEnd=C=_([c("panend")],C);let T=class extends P{};s.PinchStart=T,T.__name__="PinchStart",s.PinchStart=T=_([c("pinchstart")],T);let B=class extends P{};s.PinchEnd=B,B.__name__="PinchEnd",s.PinchEnd=B=_([c("pinchend")],B);let I=class extends P{};s.RotateStart=I,I.__name__="RotateStart",s.RotateStart=I=_([c("rotatestart")],I);let G=class extends P{};s.RotateEnd=G,G.__name__="RotateEnd",s.RotateEnd=G=_([c("rotateend")],G)},
function _(e,r,t,s,n){s();const i=e(48),o=e(29),d=e(9),a=e(10),c=e(26),_=e(34),u=e(8),l=e(49),f=new Map;class h extends Error{}t.DeserializationError=h,h.__name__="DeserializationError";class y{constructor(e,r=new Map,t){this.resolver=e,this.references=r,this.finalize=t,this._decoding=!1,this._buffers=new Map,this._finalizable=new Set}static register(e,r){if(f.has(e))throw new Error(`'${e}' already registered for decoding`);f.set(e,r)}decode(e,r){var t;if(null!=r)for(const[e,t]of r)this._buffers.set(e,t);if(this._decoding)return this._decode(e);let s;this._decoding=!0;const n=(()=>{try{return this._decode(e)}finally{s=new Set(this._finalizable),this._decoding=!1,this._buffers.clear(),this._finalizable.clear()}})();for(const e of s)null===(t=this.finalize)||void 0===t||t.call(this,e),e.finalize();for(const e of s)e.connect_signals();return n}_decode(e){if((0,u.isArray)(e))return this._decode_plain_array(e);if(!(0,u.isPlainObject)(e))return e;if(!(0,u.isString)(e.type))return(0,u.isString)(e.id)?this._decode_ref(e):this._decode_plain_object(e);{const r=f.get(e.type);if(null!=r)return r(e,this);switch(e.type){case"ref":return this._decode_ref(e);case"symbol":return this._decode_symbol(e);case"number":return this._decode_number(e);case"array":return this._decode_array(e);case"set":return this._decode_set(e);case"map":return this._decode_map(e);case"bytes":return this._decode_bytes(e);case"slice":return this._decode_slice(e);case"value":return this._decode_value(e);case"field":return this._decode_field(e);case"expr":return this._decode_expr(e);case"typed_array":return this._decode_typed_array(e);case"ndarray":return this._decode_ndarray(e);case"object":return(0,u.isString)(e.id)?this._decode_object_ref(e):this._decode_object(e);default:this.error(`unable to decode an object of type '${e.type}'`)}}}_decode_symbol(e){this.error(`can't resolve named symbol '${e.name}'`)}_decode_number(e){if("value"in e){const{value:r}=e;if((0,u.isString)(r))switch(r){case"nan":return NaN;case"+inf":return 1/0;case"-inf":return-1/0}else if((0,u.isNumber)(r))return r}this.error(`invalid number representation '${e}'`)}_decode_plain_array(e){return(0,a.map)(e,(e=>this._decode(e)))}_decode_plain_object(e){const r={};for(const[t,s]of(0,d.entries)(e))r[t]=this._decode(s);return r}_decode_array(e){const r=[];for(const t of e.entries)r.push(this._decode(t));return r}_decode_set(e){const r=new Set;for(const t of e.entries)r.add(this._decode(t));return r}_decode_map(e){const r=(0,a.map)(e.entries,(([e,r])=>[this._decode(e),this._decode(r)]));if((0,a.every)(r,(([e])=>(0,u.isString)(e)))){const e={};for(const[t,s]of r)e[t]=s;return e}return new Map(r)}_decode_bytes(e){const{data:r}=e;if(!(0,i.is_ref)(r))return(0,u.isString)(r)?(0,_.base64_to_buffer)(r):r.buffer;{const e=this._buffers.get(r.id);if(null!=e)return e;this.error(`buffer for id=${r.id} not found`)}}_decode_slice(e){const r=this._decode(e.start),t=this._decode(e.stop),s=this._decode(e.step);return new l.Slice({start:r,stop:t,step:s})}_decode_value(e){return{value:this._decode(e.value),transform:null!=e.transform?this._decode(e.transform):void 0,units:null!=e.units?this._decode(e.units):void 0}}_decode_field(e){return{field:this._decode(e.field),transform:null!=e.transform?this._decode(e.transform):void 0,units:null!=e.units?this._decode(e.units):void 0}}_decode_expr(e){return{expr:this._decode(e.expr),transform:null!=e.transform?this._decode(e.transform):void 0,units:null!=e.units?this._decode(e.units):void 0}}_decode_typed_array(e){const{array:r,order:t,dtype:s}=e,n=this._decode(r);switch(t!=c.BYTE_ORDER&&(0,_.swap)(n,s),s){case"uint8":return new Uint8Array(n);case"int8":return new Int8Array(n);case"uint16":return new Uint16Array(n);case"int16":return new Int16Array(n);case"uint32":return new Uint32Array(n);case"int32":return new Int32Array(n);case"float32":return new Float32Array(n);case"float64":return new Float64Array(n);default:this.error(`unsupported dtype '${s}'`)}}_decode_ndarray(e){const{array:r,order:t,dtype:s,shape:n}=e,i=this._decode(r);return i instanceof ArrayBuffer&&t!=c.BYTE_ORDER&&(0,_.swap)(i,s),(0,o.ndarray)(i,{dtype:s,shape:n})}_decode_object(e){const{type:r,attributes:t}=e,s=this._resolve_type(r);return null!=t?new s(this._decode(t)):new s}_decode_ref(e){const r=this.references.get(e.id);if(null!=r)return r;this.error(`reference ${e.id} isn't known`)}_decode_object_ref(e){this.references.has(e.id)&&this.error(`reference already known '${e.id}'`);const{id:r,name:t,attributes:s}=e,n=new(this._resolve_type(t))({id:r});this.references.set(r,n);const i=this._decode(null!=s?s:{});return n.initialize_props(new d.Dict(i)),this._finalizable.add(n),n}error(e){throw new h(e)}_resolve_type(e){const r=this.resolver.get(e);if(null!=r)return r;this.error(`could not resolve type '${e}', which could be due to a widget or a custom model not being registered before first usage`)}}t.Deserializer=y,y.__name__="Deserializer"},
function _(n,i,t,c,e){c();const f=n(8);t.is_ref=function(n){return(0,f.isPlainObject)(n)&&"id"in n&&!("type"in n)}},
function _(t,s,e,l,n){l();const i=t(30);class c{constructor({start:t,stop:s,step:e}={}){this.start=null!=t?t:null,this.stop=null!=s?s:null,this.step=null!=e?e:null}[i.serialize](t){return{type:"slice",start:t.encode(this.start),stop:t.encode(this.stop),step:t.encode(this.step)}}}e.Slice=c,c.__name__="Slice"},
function _(e,t,s,n,c){var i;n();const a=e(14),r=e(8),l=e(9),o=e(25),_=e(18);class u extends a.HasProps{constructor(e){super(e)}get is_syncable(){return this.syncable}[o.equals](e,t){return(!!t.structural||t.eq(this.id,e.id))&&super[o.equals](e,t)}initialize(){super.initialize(),this._js_callbacks=new Map}connect_signals(){super.connect_signals(),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,(()=>this._update_property_callbacks())),this.connect(this.properties.js_event_callbacks.change,(()=>this._update_event_callbacks())),this.connect(this.properties.subscribed_events.change,(()=>this._update_event_callbacks()))}_process_event(e){var t;for(const s of null!==(t=(0,l.dict)(this.js_event_callbacks).get(e.event_name))&&void 0!==t?t:[])s.execute(e);null!=this.document&&this.subscribed_events.some((t=>t==e.event_name))&&this.document.event_manager.send_event(e)}trigger_event(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))}_update_event_callbacks(){null!=this.document?this.document.event_manager.subscribed_models.add(this):_.logger.warn("WARNING: Document not defined for updating event callbacks")}_update_property_callbacks(){const e=e=>{const[t,s=null]=e.split(":");return null!=s?this.properties[s][t]:this[t]};for(const[t,s]of this._js_callbacks){const n=e(t);for(const e of s)this.disconnect(n,e)}this._js_callbacks.clear();for(const[t,s]of(0,l.dict)(this.js_property_callbacks)){const n=s.map((e=>()=>e.execute(this)));this._js_callbacks.set(t,n);const c=e(t);for(const e of n)this.connect(c,e)}}_doc_attached(){(0,l.dict)(this.js_event_callbacks).is_empty&&0==this.subscribed_events.length||this._update_event_callbacks()}_doc_detached(){this.document.event_manager.subscribed_models.delete(this)}select(e){if((0,r.isString)(e))return[...this.references()].filter((t=>t instanceof u&&t.name===e));if((0,r.isPlainObject)(e)&&"type"in e)return[...this.references()].filter((t=>t.type==e.type));if(e.prototype instanceof a.HasProps)return[...this.references()].filter((t=>t instanceof e));throw new Error("invalid selector")}select_one(e){const t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}}on_event(e,t){var s;const n=(0,r.isString)(e)?e:e.prototype.event_name;this.js_event_callbacks[n]=[...null!==(s=(0,l.dict)(this.js_event_callbacks).get(n))&&void 0!==s?s:[],(0,r.isFunction)(t)?{execute:t}:t]}}s.Model=u,i=u,u.__name__="Model",i.define((({Any:e,Unknown:t,Boolean:s,String:n,Array:c,Dict:i,Nullable:a})=>({tags:[c(t),[]],name:[a(n),null],js_property_callbacks:[i(c(e)),{}],js_event_callbacks:[i(c(e)),{}],subscribed_events:[c(n),[]],syncable:[s,!0]})))},
function _(e,n,r,t,o){t();const s=e(1),c=e(50),u=s.__importStar(e(20)),a=e(8),i=e(9);r.decode_def=function(e,n){var r,t,o;function s(e){if((0,a.isString)(e))switch(e){case"Any":return u.Any;case"Unknown":return u.Unknown;case"Boolean":return u.Boolean;case"Number":return u.Number;case"Int":return u.Int;case"Bytes":return u.Bytes;case"String":return u.String;case"Null":return u.Null}else switch(e[0]){case"Regex":{const[,n,r]=e;return u.Regex(new RegExp(n,r))}case"Nullable":{const[,n]=e;return u.Nullable(s(n))}case"Or":{const[,...n]=e;return u.Or(...n.map(s))}case"Tuple":{const[,n,...r]=e;return u.Tuple(s(n),...r.map(s))}case"Array":{const[,n]=e;return u.Array(s(n))}case"Struct":{const[,...n]=e,r=n.map((([e,n])=>[e,s(n)]));return u.Struct((0,i.to_object)(r))}case"Dict":{const[,n]=e;return u.Dict(s(n))}case"Map":{const[,n,r]=e;return u.Map(s(n),s(r))}case"Enum":{const[,...n]=e;return u.Enum(...n)}case"Ref":{const[,r]=e,t=n.resolver.get(r.id);if(null!=t)return u.Ref(t);throw new Error(`${r.id} wasn't defined before referencing it`)}case"AnyRef":return u.AnyRef()}}const l=(()=>{var r,t;const o=null!==(t=null===(r=e.extends)||void 0===r?void 0:r.id)&&void 0!==t?t:"Model";if("Model"==o)return c.Model;const s=n.resolver.get(o);if(null!=s)return s;throw new Error(`base model ${o} of ${e.name} is not defined`)})(),d=((o=class extends l{}).__qualified__=e.name,o);function f(e){return void 0===e?e:n.decode(e)}for(const n of null!==(r=e.properties)&&void 0!==r?r:[]){const e=s(n.kind);d.define({[n.name]:[e,f(n.default)]})}for(const n of null!==(t=e.overrides)&&void 0!==t?t:[])d.override({[n.name]:f(n.default)});return n.resolver.register(d),d}},
function _(n,e,t,o,i){o();const d=n(5),a=n(53),c=n(54),l=n(58);t.index={},t.add_document_standalone=async function(n,e,o=[],i=!1){const s=new a.ViewManager;async function f(i){null!=i.default_view?await async function(i){var d;const a=await(0,l.build_view)(i,{parent:null,owner:s});if(a instanceof c.DOMView){const t=n.roots().indexOf(i),c=null!==(d=o[t])&&void 0!==d?d:e;a.render_to(c)}s.add(a),t.index[i.id]=a}(i):n.notify_idle(i)}for(const e of n.roots())await f(e);return i&&(window.document.title=n.title()),n.on_change((n=>{n instanceof d.RootAddedEvent?f(n.model):n instanceof d.RootRemovedEvent?function(n){const e=s.get(n);null!=e&&(e.remove(),s.delete(e),delete t.index[n.id])}(n.model):i&&n instanceof d.TitleChangedEvent&&(window.document.title=n.title)})),s}},
function _(t,e,i,s,o){s();const n=t(15),r=t(8);class h{constructor(t){this.removed=new n.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),this._slots=new WeakMap,this._removed=!1,this._idle_notified=!1;const{model:e,parent:i,owner:s}=t;this.model=e,this.parent=i,null==i?(this.root=this,this.owner=null!=s?s:new d([this])):(this.root=i.root,this.owner=this.root.owner)}get ready(){return this._ready}*children(){}connect(t,e){let i=this._slots.get(e);return null==i&&(i=(t,i)=>{const s=Promise.resolve(e.call(this,t,i));this._ready=this._ready.then((()=>s)),this.root!=this&&(this.root._ready=this.root._ready.then((()=>this._ready)))},this._slots.set(e,i)),t.connect(i,this)}disconnect(t,e){return t.disconnect(e,this)}initialize(){this._has_finished=!1}async lazy_initialize(){}remove(){this.disconnect_signals(),this.removed.emit(),this._removed=!0}toString(){return`${this.model.type}View(${this.model.id})`}serializable_state(){return{type:this.model.type}}get is_root(){return null==this.parent}has_finished(){return this._has_finished}get is_idle(){return this.has_finished()}connect_signals(){}disconnect_signals(){n.Signal.disconnect_receiver(this)}on_change(t,e){for(const i of(0,r.isArray)(t)?t:[t])this.connect(i.change,e)}cursor(t,e){return null}notify_finished(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()}}i.View=h,h.__name__="View";class d{constructor(t=[]){this.roots=new Set(t)}get(t){for(const e of this.roots)if(e.model==t)return e;return null}add(t){this.roots.add(t)}delete(t){this.roots.delete(t)}*[Symbol.iterator](){yield*this.roots}*find(t){function*e(i){if(i.model==t)yield i;else for(const t of i.children())yield*e(t)}for(const t of this.roots)yield*e(t)}find_one(t){for(const e of this.find(t))return e;return null}find_all(t){return[...this.find(t)]}}i.ViewManager=d,d.__name__="ViewManager"},
function _(e,s,t,i,l){i();const a=e(1),n=e(53),_=e(55),h=e(8),r=a.__importDefault(e(57));class c extends n.View{get children_el(){var e;return null!==(e=this.shadow_el)&&void 0!==e?e:this.el}initialize(){super.initialize(),this.el=this._createElement()}remove(){(0,_.remove)(this.el),super.remove()}css_classes(){return[]}styles(){return[]}render_to(e){e.appendChild(this.el),this.render()}finish(){this._has_finished=!0,this.notify_finished()}_createElement(){return(0,_.createElement)(this.constructor.tag_name,{class:this.css_classes()})}}t.DOMView=c,c.__name__="DOMView",c.tag_name="div";class o extends c{initialize(){super.initialize(),this.class_list=new _.ClassList(this.el.classList)}}t.DOMElementView=o,o.__name__="DOMElementView";class d extends o{initialize(){super.initialize(),this.shadow_el=this.el.attachShadow({mode:"open"})}styles(){return[...super.styles(),r.default]}empty(){(0,_.empty)(this.shadow_el),this.class_list.clear()}render(){this.empty(),this._apply_stylesheets(this.styles()),this._apply_classes(this.css_classes())}_apply_stylesheets(e){for(const s of e){const e=(0,h.isString)(s)?new _.StyleSheet(s):s;this.shadow_el.appendChild(e.el)}}_apply_classes(e){this.class_list.add(...e)}}t.DOMComponentView=d,d.__name__="DOMComponentView"},
function _(t,e,n,i,o){i(),n.supports_adopted_stylesheets=n.px=void 0;const s=t(8),l=t(9),r=t(56),c=t=>(e={},...n)=>{const i=document.createElement(t);(0,s.isPlainObject)(e)||(n=[e,...n],e={});for(let[t,n]of(0,l.entries)(e))if(null!=n&&(!(0,s.isBoolean)(n)||n))if("class"===t&&((0,s.isString)(n)&&(n=n.split(/\s+/)),(0,s.isArray)(n)))for(const t of n)null!=t&&i.classList.add(t);else if("style"===t&&(0,s.isPlainObject)(n))for(const[t,e]of(0,l.entries)(n))i.style[t]=e;else if("data"===t&&(0,s.isPlainObject)(n))for(const[t,e]of(0,l.entries)(n))i.dataset[t]=e;else i.setAttribute(t,n);function o(t){if((0,s.isString)(t))i.appendChild(document.createTextNode(t));else if(t instanceof Node)i.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)for(const e of t)i.appendChild(e);else if(null!=t&&!1!==t)throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(t)}`)}for(const t of n)if((0,s.isArray)(t))for(const e of t)o(e);else o(t);return i};function a(t){return document.createTextNode(t)}function d(t){const e=t.parentNode;null!=e&&e.removeChild(t)}function h(t){return parseFloat(t)||0}function f(t){const e=getComputedStyle(t);return{border:{top:h(e.borderTopWidth),bottom:h(e.borderBottomWidth),left:h(e.borderLeftWidth),right:h(e.borderRightWidth)},margin:{top:h(e.marginTop),bottom:h(e.marginBottom),left:h(e.marginLeft),right:h(e.marginRight)},padding:{top:h(e.paddingTop),bottom:h(e.paddingBottom),left:h(e.paddingLeft),right:h(e.paddingRight)}}}function u(t){const e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}n.createElement=function(t,e,...n){return c(t)(e,...n)},n.div=c("div"),n.span=c("span"),n.canvas=c("canvas"),n.link=c("link"),n.style=c("style"),n.a=c("a"),n.p=c("p"),n.i=c("i"),n.pre=c("pre"),n.button=c("button"),n.label=c("label"),n.legend=c("legend"),n.fieldset=c("fieldset"),n.input=c("input"),n.select=c("select"),n.option=c("option"),n.optgroup=c("optgroup"),n.textarea=c("textarea"),n.createSVGElement=function(t,e=null,...n){const i=document.createElementNS("http://www.w3.org/2000/svg",t);for(const[t,n]of(0,l.entries)(null!=e?e:{}))null!=n&&!1!==n&&i.setAttribute(t,n);function o(t){if((0,s.isString)(t))i.appendChild(document.createTextNode(t));else if(t instanceof Node)i.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)for(const e of t)i.appendChild(e);else if(null!=t&&!1!==t)throw new Error(`expected a DOM element, string, false or null, got ${JSON.stringify(t)}`)}for(const t of n)if((0,s.isArray)(t))for(const e of t)o(e);else o(t);return i},n.text=a,n.nbsp=function(){return a("\xa0")},n.append=function(t,...e){for(const n of e)t.appendChild(n)},n.remove=d,n.replaceWith=function(t,e){const n=t.parentNode;null!=n&&n.replaceChild(e,t)},n.prepend=function(t,...e){const n=t.firstChild;for(const i of e)t.insertBefore(i,n)},n.empty=function(t,e=!1){let n;for(;n=t.firstChild;)t.removeChild(n);if(e&&t instanceof Element)for(const e of t.attributes)t.removeAttributeNode(e)},n.display=function(t,e=!0){t.style.display=e?"":"none"},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset_bbox=function(t){const{top:e,left:n,width:i,height:o}=t.getBoundingClientRect();return new r.BBox({left:n+window.pageXOffset-document.documentElement.clientLeft,top:e+window.pageYOffset-document.documentElement.clientTop,width:i,height:o})},n.parent=function(t,e){let n=t;for(;n=n.parentElement;)if(n.matches(e))return n;return null},n.extents=f,n.size=u,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){const{margin:{left:e,right:n,top:i,bottom:o}}=f(t),{width:s,height:l}=u(t);return{width:Math.ceil(s+e+n),height:Math.ceil(l+i+o)}},n.content_size=function(t){var e;const{left:n,top:i}=t.getBoundingClientRect(),{padding:o}=f(t);let s=0,l=0;for(const r of(null!==(e=t.shadowRoot)&&void 0!==e?e:t).children){const t=r.getBoundingClientRect();s=Math.max(s,Math.ceil(t.left-n-o.left+t.width)),l=Math.max(l,Math.ceil(t.top-i-o.top+t.height))}return{width:s,height:l}},n.bounding_box=function(t){const{x:e,y:n,width:i,height:o}=t.getBoundingClientRect();return new r.BBox({x:e,y:n,width:i,height:o})},n.position=function(t,e,n){const{style:i}=t;if(i.left=`${e.x}px`,i.top=`${e.y}px`,i.width=`${e.width}px`,i.height=`${e.height}px`,null==n)i.margin="";else{const{top:t,right:e,bottom:o,left:s}=n;i.margin=`${t}px ${e}px ${o}px ${s}px`}},n.children=function(t){return Array.from(t.children)};class p{constructor(t){this.class_list=t}get values(){const t=[];for(let e=0;e<this.class_list.length;e++){const n=this.class_list.item(e);null!=n&&t.push(n)}return t}has(t){return this.class_list.contains(t)}add(...t){for(const e of t)this.class_list.add(e);return this}remove(...t){for(const e of t)this.class_list.remove(e);return this}clear(){for(const t of this.values)this.class_list.remove(t);return this}toggle(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this}}var g;n.ClassList=p,p.__name__="ClassList",n.classes=function(t){return new p(t.classList)},n.toggle_attribute=function(t,e,n){null==n&&(n=!t.hasAttribute(e)),n?t.setAttribute(e,"true"):t.removeAttribute(e)},(g=n.Keys||(n.Keys={}))[g.Backspace=8]="Backspace",g[g.Tab=9]="Tab",g[g.Enter=13]="Enter",g[g.Esc=27]="Esc",g[g.Space=32]="Space",g[g.PageUp=33]="PageUp",g[g.PageDown=34]="PageDown",g[g.Left=37]="Left",g[g.Up=38]="Up",g[g.Right=39]="Right",g[g.Down=40]="Down",g[g.Delete=46]="Delete";class m{constructor(t){this.el=(0,n.style)({type:"text/css"},t)}clear(){this.replace("")}*_to_rules(t){for(const[e,n]of(0,l.entries)(t))if(null!=n){const t=e.replace(/_/g,"-");yield`${t}: ${n};`}}_to_css(t,e){return null==e?t:`${t}{${[...this._to_rules(e)].join("")}}`}replace(t,e){this.el.textContent=this._to_css(t,e)}prepend(t,e){var n;const i=null!==(n=this.el.textContent)&&void 0!==n?n:"";this.el.textContent=`${this._to_css(t,e)}\n${i}`}append(t,e){var n;const i=null!==(n=this.el.textContent)&&void 0!==n?n:"";this.el.textContent=`${i}\n${this._to_css(t,e)}`}remove(){d(this.el)}}n.StyleSheet=m,m.__name__="StyleSheet";class _ extends m{initialize(){this.el.isConnected||document.head.appendChild(this.el)}}n.GlobalStyleSheet=_,_.__name__="GlobalStyleSheet";class y{constructor(t){this.el=(0,n.link)({rel:"stylesheet",href:t})}replace(t){this.el.href=t}remove(){d(this.el)}}n.ImportedStyleSheet=y,y.__name__="ImportedStyleSheet";class b extends m{initialize(){this.el.isConnected||document.head.appendChild(this.el)}}n.GlobalImportedStyleSheet=b,b.__name__="GlobalImportedStyleSheet",n.dom_ready=async function(){if("loading"==document.readyState)return new Promise(((t,e)=>{document.addEventListener("DOMContentLoaded",(()=>t()),{once:!0})}))},n.px=function(t){return`${t}px`},n.supports_adopted_stylesheets="adoptedStyleSheets"in ShadowRoot.prototype},
function _(t,i,e,h,r){h();const s=t(23),n=t(25),{min:x,max:o}=Math;e.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},e.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},e.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},e.union=function(t,i){return{x0:x(t.x0,i.x0),x1:o(t.x1,i.x1),y0:x(t.y0,i.y0),y1:o(t.y1,i.y1)}};class y{constructor(t,i=!1){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){const{x0:i,y0:e,x1:h,y1:r}=t;if(!(i<=h&&e<=r))throw new Error(`invalid bbox {x0: ${i}, y0: ${e}, x1: ${h}, y1: ${r}}`);this.x0=i,this.y0=e,this.x1=h,this.y1=r}else if("x"in t){const{x:i,y:e,width:h,height:r}=t;if(!(h>=0&&r>=0))throw new Error(`invalid bbox {x: ${i}, y: ${e}, width: ${h}, height: ${r}}`);this.x0=i,this.y0=e,this.x1=i+h,this.y1=e+r}else{let e,h,r,s;if("width"in t)if("left"in t)e=t.left,h=e+t.width;else if("right"in t)h=t.right,e=h-t.width;else{const i=t.width/2;e=t.hcenter-i,h=t.hcenter+i}else e=t.left,h=t.right;if("height"in t)if("top"in t)r=t.top,s=r+t.height;else if("bottom"in t)s=t.bottom,r=s-t.height;else{const i=t.height/2;r=t.vcenter-i,s=t.vcenter+i}else r=t.top,s=t.bottom;if(e>h||r>s){if(!i)throw new Error(`invalid bbox {left: ${e}, top: ${r}, right: ${h}, bottom: ${s}}`);e>h&&(e=h),r>s&&(r=s)}this.x0=e,this.y0=r,this.x1=h,this.y1=s}}static from_lrtb({left:t,right:i,top:e,bottom:h}){return new y({x0:Math.min(t,i),y0:Math.min(e,h),x1:Math.max(t,i),y1:Math.max(e,h)})}clone(){return new y(this)}equals(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1}[n.equals](t,i){return i.eq(this.x0,t.x0)&&i.eq(this.y0,t.y0)&&i.eq(this.x1,t.x1)&&i.eq(this.y1,t.y1)}toString(){return`BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`}get is_empty(){const{x0:t,x1:i,y0:e,y1:h}=this;return 0==t&&0==i&&0==e&&0==h}get left(){return this.x0}get top(){return this.y0}get right(){return this.x1}get bottom(){return this.y1}get p0(){return[this.x0,this.y0]}get p1(){return[this.x1,this.y1]}get x(){return this.x0}get y(){return this.y0}get width(){return this.x1-this.x0}get height(){return this.y1-this.y0}get size(){return{width:this.width,height:this.height}}get rect(){const{x0:t,y0:i,x1:e,y1:h}=this;return{p0:{x:t,y:i},p1:{x:e,y:i},p2:{x:e,y:h},p3:{x:t,y:h}}}get box(){const{x:t,y:i,width:e,height:h}=this;return{x:t,y:i,width:e,height:h}}get lrtb(){const{left:t,right:i,top:e,bottom:h}=this;return{left:t,right:i,top:e,bottom:h}}get h_range(){return{start:this.x0,end:this.x1}}get v_range(){return{start:this.y0,end:this.y1}}get ranges(){return[this.h_range,this.v_range]}get aspect(){return this.width/this.height}get hcenter(){return(this.left+this.right)/2}get vcenter(){return(this.top+this.bottom)/2}get area(){return this.width*this.height}relative(){const{width:t,height:i}=this;return new y({x:0,y:0,width:t,height:i})}translate(t,i){const{x:e,y:h,width:r,height:s}=this;return new y({x:t+e,y:i+h,width:r,height:s})}relativize(t,i){return[t-this.x,i-this.y]}contains(t,i){return this.x0<=t&&t<=this.x1&&this.y0<=i&&i<=this.y1}clip(t,i){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),i<this.y0?i=this.y0:i>this.y1&&(i=this.y1),[t,i]}grow_by(t){return new y({left:this.left-t,right:this.right+t,top:this.top-t,bottom:this.bottom+t})}shrink_by(t){return new y({left:this.left+t,right:this.right-t,top:this.top+t,bottom:this.bottom-t},!0)}union(t){return new y({x0:x(this.x0,t.x0),y0:x(this.y0,t.y0),x1:o(this.x1,t.x1),y1:o(this.y1,t.y1)})}intersection(t){return this.intersects(t)?new y({x0:o(this.x0,t.x0),y0:o(this.y0,t.y0),x1:x(this.x1,t.x1),y1:x(this.y1,t.y1)}):null}intersects(t){return!(t.x1<this.x0||t.x0>this.x1||t.y1<this.y0||t.y0>this.y1)}get xview(){return{compute:t=>this.left+t,v_compute:t=>{const i=new s.ScreenArray(t.length),e=this.left;for(let h=0;h<t.length;h++)i[h]=e+t[h];return i}}}get yview(){return{compute:t=>this.bottom-t,v_compute:t=>{const i=new s.ScreenArray(t.length),e=this.bottom;for(let h=0;h<t.length;h++)i[h]=e-t[h];return i}}}}e.BBox=y,y.__name__="BBox"},
function _(i,o,e,n,t){n(),e.default=":host{--base-font:var(--bokeh-base-font, Helvetica, Arial, sans-serif);--mono-font:var(--bokeh-mono-font, monospace);--font-size:12px;--line-height:calc(20 / 14);--line-height-computed:calc(var(--font-size) * var(--line-height));--border-radius:4px;--padding-vertical:6px;--padding-horizontal:12px;}:host{box-sizing:border-box;font-family:var(--base-font);font-size:13px;line-height:var(--line-height);}*,*:before,*:after{box-sizing:inherit;font-family:inherit;}pre{font-family:var(--mono-font);margin:0;}"},
function _(e,n,t,o,s){o();const i=e(10),c=e(12);async function a(e,n,t){(0,c.assert)(null!=e,"model doesn't implement a view");const o=new e(Object.assign(Object.assign({},t),{model:n}));return o.initialize(),await o.lazy_initialize(),o}t.build_view=async function(e,n={parent:null},t=(e=>e.default_view)){const o=await a(t(e),e,n);return o.connect_signals(),o},t.build_views=async function(e,n,t={parent:null},o=(e=>e.default_view)){const s=(0,i.difference)([...e.keys()],n),c=[];for(const n of s){const t=e.get(n);null!=t&&(e.delete(n),c.push(t),t.remove())}const l=[],r=n.filter((n=>!e.has(n)));for(const n of r){const s=await a(o(n),n,t);e.set(n,s),l.push(s)}for(const e of l)e.connect_signals();return{created:l,removed:c}},t.remove_views=function(e){for(const[n,t]of e)t.remove(),e.delete(n)}},
function _(n,t,o,e,s){e();const a=n(60),c=n(18),r=n(52);o._get_ws_url=function(n,t){let o,e="ws:";return"https:"==window.location.protocol&&(e="wss:"),null!=t?(o=document.createElement("a"),o.href=t):o=window.location,null!=n?"/"==n&&(n=""):n=o.pathname.replace(/\/+$/,""),`${e}//${o.host}${n}/ws`};const i=new Map;o.add_document_from_session=async function(n,t,o,e=[],s=!1){const l=window.location.search.substr(1);let d;try{d=await function(n,t,o){const e=(0,a.parse_token)(t).session_id;i.has(n)||i.set(n,new Map);const s=i.get(n);return s.has(e)||s.set(e,(0,a.pull_session)(n,t,o)),s.get(e)}(n,t,l)}catch(n){const o=(0,a.parse_token)(t).session_id;throw c.logger.error(`Failed to load Bokeh session ${o}: ${n}`),n}return(0,r.add_document_standalone)(d.document,o,e,s)}},
function _(e,s,n,t,o){t();const r=e(18),i=e(5),c=e(61),l=e(62),_=e(63);n.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",n.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";let h=0;function a(e){let s=e.split(".")[0];const n=s.length%4;return 0!=n&&(s+="=".repeat(4-n)),JSON.parse(atob(s.replace(/_/g,"/").replace(/-/g,"+")))}n.parse_token=a;class d{constructor(e=n.DEFAULT_SERVER_WEBSOCKET_URL,s=n.DEFAULT_TOKEN,t=null){this.url=e,this.token=s,this.args_string=t,this._number=h++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new l.Receiver,this.id=a(s).session_id.split(".")[0],r.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`)}async connect(){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{let e=`${this.url}`;return null!=this.args_string&&this.args_string.length>0&&(e+=`?${this.args_string}`),this.socket=new WebSocket(e,["bokeh",this.token]),new Promise(((e,s)=>{this.socket.binaryType="arraybuffer",this.socket.onopen=()=>this._on_open(e,s),this.socket.onmessage=e=>this._on_message(e),this.socket.onclose=e=>this._on_close(e,s),this.socket.onerror=()=>this._on_error(s)}))}catch(e){throw r.logger.error(`websocket creation failed to url: ${this.url}`),r.logger.error(` - ${e}`),e}}close(){this.closed_permanently||(r.logger.debug(`Permanently closing websocket connection ${this._number}`),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,`close method called on ClientConnection ${this._number}`),this.session._connection_closed())}_schedule_reconnect(e){setTimeout((()=>{this.closed_permanently||r.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`)}),e)}send(e){null!=this.socket?e.send(this.socket):r.logger.error("not connected so cannot send",e)}async send_with_reply(e){const s=await new Promise(((s,n)=>{this._pending_replies.set(e.msgid(),{resolve:s,reject:n}),this.send(e)}));if("ERROR"==s.msgtype())throw new Error(`Error reply ${s.content.text}`);return s}async _pull_doc_json(){const e=c.Message.create("PULL-DOC-REQ",{},{}),s=await this.send_with_reply(e);if(!("doc"in s.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return s.content.doc}async _repull_session_doc(e,s){r.logger.debug(this.session?"Repulling session":"Pulling session for first time");try{const n=await this._pull_doc_json();if(null==this.session)if(this.closed_permanently)r.logger.debug("Got new document after connection was already closed"),s(new Error("The connection has been closed"));else{const s=[],t=i.Document.from_json(n,s);this.session=new _.ClientSession(this,t);for(const e of s)t._trigger_on_change(e);for(const e of this._pending_messages)this.session.handle(e);this._pending_messages=[],r.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(n),r.logger.debug("Updated existing session with new pulled doc")}catch(e){console.trace(e),r.logger.error(`Failed to repull session ${e}`),s(e instanceof Error?e:`${e}`)}}_on_open(e,s){r.logger.info(`Websocket connection ${this._number} is now open`),this._current_handler=n=>{this._awaiting_ack_handler(n,e,s)}}_on_message(e){null==this._current_handler&&r.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(`${e}`)}const s=this._receiver.message;if(null!=s){const e=s.problem();null!=e&&this._close_bad_protocol(e),this._current_handler(s)}}_on_close(e,s){r.logger.info(`Lost websocket ${this._number} connection, ${e.code} (${e.reason})`),this.socket=null,this._pending_replies.forEach((e=>e.reject("Disconnected"))),this._pending_replies.clear(),this.closed_permanently||this._schedule_reconnect(2e3),s(new Error(`Lost websocket connection, ${e.code} (${e.reason})`))}_on_error(e){r.logger.debug(`Websocket error on socket ${this._number}`);const s="Could not open websocket";r.logger.error(`Failed to connect to Bokeh server: ${s}`),e(new Error(s))}_close_bad_protocol(e){r.logger.error(`Closing connection: ${e}`),null!=this.socket&&this.socket.close(1002,e)}_awaiting_ack_handler(e,s,n){"ACK"===e.msgtype()?(this._current_handler=e=>this._steady_state_handler(e),this._repull_session_doc(s,n)):this._close_bad_protocol("First message was not an ACK")}_steady_state_handler(e){const s=e.reqid(),n=this._pending_replies.get(s);n?(this._pending_replies.delete(s),n.resolve(e)):this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)}}n.ClientConnection=d,d.__name__="ClientConnection",n.pull_session=function(e,s,n){return new d(e,s,n).connect()}},
function _(e,s,t,r,n){r();const i=e(30),a=e(38),h=e(12);class f{constructor(e,s,t){this.header=e,this.metadata=s,this.content=t,this._buffers=new Map}get buffers(){return this._buffers}static assemble(e,s,t){const r=JSON.parse(e),n=JSON.parse(s),i=JSON.parse(t);return new f(r,n,i)}assemble_buffer(e,s){var t;const r=null!==(t=this.header.num_buffers)&&void 0!==t?t:0;if(r<=this._buffers.size)throw new Error(`too many buffers received, expecting ${r}`);const{id:n}=JSON.parse(e);this._buffers.set(n,s)}static create(e,s,t){const r=f.create_header(e);return new f(r,s,t)}static create_header(e){return{msgid:(0,a.unique_id)(),msgtype:e}}complete(){const{num_buffers:e}=this.header;return null==e||this._buffers.size==e}send(e){(0,h.assert)(null==this.header.num_buffers);const s=[],t=JSON.stringify(this.content,((e,t)=>{if(t instanceof i.Buffer){const e={id:`${s.length}`};return s.push([e,t.buffer]),e}return t})),r=s.length;r>0&&(this.header.num_buffers=r);const n=JSON.stringify(this.header),a=JSON.stringify(this.metadata);e.send(n),e.send(a),e.send(t);for(const[t,r]of s)e.send(JSON.stringify(t)),e.send(r)}msgid(){return this.header.msgid}msgtype(){return this.header.msgtype}reqid(){return this.header.reqid}problem(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"}}t.Message=f,f.__name__="Message"},
function _(t,e,s,_,r){_();const i=t(61),h=t(8),a=t(12);class n{constructor(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}consume(t){this._current_consumer(t)}_HEADER(t){this._assume_text(t),this.message=null,this._partial=null,this._fragments=[t],this._buf_header=null,this._current_consumer=this._METADATA}_METADATA(t){this._assume_text(t),this._fragments.push(t),this._current_consumer=this._CONTENT}_CONTENT(t){this._assume_text(t),this._fragments.push(t);const[e,s,_]=this._fragments;(0,a.assert)(null!=e&&null!=s&&null!=_),this._partial=i.Message.assemble(e,s,_),this._check_complete()}_BUFFER_HEADER(t){this._assume_text(t),this._buf_header=t,this._current_consumer=this._BUFFER_PAYLOAD}_BUFFER_PAYLOAD(t){this._assume_binary(t),(0,a.assert)(null!=this._partial&&null!=this._buf_header),this._partial.assemble_buffer(this._buf_header,t),this._check_complete()}_assume_text(t){if(!(0,h.isString)(t))throw new Error("Expected text fragment but received binary fragment")}_assume_binary(t){if(!(t instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")}_check_complete(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER}}s.Receiver=n,n.__name__="Receiver"},
function _(e,n,t,o,s){o();const c=e(5),_=e(61),i=e(18);class r{constructor(e,n){this._connection=e,this.document=n,this._document_listener=e=>{this._document_changed(e)},this.document.on_change(this._document_listener,!0)}get id(){return this._connection.id}handle(e){const n=e.msgtype();switch(n){case"PATCH-DOC":this._handle_patch(e);break;case"OK":this._handle_ok(e);break;case"ERROR":this._handle_error(e);break;default:i.logger.debug(`Doing nothing with message '${n}'`)}}close(){this._connection.close()}_connection_closed(){this.document.remove_on_change(this._document_listener)}async request_server_info(){const e=_.Message.create("SERVER-INFO-REQ",{},{});return(await this._connection.send_with_reply(e)).content}async force_roundtrip(){await this.request_server_info()}_document_changed(e){const n=e instanceof c.DocumentEventBatch?e.events:[e],t=this.document.create_json_patch(n),o=_.Message.create("PATCH-DOC",{},t);this._connection.send(o)}_handle_patch(e){this.document.apply_json_patch(e.content,e.buffers)}_handle_ok(e){i.logger.trace(`Unhandled OK reply to ${e.reqid()}`)}_handle_error(e){i.logger.error(`Unhandled ERROR reply to ${e.reqid()}: ${e.content.text}`)}}t.ClientSession=r,r.__name__="ClientSession"},
function _(n,o,e,t,r){t();const i=n(55),l=n(8);function d(n){let o=(0,l.isString)(n)?document.getElementById(n):n;if(null==o)throw new Error(`Error rendering Bokeh model: could not find ${(0,l.isString)(n)?`#${n}`:n} HTML tag`);if(!document.body.contains(o))throw new Error(`Error rendering Bokeh model: element ${(0,l.isString)(n)?`#${n}`:n} must be under <body>`);if("SCRIPT"==o.tagName){const n=(0,i.div)();(0,i.replaceWith)(o,n),o=n}return o}e._resolve_element=function(n){const{elementid:o}=n;return null!=o?d(o):document.body},e._resolve_root_elements=function(n){const o=[];if(null!=n.root_ids&&null!=n.roots)for(const e of n.root_ids)o.push(d(n.roots[e]));return o}},
function _(e,o,t,n,r){n();const s=e(1),i=e(5),l=e(62),a=e(18),c=e(9),g=e(52),f=e(64);function u(e,o){o.buffers.length>0?e.consume(o.buffers[0].buffer):e.consume(o.content.data);const t=e.message;null!=t&&this.apply_json_patch(t.content,t.buffers)}function m(e,o){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){a.logger.info(`Registering Jupyter comms for target ${e}`);const t=Jupyter.notebook.kernel.comm_manager;try{t.register_target(e,(t=>{a.logger.info(`Registering Jupyter comms for target ${e}`);const n=new l.Receiver;t.on_msg(u.bind(o,n))}))}catch(e){a.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if(o.roots()[0].id in t.kernels){a.logger.info(`Registering JupyterLab comms for target ${e}`);const n=t.kernels[o.roots()[0].id];try{n.registerCommTarget(e,(t=>{a.logger.info(`Registering JupyterLab comms for target ${e}`);const n=new l.Receiver;t.onMsg=u.bind(o,n)}))}catch(e){a.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if("undefined"!=typeof google&&null!=google.colab.kernel){a.logger.info(`Registering Google Colab comms for target ${e}`);const t=google.colab.kernel.comms;try{t.registerTarget(e,(async t=>{var n,r,i;a.logger.info(`Registering Google Colab comms for target ${e}`);const c=new l.Receiver;try{for(var g,f=s.__asyncValues(t.messages);!(g=await f.next()).done;){const e=g.value,t={data:e.data},n=[];for(const o of null!==(i=e.buffers)&&void 0!==i?i:[])n.push(new DataView(o));const r={content:t,buffers:n};u.bind(o)(c,r)}}catch(e){n={error:e}}finally{try{g&&!g.done&&(r=f.return)&&await r.call(f)}finally{if(n)throw n.error}}}))}catch(e){a.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}t.kernels={},t.embed_items_notebook=function(e,o){if(1!=(0,c.size)(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");const t=i.Document.from_json((0,c.values)(e)[0]);for(const e of o){null!=e.notebook_comms_target&&m(e.notebook_comms_target,t);const o=(0,f._resolve_element)(e),n=(0,f._resolve_root_elements)(e);(0,g.add_document_standalone)(t,o,n),n[0].removeAttribute("id")}}},
function _(t,_,o,r,n){r();const a=t(1);a.__exportStar(t(61),o),a.__exportStar(t(62),o)},
function _(e,t,n,s,o){function l(){const e=document.getElementsByTagName("body")[0],t=document.getElementsByClassName("bokeh-test-div");1==t.length&&(e.removeChild(t[0]),delete t[0]);const n=document.createElement("div");n.classList.add("bokeh-test-div"),n.style.display="none",e.insertBefore(n,e.firstChild)}s(),n.results={},n.init=function(){l()},n.record0=function(e,t){n.results[e]=t},n.record=function(e,t){n.results[e]=t,l()},n.count=function(e){null==n.results[e]&&(n.results[e]=0),n.results[e]+=1,l()}},
function _(e,t,o,l,n){l(),o.safely=function(e,t=!1){try{return e()}catch(e){if(function(e){const t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");const o=document.createElement("span");o.style.backgroundColor="#a94442",o.style.borderRadius="0px 4px 0px 0px",o.style.color="white",o.style.cursor="pointer",o.style.cssFloat="right",o.style.fontSize="0.8em",o.style.margin="-6px -6px 0px 0px",o.style.padding="2px 5px 4px 5px",o.title="close",o.setAttribute("aria-label","close"),o.appendChild(document.createTextNode("x")),o.addEventListener("click",(()=>s.removeChild(t)));const l=document.createElement("h3");l.style.color="#a94442",l.style.margin="8px 0px 0px 0px",l.style.padding="0px",l.appendChild(document.createTextNode("Bokeh Error"));const n=document.createElement("pre");n.style.whiteSpace="unset",n.style.overflowX="auto",n.appendChild(document.createTextNode(e)),t.appendChild(o),t.appendChild(l),t.appendChild(n);const s=document.getElementsByTagName("body")[0];s.insertBefore(t,s.firstChild)}(e instanceof Error&&null!=e.stack?e.stack:`${e}`),t)return;throw e}}},
function _(t,r,o,_,e){_();const s=t(1),i=t(7),m=s.__importStar(t(70));(0,i.register_models)(m);const n=s.__importStar(t(482));(0,i.register_models)(n)},
function _(t,_,r,o,a){o();const e=t(1);e.__exportStar(t(71),r),e.__exportStar(t(157),r),e.__exportStar(t(278),r),e.__exportStar(t(283),r),e.__exportStar(t(288),r),e.__exportStar(t(289),r),e.__exportStar(t(298),r),e.__exportStar(t(218),r),e.__exportStar(t(307),r),e.__exportStar(t(340),r),e.__exportStar(t(341),r),e.__exportStar(t(345),r),e.__exportStar(t(347),r),e.__exportStar(t(233),r),e.__exportStar(t(366),r),e.__exportStar(t(372),r),e.__exportStar(t(373),r),e.__exportStar(t(381),r),e.__exportStar(t(393),r),e.__exportStar(t(224),r),e.__exportStar(t(394),r),e.__exportStar(t(222),r),e.__exportStar(t(397),r),e.__exportStar(t(398),r),e.__exportStar(t(404),r),e.__exportStar(t(191),r),e.__exportStar(t(409),r),e.__exportStar(t(419),r),e.__exportStar(t(423),r),e.__exportStar(t(438),r)},
function _(o,e,a,n,r){n();const t=o(1);r("Annotation",o(72).Annotation),r("Arrow",o(96).Arrow),r("ArrowHead",o(138).ArrowHead),r("OpenHead",o(138).OpenHead),r("NormalHead",o(138).NormalHead),r("TeeHead",o(138).TeeHead),r("VeeHead",o(138).VeeHead),r("BaseColorBar",o(140).BaseColorBar),r("Band",o(229).Band),r("BoxAnnotation",o(231).BoxAnnotation),r("ColorBar",o(232).ColorBar),r("ContourColorBar",o(241).ContourColorBar),r("Label",o(242).Label),r("LabelSet",o(243).LabelSet),r("Legend",o(244).Legend),r("LegendItem",o(245).LegendItem),r("PolyAnnotation",o(246).PolyAnnotation),r("Slope",o(247).Slope),r("Span",o(248).Span),r("TextAnnotation",o(142).TextAnnotation),r("Title",o(141).Title),r("ToolbarPanel",o(249).ToolbarPanel),r("Whisker",o(272).Whisker),t.__exportStar(o(273),a)},
function _(t,e,n,i,s){var o;i();const a=t(73);class l extends a.RendererView{get_size(){if(this.displayed){const{width:t,height:e}=this._get_size();return{width:Math.round(t),height:Math.round(e)}}return{width:0,height:0}}_get_size(){throw new Error("not implemented")}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.visible,(()=>{null!=this.layout&&(this.layout.visible=this.model.visible,this.plot_view.request_layout())}))}get needs_clip(){return null==this.layout}serializable_state(){const t=super.serializable_state();return null==this.layout?t:Object.assign(Object.assign({},t),{bbox:this.layout.bbox.box})}}n.AnnotationView=l,l.__name__="AnnotationView";class r extends a.Renderer{constructor(t){super(t)}}n.Annotation=r,o=r,r.__name__="Annotation",o.override({level:"annotation"})},
function _(e,t,i,n,s){n();const r=e(1);var o,a;const l=e(53),_=r.__importStar(e(74)),d=e(19),h=e(50),c=e(83);class u extends h.Model{constructor(e){super(e)}}i.RendererGroup=u,o=u,u.__name__="RendererGroup",o.define((({Boolean:e})=>({visible:[e,!0]})));class p extends l.View{get coordinates(){const{_coordinates:e}=this;return null!=e?e:this._coordinates=this._initialize_coordinates()}initialize(){super.initialize(),this.visuals=new _.Visuals(this),this.needs_webgl_blit=!1}connect_signals(){super.connect_signals();const{group:e}=this.model;null!=e&&this.on_change(e.properties.visible,(()=>{this.model.visible=e.visible}));const{x_range_name:t,y_range_name:i}=this.model.properties;this.on_change([t,i],(()=>delete this._coordinates)),this.connect(this.plot_view.frame.change,(()=>delete this._coordinates))}_initialize_coordinates(){const{coordinates:e}=this.model,{frame:t}=this.plot_view;if(null!=e)return e.get_transform(t);{const{x_range_name:e,y_range_name:i}=this.model,n=t.x_scales.get(e),s=t.y_scales.get(i);return new c.CoordinateTransform(n,s)}}get plot_view(){return this.parent}get plot_model(){return this.parent.model}get layer(){const{overlays:e,primary:t}=this.canvas;return"overlay"==this.model.level?e:t}get canvas(){return this.plot_view.canvas_view}request_render(){this.request_paint()}request_paint(){this.plot_view.request_paint(this)}request_layout(){this.plot_view.request_layout()}notify_finished(){this.plot_view.notify_finished()}notify_finished_after_paint(){this.plot_view.notify_finished_after_paint()}get needs_clip(){return!1}get has_webgl(){return!1}get displayed(){return this.model.visible}render(){this.displayed&&this._render(),this._has_finished=!0}renderer_view(e){}}i.RendererView=p,p.__name__="RendererView";class g extends h.Model{constructor(e){super(e)}}i.Renderer=g,a=g,g.__name__="Renderer",a.define((({Boolean:e,String:t,Ref:i,Nullable:n})=>({group:[n(i(u)),null],level:[d.RenderLevel,"image"],visible:[e,!0],x_range_name:[t,"default"],y_range_name:[t,"default"],coordinates:[n(i(c.CoordinateMapping)),null]})))},
function _(e,a,r,t,c){t();const n=e(1),l=e(75);c("Line",l.Line),c("LineScalar",l.LineScalar),c("LineVector",l.LineVector);const s=e(78);c("Fill",s.Fill),c("FillScalar",s.FillScalar),c("FillVector",s.FillVector);const i=e(79);c("Text",i.Text),c("TextScalar",i.TextScalar),c("TextVector",i.TextVector);const o=e(80);c("Hatch",o.Hatch),c("HatchScalar",o.HatchScalar),c("HatchVector",o.HatchVector);const u=e(82);c("Image",u.Image),c("ImageScalar",u.ImageScalar),c("ImageVector",u.ImageVector);const V=n.__importStar(e(77)),S=e(76);c("VisualProperties",S.VisualProperties),c("VisualUniforms",S.VisualUniforms);class m{constructor(e){this._visuals=[];for(const[a,r]of e.model._mixins){const t=(()=>{switch(r){case V.Line:return new l.Line(e,a);case V.LineScalar:return new l.LineScalar(e,a);case V.LineVector:return new l.LineVector(e,a);case V.Fill:return new s.Fill(e,a);case V.FillScalar:return new s.FillScalar(e,a);case V.FillVector:return new s.FillVector(e,a);case V.Text:return new i.Text(e,a);case V.TextScalar:return new i.TextScalar(e,a);case V.TextVector:return new i.TextVector(e,a);case V.Hatch:return new o.Hatch(e,a);case V.HatchScalar:return new o.HatchScalar(e,a);case V.HatchVector:return new o.HatchVector(e,a);case V.Image:return new u.Image(e,a);case V.ImageScalar:return new u.ImageScalar(e,a);case V.ImageVector:return new u.ImageVector(e,a);default:throw new Error("unknown visual")}})();t instanceof S.VisualProperties&&t.update(),this._visuals.push(t),Object.defineProperty(this,a+t.type,{get:()=>t,configurable:!1,enumerable:!0})}}*[Symbol.iterator](){yield*this._visuals}}r.Visuals=m,m.__name__="Visuals"},
function _(e,t,i,l,s){l();const a=e(1),n=e(76),h=a.__importStar(e(77)),o=e(21),_=e(8);function r(e){if((0,_.isArray)(e))return e;switch(e){case"solid":return[];case"dashed":return[6];case"dotted":return[2,4];case"dotdash":return[2,4,6,4];case"dashdot":return[6,4,2,4];default:return e.split(" ").map(Number).filter(_.isInteger)}}i.resolve_line_dash=r;class u extends n.VisualProperties{get doit(){const e=this.line_color.get_value(),t=this.line_alpha.get_value(),i=this.line_width.get_value();return!(null==e||0==t||0==i)}apply(e){const{doit:t}=this;return t&&(this.set_value(e),e.stroke()),t}values(){return{color:this.line_color.get_value(),alpha:this.line_alpha.get_value(),width:this.line_width.get_value(),join:this.line_join.get_value(),cap:this.line_cap.get_value(),dash:this.line_dash.get_value(),offset:this.line_dash_offset.get_value()}}set_value(e){const t=this.line_color.get_value(),i=this.line_alpha.get_value();e.strokeStyle=(0,o.color2css)(t,i),e.lineWidth=this.line_width.get_value(),e.lineJoin=this.line_join.get_value(),e.lineCap=this.line_cap.get_value(),e.lineDash=r(this.line_dash.get_value()),e.lineDashOffset=this.line_dash_offset.get_value()}}i.Line=u,u.__name__="Line";class c extends n.VisualUniforms{get doit(){const e=this.line_color.value,t=this.line_alpha.value,i=this.line_width.value;return!(0==e||0==t||0==i)}apply(e){const{doit:t}=this;return t&&(this.set_value(e),e.stroke()),t}values(){return{color:this.line_color.value,alpha:this.line_alpha.value,width:this.line_width.value,join:this.line_join.value,cap:this.line_cap.value,dash:this.line_dash.value,offset:this.line_dash_offset.value}}set_value(e){const t=this.line_color.value,i=this.line_alpha.value;e.strokeStyle=(0,o.color2css)(t,i),e.lineWidth=this.line_width.value,e.lineJoin=this.line_join.value,e.lineCap=this.line_cap.value,e.lineDash=r(this.line_dash.value),e.lineDashOffset=this.line_dash_offset.value}}i.LineScalar=c,c.__name__="LineScalar";class d extends n.VisualUniforms{get doit(){const{line_color:e}=this;if(e.is_Scalar()&&0==e.value)return!1;const{line_alpha:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{line_width:i}=this;return!i.is_Scalar()||0!=i.value}v_doit(e){return 0!=this.line_color.get(e)&&(0!=this.line_alpha.get(e)&&0!=this.line_width.get(e))}apply(e,t){const i=this.v_doit(t);return i&&(this.set_vectorize(e,t),e.stroke()),i}values(e){return{color:this.line_color.get(e),alpha:this.line_alpha.get(e),width:this.line_width.get(e),join:this.line_join.get(e),cap:this.line_cap.get(e),dash:this.line_dash.get(e),offset:this.line_dash_offset.get(e)}}set_vectorize(e,t){const i=this.line_color.get(t),l=this.line_alpha.get(t),s=this.line_width.get(t),a=this.line_join.get(t),n=this.line_cap.get(t),h=this.line_dash.get(t),_=this.line_dash_offset.get(t);e.strokeStyle=(0,o.color2css)(i,l),e.lineWidth=s,e.lineJoin=a,e.lineCap=n,e.lineDash=r(h),e.lineDashOffset=_}}i.LineVector=d,d.__name__="LineVector",u.prototype.type="line",u.prototype.attrs=Object.keys(h.Line),c.prototype.type="line",c.prototype.attrs=Object.keys(h.LineScalar),d.prototype.type="line",d.prototype.attrs=Object.keys(h.LineVector)},
function _(t,s,o,i,r){i();class e{constructor(t,s=""){this.obj=t,this.prefix=s;const o=this;this._props=[];for(const i of this.attrs){const r=t.model.properties[s+i];r.change.connect((()=>this.update())),o[i]=r,this._props.push(r)}}*[Symbol.iterator](){yield*this._props}update(){}}o.VisualProperties=e,e.__name__="VisualProperties";class p{constructor(t,s=""){this.obj=t,this.prefix=s;for(const o of this.attrs)Object.defineProperty(this,o,{get:()=>t[s+o]})}*[Symbol.iterator](){for(const t of this.attrs)yield this.obj.model.properties[this.prefix+t]}update(){}}o.VisualUniforms=p,p.__name__="VisualUniforms"},
function _(l,e,a,t,r){t();const c=l(1),o=c.__importStar(l(17)),n=l(19),_=c.__importStar(l(20)),i=l(9);a.Line={line_color:[_.Nullable(_.Color),"black"],line_alpha:[_.Alpha,1],line_width:[_.Number,1],line_join:[n.LineJoin,"bevel"],line_cap:[n.LineCap,"butt"],line_dash:[_.Or(n.LineDash,_.Array(_.Number)),[]],line_dash_offset:[_.Number,0]},a.Fill={fill_color:[_.Nullable(_.Color),"gray"],fill_alpha:[_.Alpha,1]},a.Image={global_alpha:[_.Alpha,1]},a.Hatch={hatch_color:[_.Nullable(_.Color),"black"],hatch_alpha:[_.Alpha,1],hatch_scale:[_.Number,12],hatch_pattern:[_.Nullable(_.Or(n.HatchPatternType,_.String)),null],hatch_weight:[_.Number,1],hatch_extra:[_.Dict(_.AnyRef()),{}]},a.Text={text_color:[_.Nullable(_.Color),"#444444"],text_outline_color:[_.Nullable(_.Color),null],text_alpha:[_.Alpha,1],text_font:[o.Font,"helvetica"],text_font_size:[_.FontSize,"16px"],text_font_style:[n.FontStyle,"normal"],text_align:[n.TextAlign,"left"],text_baseline:[n.TextBaseline,"bottom"],text_line_height:[_.Number,1.2]},a.LineScalar={line_color:[o.ColorScalar,"black"],line_alpha:[o.NumberScalar,1],line_width:[o.NumberScalar,1],line_join:[o.LineJoinScalar,"bevel"],line_cap:[o.LineCapScalar,"butt"],line_dash:[o.LineDashScalar,[]],line_dash_offset:[o.NumberScalar,0]},a.FillScalar={fill_color:[o.ColorScalar,"gray"],fill_alpha:[o.NumberScalar,1]},a.ImageScalar={global_alpha:[o.NumberScalar,1]},a.HatchScalar={hatch_color:[o.ColorScalar,"black"],hatch_alpha:[o.NumberScalar,1],hatch_scale:[o.NumberScalar,12],hatch_pattern:[o.NullStringScalar,null],hatch_weight:[o.NumberScalar,1],hatch_extra:[o.AnyScalar,{}]},a.TextScalar={text_color:[o.ColorScalar,"#444444"],text_outline_color:[o.ColorScalar,null],text_alpha:[o.NumberScalar,1],text_font:[o.FontScalar,"helvetica"],text_font_size:[o.FontSizeScalar,"16px"],text_font_style:[o.FontStyleScalar,"normal"],text_align:[o.TextAlignScalar,"left"],text_baseline:[o.TextBaselineScalar,"bottom"],text_line_height:[o.NumberScalar,1.2]},a.LineVector={line_color:[o.ColorSpec,"black"],line_alpha:[o.NumberSpec,1],line_width:[o.NumberSpec,1],line_join:[o.LineJoinSpec,"bevel"],line_cap:[o.LineCapSpec,"butt"],line_dash:[o.LineDashSpec,[]],line_dash_offset:[o.NumberSpec,0]},a.FillVector={fill_color:[o.ColorSpec,"gray"],fill_alpha:[o.NumberSpec,1]},a.ImageVector={global_alpha:[o.NumberSpec,1]},a.HatchVector={hatch_color:[o.ColorSpec,"black"],hatch_alpha:[o.NumberSpec,1],hatch_scale:[o.NumberSpec,12],hatch_pattern:[o.NullStringSpec,null],hatch_weight:[o.NumberSpec,1],hatch_extra:[o.AnyScalar,{}]},a.TextVector={text_color:[o.ColorSpec,"#444444"],text_outline_color:[o.ColorSpec,null],text_alpha:[o.NumberSpec,1],text_font:[o.FontSpec,"helvetica"],text_font_size:[o.FontSizeSpec,"16px"],text_font_style:[o.FontStyleSpec,"normal"],text_align:[o.TextAlignSpec,"left"],text_baseline:[o.TextBaselineSpec,"bottom"],text_line_height:[o.NumberSpec,1.2]},a.attrs_of=function(l,e,a,t=!1){const r={};for(const c of(0,i.keys)(a)){const a=`${e}${c}`,o=l[a];r[t?a:c]=o}return r}},
function _(l,t,e,i,s){i();const a=l(1),o=l(76),r=a.__importStar(l(77)),_=l(21);class c extends o.VisualProperties{get doit(){const l=this.fill_color.get_value(),t=this.fill_alpha.get_value();return!(null==l||0==t)}apply(l,t){const{doit:e}=this;return e&&(this.set_value(l),l.fill(t)),e}values(){return{color:this.fill_color.get_value(),alpha:this.fill_alpha.get_value()}}set_value(l){const t=this.fill_color.get_value(),e=this.fill_alpha.get_value();l.fillStyle=(0,_.color2css)(t,e)}}e.Fill=c,c.__name__="Fill";class h extends o.VisualUniforms{get doit(){const l=this.fill_color.value,t=this.fill_alpha.value;return!(0==l||0==t)}apply(l,t){const{doit:e}=this;return e&&(this.set_value(l),l.fill(t)),e}values(){return{color:this.fill_color.value,alpha:this.fill_alpha.value}}set_value(l){const t=this.fill_color.value,e=this.fill_alpha.value;l.fillStyle=(0,_.color2css)(t,e)}}e.FillScalar=h,h.__name__="FillScalar";class u extends o.VisualUniforms{get doit(){const{fill_color:l}=this;if(l.is_Scalar()&&0==l.value)return!1;const{fill_alpha:t}=this;return!t.is_Scalar()||0!=t.value}v_doit(l){return 0!=this.fill_color.get(l)&&0!=this.fill_alpha.get(l)}apply(l,t,e){const i=this.v_doit(t);return i&&(this.set_vectorize(l,t),l.fill(e)),i}values(l){return{color:this.fill_color.get(l),alpha:this.fill_alpha.get(l)}}set_vectorize(l,t){const e=this.fill_color.get(t),i=this.fill_alpha.get(t);l.fillStyle=(0,_.color2css)(e,i)}}e.FillVector=u,u.__name__="FillVector",c.prototype.type="fill",c.prototype.attrs=Object.keys(r.Fill),h.prototype.type="fill",h.prototype.attrs=Object.keys(r.FillScalar),u.prototype.type="fill",u.prototype.attrs=Object.keys(r.FillVector)},
function _(t,e,l,s,o){s();const i=t(1),_=t(76),a=i.__importStar(t(77)),n=t(21),h=new Map;function r(t,e){const l=h.get(t);if(null==l){const l=new WeakSet([e]);h.set(t,l)}else{if(l.has(e))return;l.add(e)}const{fonts:s}=document;s.check(t)||s.load(t).then((()=>e.request_render()))}class u extends _.VisualProperties{get doit(){const t=this.text_color.get_value(),e=this.text_alpha.get_value();return!(null==t||0==e)}update(){if(!this.doit)return;r(this.font_value(),this.obj)}values(){return{color:this.text_color.get_value(),outline_color:this.text_outline_color.get_value(),alpha:this.text_alpha.get_value(),font:this.text_font.get_value(),font_size:this.text_font_size.get_value(),font_style:this.text_font_style.get_value(),align:this.text_align.get_value(),baseline:this.text_baseline.get_value(),line_height:this.text_line_height.get_value()}}set_value(t){const e=this.text_color.get_value(),l=this.text_outline_color.get_value(),s=this.text_alpha.get_value();t.fillStyle=(0,n.color2css)(e,s),t.strokeStyle=(0,n.color2css)(l,s),t.font=this.font_value(),t.textAlign=this.text_align.get_value(),t.textBaseline=this.text_baseline.get_value()}font_value(){return`${this.text_font_style.get_value()} ${this.text_font_size.get_value()} ${this.text_font.get_value()}`}}l.Text=u,u.__name__="Text";class x extends _.VisualUniforms{get doit(){const t=this.text_color.value,e=this.text_alpha.value;return!(0==t||0==e)}update(){if(!this.doit)return;r(this.font_value(),this.obj)}values(){return{color:this.text_color.value,outline_color:this.text_outline_color.value,alpha:this.text_alpha.value,font:this.text_font.value,font_size:this.text_font_size.value,font_style:this.text_font_style.value,align:this.text_align.value,baseline:this.text_baseline.value,line_height:this.text_line_height.value}}set_value(t){const e=this.text_color.value,l=this.text_alpha.value,s=this.text_outline_color.value,o=this.font_value(),i=this.text_align.value,_=this.text_baseline.value;t.fillStyle=(0,n.color2css)(e,l),t.strokeStyle=(0,n.color2css)(s,l),t.font=o,t.textAlign=i,t.textBaseline=_}font_value(){return`${this.text_font_style.value} ${this.text_font_size.value} ${this.text_font.value}`}}l.TextScalar=x,x.__name__="TextScalar";class c extends _.VisualUniforms{_assert_font(t){r(this.font_value(t),this.obj)}values(t){return this._assert_font(t),{color:this.text_color.get(t),outline_color:this.text_outline_color.get(t),alpha:this.text_alpha.get(t),font:this.text_font.get(t),font_size:this.text_font_size.get(t),font_style:this.text_font_style.get(t),align:this.text_align.get(t),baseline:this.text_baseline.get(t),line_height:this.text_line_height.get(t)}}get doit(){const{text_color:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{text_alpha:e}=this;return!e.is_Scalar()||0!=e.value}v_doit(t){return 0!=this.text_color.get(t)&&0!=this.text_alpha.get(t)}apply(t,e){const l=this.v_doit(e);return l&&this.set_vectorize(t,e),l}set_vectorize(t,e){this._assert_font(e);const l=this.text_color.get(e),s=this.text_outline_color.get(e),o=this.text_alpha.get(e),i=this.font_value(e),_=this.text_align.get(e),a=this.text_baseline.get(e);t.fillStyle=(0,n.color2css)(l,o),t.strokeStyle=(0,n.color2css)(s,o),t.font=i,t.textAlign=_,t.textBaseline=a}font_value(t){return`${this.text_font_style.get(t)} ${this.text_font_size.get(t)} ${this.text_font.get(t)}`}}l.TextVector=c,c.__name__="TextVector",u.prototype.type="text",u.prototype.attrs=Object.keys(a.Text),x.prototype.type="text",x.prototype.attrs=Object.keys(a.TextScalar),c.prototype.type="text",c.prototype.attrs=Object.keys(a.TextVector)},
function _(t,e,a,r,h){r();const i=t(1),s=t(76),n=t(81),c=i.__importStar(t(17)),_=i.__importStar(t(77));class l extends s.VisualProperties{constructor(){super(...arguments),this._update_iteration=0}update(){if(this._update_iteration++,this._hatch_image=null,!this.doit)return;const t=this.hatch_color.get_value(),e=this.hatch_alpha.get_value(),a=this.hatch_scale.get_value(),r=this.hatch_pattern.get_value(),h=this.hatch_weight.get_value(),i=t=>{this._hatch_image=t},s=this.hatch_extra.get_value()[r];if(null!=s){const r=s.get_pattern(t,e,a,h);if(r instanceof Promise){const{_update_iteration:t}=this;r.then((e=>{this._update_iteration==t&&(i(e),this.obj.request_render())}))}else i(r)}else{const s=this.obj.canvas.create_layer(),c=(0,n.get_pattern)(s,r,t,e,a,h);i(c)}}get doit(){const t=this.hatch_color.get_value(),e=this.hatch_alpha.get_value(),a=this.hatch_pattern.get_value();return!(null==t||0==e||" "==a||"blank"==a||null==a)}apply(t,e){const{doit:a}=this;return a&&(this.set_value(t),t.layer.undo_transform((()=>t.fill(e)))),a}set_value(t){const e=this.pattern(t);t.fillStyle=null!=e?e:"transparent"}pattern(t){const e=this._hatch_image;return null==e?null:t.createPattern(e,this.repetition())}repetition(){const t=this.hatch_pattern.get_value(),e=this.hatch_extra.get_value()[t];if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}}a.Hatch=l,l.__name__="Hatch";class o extends s.VisualUniforms{constructor(){super(...arguments),this._static_doit=!1,this._update_iteration=0}_compute_static_doit(){const t=this.hatch_color.value,e=this.hatch_alpha.value,a=this.hatch_pattern.value;return!(null==t||0==e||" "==a||"blank"==a||null==a)}update(){this._update_iteration++;const t=this.hatch_color.length;if(this._hatch_image=new c.UniformScalar(null,t),this._static_doit=this._compute_static_doit(),!this._static_doit)return;const e=this.hatch_color.value,a=this.hatch_alpha.value,r=this.hatch_scale.value,h=this.hatch_pattern.value,i=this.hatch_weight.value,s=e=>{this._hatch_image=new c.UniformScalar(e,t)},_=this.hatch_extra.value[h];if(null!=_){const t=_.get_pattern(e,a,r,i);if(t instanceof Promise){const{_update_iteration:e}=this;t.then((t=>{this._update_iteration==e&&(s(t),this.obj.request_render())}))}else s(t)}else{const t=this.obj.canvas.create_layer(),c=(0,n.get_pattern)(t,h,e,a,r,i);s(c)}}get doit(){return this._static_doit}apply(t,e){const{doit:a}=this;return a&&(this.set_value(t),t.layer.undo_transform((()=>t.fill(e)))),a}set_value(t){var e;t.fillStyle=null!==(e=this.pattern(t))&&void 0!==e?e:"transparent"}pattern(t){const e=this._hatch_image.value;return null==e?null:t.createPattern(e,this.repetition())}repetition(){const t=this.hatch_pattern.value,e=this.hatch_extra.value[t];if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}}a.HatchScalar=o,o.__name__="HatchScalar";class u extends s.VisualUniforms{constructor(){super(...arguments),this._static_doit=!1,this._update_iteration=0}_compute_static_doit(){const{hatch_color:t}=this;if(t.is_Scalar()&&0==t.value)return!1;const{hatch_alpha:e}=this;if(e.is_Scalar()&&0==e.value)return!1;const{hatch_pattern:a}=this;if(a.is_Scalar()){const t=a.value;if(" "==t||"blank"==t||null==t)return!1}return!0}update(){this._update_iteration++;const t=this.hatch_color.length;if(this._hatch_image=new c.UniformScalar(null,t),this._static_doit=this._compute_static_doit(),!this._static_doit)return;const e=(t,e,a,r,h,i)=>{const s=this.hatch_extra.value[t];if(null!=s){const t=s.get_pattern(e,a,r,h);if(t instanceof Promise){const{_update_iteration:e}=this;t.then((t=>{this._update_iteration==e&&(i(t),this.obj.request_render())}))}else i(t)}else{const s=this.obj.canvas.create_layer(),c=(0,n.get_pattern)(s,t,e,a,r,h);i(c)}};if(this.hatch_color.is_Scalar()&&this.hatch_alpha.is_Scalar()&&this.hatch_scale.is_Scalar()&&this.hatch_pattern.is_Scalar()&&this.hatch_weight.is_Scalar()){const a=this.hatch_color.value,r=this.hatch_alpha.value,h=this.hatch_scale.value;e(this.hatch_pattern.value,a,r,h,this.hatch_weight.value,(e=>{this._hatch_image=new c.UniformScalar(e,t)}))}else{const a=new Array(t);a.fill(null),this._hatch_image=new c.UniformVector(a);for(let r=0;r<t;r++){const t=this.hatch_color.get(r),h=this.hatch_alpha.get(r),i=this.hatch_scale.get(r);e(this.hatch_pattern.get(r),t,h,i,this.hatch_weight.get(r),(t=>{a[r]=t}))}}}get doit(){return this._static_doit}v_doit(t){if(!this.doit)return!1;if(0==this.hatch_color.get(t))return!1;if(0==this.hatch_alpha.get(t))return!1;const e=this.hatch_pattern.get(t);return" "!=e&&"blank"!=e&&null!=e}apply(t,e,a){const r=this.v_doit(e);return r&&(this.set_vectorize(t,e),t.layer.undo_transform((()=>t.fill(a)))),r}set_vectorize(t,e){var a;t.fillStyle=null!==(a=this.pattern(t,e))&&void 0!==a?a:"transparent"}pattern(t,e){const a=this._hatch_image.get(e);return null==a?null:t.createPattern(a,this.repetition(e))}repetition(t){const e=this.hatch_pattern.get(t),a=this.hatch_extra.value[e];if(null==a)return"repeat";switch(a.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}}}a.HatchVector=u,u.__name__="HatchVector",l.prototype.type="hatch",l.prototype.attrs=Object.keys(_.Hatch),o.prototype.type="hatch",o.prototype.attrs=Object.keys(_.HatchScalar),u.prototype.type="hatch",u.prototype.attrs=Object.keys(_.HatchVector)},
function _(e,o,a,s,r){s();const i=e(21);function l(e,o,a){e.moveTo(0,a+.5),e.lineTo(o,a+.5),e.stroke()}function n(e,o,a){e.moveTo(a+.5,0),e.lineTo(a+.5,o),e.stroke()}function t(e,o){e.moveTo(0,o),e.lineTo(o,0),e.stroke(),e.moveTo(0,0),e.lineTo(o,o),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"},a.get_pattern=function(e,o,s,r,c,k){return e.resize(c,c),e.prepare(),function(e,o,s,r,c,k){var _;const T=c,v=T/2,h=v/2,d=(0,i.color2css)(s,r);switch(e.strokeStyle=d,e.fillStyle=d,e.lineCap="square",e.lineWidth=k,null!==(_=a.hatch_aliases[o])&&void 0!==_?_:o){case"blank":break;case"dot":e.arc(v,v,v/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(v,v,v/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":l(e,T,v);break;case"vertical_line":n(e,T,v);break;case"cross":l(e,T,v),n(e,T,v);break;case"horizontal_dash":l(e,v,v);break;case"vertical_dash":n(e,v,v);break;case"spiral":{const o=T/30;e.moveTo(v,v);for(let a=0;a<360;a++){const s=.1*a,r=v+o*s*Math.cos(s),i=v+o*s*Math.sin(s);e.lineTo(r,i)}e.stroke();break}case"right_diagonal_line":e.moveTo(.5-h,T),e.lineTo(h+.5,0),e.stroke(),e.moveTo(h+.5,T),e.lineTo(3*h+.5,0),e.stroke(),e.moveTo(3*h+.5,T),e.lineTo(5*h+.5,0),e.stroke(),e.stroke();break;case"left_diagonal_line":e.moveTo(h+.5,T),e.lineTo(.5-h,0),e.stroke(),e.moveTo(3*h+.5,T),e.lineTo(h+.5,0),e.stroke(),e.moveTo(5*h+.5,T),e.lineTo(3*h+.5,0),e.stroke(),e.stroke();break;case"diagonal_cross":t(e,T);break;case"right_diagonal_dash":e.moveTo(h+.5,3*h+.5),e.lineTo(3*h+.5,h+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(h+.5,h+.5),e.lineTo(3*h+.5,3*h+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,h),e.lineTo(v,3*h),e.lineTo(T,h),e.stroke();break;case"vertical_wave":e.moveTo(h,0),e.lineTo(3*h,v),e.lineTo(h,T),e.stroke();break;case"criss_cross":t(e,T),l(e,T,v),n(e,T,v)}}(e.ctx,o,s,r,c,k),e.canvas}},
function _(a,t,e,l,s){l();const o=a(1),r=a(76),p=o.__importStar(a(77));class _ extends r.VisualProperties{get doit(){return!(0==this.global_alpha.get_value())}apply(a){const{doit:t}=this;return t&&this.set_value(a),t}values(){return{global_alpha:this.global_alpha.get_value()}}set_value(a){const t=this.global_alpha.get_value();a.globalAlpha=t}}e.Image=_,_.__name__="Image";class i extends r.VisualUniforms{get doit(){return!(0==this.global_alpha.value)}apply(a){const{doit:t}=this;return t&&this.set_value(a),t}values(){return{global_alpha:this.global_alpha.value}}set_value(a){const t=this.global_alpha.value;a.globalAlpha=t}}e.ImageScalar=i,i.__name__="ImageScalar";class g extends r.VisualUniforms{get doit(){const{global_alpha:a}=this;return!a.is_Scalar()||0!=a.value}v_doit(a){return 0!=this.global_alpha.get(a)}apply(a,t){const e=this.v_doit(t);return e&&this.set_vectorize(a,t),e}values(a){return{alpha:this.global_alpha.get(a)}}set_vectorize(a,t){const e=this.global_alpha.get(t);a.globalAlpha=e}}e.ImageVector=g,g.__name__="ImageVector",_.prototype.type="image",_.prototype.attrs=Object.keys(p.Image),i.prototype.type="image",i.prototype.attrs=Object.keys(p.ImageScalar),g.prototype.type="image",g.prototype.attrs=Object.keys(p.ImageVector)},
function _(e,t,s,a,r){var c,n;a();const _=e(13),o=e(50),i=e(84),l=e(88),u=e(90),g=e(91),h=e(86),p=e(92),m=e(95);class x{constructor(e,t){this.x_scale=e,this.y_scale=t,this.x_source=this.x_scale.source_range,this.y_source=this.y_scale.source_range,this.ranges=[this.x_source,this.y_source],this.scales=[this.x_scale,this.y_scale]}map_to_screen(e,t){return[this.x_scale.v_compute(e),this.y_scale.v_compute(t)]}map_from_screen(e,t){return[this.x_scale.v_invert(e),this.y_scale.v_invert(t)]}}s.CoordinateTransform=x,x.__name__="CoordinateTransform";class y extends o.Model{constructor(e){super(e)}get x_ranges(){return new Map([["default",this.x_source]])}get y_ranges(){return new Map([["default",this.y_source]])}_get_scale(e,t,s){if(e instanceof m.FactorRange!=t instanceof g.CategoricalScale)throw new Error(`Range ${e.type} is incompatible is Scale ${t.type}`);t instanceof u.LogScale&&e instanceof p.DataRange1d&&(e.scale_hint="log");const a=t.clone();return a.setv({source_range:e,target_range:s}),a}get_transform(e){const{x_source:t,x_scale:s,x_target:a}=this,r=this._get_scale(t,s,a),{y_source:c,y_scale:n,y_target:_}=this,o=this._get_scale(c,n,_),i=new v({source_scale:r,source_range:r.source_range,target_scale:e.x_scale,target_range:e.x_target}),l=new v({source_scale:o,source_range:o.source_range,target_scale:e.y_scale,target_range:e.y_target});return new x(i,l)}}s.CoordinateMapping=y,c=y,y.__name__="CoordinateMapping",c.define((({Ref:e})=>({x_source:[e(h.Range),()=>new p.DataRange1d],y_source:[e(h.Range),()=>new p.DataRange1d],x_scale:[e(i.Scale),()=>new l.LinearScale],y_scale:[e(i.Scale),()=>new l.LinearScale],x_target:[e(h.Range)],y_target:[e(h.Range)]})));class v extends i.Scale{constructor(e){super(e)}get s_compute(){const e=this.source_scale.s_compute,t=this.target_scale.s_compute;return s=>t(e(s))}get s_invert(){const e=this.source_scale.s_invert,t=this.target_scale.s_invert;return s=>e(t(s))}compute(e){return this.s_compute(e)}v_compute(e){const{s_compute:t}=this;return(0,_.map)(e,t)}invert(e){return this.s_invert(e)}v_invert(e){const{s_invert:t}=this;return(0,_.map)(e,t)}}s.CompositeScale=v,n=v,v.__name__="CompositeScale",n.internal((({Ref:e})=>({source_scale:[e(i.Scale)],target_scale:[e(i.Scale)]})))},
function _(e,t,r,n,s){var _;n();const a=e(85),c=e(86),o=e(87),i=e(23);class u extends a.Transform{constructor(e){super(e)}compute(e){return this.s_compute(e)}v_compute(e){const t=new i.ScreenArray(e.length),{s_compute:r}=this;for(let n=0;n<e.length;n++)t[n]=r(e[n]);return t}invert(e){return this.s_invert(e)}v_invert(e){const t=new Float64Array(e.length),{s_invert:r}=this;for(let n=0;n<e.length;n++)t[n]=r(e[n]);return t}r_compute(e,t){const{s_compute:r}=this;return this.target_range.is_reversed?[r(t),r(e)]:[r(e),r(t)]}r_invert(e,t){const{s_invert:r}=this;return this.target_range.is_reversed?[r(t),r(e)]:[r(e),r(t)]}}r.Scale=u,_=u,u.__name__="Scale",_.internal((({Ref:e})=>({source_range:[e(c.Range)],target_range:[e(o.Range1d)]})))},
function _(n,s,o,r,c){r();const e=n(50);class t extends e.Model{constructor(n){super(n)}}o.Transform=t,t.__name__="Transform"},
function _(e,t,n,i,s){var a;i();const r=e(50);class l extends r.Model{constructor(e){super(e),this.have_updated_interactively=!1}get is_reversed(){return this.start>this.end}get is_valid(){return isFinite(this.min)&&isFinite(this.max)}get span(){return Math.abs(this.end-this.start)}}n.Range=l,a=l,l.__name__="Range",a.define((({Number:e,Tuple:t,Or:n,Auto:i,Nullable:s})=>({bounds:[s(n(t(s(e),s(e)),i)),null],min_interval:[s(e),null],max_interval:[s(e),null]})))},
function _(t,e,s,n,r){var a;n();const i=t(86);class _ extends i.Range{constructor(t){super(t)}_set_auto_bounds(){if("auto"==this.bounds){const t=Math.min(this._reset_start,this._reset_end),e=Math.max(this._reset_start,this._reset_end);this.setv({bounds:[t,e]},{silent:!0})}}initialize(){super.initialize(),this._set_auto_bounds()}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}reset(){this._set_auto_bounds();const{_reset_start:t,_reset_end:e}=this;this.start!=t||this.end!=e?this.setv({start:t,end:e}):this.change.emit()}map(t){return new _({start:t(this.start),end:t(this.end)})}widen(t){let{start:e,end:s}=this;return this.is_reversed?(e+=t,s-=t):(e-=t,s+=t),new _({start:e,end:s})}}s.Range1d=_,a=_,_.__name__="Range1d",a.define((({Number:t,Nullable:e})=>({start:[t,0],end:[t,1],reset_start:[e(t),null,{on_update(t,e){e._reset_start=null!=t?t:e.start}}],reset_end:[e(t),null,{on_update(t,e){e._reset_end=null!=t?t:e.end}}]})))},
function _(t,e,n,r,s){r();const a=t(89);class _ extends a.ContinuousScale{constructor(t){super(t)}get s_compute(){const[t,e]=this._linear_compute_state();return n=>t*n+e}get s_invert(){const[t,e]=this._linear_compute_state();return n=>(n-e)/t}_linear_compute_state(){const t=this.source_range.start,e=this.source_range.end,n=this.target_range.start,r=(this.target_range.end-n)/(e-t);return[r,-r*t+n]}}n.LinearScale=_,_.__name__="LinearScale"},
function _(n,c,o,s,e){s();const t=n(84);class u extends t.Scale{constructor(n){super(n)}}o.ContinuousScale=u,u.__name__="ContinuousScale"},
function _(t,e,s,a,r){a();const o=t(89);class n extends o.ContinuousScale{constructor(t){super(t)}get s_compute(){const[t,e,s,a]=this._compute_state();return r=>{if(0==s)return 0;{const o=(Math.log(r)-a)/s;return isFinite(o)?o*t+e:NaN}}}get s_invert(){const[t,e,s,a]=this._compute_state();return r=>{const o=(r-e)/t;return Math.exp(s*o+a)}}_get_safe_factor(t,e){let s=t<0?0:t,a=e<0?0:e;if(s==a)if(0==s)[s,a]=[1,10];else{const t=Math.log10(s);s=10**Math.floor(t),a=Math.ceil(t)!=Math.floor(t)?10**Math.ceil(t):10**(Math.ceil(t)+1)}return[s,a]}_compute_state(){const t=this.source_range.start,e=this.source_range.end,s=this.target_range.start,a=this.target_range.end-s,[r,o]=this._get_safe_factor(t,e);let n,c;0==r?(n=Math.log(o),c=0):(n=Math.log(o/r),c=Math.log(r));return[a,s,n,c]}}s.LogScale=n,n.__name__="LogScale"},
function _(t,e,c,a,s){a();const n=t(84),r=t(88),{_linear_compute_state:o}=r.LinearScale.prototype;class l extends n.Scale{constructor(t){super(t)}get s_compute(){const[t,e]=o.call(this),c=this.source_range;return a=>t*c.synthetic(a)+e}get s_invert(){const[t,e]=o.call(this);return c=>(c-e)/t}}c.CategoricalScale=l,l.__name__="CategoricalScale"},
function _(t,i,n,e,a){e();const s=t(1);var l;const _=t(93),o=t(19),r=t(32),d=t(18),h=s.__importStar(t(56)),u=t(94);class g extends _.DataRange{constructor(t){super(t),this.plots=new Set,this.have_updated_interactively=!1}initialize(){super.initialize(),this._initial_start=isNaN(this.start)?null:this.start,this._initial_end=isNaN(this.end)?null:this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}computed_renderers(){const{renderers:t}=this,i=(0,r.flat_map)(this.plots,(t=>t.data_renderers));return(0,u.compute_renderers)(0==t.length?"auto":t,[...i])}_compute_plot_bounds(t,i){let n=h.empty();for(const e of t){const t=i.get(e);null==t||!e.visible&&this.only_visible||(n=h.union(n,t))}return n}adjust_bounds_for_aspect(t,i){const n=h.empty();let e=t.x1-t.x0;e<=0&&(e=1);let a=t.y1-t.y0;a<=0&&(a=1);const s=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return e<i*a?e=i*a:a=e/i,n.x1=s+.5*e,n.x0=s-.5*e,n.y1=l+.5*a,n.y0=l-.5*a,n}_compute_min_max(t,i){let n,e,a=h.empty();for(const[i,n]of t)i.visible&&(a=h.union(a,n));return[n,e]=0==i?[a.x0,a.x1]:[a.y0,a.y1],[n,e]}_compute_range(t,i){const n=this.range_padding;let e,a;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){let s,l;if((isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,d.logger.warn(`could not determine minimum data value for log axis, DataRange1d using value ${t}`)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,d.logger.warn(`could not determine maximum data value for log axis, DataRange1d using value ${i}`)),i==t)l=this.default_span+.001,s=Math.log10(t);else{let e,a;"percent"==this.range_padding_units?(e=Math.log10(t),a=Math.log10(i),l=(a-e)*(1+n)):(e=Math.log10(t-n),a=Math.log10(i+n),l=a-e),s=(e+a)/2}e=10**(s-l/2),a=10**(s+l/2)}else{let s;s=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+n):i-t+2*n;const l=(i+t)/2;e=l-s/2,a=l+s/2}let s=1;this.flipped&&([e,a]=[a,e],s=-1);const l=this.follow_interval;return null!=l&&Math.abs(e-a)>l&&("start"==this.follow?a=e+s*l:"end"==this.follow&&(e=a-s*l)),[e,a]}update(t,i,n,e){if(this.have_updated_interactively)return;const a=this.computed_renderers();let s=this._compute_plot_bounds(a,t);null!=e&&(s=this.adjust_bounds_for_aspect(s,e)),this._plot_bounds.set(n,s);const[l,_]=this._compute_min_max(this._plot_bounds.entries(),i);let[o,r]=this._compute_range(l,_);null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(o=this._initial_start):o=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(r=this._initial_end):r=this._initial_end);let d=!1;"auto"==this.bounds&&(this.setv({bounds:[o,r]},{silent:!0}),d=!0);const[h,u]=[this.start,this.end];if(o!=h||r!=u){const t={};o!=h&&(t.start=o),r!=u&&(t.end=r),this.setv(t),d=!1}d&&this.change.emit()}reset(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()}}n.DataRange1d=g,l=g,g.__name__="DataRange1d",l.define((({Boolean:t,Number:i,Nullable:n})=>({start:[i,NaN],end:[i,NaN],range_padding:[i,.1],range_padding_units:[o.PaddingUnits,"percent"],flipped:[t,!1],follow:[n(o.StartEnd),null],follow_interval:[n(i),null],default_span:[i,2],only_visible:[t,!1]}))),l.internal((({Enum:t})=>({scale_hint:[t("log","auto"),"auto"]})))},
function _(e,n,a,r,t){var s;r();const c=e(86);class o extends c.Range{constructor(e){super(e)}}a.DataRange=o,s=o,o.__name__="DataRange",s.define((({Array:e,AnyRef:n,Or:a,Auto:r})=>({renderers:[a(e(n()),r),[]]})))},
function _(n,u,e,r,t){r(),e.compute_renderers=function(n,u){return"auto"==n?u:null!=n?n:[]}},
function _(t,n,e,i,s){var r;i();const a=t(86),o=t(19),g=t(20),p=t(23),c=t(10),l=t(8),u=t(12);function h(t,n,e=0){const i=new Map;for(let s=0;s<t.length;s++){const r=t[s];if(i.has(r))throw new Error(`duplicate factor or subfactor: ${r}`);i.set(r,{value:.5+s*(1+n)+e})}return[i,(t.length-1)*n]}function d(t,n,e,i=0){var s;const r=new Map,a=new Map;for(const[n,e]of t){const t=null!==(s=a.get(n))&&void 0!==s?s:[];a.set(n,[...t,e])}let o=i,g=0;for(const[t,i]of a){const s=i.length,[a,p]=h(i,e,o);g+=p;const l=(0,c.sum)(i.map((t=>a.get(t).value)));r.set(t,{value:l/s,mapping:a}),o+=s+n+p}return[r,(a.size-1)*n+g]}function _(t,n,e,i,s=0){var r;const a=new Map,o=new Map;for(const[n,e,i]of t){const t=null!==(r=o.get(n))&&void 0!==r?r:[];o.set(n,[...t,[e,i]])}let g=s,p=0;for(const[t,s]of o){const r=s.length,[o,l]=d(s,e,i,g);p+=l;const u=(0,c.sum)(s.map((([t])=>o.get(t).value)));a.set(t,{value:u/r,mapping:o}),g+=r+n+l}return[a,(o.size-1)*n+p]}e.Factor=(0,g.Or)(g.String,(0,g.Tuple)(g.String,g.String),(0,g.Tuple)(g.String,g.String,g.String)),e.FactorSeq=(0,g.Or)((0,g.Array)(g.String),(0,g.Array)((0,g.Tuple)(g.String,g.String)),(0,g.Array)((0,g.Tuple)(g.String,g.String,g.String))),e.map_one_level=h,e.map_two_levels=d,e.map_three_levels=_;class f extends a.Range{constructor(t){super(t)}get min(){return this.start}get max(){return this.end}initialize(){super.initialize(),this._init(!0)}connect_signals(){super.connect_signals(),this.connect(this.properties.factors.change,(()=>this.reset())),this.connect(this.properties.factor_padding.change,(()=>this.reset())),this.connect(this.properties.group_padding.change,(()=>this.reset())),this.connect(this.properties.subgroup_padding.change,(()=>this.reset())),this.connect(this.properties.range_padding.change,(()=>this.reset())),this.connect(this.properties.range_padding_units.change,(()=>this.reset()))}reset(){this._init(!1),this.change.emit()}_lookup(t){switch(t.length){case 1:{const[n]=t,e=this._mapping.get(n);return null!=e?e.value:NaN}case 2:{const[n,e]=t,i=this._mapping.get(n);if(null!=i){const t=i.mapping.get(e);if(null!=t)return t.value}return NaN}case 3:{const[n,e,i]=t,s=this._mapping.get(n);if(null!=s){const t=s.mapping.get(e);if(null!=t){const n=t.mapping.get(i);if(null!=n)return n.value}}return NaN}default:(0,u.unreachable)()}}synthetic(t){if((0,l.isNumber)(t))return t;if((0,l.isString)(t))return this._lookup([t]);let n=0;const e=t[t.length-1];return(0,l.isNumber)(e)&&(n=e,t=t.slice(0,-1)),this._lookup(t)+n}v_synthetic(t){const n=t.length,e=new p.ScreenArray(n);for(let i=0;i<n;i++)e[i]=this.synthetic(t[i]);return e}_init(t){const{levels:n,mapping:e,tops:i,mids:s,inside_padding:r}=(()=>{if((0,c.every)(this.factors,l.isString)){const t=this.factors,[n,e]=h(t,this.factor_padding);return{levels:1,mapping:n,tops:null,mids:null,inside_padding:e}}if((0,c.every)(this.factors,(t=>(0,l.isArray)(t)&&2==t.length&&(0,l.isString)(t[0])&&(0,l.isString)(t[1])))){const t=this.factors,[n,e]=d(t,this.group_padding,this.factor_padding),i=[...n.keys()];return{levels:2,mapping:n,tops:i,mids:null,inside_padding:e}}if((0,c.every)(this.factors,(t=>(0,l.isArray)(t)&&3==t.length&&(0,l.isString)(t[0])&&(0,l.isString)(t[1])&&(0,l.isString)(t[2])))){const t=this.factors,[n,e]=_(t,this.group_padding,this.subgroup_padding,this.factor_padding),i=[...n.keys()],s=[];for(const[t,e]of n)for(const n of e.mapping.keys())s.push([t,n]);return{levels:3,mapping:n,tops:i,mids:s,inside_padding:e}}(0,u.unreachable)()})();this._mapping=e,this.tops=i,this.mids=s;let a=0,o=this.factors.length+r;if("percent"==this.range_padding_units){const t=(o-a)*this.range_padding/2;a-=t,o+=t}else a-=this.range_padding,o+=this.range_padding;this.setv({start:a,end:o,levels:n},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[a,o]},{silent:!0})}}e.FactorRange=f,r=f,f.__name__="FactorRange",r.define((({Number:t})=>({factors:[e.FactorSeq,[]],factor_padding:[t,0],subgroup_padding:[t,.8],group_padding:[t,1.4],range_padding:[t,0],range_padding_units:[o.PaddingUnits,"percent"],start:[t,NaN],end:[t,NaN]}))),r.internal((({Number:t,String:n,Array:e,Tuple:i,Nullable:s})=>({levels:[t],mids:[s(e(i(n,n))),null],tops:[s(e(n)),null]})))},
function _(t,e,s,a,n){a();const r=t(1);var i;const _=t(97),o=t(138),l=t(77),d=t(19),c=t(23),h=t(58),u=t(23),v=r.__importStar(t(17)),p=t(11);class w extends _.DataAnnotationView{async lazy_initialize(){await super.lazy_initialize();const{start:t,end:e}=this.model;null!=t&&(this.start=await(0,h.build_view)(t,{parent:this})),null!=e&&(this.end=await(0,h.build_view)(e,{parent:this}))}set_data(t){var e,s;super.set_data(t);const a=u.Indices.all_set(this._x_start.length);null===(e=this.start)||void 0===e||e.set_data(t,a),null===(s=this.end)||void 0===s||s.set_data(t,a)}remove(){var t,e;null===(t=this.start)||void 0===t||t.remove(),null===(e=this.end)||void 0===e||e.remove(),super.remove()}map_data(){const{frame:t}=this.plot_view,[e,s]=(()=>{switch(this.model.start_units){case"canvas":return[new c.ScreenArray(this._x_start),new c.ScreenArray(this._y_start)];case"screen":return[t.bbox.xview.v_compute(this._x_start),t.bbox.yview.v_compute(this._y_start)];case"data":return[this.coordinates.x_scale.v_compute(this._x_start),this.coordinates.y_scale.v_compute(this._y_start)]}})(),[a,n]=(()=>{switch(this.model.end_units){case"canvas":return[new c.ScreenArray(this._x_end),new c.ScreenArray(this._y_end)];case"screen":return[t.bbox.xview.v_compute(this._x_end),t.bbox.yview.v_compute(this._y_end)];case"data":return[this.coordinates.x_scale.v_compute(this._x_end),this.coordinates.y_scale.v_compute(this._y_end)]}})();this._sx_start=e,this._sy_start=s,this._sx_end=a,this._sy_end=n;const r=e.length,i=this._angles=new c.ScreenArray(r);for(let t=0;t<r;t++)i[t]=Math.PI/2+(0,p.atan2)([e[t],s[t]],[a[t],n[t]])}paint(t){const{start:e,end:s}=this,{_sx_start:a,_sy_start:n,_sx_end:r,_sy_end:i,_angles:_}=this,{x:o,y:l,width:d,height:c}=this.plot_view.frame.bbox;for(let h=0,u=a.length;h<u;h++)null!=s&&(t.save(),t.translate(r[h],i[h]),t.rotate(_[h]),s.render(t,h),t.restore()),null!=e&&(t.save(),t.translate(a[h],n[h]),t.rotate(_[h]+Math.PI),e.render(t,h),t.restore()),this.visuals.line.doit&&(t.save(),null==e&&null==s||(t.beginPath(),t.rect(o,l,d,c),null!=s&&(t.save(),t.translate(r[h],i[h]),t.rotate(_[h]),s.clip(t,h),t.restore()),null!=e&&(t.save(),t.translate(a[h],n[h]),t.rotate(_[h]+Math.PI),e.clip(t,h),t.restore()),t.closePath(),t.clip()),t.beginPath(),t.moveTo(a[h],n[h]),t.lineTo(r[h],i[h]),this.visuals.line.apply(t,h),t.restore())}}s.ArrowView=w,w.__name__="ArrowView";class y extends _.DataAnnotation{constructor(t){super(t)}}s.Arrow=y,i=y,y.__name__="Arrow",i.prototype.default_view=w,i.mixins(l.LineVector),i.define((({Ref:t,Nullable:e})=>({x_start:[v.XCoordinateSpec,{field:"x_start"}],y_start:[v.YCoordinateSpec,{field:"y_start"}],start_units:[d.CoordinateUnits,"data"],start:[e(t(o.ArrowHead)),null],x_end:[v.XCoordinateSpec,{field:"x_end"}],y_end:[v.YCoordinateSpec,{field:"y_end"}],end_units:[d.CoordinateUnits,"data"],end:[e(t(o.ArrowHead)),()=>new o.OpenHead]})))},
function _(t,e,n,s,a){s();const o=t(1);var i;const c=t(72),r=t(98),_=t(103),l=t(104),h=o.__importStar(t(17));class d extends c.AnnotationView{constructor(){super(...arguments),this._initial_set_data=!1}connect_signals(){super.connect_signals();const t=()=>{this.set_data(this.model.source),this._rerender()};this.connect(this.model.change,t),this.connect(this.model.source.streaming,t),this.connect(this.model.source.patching,t),this.connect(this.model.source.change,t)}_rerender(){this.request_render()}set_data(t){const e=this;for(const n of this.model)if(n instanceof h.VectorSpec||n instanceof h.ScalarSpec)if(n instanceof h.BaseCoordinateSpec){const s=n.array(t);e[`_${n.attr}`]=s}else{const s=n.uniform(t);e[`${n.attr}`]=s}this.plot_model.use_map&&(null!=e._x&&l.inplace.project_xy(e._x,e._y),null!=e._xs&&l.inplace.project_xsys(e._xs,e._ys));for(const t of this.visuals)t.update()}_render(){this._initial_set_data||(this.set_data(this.model.source),this._initial_set_data=!0),this.map_data(),this.paint(this.layer.ctx)}}n.DataAnnotationView=d,d.__name__="DataAnnotationView";class u extends c.Annotation{constructor(t){super(t)}}n.DataAnnotation=u,i=u,u.__name__="DataAnnotation",i.define((({Ref:t})=>({source:[t(r.ColumnarDataSource),()=>new _.ColumnDataSource]})))},
function _(t,e,n,a,s){var r;a();const i=t(18),l=t(99),o=t(15),c=t(10),u=t(29),h=t(9),g=t(8),d=t(101),_=t(100),f=t(102);class m extends f.DataSource{constructor(t){super(t),this.selection_manager=new l.SelectionManager(this)}get_array(t){let e=this.data[t];return null==e?this.data[t]=e=[]:(0,g.isArray)(e)||(this.data[t]=e=Array.from(e)),e}initialize(){super.initialize(),this._select=new o.Signal0(this,"select"),this.inspect=new o.Signal(this,"inspect")}get_column(t){return t in this.data?this.data[t]:null}columns(){return(0,h.keys)(this.data)}get_length(t=!0){const e=(0,c.uniq)((0,h.values)(this.data).map((t=>(0,u.is_NDArray)(t)?t.shape[0]:t.length)));switch(e.length){case 0:return null;case 1:return e[0];default:{const n="data source has columns of inconsistent lengths";if(t)return i.logger.warn(n),e.sort()[0];throw new Error(n)}}}get length(){var t;return null!==(t=this.get_length())&&void 0!==t?t:0}clear(){const t={};for(const e of this.columns())t[e]=new this.data[e].constructor(0);this.data=t}}n.ColumnarDataSource=m,r=m,m.__name__="ColumnarDataSource",r.define((({Ref:t})=>({selection_policy:[t(d.SelectionPolicy),()=>new d.UnionRenderers]}))),r.internal((({AnyRef:t})=>({inspected:[t(),()=>new _.Selection]})))},
function _(e,t,o,s,c){s();const n=e(100);function i(e){return"GlyphRenderer"==e.model.type}function l(e){return"GraphRenderer"==e.model.type}class r{constructor(e){this.source=e,this.inspectors=new Map}select(e,t,o,s="replace"){const c=[],n=[];for(const t of e)i(t)?c.push(t):l(t)&&n.push(t);let r=!1;for(const e of n){const c=e.model.selection_policy.hit_test(t,e);r=r||e.model.selection_policy.do_selection(c,e.model,o,s)}if(c.length>0){const e=this.source.selection_policy.hit_test(t,c);r=r||this.source.selection_policy.do_selection(e,this.source,o,s)}return r}inspect(e,t){let o=!1;if(i(e)){const s=e.hit_test(t);if(null!=s){o=!s.is_empty();const c=this.get_or_create_inspector(e.model);c.update(s,!0,"replace"),this.source.setv({inspected:c},{silent:!0}),this.source.inspect.emit([e.model,{geometry:t}])}}else if(l(e)){const s=e.model.inspection_policy.hit_test(t,e);o=e.model.inspection_policy.do_inspection(s,t,e,!1,"replace")}return o}clear(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()}get_or_create_inspector(e){let t=this.inspectors.get(e);return null==t&&(t=new n.Selection,this.inspectors.set(e,t)),t}}o.SelectionManager=r,r.__name__="SelectionManager"},
function _(i,e,s,t,n){var l;t();const c=i(50),h=i(10),d=i(9);class _ extends c.Model{constructor(i){super(i)}get_view(){return this.view}get selected_glyph(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null}add_to_selected_glyphs(i){this.selected_glyphs.push(i)}update(i,e=!0,s="replace"){switch(s){case"replace":this.indices=i.indices,this.line_indices=i.line_indices,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices,this.view=i.view,this.selected_glyphs=i.selected_glyphs;break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i)}}clear(){this.indices=[],this.line_indices=[],this.multiline_indices={},this.image_indices=[],this.view=null,this.selected_glyphs=[]}map(i){return new _(Object.assign(Object.assign({},this.attributes),{indices:this.indices.map(i),multiline_indices:(0,d.to_object)((0,d.entries)(this.multiline_indices).map((([e,s])=>[i(Number(e)),s]))),image_indices:this.image_indices.map((e=>Object.assign(Object.assign({},e),{index:i(e.index)})))}))}is_empty(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length}update_through_union(i){this.indices=(0,h.union)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=(0,d.merge)(i.multiline_indices,this.multiline_indices)}update_through_intersection(i){this.indices=(0,h.intersection)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=(0,d.merge)(i.multiline_indices,this.multiline_indices)}update_through_subtraction(i){this.indices=(0,h.difference)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=(0,d.merge)(i.multiline_indices,this.multiline_indices)}}s.Selection=_,l=_,_.__name__="Selection",l.define((({Int:i,Array:e,Dict:s,Struct:t})=>({indices:[e(i),[]],line_indices:[e(i),[]],multiline_indices:[s(e(i)),{}],image_indices:[e(t({index:i,i,j:i,flat_index:i})),[]]}))),l.internal((({Array:i,AnyRef:e,Nullable:s})=>({selected_glyphs:[i(e()),[]],view:[s(e()),null]})))},
function _(e,t,n,s,o){s();const r=e(50);class c extends r.Model{do_selection(e,t,n,s){return null!=e&&(t.selected.update(e,n,s),t._select.emit(),!t.selected.is_empty())}}n.SelectionPolicy=c,c.__name__="SelectionPolicy";class l extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!=t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_intersection(t);return e}return null}}n.IntersectRenderers=l,l.__name__="IntersectRenderers";class _ extends c{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!=t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_union(t);return e}return null}}n.UnionRenderers=_,_.__name__="UnionRenderers"},
function _(e,c,n,t,o){var a;t();const s=e(50),r=e(100);class l extends s.Model{constructor(e){super(e)}}n.DataSource=l,a=l,l.__name__="DataSource",a.define((({Ref:e})=>({selected:[e(r.Selection),()=>new r.Selection]})))},
function _(t,a,s,e,r){var c;e();const n=t(98);class o extends n.ColumnarDataSource{constructor(t){super(t)}stream(t,a,{sync:s}={}){this.stream_to(this.properties.data,t,a,{sync:s})}patch(t,{sync:a}={}){this.patch_to(this.properties.data,t,{sync:a})}}s.ColumnDataSource=o,c=o,o.__name__="ColumnDataSource",c.define((({Any:t,Dict:a,Arrayable:s})=>({data:[a(s(t)),{}]})))},
function _(n,t,e,o,r){o();const c=n(1),l=c.__importDefault(n(105)),i=c.__importDefault(n(106)),u=n(23),a=new i.default("GOOGLE"),s=new i.default("WGS84"),f=(0,l.default)(s,a);e.wgs84_mercator={compute:(n,t)=>isFinite(n)&&isFinite(t)?f.forward([n,t]):[NaN,NaN],invert:(n,t)=>isFinite(n)&&isFinite(t)?f.inverse([n,t]):[NaN,NaN]};const _={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},p={lon:[-180,180],lat:[-85.06,85.06]},{min:g,max:h}=Math;function m(n,t){const o=g(n.length,t.length),r=(0,u.infer_type)(n,t),c=new r(o),l=new r(o);return e.inplace.project_xy(n,t,c,l),[c,l]}e.clip_mercator=function(n,t,e){const[o,r]=_[e];return[h(n,o),g(t,r)]},e.in_bounds=function(n,t){const[e,o]=p[t];return e<n&&n<o},function(n){function t(n,t,o,r){const c=g(n.length,t.length);o=null!=o?o:n,r=null!=r?r:t;for(let l=0;l<c;l++){const c=n[l],i=t[l],[u,a]=e.wgs84_mercator.compute(c,i);o[l]=u,r[l]=a}}n.project_xy=t,n.project_xsys=function(n,e,o,r){const c=g(n.length,e.length);o=null!=o?o:n,r=null!=r?r:e;for(let l=0;l<c;l++)t(n[l],e[l],o[l],r[l])}}(e.inplace||(e.inplace={})),e.project_xy=m,e.project_xsys=function(n,t){const e=g(n.length,t.length),o=new Array(e),r=new Array(e);for(let c=0;c<e;c++){const[e,l]=m(n[c],t[c]);o[c]=e,r[c]=l}return[o,r]}},
function _(e,n,t,r,o){r();const a=e(1),i=a.__importDefault(e(106)),c=a.__importDefault(e(132));var u=(0,i.default)("WGS84");function f(e,n,t,r){var o,a,i;return Array.isArray(t)?(o=(0,c.default)(e,n,t,r)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof o.z?[o.x,o.y,o.z].concat(t.splice(3)):[o.x,o.y,t[2]].concat(t.splice(3)):[o.x,o.y].concat(t.splice(2)):[o.x,o.y]):(a=(0,c.default)(e,n,t,r),2===(i=Object.keys(t)).length||i.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;a[r]=t[r]})),a)}function l(e){return e instanceof i.default?e:e.oProj?e.oProj:(0,i.default)(e)}t.default=function(e,n,t){e=l(e);var r,o=!1;return void 0===n?(n=e,e=u,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=u,o=!0),n=l(n),t?f(e,n,t):(r={forward:function(t,r){return f(e,n,t,r)},inverse:function(t,r){return f(n,e,t,r)}},o&&(r.oProj=n),r)}},
function _(t,e,a,s,i){s();const l=t(1),u=l.__importDefault(t(107)),r=l.__importDefault(t(118)),d=l.__importDefault(t(119)),o=t(127),f=l.__importDefault(t(129)),p=l.__importDefault(t(130)),m=l.__importDefault(t(114)),n=t(131);function h(t,e){if(!(this instanceof h))return new h(t);e=e||function(t){if(t)throw t};var a=(0,u.default)(t);if("object"==typeof a){var s=h.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var i=(0,m.default)(f.default,a.datumCode);i&&(a.datum_params=a.datum_params||(i.towgs84?i.towgs84.split(","):null),a.ellps=i.ellipse,a.datumName=i.datumName?i.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84",a.lat1=a.lat1||a.lat0;var l=(0,o.sphere)(a.a,a.b,a.rf,a.ellps,a.sphere),d=(0,o.eccentricity)(l.a,l.b,l.rf,a.R_A),_=(0,n.getNadgrids)(a.nadgrids),c=a.datum||(0,p.default)(a.datumCode,a.datum_params,l.a,l.b,d.es,d.ep2,_);(0,r.default)(this,a),(0,r.default)(this,s),this.a=l.a,this.b=l.b,this.rf=l.rf,this.sphere=l.sphere,this.es=d.es,this.e=d.e,this.ep2=d.ep2,this.datum=c,this.init(),e(null,this)}else e(t)}else e(t)}h.projections=d.default,h.projections.start(),a.default=h},
function _(t,r,n,u,e){u();const f=t(1),i=f.__importDefault(t(108)),a=f.__importDefault(t(115)),o=f.__importDefault(t(110)),l=f.__importDefault(t(114));var C=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var d=["3857","900913","3785","102113"];n.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in i.default}(t))return i.default[t];if(function(t){return C.some((function(r){return t.indexOf(r)>-1}))}(t)){var r=(0,a.default)(t);if(function(t){var r=(0,l.default)(t,"authority");if(r){var n=(0,l.default)(r,"epsg");return n&&d.indexOf(n)>-1}}(r))return i.default["EPSG:3857"];var n=function(t){var r=(0,l.default)(t,"extension");if(r)return(0,l.default)(r,"proj4")}(r);return n?(0,o.default)(n):r}return function(t){return"+"===t[0]}(t)?(0,o.default)(t):void 0}},
function _(t,r,i,e,n){e();const f=t(1),a=f.__importDefault(t(109)),l=f.__importDefault(t(110)),u=f.__importDefault(t(115));function o(t){var r=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?o[t]=(0,l.default)(arguments[1]):o[t]=(0,u.default)(arguments[1]):o[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?o.apply(r,t):o(t)}));if("string"==typeof t){if(t in o)return o[t]}else"EPSG"in t?o["EPSG:"+t.EPSG]=t:"ESRI"in t?o["ESRI:"+t.ESRI]=t:"IAU2000"in t?o["IAU2000:"+t.IAU2000]=t:console.log(t);return}}(0,a.default)(o),i.default=o},
function _(t,l,G,S,e){S(),G.default=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},
function _(t,n,o,a,u){a();const e=t(1),r=t(111),i=e.__importDefault(t(112)),f=e.__importDefault(t(113)),l=e.__importDefault(t(114));o.default=function(t){var n,o,a,u={},e=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){u.rf=parseFloat(t)},lat_0:function(t){u.lat0=t*r.D2R},lat_1:function(t){u.lat1=t*r.D2R},lat_2:function(t){u.lat2=t*r.D2R},lat_ts:function(t){u.lat_ts=t*r.D2R},lon_0:function(t){u.long0=t*r.D2R},lon_1:function(t){u.long1=t*r.D2R},lon_2:function(t){u.long2=t*r.D2R},alpha:function(t){u.alpha=parseFloat(t)*r.D2R},gamma:function(t){u.rectified_grid_angle=parseFloat(t)},lonc:function(t){u.longc=t*r.D2R},x_0:function(t){u.x0=parseFloat(t)},y_0:function(t){u.y0=parseFloat(t)},k_0:function(t){u.k0=parseFloat(t)},k:function(t){u.k0=parseFloat(t)},a:function(t){u.a=parseFloat(t)},b:function(t){u.b=parseFloat(t)},r_a:function(){u.R_A=!0},zone:function(t){u.zone=parseInt(t,10)},south:function(){u.utmSouth=!0},towgs84:function(t){u.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){u.to_meter=parseFloat(t)},units:function(t){u.units=t;var n=(0,l.default)(f.default,t);n&&(u.to_meter=n.to_meter)},from_greenwich:function(t){u.from_greenwich=t*r.D2R},pm:function(t){var n=(0,l.default)(i.default,t);u.from_greenwich=(n||parseFloat(t))*r.D2R},nadgrids:function(t){"@null"===t?u.datumCode="none":u.nadgrids=t},axis:function(t){var n="ewnsud";3===t.length&&-1!==n.indexOf(t.substr(0,1))&&-1!==n.indexOf(t.substr(1,1))&&-1!==n.indexOf(t.substr(2,1))&&(u.axis=t)},approx:function(){u.approx=!0}};for(n in e)o=e[n],n in c?"function"==typeof(a=c[n])?a(o):u[a]=o:u[n]=o;return"string"==typeof u.datumCode&&"WGS84"!==u.datumCode&&(u.datumCode=u.datumCode.toLowerCase()),u}},
function _(S,_,P,R,I){R(),P.PJD_3PARAM=1,P.PJD_7PARAM=2,P.PJD_GRIDSHIFT=3,P.PJD_WGS84=4,P.PJD_NODATUM=5,P.SRS_WGS84_SEMIMAJOR=6378137,P.SRS_WGS84_SEMIMINOR=6356752.314,P.SRS_WGS84_ESQUARED=.0066943799901413165,P.SEC_TO_RAD=484813681109536e-20,P.HALF_PI=Math.PI/2,P.SIXTH=.16666666666666666,P.RA4=.04722222222222222,P.RA6=.022156084656084655,P.EPSLN=1e-10,P.D2R=.017453292519943295,P.R2D=57.29577951308232,P.FORTPI=Math.PI/4,P.TWO_PI=2*Math.PI,P.SPI=3.14159265359},
function _(o,r,a,e,s){e();var n={};a.default=n,n.greenwich=0,n.lisbon=-9.131906111111,n.paris=2.337229166667,n.bogota=-74.080916666667,n.madrid=-3.687938888889,n.rome=12.452333333333,n.bern=7.439583333333,n.jakarta=106.807719444444,n.ferro=-17.666666666667,n.brussels=4.367975,n.stockholm=18.058277777778,n.athens=23.7163375,n.oslo=10.722916666667},
function _(t,e,f,o,u){o(),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t,a,n){a();var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,a,t,o,n){o();const r=e(1);const l=r.__importDefault(e(116)),d=e(117);function i(e){return.017453292519943295*e}t.default=function(e){var a=(0,l.default)(e),t=a.shift(),o=a.shift();a.unshift(["name",o]),a.unshift(["type",t]);var n={};return(0,d.sExpr)(a,n),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var a="",t=0,o=e.AXIS.length;t<o;++t){var n=[e.AXIS[t][0].toLowerCase(),e.AXIS[t][1].toLowerCase()];-1!==n[0].indexOf("north")||("y"===n[0]||"lat"===n[0])&&"north"===n[1]?a+="n":-1!==n[0].indexOf("south")||("y"===n[0]||"lat"===n[0])&&"south"===n[1]?a+="s":-1!==n[0].indexOf("east")||("x"===n[0]||"lon"===n[0])&&"east"===n[1]?a+="e":-1===n[0].indexOf("west")&&("x"!==n[0]&&"lon"!==n[0]||"west"!==n[1])||(a+="w")}2===a.length&&(a+="u"),3===a.length&&(e.axis=a)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function l(a){return a*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_1","Latitude of 1st standard parallel"],["standard_parallel_2","Standard_Parallel_2"],["standard_parallel_2","Latitude of 2nd standard parallel"],["false_easting","False_Easting"],["false_easting","False easting"],["false-easting","Easting at false origin"],["false_northing","False_Northing"],["false_northing","False northing"],["false_northing","Northing at false origin"],["central_meridian","Central_Meridian"],["central_meridian","Longitude of natural origin"],["central_meridian","Longitude of false origin"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["latitude_of_origin","Latitude of natural origin"],["latitude_of_origin","Latitude of false origin"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",i],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",i],["x0","false_easting",l],["y0","false_northing",l],["long0","central_meridian",i],["lat0","latitude_of_origin",i],["lat0","standard_parallel_1",i],["lat1","standard_parallel_1",i],["lat2","standard_parallel_2",i],["azimuth","Azimuth"],["alpha","azimuth",i],["srsCode","name"]].forEach((function(a){return t=e,n=(o=a)[0],r=o[1],void(!(n in t)&&r in t&&(t[n]=t[r],3===o.length&&(t[n]=o[2](t[n]))));var t,o,n,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=i(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(n),n}},
function _(t,e,r,i,s){i(),r.default=function(t){return new d(t).output()};var h=/\s/,o=/[A-Za-z]/,n=/[A-Za-z84_]/,a=/[,\]]/,u=/[\d\.E\-\+]/;function d(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}d.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;h.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},d.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(a.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},d.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},d.prototype.number=function(t){if(!u.test(t)){if(a.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},d.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},d.prototype.keyword=function(t){if(n.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!a.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},d.prototype.neutral=function(t){if(o.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(u.test(t))return this.word=t,void(this.state=3);if(!a.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},d.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,a,r,s,c){function n(e,a,r){Array.isArray(a)&&(r.unshift(a),a=null);var s=a?{}:e,c=r.reduce((function(e,a){return E(a,e),e}),s);a&&(e[a]=c)}function E(e,a){if(Array.isArray(e)){var r=e.shift();if("PARAMETER"===r&&(r=e.shift()),1===e.length)return Array.isArray(e[0])?(a[r]={},void E(e[0],a[r])):void(a[r]=e[0]);if(e.length)if("TOWGS84"!==r){if("AXIS"===r)return r in a||(a[r]=[]),void a[r].push(e);var s;switch(Array.isArray(r)||(a[r]={}),r){case"UNIT":case"PRIMEM":case"VERT_DATUM":return a[r]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&E(e[2],a[r]));case"SPHEROID":case"ELLIPSOID":return a[r]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&E(e[3],a[r]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void n(a,r,e);default:for(s=-1;++s<e.length;)if(!Array.isArray(e[s]))return E(e,a[r]);return n(a,r,e)}}else a[r]=e;else a[r]=!0}else a[e]=!0}s(),r.sExpr=E},
function _(n,r,f,i,t){i(),f.default=function(n,r){var f,i;if(n=n||{},!r)return n;for(i in r)void 0!==(f=r[i])&&(n[i]=f);return n}},
function _(t,o,a,e,n){e();const r=t(1),f=r.__importDefault(t(120)),u=r.__importDefault(t(126));var i=[f.default,u.default],c={},d=[];function s(t,o){var a=d.length;return t.names?(d[a]=t,t.names.forEach((function(t){c[t.toLowerCase()]=a})),this):(console.log(o),!0)}function l(t){if(!t)return!1;var o=t.toLowerCase();return void 0!==c[o]&&d[c[o]]?d[c[o]]:void 0}function v(){i.forEach(s)}a.add=s,a.get=l,a.start=v,a.default={start:v,add:s,get:l}},
function _(t,i,s,h,a){h();const e=t(1),r=e.__importDefault(t(121)),n=e.__importDefault(t(122)),l=e.__importDefault(t(124)),u=e.__importDefault(t(125)),o=t(111);function f(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=(0,r.default)(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function _(t){var i,s,h=t.x,a=t.y;if(a*o.R2D>90&&a*o.R2D<-90&&h*o.R2D>180&&h*o.R2D<-180)return null;if(Math.abs(Math.abs(a)-o.HALF_PI)<=o.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*(0,n.default)(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(o.FORTPI+.5*a));else{var e=Math.sin(a),r=(0,l.default)(this.e,a,e);i=this.x0+this.a*this.k0*(0,n.default)(h-this.long0),s=this.y0-this.a*this.k0*Math.log(r)}return t.x=i,t.y=s,t}function M(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=o.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var e=Math.exp(-a/(this.a*this.k0));if(-9999===(s=(0,u.default)(this.e,e)))return null}return i=(0,n.default)(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=f,s.forward=_,s.inverse=M,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:f,forward:_,inverse:M,names:s.names}},
function _(t,n,r,u,a){u(),r.default=function(t,n,r){var u=t*n;return r/Math.sqrt(1-u*u)}},
function _(t,n,u,a,f){a();const e=t(1),o=t(111),_=e.__importDefault(t(123));u.default=function(t){return Math.abs(t)<=o.SPI?t:t-(0,_.default)(t)*o.TWO_PI}},
function _(n,t,u,f,c){f(),u.default=function(n){return n<0?-1:1}},
function _(t,n,a,o,u){o();const c=t(111);a.default=function(t,n,a){var o=t*a,u=.5*t;return o=Math.pow((1-o)/(1+o),u),Math.tan(.5*(c.HALF_PI-n))/o}},
function _(t,a,n,r,f){r();const h=t(111);n.default=function(t,a){for(var n,r,f=.5*t,o=h.HALF_PI-2*Math.atan(a),u=0;u<=15;u++)if(n=t*Math.sin(o),o+=r=h.HALF_PI-2*Math.atan(a*Math.pow((1-n)/(1+n),f))-o,Math.abs(r)<=1e-10)return o;return-9999}},
function _(n,i,e,t,r){function a(){}function f(n){return n}t(),e.init=a,e.forward=f,e.inverse=f,e.names=["longlat","identity"],e.default={init:a,forward:f,inverse:f,names:e.names}},
function _(t,r,e,a,n){a();const f=t(1),i=t(111),u=f.__importStar(t(128)),c=f.__importDefault(t(114));e.eccentricity=function(t,r,e,a){var n=t*t,f=r*r,u=(n-f)/n,c=0;return a?(n=(t*=1-u*(i.SIXTH+u*(i.RA4+u*i.RA6)))*t,u=0):c=Math.sqrt(u),{es:u,e:c,ep2:(n-f)/f}},e.sphere=function(t,r,e,a,n){if(!t){var f=(0,c.default)(u.default,a);f||(f=u.WGS84),t=f.a,r=f.b,e=f.rf}return e&&!r&&(r=(1-1/e)*t),(0===e||Math.abs(t-r)<i.EPSLN)&&(n=!0,r=t),{a:t,b:r,rf:e,sphere:n}}},
function _(e,a,l,s,r){s();var i={};l.default=i,i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s,t,l){t();var m={};s.default=m,m.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},m.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},m.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},m.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},m.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},m.potsdam={towgs84:"598.1,73.7,418.2,0.202,0.045,-2.455,6.7",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},m.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},m.hermannskogel={towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Hermannskogel"},m.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},m.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},m.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},m.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},m.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},m.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},m.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},m.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},m.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_,t,u){t();const d=a(111);_.default=function(a,m,_,t,u,p,r){var s={};return s.datum_type=void 0===a||"none"===a?d.PJD_NODATUM:d.PJD_WGS84,m&&(s.datum_params=m.map(parseFloat),0===s.datum_params[0]&&0===s.datum_params[1]&&0===s.datum_params[2]||(s.datum_type=d.PJD_3PARAM),s.datum_params.length>3&&(0===s.datum_params[3]&&0===s.datum_params[4]&&0===s.datum_params[5]&&0===s.datum_params[6]||(s.datum_type=d.PJD_7PARAM,s.datum_params[3]*=d.SEC_TO_RAD,s.datum_params[4]*=d.SEC_TO_RAD,s.datum_params[5]*=d.SEC_TO_RAD,s.datum_params[6]=s.datum_params[6]/1e6+1))),r&&(s.datum_type=d.PJD_GRIDSHIFT,s.grids=r),s.a=_,s.b=t,s.es=u,s.ep2=p,s}},
function _(t,e,n,r,i){r();var u={};function l(t){if(0===t.length)return null;var e="@"===t[0];return e&&(t=t.slice(1)),"null"===t?{name:"null",mandatory:!e,grid:null,isNull:!0}:{name:t,mandatory:!e,grid:u[t]||null,isNull:!1}}function o(t){return t/3600*Math.PI/180}function a(t,e,n){return String.fromCharCode.apply(null,new Uint8Array(t.buffer.slice(e,n)))}function d(t){return t.map((function(t){return[o(t.longitudeShift),o(t.latitudeShift)]}))}function g(t,e,n){return{name:a(t,e+8,e+16).trim(),parent:a(t,e+24,e+24+8).trim(),lowerLatitude:t.getFloat64(e+72,n),upperLatitude:t.getFloat64(e+88,n),lowerLongitude:t.getFloat64(e+104,n),upperLongitude:t.getFloat64(e+120,n),latitudeInterval:t.getFloat64(e+136,n),longitudeInterval:t.getFloat64(e+152,n),gridNodeCount:t.getInt32(e+168,n)}}function s(t,e,n,r){for(var i=e+176,u=[],l=0;l<n.gridNodeCount;l++){var o={latitudeShift:t.getFloat32(i+16*l,r),longitudeShift:t.getFloat32(i+16*l+4,r),latitudeAccuracy:t.getFloat32(i+16*l+8,r),longitudeAccuracy:t.getFloat32(i+16*l+12,r)};u.push(o)}return u}n.default=function(t,e){var n=new DataView(e),r=function(t){var e=t.getInt32(8,!1);if(11===e)return!1;11!==(e=t.getInt32(8,!0))&&console.warn("Failed to detect nadgrid endian-ness, defaulting to little-endian");return!0}(n),i=function(t,e){return{nFields:t.getInt32(8,e),nSubgridFields:t.getInt32(24,e),nSubgrids:t.getInt32(40,e),shiftType:a(t,56,64).trim(),fromSemiMajorAxis:t.getFloat64(120,e),fromSemiMinorAxis:t.getFloat64(136,e),toSemiMajorAxis:t.getFloat64(152,e),toSemiMinorAxis:t.getFloat64(168,e)}}(n,r);i.nSubgrids>1&&console.log("Only single NTv2 subgrids are currently supported, subsequent sub grids are ignored");var l=function(t,e,n){for(var r=176,i=[],u=0;u<e.nSubgrids;u++){var l=g(t,r,n),a=s(t,r,l,n),f=Math.round(1+(l.upperLongitude-l.lowerLongitude)/l.longitudeInterval),c=Math.round(1+(l.upperLatitude-l.lowerLatitude)/l.latitudeInterval);i.push({ll:[o(l.lowerLongitude),o(l.lowerLatitude)],del:[o(l.longitudeInterval),o(l.latitudeInterval)],lim:[f,c],count:l.gridNodeCount,cvs:d(a)})}return i}(n,i,r),f={header:i,subgrids:l};return u[t]=f,f},n.getNadgrids=function(t){return void 0===t?null:t.split(",").map(l)}},
function _(t,e,a,r,u){r();const m=t(1),_=t(111),o=m.__importDefault(t(133)),d=m.__importDefault(t(135)),f=m.__importDefault(t(106)),n=m.__importDefault(t(136)),i=m.__importDefault(t(137));a.default=function t(e,a,r,u){var m;if(Array.isArray(r)&&(r=(0,n.default)(r)),(0,i.default)(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===_.PJD_3PARAM||t.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==e.datumCode||(e.datum.datum_type===_.PJD_3PARAM||e.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==t.datumCode}(e,a)&&(r=t(e,m=new f.default("WGS84"),r,u),e=m),u&&"enu"!==e.axis&&(r=(0,d.default)(e,!1,r)),"longlat"===e.projName)r={x:r.x*_.D2R,y:r.y*_.D2R,z:r.z||0};else if(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),!(r=e.inverse(r)))return;if(e.from_greenwich&&(r.x+=e.from_greenwich),r=(0,o.default)(e.datum,a.datum,r))return a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*_.R2D,y:r.y*_.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),u&&"enu"!==a.axis?(0,d.default)(a,!0,r):r}},
function _(r,e,t,a,i){a();const l=r(1),n=r(111),o=r(134),u=l.__importDefault(r(122));function d(r){return r===n.PJD_3PARAM||r===n.PJD_7PARAM}function s(r,e,t){if(null===r.grids||0===r.grids.length)return console.log("Grid shift grids not found"),-1;for(var a={x:-t.x,y:t.y},i={x:Number.NaN,y:Number.NaN},l=[],o=0;o<r.grids.length;o++){var u=r.grids[o];if(l.push(u.name),u.isNull){i=a;break}if(u.mandatory,null!==u.grid){var d=u.grid.subgrids[0],s=(Math.abs(d.del[1])+Math.abs(d.del[0]))/1e4,f=d.ll[0]-s,x=d.ll[1]-s,m=d.ll[0]+(d.lim[0]-1)*d.del[0]+s,N=d.ll[1]+(d.lim[1]-1)*d.del[1]+s;if(!(x>a.y||f>a.x||N<a.y||m<a.x||(i=y(a,e,d),isNaN(i.x))))break}else if(u.mandatory)return console.log("Unable to find mandatory grid '"+u.name+"'"),-1}return isNaN(i.x)?(console.log("Failed to find a grid shift table for location '"+-a.x*n.R2D+" "+a.y*n.R2D+" tried: '"+l+"'"),-1):(t.x=-i.x,t.y=i.y,0)}function y(r,e,t){var a={x:Number.NaN,y:Number.NaN};if(isNaN(r.x))return a;var i={x:r.x,y:r.y};i.x-=t.ll[0],i.y-=t.ll[1],i.x=(0,u.default)(i.x-Math.PI)+Math.PI;var l=f(i,t);if(e){if(isNaN(l.x))return a;l.x=i.x-l.x,l.y=i.y-l.y;var n,o,d=9;do{if(o=f(l,t),isNaN(o.x)){console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");break}n={x:i.x-(o.x+l.x),y:i.y-(o.y+l.y)},l.x+=n.x,l.y+=n.y}while(d--&&Math.abs(n.x)>1e-12&&Math.abs(n.y)>1e-12);if(d<0)return console.log("Inverse grid shift iterator failed to converge."),a;a.x=(0,u.default)(l.x+t.ll[0]),a.y=l.y+t.ll[1]}else isNaN(l.x)||(a.x=r.x+l.x,a.y=r.y+l.y);return a}function f(r,e){var t,a={x:r.x/e.del[0],y:r.y/e.del[1]},i=Math.floor(a.x),l=Math.floor(a.y),n=a.x-1*i,o=a.y-1*l,u={x:Number.NaN,y:Number.NaN};if(i<0||i>=e.lim[0])return u;if(l<0||l>=e.lim[1])return u;t=l*e.lim[0]+i;var d=e.cvs[t][0],s=e.cvs[t][1];t++;var y=e.cvs[t][0],f=e.cvs[t][1];t+=e.lim[0];var x=e.cvs[t][0],m=e.cvs[t][1];t--;var N=e.cvs[t][0],c=e.cvs[t][1],_=n*o,g=n*(1-o),v=(1-n)*(1-o),S=(1-n)*o;return u.x=v*d+g*y+S*N+_*x,u.y=v*s+g*f+S*c+_*m,u}t.default=function(r,e,t){if((0,o.compareDatums)(r,e))return t;if(r.datum_type===n.PJD_NODATUM||e.datum_type===n.PJD_NODATUM)return t;var a=r.a,i=r.es;if(r.datum_type===n.PJD_GRIDSHIFT){if(0!==s(r,!1,t))return;a=n.SRS_WGS84_SEMIMAJOR,i=n.SRS_WGS84_ESQUARED}var l=e.a,u=e.b,y=e.es;if(e.datum_type===n.PJD_GRIDSHIFT&&(l=n.SRS_WGS84_SEMIMAJOR,u=n.SRS_WGS84_SEMIMINOR,y=n.SRS_WGS84_ESQUARED),i===y&&a===l&&!d(r.datum_type)&&!d(e.datum_type))return t;if(t=(0,o.geodeticToGeocentric)(t,i,a),d(r.datum_type)&&(t=(0,o.geocentricToWgs84)(t,r.datum_type,r.datum_params)),d(e.datum_type)&&(t=(0,o.geocentricFromWgs84)(t,e.datum_type,e.datum_params)),t=(0,o.geocentricToGeodetic)(t,y,l,u),e.datum_type===n.PJD_GRIDSHIFT&&0!==s(e,!0,t))return;return t},t.applyGridShift=s},
function _(a,t,r,m,s){m();const u=a(111);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===u.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==u.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,s,_,e,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-u.HALF_PI&&d>-1.001*u.HALF_PI)d=-u.HALF_PI;else if(d>u.HALF_PI&&d<1.001*u.HALF_PI)d=u.HALF_PI;else{if(d<-u.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>u.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),s=Math.sin(d),e=Math.cos(d),_=s*s,{x:((m=r/Math.sqrt(1-t*_))+i)*e*Math.cos(n),y:(m+i)*e*Math.sin(n),z:(m*(1-t)+i)*s}},r.geocentricToGeodetic=function(a,t,r,m){var s,_,e,n,d,i,p,P,y,z,M,o,A,c,x,h=1e-12,f=a.x,I=a.y,F=a.z?a.z:0;if(s=Math.sqrt(f*f+I*I),_=Math.sqrt(f*f+I*I+F*F),s/r<h){if(c=0,_/r<h)return u.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(I,f);e=F/_,P=(n=s/_)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),y=e*d,A=0;do{A++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(x=s*P+F*y-p*(1-t*y*y))),o=(M=e*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(z=n*(1-i)*d)*y,P=z,y=M}while(o*o>1e-24&&A<30);return{x:c,y:Math.atan(M/Math.abs(z)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-e*a.z)+s,z:i*(-n*a.x+e*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===u.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===u.PJD_7PARAM){var m=r[0],s=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-s)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+e*y,z:n*p-e*P+y}}}},
function _(e,a,i,s,n){s(),i.default=function(e,a,i){var s,n,r,c=i.x,d=i.y,f=i.z||0,u={};for(r=0;r<3;r++)if(!a||2!==r||void 0!==i.z)switch(0===r?(s=c,n=-1!=="ew".indexOf(e.axis[r])?"x":"y"):1===r?(s=d,n=-1!=="ns".indexOf(e.axis[r])?"y":"x"):(s=f,n="z"),e.axis[r]){case"e":case"n":u[n]=s;break;case"w":case"s":u[n]=-s;break;case"u":void 0!==i[n]&&(u.z=s);break;case"d":void 0!==i[n]&&(u.z=-s);break;default:return null}return u}},
function _(n,t,e,u,f){u(),e.default=function(n){var t={x:n[0],y:n[1]};return n.length>2&&(t.z=n[2]),n.length>3&&(t.m=n[3]),t}},
function _(e,i,n,t,r){function o(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}t(),n.default=function(e){o(e.x),o(e.y)}},
function _(e,i,s,o,n){o();const t=e(1);var l,a,r,_,c;const d=e(139),p=e(77),T=t.__importStar(e(17));class m extends d.MarkingView{}s.ArrowHeadView=m,m.__name__="ArrowHeadView";class v extends d.Marking{constructor(e){super(e)}}s.ArrowHead=v,l=v,v.__name__="ArrowHead",l.define((()=>({size:[T.NumberSpec,25]})));class u extends m{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(0,0),e.lineTo(.5*s,s)}render(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),this.visuals.line.apply(e,i)}}s.OpenHeadView=u,u.__name__="OpenHeadView";class h extends v{constructor(e){super(e)}}s.OpenHead=h,a=h,h.__name__="OpenHead",a.prototype.default_view=u,a.mixins(p.LineVector);class V extends m{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(.5*s,s)}render(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.closePath(),this.visuals.fill.apply(e,i),this.visuals.line.apply(e,i)}}s.NormalHeadView=V,V.__name__="NormalHeadView";class H extends v{constructor(e){super(e)}}s.NormalHead=H,r=H,H.__name__="NormalHead",r.prototype.default_view=V,r.mixins([p.LineVector,p.FillVector]),r.override({fill_color:"black"});class w extends m{clip(e,i){this.visuals.line.set_vectorize(e,i);const s=this.size.get(i);e.moveTo(.5*s,s),e.lineTo(.5*s,-2),e.lineTo(-.5*s,-2),e.lineTo(-.5*s,s),e.lineTo(0,.5*s),e.lineTo(.5*s,s)}render(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,s),e.lineTo(0,0),e.lineTo(-.5*s,s),e.lineTo(0,.5*s),e.closePath(),this.visuals.fill.apply(e,i),this.visuals.line.apply(e,i)}}s.VeeHeadView=w,w.__name__="VeeHeadView";class x extends v{constructor(e){super(e)}}s.VeeHead=x,_=x,x.__name__="VeeHead",_.prototype.default_view=w,_.mixins([p.LineVector,p.FillVector]),_.override({fill_color:"black"});class g extends m{render(e,i){const s=this.size.get(i);e.beginPath(),e.moveTo(.5*s,0),e.lineTo(-.5*s,0),this.visuals.line.apply(e,i)}clip(e,i){}}s.TeeHeadView=g,g.__name__="TeeHeadView";class z extends v{constructor(e){super(e)}}s.TeeHead=z,c=z,z.__name__="TeeHead",c.prototype.default_view=g,c.mixins(p.LineVector)},
function _(e,t,n,i,s){i();const a=e(1);var r;const c=e(50),o=e(53),_=a.__importStar(e(74)),u=a.__importStar(e(17));class l extends o.View{initialize(){super.initialize(),this.visuals=new _.Visuals(this)}request_render(){this.parent.request_render()}get canvas(){return this.parent.canvas}set_data(e,t){const n=this;for(const i of this.model){if(!(i instanceof u.VectorSpec||i instanceof u.ScalarSpec))continue;const s=i.uniform(e).select(t);n[`${i.attr}`]=s}}}n.MarkingView=l,l.__name__="MarkingView";class d extends c.Model{constructor(e){super(e)}}n.Marking=d,r=d,d.__name__="Marking",r.define((({})=>({})))},
function _(t,e,i,o,r){o();const a=t(1);var n;const s=t(72),_=t(141),l=t(156),h=t(157),c=t(160),u=t(191),m=t(161),p=t(218),d=t(162),f=t(222),g=t(224),b=t(146),w=t(19),y=a.__importStar(t(77)),x=t(225),v=t(226),j=t(228),k=t(143),z=t(58),B=t(56),L=t(8),T=t(9);class S extends s.AnnotationView{get orientation(){return this._orientation}initialize(){super.initialize();const{ticker:t,formatter:e}=this.model;this._ticker="auto"!=t?t:this._create_ticker(),this._formatter="auto"!=e?e:this._create_formatter(),this._major_range=this._create_major_range(),this._major_scale=this._create_major_scale(),this._minor_range=new g.Range1d({start:0,end:1}),this._minor_scale=new f.LinearScale,this._frame=new l.CartesianFrame(this._major_scale,this._minor_scale,this._major_range,this._minor_range),this._axis=this._create_axis(),this._apply_axis_properties(),this._title=new _.Title,this._apply_title_properties()}async lazy_initialize(){await super.lazy_initialize();const t=this,e={get parent(){return t.parent},get root(){return t.root},get frame(){return t._frame},get canvas_view(){return t.parent.canvas_view},request_layout(){t.parent.request_layout()},request_paint(){t.parent.request_paint(t)},request_render(){t.request_paint()}};this._axis_view=await(0,z.build_view)(this._axis,{parent:e}),this._title_view=await(0,z.build_view)(this._title,{parent:e})}remove(){this._title_view.remove(),this._axis_view.remove(),super.remove()}_apply_axis_properties(){const t=Object.assign(Object.assign(Object.assign({ticker:this._ticker,formatter:this._formatter,major_label_standoff:this.model.label_standoff,axis_line_color:null,major_tick_in:this.model.major_tick_in,major_tick_out:this.model.major_tick_out,minor_tick_in:this.model.minor_tick_in,minor_tick_out:this.model.minor_tick_out,major_label_overrides:this.model.major_label_overrides,major_label_policy:this.model.major_label_policy},y.attrs_of(this.model,"major_label_",y.Text,!0)),y.attrs_of(this.model,"major_tick_",y.Line,!0)),y.attrs_of(this.model,"minor_tick_",y.Line,!0));this._axis.setv(t)}_apply_title_properties(){var t;const e=Object.assign({text:null!==(t=this.model.title)&&void 0!==t?t:"",standoff:this.model.title_standoff},y.attrs_of(this.model,"title_",y.Text,!1));this._title.setv(e)}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>{this._apply_title_properties(),this._apply_axis_properties()})),this.connect(this._ticker.change,(()=>this.request_render())),this.connect(this._formatter.change,(()=>this.request_render()))}_update_frame(){const[t,e,i,o]=(()=>"horizontal"==this.orientation?[this._major_scale,this._minor_scale,this._major_range,this._minor_range]:[this._minor_scale,this._major_scale,this._minor_range,this._major_range])();this._frame.in_x_scale=t,this._frame.in_y_scale=e,this._frame.x_range=i,this._frame.y_range=o,this._frame.configure_scales()}update_layout(){const{location:t,width:e,height:i,padding:o,margin:r}=this.model,[a,n]=(()=>{if(!(0,L.isString)(t))return["end","start"];switch(t){case"top_left":return["start","start"];case"top":case"top_center":return["start","center"];case"top_right":return["start","end"];case"bottom_left":return["end","start"];case"bottom":case"bottom_center":return["end","center"];case"bottom_right":return["end","end"];case"left":case"center_left":return["center","start"];case"center":case"center_center":return["center","center"];case"right":case"center_right":return["center","end"]}})(),s=this._orientation=(()=>{const{orientation:t}=this.model;return"auto"==t?null!=this.panel?this.panel.is_horizontal?"horizontal":"vertical":"start"==n||"end"==n||"center"==a?"vertical":"horizontal":t})();this._update_frame();const _=new v.NodeLayout,l=new v.VStack,h=new v.VStack,c=new v.HStack,u=new v.HStack;_.absolute=!0,l.absolute=!0,h.absolute=!0,c.absolute=!0,u.absolute=!0,_.on_resize((t=>this._frame.set_geometry(t)));const m=new j.BorderLayout;this._inner_layout=m,m.absolute=!0,m.center_panel=_,m.top_panel=l,m.bottom_panel=h,m.left_panel=c,m.right_panel=u;const p={left:o,right:o,top:o,bottom:o},d=(()=>{if(null==this.panel){if((0,L.isString)(t))return{left:r,right:r,top:r,bottom:r};{const[e,i]=t;return{left:e,right:r,top:r,bottom:i}}}if(!(0,L.isString)(t)){const[e,i]=t;return m.fixup_geometry=(t,o)=>{const r=t,a=this.layout.bbox,{width:n,height:s}=t;if(t=new B.BBox({left:a.left+e,bottom:a.bottom-i,width:n,height:s}),null!=o){const e=t.left-r.left,i=t.top-r.top,{left:a,top:n,width:s,height:_}=o;o=new B.BBox({left:a+e,top:n+i,width:s,height:_})}return[t,o]},{left:e,right:0,top:0,bottom:i}}m.fixup_geometry=(t,e)=>{const i=t;if("horizontal"==s){const{top:e,width:i,height:o}=t;if("end"==n){const{right:r}=this.layout.bbox;t=new B.BBox({right:r,top:e,width:i,height:o})}else if("center"==n){const{hcenter:r}=this.layout.bbox;t=new B.BBox({hcenter:Math.round(r),top:e,width:i,height:o})}}else{const{left:e,width:i,height:o}=t;if("end"==a){const{bottom:r}=this.layout.bbox;t=new B.BBox({left:e,bottom:r,width:i,height:o})}else if("center"==a){const{vcenter:r}=this.layout.bbox;t=new B.BBox({left:e,vcenter:Math.round(r),width:i,height:o})}}if(null!=e){const o=t.left-i.left,r=t.top-i.top,{left:a,top:n,width:s,height:_}=e;e=new B.BBox({left:a+o,top:n+r,width:s,height:_})}return[t,e]}})();let f,g,b,w;if(m.padding=p,null!=this.panel)f="max",g=void 0,b=void 0,w=void 0;else if("auto"==("horizontal"==s?e:i)){f="fixed";const t=this._get_major_size_factor();null!=t&&(g=25*t),b={percent:.3},w={percent:.8}}else f="fit",g=void 0;if("horizontal"==s){const t="auto"==e?void 0:e,o="auto"==i?25:i;m.set_sizing({width_policy:f,height_policy:"min",width:g,min_width:b,max_width:w,halign:n,valign:a,margin:d}),m.center_panel.set_sizing({width_policy:"auto"==e?"fit":"fixed",height_policy:"fixed",width:t,height:o})}else{const t="auto"==e?25:e,o="auto"==i?void 0:i;m.set_sizing({width_policy:"min",height_policy:f,height:g,min_height:b,max_height:w,halign:n,valign:a,margin:d}),m.center_panel.set_sizing({width_policy:"fixed",height_policy:"auto"==i?"fit":"fixed",width:t,height:o})}l.set_sizing({width_policy:"fit",height_policy:"min"}),h.set_sizing({width_policy:"fit",height_policy:"min"}),c.set_sizing({width_policy:"min",height_policy:"fit"}),u.set_sizing({width_policy:"min",height_policy:"fit"});const{_title_view:y}=this;"horizontal"==s?(y.panel=new k.Panel("above"),y.update_layout(),l.children.push(y.layout)):(y.panel=new k.Panel("left"),y.update_layout(),c.children.push(y.layout));const{panel:z}=this,T=null!=z&&s==z.orientation?z.side:"horizontal"==s?"below":"right",S=(()=>{switch(T){case"above":return l;case"below":return h;case"left":return c;case"right":return u}})(),{_axis_view:O}=this;if(O.panel=new k.Panel(T),O.update_layout(),S.children.push(O.layout),null!=this.panel){const t=new x.Grid([{layout:m,row:0,col:0}]);t.absolute=!0,"horizontal"==s?t.set_sizing({width_policy:"max",height_policy:"min"}):t.set_sizing({width_policy:"min",height_policy:"max"}),this.layout=t}else this.layout=this._inner_layout;const{visible:q}=this.model;this.layout.sizing.visible=q}_create_axis(){return new h.LinearAxis}_create_formatter(){return new p.BasicTickFormatter}_create_major_range(){return new g.Range1d({start:0,end:1})}_create_major_scale(){return new f.LinearScale}_create_ticker(){return new u.BasicTicker}_get_major_size_factor(){return null}_render(){const{ctx:t}=this.layer;t.save(),this._paint_bbox(t,this._inner_layout.bbox),this._paint_colors(t,this._inner_layout.center_panel.bbox),this._title_view.render(),this._axis_view.render(),t.restore()}_paint_bbox(t,e){const{x:i,y:o}=e;let{width:r,height:a}=e;i+r>=this.parent.canvas_view.bbox.width&&(r-=1),o+a>=this.parent.canvas_view.bbox.height&&(a-=1),t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(i,o,r,a)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(i,o,r,a)),t.restore()}serializable_state(){const t=super.serializable_state(),{children:e=[]}=t,i=a.__rest(t,["children"]);return e.push(this._title_view.serializable_state()),e.push(this._axis_view.serializable_state()),Object.assign(Object.assign({},i),{children:e})}}i.BaseColorBarView=S,S.__name__="BaseColorBarView";class O extends s.Annotation{constructor(t){super(t)}}i.BaseColorBar=O,n=O,O.__name__="BaseColorBar",n.mixins([["major_label_",y.Text],["title_",y.Text],["major_tick_",y.Line],["minor_tick_",y.Line],["border_",y.Line],["bar_",y.Line],["background_",y.Fill]]),n.define((({Alpha:t,Number:e,String:i,Tuple:o,Map:r,Or:a,Ref:n,Auto:s,Nullable:_})=>({location:[a(w.Anchor,o(e,e)),"top_right"],orientation:[a(w.Orientation,s),"auto"],title:[_(i),null],title_standoff:[e,2],width:[a(e,s),"auto"],height:[a(e,s),"auto"],scale_alpha:[t,1],ticker:[a(n(c.Ticker),s),"auto"],formatter:[a(n(m.TickFormatter),s),"auto"],major_label_overrides:[r(a(i,e),a(i,n(b.BaseText))),new globalThis.Map,{convert:t=>(0,L.isPlainObject)(t)?new T.Dict(t):t}],major_label_policy:[n(d.LabelingPolicy),()=>new d.NoOverlap],label_standoff:[e,5],margin:[e,30],padding:[e,10],major_tick_in:[e,5],major_tick_out:[e,0],minor_tick_in:[e,0],minor_tick_out:[e,0]}))),n.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(e,t,i,s,a){var c;s();const o=e(142),r=e(19);class n extends o.TextAnnotationView{_get_position(){const e=this.model.offset,t=this.model.standoff/2,{align:i,vertical_align:s}=this.model;let a,c;const{bbox:o}=this.layout;switch(this.panel.side){case"above":case"below":switch(s){case"top":c=o.top+t;break;case"middle":c=o.vcenter;break;case"bottom":c=o.bottom-t}switch(i){case"left":a=o.left+e;break;case"center":a=o.hcenter;break;case"right":a=o.right-e}break;case"left":switch(s){case"top":a=o.left+t;break;case"middle":a=o.hcenter;break;case"bottom":a=o.right-t}switch(i){case"left":c=o.bottom-e;break;case"center":c=o.vcenter;break;case"right":c=o.top+e}break;case"right":switch(s){case"top":a=o.right-t;break;case"middle":a=o.hcenter;break;case"bottom":a=o.left+t}switch(i){case"left":c=o.top+e;break;case"center":c=o.vcenter;break;case"right":c=o.bottom-e}}return{sx:a,sy:c,x_anchor:i,y_anchor:"middle"==s?"center":s}}_render(){const e=this._get_position(),t=this.panel.get_label_angle_heuristic("parallel");this._paint(this.layer.ctx,e,t)}_get_size(){if(!this.displayed)return{width:0,height:0};const e=this._text_view.graphics();e.visuals=this.visuals.text.values();const{width:t,height:i}=e._size();return{width:t,height:0==i?0:2+i+this.model.standoff}}}i.TitleView=n,n.__name__="TitleView";class l extends o.TextAnnotation{constructor(e){super(e)}}i.Title=l,c=l,l.__name__="Title",c.prototype.default_view=n,c.define((({Number:e})=>({vertical_align:[r.VerticalAlign,"bottom"],align:[r.TextAlign,"left"],offset:[e,0],standoff:[e,10]}))),c.override({text_font_size:"13px",text_font_style:"bold",text_line_height:1})},
function _(t,i,e,n,s){n();const o=t(1);var a;const l=t(72),_=t(143),r=t(146),h=t(58),d=t(8),c=t(147),u=o.__importStar(t(77));class x extends l.AnnotationView{async lazy_initialize(){await super.lazy_initialize(),await this._init_text()}async _init_text(){const{text:t}=this.model,i=(0,d.isString)(t)?(0,c.parse_delimited_string)(t):t;this._text_view=await(0,h.build_view)(i,{parent:this})}update_layout(){const{panel:t}=this;this.layout=null!=t?new _.SideLayout(t,(()=>this.get_size()),!0):void 0}connect_signals(){super.connect_signals();const{text:t}=this.model.properties;this.on_change(t,(async()=>{this._text_view.remove(),await this._init_text()})),this.connect(this.model.change,(()=>this.request_render()))}remove(){this._text_view.remove(),super.remove()}has_finished(){return!!super.has_finished()&&!!this._text_view.has_finished()}get displayed(){return super.displayed&&""!=this._text_view.model.text&&this.visuals.text.doit}_paint(t,i,e){const n=this._text_view.graphics();n.angle=e,n.position=i,n.align="auto",n.visuals=this.visuals.text.values();const{background_fill:s,border_line:o}=this.visuals;if(s.doit||o.doit){const{p0:i,p1:e,p2:s,p3:o}=n.rect();t.beginPath(),t.moveTo(i.x,i.y),t.lineTo(e.x,e.y),t.lineTo(s.x,s.y),t.lineTo(o.x,o.y),t.closePath(),this.visuals.background_fill.apply(t),this.visuals.border_line.apply(t)}this.visuals.text.doit&&n.paint(t)}}e.TextAnnotationView=x,x.__name__="TextAnnotationView";class p extends l.Annotation{constructor(t){super(t)}}e.TextAnnotation=p,a=p,p.__name__="TextAnnotation",a.mixins([u.Text,["border_",u.Line],["background_",u.Fill]]),a.define((({String:t,Or:i,Ref:e})=>({text:[i(t,e(r.BaseText)),""]}))),a.override({background_fill_color:null,border_line_color:null})},
function _(t,e,i,l,r){l();const a=t(144),o=t(145),n=t(8),h=Math.PI/2,s={above:{parallel:0,normal:-h,horizontal:0,vertical:-h},below:{parallel:0,normal:h,horizontal:0,vertical:h},left:{parallel:-h,normal:0,horizontal:0,vertical:-h},right:{parallel:h,normal:0,horizontal:0,vertical:h}},c={above:{parallel:"bottom",normal:"center",horizontal:"bottom",vertical:"center"},below:{parallel:"top",normal:"center",horizontal:"top",vertical:"center"},left:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"},right:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"}},g={above:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},below:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},left:{parallel:"center",normal:"right",horizontal:"right",vertical:"center"},right:{parallel:"center",normal:"left",horizontal:"left",vertical:"center"}},_={above:"right",below:"left",left:"right",right:"left"},b={above:"left",below:"right",left:"right",right:"left"};class z{constructor(t){this.side=t}get dimension(){return"above"==this.side||"below"==this.side?0:1}get normals(){switch(this.side){case"above":return[0,-1];case"below":return[0,1];case"left":return[-1,0];case"right":return[1,0]}}get orientation(){return this.is_horizontal?"horizontal":"vertical"}get is_horizontal(){return 0==this.dimension}get is_vertical(){return 1==this.dimension}get_label_text_heuristics(t){const{side:e}=this;return(0,n.isString)(t)?{vertical_align:c[e][t],align:g[e][t]}:{vertical_align:"center",align:(t<0?_:b)[e]}}get_label_angle_heuristic(t){return(0,n.isString)(t)?s[this.side][t]:-t}}i.Panel=z,z.__name__="Panel";class m extends o.ContentLayoutable{constructor(t,e,i=!1){super(),this.panel=t,this.get_size=e,this.rotate=i,this.panel.is_horizontal?this.set_sizing({width_policy:"max",height_policy:"fixed"}):this.set_sizing({width_policy:"fixed",height_policy:"max"})}_content_size(){const{width:t,height:e}=this.get_size();return!this.rotate||this.panel.is_horizontal?new a.Sizeable({width:t,height:e}):new a.Sizeable({width:e,height:t})}has_size_changed(){const{width:t,height:e}=this._content_size();return this.panel.is_horizontal?this.bbox.height!=e:this.bbox.width!=t}}i.SideLayout=m,m.__name__="SideLayout"},
function _(h,t,i,e,w){e();const n=h(20),{min:d,max:s}=Math;class g{constructor(h={}){this.width=null!=h.width?h.width:0,this.height=null!=h.height?h.height:0}bounded_to({width:h,height:t}){return new g({width:this.width==1/0&&null!=h?h:this.width,height:this.height==1/0&&null!=t?t:this.height})}expanded_to({width:h,height:t}){return new g({width:h!=1/0?s(this.width,h):this.width,height:t!=1/0?s(this.height,t):this.height})}expand_to({width:h,height:t}){this.width=s(this.width,h),this.height=s(this.height,t)}narrowed_to({width:h,height:t}){return new g({width:d(this.width,h),height:d(this.height,t)})}narrow_to({width:h,height:t}){this.width=d(this.width,h),this.height=d(this.height,t)}grow_by({left:h,right:t,top:i,bottom:e}){const w=this.width+h+t,n=this.height+i+e;return new g({width:w,height:n})}shrink_by({left:h,right:t,top:i,bottom:e}){const w=s(this.width-h-t,0),n=s(this.height-i-e,0);return new g({width:w,height:n})}map(h,t){return new g({width:h(this.width),height:(null!=t?t:h)(this.height)})}}i.Sizeable=g,g.__name__="Sizeable",i.SizingPolicy=(0,n.Enum)("fixed","fit","min","max")},
function _(i,t,h,e,s){e();const n=i(144),g=i(56),r=i(8),{min:_,max:o,round:a}=Math;class l{constructor(){this.absolute=!1,this._bbox=new g.BBox,this._inner_bbox=new g.BBox,this._dirty=!1,this._handlers=[]}*[Symbol.iterator](){}get bbox(){return this._bbox}get inner_bbox(){return this._inner_bbox}get sizing(){return this._sizing}set visible(i){this._sizing.visible=i,this._dirty=!0}set_sizing(i={}){var t,h,e,s,n,g;const r=null!==(t=i.width_policy)&&void 0!==t?t:"fit",_=i.width,o=i.min_width,a=i.max_width,l=null!==(h=i.height_policy)&&void 0!==h?h:"fit",d=i.height,u=i.min_height,c=i.max_height,w=i.aspect,b=null!==(e=i.margin)&&void 0!==e?e:{top:0,right:0,bottom:0,left:0},x=null===(s=i.visible)||void 0===s||s,m=null!==(n=i.halign)&&void 0!==n?n:"start",p=null!==(g=i.valign)&&void 0!==g?g:"start";this._sizing={width_policy:r,min_width:o,width:_,max_width:a,height_policy:l,min_height:u,height:d,max_height:c,aspect:w,margin:b,visible:x,halign:m,valign:p,size:{width:_,height:d}},this._init()}_init(){}_set_geometry(i,t){this._bbox=i,this._inner_bbox=t}set_geometry(i,t){const{fixup_geometry:h}=this;null!=h&&([i,t]=h(i,t)),this._set_geometry(i,null!=t?t:i);for(const i of this._handlers)i(this._bbox,this._inner_bbox)}on_resize(i){this._handlers.push(i)}is_width_expanding(){return"max"==this.sizing.width_policy}is_height_expanding(){return"max"==this.sizing.height_policy}apply_aspect(i,{width:t,height:h}){const{aspect:e}=this.sizing;if(null!=e){const{width_policy:s,height_policy:n}=this.sizing,g=(i,t)=>{const h={max:4,fit:3,min:2,fixed:1};return h[i]>h[t]};if("fixed"!=s&&"fixed"!=n)if(s==n){const s=t,n=a(t/e),g=a(h*e),r=h;Math.abs(i.width-s)+Math.abs(i.height-n)<=Math.abs(i.width-g)+Math.abs(i.height-r)?(t=s,h=n):(t=g,h=r)}else g(s,n)?h=a(t/e):t=a(h*e);else"fixed"==s?h=a(t/e):"fixed"==n&&(t=a(h*e))}return{width:t,height:h}}measure(i){if(!this.sizing.visible)return{width:0,height:0};const t=i=>"fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:i,h=i=>"fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:i,e=new n.Sizeable(i).shrink_by(this.sizing.margin).map(t,h),s=this._measure(e),g=this.clip_size(s,e),r=t(g.width),_=h(g.height),o=this.apply_aspect(e,{width:r,height:_});return Object.assign(Object.assign({},s),o)}compute(i={}){const t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),{width:h,height:e}=t,s=new g.BBox({left:0,top:0,width:h,height:e});let n;if(null!=t.inner){const{left:i,top:s,right:r,bottom:_}=t.inner;n=new g.BBox({left:i,top:s,right:h-r,bottom:e-_})}this.set_geometry(s,n)}get xview(){return this.bbox.xview}get yview(){return this.bbox.yview}clip_size(i,t){function h(i,t,h,e){return null==h?h=0:(0,r.isNumber)(h)||(h=Math.round(h.percent*t)),null==e?e=1/0:(0,r.isNumber)(e)||(e=Math.round(e.percent*t)),o(h,_(i,e))}return{width:h(i.width,t.width,this.sizing.min_width,this.sizing.max_width),height:h(i.height,t.height,this.sizing.min_height,this.sizing.max_height)}}has_size_changed(){const{_dirty:i}=this;return this._dirty=!1,i}}h.Layoutable=l,l.__name__="Layoutable";class d extends l{_measure(i){const t=this._content_size(),h=i.bounded_to(this.sizing.size).bounded_to(t);return{width:(()=>{switch(this.sizing.width_policy){case"fixed":return null!=this.sizing.width?this.sizing.width:t.width;case"min":return t.width;case"fit":return h.width;case"max":return Math.max(t.width,h.width)}})(),height:(()=>{switch(this.sizing.height_policy){case"fixed":return null!=this.sizing.height?this.sizing.height:t.height;case"min":return t.height;case"fit":return h.height;case"max":return Math.max(t.height,h.height)}})()}}}h.ContentLayoutable=d,d.__name__="ContentLayoutable"},
function _(e,s,t,n,a){var _;n();const x=e(50),c=e(53);class i extends c.View{}t.BaseTextView=i,i.__name__="BaseTextView";class o extends x.Model{constructor(e){super(e)}}t.BaseText=o,_=o,o.__name__="BaseText",_.define((({String:e})=>({text:[e]})))},
function _(n,e,t,i,r){i();const s=n(148),l=n(155),d=[{start:"$$",end:"$$",inline:!1},{start:"\\[",end:"\\]",inline:!1},{start:"\\(",end:"\\)",inline:!0}];t.parse_delimited_string=function(n){for(const e of d){const t=n.indexOf(e.start),i=t+e.start.length;if(0==t){const t=n.indexOf(e.end,i),r=t;if(t==n.length-e.end.length)return new s.TeX({text:n.slice(i,r),inline:e.inline});break}}return new l.PlainText({text:n})}},
function _(t,e,i,s,n){var o,h,r;s();const a=t(8),l=t(149),_=t(21),c=t(150),d=t(151),u=t(38),g=t(152),x=t(56),p=t(146),f=t(153);class m extends p.BaseTextView{constructor(){super(...arguments),this._position={sx:0,sy:0},this.align="left",this._x_anchor="left",this._y_anchor="center",this._base_font_size=13,this.font_size_scale=1,this.svg_image=null}graphics(){return this}infer_text_height(){return"ascent_descent"}set base_font_size(t){null!=t&&(this._base_font_size=t)}get base_font_size(){return this._base_font_size}_rect(){const{width:t,height:e}=this._size(),{x:i,y:s}=this._computed_position();return new x.BBox({x:i,y:s,width:t,height:e}).rect}set position(t){this._position=t}get position(){return this._position}get text(){return this.model.text}get provider(){return f.default_provider}async lazy_initialize(){await super.lazy_initialize(),"not_started"==this.provider.status&&await this.provider.fetch()}connect_signals(){super.connect_signals(),this.on_change(this.model.properties.text,(()=>this.load_image()))}set visuals(t){const e=t.color,i=t.alpha,s=t.font_style;let n=t.font_size;const o=t.font,{font_size_scale:h,_base_font_size:r}=this,a=(0,d.parse_css_font_size)(n);if(null!=a){let{value:t,unit:e}=a;t*=h,"em"==e&&r&&(t*=r,e="px"),n=`${t}${e}`}const l=`${s} ${n} ${o}`;this.font=l,this.color=(0,_.color2css)(e,i);const c=t.align;this._x_anchor=c;const u=t.baseline;this._y_anchor=(()=>{switch(u){case"top":return"top";case"middle":return"center";case"bottom":return"bottom";default:return"baseline"}})()}_computed_position(){const{width:t,height:e}=this._size(),{sx:i,sy:s,x_anchor:n=this._x_anchor,y_anchor:o=this._y_anchor}=this.position,h=(0,d.font_metrics)(this.font);return{x:i-(()=>{if((0,a.isNumber)(n))return n*t;switch(n){case"left":return 0;case"center":return.5*t;case"right":return t}})(),y:s-(()=>{if((0,a.isNumber)(o))return o*e;switch(o){case"top":return h.height>e?e-(-this.valign-h.descent)-h.height:0;case"center":case"baseline":return.5*e;case"bottom":return h.height>e?e+h.descent+this.valign:e}})()}}size(){const{width:t,height:e}=this._size(),{angle:i}=this;if(null==i||0==i)return{width:t,height:e};{const s=Math.cos(Math.abs(i)),n=Math.sin(Math.abs(i));return{width:Math.abs(t*s+e*n),height:Math.abs(t*n+e*s)}}}get_image_dimensions(){var t,e,i,s,n;const o=(0,d.font_metrics)(this.font),h=parseFloat(null!==(e=null===(t=this.svg_element.getAttribute("height"))||void 0===t?void 0:t.replace(/([A-z])/g,""))&&void 0!==e?e:"0"),r=parseFloat(null!==(s=null===(i=this.svg_element.getAttribute("width"))||void 0===i?void 0:i.replace(/([A-z])/g,""))&&void 0!==s?s:"0"),a=null===(n=this.svg_element.getAttribute("style"))||void 0===n?void 0:n.split(";");if(a){const t=new Map;a.forEach((e=>{const[i,s]=e.split(":");i&&t.set(i.trim(),s.trim())}));const e=(0,d.parse_css_length)(t.get("vertical-align"));"ex"==(null==e?void 0:e.unit)?this.valign=e.value*o.x_height:"px"==(null==e?void 0:e.unit)&&(this.valign=e.value)}return{width:o.x_height*r,height:o.x_height*h}}get truncated_text(){return this.model.text.length>6?`${this.model.text.substring(0,6)}...`:this.model.text}_size(){var t,e;if(!this.svg_image)return"failed"==this.provider.status||"not_started"==this.provider.status?{width:(0,c.text_width)(this.truncated_text,this.font),height:(0,d.font_metrics)(this.font).height}:{width:this._base_font_size,height:this._base_font_size};const i=(0,d.font_metrics)(this.font);let{width:s,height:n}=this.get_image_dimensions();n=Math.max(n,i.height);return{width:s*("%"==(null===(t=this.width)||void 0===t?void 0:t.unit)?this.width.value:1),height:n*("%"==(null===(e=this.height)||void 0===e?void 0:e.unit)?this.height.value:1)}}bbox(){const{p0:t,p1:e,p2:i,p3:s}=this.rect(),n=Math.min(t.x,e.x,i.x,s.x),o=Math.min(t.y,e.y,i.y,s.y),h=Math.max(t.x,e.x,i.x,s.x),r=Math.max(t.y,e.y,i.y,s.y);return new x.BBox({left:n,right:h,top:o,bottom:r})}rect(){const t=this._rect(),{angle:e}=this;if(null==e||0==e)return t;{const{sx:i,sy:s}=this.position,n=new g.AffineTransform;return n.translate(i,s),n.rotate(e),n.translate(-i,-s),n.apply_rect(t)}}paint_rect(t){const{p0:e,p1:i,p2:s,p3:n}=this.rect();t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();const{round:o}=Math;t.moveTo(o(e.x),o(e.y)),t.lineTo(o(i.x),o(i.y)),t.lineTo(o(s.x),o(s.y)),t.lineTo(o(n.x),o(n.y)),t.closePath(),t.stroke(),t.restore()}paint_bbox(t){const{x:e,y:i,width:s,height:n}=this.bbox();t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();const{round:o}=Math;t.moveTo(o(e),o(i)),t.lineTo(o(e),o(i+n)),t.lineTo(o(e+s),o(i+n)),t.lineTo(o(e+s),o(i)),t.closePath(),t.stroke(),t.restore()}async load_image(){if(null==this.provider.MathJax)return null;const t=this._process_text();if(null==t)return this._has_finished=!0,null;const e=t.children[0];this.svg_element=e,e.setAttribute("font",this.font),e.setAttribute("stroke",this.color);const i=e.outerHTML,s=`data:image/svg+xml;utf-8,${encodeURIComponent(i)}`;return this.svg_image=await(0,l.load_image)(s),this.parent.request_layout(),this.svg_image}paint(t){this.svg_image||("not_started"!=this.provider.status&&"loading"!=this.provider.status||this.provider.ready.connect((()=>this.load_image())),"loaded"==this.provider.status&&this.load_image()),t.save();const{sx:e,sy:i}=this.position,{angle:s}=this;null!=s&&0!=s&&(t.translate(e,i),t.rotate(s),t.translate(-e,-i));const{x:n,y:o}=this._computed_position();if(this.svg_image){const{width:e,height:i}=this.get_image_dimensions();t.drawImage(this.svg_image,n,o,e,i)}else"failed"!=this.provider.status&&"not_started"!=this.provider.status||(t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic",t.fillText(this.truncated_text,n,o+(0,d.font_metrics)(this.font).ascent));t.restore(),this._has_finished||"failed"!=this.provider.status&&!this.svg_image||(this._has_finished=!0,this.parent.notify_finished_after_paint())}}i.MathTextView=m,m.__name__="MathTextView";class v extends p.BaseText{constructor(t){super(t)}}i.MathText=v,v.__name__="MathText";class y extends m{get styled_text(){return this.text}_process_text(){}_size(){return{width:(0,c.text_width)(this.text,this.font),height:(0,d.font_metrics)(this.font).height}}paint(t){t.save();const{sx:e,sy:i}=this.position,{angle:s}=this;null!=s&&0!=s&&(t.translate(e,i),t.rotate(s),t.translate(-e,-i));const{x:n,y:o}=this._computed_position();t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic",t.fillText(this.text,n,o+(0,d.font_metrics)(this.font).ascent),t.restore(),this._has_finished=!0,this.parent.notify_finished_after_paint()}}i.AsciiView=y,y.__name__="AsciiView";class b extends v{constructor(t){super(t)}}i.Ascii=b,o=b,b.__name__="Ascii",o.prototype.default_view=y;class w extends m{get styled_text(){let t=this.text.trim(),e=t.match(/<math(.*?[^?])?>/s);return e?(t=(0,u.insert_text_on_position)(t,t.indexOf(e[0])+e[0].length,`<mstyle displaystyle="true" mathcolor="${(0,_.color2hexrgb)(this.color)}" ${this.font.includes("bold")?'mathvariant="bold"':""}>`),e=t.match(/<\/[^>]*?math.*?>/s),e?(0,u.insert_text_on_position)(t,t.indexOf(e[0]),"</mstyle>"):this.text.trim()):this.text.trim()}_process_text(){var t;const e=(0,d.font_metrics)(this.font);return null===(t=this.provider.MathJax)||void 0===t?void 0:t.mathml2svg(this.styled_text,{em:this.base_font_size,ex:e.x_height})}}i.MathMLView=w,w.__name__="MathMLView";class M extends v{constructor(t){super(t)}}i.MathML=M,h=M,M.__name__="MathML",h.prototype.default_view=w;class z extends m{get styled_text(){const[t,e,i]=(0,_.color2rgba)(this.color);return`\\color[RGB]{${t}, ${e}, ${i}} ${this.font.includes("bold")?`\\bf{${this.text}}`:this.text}`}_process_text(){var t;const e=(0,d.font_metrics)(this.font);return null===(t=this.provider.MathJax)||void 0===t?void 0:t.tex2svg(this.styled_text,{display:!this.model.inline,em:this.base_font_size,ex:e.x_height},this.model.macros)}}i.TeXView=z,z.__name__="TeXView";class T extends v{constructor(t){super(t)}}i.TeX=T,r=T,T.__name__="TeX",r.prototype.default_view=z,r.define((({Boolean:t,Number:e,String:i,Dict:s,Tuple:n,Or:o})=>({macros:[s(o(i,n(i,e))),{}],inline:[t,!1]})))},
function _(i,e,t,s,a){s();const o=i(18);t.load_image=async function(i,e){return new n(i,e).promise};class n{constructor(i,e={}){this.image=new Image,this._finished=!1;const{attempts:t=1,timeout:s=1}=e;this.promise=new Promise(((a,n)=>{this.image.crossOrigin="anonymous";let r=0;this.image.onerror=()=>{if(++r==t){const s=`unable to load ${i} image after ${t} attempts`;if(o.logger.warn(s),null==this.image.crossOrigin)return void(null!=e.failed&&e.failed());o.logger.warn(`attempting to load ${i} without a cross origin policy`),this.image.crossOrigin=null,r=0}setTimeout((()=>this.image.src=i),s)},this.image.onload=()=>{this._finished=!0,null!=e.loaded&&e.loaded(this.image),a(this.image)},this.image.src=i}))}get finished(){return this._finished}}t.ImageLoader=n,n.__name__="ImageLoader"},
function _(t,e,s,i,n){i();const h=t(56),o=t(151),a=t(10),r=t(8),c=t(152),_=t(21);s.text_width=(()=>{const t=document.createElement("canvas").getContext("2d");let e="";return(s,i)=>(i!=e&&(e=i,t.font=i),t.measureText(s).width)})();class l{constructor(){this._position={sx:0,sy:0},this.font_size_scale=1,this.align="left",this._base_font_size=13,this._x_anchor="left",this._y_anchor="center"}set base_font_size(t){null!=t&&(this._base_font_size=t)}get base_font_size(){return this._base_font_size}set position(t){this._position=t}get position(){return this._position}infer_text_height(){return"ascent_descent"}bbox(){const{p0:t,p1:e,p2:s,p3:i}=this.rect(),n=Math.min(t.x,e.x,s.x,i.x),o=Math.min(t.y,e.y,s.y,i.y),a=Math.max(t.x,e.x,s.x,i.x),r=Math.max(t.y,e.y,s.y,i.y);return new h.BBox({left:n,right:a,top:o,bottom:r})}size(){const{width:t,height:e}=this._size(),{angle:s}=this;if(null==s||0==s)return{width:t,height:e};{const i=Math.cos(Math.abs(s)),n=Math.sin(Math.abs(s));return{width:Math.abs(t*i+e*n),height:Math.abs(t*n+e*i)}}}rect(){const t=this._rect(),{angle:e}=this;if(null==e||0==e)return t;{const{sx:s,sy:i}=this.position,n=new c.AffineTransform;return n.translate(s,i),n.rotate(e),n.translate(-s,-i),n.apply_rect(t)}}paint_rect(t){const{p0:e,p1:s,p2:i,p3:n}=this.rect();t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e.x),h(e.y)),t.lineTo(h(s.x),h(s.y)),t.lineTo(h(i.x),h(i.y)),t.lineTo(h(n.x),h(n.y)),t.closePath(),t.stroke(),t.restore()}paint_bbox(t){const{x:e,y:s,width:i,height:n}=this.bbox();t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();const{round:h}=Math;t.moveTo(h(e),h(s)),t.lineTo(h(e),h(s+n)),t.lineTo(h(e+i),h(s+n)),t.lineTo(h(e+i),h(s)),t.closePath(),t.stroke(),t.restore()}}s.GraphicsBox=l,l.__name__="GraphicsBox";class u extends l{constructor({text:t}){super(),this._visual_align="left",this.text=t}set visuals(t){const e=t.color,s=t.alpha,i=t.outline_color,n=t.font_style;let h=t.font_size;const a=t.font,{font_size_scale:r,base_font_size:c}=this,l=(0,o.parse_css_font_size)(h);if(null!=l){let{value:t,unit:e}=l;t*=r,"em"==e&&c&&(t*=c,e="px"),h=`${t}${e}`}const u=`${n} ${h} ${a}`;this.font=u,this.color=(0,_.color2css)(e,s),this.outline_color=(0,_.color2css)(i,s),this.line_height=t.line_height;const x=t.align;this._visual_align=x,this._x_anchor=x;const p=t.baseline;this._y_anchor=(()=>{switch(p){case"top":return"top";case"middle":return"center";case"bottom":return"bottom";default:return"baseline"}})()}infer_text_height(){if(this.text.includes("\n"))return"ascent_descent";{function t(t){for(const e of new Set(t))if(!("0"<=e&&e<="9"))switch(e){case",":case".":case"+":case"-":case"\u2212":case"e":continue;default:return!1}return!0}return t(this.text)?"cap":"ascent_descent"}}_text_line(t){var e;const s=null!==(e=this.text_height_metric)&&void 0!==e?e:this.infer_text_height(),i=(()=>{switch(s){case"x":case"x_descent":return t.x_height;case"cap":case"cap_descent":return t.cap_height;case"ascent":case"ascent_descent":return t.ascent}})(),n=(()=>{switch(s){case"x":case"cap":case"ascent":return 0;case"x_descent":case"cap_descent":case"ascent_descent":return t.descent}})();return{height:i+n,ascent:i,descent:n}}get nlines(){return this.text.split("\n").length}_size(){var t,e;const{font:i}=this,n=(0,o.font_metrics)(i),h=(this.line_height-1)*n.height,r=""==this.text,c=this.text.split("\n"),_=c.length,l=c.map((t=>(0,s.text_width)(t,i))),u=this._text_line(n).height*_,x="%"==(null===(t=this.width)||void 0===t?void 0:t.unit)?this.width.value:1,p="%"==(null===(e=this.height)||void 0===e?void 0:e.unit)?this.height.value:1;return{width:(0,a.max)(l)*x,height:r?0:(u+h*(_-1))*p,metrics:n}}_computed_position(t,e,s){const{width:i,height:n}=t,{sx:h,sy:o,x_anchor:a=this._x_anchor,y_anchor:c=this._y_anchor}=this.position;return{x:h-(()=>{if((0,r.isNumber)(a))return a*i;switch(a){case"left":return 0;case"center":return.5*i;case"right":return i}})(),y:o-(()=>{var t;if((0,r.isNumber)(c))return c*n;switch(c){case"top":return 0;case"center":return.5*n;case"bottom":return n;case"baseline":if(1!=s)return.5*n;switch(null!==(t=this.text_height_metric)&&void 0!==t?t:this.infer_text_height()){case"x":case"x_descent":return e.x_height;case"cap":case"cap_descent":return e.cap_height;case"ascent":case"ascent_descent":return e.ascent}}})()}}_rect(){const{width:t,height:e,metrics:s}=this._size(),i=this.text.split("\n").length,{x:n,y:o}=this._computed_position({width:t,height:e},s,i);return new h.BBox({x:n,y:o,width:t,height:e}).rect}paint(t){var e,i;const{font:n}=this,h=(0,o.font_metrics)(n),r=(this.line_height-1)*h.height,c=this.text.split("\n"),_=c.length,l=c.map((t=>(0,s.text_width)(t,n))),u=this._text_line(h),x=u.height*_,p="%"==(null===(e=this.width)||void 0===e?void 0:e.unit)?this.width.value:1,f="%"==(null===(i=this.height)||void 0===i?void 0:i.unit)?this.height.value:1,g=(0,a.max)(l)*p,d=(x+r*(_-1))*f;t.save(),t.fillStyle=this.color,t.strokeStyle=this.outline_color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic";const{sx:b,sy:m}=this.position,{align:y}=this,{angle:w}=this;null!=w&&0!=w&&(t.translate(b,m),t.rotate(w),t.translate(-b,-m));let{x:v,y:z}=this._computed_position({width:g,height:d},h,_);if("justify"==y)for(let e=0;e<_;e++){let i=v;const h=c[e].split(" "),o=h.length,_=h.map((t=>(0,s.text_width)(t,n))),l=(g-(0,a.sum)(_))/(o-1);for(let e=0;e<o;e++)t.fillText(h[e],i,z),t.strokeText(h[e],i,z),i+=_[e]+l;z+=u.height+r}else for(let e=0;e<_;e++){const s=v+(()=>{switch("auto"==y?this._visual_align:y){case"left":return 0;case"center":return.5*(g-l[e]);case"right":return g-l[e]}})(),i=c[e],n=z+u.ascent;t.fillText(i,s,n),t.strokeText(i,s,n),z+=u.height+r}t.restore()}}s.TextBox=u,u.__name__="TextBox";class x extends l{constructor(t,e){super(),this.base=t,this.expo=e}get children(){return[this.base,this.expo]}set base_font_size(t){super.base_font_size=t,this.base.base_font_size=t,this.expo.base_font_size=t}set position(t){this._position=t;const e=this.base.size(),s=this.expo.size(),i=this._shift_scale()*e.height,n=Math.max(e.height,i+s.height);this.base.position={sx:0,x_anchor:"left",sy:n,y_anchor:"bottom"},this.expo.position={sx:e.width,x_anchor:"left",sy:i,y_anchor:"bottom"}}get position(){return this._position}set visuals(t){this.expo.font_size_scale=.7,this.base.visuals=t,this.expo.visuals=t}_shift_scale(){if(this.base instanceof u&&1==this.base.nlines){const{x_height:t,cap_height:e}=(0,o.font_metrics)(this.base.font);return t/e}return 2/3}infer_text_height(){return this.base.infer_text_height()}_rect(){const t=this.base.bbox(),e=this.expo.bbox(),s=t.union(e),{x:i,y:n}=this._computed_position();return s.translate(i,n).rect}_size(){const t=this.base.size(),e=this.expo.size();return{width:t.width+e.width,height:Math.max(t.height,this._shift_scale()*t.height+e.height)}}paint(t){t.save();const{angle:e}=this;if(null!=e&&0!=e){const{sx:s,sy:i}=this.position;t.translate(s,i),t.rotate(e),t.translate(-s,-i)}const{x:s,y:i}=this._computed_position();t.translate(s,i),this.base.paint(t),this.expo.paint(t),t.restore()}paint_bbox(t){super.paint_bbox(t);const{x:e,y:s}=this._computed_position();t.save(),t.translate(e,s);for(const e of this.children)e.paint_bbox(t);t.restore()}_computed_position(){const{width:t,height:e}=this._size(),{sx:s,sy:i,x_anchor:n=this._x_anchor,y_anchor:h=this._y_anchor}=this.position;return{x:s-(()=>{if((0,r.isNumber)(n))return n*t;switch(n){case"left":return 0;case"center":return.5*t;case"right":return t}})(),y:i-(()=>{if((0,r.isNumber)(h))return h*e;switch(h){case"top":return 0;case"center":case"baseline":return.5*e;case"bottom":return e}})()}}}s.BaseExpo=x,x.__name__="BaseExpo";class p{constructor(t){this.items=t}set base_font_size(t){for(const e of this.items)e.base_font_size=t}get length(){return this.items.length}set visuals(t){for(const e of this.items)e.visuals=t;const e={x:0,cap:1,ascent:2,x_descent:3,cap_descent:4,ascent_descent:5},s=(0,a.max_by)(this.items.map((t=>t.infer_text_height())),(t=>e[t]));for(const t of this.items)t.text_height_metric=s}set angle(t){for(const e of this.items)e.angle=t}max_size(){let t=0,e=0;for(const s of this.items){const i=s.size();t=Math.max(t,i.width),e=Math.max(e,i.height)}return{width:t,height:e}}}s.GraphicsBoxes=p,p.__name__="GraphicsBoxes"},
function _(t,e,n,c,s){c();const a=t(12),o=t(8),r=(()=>{try{return"undefined"!=typeof OffscreenCanvas&&null!=new OffscreenCanvas(0,0).getContext("2d")}catch(t){return!1}})()?(t,e)=>new OffscreenCanvas(t,e):(t,e)=>{const n=document.createElement("canvas");return n.width=t,n.height=e,n},i=(()=>{const t=r(0,0).getContext("2d");return e=>{t.font=e;const n=t.measureText("M"),c=t.measureText("x"),s=t.measureText("\xc5\u015ag|"),r=s.fontBoundingBoxAscent,i=s.fontBoundingBoxDescent;if((0,o.is_defined)(r)&&(0,o.is_defined)(i))return{height:r+i,ascent:r,descent:i,cap_height:n.actualBoundingBoxAscent,x_height:c.actualBoundingBoxAscent};const u=s.actualBoundingBoxAscent,f=s.actualBoundingBoxDescent;if((0,o.is_defined)(u)&&(0,o.is_defined)(f))return{height:u+f,ascent:u,descent:f,cap_height:n.actualBoundingBoxAscent,x_height:c.actualBoundingBoxAscent};(0,a.unreachable)()}})(),u=(()=>{const t=document.createElement("canvas"),e=t.getContext("2d");let n=-1,c=-1;return(s,a=1)=>{e.font=s;const{width:o}=e.measureText("M"),r=o*a,i=Math.ceil(r),u=Math.ceil(2*r),f=Math.ceil(1.5*r);n<i&&(n=i,t.width=i),c<u&&(c=u,t.height=u),e.save(),e.scale(a,a),e.fillStyle="#f00",e.fillRect(0,0,i,u);const l=t=>{let e=0;for(let n=0;n<=f;n++)for(let c=0;c<i;c++,e+=4)if(255!=t[e])return f-n;return 0};e.font=s,e.fillStyle="#000";for(const t of"xa")e.fillText(t,0,f/a);const{data:d}=e.getImageData(0,0,i,u),h=l(d)/a;for(const t of"ASQ")e.fillText(t,0,f/a);const{data:g}=e.getImageData(0,0,i,u),x=l(g)/a;for(const t of"\xc5\u015agy")e.fillText(t,0,f/a);const{data:m}=e.getImageData(0,0,i,u),_=l(m)/a,B=(t=>{let e=t.length-4;for(let n=u;n>=f;n--)for(let c=0;c<i;c++,e-=4)if(255!=t[e])return n-f;return 0})(m)/a;return e.restore(),{height:_+B,ascent:_,cap_height:x,x_height:h,descent:B}}})(),f=(()=>{try{return i("normal 10px sans-serif"),i}catch(t){return u}})(),l=new Map;n.font_metrics=function(t){let e=l.get(t);if(null==e){const n=document.fonts.check(t);e={font:f(t)},n&&l.set(t,e)}return e.font},n.parse_css_font_size=function(t){const e=t.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);if(null!=e){const[,t,,n]=e,c=Number(t);if(isFinite(c))return{value:c,unit:n}}return null},n.parse_css_length=function(t){const e=t.match(/^\s*(-?\d+(\.\d+)?)(\w+)\s*$/);if(null!=e){const[,t,,n]=e,c=Number(t);if(isFinite(c))return{value:c,unit:n}}return null}},
function _(t,s,r,n,i){n();const{sin:e,cos:a}=Math;class h{constructor(t=1,s=0,r=0,n=1,i=0,e=0){this.a=t,this.b=s,this.c=r,this.d=n,this.e=i,this.f=e}toString(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return`matrix(${t}, ${s}, ${r}, ${n}, ${i}, ${e})`}static from_DOMMatrix(t){const{a:s,b:r,c:n,d:i,e,f:a}=t;return new h(s,r,n,i,e,a)}to_DOMMatrix(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return new DOMMatrix([t,s,r,n,i,e])}clone(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return new h(t,s,r,n,i,e)}get is_identity(){const{a:t,b:s,c:r,d:n,e:i,f:e}=this;return 1==t&&0==s&&0==r&&1==n&&0==i&&0==e}apply_point(t){const[s,r]=this.apply(t.x,t.y);return{x:s,y:r}}apply_rect(t){return{p0:this.apply_point(t.p0),p1:this.apply_point(t.p1),p2:this.apply_point(t.p2),p3:this.apply_point(t.p3)}}apply(t,s){const{a:r,b:n,c:i,d:e,e:a,f:h}=this;return[r*t+i*s+a,n*t+e*s+h]}iv_apply(t,s){const{a:r,b:n,c:i,d:e,e:a,f:h}=this,c=t.length;for(let o=0;o<c;o++){const c=t[o],p=s[o];t[o]=r*c+i*p+a,s[o]=n*c+e*p+h}}transform(t,s,r,n,i,e){const{a,b:h,c,d:o,e:p,f}=this;return this.a=a*t+c*s,this.c=a*r+c*n,this.e=a*i+c*e+p,this.b=h*t+o*s,this.d=h*r+o*n,this.f=h*i+o*e+f,this}translate(t,s){return this.transform(1,0,0,1,t,s)}scale(t,s){return this.transform(t,0,0,s,0,0)}skew(t,s){return this.transform(1,s,t,1,0,0)}rotate(t){const s=e(t),r=a(t);return this.transform(r,s,-s,r,0,0)}rotate_ccw(t){return this.rotate(-t)}translate_x(t){return this.translate(t,0)}translate_y(t){return this.translate(0,t)}flip(){return this.scale(-1,-1)}flip_x(){return this.scale(1,-1)}flip_y(){return this.scale(-1,1)}}r.AffineTransform=h,h.__name__="AffineTransform"},
function _(t,e,a,r,s){var n=this&&this.__createBinding||(Object.create?function(t,e,a,r){void 0===r&&(r=a);var s=Object.getOwnPropertyDescriptor(e,a);s&&!("get"in s?!e.__esModule:s.writable||s.configurable)||(s={enumerable:!0,get:function(){return e[a]}}),Object.defineProperty(t,r,s)}:function(t,e,a,r){void 0===r&&(r=a),t[r]=e[a]}),i=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),o=this&&this.__importStar||function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var a in t)"default"!==a&&Object.prototype.hasOwnProperty.call(t,a)&&n(e,t,a);return i(e,t),e};r();const d=t(15),u=t(154);class c{constructor(){this.ready=new d.Signal0(this,"ready"),this.status="not_started"}}a.MathJaxProvider=c,c.__name__="MathJaxProvider";class l extends c{get MathJax(){return null}async fetch(){this.status="failed"}}a.NoProvider=l,l.__name__="NoProvider";class h extends c{get MathJax(){return"undefined"!=typeof MathJax?MathJax:null}async fetch(){const t=document.createElement("script");t.src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-svg.js",t.onload=()=>{this.status="loaded",this.ready.emit()},t.onerror=()=>{this.status="failed"},this.status="loading",document.head.appendChild(t)}}a.CDNProvider=h,h.__name__="CDNProvider";class _ extends c{get MathJax(){return this._mathjax}async fetch(){this.status="loading";try{const e=await(0,u.load_module)(Promise.resolve().then((()=>o(t(624)))));this._mathjax=e,this.status="loaded",this.ready.emit()}catch(t){this.status="failed"}}}a.BundleProvider=_,_.__name__="BundleProvider",a.default_provider=new _},
function _(n,r,o,t,c){t(),o.load_module=async function(n){try{return await n}catch(n){if((r=n)instanceof Error&&"code"in r&&"MODULE_NOT_FOUND"===n.code)return null;throw n}var r}},
function _(e,t,i,n,s){var a;n();const x=e(146),_=e(150);class l extends x.BaseTextView{initialize(){super.initialize(),this._has_finished=!0}graphics(){return new _.TextBox({text:this.model.text})}}i.PlainTextView=l,l.__name__="PlainTextView";class r extends x.BaseText{constructor(e){super(e)}}i.PlainText=r,a=r,r.__name__="PlainText",a.prototype.default_view=l},
function _(e,s,t,a,_){a();const r=e(91),n=e(90),i=e(87),g=e(92),c=e(95),h=e(56),l=e(9),o=e(12),u=e(15);class x{constructor(e,s,t,a,_={},r={},n={},i={}){this.in_x_scale=e,this.in_y_scale=s,this.x_range=t,this.y_range=a,this.extra_x_ranges=_,this.extra_y_ranges=r,this.extra_x_scales=n,this.extra_y_scales=i,this._bbox=new h.BBox,this.change=new u.Signal0(this,"change"),(0,o.assert)(e.properties.source_range.is_unset&&e.properties.target_range.is_unset),(0,o.assert)(s.properties.source_range.is_unset&&s.properties.target_range.is_unset),this._configure_scales()}get bbox(){return this._bbox}_get_ranges(e,s){return new Map((0,l.entries)(Object.assign(Object.assign({},s),{default:e})))}_get_scales(e,s,t,a){var _;const i=new Map((0,l.entries)(Object.assign(Object.assign({},s),{default:e}))),h=new Map;for(const[s,l]of t){if(l instanceof c.FactorRange!=e instanceof r.CategoricalScale)throw new Error(`Range ${l.type} is incompatible is Scale ${e.type}`);e instanceof n.LogScale&&l instanceof g.DataRange1d&&(l.scale_hint="log");const t=(null!==(_=i.get(s))&&void 0!==_?_:e).clone();t.setv({source_range:l,target_range:a}),h.set(s,t)}return h}_configure_frame_ranges(){const{bbox:e}=this;this._x_target=new i.Range1d({start:e.left,end:e.right}),this._y_target=new i.Range1d({start:e.bottom,end:e.top})}_configure_scales(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._x_scales=this._get_scales(this.in_x_scale,this.extra_x_scales,this._x_ranges,this._x_target),this._y_scales=this._get_scales(this.in_y_scale,this.extra_y_scales,this._y_ranges,this._y_target)}configure_scales(){this._configure_scales(),this.change.emit()}_update_scales(){this._configure_frame_ranges();for(const[,e]of this._x_scales)e.target_range=this._x_target;for(const[,e]of this._y_scales)e.target_range=this._y_target}set_geometry(e){this._bbox=e,this._update_scales()}get x_target(){return this._x_target}get y_target(){return this._y_target}get x_ranges(){return this._x_ranges}get y_ranges(){return this._y_ranges}get ranges(){return new Set([...this.x_ranges.values(),...this.y_ranges.values()])}get x_scales(){return this._x_scales}get y_scales(){return this._y_scales}get scales(){return new Set([...this.x_scales.values(),...this.y_scales.values()])}get x_scale(){return this._x_scales.get("default")}get y_scale(){return this._y_scales.get("default")}}t.CartesianFrame=x,x.__name__="CartesianFrame"},
function _(i,s,x,A,o){A(),o("Axis",i(158).Axis),o("CategoricalAxis",i(163).CategoricalAxis),o("ContinuousAxis",i(166).ContinuousAxis),o("DatetimeAxis",i(167).DatetimeAxis),o("LinearAxis",i(183).LinearAxis),o("LogAxis",i(185).LogAxis),o("MercatorAxis",i(188).MercatorAxis)},
function _(t,e,i,s,a){s();const l=t(1);var o;const n=t(159),_=t(160),r=t(161),h=t(162),c=l.__importStar(t(77)),b=t(19),u=t(23),m=t(143),d=t(10),x=t(9),f=t(8),g=t(150),p=t(95),v=t(146),w=t(58),j=t(12),k=t(8),y=t(147),{abs:z}=Math;class M extends n.GuideRendererView{constructor(){super(...arguments),this._axis_label_view=null,this._major_label_views=new Map}async lazy_initialize(){await super.lazy_initialize(),await this._init_axis_label(),await this._init_major_labels()}async _init_axis_label(){const{axis_label:t}=this.model;if(null!=t){const e=(0,k.isString)(t)?(0,y.parse_delimited_string)(t):t;this._axis_label_view=await(0,w.build_view)(e,{parent:this})}else this._axis_label_view=null}async _init_major_labels(){for(const[t,e]of this.model.major_label_overrides){const i=(0,k.isString)(e)?(0,y.parse_delimited_string)(e):e;this._major_label_views.set(t,await(0,w.build_view)(i,{parent:this}))}}update_layout(){this.layout=new m.SideLayout(this.panel,(()=>this.get_size()),!0),this.layout.on_resize((()=>this._coordinates=void 0))}get_size(){const{visible:t,fixed_location:e}=this.model;if(t&&null==e&&this.is_renderable){const{extents:t}=this;return{width:0,height:Math.round(t.tick+t.tick_label+t.axis_label)}}return{width:0,height:0}}get is_renderable(){const[t,e]=this.ranges;return t.is_valid&&e.is_valid&&t.span>0&&e.span>0}_render(){var t;if(!this.is_renderable)return;const{tick_coords:e,extents:i}=this,s=this.layer.ctx;s.save(),this._draw_rule(s,i),this._draw_major_ticks(s,i,e),this._draw_minor_ticks(s,i,e),this._draw_major_labels(s,i,e),this._draw_axis_label(s,i,e),null===(t=this._paint)||void 0===t||t.call(this,s,i,e),s.restore()}connect_signals(){super.connect_signals();const{axis_label:t,major_label_overrides:e}=this.model.properties;this.on_change(t,(async()=>{var t;null===(t=this._axis_label_view)||void 0===t||t.remove(),await this._init_axis_label()})),this.on_change(e,(async()=>{for(const t of this._major_label_views.values())t.remove();await this._init_major_labels()})),this.connect(this.model.change,(()=>this.plot_view.request_layout()))}get needs_clip(){return null!=this.model.fixed_location}_draw_rule(t,e){if(!this.visuals.axis_line.doit)return;const[i,s]=this.rule_coords,[a,l]=this.coordinates.map_to_screen(i,s),[o,n]=this.normals,[_,r]=this.offsets;this.visuals.axis_line.set_value(t),t.beginPath();for(let e=0;e<a.length;e++){const i=Math.round(a[e]+o*_),s=Math.round(l[e]+n*r);t.lineTo(i,s)}t.stroke()}_draw_major_ticks(t,e,i){const s=this.model.major_tick_in,a=this.model.major_tick_out,l=this.visuals.major_tick_line;this._draw_ticks(t,i.major,s,a,l)}_draw_minor_ticks(t,e,i){const s=this.model.minor_tick_in,a=this.model.minor_tick_out,l=this.visuals.minor_tick_line;this._draw_ticks(t,i.minor,s,a,l)}_draw_major_labels(t,e,i){const s=i.major,a=this.compute_labels(s[this.dimension]),l=this.model.major_label_orientation,o=e.tick+this.model.major_label_standoff,n=this.visuals.major_label_text;this._draw_oriented_labels(t,a,s,l,this.panel.side,o,n)}_axis_label_extent(){if(null==this._axis_label_view)return 0;const t=this._axis_label_view.graphics();t.visuals=this.visuals.axis_label_text.values(),t.angle=this.panel.get_label_angle_heuristic("parallel"),(0,f.isNumber)(this.plot_view.base_font_size)&&(t.base_font_size=this.plot_view.base_font_size);const e=t.size(),i=0==this.dimension?e.height:e.width,s=this.model.axis_label_standoff;return i>0?s+i+3:0}_draw_axis_label(t,e,i){if(null==this._axis_label_view||null!=this.model.fixed_location)return;const[s,a]=(()=>{const{bbox:t}=this.layout;switch(this.panel.side){case"above":return[t.hcenter,t.bottom];case"below":return[t.hcenter,t.top];case"left":return[t.right,t.vcenter];case"right":return[t.left,t.vcenter]}})(),[l,o]=this.normals,n=e.tick+e.tick_label+this.model.axis_label_standoff,{vertical_align:_,align:r}=this.panel.get_label_text_heuristics("parallel"),h={sx:s+l*n,sy:a+o*n,x_anchor:r,y_anchor:_},c=this._axis_label_view.graphics();c.visuals=this.visuals.axis_label_text.values(),c.angle=this.panel.get_label_angle_heuristic("parallel"),null!=this.plot_view.base_font_size&&(c.base_font_size=this.plot_view.base_font_size),c.position=h,c.align=r,c.paint(t)}_draw_ticks(t,e,i,s,a){if(!a.doit)return;const[l,o]=e,[n,_]=this.coordinates.map_to_screen(l,o),[r,h]=this.normals,[c,b]=this.offsets,[u,m]=[r*(c-i),h*(b-i)],[d,x]=[r*(c+s),h*(b+s)];a.set_value(t),t.beginPath();for(let e=0;e<n.length;e++){const i=Math.round(n[e]+d),s=Math.round(_[e]+x),a=Math.round(n[e]+u),l=Math.round(_[e]+m);t.moveTo(i,s),t.lineTo(a,l)}t.stroke()}_draw_oriented_labels(t,e,i,s,a,l,o){if(!o.doit||0==e.length)return;const[n,_]=i,[r,h]=this.coordinates.map_to_screen(n,_),[c,b]=this.offsets,[m,d]=this.normals,x=m*(c+l),f=d*(b+l),{vertical_align:p,align:v}=this.panel.get_label_text_heuristics(s),w=this.panel.get_label_angle_heuristic(s);e.visuals=o.values(),e.angle=w,e.base_font_size=this.plot_view.base_font_size;for(let t=0;t<e.length;t++){const i=e.items[t];i.position={sx:r[t]+x,sy:h[t]+f,x_anchor:v,y_anchor:p},i instanceof g.TextBox&&(i.align=v)}const j=e.length,k=u.Indices.all_set(j),{items:y}=e,z=y.map((t=>t.bbox())),M=(()=>{const[t]=this.ranges;return t.is_reversed?0==this.dimension?(t,e)=>z[t].left-z[e].right:(t,e)=>z[e].top-z[t].bottom:0==this.dimension?(t,e)=>z[e].left-z[t].right:(t,e)=>z[t].top-z[e].bottom})(),{major_label_policy:O}=this.model,T=O.filter(k,z,M),A=[...T.ones()];if(0!=A.length){const t=this.parent.canvas_view.bbox,e=e=>{const i=z[e];if(i.left<0){const t=-i.left,{position:s}=y[e];y[e].position=Object.assign(Object.assign({},s),{sx:s.sx+t})}else if(i.right>t.width){const s=i.right-t.width,{position:a}=y[e];y[e].position=Object.assign(Object.assign({},a),{sx:a.sx-s})}},i=e=>{const i=z[e];if(i.top<0){const t=-i.top,{position:s}=y[e];y[e].position=Object.assign(Object.assign({},s),{sy:s.sy+t})}else if(i.bottom>t.height){const s=i.bottom-t.height,{position:a}=y[e];y[e].position=Object.assign(Object.assign({},a),{sy:a.sy-s})}},s=A[0],a=A[A.length-1];0==this.dimension?(e(s),e(a)):(i(s),i(a))}for(const e of T){y[e].paint(t)}}_tick_extent(){return this.model.major_tick_out}_tick_label_extents(){const t=this.tick_coords.major,e=this.compute_labels(t[this.dimension]),i=this.model.major_label_orientation,s=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(e,i,s,a)]}get extents(){const t=this._tick_label_extents();return{tick:this._tick_extent(),tick_labels:t,tick_label:(0,d.sum)(t),axis_label:this._axis_label_extent()}}_oriented_labels_extent(t,e,i,s){if(0==t.length||!s.doit)return 0;const a=this.panel.get_label_angle_heuristic(e);t.visuals=s.values(),t.angle=a,t.base_font_size=this.plot_view.base_font_size;const l=t.max_size(),o=0==this.dimension?l.height:l.width;return o>0?i+o+3:0}get normals(){return this.panel.normals}get dimension(){return this.panel.dimension}compute_labels(t){const e=this.model.formatter.format_graphics(t,this),{_major_label_views:i}=this,s=new Set;for(let a=0;a<t.length;a++){const l=i.get(t[a]);null!=l&&(s.add(l),e[a]=l.graphics())}for(const t of this._major_label_views.values())s.has(t)||(t._has_finished=!0);return new g.GraphicsBoxes(e)}get offsets(){if(null!=this.model.fixed_location)return[0,0];const{frame:t}=this.plot_view;let[e,i]=[0,0];switch(this.panel.side){case"below":i=z(this.layout.bbox.top-t.bbox.bottom);break;case"above":i=z(this.layout.bbox.bottom-t.bbox.top);break;case"right":e=z(this.layout.bbox.left-t.bbox.right);break;case"left":e=z(this.layout.bbox.right-t.bbox.left)}return[e,i]}get ranges(){const t=this.dimension,e=1-t,{ranges:i}=this.coordinates;return[i[t],i[e]]}get computed_bounds(){const[t]=this.ranges,e=this.model.bounds,i=[t.min,t.max];if("auto"==e)return[t.min,t.max];{let t,s;const[a,l]=e,[o,n]=i,{min:_,max:r}=Math;return z(a-l)>z(o-n)?(t=r(_(a,l),o),s=_(r(a,l),n)):(t=_(a,l),s=r(a,l)),[t,s]}}get rule_coords(){const t=this.dimension,e=1-t,[i]=this.ranges,[s,a]=this.computed_bounds,l=[new Array(2),new Array(2)];return l[t][0]=Math.max(s,i.min),l[t][1]=Math.min(a,i.max),l[t][0]>l[t][1]&&(l[t][0]=l[t][1]=NaN),l[e][0]=this.loc,l[e][1]=this.loc,l}get tick_coords(){const t=this.dimension,e=1-t,[i]=this.ranges,[s,a]=this.computed_bounds,l=this.model.ticker.get_ticks(s,a,i,this.loc),o=l.major,n=l.minor,_=[[],[]],r=[[],[]],[h,c]=[i.min,i.max];for(let i=0;i<o.length;i++)o[i]<h||o[i]>c||(_[t].push(o[i]),_[e].push(this.loc));for(let i=0;i<n.length;i++)n[i]<h||n[i]>c||(r[t].push(n[i]),r[e].push(this.loc));return{major:_,minor:r}}get loc(){const{fixed_location:t}=this.model;if(null!=t){if((0,f.isNumber)(t))return t;const[,e]=this.ranges;if(e instanceof p.FactorRange)return e.synthetic(t);(0,j.unreachable)()}const[,e]=this.ranges;switch(this.panel.side){case"left":case"below":return e.start;case"right":case"above":return e.end}}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box})}remove(){var t;null===(t=this._axis_label_view)||void 0===t||t.remove();for(const t of this._major_label_views.values())t.remove();super.remove()}has_finished(){if(!super.has_finished())return!1;if(null!=this._axis_label_view&&!this._axis_label_view.has_finished())return!1;for(const t of this._major_label_views.values())if(!t.has_finished())return!1;return!0}}i.AxisView=M,M.__name__="AxisView";class O extends n.GuideRenderer{constructor(t){super(t)}}i.Axis=O,o=O,O.__name__="Axis",o.prototype.default_view=M,o.mixins([["axis_",c.Line],["major_tick_",c.Line],["minor_tick_",c.Line],["major_label_",c.Text],["axis_label_",c.Text]]),o.define((({Any:t,Int:e,Number:i,String:s,Ref:a,Map:l,Tuple:o,Or:n,Nullable:c,Auto:u})=>({bounds:[n(o(i,i),u),"auto"],ticker:[a(_.Ticker)],formatter:[a(r.TickFormatter)],axis_label:[c(n(s,a(v.BaseText))),null],axis_label_standoff:[e,5],major_label_standoff:[e,5],major_label_orientation:[n(b.TickLabelOrientation,i),"horizontal"],major_label_overrides:[l(n(s,i),n(s,a(v.BaseText))),new globalThis.Map,{convert:t=>(0,f.isPlainObject)(t)?new x.Dict(t):t}],major_label_policy:[a(h.LabelingPolicy),()=>new h.AllLabels],major_tick_in:[i,2],major_tick_out:[i,6],minor_tick_in:[i,0],minor_tick_out:[i,4],fixed_location:[c(n(i,t)),null]}))),o.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic"})},
function _(e,r,d,n,i){var s;n();const _=e(73);class u extends _.RendererView{}d.GuideRendererView=u,u.__name__="GuideRendererView";class c extends _.Renderer{constructor(e){super(e)}}d.GuideRenderer=c,s=c,c.__name__="GuideRenderer",s.override({level:"guide"})},
function _(c,e,n,s,o){s();const r=c(50);class t extends r.Model{constructor(c){super(c)}}n.Ticker=t,t.__name__="Ticker"},
function _(t,o,r,e,c){e();const n=t(50),a=t(150);class m extends n.Model{constructor(t){super(t)}format_graphics(t,o){return this.doFormat(t,o).map((t=>new a.TextBox({text:t})))}compute(t,o){return this.doFormat([t],null!=o?o:{loc:0})[0]}v_compute(t,o){return this.doFormat(t,null!=o?o:{loc:0})}}r.TickFormatter=m,m.__name__="TickFormatter"},
function _(e,n,s,t,i){var l,r;t();const c=e(50),o=e(9),a=e(38),u=e(8),d=e(23);class _ extends c.Model{constructor(e){super(e)}}s.LabelingPolicy=_,_.__name__="LabelingPolicy";class f extends _{constructor(e){super(e)}filter(e,n,s){return e}}s.AllLabels=f,f.__name__="AllLabels";class v extends _{constructor(e){super(e)}filter(e,n,s){const{min_distance:t}=this;let i=null;for(const n of e)null!=i&&s(i,n)<t?e.unset(n):i=n;return e}}s.NoOverlap=v,l=v,v.__name__="NoOverlap",l.define((({Number:e})=>({min_distance:[e,5]})));class m extends _{constructor(e){super(e)}get names(){return(0,o.keys)(this.args)}get values(){return(0,o.values)(this.args)}get func(){const e=(0,a.use_strict)(this.code);return new d.GeneratorFunction("indices","bboxes","distance",...this.names,e)}filter(e,n,s){var t,i;const l=Object.create(null),r=this.func.call(l,e,n,s,...this.values);let c=r.next();if(null!==(t=c.done)&&void 0!==t&&t&&void 0!==c.value){const{value:n}=c;return n instanceof d.Indices?n:void 0===n?e:(0,u.isIterable)(n)?d.Indices.from_indices(e.size,n):d.Indices.all_unset(e.size)}{const n=[];do{n.push(c.value),c=r.next()}while(null===(i=c.done)||void 0===i||!i);return d.Indices.from_indices(e.size,n)}}}s.CustomLabelingPolicy=m,r=m,m.__name__="CustomLabelingPolicy",r.define((({Unknown:e,String:n,Dict:s})=>({args:[s(e),{}],code:[n,""]})))},
function _(t,s,o,e,i){e();const r=t(1);var a;const l=t(158),_=t(164),n=t(165),p=r.__importStar(t(77)),c=t(19),h=t(150),m=t(8);class u extends l.AxisView{_paint(t,s,o){this._draw_group_separators(t,s,o)}_draw_group_separators(t,s,o){const[e]=this.ranges,[i,r]=this.computed_bounds;if(!e.tops||e.tops.length<2||!this.visuals.separator_line.doit)return;const a=this.dimension,l=1-a,_=[[],[]];let n=0;for(let t=0;t<e.tops.length-1;t++){let s,o;for(let i=n;i<e.factors.length;i++)if(e.factors[i][0]==e.tops[t+1]){[s,o]=[e.factors[i-1],e.factors[i]],n=i;break}const p=(e.synthetic(s)+e.synthetic(o))/2;p>i&&p<r&&(_[a].push(p),_[l].push(this.loc))}const p=this.extents.tick_label;this._draw_ticks(t,_,-3,p-6,this.visuals.separator_line)}_draw_major_labels(t,s,o){const e=this._get_factor_info();let i=s.tick+this.model.major_label_standoff;for(let o=0;o<e.length;o++){const[r,a,l,_]=e[o];this._draw_oriented_labels(t,r,a,l,this.panel.side,i,_),i+=s.tick_labels[o]}}_tick_label_extents(){const t=this._get_factor_info(),s=[];for(const[o,,e,i]of t){const t=this._oriented_labels_extent(o,e,this.model.major_label_standoff,i);s.push(t)}return s}_get_factor_info(){const[t]=this.ranges,[s,o]=this.computed_bounds,e=this.loc,i=this.model.ticker.get_ticks(s,o,t,e),r=this.tick_coords,a=[],l=t=>new h.GraphicsBoxes(t.map((t=>(0,m.isString)(t)?new h.TextBox({text:t}):t))),_=t=>l(this.model.formatter.doFormat(t,this));if(1==t.levels){const t=_(i.major);a.push([t,r.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){const t=_(i.major.map((t=>t[1])));a.push([t,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([l(i.tops),r.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){const t=_(i.major.map((t=>t[2]))),s=i.mids.map((t=>t[1]));a.push([t,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([l(s),r.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),a.push([l(i.tops),r.tops,this.model.group_label_orientation,this.visuals.group_text])}return a}get tick_coords(){const t=this.dimension,s=1-t,[o]=this.ranges,[e,i]=this.computed_bounds,r=this.model.ticker.get_ticks(e,i,o,this.loc),a={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return a.major[t]=r.major,a.major[s]=r.major.map((()=>this.loc)),3==o.levels&&(a.mids[t]=r.mids,a.mids[s]=r.mids.map((()=>this.loc))),o.levels>1&&(a.tops[t]=r.tops,a.tops[s]=r.tops.map((()=>this.loc))),a}}o.CategoricalAxisView=u,u.__name__="CategoricalAxisView";class d extends l.Axis{constructor(t){super(t)}}o.CategoricalAxis=d,a=d,d.__name__="CategoricalAxis",a.prototype.default_view=u,a.mixins([["separator_",p.Line],["group_",p.Text],["subgroup_",p.Text]]),a.define((({Number:t,Or:s})=>({group_label_orientation:[s(c.TickLabelOrientation,t),"parallel"],subgroup_label_orientation:[s(c.TickLabelOrientation,t),"parallel"]}))),a.override({ticker:()=>new _.CategoricalTicker,formatter:()=>new n.CategoricalTickFormatter,separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})},
function _(t,c,o,s,e){s();const r=t(160);class i extends r.Ticker{constructor(t){super(t)}get_ticks(t,c,o,s){var e,r;return{major:this._collect(o.factors,o,t,c),minor:[],tops:this._collect(null!==(e=o.tops)&&void 0!==e?e:[],o,t,c),mids:this._collect(null!==(r=o.mids)&&void 0!==r?r:[],o,t,c)}}_collect(t,c,o,s){const e=[];for(const r of t){const t=c.synthetic(r);t>o&&t<s&&e.push(r)}return e}}o.CategoricalTicker=i,i.__name__="CategoricalTicker"},
function _(t,r,o,c,a){c();const e=t(161),n=t(10);class i extends e.TickFormatter{constructor(t){super(t)}doFormat(t,r){return(0,n.copy)(t)}}o.CategoricalTickFormatter=i,i.__name__="CategoricalTickFormatter"},
function _(s,n,i,o,u){o();const e=s(158);class t extends e.AxisView{}i.ContinuousAxisView=t,t.__name__="ContinuousAxisView";class _ extends e.Axis{constructor(s){super(s)}}i.ContinuousAxis=_,_.__name__="ContinuousAxis"},
function _(e,t,i,s,a){var n;s();const o=e(166),r=e(168),m=e(174);class _ extends o.ContinuousAxisView{}i.DatetimeAxisView=_,_.__name__="DatetimeAxisView";class c extends o.ContinuousAxis{constructor(e){super(e)}}i.DatetimeAxis=c,n=c,c.__name__="DatetimeAxis",n.prototype.default_view=_,n.override({ticker:()=>new m.DatetimeTicker,formatter:()=>new r.DatetimeTickFormatter})},
function _(t,e,o,n,r){n();const s=t(1);var i;const _=t(19),u=t(32),c=t(169),l=t(8),m=t(161),d=t(173),a=s.__importDefault(t(172));o.resolution_order=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],o.tm_index_for_resolution=new Map;for(const t of o.resolution_order)o.tm_index_for_resolution.set(t,0);function f(t,e){const o=1.1*t*1e3,n=1e3*e;return o<d.ONE_MILLI?"microseconds":o<d.ONE_SECOND?"milliseconds":o<d.ONE_MINUTE?n>=d.ONE_MINUTE?"minsec":"seconds":o<d.ONE_HOUR?n>=d.ONE_HOUR?"hourmin":"minutes":o<d.ONE_DAY?"hours":o<d.ONE_MONTH?"days":o<d.ONE_YEAR?"months":"years"}function h(t){return(0,a.default)(t,"%Y %m %d %H %M %S").split(/\s+/).map((t=>parseInt(t,10)))}function x(t,e){const o=(0,c.sprintf)("$1%06d",N(t));return-1==(e=e.replace(/((^|[^%])(%%)*)%f/,o)).indexOf("%")?e:(0,a.default)(t,e)}function N(t){return Math.round(t/1e3%1*1e6)}o.tm_index_for_resolution.set("seconds",5),o.tm_index_for_resolution.set("minsec",4),o.tm_index_for_resolution.set("minutes",4),o.tm_index_for_resolution.set("hourmin",3),o.tm_index_for_resolution.set("hours",3),o._get_resolution=f,o._mktime=h,o._strftime=x,o._us=N;class O extends m.TickFormatter{constructor(t){super(t)}doFormat(t,e,o){if(0==t.length)return[];const n=Math.abs(t[t.length-1]-t[0])/1e3,r=n/(t.length-1),s=(0,l.is_undefined)(o)?f(r,n):o,i=[];for(const[e,o]of(0,u.enumerate)(t)){const n=this._compute_label(e,s),r=this._add_context(e,n,o,t.length,s);i.push(r)}return i}_compute_label(t,e){const n=x(t,this[e]),r=h(t),s=o.resolution_order.indexOf(e);let i,_=n,u=!1,c=s;for(;0==r[o.tm_index_for_resolution.get(o.resolution_order[c])]&&(c+=1,c!=o.resolution_order.length);){if(("minsec"==e||"hourmin"==e)&&!u){if("minsec"==e&&0==r[4]&&0!=r[5]||"hourmin"==e&&0==r[3]&&0!=r[4]){i=o.resolution_order[s-1],_=x(t,this[i]);break}u=!0}i=o.resolution_order[c],_=x(t,this[i])}if(this.strip_leading_zeros){const t=_.replace(/^0+/g,"");return t!=_&&isNaN(parseInt(t))?`0${t}`:t}return _}_add_context(t,e,o,n,r){const s=this.context_location,i=this.context_which;if(null==this.context)return e;if("start"==i&&0==o||"end"==i&&o==n-1||"center"==i&&o==Math.floor(n/2)||"all"==i){const o=(0,l.isString)(this.context)?x(t,this.context):this.context.doFormat([t],{loc:0},r)[0];if(""==o)return e;if("above"==s)return`${o}\n${e}`;if("below"==s)return`${e}\n${o}`;if("left"==s)return`${o} ${e}`;if("right"==s)return`${e} ${o}`}return e}}o.DatetimeTickFormatter=O,i=O,O.__name__="DatetimeTickFormatter",i.define((({Boolean:t,Nullable:e,Or:o,Ref:n,String:r})=>({microseconds:[r,"%fus"],milliseconds:[r,"%3Nms"],seconds:[r,"%Ss"],minsec:[r,":%M:%S"],minutes:[r,":%M"],hourmin:[r,"%H:%M"],hours:[r,"%Hh"],days:[r,"%m/%d"],months:[r,"%m/%Y"],years:[r,"%Y"],strip_leading_zeros:[t,!0],context:[e(o(r,n(O))),null],context_which:[_.ContextWhich,"start"],context_location:[_.Location,"below"]})))},
function _(r,t,n,e,i){e();const u=r(1),a=u.__importStar(r(170)),f=r(171),l=u.__importDefault(r(172)),o=r(20),s=r(8);function c(r,...t){return(0,f.sprintf)(r,...t)}function m(r,t,n){if((0,s.isNumber)(r)){return c((()=>{switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}})(),r)}return`${r}`}function _(r,t,e){if(null==t)return m;if(null!=e&&r in e){const t=e[r];if((0,s.isString)(t)){if(t in n.DEFAULT_FORMATTERS)return n.DEFAULT_FORMATTERS[t];throw new Error(`Unknown tooltip field formatter type '${t}'`)}return function(r,n,e){return t.format(r,n,e)}}return n.DEFAULT_FORMATTERS.numeral}function p(r,t,n){const e=t.get_column(r);if(null==e)return null;if(null==n)return null;if((0,s.isNumber)(n))return e[n];const i=e[n.index];if((0,s.isTypedArray)(i)||(0,s.isArray)(i)){if((0,s.isArray)(i[0])){return i[n.j][n.i]}return i[n.flat_index]}return i}function T(r,t,n,e){if("$"==r[0]){return function(r,t){if(r in t)return t[r];throw new Error(`Unknown special variable '$${r}'`)}(r.substring(1),e)}return p(r.substring(1).replace(/[{}]/g,""),t,n)}n.FormatterType=(0,o.Enum)("numeral","printf","datetime"),n.DEFAULT_FORMATTERS={numeral:(r,t,n)=>a.format(r,t),datetime:(r,t,n)=>(0,l.default)(r,t),printf:(r,t,n)=>c(t,r)},n.sprintf=c,n.basic_formatter=m,n.get_formatter=_,n._get_column_value=p,n.get_value=T,n.replace_placeholders=function(r,t,n,e,i={},u){let a,f;if((0,s.isString)(r)?(a=r,f=!1):(a=r.html,f=!0),a=a.replace(/@\$name/g,(r=>`@{${i.name}}`)),a=a.replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,((r,a,l)=>{const o=T(a,t,n,i);if(null==o)return u?u("???"):"???";if("safe"==l)return f=!0,`${o}`;const s=`${_(a,l,e)(o,l,i)}`;return u?u(s):s})),f){return[...(new DOMParser).parseFromString(a,"text/html").body.childNodes]}return a}},
function _(e,n,t,r,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var a,o={},l=o,u="en-US",c=null,s="0,0";void 0!==n&&n.exports;function f(e){this._value=e}function d(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function h(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+d(i-r.length),n>0&&(a+="."+d(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function p(e,n,t){var r;return r=n.indexOf("$")>-1?function(e,n,t){var r,i,a=n,l=a.indexOf("$"),c=a.indexOf("("),s=a.indexOf("+"),f=a.indexOf("-"),d="",h="";-1===a.indexOf("$")?"infix"===o[u].currency.position?(h=o[u].currency.symbol,o[u].currency.spaceSeparated&&(h=" "+h+" ")):o[u].currency.spaceSeparated&&(d=" "):a.indexOf(" $")>-1?(d=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(d=" ",a=a.replace("$ ","")):a=a.replace("$","");if(i=m(e,a,t,h),-1===n.indexOf("$"))switch(o[u].currency.position){case"postfix":i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;break;case"infix":break;case"prefix":i.indexOf("(")>-1||i.indexOf("-")>-1?(i=i.split(""),r=Math.max(c,f)+1,i.splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?i.indexOf("(")>-1||i.indexOf("+")>-1||i.indexOf("-")>-1?(r=1,(l<c||l<s||l<f)&&(r=0),(i=i.split("")).splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i:i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;return i}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=m(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):m(e,n,t),r}function m(e,n,t,r){var i,a,l,s,f,d,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==c)return c;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(f=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(d=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,f)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===d?0:3*~~(d/3)-d)<0?M+3:M,i=0;i<M;i++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=o[u].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=o[u].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=o[u].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=o[u].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(a=Math.pow(1024,s),l=Math.pow(1024,s+1),e>=a&&e<l){C+=K[s],a>0&&(e/=a);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(a=Math.pow(1e3,s),l=Math.pow(1e3,s+1),e>=a&&e<l){C+=G[s],a>0&&(e/=a);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),o[u].ordinal&&(L+=o[u].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?h(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?h(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):h(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:o[u].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=h(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o[u].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function x(e,n){o[e]=n}function g(e){u=e;var n=o[e].defaults;n&&n.format&&a.defaultFormat(n.format),n&&n.currencyFormat&&a.defaultCurrencyFormat(n.currencyFormat)}(a=function(e){return a.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=a.fn.unformat(e)),new f(Number(e))}).version="1.6.2",a.isNumbro=function(e){return e instanceof f},a.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;l[t]||(Object.keys(l).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.setCulture=function(e,n){var t=e,r=e.split("-")[1],i=null;o[t]||(r&&Object.keys(o).forEach((function(e){i||e.split("-")[1]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return u;if(e&&!n){if(!l[e])throw new Error("Unknown language : "+e);g(e)}return!n&&l[e]||x(e,n),a},a.culture=function(e,n){if(!e)return u;if(e&&!n){if(!o[e])throw new Error("Unknown culture : "+e);g(e)}return!n&&o[e]||x(e,n),a},a.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return l[u];if(!l[e])throw new Error("Unknown language : "+e);return l[e]},a.cultureData=function(e){if(!e)return o[u];if(!o[e])throw new Error("Unknown culture : "+e);return o[e]},a.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),a.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),l},a.cultures=function(){return o},a.zeroFormat=function(e){c="string"==typeof e?e:null},a.defaultFormat=function(e){s="string"==typeof e?e:"0.0"},a.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},a.validate=function(e,n){var t,r,i,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=a.cultureData(n)}catch(e){c=a.cultureData(a.culture())}return i=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,r="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===i))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(r+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,r){return null!=t&&t!==a.culture()&&a.setCulture(t),p(Number(e),null!=n?n:s,null==r?Math.round:r)}}},
function _(e,n,t,r,i){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,t,n,r,o){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(t,n,e,_,E){function N(t){return new Date(t.getTime())}function O(t){const n=N(t);return n.setUTCDate(1),n.setUTCHours(0),n.setUTCMinutes(0),n.setUTCSeconds(0),n.setUTCMilliseconds(0),n}_(),e.ONE_MILLI=1,e.ONE_SECOND=1e3,e.ONE_MINUTE=60*e.ONE_SECOND,e.ONE_HOUR=60*e.ONE_MINUTE,e.ONE_DAY=24*e.ONE_HOUR,e.ONE_MONTH=30*e.ONE_DAY,e.ONE_YEAR=365*e.ONE_DAY,e.copy_date=N,e.last_month_no_later_than=O,e.last_year_no_later_than=function(t){const n=O(t);return n.setUTCMonth(0),n}},
function _(e,n,i,a,s){var r;a();const t=e(10),c=e(175),m=e(177),_=e(178),k=e(180),o=e(181),T=e(173);class w extends m.CompositeTicker{constructor(e){super(e)}}i.DatetimeTicker=w,r=w,w.__name__="DatetimeTicker",r.override({num_minor_ticks:0,tickers:()=>[new c.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*T.ONE_MILLI,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:T.ONE_SECOND,max_interval:30*T.ONE_MINUTE,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:T.ONE_HOUR,max_interval:12*T.ONE_HOUR,num_minor_ticks:0}),new _.DaysTicker({days:(0,t.range)(1,32)}),new _.DaysTicker({days:(0,t.range)(1,31,3)}),new _.DaysTicker({days:[1,8,15,22]}),new _.DaysTicker({days:[1,15]}),new k.MonthsTicker({months:(0,t.range)(0,12,1)}),new k.MonthsTicker({months:(0,t.range)(0,12,2)}),new k.MonthsTicker({months:(0,t.range)(0,12,4)}),new k.MonthsTicker({months:(0,t.range)(0,12,6)}),new o.YearsTicker({})]})},
function _(t,i,a,s,e){var n;s();const r=t(176),_=t(10),l=t(11);class h extends r.ContinuousTicker{constructor(t){super(t)}get_min_interval(){return this.min_interval}get_max_interval(){var t;return null!==(t=this.max_interval)&&void 0!==t?t:1/0}initialize(){super.initialize();const t=(0,_.nth)(this.mantissas,-1)/this.base,i=(0,_.nth)(this.mantissas,0)*this.base;this.extended_mantissas=[t,...this.mantissas,i],this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()}get_interval(t,i,a){const s=i-t,e=this.get_ideal_interval(t,i,a),n=Math.floor((0,l.log)(e/this.base_factor,this.base)),r=this.base**n*this.base_factor,h=this.extended_mantissas,m=h.map((t=>Math.abs(a-s/(t*r)))),v=h[(0,_.argmin)(m)]*r;return(0,l.clamp)(v,this.get_min_interval(),this.get_max_interval())}}a.AdaptiveTicker=h,n=h,h.__name__="AdaptiveTicker",n.define((({Number:t,Array:i,Nullable:a})=>({base:[t,10],mantissas:[i(t),[1,2,5]],min_interval:[t,0],max_interval:[a(t),null]})))},
function _(t,n,i,s,e){var o;s();const r=t(160),c=t(10);class _ extends r.Ticker{constructor(t){super(t)}get_ticks(t,n,i,s){return this.get_ticks_no_defaults(t,n,s,this.desired_num_ticks)}get_ticks_no_defaults(t,n,i,s){const e=this.get_interval(t,n,s),o=Math.floor(t/e),r=Math.ceil(n/e);let _;_=isFinite(o)&&isFinite(r)?(0,c.range)(o,r+1):[];const u=_.map((t=>t*e)).filter((i=>t<=i&&i<=n)),a=this.num_minor_ticks,f=[];if(a>0&&u.length>0){const i=e/a,s=(0,c.range)(0,a).map((t=>t*i));for(const i of s.slice(1)){const s=u[0]-i;t<=s&&s<=n&&f.push(s)}for(const i of u)for(const e of s){const s=i+e;t<=s&&s<=n&&f.push(s)}}return{major:u,minor:f}}get_ideal_interval(t,n,i){return(n-t)/i}}i.ContinuousTicker=_,o=_,_.__name__="ContinuousTicker",o.define((({Int:t})=>({num_minor_ticks:[t,5],desired_num_ticks:[t,6]})))},
function _(t,e,i,r,s){var n;r();const _=t(176),a=t(10);class l extends _.ContinuousTicker{constructor(t){super(t)}get min_intervals(){return this.tickers.map((t=>t.get_min_interval()))}get max_intervals(){return this.tickers.map((t=>t.get_max_interval()))}get_min_interval(){return this.min_intervals[0]}get_max_interval(){return this.max_intervals[0]}get_best_ticker(t,e,i){const r=e-t,s=this.get_ideal_interval(t,e,i),n=[(0,a.sorted_index)(this.min_intervals,s)-1,(0,a.sorted_index)(this.max_intervals,s)],_=[this.min_intervals[n[0]],this.max_intervals[n[1]]].map((t=>Math.abs(i-r/t)));let l;if((0,a.is_empty)(_.filter((t=>!isNaN(t)))))l=this.tickers[0];else{const t=n[(0,a.argmin)(_)];l=this.tickers[t]}return l}get_interval(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)}get_ticks_no_defaults(t,e,i,r){return this.get_best_ticker(t,e,r).get_ticks_no_defaults(t,e,i,r)}}i.CompositeTicker=l,n=l,l.__name__="CompositeTicker",n.define((({Array:t,Ref:e})=>({tickers:[t(e(_.ContinuousTicker)),[]]})))},
function _(t,e,n,s,o){var a;s();const i=t(179),r=t(173),c=t(10);class _ extends i.SingleIntervalTicker{constructor(t){super(t)}initialize(){super.initialize();const t=this.days;t.length>1?this.interval=(t[1]-t[0])*r.ONE_DAY:this.interval=31*r.ONE_DAY}get_ticks_no_defaults(t,e,n,s){const o=function(t,e){const n=(0,r.last_month_no_later_than)(new Date(t)),s=(0,r.last_month_no_later_than)(new Date(e));s.setUTCMonth(s.getUTCMonth()+1);const o=[],a=n;for(;o.push((0,r.copy_date)(a)),a.setUTCMonth(a.getUTCMonth()+1),!(a>s););return o}(t,e),a=this.days,i=this.interval,_=(0,c.concat)(o.map((t=>((t,e)=>{const n=t.getUTCMonth(),s=[];for(const o of a){const a=(0,r.copy_date)(t);a.setUTCDate(o),new Date(a.getTime()+e/2).getUTCMonth()==n&&s.push(a)}return s})(t,i))));return{major:_.map((t=>t.getTime())).filter((n=>t<=n&&n<=e)),minor:[]}}}n.DaysTicker=_,a=_,_.__name__="DaysTicker",a.define((({Int:t,Array:e})=>({days:[e(t),[]]}))),a.override({num_minor_ticks:0})},
function _(e,n,t,r,i){var a;r();const l=e(176);class s extends l.ContinuousTicker{constructor(e){super(e)}get_interval(e,n,t){return this.interval}get_min_interval(){return this.interval}get_max_interval(){return this.interval}}t.SingleIntervalTicker=s,a=s,s.__name__="SingleIntervalTicker",a.define((({Number:e})=>({interval:[e]})))},
function _(t,e,n,a,r){var s;a();const i=t(179),o=t(173),l=t(10);class _ extends i.SingleIntervalTicker{constructor(t){super(t)}initialize(){super.initialize();const t=this.months;t.length>1?this.interval=(t[1]-t[0])*o.ONE_MONTH:this.interval=12*o.ONE_MONTH}get_ticks_no_defaults(t,e,n,a){const r=function(t,e){const n=(0,o.last_year_no_later_than)(new Date(t)),a=(0,o.last_year_no_later_than)(new Date(e));a.setUTCFullYear(a.getUTCFullYear()+1);const r=[],s=n;for(;r.push((0,o.copy_date)(s)),s.setUTCFullYear(s.getUTCFullYear()+1),!(s>a););return r}(t,e),s=this.months;return{major:(0,l.concat)(r.map((t=>s.map((e=>{const n=(0,o.copy_date)(t);return n.setUTCMonth(e),n}))))).map((t=>t.getTime())).filter((n=>t<=n&&n<=e)),minor:[]}}}n.MonthsTicker=_,s=_,_.__name__="MonthsTicker",s.define((({Int:t,Array:e})=>({months:[e(t),[]]})))},
function _(e,t,a,i,r){i();const n=e(182),_=e(179),s=e(173);class c extends _.SingleIntervalTicker{constructor(e){super(e)}initialize(){super.initialize(),this.interval=s.ONE_YEAR,this.basic_ticker=new n.BasicTicker({num_minor_ticks:0})}get_ticks_no_defaults(e,t,a,i){const r=(0,s.last_year_no_later_than)(new Date(e)).getUTCFullYear(),n=(0,s.last_year_no_later_than)(new Date(t)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,n,a,i).major.map((e=>Date.UTC(e,0,1))).filter((a=>e<=a&&a<=t)),minor:[]}}}a.YearsTicker=c,c.__name__="YearsTicker"},
function _(c,e,s,i,n){i();const r=c(175);class t extends r.AdaptiveTicker{constructor(c){super(c)}}s.BasicTicker=t,t.__name__="BasicTicker"},
function _(e,i,s,n,r){var t;n();const a=e(166),o=e(184),c=e(182);class _ extends a.ContinuousAxisView{}s.LinearAxisView=_,_.__name__="LinearAxisView";class u extends a.ContinuousAxis{constructor(e){super(e)}}s.LinearAxis=u,t=u,u.__name__="LinearAxis",t.prototype.default_view=_,t.override({ticker:()=>new c.BasicTicker,formatter:()=>new o.BasicTickFormatter})},
function _(i,t,e,n,o){var r;n();const s=i(161),c=i(38);function _(i){let t="";for(const e of i)t+="-"==e?"\u2212":e;return t}e.unicode_replace=_;class a extends s.TickFormatter{constructor(i){super(i),this.last_precision=3}get scientific_limit_low(){return 10**this.power_limit_low}get scientific_limit_high(){return 10**this.power_limit_high}_need_sci(i){if(!this.use_scientific)return!1;const{scientific_limit_high:t}=this,{scientific_limit_low:e}=this,n=i.length<2?0:Math.abs(i[1]-i[0])/1e4;for(const o of i){const i=Math.abs(o);if(!(i<=n)&&(i>=t||i<=e))return!0}return!1}_format_with_precision(i,t,e){return t?i.map((i=>_(i.toExponential(e)))):i.map((i=>_((0,c.to_fixed)(i,e))))}_auto_precision(i,t){const e=new Array(i.length),n=this.last_precision<=15;i:for(let o=this.last_precision;n?o<=15:o>=1;n?o++:o--){if(t){e[0]=i[0].toExponential(o);for(let t=1;t<i.length;t++)if(e[t]==e[t-1])continue i;this.last_precision=o;break}e[0]=(0,c.to_fixed)(i[0],o);for(let t=1;t<i.length;t++)if(e[t]=(0,c.to_fixed)(i[t],o),e[t]==e[t-1])continue i;this.last_precision=o;break}return this.last_precision}doFormat(i,t){if(0==i.length)return[];const e=this._need_sci(i),n="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,n)}}e.BasicTickFormatter=a,r=a,a.__name__="BasicTickFormatter",r.define((({Boolean:i,Int:t,Auto:e,Or:n})=>({precision:[n(t,e),"auto"],use_scientific:[i,!0],power_limit_high:[t,5],power_limit_low:[t,-3]})))},
function _(e,o,i,s,t){var n;s();const r=e(166),_=e(186),c=e(187);class a extends r.ContinuousAxisView{}i.LogAxisView=a,a.__name__="LogAxisView";class u extends r.ContinuousAxis{constructor(e){super(e)}}i.LogAxis=u,n=u,u.__name__="LogAxis",n.prototype.default_view=a,n.override({ticker:()=>new c.LogTicker,formatter:()=>new _.LogTickFormatter})},
function _(e,t,n,o,r){var i;o();const a=e(161),s=e(184),c=e(187),l=e(150),{abs:u,log:x,round:_}=Math;class p extends a.TickFormatter{constructor(e){super(e)}initialize(){super.initialize(),this.basic_formatter=new s.BasicTickFormatter}format_graphics(e,t){var n,o;if(0==e.length)return[];const r=null!==(o=null===(n=this.ticker)||void 0===n?void 0:n.base)&&void 0!==o?o:10,i=this._exponents(e,r);return null==i?this.basic_formatter.format_graphics(e,t):i.map((e=>{if(u(e)<this.min_exponent){const t=new l.TextBox({text:(0,s.unicode_replace)(`${r**e}`)}),n=new l.TextBox({text:""});return new l.BaseExpo(t,n)}{const t=new l.TextBox({text:(0,s.unicode_replace)(`${r}`)}),n=new l.TextBox({text:(0,s.unicode_replace)(`${e}`)});return new l.BaseExpo(t,n)}}))}_exponents(e,t){let n=null;const o=[];for(const r of e){const e=_(x(r)/x(t));if(n==e)return null;n=e,o.push(e)}return o}doFormat(e,t){var n,o;if(0==e.length)return[];const r=null!==(o=null===(n=this.ticker)||void 0===n?void 0:n.base)&&void 0!==o?o:10,i=this._exponents(e,r);return null==i?this.basic_formatter.doFormat(e,t):i.map((e=>u(e)<this.min_exponent?(0,s.unicode_replace)(`${r**e}`):(0,s.unicode_replace)(`${r}^${e}`)))}}n.LogTickFormatter=p,i=p,p.__name__="LogTickFormatter",i.define((({Int:e,Ref:t,Nullable:n})=>({ticker:[n(t(c.LogTicker)),null],min_exponent:[e,0]})))},
function _(t,o,e,s,n){var r;s();const i=t(175),a=t(10);class c extends i.AdaptiveTicker{constructor(t){super(t)}get_ticks_no_defaults(t,o,e,s){const n=this.num_minor_ticks,r=[],i=this.base,c=Math.log(t)/Math.log(i),f=Math.log(o)/Math.log(i),l=f-c;let h;if(isFinite(l)&&0!=l)if(l<2){const e=this.get_interval(t,o,s),i=Math.floor(t/e),c=Math.ceil(o/e);if(h=(0,a.range)(i,c+1).filter((t=>0!=t)).map((t=>t*e)).filter((e=>t<=e&&e<=o)),n>0&&h.length>0){const t=e/n,o=(0,a.range)(0,n).map((o=>o*t));for(const t of o.slice(1))r.push(h[0]-t);for(const t of h)for(const e of o)r.push(t+e)}}else{const t=Math.ceil(.999999*c),o=Math.floor(1.000001*f),e=Math.ceil((o-t)/9);if(h=(0,a.range)(t-1,o+1,e).map((t=>i**t)),n>0&&h.length>0){const t=i**e/n,o=(0,a.range)(1,n+1).map((o=>o*t));for(const t of o)r.push(h[0]/t);r.push(h[0]);for(const t of h)for(const e of o)r.push(t*e)}}else h=[];return{major:h.filter((e=>t<=e&&e<=o)),minor:r.filter((e=>t<=e&&e<=o))}}}e.LogTicker=c,r=c,c.__name__="LogTicker",r.override({mantissas:[1,5]})},
function _(e,r,t,i,a){var o;i();const s=e(158),c=e(183),n=e(189),_=e(190);class x extends s.AxisView{}t.MercatorAxisView=x,x.__name__="MercatorAxisView";class d extends c.LinearAxis{constructor(e){super(e)}}t.MercatorAxis=d,o=d,d.__name__="MercatorAxis",o.prototype.default_view=x,o.override({ticker:()=>new _.MercatorTicker({dimension:"lat"}),formatter:()=>new n.MercatorTickFormatter({dimension:"lat"})})},
function _(r,t,e,o,n){var i;o();const c=r(184),s=r(19),a=r(104);class l extends c.BasicTickFormatter{constructor(r){super(r)}doFormat(r,t){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==r.length)return[];const e=r.length,o=new Array(e);if("lon"==this.dimension)for(let n=0;n<e;n++){const[e]=a.wgs84_mercator.invert(r[n],t.loc);o[n]=e}else for(let n=0;n<e;n++){const[,e]=a.wgs84_mercator.invert(t.loc,r[n]);o[n]=e}return super.doFormat(o,t)}}e.MercatorTickFormatter=l,i=l,l.__name__="MercatorTickFormatter",i.define((({Nullable:r})=>({dimension:[r(s.LatLon),null]})))},
function _(t,o,n,s,r){var e;s();const i=t(182),c=t(19),_=t(104);class a extends i.BasicTicker{constructor(t){super(t)}get_ticks_no_defaults(t,o,n,s){if(null==this.dimension)throw new Error(`${this}.dimension wasn't configured`);return[t,o]=(0,_.clip_mercator)(t,o,this.dimension),"lon"==this.dimension?this._get_ticks_lon(t,o,n,s):this._get_ticks_lat(t,o,n,s)}_get_ticks_lon(t,o,n,s){const[r]=_.wgs84_mercator.invert(t,n),[e,i]=_.wgs84_mercator.invert(o,n),c=super.get_ticks_no_defaults(r,e,n,s),a=[];for(const t of c.major)if((0,_.in_bounds)(t,"lon")){const[o]=_.wgs84_mercator.compute(t,i);a.push(o)}const m=[];for(const t of c.minor)if((0,_.in_bounds)(t,"lon")){const[o]=_.wgs84_mercator.compute(t,i);m.push(o)}return{major:a,minor:m}}_get_ticks_lat(t,o,n,s){const[,r]=_.wgs84_mercator.invert(n,t),[e,i]=_.wgs84_mercator.invert(n,o),c=super.get_ticks_no_defaults(r,i,n,s),a=[];for(const t of c.major)if((0,_.in_bounds)(t,"lat")){const[,o]=_.wgs84_mercator.compute(e,t);a.push(o)}const m=[];for(const t of c.minor)if((0,_.in_bounds)(t,"lat")){const[,o]=_.wgs84_mercator.compute(e,t);m.push(o)}return{major:a,minor:m}}}n.MercatorTicker=a,e=a,a.__name__="MercatorTicker",e.define((({Nullable:t})=>({dimension:[t(c.LatLon),null]})))},
function _(e,i,r,c,k){c(),k("AdaptiveTicker",e(175).AdaptiveTicker),k("BasicTicker",e(182).BasicTicker),k("CategoricalTicker",e(164).CategoricalTicker),k("CompositeTicker",e(177).CompositeTicker),k("ContinuousTicker",e(176).ContinuousTicker),k("DatetimeTicker",e(174).DatetimeTicker),k("DaysTicker",e(178).DaysTicker),k("FixedTicker",e(192).FixedTicker),k("LogTicker",e(187).LogTicker),k("MercatorTicker",e(190).MercatorTicker),k("MonthsTicker",e(180).MonthsTicker),k("SingleIntervalTicker",e(179).SingleIntervalTicker),k("Ticker",e(160).Ticker),k("YearsTicker",e(181).YearsTicker),k("BinnedTicker",e(193).BinnedTicker)},
function _(e,r,t,i,n){var s;i();const _=e(176);class c extends _.ContinuousTicker{constructor(e){super(e)}get_ticks_no_defaults(e,r,t,i){return{major:[...this.ticks],minor:[...this.minor_ticks]}}get_interval(e,r,t){return 0}get_min_interval(){return 0}get_max_interval(){return 0}}t.FixedTicker=c,s=c,c.__name__="FixedTicker",s.define((({Number:e,Arrayable:r})=>({ticks:[r(e),[]],minor_ticks:[r(e),[]]})))},
function _(e,n,t,r,i){var o;r();const a=e(160),s=e(194),c=e(13);class m extends a.Ticker{constructor(e){super(e)}get_ticks(e,n,t,r){const{binning:i}=this.mapper.metrics,o=Math.max(0,(0,c.left_edge_index)(e,i)),a=Math.min((0,c.left_edge_index)(n,i)+1,i.length-1),s=[];for(let e=o;e<=a;e++)s.push(i[e]);const{num_major_ticks:m}=this,_=[],h="auto"==m?s.length:m,l=Math.max(1,Math.floor(s.length/h));for(let e=0;e<s.length;e+=l)_.push(s[e]);return{major:_,minor:[]}}}t.BinnedTicker=m,o=m,m.__name__="BinnedTicker",o.define((({Number:e,Ref:n,Or:t,Auto:r})=>({mapper:[n(s.ScanningColorMapper)],num_major_ticks:[t(e,r),8]})))},
function _(n,i,e,t,a){t();const o=n(195),_=n(13);class r extends o.ContinuousColorMapper{constructor(n){super(n)}index_to_value(n){return this._scan_data.binning[n]}value_to_index(n,i){const e=this._scan_data;return n<e.binning[0]?-1:n>e.binning[e.binning.length-1]?i:(0,_.left_edge_index)(n,e.binning)}}e.ScanningColorMapper=r,r.__name__="ScanningColorMapper"},
function _(t,e,o,n,s){var l;n();const i=t(196),c=t(198),a=t(10),h=t(8);class r extends i.ColorMapper{constructor(t){super(t),this._scan_data=null}connect_signals(){super.connect_signals();const t=()=>{for(const[t]of this.domain)this.connect(t.view.change,(()=>this.update_data())),this.connect(t.data_source.selected.change,(()=>this.update_data()))},{high:e,low:o,high_color:n,low_color:s,palette:l,nan_color:i}=this.properties;this.on_change([e,o,n,s,l,i],(()=>this.update_data())),this.connect(this.properties.domain.change,(()=>t())),t()}update_data(){const{domain:t,palette:e}=this,o=[...this._collect(t)];this._scan_data=this.scan(o,e.length),this.metrics_change.emit(),this.change.emit()}get metrics(){return null==this._scan_data&&this.update_data(),this._scan_data}*_collect(t){for(const[e,o]of t)for(const t of(0,h.isArray)(o)?o:[o]){if(e.view.properties.indices.is_unset)continue;const o=e.data_source.get_column(t);if(null==o)continue;let n=e.view.indices.select(o);const s=e.view.masked,l=e.data_source.selected.indices;let i;if(null!=s&&l.length>0?i=(0,a.intersection)([...s],l):null!=s?i=[...s]:l.length>0&&(i=l),null!=i&&(n=(0,a.map)(i,(t=>n[t]))),n.length>0&&!(0,h.isNumber)(n[0]))for(const t of n)yield*t;else yield*n}}_v_compute(t,e,o,n){const{nan_color:s}=n;let{low_color:l,high_color:i}=n;null==l&&(l=o[0]),null==i&&(i=o[o.length-1]);const{domain:c}=this,h=(0,a.is_empty)(c)?t:[...this._collect(c)];this._scan_data=this.scan(h,o.length),this.metrics_change.emit();for(let n=0,c=t.length;n<c;n++){const c=t[n];isNaN(c)?e[n]=s:e[n]=this.cmap(c,o,l,i)}}_colors(t){return Object.assign(Object.assign({},super._colors(t)),{low_color:null!=this.low_color?t(this.low_color):void 0,high_color:null!=this.high_color?t(this.high_color):void 0})}cmap(t,e,o,n){const s=this.value_to_index(t,e.length);return s<0?o:s>=e.length?n:e[s]}}o.ContinuousColorMapper=r,l=r,r.__name__="ContinuousColorMapper",l.define((({Number:t,String:e,Ref:o,Color:n,Or:s,Tuple:l,Array:i,Nullable:a})=>({high:[a(t),null],low:[a(t),null],high_color:[a(n),null],low_color:[a(n),null],domain:[i(l(o(c.GlyphRenderer),s(e,i(e)))),[]]})))},
function _(e,r,t,n,o){var a;n();const c=e(197),i=e(15),_=e(23),l=e(21),s=e(26);function p(e){return(0,l.encode_rgba)((0,l.color2rgba)(e))}function u(e){const r=new Uint32Array(e.length);for(let t=0,n=e.length;t<n;t++)r[t]=p(e[t]);return r}t._convert_color=p,t._convert_palette=u;class h extends c.Mapper{constructor(e){super(e)}initialize(){super.initialize(),this.metrics_change=new i.Signal0(this,"metrics_change")}v_compute(e){const r=new Array(e.length);return this._v_compute(e,r,this.palette,this._colors((e=>e))),r}get rgba_mapper(){const e=this,r=u(this.palette),t=this._colors(p);return{v_compute(n){const o=new _.ColorArray(n.length);return e._v_compute(n,o,r,t),new Uint8ClampedArray((0,s.to_big_endian)(o).buffer)}}}_colors(e){return{nan_color:e(this.nan_color)}}}t.ColorMapper=h,a=h,h.__name__="ColorMapper",a.define((({Color:e,Array:r})=>({palette:[r(e)],nan_color:[e,"gray"]})))},
function _(r,e,n,s,o){s();const p=r(85);class t extends p.Transform{constructor(r){super(r)}compute(r){throw new Error("mapping single values is not supported")}}n.Mapper=t,t.__name__="Mapper"},
function _(e,t,i,s,l){var n;s();const h=e(199),o=e(200),c=e(210),a=e(211),_=e(213),d=e(202),r=e(98),p=e(214),g=e(23),u=e(13),y=e(9),m=e(58),v=e(25),w=e(95),f=e(207),b={fill:{},line:{}},V={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},G={fill:{fill_alpha:.2},line:{}},x={fill:{fill_alpha:.2},line:{}};class R extends h.DataRendererView{get glyph_view(){return this.glyph}get data_source(){return this.model.properties.data_source}async lazy_initialize(){var e;await super.lazy_initialize(),this.cds_view=await(0,m.build_view)(this.model.view,{parent:this});const t=this.model.glyph;this.glyph=await this.build_glyph_view(t);const i="fill"in this.glyph.visuals,s="line"in this.glyph.visuals,l=Object.assign({},t.attributes);function n(e){const n=(0,y.clone)(l);return i&&(0,y.extend)(n,e.fill),s&&(0,y.extend)(n,e.line),new t.constructor(n)}function h(e,t){return t instanceof d.Glyph?t:n("auto"==t?e:{fill:{},line:{}})}delete l.id;let{selection_glyph:o,nonselection_glyph:c,hover_glyph:a,muted_glyph:_}=this.model;o=h(b,o),this.selection_glyph=await this.build_glyph_view(o),c=h(G,c),this.nonselection_glyph=await this.build_glyph_view(c),null!=a&&(this.hover_glyph=await this.build_glyph_view(a)),_=h(x,_),this.muted_glyph=await this.build_glyph_view(_);const r=h(V,"auto");this.decimated_glyph=await this.build_glyph_view(r),this.selection_glyph.set_base(this.glyph),this.nonselection_glyph.set_base(this.glyph),null===(e=this.hover_glyph)||void 0===e||e.set_base(this.glyph),this.muted_glyph.set_base(this.glyph),this.decimated_glyph.set_base(this.glyph),this.set_data()}async build_glyph_view(e){return(0,m.build_view)(e,{parent:this})}remove(){var e;this.cds_view.remove(),this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(e=this.hover_glyph)||void 0===e||e.remove(),this.muted_glyph.remove(),this.decimated_glyph.remove(),super.remove()}connect_signals(){super.connect_signals();const e=()=>this.request_render(),t=()=>this.update_data();this.connect(this.model.change,e),this.connect(this.glyph.model.change,t),this.connect(this.selection_glyph.model.change,t),this.connect(this.nonselection_glyph.model.change,t),null!=this.hover_glyph&&this.connect(this.hover_glyph.model.change,t),this.connect(this.muted_glyph.model.change,t),this.connect(this.decimated_glyph.model.change,t),this.connect(this.model.data_source.change,t),this.connect(this.model.data_source.streaming,t),this.connect(this.model.data_source.patching,(e=>this.update_data(e))),this.connect(this.model.data_source.selected.change,e),this.connect(this.model.data_source._select,e),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,(()=>{const{inspected:t}=this.model.data_source,i={indices:t.indices,line_indices:t.line_indices,multiline_indices:t.multiline_indices,image_indices:t.image_indices,selected_glyphs:t.selected_glyphs};(0,v.is_equal)(this._previous_inspected,i)||(this._previous_inspected=i,e())})),this.connect(this.model.properties.view.change,(async()=>{this.cds_view.remove(),this.cds_view=await(0,m.build_view)(this.model.view,{parent:this}),t()})),this.connect(this.model.view.properties.indices.change,t),this.connect(this.model.view.properties.masked.change,(()=>this.set_visuals())),this.connect(this.model.properties.visible.change,(()=>this.plot_view.invalidate_dataranges=!0));const{x_ranges:i,y_ranges:s}=this.plot_view.frame;for(const[,e]of i)e instanceof w.FactorRange&&this.connect(e.change,t);for(const[,e]of s)e instanceof w.FactorRange&&this.connect(e.change,t);const{transformchange:l,exprchange:n}=this.model.glyph;this.connect(l,t),this.connect(n,t)}_update_masked_indices(){const e=this.glyph.mask_data();return this.model.view.masked=e,e}update_data(e){this.set_data(e),this.request_render()}set_data(e){const t=this.model.data_source;this.all_indices=this.model.view.indices;const{all_indices:i}=this;this.glyph.set_data(t,i,e),this.set_visuals(),this._update_masked_indices();const{lod_factor:s}=this.plot_model,l=this.all_indices.count;this.decimated=new g.Indices(l);for(let e=0;e<l;e+=s)this.decimated.set(e);this.plot_view.invalidate_dataranges=!0}set_visuals(){var e;const t=this.model.data_source,{all_indices:i}=this;this.glyph.set_visuals(t,i),this.decimated_glyph.set_visuals(t,i),this.selection_glyph.set_visuals(t,i),this.nonselection_glyph.set_visuals(t,i),null===(e=this.hover_glyph)||void 0===e||e.set_visuals(t,i),this.muted_glyph.set_visuals(t,i)}get has_webgl(){return this.glyph.has_webgl}_render(){const e=this.has_webgl;this.glyph.map_data();const t=[...this.all_indices];let i=[...this._update_masked_indices()];const{ctx:s}=this.layer;s.save();const{selected:l}=this.model.data_source;let n;n=l.is_empty()?[]:this.glyph instanceof o.LineView&&l.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(i):l.indices;const{inspected:h}=this.model.data_source;this._previous_inspected={indices:h.indices,line_indices:h.line_indices,multiline_indices:h.multiline_indices,image_indices:h.image_indices,selected_glyphs:h.selected_glyphs};const d=new Set((()=>h.is_empty()?[]:h.selected_glyph?this.model.view.convert_indices_from_subset(i):h.indices.length>0?h.indices:Object.keys(h.multiline_indices).map((e=>parseInt(e))))()),r=(0,u.filter)(i,(e=>d.has(t[e]))),{lod_threshold:p}=this.plot_model;let g,y,m;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!e&&null!=p&&t.length>p?(i=[...this.decimated],g=this.decimated_glyph,y=this.decimated_glyph,m=this.selection_glyph):(g=this.model.muted?this.muted_glyph:this.glyph,y=this.nonselection_glyph,m=this.selection_glyph),null!=this.hover_glyph&&r.length){const e=new Set(i);for(const t of r)e.delete(t);i=[...e]}if(n.length){const e=new Set(n),l=new Array,h=new Array;if(this.glyph instanceof o.LineView)for(const i of t)e.has(i)?l.push(i):h.push(i);else for(const s of i)e.has(t[s])?l.push(s):h.push(s);y.render(s,h),m.render(s,l),null!=this.hover_glyph&&(this.glyph instanceof o.LineView?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(r)):this.hover_glyph.render(s,r))}else if(this.glyph instanceof o.LineView)null!=this.hover_glyph&&r.length?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(r)):g.render(s,t);else if(this.glyph instanceof c.PatchView||this.glyph instanceof a.HAreaView||this.glyph instanceof _.VAreaView)if(0==h.selected_glyphs.length||null==this.hover_glyph)g.render(s,t);else for(const e of h.selected_glyphs)e==this.glyph.model&&this.hover_glyph.render(s,t);else g.render(s,i),null!=this.hover_glyph&&r.length&&this.hover_glyph.render(s,r);s.restore()}get_reference_point(e,t){if(null!=e){const i=this.model.data_source.get_column(e);if(null!=i)for(const[e,s]of(0,y.entries)(this.model.view.indices_map))if(i[parseInt(e)]==t)return s}return 0}draw_legend(e,t,i,s,l,n,h,o){0!=this.glyph.data_size&&(null==o&&(o=this.get_reference_point(n,h)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:s,y1:l},o))}hit_test(e){if(!this.model.visible)return null;const t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)}}i.GlyphRendererView=R,R.__name__="GlyphRendererView";class k extends h.DataRenderer{constructor(e){super(e)}get_selection_manager(){return this.data_source.selection_manager}add_decoration(e,t){const i=new f.Decoration({marking:e,node:t}),s=[this.glyph,this.selection_glyph,this.nonselection_glyph,this.hover_glyph,this.muted_glyph];for(const e of s)e instanceof d.Glyph&&(e.decorations=[...e.decorations,i]);return i}}i.GlyphRenderer=k,n=k,k.__name__="GlyphRenderer",n.prototype.default_view=R,n.define((({Boolean:e,Auto:t,Or:i,Ref:s,Null:l,Nullable:n})=>({data_source:[s(r.ColumnarDataSource)],view:[s(p.CDSView),()=>new p.CDSView],glyph:[s(d.Glyph)],hover_glyph:[n(s(d.Glyph)),null],nonselection_glyph:[i(s(d.Glyph),t,l),"auto"],selection_glyph:[i(s(d.Glyph),t,l),"auto"],muted_glyph:[i(s(d.Glyph),t,l),"auto"],muted:[e,!1]})))},
function _(e,r,t,a,n){var s;a();const c=e(73);class _ extends c.RendererView{get xscale(){return this.coordinates.x_scale}get yscale(){return this.coordinates.y_scale}}t.DataRendererView=_,_.__name__="DataRendererView";class i extends c.Renderer{constructor(e){super(e)}get selection_manager(){return this.get_selection_manager()}}t.DataRenderer=i,s=i,i.__name__="DataRenderer",s.override({level:"glyph"})},
function _(e,t,i,s,n){s();const l=e(1);var _;const r=e(201),o=e(208),a=l.__importStar(e(77)),h=l.__importStar(e(209)),c=e(100);class d extends r.XYGlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:t}=this.renderer.plot_view.canvas_view;if(null!=t&&t.regl_wrapper.has_webgl){const{LineGL:i}=await Promise.resolve().then((()=>l.__importStar(e(507))));this.glglyph=new i(t.regl_wrapper,this)}}_render(e,t,i){const{sx:s,sy:n}=null!=i?i:this;let l=null;const _=e=>null!=l&&e-l!=1;let r=!0;e.beginPath();for(const i of t){const t=s[i],o=n[i];isFinite(t+o)?r||_(i)?(e.moveTo(t,o),r=!1):e.lineTo(t,o):r=!0,l=i}this.visuals.line.set_value(e),e.stroke()}_hit_point(e){const t=new c.Selection,i={x:e.sx,y:e.sy};let s=9999;const n=Math.max(2,this.line_width.value/2);for(let e=0,l=this.sx.length-1;e<l;e++){const l={x:this.sx[e],y:this.sy[e]},_={x:this.sx[e+1],y:this.sy[e+1]},r=h.dist_to_segment(i,l,_);r<n&&r<s&&(s=r,t.add_to_selected_glyphs(this.model),t.view=this,t.line_indices=[e])}return t}_hit_span(e){const{sx:t,sy:i}=e,s=new c.Selection;let n,l;"v"==e.direction?(n=this.renderer.yscale.invert(i),l=this._y):(n=this.renderer.xscale.invert(t),l=this._x);for(let e=0,t=l.length-1;e<t;e++)(l[e]<=n&&n<=l[e+1]||l[e+1]<=n&&n<=l[e])&&(s.add_to_selected_glyphs(this.model),s.view=this,s.line_indices.push(e));return s}get_interpolation_hit(e,t){const[i,s,n,l]=[this._x[e],this._y[e],this._x[e+1],this._y[e+1]];return(0,o.line_interpolation)(this.renderer,t,i,s,n,l)}draw_legend_for_index(e,t,i){(0,o.generic_line_scalar_legend)(this.visuals,e,t)}}i.LineView=d,d.__name__="LineView";class p extends r.XYGlyph{constructor(e){super(e)}}i.Line=p,_=p,p.__name__="Line",_.prototype.default_view=d,_.mixins(a.LineScalar)},
function _(e,t,_,s,i){s();const n=e(1);var a;const o=e(104),c=n.__importStar(e(17)),p=e(202);class r extends p.GlyphView{_project_data(){o.inplace.project_xy(this._x,this._y)}_index_data(e){const{_x:t,_y:_,data_size:s}=this;for(let i=0;i<s;i++){const s=t[i],n=_[i];e.add_point(s,n)}}scenterxy(e){return[this.sx[e],this.sy[e]]}}_.XYGlyphView=r,r.__name__="XYGlyphView";class d extends p.Glyph{constructor(e){super(e)}}_.XYGlyph=d,a=d,d.__name__="XYGlyph",a.define((({})=>({x:[c.XCoordinateSpec,{field:"x"}],y:[c.YCoordinateSpec,{field:"y"}]})))},
function _(e,t,s,i,n){i();const a=e(1);var r;const o=a.__importStar(e(17)),_=a.__importStar(e(56)),l=a.__importStar(e(74)),c=e(53),h=e(50),d=e(58),u=e(18),f=e(23),p=e(8),g=e(203),y=e(13),v=e(25),x=e(204),m=e(95),w=e(100),b=e(207),{abs:S,ceil:z}=Math;class $ extends c.View{constructor(){super(...arguments),this._index=null,this._data_size=null,this._nohit_warned=new Set,this.decorations=new Map}get renderer(){return this.parent}get has_webgl(){return null!=this.glglyph}get index(){const{_index:e}=this;if(null!=e)return e;throw new Error(`${this}.index_data() wasn't called`)}get data_size(){const{_data_size:e}=this;if(null!=e)return e;throw new Error(`${this}.set_data() wasn't called`)}initialize(){super.initialize(),this.visuals=new l.Visuals(this)}async lazy_initialize(){await super.lazy_initialize(),await(0,d.build_views)(this.decorations,this.model.decorations,{parent:this.parent})}request_render(){this.parent.request_render()}get canvas(){return this.renderer.parent.canvas_view}render(e,t,s){var i;null!=this.glglyph&&(this.renderer.needs_webgl_blit=this.glglyph.render(e,t,null!==(i=this.base)&&void 0!==i?i:this),this.renderer.needs_webgl_blit)||this._render(e,t,null!=s?s:this.base)}has_finished(){return!0}notify_finished(){this.renderer.notify_finished()}_bounds(e){return e}bounds(){return this._bounds(this.index.bbox)}log_bounds(){const{x0:e,x1:t}=this.index.bounds(_.positive_x()),{y0:s,y1:i}=this.index.bounds(_.positive_y());return this._bounds({x0:e,y0:s,x1:t,y1:i})}get_anchor_point(e,t,[s,i]){switch(e){case"center":case"center_center":{const[e,n]=this.scenterxy(t,s,i);return{x:e,y:n}}default:return null}}sdist(e,t,s,i="edge",n=!1){const a=t.length,r=new f.ScreenArray(a),o=e.s_compute;if("center"==i)for(let e=0;e<a;e++){const i=t[e],n=s.get(e)/2,a=o(i-n),_=o(i+n);r[e]=S(_-a)}else for(let e=0;e<a;e++){const i=t[e],n=o(i),a=o(i+s.get(e));r[e]=S(a-n)}return n&&(0,y.inplace_map)(r,(e=>z(e))),r}draw_legend_for_index(e,t,s){}hit_test(e){switch(e.type){case"point":if(null!=this._hit_point)return this._hit_point(e);break;case"span":if(null!=this._hit_span)return this._hit_span(e);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(e);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(e)}return this._nohit_warned.has(e.type)||(u.logger.debug(`'${e.type}' selection not available for ${this.model.type}`),this._nohit_warned.add(e.type)),null}_hit_rect_against_index(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,[a,r]=this.renderer.coordinates.x_scale.r_invert(t,s),[o,_]=this.renderer.coordinates.y_scale.r_invert(i,n),l=[...this.index.indices({x0:a,x1:r,y0:o,y1:_})];return new w.Selection({indices:l})}_project_data(){}*_iter_visuals(){for(const e of this.visuals)for(const t of e)(t instanceof o.VectorSpec||t instanceof o.ScalarSpec)&&(yield t)}set_base(e){e!=this&&e instanceof this.constructor&&(this.base=e)}_configure(e,t){Object.defineProperty(this,(0,p.isString)(e)?e:e.attr,Object.assign({configurable:!0,enumerable:!0},t))}set_visuals(e,t){var s;for(const s of this._iter_visuals()){const{base:i}=this;if(null!=i){const e=i.model.properties[s.attr];if(null!=e&&(0,v.is_equal)(s.get_value(),e.get_value())){this._configure(s,{get:()=>i[`${s.attr}`]});continue}}const n=s.uniform(e).select(t);this._configure(s,{value:n})}for(const e of this.visuals)e.update();null===(s=this.glglyph)||void 0===s||s.set_visuals_changed()}set_data(e,t,s){var i;const{x_source:n,y_source:a}=this.renderer.coordinates,r=new Set(this._iter_visuals());this._data_size=t.count;for(const s of this.model)if((s instanceof o.VectorSpec||s instanceof o.ScalarSpec)&&!r.has(s))if(s instanceof o.BaseCoordinateSpec){const i=s.array(e);let r=t.select(i);const _="x"==s.dimension?n:a;if(_ instanceof m.FactorRange)if(s instanceof o.CoordinateSpec)r=_.v_synthetic(r);else if(s instanceof o.CoordinateSeqSpec)for(let e=0;e<r.length;e++)r[e]=_.v_synthetic(r[e]);let l;l=s instanceof o.CoordinateSeqSpec?g.RaggedArray.from(r,Float64Array):r,this._configure(`_${s.attr}`,{value:l})}else{const i=s.uniform(e).select(t);if(this._configure(s,{value:i}),s instanceof o.DistanceSpec){const e=i.is_Scalar()?i.value:(0,y.max)(i.array);this._configure(`max_${s.attr}`,{value:e})}}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(null!=s?s:null);for(const s of this.decorations.values())s.marking.set_data(e,t);null===(i=this.glglyph)||void 0===i||i.set_data_changed(),this.index_data()}_set_data(e){}get _index_size(){return this.data_size}index_data(){const e=new x.SpatialIndex(this._index_size);this._index_data(e),e.finish(),this._index=e}mask_data(){return null==this._mask_data?f.Indices.all_set(this.data_size):this._mask_data()}map_data(){var e;const t=this,{x_scale:s,y_scale:i}=this.renderer.coordinates;for(const e of this.model)if(e instanceof o.BaseCoordinateSpec){const n="x"==e.dimension?s:i;let a=t[`_${e.attr}`];if(a instanceof g.RaggedArray){const e=n.v_compute(a.array);a=new g.RaggedArray(a.offsets,e)}else a=n.v_compute(a);this[`s${e.attr}`]=a}this._map_data(),null===(e=this.glglyph)||void 0===e||e.set_data_changed()}_map_data(){}}s.GlyphView=$,$.__name__="GlyphView";class k extends h.Model{constructor(e){super(e)}}s.Glyph=k,r=k,k.__name__="Glyph",r.define((({Array:e,Ref:t})=>({decorations:[e(t(b.Decoration)),[]]})))},
function _(t,s,r,e,a){var n;e();const o=t(25),h=t(12);class i{constructor(t,s){this.offsets=t,this.array=s}[(n=Symbol.toStringTag,o.equals)](t,s){return s.arrays(this.offsets,t.offsets)&&s.arrays(this.array,t.array)}get length(){return this.offsets.length}clone(){return new i(this.offsets.slice(),this.array.slice())}static from(t,s){const r=t.length;let e=0;const a=(()=>{const s=new Uint32Array(r);for(let a=0;a<r;a++){const r=t[a].length;s[a]=e,e+=r}return e<256?new Uint8Array(s):e<65536?new Uint16Array(s):s})(),n=new s(e);for(let s=0;s<r;s++)n.set(t[s],a[s]);return new i(a,n)}*[Symbol.iterator](){const{offsets:t,length:s}=this;for(let r=0;r<s;r++)yield this.array.subarray(t[r],t[r+1])}_check_bounds(t){(0,h.assert)(0<=t&&t<this.length,`Out of bounds: 0 <= ${t} < ${this.length}`)}get(t){this._check_bounds(t);const{offsets:s}=this;return this.array.subarray(s[t],s[t+1])}set(t,s){this._check_bounds(t),this.array.set(s,this.offsets[t])}}r.RaggedArray=i,i.__name__="RaggedArray",i[n]="RaggedArray"},
function _(i,t,n,e,s){e();const d=i(1).__importDefault(i(205)),o=i(23),x=i(56);function h(i,t){let n=0,e=t.length-1;for(;n<e;){const s=n+e>>1;t[s]>i?e=s:n=s+1}return t[n]}class r extends d.default{get boxes(){return this._boxes}search_indices(i,t,n,e){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let s=this._boxes.length-4;const d=[],x=new o.Indices(this.numItems);for(;void 0!==s;){const o=Math.min(s+4*this.nodeSize,h(s,this._levelBounds));for(let h=s;h<o;h+=4){const o=0|this._indices[h>>2],r=this._boxes[h+0],l=this._boxes[h+1],a=this._boxes[h+2],_=this._boxes[h+3];n<r||(e<l||i>a||t>_||(s<4*this.numItems?x.set(o):d.push(o)))}s=d.pop()}return x}}r.__name__="_FlatBush";class l{constructor(i){this.index=null,i>0&&(this.index=new r(i))}add_rect(i,t,n,e){var s;isFinite(i+t+n+e)?null===(s=this.index)||void 0===s||s.add(i,t,n,e):this.add_empty()}add_point(i,t){var n;isFinite(i+t)?null===(n=this.index)||void 0===n||n.add(i,t,i,t):this.add_empty()}add_empty(){var i;null===(i=this.index)||void 0===i||i.add(1/0,1/0,-1/0,-1/0)}finish(){var i;null===(i=this.index)||void 0===i||i.finish()}_normalize(i){let{x0:t,y0:n,x1:e,y1:s}=i;return t>e&&([t,e]=[e,t]),n>s&&([n,s]=[s,n]),{x0:t,y0:n,x1:e,y1:s}}get bbox(){if(null==this.index)return(0,x.empty)();{const{minX:i,minY:t,maxX:n,maxY:e}=this.index;return{x0:i,y0:t,x1:n,y1:e}}}indices(i){if(null==this.index)return new o.Indices(0);{const{x0:t,y0:n,x1:e,y1:s}=this._normalize(i);return this.index.search_indices(t,n,e,s)}}bounds(i){const t=(0,x.empty)();if(null==this.index)return t;const{boxes:n}=this.index;for(const e of this.indices(i)){const s=n[4*e+0],d=n[4*e+1],o=n[4*e+2],x=n[4*e+3];s>=i.x0&&s<t.x0&&(t.x0=s),o<=i.x1&&o>t.x1&&(t.x1=o),d>=i.y0&&d<t.y0&&(t.y0=d),x<=i.y1&&x>t.y1&&(t.y1=x)}return t}}n.SpatialIndex=l,l.__name__="SpatialIndex"},
function _(t,s,i,e,h){e();const n=t(1).__importDefault(t(206)),o=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class r{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[s,i]=new Uint8Array(t,0,2);if(251!==s)throw new Error("Data does not appear to be in a Flatbush format.");if(i>>4!=3)throw new Error(`Got v${i>>4} data when expected v3.`);const[e]=new Uint16Array(t,2,1),[h]=new Uint32Array(t,4,1);return new r(h,e,o[15&i],t)}constructor(t,s=16,i=Float64Array,e){if(void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+s,2),65535);let h=t,r=h;this._levelBounds=[4*h];do{h=Math.ceil(h/this.nodeSize),r+=h,this._levelBounds.push(4*r)}while(1!==h);this.ArrayType=i||Float64Array,this.IndexArrayType=r<16384?Uint16Array:Uint32Array;const a=o.indexOf(this.ArrayType),_=4*r*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error(`Unexpected typed array class: ${i}.`);e&&e instanceof ArrayBuffer?(this.data=e,this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=4*r,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+r*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=s,new Uint32Array(this.data,4,1)[0]=t),this._queue=new n.default}add(t,s,i,e){const h=this._pos>>2;return this._indices[h]=h,this._boxes[this._pos++]=t,this._boxes[this._pos++]=s,this._boxes[this._pos++]=i,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),s<this.minY&&(this.minY=s),i>this.maxX&&(this.maxX=i),e>this.maxY&&(this.maxY=e),h}finish(){if(this._pos>>2!==this.numItems)throw new Error(`Added ${this._pos>>2} items when expected ${this.numItems}.`);if(this.numItems<=this.nodeSize)return this._boxes[this._pos++]=this.minX,this._boxes[this._pos++]=this.minY,this._boxes[this._pos++]=this.maxX,void(this._boxes[this._pos++]=this.maxY);const t=this.maxX-this.minX||1,s=this.maxY-this.minY||1,i=new Uint32Array(this.numItems);for(let e=0;e<this.numItems;e++){let h=4*e;const n=this._boxes[h++],o=this._boxes[h++],r=this._boxes[h++],a=this._boxes[h++],_=Math.floor(65535*((n+r)/2-this.minX)/t),x=Math.floor(65535*((o+a)/2-this.minY)/s);i[e]=m(_,x)}x(i,this._boxes,this._indices,0,this.numItems-1,this.nodeSize);for(let t=0,s=0;t<this._levelBounds.length-1;t++){const i=this._levelBounds[t];for(;s<i;){const t=s;let e=1/0,h=1/0,n=-1/0,o=-1/0;for(let t=0;t<this.nodeSize&&s<i;t++)e=Math.min(e,this._boxes[s++]),h=Math.min(h,this._boxes[s++]),n=Math.max(n,this._boxes[s++]),o=Math.max(o,this._boxes[s++]);this._indices[this._pos>>2]=t,this._boxes[this._pos++]=e,this._boxes[this._pos++]=h,this._boxes[this._pos++]=n,this._boxes[this._pos++]=o}}}search(t,s,i,e,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const o=[],r=[];for(;void 0!==n;){const a=Math.min(n+4*this.nodeSize,_(n,this._levelBounds));for(let _=n;_<a;_+=4){if(i<this._boxes[_])continue;if(e<this._boxes[_+1])continue;if(t>this._boxes[_+2])continue;if(s>this._boxes[_+3])continue;const a=0|this._indices[_>>2];n<4*this.numItems?(void 0===h||h(a))&&r.push(a):o.push(a)}n=o.pop()}return r}neighbors(t,s,i=1/0,e=1/0,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const o=this._queue,r=[],x=e*e;for(;void 0!==n;){const e=Math.min(n+4*this.nodeSize,_(n,this._levelBounds));for(let i=n;i<e;i+=4){const e=0|this._indices[i>>2],r=a(t,this._boxes[i],this._boxes[i+2]),_=a(s,this._boxes[i+1],this._boxes[i+3]),x=r*r+_*_;n<4*this.numItems?(void 0===h||h(e))&&o.push(1+(e<<1),x):o.push(e<<1,x)}for(;o.length&&1&o.peek();){if(o.peekValue()>x)return o.clear(),r;if(r.push(o.pop()>>1),r.length===i)return o.clear(),r}n=o.pop()>>1}return o.clear(),r}}function a(t,s,i){return t<s?s-t:t<=i?0:t-i}function _(t,s){let i=0,e=s.length-1;for(;i<e;){const h=i+e>>1;s[h]>t?e=h:i=h+1}return s[i]}function x(t,s,i,e,h,n){if(Math.floor(e/n)>=Math.floor(h/n))return;const o=t[e+h>>1];let r=e-1,a=h+1;for(;;){do{r++}while(t[r]<o);do{a--}while(t[a]>o);if(r>=a)break;d(t,s,i,r,a)}x(t,s,i,e,a,n),x(t,s,i,a+1,h,n)}function d(t,s,i,e,h){const n=t[e];t[e]=t[h],t[h]=n;const o=4*e,r=4*h,a=s[o],_=s[o+1],x=s[o+2],d=s[o+3];s[o]=s[r],s[o+1]=s[r+1],s[o+2]=s[r+2],s[o+3]=s[r+3],s[r]=a,s[r+1]=_,s[r+2]=x,s[r+3]=d;const m=i[e];i[e]=i[h],i[h]=m}function m(t,s){let i=t^s,e=65535^i,h=65535^(t|s),n=t&(65535^s),o=i|e>>1,r=i>>1^i,a=h>>1^e&n>>1^h,_=i&h>>1^n>>1^n;i=o,e=r,h=a,n=_,o=i&i>>2^e&e>>2,r=i&e>>2^e&(i^e)>>2,a^=i&h>>2^e&n>>2,_^=e&h>>2^(i^e)&n>>2,i=o,e=r,h=a,n=_,o=i&i>>4^e&e>>4,r=i&e>>4^e&(i^e)>>4,a^=i&h>>4^e&n>>4,_^=e&h>>4^(i^e)&n>>4,i=o,e=r,h=a,n=_,a^=i&h>>8^e&n>>8,_^=e&h>>8^(i^e)&n>>8,i=a^a>>1,e=_^_>>1;let x=t^s,d=e|65535^(x|i);return x=16711935&(x|x<<8),x=252645135&(x|x<<4),x=858993459&(x|x<<2),x=1431655765&(x|x<<1),d=16711935&(d|d<<8),d=252645135&(d|d<<4),d=858993459&(d|d<<2),d=1431655765&(d|d<<1),(d<<1|x)>>>0}i.default=r},
function _(s,t,i,h,e){h();i.default=class{constructor(){this.ids=[],this.values=[],this.length=0}clear(){this.length=0}push(s,t){let i=this.length++;for(;i>0;){const s=i-1>>1,h=this.values[s];if(t>=h)break;this.ids[i]=this.ids[s],this.values[i]=h,i=s}this.ids[i]=s,this.values[i]=t}pop(){if(0===this.length)return;const s=this.ids[0];if(this.length--,this.length>0){const s=this.ids[0]=this.ids[this.length],t=this.values[0]=this.values[this.length],i=this.length>>1;let h=0;for(;h<i;){let s=1+(h<<1);const i=s+1;let e=this.ids[s],l=this.values[s];const n=this.values[i];if(i<this.length&&n<l&&(s=i,e=this.ids[i],l=n),l>=t)break;this.ids[h]=e,this.values[h]=l,h=s}this.ids[h]=s,this.values[h]=t}return s}peek(){if(0!==this.length)return this.ids[0]}peekValue(){if(0!==this.length)return this.values[0]}shrink(){this.ids.length=this.values.length=this.length}}},
function _(e,i,a,n,t){var o;n();const r=e(139),s=e(50),_=e(53),c=e(58);class d extends _.View{async lazy_initialize(){await super.lazy_initialize(),this.marking=await(0,c.build_view)(this.model.marking,{parent:this.parent})}}a.DecorationView=d,d.__name__="DecorationView";class l extends s.Model{constructor(e){super(e)}}a.Decoration=l,o=l,l.__name__="Decoration",o.prototype.default_view=d,o.define((({Enum:e,Ref:i})=>({marking:[i(r.Marking)],node:[e("start","middle","end")]})))},
function _(e,n,a,t,i){t();const l=e(1).__importStar(e(209));function r(e,n,{x0:a,x1:t,y0:i,y1:l},r){n.save(),n.beginPath(),n.moveTo(a,(i+l)/2),n.lineTo(t,(i+l)/2),e.line.apply(n,r),n.restore()}function c(e,n,{x0:a,x1:t,y0:i,y1:l},r){var c,o;const _=.1*Math.abs(t-a),s=.1*Math.abs(l-i),y=a+_,p=t-_,g=i+s,h=l-s;n.beginPath(),n.rect(y,g,p-y,h-g),e.fill.apply(n,r),null===(c=e.hatch)||void 0===c||c.apply(n,r),null===(o=e.line)||void 0===o||o.apply(n,r)}a.generic_line_scalar_legend=function(e,n,{x0:a,x1:t,y0:i,y1:l}){n.save(),n.beginPath(),n.moveTo(a,(i+l)/2),n.lineTo(t,(i+l)/2),e.line.apply(n),n.restore()},a.generic_line_vector_legend=r,a.generic_line_legend=r,a.generic_area_scalar_legend=function(e,n,{x0:a,x1:t,y0:i,y1:l}){var r,c;const o=.1*Math.abs(t-a),_=.1*Math.abs(l-i),s=a+o,y=t-o,p=i+_,g=l-_;n.beginPath(),n.rect(s,p,y-s,g-p),e.fill.apply(n),null===(r=e.hatch)||void 0===r||r.apply(n),null===(c=e.line)||void 0===c||c.apply(n)},a.generic_area_vector_legend=c,a.generic_area_legend=c,a.line_interpolation=function(e,n,a,t,i,r){const{sx:c,sy:o}=n;let _,s,y,p;"point"==n.type?([y,p]=e.yscale.r_invert(o-1,o+1),[_,s]=e.xscale.r_invert(c-1,c+1)):"v"==n.direction?([y,p]=e.yscale.r_invert(o,o),[_,s]=[Math.min(a-1,i-1),Math.max(a+1,i+1)]):([_,s]=e.xscale.r_invert(c,c),[y,p]=[Math.min(t-1,r-1),Math.max(t+1,r+1)]);const{x:g,y:h}=l.check_2_segments_intersect(_,y,s,p,a,t,i,r);return[g,h]}},
function _(t,n,e,i,r){function s(t,n){return(t.x-n.x)**2+(t.y-n.y)**2}function o(t,n,e){const i=s(n,e);if(0==i)return s(t,n);const r=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/i;if(r<0)return s(t,n);if(r>1)return s(t,e);return s(t,{x:n.x+r*(e.x-n.x),y:n.y+r*(e.y-n.y)})}i(),e.point_in_poly=function(t,n,e,i){let r=!1,s=e[e.length-1],o=i[i.length-1];for(let u=0;u<e.length;u++){const c=e[u],_=i[u];o<n!=_<n&&s+(n-o)/(_-o)*(c-s)<t&&(r=!r),s=c,o=_}return r},e.point_in_ellipse=function(t,n,e,i,r,s,o){return((Math.cos(e)/r)**2+(Math.sin(e)/i)**2)*(t-s)**2+2*Math.cos(e)*Math.sin(e)*((1/r)**2-(1/i)**2)*(t-s)*(n-o)+((Math.cos(e)/i)**2+(Math.sin(e)/r)**2)*(n-o)**2<=1},e.dist_2_pts=s,e.dist_to_segment_squared=o,e.dist_to_segment=function(t,n,e){return Math.sqrt(o(t,n,e))},e.check_2_segments_intersect=function(t,n,e,i,r,s,o,u){const c=(u-s)*(e-t)-(o-r)*(i-n);if(0==c)return{hit:!1,x:null,y:null};{let _=n-s,h=t-r;const l=(e-t)*_-(i-n)*h;_=((o-r)*_-(u-s)*h)/c,h=l/c;return{hit:_>0&&_<1&&h>0&&h<1,x:t+_*(e-t),y:n+_*(i-n)}}}},
function _(t,s,e,i,a){i();const l=t(1);var n;const _=t(201),o=t(208),c=l.__importStar(t(209)),h=l.__importStar(t(77)),r=t(100);class p extends _.XYGlyphView{_render(t,s,e){const{sx:i,sy:a}=null!=e?e:this;let l=!0;t.beginPath();for(const e of s){const s=i[e],n=a[e];isFinite(s+n)?l?(t.moveTo(s,n),l=!1):t.lineTo(s,n):(t.closePath(),l=!0)}t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t),this.visuals.line.apply(t)}draw_legend_for_index(t,s,e){(0,o.generic_area_scalar_legend)(this.visuals,t,s)}_hit_point(t){const s=new r.Selection;return c.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(s.add_to_selected_glyphs(this.model),s.view=this),s}}e.PatchView=p,p.__name__="PatchView";class d extends _.XYGlyph{constructor(t){super(t)}}e.Patch=d,n=d,d.__name__="Patch",n.prototype.default_view=p,n.mixins([h.LineScalar,h.FillScalar,h.HatchScalar])},
function _(t,s,e,i,n){i();const h=t(1);var r;const a=t(212),_=h.__importStar(t(209)),o=h.__importStar(t(17)),l=t(100);class c extends a.AreaView{_index_data(t){const{min:s,max:e}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._x1[n],h=this._x2[n],r=this._y[n];t.add_rect(s(i,h),r,e(i,h),r)}}_render(t,s,e){const{sx1:i,sx2:n,sy:h}=null!=e?e:this;t.beginPath();for(let s=0,e=i.length;s<e;s++)t.lineTo(i[s],h[s]);for(let s=n.length-1;s>=0;s--)t.lineTo(n[s],h[s]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)}_hit_point(t){const s=this.sy.length,e=new l.Selection;for(let i=0,n=s-1;i<n;i++){const s=[this.sx1[i],this.sx1[i+1],this.sx2[i+1],this.sx2[i]],n=[this.sy[i],this.sy[i+1],this.sy[i+1],this.sy[i]];if(_.point_in_poly(t.sx,t.sy,s,n)){e.add_to_selected_glyphs(this.model),e.view=this,e.line_indices=[i];break}}return e}scenterxy(t){return[(this.sx1[t]+this.sx2[t])/2,this.sy[t]]}_map_data(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)}}e.HAreaView=c,c.__name__="HAreaView";class x extends a.Area{constructor(t){super(t)}}e.HArea=x,r=x,x.__name__="HArea",r.prototype.default_view=c,r.define((({})=>({x1:[o.XCoordinateSpec,{field:"x1"}],x2:[o.XCoordinateSpec,{field:"x2"}],y:[o.YCoordinateSpec,{field:"y"}]})))},
function _(e,a,r,_,s){_();const n=e(1);var c;const i=e(202),l=e(208),t=n.__importStar(e(77));class o extends i.GlyphView{draw_legend_for_index(e,a,r){(0,l.generic_area_scalar_legend)(this.visuals,e,a)}}r.AreaView=o,o.__name__="AreaView";class d extends i.Glyph{constructor(e){super(e)}}r.Area=d,c=d,d.__name__="Area",c.mixins([t.FillScalar,t.HatchScalar])},
function _(t,s,e,i,n){i();const h=t(1);var r;const a=t(212),_=h.__importStar(t(209)),o=h.__importStar(t(17)),l=t(100);class c extends a.AreaView{_index_data(t){const{min:s,max:e}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._x[n],h=this._y1[n],r=this._y2[n];t.add_rect(i,s(h,r),i,e(h,r))}}_render(t,s,e){const{sx:i,sy1:n,sy2:h}=null!=e?e:this;t.beginPath();for(let s=0,e=n.length;s<e;s++)t.lineTo(i[s],n[s]);for(let s=h.length-1;s>=0;s--)t.lineTo(i[s],h[s]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)}scenterxy(t){return[this.sx[t],(this.sy1[t]+this.sy2[t])/2]}_hit_point(t){const s=this.sx.length,e=new l.Selection;for(let i=0,n=s-1;i<n;i++){const s=[this.sx[i],this.sx[i+1],this.sx[i+1],this.sx[i]],n=[this.sy1[i],this.sy1[i+1],this.sy2[i+1],this.sy2[i]];if(_.point_in_poly(t.sx,t.sy,s,n)){e.add_to_selected_glyphs(this.model),e.view=this,e.line_indices=[i];break}}return e}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)}}e.VAreaView=c,c.__name__="VAreaView";class y extends a.Area{constructor(t){super(t)}}e.VArea=y,r=y,y.__name__="VArea",r.prototype.default_view=c,r.define((({})=>({x:[o.XCoordinateSpec,{field:"x"}],y1:[o.YCoordinateSpec,{field:"y1"}],y2:[o.YCoordinateSpec,{field:"y2"}]})))},
function _(e,i,t,s,n){var c;s();const _=e(50),o=e(53),l=e(23),r=e(215),a=e(216),d=e(217);class h extends o.View{initialize(){super.initialize(),this.compute_indices()}connect_signals(){super.connect_signals();const{filter:e}=this.model.properties;this.on_change(e,(()=>this.compute_indices()));const i=()=>{const e=()=>this.compute_indices(),i=this.parent.data_source.get_value();this.connect(i.change,e),this.connect(i.streaming,e),this.connect(i.patching,e)};i();const{data_source:t}=this.parent;this.on_change(t,(()=>{i()}))}compute_indices(){var e;const i=this.parent.data_source.get_value(),t=null!==(e=i.get_length())&&void 0!==e?e:1,s=l.Indices.all_set(t),n=this.model.filter.compute_indices(i);s.intersect(n),this.model.indices=s,this.model._indices_map_to_subset()}}t.CDSViewView=h,h.__name__="CDSViewView";class u extends _.Model{constructor(e){super(e)}_indices_map_to_subset(){this._indices=[...this.indices],this.indices_map={};for(let e=0;e<this._indices.length;e++)this.indices_map[this._indices[e]]=e}convert_selection_from_subset(e){return e.map((e=>this._indices[e]))}convert_selection_to_subset(e){return e.map((e=>this.indices_map[e]))}convert_indices_from_subset(e){return e.map((e=>this._indices[e]))}get filters(){const{filter:e}=this;return e instanceof d.IntersectionFilter?e.operands:e instanceof a.AllIndices?[]:[e]}set filters(e){0==e.length?this.filter=new a.AllIndices:1==e.length?this.filter=e[0]:this.filter=new d.IntersectionFilter({operands:e})}}t.CDSView=u,c=u,u.__name__="CDSView",c.prototype.default_view=h,c.define((({Ref:e})=>({filter:[e(r.Filter),()=>new a.AllIndices]}))),c.internal((({Int:e,Dict:i,Ref:t,Nullable:s})=>({indices:[t(l.Indices)],indices_map:[i(e),{}],masked:[s(t(l.Indices)),null]})))},
function _(e,t,n,s,c){s();const o=e(50);class r extends o.Model{constructor(e){super(e)}}n.Filter=r,r.__name__="Filter"},
function _(e,n,s,t,c){t();const l=e(215),i=e(23);class _ extends l.Filter{constructor(e){super(e)}compute_indices(e){var n;const s=null!==(n=e.get_length())&&void 0!==n?n:1;return i.Indices.all_set(s)}}s.AllIndices=_,_.__name__="AllIndices"},
function _(e,t,n,r,s){var c;r();const i=e(215),o=e(23);class l extends i.Filter{constructor(e){super(e)}compute_indices(e){var t;const{operands:n}=this;if(0==n.length){const n=null!==(t=e.get_length())&&void 0!==t?t:1;return o.Indices.all_set(n)}{const[t,...r]=n.map((t=>t.compute_indices(e)));for(const e of r)t.intersect(e);return t}}}n.IntersectionFilter=l,c=l,l.__name__="IntersectionFilter",c.define((({Array:e,Ref:t})=>({operands:[e(t(i.Filter))]})))},
function _(t,r,a,e,i){e(),i("BasicTickFormatter",t(184).BasicTickFormatter),i("CategoricalTickFormatter",t(165).CategoricalTickFormatter),i("DatetimeTickFormatter",t(168).DatetimeTickFormatter),i("CustomJSTickFormatter",t(219).CustomJSTickFormatter),i("LogTickFormatter",t(186).LogTickFormatter),i("MercatorTickFormatter",t(189).MercatorTickFormatter),i("NumeralTickFormatter",t(220).NumeralTickFormatter),i("PrintfTickFormatter",t(221).PrintfTickFormatter),i("TickFormatter",t(161).TickFormatter)},
function _(t,e,s,n,r){var c;n();const i=t(161),a=t(9),o=t(38);class u extends i.TickFormatter{constructor(t){super(t)}get names(){return(0,a.keys)(this.args)}get values(){return(0,a.values)(this.args)}_make_func(){const t=(0,o.use_strict)(this.code);return new Function("tick","index","ticks",...this.names,t)}doFormat(t,e){const s=this._make_func().bind({});return t.map(((t,e,n)=>`${s(t,e,n,...this.values)}`))}}s.CustomJSTickFormatter=u,c=u,u.__name__="CustomJSTickFormatter",c.define((({Unknown:t,String:e,Dict:s})=>({args:[s(t),{}],code:[e,""]})))},
function _(r,n,t,o,e){o();var a;const u=r(1).__importStar(r(170)),c=r(161),i=r(19);class s extends c.TickFormatter{constructor(r){super(r)}get _rounding_fn(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}doFormat(r,n){const{format:t,language:o,_rounding_fn:e}=this;return r.map((r=>u.format(r,t,o,e)))}}t.NumeralTickFormatter=s,a=s,s.__name__="NumeralTickFormatter",a.define((({String:r})=>({format:[r,"0,0"],language:[r,"en"],rounding:[i.RoundingFunction,"round"]})))},
function _(t,r,n,o,a){var e;o();const i=t(161),s=t(169);class c extends i.TickFormatter{constructor(t){super(t)}doFormat(t,r){return t.map((t=>(0,s.sprintf)(this.format,t)))}}n.PrintfTickFormatter=c,e=c,c.__name__="PrintfTickFormatter",e.define((({String:t})=>({format:[t,"%s"]})))},
function _(a,e,l,c,n){c(),n("CategoricalScale",a(91).CategoricalScale),n("ContinuousScale",a(89).ContinuousScale),n("LinearScale",a(88).LinearScale),n("LinearInterpolationScale",a(223).LinearInterpolationScale),n("LogScale",a(90).LogScale),n("Scale",a(84).Scale)},
function _(e,r,n,t,a){var i;t();const s=e(84),o=e(88),c=e(13);class _ extends s.Scale{constructor(e){super(e)}initialize(){super.initialize();const{source_range:e,target_range:r}=this.properties;e.is_unset||r.is_unset||(this.linear_scale=new o.LinearScale({source_range:e.get_value(),target_range:r.get_value()}))}connect_signals(){super.connect_signals();const{source_range:e,target_range:r}=this.properties;this.on_change([e,r],(()=>{this.linear_scale=new o.LinearScale({source_range:this.source_range,target_range:this.target_range})}))}get s_compute(){throw new Error("not implemented")}get s_invert(){throw new Error("not implemented")}compute(e){return e}v_compute(e){const{binning:r}=this,{start:n,end:t}=this.source_range,a=n,i=t,s=r.length,o=(t-n)/(s-1),_=new Float64Array(s);for(let e=0;e<s;e++)_[e]=n+e*o;const l=(0,c.map)(e,(e=>{if(e<a)return a;if(e>i)return i;const n=(0,c.left_edge_index)(e,r);if(-1==n)return a;if(n>=s-1)return i;const t=r[n],o=(e-t)/(r[n+1]-t),l=_[n];return l+o*(_[n+1]-l)}));return this.linear_scale.v_compute(l)}invert(e){return e}v_invert(e){return new Float64Array(e)}}n.LinearInterpolationScale=_,i=_,_.__name__="LinearInterpolationScale",i.internal((({Number:e,Arrayable:r,Ref:n})=>({binning:[r(e)],linear_scale:[n(o.LinearScale)]})))},
function _(a,n,e,g,R){g(),R("DataRange",a(93).DataRange),R("DataRange1d",a(92).DataRange1d),R("FactorRange",a(95).FactorRange),R("Range",a(86).Range),R("Range1d",a(87).Range1d)},
function _(a,i,o,l,S){l();var c=a(144);S("Sizeable",c.Sizeable),S("SizingPolicy",c.SizingPolicy),S("Layoutable",a(145).Layoutable);var t=a(226);S("HStack",t.HStack),S("VStack",t.VStack);var e=a(227);S("Grid",e.Grid),S("Row",e.Row),S("Column",e.Column)},
function _(t,e,h,i,r){i();const n=t(145),s=t(56);class o extends n.Layoutable{constructor(){super(...arguments),this.children=[]}*[Symbol.iterator](){yield*this.children}}h.Stack=o,o.__name__="Stack";class c extends o{_measure(t){let e=0,h=0;for(const t of this.children){const i=t.measure({width:0,height:0});e+=i.width,h=Math.max(h,i.height)}return{width:e,height:h}}_set_geometry(t,e){if(super._set_geometry(t,e),t.is_empty)for(const t of this.children)t.set_geometry(new s.BBox);else{const e=this.absolute?t.top:0;let h=this.absolute?t.left:0;const{height:i}=t;for(const t of this.children){const{width:r}=t.measure({width:0,height:0});t.set_geometry(new s.BBox({left:h,width:r,top:e,height:i})),h+=r}}}}h.HStack=c,c.__name__="HStack";class a extends o{_measure(t){let e=0,h=0;for(const t of this.children){const i=t.measure({width:0,height:0});e=Math.max(e,i.width),h+=i.height}return{width:e,height:h}}_set_geometry(t,e){if(super._set_geometry(t,e),t.is_empty)for(const t of this.children)t.set_geometry(new s.BBox);else{const e=this.absolute?t.left:0;let h=this.absolute?t.top:0;const{width:i}=t;for(const t of this.children){const{height:r}=t.measure({width:0,height:0});t.set_geometry(new s.BBox({top:h,height:r,left:e,width:i})),h+=r}}}}h.VStack=a,a.__name__="VStack";class l extends n.Layoutable{constructor(){super(...arguments),this.children=[]}*[Symbol.iterator](){yield*this.children}_measure(t){const{width_policy:e,height_policy:h}=this.sizing,{min:i,max:r}=Math;let n=0,s=0;for(const e of this.children){const{width:h,height:i}=e.measure(t);n=r(n,h),s=r(s,i)}return{width:(()=>{const{width:h}=this.sizing;if(t.width==1/0)return"fixed"==e&&null!=h?h:n;switch(e){case"fixed":return null!=h?h:n;case"min":return n;case"fit":return null!=h?i(t.width,h):t.width;case"max":return null!=h?r(t.width,h):t.width}})(),height:(()=>{const{height:e}=this.sizing;if(t.height==1/0)return"fixed"==h&&null!=e?e:s;switch(h){case"fixed":return null!=e?e:s;case"min":return s;case"fit":return null!=e?i(t.height,e):t.height;case"max":return null!=e?r(t.height,e):t.height}})()}}_set_geometry(t,e){if(super._set_geometry(t,e),t.is_empty)for(const t of this.children)t.set_geometry(new s.BBox);else{const e=this.absolute?t:t.relative(),{left:h,right:i,top:r,bottom:n}=e,o=Math.round(e.vcenter),c=Math.round(e.hcenter);for(const e of this.children){const{margin:a,halign:l="start",valign:d="start"}=e.sizing,{width:g,height:u,inner:_}=e.measure(t),m=(()=>{switch(`${d}_${l}`){case"start_start":return new s.BBox({left:h+a.left,top:r+a.top,width:g,height:u});case"start_center":return new s.BBox({hcenter:c,top:r+a.top,width:g,height:u});case"start_end":return new s.BBox({right:i-a.right,top:r+a.top,width:g,height:u});case"center_start":return new s.BBox({left:h+a.left,vcenter:o,width:g,height:u});case"center_center":return new s.BBox({hcenter:c,vcenter:o,width:g,height:u});case"center_end":return new s.BBox({right:i-a.right,vcenter:o,width:g,height:u});case"end_start":return new s.BBox({left:h+a.left,bottom:n-a.bottom,width:g,height:u});case"end_center":return new s.BBox({hcenter:c,bottom:n-a.bottom,width:g,height:u});case"end_end":return new s.BBox({right:i-a.right,bottom:n-a.bottom,width:g,height:u})}})(),w=null==_?m:new s.BBox({left:m.left+_.left,top:m.top+_.top,right:m.right-_.right,bottom:m.bottom-_.bottom});e.set_geometry(m,w)}}}}h.NodeLayout=l,l.__name__="NodeLayout"},
function _(t,i,s,e,o){e();const n=t(144),r=t(145),l=t(8),h=t(56),c=t(10),{max:a,round:g}=Math;class p{constructor(t){this.def=t,this._map=new Map}get(t){let i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i}apply(t,i){const s=this.get(t);this._map.set(t,i(s))}}s.DefaultMap=p,p.__name__="DefaultMap";class _{constructor(){this._items=[],this._nrows=0,this._ncols=0}get size(){return this._items.length}get nrows(){return this._nrows}get ncols(){return this._ncols}add(t,i){const{r1:s,c1:e}=t;this._nrows=a(this._nrows,s+1),this._ncols=a(this._ncols,e+1),this._items.push({span:t,data:i})}at(t,i){return this._items.filter((({span:s})=>s.r0<=t&&t<=s.r1&&s.c0<=i&&i<=s.c1)).map((({data:t})=>t))}row(t){return this._items.filter((({span:i})=>i.r0<=t&&t<=i.r1)).map((({data:t})=>t))}col(t){return this._items.filter((({span:i})=>i.c0<=t&&t<=i.c1)).map((({data:t})=>t))}*[Symbol.iterator](){yield*this._items}foreach(t){for(const{span:i,data:s}of this._items)t(i,s)}map(t){const i=new _;for(const{span:s,data:e}of this._items)i.add(s,t(s,e));return i}}s.Container=_,_.__name__="Container";class f extends r.Layoutable{constructor(t=[]){super(),this.items=t,this.rows="auto",this.cols="auto",this.spacing=0}*[Symbol.iterator](){for(const{layout:t}of this.items)yield t}is_width_expanding(){if(super.is_width_expanding())return!0;if("fixed"==this.sizing.width_policy)return!1;const{cols:t}=this._state;return(0,c.some)(t,(t=>"max"==t.policy))}is_height_expanding(){if(super.is_height_expanding())return!0;if("fixed"==this.sizing.height_policy)return!1;const{rows:t}=this._state;return(0,c.some)(t,(t=>"max"==t.policy))}_init(){var t,i,s,e;super._init();const o=new _;for(const{layout:t,row:i,col:s,row_span:e=1,col_span:n=1}of this.items)if(t.sizing.visible){const r=i,l=s,h=i+e-1,c=s+n-1;o.add({r0:r,c0:l,r1:h,c1:c},t)}const{nrows:n,ncols:r}=o,h=new Array(n);for(let s=0;s<n;s++){const e=(()=>{var t;const i=(0,l.isPlainObject)(this.rows)?null!==(t=this.rows[s])&&void 0!==t?t:this.rows["*"]:this.rows;return null==i?{policy:"auto"}:(0,l.isNumber)(i)?{policy:"fixed",height:i}:(0,l.isString)(i)?{policy:i}:i})(),n=null!==(t=e.align)&&void 0!==t?t:"auto";"fixed"==e.policy?h[s]={policy:"fixed",height:e.height,align:n}:"min"==e.policy?h[s]={policy:"min",align:n}:"fit"==e.policy||"max"==e.policy?h[s]={policy:e.policy,flex:null!==(i=e.flex)&&void 0!==i?i:1,align:n}:(0,c.some)(o.row(s),(t=>t.is_height_expanding()))?h[s]={policy:"max",flex:1,align:n}:h[s]={policy:"min",align:n}}const a=new Array(r);for(let t=0;t<r;t++){const i=(()=>{var i;const s=(0,l.isPlainObject)(this.cols)?null!==(i=this.cols[t])&&void 0!==i?i:this.cols["*"]:this.cols;return null==s?{policy:"auto"}:(0,l.isNumber)(s)?{policy:"fixed",width:s}:(0,l.isString)(s)?{policy:s}:s})(),n=null!==(s=i.align)&&void 0!==s?s:"auto";"fixed"==i.policy?a[t]={policy:"fixed",width:i.width,align:n}:"min"==i.policy?a[t]={policy:"min",align:n}:"fit"==i.policy||"max"==i.policy?a[t]={policy:i.policy,flex:null!==(e=i.flex)&&void 0!==e?e:1,align:n}:(0,c.some)(o.col(t),(t=>t.is_width_expanding()))?a[t]={policy:"max",flex:1,align:n}:a[t]={policy:"min",align:n}}const[g,p]=(0,l.isNumber)(this.spacing)?[this.spacing,this.spacing]:this.spacing;this._state={items:o,nrows:n,ncols:r,rows:h,cols:a,rspacing:g,cspacing:p}}_measure_totals(t,i){const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state;return{height:(0,c.sum)(t)+(s-1)*o,width:(0,c.sum)(i)+(e-1)*n}}_measure_cells(t){const{items:i,nrows:s,ncols:e,rows:o,cols:r,rspacing:l,cspacing:h}=this._state,c=new Array(s);for(let t=0;t<s;t++){const i=o[t];c[t]="fixed"==i.policy?i.height:0}const p=new Array(e);for(let t=0;t<e;t++){const i=r[t];p[t]="fixed"==i.policy?i.width:0}const f=new _;i.foreach(((i,s)=>{const{r0:e,c0:_,r1:d,c1:u}=i,w=(d-e)*l,m=(u-_)*h;let y=0;for(let i=e;i<=d;i++)y+=t(i,_).height;y+=w;let x=0;for(let i=_;i<=u;i++)x+=t(e,i).width;x+=m;const b=s.measure({width:x,height:y});f.add(i,{layout:s,size_hint:b});const z=new n.Sizeable(b).grow_by(s.sizing.margin);z.height-=w,z.width-=m;const v=[];for(let t=e;t<=d;t++){const i=o[t];"fixed"==i.policy?z.height-=i.height:v.push(t)}if(z.height>0){const t=g(z.height/v.length);for(const i of v)c[i]=a(c[i],t)}const j=[];for(let t=_;t<=u;t++){const i=r[t];"fixed"==i.policy?z.width-=i.width:j.push(t)}if(z.width>0){const t=g(z.width/j.length);for(const i of j)p[i]=a(p[i],t)}}));return{size:this._measure_totals(c,p),row_heights:c,col_widths:p,size_hints:f}}_measure_grid(t){const{nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:r}=this._state,l=this._measure_cells(((t,i)=>{const s=e[t],n=o[i];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==s.policy?s.height:1/0}}));let h;h="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:l.size.height;let c,p=0;for(let t=0;t<i;t++){const i=e[t];"fit"==i.policy||"max"==i.policy?p+=i.flex:h-=l.row_heights[t]}if(h-=(i-1)*n,0!=p&&h>0)for(let t=0;t<i;t++){const i=e[t];if("fit"==i.policy||"max"==i.policy){const s=g(h*(i.flex/p));h-=s,l.row_heights[t]=s,p-=i.flex}}else if(h<0){let t=0;for(let s=0;s<i;s++){"fixed"!=e[s].policy&&t++}let s=-h;for(let o=0;o<i;o++){if("fixed"!=e[o].policy){const i=l.row_heights[o],e=g(s/t);l.row_heights[o]=a(i-e,0),s-=e>i?i:e,t--}}}c="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:l.size.width;let _=0;for(let t=0;t<s;t++){const i=o[t];"fit"==i.policy||"max"==i.policy?_+=i.flex:c-=l.col_widths[t]}if(c-=(s-1)*r,0!=_&&c>0)for(let t=0;t<s;t++){const i=o[t];if("fit"==i.policy||"max"==i.policy){const s=g(c*(i.flex/_));c-=s,l.col_widths[t]=s,_-=i.flex}}else if(c<0){let t=0;for(let i=0;i<s;i++){"fixed"!=o[i].policy&&t++}let i=-c;for(let e=0;e<s;e++){if("fixed"!=o[e].policy){const s=l.col_widths[e],o=g(i/t);l.col_widths[e]=a(s-o,0),i-=o>s?s:o,t--}}}const{row_heights:f,col_widths:d,size_hints:u}=this._measure_cells(((t,i)=>({width:l.col_widths[i],height:l.row_heights[t]})));return{size:this._measure_totals(f,d),row_heights:f,col_widths:d,size_hints:u}}_measure(t){const{size:i}=this._measure_grid(t);return i}_set_geometry(t,i){super._set_geometry(t,i);const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state,{row_heights:r,col_widths:l,size_hints:c}=this._measure_grid(t),_=this._state.rows.map(((t,i)=>Object.assign(Object.assign({},t),{top:0,height:r[i],get bottom(){return this.top+this.height}}))),f=this._state.cols.map(((t,i)=>Object.assign(Object.assign({},t),{left:0,width:l[i],get right(){return this.left+this.width}}))),d=c.map(((t,i)=>Object.assign(Object.assign({},i),{outer:new h.BBox,inner:new h.BBox})));for(let i=0,e=this.absolute?t.top:0;i<s;i++){const t=_[i];t.top=e,e+=t.height+o}for(let i=0,s=this.absolute?t.left:0;i<e;i++){const t=f[i];t.left=s,s+=t.width+n}d.foreach((({r0:t,c0:i,r1:s,c1:e},r)=>{const{layout:l,size_hint:c}=r,{sizing:a}=l,{width:p,height:d}=c,u=function(t,i){let s=(i-t)*n;for(let e=t;e<=i;e++)s+=f[e].width;return s}(i,e),w=function(t,i){let s=(i-t)*o;for(let e=t;e<=i;e++)s+=_[e].height;return s}(t,s),m=i==e&&"auto"!=f[i].align?f[i].align:a.halign,y=t==s&&"auto"!=_[t].align?_[t].align:a.valign;let x=f[i].left;"start"==m?x+=a.margin.left:"center"==m?x+=g((u-p)/2):"end"==m&&(x+=u-a.margin.right-p);let b=_[t].top;"start"==y?b+=a.margin.top:"center"==y?b+=g((w-d)/2):"end"==y&&(b+=w-a.margin.bottom-d),r.outer=new h.BBox({left:x,top:b,width:p,height:d})}));const u=_.map((()=>({start:new p((()=>0)),end:new p((()=>0))}))),w=f.map((()=>({start:new p((()=>0)),end:new p((()=>0))})));d.foreach((({r0:t,c0:i,r1:s,c1:e},{size_hint:o,outer:n})=>{const{inner:r}=o;null!=r&&(u[t].start.apply(n.top,(t=>a(t,r.top))),u[s].end.apply(_[s].bottom-n.bottom,(t=>a(t,r.bottom))),w[i].start.apply(n.left,(t=>a(t,r.left))),w[e].end.apply(f[e].right-n.right,(t=>a(t,r.right))))})),d.foreach((({r0:t,c0:i,r1:s,c1:e},o)=>{const{size_hint:n,outer:r}=o,l=t=>{const i=this.absolute?r:r.relative(),s=i.left+t.left,e=i.top+t.top,o=i.right-t.right,n=i.bottom-t.bottom;return new h.BBox({left:s,top:e,right:o,bottom:n})};if(null!=n.inner){let h=l(n.inner);const c=u[t].start.get(r.top),a=u[s].end.get(_[s].bottom-r.bottom),g=w[i].start.get(r.left),p=w[e].end.get(f[e].right-r.right);try{h=l({top:c,bottom:a,left:g,right:p})}catch(t){}o.inner=h}else o.inner=r})),d.foreach(((t,{layout:i,outer:s,inner:e})=>{i.set_geometry(s,e)}))}}s.Grid=f,f.__name__="Grid";class d extends f{constructor(t){super(),this.items=t.map(((t,i)=>({layout:t,row:0,col:i}))),this.rows="fit"}}s.Row=d,d.__name__="Row";class u extends f{constructor(t){super(),this.items=t.map(((t,i)=>({layout:t,row:i,col:0}))),this.cols="fit"}}s.Column=u,u.__name__="Column"},
function _(t,e,i,h,o){h();const n=t(144),s=t(145),r=t(56);class l extends s.Layoutable{constructor(){super(...arguments),this.aligns={left:!0,right:!0,top:!0,bottom:!0},this.min_border={left:0,top:0,right:0,bottom:0},this.padding={left:0,top:0,right:0,bottom:0},this.center_border_width=0}*[Symbol.iterator](){yield this.top_panel,yield this.bottom_panel,yield this.left_panel,yield this.right_panel,yield this.center_panel}_measure(t){t=new n.Sizeable({width:"fixed"==this.sizing.width_policy||t.width==1/0?this.sizing.width:t.width,height:"fixed"==this.sizing.height_policy||t.height==1/0?this.sizing.height:t.height});const e=this.left_panel.measure({width:0,height:t.height}),i=Math.max(e.width,this.min_border.left)+this.padding.left,h=this.right_panel.measure({width:0,height:t.height}),o=Math.max(h.width,this.min_border.right)+this.padding.right,s=this.top_panel.measure({width:t.width,height:0}),r=Math.max(s.height,this.min_border.top)+this.padding.top,l=this.bottom_panel.measure({width:t.width,height:0}),_=Math.max(l.height,this.min_border.bottom)+this.padding.bottom,g=new n.Sizeable(t).shrink_by({left:i,right:o,top:r,bottom:_}),a=this.center_panel.measure(g);return{width:i+a.width+o,height:r+a.height+_,inner:{left:i,right:o,top:r,bottom:_},align:(()=>{const{width_policy:t,height_policy:e}=this.center_panel.sizing;return Object.assign(Object.assign({},this.aligns),{fixed_width:"fixed"==t,fixed_height:"fixed"==e})})()}}_set_geometry(t,e){var i,h,o,n;if(super._set_geometry(t,e),this.sizing.visible){this.center_panel.set_geometry(e);const i=this.left_panel.measure({width:0,height:t.height}),h=this.right_panel.measure({width:0,height:t.height}),o=this.top_panel.measure({width:t.width,height:0}),n=this.bottom_panel.measure({width:t.width,height:0}),{left:s,top:l,right:_,bottom:g}=e;this.top_panel.set_geometry(new r.BBox({left:s,right:_,bottom:l,height:o.height})),this.bottom_panel.set_geometry(new r.BBox({left:s,right:_,top:g,height:n.height})),this.left_panel.set_geometry(new r.BBox({top:l,bottom:g,right:s,width:i.width})),this.right_panel.set_geometry(new r.BBox({top:l,bottom:g,left:_,width:h.width}));const a=e.shrink_by(this.center_border_width);if(null!=this.inner_top_panel){const{left:t,right:e,top:i,width:h}=a,o=this.inner_top_panel.measure({width:h,height:0});this.inner_top_panel.set_geometry(new r.BBox({left:t,right:e,top:i,height:o.height}))}if(null!=this.inner_bottom_panel){const{left:t,right:e,bottom:i,width:h}=a,o=this.inner_bottom_panel.measure({width:h,height:0});this.inner_bottom_panel.set_geometry(new r.BBox({left:t,right:e,bottom:i,height:o.height}))}if(null!=this.inner_left_panel){const{top:t,bottom:e,left:i,height:h}=a,o=this.inner_left_panel.measure({width:0,height:h});this.inner_left_panel.set_geometry(new r.BBox({top:t,bottom:e,left:i,width:o.width}))}if(null!=this.inner_right_panel){const{top:t,bottom:e,right:i,height:h}=a,o=this.inner_right_panel.measure({width:0,height:h});this.inner_right_panel.set_geometry(new r.BBox({top:t,bottom:e,right:i,width:o.width}))}}else this.center_panel.set_geometry(new r.BBox),this.top_panel.set_geometry(new r.BBox),this.bottom_panel.set_geometry(new r.BBox),this.left_panel.set_geometry(new r.BBox),this.right_panel.set_geometry(new r.BBox),null===(i=this.inner_top_panel)||void 0===i||i.set_geometry(new r.BBox),null===(h=this.inner_bottom_panel)||void 0===h||h.set_geometry(new r.BBox),null===(o=this.inner_left_panel)||void 0===o||o.set_geometry(new r.BBox),null===(n=this.inner_right_panel)||void 0===n||n.set_geometry(new r.BBox)}}i.BorderLayout=l,l.__name__="BorderLayout"},
function _(e,s,_,i,l){i();const t=e(1);var o;const r=e(230),p=t.__importStar(e(77));class h extends r.UpperLowerView{paint(e){e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,_=this._lower_sx.length;s<_;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);for(let s=this._upper_sx.length-1;s>=0;s--)e.lineTo(this._upper_sx[s],this._upper_sy[s]);e.closePath(),this.visuals.fill.apply(e),e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,_=this._lower_sx.length;s<_;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);this.visuals.line.apply(e),e.beginPath(),e.moveTo(this._upper_sx[0],this._upper_sy[0]);for(let s=0,_=this._upper_sx.length;s<_;s++)e.lineTo(this._upper_sx[s],this._upper_sy[s]);this.visuals.line.apply(e)}}_.BandView=h,h.__name__="BandView";class n extends r.UpperLower{constructor(e){super(e)}}_.Band=n,o=n,n.__name__="Band",o.prototype.default_view=h,o.mixins([p.Line,p.Fill]),o.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(e,t,s,r,i){r();const n=e(1);var a;const o=e(97),c=e(23),_=e(19),p=n.__importStar(e(17));class u extends o.DataAnnotationView{map_data(){const{frame:e}=this.plot_view,t=this.model.dimension,s=this.coordinates.x_scale,r=this.coordinates.y_scale,i="height"==t?r:s,n="height"==t?s:r,a="height"==t?e.bbox.yview:e.bbox.xview,o="height"==t?e.bbox.xview:e.bbox.yview,_=(()=>{switch(this.model.properties.lower.units){case"canvas":return new c.ScreenArray(this._lower);case"screen":return a.v_compute(this._lower);case"data":return i.v_compute(this._lower)}})(),p=(()=>{switch(this.model.properties.upper.units){case"canvas":return new c.ScreenArray(this._upper);case"screen":return a.v_compute(this._upper);case"data":return i.v_compute(this._upper)}})(),u=(()=>{switch(this.model.properties.base.units){case"canvas":return new c.ScreenArray(this._base);case"screen":return o.v_compute(this._base);case"data":return n.v_compute(this._base)}})(),[h,d]="height"==t?[1,0]:[0,1],w=[_,u],l=[p,u];this._lower_sx=w[h],this._lower_sy=w[d],this._upper_sx=l[h],this._upper_sy=l[d]}}s.UpperLowerView=u,u.__name__="UpperLowerView";class h extends p.CoordinateSpec{constructor(){super(...arguments),this._value=p.unset}get dimension(){return"width"==this.obj.dimension?"x":"y"}get units(){var e;return this._value===p.unset?"data":null!==(e=this._value.units)&&void 0!==e?e:"data"}}s.XOrYCoordinateSpec=h,h.__name__="XOrYCoordinateSpec";class d extends o.DataAnnotation{constructor(e){super(e)}}s.UpperLower=d,a=d,d.__name__="UpperLower",a.define((()=>({dimension:[_.Dimension,"height"],lower:[h,{field:"lower"}],upper:[h,{field:"upper"}],base:[h,{field:"base"}]})))},
function _(t,o,i,e,n){e();const s=t(1);var l;const r=t(72),a=s.__importStar(t(77)),c=t(19),b=t(56);i.EDGE_TOLERANCE=2.5;class h extends r.AnnotationView{constructor(){super(...arguments),this.bbox=new b.BBox}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_render(){const{left:t,right:o,top:i,bottom:e}=this.model,{frame:n}=this.plot_view,s=this.coordinates.x_scale,l=this.coordinates.y_scale,r=(t,o,i,e,n)=>{if(null==t)return n;switch(o){case"canvas":return t;case"screen":return e.compute(t);case"data":return i.compute(t)}};this.bbox=b.BBox.from_lrtb({left:r(t,this.model.left_units,s,n.bbox.xview,n.bbox.left),right:r(o,this.model.right_units,s,n.bbox.xview,n.bbox.right),top:r(i,this.model.top_units,l,n.bbox.yview,n.bbox.top),bottom:r(e,this.model.bottom_units,l,n.bbox.yview,n.bbox.bottom)}),this._paint_box()}_paint_box(){const{ctx:t}=this.layer;t.save();const{left:o,top:i,width:e,height:n}=this.bbox;t.beginPath(),t.rect(o,i,e,n),this.visuals.fill.apply(t),this.visuals.hatch.apply(t),this.visuals.line.apply(t),t.restore()}interactive_bbox(){const t=this.model.line_width+i.EDGE_TOLERANCE;return this.bbox.grow_by(t)}interactive_hit(t,o){if(null==this.model.in_cursor)return!1;return this.interactive_bbox().contains(t,o)}cursor(t,o){const{left:i,right:e,bottom:n,top:s}=this.bbox;return Math.abs(t-i)<3||Math.abs(t-e)<3?this.model.ew_cursor:Math.abs(o-n)<3||Math.abs(o-s)<3?this.model.ns_cursor:this.bbox.contains(t,o)?this.model.in_cursor:null}}i.BoxAnnotationView=h,h.__name__="BoxAnnotationView";class u extends r.Annotation{constructor(t){super(t)}update({left:t,right:o,top:i,bottom:e}){this.setv({left:t,right:o,top:i,bottom:e,visible:!0})}clear(){this.visible=!1}}i.BoxAnnotation=u,l=u,u.__name__="BoxAnnotation",l.prototype.default_view=h,l.mixins([a.Line,a.Fill,a.Hatch]),l.define((({Number:t,Nullable:o})=>({top:[o(t),null],bottom:[o(t),null],left:[o(t),null],right:[o(t),null],top_units:[c.CoordinateUnits,"data"],bottom_units:[c.CoordinateUnits,"data"],left_units:[c.CoordinateUnits,"data"],right_units:[c.CoordinateUnits,"data"]}))),l.internal((({String:t,Nullable:o})=>({ew_cursor:[o(t),null],ns_cursor:[o(t),null],in_cursor:[o(t),null]}))),l.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(e,i,n,t,a){var o;t();const l=e(140),s=e(157),r=e(218),_=e(196),c=e(233),h=e(224),g=e(222),p=e(191),m=e(10),d=e(12);class u extends l.BaseColorBarView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.color_mapper.change,(async()=>{this._title_view.remove(),this._axis_view.remove(),this.initialize(),await this.lazy_initialize(),this.plot_view.invalidate_layout()})),this.connect(this.model.color_mapper.metrics_change,(()=>this._metrics_changed())),this.connect(this.model.properties.display_low.change,(()=>this._metrics_changed())),this.connect(this.model.properties.display_high.change,(()=>this._metrics_changed()))}update_layout(){super.update_layout(),this._set_canvas_image()}_create_axis(){const{color_mapper:e}=this.model;return e instanceof c.CategoricalColorMapper?new s.CategoricalAxis:e instanceof c.LogColorMapper?new s.LogAxis:new s.LinearAxis}_create_formatter(){const{color_mapper:e}=this.model;return this._ticker instanceof p.LogTicker?new r.LogTickFormatter:e instanceof c.CategoricalColorMapper?new r.CategoricalTickFormatter:new r.BasicTickFormatter}_create_major_range(){const{color_mapper:e}=this.model;if(e instanceof c.CategoricalColorMapper)return new h.FactorRange({factors:e.factors});if(e instanceof c.ContinuousColorMapper){const{min:i,max:n}=this._continuous_metrics(e);return new h.Range1d({start:i,end:n})}(0,d.unreachable)()}_create_major_scale(){const{color_mapper:e}=this.model;return e instanceof c.LinearColorMapper?new g.LinearScale:e instanceof c.LogColorMapper?new g.LogScale:e instanceof c.ScanningColorMapper?new g.LinearInterpolationScale({binning:this._scanning_binning(e)}):e instanceof c.CategoricalColorMapper?new g.CategoricalScale:void(0,d.unreachable)()}_create_ticker(){const{color_mapper:e}=this.model;return e instanceof c.LogColorMapper?new p.LogTicker:e instanceof c.ScanningColorMapper?new p.BinnedTicker({mapper:e}):e instanceof c.CategoricalColorMapper?new p.CategoricalTicker:new p.BasicTicker}_continuous_metrics(e){const{display_low:i,display_high:n}=this.model;let{min:t,max:a}=e.metrics;if(null!=n&&null!=i&&n<i)return this._index_low=0,this._index_high=-1,{min:NaN,max:NaN};if(this._index_high=null,null!=n){const i=e.palette.length,t=e.value_to_index(n,i);t<i-1&&(this._index_high=t,a=e.index_to_value(t+1))}if(this._index_low=null,null!=i){const n=e.value_to_index(i,e.palette.length);n>0&&(this._index_low=n,t=e.index_to_value(n))}return{min:t,max:a}}_get_major_size_factor(){return this.model.color_mapper.palette.length}_metrics_changed(){const e=this._major_range,i=this._major_scale,{color_mapper:n}=this.model;if(n instanceof c.ScanningColorMapper&&i instanceof g.LinearInterpolationScale){const e=this._scanning_binning(n);i.binning=e;const t="vertical"==this.orientation,a=t?this._frame.y_scale:this._frame.x_scale;if(a instanceof g.LinearInterpolationScale){a.binning=e;const i=t?this._frame.y_range:this._frame.x_range;i instanceof h.Range1d&&(i.start=e[0],i.end=e[e.length-1])}}else if(n instanceof c.ContinuousColorMapper&&e instanceof h.Range1d){const{min:i,max:t}=this._continuous_metrics(n);e.setv({start:i,end:t})}this._set_canvas_image(),this.plot_view.request_layout()}_paint_colors(e,i){const{x:n,y:t,width:a,height:o}=i;e.save(),e.globalAlpha=this.model.scale_alpha,null!=this._image&&(e.setImageSmoothingEnabled(!1),e.drawImage(this._image,n,t,a,o)),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(e),e.strokeRect(n,t,a,o)),e.restore()}_scanning_binning(e){let{binning:i,force_low_cutoff:n}=e.metrics;const{display_high:t}=this.model;let{display_low:a}=this.model;if(n&&(null==a||e.metrics.min>a)&&(a=e.metrics.min),null!=t&&null!=a&&t<a)return this._index_low=0,this._index_high=-1,[NaN];if(this._index_high=null,null!=t){const n=e.value_to_index(t,i.length);n<i.length-1&&(this._index_high=n)}if(this._index_low=null,null!=a){const n=e.value_to_index(a,i.length);n>0&&(this._index_low=n)}if(null!=this._index_low||null!=this._index_high){const e=null!=this._index_low?this._index_low:0,n=(null!=this._index_high?this._index_high+1:i.length-1)-e+1;if(n>0){const t=new Array(n);for(let a=0;a<n;a++)t[a]=i[a+e];i=t}else i=[NaN]}return i}_set_canvas_image(){const{orientation:e}=this;let{palette:i}=this.model.color_mapper;if(null==this._index_high&&null==this._index_low||(i=i.slice(null!=this._index_low?this._index_low:0,null!=this._index_high?this._index_high+1:i.length)),i.length<1)return void(this._image=null);"vertical"==e&&(i=(0,m.reversed)(i));const[n,t]="vertical"==e?[1,i.length]:[i.length,1],a=this._image=document.createElement("canvas");a.width=n,a.height=t;const o=a.getContext("2d"),l=o.getImageData(0,0,n,t),s=new c.LinearColorMapper({palette:i}).rgba_mapper.v_compute((0,m.range)(0,i.length));l.data.set(s),o.putImageData(l,0,0)}}n.ColorBarView=u,u.__name__="ColorBarView";class f extends l.BaseColorBar{constructor(e){super(e)}}n.ColorBar=f,o=f,f.__name__="ColorBar",o.prototype.default_view=u,o.define((({Nullable:e,Number:i,Ref:n})=>({color_mapper:[n(_.ColorMapper)],display_low:[e(i),null],display_high:[e(i),null]})))},
function _(r,o,a,p,e){p(),e("CategoricalColorMapper",r(234).CategoricalColorMapper),e("CategoricalMarkerMapper",r(236).CategoricalMarkerMapper),e("CategoricalPatternMapper",r(237).CategoricalPatternMapper),e("ContinuousColorMapper",r(195).ContinuousColorMapper),e("ColorMapper",r(196).ColorMapper),e("LinearColorMapper",r(238).LinearColorMapper),e("LogColorMapper",r(239).LogColorMapper),e("ScanningColorMapper",r(194).ScanningColorMapper),e("EqHistColorMapper",r(240).EqHistColorMapper)},
function _(t,o,r,a,e){var c;a();const s=t(235),l=t(196),n=t(95);class _ extends l.ColorMapper{constructor(t){super(t)}_v_compute(t,o,r,{nan_color:a}){(0,s.cat_v_compute)(t,this.factors,r,o,this.start,this.end,a)}}r.CategoricalColorMapper=_,c=_,_.__name__="CategoricalColorMapper",c.define((({Number:t,Nullable:o})=>({factors:[n.FactorSeq],start:[t,0],end:[o(t),null]})))},
function _(n,t,e,i,l){i();const o=n(13),f=n(8);function c(n,t){if(n.length!=t.length)return!1;for(let e=0,i=n.length;e<i;e++)if(n[e]!==t[e])return!1;return!0}e._cat_equals=c,e.cat_v_compute=function(n,t,e,i,l,r,u){const _=n.length;for(let g=0;g<_;g++){let _,h,d=n[g];(0,f.isString)(d)?_=(0,o.index_of)(t,d):(d=d.slice(l,null!=r?r:void 0),_=1==d.length?(0,o.index_of)(t,d[0]):(0,o.find_index)(t,(n=>c(n,d)))),h=_<0||_>=e.length?u:e[_],i[g]=h}}},
function _(e,r,a,t,s){var c;t();const l=e(235),n=e(95),u=e(197),o=e(19);class p extends u.Mapper{constructor(e){super(e)}v_compute(e){const r=new Array(e.length);return(0,l.cat_v_compute)(e,this.factors,this.markers,r,this.start,this.end,this.default_value),r}}a.CategoricalMarkerMapper=p,c=p,p.__name__="CategoricalMarkerMapper",c.define((({Number:e,Array:r,Nullable:a})=>({factors:[n.FactorSeq],markers:[r(o.MarkerType)],start:[e,0],end:[a(e),null],default_value:[o.MarkerType,"circle"]})))},
function _(t,e,a,r,n){var s;r();const c=t(235),l=t(95),p=t(197),u=t(19);class o extends p.Mapper{constructor(t){super(t)}v_compute(t){const e=new Array(t.length);return(0,c.cat_v_compute)(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e}}a.CategoricalPatternMapper=o,s=o,o.__name__="CategoricalPatternMapper",s.define((({Number:t,Array:e,Nullable:a})=>({factors:[l.FactorSeq],patterns:[e(u.HatchPatternType)],start:[t,0],end:[a(t),null],default_value:[u.HatchPatternType," "]})))},
function _(n,r,o,t,a){t();const e=n(195),i=n(13),s=n(11);class _ extends e.ContinuousColorMapper{constructor(n){super(n)}scan(n,r){const o=null!=this.low?this.low:(0,i.min)(n),t=null!=this.high?this.high:(0,i.max)(n);return{max:t,min:o,norm_factor:1/(t-o),normed_interval:1/r}}index_to_value(n){const r=this._scan_data;return r.min+r.normed_interval*n/r.norm_factor}value_to_index(n,r){const o=this._scan_data;if(n==o.max)return r-1;const t=(n-o.min)*o.norm_factor,a=Math.floor(t/o.normed_interval);return(0,s.clamp)(a,-1,r)}}o.LinearColorMapper=_,_.__name__="LinearColorMapper"},
function _(n,t,a,o,s){o();const r=n(195),e=n(13),i=n(11);class l extends r.ContinuousColorMapper{constructor(n){super(n)}scan(n,t){const a=null!=this.low?this.low:(0,e.min)(n),o=null!=this.high?this.high:(0,e.max)(n);return{max:o,min:a,scale:t/Math.log(o/a)}}index_to_value(n){const t=this._scan_data;return t.min*Math.exp(n/t.scale)}value_to_index(n,t){const a=this._scan_data;if(n==a.max)return t-1;if(n>a.max)return t;if(n<a.min)return-1;const o=Math.log(n/a.min),s=Math.floor(o*a.scale);return(0,i.clamp)(s,-1,t)}}a.LogColorMapper=l,l.__name__="LogColorMapper"},
function _(e,n,s,t,l){var o;t();const i=e(194),r=e(13),c=e(10);class a extends i.ScanningColorMapper{constructor(e){super(e)}scan(e,n){const s=null!=this.low?this.low:(0,r.min)(e),t=null!=this.high?this.high:(0,r.max)(e),l=this.bins,o=(0,c.linspace)(s,t,l+1),i=(0,r.bin_counts)(e,o);let a=0;for(let e=0;e<l;e++)0!=i[e]&&a++;const _=new Array(a+1),h=new Array(a+1);for(let e=0,n=1;e<l;e++)0!=i[e]&&(_[n]=i[e],h[n]=(o[e]+o[e+1])/2,n++);_[0]=0,h[0]=2*h[1]-h[a];const f=(0,c.cumsum)(_),p=f[1],u=f[a]-p;for(let e=1;e<=a;e++)f[e]=(f[e]-p)/u;f[0]=-1;let{rescale_discrete_levels:m}=this,d=0;if(m){const e=-.5/98,n=e*a+(1.5-2*e);n>1?d=1-n:m=!1}const g=(0,c.linspace)(d,1,n+1),w=(0,r.interpolate)(g,f,h);let b=!1;if(m){const e=(0,r.sorted_index)(w,s);s<w[e]&&e>0&&(w[e-1]=s),b=!0}else w[0]=s;return w[w.length-1]=t,{min:s,max:t,binning:w,force_low_cutoff:b}}}s.EqHistColorMapper=a,o=a,a.__name__="EqHistColorMapper",o.define((({Boolean:e,Int:n})=>({bins:[n,65536],rescale_discrete_levels:[e,!1]})))},
function _(e,t,r,i,n){var o;i();const l=e(140),a=e(224),s=e(198),_=e(58),h=e(12);class v extends l.BaseColorBarView{async lazy_initialize(){await super.lazy_initialize();const{fill_renderer:e,line_renderer:t}=this.model;this._fill_view=await(0,_.build_view)(e,{parent:this.parent}),this._line_view=await(0,_.build_view)(t,{parent:this.parent})}remove(){this._fill_view.remove(),this._line_view.remove(),super.remove()}_create_major_range(){const e=this.model.levels;return e.length>0?new a.Range1d({start:e[0],end:e[e.length-1]}):new a.Range1d({start:0,end:1})}_paint_colors(e,t){const r="vertical"==this.orientation,i=this.model.levels,n=this._major_scale;n.source_range=this._major_range,n.target_range=r?new a.Range1d({start:t.bottom,end:t.top}):new a.Range1d({start:t.left,end:t.right});const o=n.v_compute(i),l=this._fill_view.glyph,s=l.data_size;if(s>0){(0,h.assert)(i.length==s+1,"Inconsistent number of filled contour levels"),e.save();for(let i=0;i<s;i++)e.beginPath(),r?e.rect(t.left,o[i],t.width,o[i+1]-o[i]):e.rect(o[i],t.top,o[i+1]-o[i],t.height),l.visuals.fill.apply(e,i),l.visuals.hatch.apply(e,i);e.restore()}const _=this._line_view.glyph,v=_.data_size;if(v>0){(0,h.assert)(i.length==v,"Inconsistent number of line contour levels"),e.save();for(let i=0;i<v;i++)e.beginPath(),r?(e.moveTo(t.left,o[i]),e.lineTo(t.right,o[i])):(e.moveTo(o[i],t.bottom),e.lineTo(o[i],t.top)),_.visuals.line.set_vectorize(e,i),e.stroke();e.restore()}}}r.ContourColorBarView=v,v.__name__="ContourColorBarView";class d extends l.BaseColorBar{constructor(e){super(e)}}r.ContourColorBar=d,o=d,d.__name__="ContourColorBar",o.prototype.default_view=v,o.define((({Array:e,Number:t,Ref:r})=>({fill_renderer:[r(s.GlyphRenderer)],line_renderer:[r(s.GlyphRenderer)],levels:[e(t),[]]})))},
function _(e,t,s,i,n){var a;i();const o=e(142),l=e(11),h=e(19),r=e(143);class u extends o.TextAnnotationView{update_layout(){const{panel:e}=this;this.layout=null!=e?new r.SideLayout(e,(()=>this.get_size()),!1):void 0}_get_size(){if(!this.displayed)return{width:0,height:0};const e=this._text_view.graphics(),{angle:t,angle_units:s}=this.model;e.angle=(0,l.resolve_angle)(t,s),e.visuals=this.visuals.text.values();const{width:i,height:n}=e.size();return{width:i,height:n}}_render(){const{angle:e,angle_units:t}=this.model,s=(0,l.resolve_angle)(e,t),i=null!=this.layout?this.layout:this.plot_view.frame,n=this.coordinates.x_scale,a=this.coordinates.y_scale;let o=(()=>{switch(this.model.x_units){case"canvas":return this.model.x;case"screen":return i.bbox.xview.compute(this.model.x);case"data":return n.compute(this.model.x)}})(),h=(()=>{switch(this.model.y_units){case"canvas":return this.model.y;case"screen":return i.bbox.yview.compute(this.model.y);case"data":return a.compute(this.model.y)}})();o+=this.model.x_offset,h-=this.model.y_offset,this._paint(this.layer.ctx,{sx:o,sy:h},s)}}s.LabelView=u,u.__name__="LabelView";class d extends o.TextAnnotation{constructor(e){super(e)}}s.Label=d,a=d,d.__name__="Label",a.prototype.default_view=u,a.define((({Number:e,Angle:t})=>({x:[e],x_units:[h.CoordinateUnits,"data"],y:[e],y_units:[h.CoordinateUnits,"data"],angle:[t,0],angle_units:[h.AngleUnits,"rad"],x_offset:[e,0],y_offset:[e,0]})))},
function _(t,e,i,s,n){s();const a=t(1);var o;const l=t(97),r=a.__importStar(t(77)),c=t(19),_=t(150),u=a.__importStar(t(17)),x=t(23);class h extends l.DataAnnotationView{map_data(){const{x_scale:t,y_scale:e}=this.coordinates,i=null!=this.layout?this.layout:this.plot_view.frame;this.sx=(()=>{switch(this.model.x_units){case"canvas":return new x.ScreenArray(this._x);case"screen":return i.bbox.xview.v_compute(this._x);case"data":return t.v_compute(this._x)}})(),this.sy=(()=>{switch(this.model.y_units){case"canvas":return new x.ScreenArray(this._y);case"screen":return i.bbox.yview.v_compute(this._y);case"data":return e.v_compute(this._y)}})()}paint(){const{ctx:t}=this.layer;for(let e=0,i=this.text.length;e<i;e++){const i=this.x_offset.get(e),s=this.y_offset.get(e),n=this.sx[e]+i,a=this.sy[e]-s,o=this.angle.get(e),l=this.text.get(e);isFinite(n+a+o)&&null!=l&&this._paint(t,e,`${l}`,n,a,o)}}_paint(t,e,i,s,n,a){const o=new _.TextBox({text:i});o.angle=a,o.position={sx:s,sy:n},o.visuals=this.visuals.text.values(e);const{background_fill:l,border_line:r}=this.visuals;if(l.doit||r.doit){const{p0:i,p1:s,p2:n,p3:a}=o.rect();t.beginPath(),t.moveTo(i.x,i.y),t.lineTo(s.x,s.y),t.lineTo(n.x,n.y),t.lineTo(a.x,a.y),t.closePath(),this.visuals.background_fill.apply(t,e),this.visuals.border_line.apply(t,e)}this.visuals.text.doit&&o.paint(t)}}i.LabelSetView=h,h.__name__="LabelSetView";class d extends l.DataAnnotation{constructor(t){super(t)}}i.LabelSet=d,o=d,d.__name__="LabelSet",o.prototype.default_view=h,o.mixins([r.TextVector,["border_",r.LineVector],["background_",r.FillVector]]),o.define((()=>({x:[u.XCoordinateSpec,{field:"x"}],y:[u.YCoordinateSpec,{field:"y"}],x_units:[c.CoordinateUnits,"data"],y_units:[c.CoordinateUnits,"data"],text:[u.NullStringSpec,{field:"text"}],angle:[u.AngleSpec,0],x_offset:[u.NumberSpec,{value:0}],y_offset:[u.NumberSpec,{value:0}]}))),o.override({background_fill_color:null,border_line_color:null})},
function _(t,e,i,l,s){l();const n=t(1);var o;const h=t(72),a=t(245),_=t(19),r=n.__importStar(t(77)),d=t(15),c=t(143),g=t(56),m=t(10),b=t(8),f=t(150);class x extends h.AnnotationView{update_layout(){const{panel:t}=this;this.layout=null!=t?new c.SideLayout(t,(()=>this.get_size())):void 0}cursor(t,e){return"none"==this.model.click_policy?null:"pointer"}get legend_padding(){return null!=this.model.border_line_color?this.model.padding:0}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render())),this.connect(this.model.item_change,(()=>this.request_render()))}compute_legend_bbox(){const{glyph_height:t,glyph_width:e}=this.model,{label_height:i,label_width:l}=this.model,s=[];for(const t of this.model.items){const e=t.get_field_from_label_prop(),i=t.get_labels_list_from_label_prop();for(const l of i){const i=new f.TextBox({text:`${l}`});i.visuals=this.visuals.label_text.values(),s.push({item:t,field:e,label:l,text_box:i,bbox:i.bbox()})}}this.text_widths=new Map;for(const t of s)this.text_widths.set(t.label,(0,m.max)([t.bbox.width,l]));this.max_label_height=(0,m.max)([i,t,...s.map((t=>t.bbox.height))]);const n=(0,m.max)([0,...this.text_widths.values()]),{title:o}=this.model;if(null==o||0==o.length)this.title_width=0,this.title_height=0;else{const t=new f.TextBox({text:o});t.visuals=this.visuals.title_text.values();const{width:e,height:i}=t.bbox();this.title_width=e,this.title_height=i+this.model.title_standoff}const h=this.model.margin,{legend_padding:a}=this,_=this.model.spacing,{label_standoff:r}=this.model;let d,c;if("vertical"==this.model.orientation)d=s.length*this.max_label_height+Math.max(s.length-1,0)*_+2*a+this.title_height,c=(0,m.max)([n+e+r+2*a,this.title_width+2*a]);else{let t=2*a+Math.max(s.length-1,0)*_;for(const[,i]of this.text_widths)t+=(0,m.max)([i,l])+e+r;c=(0,m.max)([this.title_width+2*a,t]),d=this.max_label_height+this.title_height+2*a}const x=null!=this.layout?this.layout:this.plot_view.frame,[u,p]=x.bbox.ranges,{location:w}=this.model;let v,y;if((0,b.isString)(w))switch(w){case"top_left":v=u.start+h,y=p.start+h;break;case"top":case"top_center":v=(u.end+u.start)/2-c/2,y=p.start+h;break;case"top_right":v=u.end-h-c,y=p.start+h;break;case"bottom_right":v=u.end-h-c,y=p.end-h-d;break;case"bottom":case"bottom_center":v=(u.end+u.start)/2-c/2,y=p.end-h-d;break;case"bottom_left":v=u.start+h,y=p.end-h-d;break;case"left":case"center_left":v=u.start+h,y=(p.end+p.start)/2-d/2;break;case"center":case"center_center":v=(u.end+u.start)/2-c/2,y=(p.end+p.start)/2-d/2;break;case"right":case"center_right":v=u.end-h-c,y=(p.end+p.start)/2-d/2}else{const[t,e]=w;v=x.bbox.xview.compute(t),y=x.bbox.yview.compute(e)-d}return new g.BBox({left:v,top:y,width:c,height:d})}interactive_bbox(){return this.compute_legend_bbox()}interactive_hit(t,e){return this.interactive_bbox().contains(t,e)}on_hit(t,e){let i;const{glyph_width:l}=this.model,{legend_padding:s}=this,n=this.model.spacing,{label_standoff:o}=this.model;let h=i=s;const a=this.compute_legend_bbox(),_="vertical"==this.model.orientation;for(const r of this.model.items){const d=r.get_labels_list_from_label_prop();for(const c of d){const d=a.x+h,m=a.y+i+this.title_height;let b,f;[b,f]=_?[a.width-2*s,this.max_label_height]:[this.text_widths.get(c)+l+o,this.max_label_height];if(new g.BBox({left:d,top:m,width:b,height:f}).contains(t,e)){switch(this.model.click_policy){case"hide":for(const t of r.renderers)t.visible=!t.visible;break;case"mute":for(const t of r.renderers)t.muted=!t.muted}return!0}_?i+=this.max_label_height+n:h+=this.text_widths.get(c)+l+o+n}}return!1}_render(){if(0==this.model.items.length)return;if(!(0,m.some)(this.model.items,(t=>t.visible)))return;for(const t of this.model.items)t.legend=this.model;const{ctx:t}=this.layer,e=this.compute_legend_bbox();t.save(),this._draw_legend_box(t,e),this._draw_legend_items(t,e),this._draw_title(t,e),t.restore()}_draw_legend_box(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.apply(t),this.visuals.border_line.apply(t)}_draw_legend_items(t,e){const{glyph_width:i,glyph_height:l}=this.model,{legend_padding:s}=this,n=this.model.spacing,{label_standoff:o}=this.model;let h=s,a=s;const _="vertical"==this.model.orientation;for(const r of this.model.items){if(!r.visible)continue;const d=r.get_labels_list_from_label_prop(),c=r.get_field_from_label_prop();if(0==d.length)continue;const g=(()=>{switch(this.model.click_policy){case"none":return!0;case"hide":return(0,m.every)(r.renderers,(t=>t.visible));case"mute":return(0,m.every)(r.renderers,(t=>!t.muted))}})();for(const m of d){const d=e.x+h,b=e.y+a+this.title_height,f=d+i,x=b+l;_?a+=this.max_label_height+n:h+=this.text_widths.get(m)+i+o+n,this.visuals.label_text.set_value(t),t.fillText(m,f+o,b+this.max_label_height/2);for(const e of r.renderers){const i=this.plot_view.renderer_view(e);null==i||i.draw_legend(t,d,f,b,x,c,m,r.index)}if(!g){let l,n;[l,n]=_?[e.width-2*s,this.max_label_height]:[this.text_widths.get(m)+i+o,this.max_label_height],t.beginPath(),t.rect(d,b,l,n),this.visuals.inactive_fill.set_value(t),t.fill()}}}}_draw_title(t,e){const{title:i}=this.model;null!=i&&0!=i.length&&this.visuals.title_text.doit&&(t.save(),t.translate(e.x0,e.y0+this.title_height),this.visuals.title_text.set_value(t),t.fillText(i,this.legend_padding,this.legend_padding-this.model.title_standoff),t.restore())}_get_size(){const{width:t,height:e}=this.compute_legend_bbox();return{width:t+2*this.model.margin,height:e+2*this.model.margin}}}i.LegendView=x,x.__name__="LegendView";class u extends h.Annotation{constructor(t){super(t)}initialize(){super.initialize(),this.item_change=new d.Signal0(this,"item_change")}get_legend_names(){const t=[];for(const e of this.items){const i=e.get_labels_list_from_label_prop();t.push(...i)}return t}}i.Legend=u,o=u,u.__name__="Legend",o.prototype.default_view=x,o.mixins([["label_",r.Text],["title_",r.Text],["inactive_",r.Fill],["border_",r.Line],["background_",r.Fill]]),o.define((({Number:t,String:e,Array:i,Tuple:l,Or:s,Ref:n,Nullable:o})=>({orientation:[_.Orientation,"vertical"],location:[s(_.LegendLocation,l(t,t)),"top_right"],title:[o(e),null],title_standoff:[t,5],label_standoff:[t,5],glyph_height:[t,20],glyph_width:[t,20],label_height:[t,20],label_width:[t,20],margin:[t,10],padding:[t,10],spacing:[t,3],items:[i(n(a.LegendItem)),[]],click_policy:[_.LegendClickPolicy,"none"]}))),o.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(e,r,l,n,t){n();const i=e(1);var s;const o=e(50),_=e(198),a=e(98),u=e(27),d=i.__importStar(e(17)),c=e(18),f=e(10);class h extends o.Model{constructor(e){super(e)}_check_data_sources_on_renderers(){if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;const e=this.renderers[0].data_source;for(const r of this.renderers)if(r.data_source!=e)return!1}return!0}_check_field_label_on_data_source(){const e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;const r=this.renderers[0].data_source;if(!(0,f.includes)(r.columns(),e))return!1}return!0}initialize(){super.initialize(),this.legend=null,this.connect(this.change,(()=>{var e;return null===(e=this.legend)||void 0===e?void 0:e.item_change.emit()}));this._check_data_sources_on_renderers()||c.logger.error("Non matching data sources on legend item renderers");this._check_field_label_on_data_source()||c.logger.error(`Bad column name on label: ${this.label}`)}get_field_from_label_prop(){const{label:e}=this;return(0,u.isField)(e)?e.field:null}get_labels_list_from_label_prop(){if(!this.visible)return[];if((0,u.isValue)(this.label)){const{value:e}=this.label;return null!=e?[e]:[]}const e=this.get_field_from_label_prop();if(null!=e){let r;if(0==this.renderers.length)return["No source found"];if(r=this.renderers[0].data_source,r instanceof a.ColumnarDataSource){const l=r.get_column(e);return null!=l?(0,f.uniq)(Array.from(l)):["Invalid field"]}}return[]}}l.LegendItem=h,s=h,h.__name__="LegendItem",s.define((({Boolean:e,Int:r,Array:l,Ref:n,Nullable:t})=>({label:[d.NullStringSpec,null],renderers:[l(n(_.GlyphRenderer)),[]],index:[t(r),null],visible:[e,!0]})))},
function _(t,s,e,n,i){n();const o=t(1);var a;const l=t(72),c=o.__importStar(t(77)),r=t(19);class _ extends l.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_render(){const{xs:t,ys:s}=this.model;if(t.length!=s.length)return;const e=t.length;if(e<3)return;const{frame:n}=this.plot_view,{ctx:i}=this.layer,o=this.coordinates.x_scale,a=this.coordinates.y_scale;function l(t,s,e,n){switch(s){case"canvas":return t;case"screen":return n.v_compute(t);case"data":return e.v_compute(t)}}const c=l(t,this.model.xs_units,o,n.bbox.xview),r=l(s,this.model.ys_units,a,n.bbox.yview);i.beginPath();for(let t=0;t<e;t++)i.lineTo(c[t],r[t]);i.closePath(),this.visuals.fill.apply(i),this.visuals.hatch.apply(i),this.visuals.line.apply(i)}}e.PolyAnnotationView=_,_.__name__="PolyAnnotationView";class h extends l.Annotation{constructor(t){super(t)}update({xs:t,ys:s}){this.setv({xs:t,ys:s,visible:!0})}clear(){this.setv({xs:[],ys:[],visible:!1})}}e.PolyAnnotation=h,a=h,h.__name__="PolyAnnotation",a.prototype.default_view=_,a.mixins([c.Line,c.Fill,c.Hatch]),a.define((({Number:t,Array:s})=>({xs:[s(t),[]],xs_units:[r.CoordinateUnits,"data"],ys:[s(t),[]],ys_units:[r.CoordinateUnits,"data"]}))),a.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(e,t,n,o,i){o();const s=e(1);var l;const r=e(72),c=s.__importStar(e(77));class a extends r.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_render(){const{gradient:e,y_intercept:t}=this.model;if(null==e||null==t)return;const{frame:n}=this.plot_view,o=this.coordinates.x_scale,i=this.coordinates.y_scale;let s,l,r,c;if(0==e)s=i.compute(t),l=s,r=n.bbox.left,c=r+n.bbox.width;else{s=n.bbox.top,l=s+n.bbox.height;const a=(i.invert(s)-t)/e,_=(i.invert(l)-t)/e;r=o.compute(a),c=o.compute(_)}const{ctx:a}=this.layer;a.save(),a.beginPath(),this.visuals.line.set_value(a),a.moveTo(r,s),a.lineTo(c,l),a.stroke(),a.restore()}}n.SlopeView=a,a.__name__="SlopeView";class _ extends r.Annotation{constructor(e){super(e)}}n.Slope=_,l=_,_.__name__="Slope",l.prototype.default_view=a,l.mixins(c.Line),l.define((({Number:e,Nullable:t})=>({gradient:[t(e),null],y_intercept:[t(e),null]}))),l.override({line_color:"black"})},
function _(e,t,i,n,o){n();const s=e(1);var a;const l=e(72),c=s.__importStar(e(77)),r=e(19);class d extends l.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.plot_view.request_paint(this)))}_render(){const{location:e}=this.model;if(null==e)return;const{frame:t}=this.plot_view,i=this.coordinates.x_scale,n=this.coordinates.y_scale,o=(t,i)=>{switch(this.model.location_units){case"canvas":return e;case"screen":return i.compute(e);case"data":return t.compute(e)}};let s,a,l,c;"width"==this.model.dimension?(l=o(n,t.bbox.yview),a=t.bbox.left,c=t.bbox.width,s=this.model.line_width):(l=t.bbox.top,a=o(i,t.bbox.xview),c=this.model.line_width,s=t.bbox.height);const{ctx:r}=this.layer;r.save(),r.beginPath(),this.visuals.line.set_value(r),r.moveTo(a,l),"width"==this.model.dimension?r.lineTo(a+c,l):r.lineTo(a,l+s),r.stroke(),r.restore()}}i.SpanView=d,d.__name__="SpanView";class h extends l.Annotation{constructor(e){super(e)}}i.Span=h,a=h,h.__name__="Span",a.prototype.default_view=d,a.mixins(c.Line),a.define((({Number:e,Nullable:t})=>({location:[t(e),null],location_units:[r.CoordinateUnits,"data"],dimension:[r.Dimension,"width"]}))),a.override({line_color:"black"})},
function _(e,i,t,o,s){var l;o();const a=e(72),n=e(250),r=e(58),h=e(55),_=e(143),v=e(56);class b extends a.AnnotationView{constructor(){super(...arguments),this._invalidate_toolbar=!0,this._previous_bbox=new v.BBox}update_layout(){this.layout=new _.SideLayout(this.panel,(()=>this.get_size()),!0)}has_finished(){return super.has_finished()&&this.toolbar_view.has_finished()}initialize(){super.initialize(),this.el=(0,h.div)(),this.plot_view.canvas_view.add_event(this.el)}async lazy_initialize(){await super.lazy_initialize(),this.toolbar_view=await(0,r.build_view)(this.model.toolbar,{parent:this.canvas})}connect_signals(){super.connect_signals(),this.plot_view.mouseenter.connect((()=>{this.toolbar_view.set_visibility(!0)})),this.plot_view.mouseleave.connect((()=>{this.toolbar_view.set_visibility(!1)}))}remove(){this.toolbar_view.remove(),(0,h.remove)(this.el),super.remove()}render(){this.model.visible||(0,h.undisplay)(this.el),super.render()}_render(){const{style:e}=this.toolbar_view.el;this.toolbar_view.model.horizontal?(e.width="100%",e.height="unset"):(e.width="unset",e.height="100%");const{bbox:i}=this.layout;this._previous_bbox.equals(i)||((0,h.position)(this.el,i),this._previous_bbox=i,this._invalidate_toolbar=!0),this._invalidate_toolbar&&(this.el.style.position="absolute",(0,h.empty)(this.el),this.el.appendChild(this.toolbar_view.el),this.toolbar_view.render(),this.toolbar_view.after_render(),this._invalidate_toolbar=!1),(0,h.display)(this.el)}_get_size(){const{tools:e,logo:i}=this.model.toolbar;return{width:30*e.length+(null!=i?25:0)+15,height:30}}}t.ToolbarPanelView=b,b.__name__="ToolbarPanelView";class d extends a.Annotation{constructor(e){super(e)}}t.ToolbarPanel=d,l=d,d.__name__="ToolbarPanel",l.prototype.default_view=b,l.define((({Ref:e})=>({toolbar:[e(n.Toolbar)]})))},
function _(t,e,o,i,s){i();const l=t(1);var n;const a=t(18),r=t(55),c=t(58),h=t(251),_=t(19),u=t(10),v=t(32),p=t(9),f=t(8),d=t(257),g=t(258),b=t(267),w=t(259),m=t(268),y=t(269),T=t(263),z=l.__importStar(t(270)),x=z,C=l.__importStar(t(266)),k=C,A=l.__importStar(t(271)),L=A,I=l.__importDefault(t(265));class P extends h.UIElementView{constructor(){super(...arguments),this.tool_button_views=new Map,this._visible=null}get overflow_el(){return this._overflow_el}get visible(){var t;return!!this.model.visible&&(!this.model.autohide||null!==(t=this._visible)&&void 0!==t&&t)}initialize(){super.initialize();const{location:t}=this.model,e="left"==t||"above"==t,o=this.model.horizontal?"vertical":"horizontal";this._overflow_menu=new T.ContextMenu([],{target:this.root.el,orientation:o,reversed:e,prevent_hide:t=>t.composedPath().includes(this._overflow_el),extra_styles:[C.default]})}async lazy_initialize(){await super.lazy_initialize(),await this._build_tool_button_views()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.tools.change,(async()=>{await this._build_tool_button_views(),this.render()})),this.connect(this.model.properties.autohide.change,(()=>{this._on_visible_change()}))}styles(){return[...super.styles(),z.default,C.default,A.default,I.default]}remove(){(0,c.remove_views)(this.tool_button_views),super.remove()}async _build_tool_button_views(){await(0,c.build_views)(this.tool_button_views,this.model.tools,{parent:this},(t=>t.button_view))}set_visibility(t){t!=this._visible&&(this._visible=t,this._on_visible_change())}_on_visible_change(){this.el.classList.toggle(x.hidden,!this.visible)}_after_resize(){super._after_resize(),this.render()}render(){super.render(),this.el.classList.add(x[this.model.location]),this.el.classList.toggle(x.inner,this.model.inner),this._on_visible_change();const{horizontal:t}=this.model;let e=0;if(null!=this.model.logo){const o="grey"===this.model.logo?L.grey:null,i=(0,r.a)({href:"https://bokeh.org/",target:"_blank",class:[L.logo,L.logo_small,o]});this.shadow_el.appendChild(i);const{width:s,height:l}=i.getBoundingClientRect();e+=t?s:l}for(const[,t]of this.tool_button_views)t.render();const o=[],i=t=>this.tool_button_views.get(t).el,{gestures:s}=this.model;for(const t of(0,p.values)(s))o.push(t.tools.map(i));o.push(this.model.actions.map(i)),o.push(this.model.inspectors.filter((t=>t.toggleable)).map(i));const l=o.filter((t=>0!=t.length)),n=()=>(0,r.div)({class:k.divider});this._overflow_el=(0,r.div)({class:k.tool_overflow,tabIndex:0},t?"\u22ee":"\u22ef");const a=()=>{const t=(()=>{switch(this.model.location){case"right":return{left_of:this._overflow_el};case"left":return{right_of:this._overflow_el};case"above":return{below:this._overflow_el};case"below":return{above:this._overflow_el}}})();this._overflow_menu.toggle(t)};this._overflow_el.addEventListener("click",(()=>{a()})),this._overflow_el.addEventListener("keydown",(t=>{t.keyCode==r.Keys.Enter&&a()}));const{bbox:c}=this,h=t?x.right:x.above;let _=!1;for(const o of(0,v.join)(l,n))if(_)this._overflow_menu.items.push({content:o,class:h});else{this.shadow_el.appendChild(o);const{width:i,height:s}=o.getBoundingClientRect();e+=t?i:s,_=t?e>c.width-15:e>c.height-15,_&&(this.shadow_el.removeChild(o),this.shadow_el.appendChild(this._overflow_el),(0,u.clear)(this._overflow_menu.items),this._overflow_menu.items.push({content:o,class:h}))}}}function S(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}o.ToolbarView=P,P.__name__="ToolbarView",o.Drag=d.Tool,o.Inspection=d.Tool,o.Scroll=d.Tool,o.Tap=d.Tool;class $ extends h.UIElement{constructor(t){super(t)}get horizontal(){return"above"==this.location||"below"==this.location}get vertical(){return"left"==this.location||"right"==this.location}connect_signals(){super.connect_signals();const{tools:t,active_drag:e,active_inspect:o,active_scroll:i,active_tap:s,active_multi:l}=this.properties;this.on_change([t,e,o,i,s,l],(()=>{this._init_tools(),this._activate_tools()}))}initialize(){super.initialize(),this._init_tools(),this._activate_tools()}_init_tools(){function t(t,e){return(t instanceof g.ToolProxy?t.underlying:t)instanceof e}const e=this.tools.filter((e=>t(e,w.InspectTool)));this.inspectors=e;const o=this.tools.filter((e=>t(e,y.HelpTool)));this.help=o;const i=this.tools.filter((e=>t(e,m.ActionTool)));this.actions=i;const s=(t,e)=>{t in this.gestures||a.logger.warn(`Toolbar: unknown event type '${t}' for tool: ${e}`)},l={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};for(const e of this.tools)if(t(e,b.GestureTool))if((0,f.isString)(e.event_type))l[e.event_type].tools.push(e),s(e.event_type,e);else{l.multi.tools.push(e);for(const t of e.event_type)s(t,e)}for(const t of Object.keys(l)){const e=this.gestures[t];e.tools=l[t].tools,e.active&&(0,u.every)(e.tools,(t=>{var o;return t.id!=(null===(o=e.active)||void 0===o?void 0:o.id)}))&&(e.active=null)}}_activate_tools(){if("auto"==this.active_inspect);else if(null==this.active_inspect)for(const t of this.inspectors)t.active=!1;else if((0,f.isArray)(this.active_inspect)){const t=(0,u.intersection)(this.active_inspect,this.inspectors);t.length!=this.active_inspect.length&&(this.active_inspect=t);for(const t of this.inspectors)(0,u.includes)(this.active_inspect,t)||(t.active=!1)}else{let t=!1;for(const e of this.inspectors)e!=this.active_inspect?e.active=!1:t=!0;t||(this.active_inspect=null)}const t=t=>{t.active?this._active_change(t):t.active=!0};for(const t of(0,p.values)(this.gestures)){t.tools=(0,u.sort_by)(t.tools,(t=>t.default_order));for(const e of t.tools)this.connect(e.properties.active.change,(()=>this._active_change(e)))}function e(t){switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null}function o(t){return"tap"==t||"pan"==t}for(const[i,s]of(0,p.entries)(this.gestures)){const l=i,n=e(l);if(n){const e=this[n];if("auto"==e)0!=s.tools.length&&o(l)&&t(s.tools[0]);else if(null!=e)(0,u.includes)(this.tools,e)?t(e):this[n]=null;else{this.gestures[l].active=null;for(const t of this.gestures[l].tools)t.active=!1}}}}_active_change(t){const{event_type:e}=t,o=(0,f.isString)(e)?[e]:e;for(const e of o)if(t.active){const o=this.gestures[e].active;null!=o&&t!=o&&(a.logger.debug(`Toolbar: deactivating tool: ${o} for event type '${e}'`),o.active=!1),this.gestures[e].active=t,a.logger.debug(`Toolbar: activating tool: ${t} for event type '${e}'`)}else this.gestures[e].active=null}}o.Toolbar=$,n=$,$.__name__="Toolbar",n.prototype.default_view=P,n.define((({Any:t,Boolean:e,Array:o,Or:i,Ref:s,Nullable:l})=>({tools:[o(i(s(d.Tool),s(g.ToolProxy))),[]],logo:[l(_.Logo),"normal"],autohide:[e,!1],active_drag:[t,"auto"],active_inspect:[t,"auto"],active_scroll:[t,"auto"],active_tap:[t,"auto"],active_multi:[t,"auto"]}))),n.internal((({Any:t,Array:e,Boolean:o,Ref:i,Or:s})=>({location:[_.Location,"right"],inner:[o,!1],gestures:[t,S],actions:[e(s(i(m.ActionTool),i(g.ToolProxy))),[]],inspectors:[e(s(i(w.InspectTool),i(g.ToolProxy))),[]],help:[e(s(i(y.HelpTool),i(g.ToolProxy))),[]]})))},
function _(e,t,s,i,l){i();const r=e(1);var n;const o=e(50),a=e(252),h=e(18),_=e(54),p=e(55),y=e(253),c=e(9),u=e(56),b=e(8),d=r.__importDefault(e(256)),{round:f}=Math;function*g(e){if(e instanceof a.Styles){const t=new Set((0,c.keys)(o.Model.prototype._props));for(const s of e)t.has(s.attr)||(yield[s.attr,s.get_value()])}else yield*(0,c.entries)(e)}class x extends _.DOMComponentView{constructor(){super(...arguments),this._display=new p.StyleSheet,this.style=new p.StyleSheet}get stylesheets(){return[...this._stylesheets()]}*_stylesheets(){yield this.style,yield this._display}get classes(){return[...this.css_classes(),...this._classes()]}*_classes(){yield`bk-${this.model.type}`}styles(){return[...super.styles(),d.default]}update_style(){this.style.clear()}box_sizing(){return{width_policy:"auto",height_policy:"auto",width:null,height:null,aspect_ratio:null}}get bbox(){return null==this._bbox&&this._update_bbox(),this._bbox}update_bbox(){this._update_bbox()}_update_bbox(){const e=(()=>{if(null!=this.el.offsetParent){const e=this.el.getBoundingClientRect(),{left:t,top:s}=(()=>{if(null!=this.parent){const t=this.parent.el.getBoundingClientRect();return{left:e.left-t.left,top:e.top-t.top}}return{left:0,top:0}})();return new u.BBox({left:f(t),top:f(s),width:f(e.width),height:f(e.height)})}return new u.BBox})();this._bbox=e}initialize(){super.initialize(),this._resize_observer=new ResizeObserver((e=>this.after_resize())),this._resize_observer.observe(this.el,{box:"border-box"})}connect_signals(){super.connect_signals();const{visible:e,styles:t}=this.model.properties;this.on_change(e,(()=>this._apply_visible())),this.on_change(t,(()=>this._apply_styles()))}remove(){this._resize_observer.disconnect(),super.remove()}_after_resize(){}after_resize(){this.update_bbox(),this._after_resize(),this.finish()}render_to(e){super.render_to(e),this.after_render()}render(){this.empty(),this._apply_stylesheets(this.styles()),this._apply_stylesheets(this.stylesheets),this._apply_stylesheets(this.model.stylesheets),this._apply_styles(),this._apply_classes(this.classes),this._apply_classes(this.model.classes),this._apply_visible()}after_render(){this.update_style(),this._is_displayed||this.finish()}get _is_displayed(){return null!=this.el.offsetParent}_apply_styles(){const{styles:e}=this.model,t=(e,t)=>{const s=this.el.style.hasOwnProperty(e);return s&&(0,b.isString)(t)&&(this.el.style[e]=t),s};for(const[s,i]of g(e)){const e=s.replace(/_/g,"-");t(e,i)||t(`-webkit-${e}`,i)||t(`-moz-${e}`,i)||h.logger.trace(`unknown CSS property '${e}'`)}}_apply_stylesheets(e){super._apply_stylesheets(e.map((e=>{if((0,b.isPlainObject)(e)){const t=[];for(const[s,i]of(0,c.entries)(e)){t.push(`${s} {`);for(const[e,s]of g(i)){const i=e.replace(/_/g,"-");(0,b.isString)(s)&&0!=s.length&&t.push(`  ${i}: ${s};`)}t.push("}")}return t.join("\n")}return e})))}_apply_visible(){this.model.visible?this._display.clear():this._display.replace(":host { display: none !important; }")}export(e="auto",t=!0){const s="auto"==e||"png"==e?"canvas":"svg",i=new y.CanvasLayer(s,t),{width:l,height:r}=this.bbox;return i.resize(l,r),i}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.bbox.box})}}s.UIElementView=x,x.__name__="UIElementView";class m extends o.Model{constructor(e){super(e)}}s.UIElement=m,n=m,m.__name__="UIElement",n.define((({Boolean:e,Array:t,Dict:s,String:i,Ref:l,Or:r,Nullable:n})=>{const o=r(s(n(i)),l(a.Styles));return{visible:[e,!0],classes:[t(i),[]],styles:[o,{}],stylesheets:[t(r(i,s(o))),[]]}}))},
function _(l,n,u,_,e){var t;_();const o=l(50);class r extends o.Model{constructor(l){super(l)}}u.Styles=r,t=r,r.__name__="Styles",t.define((({String:l,Nullable:n})=>({align_content:[n(l),null],align_items:[n(l),null],align_self:[n(l),null],alignment_baseline:[n(l),null],all:[n(l),null],animation:[n(l),null],animation_delay:[n(l),null],animation_direction:[n(l),null],animation_duration:[n(l),null],animation_fill_mode:[n(l),null],animation_iteration_count:[n(l),null],animation_name:[n(l),null],animation_play_state:[n(l),null],animation_timing_function:[n(l),null],aspect_ratio:[n(l),null],backface_visibility:[n(l),null],background:[n(l),null],background_attachment:[n(l),null],background_clip:[n(l),null],background_color:[n(l),null],background_image:[n(l),null],background_origin:[n(l),null],background_position:[n(l),null],background_position_x:[n(l),null],background_position_y:[n(l),null],background_repeat:[n(l),null],background_size:[n(l),null],baseline_shift:[n(l),null],block_size:[n(l),null],border:[n(l),null],border_block_end:[n(l),null],border_block_end_color:[n(l),null],border_block_end_style:[n(l),null],border_block_end_width:[n(l),null],border_block_start:[n(l),null],border_block_start_color:[n(l),null],border_block_start_style:[n(l),null],border_block_start_width:[n(l),null],border_bottom:[n(l),null],border_bottom_color:[n(l),null],border_bottom_left_radius:[n(l),null],border_bottom_right_radius:[n(l),null],border_bottom_style:[n(l),null],border_bottom_width:[n(l),null],border_collapse:[n(l),null],border_color:[n(l),null],border_image:[n(l),null],border_image_outset:[n(l),null],border_image_repeat:[n(l),null],border_image_slice:[n(l),null],border_image_source:[n(l),null],border_image_width:[n(l),null],border_inline_end:[n(l),null],border_inline_end_color:[n(l),null],border_inline_end_style:[n(l),null],border_inline_end_width:[n(l),null],border_inline_start:[n(l),null],border_inline_start_color:[n(l),null],border_inline_start_style:[n(l),null],border_inline_start_width:[n(l),null],border_left:[n(l),null],border_left_color:[n(l),null],border_left_style:[n(l),null],border_left_width:[n(l),null],border_radius:[n(l),null],border_right:[n(l),null],border_right_color:[n(l),null],border_right_style:[n(l),null],border_right_width:[n(l),null],border_spacing:[n(l),null],border_style:[n(l),null],border_top:[n(l),null],border_top_color:[n(l),null],border_top_left_radius:[n(l),null],border_top_right_radius:[n(l),null],border_top_style:[n(l),null],border_top_width:[n(l),null],border_width:[n(l),null],bottom:[n(l),null],box_shadow:[n(l),null],box_sizing:[n(l),null],break_after:[n(l),null],break_before:[n(l),null],break_inside:[n(l),null],caption_side:[n(l),null],caret_color:[n(l),null],clear:[n(l),null],clip:[n(l),null],clip_path:[n(l),null],clip_rule:[n(l),null],color:[n(l),null],color_interpolation:[n(l),null],color_interpolation_filters:[n(l),null],column_count:[n(l),null],column_fill:[n(l),null],column_gap:[n(l),null],column_rule:[n(l),null],column_rule_color:[n(l),null],column_rule_style:[n(l),null],column_rule_width:[n(l),null],column_span:[n(l),null],column_width:[n(l),null],columns:[n(l),null],content:[n(l),null],counter_increment:[n(l),null],counter_reset:[n(l),null],cursor:[n(l),null],direction:[n(l),null],display:[n(l),null],dominant_baseline:[n(l),null],empty_cells:[n(l),null],fill:[n(l),null],fill_opacity:[n(l),null],fill_rule:[n(l),null],filter:[n(l),null],flex:[n(l),null],flex_basis:[n(l),null],flex_direction:[n(l),null],flex_flow:[n(l),null],flex_grow:[n(l),null],flex_shrink:[n(l),null],flex_wrap:[n(l),null],float:[n(l),null],flood_color:[n(l),null],flood_opacity:[n(l),null],font:[n(l),null],font_family:[n(l),null],font_feature_settings:[n(l),null],font_kerning:[n(l),null],font_size:[n(l),null],font_size_adjust:[n(l),null],font_stretch:[n(l),null],font_style:[n(l),null],font_synthesis:[n(l),null],font_variant:[n(l),null],font_variant_caps:[n(l),null],font_variant_east_asian:[n(l),null],font_variant_ligatures:[n(l),null],font_variant_numeric:[n(l),null],font_variant_position:[n(l),null],font_weight:[n(l),null],gap:[n(l),null],glyph_orientation_vertical:[n(l),null],grid:[n(l),null],grid_area:[n(l),null],grid_auto_columns:[n(l),null],grid_auto_flow:[n(l),null],grid_auto_rows:[n(l),null],grid_column:[n(l),null],grid_column_end:[n(l),null],grid_column_gap:[n(l),null],grid_column_start:[n(l),null],grid_gap:[n(l),null],grid_row:[n(l),null],grid_row_end:[n(l),null],grid_row_gap:[n(l),null],grid_row_start:[n(l),null],grid_template:[n(l),null],grid_template_areas:[n(l),null],grid_template_columns:[n(l),null],grid_template_rows:[n(l),null],height:[n(l),null],hyphens:[n(l),null],image_orientation:[n(l),null],image_rendering:[n(l),null],inline_size:[n(l),null],justify_content:[n(l),null],justify_items:[n(l),null],justify_self:[n(l),null],left:[n(l),null],letter_spacing:[n(l),null],lighting_color:[n(l),null],line_break:[n(l),null],line_height:[n(l),null],list_style:[n(l),null],list_style_image:[n(l),null],list_style_position:[n(l),null],list_style_type:[n(l),null],margin:[n(l),null],margin_block_end:[n(l),null],margin_block_start:[n(l),null],margin_bottom:[n(l),null],margin_inline_end:[n(l),null],margin_inline_start:[n(l),null],margin_left:[n(l),null],margin_right:[n(l),null],margin_top:[n(l),null],marker:[n(l),null],marker_end:[n(l),null],marker_mid:[n(l),null],marker_start:[n(l),null],mask:[n(l),null],mask_composite:[n(l),null],mask_image:[n(l),null],mask_position:[n(l),null],mask_repeat:[n(l),null],mask_size:[n(l),null],mask_type:[n(l),null],max_block_size:[n(l),null],max_height:[n(l),null],max_inline_size:[n(l),null],max_width:[n(l),null],min_block_size:[n(l),null],min_height:[n(l),null],min_inline_size:[n(l),null],min_width:[n(l),null],object_fit:[n(l),null],object_position:[n(l),null],opacity:[n(l),null],order:[n(l),null],orphans:[n(l),null],outline:[n(l),null],outline_color:[n(l),null],outline_offset:[n(l),null],outline_style:[n(l),null],outline_width:[n(l),null],overflow:[n(l),null],overflow_anchor:[n(l),null],overflow_wrap:[n(l),null],overflow_x:[n(l),null],overflow_y:[n(l),null],overscroll_behavior:[n(l),null],overscroll_behavior_block:[n(l),null],overscroll_behavior_inline:[n(l),null],overscroll_behavior_x:[n(l),null],overscroll_behavior_y:[n(l),null],padding:[n(l),null],padding_block_end:[n(l),null],padding_block_start:[n(l),null],padding_bottom:[n(l),null],padding_inline_end:[n(l),null],padding_inline_start:[n(l),null],padding_left:[n(l),null],padding_right:[n(l),null],padding_top:[n(l),null],page_break_after:[n(l),null],page_break_before:[n(l),null],page_break_inside:[n(l),null],paint_order:[n(l),null],perspective:[n(l),null],perspective_origin:[n(l),null],place_content:[n(l),null],place_items:[n(l),null],place_self:[n(l),null],pointer_events:[n(l),null],position:[n(l),null],quotes:[n(l),null],resize:[n(l),null],right:[n(l),null],rotate:[n(l),null],row_gap:[n(l),null],ruby_align:[n(l),null],ruby_position:[n(l),null],scale:[n(l),null],scroll_behavior:[n(l),null],shape_rendering:[n(l),null],stop_color:[n(l),null],stop_opacity:[n(l),null],stroke:[n(l),null],stroke_dasharray:[n(l),null],stroke_dashoffset:[n(l),null],stroke_linecap:[n(l),null],stroke_linejoin:[n(l),null],stroke_miterlimit:[n(l),null],stroke_opacity:[n(l),null],stroke_width:[n(l),null],tab_size:[n(l),null],table_layout:[n(l),null],text_align:[n(l),null],text_align_last:[n(l),null],text_anchor:[n(l),null],text_combine_upright:[n(l),null],text_decoration:[n(l),null],text_decoration_color:[n(l),null],text_decoration_line:[n(l),null],text_decoration_style:[n(l),null],text_emphasis:[n(l),null],text_emphasis_color:[n(l),null],text_emphasis_position:[n(l),null],text_emphasis_style:[n(l),null],text_indent:[n(l),null],text_justify:[n(l),null],text_orientation:[n(l),null],text_overflow:[n(l),null],text_rendering:[n(l),null],text_shadow:[n(l),null],text_transform:[n(l),null],text_underline_position:[n(l),null],top:[n(l),null],touch_action:[n(l),null],transform:[n(l),null],transform_box:[n(l),null],transform_origin:[n(l),null],transform_style:[n(l),null],transition:[n(l),null],transition_delay:[n(l),null],transition_duration:[n(l),null],transition_property:[n(l),null],transition_timing_function:[n(l),null],translate:[n(l),null],unicode_bidi:[n(l),null],user_select:[n(l),null],vertical_align:[n(l),null],visibility:[n(l),null],white_space:[n(l),null],widows:[n(l),null],width:[n(l),null],will_change:[n(l),null],word_break:[n(l),null],word_spacing:[n(l),null],word_wrap:[n(l),null],writing_mode:[n(l),null],z_index:[n(l),null]})))},
function _(t,e,i,s,n){s();const a=t(254),o=t(56),r=t(55);function h(t){!function(t){void 0===t.lineDash&&Object.defineProperty(t,"lineDash",{get:()=>t.getLineDash(),set:e=>t.setLineDash(e)})}(t),function(t){t.setImageSmoothingEnabled=e=>{t.imageSmoothingEnabled=e,t.mozImageSmoothingEnabled=e,t.oImageSmoothingEnabled=e,t.webkitImageSmoothingEnabled=e,t.msImageSmoothingEnabled=e},t.getImageSmoothingEnabled=()=>{const e=t.imageSmoothingEnabled;return null==e||e}}(t),function(t){t.ellipse||(t.ellipse=function(e,i,s,n,a,o,r,h=!1){const c=.551784;t.translate(e,i),t.rotate(a);let l=s,g=n;h&&(l=-s,g=-n),t.moveTo(-l,0),t.bezierCurveTo(-l,g*c,-l*c,g,0,g),t.bezierCurveTo(l*c,g,l,g*c,l,0),t.bezierCurveTo(l,-g*c,l*c,-g,0,-g),t.bezierCurveTo(-l*c,-g,-l,-g*c,-l,0),t.rotate(-a),t.translate(-e,-i)})}(t)}class c{constructor(t,e){switch(this.backend=t,this.hidpi=e,this.pixel_ratio=1,this.bbox=new o.BBox,t){case"webgl":case"canvas":{this._el=this._canvas=(0,r.canvas)({class:"bk-layer"});const t=this.canvas.getContext("2d");if(null==t)throw new Error("unable to obtain 2D rendering context");this._ctx=t,e&&(this.pixel_ratio=devicePixelRatio);break}case"svg":{const t=new a.SVGRenderingContext2D;this._ctx=t,this._canvas=t.get_svg(),this._el=(0,r.div)({class:"bk-layer"});this._el.attachShadow({mode:"open"}).appendChild(this._canvas);break}}this._ctx.layer=this,h(this._ctx)}get canvas(){return this._canvas}get ctx(){return this._ctx}get el(){return this._el}resize(t,e){if(this.bbox.width==t&&this.bbox.height==e)return;this.bbox=new o.BBox({left:0,top:0,width:t,height:e});const{target:i}=this;i.width=t*this.pixel_ratio,i.height=e*this.pixel_ratio}get target(){return this._ctx instanceof a.SVGRenderingContext2D?this._ctx:this.canvas}undo_transform(t){const{ctx:e}=this,i=e.getTransform();e.setTransform(this._base_transform);try{t(e)}finally{e.setTransform(i)}}prepare(){const{ctx:t,hidpi:e,pixel_ratio:i}=this;t.save(),e&&(t.scale(i,i),t.translate(.5,.5)),this._base_transform=t.getTransform(),this.clear()}clear(){const{x:t,y:e,width:i,height:s}=this.bbox;this.ctx.clearRect(t,e,i,s)}finish(){this.ctx.restore()}to_blob(){const{_canvas:t}=this;if(t instanceof HTMLCanvasElement)return new Promise(((e,i)=>{t.toBlob((t=>null!=t?e(t):i()),"image/png")}));{const t=this._ctx.get_serialized_svg(!0),e=new Blob([t],{type:"image/svg+xml"});return Promise.resolve(e)}}}i.CanvasLayer=c,c.__name__="CanvasLayer"},
function _(t,e,i,s,r){s();const n=t(152),a=t(8),o=t(255),l=t(11),h=t(55);function _(t){const e={left:"start",right:"end",center:"middle",start:"start",end:"end"};return t in e?e[t]:e.start}function c(t){const e={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return t in e?e[t]:e.alphabetic}const p=function(t,e){const i=new Map,s=t.split(",");e=null!=e?e:10;for(let t=0;t<s.length;t+=2){const r=`&${s[t+1]};`,n=parseInt(s[t],e);i.set(r,`&#${n};`)}return i.set("\\xa0","&#160;"),i}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),u={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"},lineDashOffset:{svgAttr:"stroke-dashoffset",canvas:0,svg:0,apply:"stroke"}};class d{constructor(t,e){this.__root=t,this.__ctx=e}addColorStop(t,e){if("linearGradient"===this.__root.nodeName&&this.__root.getAttribute("x1")===this.__root.getAttribute("x2")&&this.__root.getAttribute("y1")===this.__root.getAttribute("y2"))return;if("radialGradient"===this.__root.nodeName&&this.__root.getAttribute("cx")===this.__root.getAttribute("fx")&&this.__root.getAttribute("cy")===this.__root.getAttribute("fy")&&this.__root.getAttribute("r")===this.__root.getAttribute("r0"))return;const i=this.__ctx.__createElement("stop");if(i.setAttribute("offset",`${t}`),-1!==e.indexOf("rgba")){const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),[,s,r,n,a]=t;i.setAttribute("stop-color",`rgb(${s},${r},${n})`),i.setAttribute("stop-opacity",a)}else i.setAttribute("stop-color",e);this.__root.appendChild(i)}}d.__name__="CanvasGradient";class m{constructor(t,e){this.__root=t,this.__ctx=e}setTransform(t){throw new Error("not implemented")}}m.__name__="CanvasPattern";class f{constructor(t){var e,i,s;this.__currentDefaultPath="",this.__currentPosition=null,this.globalAlpha=1,this._transform=new n.AffineTransform,this._clip_path=null,this.__document=null!==(e=null==t?void 0:t.document)&&void 0!==e?e:document,(null==t?void 0:t.ctx)?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__currentElement=this.__root,this.width=null!==(i=null==t?void 0:t.width)&&void 0!==i?i:500,this.height=null!==(s=null==t?void 0:t.height)&&void 0!==s?s:500,this.__ids=new Set,this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}get canvas(){return this}get width(){return this._width}set width(t){this._width=t,this.__root.setAttribute("width",`${t}`)}get height(){return this._height}set height(t){this._height=t,this.__root.setAttribute("height",`${t}`)}_random_string(){let t;do{t=f.__random.choices(12,"ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz").join("")}while(this.__ids.has(t));return t}__createElement(t,e={},i=!1){const s=this.__document.createElementNS("http://www.w3.org/2000/svg",t);i&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none"));const r=Object.keys(e);for(const t of r)s.setAttribute(t,`${e[t]}`);return s}__setDefaultStyles(){const t=Object.keys(u),e=this;for(let i=0;i<t.length;i++){const s=t[i];e[s]=u[s].canvas}}__applyStyleState(t){const e=Object.keys(t),i=this;for(let s=0;s<e.length;s++){const r=e[s];i[r]=t[r]}}__getStyleState(){const t=Object.keys(u),e={};for(let i=0;i<t.length;i++){const s=t[i];e[s]=this[s]}return e}__applyStyleToCurrentElement(t){const e=this.__currentElement,i=Object.keys(u);for(let s=0;s<i.length;s++){const r=u[i[s]],n=this[i[s]];if(null!=r.apply&&r.apply.includes(t))if(n instanceof m){for(const t of[...n.__ctx.__defs.childNodes])if(t instanceof Element){const e=t.getAttribute("id");this.__ids.add(e),this.__defs.appendChild(t)}const t=n.__root.getAttribute("id");e.setAttribute(r.apply,`url(#${t})`)}else if(n instanceof d){const t=n.__root.getAttribute("id");e.setAttribute(r.apply,`url(#${t})`)}else if(r.svg!==n)if("stroke"!==r.svgAttr&&"fill"!==r.svgAttr||!(0,a.isString)(n)||-1===n.indexOf("rgba")){let a=r.svgAttr;if("globalAlpha"===i[s]&&(a=`${t}-${r.svgAttr}`,null!=e.getAttribute(a)))continue;e.setAttribute(a,`${n}`)}else{const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(n),[,i,s,a,o]=t;e.setAttribute(r.svgAttr,`rgb(${i},${s},${a})`);const l=parseFloat(o)*this.globalAlpha;e.setAttribute(`${r.svgAttr}-opacity`,`${l}`)}}}get_serialized_svg(t=!1){let e=(new XMLSerializer).serializeToString(this.__root);if(t)for(const[t,i]of p){const s=new RegExp(t,"gi");s.test(e)&&(e=e.replace(s,i))}return e}get_svg(){return this.__root}save(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()}restore(){if(0==this.__stack.length)return;const{transform:t,clip_path:e,attributes:i}=this.__stack.pop();this._transform=t,this._clip_path=e,this.__applyStyleState(i)}_apply_transform(t,e=this._transform){e.is_identity||t.setAttribute("transform",e.toString())}scale(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,null!=e?e:t)}rotate(t){isFinite(t)&&this._transform.rotate(t)}translate(t,e){isFinite(t+e)&&this._transform.translate(t,e)}transform(t,e,i,s,r,n){isFinite(t+e+i+s+r+n)&&this._transform.transform(t,e,i,s,r,n)}beginPath(){this.__currentDefaultPath="",this.__currentPosition=null,this.__init_element()}__init_element(){const t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t}__applyCurrentDefaultPath(){const t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)}__addPathCommand(t,e,i){const s=this.__currentDefaultPath?" ":"";this.__currentDefaultPath+=s+i,this.__currentPosition={x:t,y:e}}get _hasCurrentDefaultPath(){return!!this.__currentDefaultPath}moveTo(t,e){if(!isFinite(t+e))return;"path"!==this.__currentElement.nodeName&&this.beginPath();const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`M ${i} ${s}`)}closePath(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")}lineTo(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`L ${i} ${s}`)}else this.moveTo(t,e)}bezierCurveTo(t,e,i,s,r,n){if(!isFinite(t+e+i+s+r+n))return;const[a,o]=this._transform.apply(r,n),[l,h]=this._transform.apply(t,e),[_,c]=this._transform.apply(i,s);this.__addPathCommand(a,o,`C ${l} ${h} ${_} ${c} ${a} ${o}`)}quadraticCurveTo(t,e,i,s){if(!isFinite(t+e+i+s))return;const[r,n]=this._transform.apply(i,s),[a,o]=this._transform.apply(t,e);this.__addPathCommand(r,n,`Q ${a} ${o} ${r} ${n}`)}arcTo(t,e,i,s,r){if(!isFinite(t+e+i+s+r))return;if(null==this.__currentPosition)return;const n=this.__currentPosition.x,a=this.__currentPosition.y;if(r<0)throw new Error(`IndexSizeError: The radius provided (${r}) is negative.`);if(n===t&&a===e||t===i&&e===s||0===r)return void this.lineTo(t,e);function o([t,e]){const i=Math.sqrt(t**2+e**2);return[t/i,e/i]}const l=o([n-t,a-e]),h=o([i-t,s-e]);if(l[0]*h[1]==l[1]*h[0])return void this.lineTo(t,e);const _=l[0]*h[0]+l[1]*h[1],c=Math.acos(Math.abs(_)),p=o([l[0]+h[0],l[1]+h[1]]),u=r/Math.sin(c/2),d=t+u*p[0],m=e+u*p[1],f=[-l[1],l[0]],g=[h[1],-h[0]];function b(t){const e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}const v=b(f),A=b(g);this.lineTo(d+f[0]*r,m+f[1]*r),this.arc(d,m,r,v,A)}stroke(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}fill(t,e){let i=null;if(t instanceof Path2D)i=t;else{if(null!=e)throw new Error("invalid arguments");e=t}if(null!=i)throw new Error("not implemented");"none"!=this.__currentElement.getAttribute("fill")&&this.__init_element(),"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=e&&this.__currentElement.setAttribute("fill-rule",e),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}rect(t,e,i,s){isFinite(t+e+i+s)&&(this.moveTo(t,e),this.lineTo(t+i,e),this.lineTo(t+i,e+s),this.lineTo(t,e+s),this.lineTo(t,e))}fillRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.fill())}strokeRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.stroke())}__clearCanvas(){(0,h.empty)(this.__defs),(0,h.empty)(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root}clearRect(t,e,i,s){if(!isFinite(t+e+i+s))return;if(0===t&&0===e&&i===this.width&&s===this.height)return void this.__clearCanvas();const r=this.__createElement("rect",{x:t,y:e,width:i,height:s,fill:"#FFFFFF"},!0);this._apply_transform(r),this.__root.appendChild(r)}createLinearGradient(t,e,i,s){if(!isFinite(t+e+i+s))throw new Error("The provided double value is non-finite");const[r,n]=this._transform.apply(t,e),[a,o]=this._transform.apply(i,s),l=this.__createElement("linearGradient",{id:this._random_string(),x1:`${r}px`,x2:`${a}px`,y1:`${n}px`,y2:`${o}px`,gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(l),new d(l,this)}createRadialGradient(t,e,i,s,r,n){if(!isFinite(t+e+i+s+r+n))throw new Error("The provided double value is non-finite");const[a,o]=this._transform.apply(t,e),[l,h]=this._transform.apply(s,r),_=this.__createElement("radialGradient",{id:this._random_string(),cx:`${l}px`,cy:`${h}px`,r:`${n}px`,r0:`${i}px`,fx:`${a}px`,fy:`${o}px`,gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(_),new d(_,this)}createConicGradient(t,e,i){throw Error("not implemented")}__parseFont(){const[,t,e,i,s,,r]=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font);return{style:null!=t?t:"normal",size:null!=s?s:"10px",family:null!=r?r:"sans-serif",weight:null!=i?i:"normal",decoration:null!=e?e:"normal"}}__applyText(t,e,i,s){const r=this.__parseFont(),n=this.__createElement("text",{"font-family":r.family,"font-size":r.size,"font-style":r.style,"font-weight":r.weight,"text-decoration":r.decoration,x:e,y:i,"text-anchor":_(this.textAlign),"dominant-baseline":c(this.textBaseline)},!0);n.appendChild(this.__document.createTextNode(t)),this._apply_transform(n),this.__currentElement=n,this.__applyStyleToCurrentElement(s);const a=(()=>{if(null!=this._clip_path){const t=this.__createElement("g");return t.setAttribute("clip-path",this._clip_path),t.appendChild(n),t}return n})();this.__root.appendChild(a)}fillText(t,e,i){isFinite(e+i)&&this.__applyText(t,e,i,"fill")}strokeText(t,e,i){isFinite(e+i)&&this.__applyText(t,e,i,"stroke")}measureText(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)}arc(t,e,i,s,r,n=!1){this.ellipse(t,e,i,i,0,s,r,n)}ellipse(t,e,i,s,r,n,a,o=!1){if(!isFinite(t+e+i+s+r+n+a))return;if(i<0||s<0)throw new DOMException("IndexSizeError, radius can't be negative");const h=o?a-n:n-a;n%=2*Math.PI,a%=2*Math.PI;const _=t+i*Math.cos(n),c=e+s*Math.sin(n);this.lineTo(_,c);const p=180*r/Math.PI,u=o?0:1;if(Math.abs(n-a)<2*l.float32_epsilon&&!(Math.abs(h)<2*l.float32_epsilon&&h<0)){const r=t+i*Math.cos(n+Math.PI),a=e+s*Math.sin(n+Math.PI),[o,l]=this._transform.apply(_,c),[h,d]=this._transform.apply(r,a);this.__addPathCommand(o,l,`A ${i} ${s} ${p} 0 ${u} ${h} ${d} A ${i} ${s} ${p} 0 ${u} ${o} ${l}`)}else{const r=t+i*Math.cos(a),l=e+s*Math.sin(a);let h=a-n;h<0&&(h+=2*Math.PI);const _=o!==h>Math.PI?1:0,[c,d]=this._transform.apply(r,l);this.__addPathCommand(c,d,`A ${i} ${s} ${p} ${_} ${u} ${c} ${d}`)}}clip(){const t=this.__createElement("clipPath"),e=this._random_string();this.__applyCurrentDefaultPath(),t.setAttribute("id",e),t.appendChild(this.__currentElement),this.__defs.appendChild(t),this._clip_path=`url(#${e})`}drawImage(t,...e){let i,s,r,n,a,o,l,h;if(2==e.length){if([i,s]=e,!isFinite(i+s))return;a=0,o=0,l=t.width,h=t.height,r=l,n=h}else if(4==e.length){if([i,s,r,n]=e,!isFinite(i+s+r+n))return;a=0,o=0,l=t.width,h=t.height}else{if(8!==e.length)throw new Error(`Inavlid number of arguments passed to drawImage: ${arguments.length}`);if([a,o,l,h,i,s,r,n]=e,!isFinite(a+o+l+h+i+s+r+n))return}const _=this.__root,c=this._transform.clone().translate(i,s);if(t instanceof f||t instanceof SVGSVGElement){const e=(t instanceof SVGSVGElement?t:t.get_svg()).cloneNode(!0);let i;c.is_identity&&1==this.globalAlpha&&null==this._clip_path?i=_:(i=this.__createElement("g"),c.is_identity||this._apply_transform(i,c),1!=this.globalAlpha&&i.setAttribute("opacity",`${this.globalAlpha}`),null!=this._clip_path&&i.setAttribute("clip-path",this._clip_path),_.appendChild(i));for(const t of[...e.childNodes])if(t instanceof SVGDefsElement){for(const e of[...t.childNodes])if(e instanceof Element){const t=e.getAttribute("id");this.__ids.add(t),this.__defs.appendChild(e.cloneNode(!0))}}else i.appendChild(t.cloneNode(!0))}else if(t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__createElement("image");if(e.setAttribute("width",`${r}`),e.setAttribute("height",`${n}`),e.setAttribute("preserveAspectRatio","none"),1!=this.globalAlpha&&e.setAttribute("opacity",`${this.globalAlpha}`),a||o||l!==t.width||h!==t.height){const e=this.__document.createElement("canvas");e.width=r,e.height=n;e.getContext("2d").drawImage(t,a,o,l,h,0,0,r,n),t=e}this._apply_transform(e,c);const i=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");if(e.setAttribute("href",i),null!=this._clip_path){const t=this.__createElement("g");t.setAttribute("clip-path",this._clip_path),t.appendChild(e),_.appendChild(t)}else _.appendChild(e)}else if(t instanceof HTMLCanvasElement){const e=this.__createElement("image");e.setAttribute("width",`${r}`),e.setAttribute("height",`${n}`),e.setAttribute("preserveAspectRatio","none"),1!=this.globalAlpha&&e.setAttribute("opacity",`${this.globalAlpha}`);const i=this.__document.createElement("canvas");i.width=r,i.height=n;const s=i.getContext("2d");if(s.imageSmoothingEnabled=!1,s.drawImage(t,a,o,l,h,0,0,r,n),t=i,this._apply_transform(e,c),e.setAttribute("href",t.toDataURL()),null!=this._clip_path){const t=this.__createElement("g");t.setAttribute("clip-path",this._clip_path),t.appendChild(e),_.appendChild(t)}else _.appendChild(e)}}createPattern(t,e){const i=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),s=this._random_string();if(i.setAttribute("id",s),i.setAttribute("width",`${this._to_number(t.width)}`),i.setAttribute("height",`${this._to_number(t.height)}`),i.setAttribute("patternUnits","userSpaceOnUse"),t instanceof HTMLCanvasElement||t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),s=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttribute("href",s),i.appendChild(e),this.__defs.appendChild(i)}else if(t instanceof f){for(const e of[...t.__root.childNodes])e instanceof SVGDefsElement||i.appendChild(e.cloneNode(!0));this.__defs.appendChild(i)}else{if(!(t instanceof SVGSVGElement))throw new Error("unsupported");for(const e of[...t.childNodes])e instanceof SVGDefsElement||i.appendChild(e.cloneNode(!0));this.__defs.appendChild(i)}return new m(i,this)}getLineDash(){const{lineDash:t}=this;return(0,a.isString)(t)?t.split(",").map((t=>parseInt(t))):null==t?[]:t}setLineDash(t){t.length>0?this.lineDash=t.join(","):this.lineDash=null}_to_number(t){return(0,a.isNumber)(t)?t:t.baseVal.value}getTransform(){return this._transform.to_DOMMatrix()}setTransform(...t){let e;e=(0,a.isNumber)(t[0])?new DOMMatrix(t):t[0]instanceof DOMMatrix?t[0]:new DOMMatrix(Object.values(!t[0])),this._transform=n.AffineTransform.from_DOMMatrix(e)}resetTransform(){this._transform=new n.AffineTransform}isPointInPath(...t){throw new Error("not implemented")}isPointInStroke(...t){throw new Error("not implemented")}createImageData(...t){throw new Error("not implemented")}getImageData(t,e,i,s){throw new Error("not implemented")}putImageData(...t){throw new Error("not implemented")}drawFocusIfNeeded(...t){throw new Error("not implemented")}scrollPathIntoView(...t){throw new Error("not implemented")}}i.SVGRenderingContext2D=f,f.__name__="SVGRenderingContext2D",f.__random=o.random},
function _(t,e,s,n,r){n();const o=2147483647,{PI:a,log:i,sin:h,cos:l,sqrt:c}=Math;class d{constructor(t){this.seed=t%o,this.seed<=0&&(this.seed+=2147483646)}integer(){return this.seed=48271*this.seed%o,this.seed}float(){return(this.integer()-1)/2147483646}floats(t,e=0,s=1){const n=new Array(t);for(let r=0;r<t;r++)n[r]=e+this.float()*(s-e);return n}choices(t,e){const s=e.length,n=new Array(t);for(let r=0;r<t;r++)n[r]=e[this.integer()%s];return n}normal(t,e,s){const[n,r]=[t,e],o=new Float64Array(s);for(let t=0;t<s;t+=2){const e=this.float(),d=this.float(),f=c(-2*i(e));o[t]=n+r*(f*l(2*a*d)),t+1<s&&(o[t+1]=n+r*(f*h(2*a*d)))}return o}}s.Random=d,d.__name__="Random",s.random=new d(Date.now())},
function _(t,i,o,e,n){e(),o.default=":host{position:relative;}"},
function _(t,e,o,n,i){var s;n();const a=t(53),l=t(19),r=t(10),c=t(50);class _ extends a.View{connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>{this.model.active?this.activate():this.deactivate()}))}activate(){}deactivate(){}}o.ToolView=_,_.__name__="ToolView";class d extends c.Model{constructor(t){super(t)}get computed_overlays(){return[]}get tooltip(){var t;return null!==(t=this.description)&&void 0!==t?t:this.tool_name}get computed_icon(){const{icon:t,tool_icon:e}=this;return null!=t?t:null!=e?`.${e}`:void 0}get menu(){return null}_get_dim_limits([t,e],[o,n],i,s){const a=i.bbox.h_range;let l;"width"==s||"both"==s?(l=[(0,r.min)([t,o]),(0,r.max)([t,o])],l=[(0,r.max)([l[0],a.start]),(0,r.min)([l[1],a.end])]):l=[a.start,a.end];const c=i.bbox.v_range;let _;return"height"==s||"both"==s?(_=[(0,r.min)([e,n]),(0,r.max)([e,n])],_=[(0,r.max)([_[0],c.start]),(0,r.min)([_[1],c.end])]):_=[c.start,c.end],[l,_]}_get_dim_tooltip(t){const{description:e,tool_name:o}=this;return null!=e?e:"both"==t?o:"auto"==t?`${o} (either x, y or both dimensions)`:`${o} (${"width"==t?"x":"y"}-axis)`}static register_alias(t,e){this.prototype._known_aliases.set(t,e)}static from_string(t){const e=this.prototype._known_aliases.get(t);if(null!=e)return e();{const e=[...this.prototype._known_aliases.keys()];throw new Error(`unexpected tool name '${t}', possible tools are ${e.join(", ")}`)}}}o.Tool=d,s=d,d.__name__="Tool",s.prototype._known_aliases=new Map,s.define((({String:t,Regex:e,Nullable:o,Or:n})=>({icon:[o(n(l.ToolIcon,e(/^--/),e(/^\./),e(/^data:image/))),null],description:[o(t),null]}))),s.internal((({Boolean:t})=>({active:[t,!1],disabled:[t,!1]})))},
function _(t,o,e,s,n){var i;s();const l=t(15),r=t(50),c=t(257),a=t(259),u=t(32);class h extends r.Model{constructor(t){super(t)}get underlying(){return this.tools[0]}get button_view(){return this.tools[0].button_view}get event_type(){return this.tools[0].event_type}get default_order(){return this.tools[0].default_order}get tooltip(){return this.tools[0].tooltip}get tool_name(){return this.tools[0].tool_name}get computed_icon(){return this.tools[0].computed_icon}get toggleable(){const t=this.tools[0];return t instanceof a.InspectTool&&t.toggleable}get computed_overlays(){return[...(0,u.flat_map)(this.tools,(t=>t.computed_overlays))]}initialize(){super.initialize(),this.do=new l.Signal0(this,"do")}connect_signals(){super.connect_signals(),this.connect(this.do,(()=>this.doit())),this.connect(this.properties.active.change,(()=>this.set_active()));for(const t of this.tools)this.connect(t.properties.active.change,(()=>{this.active=t.active}))}doit(){for(const t of this.tools)t.do.emit()}set_active(){for(const t of this.tools)t.active=this.active}get menu(){const{menu:t}=this.tools[0];if(null==t)return null;const o=[];for(const[e,s]of(0,u.enumerate)(t))if(null==e)o.push(null);else{const t=()=>{var t,o,e;for(const n of this.tools)null===(e=null===(o=null===(t=n.menu)||void 0===t?void 0:t[s])||void 0===o?void 0:o.handler)||void 0===e||e.call(o)};o.push(Object.assign(Object.assign({},e),{handler:t}))}return o}}e.ToolProxy=h,i=h,h.__name__="ToolProxy",i.define((({Boolean:t,Array:o,Ref:e})=>({tools:[o(e(c.Tool)),[]],active:[t,t=>(0,u.some)(t.tools,(t=>t.active))],disabled:[t,!1]})))},
function _(e,o,t,n,s){var i;n();const l=e(257),_=e(260);class c extends l.ToolView{get plot_view(){return this.parent}}t.InspectToolView=c,c.__name__="InspectToolView";class p extends l.Tool{constructor(e){super(e),this.event_type="move"}}t.InspectTool=p,i=p,p.__name__="InspectTool",i.prototype.button_view=_.OnOffButtonView,i.define((({Boolean:e})=>({toggleable:[e,!0]}))),i.override({active:!0})},
function _(t,e,i,n,o){n();const s=t(1),c=t(261),l=s.__importStar(t(266));class a extends c.ToolButtonView{render(){super.render(),this.el.classList.toggle(l.active,this.model.active)}_clicked(){const{active:t}=this.model;this.model.active=!t}}i.OnOffButtonView=a,a.__name__="OnOffButtonView"},
function _(e,t,s,o,i){o();const n=e(1),l=n.__importDefault(e(262)),r=e(54),c=e(55),a=e(19),h=e(263),d=e(38),u=e(10),_=n.__importStar(e(266)),m=_,p=n.__importStar(e(265)),v=p;class f extends r.DOMElementView{initialize(){super.initialize();const e=this.model.menu;if(null==e)this.el.addEventListener("click",(e=>{e.composedPath().includes(this.el)&&this._clicked()}));else{const{location:t}=this.parent.model,s="left"==t||"above"==t,o=this.parent.model.horizontal?"vertical":"horizontal";this._menu=new h.ContextMenu(s?(0,u.reversed)(e):e,{target:this.root.el,orientation:o,prevent_hide:e=>e.composedPath().includes(this.el)}),this._hammer=new l.default(this.el,{cssProps:{},touchAction:"auto",inputClass:l.default.TouchMouseInput}),this._hammer.on("tap",(e=>{const{_menu:t}=this;null!=t&&t.is_open?t.hide():e.srcEvent.composedPath().includes(this.el)&&this._clicked()})),this._hammer.on("press",(()=>this._pressed())),this.el.addEventListener("keydown",(e=>{e.keyCode==c.Keys.Enter&&this._clicked()}))}}connect_signals(){this.connect(this.model.change,(()=>this.render()))}remove(){var e,t;null===(e=this._hammer)||void 0===e||e.destroy(),null===(t=this._menu)||void 0===t||t.remove(),super.remove()}styles(){return[...super.styles(),_.default,p.default]}css_classes(){return super.css_classes().concat(m.tool_button)}render(){(0,c.empty)(this.el);const e=(0,c.div)({class:m.tool_icon});if(this.el.appendChild(e),null!=this.model.menu){const e=(()=>{switch(this.parent.model.location){case"above":return v.tool_icon_chevron_down;case"below":return v.tool_icon_chevron_up;case"left":return v.tool_icon_chevron_right;case"right":return v.tool_icon_chevron_left}})(),t=(0,c.div)({class:[m.tool_chevron,e]});this.el.appendChild(t)}const t=this.model.computed_icon;if(null!=t)if((0,d.startsWith)(t,"data:image")){const s=`url("${encodeURI(t)}")`;e.style.backgroundImage=s}else if((0,d.startsWith)(t,"--"))e.style.backgroundImage=`var(${t})`;else if((0,d.startsWith)(t,".")){const s=t.substring(1);e.classList.add(s)}else if(a.ToolIcon.valid(t)){const s=`bk-tool-icon-${t.replace(/_/g,"-")}`;e.classList.add(s)}this.el.title=this.model.tooltip,this.el.tabIndex=0}_pressed(){var e;const t=(()=>{switch(this.parent.model.location){case"right":return{left_of:this.el};case"left":return{right_of:this.el};case"above":return{below:this.el};case"below":return{above:this.el}}})();null===(e=this._menu)||void 0===e||e.toggle(t)}}s.ToolButtonView=f,f.__name__="ToolButtonView"},
function _(t,e,i,n,r){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,i,n,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=i.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,i){return setTimeout(T(t,i),e)}function p(t,e,i){return!!Array.isArray(t)&&(f(t,i[e],i),!0)}function f(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==r)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function v(e,i,n){var r="DEPRECATED METHOD: "+i+"\n"+n+" AT \n";return function(){var i=new Error("get-stack-trace"),n=i&&i.stack?i.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,n),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(t===r||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==r&&null!==n)for(var s in n)n.hasOwnProperty(s)&&(e[s]=n[s])}return e}:Object.assign;var d=v((function(t,e,i){for(var n=Object.keys(e),s=0;s<n.length;)(!i||i&&t[n[s]]===r)&&(t[n[s]]=e[n[s]]),s++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,i){var n,r=e.prototype;(n=t.prototype=Object.create(r)).constructor=t,n._super=r,i&&s(n,i)}function T(t,e){return function(){return t.apply(e,arguments)}}function y(t,e){return"function"==typeof t?t.apply(e&&e[0]||r,e):t}function E(t,e){return t===r?e:t}function I(t,e,i){f(S(e),(function(e){t.addEventListener(e,i,!1)}))}function A(t,e,i){f(S(e),(function(e){t.removeEventListener(e,i,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function P(t){return Array.prototype.slice.call(t,0)}function D(t,e,i){for(var n=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&n.push(t[s]),r[s]=o,s++}return i&&(n=e?n.sort((function(t,i){return t[e]>i[e]})):n.sort()),n}function x(t,e){for(var i,n,s=e[0].toUpperCase()+e.slice(1),a=0;a<o.length;){if((n=(i=o[a])?i+s:e)in t)return n;a++}return r}var w=1;function O(e){var i=e.ownerDocument||e;return i.defaultView||i.parentWindow||t}var R="ontouchstart"in t,M=x(t,"PointerEvent")!==r,z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N="touch",X="mouse",Y=24,F=["x","y"],W=["clientX","clientY"];function q(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){y(t.options.enable,[t])&&i.handler(e)},this.init()}function k(t,e,i){var n=i.pointers.length,s=i.changedPointers.length,o=1&e&&n-s==0,a=12&e&&n-s==0;i.isFirst=!!o,i.isFinal=!!a,o&&(t.session={}),i.eventType=e,function(t,e){var i=t.session,n=e.pointers,s=n.length;i.firstInput||(i.firstInput=H(e));s>1&&!i.firstMultiple?i.firstMultiple=H(e):1===s&&(i.firstMultiple=!1);var o=i.firstInput,a=i.firstMultiple,h=a?a.center:o.center,l=e.center=L(n);e.timeStamp=c(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=G(h,l),e.distance=j(h,l),function(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y});e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}(i,e),e.offsetDirection=V(e.deltaX,e.deltaY);var p=U(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=p.x,e.overallVelocityY=p.y,e.overallVelocity=u(p.x)>u(p.y)?p.x:p.y,e.scale=a?(f=a.pointers,v=n,j(v[0],v[1],W)/j(f[0],f[1],W)):1,e.rotation=a?function(t,e){return G(e[1],e[0],W)+G(t[1],t[0],W)}(a.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,s,o,a=t.lastInterval||e,h=e.timeStamp-a.timeStamp;if(8!=e.eventType&&(h>25||a.velocity===r)){var c=e.deltaX-a.deltaX,l=e.deltaY-a.deltaY,p=U(h,c,l);n=p.x,s=p.y,i=u(p.x)>u(p.y)?p.x:p.y,o=V(c,l),t.lastInterval=e}else i=a.velocity,n=a.velocityX,s=a.velocityY,o=a.direction;e.velocity=i,e.velocityX=n,e.velocityY=s,e.direction=o}(i,e);var f,v;var d=t.element;_(e.srcEvent.target,d)&&(d=e.srcEvent.target);e.target=d}(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function H(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:h(t.pointers[i].clientX),clientY:h(t.pointers[i].clientY)},i++;return{timeStamp:c(),pointers:e,center:L(e),deltaX:t.deltaX,deltaY:t.deltaY}}function L(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:h(i/e),y:h(n/e)}}function U(t,e,i){return{x:e/t||0,y:i/t||0}}function V(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function j(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function G(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}q.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var Z={mousedown:1,mousemove:2,mouseup:4},B="mousedown",$="mousemove mouseup";function J(){this.evEl=B,this.evWin=$,this.pressed=!1,q.apply(this,arguments)}g(J,q,{handler:function(t){var e=Z[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:X,srcEvent:t}))}});var K={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Q={2:N,3:"pen",4:X,5:"kinect"},tt="pointerdown",et="pointermove pointerup pointercancel";function it(){this.evEl=tt,this.evWin=et,q.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(tt="MSPointerDown",et="MSPointerMove MSPointerUp MSPointerCancel"),g(it,q,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=K[n],s=Q[t.pointerType]||t.pointerType,o=s==N,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))}});var nt={touchstart:1,touchmove:2,touchend:4,touchcancel:8},rt="touchstart",st="touchstart touchmove touchend touchcancel";function ot(){this.evTarget=rt,this.evWin=st,this.started=!1,q.apply(this,arguments)}function at(t,e){var i=P(t.touches),n=P(t.changedTouches);return 12&e&&(i=D(i.concat(n),"identifier",!0)),[i,n]}g(ot,q,{handler:function(t){var e=nt[t.type];if(1===e&&(this.started=!0),this.started){var i=at.call(this,t,e);12&e&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}}});var ht={touchstart:1,touchmove:2,touchend:4,touchcancel:8},ut="touchstart touchmove touchend touchcancel";function ct(){this.evTarget=ut,this.targetIds={},q.apply(this,arguments)}function lt(t,e){var i=P(t.touches),n=this.targetIds;if(3&e&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,s,o=P(t.changedTouches),a=[],h=this.target;if(s=i.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)n[s[r].identifier]=!0,r++;for(r=0;r<o.length;)n[o[r].identifier]&&a.push(o[r]),12&e&&delete n[o[r].identifier],r++;return a.length?[D(s.concat(a),"identifier",!0),a]:void 0}g(ct,q,{handler:function(t){var e=ht[t.type],i=lt.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}});function pt(){q.apply(this,arguments);var t=T(this.handler,this);this.touch=new ct(this.manager,t),this.mouse=new J(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function ft(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,vt.call(this,e)):12&t&&vt.call(this,e)}function vt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches;setTimeout((function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)}),2500)}}function dt(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],s=Math.abs(e-r.x),o=Math.abs(i-r.y);if(s<=25&&o<=25)return!0}return!1}g(pt,q,{handler:function(t,e,i){var n=i.pointerType==N,r=i.pointerType==X;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)ft.call(this,e,i);else if(r&&dt.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var mt=x(a.style,"touchAction"),gt=mt!==r,Tt="compute",yt="auto",Et="manipulation",It="none",At="pan-x",_t="pan-y",Ct=function(){if(!gt)return!1;var e={},i=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(n){e[n]=!i||t.CSS.supports("touch-action",n)})),e}();function St(t,e){this.manager=t,this.set(e)}St.prototype={set:function(t){t==Tt&&(t=this.compute()),gt&&this.manager.element.style&&Ct[t]&&(this.manager.element.style[mt]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){y(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,It))return It;var e=C(t,At),i=C(t,_t);if(e&&i)return It;if(e||i)return e?At:_t;if(C(t,Et))return Et;return yt}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,r=C(n,It)&&!Ct.none,s=C(n,_t)&&!Ct["pan-y"],o=C(n,At)&&!Ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&i||o&&i&Y?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var bt=32;function Pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function Dt(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function xt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function wt(t,e){var i=e.manager;return i?i.get(t):t}function Ot(){Pt.apply(this,arguments)}function Rt(){Ot.apply(this,arguments),this.pX=null,this.pY=null}function Mt(){Ot.apply(this,arguments)}function zt(){Pt.apply(this,arguments),this._timer=null,this._input=null}function Nt(){Ot.apply(this,arguments)}function Xt(){Ot.apply(this,arguments)}function Yt(){Pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function Ft(t,e){return(e=e||{}).recognizers=E(e.recognizers,Ft.defaults.preset),new Wt(t,e)}Pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=wt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=wt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=wt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=wt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<8&&n(e.options.event+Dt(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=8&&n(e.options.event+Dt(i))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=bt},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!y(this.options.enable,[this,e]))return this.reset(),void(this.state=bt);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(Ot,Pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=6&e,r=this.attrTest(t);return n&&(8&i||!r)?16|e:n||r?4&i?8|e:2&e?4|e:2:bt}}),g(Rt,Ot,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push(_t),t&Y&&e.push(At),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,i=s!=this.pX,n=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,i=o!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return Ot.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=xt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(Mt,Ot,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(zt,Pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[yt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return bt},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Nt,Ot,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(Xt,Ot,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return Rt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return 30&i?e=t.overallVelocity:6&i?e=t.overallVelocityX:i&Y&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=xt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(Yt,Pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[Et]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(n&&r&&i){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||j(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return bt},failTimeout:function(){return this._timer=l((function(){this.state=bt}),this.options.interval,this),bt},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),Ft.VERSION="2.0.7",Ft.defaults={domEvents:!1,touchAction:Tt,enable:!0,inputTarget:null,inputClass:null,preset:[[Nt,{enable:!1}],[Mt,{enable:!1},["rotate"]],[Xt,{direction:6}],[Rt,{direction:6},["swipe"]],[Yt],[Yt,{event:"doubletap",taps:2},["tap"]],[zt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Wt(t,e){var i;this.options=s({},Ft.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(M?it:z?ct:R?pt:J))(i,k),this.touchAction=new St(this,this.options.touchAction),qt(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function qt(t,e){var i,n=t.element;n.style&&(f(t.options.cssProps,(function(r,s){i=x(n.style,s),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""})),e||(t.oldCssProps={}))}Wt.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<n.length;)i=n[s],2===e.stopped||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&14&i.state&&(r=e.curRecognizer=i),s++}},get:function(t){if(t instanceof Pt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=b(e,t);-1!==i&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==r&&e!==r){var i=this.handlers;return f(S(t),(function(t){i[t]=i[t]||[],i[t].push(e)})),this}},off:function(t,e){if(t!==r){var i=this.handlers;return f(S(t),(function(t){e?i[t]&&i[t].splice(b(i[t],e),1):delete i[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var n=i.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<n.length;)n[r](e),r++}},destroy:function(){this.element&&qt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(Ft,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:bt,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:Y,DIRECTION_ALL:30,Manager:Wt,Input:q,TouchAction:St,TouchInput:ct,MouseInput:J,PointerEventInput:it,TouchMouseInput:pt,SingleTouchInput:ot,Recognizer:Pt,AttrRecognizer:Ot,Tap:Yt,Pan:Rt,Swipe:Xt,Pinch:Mt,Rotate:Nt,Press:zt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:T,prefixed:x}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=Ft,"function"==typeof define&&define.amd?define((function(){return Ft})):void 0!==e&&e.exports?e.exports=Ft:t.Hammer=Ft}(window,document)},
function _(t,e,i,n,o){n();const s=t(1),l=t(55),h=t(10),r=t(8),d=s.__importStar(t(264)),a=d,u=s.__importDefault(t(265)),_=s.__importDefault(t(57));class c{constructor(t,e){var i,n,o;this.items=t,this.el=(0,l.div)(),this._open=!1,this._item_click=t=>{var e;null===(e=t.handler)||void 0===e||e.call(t),this.hide()},this._on_mousedown=t=>{var e,i;t.composedPath().includes(this.el)||null!==(i=null===(e=this.prevent_hide)||void 0===e?void 0:e.call(this,t))&&void 0!==i&&i||this.hide()},this._on_keydown=t=>{t.keyCode==l.Keys.Esc&&this.hide()},this._on_blur=()=>{this.hide()},this.target=e.target,this.orientation=null!==(i=e.orientation)&&void 0!==i?i:"vertical",this.reversed=null!==(n=e.reversed)&&void 0!==n&&n,this.prevent_hide=e.prevent_hide,this.extra_styles=null!==(o=e.extra_styles)&&void 0!==o?o:[],this.shadow_el=this.el.attachShadow({mode:"open"}),this.class_list=new l.ClassList(this.el.classList)}get is_open(){return this._open}get can_open(){return 0!=this.items.length}remove(){this._unlisten(),(0,l.remove)(this.el)}_listen(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)}_unlisten(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)}_position(t){var e;const i=(()=>{if("left_of"in t){const{left:e,top:i}=t.left_of.getBoundingClientRect();return{right:e,top:i}}if("right_of"in t){const{top:e,right:i}=t.right_of.getBoundingClientRect();return{left:i,top:e}}if("below"in t){const{left:e,bottom:i}=t.below.getBoundingClientRect();return{left:e,top:i}}if("above"in t){const{left:e,top:i}=t.above.getBoundingClientRect();return{left:e,bottom:i}}return t})(),n=null!==(e=this.el.offsetParent)&&void 0!==e?e:document.body,o=(()=>{const t=n.getBoundingClientRect(),e=getComputedStyle(n);return{left:t.left-parseFloat(e.marginLeft),right:t.right+parseFloat(e.marginRight),top:t.top-parseFloat(e.marginTop),bottom:t.bottom+parseFloat(e.marginBottom)}})(),{style:s}=this.el;s.left=null!=i.left?i.left-o.left+"px":"auto",s.top=null!=i.top?i.top-o.top+"px":"auto",s.right=null!=i.right?o.right-i.right+"px":"auto",s.bottom=null!=i.bottom?o.bottom-i.bottom+"px":"auto"}styles(){return[_.default,d.default,u.default,...this.extra_styles]}empty(){(0,l.empty)(this.shadow_el),this.class_list.clear()}render(){var t,e;this.empty();for(const t of this.styles()){const e=(0,r.isString)(t)?new l.StyleSheet(t):t;this.shadow_el.appendChild(e.el)}this.class_list.add(a[this.orientation]);const i=this.reversed?(0,h.reversed)(this.items):this.items;for(const n of i){let i;if(null==n)i=(0,l.div)({class:a.divider});else{if(null!=n.if&&!n.if())continue;if(null!=n.content)i=n.content;else{const o=null!=n.icon?(0,l.div)({class:[a.menu_icon,n.icon]}):null,s=[null!==(e=null===(t=n.active)||void 0===t?void 0:t.call(n))&&void 0!==e&&e?a.active:null,n.class];i=(0,l.div)({class:s,title:n.tooltip,tabIndex:0},o,n.label,n.content),i.addEventListener("click",(()=>{this._item_click(n)})),i.addEventListener("keydown",(t=>{t.keyCode==l.Keys.Enter&&this._item_click(n)}))}}this.shadow_el.appendChild(i)}}show(t){var e;if(0!=this.items.length&&!this._open){if(this.render(),0==this.shadow_el.children.length)return;(null!==(e=this.target.shadowRoot)&&void 0!==e?e:this.target).appendChild(this.el),this._position(null!=t?t:{left:0,top:0}),this._listen(),this._open=!0}}hide(){this._open&&(this._open=!1,this._unlisten(),(0,l.remove)(this.el))}toggle(t){this._open?this.hide():this.show(t)}}i.ContextMenu=c,c.__name__="ContextMenu"},
function _(r,o,e,i,t){i(),e.menu_icon="bk-menu-icon",e.horizontal="bk-horizontal",e.vertical="bk-vertical",e.divider="bk-divider",e.active="bk-active",e.default=".bk-menu-icon{width:28px;height:28px;mask-size:60% 60%;mask-position:center center;mask-repeat:no-repeat;-webkit-mask-size:60% 60%;-webkit-mask-position:center center;-webkit-mask-repeat:no-repeat;background-size:60%;background-color:transparent;background-repeat:no-repeat;background-position:center center;}:host{position:absolute;display:inline-flex;flex-wrap:nowrap;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;width:auto;height:auto;z-index:100;cursor:pointer;font-size:var(--font-size);background-color:#fff;border:1px solid #ccc;border-radius:var(--border-radius);box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}:host(.bk-horizontal){flex-direction:row;}:host(.bk-vertical){flex-direction:column;}.bk-divider{cursor:default;overflow:hidden;background-color:#e5e5e5;}:host(.bk-horizontal) > .bk-divider{width:1px;margin:5px 0;}:host(.bk-vertical) > .bk-divider{height:1px;margin:0 5px;}:host > :not(.bk-divider){border:1px solid transparent;--active-tool-highlight:#26aae1;}:host > :not(.bk-divider).bk-active{border-color:var(--active-tool-highlight);}:host > :not(.bk-divider):hover{background-color:#f9f9f9;}:host > :not(.bk-divider):focus,:host > :not(.bk-divider):focus-visible{outline:1px dotted var(--active-tool-highlight);outline-offset:-1px;}:host > :not(.bk-divider)::-moz-focus-inner{border:0;}:host(.bk-horizontal) > :not(.bk-divider):first-child{border-top-left-radius:var(--border-radius);border-bottom-left-radius:var(--border-radius);}:host(.bk-horizontal) > :not(.bk-divider):last-child{border-top-right-radius:var(--border-radius);border-bottom-right-radius:var(--border-radius);}:host(.bk-vertical) > :not(.bk-divider):first-child{border-top-left-radius:var(--border-radius);border-top-right-radius:var(--border-radius);}:host(.bk-vertical) > :not(.bk-divider):last-child{border-bottom-left-radius:var(--border-radius);border-bottom-right-radius:var(--border-radius);}"},
function _(o,A,e,t,n){t(),e.tool_icon_copy="bk-tool-icon-copy",e.tool_icon_replace_mode="bk-tool-icon-replace-mode",e.tool_icon_append_mode="bk-tool-icon-append-mode",e.tool_icon_intersect_mode="bk-tool-icon-intersect-mode",e.tool_icon_subtract_mode="bk-tool-icon-subtract-mode",e.tool_icon_clear_selection="bk-tool-icon-clear-selection",e.tool_icon_box_select="bk-tool-icon-box-select",e.tool_icon_x_box_select="bk-tool-icon-x-box-select",e.tool_icon_y_box_select="bk-tool-icon-y-box-select",e.tool_icon_box_zoom="bk-tool-icon-box-zoom",e.tool_icon_x_box_zoom="bk-tool-icon-x-box-zoom",e.tool_icon_y_box_zoom="bk-tool-icon-y-box-zoom",e.tool_icon_auto_box_zoom="bk-tool-icon-auto-box-zoom",e.tool_icon_zoom_in="bk-tool-icon-zoom-in",e.tool_icon_zoom_out="bk-tool-icon-zoom-out",e.tool_icon_help="bk-tool-icon-help",e.tool_icon_hover="bk-tool-icon-hover",e.tool_icon_crosshair="bk-tool-icon-crosshair",e.tool_icon_lasso_select="bk-tool-icon-lasso-select",e.tool_icon_pan="bk-tool-icon-pan",e.tool_icon_x_pan="bk-tool-icon-x-pan",e.tool_icon_y_pan="bk-tool-icon-y-pan",e.tool_icon_range="bk-tool-icon-range",e.tool_icon_polygon_select="bk-tool-icon-polygon-select",e.tool_icon_redo="bk-tool-icon-redo",e.tool_icon_reset="bk-tool-icon-reset",e.tool_icon_save="bk-tool-icon-save",e.tool_icon_tap_select="bk-tool-icon-tap-select",e.tool_icon_undo="bk-tool-icon-undo",e.tool_icon_wheel_pan="bk-tool-icon-wheel-pan",e.tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",e.tool_icon_box_edit="bk-tool-icon-box-edit",e.tool_icon_freehand_draw="bk-tool-icon-freehand-draw",e.tool_icon_poly_draw="bk-tool-icon-poly-draw",e.tool_icon_point_draw="bk-tool-icon-point-draw",e.tool_icon_poly_edit="bk-tool-icon-poly-edit",e.tool_icon_line_edit="bk-tool-icon-line-edit",e.tool_icon_settings="bk-tool-icon-settings",e.tool_icon_unknown="bk-tool-icon-unknown",e.tool_icon_fullscreen="bk-tool-icon-fullscreen",e.tool_icon_chevron_up="bk-tool-icon-chevron-up",e.tool_icon_chevron_down="bk-tool-icon-chevron-down",e.tool_icon_chevron_left="bk-tool-icon-chevron-left",e.tool_icon_chevron_right="bk-tool-icon-chevron-right",e.tool_icon_caret_up="bk-tool-icon-caret-up",e.tool_icon_caret_down="bk-tool-icon-caret-down",e.tool_icon_caret_left="bk-tool-icon-caret-left",e.tool_icon_caret_right="bk-tool-icon-caret-right",e.tool_icon_see_on="bk-tool-icon-see-on",e.tool_icon_see_off="bk-tool-icon-see-off",e.default=':host{--bokeh-icon-color:#a1a6a9;}.bk-tool-icon-copy{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-copy);-webkit-mask-image:var(--bokeh-icon-copy);}.bk-tool-icon-replace-mode{background-image:var(--bokeh-icon-replace-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC"));}.bk-tool-icon-append-mode{background-image:var(--bokeh-icon-append-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII="));}.bk-tool-icon-intersect-mode{background-image:var(--bokeh-icon-intersect-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC"));}.bk-tool-icon-subtract-mode{background-image:var(--bokeh-icon-subtract-mode, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg=="));}.bk-tool-icon-clear-selection{background-image:var(--bokeh-icon-clear-selection, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC"));}.bk-tool-icon-box-select{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-box-select);-webkit-mask-image:var(--bokeh-icon-box-select);}.bk-tool-icon-x-box-select{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-x-box-select);-webkit-mask-image:var(--bokeh-icon-x-box-select);}.bk-tool-icon-y-box-select{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-y-box-select);-webkit-mask-image:var(--bokeh-icon-y-box-select);}.bk-tool-icon-box-zoom{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-box-zoom);-webkit-mask-image:var(--bokeh-icon-box-zoom);}.bk-tool-icon-x-box-zoom{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-x-box-zoom);-webkit-mask-image:var(--bokeh-icon-x-box-zoom);}.bk-tool-icon-y-box-zoom{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-y-box-zoom);-webkit-mask-image:var(--bokeh-icon-y-box-zoom);}.bk-tool-icon-auto-box-zoom{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-auto-box-zoom);-webkit-mask-image:var(--bokeh-icon-auto-box-zoom);}.bk-tool-icon-zoom-in{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-zoom-in);-webkit-mask-image:var(--bokeh-icon-zoom-in);}.bk-tool-icon-zoom-out{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-zoom-out);-webkit-mask-image:var(--bokeh-icon-zoom-out);}.bk-tool-icon-help{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-help);-webkit-mask-image:var(--bokeh-icon-help);}.bk-tool-icon-hover{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-hover);-webkit-mask-image:var(--bokeh-icon-hover);}.bk-tool-icon-crosshair{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-crosshair);-webkit-mask-image:var(--bokeh-icon-crosshair);}.bk-tool-icon-lasso-select{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-lasso-select);-webkit-mask-image:var(--bokeh-icon-lasso-select);}.bk-tool-icon-pan{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-pan);-webkit-mask-image:var(--bokeh-icon-pan);}.bk-tool-icon-x-pan{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-x-pan);-webkit-mask-image:var(--bokeh-icon-x-pan);}.bk-tool-icon-y-pan{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-y-pan);-webkit-mask-image:var(--bokeh-icon-y-pan);}.bk-tool-icon-range{background-image:var(--bokeh-icon-range, url("data:image/png;base64,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"));}.bk-tool-icon-polygon-select{background-image:var(--bokeh-icon-polygon-select, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII="));}.bk-tool-icon-redo{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-redo);-webkit-mask-image:var(--bokeh-icon-redo);}.bk-tool-icon-reset{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-reset);-webkit-mask-image:var(--bokeh-icon-reset);}.bk-tool-icon-save{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-save);-webkit-mask-image:var(--bokeh-icon-save);}.bk-tool-icon-tap-select{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-tap-select);-webkit-mask-image:var(--bokeh-icon-tap-select);}.bk-tool-icon-undo{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-undo);-webkit-mask-image:var(--bokeh-icon-undo);}.bk-tool-icon-wheel-pan{background-image:var(--bokeh-icon-wheel-pan, url("data:image/png;base64,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"));}.bk-tool-icon-wheel-zoom{background-image:var(--bokeh-icon-wheel-zoom, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII="));}.bk-tool-icon-box-edit{background-image:var(--bokeh-icon-box-edit, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII="));}.bk-tool-icon-freehand-draw{background-image:var(--bokeh-icon-freehand-draw, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg=="));}.bk-tool-icon-poly-draw{background-image:var(--bokeh-icon-poly-draw, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg=="));}.bk-tool-icon-point-draw{background-image:var(--bokeh-icon-point-draw, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg=="));}.bk-tool-icon-poly-edit{background-image:var(--bokeh-icon-poly-edit, url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII="));}.bk-tool-icon-line-edit{background-image:var(--bokeh-icon-line-edit, url("data:image/png;base64,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"));}.bk-tool-icon-settings{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-settings);-webkit-mask-image:var(--bokeh-icon-settings);}.bk-tool-icon-unknown{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-unknown);-webkit-mask-image:var(--bokeh-icon-unknown);}.bk-tool-icon-fullscreen{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-fullscreen);-webkit-mask-image:var(--bokeh-icon-fullscreen);}.bk-tool-icon-chevron-up{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-up);-webkit-mask-image:var(--bokeh-icon-chevron-up);}.bk-tool-icon-chevron-down{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-down);-webkit-mask-image:var(--bokeh-icon-chevron-down);}.bk-tool-icon-chevron-left{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-left);-webkit-mask-image:var(--bokeh-icon-chevron-left);}.bk-tool-icon-chevron-right{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-chevron-right);-webkit-mask-image:var(--bokeh-icon-chevron-right);}.bk-tool-icon-caret-up{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-caret-up);-webkit-mask-image:var(--bokeh-icon-caret-up);}.bk-tool-icon-caret-down{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-caret-down);-webkit-mask-image:var(--bokeh-icon-caret-down);}.bk-tool-icon-caret-left{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-caret-left);-webkit-mask-image:var(--bokeh-icon-caret-left);}.bk-tool-icon-caret-right{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-caret-right);-webkit-mask-image:var(--bokeh-icon-caret-right);}.bk-tool-icon-see-on{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-see-on);-webkit-mask-image:var(--bokeh-icon-see-on);}.bk-tool-icon-see-off{background-color:var(--bokeh-icon-color);mask-image:var(--bokeh-icon-see-off);-webkit-mask-image:var(--bokeh-icon-see-off);}:host{--bokeh-icon-question-mark:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M8%208a3.5%203%200%200%201%203.5%20-3h1a3.5%203%200%200%201%203.5%203a3%203%200%200%201%20-2%203a3%204%200%200%200%20-2%204%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%2219%22%20x2%3D%2212%22%20y2%3D%2219.01%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-help:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%229%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%2217%22%20x2%3D%2212%22%20y2%3D%2217.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2013.5a1.5%201.5%200%200%201%201%20-1.5a2.6%202.6%200%201%200%20-3%20-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%206l-12%2012%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%206l12%2012%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-settings:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M10.325%204.317c.426%20-1.756%202.924%20-1.756%203.35%200a1.724%201.724%200%200%200%202.573%201.066c1.543%20-.94%203.31%20.826%202.37%202.37a1.724%201.724%200%200%200%201.065%202.572c1.756%20.426%201.756%202.924%200%203.35a1.724%201.724%200%200%200%20-1.066%202.573c.94%201.543%20-.826%203.31%20-2.37%202.37a1.724%201.724%200%200%200%20-2.572%201.065c-.426%201.756%20-2.924%201.756%20-3.35%200a1.724%201.724%200%200%200%20-2.573%20-1.066c-1.543%20.94%20-3.31%20-.826%20-2.37%20-2.37a1.724%201.724%200%200%200%20-1.065%20-2.572c-1.756%20-.426%20-1.756%20-2.924%200%20-3.35a1.724%201.724%200%200%200%201.066%20-2.573c-.94%20-1.543%20.826%20-3.31%202.37%20-2.37c1%20.608%202.296%20.07%202.572%20-1.065z%22%3E%3C%2Fpath%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%223%22%3E%3C%2Fcircle%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-unknown:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M14%203v4a1%201%200%200%200%201%201h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M17%2021h-10a2%202%200%200%201%20-2%20-2v-14a2%202%200%200%201%202%20-2h7l5%205v11a2%202%200%200%201%20-2%202z%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2017v.01%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2014a1.5%201.5%200%201%200%20-1.14%20-2.474%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-fullscreen:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%223%22%20y%3D%2216%22%20width%3D%225%22%20height%3D%225%22%20rx%3D%221%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012v-6a2%202%200%200%201%202%20-2h12a2%202%200%200%201%202%202v12a2%202%200%200%201%20-2%202h-6%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%208h4v4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%208l-5%205%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-save:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%2017v2a2%202%200%200%200%202%202h12a2%202%200%200%200%202%20-2v-2%22%20%2F%3E%0A%20%20%3Cpolyline%20points%3D%227%2011%2012%2016%2017%2011%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%224%22%20x2%3D%2212%22%20y2%3D%2216%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-copy:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Crect%20x%3D%228%22%20y%3D%228%22%20width%3D%2212%22%20height%3D%2212%22%20rx%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M16%208v-2a2%202%200%200%200%20-2%20-2h-8a2%202%200%200%200%20-2%202v8a2%202%200%200%200%202%202h2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-tap-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cline%20x1%3D%223%22%20y1%3D%2212%22%20x2%3D%226%22%20y2%3D%2212%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2212%22%20y1%3D%223%22%20x2%3D%2212%22%20y2%3D%226%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227.8%22%20y1%3D%227.8%22%20x2%3D%225.6%22%20y2%3D%225.6%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2216.2%22%20y1%3D%227.8%22%20x2%3D%2218.4%22%20y2%3D%225.6%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227.8%22%20y1%3D%2216.2%22%20x2%3D%225.6%22%20y2%3D%2218.4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012l9%203l-4%202l-2%204l-3%20-9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-lasso-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4.028%2013.252c-.657%20-.972%20-1.028%20-2.078%20-1.028%20-3.252c0%20-3.866%204.03%20-7%209%20-7s9%203.134%209%207s-4.03%207%20-9%207c-1.913%200%20-3.686%20-.464%20-5.144%20-1.255%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%225%22%20cy%3D%2215%22%20r%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M5%2017c0%201.42%20.316%202.805%201%204%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%209l3%203l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%209l-3%203l3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l3%203l3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%206l-3%20-3l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012v9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%203v9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%209l3%203l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%209l-3%203l3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012h9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2012h9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-pan:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2018l3%203l3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%206l-3%20-3l-3%203%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2012v9%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%203v9%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17%2013l-4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-box-select:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l2%202l2%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%2015v2.5%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%206v-1a1%201%200%200%201%201%20-1h1m5%200h2m5%200h1a1%201%200%200%201%201%201v1m0%205v2m0%205v1a1%201%200%200%201%20-1%201h-1m-5%200h-2m-5%200h-1a1%201%200%200%201%20-1%20-1v-1m0%20-5v-2%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-x-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M17%2013l-4%204%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l4%204%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-y-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M13%2013l2%202l2%20-2%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%2015v2.5%22%20%2F%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-auto-box-zoom:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2215%22%20cy%3D%2215%22%20r%3D%225%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2022l-3%20-3%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M6%2018h-1a2%202%200%200%201%20-2%20-2v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%2011v-1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M3%206v-1a2%202%200%200%201%202%20-2h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10%203h1%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M15%203h1a2%202%200%200%201%202%202v1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-zoom-in:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2210%22%20cy%3D%2210%22%20r%3D%227%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227%22%20y1%3D%2210%22%20x2%3D%2213%22%20y2%3D%2210%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2210%22%20y1%3D%227%22%20x2%3D%2210%22%20y2%3D%2213%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2221%22%20y1%3D%2221%22%20x2%3D%2215%22%20y2%3D%2215%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-zoom-out:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2210%22%20cy%3D%2210%22%20r%3D%227%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%227%22%20y1%3D%2210%22%20x2%3D%2213%22%20y2%3D%2210%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%2221%22%20y1%3D%2221%22%20x2%3D%2215%22%20y2%3D%2215%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-undo:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M9%2013l-4%20-4l4%20-4m-4%204h11a4%204%200%200%201%200%208h-1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-redo:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M15%2013l4%20-4l-4%20-4m4%204h-11a4%204%200%200%200%200%208h1%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-reset:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M20%2011a8.1%208.1%200%200%200%20-15.5%20-2m-.5%20-4v4h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2013a8.1%208.1%200%200%200%2015.5%202m.5%204v-4h-4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-hover:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M12%2020l-3%20-3h-2a3%203%200%200%201%20-3%20-3v-6a3%203%200%200%201%203%20-3h10a3%203%200%200%201%203%203v6a3%203%200%200%201%20-3%203h-2l-3%203%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%228%22%20y1%3D%229%22%20x2%3D%2216%22%20y2%3D%229%22%20%2F%3E%0A%20%20%3Cline%20x1%3D%228%22%20y1%3D%2213%22%20x2%3D%2214%22%20y2%3D%2213%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-crosshair:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%229%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M20%2012h-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M4%2012h4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%2020v-4%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M12%204v4%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%226%2015%2012%209%2018%2015%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%226%209%2012%2015%2018%209%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%2215%206%209%2012%2015%2018%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-chevron-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpolyline%20points%3D%229%206%2015%2012%209%2018%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-up:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-down:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(180%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-left:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(270%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-caret-right:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22currentColor%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cpath%20d%3D%22M18%2015l-6%20-6l-6%206h12%22%20transform%3D%22rotate(90%2012%2012)%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-see-on:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Ccircle%20cx%3D%2212%22%20cy%3D%2212%22%20r%3D%222%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M22%2012c-2.667%204.667%20-6%207%20-10%207s-7.333%20-2.333%20-10%20-7c2.667%20-4.667%206%20-7%2010%20-7s7.333%202.333%2010%207%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");--bokeh-icon-see-off:url("data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2224%22%20height%3D%2224%22%20viewBox%3D%220%200%2024%2024%22%20stroke-width%3D%222%22%20stroke%3D%22currentColor%22%20fill%3D%22none%22%20stroke-linecap%3D%22round%22%20stroke-linejoin%3D%22round%22%3E%0A%20%20%3Cline%20x1%3D%223%22%20y1%3D%223%22%20x2%3D%2221%22%20y2%3D%2221%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M10.584%2010.587a2%202%200%200%200%202.828%202.83%22%20%2F%3E%0A%20%20%3Cpath%20d%3D%22M9.363%205.365a9.466%209.466%200%200%201%202.637%20-.365c4%200%207.333%202.333%2010%207c-.778%201.361%20-1.612%202.524%20-2.503%203.488m-2.14%201.861c-1.631%201.1%20-3.415%201.651%20-5.357%201.651c-4%200%20-7.333%20-2.333%20-10%20-7c1.369%20-2.395%202.913%20-4.175%204.632%20-5.341%22%20%2F%3E%0A%3C%2Fsvg%3E%0A");}'},
function _(o,t,e,b,r){b(),e.tool_button="bk-tool-button",e.tool_icon="bk-tool-icon",e.tool_chevron="bk-tool-chevron",e.above="bk-above",e.below="bk-below",e.left="bk-left",e.right="bk-right",e.tool_overflow="bk-tool-overflow",e.active="bk-active",e.divider="bk-divider",e.horizontal="bk-horizontal",e.vertical="bk-vertical",e.default=':host{--button-width:30px;--button-height:30px;--button-color:lightgray;--button-border:2px;--active-tool-highlight:#26aae1;--active-tool-border:var(--button-border) solid transparent;}.bk-tool-button{position:relative;width:var(--button-width);height:var(--button-height);cursor:pointer;touch-action:auto;user-select:none;-webkit-user-drag:none;-webkit-tap-highlight-color:rgba(0, 0, 0, 0);}.bk-tool-icon{position:relative;top:calc(var(--button-border)/2);width:calc(var(--button-width) - var(--button-border));height:calc(var(--button-height) - var(--button-border));mask-size:60% 60%;mask-position:center center;mask-repeat:no-repeat;-webkit-mask-size:60% 60%;-webkit-mask-position:center center;-webkit-mask-repeat:no-repeat;background-size:60% 60%;background-origin:border-box;background-position:center center;background-repeat:no-repeat;}.bk-tool-chevron{position:absolute;visibility:hidden;width:8px;height:8px;mask-size:100% 100%;mask-position:center center;mask-repeat:no-repeat;-webkit-mask-size:100% 100%;-webkit-mask-position:center center;-webkit-mask-repeat:no-repeat;}.bk-tool-button:hover .bk-tool-chevron{visibility:visible;}:host(.bk-above) .bk-tool-chevron{right:0;bottom:0;}:host(.bk-below) .bk-tool-chevron{right:0;top:0;}:host(.bk-left) .bk-tool-chevron{right:0;bottom:0;}:host(.bk-right) .bk-tool-chevron{left:0;bottom:0;}.bk-tool-button:hover,.bk-tool-overflow:hover{background-color:rgba(192, 192, 192, 0.15);}.bk-tool-button:focus,.bk-tool-overflow:focus,.bk-tool-button:focus-visible,.bk-tool-overflow:focus-visible{outline:1px dotted var(--active-tool-highlight);outline-offset:-1px;}.bk-tool-button::-moz-focus-inner,.bk-tool-overflow::-moz-focus-inner{border:0;}:host(.bk-above) .bk-tool-button{border-bottom:var(--active-tool-border);}:host(.bk-above) .bk-tool-button.bk-active{border-bottom-color:var(--active-tool-highlight);}:host(.bk-below) .bk-tool-button{border-top:var(--active-tool-border);}:host(.bk-below) .bk-tool-button.bk-active{border-top-color:var(--active-tool-highlight);}:host(.bk-right) .bk-tool-button{border-left:var(--active-tool-border);}:host(.bk-right) .bk-tool-button.bk-active{border-left-color:var(--active-tool-highlight);}:host(.bk-left) .bk-tool-button{border-right:var(--active-tool-border);}:host(.bk-left) .bk-tool-button.bk-active{border-right-color:var(--active-tool-highlight);}.bk-divider{content:" ";display:inline-block;background-color:var(--button-color);}:host(.bk-above) .bk-divider,:host(.bk-below) .bk-divider{height:10px;width:1px;}:host(.bk-left) .bk-divider,:host(.bk-right) .bk-divider{height:1px;width:10px;}.bk-tool-overflow{color:gray;display:flex;align-items:center;}:host(.bk-above) .bk-tool-overflow,:host(.bk-below) .bk-tool-overflow,:host(.bk-horizontal) .bk-tool-overflow{width:calc(var(--button-width)/2);height:var(--button-height);flex-direction:row;}:host(.bk-left) .bk-tool-overflow,:host(.bk-right) .bk-tool-overflow,:host(.bk-vertical) .bk-tool-overflow{width:var(--button-width);height:calc(var(--button-height)/2);flex-direction:column;}'},
function _(e,t,o,s,n){s();const _=e(257),r=e(260);class u extends _.ToolView{get plot_view(){return this.parent}}o.GestureToolView=u,u.__name__="GestureToolView";class i extends _.Tool{constructor(e){super(e),this.button_view=r.OnOffButtonView}}o.GestureTool=i,i.__name__="GestureTool"},
function _(o,t,n,i,e){i();const s=o(257),c=o(261),l=o(15);class _ extends c.ToolButtonView{_clicked(){this.model.do.emit(void 0)}}n.ActionToolButtonView=_,_.__name__="ActionToolButtonView";class d extends s.ToolView{connect_signals(){super.connect_signals(),this.connect(this.model.do,(o=>this.doit(o)))}}n.ActionToolView=d,d.__name__="ActionToolView";class a extends s.Tool{constructor(o){super(o),this.button_view=_,this.do=new l.Signal(this,"do")}}n.ActionTool=a,a.__name__="ActionTool"},
function _(o,e,t,l,i){var s;l();const n=o(268),r=o(265);class c extends n.ActionToolView{doit(){window.open(this.model.redirect)}}t.HelpToolView=c,c.__name__="HelpToolView";class _ extends n.ActionTool{constructor(o){super(o),this.tool_name="Help",this.tool_icon=r.tool_icon_help}}t.HelpTool=_,s=_,_.__name__="HelpTool",s.prototype.default_view=c,s.define((({String:o})=>({redirect:[o,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]}))),s.override({description:"Click the question mark to learn more about Bokeh plot tools."}),s.register_alias("help",(()=>new _))},
function _(e,o,t,i,n){i(),t.inner="bk-inner",t.hidden="bk-hidden",t.logo="bk-logo",t.above="bk-above",t.below="bk-below",t.left="bk-left",t.right="bk-right",t.default=":host{display:flex;flex-wrap:nowrap;align-items:center;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}:host(.bk-inner){background-color:white;opacity:0.8;}:host(.bk-hidden){visibility:hidden;opacity:0;transition:visibility 0.3s linear, opacity 0.3s linear;}.bk-logo{flex-shrink:0;}:host(.bk-above),:host(.bk-below){flex-direction:row;justify-content:flex-end;}:host(.bk-above) .bk-logo,:host(.bk-below) .bk-logo{order:1;margin-left:5px;margin-right:0px;}:host(.bk-left),:host(.bk-right){flex-direction:column;justify-content:flex-start;}:host(.bk-left) .bk-logo,:host(.bk-right) .bk-logo{order:0;margin-bottom:5px;margin-top:0px;}"},
function _(l,g,A,o,a){o(),A.logo="bk-logo",A.grey="bk-grey",A.logo_small="bk-logo-small",A.default=".bk-logo{margin:5px;position:relative;display:block;background-repeat:no-repeat;}.bk-logo.bk-grey{filter:url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\");-webkit-filter:grayscale(100%);}.bk-logo-small{width:20px;height:20px;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);}"},
function _(e,t,s,i,r){var a;i();const l=e(230),_=e(138),h=e(23),n=e(58),o=e(77);class d extends l.UpperLowerView{async lazy_initialize(){await super.lazy_initialize();const{lower_head:e,upper_head:t}=this.model;null!=e&&(this.lower_head=await(0,n.build_view)(e,{parent:this})),null!=t&&(this.upper_head=await(0,n.build_view)(t,{parent:this}))}set_data(e){var t,s;super.set_data(e);const i=h.Indices.all_set(this._lower.length);null===(t=this.lower_head)||void 0===t||t.set_data(e,i),null===(s=this.upper_head)||void 0===s||s.set_data(e,i)}paint(e){if(this.visuals.line.doit)for(let t=0,s=this._lower_sx.length;t<s;t++)e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),this.visuals.line.apply(e,t);const t="height"==this.model.dimension?0:Math.PI/2;if(null!=this.lower_head)for(let s=0,i=this._lower_sx.length;s<i;s++)e.save(),e.translate(this._lower_sx[s],this._lower_sy[s]),e.rotate(t+Math.PI),this.lower_head.render(e,s),e.restore();if(null!=this.upper_head)for(let s=0,i=this._upper_sx.length;s<i;s++)e.save(),e.translate(this._upper_sx[s],this._upper_sy[s]),e.rotate(t),this.upper_head.render(e,s),e.restore()}}s.WhiskerView=d,d.__name__="WhiskerView";class p extends l.UpperLower{constructor(e){super(e)}}s.Whisker=p,a=p,p.__name__="Whisker",a.prototype.default_view=d,a.mixins(o.LineVector),a.define((({Ref:e,Nullable:t})=>({lower_head:[t(e(_.ArrowHead)),()=>new _.TeeHead({size:10})],upper_head:[t(e(_.ArrowHead)),()=>new _.TeeHead({size:10})]}))),a.override({level:"underlay"})},
function _(L,e,T,l,H){l(),H("HTMLLabel",L(274).HTMLLabel),H("HTMLLabelSet",L(276).HTMLLabelSet),H("HTMLTitle",L(277).HTMLTitle)},
function _(e,t,s,i,n){i();const o=e(1);var a;const l=e(275),r=e(11),_=e(19),d=e(150),u=e(143),c=o.__importStar(e(77));class h extends l.TextAnnotationView{update_layout(){const{panel:e}=this;this.layout=null!=e?new u.SideLayout(e,(()=>this.get_size()),!1):void 0}_get_size(){const{text:e}=this.model,t=new d.TextBox({text:e}),{angle:s,angle_units:i}=this.model;t.angle=(0,r.resolve_angle)(s,i),t.visuals=this.visuals.text.values();const{width:n,height:o}=t.size();return{width:n,height:o}}_render(){const{angle:e,angle_units:t}=this.model,s=(0,r.resolve_angle)(e,t),i=null!=this.layout?this.layout:this.plot_view.frame,n=this.coordinates.x_scale,o=this.coordinates.y_scale;let a=(()=>{switch(this.model.x_units){case"canvas":return this.model.x;case"screen":return i.bbox.xview.compute(this.model.x);case"data":return n.compute(this.model.x)}})(),l=(()=>{switch(this.model.y_units){case"canvas":return this.model.y;case"screen":return i.bbox.yview.compute(this.model.y);case"data":return o.compute(this.model.y)}})();a+=this.model.x_offset,l-=this.model.y_offset,this._paint(this.layer.ctx,this.model.text,a,l,s)}}s.HTMLLabelView=h,h.__name__="HTMLLabelView";class x extends l.TextAnnotation{constructor(e){super(e)}}s.HTMLLabel=x,a=x,x.__name__="HTMLLabel",a.prototype.default_view=h,a.mixins([c.Text,["border_",c.Line],["background_",c.Fill]]),a.define((({Number:e,String:t,Angle:s})=>({x:[e],x_units:[_.CoordinateUnits,"data"],y:[e],y_units:[_.CoordinateUnits,"data"],text:[t,""],angle:[s,0],angle_units:[_.AngleUnits,"rad"],x_offset:[e,0],y_offset:[e,0]}))),a.override({background_fill_color:null,border_line_color:null})},
function _(t,e,s,i,l){i();const n=t(72),o=t(55),a=t(143);class r extends n.AnnotationView{update_layout(){const{panel:t}=this;this.layout=null!=t?new a.SideLayout(t,(()=>this.get_size()),!0):void 0}initialize(){super.initialize(),this.el=(0,o.div)(),this.plot_view.canvas_view.add_overlay(this.el)}remove(){(0,o.remove)(this.el),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.render()))}render(){this.model.visible||(0,o.undisplay)(this.el),super.render()}_paint(t,e,s,i,l){const{el:n}=this;(0,o.undisplay)(n),n.textContent=e,this.visuals.text.set_value(t),n.style.position="absolute",n.style.left=`${s}px`,n.style.top=`${i}px`,n.style.color=t.fillStyle,n.style.webkitTextStroke=`1px ${t.strokeStyle}`,n.style.font=t.font,n.style.lineHeight="normal",n.style.whiteSpace="pre";const[a,r]=(()=>{switch(this.visuals.text.text_align.get_value()){case"left":return["left","0%"];case"center":return["center","-50%"];case"right":return["right","-100%"]}})(),[u,d]=(()=>{switch(this.visuals.text.text_baseline.get_value()){case"top":return["top","0%"];case"middle":default:return["center","-50%"];case"bottom":return["bottom","-100%"]}})();let c=`translate(${r}, ${d})`;l&&(c+=`rotate(${l}rad)`),n.style.transformOrigin=`${a} ${u}`,n.style.transform=c,this.layout,this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),n.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),n.style.borderStyle=t.lineDash.length<2?"solid":"dashed",n.style.borderWidth=`${t.lineWidth}px`,n.style.borderColor=t.strokeStyle),(0,o.display)(n)}}s.TextAnnotationView=r,r.__name__="TextAnnotationView";class u extends n.Annotation{constructor(t){super(t)}}s.TextAnnotation=u,u.__name__="TextAnnotation"},
function _(t,e,s,i,r){i();const o=t(1);var l;const a=t(97),n=o.__importStar(t(77)),c=t(19),h=t(55),_=o.__importStar(t(17)),u=t(23),d=t(12);class y extends a.DataAnnotationView{constructor(){super(...arguments),this.els=[]}set_data(t){super.set_data(t),this.els.forEach((t=>(0,h.remove)(t))),this.els=[];for(const t of this.text){const t=(0,h.div)({style:{display:"none"}});this.plot_view.canvas_view.add_overlay(t),this.els.push(t)}}remove(){this.els.forEach((t=>(0,h.remove)(t))),this.els=[],super.remove()}_rerender(){this.render()}map_data(){const{x_scale:t,y_scale:e}=this.coordinates,s=null!=this.layout?this.layout:this.plot_view.frame;this.sx=(()=>{switch(this.model.x_units){case"canvas":return new u.ScreenArray(this._x);case"screen":return s.bbox.xview.v_compute(this._x);case"data":return t.v_compute(this._x)}})(),this.sy=(()=>{switch(this.model.y_units){case"canvas":return new u.ScreenArray(this._y);case"screen":return s.bbox.yview.v_compute(this._y);case"data":return e.v_compute(this._y)}})()}paint(){const{ctx:t}=this.layer;for(let e=0,s=this.text.length;e<s;e++){const s=this.x_offset.get(e),i=this.y_offset.get(e),r=this.sx[e]+s,o=this.sy[e]-i,l=this.angle.get(e),a=this.text.get(e);isFinite(r+o+l)&&null!=a&&this._paint(t,e,a,r,o,l)}}_paint(t,e,s,i,r,o){(0,d.assert)(e in this.els);const l=this.els[e];l.textContent=s,this.visuals.text.set_vectorize(t,e),l.style.position="absolute",l.style.left=`${i}px`,l.style.top=`${r}px`,l.style.color=t.fillStyle,l.style.webkitTextStroke=`1px ${t.strokeStyle}`,l.style.font=t.font,l.style.lineHeight="normal",l.style.whiteSpace="pre";const[a,n]=(()=>{switch(this.visuals.text.text_align.get(e)){case"left":return["left","0%"];case"center":return["center","-50%"];case"right":return["right","-100%"]}})(),[c,_]=(()=>{switch(this.visuals.text.text_baseline.get(e)){case"top":return["top","0%"];case"middle":default:return["center","-50%"];case"bottom":return["bottom","-100%"]}})();let u=`translate(${n}, ${_})`;o&&(u+=`rotate(${o}rad)`),l.style.transformOrigin=`${a} ${c}`,l.style.transform=u,this.layout,this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),l.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),l.style.borderStyle=t.lineDash.length<2?"solid":"dashed",l.style.borderWidth=`${t.lineWidth}px`,l.style.borderColor=t.strokeStyle),(0,h.display)(l)}}s.HTMLLabelSetView=y,y.__name__="HTMLLabelSetView";class p extends a.DataAnnotation{constructor(t){super(t)}}s.HTMLLabelSet=p,l=p,p.__name__="HTMLLabelSet",l.prototype.default_view=y,l.mixins([n.TextVector,["border_",n.LineVector],["background_",n.FillVector]]),l.define((()=>({x:[_.XCoordinateSpec,{field:"x"}],y:[_.YCoordinateSpec,{field:"y"}],x_units:[c.CoordinateUnits,"data"],y_units:[c.CoordinateUnits,"data"],text:[_.NullStringSpec,{field:"text"}],angle:[_.AngleSpec,0],x_offset:[_.NumberSpec,{value:0}],y_offset:[_.NumberSpec,{value:0}]}))),l.override({background_fill_color:null,border_line_color:null})},
function _(t,e,i,s,l){s();const o=t(1);var a;const n=t(275),r=t(19),c=t(150),h=o.__importStar(t(77));class _ extends n.TextAnnotationView{_get_location(){const t=this.model.offset,e=this.model.standoff/2;let i,s;const{bbox:l}=this.layout;switch(this.panel.side){case"above":case"below":switch(this.model.vertical_align){case"top":s=l.top+e;break;case"middle":s=l.vcenter;break;case"bottom":s=l.bottom-e}switch(this.model.align){case"left":i=l.left+t;break;case"center":i=l.hcenter;break;case"right":i=l.right-t}break;case"left":switch(this.model.vertical_align){case"top":i=l.left+e;break;case"middle":i=l.hcenter;break;case"bottom":i=l.right-e}switch(this.model.align){case"left":s=l.bottom-t;break;case"center":s=l.vcenter;break;case"right":s=l.top+t}break;case"right":switch(this.model.vertical_align){case"top":i=l.right-e;break;case"middle":i=l.hcenter;break;case"bottom":i=l.left+e}switch(this.model.align){case"left":s=l.top+t;break;case"center":s=l.vcenter;break;case"right":s=l.bottom-t}}return[i,s]}_render(){const{text:t}=this.model;if(0==t.length)return;this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;const[e,i]=this._get_location(),s=this.panel.get_label_angle_heuristic("parallel");this._paint(this.layer.ctx,t,e,i,s)}_get_size(){const{text:t}=this.model,e=new c.TextBox({text:t});e.visuals=this.visuals.text.values();const{width:i,height:s}=e.size();return{width:i,height:0==s?0:2+s+this.model.standoff}}}i.HTMLTitleView=_,_.__name__="HTMLTitleView";class d extends n.TextAnnotation{constructor(t){super(t)}}i.HTMLTitle=d,a=d,d.__name__="HTMLTitle",a.prototype.default_view=_,a.mixins([h.Text,["border_",h.Line],["background_",h.Fill]]),a.define((({Number:t,String:e})=>({text:[e,""],vertical_align:[r.VerticalAlign,"bottom"],align:[r.TextAlign,"left"],offset:[t,0],standoff:[t,10]}))),a.prototype._props.text_align.options.internal=!0,a.prototype._props.text_baseline.options.internal=!0,a.override({text_font_size:"13px",text_font_style:"bold",text_line_height:1,background_fill_color:null,border_line_color:null})},
function _(e,t,u,n,S){n(),S("CustomJS",e(279).CustomJS),S("OpenURL",e(281).OpenURL),S("SetValue",e(282).SetValue)},
function _(t,e,s,n,c){var a;n();const r=t(280),u=t(9),o=t(38);class i extends r.Callback{constructor(t){super(t)}get names(){return(0,u.keys)(this.args)}get values(){return(0,u.values)(this.args)}get func(){const t=(0,o.use_strict)(this.code);return new Function(...this.names,"cb_obj","cb_data",t)}execute(t,e={}){return this.func.apply(t,this.values.concat(t,e))}}s.CustomJS=i,a=i,i.__name__="CustomJS",a.define((({Unknown:t,String:e,Dict:s})=>({args:[s(t),{}],code:[e,""]})))},
function _(c,a,l,n,s){n();const e=c(50);class o extends e.Model{constructor(c){super(c)}}l.Callback=o,o.__name__="Callback"},
function _(e,t,n,o,i){var s;o();const c=e(280),r=e(169),a=e(8);class d extends c.Callback{constructor(e){super(e)}navigate(e){this.same_tab?window.location.href=e:window.open(e)}execute(e,{source:t}){const n=e=>{const n=(0,r.replace_placeholders)(this.url,t,e,void 0,void 0,encodeURI);if(!(0,a.isString)(n))throw new Error("HTML output is not supported in this context");this.navigate(n)},{selected:o}=t;for(const e of o.indices)n(e);for(const e of o.line_indices)n(e)}}n.OpenURL=d,s=d,d.__name__="OpenURL",s.define((({Boolean:e,String:t})=>({url:[t,"http://"],same_tab:[e,!1]})))},
function _(e,t,r,n,o){var a;n();const s=e(280),c=e(14),l=e(18);class u extends s.Callback{constructor(e){super(e)}execute(){const{obj:e,attr:t,value:r}=this;t in e.properties?e.setv({[t]:r}):l.logger.error(`${e.type}.${t} is not a property`)}}r.SetValue=u,a=u,u.__name__="SetValue",a.define((({String:e,Unknown:t,Ref:r})=>({obj:[r(c.HasProps)],attr:[e],value:[t]})))},
function _(a,n,e,r,s){r(),s("Canvas",a(284).Canvas),s("CartesianFrame",a(156).CartesianFrame)},
function _(e,t,s,i,a){i();const r=e(1);var l;const n=e(28),o=e(18),h=e(55),_=e(19),c=e(285),p=e(154),u=e(253),d=e(251),b=e(55),v=r.__importDefault(e(287));const w=(()=>{let t;return async()=>void 0!==t?t:t=await async function(){const t=document.createElement("canvas"),s=t.getContext("webgl",{premultipliedAlpha:!0});if(null!=s){const i=await(0,p.load_module)(Promise.resolve().then((()=>r.__importStar(e(490)))));if(null!=i){const e=i.get_regl(s);if(e.has_webgl)return{canvas:t,regl_wrapper:e};o.logger.trace("WebGL is supported, but not the required extensions")}else o.logger.trace("WebGL is supported, but bokehjs(.min).js bundle is not available")}else o.logger.trace("WebGL is not supported");return null}()})();class g extends d.UIElementView{constructor(){super(...arguments),this.webgl=null,this._size=new b.StyleSheet,this.plot_views=[]}initialize(){super.initialize(),this.underlays_el=(0,h.div)({class:"bk-layer"}),this.primary=this.create_layer(),this.overlays=this.create_layer(),this.overlays_el=(0,h.div)({class:"bk-layer"}),this.events_el=(0,h.div)({class:["bk-layer","bk-events"]}),this.ui_event_bus=new c.UIEventBus(this)}async lazy_initialize(){if(await super.lazy_initialize(),"webgl"==this.model.output_backend&&(this.webgl=await w(),n.settings.force_webgl&&null==this.webgl))throw new Error("webgl is not available")}remove(){this.ui_event_bus.destroy(),super.remove()}styles(){return[...super.styles(),v.default,this._size]}render(){super.render();const e=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];(0,h.append)(this.shadow_el,...e)}add_underlay(e){this.underlays_el.appendChild(e)}add_overlay(e){this.overlays_el.appendChild(e)}add_event(e){this.events_el.appendChild(e)}get pixel_ratio(){return this.primary.pixel_ratio}_update_bbox(){super._update_bbox();const{width:e,height:t}=this.bbox;this._size.replace(`\n    .bk-layer {\n      width: ${e}px;\n      height: ${t}px;\n    }\n    `)}_after_resize(){if(0!=this.plot_views.length)return;super._after_resize();const{width:e,height:t}=this.bbox;this.primary.resize(e,t),this.overlays.resize(e,t)}resize(){this._update_bbox();const{width:e,height:t}=this.bbox;this.primary.resize(e,t),this.overlays.resize(e,t)}prepare_webgl(e){const{webgl:t}=this;if(null!=t){const{width:s,height:i}=this.bbox;t.canvas.width=this.pixel_ratio*s,t.canvas.height=this.pixel_ratio*i;const[a,r,l,n]=e,{xview:o,yview:h}=this.bbox,_=o.compute(a),c=h.compute(r+n),p=this.pixel_ratio;t.regl_wrapper.set_scissor(p*_,p*c,p*l,p*n),this._clear_webgl()}}blit_webgl(e){const{webgl:t}=this;if(null!=t){if(o.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi){const t=this.pixel_ratio;e.scale(t,t),e.translate(.5,.5)}this._clear_webgl()}}_clear_webgl(){const{webgl:e}=this;if(null!=e){const{regl_wrapper:t,canvas:s}=e;t.clear(s.width,s.height)}}compose(){const e=this.create_layer(),{width:t,height:s}=this.bbox;return e.resize(t,s),e.ctx.drawImage(this.primary.canvas,0,0),e.ctx.drawImage(this.overlays.canvas,0,0),e}create_layer(){const{output_backend:e,hidpi:t}=this.model;return new u.CanvasLayer(e,t)}to_blob(){return this.compose().to_blob()}}s.CanvasView=g,g.__name__="CanvasView";class y extends d.UIElement{constructor(e){super(e)}}s.Canvas=y,l=y,y.__name__="Canvas",l.prototype.default_view=g,l.define((({Boolean:e})=>({hidpi:[e,!0],output_backend:[_.OutputBackend,"canvas"]})))},
function _(t,e,s,n,i){n();const r=t(1),a=r.__importDefault(t(262)),_=t(15),h=t(18),o=t(55),l=r.__importStar(t(46)),c=t(286),p=t(10),u=t(8),v=t(26);class d{constructor(t){this.canvas_view=t,this.pan_start=new _.Signal(this,"pan:start"),this.pan=new _.Signal(this,"pan"),this.pan_end=new _.Signal(this,"pan:end"),this.pinch_start=new _.Signal(this,"pinch:start"),this.pinch=new _.Signal(this,"pinch"),this.pinch_end=new _.Signal(this,"pinch:end"),this.rotate_start=new _.Signal(this,"rotate:start"),this.rotate=new _.Signal(this,"rotate"),this.rotate_end=new _.Signal(this,"rotate:end"),this.tap=new _.Signal(this,"tap"),this.doubletap=new _.Signal(this,"doubletap"),this.press=new _.Signal(this,"press"),this.pressup=new _.Signal(this,"pressup"),this.move_enter=new _.Signal(this,"move:enter"),this.move=new _.Signal(this,"move"),this.move_exit=new _.Signal(this,"move:exit"),this.scroll=new _.Signal(this,"scroll"),this.keydown=new _.Signal(this,"keydown"),this.keyup=new _.Signal(this,"keyup"),this.hammer=new a.default(this.hit_area,{cssProps:{},touchAction:"auto",inputClass:a.default.TouchMouseInput}),this._prev_move=null,this._curr_pan=null,this._curr_pinch=null,this._curr_rotate=null,this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",(t=>this._mouse_move(t))),this.hit_area.addEventListener("mouseenter",(t=>this._mouse_enter(t))),this.hit_area.addEventListener("mouseleave",(t=>this._mouse_exit(t))),this.hit_area.addEventListener("contextmenu",(t=>this._context_menu(t))),this.hit_area.addEventListener("wheel",(t=>this._mouse_wheel(t))),document.addEventListener("keydown",this),document.addEventListener("keyup",this)}get hit_area(){return this.canvas_view.events_el}destroy(){this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)}handleEvent(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)}_configure_hammerjs(){this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",(t=>this._doubletap(t))),this.hammer.on("tap",(t=>this._tap(t))),this.hammer.on("press",(t=>this._press(t))),this.hammer.on("pressup",(t=>this._pressup(t))),this.hammer.get("pan").set({direction:a.default.DIRECTION_ALL}),this.hammer.on("panstart",(t=>this._pan_start(t))),this.hammer.on("pan",(t=>this._pan(t))),this.hammer.on("panend",(t=>this._pan_end(t))),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",(t=>this._pinch_start(t))),this.hammer.on("pinch",(t=>this._pinch(t))),this.hammer.on("pinchend",(t=>this._pinch_end(t))),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",(t=>this._rotate_start(t))),this.hammer.on("rotate",(t=>this._rotate(t))),this.hammer.on("rotateend",(t=>this._rotate_end(t)))}register_tool(t){const e=t.model.event_type;null!=e&&((0,u.isString)(e)?this._register_tool(t,e):e.forEach(((e,s)=>this._register_tool(t,e,s<1))))}_register_tool(t,e,s=!0){const n=t,{id:i}=n.model,r=t=>e=>{e.id==i&&t(e.e)},a=t=>e=>{t(e.e)};switch(e){case"pan":null!=n._pan_start&&n.connect(this.pan_start,r(n._pan_start.bind(n))),null!=n._pan&&n.connect(this.pan,r(n._pan.bind(n))),null!=n._pan_end&&n.connect(this.pan_end,r(n._pan_end.bind(n)));break;case"pinch":null!=n._pinch_start&&n.connect(this.pinch_start,r(n._pinch_start.bind(n))),null!=n._pinch&&n.connect(this.pinch,r(n._pinch.bind(n))),null!=n._pinch_end&&n.connect(this.pinch_end,r(n._pinch_end.bind(n)));break;case"rotate":null!=n._rotate_start&&n.connect(this.rotate_start,r(n._rotate_start.bind(n))),null!=n._rotate&&n.connect(this.rotate,r(n._rotate.bind(n))),null!=n._rotate_end&&n.connect(this.rotate_end,r(n._rotate_end.bind(n)));break;case"move":null!=n._move_enter&&n.connect(this.move_enter,r(n._move_enter.bind(n))),null!=n._move&&n.connect(this.move,r(n._move.bind(n))),null!=n._move_exit&&n.connect(this.move_exit,r(n._move_exit.bind(n)));break;case"tap":null!=n._tap&&n.connect(this.tap,r(n._tap.bind(n))),null!=n._doubletap&&n.connect(this.doubletap,r(n._doubletap.bind(n)));break;case"press":null!=n._press&&n.connect(this.press,r(n._press.bind(n))),null!=n._pressup&&n.connect(this.pressup,r(n._pressup.bind(n)));break;case"scroll":null!=n._scroll&&n.connect(this.scroll,r(n._scroll.bind(n)));break;default:throw new Error(`unsupported event_type: ${e}`)}s&&(null!=n._keydown&&n.connect(this.keydown,a(n._keydown.bind(n))),null!=n._keyup&&n.connect(this.keyup,a(n._keyup.bind(n))),v.is_mobile&&null!=n._scroll&&"pinch"==e&&(h.logger.debug("Registering scroll on touch screen"),n.connect(this.scroll,r(n._scroll.bind(n)))))}_hit_test_renderers(t,e,s){var n,i;const r=t.get_renderer_views();for(const t of(0,p.reversed)(r))if(null!==(i=null===(n=t.interactive_hit)||void 0===n?void 0:n.call(t,e,s))&&void 0!==i&&i)return t;return null}set_cursor(t="default"){this.hit_area.style.cursor=t}_hit_test_frame(t,e,s){return t.frame.bbox.contains(e,s)}_hit_test_plot(t,e){for(const s of this.canvas_view.plot_views)if(s.bbox.relative().contains(t,e))return s;return null}_trigger(t,e,s){var n;const{sx:i,sy:r}=e,a=this._hit_test_plot(i,r),_=t=>{const[s,n]=[i,r];return Object.assign(Object.assign({},e),{sx:s,sy:n})};if("panstart"==e.type||"pan"==e.type||"panend"==e.type){let n;if("panstart"==e.type&&null!=a?(this._curr_pan={plot_view:a},n=a):"pan"==e.type&&null!=this._curr_pan?n=this._curr_pan.plot_view:"panend"==e.type&&null!=this._curr_pan?(n=this._curr_pan.plot_view,this._curr_pan=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("pinchstart"==e.type||"pinch"==e.type||"pinchend"==e.type){let n;if("pinchstart"==e.type&&null!=a?(this._curr_pinch={plot_view:a},n=a):"pinch"==e.type&&null!=this._curr_pinch?n=this._curr_pinch.plot_view:"pinchend"==e.type&&null!=this._curr_pinch?(n=this._curr_pinch.plot_view,this._curr_pinch=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("rotatestart"==e.type||"rotate"==e.type||"rotateend"==e.type){let n;if("rotatestart"==e.type&&null!=a?(this._curr_rotate={plot_view:a},n=a):"rotate"==e.type&&null!=this._curr_rotate?n=this._curr_rotate.plot_view:"rotateend"==e.type&&null!=this._curr_rotate?(n=this._curr_rotate.plot_view,this._curr_rotate=null):n=null,null!=n){const e=_();this.__trigger(n,t,e,s)}}else if("mouseenter"==e.type||"mousemove"==e.type||"mouseleave"==e.type){const h=null===(n=this._prev_move)||void 0===n?void 0:n.plot_view;if(null!=h&&("mouseleave"==e.type||h!=a)){const{sx:t,sy:e}=_();this.__trigger(h,this.move_exit,{type:"mouseleave",sx:t,sy:e,shiftKey:!1,ctrlKey:!1},s)}if(null!=a&&("mouseenter"==e.type||h!=a)){const{sx:t,sy:e}=_();this.__trigger(a,this.move_enter,{type:"mouseenter",sx:t,sy:e,shiftKey:!1,ctrlKey:!1},s)}if(null!=a&&"mousemove"==e.type){const e=_();this.__trigger(a,t,e,s)}this._prev_move={sx:i,sy:r,plot_view:a}}else if(null!=a){const e=_();this.__trigger(a,t,e,s)}}__trigger(t,e,s,n){var i,r,a,_;const h=t.model.toolbar.gestures,o=e.name.split(":")[0],l=this._hit_test_renderers(t,s.sx,s.sy);switch(o){case"move":{const n=h.move.active;null!=n&&this.trigger(e,s,n.id);const r=t.model.toolbar.inspectors.filter((t=>t.active));let a="default";null!=l?(a=null!==(i=l.cursor(s.sx,s.sy))&&void 0!==i?i:a,(0,p.is_empty)(r)||(e=this.move_exit)):this._hit_test_frame(t,s.sx,s.sy)&&((0,p.is_empty)(r)||(a="crosshair")),this.set_cursor(a),r.map((t=>this.trigger(e,s,t.id)));break}case"tap":{const i=null!==(r=n.path)&&void 0!==r?r:n.composedPath();if(0!=i.length&&i[0]!=this.hit_area)return;if(null===(a=null==l?void 0:l.on_hit)||void 0===a||a.call(l,s.sx,s.sy),this._hit_test_frame(t,s.sx,s.sy)){const t=h.tap.active;null!=t&&this.trigger(e,s,t.id)}break}case"doubletap":if(this._hit_test_frame(t,s.sx,s.sy)){const t=null!==(_=h.doubletap.active)&&void 0!==_?_:h.tap.active;null!=t&&this.trigger(e,s,t.id)}break;case"scroll":{const t=h[v.is_mobile?"pinch":"scroll"].active;null!=t&&(n.preventDefault(),n.stopPropagation(),this.trigger(e,s,t.id));break}case"pan":{const t=h.pan.active;null!=t&&(n.preventDefault(),this.trigger(e,s,t.id));break}default:{const t=h[o].active;null!=t&&this.trigger(e,s,t.id)}}this._trigger_bokeh_event(t,s)}trigger(t,e,s=null){t.emit({id:s,e})}_trigger_bokeh_event(t,e){const s=(()=>{const{sx:s,sy:n}=e,i=t.frame.x_scale.invert(s),r=t.frame.y_scale.invert(n);switch(e.type){case"wheel":return new l.MouseWheel(s,n,i,r,e.delta);case"mousemove":return new l.MouseMove(s,n,i,r);case"mouseenter":return new l.MouseEnter(s,n,i,r);case"mouseleave":return new l.MouseLeave(s,n,i,r);case"tap":return new l.Tap(s,n,i,r);case"doubletap":return new l.DoubleTap(s,n,i,r);case"press":return new l.Press(s,n,i,r);case"pressup":return new l.PressUp(s,n,i,r);case"pan":return new l.Pan(s,n,i,r,e.deltaX,e.deltaY);case"panstart":return new l.PanStart(s,n,i,r);case"panend":return new l.PanEnd(s,n,i,r);case"pinch":return new l.Pinch(s,n,i,r,e.scale);case"pinchstart":return new l.PinchStart(s,n,i,r);case"pinchend":return new l.PinchEnd(s,n,i,r);case"rotate":return new l.Rotate(s,n,i,r,e.rotation);case"rotatestart":return new l.RotateStart(s,n,i,r);case"rotateend":return new l.RotateEnd(s,n,i,r);default:return}})();null!=s&&t.model.trigger_event(s)}_get_sxy(t){const{pageX:e,pageY:s}=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,{left:n,top:i}=(0,o.offset_bbox)(this.hit_area);return{sx:e-n,sy:s-i}}_pan_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_pinch_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_rotate_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_tap_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_move_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_scroll_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{delta:(0,c.getDeltaY)(t),shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_key_event(t){return{type:t.type,keyCode:t.keyCode}}_pan_start(t){const e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)}_pan(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)}_pan_end(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)}_pinch_start(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)}_pinch(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)}_pinch_end(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)}_rotate_start(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)}_rotate(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)}_rotate_end(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)}_tap(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)}_doubletap(t){this._trigger(this.doubletap,this._tap_event(t),t.srcEvent)}_press(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)}_pressup(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)}_mouse_enter(t){this._trigger(this.move_enter,this._move_event(t),t)}_mouse_move(t){this._trigger(this.move,this._move_event(t),t)}_mouse_exit(t){this._trigger(this.move_exit,this._move_event(t),t)}_mouse_wheel(t){this._trigger(this.scroll,this._scroll_event(t),t)}_context_menu(t){}_key_down(t){this.trigger(this.keydown,this._key_event(t))}_key_up(t){this.trigger(this.keyup,this._key_event(t))}}s.UIEventBus=d,d.__name__="UIEventBus"},
function _(t,e,n,l,o){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function a(t){const e=getComputedStyle(t).fontSize,n=parseInt(e,10);return isNaN(n)?null:n}l(),n.getDeltaY=function(t){let e=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:e*=(n=t.target,null!==(i=null!==(o=a(null!==(l=n.offsetParent)&&void 0!==l?l:document.body))&&void 0!==o?o:a(n))&&void 0!==i?i:16);break;case t.DOM_DELTA_PAGE:e*=function(t){return t.clientHeight}(t.target)}var n,l,o,i;return e}},
function _(e,t,n,o,a){o(),n.layer="bk-layer",n.events="bk-events",n.default=".bk-layer{position:absolute;top:0;left:0;width:100%;height:100%;z-index:0;}.bk-layer.bk-events{touch-action:auto;user-select:none;-webkit-user-drag:none;-webkit-tap-highlight-color:rgba(0, 0, 0, 0);}"},
function _(n,i,o,a,p){a(),p("CoordinateMapping",n(83).CoordinateMapping)},
function _(m,o,n,r,a){r(),a("Expression",m(290).Expression),a("CustomJSExpr",m(291).CustomJSExpr),a("Stack",m(292).Stack),a("CumSum",m(293).CumSum),a("ScalarExpression",m(290).ScalarExpression),a("Minimum",m(294).Minimum),a("Maximum",m(295).Maximum);var s=m(296);a("XComponent",s.XComponent),a("YComponent",s.YComponent),a("PolarTransform",m(297).PolarTransform)},
function _(e,t,s,i,r){i();const n=e(50);class _ extends n.Model{constructor(e){super(e)}initialize(){super.initialize(),this._result=new Map}v_compute(e){let t=this._result.get(e);return(void 0===t||e.changed_for(this))&&(t=this._v_compute(e),this._result.set(e,t)),t}}s.Expression=_,_.__name__="Expression";class o extends n.Model{constructor(e){super(e)}initialize(){super.initialize(),this._result=new Map}compute(e){let t=this._result.get(e);return(void 0===t||e.changed_for(this))&&(t=this._compute(e),this._result.set(e,t)),t}}s.ScalarExpression=o,o.__name__="ScalarExpression"},
function _(e,s,n,t,r){var o;t();const a=e(14),c=e(290),i=e(23),u=e(10),l=e(9),h=e(38),g=e(8);class v extends c.Expression{constructor(e){super(e)}connect_signals(){super.connect_signals();for(const e of(0,l.values)(this.args))e instanceof a.HasProps&&e.change.connect((()=>{this._result.clear(),this.change.emit()}))}get names(){return(0,l.keys)(this.args)}get values(){return(0,l.values)(this.args)}get func(){const e=(0,h.use_strict)(this.code);return new i.GeneratorFunction(...this.names,e)}_v_compute(e){var s,n;const t=this.func.apply(e,this.values);let r=t.next();if(null!==(s=r.done)&&void 0!==s&&s&&void 0!==r.value){const{value:s}=r;return(0,g.isArray)(s)||(0,g.isTypedArray)(s)?s:(0,g.isIterable)(s)?[...s]:(0,u.repeat)(s,e.length)}{const e=[];do{e.push(r.value),r=t.next()}while(null===(n=r.done)||void 0===n||!n);return e}}}n.CustomJSExpr=v,o=v,v.__name__="CustomJSExpr",o.define((({Unknown:e,String:s,Dict:n})=>({args:[n(e),{}],code:[s,""]})))},
function _(t,n,e,o,r){var s;o();const c=t(290),a=t(9);class i extends c.Expression{constructor(t){super(t)}_v_compute(t){var n;const e=null!==(n=t.get_length())&&void 0!==n?n:0,o=new Float64Array(e);for(const n of this.fields){const r=(0,a.dict)(t.data).get(n);if(null!=r){const t=Math.min(e,r.length);for(let n=0;n<t;n++)o[n]+=r[n]}}return o}}e.Stack=i,s=i,i.__name__="Stack",s.define((({String:t,Array:n})=>({fields:[n(t),[]]})))},
function _(e,n,t,o,r){var i;o();const l=e(290);class u extends l.Expression{constructor(e){super(e)}_v_compute(e){var n;const t=new Float64Array(null!==(n=e.get_length())&&void 0!==n?n:0),o=e.data[this.field],r=this.include_zero?1:0;t[0]=this.include_zero?0:o[0];for(let e=1;e<t.length;e++)t[e]=t[e-1]+o[e-r];return t}}t.CumSum=u,i=u,u.__name__="CumSum",i.define((({Boolean:e,String:n})=>({field:[n],include_zero:[e,!1]})))},
function _(i,n,t,e,a){var r;e();const s=i(290),c=i(9),m=i(10);class u extends s.ScalarExpression{constructor(i){super(i)}_compute(i){var n;const t=null!==(n=(0,c.dict)(i.data).get(this.field))&&void 0!==n?n:[];return Math.min(this.initial,(0,m.min)(t))}}t.Minimum=u,r=u,u.__name__="Minimum",r.define((({Number:i,String:n})=>({field:[n],initial:[i,1/0]})))},
function _(i,t,a,n,e){var r;n();const s=i(290),c=i(9),m=i(10);class u extends s.ScalarExpression{constructor(i){super(i)}_compute(i){var t;const a=null!==(t=(0,c.dict)(i.data).get(this.field))&&void 0!==t?t:[];return Math.max(this.initial,(0,m.max)(a))}}a.Maximum=u,r=u,u.__name__="Maximum",r.define((({Number:i,String:t})=>({field:[t],initial:[i,-1/0]})))},
function _(n,e,t,o,r){var s;o();const _=n(290);class m extends _.Expression{constructor(n){super(n)}get x(){return new c({transform:this})}get y(){return new u({transform:this})}}t.CoordinateTransform=m,m.__name__="CoordinateTransform";class a extends _.Expression{constructor(n){super(n)}}t.XYComponent=a,s=a,a.__name__="XYComponent",s.define((({Ref:n})=>({transform:[n(m)]})));class c extends a{constructor(n){super(n)}_v_compute(n){return this.transform.v_compute(n).x}}t.XComponent=c,c.__name__="XComponent";class u extends a{constructor(n){super(n)}_v_compute(n){return this.transform.v_compute(n).y}}t.YComponent=u,u.__name__="YComponent"},
function _(r,t,n,e,o){e();const i=r(1);var a;const s=r(296),c=r(19),l=i.__importStar(r(17));class d extends s.CoordinateTransform{constructor(r){super(r)}_v_compute(r){const t=this.properties.radius.uniform(r),n=this.properties.angle.uniform(r),e="anticlock"==this.direction?-1:1,o=Math.min(t.length,n.length),i=new Float64Array(o),a=new Float64Array(o);for(let r=0;r<o;r++){const o=t.get(r),s=n.get(r)*e;i[r]=o*Math.cos(s),a[r]=o*Math.sin(s)}return{x:i,y:a}}}n.PolarTransform=d,a=d,d.__name__="PolarTransform",a.define((({})=>({radius:[l.DistanceSpec,{field:"radius"}],angle:[l.AngleSpec,{field:"angle"}],direction:[c.Direction,"anticlock"]})))},
function _(e,i,r,t,l){t(),l("BooleanFilter",e(299).BooleanFilter),l("CustomJSFilter",e(300).CustomJSFilter),l("Filter",e(215).Filter),l("GroupFilter",e(301).GroupFilter),l("IndexFilter",e(302).IndexFilter),l("AllIndices",e(216).AllIndices),l("InversionFilter",e(303).InversionFilter),l("IntersectionFilter",e(217).IntersectionFilter),l("UnionFilter",e(304).UnionFilter),l("DifferenceFilter",e(305).DifferenceFilter),l("SymmetricDifferenceFilter",e(306).SymmetricDifferenceFilter)},
function _(e,l,n,o,s){var t;o();const a=e(215),r=e(23);class i extends a.Filter{constructor(e){super(e)}compute_indices(e){var l;const n=null!==(l=e.get_length())&&void 0!==l?l:1,{booleans:o}=this;return null==o?r.Indices.all_set(n):r.Indices.from_booleans(n,o)}}n.BooleanFilter=i,t=i,i.__name__="BooleanFilter",t.define((({Boolean:e,Array:l,Nullable:n})=>({booleans:[n(l(e)),null]})))},
function _(e,n,r,s,t){var i;s();const o=e(215),u=e(23),c=e(9),a=e(8),l=e(38);class f extends o.Filter{constructor(e){super(e)}get names(){return(0,c.keys)(this.args)}get values(){return(0,c.values)(this.args)}get func(){const e=(0,l.use_strict)(this.code);return new Function(...this.names,"source",e)}compute_indices(e){var n;const r=null!==(n=e.get_length())&&void 0!==n?n:1,s=this.func(...this.values,e);if(null==s)return u.Indices.all_set(r);if((0,a.isArrayOf)(s,a.isInteger))return u.Indices.from_indices(r,s);if((0,a.isArrayOf)(s,a.isBoolean))return u.Indices.from_booleans(r,s);throw new Error(`expect an array of integers or booleans, or null, got ${s}`)}}r.CustomJSFilter=f,i=f,f.__name__="CustomJSFilter",i.define((({Unknown:e,String:n,Dict:r})=>({args:[r(e),{}],code:[n,""]})))},
function _(n,e,t,o,r){var u;o();const s=n(215),i=n(23),l=n(18);class c extends s.Filter{constructor(n){super(n)}compute_indices(n){var e;const t=n.get_column(this.column_name),o=null!==(e=n.get_length())&&void 0!==e?e:1;if(null==t)return l.logger.warn(`${this}: groupby column '${this.column_name}' not found in the data source`),i.Indices.all_set(o);{const n=new i.Indices(o,0);for(let e=0;e<n.size;e++)t[e]===this.group&&n.set(e);return n}}}t.GroupFilter=c,u=c,c.__name__="GroupFilter",u.define((({String:n})=>({column_name:[n],group:[n]})))},
function _(e,n,i,l,t){var s;l();const c=e(215),r=e(23);class d extends c.Filter{constructor(e){super(e)}compute_indices(e){var n;const i=null!==(n=e.get_length())&&void 0!==n?n:1,{indices:l}=this;return null==l?r.Indices.all_set(i):r.Indices.from_indices(i,l)}}i.IndexFilter=d,s=d,d.__name__="IndexFilter",s.define((({Int:e,Array:n,Nullable:i})=>({indices:[i(n(e)),null]})))},
function _(e,n,r,t,i){var s;t();const o=e(215);class c extends o.Filter{constructor(e){super(e)}compute_indices(e){const n=this.operand.compute_indices(e);return n.invert(),n}}r.InversionFilter=c,s=c,c.__name__="InversionFilter",s.define((({Ref:e})=>({operand:[e(o.Filter)]})))},
function _(n,e,t,r,o){var s;r();const i=n(215),c=n(23);class l extends i.Filter{constructor(n){super(n)}compute_indices(n){var e;const{operands:t}=this;if(0==t.length){const t=null!==(e=n.get_length())&&void 0!==e?e:1;return c.Indices.all_set(t)}{const[e,...r]=t.map((e=>e.compute_indices(n)));for(const n of r)e.add(n);return e}}}t.UnionFilter=l,s=l,l.__name__="UnionFilter",s.define((({Array:n,Ref:e})=>({operands:[n(e(i.Filter))]})))},
function _(e,t,n,r,s){var c;r();const i=e(215),o=e(23);class l extends i.Filter{constructor(e){super(e)}compute_indices(e){var t;const{operands:n}=this;if(0==n.length){const n=null!==(t=e.get_length())&&void 0!==t?t:1;return o.Indices.all_set(n)}{const[t,...r]=n.map((t=>t.compute_indices(e)));for(const e of r)t.subtract(e);return t}}}n.DifferenceFilter=l,c=l,l.__name__="DifferenceFilter",c.define((({Array:e,Ref:t})=>({operands:[e(t(i.Filter))]})))},
function _(e,t,r,n,c){var i;n();const s=e(215),o=e(23);class l extends s.Filter{constructor(e){super(e)}compute_indices(e){var t;const{operands:r}=this;if(0==r.length){const r=null!==(t=e.get_length())&&void 0!==t?t:1;return o.Indices.all_set(r)}{const[t,...n]=r.map((t=>t.compute_indices(e)));for(const e of n)t.symmetric_subtract(e);return t}}}r.SymmetricDifferenceFilter=l,i=l,l.__name__="SymmetricDifferenceFilter",i.define((({Array:e,Ref:t})=>({operands:[e(t(s.Filter))]})))},
function _(e,a,l,t,i){t(),i("AnnularWedge",e(308).AnnularWedge),i("Annulus",e(309).Annulus),i("Arc",e(310).Arc),i("Bezier",e(311).Bezier),i("Block",e(312).Block),i("Circle",e(314).Circle),i("Ellipse",e(315).Ellipse),i("Glyph",e(202).Glyph),i("HArea",e(211).HArea),i("HBar",e(317).HBar),i("HexTile",e(318).HexTile),i("Image",e(319).Image),i("ImageRGBA",e(321).ImageRGBA),i("ImageURL",e(322).ImageURL),i("Line",e(200).Line),i("MultiLine",e(323).MultiLine),i("MultiPolygons",e(324).MultiPolygons),i("Patch",e(210).Patch),i("Patches",e(325).Patches),i("Quad",e(326).Quad),i("Quadratic",e(327).Quadratic),i("Ray",e(328).Ray),i("Rect",e(329).Rect),i("Scatter",e(330).Scatter),i("Segment",e(333).Segment),i("Spline",e(334).Spline),i("Step",e(336).Step),i("Text",e(337).Text),i("VArea",e(213).VArea),i("VBar",e(338).VBar),i("Wedge",e(339).Wedge)},
function _(e,s,t,i,r){i();const n=e(1);var a;const _=e(201),o=e(208),d=e(77),h=e(23),l=e(19),u=n.__importStar(e(17)),c=e(11),g=e(100),p=e(13);class x extends _.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this.inner_radius):this.sinner_radius=(0,h.to_screen)(this.inner_radius),"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this.outer_radius):this.souter_radius=(0,h.to_screen)(this.outer_radius),this.max_souter_radius=(0,p.max)(this.souter_radius)}_render(e,s,t){const{sx:i,sy:r,start_angle:n,end_angle:a,sinner_radius:_,souter_radius:o}=null!=t?t:this,d="anticlock"==this.model.direction;for(const t of s){const s=i[t],h=r[t],l=_[t],u=o[t],c=n.get(t),g=a.get(t);if(!isFinite(s+h+l+u+c+g))continue;const p=g-c;e.translate(s,h),e.rotate(c),e.beginPath(),e.moveTo(u,0),e.arc(0,0,u,0,p,d),e.rotate(p),e.lineTo(l,0),e.arc(0,0,l,0,-p,!d),e.closePath(),e.rotate(-p-c),e.translate(-s,-h),this.visuals.fill.apply(e,t),this.visuals.hatch.apply(e,t),this.visuals.line.apply(e,t)}}_hit_point(e){const{sx:s,sy:t}=e,i=this.renderer.xscale.invert(s),r=this.renderer.yscale.invert(t),n=s-this.max_souter_radius,a=s+this.max_souter_radius,[_,o]=this.renderer.xscale.r_invert(n,a),d=t-this.max_souter_radius,h=t+this.max_souter_radius,[l,u]=this.renderer.yscale.r_invert(d,h),p=[];for(const e of this.index.indices({x0:_,x1:o,y0:l,y1:u})){const s=this.souter_radius[e]**2,t=this.sinner_radius[e]**2,[n,a]=this.renderer.xscale.r_compute(i,this._x[e]),[_,o]=this.renderer.yscale.r_compute(r,this._y[e]),d=(n-a)**2+(_-o)**2;d<=s&&d>=t&&p.push(e)}const x="anticlock"==this.model.direction,m=[];for(const e of p){const i=Math.atan2(t-this.sy[e],s-this.sx[e]);(Math.abs(this.start_angle.get(e)-this.end_angle.get(e))>=2*Math.PI||(0,c.angle_between)(-i,-this.start_angle.get(e),-this.end_angle.get(e),x))&&m.push(e)}return new g.Selection({indices:m})}draw_legend_for_index(e,s,t){(0,o.generic_area_vector_legend)(this.visuals,e,s,t)}scenterxy(e){const s=(this.sinner_radius[e]+this.souter_radius[e])/2,t=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+s*Math.cos(t),this.sy[e]+s*Math.sin(t)]}}t.AnnularWedgeView=x,x.__name__="AnnularWedgeView";class m extends _.XYGlyph{constructor(e){super(e)}}t.AnnularWedge=m,a=m,m.__name__="AnnularWedge",a.prototype.default_view=x,a.mixins([d.LineVector,d.FillVector,d.HatchVector]),a.define((({})=>({direction:[l.Direction,"anticlock"],inner_radius:[u.DistanceSpec,{field:"inner_radius"}],outer_radius:[u.DistanceSpec,{field:"outer_radius"}],start_angle:[u.AngleSpec,{field:"start_angle"}],end_angle:[u.AngleSpec,{field:"end_angle"}]})))},
function _(s,e,r,i,t){i();const n=s(1);var a;const u=s(201),_=s(23),o=s(77),d=n.__importStar(s(17)),h=s(100);class c extends u.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this.inner_radius):this.sinner_radius=(0,_.to_screen)(this.inner_radius),"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this.outer_radius):this.souter_radius=(0,_.to_screen)(this.outer_radius)}_render(s,e,r){const{sx:i,sy:t,sinner_radius:n,souter_radius:a}=null!=r?r:this;for(const r of e){const e=i[r],u=t[r],_=n[r],o=a[r];isFinite(e+u+_+o)&&(s.beginPath(),s.arc(e,u,_,0,2*Math.PI,!0),s.moveTo(e+o,u),s.arc(e,u,o,2*Math.PI,0,!1),this.visuals.fill.apply(s,r),this.visuals.hatch.apply(s,r),this.visuals.line.apply(s,r))}}_hit_point(s){const{sx:e,sy:r}=s,i=this.renderer.xscale.invert(e),t=this.renderer.yscale.invert(r);let n,a,u,_;if("data"==this.model.properties.outer_radius.units)n=i-this.max_outer_radius,u=i+this.max_outer_radius,a=t-this.max_outer_radius,_=t+this.max_outer_radius;else{const s=e-this.max_outer_radius,i=e+this.max_outer_radius;[n,u]=this.renderer.xscale.r_invert(s,i);const t=r-this.max_outer_radius,o=r+this.max_outer_radius;[a,_]=this.renderer.yscale.r_invert(t,o)}const o=[];for(const s of this.index.indices({x0:n,x1:u,y0:a,y1:_})){const e=this.souter_radius[s]**2,r=this.sinner_radius[s]**2,[n,a]=this.renderer.xscale.r_compute(i,this._x[s]),[u,_]=this.renderer.yscale.r_compute(t,this._y[s]),d=(n-a)**2+(u-_)**2;d<=e&&d>=r&&o.push(s)}return new h.Selection({indices:o})}draw_legend_for_index(s,{x0:e,y0:r,x1:i,y1:t},n){const a=n+1,u=new Array(a);u[n]=(e+i)/2;const _=new Array(a);_[n]=(r+t)/2;const o=.5*Math.min(Math.abs(i-e),Math.abs(t-r)),d=new Array(a);d[n]=.4*o;const h=new Array(a);h[n]=.8*o,this._render(s,[n],{sx:u,sy:_,sinner_radius:d,souter_radius:h})}}r.AnnulusView=c,c.__name__="AnnulusView";class l extends u.XYGlyph{constructor(s){super(s)}}r.Annulus=l,a=l,l.__name__="Annulus",a.prototype.default_view=c,a.mixins([o.LineVector,o.FillVector,o.HatchVector]),a.define((({})=>({inner_radius:[d.DistanceSpec,{field:"inner_radius"}],outer_radius:[d.DistanceSpec,{field:"outer_radius"}]})))},
function _(e,s,t,i,n){i();const r=e(1);var a;const o=e(201),d=e(208),c=e(77),l=e(23),_=e(19),h=r.__importStar(e(17));class u extends o.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius):this.sradius=(0,l.to_screen)(this.radius)}_render(e,s,t){if(!this.visuals.line.doit)return;const{sx:i,sy:n,sradius:r,start_angle:a,end_angle:o}=null!=t?t:this,d="anticlock"==this.model.direction;for(const t of s){const s=i[t],c=n[t],l=r[t],_=a.get(t),h=o.get(t);isFinite(s+c+l+_+h)&&(this._render_decorations(e,t,s,c,l,_,h,d),e.beginPath(),e.arc(s,c,l,_,h,d),this.visuals.line.apply(e,t))}}_render_decorations(e,s,t,i,n,r,a,o){const{sin:d,cos:c,PI:l}=Math;for(const o of this.decorations.values()){if(e.save(),"start"==o.model.node){const s=n*c(r)+t,a=n*d(r)+i;e.translate(s,a),e.rotate(r+l)}else if("end"==o.model.node){const s=n*Math.cos(a)+t,r=n*Math.sin(a)+i;e.translate(s,r),e.rotate(a)}o.marking.render(e,s),e.restore()}}draw_legend_for_index(e,s,t){(0,d.generic_line_vector_legend)(this.visuals,e,s,t)}}t.ArcView=u,u.__name__="ArcView";class g extends o.XYGlyph{constructor(e){super(e)}}t.Arc=g,a=g,g.__name__="Arc",a.prototype.default_view=u,a.mixins(c.LineVector),a.define((({})=>({direction:[_.Direction,"anticlock"],radius:[h.DistanceSpec,{field:"radius"}],start_angle:[h.AngleSpec,{field:"start_angle"}],end_angle:[h.AngleSpec,{field:"end_angle"}]})))},
function _(e,t,i,n,s){n();const c=e(1);var o;const r=e(77),a=e(202),_=e(208),d=e(104),l=c.__importStar(e(17));function x(e,t,i,n,s,c,o,r){const a=[],_=[[],[]];for(let _=0;_<=2;_++){let d,l,x;if(0===_?(l=6*e-12*i+6*s,d=-3*e+9*i-9*s+3*o,x=3*i-3*e):(l=6*t-12*n+6*c,d=-3*t+9*n-9*c+3*r,x=3*n-3*t),Math.abs(d)<1e-12){if(Math.abs(l)<1e-12)continue;const e=-x/l;0<e&&e<1&&a.push(e);continue}const y=l*l-4*x*d,p=Math.sqrt(y);if(y<0)continue;const h=(-l+p)/(2*d);0<h&&h<1&&a.push(h);const f=(-l-p)/(2*d);0<f&&f<1&&a.push(f)}let d=a.length;const l=d;for(;d--;){const l=a[d],x=1-l,y=x*x*x*e+3*x*x*l*i+3*x*l*l*s+l*l*l*o;_[0][d]=y;const p=x*x*x*t+3*x*x*l*n+3*x*l*l*c+l*l*l*r;_[1][d]=p}return _[0][l]=e,_[1][l]=t,_[0][l+1]=o,_[1][l+1]=r,[Math.min(..._[0]),Math.max(..._[1]),Math.max(..._[0]),Math.min(..._[1])]}class y extends a.GlyphView{_project_data(){d.inplace.project_xy(this._x0,this._y0),d.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{data_size:t,_x0:i,_y0:n,_x1:s,_y1:c,_cx0:o,_cy0:r,_cx1:a,_cy1:_}=this;for(let d=0;d<t;d++){const t=i[d],l=n[d],y=s[d],p=c[d],h=o[d],f=r[d],u=a[d],m=_[d];if(isFinite(t+y+l+p+h+f+u+m)){const[i,n,s,c]=x(t,l,y,p,h,f,u,m);e.add_rect(i,n,s,c)}else e.add_empty()}}_render(e,t,i){if(!this.visuals.line.doit)return;const{sx0:n,sy0:s,sx1:c,sy1:o,scx0:r,scy0:a,scx1:_,scy1:d}=null!=i?i:this;for(const i of t){const t=n[i],l=s[i],x=c[i],y=o[i],p=r[i],h=a[i],f=_[i],u=d[i];isFinite(t+l+x+y+p+h+f+u)&&(e.beginPath(),e.moveTo(t,l),e.bezierCurveTo(p,h,f,u,x,y),this.visuals.line.apply(e,i))}}draw_legend_for_index(e,t,i){(0,_.generic_line_vector_legend)(this.visuals,e,t,i)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}i.BezierView=y,y.__name__="BezierView";class p extends a.Glyph{constructor(e){super(e)}}i.Bezier=p,o=p,p.__name__="Bezier",o.prototype.default_view=y,o.define((({})=>({x0:[l.XCoordinateSpec,{field:"x0"}],y0:[l.YCoordinateSpec,{field:"y0"}],x1:[l.XCoordinateSpec,{field:"x1"}],y1:[l.YCoordinateSpec,{field:"y1"}],cx0:[l.XCoordinateSpec,{field:"cx0"}],cy0:[l.YCoordinateSpec,{field:"cy0"}],cx1:[l.XCoordinateSpec,{field:"cx1"}],cy1:[l.YCoordinateSpec,{field:"cy1"}]}))),o.mixins(r.LineVector)},
function _(t,e,s,i,r){i();const h=t(1);var a;const n=t(313),o=t(23),l=h.__importStar(t(17));class _ extends n.LRTBView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:s}=await Promise.resolve().then((()=>h.__importStar(t(508))));this.glglyph=new s(e.regl_wrapper,this)}}scenterxy(t){return[this.sleft[t]/2+this.sright[t]/2,this.stop[t]/2+this.sbottom[t]/2]}_lrtb(t){const e=this._x[t],s=this._y[t],i=this.width.get(t),r=this.height.get(t);return[Math.min(e,e+i),Math.max(e,e+i),Math.max(s,s+r),Math.min(s,s+r)]}_map_data(){const t=this.renderer.xscale.v_compute(this._x),e=this.renderer.yscale.v_compute(this._y),s=this.sdist(this.renderer.xscale,this._x,this.width,"edge"),i=this.sdist(this.renderer.yscale,this._y,this.height,"edge"),r=t.length;this.stop=new o.ScreenArray(r),this.sbottom=new o.ScreenArray(r),this.sleft=new o.ScreenArray(r),this.sright=new o.ScreenArray(r);for(let h=0;h<r;h++)this.stop[h]=e[h]-i[h],this.sbottom[h]=e[h],this.sleft[h]=t[h],this.sright[h]=t[h]+s[h];this._clamp_viewport()}}s.BlockView=_,_.__name__="BlockView";class c extends n.LRTB{constructor(t){super(t)}}s.Block=c,a=c,c.__name__="Block",a.prototype.default_view=_,a.define((({})=>({x:[l.XCoordinateSpec,{field:"x"}],y:[l.YCoordinateSpec,{field:"y"}],width:[l.NumberSpec,{value:1}],height:[l.NumberSpec,{value:1}]})))},
function _(t,e,s,r,i){var n;r();const a=t(77),h=t(202),o=t(208),c=t(100);class _ extends h.GlyphView{get_anchor_point(t,e,s){const r=Math.min(this.sleft[e],this.sright[e]),i=Math.max(this.sright[e],this.sleft[e]),n=Math.min(this.stop[e],this.sbottom[e]),a=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:r,y:n};case"top":case"top_center":return{x:(r+i)/2,y:n};case"top_right":return{x:i,y:n};case"bottom_left":return{x:r,y:a};case"bottom":case"bottom_center":return{x:(r+i)/2,y:a};case"bottom_right":return{x:i,y:a};case"left":case"center_left":return{x:r,y:(n+a)/2};case"center":case"center_center":return{x:(r+i)/2,y:(n+a)/2};case"right":case"center_right":return{x:i,y:(n+a)/2}}}_index_data(t){const{min:e,max:s}=Math,{data_size:r}=this;for(let i=0;i<r;i++){const[r,n,a,h]=this._lrtb(i);t.add_rect(e(r,n),e(a,h),s(n,r),s(a,h))}}_render(t,e,s){const{sleft:r,sright:i,stop:n,sbottom:a}=null!=s?s:this;for(const s of e){const e=r[s],h=n[s],o=i[s],c=a[s];isFinite(e+h+o+c)&&(t.beginPath(),t.rect(e,h,o-e,c-h),this.visuals.fill.apply(t,s),this.visuals.hatch.apply(t,s),this.visuals.line.apply(t,s))}}_clamp_viewport(){const t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,s=this.stop.length;for(let r=0;r<s;r++)this.stop[r]=Math.max(this.stop[r],e.start),this.sbottom[r]=Math.min(this.sbottom[r],e.end),this.sleft[r]=Math.max(this.sleft[r],t.start),this.sright[r]=Math.min(this.sright[r],t.end)}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const{sx:e,sy:s}=t,r=this.renderer.xscale.invert(e),i=this.renderer.yscale.invert(s),n=[...this.index.indices({x0:r,y0:i,x1:r,y1:i})];return new c.Selection({indices:n})}_hit_span(t){const{sx:e,sy:s}=t;let r;if("v"==t.direction){const t=this.renderer.yscale.invert(s),e=this.renderer.plot_view.frame.bbox.h_range,[i,n]=this.renderer.xscale.r_invert(e.start,e.end);r=[...this.index.indices({x0:i,y0:t,x1:n,y1:t})]}else{const t=this.renderer.xscale.invert(e),s=this.renderer.plot_view.frame.bbox.v_range,[i,n]=this.renderer.yscale.r_invert(s.start,s.end);r=[...this.index.indices({x0:t,y0:i,x1:t,y1:n})]}return new c.Selection({indices:r})}draw_legend_for_index(t,e,s){(0,o.generic_area_vector_legend)(this.visuals,t,e,s)}}s.LRTBView=_,_.__name__="LRTBView";class l extends h.Glyph{constructor(t){super(t)}}s.LRTB=l,n=l,l.__name__="LRTB",n.mixins([a.LineVector,a.FillVector,a.HatchVector])},
function _(s,i,e,t,r){t();const a=s(1);var n;const h=s(201),d=s(77),_=s(23),l=s(19),c=a.__importStar(s(209)),u=a.__importStar(s(17)),o=s(10),x=s(13),m=s(100);class p extends h.XYGlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:i}=this.renderer.plot_view.canvas_view;if(null!=i&&i.regl_wrapper.has_webgl){const{CircleGL:e}=await Promise.resolve().then((()=>a.__importStar(s(504))));this.glglyph=new e(i.regl_wrapper,this)}}get use_radius(){return!(this.radius.is_Scalar()&&isNaN(this.radius.value))}_set_data(s){super._set_data(s);const i=(()=>{if(this.use_radius)return 2*this.max_radius;{const{size:s}=this;return s.is_Scalar()?s.value:(0,x.max)(s.array)}})();this._configure("max_size",{value:i})}_index_data(s){if(this.use_radius){const{_x:i,_y:e,radius:t,data_size:r}=this;for(let a=0;a<r;a++){const r=i[a],n=e[a],h=t.get(a);s.add_rect(r-h,n-h,r+h,n+h)}}else super._index_data(s)}_map_data(){if(this.use_radius)if("data"==this.model.properties.radius.units)switch(this.model.radius_dimension){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this.radius);break;case"max":{const s=this.sdist(this.renderer.xscale,this._x,this.radius),i=this.sdist(this.renderer.yscale,this._y,this.radius);this.sradius=(0,x.map)(s,((s,e)=>Math.max(s,i[e])));break}case"min":{const s=this.sdist(this.renderer.xscale,this._x,this.radius),i=this.sdist(this.renderer.yscale,this._y,this.radius);this.sradius=(0,x.map)(s,((s,e)=>Math.min(s,i[e])));break}}else this.sradius=(0,_.to_screen)(this.radius);else{const s=_.ScreenArray.from(this.size);this.sradius=(0,x.map)(s,(s=>s/2))}}_mask_data(){const{frame:s}=this.renderer.plot_view,i=s.x_target,e=s.y_target;let t,r;return this.use_radius&&"data"==this.model.properties.radius.units?(t=i.map((s=>this.renderer.xscale.invert(s))).widen(this.max_radius),r=e.map((s=>this.renderer.yscale.invert(s))).widen(this.max_radius)):(t=i.widen(this.max_size).map((s=>this.renderer.xscale.invert(s))),r=e.widen(this.max_size).map((s=>this.renderer.yscale.invert(s)))),this.index.indices({x0:t.start,x1:t.end,y0:r.start,y1:r.end})}_render(s,i,e){const{sx:t,sy:r,sradius:a}=null!=e?e:this;for(const e of i){const i=t[e],n=r[e],h=a[e];isFinite(i+n+h)&&(s.beginPath(),s.arc(i,n,h,0,2*Math.PI,!1),this.visuals.fill.apply(s,e),this.visuals.hatch.apply(s,e),this.visuals.line.apply(s,e))}}_hit_point(s){const{sx:i,sy:e}=s,t=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(e),{hit_dilation:a}=this.model;let n,h,d,_;if(this.use_radius&&"data"==this.model.properties.radius.units)n=t-this.max_radius*a,h=t+this.max_radius*a,d=r-this.max_radius*a,_=r+this.max_radius*a;else{const s=i-this.max_size*a,t=i+this.max_size*a;[n,h]=this.renderer.xscale.r_invert(s,t);const r=e-this.max_size*a,l=e+this.max_size*a;[d,_]=this.renderer.yscale.r_invert(r,l)}const l=this.index.indices({x0:n,x1:h,y0:d,y1:_}),c=[];if(this.use_radius&&"data"==this.model.properties.radius.units)for(const s of l){const i=(this.sradius[s]*a)**2,[e,n]=this.renderer.xscale.r_compute(t,this._x[s]),[h,d]=this.renderer.yscale.r_compute(r,this._y[s]);(e-n)**2+(h-d)**2<=i&&c.push(s)}else for(const s of l){const t=(this.sradius[s]*a)**2;(this.sx[s]-i)**2+(this.sy[s]-e)**2<=t&&c.push(s)}return new m.Selection({indices:c})}_hit_span(s){const{sx:i,sy:e}=s,t=this.bounds();let r,a,n,h;if("h"==s.direction){let s,e;if(n=t.y0,h=t.y1,this.use_radius&&"data"==this.model.properties.radius.units)s=i-this.max_radius,e=i+this.max_radius,[r,a]=this.renderer.xscale.r_invert(s,e);else{const t=this.max_size/2;s=i-t,e=i+t,[r,a]=this.renderer.xscale.r_invert(s,e)}}else{let s,i;if(r=t.x0,a=t.x1,this.use_radius&&"data"==this.model.properties.radius.units)s=e-this.max_radius,i=e+this.max_radius,[n,h]=this.renderer.yscale.r_invert(s,i);else{const t=this.max_size/2;s=e-t,i=e+t,[n,h]=this.renderer.yscale.r_invert(s,i)}}const d=[...this.index.indices({x0:r,x1:a,y0:n,y1:h})];return new m.Selection({indices:d})}_hit_rect(s){const{sx0:i,sx1:e,sy0:t,sy1:r}=s,[a,n]=this.renderer.xscale.r_invert(i,e),[h,d]=this.renderer.yscale.r_invert(t,r),_=[...this.index.indices({x0:a,x1:n,y0:h,y1:d})];return new m.Selection({indices:_})}_hit_poly(s){const{sx:i,sy:e}=s,t=(0,o.range)(0,this.sx.length),r=[];for(let s=0,a=t.length;s<a;s++){const a=t[s];c.point_in_poly(this.sx[s],this.sy[s],i,e)&&r.push(a)}return new m.Selection({indices:r})}draw_legend_for_index(s,{x0:i,y0:e,x1:t,y1:r},a){const n=a+1,h=new Array(n);h[a]=(i+t)/2;const d=new Array(n);d[a]=(e+r)/2;const _=new Array(n);_[a]=.2*Math.min(Math.abs(t-i),Math.abs(r-e)),this._render(s,[a],{sx:h,sy:d,sradius:_})}}e.CircleView=p,p.__name__="CircleView";class y extends h.XYGlyph{constructor(s){super(s)}}e.Circle=y,n=y,y.__name__="Circle",n.prototype.default_view=p,n.mixins([d.LineVector,d.FillVector,d.HatchVector]),n.define((({Number:s})=>({angle:[u.AngleSpec,0],size:[u.ScreenSizeSpec,{value:4}],radius:[u.NullDistanceSpec,null],radius_dimension:[l.RadiusDimension,"x"],hit_dilation:[s,1]})))},
function _(t,s,e,i,h){i();const r=t(1);var n;const a=t(316),l=r.__importStar(t(209)),o=t(23),_=t(100),d=r.__importStar(t(17));class c extends a.CenterRotatableView{_map_data(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.width,"center"):this.sw=(0,o.to_screen)(this.width),"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.height,"center"):this.sh=(0,o.to_screen)(this.height)}_render(t,s,e){const{sx:i,sy:h,sw:r,sh:n,angle:a}=null!=e?e:this;for(const e of s){const s=i[e],l=h[e],o=r[e],_=n[e],d=a.get(e);isFinite(s+l+o+_+d)&&(t.beginPath(),t.ellipse(s,l,o/2,_/2,d,0,2*Math.PI),this.visuals.fill.apply(t,e),this.visuals.hatch.apply(t,e),this.visuals.line.apply(t,e))}}_hit_point(t){let s,e,i,h,r,n,a,o,d;const{sx:c,sy:p}=t,w=this.renderer.xscale.invert(c),x=this.renderer.yscale.invert(p);"data"==this.model.properties.width.units?(s=w-this.max_width,e=w+this.max_width):(n=c-this.max_width,a=c+this.max_width,[s,e]=this.renderer.xscale.r_invert(n,a)),"data"==this.model.properties.height.units?(i=x-this.max_height,h=x+this.max_height):(o=p-this.max_height,d=p+this.max_height,[i,h]=this.renderer.yscale.r_invert(o,d));const y=this.index.indices({x0:s,x1:e,y0:i,y1:h}),m=[];for(const t of y)r=l.point_in_ellipse(c,p,this.angle.get(t),this.sh[t]/2,this.sw[t]/2,this.sx[t],this.sy[t]),r&&m.push(t);return new _.Selection({indices:m})}draw_legend_for_index(t,{x0:s,y0:e,x1:i,y1:h},r){const n=r+1,a=new Array(n);a[r]=(s+i)/2;const l=new Array(n);l[r]=(e+h)/2;const o=this.sw[r]/this.sh[r],_=.8*Math.min(Math.abs(i-s),Math.abs(h-e)),c=new Array(n),p=new Array(n);o>1?(c[r]=_,p[r]=_/o):(c[r]=_*o,p[r]=_);const w=new d.UniformScalar(0,n);this._render(t,[r],{sx:a,sy:l,sw:c,sh:p,angle:w})}}e.EllipseView=c,c.__name__="EllipseView";class p extends a.CenterRotatable{constructor(t){super(t)}}e.Ellipse=p,n=p,p.__name__="Ellipse",n.prototype.default_view=c},
function _(e,t,i,a,n){a();const s=e(1);var r;const h=e(201),o=e(77),_=s.__importStar(e(17));class c extends h.XYGlyphView{get max_w2(){return"data"==this.model.properties.width.units?this.max_width/2:0}get max_h2(){return"data"==this.model.properties.height.units?this.max_height/2:0}_bounds({x0:e,x1:t,y0:i,y1:a}){const{max_w2:n,max_h2:s}=this;return{x0:e-n,x1:t+n,y0:i-s,y1:a+s}}}i.CenterRotatableView=c,c.__name__="CenterRotatableView";class l extends h.XYGlyph{constructor(e){super(e)}}i.CenterRotatable=l,r=l,l.__name__="CenterRotatable",r.mixins([o.LineVector,o.FillVector,o.HatchVector]),r.define((({})=>({angle:[_.AngleSpec,0],width:[_.DistanceSpec,{field:"width"}],height:[_.DistanceSpec,{field:"height"}]})))},
function _(t,e,s,i,r){i();const h=t(1);var a;const n=t(313),_=t(23),l=h.__importStar(t(17));class o extends n.LRTBView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:s}=await Promise.resolve().then((()=>h.__importStar(t(508))));this.glglyph=new s(e.regl_wrapper,this)}}scenterxy(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]}_lrtb(t){const e=this._left[t],s=this._right[t],i=this._y[t],r=this.height.get(t)/2;return[Math.min(e,s),Math.max(e,s),i+r,i-r]}_map_data(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this.height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);const t=this.sy.length;this.stop=new _.ScreenArray(t),this.sbottom=new _.ScreenArray(t);for(let e=0;e<t;e++)this.stop[e]=this.sy[e]-this.sh[e]/2,this.sbottom[e]=this.sy[e]+this.sh[e]/2;this._clamp_viewport()}}s.HBarView=o,o.__name__="HBarView";class c extends n.LRTB{constructor(t){super(t)}}s.HBar=c,a=c,c.__name__="HBar",a.prototype.default_view=o,a.define((({})=>({left:[l.XCoordinateSpec,{value:0}],y:[l.YCoordinateSpec,{field:"y"}],height:[l.NumberSpec,{value:1}],right:[l.XCoordinateSpec,{field:"right"}]})))},
function _(e,t,s,i,r){i();const n=e(1);var a;const l=e(202),o=n.__importStar(e(209)),c=n.__importStar(e(17)),h=e(77),_=e(19),d=e(104),p=e(208),x=e(100);class y extends l.GlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:t}=this.renderer.plot_view.canvas_view;if(null!=t&&t.regl_wrapper.has_webgl){const{HexTileGL:s}=await Promise.resolve().then((()=>n.__importStar(e(506))));this.glglyph=new s(t.regl_wrapper,this)}}scenterxy(e){return[this.sx[e],this.sy[e]]}_set_data(){const{orientation:e,size:t,aspect_scale:s}=this.model,{q:i,r}=this,n=this.q.length;this._x=new Float64Array(n),this._y=new Float64Array(n);const{_x:a,_y:l}=this,o=Math.sqrt(3);if("pointytop"==e)for(let e=0;e<n;e++){const n=i.get(e),c=r.get(e)/2;a[e]=t*o*(n+c)/s,l[e]=-3*t*c}else for(let e=0;e<n;e++){const n=i.get(e)/2,c=r.get(e);a[e]=3*t*n,l[e]=-t*o*(c+n)*s}}_project_data(){d.inplace.project_xy(this._x,this._y)}_index_data(e){let t=this.model.size,s=Math.sqrt(3)*t/2;"flattop"==this.model.orientation?([s,t]=[t,s],t*=this.model.aspect_scale):s/=this.model.aspect_scale;const{data_size:i}=this;for(let r=0;r<i;r++){const i=this._x[r],n=this._y[r];e.add_rect(i-s,n-t,i+s,n+t)}}map_data(){var e;[this.sx,this.sy]=this.renderer.coordinates.map_to_screen(this._x,this._y),[this.svx,this.svy]=this._get_unscaled_vertices(),null===(e=this.glglyph)||void 0===e||e.set_data_changed()}_get_unscaled_vertices(){const e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){const s=this.renderer.yscale,i=this.renderer.xscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t,a=r/2;return[[0,-n,-n,0,n,n],[r,a,-a,-r,-a,a]]}{const s=this.renderer.xscale,i=this.renderer.yscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t,a=r/2;return[[r,a,-a,-r,-a,a],[0,-n,-n,0,n,n]]}}_render(e,t,s){const{sx:i,sy:r,svx:n,svy:a,scale:l}=null!=s?s:this;for(const s of t){const t=i[s],o=r[s],c=l.get(s);if(isFinite(t+o+c)){e.translate(t,o),e.beginPath();for(let t=0;t<6;t++)e.lineTo(n[t]*c,a[t]*c);e.closePath(),e.translate(-t,-o),this.visuals.fill.apply(e,s),this.visuals.hatch.apply(e,s),this.visuals.line.apply(e,s)}}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s),n=this.index.indices({x0:i,y0:r,x1:i,y1:r}),a=[];for(const e of n)o.point_in_poly(t-this.sx[e],s-this.sy[e],this.svx,this.svy)&&a.push(e);return new x.Selection({indices:a})}_hit_span(e){const{sx:t,sy:s}=e;let i;if("v"==e.direction){const e=this.renderer.yscale.invert(s),t=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(t.start,t.end);i=[...this.index.indices({x0:r,y0:e,x1:n,y1:e})]}else{const e=this.renderer.xscale.invert(t),s=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(s.start,s.end);i=[...this.index.indices({x0:e,y0:r,x1:e,y1:n})]}return new x.Selection({indices:i})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:r}=e,[n,a]=this.renderer.xscale.r_invert(t,s),[l,o]=this.renderer.yscale.r_invert(i,r),c=[...this.index.indices({x0:n,x1:a,y0:l,y1:o})];return new x.Selection({indices:c})}draw_legend_for_index(e,t,s){(0,p.generic_area_vector_legend)(this.visuals,e,t,s)}}s.HexTileView=y,y.__name__="HexTileView";class u extends l.Glyph{constructor(e){super(e)}}s.HexTile=u,a=u,u.__name__="HexTile",a.prototype.default_view=y,a.mixins([h.LineVector,h.FillVector,h.HatchVector]),a.define((({Number:e})=>({r:[c.NumberSpec,{field:"r"}],q:[c.NumberSpec,{field:"q"}],scale:[c.NumberSpec,1],size:[e,1],aspect_scale:[e,1],orientation:[_.HexTileOrientation,"pointytop"]}))),a.override({line_color:null})},
function _(e,a,t,_,r){var n;_();const s=e(320),o=e(196),i=e(238);class p extends s.ImageBaseView{connect_signals(){super.connect_signals(),this.connect(this.model.color_mapper.change,(()=>this._update_image()))}_update_image(){null!=this.image_data&&(this._set_data(null),this.renderer.request_render())}_flat_img_to_buf8(e){return this.model.color_mapper.rgba_mapper.v_compute(e)}}t.ImageView=p,p.__name__="ImageView";class m extends s.ImageBase{constructor(e){super(e)}}t.Image=m,n=m,m.__name__="Image",n.prototype.default_view=p,n.define((({Ref:e})=>({color_mapper:[e(o.ColorMapper),()=>new i.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})]})))},
function _(e,t,s,i,r){i();const a=e(1);var n;const h=e(201),_=e(23),c=e(19),o=a.__importStar(e(17)),g=a.__importStar(e(77)),d=e(100),l=e(12),m=e(8);class u extends h.XYGlyphView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,(()=>this.renderer.request_render()))}get xy_scale(){switch(this.model.origin){case"bottom_left":return[1,-1];case"top_left":return[1,1];case"bottom_right":return[-1,-1];case"top_right":return[-1,1]}}get xy_offset(){switch(this.model.origin){case"bottom_left":return[0,1];case"top_left":return[0,0];case"bottom_right":return[1,1];case"top_right":return[1,0]}}get xy_anchor(){const{anchor:e}=this.model;if(!(0,m.isString)(e)){return[(()=>{const[t]=e;switch(t){case"start":case"left":return 0;case"center":return.5;case"end":case"right":return 1;default:return t}})(),(()=>{const[,t]=e;switch(t){case"start":case"top":return 0;case"center":return.5;case"end":case"bottom":return 1;default:return t}})()]}switch(e){case"top_left":return[0,0];case"top":case"top_center":return[.5,0];case"top_right":return[1,0];case"right":case"center_right":return[1,.5];case"bottom_right":return[1,1];case"bottom":case"bottom_center":return[.5,1];case"bottom_left":return[0,1];case"left":case"center_left":return[0,.5];case"center":case"center_center":return[.5,.5]}}get xy_sign(){const e=this.renderer.xscale.source_range,t=this.renderer.yscale.source_range;return[e.is_reversed?-1:1,t.is_reversed?-1:1]}_render(e,t,s){const{image_data:i,sx:r,sy:a,sw:n,sh:h}=null!=s?s:this,_=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1);const[c,o]=this.xy_sign,[g,d]=this.xy_scale,[l,m]=this.xy_offset,[u,f]=this.xy_anchor;if(this.visuals.image.doit)for(const s of t){const t=i[s],_=r[s],p=a[s],w=n[s],x=h[s];if(null==t||!isFinite(_+p+w+x))continue;const y=c*u*w,b=o*f*x;e.save(),e.translate(_-y,p-b),e.scale(c*g,o*d),this.visuals.image.set_vectorize(e,s),e.drawImage(t,-l*w,-m*x,w,x),e.restore()}e.setImageSmoothingEnabled(_)}_set_data(e){this._set_width_heigh_data();for(let t=0,s=this.image.length;t<s;t++){if(null!=e&&e.indexOf(t)<0)continue;const s=this.image.get(t);(0,l.assert)(2==s.dimension,"expected a 2D array"),this._height[t]=s.shape[0],this._width[t]=s.shape[1];const i=this._flat_img_to_buf8(s);this._set_image_data_from_buffer(t,i)}}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const[t,i,r,a]=this._lrtb(s);e.add_rect(t,a,i,r)}}_lrtb(e){const t=this.dw.get(e),s=this.dh.get(e),i=this._x[e],r=this._y[e],[a,n]=this.xy_sign,[h,_]=this.xy_anchor,[c,o]=[i-a*h*t,i+a*(1-h)*t],[g,d]=[r+n*_*s,r-n*(1-_)*s],[l,m]=c<o?[c,o]:[o,c],[u,f]=g<d?[g,d]:[d,g];return[l,m,f,u]}_set_width_heigh_data(){null!=this.image_data&&this.image_data.length==this.image.length||(this.image_data=new Array(this.image.length)),null!=this._width&&this._width.length==this.image.length||(this._width=new Uint32Array(this.image.length)),null!=this._height&&this._height.length==this.image.length||(this._height=new Uint32Array(this.image.length))}_get_or_create_canvas(e){const t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;{const t=document.createElement("canvas");return t.width=this._width[e],t.height=this._height[e],t}}_set_image_data_from_buffer(e,t){const s=this._get_or_create_canvas(e),i=s.getContext("2d"),r=i.getImageData(0,0,this._width[e],this._height[e]);r.data.set(t),i.putImageData(r,0,0),this.image_data[e]=s}_map_data(){"data"==this.model.properties.dw.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.dw,"edge",this.model.dilate):this.sw=(0,_.to_screen)(this.dw),"data"==this.model.properties.dh.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.dh,"edge",this.model.dilate):this.sh=(0,_.to_screen)(this.dh)}_image_index(e,t,s){const[i,r,a,n]=this._lrtb(e),h=this._width[e],_=this._height[e],c=(r-i)/h,o=(a-n)/_;let g=Math.floor((t-i)/c),d=Math.floor((s-n)/o);return this.renderer.xscale.source_range.is_reversed&&(g=h-g-1),this.renderer.yscale.source_range.is_reversed&&(d=_-d-1),{index:e,i:g,j:d,flat_index:d*h+g}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s),a=this.index.indices({x0:i,x1:i,y0:r,y1:r}),n=new d.Selection,h=[];for(const e of a)t!=1/0&&s!=1/0&&(h.push(e),n.image_indices.push(this._image_index(e,i,r)));return n.indices=h,n}}s.ImageBaseView=u,u.__name__="ImageBaseView";class f extends h.XYGlyph{constructor(e){super(e)}}s.ImageBase=f,n=f,f.__name__="ImageBase",n.mixins(g.ImageVector),n.define((({Boolean:e,Number:t,Or:s,Tuple:i})=>({image:[o.NDArraySpec,{field:"image"}],dw:[o.DistanceSpec,{field:"dw"}],dh:[o.DistanceSpec,{field:"dh"}],dilate:[e,!1],origin:[c.ImageOrigin,"bottom_left"],anchor:[s(c.Anchor,i(s(c.Align,c.HAlign,t),s(c.Align,c.VAlign,t))),"bottom_left"]})))},
function _(e,a,t,r,_){var n;r();const s=e(320),m=e(8);class i extends s.ImageBaseView{_flat_img_to_buf8(e){let a;return a=(0,m.isArray)(e)?new Uint32Array(e):e,new Uint8ClampedArray(a.buffer)}}t.ImageRGBAView=i,i.__name__="ImageRGBAView";class g extends s.ImageBase{constructor(e){super(e)}}t.ImageRGBA=g,n=g,g.__name__="ImageRGBA",n.prototype.default_view=i},
function _(e,t,s,r,a){r();const i=e(1);var n;const c=e(201),o=e(23),h=e(19),_=i.__importStar(e(17)),l=e(13),d=e(149);class m extends c.XYGlyphView{constructor(){super(...arguments),this._images_rendered=!1,this._set_data_iteration=0}connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,(()=>this.renderer.request_render()))}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++)e.add_empty()}_set_data(){this._set_data_iteration++;const e=this.url.length;this.image=new Array(e),this.rendered=new o.Indices(e);const{retry_attempts:t,retry_timeout:s}=this.model,{_set_data_iteration:r}=this;for(let a=0;a<e;a++){const e=this.url.get(a);if(!e)continue;const i=new d.ImageLoader(e,{loaded:()=>{this._set_data_iteration!=r||this.rendered.get(a)||this.renderer.request_render()},failed:()=>{this._set_data_iteration==r&&(this.image[a]=void 0)},attempts:t+1,timeout:s});this.image[a]=i.image}const a="data"==this.model.properties.w.units,i="data"==this.model.properties.h.units,n=this._x.length,c=new o.ScreenArray(a?2*n:n),h=new o.ScreenArray(i?2*n:n),{anchor:_}=this.model;function m(e,t){switch(_){case"top_left":case"bottom_left":case"left":case"center_left":return[e,e+t];case"top":case"top_center":case"bottom":case"bottom_center":case"center":case"center_center":return[e-t/2,e+t/2];case"top_right":case"bottom_right":case"right":case"center_right":return[e-t,e]}}function g(e,t){switch(_){case"top_left":case"top":case"top_center":case"top_right":return[e,e-t];case"bottom_left":case"bottom":case"bottom_center":case"bottom_right":return[e+t,e];case"left":case"center_left":case"center":case"center_center":case"right":case"center_right":return[e+t/2,e-t/2]}}if(a)for(let e=0;e<n;e++)[c[e],c[n+e]]=m(this._x[e],this.w.get(e));else c.set(this._x,0);if(i)for(let e=0;e<n;e++)[h[e],h[n+e]]=g(this._y[e],this.h.get(e));else h.set(this._y,0);const[u,p]=(0,l.minmax)(c),[f,w]=(0,l.minmax)(h);this._bounds_rect={x0:u,x1:p,y0:f,y1:w}}has_finished(){return super.has_finished()&&this._images_rendered}_map_data(){"data"==this.model.properties.w.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.w,"edge",this.model.dilate):this.sw=(0,o.to_screen)(this.w),"data"==this.model.properties.h.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.h,"edge",this.model.dilate):this.sh=(0,o.to_screen)(this.h)}_render(e,t,s){const{image:r,sx:a,sy:i,sw:n,sh:c,angle:o,global_alpha:h}=null!=s?s:this,{frame:_}=this.renderer.plot_view,{left:l,top:d,width:m,height:g}=_.bbox;e.beginPath(),e.rect(l+1,d+1,m-2,g-2),e.clip();let u=!0;for(const s of t){const t=r[s];isFinite(a[s]+i[s]+o.get(s)+h.get(s))&&null!=t&&(t.complete?0==t.naturalWidth&&0==t.naturalHeight||this._render_image(e,s,t,a,i,n,c,o,h):u=!1)}u&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())}_final_sx_sy(e,t,s,r,a){switch(e){case"top_left":return[t,s];case"top":case"top_center":return[t-r/2,s];case"top_right":return[t-r,s];case"right":case"center_right":return[t-r,s-a/2];case"bottom_right":return[t-r,s-a];case"bottom":case"bottom_center":return[t-r/2,s-a];case"bottom_left":return[t,s-a];case"left":case"center_left":return[t,s-a/2];case"center":case"center_center":return[t-r/2,s-a/2]}}_render_image(e,t,s,r,a,i,n,c,o){isFinite(i[t])||(i[t]=s.width),isFinite(n[t])||(n[t]=s.height);const h=i[t],_=n[t],{anchor:l}=this.model,[d,m]=this._final_sx_sy(l,r[t],a[t],h,_),g=c.get(t),u=o.get(t);e.save(),e.globalAlpha=u;const p=h/2,f=_/2;g?(e.translate(d,m),e.translate(p,f),e.rotate(g),e.translate(-p,-f),e.drawImage(s,0,0,h,_),e.translate(p,f),e.rotate(-g),e.translate(-p,-f),e.translate(-d,-m)):e.drawImage(s,d,m,h,_),e.restore(),this.rendered.set(t)}bounds(){return this._bounds_rect}}s.ImageURLView=m,m.__name__="ImageURLView";class g extends c.XYGlyph{constructor(e){super(e)}}s.ImageURL=g,n=g,g.__name__="ImageURL",n.prototype.default_view=m,n.define((({Boolean:e,Int:t})=>({url:[_.StringSpec,{field:"url"}],anchor:[h.Anchor,"top_left"],global_alpha:[_.NumberSpec,{value:1}],angle:[_.AngleSpec,0],w:[_.NullDistanceSpec,null],h:[_.NullDistanceSpec,null],dilate:[e,!1],retry_attempts:[t,0],retry_timeout:[t,0]})))},
function _(e,t,s,i,n){i();const o=e(1);var r;const l=e(104),_=e(77),c=o.__importStar(e(209)),h=o.__importStar(e(17)),a=e(13),d=e(9),x=e(202),y=e(208),g=e(100);class p extends x.GlyphView{_project_data(){l.inplace.project_xy(this._xs.array,this._ys.array)}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const t=this._xs.get(s),i=this._ys.get(s),[n,o,r,l]=(0,a.minmax2)(t,i);e.add_rect(n,r,o,l)}}_render(e,t,s){const{sxs:i,sys:n}=null!=s?s:this;for(const s of t){const t=i.get(s),o=n.get(s),r=Math.min(t.length,o.length);let l=!0;e.beginPath();for(let s=0;s<r;s++){const i=t[s],n=o[s];isFinite(i+n)?l?(e.moveTo(i,n),l=!1):e.lineTo(i,n):l=!0}this.visuals.line.set_vectorize(e,s),e.stroke()}}_hit_point(e){const t={x:e.sx,y:e.sy};let s=9999;const i=new Map;for(let e=0,n=this.sxs.length;e<n;e++){const n=Math.max(2,this.line_width.get(e)/2),o=this.sxs.get(e),r=this.sys.get(e);let l=null;for(let e=0,i=o.length-1;e<i;e++){const i={x:o[e],y:r[e]},_={x:o[e+1],y:r[e+1]},h=c.dist_to_segment(t,i,_);h<n&&h<s&&(s=h,l=[e])}null!=l&&i.set(e,l)}return new g.Selection({indices:[...i.keys()],multiline_indices:(0,d.to_object)(i)})}_hit_span(e){const{sx:t,sy:s}=e;let i,n;"v"==e.direction?(i=this.renderer.yscale.invert(s),n=this._ys):(i=this.renderer.xscale.invert(t),n=this._xs);const o=new Map;for(let e=0,t=n.length;e<t;e++){const t=n.get(e),s=[];for(let e=0,n=t.length-1;e<n;e++)t[e]<=i&&i<=t[e+1]&&s.push(e);s.length>0&&o.set(e,s)}return new g.Selection({indices:[...o.keys()],multiline_indices:(0,d.to_object)(o)})}get_interpolation_hit(e,t,s){const i=this._xs.get(e),n=this._ys.get(e),o=i[t],r=n[t],l=i[t+1],_=n[t+1];return(0,y.line_interpolation)(this.renderer,s,o,r,l,_)}draw_legend_for_index(e,t,s){(0,y.generic_line_vector_legend)(this.visuals,e,t,s)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}s.MultiLineView=p,p.__name__="MultiLineView";class u extends x.Glyph{constructor(e){super(e)}}s.MultiLine=u,r=u,u.__name__="MultiLine",r.prototype.default_view=p,r.define((({})=>({xs:[h.XCoordinateSeqSpec,{field:"xs"}],ys:[h.YCoordinateSeqSpec,{field:"ys"}]}))),r.mixins(_.LineVector)},
function _(t,e,s,n,i){n();const o=t(1);var r;const l=t(204),h=t(202),a=t(208),_=t(13),c=t(13),d=t(77),x=o.__importStar(t(209)),y=o.__importStar(t(17)),f=t(100),g=t(12);class p extends h.GlyphView{_project_data(){}_index_data(t){const{min:e,max:s}=Math,{data_size:n}=this;for(let i=0;i<n;i++){const n=this._xs[i],o=this._ys[i];if(0==n.length||0==o.length){t.add_empty();continue}let r=1/0,l=-1/0,h=1/0,a=-1/0;for(let t=0,i=n.length;t<i;t++){const i=n[t][0],c=o[t][0];if(0!=i.length&&0!=c.length){const[t,n]=(0,_.minmax)(i),[o,d]=(0,_.minmax)(c);r=e(r,t),l=s(l,n),h=e(h,o),a=s(a,d)}}t.add_rect(r,h,l,a)}this._hole_index=this._index_hole_data()}_index_hole_data(){const{min:t,max:e}=Math,{data_size:s}=this,n=new l.SpatialIndex(s);for(let i=0;i<s;i++){const s=this._xs[i],o=this._ys[i];if(0==s.length||0==o.length){n.add_empty();continue}let r=1/0,l=-1/0,h=1/0,a=-1/0;for(let n=0,i=s.length;n<i;n++){const i=s[n],c=o[n];if(i.length>1&&c.length>1)for(let s=1,n=i.length;s<n;s++){const[n,o]=(0,_.minmax)(i[s]),[d,x]=(0,_.minmax)(c[s]);r=t(r,n),l=e(l,o),h=t(h,d),a=e(a,x)}}n.add_rect(r,h,l,a)}return n.finish(),n}_mask_data(){const{x_range:t,y_range:e}=this.renderer.plot_view.frame;return this.index.indices({x0:t.min,x1:t.max,y0:e.min,y1:e.max})}_render(t,e,s){if(!this.visuals.fill.doit&&!this.visuals.line.doit)return;const{sxs:n,sys:i}=null!=s?s:this;for(const s of e){t.beginPath();const e=n[s],o=i[s],r=Math.min(e.length,o.length);for(let s=0;s<r;s++){const n=e[s],i=o[s],r=Math.min(n.length,i.length);for(let e=0;e<r;e++){const s=n[e],o=i[e],r=Math.min(s.length,o.length);for(let e=0;e<r;e++){const n=s[e],i=o[e];0==e?t.moveTo(n,i):t.lineTo(n,i)}t.closePath()}}this.visuals.fill.apply(t,s,"evenodd"),this.visuals.hatch.apply(t,s,"evenodd"),this.visuals.line.apply(t,s)}}_hit_rect(t){const{sx0:e,sx1:s,sy0:n,sy1:i}=t,o=[e,s,s,e],r=[n,n,i,i],[l,h]=this.renderer.xscale.r_invert(e,s),[a,_]=this.renderer.yscale.r_invert(n,i),c=this.index.indices({x0:l,x1:h,y0:a,y1:_}),d=[];for(const t of c){const e=this.sxs[t],s=this.sys[t];let n=!0;for(let t=0,i=e.length;t<i;t++){for(let i=0,l=e[t][0].length;i<l;i++){const l=e[t][0][i],h=s[t][0][i];if(!x.point_in_poly(l,h,o,r)){n=!1;break}}if(!n)break}n&&d.push(t)}return new f.Selection({indices:d})}_hit_point(t){const{sx:e,sy:s}=t,n=this.renderer.xscale.invert(e),i=this.renderer.yscale.invert(s),o=this.index.indices({x0:n,y0:i,x1:n,y1:i}),r=this._hole_index.indices({x0:n,y0:i,x1:n,y1:i}),l=[];for(const t of o){const n=this.sxs[t],i=this.sys[t];for(let o=0,h=n.length;o<h;o++){const h=n[o].length;if(x.point_in_poly(e,s,n[o][0],i[o][0]))if(1==h)l.push(t);else if(r.get(t)){if(h>1){let r=!1;for(let t=1;t<h;t++){const l=n[o][t],h=i[o][t];if(x.point_in_poly(e,s,l,h)){r=!0;break}}r||l.push(t)}}else l.push(t)}}return new f.Selection({indices:l})}_get_snap_coord(t){return(0,c.sum)(t)/t.length}scenterxy(t,e,s){if(1==this.sxs[t].length){return[this._get_snap_coord(this.sxs[t][0][0]),this._get_snap_coord(this.sys[t][0][0])]}{const n=this.sxs[t],i=this.sys[t];for(let t=0,o=n.length;t<o;t++)if(x.point_in_poly(e,s,n[t][0],i[t][0])){return[this._get_snap_coord(n[t][0]),this._get_snap_coord(i[t][0])]}}(0,g.unreachable)()}map_data(){const t=this._xs.length;this.sxs=new Array(t),this.sys=new Array(t);for(let e=0;e<t;e++){const t=this._xs[e].length;this.sxs[e]=new Array(t),this.sys[e]=new Array(t);for(let s=0;s<t;s++){const t=this._xs[e][s].length;this.sxs[e][s]=new Array(t),this.sys[e][s]=new Array(t);for(let n=0;n<t;n++){const[t,i]=this.renderer.coordinates.map_to_screen(this._xs[e][s][n],this._ys[e][s][n]);this.sxs[e][s][n]=t,this.sys[e][s][n]=i}}}}draw_legend_for_index(t,e,s){(0,a.generic_area_vector_legend)(this.visuals,t,e,s)}}s.MultiPolygonsView=p,p.__name__="MultiPolygonsView";class m extends h.Glyph{constructor(t){super(t)}}s.MultiPolygons=m,r=m,m.__name__="MultiPolygons",r.prototype.default_view=p,r.define((({})=>({xs:[y.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[y.YCoordinateSeqSeqSeqSpec,{field:"ys"}]}))),r.mixins([d.LineVector,d.FillVector,d.HatchVector])},
function _(e,t,s,i,n){i();const r=e(1);var a;const o=e(202),c=e(208),_=e(13),h=e(77),l=r.__importStar(e(209)),d=r.__importStar(e(17)),y=e(100),p=e(12),x=e(104);class f extends o.GlyphView{_project_data(){x.inplace.project_xy(this._xs.array,this._ys.array)}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const t=this._xs.get(s),i=this._ys.get(s),[n,r,a,o]=(0,_.minmax2)(t,i);e.add_rect(n,a,r,o)}}_mask_data(){const{x_range:e,y_range:t}=this.renderer.plot_view.frame;return this.index.indices({x0:e.min,x1:e.max,y0:t.min,y1:t.max})}_render(e,t,s){const{sxs:i,sys:n}=null!=s?s:this;for(const s of t){const t=i.get(s),r=n.get(s);let a=!0;e.beginPath();const o=Math.min(t.length,r.length);for(let s=0;s<o;s++){const i=t[s],n=r[s];isFinite(i+n)?a?(e.moveTo(i,n),a=!1):e.lineTo(i,n):(e.closePath(),a=!0)}e.closePath(),this.visuals.fill.apply(e,s),this.visuals.hatch.apply(e,s),this.visuals.line.apply(e,s)}}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,r=[t,s,s,t],a=[i,i,n,n],[o,c]=this.renderer.xscale.r_invert(t,s),[_,h]=this.renderer.yscale.r_invert(i,n),d=this.index.indices({x0:o,x1:c,y0:_,y1:h}),p=[];for(const e of d){const t=this.sxs.get(e),s=this.sys.get(e);let i=!0;for(let e=0,n=t.length;e<n;e++){const n=t[e],o=s[e];if(!l.point_in_poly(n,o,r,a)){i=!1;break}}i&&p.push(e)}return new y.Selection({indices:p})}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(s),r=this.index.indices({x0:i,y0:n,x1:i,y1:n}),a=[];for(const e of r){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;for(let o=0,c=0;;c++){if(isNaN(i[c])||c==r){const r=i.subarray(o,c),_=n.subarray(o,c);if(l.point_in_poly(t,s,r,_)){a.push(e);break}o=c+1}if(c==r)break}}return new y.Selection({indices:a})}_get_snap_coord(e){return(0,_.sum)(e)/e.length}scenterxy(e,t,s){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;let a=!1;for(let e=0,o=0;;o++){const c=isNaN(i[o]);if(a=a||c,o==r&&!a){return[this._get_snap_coord(i),this._get_snap_coord(n)]}if(c||o==r){const r=i.subarray(e,o),a=n.subarray(e,o);if(l.point_in_poly(t,s,r,a)){return[this._get_snap_coord(r),this._get_snap_coord(a)]}e=o+1}if(o==r)break}(0,p.unreachable)()}draw_legend_for_index(e,t,s){(0,c.generic_area_vector_legend)(this.visuals,e,t,s)}}s.PatchesView=f,f.__name__="PatchesView";class g extends o.Glyph{constructor(e){super(e)}}s.Patches=g,a=g,g.__name__="Patches",a.prototype.default_view=f,a.define((({})=>({xs:[d.XCoordinateSeqSpec,{field:"xs"}],ys:[d.YCoordinateSeqSpec,{field:"ys"}]}))),a.mixins([h.LineVector,h.FillVector,h.HatchVector])},
function _(t,e,i,r,o){r();const s=t(1);var a;const n=t(313),l=s.__importStar(t(17));class _ extends n.LRTBView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:i}=await Promise.resolve().then((()=>s.__importStar(t(508))));this.glglyph=new i(e.regl_wrapper,this)}}scenterxy(t){return[this.sleft[t]/2+this.sright[t]/2,this.stop[t]/2+this.sbottom[t]/2]}_lrtb(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]}}i.QuadView=_,_.__name__="QuadView";class p extends n.LRTB{constructor(t){super(t)}}i.Quad=p,a=p,p.__name__="Quad",a.prototype.default_view=_,a.define((({})=>({right:[l.XCoordinateSpec,{field:"right"}],bottom:[l.YCoordinateSpec,{field:"bottom"}],left:[l.XCoordinateSpec,{field:"left"}],top:[l.YCoordinateSpec,{field:"top"}]})))},
function _(e,t,i,n,s){n();const c=e(1);var o;const r=e(77),a=e(104),_=e(202),d=e(208),l=c.__importStar(e(17));function x(e,t,i){if(t==(e+i)/2)return[e,i];{const n=(e-t)/(e-2*t+i),s=e*(1-n)**2+2*t*(1-n)*n+i*n**2;return[Math.min(e,i,s),Math.max(e,i,s)]}}class y extends _.GlyphView{_project_data(){a.inplace.project_xy(this._x0,this._y0),a.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{_x0:t,_x1:i,_y0:n,_y1:s,_cx:c,_cy:o,data_size:r}=this;for(let a=0;a<r;a++){const r=t[a],_=i[a],d=n[a],l=s[a],y=c[a],p=o[a];if(isFinite(r+_+d+l+y+p)){const[t,i]=x(r,y,_),[n,s]=x(d,p,l);e.add_rect(t,n,i,s)}else e.add_empty()}}_render(e,t,i){if(!this.visuals.line.doit)return;const{sx0:n,sy0:s,sx1:c,sy1:o,scx:r,scy:a}=null!=i?i:this;for(const i of t){const t=n[i],_=s[i],d=c[i],l=o[i],x=r[i],y=a[i];isFinite(t+_+d+l+x+y)&&(e.beginPath(),e.moveTo(t,_),e.quadraticCurveTo(x,y,d,l),this.visuals.line.apply(e,i))}}draw_legend_for_index(e,t,i){(0,d.generic_line_vector_legend)(this.visuals,e,t,i)}scenterxy(){throw new Error(`${this}.scenterxy() is not implemented`)}}i.QuadraticView=y,y.__name__="QuadraticView";class p extends _.Glyph{constructor(e){super(e)}}i.Quadratic=p,o=p,p.__name__="Quadratic",o.prototype.default_view=y,o.define((({})=>({x0:[l.XCoordinateSpec,{field:"x0"}],y0:[l.YCoordinateSpec,{field:"y0"}],x1:[l.XCoordinateSpec,{field:"x1"}],y1:[l.YCoordinateSpec,{field:"y1"}],cx:[l.XCoordinateSpec,{field:"cx"}],cy:[l.YCoordinateSpec,{field:"cy"}]}))),o.mixins(r.LineVector)},
function _(e,t,s,n,i){n();const l=e(1);var a;const r=e(201),h=e(208),o=e(77),_=e(23),c=l.__importStar(e(17));class g extends r.XYGlyphView{_map_data(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this.length):this.slength=(0,_.to_screen)(this.length);const{width:e,height:t}=this.renderer.plot_view.frame.bbox,s=2*(e+t),{slength:n}=this;for(let e=0,t=n.length;e<t;e++)0==n[e]&&(n[e]=s)}_render(e,t,s){if(!this.visuals.line.doit)return;const{sx:n,sy:i,slength:l,angle:a}=null!=s?s:this;for(const s of t){const t=n[s],r=i[s],h=a.get(s),o=l[s];isFinite(t+r+h+o)&&(e.translate(t,r),e.rotate(h),e.beginPath(),e.moveTo(0,0),e.lineTo(o,0),this.visuals.line.apply(e,s),e.rotate(-h),e.translate(-t,-r))}}draw_legend_for_index(e,t,s){(0,h.generic_line_vector_legend)(this.visuals,e,t,s)}}s.RayView=g,g.__name__="RayView";class d extends r.XYGlyph{constructor(e){super(e)}}s.Ray=d,a=d,d.__name__="Ray",a.prototype.default_view=g,a.mixins(o.LineVector),a.define((({})=>({length:[c.DistanceSpec,0],angle:[c.AngleSpec,0]})))},
function _(t,e,s,i,r){var n,h=this&&this.__createBinding||(Object.create?function(t,e,s,i){void 0===i&&(i=s);var r=Object.getOwnPropertyDescriptor(e,s);r&&!("get"in r?!e.__esModule:r.writable||r.configurable)||(r={enumerable:!0,get:function(){return e[s]}}),Object.defineProperty(t,i,r)}:function(t,e,s,i){void 0===i&&(i=s),t[i]=e[s]}),a=this&&this.__setModuleDefault||(Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e}),l=this&&this.__importStar||function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var s in t)"default"!==s&&Object.prototype.hasOwnProperty.call(t,s)&&h(e,t,s);return a(e,t),e};i();const o=t(316),c=t(208),_=t(23),d=t(13),f=t(100);class u extends o.CenterRotatableView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{RectGL:s}=await Promise.resolve().then((()=>l(t(510))));this.glglyph=new s(e.regl_wrapper,this)}}_map_data(){if("data"==this.model.properties.width.units)[this.sw,this.sx0]=this._map_dist_corner_for_data_side_length(this._x,this.width,this.renderer.xscale);else{this.sw=(0,_.to_screen)(this.width);const t=this.sx.length;this.sx0=new _.ScreenArray(t);for(let e=0;e<t;e++)this.sx0[e]=this.sx[e]-this.sw[e]/2}if("data"==this.model.properties.height.units)[this.sh,this.sy1]=this._map_dist_corner_for_data_side_length(this._y,this.height,this.renderer.yscale);else{this.sh=(0,_.to_screen)(this.height);const t=this.sy.length;this.sy1=new _.ScreenArray(t);for(let e=0;e<t;e++)this.sy1[e]=this.sy[e]-this.sh[e]/2}const t=this.sw.length;this.ssemi_diag=new _.ScreenArray(t);for(let e=0;e<t;e++)this.ssemi_diag[e]=Math.sqrt(this.sw[e]/2*this.sw[e]/2+this.sh[e]/2*this.sh[e]/2)}_render(t,e,s){const{sx:i,sy:r,sx0:n,sy1:h,sw:a,sh:l,angle:o}=null!=s?s:this;for(const s of e){const e=i[s],c=r[s],_=n[s],d=h[s],f=a[s],u=l[s],y=o.get(s);isFinite(e+c+_+d+f+u+y)&&(0!=f&&0!=u&&(t.beginPath(),y?(t.translate(e,c),t.rotate(y),t.rect(-f/2,-u/2,f,u),t.rotate(-y),t.translate(-e,-c)):t.rect(_,d,f,u),this.visuals.fill.apply(t,s),this.visuals.hatch.apply(t,s),this.visuals.line.apply(t,s)))}}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){let{sx:e,sy:s}=t;const i=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(s),n=this.sx0.length,h=new _.ScreenArray(n);for(let t=0;t<n;t++)h[t]=this.sx0[t]+this.sw[t]/2;const a=new _.ScreenArray(n);for(let t=0;t<n;t++)a[t]=this.sy1[t]+this.sh[t]/2;const l=(0,d.max)(this._ddist(0,h,this.ssemi_diag)),o=(0,d.max)(this._ddist(1,a,this.ssemi_diag)),c=i-l,u=i+l,y=r-o,w=r+o;let g,p;const x=[];for(const t of this.index.indices({x0:c,x1:u,y0:y,y1:w})){const i=this.angle.get(t);if(i){const r=Math.sin(-i),n=Math.cos(-i),h=n*(e-this.sx[t])-r*(s-this.sy[t])+this.sx[t],a=r*(e-this.sx[t])+n*(s-this.sy[t])+this.sy[t];e=h,s=a,g=Math.abs(this.sx[t]-e)<=this.sw[t]/2,p=Math.abs(this.sy[t]-s)<=this.sh[t]/2}else{const i=e-this.sx0[t],r=s-this.sy1[t];g=0<=i&&i<=this.sw[t],p=0<=r&&r<=this.sh[t]}g&&p&&x.push(t)}return new f.Selection({indices:x})}_map_dist_corner_for_data_side_length(t,e,s){const i=t.length,r=new Float64Array(i),n=new Float64Array(i);for(let s=0;s<i;s++){const i=t[s],h=e.get(s)/2;r[s]=i-h,n[s]=i+h}const h=s.v_compute(r),a=s.v_compute(n),l=this.sdist(s,r,e,"edge",this.model.dilate);let o=h;for(let t=0;t<i;t++){const e=h[t],s=a[t];if(!isNaN(e+s)&&e!=s){o=e<s?h:a;break}}return[l,o]}_ddist(t,e,s){const i=(0,_.infer_type)(e,s),r=0==t?this.renderer.xscale:this.renderer.yscale,n=e,h=n.length,a=new i(h);for(let t=0;t<h;t++)a[t]=n[t]+s[t];const l=r.v_invert(n),o=r.v_invert(a),c=l.length,d=new i(c);for(let t=0;t<c;t++)d[t]=Math.abs(o[t]-l[t]);return d}draw_legend_for_index(t,e,s){(0,c.generic_area_vector_legend)(this.visuals,t,e,s)}}s.RectView=u,u.__name__="RectView";class y extends o.CenterRotatable{constructor(t){super(t)}}s.Rect=y,n=y,y.__name__="Rect",n.prototype.default_view=u,n.define((({Boolean:t})=>({dilate:[t,!1]})))},
function _(e,t,r,a,s){a();const i=e(1);var n;const l=e(331),_=e(332),c=i.__importStar(e(17));class o extends l.MarkerView{async lazy_initialize(){await super.lazy_initialize();const{webgl:t}=this.renderer.plot_view.canvas_view;if(null!=t&&t.regl_wrapper.has_webgl){const{MultiMarkerGL:r}=await Promise.resolve().then((()=>i.__importStar(e(509))));this.glglyph=new r(t.regl_wrapper,this)}}_render(e,t,r){const{sx:a,sy:s,size:i,angle:n,marker:l}=null!=r?r:this;for(const r of t){const t=a[r],c=s[r],o=i.get(r),g=n.get(r),w=l.get(r);if(!isFinite(t+c+o+g)||null==w)continue;const p=o/2;e.beginPath(),e.translate(t,c),g&&e.rotate(g),_.marker_funcs[w](e,r,p,this.visuals),g&&e.rotate(-g),e.translate(-t,-c)}}draw_legend_for_index(e,{x0:t,x1:r,y0:a,y1:s},i){const n=i+1,l=this.marker.get(i),_=Object.assign(Object.assign({},this._get_legend_args({x0:t,x1:r,y0:a,y1:s},i)),{marker:new c.UniformScalar(l,n)});this._render(e,[i],_)}}r.ScatterView=o,o.__name__="ScatterView";class g extends l.Marker{constructor(e){super(e)}}r.Scatter=g,n=g,g.__name__="Scatter",n.prototype.default_view=o,n.define((()=>({marker:[c.MarkerSpec,{value:"circle"}]})))},
function _(e,t,s,n,i){n();const r=e(1);var a;const c=e(201),o=e(77),_=r.__importStar(e(209)),h=r.__importStar(e(17)),l=e(10),x=e(100);class d extends c.XYGlyphView{_render(e,t,s){const{sx:n,sy:i,size:r,angle:a}=null!=s?s:this;for(const s of t){const t=n[s],c=i[s],o=r.get(s),_=a.get(s);if(!isFinite(t+c+o+_))continue;const h=o/2;e.beginPath(),e.translate(t,c),_&&e.rotate(_),this._render_one(e,s,h,this.visuals),_&&e.rotate(-_),e.translate(-t,-c)}}_mask_data(){const{x_target:e,y_target:t}=this.renderer.plot_view.frame,s=e.widen(this.max_size).map((e=>this.renderer.xscale.invert(e))),n=t.widen(this.max_size).map((e=>this.renderer.yscale.invert(e)));return this.index.indices({x0:s.start,x1:s.end,y0:n.start,y1:n.end})}_hit_point(e){const{sx:t,sy:s}=e,{max_size:n}=this,{hit_dilation:i}=this.model,r=t-n*i,a=t+n*i,[c,o]=this.renderer.xscale.r_invert(r,a),_=s-n*i,h=s+n*i,[l,d]=this.renderer.yscale.r_invert(_,h),y=this.index.indices({x0:c,x1:o,y0:l,y1:d}),g=[];for(const e of y){const n=this.size.get(e)/2*i;Math.abs(this.sx[e]-t)<=n&&Math.abs(this.sy[e]-s)<=n&&g.push(e)}return new x.Selection({indices:g})}_hit_span(e){const{sx:t,sy:s}=e,n=this.bounds(),i=this.max_size/2;let r,a,c,o;if("h"==e.direction){c=n.y0,o=n.y1;const e=t-i,s=t+i;[r,a]=this.renderer.xscale.r_invert(e,s)}else{r=n.x0,a=n.x1;const e=s-i,t=s+i;[c,o]=this.renderer.yscale.r_invert(e,t)}const _=[...this.index.indices({x0:r,x1:a,y0:c,y1:o})];return new x.Selection({indices:_})}_hit_rect(e){const{sx0:t,sx1:s,sy0:n,sy1:i}=e,[r,a]=this.renderer.xscale.r_invert(t,s),[c,o]=this.renderer.yscale.r_invert(n,i),_=[...this.index.indices({x0:r,x1:a,y0:c,y1:o})];return new x.Selection({indices:_})}_hit_poly(e){const{sx:t,sy:s}=e,n=(0,l.range)(0,this.sx.length),i=[];for(let e=0,r=n.length;e<r;e++){const r=n[e];_.point_in_poly(this.sx[e],this.sy[e],t,s)&&i.push(r)}return new x.Selection({indices:i})}_get_legend_args({x0:e,x1:t,y0:s,y1:n},i){const r=i+1,a=new Array(r),c=new Array(r);a[i]=(e+t)/2,c[i]=(s+n)/2;const o=.4*Math.min(Math.abs(t-e),Math.abs(n-s));return{sx:a,sy:c,size:new h.UniformScalar(o,r),angle:new h.UniformScalar(0,r)}}draw_legend_for_index(e,{x0:t,x1:s,y0:n,y1:i},r){const a=this._get_legend_args({x0:t,x1:s,y0:n,y1:i},r);this._render(e,[r],a)}}s.MarkerView=d,d.__name__="MarkerView";class y extends c.XYGlyph{constructor(e){super(e)}}s.Marker=y,a=y,y.__name__="Marker",a.mixins([o.LineVector,o.FillVector,o.HatchVector]),a.define((({Number:e})=>({size:[h.ScreenSizeSpec,{value:4}],angle:[h.AngleSpec,0],hit_dilation:[e,1]})))},
function _(l,n,o,i,a){i();const t=Math.sqrt(3),e=Math.sqrt(5),p=(e+1)/4,c=Math.sqrt((5-e)/8),h=(e-1)/4,u=Math.sqrt((5+e)/8);function f(l,n){l.rotate(Math.PI/4),y(l,n),l.rotate(-Math.PI/4)}function r(l,n){const o=n*t,i=o/3;l.moveTo(-o/2,-i),l.lineTo(0,0),l.lineTo(o/2,-i),l.lineTo(0,0),l.lineTo(0,n)}function y(l,n){l.moveTo(0,n),l.lineTo(0,-n),l.moveTo(-n,0),l.lineTo(n,0)}function T(l,n){l.moveTo(0,n),l.lineTo(n/1.5,0),l.lineTo(0,-n),l.lineTo(-n/1.5,0),l.closePath()}function s(l,n){const o=n*t,i=o/3;l.moveTo(-n,i),l.lineTo(n,i),l.lineTo(0,i-o),l.closePath()}function v(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function d(l,n,o,i){T(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function P(l,n,o,i){!function(l,n){l.beginPath(),l.arc(0,0,n/4,0,2*Math.PI,!1),l.closePath()}(l,o),i.line.set_vectorize(l,n),l.fillStyle=l.strokeStyle,l.fill()}function m(l,n,o,i){!function(l,n){const o=n/2,i=t*o;l.moveTo(n,0),l.lineTo(o,-i),l.lineTo(-o,-i),l.lineTo(-n,0),l.lineTo(-o,i),l.lineTo(o,i),l.closePath()}(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function _(l,n,o,i){const a=2*o;l.rect(-o,-o,a,a),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function q(l,n,o,i){!function(l,n){const o=Math.sqrt(5-2*e)*n;l.moveTo(0,-n),l.lineTo(o*h,o*u-n),l.lineTo(o*(1+h),o*u-n),l.lineTo(o*(1+h-p),o*(u+c)-n),l.lineTo(o*(1+2*h-p),o*(2*u+c)-n),l.lineTo(0,2*o*u-n),l.lineTo(-o*(1+2*h-p),o*(2*u+c)-n),l.lineTo(-o*(1+h-p),o*(u+c)-n),l.lineTo(-o*(1+h),o*u-n),l.lineTo(-o*h,o*u-n),l.closePath()}(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}function M(l,n,o,i){s(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)}o.marker_funcs={asterisk:function(l,n,o,i){y(l,o),f(l,o),i.line.apply(l,n)},circle:v,circle_cross:function(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),y(l,o),i.line.apply(l,n)},circle_dot:function(l,n,o,i){v(l,n,o,i),P(l,n,o,i)},circle_y:function(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),r(l,o),i.line.apply(l,n)},circle_x:function(l,n,o,i){l.arc(0,0,o,0,2*Math.PI,!1),i.fill.apply(l,n),i.hatch.apply(l,n),f(l,o),i.line.apply(l,n)},cross:function(l,n,o,i){y(l,o),i.line.apply(l,n)},diamond:d,diamond_dot:function(l,n,o,i){d(l,n,o,i),P(l,n,o,i)},diamond_cross:function(l,n,o,i){T(l,o),i.fill.apply(l,n),i.hatch.apply(l,n),l.moveTo(0,o),l.lineTo(0,-o),l.moveTo(-o/1.5,0),l.lineTo(o/1.5,0),i.line.apply(l,n)},dot:P,hex:m,hex_dot:function(l,n,o,i){m(l,n,o,i),P(l,n,o,i)},inverted_triangle:function(l,n,o,i){l.rotate(Math.PI),s(l,o),l.rotate(-Math.PI),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},plus:function(l,n,o,i){const a=3*o/8,t=[a,a,o,o,a,a,-a,-a,-o,-o,-a,-a],e=[o,a,a,-a,-a,-o,-o,-a,-a,a,a,o];l.beginPath();for(let n=0;n<12;n++)l.lineTo(t[n],e[n]);l.closePath(),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},square:_,square_cross:function(l,n,o,i){const a=2*o;l.rect(-o,-o,a,a),i.fill.apply(l,n),i.hatch.apply(l,n),y(l,o),i.line.apply(l,n)},square_dot:function(l,n,o,i){_(l,n,o,i),P(l,n,o,i)},square_pin:function(l,n,o,i){const a=3*o/8;l.moveTo(-o,-o),l.quadraticCurveTo(0,-a,o,-o),l.quadraticCurveTo(a,0,o,o),l.quadraticCurveTo(0,a,-o,o),l.quadraticCurveTo(-a,0,-o,-o),l.closePath(),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},square_x:function(l,n,o,i){const a=2*o;l.rect(-o,-o,a,a),i.fill.apply(l,n),i.hatch.apply(l,n),l.moveTo(-o,o),l.lineTo(o,-o),l.moveTo(-o,-o),l.lineTo(o,o),i.line.apply(l,n)},star:q,star_dot:function(l,n,o,i){q(l,n,o,i),P(l,n,o,i)},triangle:M,triangle_dot:function(l,n,o,i){M(l,n,o,i),P(l,n,o,i)},triangle_pin:function(l,n,o,i){const a=o*t,e=a/3,p=3*e/8;l.moveTo(-o,e),l.quadraticCurveTo(0,p,o,e),l.quadraticCurveTo(t*p/2,p/2,0,e-a),l.quadraticCurveTo(-t*p/2,p/2,-o,e),l.closePath(),i.fill.apply(l,n),i.hatch.apply(l,n),i.line.apply(l,n)},dash:function(l,n,o,i){!function(l,n){l.moveTo(-n,0),l.lineTo(n,0)}(l,o),i.line.apply(l,n)},x:function(l,n,o,i){f(l,o),i.line.apply(l,n)},y:function(l,n,o,i){r(l,o),i.line.apply(l,n)}}},
function _(e,t,s,i,n){i();const r=e(1);var o;const a=r.__importStar(e(209)),_=r.__importStar(e(17)),d=e(77),h=e(104),c=e(11),x=e(202),l=e(208),y=e(100);class p extends x.GlyphView{_project_data(){h.inplace.project_xy(this._x0,this._y0),h.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{min:t,max:s}=Math,{_x0:i,_x1:n,_y0:r,_y1:o,data_size:a}=this;for(let _=0;_<a;_++){const a=i[_],d=n[_],h=r[_],c=o[_];e.add_rect(t(a,d),t(h,c),s(a,d),s(h,c))}}_render(e,t,s){if(!this.visuals.line.doit)return;const{sx0:i,sy0:n,sx1:r,sy1:o}=null!=s?s:this;for(const s of t){const t=i[s],a=n[s],_=r[s],d=o[s];isFinite(t+a+_+d)&&(this._render_decorations(e,s,t,a,_,d),e.beginPath(),e.moveTo(t,a),e.lineTo(_,d),this.visuals.line.apply(e,s))}}_render_decorations(e,t,s,i,n,r){const{PI:o}=Math,a=(0,c.atan2)([s,i],[n,r])+o/2;for(const _ of this.decorations.values())e.save(),"start"==_.model.node?(e.translate(s,i),e.rotate(a+o)):"end"==_.model.node&&(e.translate(n,r),e.rotate(a)),_.marking.render(e,t),e.restore()}_hit_point(e){const{sx:t,sy:s}=e,i={x:t,y:s},[n,r]=this.renderer.xscale.r_invert(t-2,t+2),[o,_]=this.renderer.yscale.r_invert(s-2,s+2),d=this.index.indices({x0:n,y0:o,x1:r,y1:_}),h=[];for(const e of d){const t=Math.max(2,this.line_width.get(e)/2)**2,s={x:this.sx0[e],y:this.sy0[e]},n={x:this.sx1[e],y:this.sy1[e]};a.dist_to_segment_squared(i,s,n)<t&&h.push(e)}return new y.Selection({indices:h})}_hit_span(e){const[t,s]=this.renderer.plot_view.frame.bbox.ranges,{sx:i,sy:n}=e;let r,o,a;"v"==e.direction?(a=this.renderer.yscale.invert(n),[r,o]=[this._y0,this._y1]):(a=this.renderer.xscale.invert(i),[r,o]=[this._x0,this._x1]);const _=[],[d,h]=this.renderer.xscale.r_invert(t.start,t.end),[c,x]=this.renderer.yscale.r_invert(s.start,s.end),l=this.index.indices({x0:d,y0:c,x1:h,y1:x});for(const t of l){(r[t]<=a&&a<=o[t]||o[t]<=a&&a<=r[t])&&_.push(t);const s=1.5+this.line_width.get(t)/2;r[t]==o[t]&&("h"==e.direction?Math.abs(this.sx0[t]-i)<=s&&_.push(t):Math.abs(this.sy0[t]-n)<=s&&_.push(t))}return new y.Selection({indices:_})}scenterxy(e){return[this.sx0[e]/2+this.sx1[e]/2,this.sy0[e]/2+this.sy1[e]/2]}draw_legend_for_index(e,t,s){(0,l.generic_line_vector_legend)(this.visuals,e,t,s)}}s.SegmentView=p,p.__name__="SegmentView";class f extends x.Glyph{constructor(e){super(e)}}s.Segment=f,o=f,f.__name__="Segment",o.prototype.default_view=p,o.define((({})=>({x0:[_.XCoordinateSpec,{field:"x0"}],y0:[_.YCoordinateSpec,{field:"y0"}],x1:[_.XCoordinateSpec,{field:"x1"}],y1:[_.YCoordinateSpec,{field:"y1"}]}))),o.mixins(d.LineVector)},
function _(t,e,s,i,n){i();const o=t(1);var _;const l=t(201),a=o.__importStar(t(77)),c=t(335);class r extends l.XYGlyphView{_set_data(){const{tension:t,closed:e}=this.model;[this._xt,this._yt]=(0,c.catmullrom_spline)(this._x,this._y,20,t,e)}_map_data(){const{x_scale:t,y_scale:e}=this.renderer.coordinates;this.sxt=t.v_compute(this._xt),this.syt=e.v_compute(this._yt)}_render(t,e,s){const{sxt:i,syt:n}=null!=s?s:this;let o=!0;t.beginPath();const _=i.length;for(let e=0;e<_;e++){const s=i[e],_=n[e];isFinite(s+_)?o?(t.moveTo(s,_),o=!1):t.lineTo(s,_):o=!0}this.visuals.line.set_value(t),t.stroke()}}s.SplineView=r,r.__name__="SplineView";class h extends l.XYGlyph{constructor(t){super(t)}}s.Spline=h,_=h,h.__name__="Spline",_.prototype.default_view=r,_.mixins(a.LineScalar),_.define((({Boolean:t,Number:e})=>({tension:[e,.5],closed:[t,!1]})))},
function _(n,t,e,o,s){o();const c=n(23),l=n(12);e.catmullrom_spline=function(n,t,e=10,o=.5,s=!1){(0,l.assert)(n.length==t.length);const r=n.length,f=s?r+1:r,w=(0,c.infer_type)(n,t),i=new w(f+2),u=new w(f+2);i.set(n,1),u.set(t,1),s?(i[0]=n[r-1],u[0]=t[r-1],i[f]=n[0],u[f]=t[0],i[f+1]=n[1],u[f+1]=t[1]):(i[0]=n[0],u[0]=t[0],i[f+1]=n[r-1],u[f+1]=t[r-1]);const g=new w(4*(e+1));for(let n=0,t=0;n<=e;n++){const o=n/e,s=o**2,c=o*s;g[t++]=2*c-3*s+1,g[t++]=-2*c+3*s,g[t++]=c-2*s+o,g[t++]=c-s}const h=new w((f-1)*(e+1)),_=new w((f-1)*(e+1));for(let n=1,t=0;n<f;n++){const s=(i[n+1]-i[n-1])*o,c=(u[n+1]-u[n-1])*o,l=(i[n+2]-i[n])*o,r=(u[n+2]-u[n])*o;for(let o=0;o<=4*e;t++){const e=g[o++],f=g[o++],w=g[o++],a=g[o++];h[t]=e*i[n]+f*i[n+1]+w*s+a*l,_[t]=e*u[n]+f*u[n+1]+w*c+a*r}}return[h,_]}},
function _(e,t,r,i,n){i();const s=e(1);var _;const a=e(201),l=e(208),o=s.__importStar(e(77)),c=e(19),h=e(12);class d extends a.XYGlyphView{async lazy_initialize(){await super.lazy_initialize();const{webgl:t}=this.renderer.plot_view.canvas_view;if(null!=t&&t.regl_wrapper.has_webgl){const{StepGL:r}=await Promise.resolve().then((()=>s.__importStar(e(511))));this.glglyph=new r(t.regl_wrapper,this)}}_render(e,t,r){const i=t.length;if(i<2)return;const{sx:n,sy:s}=null!=r?r:this,_=this.model.mode;this.visuals.line.set_value(e);let a=!1,l=!1;const o=t[0];let c=isFinite(n[o]+s[o]);"center"==_&&(a=this._render_xy(e,a,c?n[o]:NaN,s[o]));for(const r of t){const t=isFinite(n[r+1]+s[r+1]);switch(_){case"before":a=this._render_xy(e,a,c?n[r]:NaN,s[r]),r<n.length-1&&(a=this._render_xy(e,a,c&&t?n[r]:NaN,s[r+1]));break;case"after":a=this._render_xy(e,a,c?n[r]:NaN,s[r]),r<n.length-1&&(a=this._render_xy(e,a,c&&t?n[r+1]:NaN,s[r]));break;case"center":if(c&&t){const t=(n[r]+n[r+1])/2;a=this._render_xy(e,a,t,s[r]),a=this._render_xy(e,a,t,s[r+1])}else l&&(a=this._render_xy(e,a,c?n[r]:NaN,s[r])),a=this._render_xy(e,a,t?n[r+1]:NaN,s[r+1]);break;default:(0,h.unreachable)()}l=c,c=t}if(a){const r=t[i-1];this._render_xy(e,a,c?n[r]:NaN,s[r]),e.stroke()}}_render_xy(e,t,r,i){return isFinite(r+i)?t?e.lineTo(r,i):(e.beginPath(),e.moveTo(r,i),t=!0):t&&(e.stroke(),t=!1),t}draw_legend_for_index(e,t,r){(0,l.generic_line_scalar_legend)(this.visuals,e,t)}}r.StepView=d,d.__name__="StepView";class p extends a.XYGlyph{constructor(e){super(e)}}r.Step=p,_=p,p.__name__="Step",_.prototype.default_view=d,_.mixins(o.LineScalar),_.define((()=>({mode:[c.StepMode,"before"]})))},
function _(t,e,s,n,l){n();const i=t(1);var o;const r=t(201),x=t(77),a=i.__importStar(t(209)),_=i.__importStar(t(17)),c=t(12),p=t(100),u=t(150);class y extends r.XYGlyphView{_set_data(t){super._set_data(t),this.labels=Array.from(this.text,(t=>{const e=`${t}`;return null!=t?new u.TextBox({text:e}):null}))}_render(t,e,s){const{sx:n,sy:l,x_offset:i,y_offset:o,angle:r,labels:x}=null!=s?s:this;for(const s of e){const e=n[s],a=l[s],_=i.get(s),c=o.get(s),p=r.get(s),u=x[s];isFinite(e+a+_+c+p)&&null!=u&&(this.visuals.text.v_doit(s)&&(u.visuals=this.visuals.text.values(s),u.position={sx:e+_,sy:a+c},u.angle=p,u.align="auto",u.paint(t)))}}_hit_point(t){const{sx:e,sy:s}=t,n=[];let l=0;for(const t of this.labels){if(null!=t){const{p0:i,p1:o,p2:r,p3:x}=t.rect();a.point_in_poly(e,s,[i.x,o.x,r.x,x.x],[i.y,o.y,r.y,x.y])&&n.push(l)}l+=1}return new p.Selection({indices:n})}scenterxy(t){const e=this.labels[t];(0,c.assert)(null!=e);const{p0:s,p1:n,p2:l,p3:i}=e.rect();return[(s.x+n.x+l.x+i.x)/4,(s.y+n.y+l.y+i.y)/4]}}s.TextView=y,y.__name__="TextView";class f extends r.XYGlyph{constructor(t){super(t)}}s.Text=f,o=f,f.__name__="Text",o.prototype.default_view=y,o.mixins(x.TextVector),o.define((({})=>({text:[_.NullStringSpec,{field:"text"}],angle:[_.AngleSpec,0],x_offset:[_.NumberSpec,0],y_offset:[_.NumberSpec,0]})))},
function _(t,e,s,i,r){i();const h=t(1);var a;const o=t(313),n=t(23),_=h.__importStar(t(17));class l extends o.LRTBView{async lazy_initialize(){await super.lazy_initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;if(null!=e&&e.regl_wrapper.has_webgl){const{LRTBGL:s}=await Promise.resolve().then((()=>h.__importStar(t(508))));this.glglyph=new s(e.regl_wrapper,this)}}scenterxy(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]}_lrtb(t){const e=this.width.get(t)/2,s=this._x[t],i=this._top[t],r=this._bottom[t];return[s-e,s+e,Math.max(i,r),Math.min(i,r)]}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this.width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);const t=this.sx.length;this.sleft=new n.ScreenArray(t),this.sright=new n.ScreenArray(t);for(let e=0;e<t;e++)this.sleft[e]=this.sx[e]-this.sw[e]/2,this.sright[e]=this.sx[e]+this.sw[e]/2;this._clamp_viewport()}}s.VBarView=l,l.__name__="VBarView";class c extends o.LRTB{constructor(t){super(t)}}s.VBar=c,a=c,c.__name__="VBar",a.prototype.default_view=l,a.define((({})=>({x:[_.XCoordinateSpec,{field:"x"}],bottom:[_.YCoordinateSpec,{value:0}],width:[_.NumberSpec,{value:1}],top:[_.YCoordinateSpec,{field:"top"}]})))},
function _(e,s,t,i,n){i();const a=e(1);var r;const c=e(201),d=e(208),h=e(77),l=e(23),o=e(19),_=a.__importStar(e(17)),u=e(11),g=e(100),x=e(13);class p extends c.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius):this.sradius=(0,l.to_screen)(this.radius),this.max_sradius=(0,x.max)(this.sradius)}_render(e,s,t){const{sx:i,sy:n,sradius:a,start_angle:r,end_angle:c}=null!=t?t:this,d="anticlock"==this.model.direction;for(const t of s){const s=i[t],h=n[t],l=a[t],o=r.get(t),_=c.get(t);isFinite(s+h+l+o+_)&&(e.beginPath(),e.arc(s,h,l,o,_,d),e.lineTo(s,h),e.closePath(),this.visuals.fill.apply(e,t),this.visuals.hatch.apply(e,t),this.visuals.line.apply(e,t))}}_hit_point(e){let s,t,i,n,a;const{sx:r,sy:c}=e,d=this.renderer.xscale.invert(r),h=this.renderer.yscale.invert(c);t=r-this.max_sradius,i=r+this.max_sradius;const[l,o]=this.renderer.xscale.r_invert(t,i);n=c-this.max_sradius,a=c+this.max_sradius;const[_,x]=this.renderer.yscale.r_invert(n,a),p=[];for(const e of this.index.indices({x0:l,x1:o,y0:_,y1:x})){const r=this.sradius[e]**2;[t,i]=this.renderer.xscale.r_compute(d,this._x[e]),[n,a]=this.renderer.yscale.r_compute(h,this._y[e]),s=(t-i)**2+(n-a)**2,s<=r&&p.push(e)}const y="anticlock"==this.model.direction,m=[];for(const e of p){const s=Math.atan2(c-this.sy[e],r-this.sx[e]);(Math.abs(this.start_angle.get(e)-this.end_angle.get(e))>=2*Math.PI||(0,u.angle_between)(-s,-this.start_angle.get(e),-this.end_angle.get(e),y))&&m.push(e)}return new g.Selection({indices:m})}draw_legend_for_index(e,s,t){(0,d.generic_area_vector_legend)(this.visuals,e,s,t)}scenterxy(e){const s=this.sradius[e]/2,t=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+s*Math.cos(t),this.sy[e]+s*Math.sin(t)]}}t.WedgeView=p,p.__name__="WedgeView";class y extends c.XYGlyph{constructor(e){super(e)}}t.Wedge=y,r=y,y.__name__="Wedge",r.prototype.default_view=p,r.mixins([h.LineVector,h.FillVector,h.HatchVector]),r.define((({})=>({direction:[o.Direction,"anticlock"],radius:[_.DistanceSpec,{field:"radius"}],start_angle:[_.AngleSpec,{field:"start_angle"}],end_angle:[_.AngleSpec,{field:"end_angle"}]})))},
function _(n,i,o,a,r){a(),r("Decoration",n(207).Decoration),r("Marking",n(139).Marking)},
function _(t,_,r,o,a){o();const e=t(1);e.__exportStar(t(342),r),e.__exportStar(t(343),r),e.__exportStar(t(344),r)},
function _(e,t,d,n,s){n();const o=e(50),r=e(13),i=e(10),_=e(100);class a extends o.Model{constructor(e){super(e)}_hit_test(e,t,d){if(!t.model.visible)return null;const n=d.glyph.hit_test(e);return null==n?null:d.model.view.convert_selection_from_subset(n)}}d.GraphHitTestPolicy=a,a.__name__="GraphHitTestPolicy";class c extends a{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.edge_view)}do_selection(e,t,d,n){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;return s.update(e,d,n),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const{edge_renderer:o}=d.model,r=o.get_selection_manager().get_or_create_inspector(d.edge_view.model);return r.update(e,n,s),d.edge_view.model.data_source.setv({inspected:r},{silent:!0}),d.edge_view.model.data_source.inspect.emit([d.edge_view.model,{geometry:t}]),!r.is_empty()}}d.EdgesOnly=c,c.__name__="EdgesOnly";class l extends a{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.node_view)}do_selection(e,t,d,n){if(null==e)return!1;const s=t.node_renderer.data_source.selected;return s.update(e,d,n),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const{node_renderer:o}=d.model,r=o.get_selection_manager().get_or_create_inspector(d.node_view.model);return r.update(e,n,s),d.node_view.model.data_source.setv({inspected:r},{silent:!0}),d.node_view.model.data_source.inspect.emit([d.node_view.model,{geometry:t}]),!r.is_empty()}}d.NodesOnly=l,l.__name__="NodesOnly";class u extends a{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.node_view)}get_linked_edges(e,t,d){let n=[];"selection"==d?n=e.selected.indices.map((t=>e.data.index[t])):"inspection"==d&&(n=e.inspected.indices.map((t=>e.data.index[t])));const s=[];for(let e=0;e<t.data.start.length;e++)((0,i.contains)(n,t.data.start[e])||(0,i.contains)(n,t.data.end[e]))&&s.push(e);const o=new _.Selection;for(const e of s)o.multiline_indices[e]=[0];return o.indices=s,o}do_selection(e,t,d,n){if(null==e)return!1;const s=t.node_renderer.data_source.selected;s.update(e,d,n);const o=t.edge_renderer.data_source.selected,r=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(r,d,n),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const o=d.node_view.model.data_source.selection_manager.get_or_create_inspector(d.node_view.model);o.update(e,n,s),d.node_view.model.data_source.setv({inspected:o},{silent:!0});const r=d.edge_view.model.data_source.selection_manager.get_or_create_inspector(d.edge_view.model),i=this.get_linked_edges(d.node_view.model.data_source,d.edge_view.model.data_source,"inspection");return r.update(i,n,s),d.edge_view.model.data_source.setv({inspected:r},{silent:!0}),d.node_view.model.data_source.inspect.emit([d.node_view.model,{geometry:t}]),!o.is_empty()}}d.NodesAndLinkedEdges=u,u.__name__="NodesAndLinkedEdges";class m extends a{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.edge_view)}get_linked_nodes(e,t,d){let n=[];"selection"==d?n=t.selected.indices:"inspection"==d&&(n=t.inspected.indices);const s=[];for(const e of n)s.push(t.data.start[e]),s.push(t.data.end[e]);const o=(0,i.uniq)(s).map((t=>(0,r.indexOf)(e.data.index,t)));return new _.Selection({indices:o})}do_selection(e,t,d,n){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;s.update(e,d,n);const o=t.node_renderer.data_source.selected,r=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(r,d,n),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const o=d.edge_view.model.data_source.selection_manager.get_or_create_inspector(d.edge_view.model);o.update(e,n,s),d.edge_view.model.data_source.setv({inspected:o},{silent:!0});const r=d.node_view.model.data_source.selection_manager.get_or_create_inspector(d.node_view.model),i=this.get_linked_nodes(d.node_view.model.data_source,d.edge_view.model.data_source,"inspection");return r.update(i,n,s),d.node_view.model.data_source.setv({inspected:r},{silent:!0}),d.edge_view.model.data_source.inspect.emit([d.edge_view.model,{geometry:t}]),!o.is_empty()}}d.EdgesAndLinkedNodes=m,m.__name__="EdgesAndLinkedNodes";class p extends a{constructor(e){super(e)}hit_test(e,t){return this._hit_test(e,t,t.node_view)}get_adjacent_nodes(e,t,d){let n=[];"selection"==d?n=e.selected.indices.map((t=>e.data.index[t])):"inspection"==d&&(n=e.inspected.indices.map((t=>e.data.index[t])));const s=[],o=[];for(let e=0;e<t.data.start.length;e++)(0,i.contains)(n,t.data.start[e])&&(s.push(t.data.end[e]),o.push(t.data.start[e])),(0,i.contains)(n,t.data.end[e])&&(s.push(t.data.start[e]),o.push(t.data.end[e]));for(let e=0;e<o.length;e++)s.push(o[e]);const a=(0,i.uniq)(s).map((t=>(0,r.indexOf)(e.data.index,t)));return new _.Selection({indices:a})}do_selection(e,t,d,n){if(null==e)return!1;const s=t.node_renderer.data_source.selected;s.update(e,d,n);const o=this.get_adjacent_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.is_empty()||s.update(o,d,n),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,d,n,s){if(null==e)return!1;const o=d.node_view.model.data_source.selection_manager.get_or_create_inspector(d.node_view.model);o.update(e,n,s),d.node_view.model.data_source.setv({inspected:o},{silent:!0});const r=this.get_adjacent_nodes(d.node_view.model.data_source,d.edge_view.model.data_source,"inspection");return r.is_empty()||(o.update(r,n,s),d.node_view.model.data_source.setv({inspected:o},{silent:!0})),d.node_view.model.data_source.inspect.emit([d.node_view.model,{geometry:t}]),!o.is_empty()}}d.NodesAndAdjacentNodes=p,p.__name__="NodesAndAdjacentNodes"},
function _(e,o,t,r,n){var s;r();const a=e(50),d=e(296);class _ extends a.Model{constructor(e){super(e)}get node_coordinates(){return new u({layout:this})}get edge_coordinates(){return new i({layout:this})}}t.LayoutProvider=_,_.__name__="LayoutProvider";class c extends d.CoordinateTransform{constructor(e){super(e)}}t.GraphCoordinates=c,s=c,c.__name__="GraphCoordinates",s.define((({Ref:e})=>({layout:[e(_)]})));class u extends c{constructor(e){super(e)}_v_compute(e){const[o,t]=this.layout.get_node_coordinates(e);return{x:o,y:t}}}t.NodeCoordinates=u,u.__name__="NodeCoordinates";class i extends c{constructor(e){super(e)}_v_compute(e){const[o,t]=this.layout.get_edge_coordinates(e);return{x:o,y:t}}}t.EdgeCoordinates=i,i.__name__="EdgeCoordinates"},
function _(t,e,a,n,o){var l;n();const r=t(343),s=t(9);class u extends r.LayoutProvider{constructor(t){super(t)}get_node_coordinates(t){var e,a;const n=null!==(e=new s.Dict(t.data).get("index"))&&void 0!==e?e:[],o=n.length,l=new Float64Array(o),r=new Float64Array(o),{graph_layout:u}=this;for(let t=0;t<o;t++){const e=n[t],[o,s]=null!==(a=u.get(e))&&void 0!==a?a:[NaN,NaN];l[t]=o,r[t]=s}return[l,r]}get_edge_coordinates(t){var e,a,n,o;const l=new s.Dict(t.data),r=null!==(e=l.get("start"))&&void 0!==e?e:[],u=null!==(a=l.get("end"))&&void 0!==a?a:[],i=Math.min(r.length,u.length),d=[],g=[],c=l.get("xs"),h=l.get("ys"),N=null!=c&&null!=h,{graph_layout:v}=this;for(let t=0;t<i;t++){const e=v.has(r[t])&&v.has(u[t]);if(N&&e)d.push(c[t]),g.push(h[t]);else{const e=null!==(n=v.get(r[t]))&&void 0!==n?n:[NaN,NaN],a=null!==(o=v.get(u[t]))&&void 0!==o?o:[NaN,NaN];d.push([e[0],a[0]]),g.push([e[1],a[1]])}}return[d,g]}}a.StaticLayoutProvider=u,l=u,u.__name__="StaticLayoutProvider",l.define((({Number:t,Int:e,Arrayable:a,Map:n})=>({graph_layout:[n(e,a(t)),new globalThis.Map]})))},
function _(i,d,n,r,G){r(),G("Grid",i(346).Grid)},
function _(i,e,s,n,t){n();const r=i(1);var o;const d=i(157),_=i(159),a=i(160),l=r.__importStar(i(77)),h=i(8);class u extends _.GuideRendererView{_render(){const i=this.layer.ctx;i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render()))}_draw_regions(i){if(!this.visuals.band_fill.doit&&!this.visuals.band_hatch.doit)return;const[e,s]=this.grid_coords("major",!1);for(let n=0;n<e.length-1;n++){if(n%2!=1)continue;const[t,r]=this.coordinates.map_to_screen(e[n],s[n]),[o,d]=this.coordinates.map_to_screen(e[n+1],s[n+1]);i.beginPath(),i.rect(t[0],r[0],o[1]-t[0],d[1]-r[0]),this.visuals.band_fill.apply(i),this.visuals.band_hatch.apply(i)}}_draw_grids(i){if(!this.visuals.grid_line.doit)return;const[e,s]=this.grid_coords("major");this._draw_grid_helper(i,this.visuals.grid_line,e,s)}_draw_minor_grids(i){if(!this.visuals.minor_grid_line.doit)return;const[e,s]=this.grid_coords("minor");this._draw_grid_helper(i,this.visuals.minor_grid_line,e,s)}_draw_grid_helper(i,e,s,n){e.set_value(i),i.beginPath();for(let e=0;e<s.length;e++){const[t,r]=this.coordinates.map_to_screen(s[e],n[e]);i.moveTo(Math.round(t[0]),Math.round(r[0]));for(let e=1;e<t.length;e++)i.lineTo(Math.round(t[e]),Math.round(r[e]))}i.stroke()}ranges(){const i=this.model.dimension,e=1-i,{ranges:s}=this.coordinates;return[s[i],s[e]]}computed_bounds(){const[i]=this.ranges(),e=this.model.bounds,s=[i.min,i.max];let n,t;if((0,h.isArray)(e))n=Math.min(e[0],e[1]),t=Math.max(e[0],e[1]),n<s[0]&&(n=s[0]),t>s[1]&&(t=s[1]);else{[n,t]=s;for(const i of this.plot_view.axis_views)i.dimension==this.model.dimension&&i.model.x_range_name==this.model.x_range_name&&i.model.y_range_name==this.model.y_range_name&&([n,t]=i.computed_bounds)}return[n,t]}grid_coords(i,e=!0){const s=this.model.dimension,n=1-s,[t,r]=this.ranges(),[o,d]=(()=>{const[i,e]=this.computed_bounds();return[Math.min(i,e),Math.max(i,e)]})(),_=[[],[]],a=this.model.get_ticker();if(null==a)return _;const l=a.get_ticks(o,d,t,r.min)[i],h=t.min,u=t.max,[c,m]=(()=>{const{cross_bounds:i}=this.model;return"auto"==i?[r.min,r.max]:i})();e||(l[0]!=h&&l.splice(0,0,h),l[l.length-1]!=u&&l.push(u));for(let i=0;i<l.length;i++){if((l[i]==h||l[i]==u)&&e)continue;const t=[],r=[],o=2;for(let e=0;e<o;e++){const s=c+(m-c)/(o-1)*e;t.push(l[i]),r.push(s)}_[s].push(t),_[n].push(r)}return _}}s.GridView=u,u.__name__="GridView";class c extends _.GuideRenderer{constructor(i){super(i)}get_ticker(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null}}s.Grid=c,o=c,c.__name__="Grid",o.prototype.default_view=u,o.mixins([["grid_",l.Line],["minor_grid_",l.Line],["band_",l.Fill],["band_",l.Hatch]]),o.define((({Number:i,Auto:e,Enum:s,Ref:n,Tuple:t,Or:r,Nullable:o})=>({bounds:[r(t(i,i),e),"auto"],cross_bounds:[r(t(i,i),e),"auto"],dimension:[s(0,1),0],axis:[o(n(d.Axis)),null],ticker:[o(n(a.Ticker)),null]}))),o.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},
function _(o,x,B,a,l){a(),l("Column",o(348).Column),l("FlexBox",o(349).FlexBox),l("GridBox",o(354).GridBox),l("GroupBox",o(356).GroupBox),l("HBox",o(358).HBox),l("LayoutDOM",o(350).LayoutDOM),l("Row",o(359).Row),l("ScrollBox",o(360).ScrollBox),l("Spacer",o(361).Spacer),l("TabPanel",o(362).TabPanel),l("Tabs",o(363).Tabs),l("VBox",o(365).VBox)},
function _(e,o,n,t,s){var u;t();const _=e(349);class c extends _.FlexBoxView{constructor(){super(...arguments),this._direction="column"}}n.ColumnView=c,c.__name__="ColumnView";class l extends _.FlexBox{constructor(e){super(e)}}n.Column=l,u=l,l.__name__="Column",u.prototype.default_view=c},
function _(e,t,i,n,o){var s;n();const a=e(350),c=e(353),r=e(227),l=e(251),h=e(55);class d extends a.LayoutDOMView{connect_signals(){super.connect_signals();const{children:e}=this.model.properties;this.on_change(e,(()=>this.update_children()))}get child_models(){return this.model.children}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"flex"}}_update_layout(){super._update_layout(),this.style.append(":host",{flex_direction:this._direction,gap:(0,h.px)(this.model.spacing)});const e=new r.Container;let t=0,i=0;for(const n of this.child_views){if(!(n instanceof a.LayoutDOMView))continue;const o=n.box_sizing(),s=(()=>{const e="row"==this._direction?o.width_policy:o.height_policy,t="row"==this._direction?o.width:o.height,i=null!=t?(0,h.px)(t):"auto";switch(e){case"auto":case"fixed":return`0 0 ${i}`;case"fit":return"1 1 auto";case"min":return"0 1 auto";case"max":return"1 0 0px"}})(),c=(()=>{switch("row"==this._direction?o.height_policy:o.width_policy){case"auto":case"fixed":case"fit":case"min":return"row"==this._direction?o.valign:o.halign;case"max":return"stretch"}})();n.style.append(":host",{flex:s,align_self:c}),"row"==this._direction?"max"==o.height_policy&&n.style.append(":host",{height:"auto"}):"max"==o.width_policy&&n.style.append(":host",{width:"auto"}),null!=n.layout&&(e.add({r0:t,c0:i,r1:t+1,c1:i+1},n),"row"==this._direction?i+=1:t+=1)}0!=e.size?(this.layout=new c.GridAlignmentLayout(e),this.layout.set_sizing()):delete this.layout}}i.FlexBoxView=d,d.__name__="FlexBoxView";class _ extends a.LayoutDOM{constructor(e){super(e)}}i.FlexBox=_,s=_,_.__name__="FlexBox",s.define((({Number:e,Array:t,Ref:i})=>({children:[t(i(l.UIElement)),[]],spacing:[e,0]})))},
function _(e,t,i,s,n){var a;s();const l=e(251),o=e(351),r=e(15),h=e(19),u=e(55),c=e(8),d=e(58),_=e(225),f=e(16),m=e(253),p=e(12);class w extends l.UIElementView{constructor(){super(...arguments),this.mouseenter=new r.Signal(this,"mouseenter"),this.mouseleave=new r.Signal(this,"mouseleave"),this.disabled=new r.Signal(this,"disabled"),this._resized=!1,this._auto_width="fit-content",this._auto_height="fit-content"}get is_layout_root(){return this.is_root||!(this.parent instanceof w)}initialize(){super.initialize(),this._child_views=new Map}_after_resize(){this._resized=!0,super._after_resize(),this.compute_layout()}async lazy_initialize(){await super.lazy_initialize(),await this.build_child_views()}remove(){for(const e of this.child_views)e.remove();this._child_views.clear(),super.remove()}connect_signals(){super.connect_signals(),this.el.addEventListener("mouseenter",(e=>{this.mouseenter.emit(e)})),this.el.addEventListener("mouseleave",(e=>{this.mouseleave.emit(e)})),this.el.addEventListener("contextmenu",(e=>{null!=this.model.context_menu&&(console.log("context menu"),e.preventDefault())})),this.parent instanceof w&&this.connect(this.parent.disabled,(e=>{this.disabled.emit(e||this.model.disabled)}));const e=this.model.properties;this.on_change(e.disabled,(()=>{this.disabled.emit(this.model.disabled)})),this.on_change([e.width,e.height,e.min_width,e.min_height,e.max_width,e.max_height,e.margin,e.width_policy,e.height_policy,e.flow_mode,e.sizing_mode,e.aspect_ratio,e.visible],(()=>this.invalidate_layout())),this.on_change([e.css_classes,e.stylesheets],(()=>this.invalidate_render()))}css_classes(){return[...super.css_classes(),...this.model.css_classes]}*children(){yield*super.children(),yield*this.child_views}get child_views(){return this.child_models.map((e=>this._child_views.get(e)))}async build_child_views(){const{created:e,removed:t}=await(0,d.build_views)(this._child_views,this.child_models,{parent:this});for(const e of t)this._resize_observer.unobserve(e.el);for(const t of e)this._resize_observer.observe(t.el,{box:"border-box"});return e}render(){super.render(),this.class_list.add(...this.css_classes());for(const e of this.child_views)this.shadow_el.appendChild(e.el),e.render(),e.after_render()}_update_children(){}async update_children(){const e=new Set(await this.build_child_views());for(const e of this.child_views)(0,u.remove)(e.el);for(const t of this.child_views)this.shadow_el.appendChild(t.el),e.has(t)&&(t.render(),t.after_render());this._update_children(),this.invalidate_layout()}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"flow"}}_update_layout(){function e(e,t,i){switch(e){case"auto":return null!=t?(0,u.px)(t):i;case"fixed":return null!=t?(0,u.px)(t):"fit-content";case"fit":return"fit-content";case"min":return"min-content";case"max":return"100%"}}function t(e){return(0,c.isNumber)(e)?(0,u.px)(e):`${e.percent}%`}const i={},s=this._intrinsic_display();i.display=function(e){const{inner:t,outer:i}=e;switch(`${t} ${i}`){case"block flow":return"block";case"inline flow":return"inline";case"block flow-root":return"flow-root";case"inline flow-root":return"inline-block";case"block flex":return"flex";case"inline flex":return"inline-flex";case"block grid":return"grid";case"inline grid":return"inline-grid";case"block table":return"table";case"inline table":return"inline-table";default:(0,p.unreachable)()}}(s);const n=this.box_sizing(),{width_policy:a,height_policy:l,width:o,height:r,aspect_ratio:h}=n,d=(()=>{if("auto"==h){if(null!=o&&null!=r)return o/r}else if((0,c.isNumber)(h))return h;return null})();"auto"==h?i.aspect_ratio=null!=o&&null!=r?`${o} / ${r}`:"auto":(0,c.isNumber)(h)&&(i.aspect_ratio=`${h}`);const[_,f]=(()=>{const t=e(a,o,this._auto_width),i=e(l,r,this._auto_height);if(null!=h){if(a!=l)return"fixed"==a?[t,"auto"]:"fixed"==l?["auto",i]:"max"==a?[t,"auto"]:"max"==l?["auto",i]:["auto","auto"];if("fixed"!=a&&"fixed"!=l&&null!=d)return d>=1?[t,"auto"]:["auto",i]}return[t,i]})();i.width=_,i.height=f;const{min_width:m,max_width:w}=this.model,{min_height:g,max_height:b}=this.model;i.min_width=null==m?"0px":t(m),i.min_height=null==g?"0px":t(g),this.is_layout_root?(null!=w&&(i.max_width=t(w)),null!=b&&(i.max_height=t(b))):(null!=w?i.max_width=`min(${t(w)}, 100%)`:"fixed"!=a&&(i.max_width="100%"),null!=b?i.max_height=`min(${t(b)}, 100%)`:"fixed"!=l&&(i.max_height="100%"));const{margin:x}=this.model;if(null!=x)if((0,c.isNumber)(x))i.margin=(0,u.px)(x);else if(2==x.length){const[e,t]=x;i.margin=`${(0,u.px)(e)} ${(0,u.px)(t)}`}else{const[e,t,s,n]=x;i.margin=`${(0,u.px)(e)} ${(0,u.px)(t)} ${(0,u.px)(s)} ${(0,u.px)(n)}`}const{resizable:y}=this.model;if(!1!==y){const e=(()=>{switch(y){case"width":return"horizontal";case"height":return"vertical";case!0:case"both":return"both"}})();i.resize=e,i.overflow="auto"}this.style.append(":host",i)}update_layout(){this.update_style();for(const e of this.child_views)e instanceof w&&e.update_layout();this._update_layout()}get is_managed(){return this.parent instanceof w}_measure_layout(){}measure_layout(){for(const e of this.child_views)e instanceof w&&e.measure_layout();this._measure_layout()}compute_layout(){if(this.parent instanceof w)this.parent.compute_layout();else{if(this.measure_layout(),this.update_bbox(),null!=this.layout)this.layout.compute(this.bbox.size);else for(const e of this.child_views)e instanceof w&&null!=e.layout&&e.layout.compute(e.bbox.size);this.after_layout()}}update_bbox(){for(const e of this.child_views)e.update_bbox();super.update_bbox()}_after_layout(){}after_layout(){for(const e of this.child_views)e instanceof w&&e.after_layout();this._after_layout()}render_to(e){e.appendChild(this.el),this.build(),this.notify_finished()}after_render(){this.is_managed||this.invalidate_layout(),this._has_finished||(this._is_displayed?(0,f.defer)().then((()=>{this._resized||this.finish()})):this.finish())}build(){if(!this.is_layout_root)throw new Error(`${this.toString()} is not a root layout`);return this.render(),this.after_render(),this}async rebuild(){await this.build_child_views(),this.invalidate_render()}invalidate_layout(){this.parent instanceof w?this.parent.invalidate_layout():(this.update_layout(),this.compute_layout())}invalidate_render(){this.render(),this.invalidate_layout()}has_finished(){if(!super.has_finished())return!1;for(const e of this.child_views)if(!e.has_finished())return!1;return!0}box_sizing(){let{width_policy:e,height_policy:t,aspect_ratio:i}=this.model;const{sizing_mode:s}=this.model;if(null!=s)if("fixed"==s)e=t="fixed";else if("stretch_both"==s)e=t="max";else if("stretch_width"==s)e="max";else if("stretch_height"==s)t="max";else switch(null==i&&(i="auto"),s){case"scale_width":e="max",t="min";break;case"scale_height":e="min",t="max";break;case"scale_both":e="max",t="max"}const[n,a]=(()=>{const{align:e}=this.model;return"auto"==e?[void 0,void 0]:(0,c.isArray)(e)?e:[e,e]})(),{width:l,height:o}=this.model;return{width_policy:e,height_policy:t,width:l,height:o,aspect_ratio:i,halign:n,valign:a}}export(e="auto",t=!0){const i=(()=>{switch(e){case"auto":case"png":return"canvas";case"svg":return"svg"}})(),s=new m.CanvasLayer(i,t),{x:n,y:a,width:l,height:o}=this.bbox;s.resize(l,o);const r=getComputedStyle(this.el).backgroundColor;s.ctx.fillStyle=r,s.ctx.fillRect(n,a,l,o);for(const i of this.child_views){const n=i.export(e,t),{x:a,y:l}=i.bbox;s.ctx.drawImage(n.canvas,a,l)}return s}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{children:this.child_views.map((e=>e.serializable_state()))})}}i.LayoutDOMView=w,w.__name__="LayoutDOMView";class g extends l.UIElement{constructor(e){super(e)}}i.LayoutDOM=g,a=g,g.__name__="LayoutDOM",a.define((e=>{const{Boolean:t,Number:i,String:s,Auto:n,Array:a,Tuple:l,Or:r,Null:u,Nullable:c,Ref:d}=e,f=l(i,i),m=l(i,i,i,i);return{width:[c(i),null],height:[c(i),null],min_width:[c(i),null],min_height:[c(i),null],max_width:[c(i),null],max_height:[c(i),null],margin:[c(r(i,f,m)),null],width_policy:[r(_.SizingPolicy,n),"auto"],height_policy:[r(_.SizingPolicy,n),"auto"],aspect_ratio:[r(i,n,u),null],flow_mode:[h.FlowMode,"block"],sizing_mode:[c(h.SizingMode),null],disabled:[t,!1],align:[r(h.Align,l(h.Align,h.Align),n),"auto"],css_classes:[a(s),[]],context_menu:[c(d(o.Menu)),null],resizable:[r(t,h.Dimensions),!1]}}))},
function _(e,t,s,i,r){i();const n=e(1);var o;const a=e(251),l=e(352),m=e(19),d=e(58),u=e(32),c=n.__importStar(e(264)),_=c;class h extends a.UIElementView{constructor(){super(...arguments),this.items=new Map}styles(){return[...super.styles(),c.default]}async lazy_initialize(){await(0,d.build_views)(this.items,this.model.items)}remove(){(0,d.remove_views)(this.items),super.remove()}render(){super.render(),this.el.classList.add(_[this.model.orientation]);const e=(()=>{const{items:e,reversed:t}=this.model,s=t?(0,u.reverse)(e):e;return(0,u.map)(s,(e=>this.items.get(e)))})();for(const t of e)t.render(),this.shadow_el.appendChild(t.el)}}s.MenuView=h,h.__name__="MenuView";class p extends a.UIElement{constructor(e){super(e)}}s.Menu=p,o=p,p.__name__="Menu",o.define((({Boolean:e,Array:t,Ref:s})=>({items:[t(s(l.MenuItem)),[]],reversed:[e,!1],orientation:[m.Orientation,"vertical"]})))},
function _(e,t,n,s,u){s();const _=e(1),l=e(251),m=_.__importDefault(e(264)),a=_.__importDefault(e(265));class r extends l.UIElementView{styles(){return[...super.styles(),m.default,a.default]}}n.MenuItemView=r,r.__name__="MenuItemView";class c extends l.UIElement{constructor(e){super(e)}}n.MenuItem=c,c.__name__="MenuItem"},
function _(t,o,e,i,l){i();const n=t(145),r=t(56),h=t(12),{max:u}=Math;class s extends n.Layoutable{constructor(t){super(),this.children=t}_measure(t){return{width:0,height:0}}compute(t={}){const{width:o,height:e}=t;(0,h.assert)(null!=o&&null!=e);const i={width:o,height:e},l=new r.BBox({left:0,top:0,width:o,height:e});let n;if(null!=i.inner){const{left:t,top:l,right:h,bottom:u}=i.inner;n=new r.BBox({left:t,top:l,right:o-h,bottom:e-u})}this.set_geometry(l,n)}_set_geometry(t,o){super._set_geometry(t,o);const e=this.children.map(((t,o)=>{const{layout:e,bbox:i}=o;(0,h.assert)(null!=e);const l=e.measure(i);return{child:o,layout:e,bbox:i,size_hint:l}})),i=Array(e.nrows).fill(null).map((()=>({top:0,bottom:0}))),l=Array(e.ncols).fill(null).map((()=>({left:0,right:0})));e.foreach((({r0:t,c0:o,r1:e,c1:n},{size_hint:r})=>{const{inner:h}=r;null!=h&&(l[o].left=u(l[o].left,h.left),l[n].right=u(l[n].right,h.right),i[t].top=u(i[t].top,h.top),i[e].bottom=u(i[e].bottom,h.bottom))})),e.foreach((({r0:t,c0:o,r1:e,c1:n},{layout:h,size_hint:u,bbox:s})=>{const f=s,g=null==u.inner?void 0:(()=>{var h,s,g,m,c,d;const{inner:b,align:p}=u,a=null===(h=null==p?void 0:p.left)||void 0===h||h,_=null===(s=null==p?void 0:p.right)||void 0===s||s,v=null===(g=null==p?void 0:p.top)||void 0===g||g,w=null===(m=null==p?void 0:p.bottom)||void 0===m||m,y=null!==(c=null==p?void 0:p.fixed_width)&&void 0!==c&&c,x=null!==(d=null==p?void 0:p.fixed_height)&&void 0!==d&&d,{left:B,right:A}=(()=>{if(y){const t=f.width-b.right-b.left;if(a){const e=l[o].left;return{left:e,right:f.width-(e+t)}}if(_){const o=l[n].right;return{left:f.width-(o+t),right:o}}return{left:b.left,right:b.right}}return{left:a?l[o].left:b.left,right:_?l[n].right:b.right}})(),{top:z,bottom:L}=(()=>{if(x){const o=f.height-b.bottom-b.top;if(v){const e=i[t].top;return{top:e,bottom:f.height-(e+o)}}if(w){const t=i[e].bottom;return{top:f.height-(t+o),bottom:t}}return{top:b.top,bottom:b.bottom}}return{top:v?i[t].top:b.top,bottom:w?i[e].bottom:b.bottom}})(),{width:G,height:M}=f;return r.BBox.from_lrtb({left:B,top:z,right:G-A,bottom:M-L})})();h.set_geometry(f,g)}))}}e.GridAlignmentLayout=s,s.__name__="GridAlignmentLayout"},
function _(e,n,i,s,r){var t;s();const o=e(355),l=e(251);class c extends o.CSSGridBoxView{connect_signals(){super.connect_signals();const{children:e,rows:n,cols:i}=this.model.properties;this.on_change(e,(()=>this.update_children())),this.on_change([n,i],(()=>this.invalidate_layout()))}get _children(){return this.model.children}get _rows(){return this.model.rows}get _cols(){return this.model.cols}}i.GridBoxView=c,c.__name__="GridBoxView";class d extends o.CSSGridBox{constructor(e){super(e)}}i.GridBox=d,t=d,d.__name__="GridBox",t.prototype.default_view=c,t.define((({Int:e,Tuple:n,Array:i,Ref:s,Opt:r,Nullable:t})=>({children:[i(n(s(l.UIElement),e,e,r(e),r(e))),[]],rows:[t(o.TracksSizing),null],cols:[t(o.TracksSizing),null]})))},
function _(i,n,e,t,s){t();const r=i(1);var a;const o=i(350),l=i(353),c=i(55),_=i(227),u=i(20),g=i(32),d=i(8),p=r.__importStar(i(20)),{max:f}=Math;e.TrackAlign=(0,u.Enum)("start","center","end","auto"),e.TrackSize=p.String,e.TrackSizing=p.Struct({size:p.Opt(e.TrackSize),align:p.Opt(e.TrackAlign)}),e.TrackSizingLike=p.Or(e.TrackSize,e.TrackSizing),e.TracksSizing=p.Or(e.TrackSizingLike,p.Array(e.TrackSizingLike),p.Map(p.Int,e.TrackSizingLike));class h extends o.LayoutDOMView{connect_signals(){super.connect_signals();const{spacing:i}=this.model.properties;this.on_change(i,(()=>this.invalidate_layout()))}get child_models(){return this._children.map((([i])=>i))}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"grid"}}_update_layout(){super._update_layout();const i={},[n,e]=(()=>{const{spacing:i}=this.model;return(0,d.isNumber)(i)?[i,i]:i})();i.row_gap=(0,c.px)(n),i.column_gap=(0,c.px)(e);let t=0,s=0;const r=new _.Container;for(const[[,i,n,e=1,a=1],l]of(0,g.enumerate)(this._children)){const c=this.child_views[l];t=f(t,i+e),s=f(s,n+a);const _={};if(_.grid_row_start=`${i+1}`,_.grid_row_end=`span ${e}`,_.grid_column_start=`${n+1}`,_.grid_column_end=`span ${a}`,c.style.append(":host",_),c instanceof o.LayoutDOMView&&null!=c.layout){const t=i,s=n,o=i+e-1,l=n+a-1;r.add({r0:t,c0:s,r1:o,c1:l},c)}}const{_rows:a,_cols:u}=this;function p(i,n){if(i instanceof Map)for(const[e,t]of i.entries())(0,d.isString)(t)?n[e].size=t:n[e]=t;else if((0,d.isArray)(i))for(const[e,t]of(0,g.enumerate)(i))(0,d.isString)(e)?n[t].size=e:n[t]=e;else if(null!=i)for(const e of n)(0,d.isString)(i)?e.size=i:(e.size=i.size,e.align=i.align)}a instanceof Map?t=f(t,...a.keys()):(0,d.isArray)(a)&&(t=f(t,a.length)),u instanceof Map?s=f(s,...u.keys()):(0,d.isArray)(u)&&(s=f(s,u.length));const h=Array(t).fill(null).map((()=>({}))),m=Array(s).fill(null).map((()=>({})));p(a,h),p(u,m);for(const[[,i,n],e]of(0,g.enumerate)(this._children)){const t=this.child_views[e],{halign:s,valign:r}=t.box_sizing();t.style.append(":host",{justify_self:null!=s?s:m[n].align,align_self:null!=r?r:h[i].align})}i.grid_template_rows=h.map((({size:i})=>null!=i?i:"1fr")).join(" "),i.grid_template_columns=m.map((({size:i})=>null!=i?i:"1fr")).join(" "),this.style.append(":host",i),0!=r.size?(this.layout=new l.GridAlignmentLayout(r),this.layout.set_sizing()):delete this.layout}}e.CSSGridBoxView=h,h.__name__="CSSGridBoxView";class m extends o.LayoutDOM{constructor(i){super(i)}}e.CSSGridBox=m,a=m,m.__name__="CSSGridBox",a.define((({Number:i,Tuple:n,Or:e})=>({spacing:[e(i,n(i,i)),0]})))},
function _(e,t,s,l,i){l();const c=e(1);var h;const d=e(350),o=e(251),n=e(55),a=c.__importDefault(e(357));class _ extends d.LayoutDOMView{styles(){return[...super.styles(),a.default]}connect_signals(){super.connect_signals();const{child:e}=this.model.properties;this.on_change(e,(()=>this.update_children()));const{checkable:t,disabled:s}=this.model.properties;this.on_change(t,(()=>{(0,n.display)(this.checkbox_el,this.model.checkable)})),this.on_change(s,(()=>{this.checkbox_el.checked=!this.model.disabled}))}get child_models(){return[this.model.child]}render(){super.render();const{checkable:e,disabled:t,title:s}=this.model;this.checkbox_el=(0,n.input)({type:"checkbox",checked:!t}),this.checkbox_el.addEventListener("change",(()=>{this.model.disabled=!this.checkbox_el.checked})),(0,n.display)(this.checkbox_el,e);const l=(0,n.legend)({},this.checkbox_el,s),i=this.child_views.map((e=>e.el));this.fieldset_el=(0,n.fieldset)({},l,...i),this.shadow_el.appendChild(this.fieldset_el)}_update_children(){const e=this.child_views.map((e=>e.el));this.fieldset_el.append(...e)}}s.GroupBoxView=_,_.__name__="GroupBoxView";class r extends d.LayoutDOM{constructor(e){super(e)}}s.GroupBox=r,h=r,r.__name__="GroupBox",h.prototype.default_view=_,h.define((({Boolean:e,String:t,Nullable:s,Ref:l})=>({title:[s(t),null],child:[l(o.UIElement)],checkable:[e,!1]})))},
function _(d,a,e,l,i){l(),e.default="legend{display:flex;gap:0.5em;padding:0 calc(var(--padding-horizontal) / 2);}fieldset{border:1px solid #ccc;}"},
function _(e,n,l,t,s){var i;t();const o=e(355),c=e(251);class r extends o.CSSGridBoxView{connect_signals(){super.connect_signals();const{children:e,cols:n}=this.model.properties;this.on_change(e,(()=>this.update_children())),this.on_change(n,(()=>this.invalidate_layout()))}get _children(){return this.model.children.map((({child:e,col:n,span:l},t)=>[e,0,null!=n?n:t,1,null!=l?l:1]))}get _rows(){return null}get _cols(){return this.model.cols}}l.HBoxView=r,r.__name__="HBoxView";class a extends o.CSSGridBox{constructor(e){super(e)}}l.HBox=a,i=a,a.__name__="HBox",i.prototype.default_view=r,i.define((({Int:e,Struct:n,Array:l,Ref:t,Opt:s,Nullable:i})=>({children:[l(n({child:t(c.UIElement),col:s(e),span:s(e)})),[]],cols:[i(o.TracksSizing),null]})))},
function _(e,o,t,s,_){var n;s();const r=e(349);class c extends r.FlexBoxView{constructor(){super(...arguments),this._direction="row"}}t.RowView=c,c.__name__="RowView";class w extends r.FlexBox{constructor(e){super(e)}}t.Row=w,n=w,w.__name__="Row",n.prototype.default_view=c},
function _(l,e,o,t,r){var s;t();const a=l(350),c=l(251),i=l(19);class n extends a.LayoutDOMView{styles(){return[...super.styles()]}connect_signals(){super.connect_signals();const{child:l,horizontal_scrollbar:e,vertical_scrollbar:o}=this.model.properties;this.on_change(l,(()=>this.update_children())),this.on_change([e,o],(()=>this.invalidate_layout()))}get child_models(){return[this.model.child]}_update_layout(){function l(l){switch(l){case"auto":return"auto";case"visible":return"scroll";case"hidden":return"hidden"}}super._update_layout();const{horizontal_scrollbar:e,vertical_scrollbar:o}=this.model;this.style.append(":host",{overflow_x:l(e),overflow_y:l(o)})}}o.ScrollBoxView=n,n.__name__="ScrollBoxView";class _ extends a.LayoutDOM{constructor(l){super(l)}}o.ScrollBox=_,s=_,_.__name__="ScrollBox",s.prototype.default_view=n,s.define((({Ref:l})=>({child:[l(c.UIElement)],horizontal_scrollbar:[i.ScrollbarPolicy,"auto"],vertical_scrollbar:[i.ScrollbarPolicy,"auto"]})))},
function _(t,e,a,o,_){var r;o();const s=t(350);class c extends s.LayoutDOMView{constructor(){super(...arguments),this._auto_width="auto",this._auto_height="auto"}get child_models(){return[]}}a.SpacerView=c,c.__name__="SpacerView";class u extends s.LayoutDOM{constructor(t){super(t)}}a.Spacer=u,r=u,u.__name__="Spacer",r.prototype.default_view=c},
function _(e,n,l,a,t){var o;a();const s=e(50),c=e(251);class d extends s.Model{constructor(e){super(e)}}l.TabPanel=d,o=d,d.__name__="TabPanel",o.define((({Boolean:e,String:n,Ref:l})=>({title:[n,""],child:[l(c.UIElement)],closable:[e,!1],disabled:[e,!1]})))},
function _(e,t,s,a,i){a();const o=e(1);var l;const c=e(55),d=e(10),n=e(227),h=e(19),r=e(350),_=e(362),u=e(353),p=o.__importStar(e(364)),v=p,m=o.__importDefault(e(265));class f extends r.LayoutDOMView{connect_signals(){super.connect_signals();const{tabs:e,active:t}=this.model.properties;this.on_change(e,(()=>this.update_children())),this.on_change(t,(()=>this.update_active()))}styles(){return[...super.styles(),p.default,m.default]}get child_models(){return this.model.tabs.map((e=>e.child))}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"flex"}}_update_layout(){super._update_layout();const e=(()=>{switch(this.model.tabs_location){case"above":case"below":return"column";case"left":case"right":return"row"}})();this.style.append(":host",{flex_direction:e});const t=new n.Container;for(const e of this.child_views)e.style.append(":host",{grid_area:"stack"}),e instanceof r.LayoutDOMView&&null!=e.layout&&t.add({r0:0,c0:0,r1:1,c1:1},e);0!=t.size?(this.layout=new u.GridAlignmentLayout(t),this.layout.set_sizing()):delete this.layout}_after_layout(){super._after_layout();const{child_views:e}=this;for(const t of e)(0,c.hide)(t.el);const{active:t}=this.model;if(t in e){const s=e[t];(0,c.show)(s.el)}}render(){super.render();const{active:e}=this.model,t=this.model.tabs.map(((t,s)=>{const a=(0,c.div)({class:[v.tab,s==e?v.active:null],tabIndex:0},t.title);if(a.addEventListener("click",(e=>{this.model.disabled||e.target==e.currentTarget&&this.change_active(s)})),t.closable){const e=(0,c.div)({class:v.close});e.addEventListener("click",(e=>{if(e.target==e.currentTarget){this.model.tabs=(0,d.remove_at)(this.model.tabs,s);const e=this.model.tabs.length;this.model.active>e-1&&(this.model.active=e-1)}})),a.appendChild(e)}return(this.model.disabled||t.disabled)&&a.classList.add(v.disabled),a})),s=this.model.tabs_location;this.header_el=(0,c.div)({class:[v.header,v[s]]},t),this.shadow_el.appendChild(this.header_el),this.stack_el=(0,c.div)({class:"bk-stack"}),this.shadow_el.appendChild(this.stack_el);for(const e of this.child_views)this.stack_el.appendChild(e.el)}change_active(e){e!=this.model.active&&(this.model.active=e)}update_active(){const e=this.model.active,t=(0,c.children)(this.header_el);for(const e of t)e.classList.remove(v.active);t[e].classList.add(v.active);const{child_views:s}=this;for(const e of s)(0,c.hide)(e.el);(0,c.show)(s[e].el)}}s.TabsView=f,f.__name__="TabsView";class b extends r.LayoutDOM{constructor(e){super(e)}}s.Tabs=b,l=b,b.__name__="Tabs",l.prototype.default_view=f,l.define((({Int:e,Array:t,Ref:s})=>({tabs:[t(s(_.TabPanel)),[]],tabs_location:[h.Location,"above"],active:[e,0]})))},
function _(e,r,b,a,o){a(),b.header="bk-header",b.above="bk-above",b.below="bk-below",b.left="bk-left",b.right="bk-right",b.stack="bk-stack",b.tab="bk-tab",b.active="bk-active",b.close="bk-close",b.disabled="bk-disabled",b.default=':host{display:flex;}.bk-header{flex:0 0 auto;}.bk-header.bk-above,.bk-header.bk-below{flex-direction:row;}.bk-header.bk-left,.bk-header.bk-right{flex-direction:column;}.bk-header.bk-above,.bk-header.bk-left{order:0;}.bk-header.bk-below,.bk-header.bk-right{order:1;}.bk-stack{flex:1 1 auto;}.bk-stack{display:grid;grid-template-rows:1fr;grid-template-columns:1fr;grid-template-areas:"stack";}.bk-header{display:flex;flex-wrap:nowrap;align-items:stretch;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-header.bk-above{border-bottom:1px solid #e6e6e6;}.bk-header.bk-right{border-left:1px solid #e6e6e6;}.bk-header.bk-below{border-top:1px solid #e6e6e6;}.bk-header.bk-left{border-right:1px solid #e6e6e6;}.bk-header .bk-tab{padding:4px 8px;border:solid transparent;outline:0;outline-offset:-5px;white-space:nowrap;cursor:pointer;text-align:center;}.bk-header .bk-tab:hover{background-color:#f2f2f2;}.bk-header .bk-tab:focus,.bk-header .bk-tab:active{outline:1px dotted #ccc;}.bk-header .bk-tab.bk-active{color:#4d4d4d;background-color:white;border-color:#e6e6e6;}.bk-header .bk-tab .bk-close{margin-left:10px;}.bk-header .bk-tab.bk-disabled{cursor:not-allowed;pointer-events:none;opacity:0.65;}.bk-header.bk-above .bk-tab{border-width:3px 1px 0px 1px;border-radius:var(--border-radius) var(--border-radius) 0 0;}.bk-header.bk-right .bk-tab{border-width:1px 3px 1px 0px;border-radius:0 var(--border-radius) var(--border-radius) 0;}.bk-header.bk-below .bk-tab{border-width:0px 1px 3px 1px;border-radius:0 0 var(--border-radius) var(--border-radius);}.bk-header.bk-left .bk-tab{border-width:1px 0px 1px 3px;border-radius:var(--border-radius) 0 0 var(--border-radius);}.bk-close{display:inline-block;vertical-align:middle;width:14px;height:14px;cursor:pointer;background-color:gray;mask-image:var(--bokeh-icon-x);mask-size:contain;mask-repeat:no-repeat;-webkit-mask-image:var(--bokeh-icon-x);-webkit-mask-size:contain;-webkit-mask-repeat:no-repeat;}.bk-close:hover{background-color:red;}'},
function _(e,n,t,r,s){var l;r();const i=e(355),o=e(251);class c extends i.CSSGridBoxView{connect_signals(){super.connect_signals();const{children:e,rows:n}=this.model.properties;this.on_change(e,(()=>this.update_children())),this.on_change(n,(()=>this.invalidate_layout()))}get _children(){return this.model.children.map((({child:e,row:n,span:t},r)=>[e,null!=n?n:r,0,null!=t?t:1,1]))}get _rows(){return this.model.rows}get _cols(){return null}}t.VBoxView=c,c.__name__="VBoxView";class a extends i.CSSGridBox{constructor(e){super(e)}}t.VBox=a,l=a,a.__name__="VBox",l.prototype.default_view=c,l.define((({Int:e,Struct:n,Array:t,Ref:r,Opt:s,Nullable:l})=>({children:[t(n({child:r(o.UIElement),row:s(e),span:s(e)})),[]],rows:[l(i.TracksSizing),null]})))},
function _(i,n,c,e,o){e(),o("Menu",i(351).Menu),o("Action",i(367).Action),o("CheckAction",i(369).CheckAction),o("Section",i(370).Section),o("Divider",i(371).Divider)},
function _(e,n,t,i,l){var s;i();const c=e(352),d=e(351),o=e(368),r=e(55);class a extends c.MenuItemView{_click(){}render(){super.render();const{label:e,description:n}=this.model;this.el.tabIndex=0,this.el.title=null!=n?n:"",this.el.appendChild((0,r.span)(e)),this.el.addEventListener("click",(()=>{this._click()})),this.el.addEventListener("keydown",(e=>{e.keyCode==r.Keys.Enter&&this._click()}))}}t.ActionView=a,a.__name__="ActionView";class u extends c.MenuItem{constructor(e){super(e)}}t.Action=u,s=u,u.__name__="Action",s.prototype.default_view=a,s.define((({String:e,Nullable:n,Ref:t})=>({icon:[n(t(o.Icon)),null],label:[e],description:[n(e),null],menu:[n(t(d.Menu)),null]})))},
function _(e,n,o,c,s){var _;c();const t=e(50),i=e(54);class r extends i.DOMComponentView{}o.IconView=r,r.__name__="IconView";class a extends t.Model{constructor(e){super(e)}}o.Icon=a,_=a,a.__name__="Icon",_.define((({Number:e,Or:n,CSSLength:o})=>({size:[n(e,o),"1em"]})))},
function _(e,c,n,t,o){var i;t();const _=e(367);class s extends _.ActionView{}n.CheckActionView=s,s.__name__="CheckActionView";class a extends _.Action{constructor(e){super(e)}}n.CheckAction=a,i=a,a.__name__="CheckAction",i.prototype.default_view=s,i.define((({Boolean:e})=>({checked:[e,!1]})))},
function _(e,n,t,r,i){var s;r();const c=e(352);class o extends c.MenuItemView{render(){super.render()}}t.SectionView=o,o.__name__="SectionView";class _ extends c.MenuItem{constructor(e){super(e)}}t.Section=_,s=_,_.__name__="Section",s.prototype.default_view=o,s.define((({Array:e,Ref:n})=>({items:[e(n(c.MenuItem)),[]]})))},
function _(e,i,r,t,s){t();const d=e(1);var n;const _=e(352),a=d.__importStar(e(264));class c extends _.MenuItemView{render(){super.render(),this.el.classList.add(a.divider)}}r.DividerView=c,c.__name__="DividerView";class o extends _.MenuItem{constructor(e){super(e)}}r.Divider=o,n=o,o.__name__="Divider",n.prototype.default_view=c},
function _(t,a,i,e,M){e();var T=t(148);M("MathText",T.MathText),M("Ascii",T.Ascii),M("MathML",T.MathML),M("TeX",T.TeX),M("PlainText",t(155).PlainText)},
function _(r,o,t,e,n){e(),n("CustomJSTransform",r(374).CustomJSTransform),n("Dodge",r(375).Dodge),n("Interpolator",r(377).Interpolator),n("Jitter",r(378).Jitter),n("LinearInterpolator",r(379).LinearInterpolator),n("StepInterpolator",r(380).StepInterpolator),n("Transform",r(85).Transform)},
function _(r,t,s,n,e){var a;n();const u=r(85),o=r(9),m=r(38);class _ extends u.Transform{constructor(r){super(r)}get names(){return(0,o.keys)(this.args)}get values(){return(0,o.values)(this.args)}_make_transform(r,t){return new Function(...this.names,r,(0,m.use_strict)(t))}get scalar_transform(){return this._make_transform("x",this.func)}get vector_transform(){return this._make_transform("xs",this.v_func)}compute(r){return this.scalar_transform(...this.values,r)}v_compute(r){return this.vector_transform(...this.values,r)}}s.CustomJSTransform=_,a=_,_.__name__="CustomJSTransform",a.define((({Unknown:r,String:t,Dict:s})=>({args:[s(r),{}],func:[t,""],v_func:[t,""]})))},
function _(e,n,r,o,s){var t;o();const u=e(376);class a extends u.RangeTransform{constructor(e){super(e)}_compute(e){return e+this.value}}r.Dodge=a,t=a,a.__name__="Dodge",t.define((({Number:e})=>({value:[e,0]})))},
function _(e,n,t,r,a){var s;r();const c=e(85),o=e(86),i=e(95),u=e(23),h=e(8),l=e(12);class g extends c.Transform{constructor(e){super(e)}v_compute(e){let n;this.range instanceof i.FactorRange?n=this.range.v_synthetic(e):(0,h.isArrayableOf)(e,h.isNumber)?n=e:(0,l.unreachable)();const t=new((0,u.infer_type)(n))(n.length);for(let e=0;e<n.length;e++){const r=n[e];t[e]=this._compute(r)}return t}compute(e){return this.range instanceof i.FactorRange?this._compute(this.range.synthetic(e)):(0,h.isNumber)(e)?this._compute(e):void(0,l.unreachable)()}}t.RangeTransform=g,s=g,g.__name__="RangeTransform",s.define((({Ref:e,Nullable:n})=>({range:[n(e(o.Range)),null]})))},
function _(t,e,r,n,s){var o;n();const i=t(85),a=t(98),h=t(23),l=t(10),d=t(8);class c extends i.Transform{constructor(t){super(t),this._sorted_dirty=!0}connect_signals(){super.connect_signals(),this.connect(this.change,(()=>this._sorted_dirty=!0))}v_compute(t){const e=new((0,h.infer_type)(t))(t.length);for(let r=0;r<t.length;r++){const n=t[r];e[r]=this.compute(n)}return e}sort(t=!1){if(!this._sorted_dirty)return;let e,r;if((0,d.isString)(this.x)&&(0,d.isString)(this.y)&&null!=this.data){const t=this.data.columns();if(!(0,l.includes)(t,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!(0,l.includes)(t,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");e=this.data.get_column(this.x),r=this.data.get_column(this.y)}else{if(!(0,d.isArray)(this.x)||!(0,d.isArray)(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");e=this.x,r=this.y}if(e.length!==r.length)throw new Error("The length for x and y do not match");if(e.length<2)throw new Error("x and y must have at least two elements to support interpolation");const n=e.length,s=new Uint32Array(n);for(let t=0;t<n;t++)s[t]=t;const o=t?-1:1;s.sort(((t,r)=>o*(e[t]-e[r]))),this._x_sorted=new((0,h.infer_type)(e))(n),this._y_sorted=new((0,h.infer_type)(r))(n);for(let t=0;t<n;t++)this._x_sorted[t]=e[s[t]],this._y_sorted[t]=r[s[t]];this._sorted_dirty=!1}}r.Interpolator=c,o=c,c.__name__="Interpolator",o.define((({Boolean:t,Number:e,String:r,Ref:n,Array:s,Or:o,Nullable:i})=>({x:[o(r,s(e))],y:[o(r,s(e))],data:[i(n(a.ColumnarDataSource)),null],clip:[t,!0]})))},
function _(t,s,e,i,r){i();const n=t(1);var o;const a=t(376),u=t(95),h=t(19),c=t(8),m=t(13),f=n.__importStar(t(11)),_=t(12);class p extends a.RangeTransform{constructor(t){super(t)}v_compute(t){var s;let e;this.range instanceof u.FactorRange?e=this.range.v_synthetic(t):(0,c.isArrayableOf)(t,c.isNumber)?e=t:(0,_.unreachable)();const i=e.length;(null===(s=this.previous_offsets)||void 0===s?void 0:s.length)!=i&&(this.previous_offsets=new Array(i),this.previous_offsets=(0,m.map)(this.previous_offsets,(()=>this._compute())));const r=this.previous_offsets;return(0,m.map)(e,((t,s)=>r[s]+t))}_compute(){switch(this.distribution){case"uniform":return this.mean+(f.random()-.5)*this.width;case"normal":return f.rnorm(this.mean,this.width)}}}e.Jitter=p,o=p,p.__name__="Jitter",o.define((({Number:t})=>({mean:[t,0],width:[t,1],distribution:[h.Distribution,"uniform"]})))},
function _(t,s,_,r,e){r();const i=t(10),o=t(377);class n extends o.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];const s=(0,i.find_last_index)(this._x_sorted,(s=>s<t)),_=this._x_sorted[s],r=this._x_sorted[s+1],e=this._y_sorted[s],o=this._y_sorted[s+1];return e+(t-_)/(r-_)*(o-e)}}_.LinearInterpolator=n,n.__name__="LinearInterpolator"},
function _(t,e,s,r,o){var _;r();const i=t(377),n=t(19),d=t(10);class h extends i.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}let e;switch(this.mode){case"after":e=(0,d.find_last_index)(this._x_sorted,(e=>t>=e));break;case"before":e=(0,d.find_index)(this._x_sorted,(e=>t<=e));break;case"center":{const s=(0,d.map)(this._x_sorted,(e=>Math.abs(e-t))),r=(0,d.min)(s);e=(0,d.find_index)(s,(t=>r===t));break}default:throw new Error(`unknown mode: ${this.mode}`)}return-1!=e?this._y_sorted[e]:NaN}}s.StepInterpolator=h,_=h,h.__name__="StepInterpolator",_.define((()=>({mode:[n.StepMode,"after"]})))},
function _(p,o,t,i,a){i(),a("MapOptions",p(382).MapOptions),a("GMapOptions",p(382).GMapOptions),a("GMapPlot",p(382).GMapPlot),a("GMap",p(390).GMap),a("Plot",p(383).Plot),a("GridPlot",p(391).GridPlot),a("Figure",p(392).Figure)},
function _(e,t,a,n,o){var p,s,l;n();const _=e(383),i=e(19),r=e(50),c=e(87),d=e(389);o("GMapPlotView",d.GMapPlotView);class u extends r.Model{constructor(e){super(e)}}a.MapOptions=u,p=u,u.__name__="MapOptions",p.define((({Int:e,Number:t})=>({lat:[t],lng:[t],zoom:[e,12]})));class M extends u{constructor(e){super(e)}}a.GMapOptions=M,s=M,M.__name__="GMapOptions",s.define((({Boolean:e,Int:t,String:a,Nullable:n})=>({map_type:[i.MapType,"roadmap"],scale_control:[e,!1],styles:[n(a),null],tilt:[t,45]})));class m extends _.Plot{constructor(e){super(e),this.use_map=!0}}a.GMapPlot=m,l=m,m.__name__="GMapPlot",l.prototype.default_view=d.GMapPlotView,l.define((({String:e,Bytes:t,Ref:a})=>({map_options:[a(M)],api_key:[t],api_version:[e,"weekly"]}))),l.override({x_range:()=>new c.Range1d,y_range:()=>new c.Range1d,background_fill_alpha:0})},
function _(e,t,r,o,n){o();var a;const i=e(1).__importStar(e(77)),l=e(15),s=e(19),_=e(10),c=e(43),d=e(8),h=e(350),u=e(158),b=e(346),g=e(72),f=e(141),p=e(88),w=e(250),m=e(86),y=e(84),v=e(103),x=e(73),S=e(199),R=e(198),A=e(92),D=e(384);n("PlotView",D.PlotView);class L extends h.LayoutDOM{constructor(e){super(e),this.use_map=!1,this.reset=new l.Signal0(this,"reset")}add_layout(e,t="center"){const r=this.properties[t].get_value();this.setv({[t]:[...r,e]})}remove_layout(e){const t=t=>{(0,_.remove_by)(t,(t=>t==e))};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)}get data_renderers(){return this.renderers.filter((e=>e instanceof S.DataRenderer))}add_renderers(...e){this.renderers=this.renderers.concat(e)}add_glyph(e,t=new v.ColumnDataSource,r={}){const o=new R.GlyphRenderer(Object.assign(Object.assign({},r),{data_source:t,glyph:e}));return this.add_renderers(o),o}add_tools(...e){this.toolbar.tools=this.toolbar.tools.concat(e)}remove_tools(...e){this.toolbar.tools=[...(0,c.difference)(new Set(this.toolbar.tools),new Set(e))]}get panels(){return[...this.side_panels,...this.center]}get side_panels(){const{above:e,below:t,left:r,right:o}=this;return(0,_.concat)([e,t,r,o])}}r.Plot=L,a=L,L.__name__="Plot",a.prototype.default_view=D.PlotView,a.mixins([["outline_",i.Line],["background_",i.Fill],["border_",i.Fill]]),a.define((({Boolean:e,Number:t,String:r,Array:o,Dict:n,Or:a,Ref:i,Null:l,Nullable:_,Struct:c,Opt:h})=>({toolbar:[i(w.Toolbar),()=>new w.Toolbar],toolbar_location:[_(s.Location),"right"],toolbar_sticky:[e,!0],toolbar_inner:[e,!1],frame_width:[_(t),null],frame_height:[_(t),null],frame_align:[a(e,c({left:h(e),right:h(e),top:h(e),bottom:h(e)})),!0],title:[a(i(f.Title),r,l),"",{convert:e=>(0,d.isString)(e)?new f.Title({text:e}):e}],title_location:[_(s.Location),"above"],above:[o(a(i(g.Annotation),i(u.Axis))),[]],below:[o(a(i(g.Annotation),i(u.Axis))),[]],left:[o(a(i(g.Annotation),i(u.Axis))),[]],right:[o(a(i(g.Annotation),i(u.Axis))),[]],center:[o(a(i(g.Annotation),i(b.Grid))),[]],renderers:[o(i(x.Renderer)),[]],x_range:[i(m.Range),()=>new A.DataRange1d],y_range:[i(m.Range),()=>new A.DataRange1d],x_scale:[i(y.Scale),()=>new p.LinearScale],y_scale:[i(y.Scale),()=>new p.LinearScale],extra_x_ranges:[n(i(m.Range)),{}],extra_y_ranges:[n(i(m.Range)),{}],extra_x_scales:[n(i(y.Scale)),{}],extra_y_scales:[n(i(y.Scale)),{}],lod_factor:[t,10],lod_interval:[t,300],lod_threshold:[_(t),2e3],lod_timeout:[t,500],hidpi:[e,!0],output_backend:[s.OutputBackend,"canvas"],min_border:[_(t),5],min_border_top:[_(t),null],min_border_left:[_(t),null],min_border_bottom:[_(t),null],min_border_right:[_(t),null],inner_width:[t,0],inner_height:[t,0],outer_width:[t,0],outer_height:[t,0],match_aspect:[e,!1],aspect_scale:[t,1],reset_policy:[s.ResetPolicy,"standard"],hold_render:[e,!1]}))),a.override({width:600,height:600,outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})},
function _(e,t,i,s,n){s();const a=e(1),o=e(156),r=e(284),l=e(258),_=e(350),h=e(72),d=e(141),c=e(158),u=e(249),p=e(92),g=e(46),m=e(58),b=e(74),v=e(18),f=e(46),w=e(385),y=e(8),x=e(10),z=e(32),k=e(253),S=e(226),M=e(228),$=e(227),q=e(143),R=e(56),V=e(151),O=e(386),j=e(387),P=e(28),T=e(55),B=a.__importDefault(e(388)),{max:C}=Math;class A extends _.LayoutDOMView{constructor(){super(...arguments),this._computed_style=new T.StyleSheet,this._outer_bbox=new R.BBox,this._inner_bbox=new R.BBox,this._needs_paint=!0,this._invalidated_painters=new Set,this._invalidate_all=!0,this._needs_notify=!1}get canvas(){return this.canvas_view}styles(){return[...super.styles(),B.default,this._computed_style]}get toolbar_panel(){return null!=this._toolbar?this.renderer_view(this._toolbar):void 0}get state(){return this._state_manager}set invalidate_dataranges(e){this._range_manager.invalidate_dataranges=e}renderer_view(e){const t=this.renderer_views.get(e);if(null==t)for(const[,t]of this.renderer_views){const i=t.renderer_view(e);if(null!=i)return i}return t}get base_font_size(){const e=getComputedStyle(this.el).fontSize,t=(0,V.parse_css_font_size)(e);if(null!=t){const{value:e,unit:i}=t;if("px"==i)return e}return null}get is_paused(){return null!=this._is_paused&&0!==this._is_paused}get child_models(){return[]}pause(){null==this._is_paused?this._is_paused=1:this._is_paused+=1}unpause(e=!1){if(null==this._is_paused)throw new Error("wasn't paused");this._is_paused=Math.max(this._is_paused-1,0),0!=this._is_paused||e||this.request_paint("everything")}notify_finished_after_paint(){this._needs_notify=!0}request_render(){this.request_paint("everything")}request_paint(e){this.invalidate_painters(e),this.schedule_paint()}invalidate_painters(e){if("everything"==e)this._invalidate_all=!0;else if((0,y.isArray)(e))for(const t of e)this._invalidated_painters.add(t);else this._invalidated_painters.add(e)}schedule_paint(){if(!this.is_paused){const e=this.throttled_paint();this._ready=this._ready.then((()=>e))}}request_layout(){this.request_paint("everything")}reset(){"standard"==this.model.reset_policy&&(this.state.clear(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new g.Reset)}remove(){for(const e of this.frame.ranges.values())e instanceof p.DataRange1d&&e.plots.delete(this.model);(0,m.remove_views)(this.renderer_views),(0,m.remove_views)(this.tool_views),this.canvas_view.remove(),super.remove()}render(){super.render(),this.shadow_el.appendChild(this.canvas_view.el),this.canvas_view.render()}initialize(){this.pause(),super.initialize(),this.lod_started=!1,this.visuals=new b.Visuals(this),this._initial_state={selection:new Map,dimensions:{width:0,height:0}},this.renderer_views=new Map,this.tool_views=new Map,this.frame=new o.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges,this.model.extra_x_scales,this.model.extra_y_scales);for(const e of this.frame.ranges.values())e instanceof p.DataRange1d&&e.plots.add(this.model);this._range_manager=new O.RangeManager(this),this._state_manager=new j.StateManager(this,this._initial_state),this.throttled_paint=(0,w.throttle)((()=>{this._removed||this.repaint()}),1e3/60);const{title_location:e,title:t}=this.model;null!=e&&null!=t&&(this._title=t instanceof d.Title?t:new d.Title({text:t}));const{toolbar_location:i,toolbar_inner:s,toolbar:n}=this.model;null!=i&&(this._toolbar=new u.ToolbarPanel({toolbar:n}),n.location=i,n.inner=s)}async lazy_initialize(){await super.lazy_initialize();const{hidpi:e,output_backend:t}=this.model,i=new r.Canvas({hidpi:e,output_backend:t});this.canvas_view=await(0,m.build_view)(i,{parent:this}),this.canvas_view.plot_views=[this],await this.build_renderer_views(),await this.build_tool_views(),this._range_manager.update_dataranges()}box_sizing(){const e=super.box_sizing(),{width_policy:t,height_policy:i}=e,s=a.__rest(e,["width_policy","height_policy"]),{frame_width:n,frame_height:o}=this.model;return Object.assign(Object.assign({},s),{width_policy:null!=n&&"auto"==t?"fit":t,height_policy:null!=o&&"auto"==i?"fit":i})}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"grid"}}_update_layout(){var e,t,i,s,n;super._update_layout(),this._invalidate_all=!0,this._needs_paint=!0;const a=new M.BorderLayout,{frame_align:o}=this.model;if(a.aligns=(()=>{if((0,y.isBoolean)(o))return{left:o,right:o,top:o,bottom:o};{const{left:e=!0,right:t=!0,top:i=!0,bottom:s=!0}=o;return{left:e,right:t,top:i,bottom:s}}})(),a.set_sizing({width_policy:"max",height_policy:"max",visible:this._is_displayed}),this.visuals.outline_line.doit){const e=this.visuals.outline_line.line_width.get_value();a.center_border_width=e}const r=(0,x.copy)(this.model.above),l=(0,x.copy)(this.model.below),_=(0,x.copy)(this.model.left),c=(0,x.copy)(this.model.right),p=[],g=[],m=[],b=[],v=(e,t=!1)=>{switch(e){case"above":return t?p:r;case"below":return t?g:l;case"left":return t?m:_;case"right":return t?b:c}},{title_location:f}=this.model;if(null!=f&&null!=this._title&&v(f).push(this._title),null!=this._toolbar){const{location:e}=this._toolbar.toolbar;if(this.model.toolbar_inner){v(e,!0).push(this._toolbar)}else{const t=v(e);let i=!0;if(this.model.toolbar_sticky)for(let s=0;s<t.length;s++){const n=t[s];if(n instanceof d.Title){t[s]="above"==e||"below"==e?[n,this._toolbar]:[this._toolbar,n],i=!1;break}}i&&t.push(this._toolbar)}}const w=(e,t)=>{var i;const s=this.renderer_view(t);return s.panel=new q.Panel(e),null===(i=s.update_layout)||void 0===i||i.call(s),s.layout},z=(e,t)=>{const i="above"==e||"below"==e,s=[];for(const n of t)if((0,y.isArray)(n)){const t=n.map((t=>{const s=w(e,t);if(t instanceof u.ToolbarPanel){const e=i?"width_policy":"height_policy";s.set_sizing(Object.assign(Object.assign({},s.sizing),{[e]:"min"}))}return s}));let a;i?(a=new $.Row(t),a.set_sizing({width_policy:"max",height_policy:"min"})):(a=new $.Column(t),a.set_sizing({width_policy:"min",height_policy:"max"})),a.absolute=!0,s.push(a)}else s.push(w(e,n));return s},k=null!==(e=this.model.min_border)&&void 0!==e?e:0;a.min_border={left:null!==(t=this.model.min_border_left)&&void 0!==t?t:k,top:null!==(i=this.model.min_border_top)&&void 0!==i?i:k,right:null!==(s=this.model.min_border_right)&&void 0!==s?s:k,bottom:null!==(n=this.model.min_border_bottom)&&void 0!==n?n:k};const R=new S.NodeLayout,V=new S.VStack,O=new S.VStack,j=new S.HStack,P=new S.HStack,T=new S.VStack,B=new S.VStack,C=new S.HStack,A=new S.HStack;R.absolute=!0,V.absolute=!0,O.absolute=!0,j.absolute=!0,P.absolute=!0,T.absolute=!0,B.absolute=!0,C.absolute=!0,A.absolute=!0,R.children=this.model.center.filter((e=>e instanceof h.Annotation)).map((e=>{var t;const i=this.renderer_view(e);return null===(t=i.update_layout)||void 0===t||t.call(i),i.layout})).filter((e=>null!=e));const{frame_width:D,frame_height:H}=this.model;R.set_sizing(Object.assign(Object.assign({},null!=D?{width_policy:"fixed",width:D}:{width_policy:"fit"}),null!=H?{height_policy:"fixed",height:H}:{height_policy:"fit"})),R.on_resize((e=>this.frame.set_geometry(e))),V.children=(0,x.reversed)(z("above",r)),O.children=z("below",l),j.children=(0,x.reversed)(z("left",_)),P.children=z("right",c),T.children=z("above",p),B.children=z("below",g),C.children=z("left",m),A.children=z("right",b),V.set_sizing({width_policy:"fit",height_policy:"min"}),O.set_sizing({width_policy:"fit",height_policy:"min"}),j.set_sizing({width_policy:"min",height_policy:"fit"}),P.set_sizing({width_policy:"min",height_policy:"fit"}),T.set_sizing({width_policy:"fit",height_policy:"min"}),B.set_sizing({width_policy:"fit",height_policy:"min"}),C.set_sizing({width_policy:"min",height_policy:"fit"}),A.set_sizing({width_policy:"min",height_policy:"fit"}),a.center_panel=R,a.top_panel=V,a.bottom_panel=O,a.left_panel=j,a.right_panel=P,0!=T.children.length&&(a.inner_top_panel=T),0!=B.children.length&&(a.inner_bottom_panel=B),0!=C.children.length&&(a.inner_left_panel=C),0!=A.children.length&&(a.inner_right_panel=A),this.layout=a}_measure_layout(){const{frame_width:e,frame_height:t}=this.model,i=null==e?"1fr":(0,T.px)(e),s=null==t?"1fr":(0,T.px)(t),{layout:n}=this,a=n.top_panel.measure({width:1/0,height:1/0}),o=n.bottom_panel.measure({width:1/0,height:1/0}),r=n.left_panel.measure({width:1/0,height:1/0}),l=n.right_panel.measure({width:1/0,height:1/0}),_=C(a.height,n.min_border.top),h=C(o.height,n.min_border.bottom),d=C(r.width,n.min_border.left),c=C(l.width,n.min_border.right);this._computed_style.replace(`\n      :host {\n        grid-template-rows: ${_}px ${s} ${h}px;\n        grid-template-columns: ${d}px ${i} ${c}px;\n      }\n    `)}get axis_views(){const e=[];for(const[,t]of this.renderer_views)t instanceof c.AxisView&&e.push(t);return e}update_range(e,t){this.pause(),this._range_manager.update(e,t),this.unpause()}reset_range(){this.update_range(null),this.trigger_ranges_update_event()}trigger_ranges_update_event(){const{x_range:e,y_range:t}=this.model;this.model.trigger_event(new f.RangesUpdate(e.start,e.end,t.start,t.end))}get_selection(){const e=new Map;for(const t of this.model.data_renderers){const{selected:i}=t.selection_manager.source;e.set(t,i)}return e}update_selection(e){for(const t of this.model.data_renderers){const i=t.selection_manager.source;if(null!=e){const s=e.get(t);null!=s&&i.selected.update(s,!0)}else i.selection_manager.clear()}}reset_selection(){this.update_selection(null)}_invalidate_layout_if_needed(){(()=>{var e,t;for(const i of this.model.side_panels){const s=this.renderer_views.get(i);if(null!==(t=null===(e=s.layout)||void 0===e?void 0:e.has_size_changed())&&void 0!==t&&t)return this.invalidate_painters(s),!0}return!1})()&&this.compute_layout()}get_renderer_views(){return this.computed_renderers.map((e=>this.renderer_views.get(e)))}*_compute_renderers(){const{above:e,below:t,left:i,right:s,center:n,renderers:a}=this.model;yield*a,yield*e,yield*t,yield*i,yield*s,yield*n,null!=this._title&&(yield this._title),null!=this._toolbar&&(yield this._toolbar);for(const e of this.model.toolbar.tools)yield*e.computed_overlays}async build_renderer_views(){this.computed_renderers=[...this._compute_renderers()],await(0,m.build_views)(this.renderer_views,this.computed_renderers,{parent:this})}async build_tool_views(){const e=(0,z.flat_map)(this.model.toolbar.tools,(e=>e instanceof l.ToolProxy?e.tools:[e])),{created:t}=await(0,m.build_views)(this.tool_views,[...e],{parent:this});t.map((e=>this.canvas_view.ui_event_bus.register_tool(e)))}connect_signals(){super.connect_signals();const{extra_x_ranges:e,extra_y_ranges:t,extra_x_scales:i,extra_y_scales:s}=this.model.properties;this.on_change([e,t,i,s],(()=>{this.frame.x_range=this.model.x_range,this.frame.y_range=this.model.y_range,this.frame.in_x_scale=this.model.x_scale,this.frame.in_y_scale=this.model.y_scale,this.frame.extra_x_ranges=this.model.extra_x_ranges,this.frame.extra_y_ranges=this.model.extra_y_ranges,this.frame.extra_x_scales=this.model.extra_x_scales,this.frame.extra_y_scales=this.model.extra_y_scales,this.frame.configure_scales()}));const{above:n,below:a,left:o,right:r,center:l,renderers:_}=this.model.properties,h=[n,a,o,r,l];this.on_change(_,(async()=>{await this.build_renderer_views()})),this.on_change(h,(async()=>{await this.build_renderer_views(),this.invalidate_layout()})),this.connect(this.model.toolbar.properties.tools.change,(async()=>{await this.build_renderer_views(),await this.build_tool_views()}));const{x_ranges:d,y_ranges:c}=this.frame;for(const[,e]of d)this.connect(e.change,(()=>{this.request_paint("everything")}));for(const[,e]of c)this.connect(e.change,(()=>{this.request_paint("everything")}));this.connect(this.model.change,(()=>this.request_paint("everything"))),this.connect(this.model.reset,(()=>this.reset()));const{toolbar_location:p}=this.model.properties;this.on_change(p,(async()=>{const{toolbar_location:e}=this.model;if(null!=this._toolbar)null!=e?this._toolbar.toolbar.location=e:(this._toolbar=void 0,await this.build_renderer_views());else if(null!=e){const{toolbar:t,toolbar_inner:i}=this.model;this._toolbar=new u.ToolbarPanel({toolbar:t}),t.location=e,t.inner=i,await this.build_renderer_views()}this.invalidate_layout()}));const{hold_render:g}=this.model.properties;this.on_change(g,(()=>this._hold_render_changed()))}has_finished(){if(!super.has_finished())return!1;if(this.model.visible)for(const[,e]of this.renderer_views)if(!e.has_finished())return!1;return!0}_after_layout(){var e;super._after_layout(),this.unpause(!0);const t=this.layout.left_panel.bbox,i=this.layout.right_panel.bbox,s=this.layout.center_panel.bbox,n=this.layout.top_panel.bbox,a=this.layout.bottom_panel.bbox,{bbox:o}=this,r=n.bottom,l=o.height-a.top,_=t.right,d=o.width-i.left;this.canvas.style.replace(`\n      .bk-layer.bk-events {\n        display: grid;\n        grid-template-areas:\n          ".    above  .    "\n          "left center right"\n          ".    below  .    ";\n        grid-template-rows: ${(0,T.px)(r)} ${(0,T.px)(s.height)} ${(0,T.px)(l)};\n        grid-template-columns: ${(0,T.px)(_)} ${(0,T.px)(s.width)} ${(0,T.px)(d)};\n      }\n    `);for(const[,t]of this.renderer_views)t instanceof h.AnnotationView&&(null===(e=t.after_layout)||void 0===e||e.call(t));this.model.setv({inner_width:Math.round(this.frame.bbox.width),inner_height:Math.round(this.frame.bbox.height),outer_width:Math.round(this.bbox.width),outer_height:Math.round(this.bbox.height)},{no_change:!0}),this.model.match_aspect&&(this.pause(),this._range_manager.update_dataranges(),this.unpause(!0)),this._outer_bbox.equals(this.bbox)||(this.canvas_view.resize(),this._outer_bbox=this.bbox,this._invalidate_all=!0,this._needs_paint=!0);const{inner_bbox:c}=this.layout;this._inner_bbox.equals(c)||(this._inner_bbox=c,this._needs_paint=!0),this._needs_paint&&this.paint()}repaint(){this._invalidate_layout_if_needed(),this.paint()}paint(){this.is_paused||(this.model.visible&&(v.logger.trace(`${this.toString()}.paint()`),this._actual_paint()),this._needs_notify&&(this._needs_notify=!1,this.notify_finished()))}_actual_paint(){var e;const{document:t}=this.model;if(null!=t){const e=t.interactive_duration();e>=0&&e<this.model.lod_interval?setTimeout((()=>{t.interactive_duration()>this.model.lod_timeout&&t.interactive_stop(),this.request_paint("everything")}),this.model.lod_timeout):t.interactive_stop()}this._range_manager.invalidate_dataranges&&(this._range_manager.update_dataranges(),this._invalidate_layout_if_needed());let i=!1,s=!1;if(this._invalidate_all)i=!0,s=!0;else for(const e of this._invalidated_painters){const{level:t}=e.model;if("overlay"!=t?i=!0:s=!0,i&&s)break}this._invalidated_painters.clear(),this._invalidate_all=!1;const n=[this.frame.bbox.left,this.frame.bbox.top,this.frame.bbox.width,this.frame.bbox.height],{primary:a,overlays:o}=this.canvas_view;i&&(a.prepare(),this.canvas_view.prepare_webgl(n),this._paint_empty(a.ctx,n),this._paint_outline(a.ctx,n),this._paint_levels(a.ctx,"image",n,!0),this._paint_levels(a.ctx,"underlay",n,!0),this._paint_levels(a.ctx,"glyph",n,!0),this._paint_levels(a.ctx,"guide",n,!1),this._paint_levels(a.ctx,"annotation",n,!1),a.finish()),(s||P.settings.wireframe)&&(o.prepare(),this._paint_levels(o.ctx,"overlay",n,!1),P.settings.wireframe&&this._paint_layout(o.ctx,this.layout),o.finish()),null==this._initial_state.range&&(this._initial_state.range=null!==(e=this._range_manager.compute_initial())&&void 0!==e?e:void 0),this._needs_paint=!1}_paint_levels(e,t,i,s){for(const n of this.computed_renderers){if(n.level!=t)continue;const a=this.renderer_views.get(n);e.save(),(s||a.needs_clip)&&(e.beginPath(),e.rect(...i),e.clip()),a.render(),e.restore(),a.has_webgl&&a.needs_webgl_blit&&this.canvas_view.blit_webgl(e)}}_paint_layout(e,t){const{x:i,y:s,width:n,height:a}=t.bbox;e.strokeStyle="blue",e.strokeRect(i,s,n,a);for(const n of t)e.save(),t.absolute||e.translate(i,s),this._paint_layout(e,n),e.restore()}_paint_empty(e,t){const[i,s,n,a]=[0,0,this.bbox.width,this.bbox.height],[o,r,l,_]=t;this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(e),e.fillRect(i,s,n,a),e.clearRect(o,r,l,_)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fillRect(o,r,l,_))}_paint_outline(e,t){if(this.visuals.outline_line.doit){e.save(),this.visuals.outline_line.set_value(e);let[i,s,n,a]=t;i+n==this.bbox.width&&(n-=1),s+a==this.bbox.height&&(a-=1),e.strokeRect(i,s,n,a),e.restore()}}export(e="auto",t=!0){const i=(()=>{switch(e){case"auto":return this.canvas_view.model.output_backend;case"png":return"canvas";case"svg":return"svg"}})(),s=new k.CanvasLayer(i,t),{width:n,height:a}=this.bbox;if(s.resize(n,a),0!=n&&0!=a){const{canvas:e}=this.canvas_view.compose();s.ctx.drawImage(e,0,0)}return s}serializable_state(){const e=super.serializable_state(),{children:t}=e,i=a.__rest(e,["children"]),s=this.get_renderer_views().map((e=>e.serializable_state())).filter((e=>null!=e.bbox));return Object.assign(Object.assign({},i),{children:[...null!=t?t:[],...s]})}_hold_render_changed(){this.model.hold_render?this.pause():this.unpause()}}i.PlotView=A,A.__name__="PlotView"},
function _(n,t,e,l,u){l(),e.throttle=function(n,t){let e,l=null,u=null,o=0,i=!1;const r=function(){return new Promise(((r,c)=>{e=r;const a=function(){o=Date.now(),l=null,u=null,i=!1;try{n(),r()}catch(n){c(n)}},m=Date.now(),s=t-(m-o);s<=0&&!i?(null!=l&&clearTimeout(l),i=!0,u=requestAnimationFrame(a)):null!=l||i?r():l=setTimeout((()=>u=requestAnimationFrame(a)),s)}))};return r.stop=function(){null!=l&&clearTimeout(l),null!=u&&cancelAnimationFrame(u),e()},r}},
function _(t,n,e,a,s){a();const o=t(92),r=t(18);class l{constructor(t){this.parent=t,this.invalidate_dataranges=!0}get frame(){return this.parent.frame}update(t,n={}){var e;const{x_ranges:a,y_ranges:s}=this.frame;if(null==t){for(const[,t]of a)t.reset();for(const[,t]of s)t.reset();this.update_dataranges()}else{const o=[];for(const[n,e]of a)o.push([e,t.xrs.get(n)]);for(const[n,e]of s)o.push([e,t.yrs.get(n)]);null!==(e=n.scrolling)&&void 0!==e&&e&&this._update_ranges_together(o),this._update_ranges_individually(o,n)}}reset(){this.update(null)}_update_dataranges(t){const n=new Map,e=new Map;let a=!1;for(const[,n]of t.x_ranges)n instanceof o.DataRange1d&&"log"==n.scale_hint&&(a=!0);for(const[,n]of t.y_ranges)n instanceof o.DataRange1d&&"log"==n.scale_hint&&(a=!0);for(const t of this.parent.model.data_renderers){const s=this.parent.renderer_view(t);if(null==s)continue;const o=s.glyph_view.bounds();if(n.set(t,o),a){const n=s.glyph_view.log_bounds();e.set(t,n)}}let s=!1,l=!1;const i=t.x_target.span,d=t.y_target.span;let _;!1!==this.parent.model.match_aspect&&0!=i&&0!=d&&(_=1/this.parent.model.aspect_scale*(i/d));for(const[,a]of t.x_ranges){if(a instanceof o.DataRange1d){const t="log"==a.scale_hint?e:n;a.update(t,0,this.parent.model,_),a.follow&&(s=!0)}null!=a.bounds&&(l=!0)}for(const[,a]of t.y_ranges){if(a instanceof o.DataRange1d){const t="log"==a.scale_hint?e:n;a.update(t,1,this.parent.model,_),a.follow&&(s=!0)}null!=a.bounds&&(l=!0)}if(s&&l){r.logger.warn("Follow enabled so bounds are unset.");for(const[,n]of t.x_ranges)n.bounds=null;for(const[,n]of t.y_ranges)n.bounds=null}}update_dataranges(){this._update_dataranges(this.frame);for(const t of this.parent.model.renderers){const{coordinates:n}=t;null!=n&&this._update_dataranges(n)}null!=this.compute_initial()&&(this.invalidate_dataranges=!1)}compute_initial(){let t=!0;const{x_ranges:n,y_ranges:e}=this.frame,a=new Map,s=new Map;for(const[e,s]of n){const{start:n,end:o}=s;if(isNaN(n+o)){t=!1;break}a.set(e,{start:n,end:o})}if(t)for(const[n,a]of e){const{start:e,end:o}=a;if(isNaN(e+o)){t=!1;break}s.set(n,{start:e,end:o})}return t?{xrs:a,yrs:s}:(r.logger.warn("could not set initial ranges"),null)}_update_ranges_together(t){let n=1;for(const[e,a]of t)n=Math.min(n,this._get_weight_to_constrain_interval(e,a));if(n<1)for(const[e,a]of t)a.start=n*a.start+(1-n)*e.start,a.end=n*a.end+(1-n)*e.end}_update_ranges_individually(t,n={}){var e,a,s;const o=null!==(e=n.panning)&&void 0!==e&&e,r=null!==(a=n.scrolling)&&void 0!==a&&a,l=null!==(s=n.maintain_focus)&&void 0!==s&&s;let i=!1;for(const[n,e]of t){if(!r){const t=this._get_weight_to_constrain_interval(n,e);t<1&&(e.start=t*e.start+(1-t)*n.start,e.end=t*e.end+(1-t)*n.end)}if(null!=n.bounds&&"auto"!=n.bounds){const[t,a]=n.bounds,s=Math.abs(e.end-e.start);n.is_reversed?(null!=t&&t>e.end&&(i=!0,e.end=t,(o||r)&&(e.start=t+s)),null!=a&&a<e.start&&(i=!0,e.start=a,(o||r)&&(e.end=a-s))):(null!=t&&t>e.start&&(i=!0,e.start=t,(o||r)&&(e.end=t+s)),null!=a&&a<e.end&&(i=!0,e.end=a,(o||r)&&(e.start=a-s)))}}if(!(r&&i&&l))for(const[n,e]of t)n.have_updated_interactively=!0,n.start==e.start&&n.end==e.end||n.setv(e)}_get_weight_to_constrain_interval(t,n){const{min_interval:e}=t;let{max_interval:a}=t;if(null!=t.bounds&&"auto"!=t.bounds){const[n,e]=t.bounds;if(null!=n&&null!=e){const t=Math.abs(e-n);a=null!=a?Math.min(a,t):t}}let s=1;if(null!=e||null!=a){const o=Math.abs(t.end-t.start),r=Math.abs(n.end-n.start);null!=e&&e>0&&r<e&&(s=(o-e)/(o-r)),null!=a&&a>0&&r>a&&(s=(a-o)/(r-o)),s=Math.max(0,Math.min(1,s))}return s}}e.RangeManager=l,l.__name__="RangeManager"},
function _(t,i,s,e,n){e();const h=t(15);class a{constructor(t,i){this.parent=t,this.initial_state=i,this.changed=new h.Signal0(this.parent,"state_changed"),this.history=[],this.index=-1}_do_state_change(t){const i=t in this.history?this.history[t].state:this.initial_state;return null!=i.range&&this.parent.update_range(i.range),this.parent.update_selection(i.selection),i}push(t,i){const{history:s,index:e}=this,n=e in s?s[e].state:{},h=Object.assign(Object.assign(Object.assign({},this.initial_state),n),i);this.history=this.history.slice(0,this.index+1),this.history.push({type:t,state:h}),this.index=this.history.length-1,this.changed.emit()}clear(){this.history=[],this.index=-1,this.changed.emit()}undo(){if(this.can_undo){this.index-=1;const t=this._do_state_change(this.index);return this.changed.emit(),t}return null}redo(){if(this.can_redo){this.index+=1;const t=this._do_state_change(this.index);return this.changed.emit(),t}return null}get can_undo(){return this.index>=0}get can_redo(){return this.index<this.history.length-1}}s.StateManager=a,a.__name__="StateManager"},
function _(a,r,t,e,n){e(),t.Canvas="bk-Canvas",t.default=':host{display:grid;grid-template-areas:".    above  .    " "left center right" ".    below  .    ";grid-template-rows:0px 1fr 0px;grid-template-columns:0px 1fr 0px;}.bk-Canvas{grid-row-start:1;grid-row-end:span 3;grid-column-start:1;grid-column-end:span 3;}'},
function _(t,e,s,i,o){i();const a=t(18),n=t(15),p=t(55),_=t(104),l=t(384);const h=new n.Signal0({},"gmaps_ready");class d extends l.PlotView{initialize(){super.initialize(),this._tiles_loaded=!1,this.zoom_count=0;const{zoom:t,lat:e,lng:s}=this.model.map_options;this.initial_zoom=t,this.initial_lat=e,this.initial_lng=s;const i=new TextDecoder("utf-8");if(this._api_key=i.decode(this.model.api_key),!this._api_key){const t="https://developers.google.com/maps/documentation/javascript/get-api-key";a.logger.error(`api_key is required. See ${t} for more information on how to obtain your own.`)}}async lazy_initialize(){if(await super.lazy_initialize(),this.map_el=(0,p.div)({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),"undefined"==typeof google||void 0===google.maps){if(void 0===window._bokeh_gmaps_callback){const{api_version:t}=this.model;!function(t,e){window._bokeh_gmaps_callback=()=>h.emit();const s=encodeURIComponent,i=document.createElement("script");i.type="text/javascript",i.src=`https://maps.googleapis.com/maps/api/js?v=${s(e)}&key=${s(t)}&callback=_bokeh_gmaps_callback`,document.body.appendChild(i)}(this._api_key,t)}h.connect((()=>{this._build_map(),this.request_paint("everything")}))}else this._build_map()}remove(){(0,p.remove)(this.map_el),super.remove()}update_range(t,e){var s,i;if(null==t)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),super.update_range(null,e);else if(null!=t.sdx||null!=t.sdy)this.map.panBy(null!==(s=t.sdx)&&void 0!==s?s:0,null!==(i=t.sdy)&&void 0!==i?i:0),super.update_range(t,e);else if(null!=t.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),super.update_range(t,e);const s=t.factor<0?-1:1,i=this.map.getZoom();if(null!=i){const t=i+s;if(t>=2){this.map.setZoom(t);const[e,s]=this._get_projected_bounds();s-e<0&&this.map.setZoom(i)}}this.unpause()}this._set_bokeh_ranges()}_build_map(){const{maps:t}=google;this.map_types={satellite:t.MapTypeId.SATELLITE,terrain:t.MapTypeId.TERRAIN,roadmap:t.MapTypeId.ROADMAP,hybrid:t.MapTypeId.HYBRID};const e=this.model.map_options,s={center:new t.LatLng(e.lat,e.lng),zoom:e.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[e.map_type],scaleControl:e.scale_control,tilt:e.tilt};null!=e.styles&&(s.styles=JSON.parse(e.styles)),this.map=new t.Map(this.map_el,s),t.event.addListener(this.map,"idle",(()=>this._set_bokeh_ranges())),t.event.addListener(this.map,"bounds_changed",(()=>this._set_bokeh_ranges())),t.event.addListenerOnce(this.map,"tilesloaded",(()=>this._render_finished())),this.connect(this.model.properties.map_options.change,(()=>this._update_options())),this.connect(this.model.map_options.properties.styles.change,(()=>this._update_styles())),this.connect(this.model.map_options.properties.lat.change,(()=>this._update_center("lat"))),this.connect(this.model.map_options.properties.lng.change,(()=>this._update_center("lng"))),this.connect(this.model.map_options.properties.zoom.change,(()=>this._update_zoom())),this.connect(this.model.map_options.properties.map_type.change,(()=>this._update_map_type())),this.connect(this.model.map_options.properties.scale_control.change,(()=>this._update_scale_control())),this.connect(this.model.map_options.properties.tilt.change,(()=>this._update_tilt()))}_render_finished(){this._tiles_loaded=!0,this.notify_finished()}has_finished(){return super.has_finished()&&!0===this._tiles_loaded}_get_latlon_bounds(){const t=this.map.getBounds(),e=t.getNorthEast(),s=t.getSouthWest();return[s.lng(),e.lng(),s.lat(),e.lat()]}_get_projected_bounds(){const[t,e,s,i]=this._get_latlon_bounds(),[o,a]=_.wgs84_mercator.compute(t,s),[n,p]=_.wgs84_mercator.compute(e,i);return[o,n,a,p]}_set_bokeh_ranges(){const[t,e,s,i]=this._get_projected_bounds();this.frame.x_range.setv({start:t,end:e}),this.frame.y_range.setv({start:s,end:i})}_update_center(t){var e;const s=null===(e=this.map.getCenter())||void 0===e?void 0:e.toJSON();null!=s&&(s[t]=this.model.map_options[t],this.map.setCenter(s),this._set_bokeh_ranges())}_update_map_type(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})}_update_scale_control(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})}_update_tilt(){this.map.setOptions({tilt:this.model.map_options.tilt})}_update_options(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()}_update_styles(){const{styles:t}=this.model.map_options;this.map.setOptions({styles:null!=t?JSON.parse(t):null})}_update_zoom(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()}_after_layout(){super._after_layout();const{left:t,top:e,width:s,height:i}=this.frame.bbox;this.map_el.style.top=`${e}px`,this.map_el.style.left=`${t}px`,this.map_el.style.width=`${s}px`,this.map_el.style.height=`${i}px`}}s.GMapPlotView=d,d.__name__="GMapPlotView"},
function _(e,a,t,s,n){var p;s();const _=e(382);class i extends _.GMapPlotView{serializable_state(){const e=super.serializable_state();return Object.assign(Object.assign({},e),{type:"GMapPlot"})}}t.GMapView=i,i.__name__="GMapView";class l extends _.GMapPlot{constructor(e){super(e)}}t.GMap=l,p=l,l.__name__="GMap",p.prototype.default_view=i},
function _(t,o,e,i,s){var l;i();const r=t(350),a=t(354),n=t(355),c=t(250),_=t(268),d=t(253),h=t(58),u=t(19);class b extends r.LayoutDOMView{constructor(){super(...arguments),this._tool_views=new Map}get toolbar_view(){return this.child_views.find((t=>t.model==this.model.toolbar))}get grid_box_view(){return this.child_views.find((t=>t.model==this._grid_box))}_update_location(){const t=this.model.toolbar_location;null==t?this.model.toolbar.visible=!1:this.model.toolbar.setv({visible:!0,location:t})}initialize(){super.initialize(),this._update_location();const{children:t,rows:o,cols:e,spacing:i}=this.model;this._grid_box=new a.GridBox({children:t,rows:o,cols:e,spacing:i})}async lazy_initialize(){await super.lazy_initialize(),await this.build_tool_views()}connect_signals(){super.connect_signals();const{toolbar:t,toolbar_location:o,children:e,rows:i,cols:s,spacing:l}=this.model.properties;this.on_change(o,(()=>{this._update_location(),this.rebuild()})),this.on_change([t,e,i,s,l],(()=>{this.rebuild()})),this.on_change(this.model.toolbar.properties.tools,(async()=>{await this.build_tool_views()})),this.mouseenter.connect((()=>{this.toolbar_view.set_visibility(!0)})),this.mouseleave.connect((()=>{this.toolbar_view.set_visibility(!1)}))}remove(){(0,h.remove_views)(this._tool_views),super.remove()}async build_tool_views(){const t=this.model.toolbar.tools.filter((t=>t instanceof _.ActionTool));await(0,h.build_views)(this._tool_views,t,{parent:this})}get child_models(){return[this.model.toolbar,this._grid_box]}_intrinsic_display(){return{inner:this.model.flow_mode,outer:"flex"}}_update_layout(){super._update_layout();const{location:t}=this.model.toolbar,o=(()=>{switch(t){case"above":return"column";case"below":return"column-reverse";case"left":return"row";case"right":return"row-reverse"}})();this.style.append(":host",{flex_direction:o})}export(t="auto",o=!0){const e=(()=>{switch(t){case"auto":case"png":return"canvas";case"svg":return"svg"}})(),i=new d.CanvasLayer(e,o),{x:s,y:l,width:r,height:a}=this.grid_box_view.bbox.relative();i.resize(r,a),i.ctx.save();const n=getComputedStyle(this.el).backgroundColor;i.ctx.fillStyle=n,i.ctx.fillRect(s,l,r,a);for(const e of this.child_views){const s=e.export(t,o),{x:l,y:r}=e.bbox;i.ctx.drawImage(s.canvas,l,r)}return i.ctx.restore(),i}}e.GridPlotView=b,b.__name__="GridPlotView";class w extends r.LayoutDOM{constructor(t){super(t)}}e.GridPlot=w,l=w,w.__name__="GridPlot",l.prototype.default_view=b,l.define((({Int:t,Number:o,Tuple:e,Array:i,Ref:s,Or:l,Opt:a,Nullable:_})=>({toolbar:[s(c.Toolbar),()=>new c.Toolbar],toolbar_location:[_(u.Location),"above"],children:[i(e(s(r.LayoutDOM),t,t,a(t),a(t))),[]],rows:[_(n.TracksSizing),null],cols:[_(n.TracksSizing),null],spacing:[l(o,e(o,o)),0]})))},
function _(e,t,s,i,a){var r;i();const n=e(383);class _ extends n.PlotView{serializable_state(){const e=super.serializable_state();return Object.assign(Object.assign({},e),{type:"Plot"})}}s.FigureView=_,_.__name__="FigureView";class l extends n.Plot{constructor(e){super(e)}}s.Figure=l,r=l,l.__name__="Figure",r.prototype.default_view=_},
function _(t,_,n,o,r){o();t(1).__exportStar(t(162),n)},
function _(e,r,n,d,R){d(),R("ContourRenderer",e(395).ContourRenderer),R("GlyphRenderer",e(198).GlyphRenderer),R("GraphRenderer",e(396).GraphRenderer),R("GuideRenderer",e(159).GuideRenderer);var G=e(73);R("Renderer",G.Renderer),R("RendererGroup",G.RendererGroup)},
function _(e,r,i,n,t){var l;n();const _=e(199),s=e(198),a=e(58);class d extends _.DataRendererView{get glyph_view(){return this.fill_view.glyph.data_size>0?this.fill_view.glyph:this.line_view.glyph}async lazy_initialize(){await super.lazy_initialize();const{parent:e}=this,{fill_renderer:r,line_renderer:i}=this.model;this.fill_view=await(0,a.build_view)(r,{parent:e}),this.line_view=await(0,a.build_view)(i,{parent:e})}remove(){this.fill_view.remove(),this.line_view.remove(),super.remove()}_render(){this.fill_view.render(),this.line_view.render()}renderer_view(e){if(e instanceof s.GlyphRenderer){if(e==this.fill_view.model)return this.fill_view;if(e==this.line_view.model)return this.line_view}return super.renderer_view(e)}}i.ContourRendererView=d,d.__name__="ContourRendererView";class o extends _.DataRenderer{constructor(e){super(e)}get_selection_manager(){return this.fill_renderer.data_source.selection_manager}}i.ContourRenderer=o,l=o,o.__name__="ContourRenderer",l.prototype.default_view=d,l.define((({Array:e,Number:r,Ref:i})=>({fill_renderer:[i(s.GlyphRenderer)],line_renderer:[i(s.GlyphRenderer)],levels:[e(r),[]]})))},
function _(e,r,i,n,t){var o;n();const s=e(199),d=e(198),a=e(343),p=e(342),l=e(58),_=e(201),h=e(323),y=e(325);class c extends s.DataRendererView{get glyph_view(){return this.node_view.glyph}async lazy_initialize(){await super.lazy_initialize(),this.apply_coordinates();const{parent:e}=this,{edge_renderer:r,node_renderer:i}=this.model;this.edge_view=await(0,l.build_view)(r,{parent:e}),this.node_view=await(0,l.build_view)(i,{parent:e})}connect_signals(){super.connect_signals(),this.connect(this.model.layout_provider.change,(()=>{this.apply_coordinates(),this.edge_view.set_data(),this.node_view.set_data(),this.request_render()}))}apply_coordinates(){const{edge_renderer:e,node_renderer:r}=this.model;if(!(e.glyph instanceof h.MultiLine||e.glyph instanceof y.Patches))throw new Error(`${this}.edge_renderer.glyph must be a MultiLine glyph`);if(!(r.glyph instanceof _.XYGlyph))throw new Error(`${this}.node_renderer.glyph must be a XYGlyph glyph`);const i=this.model.layout_provider.edge_coordinates,n=this.model.layout_provider.node_coordinates;e.glyph.properties.xs.internal=!0,e.glyph.properties.ys.internal=!0,r.glyph.properties.x.internal=!0,r.glyph.properties.y.internal=!0,e.glyph.xs={expr:i.x},e.glyph.ys={expr:i.y},r.glyph.x={expr:n.x},r.glyph.y={expr:n.y}}remove(){this.edge_view.remove(),this.node_view.remove(),super.remove()}_render(){this.edge_view.render(),this.node_view.render()}renderer_view(e){if(e instanceof d.GlyphRenderer){if(e==this.edge_view.model)return this.edge_view;if(e==this.node_view.model)return this.node_view}return super.renderer_view(e)}}i.GraphRendererView=c,c.__name__="GraphRendererView";class g extends s.DataRenderer{constructor(e){super(e)}get_selection_manager(){return this.node_renderer.data_source.selection_manager}}i.GraphRenderer=g,o=g,g.__name__="GraphRenderer",o.prototype.default_view=c,o.define((({Ref:e})=>({layout_provider:[e(a.LayoutProvider)],node_renderer:[e(d.GlyphRenderer)],edge_renderer:[e(d.GlyphRenderer)],selection_policy:[e(p.GraphHitTestPolicy),()=>new p.NodesOnly],inspection_policy:[e(p.GraphHitTestPolicy),()=>new p.NodesOnly]})))},
function _(e,t,n,o,c){o();e(1).__exportStar(e(101),n),c("Selection",e(100).Selection)},
function _(y,B,a,s,C){s(),C("ByID",y(399).ByID),C("ByClass",y(401).ByClass),C("ByCSS",y(402).ByCSS),C("ByXPath",y(403).ByXPath)},
function _(e,n,r,t,c){t();const o=e(400);class s extends o.Selector{constructor(e){super(e)}find_one(e){return e.querySelector(`#${this.query}`)}}r.ByID=s,s.__name__="ByID"},
function _(e,n,r,t,c){var o;t();const s=e(50);class _ extends s.Model{constructor(e){super(e)}}r.Selector=_,o=_,_.__name__="Selector",o.define((({String:e})=>({query:[e]})))},
function _(e,s,n,r,t){r();const c=e(400);class o extends c.Selector{constructor(e){super(e)}find_one(e){return e.querySelector(`.${this.query}`)}}n.ByClass=o,o.__name__="ByClass"},
function _(e,n,r,t,c){t();const o=e(400);class s extends o.Selector{constructor(e){super(e)}find_one(e){return e.querySelector(this.query)}}r.ByCSS=s,s.__name__="ByCSS"},
function _(e,t,n,r,a){r();const c=e(400);class o extends c.Selector{constructor(e){super(e)}find_one(e){return document.evaluate(this.query,e).iterateNext()}}n.ByXPath=o,o.__name__="ByXPath"},
function _(a,e,S,o,r){o(),r("ServerSentDataSource",a(405).ServerSentDataSource),r("AjaxDataSource",a(407).AjaxDataSource),r("ColumnDataSource",a(103).ColumnDataSource),r("ColumnarDataSource",a(98).ColumnarDataSource),r("CDSView",a(214).CDSView),r("DataSource",a(102).DataSource),r("GeoJSONDataSource",a(408).GeoJSONDataSource),r("WebDataSource",a(406).WebDataSource)},
function _(e,t,i,a,s){a();const n=e(406);class r extends n.WebDataSource{constructor(e){super(e),this.initialized=!1}setup(){if(!this.initialized){this.initialized=!0;new EventSource(this.data_url).onmessage=e=>{var t;this.load_data(JSON.parse(e.data),this.mode,null!==(t=this.max_size)&&void 0!==t?t:void 0)}}}}i.ServerSentDataSource=r,r.__name__="ServerSentDataSource"},
function _(t,e,a,n,r){var s;n();const l=t(103),i=t(19);class o extends l.ColumnDataSource{constructor(t){super(t)}get_column(t){return t in this.data?this.data[t]:[]}get_length(){var t;return null!==(t=super.get_length())&&void 0!==t?t:0}initialize(){super.initialize(),this.setup()}load_data(t,e,a){const{adapter:n}=this;let r;switch(r=null!=n?n.execute(this,{response:t}):t,e){case"replace":this.data=r;break;case"append":{const t=this.data;for(const e of this.columns()){const n=Array.from(t[e]),s=Array.from(r[e]),l=n.concat(s);r[e]=null!=a?l.slice(-a):l}this.data=r;break}}}}a.WebDataSource=o,s=o,o.__name__="WebDataSource",s.define((({Any:t,Int:e,String:a,Nullable:n})=>({max_size:[n(e),null],mode:[i.UpdateMode,"replace"],adapter:[n(t),null],data_url:[a]})))},
function _(t,e,i,s,a){var n;s();const r=t(406),o=t(19),l=t(18),d=t(9);class h extends r.WebDataSource{constructor(t){super(t),this.interval=null,this.initialized=!1}destroy(){null!=this.interval&&clearInterval(this.interval),super.destroy()}setup(){if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),null!=this.polling_interval)){const t=()=>this.get_data(this.mode,this.max_size,this.if_modified);this.interval=setInterval(t,this.polling_interval)}}get_data(t,e=null,i=!1){const s=this.prepare_request();s.addEventListener("load",(()=>this.do_load(s,t,null!=e?e:void 0))),s.addEventListener("error",(()=>this.do_error(s))),s.send()}prepare_request(){const t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);const e=this.http_headers;for(const[i,s]of(0,d.entries)(e))t.setRequestHeader(i,s);return t}do_load(t,e,i){if(200===t.status){const s=JSON.parse(t.responseText);this.load_data(s,e,i)}}do_error(t){l.logger.error(`Failed to fetch JSON from ${this.data_url} with code ${t.status}`)}}i.AjaxDataSource=h,n=h,h.__name__="AjaxDataSource",n.define((({Boolean:t,Int:e,String:i,Dict:s,Nullable:a})=>({polling_interval:[a(e),null],content_type:[i,"application/json"],http_headers:[s(i),{}],method:[o.HTTPMethod,"POST"],if_modified:[t,!1]})))},
function _(e,t,o,r,n){var s;r();const a=e(98),i=e(18),l=e(8),c=e(10),_=e(9);function g(e){return null!=e?e:NaN}const{hasOwnProperty:u}=Object.prototype;class y extends a.ColumnarDataSource{constructor(e){super(e)}initialize(){super.initialize(),this._update_data()}connect_signals(){super.connect_signals(),this.connect(this.properties.geojson.change,(()=>this._update_data()))}_update_data(){this.data=this.geojson_to_column_data()}_get_new_list_array(e){return(0,c.range)(0,e).map((e=>[]))}_get_new_nan_array(e){return(0,c.range)(0,e).map((e=>NaN))}_add_properties(e,t,o,r){var n;const s=null!==(n=e.properties)&&void 0!==n?n:{};for(const[e,n]of(0,_.entries)(s))u.call(t,e)||(t[e]=this._get_new_nan_array(r)),t[e][o]=g(n)}_add_geometry(e,t,o){function r(e,t){return e.concat([[NaN,NaN,NaN]]).concat(t)}switch(e.type){case"Point":{const[r,n,s]=e.coordinates;t.x[o]=r,t.y[o]=n,t.z[o]=g(s);break}case"LineString":{const{coordinates:r}=e;for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=g(a)}break}case"Polygon":{e.coordinates.length>1&&i.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");const r=e.coordinates[0];for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=g(a)}break}case"MultiPoint":i.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":{const n=e.coordinates.reduce(r);for(let e=0;e<n.length;e++){const[r,s,a]=n[e];t.xs[o][e]=r,t.ys[o][e]=s,t.zs[o][e]=g(a)}break}case"MultiPolygon":{const n=[];for(const t of e.coordinates)t.length>1&&i.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),n.push(t[0]);const s=n.reduce(r);for(let e=0;e<s.length;e++){const[r,n,a]=s[e];t.xs[o][e]=r,t.ys[o][e]=n,t.zs[o][e]=g(a)}break}default:throw new Error(`Invalid GeoJSON geometry type: ${e.type}`)}}geojson_to_column_data(){const e=JSON.parse(this.geojson);let t;switch(e.type){case"GeometryCollection":if((0,l.is_undefined)(e.geometries))throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if((0,l.is_undefined)(e.features))throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}let o=0;for(const e of t){const t="Feature"===e.type?e.geometry:e;"GeometryCollection"==t.type?o+=t.geometries.length:o+=1}const r={x:this._get_new_nan_array(o),y:this._get_new_nan_array(o),z:this._get_new_nan_array(o),xs:this._get_new_list_array(o),ys:this._get_new_list_array(o),zs:this._get_new_list_array(o)};let n=0;for(const e of t){const t="Feature"==e.type?e.geometry:e;if("GeometryCollection"==t.type)for(const s of t.geometries)this._add_geometry(s,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1;else this._add_geometry(t,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1}return r}}o.GeoJSONDataSource=y,s=y,y.__name__="GeoJSONDataSource",s.define((({String:e})=>({geojson:[e]}))),s.internal((({Any:e,Dict:t,Arrayable:o})=>({data:[t(o(e)),{}]})))},
function _(e,r,T,o,S){o(),S("BBoxTileSource",e(410).BBoxTileSource),S("MercatorTileSource",e(411).MercatorTileSource),S("QUADKEYTileSource",e(414).QUADKEYTileSource),S("TileRenderer",e(415).TileRenderer),S("TileSource",e(412).TileSource),S("TMSTileSource",e(418).TMSTileSource),S("WMTSTileSource",e(416).WMTSTileSource)},
function _(e,t,r,o,l){var i;o();const n=e(411);class s extends n.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars);let l,i,n,s;return this.use_latlon?[i,s,l,n]=this.get_tile_geographic_bounds(e,t,r):[i,s,l,n]=this.get_tile_meter_bounds(e,t,r),o.replace("{XMIN}",i.toString()).replace("{YMIN}",s.toString()).replace("{XMAX}",l.toString()).replace("{YMAX}",n.toString())}}r.BBoxTileSource=s,i=s,s.__name__="BBoxTileSource",i.define((({Boolean:e})=>({use_latlon:[e,!1]})))},
function _(t,e,i,_,s){var r;_();const o=t(412),n=t(10),l=t(413);class u extends o.TileSource{constructor(t){super(t)}initialize(){super.initialize(),this._resolutions=(0,n.range)(this.min_zoom,this.max_zoom+1).map((t=>this.get_resolution(t)))}_computed_initial_resolution(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size}is_valid_tile(t,e,i){return!(!this.wrap_around&&(t<0||t>=2**i))&&!(e<0||e>=2**i)}parent_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=_.substring(0,_.length-1);return this.quadkey_to_tile_xyz(s)}get_resolution(t){return this._computed_initial_resolution()/2**t}get_resolution_by_extent(t,e,i){return[(t[2]-t[0])/i,(t[3]-t[1])/e]}get_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s);let o=0;for(const t of this._resolutions){if(r>t){if(0==o)return 0;if(o>0)return o-1}o+=1}return o-1}get_closest_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s),o=this._resolutions.reduce((function(t,e){return Math.abs(e-r)<Math.abs(t-r)?e:t}));return this._resolutions.indexOf(o)}snap_to_zoom_level(t,e,i,_){const[s,r,o,n]=t,l=this._resolutions[_];let u=i*l,a=e*l;if(!this.snap_to_zoom){const t=(o-s)/u,e=(n-r)/a;t>e?(u=o-s,a*=t):(u*=e,a=n-r)}const h=(u-(o-s))/2,c=(a-(n-r))/2;return[s-h,r-c,o+h,n+c]}tms_to_wmts(t,e,i){return[t,2**i-1-e,i]}wmts_to_tms(t,e,i){return[t,2**i-1-e,i]}pixels_to_meters(t,e,i){const _=this.get_resolution(i);return[t*_-this.x_origin_offset,e*_-this.y_origin_offset]}meters_to_pixels(t,e,i){const _=this.get_resolution(i);return[(t+this.x_origin_offset)/_,(e+this.y_origin_offset)/_]}pixels_to_tile(t,e){let i=Math.ceil(t/this.tile_size);i=0===i?i:i-1;return[i,Math.max(Math.ceil(e/this.tile_size)-1,0)]}pixels_to_raster(t,e,i){return[t,(this.tile_size<<i)-e]}meters_to_tile(t,e,i){const[_,s]=this.meters_to_pixels(t,e,i);return this.pixels_to_tile(_,s)}get_tile_meter_bounds(t,e,i){const[_,s]=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),[r,o]=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i);return[_,s,r,o]}get_tile_geographic_bounds(t,e,i){const _=this.get_tile_meter_bounds(t,e,i),[s,r,o,n]=(0,l.meters_extent_to_geographic)(_);return[s,r,o,n]}get_tiles_by_extent(t,e,i=1){const[_,s,r,o]=t;let[n,l]=this.meters_to_tile(_,s,e),[u,a]=this.meters_to_tile(r,o,e);n-=i,l-=i,u+=i,a+=i;const h=[];for(let t=a;t>=l;t--)for(let i=n;i<=u;i++)this.is_valid_tile(i,t,e)&&h.push([i,t,e,this.get_tile_meter_bounds(i,t,e)]);return this.sort_tiles_from_center(h,[n,l,u,a]),h}quadkey_to_tile_xyz(t){let e=0,i=0;const _=t.length;for(let s=_;s>0;s--){const r=1<<s-1;switch(t.charAt(_-s)){case"0":continue;case"1":e|=r;break;case"2":i|=r;break;case"3":e|=r,i|=r;break;default:throw new TypeError(`Invalid Quadkey: ${t}`)}}return[e,i,_]}tile_xyz_to_quadkey(t,e,i){let _="";for(let s=i;s>0;s--){const i=1<<s-1;let r=0;0!=(t&i)&&(r+=1),0!=(e&i)&&(r+=2),_+=r.toString()}return _}children_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=[];for(let t=0;t<=3;t++){const[e,i,r]=this.quadkey_to_tile_xyz(_+t.toString()),o=this.get_tile_meter_bounds(e,i,r);s.push([e,i,r,o])}return s}get_closest_parent_by_tile_xyz(t,e,i){const _=this.calculate_world_x_by_tile_xyz(t,e,i);[t,e,i]=this.normalize_xyz(t,e,i);let s=this.tile_xyz_to_quadkey(t,e,i);for(;s.length>0;)if(s=s.substring(0,s.length-1),[t,e,i]=this.quadkey_to_tile_xyz(s),[t,e,i]=this.denormalize_xyz(t,e,i,_),this.tiles.has(this.tile_xyz_to_key(t,e,i)))return[t,e,i];return[0,0,0]}normalize_xyz(t,e,i){if(this.wrap_around){const _=2**i;return[(t%_+_)%_,e,i]}return[t,e,i]}denormalize_xyz(t,e,i,_){return[t+_*2**i,e,i]}denormalize_meters(t,e,i,_){return[t+2*_*Math.PI*6378137,e]}calculate_world_x_by_tile_xyz(t,e,i){return Math.floor(t/2**i)}}i.MercatorTileSource=u,r=u,u.__name__="MercatorTileSource",r.define((({Boolean:t})=>({snap_to_zoom:[t,!1],wrap_around:[t,!0]}))),r.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})},
function _(e,t,r,i,n){var l;i();const a=e(50),s=e(9);class c extends a.Model{constructor(e){super(e)}initialize(){super.initialize(),this.tiles=new Map,this._normalize_case()}connect_signals(){super.connect_signals(),this.connect(this.change,(()=>this._clear_cache()))}string_lookup_replace(e,t){let r=e;for(const[e,i]of(0,s.entries)(t))r=r.replace(`{${e}}`,i);return r}_normalize_case(){const e=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=e}_clear_cache(){this.tiles=new Map}tile_xyz_to_key(e,t,r){return`${e}:${t}:${r}`}key_to_tile_xyz(e){const[t,r,i]=e.split(":").map((e=>parseInt(e)));return[t,r,i]}sort_tiles_from_center(e,t){const[r,i,n,l]=t,a=(n-r)/2+r,s=(l-i)/2+i;e.sort((function(e,t){return Math.sqrt((a-e[0])**2+(s-e[1])**2)-Math.sqrt((a-t[0])**2+(s-t[1])**2)}))}get_image_url(e,t,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",t.toString()).replace("{Z}",r.toString())}}r.TileSource=c,l=c,c.__name__="TileSource",l.define((({Number:e,String:t,Dict:r,Nullable:i})=>({url:[t,""],tile_size:[e,256],max_zoom:[e,30],min_zoom:[e,0],extra_url_vars:[r(t),{}],attribution:[t,""],x_origin_offset:[e],y_origin_offset:[e],initial_resolution:[i(e),null]})))},
function _(t,e,r,n,o){n();const c=t(104);function _(t,e){return c.wgs84_mercator.compute(t,e)}function g(t,e){return c.wgs84_mercator.invert(t,e)}r.geographic_to_meters=_,r.meters_to_geographic=g,r.geographic_extent_to_meters=function(t){const[e,r,n,o]=t,[c,g]=_(e,r),[i,u]=_(n,o);return[c,g,i,u]},r.meters_extent_to_geographic=function(t){const[e,r,n,o]=t,[c,_]=g(e,r),[i,u]=g(n,o);return[c,_,i,u]}},
function _(e,t,r,s,_){s();const o=e(411);class c extends o.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const s=this.string_lookup_replace(this.url,this.extra_url_vars),[_,o,c]=this.tms_to_wmts(e,t,r),i=this.tile_xyz_to_quadkey(_,o,c);return s.replace("{Q}",i)}}r.QUADKEYTileSource=c,c.__name__="QUADKEYTileSource"},
function _(t,e,i,s,_){s();const n=t(1);var a;const h=t(412),o=t(416),r=t(73),l=t(87),d=t(55),m=t(149),c=t(10),p=t(8),u=n.__importDefault(t(417));class g extends r.RendererView{initialize(){this._tiles=[],super.initialize()}connect_signals(){super.connect_signals(),this.connect(this.model.change,(()=>this.request_render())),this.connect(this.model.tile_source.change,(()=>this.request_render()))}remove(){null!=this.attribution_el&&(0,d.remove)(this.attribution_el),super.remove()}get_extent(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]}get map_plot(){return this.plot_model}get map_canvas(){return this.layer.ctx}get map_frame(){return this.plot_view.frame}get x_range(){return this.map_plot.x_range}get y_range(){return this.map_plot.y_range}_set_data(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0}_update_attribution(){null!=this.attribution_el&&(0,d.remove)(this.attribution_el);const{attribution:t}=this.model.tile_source;if((0,p.isString)(t)&&t.length>0){const{layout:e,frame:i}=this.plot_view,s=e.bbox.width-i.bbox.right,_=e.bbox.height-i.bbox.bottom,n=i.bbox.width;this.attribution_el=(0,d.div)({style:{right:`${s}px`,bottom:`${_}px`,"max-width":`${n}px`}});const a=(0,d.div)();a.innerHTML=t;const h=this.attribution_el.attachShadow({mode:"open"}),o=new d.StyleSheet(u.default);h.appendChild(o.el),h.appendChild(a),this.attribution_el.title=a.textContent.replace(/\s*\n\s*/g," "),this.plot_view.canvas_view.add_event(this.attribution_el)}}_map_data(){this.initial_extent=this.get_extent();const t=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width),e=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width,t);this.x_range.start=e[0],this.y_range.start=e[1],this.x_range.end=e[2],this.y_range.end=e[3],this.x_range instanceof l.Range1d&&(this.x_range.reset_start=e[0],this.x_range.reset_end=e[2]),this.y_range instanceof l.Range1d&&(this.y_range.reset_start=e[1],this.y_range.reset_end=e[3]),this._update_attribution()}_create_tile(t,e,i,s,_=!1){const n=this.model.tile_source.tile_xyz_to_quadkey(t,e,i),a=this.model.tile_source.tile_xyz_to_key(t,e,i);if(this.model.tile_source.tiles.has(a))return;const[h,o,r]=this.model.tile_source.normalize_xyz(t,e,i),l=this.model.tile_source.get_image_url(h,o,r),d={img:void 0,tile_coords:[t,e,i],normalized_coords:[h,o,r],quadkey:n,cache_key:a,bounds:s,loaded:!1,finished:!1,x_coord:s[0],y_coord:s[3]};this.model.tile_source.tiles.set(a,d),this._tiles.push(d),new m.ImageLoader(l,{loaded:t=>{Object.assign(d,{img:t,loaded:!0}),_?(d.finished=!0,this.notify_finished()):this.request_render()},failed(){d.finished=!0}})}_enforce_aspect_ratio(){if(this._last_height!==this.map_frame.bbox.height||this._last_width!==this.map_frame.bbox.width){const t=this.get_extent(),e=this.model.tile_source.get_level_by_extent(t,this.map_frame.bbox.height,this.map_frame.bbox.width),i=this.model.tile_source.snap_to_zoom_level(t,this.map_frame.bbox.height,this.map_frame.bbox.width,e);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame.bbox.height,this._last_width=this.map_frame.bbox.width}}has_finished(){if(!super.has_finished())return!1;if(0==this._tiles.length)return!1;for(const t of this._tiles)if(!t.finished)return!1;return!0}_render(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()}_draw_tile(t){const e=this.model.tile_source.tiles.get(t);if(null!=e&&e.loaded){const[[t],[i]]=this.coordinates.map_to_screen([e.bounds[0]],[e.bounds[3]]),[[s],[_]]=this.coordinates.map_to_screen([e.bounds[2]],[e.bounds[1]]),n=s-t,a=_-i,h=t,o=i,r=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(e.img,h,o,n,a),this.map_canvas.setImageSmoothingEnabled(r),e.finished=!0}}_set_rect(){const t=this.plot_model.outline_line_width,e=this.map_frame.bbox.left+t/2,i=this.map_frame.bbox.top+t/2,s=this.map_frame.bbox.width-t,_=this.map_frame.bbox.height-t;this.map_canvas.rect(e,i,s,_),this.map_canvas.clip()}_render_tiles(t){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(const e of t)this._draw_tile(e);this.map_canvas.restore()}_prefetch_tiles(){const{tile_source:t}=this.model,e=this.get_extent(),i=this.map_frame.bbox.height,s=this.map_frame.bbox.width,_=this.model.tile_source.get_level_by_extent(e,i,s),n=this.model.tile_source.get_tiles_by_extent(e,_);for(let e=0,i=Math.min(10,n.length);e<i;e++){const[i,s,_]=n[e],a=this.model.tile_source.children_by_tile_xyz(i,s,_);for(const e of a){const[i,s,_,n]=e;t.tiles.has(t.tile_xyz_to_key(i,s,_))||this._create_tile(i,s,_,n,!0)}}}_fetch_tiles(t){for(const e of t){const[t,i,s,_]=e;this._create_tile(t,i,s,_)}}_update(){const{tile_source:t}=this.model,{min_zoom:e}=t,{max_zoom:i}=t;let s=this.get_extent();const _=this.extent[2]-this.extent[0]<s[2]-s[0],n=this.map_frame.bbox.height,a=this.map_frame.bbox.width;let h=t.get_level_by_extent(s,n,a),o=!1;h<e?(s=this.extent,h=e,o=!0):h>i&&(s=this.extent,h=i,o=!0),o&&(this.x_range.setv({start:s[0],end:s[2]}),this.y_range.setv({start:s[1],end:s[3]})),this.extent=s;const r=t.get_tiles_by_extent(s,h),l=[],d=[],m=[],p=[];for(const e of r){const[i,s,n]=e,a=t.tile_xyz_to_key(i,s,n),h=t.tiles.get(a);if(null!=h&&h.loaded)d.push(a);else if(this.model.render_parents){const[e,a,h]=t.get_closest_parent_by_tile_xyz(i,s,n),o=t.tile_xyz_to_key(e,a,h),r=t.tiles.get(o);if(null!=r&&r.loaded&&!(0,c.includes)(m,o)&&m.push(o),_){const e=t.children_by_tile_xyz(i,s,n);for(const[i,s,_]of e){const e=t.tile_xyz_to_key(i,s,_);t.tiles.has(e)&&p.push(e)}}}null==h&&l.push(e)}this._render_tiles(m),this._render_tiles(p),this._render_tiles(d),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout((()=>this._fetch_tiles(l)),65)}}i.TileRendererView=g,g.__name__="TileRendererView";class b extends r.Renderer{constructor(t){super(t)}}i.TileRenderer=b,a=b,b.__name__="TileRenderer",a.prototype.default_view=g,a.define((({Boolean:t,Number:e,Ref:i})=>({alpha:[e,1],smoothing:[t,!0],tile_source:[i(h.TileSource),()=>new o.WMTSTileSource],render_parents:[t,!0]}))),a.override({level:"image"})},
function _(t,e,r,o,s){o();const c=t(411);class i extends c.MercatorTileSource{constructor(t){super(t)}get_image_url(t,e,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars),[s,c,i]=this.tms_to_wmts(t,e,r);return o.replace("{X}",s.toString()).replace("{Y}",c.toString()).replace("{Z}",i.toString())}}r.WMTSTileSource=i,i.__name__="WMTSTileSource"},
function _(o,e,i,l,t){l(),i.default=":host{position:absolute;padding:2px;background-color:rgba(255, 255, 255, 0.5);font-size:9px;line-height:1.05;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;}a{color:black;}"},
function _(e,r,t,c,o){c();const i=e(411);class l extends i.MercatorTileSource{constructor(e){super(e)}get_image_url(e,r,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",r.toString()).replace("{Z}",t.toString())}}t.TMSTileSource=l,l.__name__="TMSTileSource"},
function _(e,t,u,a,r){a(),r("CanvasTexture",e(420).CanvasTexture),r("ImageURLTexture",e(422).ImageURLTexture),r("Texture",e(421).Texture)},
function _(t,e,n,c,s){var r;c();const o=t(421),a=t(38);class u extends o.Texture{constructor(t){super(t)}get func(){const t=(0,a.use_strict)(this.code);return new Function("ctx","color","scale","weight",t)}get_pattern(t,e,n){const c=document.createElement("canvas");c.width=e,c.height=e;const s=c.getContext("2d");return this.func.call(this,s,t,e,n),c}}n.CanvasTexture=u,r=u,u.__name__="CanvasTexture",r.define((({String:t})=>({code:[t]})))},
function _(e,t,n,r,o){var i;r();const s=e(50),u=e(19);class c extends s.Model{constructor(e){super(e)}}n.Texture=c,i=c,c.__name__="Texture",i.define((()=>({repetition:[u.TextureRepetition,"repeat"]})))},
function _(e,t,i,r,n){var a;r();const s=e(421),o=e(149);class u extends s.Texture{constructor(e){super(e)}initialize(){super.initialize(),this._loader=new o.ImageLoader(this.url)}get_pattern(e,t,i){const{_loader:r}=this;return this._loader.finished?r.image:r.promise}}i.ImageURLTexture=u,a=u,u.__name__="ImageURLTexture",a.define((({String:e})=>({url:[e]})))},
function _(o,e,t,n,l){n();o(1).__exportStar(o(424),t),l("Dialog",o(428).Dialog),l("Inspector",o(432).Inspector),l("Pane",o(434).Pane),l("Tooltip",o(435).Tooltip),l("UIElement",o(251).UIElement)},
function _(n,c,o,I,i){I(),i("BuiltinIcon",n(425).BuiltinIcon),i("SVGIcon",n(426).SVGIcon),i("TablerIcon",n(427).TablerIcon)},
function _(e,n,t,i,s){i();const o=e(1);var r;const a=e(368),c=e(55),l=e(21),m=e(8),u=o.__importDefault(e(265));class _ extends a.IconView{constructor(){super(...arguments),this._style=new c.StyleSheet}styles(){return[...super.styles(),u.default,this._style]}render(){super.render();const e=`var(--bokeh-icon-${this.model.icon_name})`,n=(0,l.color2css)(this.model.color),t=(()=>{const{size:e}=this.model;return(0,m.isNumber)(e)?`${e}px`:e})();this._style.replace(`\n      :host {\n        display: inline-block;\n        vertical-align: middle;\n        width: ${t};\n        height: ${t};\n        background-color: ${n};\n        mask-image: ${e};\n        mask-size: contain;\n        mask-repeat: no-repeat;\n        -webkit-mask-image: ${e};\n        -webkit-mask-size: contain;\n        -webkit-mask-repeat: no-repeat;\n      }\n    `)}}t.BuiltinIconView=_,_.__name__="BuiltinIconView";class d extends a.Icon{constructor(e){super(e)}}t.BuiltinIcon=d,r=d,d.__name__="BuiltinIcon",r.prototype.default_view=_,r.define((({String:e,Color:n})=>({icon_name:[e],color:[n,"gray"]})))},
function _(e,n,s,t,r){var i;t();const o=e(368),c=e(55),l=e(8);class a extends o.IconView{constructor(){super(...arguments),this._style=new c.StyleSheet}styles(){return[...super.styles(),this._style]}render(){super.render();const e=(()=>{const{size:e}=this.model;return(0,l.isNumber)(e)?`${e}px`:e})();this._style.replace(`\n      :host {\n        display: inline-block;\n        vertical-align: middle;\n      }\n      :host svg {\n        width: ${e};\n        height: ${e};\n      }\n    `);const n=(new DOMParser).parseFromString(this.model.svg,"image/svg+xml");this.shadow_el.append(n.documentElement)}}s.SVGIconView=a,a.__name__="SVGIconView";class d extends o.Icon{constructor(e){super(e)}}s.SVGIcon=d,i=d,d.__name__="SVGIcon",i.prototype.default_view=a,i.define((({String:e})=>({svg:[e]})))},
function _(e,n,t,s,o){var r,l;s();const i=e(368),a=e(55),c=e(8);class f extends i.IconView{constructor(){super(...arguments),this._tabler=new a.ImportedStyleSheet(`${f._url}/tabler-icons.min.css`),this._style=new a.StyleSheet}styles(){return[...super.styles(),this._tabler,this._style]}initialize(){super.initialize(),f._fonts.initialize()}render(){super.render();const e=(()=>{const{size:e}=this.model;return(0,c.isNumber)(e)?`${e}px`:e})();this._style.replace(`\n      :host {\n        display: inline-block;\n        vertical-align: middle;\n        font-size: ${e};\n      }\n    `);const n=(0,a.span)({class:["ti",`ti-${this.model.icon_name}`]});this.shadow_el.appendChild(n)}}t.TablerIconView=f,r=f,f.__name__="TablerIconView",f._url="https://unpkg.com/@tabler/icons@latest/iconfont",f._fonts=new a.GlobalStyleSheet(`    /*!\n    * Tabler Icons 1.68.0 by tabler - https://tabler.io\n    * License - https://github.com/tabler/tabler-icons/blob/master/LICENSE\n    */\n  @font-face {\n    font-family: "tabler-icons";\n    font-style: normal;\n    font-weight: 400;\n    src: url("${r._url}/fonts/tabler-icons.eot");\n    src: url("${r._url}/fonts/tabler-icons.eot?#iefix") format("embedded-opentype"),\n         url("${r._url}/fonts/tabler-icons.woff2") format("woff2"),\n         url("${r._url}/fonts/tabler-icons.woff") format("woff"),\n         url("${r._url}/fonts/tabler-icons.ttf") format("truetype"),\n         url("${r._url}/fonts/tabler-icons.svg#tabler-icons") format("svg");\n  }\n\n  @media screen and (-webkit-min-device-pixel-ratio: 0) {\n    @font-face {\n      font-family: "tabler-icons";\n      src: url("${r._url}/fonts/tabler-icons.svg#tabler-icons") format("svg");\n    }\n  }\n`);class b extends i.Icon{constructor(e){super(e)}}t.TablerIcon=b,l=b,b.__name__="TablerIcon",l.prototype.default_view=f,l.define((({String:e})=>({icon_name:[e]})))},
function _(e,t,i,s,n){s();const l=e(1);var o;const a=e(251),d=e(429),r=e(430),c=e(55),h=e(8),_=e(58),p=l.__importStar(e(431)),u=p,m=l.__importDefault(e(265)),v=a.UIElement;class w extends a.UIElementView{styles(){return[...super.styles(),p.default,m.default]}async lazy_initialize(){await super.lazy_initialize();const e=(()=>{const{content:e}=this.model;return(0,h.isString)(e)?new r.Text({content:e}):e})();this._content=await(0,_.build_view)(e,{parent:this})}connect_signals(){super.connect_signals();const{visible:e}=this.model.properties;this.on_change(e,(()=>this.render()))}remove(){this._content.remove(),super.remove()}render(){if(super.render(),!this.model.visible)return void this.el.remove();document.body.appendChild(this.el),this._content.render();const e=(0,c.div)({class:u.title}),t=(0,c.div)({class:u.content},this._content.el),i=(0,c.div)({class:u.buttons});if(this.shadow_el.appendChild(e),this.shadow_el.appendChild(t),this.shadow_el.appendChild(i),this.model.closable){const e=(0,c.div)({class:u.close});e.addEventListener("click",(()=>this.model.visible=!1)),this.shadow_el.appendChild(e)}}}i.DialogView=w,w.__name__="DialogView";class b extends a.UIElement{constructor(e){super(e)}}i.Dialog=b,o=b,b.__name__="Dialog",o.prototype.default_view=w,o.define((({Boolean:e,String:t,Array:i,Ref:s,Or:n,Nullable:l})=>({title:[l(n(t,s(d.DOMNode))),null],content:[n(t,s(d.DOMNode),s(a.UIElement))],buttons:[i(s(v)),[]],modal:[e,!1],closable:[e,!0],draggable:[e,!0]})))},
function _(e,o,_,d,s){d();const n=e(54),c=e(50);class t extends n.DOMView{}_.DOMNodeView=t,t.__name__="DOMNodeView";class M extends c.Model{constructor(e){super(e)}}_.DOMNode=M,M.__name__="DOMNode",M.__module__="bokeh.models.dom"},
function _(e,t,n,o,r){var c;o();const s=e(429);class _ extends s.DOMNodeView{render(){this.el.textContent=this.model.content}_createElement(){return document.createTextNode("")}}n.TextView=_,_.__name__="TextView";class d extends s.DOMNode{constructor(e){super(e)}}n.Text=d,c=d,d.__name__="Text",c.prototype.default_view=_,c.define((({String:e})=>({content:[e,""]})))},
function _(o,e,t,i,r){i(),t.title="bk-title",t.content="bk-content",t.buttons="bk-buttons",t.close="bk-close",t.default=":host{--bokeh-bg-color:white;--bokeh-border-color:#e5e5e5;--bokeh-shadow-color:#e5e5e5;}:host{position:fixed;z-index:1000;left:0;right:0;top:0;bottom:0;margin-left:auto;margin-right:auto;margin-top:auto;margin-bottom:auto;min-width:10vw;min-height:10vh;width:max-content;height:max-content;max-width:80vw;max-height:60vh;overflow:hidden;display:flex;flex-direction:column;flex-wrap:nowrap;background-color:var(--bokeh-bg-color);border:1px solid var(--bokeh-border-color);box-shadow:5px 5px 10px var(--bokeh-shadow-color);}.bk-title{position:relative;flex:1;min-height:0;}.bk-content{position:relative;flex:1;min-height:0;}.bk-buttons{position:relative;flex:1;min-height:0;}.bk-close{position:absolute;top:0;right:0;width:18px;height:18px;cursor:pointer;background-color:gray;mask-image:var(--bokeh-icon-x);mask-size:contain;mask-repeat:no-repeat;-webkit-mask-image:var(--bokeh-icon-x);-webkit-mask-size:contain;-webkit-mask-repeat:no-repeat;}.bk-close:hover{background-color:red;}"},
function _(t,s,e,n,o){n();const c=t(1);var l;const i=t(251),r=c.__importStar(t(17)),a=t(14),d=t(55),p=t(40),h=t(50),u=t(8),f=t(9),_=t(10),v=t(32),g=t(15),b=t(36),m=c.__importDefault(t(433));class y{constructor(t,s,e){this.click=t,this.max_items=s,this.max_depth=e,this.visited=new WeakSet,this.depth=0}to_html(t){if((0,u.isObject)(t)){if(this.visited.has(t))return(0,d.span)("<circular>");this.visited.add(t)}return null==t?this.null():(0,u.isBoolean)(t)?this.boolean(t):(0,u.isNumber)(t)?this.number(t):(0,u.isString)(t)?this.string(t):(0,u.isSymbol)(t)?this.symbol(t):t instanceof h.Model?this.model(t):t instanceof r.Property?this.property(t):(0,u.isPlainObject)(t)?this.object(t):(0,u.isArray)(t)?this.array(t):(0,u.isIterable)(t)?this.iterable(t):(0,d.span)((0,p.to_string)(t))}null(){return(0,d.span)({class:"null"},"null")}token(t){return(0,d.span)({class:"token"},t)}boolean(t){return(0,d.span)({class:"boolean"},`${t}`)}number(t){return(0,d.span)({class:"number"},`${t}`)}string(t){const s=t.includes("'"),e=t.includes('"'),n=s&&e?`\`${t.replace(/`/g,"\\`")}\``:e?`'${t}'`:`"${t}"`;return(0,d.span)({class:"string"},n)}symbol(t){return(0,d.span)({class:"symbol"},t.toString())}array(t){const s=this.token,e=[];let n=0;for(const s of t)if(e.push(this.to_html(s)),n++>this.max_items){e.push((0,d.span)("\u2026"));break}return(0,d.span)({class:"array"},s("["),...(0,v.interleave)(e,(()=>s(", "))),s("]"))}iterable(t){var s;const e=this.token,n=null!==(s=Object(t)[Symbol.toStringTag])&&void 0!==s?s:"Object",o=this.array([...t]);return(0,d.span)({class:"iterable"},`${n}`,e("("),o,e(")"))}object(t){const s=this.token,e=[];let n=0;for(const[o,c]of(0,f.entries)(t))if(e.push((0,d.span)(`${o}`,s(": "),this.to_html(c))),n++>this.max_items){e.push((0,d.span)("\u2026"));break}return(0,d.span)({class:"object"},s("{"),...(0,v.interleave)(e,(()=>s(", "))),s("}"))}model(t){const s=this.token,e=(0,d.span)({class:"model"},t.constructor.__qualified__,s("("),this.to_html(t.id),s(")"));return e.addEventListener("click",(()=>this.click(t))),e}property(t){const s=this.model(t.obj),e=(0,d.span)({class:"attr"},t.attr);return(0,d.span)(s,this.token("."),e)}}e.HTMLPrinter=y,y.__name__="HTMLPrinter";class k extends i.UIElementView{constructor(){super(...arguments),this.prev_listener=null,this.watched_props=new Set}styles(){return[...super.styles(),m.default]}render(){super.render(),null!=this.prev_listener&&b.diagnostics.disconnect(this.prev_listener);const t=[],s=[],e=[],n=new WeakMap;b.diagnostics.connect((o=>{if(o instanceof r.Property){for(const[s,e]of t)s==o.obj&&c(e);for(const[t,e]of s)if(t==o){const[,,,s]=e.children;l(t,e,s);break}for(const[t,s]of e)if(t==o){const[,e]=s.children;l(t,s,e);break}}function c(t){const s=n.get(t);null!=s&&s.cancel();const e=t.animate([{backgroundColor:"#def189"},{backgroundColor:"initial"}],{duration:2e3});n.set(t,e)}function l(t,s,e){s.classList.toggle("dirty",t.dirty),(0,d.empty)(e);const n=t.is_unset?(0,d.span)("unset"):S(t.get_value());e.appendChild(n),c(e)}}));const o=(()=>{const s=(0,d.input)({class:"filter",type:"text",placeholder:"Filter"});return s.addEventListener("keyup",(()=>{const e=s.value;for(const[s,n]of t){const t=s.constructor.__qualified__.includes(e);n.classList.toggle("hidden",!t)}})),(0,d.div)({class:"toolbar"},s)})(),c=(0,d.input)({type:"checkbox",checked:!0}),l=(0,d.input)({type:"checkbox",checked:!0}),i=()=>{for(const[t,e]of s){const s=c.checked,n=l.checked,o=!t.dirty&&!s||t.internal&&!n;e.classList.toggle("hidden",o)}};c.addEventListener("change",(()=>i())),l.addEventListener("change",(()=>i()));const p=(()=>{const t=(0,d.input)({class:"filter",type:"text",placeholder:"Filter"}),e=(0,d.span)({class:"checkbox"},(0,d.input)({type:"checkbox",checked:!0}),(0,d.span)("Group")),n=(0,d.span)({class:"checkbox"},c,(0,d.span)("Initial?")),o=(0,d.span)({class:"checkbox"},l,(0,d.span)("Internal?"));return t.addEventListener("keyup",(()=>{const e=t.value;for(const[t,n]of s){const s=t.attr.includes(e);n.classList.toggle("hidden",!s)}})),(0,d.div)({class:"toolbar"},t,e,n,o)})(),u=(()=>{const t=(0,d.input)({class:"filter",type:"text",placeholder:"Filter"});return t.addEventListener("keyup",(()=>{const s=t.value;for(const[t,n]of e){const e=t.attr.includes(s);n.classList.toggle("hidden",!e)}})),(0,d.div)({class:"toolbar"},t)})(),v=(0,d.div)({class:"models-list"}),m=(0,d.div)({class:"props-list"}),k=(0,d.div)({class:"watches-list"}),w=(0,d.div)({class:"models-panel"},o,v),x=(0,d.div)({class:"props-panel"},p,m),L=(0,d.div)({class:"watches-panel"},u,k),E=(0,d.div)({class:"col",style:{width:"100%"}},L,x),j=(0,d.div)({class:"inspector"},w,E);function I(t){t instanceof h.Model&&P(t)}function S(t){return new y(I,5,3).to_html(t)}const C=(s,e)=>{(0,_.clear)(t),(0,d.empty)(v);const n=null!=e?new Set(e.roots()):new Set;for(const e of s){const s=n.has(e)?(0,d.span)({class:"tag"},"root"):null,o=(0,d.span)({class:"model-ref",tabIndex:0},S(e),s);o.addEventListener("keydown",(t=>{t.keyCode==d.Keys.Enter&&P(e)})),t.push([e,o]),v.appendChild(o)}},P=e=>{var n;(0,_.clear)(s),(0,d.empty)(m);for(const[s,n]of t)n.classList.toggle("active",e==s);const o=(()=>{const t=[];let s=Object.getPrototypeOf(e);do{t.push([s.constructor,(0,f.keys)(s._props)]),s=Object.getPrototypeOf(s)}while(s.constructor!=a.HasProps);t.reverse();const n=[];for(const[,s]of t)s.splice(0,n.length),n.push(...s);return t})(),i=null!==(n=g.receivers_for_sender.get(e))&&void 0!==n?n:[];for(const[t,n]of o){if(0==n.length)continue;const o=(0,d.span)({class:["expander"]}),r=(0,d.div)({class:"base"},o,"inherited from"," ",(0,d.span)({class:"monospace"},t.__qualified__));m.appendChild(r);const a=[];for(const t of n){const n=e.property(t),o=n.kind.toString(),r=n.is_unset?(0,d.span)("unset"):S(n.get_value()),p=n.internal?(0,d.span)({class:"tag"},"internal"):null,h=i.filter((t=>t.signal==n.change)).length,u=0!=h?(0,d.span)({class:"tag"},`${h}`):null,f=this.watched_props.has(n),_=(0,d.input)({type:"checkbox",checked:f}),v=(0,d.div)({class:"prop-attr",tabIndex:0},_,(0,d.span)({class:"attr"},t),p),g=(0,d.div)({class:"prop-conns"},u),b=(0,d.div)({class:"prop-kind"},o),y=(0,d.div)({class:"prop-value"},r),k=n.dirty?"dirty":null,w=n.internal?"internal":null,x=c.checked,L=l.checked,E=!n.dirty&&!x||n.internal&&!L?"hidden":null,j=(0,d.div)({class:["prop",k,w,E]},v,g,b,y);a.push(j),s.push([n,j]),m.appendChild(j),_.addEventListener("change",(()=>{this.watched_props[_.checked?"add":"delete"](n),O()}))}r.addEventListener("click",(()=>{o.classList.toggle("closed");for(const t of a)t.classList.toggle("closed")}))}},O=()=>{if((0,_.clear)(e),(0,d.empty)(k),0==this.watched_props.size){const t=(0,d.div)({class:"nothing"},"No watched properties");k.appendChild(t)}else for(const t of this.watched_props){const s=(0,d.span)(S(t)),n=(0,d.span)(t.is_unset?(0,d.span)("unset"):S(t.get_value())),o=(0,d.div)({class:["prop",t.dirty?"dirty":null]},s,n);e.push([t,o]),k.appendChild(o)}};this.shadow_el.appendChild(j);const{target:$}=this.model;if(null!=$){const t=$.references(),{document:s}=$;C(t,s),P($)}else{const{document:t}=this.model;if(null!=t){C(t._all_models.values(),t);const s=t.roots();if(0!=s.length){const[t]=s;P(t)}}}O()}}e.InspectorView=k,k.__name__="InspectorView";class w extends i.UIElement{constructor(t){super(t)}}e.Inspector=w,l=w,w.__name__="Inspector",l.prototype.default_view=k,l.define((({Ref:t,Nullable:s})=>({target:[s(t(a.HasProps)),null]})))},
function _(o,e,r,i,l){i(),r.default='.null{color:#7724c1;}.token{color:#881280;}.boolean{color:#007500;}.number{color:#1a1aa6;}.string{color:#994500;}.symbol{color:#c80000;}.model{cursor:pointer;}.attr{color:#c80000;}:root{--common-padding:3px;--common-outline:#1a73e8 solid 1px;--panel-bg-color:#f1f3f4;--panel-border-color:#cacdd1;}.monospace{font-family:var(--mono-font);}.hidden{display:none !important;}.col{display:flex;flex-direction:column;}.row{display:flex;flex-direction:row;}.toolbar{display:flex;flex-direction:row;gap:1em;background-color:var(--panel-bg-color);border-bottom:1px solid var(--panel-border-color);padding:var(--common-padding);}.checkbox{display:flex;flex-direction:row;align-items:center;gap:0.25em;}.filter:focus{outline:var(--common-outline);}.inspector{display:flex;border:1px solid var(--panel-border-color);}.models-panel{display:flex;flex-direction:column;border-right:1px solid var(--panel-border-color);}.props-panel{display:flex;flex-direction:column;}.watches-panel{display:flex;flex-direction:column;border-bottom:1px solid var(--panel-border-color);}.models-list{display:flex;flex-direction:column;height:min-content;padding:var(--common-padding);}.props-list{display:grid;grid-template-columns:min-content min-content 1fr 1fr;column-gap:1em;padding:var(--common-padding);}.watches-list{display:grid;grid-template-columns:1fr 1fr;column-gap:1em;padding:var(--common-padding);}.nothing{grid-column:1 / span 2;font-style:italic;text-align:center;}.prop{display:contents;}.prop.closed{display:none;}.prop > *{opacity:0.6;}.prop.dirty > *{opacity:1;}.model-ref{display:flex;align-items:center;flex-direction:row;font-family:var(--mono-font);}.model-ref:focus-visible{outline:var(--common-outline);}.model-ref:hover{background-color:#e2e2e2;}.model-ref.active{background-color:#c8e0ee;}.tag{margin-left:1em;padding:0 4px;font-size:60%;border-width:1px;border-style:solid;border-radius:4px;color:#202124;background-color:#f1f3f4;border-color:#cacdd1;}.expander{margin:0 2px;display:inline-block;vertical-align:middle;background-color:#5f6368;--open-image:url(\'data:image/svg+xml;utf8,    <svg xmlns="http://www.w3.org/2000/svg" width="6" height="6">      <path d="M 0 1 L 6 1 3 5 Z"/>    </svg>\');--closed-image:url(\'data:image/svg+xml;utf8,    <svg xmlns="http://www.w3.org/2000/svg" width="6" height="6">      <path d="M 1 0 L 5 3 1 6 Z"/>    </svg>\');}.expander{width:6px;height:6px;mask-image:var(--open-image);-webkit-mask-image:var(--open-image);}.expander.closed{width:6px;height:6px;mask-image:var(--closed-image);-webkit-mask-image:var(--closed-image);}.base{grid-column:1 / span 4;color:#5f6368;cursor:pointer;}.prop-attr,.prop-conns,.prop-kind,.prop-value{display:flex;flex-direction:row;align-items:center;overflow:hidden;white-space:nowrap;text-overflow:ellipsis;font-family:var(--mono-font);}.prop-attr > input[type="checkbox"]{visibility:hidden;margin-right:0.25em;}.prop-attr > input[type="checkbox"]:checked,.prop-attr:hover > input{visibility:visible;}.prop-attr:focus-visible{outline:var(--common-outline);}'},
function _(e,i,s,t,n){var r;t();const a=e(251),_=e(58),l=e(8);class h extends a.UIElementView{constructor(){super(...arguments),this._child_views=new Map}get _ui_elements(){return this.model.children.filter((e=>e instanceof a.UIElement))}get child_views(){return this._ui_elements.map((e=>this._child_views.get(e)))}async lazy_initialize(){await super.lazy_initialize(),await this._rebuild_views()}async _rebuild_views(){await(0,_.build_views)(this._child_views,this._ui_elements,{parent:this})}remove(){(0,_.remove_views)(this._child_views),super.remove()}connect_signals(){super.connect_signals();const{children:e}=this.model.properties;this.on_change(e,(()=>{this._rebuild_views(),this.render()}))}render(){super.render();for(const e of this.model.children)if((0,l.isString)(e)){const i=document.createTextNode(e);this.shadow_el.append(i)}else{const i=this._child_views.get(e);this.shadow_el.append(i.el),i.render(),i.after_render()}}has_finished(){if(!super.has_finished())return!1;for(const e of this.child_views)if(!e.has_finished())return!1;return!0}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{children:this.child_views.map((e=>e.serializable_state()))})}}s.PaneView=h,h.__name__="PaneView";class c extends a.UIElement{constructor(e){super(e)}}s.Pane=c,r=c,c.__name__="Pane",r.prototype.default_view=h,r.define((({String:e,Array:i,Ref:s,Or:t})=>({children:[i(t(e,s(a.UIElement))),[]]})))},
function _(t,e,i,s,r){s();const n=t(1);var o;const l=t(251),a=t(400),c=t(436),h=t(19),u=t(55),_=t(54),d=t(8),g=t(12),p=t(18),v=t(58),m=n.__importStar(t(437)),b=m,f=n.__importDefault(t(265));class w extends l.UIElementView{constructor(){super(...arguments),this._html=null}get target(){return this._target}_init_target(){const{target:t}=this.model,e=(()=>{var e,i;if(t instanceof l.UIElement)return null!==(i=null===(e=this.owner.find_one(t))||void 0===e?void 0:e.el)&&void 0!==i?i:null;if(t instanceof a.Selector)return t.find_one(document);if(t instanceof Node)return t;{const{parent:t}=this;return t instanceof _.DOMElementView?t.el:null}})();e instanceof Element?this._target=e:(p.logger.warn(`unable to resolve target '${t}' for '${this}'`),this._target=document.body)}initialize(){super.initialize(),this._init_target()}async lazy_initialize(){await super.lazy_initialize();const{content:t}=this.model;t instanceof c.HTML&&(this._html=await(0,v.build_view)(t,{parent:this})),this.render()}connect_signals(){super.connect_signals(),this._observer=new ResizeObserver((()=>{this._reposition()})),this._observer.observe(this.target);const{target:t,content:e,closable:i,interactive:s,position:r,attachment:n,visible:o}=this.model.properties;this.on_change(t,(()=>{this._init_target(),this._observer.disconnect(),this._observer.observe(this.target),this.render()})),this.on_change([e,i,s],(()=>this.render())),this.on_change([r,n,o],(()=>this._reposition()))}remove(){var t;null===(t=this._html)||void 0===t||t.remove(),this._observer.disconnect(),super.remove()}styles(){return[...super.styles(),m.default,f.default]}get content(){const{content:t}=this.model;return(0,d.isString)(t)?document.createTextNode(t):t instanceof c.HTML?((0,g.assert)(null!=this._html),this._html.el):t}render(){var t;if(super.render(),null===(t=this._html)||void 0===t||t.render(),this.content_el=(0,u.div)({class:b.tooltip_content},this.content),this.shadow_el.appendChild(this.content_el),this.model.closable){const t=(0,u.div)({class:b.close});t.addEventListener("click",(()=>{this.model.visible=!1})),this.shadow_el.appendChild(t)}this.el.classList.toggle(b.tooltip_arrow,this.model.show_arrow),this.el.classList.toggle(b.non_interactive,!this.model.interactive),this._reposition()}_anchor_to_align(t){switch(t){case"top_left":return["top","left"];case"top":case"top_center":return["top","center"];case"top_right":return["top","right"];case"left":case"center_left":return["center","left"];case"center":case"center_center":return["center","center"];case"right":case"center_right":return["center","right"];case"bottom_left":return["bottom","left"];case"bottom":case"bottom_center":return["bottom","center"];case"bottom_right":return["bottom","right"]}}_reposition(){var t;const{position:e,visible:i}=this.model;if(null==e||!i)return void this.el.remove();(null!==(t=this.target.shadowRoot)&&void 0!==t?t:this.target).appendChild(this.el);const s=(0,u.bounding_box)(this.target).relative(),[r,n]=(()=>{if((0,d.isString)(e)){const[t,i]=this._anchor_to_align(e);return[(()=>{switch(i){case"left":return s.left;case"center":return s.hcenter;case"right":return s.right}})(),(()=>{switch(t){case"top":return s.top;case"center":return s.vcenter;case"bottom":return s.bottom}})()]}return e})(),o=(()=>{const t=(()=>{const{attachment:t}=this.model;if("auto"==t){if((0,d.isString)(e)){const[t,i]=this._anchor_to_align(e);if("center"!=i)return"left"==i?"left":"right";if("center"!=t)return"top"==t?"above":"below"}return"horizontal"}return t})();switch(t){case"horizontal":return r<s.hcenter?"right":"left";case"vertical":return n<s.vcenter?"below":"above";default:return t}})();let l;this.el.classList.remove(b.right),this.el.classList.remove(b.left),this.el.classList.remove(b.above),this.el.classList.remove(b.below);let a=null,c=null;const{width:h,height:_}=(0,u.bounding_box)(this.el);switch(o){case"right":this.el.classList.add(b.left),a=r+(h-this.el.clientWidth)+10,l=n-_/2;break;case"left":this.el.classList.add(b.right),c=s.width-r+10,l=n-_/2;break;case"below":this.el.classList.add(b.above),l=n+(_-this.el.clientHeight)+10,a=Math.round(r-h/2);break;case"above":this.el.classList.add(b.below),l=n-_-10,a=Math.round(r-h/2)}this.el.style.top=`${l}px`,this.el.style.left=null!=a?`${a}px`:"",this.el.style.right=null!=c?`${c}px`:""}}i.TooltipView=w,w.__name__="TooltipView";class L extends l.UIElement{constructor(t){super(t)}clear(){this.position=null}}i.Tooltip=L,o=L,L.__name__="Tooltip",o.prototype.default_view=w,o.define((({Boolean:t,Number:e,String:i,Tuple:s,Or:r,Ref:n,Nullable:o,Auto:u})=>({target:[r(n(l.UIElement),n(a.Selector),n(Node),u),"auto"],position:[o(r(h.Anchor,s(e,e))),null],content:[r(i,n(c.HTML),n(Node))],attachment:[r(h.TooltipAttachment,u),"auto"],show_arrow:[t,!0],closable:[t,!1],interactive:[t,!0]}))),o.override({visible:!1})},
function _(e,t,r,s,i){var o;s();const n=e(429),l=e(251),a=e(58),d=e(55),_=e(12),c=e(8);class f extends n.DOMNodeView{constructor(){super(...arguments),this._refs=new Map}async lazy_initialize(){await super.lazy_initialize(),await(0,a.build_views)(this._refs,this.model.refs)}remove(){(0,a.remove_views)(this._refs),super.remove()}render(){(0,d.empty)(this.el),this.el.style.display="contents";const e=new DOMParser,t=(()=>{const{html:t}=this.model;if((0,c.isString)(t)){const r=e.parseFromString(t,"text/html"),s=r.createNodeIterator(r,NodeFilter.SHOW_ELEMENT,(e=>"ref"==e.nodeName.toLowerCase()?NodeFilter.FILTER_ACCEPT:NodeFilter.FILTER_REJECT));let i;for(;i=s.nextNode();){(0,_.assert)(i instanceof Element);const e=i.getAttribute("id");if(null!=e)for(const[t,r]of this._refs)if(t.id==e){r.render(),i.replaceWith(r.el);break}}return[...r.body.childNodes]}return[]})();for(const e of t)this.el.appendChild(e)}}r.HTMLView=f,f.__name__="HTMLView";class m extends n.DOMNode{constructor(e){super(e)}}r.HTML=m,o=m,m.__name__="HTML",o.prototype.default_view=f,o.define((({String:e,Array:t,Or:r,Ref:s})=>({html:[r(e,t(r(e,s(n.DOMNode),s(l.UIElement))))],refs:[t(r(s(n.DOMNode),s(l.UIElement))),[]]})))},
function _(o,t,r,i,l){i(),r.non_interactive="bk-non-interactive",r.tooltip_content="bk-tooltip-content",r.left="bk-left",r.tooltip_arrow="bk-tooltip-arrow",r.right="bk-right",r.above="bk-above",r.below="bk-below",r.tooltip_row_label="bk-tooltip-row-label",r.tooltip_row_value="bk-tooltip-row-value",r.tooltip_color_block="bk-tooltip-color-block",r.close="bk-close",r.default=':host{--tooltip-border:#e5e5e5;--tooltip-color:white;--tooltip-text:#2f2f2f;--tooltip-arrow-color:#909599;--tooltip-arrow-width:10px;--tooltip-arrow-height:10px;--tooltip-arrow-half-width:7px;--tooltip-arrow-half-height:7px;}:host{width:max-content;font-weight:300;font-size:12px;position:absolute;padding:5px;border:1px solid var(--tooltip-border);color:var(--tooltip-text);background-color:var(--tooltip-color);opacity:0.95;z-index:100;}.bk-non-interactive{pointer-events:none;}.bk-tooltip-content > div:not(:first-child){margin-top:5px;border-top:var(--tooltip-border) 1px dashed;}:host(.bk-left.bk-tooltip-arrow) .bk-tooltip-content::before{position:absolute;margin:calc(-1*var(--tooltip-arrow-half-height)) 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:var(--tooltip-arrow-half-height) 0 var(--tooltip-arrow-half-height) 0;border-color:transparent;content:" ";display:block;left:calc(-1*var(--tooltip-arrow-width));border-right-width:var(--tooltip-arrow-width);border-right-color:var(--tooltip-arrow-color);}:host(.bk-left) .bk-tooltip-content::before{left:calc(-1*var(--tooltip-arrow-width));border-right-width:var(--tooltip-arrow-width);border-right-color:var(--tooltip-arrow-color);}:host(.bk-right.bk-tooltip-arrow) .bk-tooltip-content::after{position:absolute;margin:calc(-1*var(--tooltip-arrow-half-height)) 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:var(--tooltip-arrow-half-height) 0 var(--tooltip-arrow-half-height) 0;border-color:transparent;content:" ";display:block;right:calc(-1*var(--tooltip-arrow-width));border-left-width:var(--tooltip-arrow-width);border-left-color:var(--tooltip-arrow-color);}:host(.bk-right) .bk-tooltip-content::after{right:calc(-1*var(--tooltip-arrow-width));border-left-width:var(--tooltip-arrow-width);border-left-color:var(--tooltip-arrow-color);}:host(.bk-above) .bk-tooltip-content::before{position:absolute;margin:0 0 0 calc(-1*var(--tooltip-arrow-half-width));left:50%;width:0;height:0;border-style:solid;border-width:0 var(--tooltip-arrow-half-width) 0 var(--tooltip-arrow-half-width);border-color:transparent;content:" ";display:block;top:calc(-1*var(--tooltip-arrow-height));border-bottom-width:var(--tooltip-arrow-height);border-bottom-color:var(--tooltip-arrow-color);}:host(.bk-below) .bk-tooltip-content::after{position:absolute;margin:0 0 0 calc(-1*var(--tooltip-arrow-half-width));left:50%;width:0;height:0;border-style:solid;border-width:0 var(--tooltip-arrow-half-width) 0 var(--tooltip-arrow-half-width);border-color:transparent;content:" ";display:block;bottom:calc(-1*var(--tooltip-arrow-height));border-top-width:var(--tooltip-arrow-height);border-top-color:var(--tooltip-arrow-color);}.bk-tooltip-row-label{text-align:right;color:#26aae1;}.bk-tooltip-row-value{color:default;}.bk-tooltip-color-block{width:12px;height:12px;margin-left:5px;margin-right:5px;outline:#dddddd solid 1px;display:inline-block;}.bk-close{position:absolute;top:2px;right:2px;width:12px;height:12px;cursor:pointer;background-color:gray;mask-image:var(--bokeh-icon-x);mask-size:contain;mask-repeat:no-repeat;-webkit-mask-image:var(--bokeh-icon-x);-webkit-mask-size:contain;-webkit-mask-repeat:no-repeat;}.bk-close:hover{background-color:red;}'},
function _(o,r,t,_,a){_();const l=o(1);l.__exportStar(o(439),t),l.__exportStar(o(453),t),l.__exportStar(o(463),t),l.__exportStar(o(474),t),a("Tool",o(257).Tool),a("ToolProxy",o(258).ToolProxy),a("Toolbar",o(250).Toolbar)},
function _(o,l,T,e,t){e(),t("ActionTool",o(268).ActionTool),t("CopyTool",o(440).CopyTool),t("CustomAction",o(441).CustomAction),t("FullscreenTool",o(442).FullscreenTool),t("HelpTool",o(269).HelpTool),t("RedoTool",o(443).RedoTool),t("ResetTool",o(445).ResetTool),t("SaveTool",o(446).SaveTool),t("SettingsTool",o(447).SettingsTool),t("UndoTool",o(448).UndoTool),t("ZoomInTool",o(449).ZoomInTool),t("ZoomOutTool",o(452).ZoomOutTool)},
function _(o,t,e,i,a){var n;i();const c=o(268),p=o(265);class s extends c.ActionToolView{async copy(){const o=await this.parent.export().to_blob(),t=new ClipboardItem({[o.type]:o});await navigator.clipboard.write([t])}doit(){this.copy()}}e.CopyToolView=s,s.__name__="CopyToolView";class l extends c.ActionTool{constructor(o){super(o),this.tool_name="Copy",this.tool_icon=p.tool_icon_copy}}e.CopyTool=l,n=l,l.__name__="CopyTool",n.prototype.default_view=s,n.register_alias("copy",(()=>new l))},
function _(o,t,n,s,e){s();const c=o(1);var i;const l=o(268),u=c.__importStar(o(265));class _ extends l.ActionToolButtonView{css_classes(){return super.css_classes().concat("bk-toolbar-button-custom-action")}}n.CustomActionButtonView=_,_.__name__="CustomActionButtonView";class a extends l.ActionToolView{doit(){var o;null===(o=this.model.callback)||void 0===o||o.execute(this.model)}}n.CustomActionView=a,a.__name__="CustomActionView";class m extends l.ActionTool{constructor(o){super(o),this.tool_name="Custom Action",this.tool_icon=u.tool_icon_unknown,this.button_view=_}}n.CustomAction=m,i=m,m.__name__="CustomAction",i.prototype.default_view=a,i.define((({Any:o,Nullable:t})=>({callback:[t(o),null]}))),i.override({description:"Perform a Custom Action"})},
function _(e,l,o,n,t){n();const s=e(1);var c;const r=e(268),i=s.__importStar(e(265));class u extends r.ActionToolView{doit(){null!=document.fullscreenElement?document.exitFullscreen():(async()=>{await this.parent.el.requestFullscreen()})()}}o.FullscreenToolView=u,u.__name__="FullscreenToolView";class _ extends r.ActionTool{constructor(e){super(e),this.tool_name="Fullscreen",this.tool_icon=i.tool_icon_fullscreen}}o.FullscreenTool=_,c=_,_.__name__="FullscreenTool",c.prototype.default_view=u,c.register_alias("fullscreen",(()=>new _))},
function _(o,e,t,i,s){var n;i();const l=o(444),_=o(265);class d extends l.PlotActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state.changed,(()=>this.model.disabled=!this.plot_view.state.can_redo))}doit(){const o=this.plot_view.state.redo();null!=(null==o?void 0:o.range)&&this.plot_view.trigger_ranges_update_event()}}t.RedoToolView=d,d.__name__="RedoToolView";class a extends l.PlotActionTool{constructor(o){super(o),this.tool_name="Redo",this.tool_icon=_.tool_icon_redo}}t.RedoTool=a,n=a,a.__name__="RedoTool",n.prototype.default_view=d,n.override({disabled:!0}),n.register_alias("redo",(()=>new a))},
function _(o,t,n,e,l){e();const c=o(268);class i extends c.ActionToolView{get plot_view(){return this.parent}}n.PlotActionToolView=i,i.__name__="PlotActionToolView";class s extends c.ActionTool{constructor(o){super(o)}}n.PlotActionTool=s,s.__name__="PlotActionTool"},
function _(e,o,t,s,i){var l;s();const _=e(444),n=e(265);class c extends _.PlotActionToolView{doit(){this.plot_view.reset()}}t.ResetToolView=c,c.__name__="ResetToolView";class r extends _.PlotActionTool{constructor(e){super(e),this.tool_name="Reset",this.tool_icon=n.tool_icon_reset}}t.ResetTool=r,l=r,r.__name__="ResetTool",l.prototype.default_view=c,l.register_alias("reset",(()=>new r))},
function _(e,o,t,a,n){var i;a();const l=e(268),s=e(265);class c extends l.ActionToolView{async copy(){const e=await this.parent.export().to_blob(),o=new ClipboardItem({[e.type]:e});await navigator.clipboard.write([o])}async save(e){const o=await this.parent.export().to_blob(),t=document.createElement("a");t.href=URL.createObjectURL(o),t.download=e,t.target="_blank",t.dispatchEvent(new MouseEvent("click"))}doit(e="save"){var o;switch(e){case"save":{const e=null!==(o=this.model.filename)&&void 0!==o?o:prompt("Enter filename","bokeh_plot");null!=e&&this.save(e);break}case"copy":this.copy()}}}t.SaveToolView=c,c.__name__="SaveToolView";class r extends l.ActionTool{constructor(e){super(e),this.tool_name="Save",this.tool_icon=s.tool_icon_save}get menu(){return[{icon:"bk-tool-icon-copy",tooltip:"Copy image to clipboard",if:()=>"undefined"!=typeof ClipboardItem,handler:()=>{this.do.emit("copy")}}]}}t.SaveTool=r,i=r,r.__name__="SaveTool",i.prototype.default_view=c,i.define((({String:e,Nullable:o})=>({filename:[o(e),null]}))),i.register_alias("save",(()=>new r))},
function _(t,i,e,o,n){o();const s=t(1);var a;const l=t(268),_=s.__importStar(t(265)),c=t(428),r=t(432),g=t(58);class w extends l.ActionToolView{async lazy_initialize(){await super.lazy_initialize();const t=new c.Dialog({content:new r.Inspector({target:this.parent.model}),closable:!0,visible:!1});this._dialog=await(0,g.build_view)(t,{parent:this.parent})}doit(){this._dialog.model.visible=!0}}e.SettingsToolView=w,w.__name__="SettingsToolView";class d extends l.ActionTool{constructor(t){super(t),this.tool_name="Settings",this.tool_icon=_.tool_icon_settings}}e.SettingsTool=d,a=d,d.__name__="SettingsTool",a.prototype.default_view=w,a.register_alias("settings",(()=>new d))},
function _(o,t,e,n,i){var s;n();const l=o(444),_=o(265);class d extends l.PlotActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state.changed,(()=>this.model.disabled=!this.plot_view.state.can_undo))}doit(){const o=this.plot_view.state.undo();null!=(null==o?void 0:o.range)&&this.plot_view.trigger_ranges_update_event()}}e.UndoToolView=d,d.__name__="UndoToolView";class a extends l.PlotActionTool{constructor(o){super(o),this.tool_name="Undo",this.tool_icon=_.tool_icon_undo}}e.UndoTool=a,s=a,a.__name__="UndoTool",s.prototype.default_view=d,s.override({disabled:!0}),s.register_alias("undo",(()=>new a))},
function _(o,n,e,i,s){var t;i();const _=o(450),a=o(265);class m extends _.ZoomBaseToolView{}e.ZoomInToolView=m,m.__name__="ZoomInToolView";class l extends _.ZoomBaseTool{constructor(o){super(o),this.maintain_focus=!0,this.tool_name="Zoom In",this.tool_icon=a.tool_icon_zoom_in}get_factor(){return this.factor}}e.ZoomInTool=l,t=l,l.__name__="ZoomInTool",t.prototype.default_view=m,t.register_alias("zoom_in",(()=>new l({dimensions:"both"}))),t.register_alias("xzoom_in",(()=>new l({dimensions:"width"}))),t.register_alias("yzoom_in",(()=>new l({dimensions:"height"})))},
function _(o,t,e,i,s){var n;i();const a=o(444),l=o(19),_=o(451);class m extends a.PlotActionToolView{doit(){var o;const t=this.plot_view.frame,e=this.model.dimensions,i="width"==e||"both"==e,s="height"==e||"both"==e,n=this.model.get_factor(),a=(0,_.scale_range)(t,n,i,s);this.plot_view.state.push("zoom_out",{range:a}),this.plot_view.update_range(a,{scrolling:!0,maintain_focus:this.model.maintain_focus}),null===(o=this.model.document)||void 0===o||o.interactive_start(this.plot_view.model),this.plot_view.trigger_ranges_update_event()}}e.ZoomBaseToolView=m,m.__name__="ZoomBaseToolView";class r extends a.PlotActionTool{constructor(o){super(o)}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}e.ZoomBaseTool=r,n=r,r.__name__="ZoomBaseTool",n.define((({Percent:o})=>({factor:[o,.1],dimensions:[l.Dimensions,"both"]})))},
function _(n,t,o,r,e){function s(n,t,o){const[r,e]=[n.start,n.end],s=null!=o?o:(e+r)/2;return[r-(r-s)*t,e-(e-s)*t]}function c(n,[t,o]){const r=new Map;for(const[e,s]of n){const[n,c]=s.r_invert(t,o);r.set(e,{start:n,end:c})}return r}r(),o.scale_highlow=s,o.get_info=c,o.scale_range=function(n,t,o=!0,r=!0,e){const a=o?t:0,[l,u]=s(n.bbox.h_range,a,null!=e?e.x:void 0),i=c(n.x_scales,[l,u]),_=r?t:0,[f,g]=s(n.bbox.v_range,_,null!=e?e.y:void 0);return{xrs:i,yrs:c(n.y_scales,[f,g]),factor:t}}},
function _(o,t,e,i,s){var n;i();const _=o(450),a=o(265);class m extends _.ZoomBaseToolView{}e.ZoomOutToolView=m,m.__name__="ZoomOutToolView";class l extends _.ZoomBaseTool{constructor(o){super(o),this.tool_name="Zoom Out",this.tool_icon=a.tool_icon_zoom_out}get_factor(){return-this.factor/(1-this.factor)}}e.ZoomOutTool=l,n=l,l.__name__="ZoomOutTool",n.prototype.default_view=m,n.define((({Boolean:o})=>({maintain_focus:[o,!0]}))),n.register_alias("zoom_out",(()=>new l({dimensions:"both"}))),n.register_alias("xzoom_out",(()=>new l({dimensions:"width"}))),n.register_alias("yzoom_out",(()=>new l({dimensions:"height"})))},
function _(o,l,T,i,t){i(),t("EditTool",o(454).EditTool),t("BoxEditTool",o(455).BoxEditTool),t("FreehandDrawTool",o(456).FreehandDrawTool),t("LineEditTool",o(457).LineEditTool),t("PointDrawTool",o(459).PointDrawTool),t("PolyDrawTool",o(460).PolyDrawTool),t("PolyTool",o(461).PolyTool),t("PolyEditTool",o(462).PolyEditTool)},
function _(e,t,s,o,n){var r;o();const i=e(10),c=e(8),_=e(12),a=e(198),l=e(267);class d extends l.GestureToolView{constructor(){super(...arguments),this._mouse_in_frame=!0}_select_mode(e){const{shiftKey:t,ctrlKey:s}=e;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void(0,_.unreachable)():"replace"}_move_enter(e){this._mouse_in_frame=!0}_move_exit(e){this._mouse_in_frame=!1}_map_drag(e,t,s){if(!this.plot_view.frame.bbox.contains(e,t))return null;const o=this.plot_view.renderer_view(s);if(null==o)return null;return[o.coordinates.x_scale.invert(e),o.coordinates.y_scale.invert(t)]}_delete_selected(e){const t=e.data_source,s=t.selected.indices;s.sort();for(const e of t.columns()){const o=t.get_array(e);for(let e=0;e<s.length;e++){const t=s[e];o.splice(t-e,1)}}this._emit_cds_changes(t)}_pop_glyphs(e,t){const s=e.columns();if(t&&s.length)for(const o of s){let s=e.get_array(o);const n=s.length-t+1;n<1||((0,c.isArray)(s)||(s=Array.from(s),e.data[o]=s),s.splice(0,n))}}_emit_cds_changes(e,t=!0,s=!0,o=!0){if(s&&e.selection_manager.clear(),t&&e.change.emit(),o){const{data:t}=e;e.setv({data:t},{check_eq:!1})}}_drag_points(e,t,s="both"){if(null==this._basepoint)return;const[o,n]=this._basepoint;for(const r of t){const t=this._map_drag(o,n,r),i=this._map_drag(e.sx,e.sy,r);if(null==i||null==t)continue;const[c,_]=i,[a,l]=t,[d,u]=[c-a,_-l],h=r.glyph,f=r.data_source,[p,m]=[h.x.field,h.y.field];for(const e of f.selected.indices)!p||"width"!=s&&"both"!=s||(f.data[p][e]+=d),!m||"height"!=s&&"both"!=s||(f.data[m][e]+=u);f.change.emit()}this._basepoint=[e.sx,e.sy]}_pad_empty_columns(e,t){for(const s of e.columns())(0,i.includes)(t,s)||e.get_array(s).push(this.model.empty_value)}_select_event(e,t,s){const o=this.plot_view.frame,{sx:n,sy:r}=e;if(!o.bbox.contains(n,r))return[];const i={type:"point",sx:n,sy:r},c=[];for(const e of s){const s=e.get_selection_manager(),o=e.data_source,n=this.plot_view.renderer_view(e);if(null!=n){s.select([n],i,!0,t)&&c.push(e),o.properties.selected.change.emit()}}return c}}s.EditToolView=d,d.__name__="EditToolView";class u extends l.GestureTool{constructor(e){super(e)}}s.EditTool=u,r=u,u.__name__="EditTool",r.define((({Unknown:e,Array:t,Ref:s})=>({empty_value:[e],renderers:[t(s(a.GlyphRenderer)),[]]})))},
function _(e,t,s,i,_){var o;i();const n=e(55),a=e(19),d=e(454),r=e(265);class l extends d.EditToolView{_tap(e){null==this._draw_basepoint&&null==this._basepoint&&this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)if(e.keyCode===n.Keys.Backspace)this._delete_selected(t);else if(e.keyCode==n.Keys.Esc){t.data_source.selection_manager.clear()}}_set_extent([e,t],[s,i],_,o=!1){const n=this.model.renderers[0],a=this.plot_view.renderer_view(n);if(null==a)return;const d=n.glyph,r=n.data_source,[l,h]=a.coordinates.x_scale.r_invert(e,t),[p,u]=a.coordinates.y_scale.r_invert(s,i),[c,m]=[(l+h)/2,(p+u)/2],[f,b]=[h-l,u-p],[y,x]=[d.x.field,d.y.field],[w,v]=[d.width.field,d.height.field];if(_)this._pop_glyphs(r,this.model.num_objects),y&&r.get_array(y).push(c),x&&r.get_array(x).push(m),w&&r.get_array(w).push(f),v&&r.get_array(v).push(b),this._pad_empty_columns(r,[y,x,w,v]);else{const e=r.data[y].length-1;y&&(r.data[y][e]=c),x&&(r.data[x][e]=m),w&&(r.data[w][e]=f),v&&(r.data[v][e]=b)}this._emit_cds_changes(r,!0,!1,o)}_update_box(e,t=!1,s=!1){if(null==this._draw_basepoint)return;const i=[e.sx,e.sy],_=this.plot_view.frame,o=this.model.dimensions,[n,a]=this.model._get_dim_limits(this._draw_basepoint,i,_,o);this._set_extent(n,a,t,s)}_doubletap(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,"append",this.model.renderers),this._update_box(e,!0,!1)))}_move(e){this._update_box(e,!1,!1)}_pan_start(e){if(e.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy]}}_pan(e,t=!1,s=!1){if(e.shiftKey){if(null==this._draw_basepoint)return;this._update_box(e,t,s)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}}_pan_end(e){if(this._pan(e,!1,!0),e.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0)}}}s.BoxEditToolView=l,l.__name__="BoxEditToolView";class h extends d.EditTool{constructor(e){super(e),this.tool_name="Box Edit Tool",this.tool_icon=r.tool_icon_box_edit,this.event_type=["tap","pan","move"],this.default_order=1}}s.BoxEditTool=h,o=h,h.__name__="BoxEditTool",o.prototype.default_view=l,o.define((({Int:e})=>({dimensions:[a.Dimensions,"both"],num_objects:[e,0]})))},
function _(e,t,a,s,r){var _;s();const o=e(55),d=e(8),n=e(454),i=e(265);class l extends n.EditToolView{_draw(e,t,a=!1){if(!this.model.active)return;const s=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,s);if(null==r)return;const[_,o]=r,n=s.data_source,i=s.glyph,[l,h]=[i.xs.field,i.ys.field];if("new"==t)this._pop_glyphs(n,this.model.num_objects),l&&n.get_array(l).push([_]),h&&n.get_array(h).push([o]),this._pad_empty_columns(n,[l,h]);else if("add"==t){if(l){const e=n.data[l].length-1;let t=n.get_array(l)[e];(0,d.isArray)(t)||(t=Array.from(t),n.data[l][e]=t),t.push(_)}if(h){const e=n.data[h].length-1;let t=n.get_array(h)[e];(0,d.isArray)(t)||(t=Array.from(t),n.data[h][e]=t),t.push(o)}}this._emit_cds_changes(n,!0,!0,a)}_pan_start(e){this._draw(e,"new")}_pan(e){this._draw(e,"add")}_pan_end(e){this._draw(e,"add",!0)}_tap(e){this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===o.Keys.Esc?t.data_source.selection_manager.clear():e.keyCode===o.Keys.Backspace&&this._delete_selected(t)}}a.FreehandDrawToolView=l,l.__name__="FreehandDrawToolView";class h extends n.EditTool{constructor(e){super(e),this.tool_name="Freehand Draw Tool",this.tool_icon=i.tool_icon_freehand_draw,this.event_type=["pan","tap"],this.default_order=3}}a.FreehandDrawTool=h,_=h,h.__name__="FreehandDrawTool",_.prototype.default_view=l,_.define((({Int:e})=>({num_objects:[e,0]}))),_.register_alias("freehand_draw",(()=>new h))},
function _(e,t,s,i,r){var n;i();const _=e(19),d=e(458),o=e(265);class l extends d.LineToolView{constructor(){super(...arguments),this._drawing=!1}_doubletap(e){if(!this.model.active)return;const t=this.model.renderers;for(const s of t){1==this._select_event(e,"replace",[s]).length&&(this._selected_renderer=s)}this._show_intersections(),this._update_line_cds()}_show_intersections(){if(!this.model.active)return;if(null==this._selected_renderer)return;if(!this.model.renderers.length)return this._set_intersection([],[]),this._selected_renderer=null,void(this._drawing=!1);const e=this._selected_renderer.data_source,t=this._selected_renderer.glyph,[s,i]=[t.x.field,t.y.field],r=e.get_array(s),n=e.get_array(i);this._set_intersection(r,n)}_tap(e){const t=this.model.intersection_renderer;if(null==this._map_drag(e.sx,e.sy,t))return;if(this._drawing&&this._selected_renderer){const s=this._select_mode(e);if(0==this._select_event(e,s,[t]).length)return}const s=this._select_mode(e);this._select_event(e,s,[t]),this._select_event(e,s,this.model.renderers)}_update_line_cds(){if(null==this._selected_renderer)return;const e=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,[s,i]=[e.x.field,e.y.field];if(s&&i){const e=t.data[s],r=t.data[i];this._selected_renderer.data_source.data[s]=e,this._selected_renderer.data_source.data[i]=r}this._emit_cds_changes(this._selected_renderer.data_source,!0,!0,!1)}_pan_start(e){this._select_event(e,"append",[this.model.intersection_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer],this.model.dimensions),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer]),this._emit_cds_changes(this.model.intersection_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}activate(){this._drawing=!0}deactivate(){this._selected_renderer&&(this._drawing&&(this._drawing=!1),this._hide_intersections())}}s.LineEditToolView=l,l.__name__="LineEditToolView";class h extends d.LineTool{constructor(e){super(e),this.tool_name="Line Edit Tool",this.tool_icon=o.tool_icon_line_edit,this.event_type=["tap","pan","move"],this.default_order=4}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}s.LineEditTool=h,n=h,h.__name__="LineEditTool",n.prototype.default_view=l,n.define((()=>({dimensions:[_.Dimensions,"both"]})))},
function _(e,i,n,t,s){var o;t();const r=e(8),_=e(454);class d extends _.EditToolView{_set_intersection(e,i){const n=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,[s,o]=[n.x.field,n.y.field];s&&((0,r.isArray)(e)?t.data[s]=e:n.x={value:e}),o&&((0,r.isArray)(i)?t.data[o]=i:n.y={value:i}),this._emit_cds_changes(t,!0,!0,!1)}_hide_intersections(){this._set_intersection([],[])}}n.LineToolView=d,d.__name__="LineToolView";class a extends _.EditTool{constructor(e){super(e)}}n.LineTool=a,o=a,a.__name__="LineTool",o.define((({AnyRef:e})=>({intersection_renderer:[e()]})))},
function _(e,t,s,o,i){var _;o();const a=e(55),n=e(454),r=e(265);class d extends n.EditToolView{_tap(e){if(this._select_event(e,this._select_mode(e),this.model.renderers).length||!this.model.add)return;const t=this.model.renderers[0],s=this._map_drag(e.sx,e.sy,t);if(null==s)return;const o=t.glyph,i=t.data_source,[_,a]=[o.x.field,o.y.field],[n,r]=s;this._pop_glyphs(i,this.model.num_objects),_&&i.get_array(_).push(n),a&&i.get_array(a).push(r),this._pad_empty_columns(i,[_,a]);const{data:d}=i;i.setv({data:d},{check_eq:!1})}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===a.Keys.Backspace?this._delete_selected(t):e.keyCode==a.Keys.Esc&&t.data_source.selection_manager.clear()}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0);this._basepoint=null}}}s.PointDrawToolView=d,d.__name__="PointDrawToolView";class l extends n.EditTool{constructor(e){super(e),this.tool_name="Point Draw Tool",this.tool_icon=r.tool_icon_point_draw,this.event_type=["tap","pan","move"],this.default_order=2}}s.PointDrawTool=l,_=l,l.__name__="PointDrawTool",_.prototype.default_view=d,_.define((({Boolean:e,Int:t})=>({add:[e,!0],drag:[e,!0],num_objects:[t,0]})))},
function _(e,t,s,i,a){var r;i();const o=e(55),n=e(8),d=e(461),_=e(265);class l extends d.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._initialized=!1}_tap(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,this._select_mode(e),this.model.renderers)}_draw(e,t,s=!1){const i=this.model.renderers[0],a=this._map_drag(e.sx,e.sy,i);if(this._initialized||this.activate(),null==a)return;const[r,o]=this._snap_to_vertex(e,...a),d=i.data_source,_=i.glyph,[l,h]=[_.xs.field,_.ys.field];if("new"==t)this._pop_glyphs(d,this.model.num_objects),l&&d.get_array(l).push([r,r]),h&&d.get_array(h).push([o,o]),this._pad_empty_columns(d,[l,h]);else if("edit"==t){if(l){const e=d.data[l][d.data[l].length-1];e[e.length-1]=r}if(h){const e=d.data[h][d.data[h].length-1];e[e.length-1]=o}}else if("add"==t){if(l){const e=d.data[l].length-1;let t=d.get_array(l)[e];const s=t[t.length-1];t[t.length-1]=r,(0,n.isArray)(t)||(t=Array.from(t),d.data[l][e]=t),t.push(s)}if(h){const e=d.data[h].length-1;let t=d.get_array(h)[e];const s=t[t.length-1];t[t.length-1]=o,(0,n.isArray)(t)||(t=Array.from(t),d.data[h][e]=t),t.push(s)}}this._emit_cds_changes(d,!0,!1,s)}_show_vertices(){if(!this.model.active)return;const e=[],t=[];for(let s=0;s<this.model.renderers.length;s++){const i=this.model.renderers[s],a=i.data_source,r=i.glyph,[o,n]=[r.xs.field,r.ys.field];if(o)for(const t of a.get_array(o))e.push(...t);if(n)for(const e of a.get_array(n))t.push(...e);this._drawing&&s==this.model.renderers.length-1&&(e.splice(e.length-1,1),t.splice(t.length-1,1))}this._set_vertices(e,t)}_doubletap(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))}_move(e){this._drawing&&this._draw(e,"edit")}_remove(){const e=this.model.renderers[0],t=e.data_source,s=e.glyph,[i,a]=[s.xs.field,s.ys.field];if(i){const e=t.data[i].length-1,s=t.get_array(i)[e];s.splice(s.length-1,1)}if(a){const e=t.data[a].length-1,s=t.get_array(a)[e];s.splice(s.length-1,1)}this._emit_cds_changes(t)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===o.Keys.Backspace?this._delete_selected(t):e.keyCode==o.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),t.data_source.selection_manager.clear())}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){if(null==this._basepoint||!this.model.drag)return;const[t,s]=this._basepoint;for(const i of this.model.renderers){const a=this._map_drag(t,s,i),r=this._map_drag(e.sx,e.sy,i);if(null==r||null==a)continue;const o=i.data_source,n=i.glyph,[d,_]=[n.xs.field,n.ys.field];if(!d&&!_)continue;const[l,h]=r,[c,g]=a,[f,p]=[l-c,h-g];for(const e of o.selected.indices){let t,s,i;d&&(s=o.data[d][e]),_?(i=o.data[_][e],t=i.length):t=s.length;for(let e=0;e<t;e++)s&&(s[e]+=f),i&&(i[e]+=p)}o.change.emit()}this._basepoint=[e.sx,e.sy]}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source);this._basepoint=null}}activate(){if(null!=this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(const e of this.model.renderers){const t=e.data_source;t.connect(t.properties.data.change,(()=>this._show_vertices()))}this._initialized=!0}}deactivate(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()}}s.PolyDrawToolView=l,l.__name__="PolyDrawToolView";class h extends d.PolyTool{constructor(e){super(e),this.tool_name="Polygon Draw Tool",this.tool_icon=_.tool_icon_poly_draw,this.event_type=["pan","tap","move"],this.default_order=3}}s.PolyDrawTool=h,r=h,h.__name__="PolyDrawTool",r.prototype.default_view=l,r.define((({Boolean:e,Int:t})=>({drag:[e,!0],num_objects:[t,0]})))},
function _(e,t,r,s,l){var o;s();const _=e(8),i=e(12),d=e(454);class n extends d.EditToolView{_set_vertices(e,t){const{vertex_renderer:r}=this.model;(0,i.assert)(null!=r);const s=r.glyph,l=r.data_source,[o,d]=[s.x.field,s.y.field];o&&((0,_.isArray)(e)?l.data[o]=e:s.x={value:e}),d&&((0,_.isArray)(t)?l.data[d]=t:s.y={value:t}),this._emit_cds_changes(l,!0,!0,!1)}_hide_vertices(){this._set_vertices([],[])}_snap_to_vertex(e,t,r){if(this.model.vertex_renderer){const s=this._select_event(e,"replace",[this.model.vertex_renderer]),l=this.model.vertex_renderer.data_source,o=this.model.vertex_renderer.glyph,[_,i]=[o.x.field,o.y.field];if(s.length){const e=l.selected.indices[0];_&&(t=l.data[_][e]),i&&(r=l.data[i][e]),l.selection_manager.clear()}}return[t,r]}}r.PolyToolView=n,n.__name__="PolyToolView";class a extends d.EditTool{constructor(e){super(e)}}r.PolyTool=a,o=a,a.__name__="PolyTool",o.define((({AnyRef:e,Nullable:t})=>({vertex_renderer:[t(e()),null]})))},
function _(e,t,r,s,i){var _;s();const d=e(55),n=e(8),l=e(461),c=e(265);class a extends l.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._cur_index=null}_doubletap(e){if(null==this.model.vertex_renderer||!this.model.active)return;const t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null==t)return;const[r,s]=t,i=this._select_event(e,"replace",[this.model.vertex_renderer]),_=this.model.vertex_renderer.data_source,d=this.model.vertex_renderer.glyph,[n,l]=[d.x.field,d.y.field];if(i.length&&null!=this._selected_renderer){const e=_.selected.indices[0];this._drawing?(this._drawing=!1,_.selection_manager.clear()):(_.selected.indices=[e+1],n&&_.get_array(n).splice(e+1,0,r),l&&_.get_array(l).splice(e+1,0,s),this._drawing=!0),_.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}_show_vertices(e){if(!this.model.active)return;if(0==this.model.renderers.length)return;const t=this.model.renderers[0],r=()=>this._update_vertices(t),s=t.data_source,i=this._select_event(e,"replace",this.model.renderers);if(!i.length)return this._set_vertices([],[]),this._selected_renderer=null,this._drawing=!1,this._cur_index=null,void s.disconnect(s.properties.data.change,r);s.connect(s.properties.data.change,r),this._cur_index=i[0].data_source.selected.indices[0],this._update_vertices(i[0])}_update_vertices(e){const t=e.glyph,r=e.data_source,s=this._cur_index,[i,_]=[t.xs.field,t.ys.field];if(this._drawing)return;if(null==s&&(i||_))return;let d,l;i&&null!=s?(d=r.data[i][s],(0,n.isArray)(d)||(r.data[i][s]=d=Array.from(d))):d=t.xs.value,_&&null!=s?(l=r.data[_][s],(0,n.isArray)(l)||(r.data[_][s]=l=Array.from(l))):l=t.ys.value,this._selected_renderer=e,this._set_vertices(d,l)}_move(e){if(this._drawing&&null!=this._selected_renderer){const t=this.model.vertex_renderer;if(null==t)return;const r=t.data_source,s=t.glyph,i=this._map_drag(e.sx,e.sy,t);if(null==i)return;let[_,d]=i;const n=r.selected.indices;[_,d]=this._snap_to_vertex(e,_,d),r.selected.indices=n;const[l,c]=[s.x.field,s.y.field],a=n[0];l&&(r.data[l][a]=_),c&&(r.data[c][a]=d),r.change.emit(),this._selected_renderer.data_source.change.emit()}}_tap(e){const t=this.model.vertex_renderer;if(null==t)return;const r=this._map_drag(e.sx,e.sy,t);if(null==r)return;if(this._drawing&&this._selected_renderer){let[s,i]=r;const _=t.data_source,d=t.glyph,[n,l]=[d.x.field,d.y.field],c=_.selected.indices;[s,i]=this._snap_to_vertex(e,s,i);const a=c[0];if(_.selected.indices=[a+1],n){const e=_.get_array(n),t=e[a];e[a]=s,e.splice(a+1,0,t)}if(l){const e=_.get_array(l),t=e[a];e[a]=i,e.splice(a+1,0,t)}return _.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}const s=this._select_mode(e);this._select_event(e,s,[t]),this._select_event(e,s,this.model.renderers)}_remove_vertex(){if(!this._drawing||!this._selected_renderer)return;const e=this.model.vertex_renderer;if(null==e)return;const t=e.data_source,r=e.glyph,s=t.selected.indices[0],[i,_]=[r.x.field,r.y.field];i&&t.get_array(i).splice(s,1),_&&t.get_array(_).splice(s,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}_pan_start(e){null!=this.model.vertex_renderer&&(this._select_event(e,"append",[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy])}_pan(e){null!=this._basepoint&&null!=this.model.vertex_renderer&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&null!=this.model.vertex_renderer&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}_keyup(e){if(!this.model.active||!this._mouse_in_frame)return;let t;if(this._selected_renderer){const{vertex_renderer:e}=this.model;t=null!=e?[e]:[]}else t=this.model.renderers;for(const r of t)e.keyCode===d.Keys.Backspace?(this._delete_selected(r),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==d.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),r.data_source.selection_manager.clear())}deactivate(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())}}r.PolyEditToolView=a,a.__name__="PolyEditToolView";class o extends l.PolyTool{constructor(e){super(e),this.tool_name="Poly Edit Tool",this.tool_icon=c.tool_icon_poly_edit,this.event_type=["tap","pan","move"],this.default_order=4}}r.PolyEditTool=o,_=o,o.__name__="PolyEditTool",_.prototype.default_view=a},
function _(o,l,e,T,t){T(),t("BoxSelectTool",o(464).BoxSelectTool),t("BoxZoomTool",o(466).BoxZoomTool),t("GestureTool",o(267).GestureTool),t("LassoSelectTool",o(467).LassoSelectTool),t("PanTool",o(469).PanTool),t("PolySelectTool",o(468).PolySelectTool),t("RangeTool",o(470).RangeTool),t("SelectTool",o(465).SelectTool),t("TapTool",o(471).TapTool),t("WheelPanTool",o(472).WheelPanTool),t("WheelZoomTool",o(473).WheelZoomTool)},
function _(e,t,o,s,i){s();const l=e(1);var _;const n=e(465),c=e(231),r=e(19),a=l.__importStar(e(265));class h extends n.SelectToolView{_compute_limits(e){const t=this.plot_view.frame,o=this.model.dimensions;let s=this._base_point;if("center"==this.model.origin){const[t,o]=s,[i,l]=e;s=[t-(i-t),o-(l-o)]}return this.model._get_dim_limits(s,e,t,o)}_pan_start(e){const{sx:t,sy:o}=e;this._base_point=[t,o]}_pan(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s),[[_,n],[c,r]]=[i,l];this.model.overlay.update({left:_,right:n,top:c,bottom:r}),this.model.select_every_mousemove&&this._do_select(i,l,!1,this._select_mode(e))}_pan_end(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this._do_select(i,l,!0,this._select_mode(e)),this.model.overlay.clear(),this._base_point=null,this.plot_view.state.push("box_select",{selection:this.plot_view.get_selection()})}_do_select([e,t],[o,s],i,l="replace"){const _={type:"rect",sx0:e,sx1:t,sy0:o,sy1:s};this._select(_,i,l)}}o.BoxSelectToolView=h,h.__name__="BoxSelectToolView";const m=()=>new c.BoxAnnotation({level:"overlay",visible:!1,top_units:"canvas",left_units:"canvas",bottom_units:"canvas",right_units:"canvas",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class d extends n.SelectTool{constructor(e){super(e),this.tool_name="Box Select",this.event_type="pan",this.default_order=30}get computed_icon(){const e=super.computed_icon;if(null!=e)return e;switch(this.dimensions){case"both":return`.${a.tool_icon_box_select}`;case"width":return`.${a.tool_icon_x_box_select}`;case"height":return`.${a.tool_icon_y_box_select}`}}get tooltip(){return this._get_dim_tooltip(this.dimensions)}get computed_overlays(){return[...super.computed_overlays,this.overlay]}}o.BoxSelectTool=d,_=d,d.__name__="BoxSelectTool",_.prototype.default_view=h,_.define((({Boolean:e,Ref:t})=>({dimensions:[r.Dimensions,"both"],select_every_mousemove:[e,!1],overlay:[t(c.BoxAnnotation),m],origin:[r.BoxOrigin,"corner"]}))),_.register_alias("box_select",(()=>new d)),_.register_alias("xbox_select",(()=>new d({dimensions:"width"}))),_.register_alias("ybox_select",(()=>new d({dimensions:"height"})))},
function _(e,t,s,r,n){var o;r();const c=e(267),i=e(198),a=e(396),l=e(199),d=e(94),_=e(19),h=e(55),p=e(46),u=e(15),m=e(12);class v extends c.GestureToolView{connect_signals(){super.connect_signals(),this.model.clear.connect((()=>this._clear()))}get computed_renderers(){const{renderers:e}=this.model,t=this.plot_view.model.data_renderers;return(0,d.compute_renderers)(e,t)}_computed_renderers_by_data_source(){var e;const t=new Map;for(const s of this.computed_renderers){let r;if(s instanceof i.GlyphRenderer)r=s.data_source;else{if(!(s instanceof a.GraphRenderer))continue;r=s.node_renderer.data_source}const n=null!==(e=t.get(r))&&void 0!==e?e:[];t.set(r,[...n,s])}return t}_select_mode(e){const{shiftKey:t,ctrlKey:s}=e;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void(0,m.unreachable)():this.model.mode}_keyup(e){e.keyCode==h.Keys.Esc&&this._clear()}_clear(){for(const e of this.computed_renderers)e.get_selection_manager().clear();const e=this.computed_renderers.map((e=>this.plot_view.renderer_view(e)));this.plot_view.request_paint(e)}_select(e,t,s){const r=this._computed_renderers_by_data_source();for(const[,n]of r){const r=n[0].get_selection_manager(),o=[];for(const e of n){const t=this.plot_view.renderer_view(e);null!=t&&o.push(t)}r.select(o,e,t,s)}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)}_emit_selection_event(e,t=!0){const{x_scale:s,y_scale:r}=this.plot_view.frame;let n;switch(e.type){case"point":{const{sx:t,sy:o}=e,c=s.invert(t),i=r.invert(o);n=Object.assign(Object.assign({},e),{x:c,y:i});break}case"span":{const{sx:t,sy:o}=e,c=s.invert(t),i=r.invert(o);n=Object.assign(Object.assign({},e),{x:c,y:i});break}case"rect":{const{sx0:t,sx1:o,sy0:c,sy1:i}=e,[a,l]=s.r_invert(t,o),[d,_]=r.r_invert(c,i);n=Object.assign(Object.assign({},e),{x0:a,y0:d,x1:l,y1:_});break}case"poly":{const{sx:t,sy:o}=e,c=s.v_invert(t),i=r.v_invert(o);n=Object.assign(Object.assign({},e),{x:c,y:i});break}}this.plot_view.model.trigger_event(new p.SelectionGeometry(n,t))}}s.SelectToolView=v,v.__name__="SelectToolView";class b extends c.GestureTool{constructor(e){super(e)}initialize(){super.initialize(),this.clear=new u.Signal0(this,"clear")}get menu(){return[{icon:"bk-tool-icon-replace-mode",tooltip:"Replace the current selection",active:()=>"replace"==this.mode,handler:()=>{this.mode="replace",this.active=!0}},{icon:"bk-tool-icon-append-mode",tooltip:"Append to the current selection (Shift)",active:()=>"append"==this.mode,handler:()=>{this.mode="append",this.active=!0}},{icon:"bk-tool-icon-intersect-mode",tooltip:"Intersect with the current selection (Ctrl)",active:()=>"intersect"==this.mode,handler:()=>{this.mode="intersect",this.active=!0}},{icon:"bk-tool-icon-subtract-mode",tooltip:"Subtract from the current selection (Shift+Ctrl)",active:()=>"subtract"==this.mode,handler:()=>{this.mode="subtract",this.active=!0}},null,{icon:"bk-tool-icon-clear-selection",tooltip:"Clear the current selection (Esc)",handler:()=>{this.clear.emit()}}]}}s.SelectTool=b,o=b,b.__name__="SelectTool",o.define((({Array:e,Ref:t,Or:s,Auto:r})=>({renderers:[s(e(t(l.DataRenderer)),r),"auto"],mode:[_.SelectionMode,"replace"]})))},
function _(o,t,e,i,s){i();const n=o(1);var _;const a=o(267),r=o(231),h=o(19),l=o(55),c=n.__importStar(o(265));class m extends a.GestureToolView{constructor(){super(...arguments),this._base_point=null}_match_aspect([o,t],[e,i],s){const n=s.bbox.aspect,_=s.bbox.h_range.end,a=s.bbox.h_range.start,r=s.bbox.v_range.end,h=s.bbox.v_range.start;let l=Math.abs(o-e),c=Math.abs(t-i);const m=0==c?0:l/c,[d]=m>=n?[1,m/n]:[n/m,1];let u,p,b,x;return o<=e?(u=o,p=o+l*d,p>_&&(p=_)):(p=o,u=o-l*d,u<a&&(u=a)),l=Math.abs(p-u),t<=i?(x=t,b=t+l/n,b>r&&(b=r)):(b=t,x=t-l/n,x<h&&(x=h)),c=Math.abs(b-x),o<=e?p=o+n*c:u=o-n*c,[[u,p],[x,b]]}_compute_limits(o,t){const{frame:e}=this.plot_view;if("center"==this.model.origin){const[e,i]=o,[s,n]=t;o=[e-(s-e),i-(n-i)]}const i=(()=>{const{dimensions:e}=this.model;if("auto"==e){const[e,i]=o,[s,n]=t,_=Math.abs(e-s),a=Math.abs(i-n),r=5;return _<r&&a>r?"height":_>r&&a<r?"width":"both"}return e})();return this.model.match_aspect&&"both"==i?this._match_aspect(o,t,e):this.model._get_dim_limits(o,t,e,i)}_pan_start(o){this._base_point=[o.sx,o.sy]}_pan(o){if(null==this._base_point)return;const t=[o.sx,o.sy],[[e,i],[s,n]]=this._compute_limits(this._base_point,t);this.model.overlay.update({left:e,right:i,top:s,bottom:n})}_pan_end(o){if(null==this._base_point)return;const t=[o.sx,o.sy],[e,i]=this._compute_limits(this._base_point,t);this._update(e,i),this._stop()}_stop(){this.model.overlay.clear(),this._base_point=null}_keydown(o){o.keyCode==l.Keys.Esc&&this._stop()}_update([o,t],[e,i]){if(Math.abs(t-o)<=5||Math.abs(i-e)<=5)return;const{x_scales:s,y_scales:n}=this.plot_view.frame,_=new Map;for(const[e,i]of s){const[s,n]=i.r_invert(o,t);_.set(e,{start:s,end:n})}const a=new Map;for(const[o,t]of n){const[s,n]=t.r_invert(e,i);a.set(o,{start:s,end:n})}const r={xrs:_,yrs:a};this.plot_view.state.push("box_zoom",{range:r}),this.plot_view.update_range(r),this.plot_view.trigger_ranges_update_event()}}e.BoxZoomToolView=m,m.__name__="BoxZoomToolView";const d=()=>new r.BoxAnnotation({level:"overlay",visible:!1,top_units:"canvas",left_units:"canvas",bottom_units:"canvas",right_units:"canvas",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class u extends a.GestureTool{constructor(o){super(o),this.tool_name="Box Zoom",this.event_type="pan",this.default_order=20}get computed_icon(){const o=super.computed_icon;if(null!=o)return o;switch(this.dimensions){case"both":return`.${c.tool_icon_box_zoom}`;case"width":return`.${c.tool_icon_x_box_zoom}`;case"height":return`.${c.tool_icon_y_box_zoom}`;case"auto":return`.${c.tool_icon_auto_box_zoom}`}}get tooltip(){return this._get_dim_tooltip(this.dimensions)}get computed_overlays(){return[...super.computed_overlays,this.overlay]}get menu(){return[{icon:c.tool_icon_box_zoom,tooltip:"Box zoom in both dimensions",active:()=>"both"==this.dimensions,handler:()=>{this.dimensions="both",this.active=!0}},{icon:c.tool_icon_x_box_zoom,tooltip:"Box zoom in x-dimension",active:()=>"width"==this.dimensions,handler:()=>{this.dimensions="width",this.active=!0}},{icon:c.tool_icon_y_box_zoom,tooltip:"Box zoom in y-dimension",active:()=>"height"==this.dimensions,handler:()=>{this.dimensions="height",this.active=!0}},{icon:c.tool_icon_auto_box_zoom,tooltip:"Automatic mode (box zoom in x, y or both dimensions, depending on the mouse gesture)",active:()=>"auto"==this.dimensions,handler:()=>{this.dimensions="auto",this.active=!0}}]}}e.BoxZoomTool=u,_=u,u.__name__="BoxZoomTool",_.prototype.default_view=m,_.define((({Boolean:o,Ref:t,Or:e,Auto:i})=>({dimensions:[e(h.Dimensions,i),"both"],overlay:[t(r.BoxAnnotation),d],match_aspect:[o,!1],origin:[h.BoxOrigin,"corner"]}))),_.register_alias("box_zoom",(()=>new u({dimensions:"both"}))),_.register_alias("xbox_zoom",(()=>new u({dimensions:"width"}))),_.register_alias("ybox_zoom",(()=>new u({dimensions:"height"}))),_.register_alias("auto_box_zoom",(()=>new u({dimensions:"auto"})))},
function _(e,s,t,o,l){var _;o();const i=e(465),a=e(246),c=e(468),n=e(55),h=e(265);class r extends i.SelectToolView{constructor(){super(...arguments),this.sxs=[],this.sys=[]}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>this._active_change()))}_active_change(){this.model.active||this._clear_overlay()}_keyup(e){e.keyCode==n.Keys.Enter&&this._clear_overlay()}_pan_start(e){this.sxs=[],this.sys=[];const{sx:s,sy:t}=e;this._append_overlay(s,t)}_pan(e){const[s,t]=this.plot_view.frame.bbox.clip(e.sx,e.sy);this._append_overlay(s,t),this.model.select_every_mousemove&&this._do_select(this.sxs,this.sys,!1,this._select_mode(e))}_pan_end(e){const{sxs:s,sys:t}=this;this._clear_overlay(),this._do_select(s,t,!0,this._select_mode(e)),this.plot_view.state.push("lasso_select",{selection:this.plot_view.get_selection()})}_append_overlay(e,s){const{sxs:t,sys:o}=this;t.push(e),o.push(s),this.model.overlay.update({xs:t,ys:o})}_clear_overlay(){this.sxs=[],this.sys=[],this.model.overlay.clear()}_do_select(e,s,t,o){const l={type:"poly",sx:e,sy:s};this._select(l,t,o)}}t.LassoSelectToolView=r,r.__name__="LassoSelectToolView";class y extends i.SelectTool{constructor(e){super(e),this.tool_name="Lasso Select",this.tool_icon=h.tool_icon_lasso_select,this.event_type="pan",this.default_order=12}get computed_overlays(){return[...super.computed_overlays,this.overlay]}}t.LassoSelectTool=y,_=y,y.__name__="LassoSelectTool",_.prototype.default_view=r,_.define((({Boolean:e,Ref:s})=>({select_every_mousemove:[e,!0],overlay:[s(a.PolyAnnotation),c.DEFAULT_POLY_OVERLAY]}))),_.register_alias("lasso_select",(()=>new y))},
function _(e,t,s,l,o){var a;l();const i=e(465),_=e(246),c=e(55),n=e(10),h=e(265);class y extends i.SelectToolView{initialize(){super.initialize(),this.data={sx:[],sy:[]}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,(()=>this._active_change()))}_active_change(){this.model.active||this._clear_data()}_keyup(e){e.keyCode==c.Keys.Enter&&this._clear_data()}_doubletap(e){this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(e)),this.plot_view.state.push("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()}_clear_data(){this.data={sx:[],sy:[]},this.model.overlay.clear()}_tap(e){const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)&&(this.data.sx.push(t),this.data.sy.push(s),this.model.overlay.update({xs:(0,n.copy)(this.data.sx),ys:(0,n.copy)(this.data.sy)}))}_do_select(e,t,s,l){const o={type:"poly",sx:e,sy:t};this._select(o,s,l)}}s.PolySelectToolView=y,y.__name__="PolySelectToolView";s.DEFAULT_POLY_OVERLAY=()=>new _.PolyAnnotation({level:"overlay",visible:!1,xs_units:"canvas",ys_units:"canvas",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class r extends i.SelectTool{constructor(e){super(e),this.tool_name="Poly Select",this.tool_icon=h.tool_icon_polygon_select,this.event_type="tap",this.default_order=11}get computed_overlays(){return[...super.computed_overlays,this.overlay]}}s.PolySelectTool=r,a=r,r.__name__="PolySelectTool",a.prototype.default_view=y,a.define((({Ref:e})=>({overlay:[e(_.PolyAnnotation),s.DEFAULT_POLY_OVERLAY]}))),a.register_alias("poly_select",(()=>new r))},
function _(t,i,n,s,e){s();const o=t(1);var a;const _=t(267),h=t(19),r=o.__importStar(t(265));function d(t,i,n){const s=new Map;for(const[e,o]of t){const[t,a]=o.r_invert(i,n);s.set(e,{start:t,end:a})}return s}n.update_ranges=d;class l extends _.GestureToolView{_pan_start(t){var i;this.last_dx=0,this.last_dy=0;const{sx:n,sy:s}=t,e=this.plot_view.frame.bbox;if(!e.contains(n,s)){const t=e.h_range,i=e.v_range;(n<t.start||n>t.end)&&(this.v_axis_only=!0),(s<i.start||s>i.end)&&(this.h_axis_only=!0)}null===(i=this.model.document)||void 0===i||i.interactive_start(this.plot_view.model)}_pan(t){var i;this._update(t.deltaX,t.deltaY),null===(i=this.model.document)||void 0===i||i.interactive_start(this.plot_view.model)}_pan_end(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.state.push("pan",{range:this.pan_info}),this.plot_view.trigger_ranges_update_event()}_update(t,i){const n=this.plot_view.frame,s=t-this.last_dx,e=i-this.last_dy,o=n.bbox.h_range,a=o.start-s,_=o.end-s,h=n.bbox.v_range,r=h.start-e,l=h.end-e,c=this.model.dimensions;let p,m,u,v,g,x;"width"!=c&&"both"!=c||this.v_axis_only?(p=o.start,m=o.end,u=0):(p=a,m=_,u=-s),"height"!=c&&"both"!=c||this.h_axis_only?(v=h.start,g=h.end,x=0):(v=r,g=l,x=-e),this.last_dx=t,this.last_dy=i;const{x_scales:w,y_scales:y}=n,f=d(w,p,m),b=d(y,v,g);this.pan_info={xrs:f,yrs:b,sdx:u,sdy:x},this.plot_view.update_range(this.pan_info,{panning:!0})}}n.PanToolView=l,l.__name__="PanToolView";class c extends _.GestureTool{constructor(t){super(t),this.tool_name="Pan",this.event_type="pan",this.default_order=10}get tooltip(){return this._get_dim_tooltip(this.dimensions)}get computed_icon(){const t=super.computed_icon;if(null!=t)return t;switch(this.dimensions){case"both":return`.${r.tool_icon_pan}`;case"width":return`.${r.tool_icon_x_pan}`;case"height":return`.${r.tool_icon_y_pan}`}}get menu(){return[{icon:r.tool_icon_pan,tooltip:"Pan in both dimensions",active:()=>"both"==this.dimensions,handler:()=>{this.dimensions="both",this.active=!0}},{icon:r.tool_icon_x_pan,tooltip:"Pan in x-dimension",active:()=>"width"==this.dimensions,handler:()=>{this.dimensions="width",this.active=!0}},{icon:r.tool_icon_y_pan,tooltip:"Pan in y-dimension",active:()=>"height"==this.dimensions,handler:()=>{this.dimensions="height",this.active=!0}}]}}n.PanTool=c,a=c,c.__name__="PanTool",a.prototype.default_view=l,a.define((()=>({dimensions:[h.Dimensions,"both"]}))),a.register_alias("pan",(()=>new c({dimensions:"both"}))),a.register_alias("xpan",(()=>new c({dimensions:"width"}))),a.register_alias("ypan",(()=>new c({dimensions:"height"})))},
function _(e,t,s,i,n){var l;i();const a=e(231),r=e(87),o=e(18),_=e(267),h=e(265);function d(e){switch(e){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return e}}function u(e,t,s,i){if(null==t)return!1;const n=s.compute(t);return Math.abs(e-n)<i}function c(e,t,s,i,n){let l=!0;if(null!=n.left&&null!=n.right){const t=s.invert(e);(t<n.left||t>n.right)&&(l=!1)}if(null!=n.bottom&&null!=n.top){const e=i.invert(t);(e<n.bottom||e>n.top)&&(l=!1)}return l}function g(e,t,s){let i=0;return e>=s.start&&e<=s.end&&(i+=1),t>=s.start&&t<=s.end&&(i+=1),i}function y(e,t,s,i){const n=t.compute(e),l=t.invert(n+s);return l>=i.start&&l<=i.end?l:e}function f(e,t,s){return e>t.start?(t.end=e,s):(t.end=t.start,t.start=e,d(s))}function v(e,t,s){return e<t.end?(t.start=e,s):(t.start=t.end,t.end=e,d(s))}function p(e,t,s,i){const[n,l]=t.r_compute(e.start,e.end),[a,r]=t.r_invert(n+s,l+s),o=g(e.start,e.end,i);g(a,r,i)>=o&&(e.start=a,e.end=r)}s.flip_side=d,s.is_near=u,s.is_inside=c,s.sides_inside=g,s.compute_value=y,s.update_range_end_side=f,s.update_range_start_side=v,s.update_range=p;class m extends _.GestureToolView{initialize(){super.initialize(),this.side=0,this.model.update_overlay_from_ranges()}connect_signals(){super.connect_signals(),null!=this.model.x_range&&this.connect(this.model.x_range.change,(()=>this.model.update_overlay_from_ranges())),null!=this.model.y_range&&this.connect(this.model.y_range.change,(()=>this.model.update_overlay_from_ranges()))}_pan_start(e){this.last_dx=0,this.last_dy=0;const t=this.model.x_range,s=this.model.y_range,{frame:i}=this.plot_view,n=i.x_scale,l=i.y_scale,r=this.model.overlay,{left:o,right:_,top:h,bottom:d}=r,g=this.model.overlay.line_width+a.EDGE_TOLERANCE;null!=t&&this.model.x_interaction&&(u(e.sx,o,n,g)?this.side=1:u(e.sx,_,n,g)?this.side=2:c(e.sx,e.sy,n,l,r)&&(this.side=3)),null!=s&&this.model.y_interaction&&(0==this.side&&u(e.sy,d,l,g)&&(this.side=4),0==this.side&&u(e.sy,h,l,g)?this.side=5:c(e.sx,e.sy,n,l,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))}_pan(e){const t=this.plot_view.frame,s=e.deltaX-this.last_dx,i=e.deltaY-this.last_dy,n=this.model.x_range,l=this.model.y_range,a=t.x_scale,r=t.y_scale;if(null!=n)if(3==this.side||7==this.side)p(n,a,s,t.x_range);else if(1==this.side){const e=y(n.start,a,s,t.x_range);this.side=v(e,n,this.side)}else if(2==this.side){const e=y(n.end,a,s,t.x_range);this.side=f(e,n,this.side)}if(null!=l)if(6==this.side||7==this.side)p(l,r,i,t.y_range);else if(4==this.side){const e=y(l.start,r,i,t.y_range);this.side=v(e,l,this.side)}else if(5==this.side){const e=y(l.end,r,i,t.y_range);this.side=f(e,l,this.side)}this.last_dx=e.deltaX,this.last_dy=e.deltaY}_pan_end(e){this.side=0,this.plot_view.trigger_ranges_update_event()}}s.RangeToolView=m,m.__name__="RangeToolView";const x=()=>new a.BoxAnnotation({level:"overlay",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:.5,line_dash:[2,2]});class w extends _.GestureTool{constructor(e){super(e),this.tool_name="Range Tool",this.tool_icon=h.tool_icon_range,this.event_type="pan",this.default_order=1}initialize(){super.initialize(),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null}update_overlay_from_ranges(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,o.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)}get computed_overlays(){return[...super.computed_overlays,this.overlay]}}s.RangeTool=w,l=w,w.__name__="RangeTool",l.prototype.default_view=m,l.define((({Boolean:e,Ref:t,Nullable:s})=>({x_range:[s(t(r.Range1d)),null],x_interaction:[e,!0],y_range:[s(t(r.Range1d)),null],y_interaction:[e,!0],overlay:[t(a.BoxAnnotation),x]})))},
function _(e,t,s,o,i){var l;o();const a=e(465),n=e(19),c=e(265);class _ extends a.SelectToolView{_tap(e){"tap"==this.model.gesture&&this._handle_tap(e)}_doubletap(e){"doubletap"==this.model.gesture&&this._handle_tap(e)}_handle_tap(e){const{sx:t,sy:s}=e,o={type:"point",sx:t,sy:s};this._select(o,!0,this._select_mode(e))}_select(e,t,s){const{callback:o}=this.model;if("select"==this.model.behavior){const i=this._computed_renderers_by_data_source();for(const[,l]of i){const i=l[0].get_selection_manager(),a=l.map((e=>this.plot_view.renderer_view(e))).filter((e=>null!=e));if(i.select(a,e,t,s)&&null!=o){const t=a[0].coordinates.x_scale.invert(e.sx),s=a[0].coordinates.y_scale.invert(e.sy),l={geometries:Object.assign(Object.assign({},e),{x:t,y:s}),source:i.source};o.execute(this.model,l)}}this._emit_selection_event(e),this.plot_view.state.push("tap",{selection:this.plot_view.get_selection()})}else for(const t of this.computed_renderers){const s=this.plot_view.renderer_view(t);if(null==s)continue;const i=t.get_selection_manager();if(i.inspect(s,e)&&null!=o){const t=s.coordinates.x_scale.invert(e.sx),l=s.coordinates.y_scale.invert(e.sy),a={geometries:Object.assign(Object.assign({},e),{x:t,y:l}),source:i.source};o.execute(this.model,a)}}}}s.TapToolView=_,_.__name__="TapToolView";class r extends a.SelectTool{constructor(e){super(e),this.tool_name="Tap",this.tool_icon=c.tool_icon_tap_select,this.event_type="tap",this.default_order=10}}s.TapTool=r,l=r,r.__name__="TapTool",l.prototype.default_view=_,l.define((({Any:e,Enum:t,Nullable:s})=>({behavior:[n.TapBehavior,"select"],gesture:[t("tap","doubletap"),"tap"],callback:[s(e),null]}))),l.register_alias("click",(()=>new r({behavior:"inspect"}))),l.register_alias("tap",(()=>new r)),l.register_alias("doubletap",(()=>new r({gesture:"doubletap"})))},
function _(e,t,s,i,n){var o;i();const a=e(267),l=e(19),_=e(265),r=e(469);class h extends a.GestureToolView{_scroll(e){let t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)}_update_ranges(e){var t;const{frame:s}=this.plot_view,i=s.bbox.h_range,n=s.bbox.v_range,[o,a]=[i.start,i.end],[l,_]=[n.start,n.end];let h,d,p,c;switch(this.model.dimension){case"height":{const t=Math.abs(_-l);h=o,d=a,p=l-t*e,c=_-t*e;break}case"width":{const t=Math.abs(a-o);h=o-t*e,d=a-t*e,p=l,c=_;break}}const{x_scales:w,y_scales:g}=s,u={xrs:(0,r.update_ranges)(w,h,d),yrs:(0,r.update_ranges)(g,p,c),factor:e};this.plot_view.state.push("wheel_pan",{range:u}),this.plot_view.update_range(u,{scrolling:!0}),null===(t=this.model.document)||void 0===t||t.interactive_start(this.plot_view.model,(()=>this.plot_view.trigger_ranges_update_event()))}}s.WheelPanToolView=h,h.__name__="WheelPanToolView";class d extends a.GestureTool{constructor(e){super(e),this.tool_name="Wheel Pan",this.tool_icon=_.tool_icon_wheel_pan,this.event_type="scroll",this.default_order=12}get tooltip(){return this._get_dim_tooltip(this.dimension)}}s.WheelPanTool=d,o=d,d.__name__="WheelPanTool",o.prototype.default_view=h,o.define((()=>({dimension:[l.Dimension,"width"]}))),o.internal((({Number:e})=>({speed:[e,.001]}))),o.register_alias("xwheel_pan",(()=>new d({dimension:"width"}))),o.register_alias("ywheel_pan",(()=>new d({dimension:"height"})))},
function _(e,o,t,s,i){var n;s();const l=e(267),_=e(451),h=e(19),a=e(26),r=e(265);class m extends l.GestureToolView{_pinch(e){const{sx:o,sy:t,scale:s,ctrlKey:i,shiftKey:n}=e;let l;l=s>=1?20*(s-1):-20/s,this._scroll({type:"wheel",sx:o,sy:t,delta:l,ctrlKey:i,shiftKey:n})}_scroll(e){var o;const{frame:t}=this.plot_view,s=t.bbox.h_range,i=t.bbox.v_range,{sx:n,sy:l}=e,h=this.model.dimensions,a=("width"==h||"both"==h)&&s.start<n&&n<s.end,r=("height"==h||"both"==h)&&i.start<l&&l<i.end;if(!(a&&r||this.model.zoom_on_axis))return;const m=this.model.speed*e.delta,d=(0,_.scale_range)(t,m,a,r,{x:n,y:l});this.plot_view.state.push("wheel_zoom",{range:d});const{maintain_focus:c}=this.model;this.plot_view.update_range(d,{scrolling:!0,maintain_focus:c}),null===(o=this.model.document)||void 0===o||o.interactive_start(this.plot_view.model,(()=>this.plot_view.trigger_ranges_update_event()))}}t.WheelZoomToolView=m,m.__name__="WheelZoomToolView";class d extends l.GestureTool{constructor(e){super(e),this.tool_name="Wheel Zoom",this.tool_icon=r.tool_icon_wheel_zoom,this.event_type=a.is_mobile?"pinch":"scroll",this.default_order=10}get tooltip(){return this._get_dim_tooltip(this.dimensions)}}t.WheelZoomTool=d,n=d,d.__name__="WheelZoomTool",n.prototype.default_view=m,n.define((({Boolean:e,Number:o})=>({dimensions:[h.Dimensions,"both"],maintain_focus:[e,!0],zoom_on_axis:[e,!0],speed:[o,1/600]}))),n.register_alias("wheel_zoom",(()=>new d({dimensions:"both"}))),n.register_alias("xwheel_zoom",(()=>new d({dimensions:"width"}))),n.register_alias("ywheel_zoom",(()=>new d({dimensions:"height"})))},
function _(o,r,s,e,l){e(),l("CrosshairTool",o(475).CrosshairTool),l("CustomJSHover",o(476).CustomJSHover),l("HoverTool",o(477).HoverTool),l("InspectTool",o(259).InspectTool)},
function _(i,o,s,t,e){var n;t();const l=i(259),a=i(248),h=i(19),_=i(9),r=i(265);class p extends l.InspectToolView{_move(i){if(!this.model.active)return;const{sx:o,sy:s}=i;this.plot_view.frame.bbox.contains(o,s)?this._update_spans(o,s):this._update_spans(null,null)}_move_exit(i){this._update_spans(null,null)}_update_spans(i,o){const s=this.model.dimensions;"width"!=s&&"both"!=s||(this.model.spans.width.location=o),"height"!=s&&"both"!=s||(this.model.spans.height.location=i)}}s.CrosshairToolView=p,p.__name__="CrosshairToolView";class c extends l.InspectTool{constructor(i){super(i),this.tool_name="Crosshair",this.tool_icon=r.tool_icon_crosshair}get tooltip(){return this._get_dim_tooltip(this.dimensions)}get computed_overlays(){return(0,_.values)(this.spans)}}s.CrosshairTool=c,n=c,c.__name__="CrosshairTool",(()=>{function i(i,o){return new a.Span({dimension:o,location_units:"canvas",level:"overlay",line_color:i.line_color,line_width:i.line_width,line_alpha:i.line_alpha})}n.prototype.default_view=p,n.define((({Alpha:i,Number:o,Color:s})=>({dimensions:[h.Dimensions,"both"],line_color:[s,"black"],line_width:[o,1],line_alpha:[i,1]}))),n.internal((({Struct:o,Ref:s})=>({spans:[o({width:s(a.Span),height:s(a.Span)}),o=>({width:i(o,"width"),height:i(o,"height")})]}))),n.register_alias("crosshair",(()=>new c))})()},
function _(e,s,t,r,n){var o;r();const a=e(50),u=e(9),c=e(38);class i extends a.Model{constructor(e){super(e)}get values(){return(0,u.values)(this.args)}_make_code(e,s,t,r){return new Function(...(0,u.keys)(this.args),e,s,t,(0,c.use_strict)(r))}format(e,s,t){return this._make_code("value","format","special_vars",this.code)(...this.values,e,s,t)}}t.CustomJSHover=i,o=i,i.__name__="CustomJSHover",o.define((({Unknown:e,String:s,Dict:t})=>({args:[t(e),{}],code:[s,""]})))},
function _(e,t,n,s,i){s();const o=e(1);var r;const l=e(58),a=e(55),c=e(19),_=o.__importStar(e(209)),d=e(15),p=e(12),u=e(21),h=e(32),m=e(9),y=e(169),f=e(8),v=e(265),x=o.__importStar(e(437)),w=e(435),g=e(478),b=e(211),C=e(320),T=e(200),S=e(323),$=e(210),k=e(213),V=e(199),A=e(198),M=e(396),H=e(94),z=e(476),R=e(259);function G(e,t,n,s){const i={x:n[e],y:s[e]},o={x:n[e+1],y:s[e+1]},{sx:r,sy:l}=t,[a,c]=function(){if("span"==t.type)return"h"==t.direction?[Math.abs(i.x-r),Math.abs(o.x-r)]:[Math.abs(i.y-l),Math.abs(o.y-l)];const e={x:r,y:l};return[_.dist_2_pts(i,e),_.dist_2_pts(o,e)]}();return a<c?[[i.x,i.y],e]:[[o.x,o.y],e+1]}function P(e,t,n){return[[e[n],t[n]],n]}n._nearest_line_hit=G,n._line_hit=P;class E extends R.InspectToolView{constructor(){super(...arguments),this.ttmodels=new Map}initialize(){super.initialize(),this._ttviews=new Map}async lazy_initialize(){await super.lazy_initialize(),await this._update_ttmodels();const{tooltips:e}=this.model;e instanceof g.Template&&(this._template_view=await(0,l.build_view)(e,{parent:this.plot_view.canvas}),this._template_view.render())}remove(){var e;null===(e=this._template_view)||void 0===e||e.remove(),(0,l.remove_views)(this._ttviews),super.remove()}connect_signals(){super.connect_signals();const e=this.plot_view.model.properties.renderers,{renderers:t,tooltips:n}=this.model.properties;this.on_change(n,(()=>delete this._template_el)),this.on_change([e,t,n],(async()=>await this._update_ttmodels()))}async _update_ttmodels(){const{ttmodels:e}=this;e.clear();const{tooltips:t}=this.model;if(null==t)return;const{computed_renderers:n}=this;for(const t of n){const n=new w.Tooltip({content:document.createElement("div"),attachment:this.model.attachment,show_arrow:this.model.show_arrow,interactive:!1,visible:!0,position:null,target:this.parent.canvas.overlays_el});t instanceof A.GlyphRenderer?e.set(t,n):t instanceof M.GraphRenderer&&(e.set(t.node_renderer,n),e.set(t.edge_renderer,n))}await(0,l.build_views)(this._ttviews,[...e.values()],{parent:this.plot_view});const s=[...function*(){for(const e of n)e instanceof A.GlyphRenderer?yield e:e instanceof M.GraphRenderer&&(yield e.node_renderer,yield e.edge_renderer)}()],i=this._slots.get(this.update);if(null!=i){const e=new Set(s.map((e=>e.data_source)));d.Signal.disconnect_receiver(this,i,e)}for(const e of s)this.connect(e.data_source.inspect,this.update)}get computed_renderers(){const{renderers:e}=this.model,t=this.plot_view.model.data_renderers;return(0,H.compute_renderers)(e,t)}_clear(){this._inspect(1/0,1/0);for(const[,e]of this.ttmodels)e.clear()}_move(e){if(!this.model.active)return;const{sx:t,sy:n}=e;this.plot_view.frame.bbox.contains(t,n)?this._inspect(t,n):this._clear()}_move_exit(){this._clear()}_inspect(e,t){let n;if("mouse"==this.model.mode)n={type:"point",sx:e,sy:t};else{n={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t}}for(const e of this.computed_renderers){const t=e.get_selection_manager(),s=this.plot_view.renderer_view(e);null!=s&&t.inspect(s,n)}this._emit_callback(n)}_update(e,t,n){var s,i;const o=e.get_selection_manager(),r=o.inspectors.get(e),l=e.view.convert_selection_to_subset(r);if(r.is_empty()&&null==r.view)return void n.clear();const c=o.source,_=this.plot_view.renderer_view(e);if(null==_)return;const{sx:d,sy:u}=t,h=_.coordinates.x_scale,y=_.coordinates.y_scale,f=h.invert(d),v=y.invert(u),{glyph:x}=_,w=[];if(x instanceof $.PatchView){const[t,n]=[d,u],[s,i]=[f,v],o={index:null,glyph_view:x,x:f,y:v,sx:d,sy:u,snap_x:s,snap_y:i,snap_sx:t,snap_sy:n,name:e.name},r=this._render_tooltips(c,o);w.push([t,n,r])}else if(x instanceof k.VAreaView||x instanceof b.HAreaView)for(const t of l.line_indices){const[n,s]=[f,v],[i,o]=[d,u],r={index:t,glyph_view:x,x:f,y:v,sx:d,sy:u,snap_x:n,snap_y:s,snap_sx:i,snap_sy:o,name:e.name,indices:l.line_indices},a=this._render_tooltips(c,r);w.push([i,o,a])}else if(x instanceof T.LineView){const{line_policy:n}=this.model;for(const s of l.line_indices){const[[i,o],[r,a],_]=(()=>{if("interp"==n){const[e,n]=x.get_interpolation_hit(s,t);return[[e,n],[h.compute(e),y.compute(n)],s]}const[e,i]=[x._x,x._y];if("prev"==n){const[t,n]=P(x.sx,x.sy,s);return[[e[s+1],i[s+1]],t,n]}if("next"==n){const[t,n]=P(x.sx,x.sy,s+1);return[[e[s+1],i[s+1]],t,n]}if("nearest"==n){const[n,o]=G(s,t,x.sx,x.sy);return[[e[o],i[o]],n,o]}throw new Error("shouldn't have happened")})(),p={index:_,glyph_view:x,x:f,y:v,sx:d,sy:u,snap_x:i,snap_y:o,snap_sx:r,snap_sy:a,name:e.name,indices:l.line_indices},m=this._render_tooltips(c,p);w.push([r,a,m])}}else if(x instanceof C.ImageBaseView)for(const t of r.image_indices){const[n,s]=[d,u],[i,o]=[f,v],r={index:t.index,glyph_view:x,x:f,y:v,sx:d,sy:u,snap_x:i,snap_y:o,snap_sx:n,snap_sy:s,name:e.name,image_index:t},l=this._render_tooltips(c,r);w.push([n,s,l])}else for(const n of l.indices)if(x instanceof S.MultiLineView&&!(0,m.is_empty)(l.multiline_indices)){const{line_policy:s}=this.model;for(const i of l.multiline_indices[n.toString()]){const[[o,r],[a,_],p]=function(){if("interp"==s){const[e,s]=x.get_interpolation_hit(n,i,t);return[[e,s],[h.compute(e),y.compute(s)],i]}const[e,o]=[x._xs.get(n),x._ys.get(n)];if("prev"==s){const[t,s]=P(x.sxs.get(n),x.sys.get(n),i);return[[e[i],o[i]],t,s]}if("next"==s){const[t,s]=P(x.sxs.get(n),x.sys.get(n),i+1);return[[e[i],o[i]],t,s]}if("nearest"==s){const[s,r]=G(i,t,x.sxs.get(n),x.sys.get(n));return[[e[r],o[r]],s,r]}throw new Error("shouldn't have happened")}(),m={index:e.view.convert_indices_from_subset([n])[0],glyph_view:x,x:f,y:v,sx:d,sy:u,snap_x:o,snap_y:r,snap_sx:a,snap_sy:_,name:e.name,indices:l.multiline_indices,segment_index:p},g=this._render_tooltips(c,m);w.push([a,_,g])}}else{const t=null===(s=x._x)||void 0===s?void 0:s[n],o=null===(i=x._y)||void 0===i?void 0:i[n],{point_policy:r,anchor:a}=this.model,[_,p]=function(){if("snap_to_data"==r){const e=x.get_anchor_point(a,n,[d,u]);if(null!=e)return[e.x,e.y];const t=x.get_anchor_point("center",n,[d,u]);return null!=t?[t.x,t.y]:[d,u]}return[d,u]}(),h={index:e.view.convert_indices_from_subset([n])[0],glyph_view:x,x:f,y:v,sx:d,sy:u,snap_x:t,snap_y:o,snap_sx:_,snap_sy:p,name:e.name,indices:l.indices},m=this._render_tooltips(c,h);w.push([_,p,m])}if(0==w.length)n.clear();else{const{content:e}=n;(0,p.assert)(e instanceof Element),(0,a.empty)(e);for(const[,,t]of w)null!=t&&e.appendChild(t);const[t,s]=w[w.length-1];n.setv({position:[t,s]},{check_eq:!1})}}update([e,{geometry:t}]){if(!this.model.active)return;if("point"!=t.type&&"span"!=t.type)return;if("ignore"==this.model.muted_policy&&e.muted)return;const n=this.ttmodels.get(e);(0,f.is_undefined)(n)||this._update(e,t,n)}_emit_callback(e){const{callback:t}=this.model;if(null!=t)for(const n of this.computed_renderers){if(!(n instanceof A.GlyphRenderer))continue;const s=this.plot_view.renderer_view(n);if(null==s)continue;const{x_scale:i,y_scale:o}=s.coordinates,r=i.invert(e.sx),l=o.invert(e.sy),a=n.data_source.inspected;t.execute(this.model,{geometry:Object.assign({x:r,y:l},e),renderer:n,index:a})}}_create_template(e){const t=(0,a.div)({style:{display:"table",borderSpacing:"2px"}});for(const[n]of e){const e=(0,a.div)({style:{display:"table-row"}});t.appendChild(e);const s=(0,a.div)({style:{display:"table-cell"},class:x.tooltip_row_label},0!=n.length?`${n}: `:"");e.appendChild(s);const i=(0,a.span)();i.dataset.value="";const o=(0,a.span)({class:x.tooltip_color_block}," ");o.dataset.swatch="",(0,a.undisplay)(o);const r=(0,a.div)({style:{display:"table-cell"},class:x.tooltip_row_value},i,o);e.appendChild(r)}return t}_render_template(e,t,n,s){const i=e.cloneNode(!0),o=(0,f.is_undefined)(s.image_index)?s.index:s.image_index,r=i.querySelectorAll("[data-value]"),l=i.querySelectorAll("[data-swatch]"),c=/\$color(\[.*\])?:(\w*)/,_=/\$swatch:(\w*)/;for(const[[,e],i]of(0,h.enumerate)(t)){const t=e.match(_),d=e.match(c);if(null!=t||null!=d){if(null!=t){const[,e]=t,s=n.get_column(e);if(null==s)r[i].textContent=`${e} unknown`;else{const e=(0,f.isNumber)(o)?s[o]:null;null!=e&&(l[i].style.backgroundColor=(0,u.color2css)(e),(0,a.display)(l[i]))}}if(null!=d){const[,e="",t]=d,s=n.get_column(t);if(null==s){r[i].textContent=`${t} unknown`;continue}const c=e.indexOf("hex")>=0,_=e.indexOf("swatch")>=0,p=(0,f.isNumber)(o)?s[o]:null;if(null==p){r[i].textContent="(null)";continue}r[i].textContent=c?(0,u.color2hex)(p):(0,u.color2css)(p),_&&(l[i].style.backgroundColor=(0,u.color2css)(p),(0,a.display)(l[i]))}}else{const t=(0,y.replace_placeholders)(e.replace("$~","$data_"),n,o,this.model.formatters,s);if((0,f.isString)(t))r[i].textContent=t;else for(const e of t)r[i].appendChild(e)}}return i}_render_tooltips(e,t){var n;const{tooltips:s}=this.model,i=t.index;if((0,f.isString)(s)){const n=(0,y.replace_placeholders)({html:s},e,i,this.model.formatters,t);return(0,a.div)(n)}if((0,f.isFunction)(s))return s(e,t);if(s instanceof g.Template)return this._template_view.update(e,i,t),this._template_view.el;if(null!=s){const i=null!==(n=this._template_el)&&void 0!==n?n:this._template_el=this._create_template(s);return this._render_template(i,s,e,t)}return null}}n.HoverToolView=E,E.__name__="HoverToolView";class N extends R.InspectTool{constructor(e){super(e),this.tool_name="Hover",this.tool_icon=v.tool_icon_hover}}n.HoverTool=N,r=N,N.__name__="HoverTool",r.prototype.default_view=E,r.define((({Any:e,Boolean:t,String:n,Array:s,Tuple:i,Dict:o,Or:r,Ref:l,Function:a,Auto:_,Nullable:d})=>({tooltips:[d(r(l(g.Template),n,s(i(n,n)),a())),[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[o(r(l(z.CustomJSHover),y.FormatterType)),{}],renderers:[r(s(l(V.DataRenderer)),_),"auto"],mode:[c.HoverMode,"mouse"],muted_policy:[c.MutedPolicy,"show"],point_policy:[c.PointPolicy,"snap_to_data"],line_policy:[c.LinePolicy,"nearest"],show_arrow:[t,!0],anchor:[c.Anchor,"center"],attachment:[c.TooltipAttachment,"horizontal"],callback:[d(e),null]}))),r.register_alias("hover",(()=>new N))},
function _(e,i,t,a,s){var n;a();const o=e(479),c=e(480),l=e(481),_=e(58);class r extends o.DOMElementView{constructor(){super(...arguments),this.action_views=new Map}async lazy_initialize(){await super.lazy_initialize(),await(0,_.build_views)(this.action_views,this.model.actions,{parent:this})}remove(){(0,_.remove_views)(this.action_views),super.remove()}update(e,i,t={}){!function a(s){for(const n of s.child_views.values())n instanceof l.PlaceholderView?n.update(e,i,t):n instanceof o.DOMElementView&&a(n)}(this);for(const a of this.action_views.values())a.update(e,i,t)}}t.TemplateView=r,r.__name__="TemplateView",r.tag_name="div";class w extends o.DOMElement{}t.Template=w,n=w,w.__name__="Template",n.prototype.default_view=r,n.define((({Array:e,Ref:i})=>({actions:[e(i(c.Action)),[]]})))},
function _(e,t,s,i,l){var n;i();const r=e(429),o=e(252),c=e(251),a=e(58),h=e(9),d=e(8);class _ extends r.DOMNodeView{constructor(){super(...arguments),this.child_views=new Map}async lazy_initialize(){await super.lazy_initialize();const e=this.model.children.filter((e=>!(0,d.isString)(e)));await(0,a.build_views)(this.child_views,e,{parent:this})}remove(){(0,a.remove_views)(this.child_views),super.remove()}render(){const{style:e}=this.model;if(null!=e)if(e instanceof o.Styles)for(const t of e){const e=t.get_value();if((0,d.isString)(e)){const s=t.attr.replace(/_/g,"-");this.el.style.hasOwnProperty(s)&&this.el.style.setProperty(s,e)}}else for(const[t,s]of(0,h.entries)(e)){const e=t.replace(/_/g,"-");this.el.style.hasOwnProperty(e)&&this.el.style.setProperty(e,s)}for(const e of this.model.children)if((0,d.isString)(e)){const t=document.createTextNode(e);this.el.appendChild(t)}else{this.child_views.get(e).render_to(this.el)}this.finish()}}s.DOMElementView=_,_.__name__="DOMElementView";class f extends r.DOMNode{constructor(e){super(e)}}s.DOMElement=f,n=f,f.__name__="DOMElement",n.define((({String:e,Array:t,Dict:s,Or:i,Nullable:l,Ref:n})=>({style:[l(i(n(o.Styles),s(e))),null],children:[t(i(e,n(r.DOMNode),n(c.UIElement))),[]]})))},
function _(e,o,_,n,c){n();const s=e(50),t=e(53);class i extends t.View{}_.ActionView=i,i.__name__="ActionView";class d extends s.Model{constructor(e){super(e)}}_.Action=d,d.__name__="Action",d.__module__="bokeh.models.dom"},
function _(e,a,n,c,l){c();const o=e(429);class s extends o.DOMNodeView{render(){}}n.PlaceholderView=s,s.__name__="PlaceholderView",s.tag_name="span";class _ extends o.DOMNode{constructor(e){super(e)}}n.Placeholder=_,_.__name__="Placeholder"},
function _(e,l,o,a,T){a(),T("Action",e(480).Action),T("ColorRef",e(483).ColorRef),T("DOMElement",e(479).DOMElement),T("DOMNode",e(429).DOMNode);var t=e(485);T("Span",t.Span),T("Div",t.Div),T("Table",t.Table),T("TableRow",t.TableRow),T("HTML",e(436).HTML),T("Index",e(486).Index),T("Placeholder",e(481).Placeholder),T("Styles",e(252).Styles),T("Template",e(478).Template),T("Text",e(430).Text),T("ToggleGroup",e(487).ToggleGroup),T("ValueOf",e(488).ValueOf),T("ValueRef",e(484).ValueRef)},
function _(e,t,l,o,s){o();const a=e(1);var n;const _=e(484),i=e(169),r=e(55),c=a.__importStar(e(437));class h extends _.ValueRefView{render(){super.render(),this.value_el=(0,r.span)(),this.swatch_el=(0,r.span)({class:c.tooltip_color_block}," "),this.el.appendChild(this.value_el),this.el.appendChild(this.swatch_el)}update(e,t,l){const o=(0,i._get_column_value)(this.model.field,e,t),s=null==o?"???":`${o}`;this.el.textContent=s}}l.ColorRefView=h,h.__name__="ColorRefView";class d extends _.ValueRef{constructor(e){super(e)}}l.ColorRef=d,n=d,d.__name__="ColorRef",n.prototype.default_view=h,n.define((({Boolean:e})=>({hex:[e,!0],swatch:[e,!0]})))},
function _(e,l,t,n,a){var _;n();const o=e(481),s=e(169);class u extends o.PlaceholderView{update(e,l,t){const n=(0,s._get_column_value)(this.model.field,e,l),a=null==n?"???":`${n}`;this.el.textContent=a}}t.ValueRefView=u,u.__name__="ValueRefView";class i extends o.Placeholder{constructor(e){super(e)}}t.ValueRef=i,_=i,i.__name__="ValueRef",_.prototype.default_view=u,_.define((({String:e})=>({field:[e]})))},
function _(e,a,_,n,t){var l,s,i,m;n();const w=e(479);class o extends w.DOMElementView{}_.SpanView=o,o.__name__="SpanView",o.tag_name="span";class d extends w.DOMElement{}_.Span=d,l=d,d.__name__="Span",l.prototype.default_view=o;class p extends w.DOMElementView{}_.DivView=p,p.__name__="DivView",p.tag_name="div";class D extends w.DOMElement{}_.Div=D,s=D,D.__name__="Div",s.prototype.default_view=p;class V extends w.DOMElementView{}_.TableView=V,V.__name__="TableView",V.tag_name="table";class c extends w.DOMElement{}_.Table=c,i=c,c.__name__="Table",i.prototype.default_view=V;class v extends w.DOMElementView{}_.TableRowView=v,v.__name__="TableRowView",v.tag_name="tr";class b extends w.DOMElement{}_.TableRow=b,m=b,b.__name__="TableRow",m.prototype.default_view=v},
function _(e,n,t,l,d){var o;l();const s=e(481);class _ extends s.PlaceholderView{update(e,n,t){this.el.textContent=null==n?"(null)":n.toString()}}t.IndexView=_,_.__name__="IndexView";class a extends s.Placeholder{constructor(e){super(e)}}t.Index=a,o=a,a.__name__="Index",o.prototype.default_view=_},
function _(e,o,r,t,n){var s;t();const u=e(480),i=e(73),p=e(32);class g extends u.ActionView{update(e,o,r){for(const[e,r]of(0,p.enumerate)(this.model.groups))e.visible=o==r}}r.ToggleGroupView=g,g.__name__="ToggleGroupView";class _ extends u.Action{constructor(e){super(e)}}r.ToggleGroup=_,s=_,_.__name__="ToggleGroup",s.prototype.default_view=g,s.define((({Array:e,Ref:o})=>({groups:[e(o(i.RendererGroup)),[]]})))},
function _(e,t,n,s,o){var r;s();const i=e(429),a=e(14),l=e(55),c=e(40);class p extends i.DOMNodeView{connect_signals(){super.connect_signals();const{obj:e,attr:t}=this.model;t in e.properties&&this.on_change(e.properties[t],(()=>this.render()))}render(){(0,l.empty)(this.el),this.el.style.display="contents";const e=(()=>{const{obj:e,attr:t}=this.model;if(t in e.properties){const n=e.properties[t].get_value();return(0,c.to_string)(n)}return`<not found: ${e.type}.${t}>`})();this.el.textContent=e}}n.ValueOfView=p,p.__name__="ValueOfView";class _ extends i.DOMNode{constructor(e){super(e)}}n.ValueOf=_,r=_,_.__name__="ValueOf",r.prototype.default_view=p,r.define((({String:e,Ref:t})=>({obj:[t(a.HasProps)],attr:[e]})))},
], 0, {"main":0,"tslib":1,"index":2,"version":3,"embed/index":4,"document/index":5,"document/document":6,"base":7,"core/util/types":8,"core/util/object":9,"core/util/array":10,"core/util/math":11,"core/util/assert":12,"core/util/arrayable":13,"core/has_props":14,"core/signaling":15,"core/util/defer":16,"core/properties":17,"core/logging":18,"core/enums":19,"core/kinds":20,"core/util/color":21,"core/util/svg_colors":22,"core/types":23,"core/util/bitset":24,"core/util/eq":25,"core/util/platform":26,"core/vectorization":27,"core/settings":28,"core/util/ndarray":29,"core/serialization/index":30,"core/serialization/serializer":31,"core/util/iterator":32,"core/serialization/buffer":33,"core/util/buffer":34,"core/serialization/reps":35,"core/diagnostics":36,"core/uniforms":37,"core/util/string":38,"document/events":39,"core/util/pretty":40,"core/util/cloneable":41,"core/patching":42,"core/util/set":43,"core/util/typed_array":44,"core/resolvers":45,"core/bokeh_events":46,"core/serialization/deserializer":47,"core/util/refs":48,"core/util/slice":49,"model":50,"document/defs":51,"embed/standalone":52,"core/view":53,"core/dom_view":54,"core/dom":55,"core/util/bbox":56,"styles/base.css":57,"core/build_views":58,"embed/server":59,"client/connection":60,"protocol/message":61,"protocol/receiver":62,"client/session":63,"embed/dom":64,"embed/notebook":65,"protocol/index":66,"testing":67,"safely":68,"models/main":69,"models/index":70,"models/annotations/index":71,"models/annotations/annotation":72,"models/renderers/renderer":73,"core/visuals/index":74,"core/visuals/line":75,"core/visuals/visual":76,"core/property_mixins":77,"core/visuals/fill":78,"core/visuals/text":79,"core/visuals/hatch":80,"core/visuals/patterns":81,"core/visuals/image":82,"models/coordinates/coordinate_mapping":83,"models/scales/scale":84,"models/transforms/transform":85,"models/ranges/range":86,"models/ranges/range1d":87,"models/scales/linear_scale":88,"models/scales/continuous_scale":89,"models/scales/log_scale":90,"models/scales/categorical_scale":91,"models/ranges/data_range1d":92,"models/ranges/data_range":93,"models/util":94,"models/ranges/factor_range":95,"models/annotations/arrow":96,"models/annotations/data_annotation":97,"models/sources/columnar_data_source":98,"core/selection_manager":99,"models/selections/selection":100,"models/selections/interaction_policy":101,"models/sources/data_source":102,"models/sources/column_data_source":103,"core/util/projections":104,"models/annotations/arrow_head":138,"models/graphics/marking":139,"models/annotations/base_color_bar":140,"models/annotations/title":141,"models/annotations/text_annotation":142,"core/layout/side_panel":143,"core/layout/types":144,"core/layout/layoutable":145,"models/text/base_text":146,"models/text/utils":147,"models/text/math_text":148,"core/util/image":149,"core/graphics":150,"core/util/text":151,"core/util/affine":152,"models/text/providers":153,"core/util/modules":154,"models/text/plain_text":155,"models/canvas/cartesian_frame":156,"models/axes/index":157,"models/axes/axis":158,"models/renderers/guide_renderer":159,"models/tickers/ticker":160,"models/formatters/tick_formatter":161,"models/policies/labeling":162,"models/axes/categorical_axis":163,"models/tickers/categorical_ticker":164,"models/formatters/categorical_tick_formatter":165,"models/axes/continuous_axis":166,"models/axes/datetime_axis":167,"models/formatters/datetime_tick_formatter":168,"core/util/templating":169,"models/tickers/util":173,"models/tickers/datetime_ticker":174,"models/tickers/adaptive_ticker":175,"models/tickers/continuous_ticker":176,"models/tickers/composite_ticker":177,"models/tickers/days_ticker":178,"models/tickers/single_interval_ticker":179,"models/tickers/months_ticker":180,"models/tickers/years_ticker":181,"models/tickers/basic_ticker":182,"models/axes/linear_axis":183,"models/formatters/basic_tick_formatter":184,"models/axes/log_axis":185,"models/formatters/log_tick_formatter":186,"models/tickers/log_ticker":187,"models/axes/mercator_axis":188,"models/formatters/mercator_tick_formatter":189,"models/tickers/mercator_ticker":190,"models/tickers/index":191,"models/tickers/fixed_ticker":192,"models/tickers/binned_ticker":193,"models/mappers/scanning_color_mapper":194,"models/mappers/continuous_color_mapper":195,"models/mappers/color_mapper":196,"models/mappers/mapper":197,"models/renderers/glyph_renderer":198,"models/renderers/data_renderer":199,"models/glyphs/line":200,"models/glyphs/xy_glyph":201,"models/glyphs/glyph":202,"core/util/ragged_array":203,"core/util/spatial":204,"models/graphics/decoration":207,"models/glyphs/utils":208,"core/hittest":209,"models/glyphs/patch":210,"models/glyphs/harea":211,"models/glyphs/area":212,"models/glyphs/varea":213,"models/sources/cds_view":214,"models/filters/filter":215,"models/filters/all_indices":216,"models/filters/intersection_filter":217,"models/formatters/index":218,"models/formatters/customjs_tick_formatter":219,"models/formatters/numeral_tick_formatter":220,"models/formatters/printf_tick_formatter":221,"models/scales/index":222,"models/scales/linear_interpolation_scale":223,"models/ranges/index":224,"core/layout/index":225,"core/layout/alignments":226,"core/layout/grid":227,"core/layout/border":228,"models/annotations/band":229,"models/annotations/upper_lower":230,"models/annotations/box_annotation":231,"models/annotations/color_bar":232,"models/mappers/index":233,"models/mappers/categorical_color_mapper":234,"models/mappers/categorical_mapper":235,"models/mappers/categorical_marker_mapper":236,"models/mappers/categorical_pattern_mapper":237,"models/mappers/linear_color_mapper":238,"models/mappers/log_color_mapper":239,"models/mappers/eqhist_color_mapper":240,"models/annotations/contour_color_bar":241,"models/annotations/label":242,"models/annotations/label_set":243,"models/annotations/legend":244,"models/annotations/legend_item":245,"models/annotations/poly_annotation":246,"models/annotations/slope":247,"models/annotations/span":248,"models/annotations/toolbar_panel":249,"models/tools/toolbar":250,"models/ui/ui_element":251,"models/dom/styles":252,"core/util/canvas":253,"core/util/svg":254,"core/util/random":255,"styles/ui.css":256,"models/tools/tool":257,"models/tools/tool_proxy":258,"models/tools/inspectors/inspect_tool":259,"models/tools/on_off_button":260,"models/tools/tool_button":261,"core/util/menus":263,"styles/menus.css":264,"styles/icons.css":265,"styles/tool_button.css":266,"models/tools/gestures/gesture_tool":267,"models/tools/actions/action_tool":268,"models/tools/actions/help_tool":269,"styles/toolbar.css":270,"styles/logo.css":271,"models/annotations/whisker":272,"models/annotations/html/index":273,"models/annotations/html/label":274,"models/annotations/html/text_annotation":275,"models/annotations/html/label_set":276,"models/annotations/html/title":277,"models/callbacks/index":278,"models/callbacks/customjs":279,"models/callbacks/callback":280,"models/callbacks/open_url":281,"models/callbacks/set_value":282,"models/canvas/index":283,"models/canvas/canvas":284,"core/ui_events":285,"core/util/wheel":286,"styles/canvas.css":287,"models/coordinates/index":288,"models/expressions/index":289,"models/expressions/expression":290,"models/expressions/customjs_expr":291,"models/expressions/stack":292,"models/expressions/cumsum":293,"models/expressions/minimum":294,"models/expressions/maximum":295,"models/expressions/coordinate_transform":296,"models/expressions/polar":297,"models/filters/index":298,"models/filters/boolean_filter":299,"models/filters/customjs_filter":300,"models/filters/group_filter":301,"models/filters/index_filter":302,"models/filters/inversion_filter":303,"models/filters/union_filter":304,"models/filters/difference_filter":305,"models/filters/symmetric_difference_filter":306,"models/glyphs/index":307,"models/glyphs/annular_wedge":308,"models/glyphs/annulus":309,"models/glyphs/arc":310,"models/glyphs/bezier":311,"models/glyphs/block":312,"models/glyphs/lrtb":313,"models/glyphs/circle":314,"models/glyphs/ellipse":315,"models/glyphs/center_rotatable":316,"models/glyphs/hbar":317,"models/glyphs/hex_tile":318,"models/glyphs/image":319,"models/glyphs/image_base":320,"models/glyphs/image_rgba":321,"models/glyphs/image_url":322,"models/glyphs/multi_line":323,"models/glyphs/multi_polygons":324,"models/glyphs/patches":325,"models/glyphs/quad":326,"models/glyphs/quadratic":327,"models/glyphs/ray":328,"models/glyphs/rect":329,"models/glyphs/scatter":330,"models/glyphs/marker":331,"models/glyphs/defs":332,"models/glyphs/segment":333,"models/glyphs/spline":334,"core/util/interpolation":335,"models/glyphs/step":336,"models/glyphs/text":337,"models/glyphs/vbar":338,"models/glyphs/wedge":339,"models/graphics/index":340,"models/graphs/index":341,"models/graphs/graph_hit_test_policy":342,"models/graphs/layout_provider":343,"models/graphs/static_layout_provider":344,"models/grids/index":345,"models/grids/grid":346,"models/layouts/index":347,"models/layouts/column":348,"models/layouts/flex_box":349,"models/layouts/layout_dom":350,"models/menus/menu":351,"models/menus/menu_item":352,"models/layouts/alignments":353,"models/layouts/grid_box":354,"models/layouts/css_grid_box":355,"models/layouts/group_box":356,"styles/group_box.css":357,"models/layouts/hbox":358,"models/layouts/row":359,"models/layouts/scroll_box":360,"models/layouts/spacer":361,"models/layouts/tab_panel":362,"models/layouts/tabs":363,"styles/tabs.css":364,"models/layouts/vbox":365,"models/menus/index":366,"models/menus/action":367,"models/ui/icons/icon":368,"models/menus/check_action":369,"models/menus/section":370,"models/menus/divider":371,"models/text/index":372,"models/transforms/index":373,"models/transforms/customjs_transform":374,"models/transforms/dodge":375,"models/transforms/range_transform":376,"models/transforms/interpolator":377,"models/transforms/jitter":378,"models/transforms/linear_interpolator":379,"models/transforms/step_interpolator":380,"models/plots/index":381,"models/plots/gmap_plot":382,"models/plots/plot":383,"models/plots/plot_canvas":384,"core/util/throttle":385,"models/plots/range_manager":386,"models/plots/state_manager":387,"styles/plots.css":388,"models/plots/gmap_plot_canvas":389,"models/plots/gmap":390,"models/plots/grid_plot":391,"models/plots/figure":392,"models/policies/index":393,"models/renderers/index":394,"models/renderers/contour_renderer":395,"models/renderers/graph_renderer":396,"models/selections/index":397,"models/selectors/index":398,"models/selectors/by_id":399,"models/selectors/selector":400,"models/selectors/by_class":401,"models/selectors/by_css":402,"models/selectors/by_xpath":403,"models/sources/index":404,"models/sources/server_sent_data_source":405,"models/sources/web_data_source":406,"models/sources/ajax_data_source":407,"models/sources/geojson_data_source":408,"models/tiles/index":409,"models/tiles/bbox_tile_source":410,"models/tiles/mercator_tile_source":411,"models/tiles/tile_source":412,"models/tiles/tile_utils":413,"models/tiles/quadkey_tile_source":414,"models/tiles/tile_renderer":415,"models/tiles/wmts_tile_source":416,"styles/attribution.css":417,"models/tiles/tms_tile_source":418,"models/textures/index":419,"models/textures/canvas_texture":420,"models/textures/texture":421,"models/textures/image_url_texture":422,"models/ui/index":423,"models/ui/icons/index":424,"models/ui/icons/builtin_icon":425,"models/ui/icons/svg_icon":426,"models/ui/icons/tabler_icon":427,"models/ui/dialog":428,"models/dom/dom_node":429,"models/dom/text":430,"styles/dialogs.css":431,"models/ui/inspector":432,"styles/inspector.css":433,"models/ui/pane":434,"models/ui/tooltip":435,"models/dom/html":436,"styles/tooltips.css":437,"models/tools/index":438,"models/tools/actions/index":439,"models/tools/actions/copy_tool":440,"models/tools/actions/custom_action":441,"models/tools/actions/fullscreen_tool":442,"models/tools/actions/redo_tool":443,"models/tools/actions/plot_action_tool":444,"models/tools/actions/reset_tool":445,"models/tools/actions/save_tool":446,"models/tools/actions/settings_tool":447,"models/tools/actions/undo_tool":448,"models/tools/actions/zoom_in_tool":449,"models/tools/actions/zoom_base_tool":450,"core/util/zoom":451,"models/tools/actions/zoom_out_tool":452,"models/tools/edit/index":453,"models/tools/edit/edit_tool":454,"models/tools/edit/box_edit_tool":455,"models/tools/edit/freehand_draw_tool":456,"models/tools/edit/line_edit_tool":457,"models/tools/edit/line_tool":458,"models/tools/edit/point_draw_tool":459,"models/tools/edit/poly_draw_tool":460,"models/tools/edit/poly_tool":461,"models/tools/edit/poly_edit_tool":462,"models/tools/gestures/index":463,"models/tools/gestures/box_select_tool":464,"models/tools/gestures/select_tool":465,"models/tools/gestures/box_zoom_tool":466,"models/tools/gestures/lasso_select_tool":467,"models/tools/gestures/poly_select_tool":468,"models/tools/gestures/pan_tool":469,"models/tools/gestures/range_tool":470,"models/tools/gestures/tap_tool":471,"models/tools/gestures/wheel_pan_tool":472,"models/tools/gestures/wheel_zoom_tool":473,"models/tools/inspectors/index":474,"models/tools/inspectors/crosshair_tool":475,"models/tools/inspectors/customjs_hover":476,"models/tools/inspectors/hover_tool":477,"models/dom/template":478,"models/dom/dom_element":479,"models/dom/action":480,"models/dom/placeholder":481,"models/dom/index":482,"models/dom/color_ref":483,"models/dom/value_ref":484,"models/dom/elements":485,"models/dom/index_":486,"models/dom/toggle_group":487,"models/dom/value_of":488}, {});export default main;
