#The Open Autonomy framework

<figure markdown>
![](images/open-autonomy-framework-logo.png)
</figure>


{{open_autonomy}} is a framework for the creation of **agent services**: off-chain
autonomous services which run as a multi-agent-system (MAS) and offer **enhanced functionalities
on-chain**. Agent services expand the range of operations that traditional
smart contracts provide, making it possible to execute arbitrarily complex operations
(such as machine-learning algorithms). Most importantly, agent services are
**decentralized**, **trust-minimized**, **transparent**, and **robust**.


## Building with Open Autonomy

The framework is designed to speed up the development life cycle of autonomous services, helping you to bring your services from an idea to production as quick as possible. Overall, this is the general path that you should have in mind when developing with {{open_autonomy}}:

1. **Idea.** Flesh out the service idea.
2. **Specification.** Define the service specification in a high-level language used by the framework. 
3. **Scaffold.** Use the scaffolding tool to build the skeleton of your service.
4. **Code.** Make the necessary adjustments so that the service implements the desired business logic.
5. **Deploy** and **Run** your service.

You'll find a more comprehensive description of the developing path in the [overview of the development process](guides/overview_of_the_development_process.md) section.





## Browse the docs

Get started with the framework, **learn the main concepts** and get some context on how agent services
fit in the wider crypto ecosystem.

[Get started](./get_started/what_is_the_open_autonomy_framework.md){ .md-button .md-button--primary}

------

Follow the guides to learn how to use the framework to **create and deploy agent services**.

[Guides](./guides/index.md){ .md-button }

------

A tour to **existing agent services** that you can explore and use them as a reference
for your implementations.

[Demos](./demos/index.md){ .md-button }

------

Detailed topics on how the **internal components** of an agent service work with the
framework.


[Key concepts](./key_concepts/index.md){ .md-button }

------

Browse through the CLI and API reference documentation.

[Advanced reference](./advanced_reference/index.md){ .md-button }


------

Browse our FAQ where you can find commonly asked questions about the framework.

[FAQ](./questions-and-answers.md){ .md-button }
