"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroAppsS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cf = require("aws-cdk-lib/aws-cloudfront");
const cforigins = require("aws-cdk-lib/aws-cloudfront-origins");
const s3 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
/**
 * Create the durable MicroApps S3 Buckets
 *
 * These should be created in a stack that will not be deleted if
 * there are breaking changes to MicroApps in the future.
 */
class MicroAppsS3 extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props === undefined) {
            throw new Error('props must be set');
        }
        const { removalPolicy, assetNameRoot, assetNameSuffix } = props;
        // Use Auto-Delete S3Bucket if removal policy is DESTROY
        const s3AutoDeleteItems = removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY;
        //
        // S3 Bucket for Logging - Usable by many stacks
        //
        this._bucketLogs = new s3.Bucket(this, 'logs', {
            bucketName: props.bucketLogsName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        //
        // S3 Buckets for Apps
        //
        this._bucketApps = new s3.Bucket(this, 'apps', {
            bucketName: props.bucketAppsName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        this._bucketAppsStaging = new s3.Bucket(this, 'staging', {
            bucketName: props.bucketAppsStagingName,
            autoDeleteObjects: s3AutoDeleteItems,
            removalPolicy,
        });
        // Create S3 Origin Identity
        this._bucketAppsOAI = new cf.OriginAccessIdentity(this, 'oai', {
            comment: assetNameRoot !== undefined ? `${assetNameRoot}${assetNameSuffix}` : undefined,
        });
        if (removalPolicy !== undefined) {
            this._bucketAppsOAI.applyRemovalPolicy(removalPolicy);
        }
        // Add Origin for CloudFront
        this._bucketAppsOrigin = new cforigins.S3Origin(this._bucketApps, {
            originAccessIdentity: this.bucketAppsOAI,
        });
    }
    get bucketApps() {
        return this._bucketApps;
    }
    get bucketAppsOAI() {
        return this._bucketAppsOAI;
    }
    get bucketAppsOrigin() {
        return this._bucketAppsOrigin;
    }
    get bucketAppsStaging() {
        return this._bucketAppsStaging;
    }
    get bucketLogs() {
        return this._bucketLogs;
    }
}
exports.MicroAppsS3 = MicroAppsS3;
_a = JSII_RTTI_SYMBOL_1;
MicroAppsS3[_a] = { fqn: "@pwrdrvr/microapps-cdk.MicroAppsS3", version: "0.3.0-alpha.1" };
//# sourceMappingURL=data:application/json;base64,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