"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const config = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-config-rule-scoped-integ');
const fn = new lambda.Function(stack, 'CustomFunction', {
    code: lambda.AssetCode.fromInline('exports.handler = (event) => console.log(event);'),
    handler: 'index.handler',
    runtime: lambda.Runtime.NODEJS_10_X,
});
const customRule = new config.CustomRule(stack, 'Custom', {
    lambdaFunction: fn,
    periodic: true,
});
customRule.scopeToResource('AWS::EC2::Instance');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuc2NvcGVkLXJ1bGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5zY29wZWQtcnVsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLDhDQUE4QztBQUM5QyxxQ0FBcUM7QUFDckMsaUNBQWlDO0FBRWpDLE1BQU0sR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBRTFCLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsa0NBQWtDLENBQUMsQ0FBQztBQUVyRSxNQUFNLEVBQUUsR0FBRyxJQUFJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLGdCQUFnQixFQUFFO0lBQ3RELElBQUksRUFBRSxNQUFNLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxrREFBa0QsQ0FBQztJQUNyRixPQUFPLEVBQUUsZUFBZTtJQUN4QixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXO0NBQ3BDLENBQUMsQ0FBQztBQUVILE1BQU0sVUFBVSxHQUFHLElBQUksTUFBTSxDQUFDLFVBQVUsQ0FBQyxLQUFLLEVBQUUsUUFBUSxFQUFFO0lBQ3hELGNBQWMsRUFBRSxFQUFFO0lBQ2xCLFFBQVEsRUFBRSxJQUFJO0NBQ2YsQ0FBQyxDQUFDO0FBRUgsVUFBVSxDQUFDLGVBQWUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0FBRWpELEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIGNvbmZpZyBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soYXBwLCAnYXdzLWNkay1jb25maWctcnVsZS1zY29wZWQtaW50ZWcnKTtcblxuY29uc3QgZm4gPSBuZXcgbGFtYmRhLkZ1bmN0aW9uKHN0YWNrLCAnQ3VzdG9tRnVuY3Rpb24nLCB7XG4gIGNvZGU6IGxhbWJkYS5Bc3NldENvZGUuZnJvbUlubGluZSgnZXhwb3J0cy5oYW5kbGVyID0gKGV2ZW50KSA9PiBjb25zb2xlLmxvZyhldmVudCk7JyksXG4gIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuTk9ERUpTXzEwX1gsXG59KTtcblxuY29uc3QgY3VzdG9tUnVsZSA9IG5ldyBjb25maWcuQ3VzdG9tUnVsZShzdGFjaywgJ0N1c3RvbScsIHtcbiAgbGFtYmRhRnVuY3Rpb246IGZuLFxuICBwZXJpb2RpYzogdHJ1ZSxcbn0pO1xuXG5jdXN0b21SdWxlLnNjb3BlVG9SZXNvdXJjZSgnQVdTOjpFQzI6Okluc3RhbmNlJyk7XG5cbmFwcC5zeW50aCgpO1xuIl19