from setuptools import setup

setup(
    name='biosteamconnectors',
    packages=['biosteamconnectors'],
    version='0.0.2',
    license='UIUC',
    author='Emily Lin',
    author_email='Emilypl2@illinois.edu',
    description='Automates DayCent and FDCIC calculator to find feedstock emissions',
    long_description=open('README.rst', encoding='utf-8').read(),
    url="https://github.com/emilypl2/BioSTEAMconnectors",
    project_urls={
        "Guest Group Lab": "https://engineeringforsustainability.com/",
        "CABBI-DayCent": "https://github.com/cabbi-bio/DayCent-CABBI",
    },
    install_requires=['biosteam>=2.31.21', 'thermosteam>=0.27.18',
                      'pandas>=1.3.2', 'numpy', 'xlwings'],
    package_data=
        {'BioSTEAMconnectors': [
                    '*',
                    'DayCent',
                    'DayCent/*',
                    ]},
    platforms=['Windows', 'Linux'],
    classifiers=['License :: OSI Approved :: University of Illinois/NCSA Open Source License',
                 'Environment :: Console',
                 'Topic :: Education',
                 'Topic :: Scientific/Engineering',
                 'Topic :: Scientific/Engineering :: Chemistry',
                 'Topic :: Scientific/Engineering :: Mathematics',
                 'Intended Audience :: Developers',
                 'Intended Audience :: Education',
                 'Intended Audience :: Manufacturing',
                 'Intended Audience :: Science/Research',
                 'Natural Language :: English',
                 'Operating System :: MacOS',
                 'Operating System :: Microsoft :: Windows',
                 'Operating System :: POSIX',
                 'Operating System :: POSIX :: BSD',
                 'Operating System :: POSIX :: Linux',
                 'Operating System :: Unix',
                 'Programming Language :: Python :: 3.7',
                 'Programming Language :: Python :: 3.8',
                 ],
    keywords=['techno-economic analysis', 'life cycle assessment'],
)