# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/06_quick.ipynb (unless otherwise specified).

__all__ = ['qtuneSimple', 'default_stats']

# Cell
from .algorithms import eaSimpleWithExtraLog
from .utils import ConcurrentMap
from .crossover import cxDictUniform
from .mutation import mutDictRand
from deap import base, creator, tools
from functools import partial
import random
import numpy

default_stats = tools.Statistics(lambda ind: ind.fitness.values)
default_stats.register("avg", numpy.mean, axis=0)
default_stats.register("std", numpy.std, axis=0)
default_stats.register("min", numpy.min, axis=0)
default_stats.register("max", numpy.max, axis=0)

def qtuneSimple(params,
                evaluate,
                n_pop=10,
                cxpb=0.6,
                mutpb=0.6,
                ngen=10,
                hof=2,
                elitism=True,
                stats=default_stats,
                crossover=partial(cxDictUniform, indpb=0.6),
                select=partial(tools.selTournament, tournsize=3),
                mutate=partial(mutDictRand, indpb=0.7),
                n_jobs=1,
                seed=None,
                verbose=__debug__):
    """Quick tune using `eaSimpleWithExtraLog`. Just provide parameter list and function to tune.
    The function given should accept keywords arguments in the parameter list.
    Check examples below for more information."""
    if seed is not None:
        random.seed(seed)

    def initParams(cls):
        return cls({i.name: next(i) for i in cls.params})

    if hof > 0:
        hof = tools.HallOfFame(hof)
    else:
        hof = None

    creator.create("eptLoss", base.Fitness, weights=(-1.0, ))
    creator.create("eptParameters",
                   dict,
                   params=params,
                   fitness=creator.eptLoss)
    toolbox = base.Toolbox()
    toolbox.register("individual", initParams, creator.eptParameters)
    toolbox.register("population", tools.initRepeat, list, toolbox.individual)
    toolbox.register('evaluate', evaluate)
    toolbox.register("select", select)
    toolbox.register("mate", crossover)
    toolbox.register("mutate", mutate, params=params)
    with ConcurrentMap(n_jobs) as pmap:
        toolbox.register('map', pmap)
        population, logbook = eaSimpleWithExtraLog(toolbox.population(n_pop),
                                   toolbox,
                                   cxpb=cxpb,
                                   mutpb=mutpb,
                                   ngen=ngen,
                                   halloffame=hof,
                                   elitism=elitism,
                                   stats=stats,
                                   verbose=verbose)
    del creator.eptLoss
    del creator.eptParameters
    return population, logbook, hof