"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Exchange = exports.ExchangeProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const amqp_generated_1 = require("./amqp.generated");
Object.defineProperty(exports, "ExchangeProperty", { enumerable: true, get: function () { return amqp_generated_1.RosExchange; } });
/**
 * A ROS resource type:  `ALIYUN::AMQP::Exchange`
 */
class Exchange extends ros.Resource {
    /**
     * Create a new `ALIYUN::AMQP::Exchange`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosExchange = new amqp_generated_1.RosExchange(this, id, {
            instanceId: props.instanceId,
            alternateExchange: props.alternateExchange,
            internal: props.internal,
            virtualHost: props.virtualHost,
            autoDeleteState: props.autoDeleteState,
            exchangeName: props.exchangeName,
            exchangeType: props.exchangeType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosExchange;
        this.attrExchangeName = rosExchange.attrExchangeName;
    }
}
exports.Exchange = Exchange;
//# sourceMappingURL=data:application/json;base64,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