"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosVirtualHost = exports.RosQueue = exports.RosInstance = exports.RosExchange = exports.RosBinding = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosBindingProps`
 *
 * @param properties - the TypeScript properties of a `RosBindingProps`
 *
 * @returns the result of the validation.
 */
function RosBindingPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('argument', ros.requiredValidator)(properties.argument));
    errors.collect(ros.propertyValidator('argument', ros.validateString)(properties.argument));
    errors.collect(ros.propertyValidator('sourceExchange', ros.requiredValidator)(properties.sourceExchange));
    errors.collect(ros.propertyValidator('sourceExchange', ros.validateString)(properties.sourceExchange));
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('bindingKey', ros.requiredValidator)(properties.bindingKey));
    errors.collect(ros.propertyValidator('bindingKey', ros.validateString)(properties.bindingKey));
    errors.collect(ros.propertyValidator('bindingType', ros.requiredValidator)(properties.bindingType));
    if (properties.bindingType && (typeof properties.bindingType) !== 'object') {
        errors.collect(ros.propertyValidator('bindingType', ros.validateAllowedValues)({
            data: properties.bindingType,
            allowedValues: ["0", "0", "QUEUE", "1", "1", "EXCHANGE"],
        }));
    }
    errors.collect(ros.propertyValidator('bindingType', ros.validateString)(properties.bindingType));
    errors.collect(ros.propertyValidator('destinationName', ros.requiredValidator)(properties.destinationName));
    errors.collect(ros.propertyValidator('destinationName', ros.validateString)(properties.destinationName));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    return errors.wrap('supplied properties not correct for "RosBindingProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Binding` resource
 *
 * @param properties - the TypeScript properties of a `RosBindingProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Binding` resource.
 */
// @ts-ignore TS6133
function rosBindingPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosBindingPropsValidator(properties).assertSuccess();
    }
    return {
        Argument: ros.stringToRosTemplate(properties.argument),
        BindingKey: ros.stringToRosTemplate(properties.bindingKey),
        BindingType: ros.stringToRosTemplate(properties.bindingType),
        DestinationName: ros.stringToRosTemplate(properties.destinationName),
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        SourceExchange: ros.stringToRosTemplate(properties.sourceExchange),
        VirtualHost: ros.stringToRosTemplate(properties.virtualHost),
    };
}
/**
 * A ROS template type:  `ALIYUN::AMQP::Binding`
 */
class RosBinding extends ros.RosResource {
    /**
     * Create a new `ALIYUN::AMQP::Binding`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosBinding.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.argument = props.argument;
        this.bindingKey = props.bindingKey;
        this.bindingType = props.bindingType;
        this.destinationName = props.destinationName;
        this.instanceId = props.instanceId;
        this.sourceExchange = props.sourceExchange;
        this.virtualHost = props.virtualHost;
    }
    get rosProperties() {
        return {
            argument: this.argument,
            bindingKey: this.bindingKey,
            bindingType: this.bindingType,
            destinationName: this.destinationName,
            instanceId: this.instanceId,
            sourceExchange: this.sourceExchange,
            virtualHost: this.virtualHost,
        };
    }
    renderProperties(props) {
        return rosBindingPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosBinding = RosBinding;
/**
 * The resource type name for this resource class.
 */
RosBinding.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Binding";
/**
 * Determine whether the given properties match those of a `RosExchangeProps`
 *
 * @param properties - the TypeScript properties of a `RosExchangeProps`
 *
 * @returns the result of the validation.
 */
function RosExchangePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('alternateExchange', ros.validateString)(properties.alternateExchange));
    errors.collect(ros.propertyValidator('internal', ros.requiredValidator)(properties.internal));
    errors.collect(ros.propertyValidator('internal', ros.validateBoolean)(properties.internal));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    errors.collect(ros.propertyValidator('autoDeleteState', ros.requiredValidator)(properties.autoDeleteState));
    errors.collect(ros.propertyValidator('autoDeleteState', ros.validateBoolean)(properties.autoDeleteState));
    errors.collect(ros.propertyValidator('exchangeName', ros.requiredValidator)(properties.exchangeName));
    if (properties.exchangeName && (Array.isArray(properties.exchangeName) || (typeof properties.exchangeName) === 'string')) {
        errors.collect(ros.propertyValidator('exchangeName', ros.validateLength)({
            data: properties.exchangeName.length,
            min: undefined,
            max: 255,
        }));
    }
    errors.collect(ros.propertyValidator('exchangeName', ros.validateString)(properties.exchangeName));
    errors.collect(ros.propertyValidator('exchangeType', ros.requiredValidator)(properties.exchangeType));
    if (properties.exchangeType && (typeof properties.exchangeType) !== 'object') {
        errors.collect(ros.propertyValidator('exchangeType', ros.validateAllowedValues)({
            data: properties.exchangeType,
            allowedValues: ["FANOUT", "DIRECT", "TOPIC", "HEADERS"],
        }));
    }
    errors.collect(ros.propertyValidator('exchangeType', ros.validateString)(properties.exchangeType));
    return errors.wrap('supplied properties not correct for "RosExchangeProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Exchange` resource
 *
 * @param properties - the TypeScript properties of a `RosExchangeProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Exchange` resource.
 */
// @ts-ignore TS6133
function rosExchangePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosExchangePropsValidator(properties).assertSuccess();
    }
    return {
        AutoDeleteState: ros.booleanToRosTemplate(properties.autoDeleteState),
        ExchangeName: ros.stringToRosTemplate(properties.exchangeName),
        ExchangeType: ros.stringToRosTemplate(properties.exchangeType),
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        Internal: ros.booleanToRosTemplate(properties.internal),
        VirtualHost: ros.stringToRosTemplate(properties.virtualHost),
        AlternateExchange: ros.stringToRosTemplate(properties.alternateExchange),
    };
}
/**
 * A ROS template type:  `ALIYUN::AMQP::Exchange`
 */
class RosExchange extends ros.RosResource {
    /**
     * Create a new `ALIYUN::AMQP::Exchange`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosExchange.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrExchangeName = this.getAtt('ExchangeName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.autoDeleteState = props.autoDeleteState;
        this.exchangeName = props.exchangeName;
        this.exchangeType = props.exchangeType;
        this.instanceId = props.instanceId;
        this.internal = props.internal;
        this.virtualHost = props.virtualHost;
        this.alternateExchange = props.alternateExchange;
    }
    get rosProperties() {
        return {
            autoDeleteState: this.autoDeleteState,
            exchangeName: this.exchangeName,
            exchangeType: this.exchangeType,
            instanceId: this.instanceId,
            internal: this.internal,
            virtualHost: this.virtualHost,
            alternateExchange: this.alternateExchange,
        };
    }
    renderProperties(props) {
        return rosExchangePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosExchange = RosExchange;
/**
 * The resource type name for this resource class.
 */
RosExchange.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Exchange";
/**
 * Determine whether the given properties match those of a `RosInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('maxTps', ros.requiredValidator)(properties.maxTps));
    if (properties.maxTps && (typeof properties.maxTps) !== 'object') {
        errors.collect(ros.propertyValidator('maxTps', ros.validateAllowedValues)({
            data: properties.maxTps,
            allowedValues: [1000, 1500, 2000, 2500, 3000, 4000, 5000, 8000, 10000, 15000, 20000, 25000, 30000, 40000, 50000, 100000, 200000, 300000, 500000, 800000, 1000000],
        }));
    }
    errors.collect(ros.propertyValidator('maxTps', ros.validateNumber)(properties.maxTps));
    if (properties.maxEipTps && (typeof properties.maxEipTps) !== 'object') {
        errors.collect(ros.propertyValidator('maxEipTps', ros.validateRange)({
            data: properties.maxEipTps,
            min: 128,
            max: undefined,
        }));
    }
    errors.collect(ros.propertyValidator('maxEipTps', ros.validateNumber)(properties.maxEipTps));
    if (properties.supportEip && (typeof properties.supportEip) !== 'object') {
        errors.collect(ros.propertyValidator('supportEip', ros.validateAllowedValues)({
            data: properties.supportEip,
            allowedValues: ["true", "false"],
        }));
    }
    errors.collect(ros.propertyValidator('supportEip', ros.validateString)(properties.supportEip));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 6, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('storageSize', ros.requiredValidator)(properties.storageSize));
    if (properties.storageSize && (typeof properties.storageSize) !== 'object') {
        errors.collect(ros.propertyValidator('storageSize', ros.validateRange)({
            data: properties.storageSize,
            min: 200,
            max: 2800,
        }));
    }
    errors.collect(ros.propertyValidator('storageSize', ros.validateNumber)(properties.storageSize));
    if (properties.payType && (typeof properties.payType) !== 'object') {
        errors.collect(ros.propertyValidator('payType', ros.validateAllowedValues)({
            data: properties.payType,
            allowedValues: ["Subscription", "PrePaid", "PrePay", "Prepaid", "PRE"],
        }));
    }
    errors.collect(ros.propertyValidator('payType', ros.validateString)(properties.payType));
    errors.collect(ros.propertyValidator('queueCapacity', ros.requiredValidator)(properties.queueCapacity));
    if (properties.queueCapacity && (typeof properties.queueCapacity) !== 'object') {
        errors.collect(ros.propertyValidator('queueCapacity', ros.validateRange)({
            data: properties.queueCapacity,
            min: 50,
            max: 80000,
        }));
    }
    errors.collect(ros.propertyValidator('queueCapacity', ros.validateNumber)(properties.queueCapacity));
    if (properties.tracingStorageTime && (typeof properties.tracingStorageTime) !== 'object') {
        errors.collect(ros.propertyValidator('tracingStorageTime', ros.validateAllowedValues)({
            data: properties.tracingStorageTime,
            allowedValues: [3, 7, 15],
        }));
    }
    errors.collect(ros.propertyValidator('tracingStorageTime', ros.validateNumber)(properties.tracingStorageTime));
    errors.collect(ros.propertyValidator('instanceName', ros.validateString)(properties.instanceName));
    if (properties.orderNum && (typeof properties.orderNum) !== 'object') {
        errors.collect(ros.propertyValidator('orderNum', ros.validateRange)({
            data: properties.orderNum,
            min: 1,
            max: 9999,
        }));
    }
    errors.collect(ros.propertyValidator('orderNum', ros.validateNumber)(properties.orderNum));
    if (properties.supportTracing && (typeof properties.supportTracing) !== 'object') {
        errors.collect(ros.propertyValidator('supportTracing', ros.validateAllowedValues)({
            data: properties.supportTracing,
            allowedValues: ["true", "false"],
        }));
    }
    errors.collect(ros.propertyValidator('supportTracing', ros.validateString)(properties.supportTracing));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    if (properties.instanceType && (typeof properties.instanceType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceType', ros.validateAllowedValues)({
            data: properties.instanceType,
            allowedValues: ["professional", "enterprise", "vip"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["month", "year", "Month", "Year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    return errors.wrap('supplied properties not correct for "RosInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Instance` resource
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Instance` resource.
 */
// @ts-ignore TS6133
function rosInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosInstancePropsValidator(properties).assertSuccess();
    }
    return {
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        MaxTps: ros.numberToRosTemplate(properties.maxTps),
        QueueCapacity: ros.numberToRosTemplate(properties.queueCapacity),
        StorageSize: ros.numberToRosTemplate(properties.storageSize),
        InstanceName: ros.stringToRosTemplate(properties.instanceName),
        MaxEipTps: ros.numberToRosTemplate(properties.maxEipTps),
        OrderNum: ros.numberToRosTemplate(properties.orderNum),
        PayType: ros.stringToRosTemplate(properties.payType),
        Period: ros.numberToRosTemplate(properties.period),
        PeriodUnit: ros.stringToRosTemplate(properties.periodUnit),
        SupportEip: ros.stringToRosTemplate(properties.supportEip),
        SupportTracing: ros.stringToRosTemplate(properties.supportTracing),
        TracingStorageTime: ros.numberToRosTemplate(properties.tracingStorageTime),
    };
}
/**
 * A ROS template type:  `ALIYUN::AMQP::Instance`
 */
class RosInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::AMQP::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrInstanceId = this.getAtt('InstanceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceType = props.instanceType;
        this.maxTps = props.maxTps;
        this.queueCapacity = props.queueCapacity;
        this.storageSize = props.storageSize;
        this.instanceName = props.instanceName;
        this.maxEipTps = props.maxEipTps;
        this.orderNum = props.orderNum;
        this.payType = props.payType;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.supportEip = props.supportEip;
        this.supportTracing = props.supportTracing;
        this.tracingStorageTime = props.tracingStorageTime;
    }
    get rosProperties() {
        return {
            instanceType: this.instanceType,
            maxTps: this.maxTps,
            queueCapacity: this.queueCapacity,
            storageSize: this.storageSize,
            instanceName: this.instanceName,
            maxEipTps: this.maxEipTps,
            orderNum: this.orderNum,
            payType: this.payType,
            period: this.period,
            periodUnit: this.periodUnit,
            supportEip: this.supportEip,
            supportTracing: this.supportTracing,
            tracingStorageTime: this.tracingStorageTime,
        };
    }
    renderProperties(props) {
        return rosInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosInstance = RosInstance;
/**
 * The resource type name for this resource class.
 */
RosInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Instance";
/**
 * Determine whether the given properties match those of a `RosQueueProps`
 *
 * @param properties - the TypeScript properties of a `RosQueueProps`
 *
 * @returns the result of the validation.
 */
function RosQueuePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('deadLetterExchange', ros.validateString)(properties.deadLetterExchange));
    errors.collect(ros.propertyValidator('maximumPriority', ros.validateNumber)(properties.maximumPriority));
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('exclusiveState', ros.validateBoolean)(properties.exclusiveState));
    errors.collect(ros.propertyValidator('deadLetterRoutingKey', ros.validateString)(properties.deadLetterRoutingKey));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    errors.collect(ros.propertyValidator('maxLength', ros.validateNumber)(properties.maxLength));
    errors.collect(ros.propertyValidator('autoDeleteState', ros.validateBoolean)(properties.autoDeleteState));
    errors.collect(ros.propertyValidator('queueName', ros.requiredValidator)(properties.queueName));
    if (properties.queueName && (Array.isArray(properties.queueName) || (typeof properties.queueName) === 'string')) {
        errors.collect(ros.propertyValidator('queueName', ros.validateLength)({
            data: properties.queueName.length,
            min: undefined,
            max: 255,
        }));
    }
    errors.collect(ros.propertyValidator('queueName', ros.validateString)(properties.queueName));
    errors.collect(ros.propertyValidator('messageTtl', ros.validateNumber)(properties.messageTtl));
    errors.collect(ros.propertyValidator('autoExpireState', ros.validateNumber)(properties.autoExpireState));
    return errors.wrap('supplied properties not correct for "RosQueueProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Queue` resource
 *
 * @param properties - the TypeScript properties of a `RosQueueProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::Queue` resource.
 */
// @ts-ignore TS6133
function rosQueuePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosQueuePropsValidator(properties).assertSuccess();
    }
    return {
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        QueueName: ros.stringToRosTemplate(properties.queueName),
        VirtualHost: ros.stringToRosTemplate(properties.virtualHost),
        AutoDeleteState: ros.booleanToRosTemplate(properties.autoDeleteState),
        AutoExpireState: ros.numberToRosTemplate(properties.autoExpireState),
        DeadLetterExchange: ros.stringToRosTemplate(properties.deadLetterExchange),
        DeadLetterRoutingKey: ros.stringToRosTemplate(properties.deadLetterRoutingKey),
        ExclusiveState: ros.booleanToRosTemplate(properties.exclusiveState),
        MaximumPriority: ros.numberToRosTemplate(properties.maximumPriority),
        MaxLength: ros.numberToRosTemplate(properties.maxLength),
        MessageTTL: ros.numberToRosTemplate(properties.messageTtl),
    };
}
/**
 * A ROS template type:  `ALIYUN::AMQP::Queue`
 */
class RosQueue extends ros.RosResource {
    /**
     * Create a new `ALIYUN::AMQP::Queue`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosQueue.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrQueueName = this.getAtt('QueueName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceId = props.instanceId;
        this.queueName = props.queueName;
        this.virtualHost = props.virtualHost;
        this.autoDeleteState = props.autoDeleteState;
        this.autoExpireState = props.autoExpireState;
        this.deadLetterExchange = props.deadLetterExchange;
        this.deadLetterRoutingKey = props.deadLetterRoutingKey;
        this.exclusiveState = props.exclusiveState;
        this.maximumPriority = props.maximumPriority;
        this.maxLength = props.maxLength;
        this.messageTtl = props.messageTtl;
    }
    get rosProperties() {
        return {
            instanceId: this.instanceId,
            queueName: this.queueName,
            virtualHost: this.virtualHost,
            autoDeleteState: this.autoDeleteState,
            autoExpireState: this.autoExpireState,
            deadLetterExchange: this.deadLetterExchange,
            deadLetterRoutingKey: this.deadLetterRoutingKey,
            exclusiveState: this.exclusiveState,
            maximumPriority: this.maximumPriority,
            maxLength: this.maxLength,
            messageTtl: this.messageTtl,
        };
    }
    renderProperties(props) {
        return rosQueuePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosQueue = RosQueue;
/**
 * The resource type name for this resource class.
 */
RosQueue.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::Queue";
/**
 * Determine whether the given properties match those of a `RosVirtualHostProps`
 *
 * @param properties - the TypeScript properties of a `RosVirtualHostProps`
 *
 * @returns the result of the validation.
 */
function RosVirtualHostPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('virtualHost', ros.requiredValidator)(properties.virtualHost));
    if (properties.virtualHost && (Array.isArray(properties.virtualHost) || (typeof properties.virtualHost) === 'string')) {
        errors.collect(ros.propertyValidator('virtualHost', ros.validateLength)({
            data: properties.virtualHost.length,
            min: undefined,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('virtualHost', ros.validateString)(properties.virtualHost));
    return errors.wrap('supplied properties not correct for "RosVirtualHostProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::AMQP::VirtualHost` resource
 *
 * @param properties - the TypeScript properties of a `RosVirtualHostProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::AMQP::VirtualHost` resource.
 */
// @ts-ignore TS6133
function rosVirtualHostPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosVirtualHostPropsValidator(properties).assertSuccess();
    }
    return {
        InstanceId: ros.stringToRosTemplate(properties.instanceId),
        VirtualHost: ros.stringToRosTemplate(properties.virtualHost),
    };
}
/**
 * A ROS template type:  `ALIYUN::AMQP::VirtualHost`
 */
class RosVirtualHost extends ros.RosResource {
    /**
     * Create a new `ALIYUN::AMQP::VirtualHost`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosVirtualHost.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrVirtualHost = this.getAtt('VirtualHost');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.instanceId = props.instanceId;
        this.virtualHost = props.virtualHost;
    }
    get rosProperties() {
        return {
            instanceId: this.instanceId,
            virtualHost: this.virtualHost,
        };
    }
    renderProperties(props) {
        return rosVirtualHostPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosVirtualHost = RosVirtualHost;
/**
 * The resource type name for this resource class.
 */
RosVirtualHost.ROS_RESOURCE_TYPE_NAME = "ALIYUN::AMQP::VirtualHost";
//# sourceMappingURL=data:application/json;base64,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